(*<*)
theory DAss_rulesT2 = DAssT2:
(*>*)

subsection {*Rules*}

subsubsection {* Logical rules*}
lemma DAss_monotone_in_U:
"\<lbrakk>DAss U n C T m E h hh v p; U \<subseteq> UU\<rbrakk> \<Longrightarrow> DAss UU n C T m E h hh v p"
(*<*)
apply (simp add: DAss_def,clarsimp)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U, C, n1) \<in> ContextSize \<and> (E, h, UU-U, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)",clarsimp)
prefer 2 apply (erule ContextSize_SPLIT,fast,fast) 
apply (erule_tac x=q in allE, erule_tac x=n1 in allE, erule_tac x=F in allE)
apply (erule impE, safe)
apply (rule_tac x=N in exI,simp)
apply (rule, erule regionsExist_antimonotone, assumption)
apply (rule, erule regionsDistinct_antimonotone, assumption)
apply (erule distinctFrom_antimonotone, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified_monotone,assumption) 
apply (erule Bounded_monotone, simp, simp,simp)
apply (erule Bounded_monotone, simp, simp,simp)
done
(*>*)

lemma DA_Weak: "\<lbrakk>G \<rhd> e : \<lbrace> U , n , C \<ggreater> T , m\<rbrace>; U \<subseteq> UU\<rbrakk> \<Longrightarrow> G \<rhd> e : DAss UU n C T m"
(*<*)
by (erule vdm_conseq, clarsimp, erule DAss_monotone_in_U,fast) 
(*>*)

lemma DAss_Contexts_same_on_U:
"\<lbrakk>DAss U n C T m E h hh v p; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> DAss U n D T m E h hh v p"
(*<*)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (erule regionsExist2, assumption)
apply (erule regionsDistinct2, assumption)
apply (erule distinctFrom2, assumption)
apply (erule ContextSize2,fast)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified2, assumption)
apply (erule Bounded2, fastsimp)+
done
(*>*)

lemma DA_Contexts_same_on_U:
"\<lbrakk>G \<rhd> e: DAss U n C T m; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> G \<rhd> e: DAss U n D T m"
(*<*)
by (erule vdm_conseq, clarsimp, erule DAss_Contexts_same_on_U, assumption)
(*>*)

lemma DAss_Generalise:
 "\<lbrakk>DAss U n C T m E h hh v p;  n \<le> nn; mm \<le> m; U \<subseteq> UU\<rbrakk>  \<Longrightarrow> DAss UU nn C T mm E h hh v p"
(*<*)
apply (simp add: DAss_def, clarsimp)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U, C, n1) \<in> ContextSize \<and> (E, h, UU-U, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)",clarsimp)
prefer 2 apply (erule ContextSize_SPLIT,fast,fast) 
apply (erule_tac x=q in allE, erule_tac x=n1 in allE, erule_tac x=F in allE)
apply (erule impE, safe)
apply (rule_tac x=N in exI,simp)
apply (rule, erule regionsExist_antimonotone, assumption)
apply (rule, erule regionsDistinct_antimonotone, assumption)
apply (erule distinctFrom_antimonotone, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified_monotone,assumption) 
apply (erule Bounded_monotone, simp, simp,simp)
apply (erule Bounded_monotone, simp, simp,simp)
apply simp
done
(*>*)

lemma DA_Generalise: 
"\<lbrakk>G \<rhd> e:DAss U n C T m; n \<le> nn; mm \<le> m; U \<subseteq> UU\<rbrakk>
 \<Longrightarrow> G \<rhd> e:  DAss UU nn C T mm"
(*<*)
by (erule vdm_conseq, clarsimp, erule DAss_Generalise, assumption+)
(*>*)

lemma DAss_Const: "\<lbrakk>DAss U n G T nn E h hh v p; m = n + k; mm = nn + k\<rbrakk> \<Longrightarrow> DAss U m G T mm E h hh v p"
(*<*)
apply (simp add: DAss_def, clarsimp)
apply (erule_tac x="q+k" in allE, erule_tac x=CS in allE, erule_tac x=F in allE, clarsimp)
apply (erule impE,safe) apply(rule_tac x=N in exI, simp)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
done
(*>*)

lemma DA_Const: "\<lbrakk>G \<rhd> e: DAss U n C T nn; m = n + k; mm = nn + k\<rbrakk> \<Longrightarrow> G \<rhd> e: DAss U m C T mm"
(*<*)
by (erule vdm_conseq, insert DAss_Const, fast)
(*>*)

lemma DAss_PConst0: "DAss n U G A nn E h hh v p = DAss n U G A nn E h hh v pp"
(*<*)by (simp add: DAss_def)(*>*)

lemma DAss_PConst: "DAss n U G A nn E h hh v p \<Longrightarrow> DAss n U G A nn E h hh v pp"
(*<*)by (simp add: DAss_def)(*>*)

subsubsection {*Rules for primitive operations*}

lemma DA_NullNoRes: "\<lbrakk>T \<notin> {UnitET, IntET}; \<forall> kN TT kS. T \<noteq> ResultET kN TT kS\<rbrakk> \<Longrightarrow> GG \<rhd> Null: DAss {} n G T n"
(*<*)
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: DAss_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe)
apply (case_tac T, simp_all)
apply (rule regList) apply(rule mLIST_NIL, simp)
apply (rule regTree) apply(rule mTREE_LEAF, simp)
apply (rule regResultNONE, simp) apply (erule_tac x=nat2 in allE, fast)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
done
(*>*)

lemma DA_NullRes: "\<lbrakk>T = ResultET kN TT kS;n=m+kN\<rbrakk> \<Longrightarrow> GG \<rhd> Null: DAss {} n G T m"
(*<*)
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: DAss_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=kN in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe)
apply (rule regResultNONE, simp, simp)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done
(*>*)
lemma DA_Null: "\<lbrakk>T \<notin> {UnitET, IntET}; n = k+m; (\<forall> kN TT kS. T \<noteq> ResultET kN TT kS) \<longrightarrow> k = 0;
                 \<forall> kN TT kS. T = ResultET kN TT kS \<longrightarrow> k=kN\<rbrakk> \<Longrightarrow> GG \<rhd> Null: DAss {} n G T m"
(*<*)
apply (case_tac "\<exists> kN TT kS . T = ResultET kN TT kS", clarsimp)
apply (rule DA_NullRes, simp) prefer 2 apply simp apply fastsimp
apply (erule impE, fast)
apply (simp,rule DA_NullNoRes, fast, assumption)
done
(*>*)

lemma DA_Int: "\<lbrakk>T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> expr.Int i: DAss {} n G T n"
(*<*)
apply (rule vdm_conseq, rule vdm_int)
apply (simp add: DAss_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule regInt)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done
(*>*)

lemma DA_IVar: "\<lbrakk>T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> IVar x: DAss {} n G T n"
(*<*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (simp add: DAss_def, clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule regInt)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done
(*>*)

lemma DA_RVar: "\<lbrakk>GETr G x = Some T\<rbrakk> \<Longrightarrow> GG \<rhd> RVar x: DAss {x} n G T n"
(*<*)
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: DAss_def, safe)
apply (subgoal_tac "\<exists> R S . (RVal (E\<lfloor>x\<rfloor>),h,Some T,R,S):reg", safe) prefer 2 apply (erule regionsExist_Lookup, simp, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule modified_Sameheap)
apply (erule distinctFrom_Lookup)
  apply(subgoal_tac "(RVal (renv E x), h, GETr G x, R, S) \<in> reg", assumption, clarsimp, simp,assumption, assumption)
apply (erule Bounded_lookup) apply (subgoal_tac "x:{x}", assumption, simp) 
  apply (subgoal_tac "(RVal (renv E x), h, GETr G x, R, S) \<in> reg",assumption,clarsimp)
apply (rule Bounded_SameF) 
apply (subgoal_tac "S \<le> CS", clarsimp)
apply (erule ContextSize_contains_region)
apply (subgoal_tac "x:{x}", assumption, simp)
apply (simp add: GETr_def)
done
(*>*)

lemma DA_Prim: "\<lbrakk>T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> Primop f x y: DAss {} n G T n"
(*<*)
apply (rule vdm_conseq, rule vdm_prim, simp add: DAss_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done
(*>*)

lemma DA_Rprim:
"\<lbrakk>x: DOM G; y:DOM G; T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> RPrimop f x y: DAss {x,y} n G T n"
(*<*)
apply (rule vdm_conseq, rule vdm_rprim, simp add: DAss_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done
(*>*)

subsubsection {* Rules for let-primop combinations *}
lemma DA_Let_Int:
  "\<lbrakk>G \<rhd> e : DAss U n C T m\<rbrakk> \<Longrightarrow> G \<rhd> (LET z = expr.Int i IN e END): DAss U n C T m"
(*<*)
apply (rule vdm_conseq, rule vdm_leti, rule vdm_int)
apply assumption
apply (clarsimp)
apply (rule DAss_PConst)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (erule regionsExist1,fast, simp,simp,rule, simp) 
apply (erule regionsDistinct1, fast, simp, simp, rule, simp)
apply (erule distinctFrom1,fast, simp, simp, rule, simp)
apply (erule ContextSizePreserved, simp)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified1, fast, simp, rule, simp)
apply (erule Bounded1,  fast, rule, simp)
apply (erule Bounded1, fast, rule, simp)
done
(*>*)

lemma DA_Let_Prim:
  "\<lbrakk>G \<rhd> e : DAss U n C T m\<rbrakk> \<Longrightarrow> G \<rhd> (LET z = Primop f x y IN e END): DAss U n C T m"
(*<*)
apply (rule vdm_conseq, rule vdm_leti, rule vdm_prim)
apply assumption
apply (clarsimp)
apply (rule DAss_PConst)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (erule regionsExist1,fast, simp,simp,rule, simp) 
apply (erule regionsDistinct1, fast, simp, simp, rule, simp)
apply (erule distinctFrom1,fast, simp, simp, rule, simp)
apply (erule ContextSizePreserved, simp)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified1, fast, simp, rule, simp)
apply (erule Bounded1,  fast, rule, simp)
apply (erule Bounded1, fast, rule, simp)
done
(*>*)

lemma DA_Let_RPrim:
  "\<lbrakk>G \<rhd> e : DAss U n C T m; x : DOM C; y : DOM C
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END): DAss ({x,y} \<union> U) n C T m"
(*<*)
apply (rule vdm_conseq, rule vdm_leti, rule vdm_rprim)
apply assumption
apply (clarsimp)
apply (rule DAss_PConst)
apply (simp add: DAss_def, safe)
apply (subgoal_tac "\<exists> n1 n2 . (E, h, U, C, n1) \<in> ContextSize \<and> (E, h, (insert x (insert y U)) - U, C, n2) \<in> ContextSize \<and> n1 + n2 = CS", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, fast, fast)
apply (erule_tac x=q in allE, erule_tac x=n1 in allE,erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule regionsExist1) apply (erule regionsExist_antimonotone,fast) apply(fast, simp,rule, simp) 
apply (rule regionsDistinct1) apply(erule regionsDistinct_antimonotone) apply(fast, simp, simp,rule, simp)
apply (rule distinctFrom1) apply(erule distinctFrom_antimonotone) apply(fast, fast, simp, rule, simp)
apply (erule ContextSizePreserved) apply simp
apply simp
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (rule modified1) apply(erule modified_monotone) apply(fast, fast, simp, rule, simp)
apply (rule Bounded1) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
apply (rule Bounded1) apply (rotate_tac -3) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
done
lemma DA_Let_rprim:
  "\<lbrakk>G \<rhd> e : DAss U n C T m; x : DOM C; y : DOM C; UU = ({x,y} \<union> U)
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END): DAss UU n C T m"
by (rule vdm_conseq, erule DA_Let_RPrim,auto)
(*>*)

subsubsection {*General let-rules*}
(*<*)
lemma reg_h_h1_letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; x:DOM C; x:U2;
 (RVal E\<lfloor>x\<rfloor>, h, GETr C x, R, S) \<in> reg\<rbrakk>
 \<Longrightarrow> (RVal E\<lfloor>x\<rfloor>, h1, GETr C x, R, S) \<in> reg"
apply (rule reg_Preserved, assumption)
apply (simp add: modified_def, erule_tac x=l in allE, erule impE, safe)
apply (simp add: distinctFrom_def)
apply (erule_tac x=x in allE,clarsimp,fast) 
apply (erule reg_region_in_heap1, assumption)
apply (subgoal_tac "x \<noteq> z")
apply (simp add: regionsDistinct_def,fast)
apply fast
done

lemma reg_h1_h_letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; x:DOM C; x:U2;
  (RVal E\<lfloor>x\<rfloor>, h1, GETr C x, R, S) \<in> reg\<rbrakk>
 \<Longrightarrow> (RVal E\<lfloor>x\<rfloor>, h, GETr C x, R, S) \<in> reg"
apply (subgoal_tac "\<exists> RR SS . (RVal E\<lfloor>x\<rfloor>, h, GETr C x, RR, SS) \<in> reg", clarsimp)
apply (subgoal_tac "(RVal (renv E x), h1, GETr C x, RR, SS) \<in> reg")
apply (subgoal_tac "R=RR \<and> S=SS", clarsimp)
apply (erule reg_Unique, assumption)
apply (erule reg_h_h1_letv, assumption+)
apply (simp add: regionsExist_def)
done

lemma regEx_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E; 
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; \<forall> x . x:U2 \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> regionsExist U2 C h1 EE"
apply (simp (no_asm) add: regionsExist_def, clarsimp)
apply (erule impE,fast)
apply (subgoal_tac "\<exists>Rx Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg", clarsimp)
apply (rule_tac x=Rx in exI, rule_tac x=Sx in exI)
apply (erule reg_h_h1_letv, assumption+)
apply (simp add: regionsExist_def)
done

lemma regsDist_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; \<forall> x . x:U2 \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> regionsDistinct U2 C h1 EE"
apply (simp (no_asm) add: regionsDistinct_def, clarsimp)
apply (erule impE,fast)
apply (subgoal_tac "(RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg")
apply (subgoal_tac "(RVal (renv E xx), h, GETr C xx, Rxx, Sxx) \<in> reg")
apply (simp add: regionsDistinct_def,fast)
apply (erule reg_h1_h_letv, assumption+, simp)
apply (erule reg_h1_h_letv, assumption+, simp)
done

lemma distFr_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1;
  Bounded FF F U1 C h E; \<forall> x . x:U2 \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> distinctFrom U2 C h1 EE FF"
apply (simp (no_asm)add: distinctFrom_def, clarsimp)
apply (erule impE,fast)
apply (simp add: Bounded_def)
apply (subgoal_tac "Rx \<inter> (F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)})={}")
apply fast
apply (subgoal_tac "(RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg")
apply (subgoal_tac "Rx \<inter> F \<subseteq> {}")
apply (subgoal_tac "Rx \<inter> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)} \<subseteq>  {}",fast)
apply (rule, clarsimp)
apply (subgoal_tac "x \<noteq> z", simp add: regionsDistinct_def) apply fast
apply fast
apply (simp add: distinctFrom_def,fast)
apply (erule reg_h1_h_letv, assumption+)
done

lemma mod_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E; 
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1;
  Bounded FF F U1 C h E; modified FF U2 C h1 EE hh; \<forall> x . x:(U1 \<union> U2) \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> modified F (U1 \<union> U2) C h E hh"
apply (simp add: modified_def, clarsimp)
apply (subgoal_tac "modified F U1 C h E h1")
prefer 2 apply (simp add: modified_def)
apply (erule_tac x=l in allE, erule impE,clarsimp) apply fast
apply (erule SameOHTransitive)
apply (erule_tac x=l in allE, erule impE) apply rule
apply (simp add: Bounded_def)
apply (subgoal_tac "l \<notin> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}",fast)
apply clarsimp
apply fast
apply rule apply (simp add: modified_def) apply (erule_tac x=l in allE, erule impE,fast) apply (simp add: sameOH_def)
  apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
apply clarsimp
apply (subgoal_tac "(RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg",fast)
apply (erule reg_h1_h_letv, assumption+)
apply fast
done

lemma Bnd_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E; 
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; Bounded FF F U1 C h E;
  Bounded Ra FF U2 C h1 EE; \<forall> x . x:(U1 \<union> U2) \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> Bounded Ra F (U1 \<union> U2) C h E"
apply (simp add: Bounded_def)
apply (rule, rule)
apply (rotate_tac -3, erule_tac x=l in allE, erule impE,simp, erule disjE)
apply (erule_tac x=l in allE, erule impE, assumption)
apply (erule disjE, simp)
apply (rule disjI2, clarsimp)
apply fast
apply (rule disjI2, clarsimp)
apply (subgoal_tac "(RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg",fast)
apply (erule reg_h1_h_letv, assumption+)
done
(*>*)

lemma DA_Letv:
      "\<lbrakk>G \<rhd> e : DAss U1 n C T1 m;
        G \<rhd> ee : DAss U2 m C T2 k; T1 = UnitET;
        U1 \<inter> U2 = {}\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): DAss (U1 \<union> U2) n C T2 k"
(*<*)
apply (rule vdm_conseq,erule vdm_letv, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAss_def, safe)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U1, C, n1) \<in> ContextSize \<and> (E, h, U2, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, simp, assumption)
apply (erule_tac x="n2+q" in allE, erule_tac x=n1 in allE, erule_tac x=F in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, clarsimp)
  apply(rotate_tac 1, erule thin_rl,safe)
  apply (erule regionsExist_antimonotone,fast)
  apply (erule regionsDistinct_antimonotone,fast)
  apply (erule distinctFrom_antimonotone,fast)
  
  apply (erule_tac x=q in allE, erule_tac x=n2 in allE,erule_tac x=FF in allE, erule impE, clarsimp)
  apply (rule_tac x=M in exI, safe)
  apply (erule regEx_Letv, assumption+,simp)
  apply (erule regsDist_Letv, assumption+, simp)
  apply (erule distFr_Letv, assumption+, simp)

  apply (rule SizePreserved_h_h1)
  apply (erule ContextSizePreserved,fastsimp) apply (simp add: modified_def)
  apply (erule_tac x=l in allE, erule impE)
  (*1*) apply rule apply (simp add: distinctFrom_def) apply (subgoal_tac "x:DOM C",fast) apply (erule reg_DOM)
  (*2*) apply (rule, subgoal_tac "l:Dom h", simp add: dom_def) apply(erule reg_region_in_heap1, assumption) 
      apply (simp add: regionsDistinct_def,clarsimp) 
      apply (subgoal_tac "z \<noteq> x")
      apply (subgoal_tac "x:DOM C",fast) apply (erule reg_DOM)
      apply fast
  apply simp
  apply (erule reg.elims, clarsimp+)

  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (erule mod_Letv,assumption+,simp) 
  apply (erule Bnd_Letv, assumption+,simp)
  apply (erule Bnd_Letv, assumption+,simp) 
done
lemma DA_letv:
      "\<lbrakk>G \<rhd> e : DAss U1 n C T1 m;
        G \<rhd> ee : DAss U2 m C T2 k; T1 = UnitET;
        U1 \<inter> U2 = {}; UU=(U1 \<union> U2)\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): DAss UU n C T2 k"
by (rule vdm_conseq, rule DA_Letv, auto)
(*>*)

lemma DA_Leti:
      "\<lbrakk>G \<rhd> e : DAss U1 n C T1 m;
        G \<rhd> ee : DAss U2 m C T2 k;
        U1 \<inter> U2 = {}; T1 = IntET\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET x = e IN ee END): DAss (U1 \<union> U2) n C T2 k"
(*<*)
apply (rule vdm_conseq,erule vdm_leti, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAss_def, safe)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U1, C, n1) \<in> ContextSize \<and> (E, h, U2, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, simp, assumption)
apply (erule_tac x="n2+q" in allE, erule_tac x=n1 in allE, erule_tac x=F in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, clarsimp)
  apply(rotate_tac 1, erule thin_rl,safe)
  apply (erule regionsExist_antimonotone,fast)
  apply (erule regionsDistinct_antimonotone,fast)
  apply (erule distinctFrom_antimonotone,fast)
  
  apply (erule_tac x=q in allE, erule_tac x=n2 in allE,erule_tac x=FF in allE, erule impE, clarsimp)
  apply (rule_tac x=M in exI, safe)
  apply (erule regEx_Letv, assumption+,clarsimp,rule, simp)
  apply (erule regsDist_Letv, assumption+,clarsimp,rule, simp)
  apply (erule distFr_Letv, assumption+,clarsimp,rule, simp)

  apply (rule SizePreserved_h_h1)
  apply (erule ContextSizePreserved,fastsimp) apply (simp add: modified_def)
  apply (erule_tac x=l in allE, erule impE)
  (*1*) apply rule apply (simp add: distinctFrom_def) apply (subgoal_tac "x:DOM C",fast) apply (erule reg_DOM)
  (*2*) apply (rule, subgoal_tac "l:Dom h", simp add: dom_def) apply(erule reg_region_in_heap1, assumption) 
      apply (simp add: regionsDistinct_def,clarsimp) 
      apply (subgoal_tac "z \<noteq> x")
      apply (subgoal_tac "x:DOM C",fast) apply (erule reg_DOM)
      apply fast
  apply simp
  apply (erule reg.elims, clarsimp+)

  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (erule mod_Letv,assumption+,safe, (rule, simp)+) 
  apply (erule Bnd_Letv, assumption+,safe, (rule, simp)+)
  apply (erule Bnd_Letv, assumption+,safe, (rule, simp)+) 
done
lemma DA_leti:
      "\<lbrakk>G \<rhd> e : DAss U1 n C T1 m;
        G \<rhd> ee : DAss U2 m C T2 k;
        U1 \<inter> U2 = {}; T1 = IntET; UU=(U1 \<union> U2)\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET x = e IN ee END): DAss UU n C T2 k"
by (rule vdm_conseq, rule DA_Leti, auto)
(*>*)

(*<*)
lemma regEx_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {}; regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
          distinctFrom (U1 \<union> (U2 - {x})) C h E F; modified F U1 C h E h1; (RVal r, h1, Some T1, R, S) \<in> reg\<rbrakk>
 \<Longrightarrow> regionsExist U2 (C(x\<mapsto>\<^sub>fT1)) h1 E\<lfloor>x:=r\<rfloor>"
apply (simp (no_asm) add: regionsExist_def, clarsimp)
apply (case_tac "xa=x",simp add: GETr_def,fast)
apply (subgoal_tac "xa : DOM C")
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa", clarsimp)
apply (subgoal_tac "\<exists>Rx Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg", clarsimp)
apply (rule_tac x=Rx in exI, rule_tac x=Sx in exI)
apply (erule reg_h_h1_letv, assumption+)
apply fast
apply assumption
apply (simp add: regionsExist_def) 
apply (rule GETr_Update1, fast)
apply (insert DOM_Update,fast)
done

lemma regsDist_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {}; regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
  distinctFrom (U1 \<union> (U2 - {x})) C h E F; (RVal r, h1, Some T1, R, S) \<in> reg; modified F U1 C h E h1;
  R \<inter> FF = {}; Bounded R F U1 C h E\<rbrakk>
 \<Longrightarrow> regionsDistinct U2 (C(x\<mapsto>\<^sub>fT1)) h1 E\<lfloor>x:=r\<rfloor>"
apply (simp add: regionsDistinct_def, clarsimp)
apply (subgoal_tac " regionsDistinct (U1 \<union> (U2 - {x})) C h E")
prefer 2 apply (simp add: regionsDistinct_def)
apply (case_tac "xa = x", clarsimp)
(*xa=x*)
  apply (case_tac "xx=x")
  (*xx=x*) apply clarsimp
  (*xx\<noteq>x*) apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xx = GETr C xx", clarsimp)
    apply (subgoal_tac "xx:DOM C")
    apply (subgoal_tac "R=Rx \<and> S=Sx", clarsimp)
    apply (simp add: Bounded_def, rule, rule)
    apply (subgoal_tac "(RVal (renv E xx), h, GETr C xx, Rxx, Sxx) \<in> reg")
    prefer 2 apply(erule reg_h1_h_letv, assumption+, fast, assumption+)
    apply (erule_tac x=xa in allE, erule impE,clarsimp)
    apply (erule disjE)
    (*1*) apply (rotate_tac 2, erule thin_rl, simp add: distinctFrom_def)
          apply (erule_tac x=xx in allE, erule impE, clarsimp) apply fast
    (*2*) apply clarsimp apply (subgoal_tac "xx \<noteq> xaa")
          apply (erule_tac x=xaa in allE, erule_tac x=xx in allE)
          apply (erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp) apply fast 
          apply fast apply (rotate_tac 2, erule thin_rl, fast)
    apply simp 
    apply (erule reg_Unique) apply (simp add: GETr_def)
    apply (erule reg_DOM)
    apply (rule GETr_Update1, fast)
(* xa \<noteq> x*)
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa", clarsimp)
  apply (subgoal_tac "xa:DOM C")
  apply (case_tac "xx=x")
    (* xx=x*)
    apply clarsimp
    apply (subgoal_tac "R=Rxx \<and> S=Sxx", clarsimp)
    apply (simp add: Bounded_def, rule, rule)
    apply (subgoal_tac "(RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg")
    prefer 2 apply(erule reg_h1_h_letv, assumption+, fast, assumption+)
    apply (erule_tac x=xaa in allE, erule impE,clarsimp)
    apply (erule disjE)
    (*1*) apply (rotate_tac 2, erule thin_rl, simp add: distinctFrom_def)
          apply (erule_tac x=xa in allE, erule impE, clarsimp) apply fast
    (*2*) apply clarsimp apply (subgoal_tac "xa \<noteq> xb")
          apply (erule_tac x=xa in allE, erule_tac x=xb in allE)
          apply (erule_tac x=Rx in allE, erule_tac x=Rxa in allE, erule impE, clarsimp) apply fast 
          apply fast apply (rotate_tac 2, erule thin_rl, fast)
    apply simp 
    apply (erule reg_Unique) apply (simp add: GETr_def)
    (* xx \<noteq> x*)
    apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xx = GETr C xx", clarsimp)
    apply (subgoal_tac "xx:DOM C")
    apply (erule_tac x=xa in allE, erule_tac x=xx in allE)
    apply (erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
    apply (rule, rule) apply (erule  reg_h1_h_letv, assumption+, fast, assumption)
    apply (rule) apply (erule  reg_h1_h_letv, assumption+, fast, assumption)
    apply simp
    apply (erule reg_DOM)
    apply (rule GETr_Update1, fast)
  apply (erule reg_DOM)
  apply (rule GETr_Update1, fast)
done

lemma distFrom_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {};regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
          distinctFrom (U1 \<union> (U2 - {x})) C h E F; (RVal r, h1, Some (T1), R, S) \<in> reg; modified F U1 C h E h1;
          R \<inter> FF = {}; Bounded R F U1 C h E; Bounded FF F U1 C h E\<rbrakk>
       \<Longrightarrow> distinctFrom U2 (C(x\<mapsto>\<^sub>fT1)) h1 E\<lfloor>x:=r\<rfloor> FF"
apply (simp add: distinctFrom_def, clarsimp)
apply (subgoal_tac "distinctFrom (U1 \<union> (U2 - {x})) C h E F")
prefer 2 apply (simp add: distinctFrom_def)
apply (case_tac "xa=x", clarsimp)
(*xa=x*)
    apply (subgoal_tac "R=Rx \<and> S=Sx", clarsimp)
    apply (erule reg_Unique) apply (simp add: GETr_def)
(*xa\<noteq>x*)
    apply (subgoal_tac "(RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg")
    prefer 2 apply(erule reg_h1_h_letv, assumption+)
             apply (erule DOM_Update1,fast)
             apply fast
             apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa", clarsimp)
             apply (rule GETr_Update1, fast)
    apply (subgoal_tac "\<forall>l. l \<in> FF \<longrightarrow> l \<in> F \<or> (\<exists>x. x \<in> U1 \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx))")
    prefer 2 apply (simp add: Bounded_def)
    apply (subgoal_tac "Rx \<inter> (F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}) = {}", fast)
    apply (subgoal_tac "Rx \<inter> F = {} \<and>
                        Rx \<inter> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)} = {}",fast)
    apply rule
    (*1*) apply (erule_tac x=xa in allE, erule impE,clarsimp)
          apply (erule DOM_Update1, fast) apply fast
    (*2*) apply (rule,rule, clarsimp)
          apply (subgoal_tac "xa\<noteq>z")
          apply (simp add: regionsDistinct_def) 
          apply (erule_tac x=xa in allE, erule_tac x=z in allE, erule_tac x=Rx in allE, erule_tac x=Rz in allE, erule impE,clarsimp)
          apply (rule, erule DOM_Update1, fast) apply (rule,fast,fast)
          apply fast
          apply fast
   apply simp
done

lemma mod_Letr:
"\<lbrakk>U1 \<inter> (U2-{x}) = {}; regionsExist (U1 \<union> (U2-{x})) C h E; regionsDistinct (U1 \<union> (U2-{x})) C h E; 
  modified F U1 C h E h1; distinctFrom (U1 \<union> (U2-{x})) C h E F; Bounded FF F U1 C h E;
  modified FF U2 (C(x\<mapsto>\<^sub>fT1)) h1 E\<lfloor>x:=r\<rfloor> hh; 
  (RVal r, h1, Some (T1), R, S) \<in> reg; Bounded R F U1 C h E\<rbrakk>
 \<Longrightarrow> modified F (U1 \<union> (U2-{x})) C h E hh"
apply (simp add: modified_def, clarsimp)
apply (subgoal_tac "modified F U1 C h E h1")
prefer 2 apply (simp add: modified_def)
apply (subgoal_tac "modified FF U2 (C(x\<mapsto>\<^sub>fT1)) h1 E\<lfloor>x:=r\<rfloor> hh")
prefer 2 apply (simp add: modified_def)
apply (erule_tac x=l in allE, erule impE,clarsimp) apply (rotate_tac -6, erule_tac x=z in allE) apply fast
apply (erule SameOHTransitive)
apply (erule_tac x=l in allE, erule impE) apply rule
apply (subgoal_tac "\<forall>l. l \<in> FF \<longrightarrow> l \<in> F \<or> (\<exists>x. x \<in> U1 \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx))")
prefer 2 apply (simp add: Bounded_def)
apply (rotate_tac 5, erule thin_rl)
apply (subgoal_tac "l \<notin> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", fast)
apply clarsimp
apply fast
apply (rule, simp add: modified_def) apply (erule_tac x=l in allE, erule impE, fastsimp) apply (simp add: sameOH_def) apply (simp add: fmap_dom_def fmap_lookup_def dom_def) 
  apply clarsimp
apply (case_tac "z = x", clarsimp)
(*z=x*) apply (subgoal_tac "R=Rz \<and> S=Sz", clarsimp)
  apply (simp add: Bounded_def)
  apply (erule_tac x=l in allE, clarsimp)
  apply fast
  apply (erule reg_Unique) apply (simp add: GETr_def)
(* z \<noteq> x*) apply (subgoal_tac "z : DOM C")
  apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
  apply (subgoal_tac "(RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg",fast)
  apply (erule reg_h1_h_letv, assumption+)
  apply fast
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) z = GETr C z", clarsimp)
  apply (rule GETr_Update1, fast)
  apply fast
  apply (erule DOM_Update1, fast)
apply assumption
apply fast
done

lemma Bnd_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {};  regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
          distinctFrom (U1 \<union> (U2 - {x})) C h E F; (RVal r, h1, Some (T1), R, S) \<in> reg; modified F U1 C h E h1;
          R \<inter> FF = {}; Bounded R F U1 C h E; Bounded FF F U1 C h E; 
           modified FF U2 (C(x\<mapsto>\<^sub>fT1)) h1 E\<lfloor>x:=r\<rfloor> hh;
          Bounded Ra FF U2 (C(x\<mapsto>\<^sub>fT1)) h1 E\<lfloor>x:=r\<rfloor>\<rbrakk>
       \<Longrightarrow> Bounded Ra F (U1 \<union> (U2 - {x})) C h E"
apply (simp add: Bounded_def)
apply (rule, rule)
apply (rotate_tac -2, erule_tac x=l in allE, erule impE,simp, erule disjE)
apply (subgoal_tac "l : F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply (subgoal_tac "l : F \<or> l: {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply (erule disjE, simp)
apply (subgoal_tac "\<exists>xa. (xa \<in> U1 \<or> xa \<in> U2 \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (rotate_tac 8, erule thin_rl)
apply fast
apply (erule exE, (erule conjE)+)+ apply (erule exE)
apply (case_tac "xa=x")
(*xa=x*)
  apply (subgoal_tac "R=Rx \<and> S=Sx")
  apply (erule_tac x=l in allE, erule impE, clarsimp)
  apply (erule disjE, simp)
  apply (subgoal_tac "\<exists>xa. (xa \<in> U1 \<or> xa \<in> U2 \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
  apply clarsimp apply fast
  apply (erule reg_Unique) apply (simp add: GETr_def)
(*xa\<noteq>x*)
apply (subgoal_tac "\<exists>xa. (xa \<in> U1 \<or> xa \<in> U2 \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (subgoal_tac "xa : DOM C")
apply (rotate_tac 8, erule thin_rl)
apply (subgoal_tac "(RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg",fast)
apply (erule reg_h1_h_letv, assumption+)
apply fast
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa", clarsimp)
apply (rule GETr_Update1, fast)
apply (erule DOM_Update1, fast)
done
(*>*)

lemma DA_Letr:
     "\<lbrakk> G \<rhd> e : DAss U1 n C T1 m;
        G \<rhd> ee : DAss U2 m (C(x\<mapsto>\<^sub>fT1)) T2 k;
        U1 \<inter> (U2-{x}) = {}; T1 \<notin> {IntET, UnitET}\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = e IN ee END): DAss (U1 \<union> (U2-{x})) n C T2 k"
(*<*)apply (rule vdm_conseq,erule vdm_letr, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAss_def, safe)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U1, C, n1) \<in> ContextSize \<and> (E, h, U2 - {x}, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, simp, assumption)
apply (erule_tac x="n2+q" in allE, erule_tac x=n1 in allE, erule_tac x=F in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, clarsimp)
  apply(rotate_tac 1, erule thin_rl,safe)
  apply (erule regionsExist_antimonotone,fast)
  apply (erule regionsDistinct_antimonotone,fast)
  apply (erule distinctFrom_antimonotone,fast)

  apply (case_tac "x:U2")
  (*x:U2*) apply (erule_tac x=q in allE, erule_tac x="n2+S" in allE,erule_tac x=FF in allE, erule impE, clarsimp)
    apply (rule_tac x=M in exI, safe)
      apply (erule regEx_Letr, assumption+)
      apply (erule regsDist_Letr, assumption+)
      apply (erule distFrom_Letr, assumption+)
      apply (erule ContextSizeCONS, simp add: GETr_def) apply (rule SizePreserved_h_h1)
          apply(erule ContextSizePreservedU) apply simp 
          apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ", simp) apply (rule GETr_Update1,fast)
          apply (simp add: modified_def) apply (subgoal_tac "modified F U1 C h E h1") prefer 2 apply (simp add: modified_def)
            apply (erule_tac x=l in allE, erule impE)
            apply (rule, simp add: distinctFrom_def) apply (erule_tac x=xa in allE, erule impE)
              apply (rule, rule disjI2, simp) apply (rule DOM_Update1) apply (erule reg_DOM,fast) 
              apply (erule_tac x=Ra in allE, erule impE) 
              apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ", fastsimp) apply (rule GETr_Update1,fast)
            apply fast
          apply (rule, rule reg_region_in_heap1) apply (erule reg_h_h1_letv, assumption+)
            apply (subgoal_tac "xa:DOM C", assumption) apply (subgoal_tac "xa:DOM (C(x\<mapsto>\<^sub>fT1))", erule DOM_Update1,fast) apply (erule reg_DOM)
            apply fast 
            apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ", simp) apply (rule GETr_Update1,fast)
            apply assumption
            apply clarsimp apply (simp add: regionsDistinct_def) 
              apply (erule_tac x=xa in allE, erule_tac x=z in allE, erule_tac x=Ra in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
               apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ",clarsimp)
               apply (rule, erule reg_DOM) 
               apply (rule,fast)
               apply fastsimp
               apply (rule GETr_Update1,fast)
            apply fast apply simp 
        apply simp apply simp
  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (rule mod_Letr, auto)
  apply (erule Bnd_Letr, assumption+)
  apply (erule Bnd_Letr, assumption+)

  (*x\<notin>U2*) apply (erule_tac x="S+q" in allE, erule_tac x=n2 in allE,erule_tac x=FF in allE, erule impE, clarsimp)
    apply (rule_tac x=M in exI, safe)
      apply (rule regEx_Letr) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp, assumption,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)+
      apply (rule regsDist_Letr) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp, assumption,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)+
      apply (rule distFrom_Letr) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp, assumption,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)+
      apply (rule SizePreserved_h_h1)
          apply(erule ContextSizePreservedU) apply (subgoal_tac "xa \<noteq> x", fastsimp,fast )
          apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ", simp) apply (rule GETr_Update1,fast)
          apply (subgoal_tac "xa \<noteq> x") prefer 2 apply fast
          apply (simp add: modified_def) apply (subgoal_tac "modified F U1 C h E h1") prefer 2 apply (simp add: modified_def)
            apply (erule_tac x=l in allE, erule impE)
            apply (rule, simp add: distinctFrom_def) apply (erule_tac x=xa in allE, erule impE)
              apply (rule, rule disjI2, simp) apply (rule DOM_Update1) apply (erule reg_DOM,fast) 
              apply (erule_tac x=Ra in allE, erule impE) 
              apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ", fastsimp) apply (rule GETr_Update1,fast)
            apply fast
          apply (rule, rule reg_region_in_heap1) apply (erule reg_h_h1_letv, assumption+)
            apply (subgoal_tac "xa:DOM C", assumption) apply (subgoal_tac "xa:DOM (C(x\<mapsto>\<^sub>fT1))", erule DOM_Update1,fast) apply (erule reg_DOM)
            apply assumption
            apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ", simp) apply (rule GETr_Update1,fast)
            apply assumption
            apply clarsimp apply (simp add: regionsDistinct_def) 
              apply (erule_tac x=xa in allE, erule_tac x=z in allE, erule_tac x=Ra in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
               apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ",clarsimp)
               apply (rule, erule reg_DOM) 
               apply (rule,fast)
               apply fastsimp
               apply (rule GETr_Update1,fast)
            apply fast apply simp 
        apply simp
  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (subgoal_tac "modified F (U1 \<union> (U2-{x})) C h E hh",fastsimp)
  apply (rule mod_Letr,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast) apply assumption
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast) prefer 2 apply assumption+
  apply (subgoal_tac "Bounded Ra F (U1 \<union> (U2-{x})) C h E",fastsimp) 
    apply(rule Bnd_Letr,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast) prefer 2 apply assumption+
  apply (subgoal_tac "Bounded FFa F (U1 \<union> (U2-{x})) C h E",fastsimp) 
    apply(rule Bnd_Letr,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast) prefer 2 apply assumption+
apply simp
done

lemma DA_letr:
     "\<lbrakk> G \<rhd> e : DAss U1 n C T1 m;
        G \<rhd> ee : DAss U2 m (C(x\<mapsto>\<^sub>fT1)) T2 k;
        U1 \<inter> (U2-{x}) = {}; T1 \<notin> {IntET, UnitET} ;UU=(U1 \<union> (U2-{x}))\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = e IN ee END): DAss UU n C T2 k"
by (rule vdm_conseq, rule DA_Letr, auto)
(*>*)

lemma DA_If: 
     "\<lbrakk> G \<rhd> e1 : DAss U1 n C T m; 
        G \<rhd> e2 : DAss U2 n C T m\<rbrakk>
     \<Longrightarrow> G \<rhd> (IF b THEN e1 ELSE e2): DAss (U1 \<union> U2) n C T m"
(*<*)
apply (rule vdm_conseq, erule vdm_if, assumption, erule thin_rl, erule thin_rl, clarsimp)
apply (rule DAss_PConst, erule disjE)
apply clarsimp 
apply (erule DAss_monotone_in_U,fast)
apply clarsimp 
apply (erule DAss_monotone_in_U,fast)
done
lemma DA_if: 
     "\<lbrakk> G \<rhd> e1 : DAss U1 n C T m; 
        G \<rhd> e2 : DAss U2 n C T m;UU=(U1 \<union> U2)\<rbrakk>
     \<Longrightarrow> G \<rhd> (IF b THEN e1 ELSE e2): DAss UU n C T m"
by (rule vdm_conseq, rule DA_If, auto)
(*>*)

subsubsection {*Rules for function calls and method invocations*}
lemma DA_Call0:
"\<lbrakk>(G \<union> {(CALL f, \<lambda> E h hh v p . \<exists> pp. tkcall pp = p \<and> DAss U n C T m E h hh v pp)}) \<rhd> (funtable f) : DAss U n C T m\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : DAss U n C T m"
(*<*)
apply (rule vdm_conseq)
apply (erule Call1)
apply clarsimp
apply (erule DAss_PConst) 
done
(*>*)

lemma DA_Call:
"\<lbrakk>(G \<union> {(CALL f, DAss U n C T m)}) \<rhd> (funtable f) : DAss U n C T m\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : DAss U n C T m"
(*<*)
apply (rule vdm_conseq)
apply (rule vdm_call)
apply (rule vdm_conseq)
apply (subgoal_tac "(G \<union> {(CALL f, DAss U n C T m)}) = ({(CALL f, \<lambda>u ua ub uc ud. DAss U n C T m u ua ub uc ud)} \<union> G)",clarsimp)
apply assumption
apply simp
apply clarsimp apply (erule DAss_PConst)
apply clarsimp 
done
(*>*)

lemma DA_Call2:
"\<lbrakk>G \<rhd> (funtable f) : DAss U n C T m\<rbrakk> \<Longrightarrow> G \<rhd> (CALL f) : DAss U n C T m"
(*<*)
by (rule DA_Call, erule CtxtWeak)
(*>*)

lemma Cut2Call:"\<lbrakk>(D \<union> {(Call f, Q)}) \<rhd> e : P; finite D; contextProvable (D \<union> {(Call f,Q)}) D\<rbrakk> \<Longrightarrow> D \<rhd> e : P"
(*<*)
apply (rule cut2) prefer 2 apply assumption apply fast+
done
(*>*)

text {*The final call rule combines the general axiom rule with context
       restriction to the function parameters.*}
consts restr :: "Context \<Rightarrow> rname list \<Rightarrow> Context"
primrec 
"restr C [] = emptyfinmap"
"restr C (h#t) = (case GETr C h of None \<Rightarrow> restr C t | Some T \<Rightarrow> (restr C t)(h\<mapsto>\<^sub>fT))"

consts params :: "funame \<Rightarrow> rname list"

lemma DA_CutCall:
  "\<lbrakk>(CALL f, DAss U n (restr C (params f)) T m) : G; 
    \<forall> x. x:U \<longrightarrow> GETr C x = GETr (restr C (params f)) x\<rbrakk>
 \<Longrightarrow> G \<rhd> (CALL f): DAss U n C T m"
(*<*)
by(rule DA_Contexts_same_on_U,erule vdm_ax, simp)
(*>*)

lemma DA_Invs:
"\<lbrakk>({(c\<bullet>mn(args),DAss U n C T m)} \<union> G) \<rhd> (snd (methtable c mn)) :  
    (\<lambda> E h hh v p  . \<forall> E'. E = newframe_env ((fst (methtable c mn)) @ [RNpar self]) (args @ [VALarg (RVal Nullref)]) (E')  \<longrightarrow> 
                     (DAss U n C T m E' h hh v (\<langle>3 0 1 1\<rangle> \<oplus> p) )) \<rbrakk> \<Longrightarrow>
   G \<rhd> (c\<bullet>mn(args)) : DAss U n C T m" 
(*<*)
by (rule vdm_conseq, erule vdm_invokestatic, clarsimp)
(*>*)

subsubsection {*Rules for freelist management*}
lemma DA_Free: "\<lbrakk>GETr C x = Some T; m=n+1; T \<notin> {IntET, UnitET}\<rbrakk> \<Longrightarrow> G \<rhd> (DIAM\<bullet>Free ([RNarg x])) :  DAss {x} n C UnitET m"
(*<*)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Free)
apply (rule vdm_conseq) 
apply (rule vdm_letr, rule vdm_getstat)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_putstat)
apply (subgoal_tac "x: DOM C")
prefer 2 apply (erule GETrSome_DOM)
apply (simp add: DAss_def, clarsimp)
apply (subgoal_tac "E'\<lfloor>x\<rfloor> = Ref a")
prefer 2 apply (simp add: newframe_env_def evalARGS_def self_def)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI)
apply (rule_tac x="Suc N" in exI, rule_tac x="F \<union> {a}" in exI, safe)
apply (subgoal_tac "a \<notin> F")
prefer 2 apply (simp add: distinctFrom_def) apply (simp add: regionsExist_def, clarsimp)
  apply (erule_tac x=Rx in allE, erule impE, fast)
  apply (subgoal_tac "a:Rx", fast) apply (erule Ref_reg, assumption)
apply (simp add: freelist_def)
  apply (subgoal_tac "(Suc N, Ref a, F \<union> {a}, h
           \<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
              sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>)
          \<in> FL", simp)
  apply (rule FL_SUC)
  apply simp apply (rule Class_is_DIAM, assumption+) 
  apply simp apply (erule FL_UpdateOutside, assumption)  
  apply (rule regUnit)
apply (simp add: modified_def, clarsimp)
  apply (simp add: sameOH_def)
  apply (simp add: regionsExist_def, clarsimp)
  apply (erule_tac x=Rx in allE, erule impE, fast)
  apply (subgoal_tac "a: Rx", fast) apply (erule Ref_reg, assumption)
apply (simp add: Bounded_def)
apply (simp add: Bounded_def)
  apply (rule disjI2)
  apply (simp add: regionsExist_def, clarsimp)
  apply (rule_tac x=Rx in exI, rule, fast)
  apply (erule Ref_reg, assumption)
apply simp
done
lemma DA_free: "\<lbrakk>GETr C x = Some T; U={x}; m=n+1; T \<notin> {IntET, UnitET}\<rbrakk> \<Longrightarrow> G \<rhd> (DIAM\<bullet>Free ([RNarg x])) :  DAss U n C UnitET m"
by (rule vdm_conseq,rule DA_Free, auto)
(*>*)

lemma DA_Free1:
"G \<rhd>  (DIAM\<bullet>Free([RNarg t])) : 
   (\<lambda> E h hh v p . \<exists> a . E\<lfloor>t\<rfloor> = Ref a \<and>
                          hh = h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                                 sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr> \<and> 
                          v = arbitrary \<and> p = (mkRescomp 12 0 1 (Suc 0)))"
(*<*)
apply (rule vdm_invokestatic)
apply (simp, rule CtxtWeakSingleton)
apply (simp add: Meth_Free) 
apply (rule vdm_conseq) 
apply (rule vdm_letr) apply (rule vdm_getstat)
apply (rule vdm_letv) apply (rule vdm_putfr)
apply (rule vdm_putstat)
apply clarsimp
apply (simp add: self_def newframe_env_def evalARGS_def)
done
(*>*)

lemma DA_Alloc:
"G \<rhd>  (DIAM\<bullet>Alloc([])) : 
    (\<lambda> E h hh v p . (h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Nullref \<longrightarrow>
                      hh = \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM), iheap = iheap h, rheap = rheap h, sheap = sheap h\<rparr> \<and> 
                      v = RVal (Ref (freshloc (Dom h)))) \<and> 
                    (h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<noteq> Nullref \<longrightarrow> 
                      (\<exists> h1 r. (\<exists>a. h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Ref a \<and> h1 = h \<and> r = h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>) \<and>
                                hh = h1\<lparr>sheap := (sheap h1)(DIAM := (sheap h1 DIAM)(DOLLAR_F := r))\<rparr> \<and>
                                v = RVal h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)))"
(*<*)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Alloc)
apply (rule CtxtWeakSingleton)
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply (rule vdm_getstat)
apply (rule vdm_leti)
apply (rule vdm_rprim)
apply (rule vdm_if)
apply (rule vdm_new)
apply (rule Call1, simp add: Fun_AllocQ)
apply (rule CtxtWeakSingleton)
apply (rule vdm_letr)
apply (rule vdm_getfr)
apply (rule vdm_letv)
apply (rule vdm_putstat)
apply (rule vdm_rvar)
apply clarsimp 
apply (simp only: newObj_def newframe_env_def evalARGS_def) apply (simp add:self_def) apply clarsimp
done
(*>*)

lemma DA_Fill_DIID:
"G \<rhd>  (DIAM\<bullet>Fill_DIID([RNarg x_, INarg tag_, INarg v0_, RNarg r1_])) : 
       (\<lambda> E h hh v p . \<forall> a . (E\<lfloor>x_\<rfloor> = Ref a \<longrightarrow>  hh=(h\<lparr>iheap := (iheap h)
                      (DOLLAR := (iheap h DOLLAR)
                         (a := ienv (newframe_env [RNpar x_, INpar tag_, INpar v0_, RNpar r1_, RNpar self]
                                      [RNarg x_, INarg tag_, INarg v0_, RNarg r1_, VALarg (RVal Nullref)] E)
                                tag_)),
                      iheap := (iheap h)
                        (DOLLAR := (iheap h DOLLAR)
                           (a := ienv (newframe_env [RNpar x_, INpar tag_, INpar v0_, RNpar r1_, RNpar self]
                                        [RNarg x_, INarg tag_, INarg v0_, RNarg r1_, VALarg (RVal Nullref)] E)
                                  tag_),
                         V0 := (iheap h V0)
                           (a := ienv (newframe_env [RNpar x_, INpar tag_, INpar v0_, RNpar r1_, RNpar self]
                                        [RNarg x_, INarg tag_, INarg v0_, RNarg r1_, VALarg (RVal Nullref)] E)
                                  v0_)),
                      rheap := (rheap h)
                        (R1 := (rheap h R1)
                           (a := renv (newframe_env [RNpar x_, INpar tag_, INpar v0_, RNpar r1_, RNpar self]
                                        [RNarg x_, INarg tag_, INarg v0_, RNarg r1_, VALarg (RVal Nullref)] E)
                                  r1_))\<rparr>) \<and>  v = (RVal (Ref a))))"
(*<*)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Fill_DIID)
apply (rule CtxtWeakSingleton)
apply (rule vdm_conseq)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_rvar,clarsimp)
apply (simp only: newObj_def newframe_env_def evalARGS_def) apply (simp add:self_def) 
done
(*>*)

lemma DA_Fill_DIIDD:
"G \<rhd>  (DIAM\<bullet>Fill_DIIDD([RNarg x_, INarg tag_, INarg v0_, RNarg r1_, RNarg r2_])) : 
       (\<lambda> E h hh v p . \<forall> a . (E\<lfloor>x_\<rfloor> = Ref a \<longrightarrow>  hh=(h\<lparr>iheap := (iheap h)
                      (DOLLAR := (iheap h DOLLAR)
                         (a := ienv (newframe_env [RNpar x_, INpar tag_, INpar v0_, RNpar r1_, RNpar r2_, RNpar self]
                                      [RNarg x_, INarg tag_, INarg v0_, RNarg r1_, RNarg r2_, VALarg (RVal Nullref)] E)
                                tag_)),
                      iheap := (iheap h)
                        (DOLLAR := (iheap h DOLLAR)
                           (a := ienv (newframe_env [RNpar x_, INpar tag_, INpar v0_, RNpar r1_, RNpar r2_, RNpar self]
                                        [RNarg x_, INarg tag_, INarg v0_, RNarg r1_, RNarg r2_, VALarg (RVal Nullref)] E)
                                  tag_),
                         V0 := (iheap h V0)
                           (a := ienv (newframe_env [RNpar x_, INpar tag_, INpar v0_, RNpar r1_, RNpar r2_, RNpar self]
                                        [RNarg x_, INarg tag_, INarg v0_, RNarg r1_, RNarg r2_, VALarg (RVal Nullref)] E)
                                  v0_)),
                      rheap := ((rheap h)
                        (R1 := (rheap h R1)
                           (a := renv (newframe_env [RNpar x_, INpar tag_, INpar v0_, RNpar r1_, RNpar r2_, RNpar self]
                                        [RNarg x_, INarg tag_, INarg v0_, RNarg r1_, RNarg r2_, VALarg (RVal Nullref)] E)
                                  r1_)))
                        (R2 := (rheap h R2)
                           (a := renv (newframe_env [RNpar x_, INpar tag_, INpar v0_, RNpar r1_, RNpar r2_, RNpar self]
                                        [RNarg x_, INarg tag_, INarg v0_, RNarg r1_, RNarg r2_, VALarg (RVal Nullref)] E)
                                  r2_))\<rparr>) \<and>  v = (RVal (Ref a))))"
(*<*)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Fill_DIIDD)
apply (rule CtxtWeakSingleton)
apply (rule vdm_conseq)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_rvar,clarsimp)
apply (simp only: newObj_def newframe_env_def evalARGS_def) apply (simp add:self_def) 
done
(*>*)
(*<*)
end
(*>*)
