(*<*)
theory DAss_TreerulesT2 = DAss_rulesT2:
(*>*)
subsubsection {*Rules for the tree datatype*}

(*<*)
lemma regionsExistsTreeMatch1:
"\<lbrakk>left \<noteq> right; t \<noteq> left; GETr C t = Some (TreeET k);
  renv E t = Ref a;regionsExist (insert t (U - {left, right})) C h E\<rbrakk>
 \<Longrightarrow> regionsExist U (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) h E<cont:=h<a\<bullet>V0>>\<lfloor>left:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>\<lfloor>right:=h\<lfloor>a\<diamondsuit>R2\<rfloor>\<rfloor>"
apply (simp add: regionsExist_def, clarsimp)
  apply (case_tac "x=right", clarsimp)
    apply (erule_tac x=t in allE, erule impE, clarsimp)
    apply (erule GETrSome_DOM)
    apply (clarsimp, erule reg.elims, clarsimp+)
    apply (simp add: GETr_def, erule mTREE.elims, clarsimp, clarsimp) apply (rule, rule, erule regTree, simp)
    apply clarsimp+
  apply (case_tac "x=left", clarsimp)
    apply (erule_tac x=t in allE, erule impE, clarsimp)
    apply (erule GETrSome_DOM)
    apply (clarsimp, erule reg.elims, clarsimp+)
    apply (erule mTREE.elims, clarsimp, clarsimp) 
    apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", simp add: GETr_def)
    apply (rule, rule, erule regTree, simp)
    apply (rule GETr_Update1, fast)
    apply clarsimp+
  apply (erule_tac x=x in allE, erule impE, clarsimp) apply (simp add: DOM_def)
    apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
    apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp, fast)
    apply (rule GETr_Update1, fast)apply (rule GETr_Update1, fast)
done

lemma regionsDistinctTreeMatch1:
"\<lbrakk>left \<noteq> right; t \<notin> U - {left,right}; t \<noteq> left; GETr C t = Some (TreeET k); renv E t = Ref a;
  regionsExist (insert t (U - {left, right})) C h E;
  regionsDistinct (insert t (U - {left, right})) C h E\<rbrakk>
 \<Longrightarrow> regionsDistinct U (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) h E<cont:=h<a\<bullet>V0>>\<lfloor>left:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>\<lfloor>right:=h\<lfloor>a\<diamondsuit>R2\<rfloor>\<rfloor>"
apply (simp add: regionsDistinct_def, safe)
(*t \<notin> U*)
  apply (case_tac "x=right", clarsimp)
    apply (case_tac "xx=right", clarsimp)
    apply (case_tac "xx=left", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=t in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule reg.elims, clarsimp+)
      apply (erule mTREE.elims, clarsimp, clarsimp)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", clarsimp, simp add: GETr_def)
      apply (erule reg.elims, clarsimp+)
      apply (erule reg.elims, clarsimp+)
      apply (subgoal_tac "(X1=Ra \<and> n1=na) \<and> (X2=R \<and> n2=n)", clarsimp,fast)
      apply (rule, erule mTREE_Unique, assumption, erule mTREE_Unique, assumption)
      apply clarsimp+
      apply (rule GETr_Update1, fast)
      apply clarsimp+
    (*xx\<notin>{right,left}*)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp)
      apply (subgoal_tac "\<exists> R S . (RVal (renv E t), h, GETr C t, R, S) \<in> reg", clarsimp)
      prefer 2 apply (simp add: regionsExist_def, erule_tac x=t in allE, erule impE, clarsimp) apply (erule GETrSome_DOM)
               apply (simp add: GETr_def)
      apply (erule_tac x=t in allE, erule_tac x=xx in allE, erule_tac x=R in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
      apply (rule, erule GETrSome_DOM)
      apply (rule, simp add:DOM_def)
      apply (rule, fast)
      apply fastsimp
      apply (subgoal_tac "Rx \<subseteq> R-{a}", fast) apply (erule mTREE_Rightregion) apply (simp add: GETr_def)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx", clarsimp)
      apply (rule GETr_Update1, fast)
      apply (rule GETr_Update1, fast)
  apply (case_tac "x=left", clarsimp)  
    apply (case_tac "xx=left", clarsimp)
    apply (case_tac "xx=right", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=t in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule reg.elims, clarsimp+)
      apply (erule mTREE.elims, clarsimp, clarsimp)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", clarsimp, simp add: GETr_def)
      apply (erule reg.elims, clarsimp+)
      apply (erule reg.elims, clarsimp+)
      apply (subgoal_tac "(X1=R \<and> n1=n) \<and> (X2=Ra \<and> n2=na)", clarsimp,fast)
      apply (rule, erule mTREE_Unique, assumption, erule mTREE_Unique, assumption)
      apply clarsimp+
      apply (rule GETr_Update1, fast)
      apply clarsimp+
    (*xx\<notin>{right,left}*)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp)
      apply (subgoal_tac "\<exists> R S . (RVal (renv E t), h, GETr C t, R, S) \<in> reg", clarsimp)
      prefer 2 apply (simp add: regionsExist_def, erule_tac x=t in allE, erule impE, clarsimp) apply (erule GETrSome_DOM)
               apply (simp add: GETr_def)
      apply (erule_tac x=t in allE, erule_tac x=xx in allE, erule_tac x=R in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
      apply (rule, erule GETrSome_DOM)
      apply (rule, simp add:DOM_def)
      apply (rule, fast)
      apply fastsimp
      apply (subgoal_tac "Rx \<subseteq> R-{a}", fast) apply (erule mTREE_Leftregion) apply (simp add: GETr_def)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", simp add: GETr_def)
      apply (rule GETr_Update1, fast)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx", clarsimp)
      apply (rule GETr_Update1, fast)
      apply (rule GETr_Update1, fast)
  (*x \<notin> {right,left}*)
    apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x")
    prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
      apply (rule GETr_Update1, fast)
      apply (rule GETr_Update1, fast)
    apply (case_tac "xx=right", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=t in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule_tac x=x in allE, erule_tac x=t in allE, erule_tac x=Rx in allE, erule_tac x=Rxa in allE, erule impE, clarsimp)
      apply (rule, simp add:DOM_def)
      apply (rule, erule GETrSome_DOM)
      apply (rule, fast)
      apply fastsimp
      apply (subgoal_tac "Rxx \<subseteq> Rxa-{a}", fast) apply (erule mTREE_Rightregion) apply (simp add: GETr_def)
    apply (case_tac "xx=left", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=t in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule_tac x=x in allE, erule_tac x=t in allE, erule_tac x=Rx in allE, erule_tac x=Rxa in allE, erule impE, clarsimp)
      apply (rule, simp add:DOM_def)
      apply (rule, erule GETrSome_DOM)
      apply (rule, fast)
      apply fastsimp
      apply (subgoal_tac "Rxx \<subseteq> Rxa-{a}", fast) apply (erule mTREE_Leftregion) 
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", simp add: GETr_def)
      apply (rule GETr_Update1, fast)
    (*xx\<notin>{right,left}*)
      apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
      apply (rule, simp add:DOM_def)
      apply (rule, simp add:DOM_def)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp,fast)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx", clarsimp)
      apply (rule GETr_Update1, fast)
      apply (rule GETr_Update1, fast)
      apply fast
(*t \<in> U*)
  apply (case_tac "x=right", clarsimp)
    apply (case_tac "xx=right", clarsimp)
    apply (case_tac "xx=left", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=right in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule reg.elims, clarsimp+)
      apply (erule mTREE.elims, clarsimp, clarsimp)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", clarsimp, simp add: GETr_def)
      apply (erule reg.elims, clarsimp+)
      apply (erule reg.elims, clarsimp+)
      apply (subgoal_tac "(X2=R \<and> n2=n) \<and> (X1=Ra \<and> n1=na)", clarsimp,fast)
      apply (rule, erule mTREE_Unique, assumption, erule mTREE_Unique, assumption)
      apply clarsimp+
      apply (rule GETr_Update1, fast)
      apply clarsimp+
    (*xx\<notin>{right,left}*)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp)
      apply (subgoal_tac "\<exists> R S . (RVal (renv E right), h, GETr C right, R, S) \<in> reg", clarsimp)
      prefer 2 apply (simp add: regionsExist_def, erule_tac x=right in allE, erule impE, clarsimp) apply (erule GETrSome_DOM)
               apply (simp add: GETr_def)
      apply (erule_tac x=right in allE, erule_tac x=xx in allE, erule_tac x=R in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
      apply (rule, erule GETrSome_DOM)
      apply (rule, simp add:DOM_def)
      apply (rule, fast)
      apply fastsimp
      apply (subgoal_tac "Rx \<subseteq> R-{a}", fast) apply (erule mTREE_Rightregion) apply (simp add: GETr_def)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx", clarsimp)
      apply (rule GETr_Update1, fast)
      apply (rule GETr_Update1, fast)
  apply (case_tac "x=left", clarsimp)  
    apply (case_tac "xx=left", clarsimp)
    apply (case_tac "xx=right", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=right in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule reg.elims, clarsimp+)
      apply (erule mTREE.elims, clarsimp, clarsimp)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", clarsimp, simp add: GETr_def)
      apply (erule reg.elims, clarsimp+)
      apply (erule reg.elims, clarsimp+)
      apply (subgoal_tac "(X1=R \<and> n1=n) \<and> (X2=Ra \<and> n2=na)", clarsimp,fast)
      apply (rule, erule mTREE_Unique, assumption, erule mTREE_Unique, assumption)
      apply clarsimp+
      apply (rule GETr_Update1, fast)
      apply clarsimp+
    (*xx\<notin>{right,left}*)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp)
      apply (subgoal_tac "\<exists> R S . (RVal (renv E right), h, GETr C right, R, S) \<in> reg", clarsimp)
      prefer 2 apply (simp add: regionsExist_def, erule_tac x=right in allE, erule impE, clarsimp) apply (erule GETrSome_DOM)
               apply (simp add: GETr_def)
      apply (erule_tac x=right in allE, erule_tac x=xx in allE, erule_tac x=R in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
      apply (rule, erule GETrSome_DOM)
      apply (rule, simp add:DOM_def)
      apply (rule, fast)
      apply fastsimp
      apply (subgoal_tac "Rx \<subseteq> R-{a}", fast) apply (erule mTREE_Leftregion) apply (simp add: GETr_def)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", simp add: GETr_def)
      apply (rule GETr_Update1, fast)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx", clarsimp)
      apply (rule GETr_Update1, fast)
      apply (rule GETr_Update1, fast)
  (*x \<notin> {right,left}*)
    apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x")
    prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
      apply (rule GETr_Update1, fast)
      apply (rule GETr_Update1, fast)
    apply (case_tac "xx=right", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=right in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule_tac x=x in allE, erule_tac x=right in allE, erule_tac x=Rx in allE, erule_tac x=Rxa in allE, erule impE, clarsimp)
      apply (rule, simp add:DOM_def)
      apply (rule, erule GETrSome_DOM)
      apply (rule, fast)
      apply fastsimp
      apply (subgoal_tac "Rxx \<subseteq> Rxa-{a}", fast) apply (erule mTREE_Rightregion) apply (simp add: GETr_def)
    apply (case_tac "xx=left", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=right in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule_tac x=x in allE, erule_tac x=right in allE, erule_tac x=Rx in allE, erule_tac x=Rxa in allE, erule impE, clarsimp)
      apply (rule, simp add:DOM_def)
      apply (rule, erule GETrSome_DOM)
      apply (rule, fast)
      apply fastsimp
      apply (subgoal_tac "Rxx \<subseteq> Rxa-{a}", fast) apply (erule mTREE_Leftregion) 
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", simp add: GETr_def)
      apply (rule GETr_Update1, fast)
    (*xx\<notin>{right,left}*)
      apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
      apply (rule, simp add:DOM_def)
      apply (rule, simp add:DOM_def)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp,fast)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx", clarsimp)
      apply (rule GETr_Update1, fast)
      apply (rule GETr_Update1, fast)
      apply fast
done

lemma distinctFromTreeMatch1:
"\<lbrakk>left \<noteq> right; t \<notin> U - {left,right}; t \<noteq> left; GETr C t = Some (TreeET k); renv E t = Ref a;
  regionsExist (insert t (U - {left, right})) C h E;
  distinctFrom (insert t (U - {left, right})) C h E F\<rbrakk>
       \<Longrightarrow> distinctFrom U (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) h E<cont:=h<a\<bullet>V0>>\<lfloor>left:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>\<lfloor>right:=h\<lfloor>a\<diamondsuit>R2\<rfloor>\<rfloor> F"
apply (simp add: distinctFrom_def, safe)
(*t \<notin> U*)
  apply (case_tac "x=right", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=t in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule_tac x=t in allE, erule impE, clarsimp) apply (erule GETrSome_DOM) 
      apply (erule_tac x=Rxa in allE, erule impE, fastsimp)
      apply (simp add: GETr_def)
      apply (subgoal_tac "Rx \<subseteq> Rxa-{a}",fast)
      apply (erule mTREE_Rightregion, assumption)
  apply (case_tac "x=left", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=t in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule_tac x=t in allE, erule impE, clarsimp) apply (erule GETrSome_DOM) 
      apply (erule_tac x=Rxa in allE, erule impE, fastsimp)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", clarsimp)
      apply (simp add: GETr_def)
      apply (subgoal_tac "Rx \<subseteq> Rxa-{a}",fast)
      apply (erule mTREE_Leftregion, assumption)
      apply (rule GETr_Update1, fast)
    (*xx\<notin>{right,left}*)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp)
      apply (erule_tac x=x in allE, erule impE, clarsimp)
      apply (simp add:DOM_def)
      apply (fast)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
      apply (rule GETr_Update1, fast)
      apply (rule GETr_Update1, fast)
(*t \<in> U*)
  apply (case_tac "x=right", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=right in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule_tac x=right in allE, erule impE, clarsimp) apply (erule GETrSome_DOM) 
      apply (erule_tac x=Rxa in allE, erule impE, fastsimp)
      apply (simp add: GETr_def)
      apply (subgoal_tac "Rx \<subseteq> Rxa-{a}",fast)
      apply (erule mTREE_Rightregion, assumption)
  apply (case_tac "x=left", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=right in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule_tac x=right in allE, erule impE, clarsimp) apply (erule GETrSome_DOM) 
      apply (erule_tac x=Rxa in allE, erule impE, fastsimp)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", clarsimp)
      apply (simp add: GETr_def)
      apply (subgoal_tac "Rx \<subseteq> Rxa-{a}",fast)
      apply (erule mTREE_Leftregion, assumption)
      apply (rule GETr_Update1, fast)
    (*xx\<notin>{right,left}*)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp)
      apply (erule_tac x=x in allE, erule impE, clarsimp)
      apply (simp add:DOM_def)
      apply (fast)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
      apply (rule GETr_Update1, fast)
      apply (rule GETr_Update1, fast)
done

lemma modifiedTreeMatch1:
"\<lbrakk>left \<noteq> right; t \<noteq> left; GETr C t = Some (TreeET k); renv E t = Ref a;
  regionsExist (insert t (U - {left, right})) C h E;
  modified F U (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) h E<cont:=h<a\<bullet>V0>>\<lfloor>left:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>\<lfloor>right:=h\<lfloor>a\<diamondsuit>R2\<rfloor>\<rfloor> hh\<rbrakk>
 \<Longrightarrow> modified F (insert t (U - {left, right})) C h E hh"
apply (simp add: modified_def, safe)
  apply (erule_tac x=l in allE, erule impE, safe)
  apply (case_tac "z=right", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=t in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule_tac x=t in allE, erule_tac x=Rx in allE, erule impE, clarsimp) apply (rule,erule GETrSome_DOM) apply fast
      apply (simp add: GETr_def)
      apply (subgoal_tac "Rz \<subseteq> Rx-{a}",fast)
      apply (erule mTREE_Rightregion, assumption)
  apply (case_tac "z=left", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=t in allE, erule impE, clarsimp)
      apply (erule GETrSome_DOM, clarsimp, rotate_tac -1)
      apply (erule_tac x=t in allE, erule_tac x=Rx in allE, erule impE, clarsimp) apply (rule,erule GETrSome_DOM) apply fast
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", clarsimp)
      apply (simp add: GETr_def)
      apply (subgoal_tac "Rz \<subseteq> Rx-{a}",fast)
      apply (erule mTREE_Leftregion, assumption)
      apply (rule GETr_Update1, fast)
    (*z \<notin> {right,left}*)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) z = GETr C z", clarsimp)
      apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
      apply (rule,simp add:DOM_def)
      apply (fast)
      apply simp
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) z = GETr (C(left\<mapsto>\<^sub>fTreeET k)) z", clarsimp)
      apply (rule GETr_Update1, fast)
      apply (rule GETr_Update1, fast)
done

lemma BoundedTreeMatch1:
"\<lbrakk>left \<noteq> right; t \<noteq> left; GETr C t = Some (TreeET k); renv E t = Ref a;
  regionsExist (insert t (U - {left, right})) C h E;
  Bounded R F U (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) h E<cont:=h<a\<bullet>V0>>\<lfloor>left:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>\<lfloor>right:=h\<lfloor>a\<diamondsuit>R2\<rfloor>\<rfloor>\<rbrakk>
\<Longrightarrow> Bounded R F (insert t (U - {left, right})) C h E"
apply (simp add: Bounded_def, rule, rule)
  apply (erule_tac x=l in allE, erule impE, simp)
  apply (erule disjE, simp)
  apply (rule disjI2, clarsimp)
  apply (case_tac "x=right", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=t in allE, erule impE, clarsimp)
      apply (rule GETrSome_DOM, assumption, clarsimp, rotate_tac -1)
      apply (rule_tac x=t in exI, clarsimp) apply (rule,erule GETrSome_DOM) 
      apply (simp add: GETr_def)
      apply (subgoal_tac "Rx \<subseteq> Rxa-{a}",fast)
      apply (erule mTREE_Rightregion, assumption)
  apply (case_tac "x=left", clarsimp)
      apply (simp add: regionsExist_def, erule_tac x=t in allE, erule impE, clarsimp)
      apply (rule GETrSome_DOM, assumption, clarsimp, rotate_tac -1)
      apply (rule_tac x=t in exI, clarsimp) apply (rule,erule GETrSome_DOM) 
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", clarsimp)
      apply (simp add: GETr_def)
      apply (subgoal_tac "Rx \<subseteq> Rxa-{a}",fast)
      apply (erule mTREE_Leftregion, assumption)
      apply (rule GETr_Update1, fast)
    (*x \<notin> {right,left}*)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp)
      apply (rule_tac x=x in exI, clarsimp)
      apply (rule,simp add:DOM_def)
      apply (fast)
      apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
      apply (rule GETr_Update1, fast)
      apply (rule GETr_Update1, fast)
done

lemma Distr1: "(k::nat) * (n1 + n2a) = k * n1 + k * n2a"
apply (insert add_mult_distrib [of n1 n2a k]) 
apply (subgoal_tac "(n1 + n2a) * k = k * (n1 + n2a)")
apply clarsimp
apply (insert mult_commute) apply fast
done
(*>*)

lemma DA_TreeMatch: 
  "\<lbrakk>GETr C t = Some (TreeET k); nk = n+k; 
    G \<rhd> e : DAss U nk (C(left\<mapsto>\<^sub>f(TreeET k))(right\<mapsto>\<^sub>f(TreeET k))) T m;
    left \<noteq> right;
    t \<notin> U - {left,right}; t \<noteq> left\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET cont = GetFi t V0; rf left = GetFr t R1; rf right = GetFr t R2 IN e END) : DAss ((U-{left,right}) \<union> {t}) n C T m"
(*<*)
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_getfi)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letr, rule vdm_getfr)
apply assumption
apply (rotate_tac 2, erule thin_rl, clarsimp)
apply (rule DAss_PConst)
apply (simp add: DAss_def, safe)
(*case t \<notin> U*)
apply (subgoal_tac " (\<exists> n1 n2 . (E, h, {t}, C, n1) \<in> ContextSize \<and> (E, h, U - {left, right}, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT) apply fast apply fast 
apply (rotate_tac -2, erule ContextSize.elims, simp_all, clarsimp)
apply (rotate_tac -1, erule ContextSize.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -1, erule mTREE.elims, simp_all, clarsimp)
apply (case_tac "left :U")
(*left :U*)
  apply (case_tac "right :U")
  (*right :U*) apply (erule_tac x=q in allE, erule_tac x="n2+(k*n1)+(k*n2a)" in allE, erule_tac x=F in allE, erule impE, clarsimp)
    apply (rule_tac x=N in exI, safe)
    apply (rule regionsExistsTreeMatch1, assumption+)
    apply (rule regionsDistinctTreeMatch1) prefer 3 apply (simp+)
    apply (rule distinctFromTreeMatch1) prefer 4 apply (simp+)
    apply (erule ContextSizeCONS) 
       apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = Some (TreeET k)", clarsimp)
       apply (erule regTree, simp) apply (rule GETr_Update2, simp add: GETr_def,fast)
    apply (rule ContextSizeCONS) apply (subgoal_tac "right : U - {left}", assumption,fast)
       apply (simp add: GETr_def)
       apply (erule regTree, simp) 
    apply (subgoal_tac "U - {left} - {right} = U - {left, right}", clarsimp) apply (erule ContextSizePreservedU) apply simp
      apply (rule GETr_Update2) apply (erule GETr_Update2) apply clarsimp apply clarsimp apply fast
    apply simp
    apply simp
    apply (simp add: Distr1)
    apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
      apply (rule modifiedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+)
  (*right \<notin> U*) apply (erule_tac x=q in allE, erule_tac x="n2+(k*n1)" in allE, erule_tac x=F in allE, erule impE, clarsimp)
    apply (rule_tac x=N in exI, safe)
    apply (rule regionsExistsTreeMatch1, assumption+)
    apply (rule regionsDistinctTreeMatch1) prefer 3 apply (simp+)
    apply (rule distinctFromTreeMatch1) prefer 4 apply (simp+)
    apply (erule ContextSizeCONS) 
       apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = Some (TreeET k)", clarsimp)
       apply (erule regTree, simp) apply (rule GETr_Update2, simp add: GETr_def,fast)
    apply (subgoal_tac "U - {left} = U - {left, right}", clarsimp) apply (erule ContextSizePreservedU) apply simp
      apply (rule GETr_Update2) apply (erule GETr_Update2) apply clarsimp apply clarsimp apply fast
    apply simp
    apply (subgoal_tac "n + k + (n2 + k * n1) + q \<le> n + (k + k * (n1 + n2a) + n2) + q", fastsimp) apply clarsimp
    apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
      apply (rule modifiedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+)
(*left \<notin> U*)  apply (case_tac "right :U")
  (*right :U*) apply (erule_tac x=q in allE, erule_tac x="n2+(k*n2a)" in allE, erule_tac x=F in allE, erule impE)
    apply (rule_tac x=N in exI, safe)
    apply (rule regionsExistsTreeMatch1, assumption+)
    apply (rule regionsDistinctTreeMatch1) prefer 3 apply (simp+)
    apply (rule distinctFromTreeMatch1) prefer 4 apply (simp+)
    apply (erule ContextSizeCONS) 
       apply (simp add: GETr_def)
       apply (erule regTree, simp) 
       apply (erule ContextSizePreservedU) apply (subgoal_tac "x \<noteq> left \<and> x \<noteq> right", clarsimp) apply fast
      apply (rule GETr_Update2) apply (erule GETr_Update2) apply clarsimp apply clarsimp 
    apply simp
    apply (subgoal_tac "n + k + (n2 + k * n2a) + q \<le> n + (k + k * (n1 + n2a) + n2) + q", fastsimp) apply clarsimp
    apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
      apply (rule modifiedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+)
  (*right \<notin> U*) apply (erule_tac x=q in allE, erule_tac x=n2 in allE, erule_tac x=F in allE, erule impE)
    apply (rule_tac x=N in exI, safe)
    apply (rule regionsExistsTreeMatch1, assumption+)
    apply (rule regionsDistinctTreeMatch1) prefer 3 apply (simp+)
    apply (rule distinctFromTreeMatch1) prefer 4 apply (simp+)
    apply (erule ContextSizePreservedU) apply (subgoal_tac "x \<noteq> left \<and> x \<noteq> right", clarsimp) apply fast
      apply (rule GETr_Update2) apply (erule GETr_Update2) apply clarsimp apply clarsimp 
    apply simp 
    apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
      apply (rule modifiedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+)
(*case t:U, i.e. t=right*)
apply (subgoal_tac " (\<exists> n1 n2 . (E, h, {right}, C, n1) \<in> ContextSize \<and> (E, h, U - {left, right}, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT) apply fast apply fast 
apply (rotate_tac -2, erule ContextSize.elims, simp_all, clarsimp)
apply (rotate_tac -1, erule ContextSize.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -1, erule mTREE.elims, simp_all, clarsimp)
apply (case_tac "left :U")
(*left :U*)
  apply (case_tac "right :U")
  (*right :U*) apply (erule_tac x=q in allE, erule_tac x="n2+(k*n1)+(k*n2a)" in allE, erule_tac x=F in allE, erule impE, clarsimp)
    apply (rule_tac x=N in exI, safe)
    apply (rule regionsExistsTreeMatch1, assumption+)
    apply (rule regionsDistinctTreeMatch1) prefer 3 apply (simp+)
    apply (rule distinctFromTreeMatch1) prefer 4 apply (simp+)
    apply (erule ContextSizeCONS) 
       apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = Some (TreeET k)", clarsimp)
       apply (erule regTree, simp) apply (rule GETr_Update2, simp add: GETr_def,fast)
    apply (rule ContextSizeCONS) apply (subgoal_tac "right : U - {left}", assumption,fast)
       apply (simp add: GETr_def)
       apply (erule regTree, simp) 
    apply (subgoal_tac "U - {left} - {right} = U - {left, right}", clarsimp) apply (erule ContextSizePreservedU) apply simp
      apply (rule GETr_Update2) apply (erule GETr_Update2) apply clarsimp apply clarsimp apply fast
    apply simp
    apply simp
    apply (simp add: Distr1)
    apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
      apply (rule modifiedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+)
  (*right \<notin> U*) apply (erule_tac x=q in allE, erule_tac x="n2+(k*n1)" in allE, erule_tac x=F in allE, erule impE, clarsimp)
    apply (rule_tac x=N in exI, safe)
    apply (rule regionsExistsTreeMatch1, assumption+)
    apply (rule regionsDistinctTreeMatch1) prefer 3 apply (simp+)
    apply (rule distinctFromTreeMatch1) prefer 4 apply (simp+)
    apply (erule ContextSizeCONS) 
       apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = Some (TreeET k)", clarsimp)
       apply (erule regTree, simp) apply (rule GETr_Update2, simp add: GETr_def,fast)
    apply (subgoal_tac "U - {left} = U - {left, right}", clarsimp) apply (erule ContextSizePreservedU) apply simp
      apply (rule GETr_Update2) apply (erule GETr_Update2) apply clarsimp apply clarsimp apply fast
    apply simp
    apply (subgoal_tac "n + k + (n2 + k * n1) + q \<le> n + (k + k * (n1 + n2a) + n2) + q", fastsimp) apply clarsimp
    apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
      apply (rule modifiedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+)
(*left \<notin> U*)  apply (case_tac "right :U")
  (*right :U*) apply (erule_tac x=q in allE, erule_tac x="n2+(k*n2a)" in allE, erule_tac x=F in allE, erule impE)
    apply (rule_tac x=N in exI, safe)
    apply (rule regionsExistsTreeMatch1, assumption+)
    apply (rule regionsDistinctTreeMatch1) prefer 3 apply (simp+)
    apply (rule distinctFromTreeMatch1) prefer 4 apply (simp+)
    apply (erule ContextSizeCONS) 
       apply (simp add: GETr_def)
       apply (erule regTree, simp) 
       apply (erule ContextSizePreservedU) apply (subgoal_tac "x \<noteq> left \<and> x \<noteq> right", clarsimp) apply fast
      apply (rule GETr_Update2) apply (erule GETr_Update2) apply clarsimp apply clarsimp 
    apply simp
    apply (subgoal_tac "n + k + (n2 + k * n2a) + q \<le> n + (k + k * (n1 + n2a) + n2) + q", fastsimp) apply clarsimp
    apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
      apply (rule modifiedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+)
  (*right \<notin> U*) apply (erule_tac x=q in allE, erule_tac x=n2 in allE, erule_tac x=F in allE, erule impE)
    apply (rule_tac x=N in exI, safe)
    apply (rule regionsExistsTreeMatch1, assumption+)
    apply (rule regionsDistinctTreeMatch1) prefer 3 apply (simp+)
    apply (rule distinctFromTreeMatch1) prefer 4 apply (simp+)
    apply (erule ContextSizePreservedU) apply (subgoal_tac "x \<noteq> left \<and> x \<noteq> right", clarsimp) apply fast
      apply (rule GETr_Update2) apply (erule GETr_Update2) apply clarsimp apply clarsimp 
    apply simp 
    apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
      apply (rule modifiedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+) 
      apply (rule BoundedTreeMatch1, assumption+)
done
(*>*)

lemma DA_TreeMatchD: 
  "\<lbrakk>GETr C t = Some (TreeET k); nk = n+k+1; 
    G \<rhd> e : DAss U nk (C(left\<mapsto>\<^sub>f(TreeET k))(right\<mapsto>\<^sub>f(TreeET k))) T m;
    left \<noteq> right;
    t \<notin> U \<union> {left,right}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET cont = GetFi t V0; rf left = GetFr t R1;
           rf right = GetFr t R2 ; _ = DIAM\<bullet>Free ([RNarg t]) IN e END) : DAss ((U-{left,right}) \<union> {t}) n C T m"
(*<*)
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_getfi)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letv, rule DA_Free1)
apply assumption

apply clarsimp apply (rule DAss_PConst) 
  apply (rotate_tac 1, erule thin_rl)
  apply (subgoal_tac "t: DOM C")
  prefer 2 apply (erule GETrSome_DOM)
  apply (simp add: DAss_def, safe)  
  apply (subgoal_tac "a \<notin> F")
  prefer 2  apply (rotate_tac 2, erule thin_rl) apply (simp add: distinctFrom_def) apply (erule_tac x=t in allE, erule impE, clarsimp)
                      apply (simp add: regionsExist_def) apply (erule_tac x=t in allE, erule impE, clarsimp)
                      apply clarsimp apply (erule_tac x=Rx in allE, erule impE,fast) 
                      apply (subgoal_tac "a:Rx", fast) apply(erule  Ref_reg, simp)
  apply (subgoal_tac "\<exists> n1 n2 . (E, h, {t}, C, n1) \<in> ContextSize \<and> (E, h, U-{left,right}, C, n2) \<in> ContextSize \<and> n1 + n2 = CS", clarsimp)
  prefer 2 apply (rotate_tac 4, erule thin_rl, erule ContextSize_SPLIT,fast,fast)
  apply (rotate_tac -2, erule ContextSize.elims, clarsimp+) 
  apply (subgoal_tac "a:R ") prefer 2 apply (erule Ref_reg, simp)
  apply (rotate_tac -2, erule ContextSize.elims, clarsimp+) 
  apply (case_tac "left:U")
  (*case left :U*)
    apply (case_tac "right:U")
    (*case right :U*) 
      apply (rule reg.elims, assumption, clarsimp+)
      apply (erule mTREE.elims, clarsimp+)
      apply (erule_tac x=q in allE, erule_tac x="k * n1 + (k * n2a + n2)" in allE, erule_tac x="F \<union> {aa}" in allE, erule impE, safe)
      apply (subgoal_tac "aa \<notin> F") prefer 2 apply (simp add: distinctFrom_def)
      apply (rule_tac x="Suc N" in exI, safe)
        apply (simp add: freelist_def) 
        apply (subgoal_tac "(Suc N, Ref aa, F \<union> {aa}, h
           \<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(aa := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
              sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref aa))\<rparr>)
          \<in> FL", simp)
        apply(rule FL_SUC) apply simp+ apply (erule FL_UpdateOutside) apply assumption
        apply (simp add: regionsExist_def, clarsimp)
             apply (case_tac "x=right")
             (*x=right*) apply clarsimp
                apply (rule, rule, rule reg_Preserved) apply (simp add: GETr_def) apply (erule regTree, simp) apply (simp add: sameOH_def,fast)
             (*x \<noteq> right*)  
               apply (case_tac "x=left")
               (*x = left*) 
                apply (rule, rule, rule reg_Preserved) 
                apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = Some (TreeET k)", clarsimp)
                apply (erule regTree, simp) apply (rule GETr_Update2, simp add: GETr_def,fast) apply (simp add: sameOH_def,fast)
               (*x \<noteq> left*) apply (erule_tac x=x in allE, erule impE, clarsimp) apply (simp add: DOM_def) 
                            apply clarsimp 
                            apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
                            apply (rule, rule, rule reg_Preserved, assumption) 
                            apply (subgoal_tac "l \<noteq> aa", simp add: sameOH_def) 
                            apply (subgoal_tac "insert aa (X1 \<union> X2) \<inter> Rx = {}",fast)
                            apply (simp add: regionsDistinct_def) 
                            apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE,
                                   erule_tac x=Rx in allE, erule impE, clarsimp) 
                              apply (rule, simp add: DOM_def) apply fastsimp apply fast
                            apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
                              apply (rule GETr_Update1,fast) apply (rule GETr_Update1,fast)
        apply (simp add: regionsDistinct_def, clarsimp)
             apply (case_tac "x=right")
             (*x=right*) apply clarsimp 
               apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx", clarsimp) 
               prefer 2 apply (rule GETr_Update1,fast) 
               apply (subgoal_tac "Rx=X2 \<and> Sx=k*n2a", clarsimp) prefer 2 apply (erule reg_Unique) apply (simp add: GETr_def) 
                 apply (rule reg_Preserved) apply (erule regTree) apply simp apply (simp add: sameOH_def) apply fast 
               apply (case_tac "xx=left")
               (*xx=left*) apply clarsimp apply (simp add: GETr_def)
                     apply (subgoal_tac "Rxx=X1 \<and> Sxx=k*n1", clarsimp) prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved) 
                        apply (erule regTree) apply simp apply (simp add: sameOH_def) apply fast 
                     apply fast 
               (*xx \<noteq> left*) apply simp
                              apply (simp add: regionsExist_def)  apply (erule_tac x=xx in allE, erule impE, safe) apply (simp add: DOM_def)
                                apply (erule disjE,simp+) 
                              apply (erule_tac x=t in allE, erule_tac x=xx in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, 
                                     erule_tac x=Rx in allE, erule impE, safe) apply (simp add: DOM_def) apply (erule disjE,simp+)
                                apply fastsimp apply fastsimp
                              apply (subgoal_tac "Rxx=Rx \<and> Sxx=Sx", clarsimp) apply fast
                              apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp) 
                              apply (erule reg_Unique) apply (erule reg_Preserved) apply (simp add: sameOH_def) apply fast
                              apply (rule GETr_Update1,fast) 
             (*x\<noteq>right*) 
               apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
               prefer 2 apply (rule GETr_Update1,fast) 
               apply (case_tac "x=left")
               (*x=left*) apply clarsimp 
                 apply (subgoal_tac "Rx=X1 \<and> Sx=k*n1", clarsimp) prefer 2 apply (erule reg_Unique) apply (simp add: GETr_def) 
                 apply (rule reg_Preserved) apply (erule regTree) apply simp apply (simp add: sameOH_def) apply fast 
                 apply (case_tac "xx=right")
                 (*xx=right*) apply clarsimp apply (simp add: GETr_def)
                     apply (subgoal_tac "Rxx=X2 \<and> Sxx=k*n2a", clarsimp) prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved) 
                        apply (erule regTree) apply simp apply (simp add: sameOH_def) apply fast 
                     apply fast 
                 (*xx \<noteq> right*) apply simp
                              apply (simp add: regionsExist_def)  apply (erule_tac x=xx in allE, erule impE, safe) apply (simp add: DOM_def)
                                apply (erule disjE,simp+) 
                              apply (erule_tac x=t in allE, erule_tac x=xx in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, 
                                     erule_tac x=Rx in allE, erule impE, safe) apply (simp add: DOM_def) apply (erule disjE,simp+)
                                apply fastsimp apply fastsimp
                              apply (subgoal_tac "Rxx=Rx \<and> Sxx=Sx", clarsimp) apply fast
                              apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp) 
                              apply (erule reg_Unique) apply (erule reg_Preserved) apply (simp add: sameOH_def) apply fast
                              apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx", clarsimp) 
                              apply (rule GETr_Update1,fast) 
                              apply (rule GETr_Update1,fast)
               (*x \<noteq> left*)
                 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
                 prefer 2 apply (rule GETr_Update1,fast)
                 apply (subgoal_tac "\<exists> Rxa Sxa . (RVal (renv E x), h, GETr C x, Rxa, Sxa):reg", clarsimp) 
                 prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, erule impE, safe) apply (simp add: DOM_def)
                 apply (subgoal_tac "Rx=Rxa \<and> Sx=Sxa", clarsimp) 
                 prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                          apply (subgoal_tac "insert aa (X1 \<union> X2) \<inter> Rxa = {}", simp add: sameOH_def, fast)
                          apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE, erule impE,safe)
                             apply (simp add: DOM_def)  apply fastsimp apply fastsimp 
                 apply (case_tac "xx=right")
                 (*xx=right*) apply clarsimp 
                     apply (subgoal_tac "Rxx=X2 \<and> Sxx=k*n2a", clarsimp) 
                     prefer 2 apply (erule reg_Unique) apply (simp add: GETr_def) apply (rule reg_Preserved) apply (erule regTree, simp) 
                              apply (simp add: sameOH_def) apply fast
                     apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE, erule impE,safe)
                             apply (simp add: DOM_def) apply fastsimp apply fastsimp 
                     apply fast
                 (*xx\<noteq>right*)
                   apply (case_tac "xx=left")
                   (*xx=left*) apply clarsimp 
                     apply (subgoal_tac "Rxx=X1 \<and> Sxx=k*n1", clarsimp) 
                     prefer 2 apply (erule reg_Unique) 
                              apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", clarsimp) 
                              apply (simp add: GETr_def) apply (rule reg_Preserved) apply (erule regTree, simp) apply (simp add: sameOH_def) apply fast
                              apply (rule GETr_Update1, fast)
                     apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE, erule impE,safe)
                             apply (simp add: DOM_def) apply fastsimp apply fastsimp 
                     apply fast
                   (*xx\<noteq>left*) apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp) 
                     apply (subgoal_tac "\<exists> Rxb Sxb . (RVal (renv E xx), h, GETr C xx, Rxb, Sxb):reg", clarsimp) 
                     prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=xx in allE, erule impE, safe) apply (simp add: DOM_def)
                     apply (subgoal_tac "Rxx=Rxb \<and> Sxx=Sxb", clarsimp) 
                     prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption) apply (simp add: sameOH_def) 
                     apply (erule_tac x=t in allE, erule_tac x=xx in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxb in allE, erule impE,safe)
                             apply (simp add: DOM_def) apply fastsimp apply fastsimp
                     apply fast
                     apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=Rxa in allE, erule_tac x=Rxb in allE, erule impE,safe)
                             apply (simp add: DOM_def) apply (simp add: DOM_def) apply fastsimp apply fastsimp
                     apply fast
                     apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx", clarsimp) 
                     apply (rule GETr_Update1, fast) 
                     apply (rule GETr_Update1,fast)  
        apply (simp add: distinctFrom_def, clarsimp)
             apply (case_tac "x=right")
             (*x=right*) apply clarsimp 
                     apply (simp add: GETr_def)
                     apply (erule_tac x=t in allE, erule impE, clarsimp) 
                     apply (erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE, clarsimp) apply fast
                     apply (subgoal_tac "Rx=X2 \<and> Sx=k*n2a", clarsimp) apply fast
                     apply (erule reg_Unique) apply (rule reg_Preserved) apply (rule regTree, simp) apply simp
                              apply clarsimp apply (simp add: sameOH_def) apply fast
             (*x\<noteq>right*)
                    apply (case_tac "x=left")
                    (*x=left*) apply clarsimp 
                       apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = Some (TreeET k)", clarsimp)
                       apply (erule_tac x=t in allE, erule impE, clarsimp) 
                       apply (erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE, clarsimp) apply fast
                       apply (subgoal_tac "Rx=X1 \<and> Sx=k*n1", clarsimp) apply fast
                       apply (erule reg_Unique) apply (rule reg_Preserved) apply (rule regTree, simp) apply simp
                              apply clarsimp apply (simp add: sameOH_def) apply fast
                       apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", clarsimp)
                       apply (simp add: GETr_def) 
                       apply (rule GETr_Update1,fast)  
                     (*x\<noteq>left*)
                       apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp)
                       apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
                       apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), h, GETr C x, RR, SS) \<in> reg", clarsimp)
                       prefer 2 apply (simp add: regionsExist_def) 
                       apply (subgoal_tac "insert aa (X1 \<union> X2) \<inter> RR = {}")
                       prefer 2 apply (simp add: regionsDistinct_def) 
                              apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=RR in allE,erule impE,clarsimp,fastsimp) apply fast
                       apply (subgoal_tac "Rx=RR \<and> Sx=SS", clarsimp)
                       prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                         apply clarsimp apply (subgoal_tac "l \<noteq> aa", simp add: sameOH_def) apply fast
                       apply (erule_tac x=x in allE, erule impE, clarsimp) apply fastsimp
                       apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
                       apply (rule GETr_Update1, fast) 
                       apply (rule GETr_Update1,fast)  
        apply (erule ContextSizeCONS)
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", clarsimp)
          prefer 2 apply (rule GETr_Update1,fast)  
          apply (simp add: GETr_def)
          apply (rule reg_Preserved) apply (erule regTree, simp) apply (simp add: sameOH_def, fast)
          apply (rule ContextSizeCONS) apply (subgoal_tac "right : U-{left}", assumption, fast)
          apply (simp add: GETr_def)
          apply (rule reg_Preserved) apply (erule regTree, simp) apply (simp add: sameOH_def, fast)
          apply (subgoal_tac "U- {left}-{right} = U-{left,right}", clarsimp) prefer 2 apply fast
          apply (rule SizePreserved_h_h1)
          apply (erule ContextSizePreservedU) apply simp
            apply (rule GETr_Update2) apply (erule GETr_Update2, fastsimp, fastsimp) 
          apply (subgoal_tac "l\<noteq>aa", simp add: sameOH_def)
          apply clarsimp
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp)
          prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
                   apply (rule GETr_Update1,fast) apply (rule GETr_Update1, fast)
          apply (simp add: regionsDistinct_def) 
          apply (erule_tac x=x in allE, erule_tac x=t in allE, erule_tac x=R in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE, safe)
            apply (erule reg_DOM) 
            apply fastsimp
            apply fastsimp
            apply fast
          apply simp
          apply simp
          apply (subgoal_tac "n + (k + k * (n1 + n2a) + n2) + q=n + k + (k * n1 + (k * n2a + n2)) + q", clarsimp)
            apply (clarsimp, rule Distr1)
      apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)  
        apply (simp add: modified_def, clarsimp)  apply (rotate_tac -7, erule thin_rl, erule thin_rl)
          apply (erule_tac x=l in allE, erule impE,clarsimp)
          apply rule apply (erule_tac x=t in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, clarsimp)
         apply clarsimp 
         apply (case_tac "z=right")
         (*z=right*) apply clarsimp
            apply (subgoal_tac "l \<notin> insert aa (X1 \<union> X2)") 
            prefer 2 apply (erule_tac x=t in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE,fastsimp) 
                     apply assumption
            apply (subgoal_tac "Rz=X2 \<and> Sz = k*n2a", fast)
            apply (erule reg_Unique) apply (rule reg_Preserved) apply (simp add: GETr_def) apply (rule regTree, simp) apply simp
              apply clarsimp apply (simp add: sameOH_def, fast)
          (*z\<noteq>right*) 
            apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) z = GETr (C(left\<mapsto>\<^sub>fTreeET k)) z", clarsimp)
            prefer 2 apply (rule GETr_Update1, fast)
            apply (case_tac "z=left")
            (*z=left*) apply clarsimp
              apply (subgoal_tac "l \<notin> insert aa (X1 \<union> X2)") 
              prefer 2 apply (erule_tac x=t in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE,fastsimp) 
                       apply assumption
              apply (subgoal_tac "Rz=X1 \<and> Sz = k*n1", fast)
              apply (erule reg_Unique) apply (rule reg_Preserved) apply (simp add: GETr_def) apply (rule regTree, simp) apply simp
                apply clarsimp apply (simp add: sameOH_def, fast)
           (*z\<noteq>left*) 
             apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) z = GETr C z", clarsimp)
             prefer 2 apply (rule GETr_Update1, fast)
             apply (subgoal_tac "z:DOM C") prefer 2 apply (simp add: DOM_def)
             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E z), h, GETr C z,RR,SS):reg", clarsimp) 
             prefer 2 apply (simp add: regionsExist_def) 
             apply (subgoal_tac "l \<notin> RR") prefer 2 apply (erule_tac x=z in allE, erule_tac x=RR in allE, fastsimp)
             apply (subgoal_tac "Rz=RR \<and> Sz = SS", fast)
             apply (rule reg_Unique, assumption) apply (rule reg_Preserved, assumption) 
             apply (subgoal_tac "la \<noteq> aa", simp add: sameOH_def) 
             apply (simp add: regionsDistinct_def)
                apply (erule_tac x=t in allE, erule_tac x=z in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, 
                       erule_tac x=RR in allE,erule impE,clarsimp, fast)
                  apply fast
             apply (subgoal_tac "l \<noteq> aa", simp add: sameOH_def, safe) 
               apply (erule_tac x=rfield in allE) apply (case_tac "rfield = DOLLAR_N", clarsimp, clarsimp)
               apply (erule_tac x=t in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE, clarsimp) apply fastsimp apply fast 
        apply (simp add: Bounded_def,rule, rule) apply (erule_tac x=l in allE, erule impE, simp) 
          apply (rotate_tac -5, erule thin_rl) 
          apply (erule disjE) apply (rule disjI2) 
            apply (rule_tac x=t in exI, simp)
            apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, rule_tac x=" k + k * (n1 + n2a)" in exI, assumption+) apply fast
          apply (erule disjE,simp)
            apply (rule disjI2)
            apply clarsimp
            apply (case_tac "x=right")
            (*x=right*) apply clarsimp apply (rule_tac x=t in exI, clarsimp)  
             apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, fast)   
             apply (subgoal_tac "Rx=X2 \<and> Sx = k*n2a", fast)
             apply (erule reg_Unique) apply (simp add: GETr_def) apply (rule reg_Preserved) apply (erule regTree, simp)
             apply (simp add: sameOH_def, fast)
            (*x\<noteq>right*) apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
              apply (case_tac "x=left")
              (*x=left*) apply clarsimp
                apply (rule_tac x=t in exI, clarsimp)  
                apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, fast)   
                apply (subgoal_tac "Rx=X1 \<and> Sx = k*n1", fast)
                apply (erule reg_Unique) apply (simp add: GETr_def) apply (rule reg_Preserved) apply (erule regTree, simp)
                apply (simp add: sameOH_def, fast)
              (*x\<noteq>left*) apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
                apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
                apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, clarsimp)
                apply (subgoal_tac "Rx=Rxa \<and> Sx = Sxa", fast)
                apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
                apply clarsimp apply (subgoal_tac "la \<noteq> aa", simp add: sameOH_def) 
                apply (simp add: regionsDistinct_def)
                apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE,
                          erule impE,clarsimp, fast)
                apply fast
                apply (rule GETr_Update1, fast)
              apply (rule GETr_Update1, fast)
        apply (simp add: Bounded_def,rule, rule) apply (erule_tac x=l in allE, erule impE, simp) 
          apply (rotate_tac -5, erule thin_rl) 
          apply (erule disjE) apply (rule disjI2) 
            apply (rule_tac x=t in exI, simp)
            apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, rule_tac x=" k + k * (n1 + n2a)" in exI, assumption+) apply fast
          apply (erule disjE,simp)
            apply (rule disjI2)
            apply clarsimp
            apply (case_tac "x=right")
            (*x=right*) apply clarsimp apply (rule_tac x=t in exI, clarsimp)  
             apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, fast)   
             apply (subgoal_tac "Rx=X2 \<and> Sx = k*n2a", fast)
             apply (erule reg_Unique) apply (simp add: GETr_def) apply (rule reg_Preserved) apply (erule regTree, simp)
             apply (simp add: sameOH_def, fast)
            (*x\<noteq>right*) apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
              apply (case_tac "x=left")
              (*x=left*) apply clarsimp
                apply (rule_tac x=t in exI, clarsimp)  
                apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, fast)   
                apply (subgoal_tac "Rx=X1 \<and> Sx = k*n1", fast)
                apply (erule reg_Unique) apply (simp add: GETr_def) apply (rule reg_Preserved) apply (erule regTree, simp)
                apply (simp add: sameOH_def, fast)
              (*x\<noteq>left*) apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
                apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
                apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, clarsimp)
                apply (subgoal_tac "Rx=Rxa \<and> Sx = Sxa", fast)
                apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
                apply clarsimp apply (subgoal_tac "la \<noteq> aa", simp add: sameOH_def) 
                apply (simp add: regionsDistinct_def)
                apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE,
                          erule impE,clarsimp, fast)
                apply fast
                apply (rule GETr_Update1, fast)
              apply (rule GETr_Update1, fast)
    (*case right \<noteq> U*) 
      apply (rule reg.elims, assumption, clarsimp+)
      apply (erule mTREE.elims, clarsimp+)
      apply (erule_tac x=q in allE, erule_tac x="k * n1 + n2" in allE, erule_tac x="F \<union> {aa}" in allE, erule impE, safe)
      apply (subgoal_tac "aa \<notin> F") prefer 2 apply (simp add: distinctFrom_def)
      apply (rule_tac x="Suc N" in exI, safe)
        apply (simp add: freelist_def) 
        apply (subgoal_tac "(Suc N, Ref aa, F \<union> {aa}, h
           \<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(aa := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
              sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref aa))\<rparr>)
          \<in> FL", simp)
        apply(rule FL_SUC) apply simp+ apply (erule FL_UpdateOutside) apply assumption
        apply (simp add: regionsExist_def, clarsimp)
          apply (subgoal_tac "right \<noteq> x") prefer 2 apply fast
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
          prefer 2 apply (erule GETr_Update1)
          apply (case_tac "x=left")
          (*x = left*) 
                apply (rule, rule, rule reg_Preserved) 
                apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) left = Some (TreeET k)", clarsimp)
                apply (erule regTree, simp) apply (simp add: GETr_def) apply (simp add: sameOH_def,fast)
          (*x \<noteq> left*) apply clarsimp 
              apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
              apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def) apply (erule disjE, clarsimp, clarsimp)
              apply (erule_tac x=x in allE, erule impE, clarsimp) apply clarsimp
              apply (rule, rule, rule reg_Preserved, assumption) 
              apply (subgoal_tac "l \<noteq> aa", simp add: sameOH_def) 
              apply (subgoal_tac "insert aa (X1 \<union> X2) \<inter> Rx = {}",fast)
              apply (simp add: regionsDistinct_def) 
              apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rx in allE, erule impE, clarsimp) 
              apply (rule, simp add: DOM_def) apply fastsimp apply fast
              apply fast 
              apply (rule GETr_Update1,fast) 
        apply (simp add: regionsDistinct_def, clarsimp)
          apply (subgoal_tac "x \<noteq> right") prefer 2 apply fast
          apply (subgoal_tac "xx \<noteq> right") prefer 2 apply fast
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
               prefer 2 apply (rule GETr_Update1,fast) 
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx", clarsimp) 
               prefer 2 apply (rule GETr_Update1,fast) 
               apply (case_tac "x=left")
               (*x=left*) apply clarsimp 
                 apply (subgoal_tac "Rx=X1 \<and> Sx=k*n1", clarsimp) prefer 2 apply (erule reg_Unique) apply (simp add: GETr_def) 
                 apply (rule reg_Preserved) apply (erule regTree) apply simp apply (simp add: sameOH_def) apply fast 
                 apply (simp add: regionsExist_def) apply (erule_tac x=xx in allE, erule impE, safe)
                   apply (simp add: DOM_def) apply (erule disjE, clarsimp, clarsimp)
                 apply (erule_tac x=t in allE, erule_tac x=xx in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, 
                                     erule_tac x=Rx in allE, erule impE, safe) apply (simp add: DOM_def) apply (erule disjE,simp+)
                   apply fastsimp apply fastsimp
                 apply (subgoal_tac "Rxx=Rx \<and> Sxx=Sx", clarsimp) apply fast
                 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp) 
                 apply (erule reg_Unique) apply (erule reg_Preserved) apply (simp add: sameOH_def) apply fast
                 apply (rule GETr_Update1,fast)
               (*x \<noteq> left*)
                 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
                 prefer 2 apply (rule GETr_Update1,fast)
                 apply (subgoal_tac "\<exists> Rxa Sxa . (RVal (renv E x), h, GETr C x, Rxa, Sxa):reg", clarsimp) 
                 prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, erule impE, safe) apply (simp add: DOM_def)
                 apply (subgoal_tac "Rx=Rxa \<and> Sx=Sxa", clarsimp) 
                 prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                          apply (subgoal_tac "insert aa (X1 \<union> X2) \<inter> Rxa = {}", simp add: sameOH_def, fast)
                          apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE, erule impE,safe)
                             apply (simp add: DOM_def)  apply fastsimp apply fastsimp 
                 apply (case_tac "xx=left")
                 (*xx=left*) apply clarsimp 
                     apply (subgoal_tac "Rxx=X1 \<and> Sxx=k*n1", clarsimp) 
                     prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved) apply (simp add: GETr_def) apply (erule regTree, simp) 
                              apply (simp add: sameOH_def) apply fast
                     apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE, erule impE,safe)
                             apply (simp add: DOM_def) apply fastsimp apply fastsimp 
                     apply fast
                   (*xx\<noteq>left*) apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp) 
                     apply (subgoal_tac "\<exists> Rxb Sxb . (RVal (renv E xx), h, GETr C xx, Rxb, Sxb):reg", clarsimp) 
                     prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=xx in allE, erule impE, safe) 
                              apply (simp add: DOM_def)
                     apply (subgoal_tac "Rxx=Rxb \<and> Sxx=Sxb", clarsimp) 
                     prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption) apply (simp add: sameOH_def) 
                     apply (erule_tac x=t in allE, erule_tac x=xx in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxb in allE, erule impE,safe)
                             apply (simp add: DOM_def) apply fastsimp apply fastsimp
                     apply fast
                     apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=Rxa in allE, erule_tac x=Rxb in allE, erule impE,safe)
                             apply (simp add: DOM_def) apply (simp add: DOM_def) apply fastsimp apply fastsimp
                     apply fast
                     apply (rule GETr_Update1, fast) 
        apply (simp add: distinctFrom_def, clarsimp)
             apply (subgoal_tac "x \<noteq> right") prefer 2 apply fast
             apply (case_tac "x=left")
             (*x=left*) apply clarsimp 
                apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = Some (TreeET k)", clarsimp)
                apply (erule_tac x=t in allE, erule impE, clarsimp) 
                apply (erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE, clarsimp) apply fast
                apply (subgoal_tac "Rx=X1 \<and> Sx=k*n1", clarsimp) apply fast
                apply (erule reg_Unique) apply (rule reg_Preserved) apply (rule regTree, simp) apply simp
                        apply clarsimp apply (simp add: sameOH_def) apply fast
                apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", clarsimp)
                apply (simp add: GETr_def) 
                apply (rule GETr_Update1,fast)  
              (*x\<noteq>left*)
                 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp)
                 apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
                 apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), h, GETr C x, RR, SS) \<in> reg", clarsimp)
                 prefer 2 apply (simp add: regionsExist_def) 
                 apply (subgoal_tac "insert aa (X1 \<union> X2) \<inter> RR = {}")
                 prefer 2 apply (simp add: regionsDistinct_def) 
                 apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE,
                        erule_tac x=RR in allE,erule impE,clarsimp,fastsimp) 
                 apply fast
                 apply (subgoal_tac "Rx=RR \<and> Sx=SS", clarsimp)
                 prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                         apply clarsimp apply (subgoal_tac "l \<noteq> aa", simp add: sameOH_def) apply fast
                 apply (erule_tac x=x in allE, erule impE, clarsimp) apply fastsimp
                 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
                 apply (rule GETr_Update1, fast) 
                 apply (rule GETr_Update1,fast)  
        apply (erule ContextSizeCONS)
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) left = GETr (C(left\<mapsto>\<^sub>fTreeET k)) left", clarsimp)
          prefer 2 apply (rule GETr_Update1,fast)  
          apply (simp add: GETr_def)
          apply (rule reg_Preserved) apply (erule regTree, simp) apply (simp add: sameOH_def, fast)
          apply (subgoal_tac "U- {left} = U-{left,right}", clarsimp) prefer 2 apply fast
          apply (rule SizePreserved_h_h1)
          apply (erule ContextSizePreservedU) apply simp
            apply (rule GETr_Update2) apply (erule GETr_Update2, fastsimp, fastsimp) 
          apply (subgoal_tac "l\<noteq>aa", simp add: sameOH_def)
          apply clarsimp
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp)
          prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
                   apply (rule GETr_Update1,fast) apply (rule GETr_Update1, fast)
          apply (simp add: regionsDistinct_def) 
          apply (erule_tac x=x in allE, erule_tac x=t in allE, erule_tac x=R in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE, safe)
            apply (erule reg_DOM) 
            apply fastsimp
            apply fastsimp
            apply fast
          apply simp
          apply (subgoal_tac "n + k + (k * n1 + n2) + q \<le> n + (k + k * (n1 + n2a) + n2) + q", arith, clarsimp)
      apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)  
        apply (simp add: modified_def, clarsimp)  apply (rotate_tac -7, erule thin_rl, erule thin_rl)
          apply (erule_tac x=l in allE, erule impE,clarsimp)
          apply rule apply (erule_tac x=t in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, clarsimp)
          apply clarsimp 
          apply (subgoal_tac "z \<noteq> right") prefer 2 apply fast
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) z = GETr (C(left\<mapsto>\<^sub>fTreeET k)) z", clarsimp)
          prefer 2 apply (rule GETr_Update1, fast)
          apply (case_tac "z=left")
          (*z=left*) apply clarsimp
            apply (subgoal_tac "l \<notin> insert aa (X1 \<union> X2)") 
            prefer 2 apply (erule_tac x=t in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE,fastsimp) 
                     apply assumption
            apply (subgoal_tac "Rz=X1 \<and> Sz = k*n1", fast)
            apply (erule reg_Unique) apply (rule reg_Preserved) apply (simp add: GETr_def) apply (rule regTree, simp) apply simp
              apply clarsimp apply (simp add: sameOH_def, fast)
          (*z\<noteq>left*) 
             apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) z = GETr C z", clarsimp)
             prefer 2 apply (rule GETr_Update1, fast)
             apply (subgoal_tac "z:DOM C") prefer 2 apply (simp add: DOM_def)
             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E z), h, GETr C z,RR,SS):reg", clarsimp) 
             prefer 2 apply (simp add: regionsExist_def) 
             apply (subgoal_tac "l \<notin> RR") prefer 2 apply (erule_tac x=z in allE, erule_tac x=RR in allE, fastsimp)
             apply (subgoal_tac "Rz=RR \<and> Sz = SS", fast)
             apply (rule reg_Unique, assumption) apply (rule reg_Preserved, assumption) 
             apply (subgoal_tac "la \<noteq> aa", simp add: sameOH_def) 
             apply (simp add: regionsDistinct_def)
                apply (erule_tac x=t in allE, erule_tac x=z in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, 
                       erule_tac x=RR in allE,erule impE,clarsimp, fast)
                  apply fast
             apply (subgoal_tac "l \<noteq> aa", simp add: sameOH_def, safe) 
               apply (erule_tac x=rfield in allE) apply (case_tac "rfield = DOLLAR_N", clarsimp, clarsimp)
               apply (erule_tac x=t in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE, clarsimp) apply fastsimp apply fast 
        apply (simp add: Bounded_def,rule, rule) apply (erule_tac x=l in allE, erule impE, simp) 
          apply (rotate_tac -5, erule thin_rl) 
          apply (erule disjE) apply (rule disjI2) 
            apply (rule_tac x=t in exI, simp)
            apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, rule_tac x=" k + k * (n1 + n2a)" in exI, assumption+) apply fast
          apply (erule disjE,simp)
            apply (rule disjI2)
            apply clarsimp
            apply (subgoal_tac "x\<noteq> right") prefer 2 apply fast
            apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
            apply (case_tac "x=left")
            (*x=left*) apply clarsimp
                apply (rule_tac x=t in exI, clarsimp)  
                apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, fast)   
                apply (subgoal_tac "Rx=X1 \<and> Sx = k*n1", fast)
                apply (erule reg_Unique) apply (simp add: GETr_def) apply (rule reg_Preserved) apply (erule regTree, simp)
                apply (simp add: sameOH_def, fast)
            (*x\<noteq>left*) apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
                apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
                apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, clarsimp)
                apply (subgoal_tac "Rx=Rxa \<and> Sx = Sxa", fast)
                apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
                apply clarsimp apply (subgoal_tac "la \<noteq> aa", simp add: sameOH_def) 
                apply (simp add: regionsDistinct_def)
                apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE,
                          erule impE,clarsimp, fast)
                apply fast
                apply (rule GETr_Update1, fast)
              apply (rule GETr_Update1, fast)
        apply (simp add: Bounded_def,rule, rule) apply (erule_tac x=l in allE, erule impE, simp) 
          apply (rotate_tac -5, erule thin_rl) 
          apply (erule disjE) apply (rule disjI2) 
            apply (rule_tac x=t in exI, simp)
            apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, rule_tac x=" k + k * (n1 + n2a)" in exI, assumption+) apply fast
          apply (erule disjE,simp)
            apply (rule disjI2)
            apply clarsimp
            apply (subgoal_tac "x\<noteq> right") prefer 2 apply fast
            apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
            apply (case_tac "x=left")
            (*x=left*) apply clarsimp
                apply (rule_tac x=t in exI, clarsimp)  
                apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, fast)   
                apply (subgoal_tac "Rx=X1 \<and> Sx = k*n1", fast)
                apply (erule reg_Unique) apply (simp add: GETr_def) apply (rule reg_Preserved) apply (erule regTree, simp)
                apply (simp add: sameOH_def, fast)
            (*x\<noteq>left*) apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
                apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
                apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, clarsimp)
                apply (subgoal_tac "Rx=Rxa \<and> Sx = Sxa", fast)
                apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
                apply clarsimp apply (subgoal_tac "la \<noteq> aa", simp add: sameOH_def) 
                apply (simp add: regionsDistinct_def)
                apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE,
                          erule impE,clarsimp, fast)
                apply fast
                apply (rule GETr_Update1, fast)
              apply (rule GETr_Update1, fast)
  (*case left \<noteq>U*)
    apply (case_tac "right:U")
    (*case right :U*) 
      apply (rule reg.elims, assumption, clarsimp+)
      apply (erule mTREE.elims, clarsimp+)
      apply (erule_tac x=q in allE, erule_tac x="k * n2a + n2" in allE, erule_tac x="F \<union> {aa}" in allE, erule impE, safe)
      apply (subgoal_tac "aa \<notin> F") prefer 2 apply (simp add: distinctFrom_def)
      apply (rule_tac x="Suc N" in exI, safe)
        apply (simp add: freelist_def) 
        apply (subgoal_tac "(Suc N, Ref aa, F \<union> {aa}, h
           \<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(aa := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
              sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref aa))\<rparr>)
          \<in> FL", simp)
        apply(rule FL_SUC) apply simp+ apply (erule FL_UpdateOutside) apply assumption
        apply (simp add: regionsExist_def, clarsimp)
          apply (subgoal_tac "left \<noteq> x") prefer 2 apply fast
          apply (case_tac "x=right")
          (*x = right*) apply clarsimp
                apply (rule, rule, rule reg_Preserved) 
                apply (simp add: GETr_def) apply (erule regTree, simp) apply (simp add: sameOH_def,fast)
          (*x \<noteq> right*) apply clarsimp 
              apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
              apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def) apply (erule disjE, clarsimp, clarsimp)
              apply (erule_tac x=x in allE, erule impE, clarsimp) apply clarsimp
              apply (rule, rule, rule reg_Preserved, assumption) 
              apply (subgoal_tac "l \<noteq> aa", simp add: sameOH_def) 
              apply (subgoal_tac "insert aa (X1 \<union> X2) \<inter> Rx = {}",fast)
              apply (simp add: regionsDistinct_def) 
              apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rx in allE, erule impE, clarsimp) 
              apply (rule, simp add: DOM_def) apply fastsimp apply fast
              apply fast 
              apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
              apply (rule GETr_Update1, fast) 
              apply (rule GETr_Update1, fast) 
        apply (simp add: regionsDistinct_def, clarsimp)
          apply (subgoal_tac "x \<noteq> left") prefer 2 apply fast
          apply (subgoal_tac "xx \<noteq> left") prefer 2 apply fast
          apply (case_tac "x=right")
          (*x=right*) apply clarsimp 
            apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) right = Some (TreeET k)", clarsimp) 
               prefer 2 apply (simp add: GETr_def) 
            apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp) 
               prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx", clarsimp) 
                        apply (rule GETr_Update1,fast) apply (rule GETr_Update1,fast) 
                 apply (subgoal_tac "Rx=X2 \<and> Sx=k*n2a", clarsimp) prefer 2 apply (erule reg_Unique) apply (simp add: GETr_def) 
                 apply (rule reg_Preserved) apply (erule regTree) apply simp apply (simp add: sameOH_def) apply fast 
                 apply (simp add: regionsExist_def) apply (erule_tac x=xx in allE, erule impE, safe)
                   apply (simp add: DOM_def) apply (erule disjE, clarsimp, clarsimp)
                 apply (erule_tac x=t in allE, erule_tac x=xx in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, 
                                     erule_tac x=Rx in allE, erule impE, safe) apply (simp add: DOM_def) apply (erule disjE,simp+)
                   apply fastsimp apply fastsimp
                 apply (subgoal_tac "Rxx=Rx \<and> Sxx=Sx", clarsimp) apply fast
                 apply (erule reg_Unique) apply (erule reg_Preserved) apply (simp add: sameOH_def) apply fast
          (*x \<noteq> left*)
                 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
                 prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
                          apply (rule GETr_Update1,fast) apply (rule GETr_Update1,fast)
                 apply (subgoal_tac "\<exists> Rxa Sxa . (RVal (renv E x), h, GETr C x, Rxa, Sxa):reg", clarsimp) 
                 prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, erule impE, safe) apply (simp add: DOM_def)
                 apply (subgoal_tac "Rx=Rxa \<and> Sx=Sxa", clarsimp) 
                 prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                          apply (subgoal_tac "insert aa (X1 \<union> X2) \<inter> Rxa = {}", simp add: sameOH_def, fast)
                          apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE, erule impE,safe)
                             apply (simp add: DOM_def)  apply fastsimp apply fastsimp 
                 apply (case_tac "xx=right")
                 (*xx=right*) apply clarsimp 
                     apply (subgoal_tac "Rxx=X2 \<and> Sxx=k*n2a", clarsimp) 
                     prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved) apply (simp add: GETr_def) apply (erule regTree, simp) 
                              apply (simp add: sameOH_def) apply fast
                     apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE, erule impE,safe)
                             apply (simp add: DOM_def) apply fastsimp apply fastsimp 
                     apply fast
                 (*xx\<noteq>right*) apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp) 
                     prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx", clarsimp) 
                              apply (rule GETr_Update1,fast) apply (rule GETr_Update1,fast) 
                     apply (subgoal_tac "\<exists> Rxb Sxb . (RVal (renv E xx), h, GETr C xx, Rxb, Sxb):reg", clarsimp) 
                     prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=xx in allE, erule impE, safe) 
                              apply (simp add: DOM_def)
                     apply (subgoal_tac "Rxx=Rxb \<and> Sxx=Sxb", clarsimp) 
                     prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption) apply (simp add: sameOH_def) 
                     apply (erule_tac x=t in allE, erule_tac x=xx in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxb in allE, erule impE,safe)
                             apply (simp add: DOM_def) apply fastsimp apply fastsimp
                     apply fast
                     apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=Rxa in allE, erule_tac x=Rxb in allE, erule impE,safe)
                             apply (simp add: DOM_def) apply (simp add: DOM_def) apply fastsimp apply fastsimp
                     apply fast
        apply (simp add: distinctFrom_def, clarsimp)
             apply (subgoal_tac "x \<noteq> left") prefer 2 apply fast
             apply (case_tac "x=right")
             (*x=right*) apply clarsimp 
                apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) right = Some (TreeET k)", clarsimp)
                apply (erule_tac x=t in allE, erule impE, clarsimp) 
                apply (erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE, clarsimp) apply fast
                apply (subgoal_tac "Rx=X2 \<and> Sx=k*n2a", clarsimp) apply fast
                apply (erule reg_Unique) apply (rule reg_Preserved) apply (rule regTree, simp) apply simp
                        apply clarsimp apply (simp add: sameOH_def) apply fast
                apply (simp add: GETr_def) 
              (*x\<noteq>rightt*)
                 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp)
                 apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
                 apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), h, GETr C x, RR, SS) \<in> reg", clarsimp)
                 prefer 2 apply (simp add: regionsExist_def) 
                 apply (subgoal_tac "insert aa (X1 \<union> X2) \<inter> RR = {}")
                 prefer 2 apply (simp add: regionsDistinct_def) 
                 apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE,
                        erule_tac x=RR in allE,erule impE,clarsimp,fastsimp) 
                 apply fast
                 apply (subgoal_tac "Rx=RR \<and> Sx=SS", clarsimp)
                 prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                         apply clarsimp apply (subgoal_tac "l \<noteq> aa", simp add: sameOH_def) apply fast
                 apply (erule_tac x=x in allE, erule impE, clarsimp) apply fastsimp
                 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
                 apply (rule GETr_Update1, fast) 
                 apply (rule GETr_Update1,fast)  
        apply (erule ContextSizeCONS)
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) right = Some (TreeET k)", clarsimp)
          prefer 2 apply (simp add: GETr_def)
          apply (rule reg_Preserved) apply (erule regTree, simp) apply (simp add: sameOH_def, fast)
          apply (rule SizePreserved_h_h1)
          apply (erule ContextSizePreservedU) 
          apply (subgoal_tac "x \<noteq> left", clarsimp) apply fast 
            apply (rule GETr_Update2) apply (erule GETr_Update2, fastsimp, fastsimp) 
          apply (subgoal_tac "x \<noteq> left") prefer 2 apply fast
          apply (subgoal_tac "l\<noteq>aa", simp add: sameOH_def) 
          apply clarsimp
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp)
          prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
                   apply (rule GETr_Update1,fast) apply (rule GETr_Update1, fast)
          apply (simp add: regionsDistinct_def) 
          apply (erule_tac x=x in allE, erule_tac x=t in allE, erule_tac x=R in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE, safe)
            apply (erule reg_DOM) 
            apply fastsimp
            apply fastsimp
            apply fast
          apply simp
          apply (subgoal_tac "n + k + (k * n2a + n2) + q \<le> n + (k + k * (n1 + n2a) + n2) + q", arith, clarsimp)
      apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)  
        apply (simp add: modified_def, clarsimp)  apply (rotate_tac -7, erule thin_rl, erule thin_rl)
          apply (erule_tac x=l in allE, erule impE,clarsimp)
          apply rule apply (erule_tac x=t in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, clarsimp)
          apply clarsimp 
          apply (subgoal_tac "z \<noteq> left") prefer 2 apply fast
          apply (case_tac "z=right")
          (*z=right*) apply clarsimp
            apply (subgoal_tac "l \<notin> insert aa (X1 \<union> X2)") 
            prefer 2 apply (erule_tac x=t in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE,fastsimp) 
                     apply assumption
            apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) right = Some (TreeET k)", clarsimp)
            prefer 2 apply (simp add: GETr_def)
            apply (subgoal_tac "Rz=X2 \<and> Sz = k*n2a", fast)
            apply (erule reg_Unique) apply (rule reg_Preserved) apply (simp add: GETr_def) apply (rule regTree, simp) apply simp
              apply clarsimp apply (simp add: sameOH_def, fast)
          (*z\<noteq>right*) 
             apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) z = GETr C z", clarsimp)
             prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) z = GETr (C(left\<mapsto>\<^sub>fTreeET k)) z", clarsimp) 
                      apply (rule GETr_Update1, fast) apply (rule GETr_Update1, fast)
             apply (subgoal_tac "z:DOM C") prefer 2 apply (simp add: DOM_def)
             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E z), h, GETr C z,RR,SS):reg", clarsimp) 
             prefer 2 apply (simp add: regionsExist_def) 
             apply (subgoal_tac "l \<notin> RR") prefer 2 apply (erule_tac x=z in allE, erule_tac x=RR in allE, fastsimp)
             apply (subgoal_tac "Rz=RR \<and> Sz = SS", fast)
             apply (rule reg_Unique, assumption) apply (rule reg_Preserved, assumption) 
             apply (subgoal_tac "la \<noteq> aa", simp add: sameOH_def) 
             apply (simp add: regionsDistinct_def)
                apply (erule_tac x=t in allE, erule_tac x=z in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, 
                       erule_tac x=RR in allE,erule impE,clarsimp, fast)
                  apply fast
             apply (subgoal_tac "l \<noteq> aa", simp add: sameOH_def, safe) 
               apply (erule_tac x=rfield in allE) apply (case_tac "rfield = DOLLAR_N", clarsimp, clarsimp)
               apply (erule_tac x=t in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE, clarsimp) apply fastsimp apply fast 
        apply (simp add: Bounded_def,rule, rule) apply (erule_tac x=l in allE, erule impE, simp) 
          apply (rotate_tac -5, erule thin_rl) 
          apply (erule disjE) apply (rule disjI2) 
            apply (rule_tac x=t in exI, simp)
            apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, rule_tac x=" k + k * (n1 + n2a)" in exI, assumption+) apply fast
          apply (erule disjE,simp)
            apply (rule disjI2)
            apply clarsimp
            apply (subgoal_tac "x\<noteq> left") prefer 2 apply fast
            apply (case_tac "x=right")
            (*x=right*) apply clarsimp
                apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) right = Some (TreeET k)", clarsimp) 
                apply (rule_tac x=t in exI, clarsimp)  
                apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, fast)   
                apply (subgoal_tac "Rx=X2 \<and> Sx = k*n2a", fast)
                apply (erule reg_Unique) apply (simp add: GETr_def) apply (rule reg_Preserved) apply (erule regTree, simp)
                apply (simp add: sameOH_def, fast)
                apply (simp add: GETr_def)
            (*x\<noteq>right*) apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
                prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
                         apply (rule GETr_Update1,fast) apply (rule GETr_Update1, fast)
                apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
                apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, clarsimp)
                apply (subgoal_tac "Rx=Rxa \<and> Sx = Sxa", fast)
                apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
                apply clarsimp apply (subgoal_tac "la \<noteq> aa", simp add: sameOH_def) 
                apply (simp add: regionsDistinct_def)
                apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE,
                          erule impE,clarsimp, fast)
                apply fast
        apply (simp add: Bounded_def,rule, rule) apply (erule_tac x=l in allE, erule impE, simp) 
          apply (rotate_tac -5, erule thin_rl) 
          apply (erule disjE) apply (rule disjI2) 
            apply (rule_tac x=t in exI, simp)
            apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, rule_tac x=" k + k * (n1 + n2a)" in exI, assumption+) apply fast
          apply (erule disjE,simp)
            apply (rule disjI2)
            apply clarsimp
            apply (subgoal_tac "x\<noteq> left") prefer 2 apply fast
            apply (case_tac "x=right")
            (*x=right*) apply clarsimp
                apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) right = Some (TreeET k)", clarsimp) 
                apply (rule_tac x=t in exI, clarsimp)  
                apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, fast)   
                apply (subgoal_tac "Rx=X2 \<and> Sx = k*n2a", fast)
                apply (erule reg_Unique) apply (simp add: GETr_def) apply (rule reg_Preserved) apply (erule regTree, simp)
                apply (simp add: sameOH_def, fast)
                apply (simp add: GETr_def)
            (*x\<noteq>right*) apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
                prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
                         apply (rule GETr_Update1,fast) apply (rule GETr_Update1, fast)
                apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
                apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, clarsimp)
                apply (subgoal_tac "Rx=Rxa \<and> Sx = Sxa", fast)
                apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
                apply clarsimp apply (subgoal_tac "la \<noteq> aa", simp add: sameOH_def) 
                apply (simp add: regionsDistinct_def)
                apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE,
                          erule impE,clarsimp, fast)
                apply fast
    (*case right \<noteq>U*) 
      apply (rule reg.elims, assumption, clarsimp+)
      apply (erule mTREE.elims, clarsimp+)
      apply (erule_tac x=q in allE, erule_tac x=n2 in allE, erule_tac x="F \<union> {aa}" in allE, erule impE, safe)
      apply (subgoal_tac "aa \<notin> F") prefer 2 apply (simp add: distinctFrom_def)
      apply (rule_tac x="Suc N" in exI, safe)
        apply (simp add: freelist_def) 
        apply (subgoal_tac "(Suc N, Ref aa, F \<union> {aa}, h
           \<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(aa := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
              sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref aa))\<rparr>)
          \<in> FL", simp)
        apply(rule FL_SUC) apply simp+ apply (erule FL_UpdateOutside) apply assumption
        apply (simp add: regionsExist_def, clarsimp)
          apply (subgoal_tac "left \<noteq> x") prefer 2 apply fast
          apply (subgoal_tac "right \<noteq> x") prefer 2 apply fast
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
          apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def) apply (erule disjE, clarsimp, clarsimp)
          apply (erule_tac x=x in allE, erule impE, clarsimp) apply clarsimp
          apply (rule, rule, rule reg_Preserved, assumption) 
          apply (subgoal_tac "l \<noteq> aa", simp add: sameOH_def) 
          apply (subgoal_tac "insert aa (X1 \<union> X2) \<inter> Rx = {}",fast)
          apply (simp add: regionsDistinct_def) 
          apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rx in allE, erule impE, clarsimp) 
          apply (rule, simp add: DOM_def) apply fastsimp apply fast
          apply fast 
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
            apply (rule GETr_Update1, fast) apply (rule GETr_Update1, fast) 
        apply (simp add: regionsDistinct_def, clarsimp)
          apply (subgoal_tac "x \<noteq> left") prefer 2 apply fast
          apply (subgoal_tac "xx \<noteq> left") prefer 2 apply fast
          apply (subgoal_tac "x \<noteq> right") prefer 2 apply fast
          apply (subgoal_tac "xx \<noteq> right") prefer 2 apply fast
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
          prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
                    apply (rule GETr_Update1,fast) apply (rule GETr_Update1,fast)
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr C xx", clarsimp) 
          prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) xx = GETr (C(left\<mapsto>\<^sub>fTreeET k)) xx", clarsimp) 
                    apply (rule GETr_Update1,fast) apply (rule GETr_Update1,fast)
          apply (subgoal_tac "\<exists> Rxa Sxa . (RVal (renv E x), h, GETr C x, Rxa, Sxa):reg", clarsimp) 
          prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, erule impE, safe) apply (simp add: DOM_def)
          apply (subgoal_tac "\<exists> Rxb Sxb . (RVal (renv E xx), h, GETr C xx, Rxb, Sxb):reg", clarsimp) 
          prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=xx in allE, erule impE, safe) apply (simp add: DOM_def)
          apply (subgoal_tac "Rx=Rxa \<and> Sx=Sxa", clarsimp) 
          prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                   apply (subgoal_tac "insert aa (X1 \<union> X2) \<inter> Rxa = {}", simp add: sameOH_def, fast)
                   apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE, erule impE,safe)
                      apply (simp add: DOM_def)  apply fastsimp apply fastsimp 
          apply (subgoal_tac "Rxx=Rxb \<and> Sxx=Sxb", clarsimp) 
          prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                   apply (subgoal_tac "insert aa (X1 \<union> X2) \<inter> Rxb = {}", simp add: sameOH_def, fast)
                   apply (erule_tac x=t in allE, erule_tac x=xx in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxb in allE, erule impE,safe)
                      apply (simp add: DOM_def)  apply fastsimp apply fastsimp 
          apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=Rxa in allE, erule_tac x=Rxb in allE, erule impE,safe)
            apply (simp add: DOM_def) apply (simp add: DOM_def) apply fastsimp apply fastsimp apply fast
        apply (simp add: distinctFrom_def, clarsimp)
             apply (subgoal_tac "x \<noteq> left") prefer 2 apply fast
             apply (subgoal_tac "x \<noteq> right") prefer 2 apply fast
             apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp)
             apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), h, GETr C x, RR, SS) \<in> reg", clarsimp)
             prefer 2 apply (simp add: regionsExist_def) 
             apply (subgoal_tac "insert aa (X1 \<union> X2) \<inter> RR = {}")
             prefer 2 apply (simp add: regionsDistinct_def) 
             apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE,
                        erule_tac x=RR in allE,erule impE,clarsimp,fastsimp)
             apply fast
             apply (subgoal_tac "Rx=RR \<and> Sx=SS", clarsimp)
             prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                      apply clarsimp apply (subgoal_tac "l \<noteq> aa", simp add: sameOH_def) apply fast
             apply (erule_tac x=x in allE, erule impE, clarsimp) apply fastsimp
             apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp) 
                 apply (rule GETr_Update1, fast) 
                 apply (rule GETr_Update1,fast)
        apply (rule SizePreserved_h_h1)
          apply (erule ContextSizePreservedU)
          apply (subgoal_tac "x \<noteq> left") prefer 2 apply fast apply (subgoal_tac "x \<noteq> right") prefer 2 apply fast apply clarsimp
          apply (rule GETr_Update2) apply (erule GETr_Update2, fastsimp, fastsimp) 
          apply (subgoal_tac "x \<noteq> left") prefer 2 apply fast
          apply (subgoal_tac "x \<noteq> right") prefer 2 apply fast
          apply (subgoal_tac "l\<noteq>aa", simp add: sameOH_def) 
          apply clarsimp
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp)
          prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
                   apply (rule GETr_Update1,fast) apply (rule GETr_Update1, fast)
          apply (simp add: regionsDistinct_def) 
          apply (erule_tac x=x in allE, erule_tac x=t in allE, erule_tac x=R in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE, safe)
            apply (erule reg_DOM) 
            apply fastsimp
            apply fastsimp
            apply fast
          apply simp
      apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)  
        apply (simp add: modified_def, clarsimp)  apply (rotate_tac -7, erule thin_rl, erule thin_rl)
          apply (erule_tac x=l in allE, erule impE,clarsimp)
          apply rule apply (erule_tac x=t in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, clarsimp)
          apply clarsimp 
          apply (subgoal_tac "z \<noteq> left") prefer 2 apply fast
          apply (subgoal_tac "z \<noteq> right") prefer 2 apply fast
          apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) z = GETr C z", clarsimp)
          prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) z = GETr (C(left\<mapsto>\<^sub>fTreeET k)) z", clarsimp) 
                   apply (rule GETr_Update1, fast) apply (rule GETr_Update1, fast)
          apply (subgoal_tac "z:DOM C") prefer 2 apply (simp add: DOM_def)
          apply (subgoal_tac "\<exists> RR SS . (RVal (renv E z), h, GETr C z,RR,SS):reg", clarsimp) 
          prefer 2 apply (simp add: regionsExist_def) 
          apply (subgoal_tac "l \<notin> RR") prefer 2 apply (erule_tac x=z in allE, erule_tac x=RR in allE, fastsimp)
          apply (subgoal_tac "Rz=RR \<and> Sz = SS", fast)
          apply (rule reg_Unique, assumption) apply (rule reg_Preserved, assumption) 
          apply (subgoal_tac "la \<noteq> aa", simp add: sameOH_def) 
          apply (simp add: regionsDistinct_def)
                apply (erule_tac x=t in allE, erule_tac x=z in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, 
                       erule_tac x=RR in allE,erule impE,clarsimp, fast)
                  apply fast
             apply (subgoal_tac "l \<noteq> aa", simp add: sameOH_def, safe) 
               apply (erule_tac x=rfield in allE) apply (case_tac "rfield = DOLLAR_N", clarsimp, clarsimp)
               apply (erule_tac x=t in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule impE, clarsimp) apply fastsimp apply fast 
        apply (simp add: Bounded_def,rule, rule) apply (erule_tac x=l in allE, erule impE, simp) 
          apply (rotate_tac -5, erule thin_rl) 
          apply (erule disjE) apply (rule disjI2) 
            apply (rule_tac x=t in exI, simp)
            apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, rule_tac x=" k + k * (n1 + n2a)" in exI, assumption+) apply fast
          apply (erule disjE,simp)
            apply (rule disjI2)
            apply clarsimp
            apply (subgoal_tac "x\<noteq> left") prefer 2 apply fast
            apply (subgoal_tac "x\<noteq> right") prefer 2 apply fast
            apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
            prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
                     apply (rule GETr_Update1,fast) apply (rule GETr_Update1, fast)
            apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
            apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, clarsimp)
            apply (subgoal_tac "Rx=Rxa \<and> Sx = Sxa", fast)
            apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
            apply clarsimp apply (subgoal_tac "la \<noteq> aa", simp add: sameOH_def) 
            apply (simp add: regionsDistinct_def)
            apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE,
                          erule impE,clarsimp, fast)
            apply fast
        apply (simp add: Bounded_def,rule, rule) apply (erule_tac x=l in allE, erule impE, simp) 
          apply (rotate_tac -5, erule thin_rl) 
          apply (erule disjE) apply (rule disjI2) 
            apply (rule_tac x=t in exI, simp)
            apply (rule_tac x="insert aa (X1 \<union> X2)" in exI, rule, rule_tac x=" k + k * (n1 + n2a)" in exI, assumption+) apply fast
          apply (erule disjE,simp)
            apply (rule disjI2)
            apply clarsimp
            apply (subgoal_tac "x\<noteq> left") prefer 2 apply fast
            apply (subgoal_tac "x\<noteq> right") prefer 2 apply fast
            apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr C x", clarsimp) 
            prefer 2 apply (subgoal_tac "GETr (C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k)) x = GETr (C(left\<mapsto>\<^sub>fTreeET k)) x", clarsimp)
                     apply (rule GETr_Update1,fast) apply (rule GETr_Update1, fast)
            apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
            apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, clarsimp)
            apply (subgoal_tac "Rx=Rxa \<and> Sx = Sxa", fast)
            apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
            apply clarsimp apply (subgoal_tac "la \<noteq> aa", simp add: sameOH_def) 
            apply (simp add: regionsDistinct_def)
            apply (erule_tac x=t in allE, erule_tac x=x in allE, erule_tac x="insert aa (X1 \<union> X2)" in allE, erule_tac x=Rxa in allE,
                          erule impE,clarsimp, fast)
            apply fast
done
(*>*)

lemma DA_MakeTree:
"\<lbrakk>GETr C y = Some T; T = (TreeET k);GETr C z = Some TT; TT = (TreeET k);y\<noteq>z;n=(Suc m + k)\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg x, RNarg y, RNarg z])) :  DAss {y,z} n C T m"
(*<*)
apply (rule vdm_invokestatic, simp) 
apply (rule CtxtWeakSingleton)
apply (simp add: Meth_Make_IIDD DAss_def, clarsimp)
apply (rule vdm_conseq, rule vdm_letr)
apply (rule DA_Alloc)
apply (rule DA_Fill_DIIDD)
apply clarsimp
apply (simp add: newObj_def newframe_env_def evalARGS_def self_def)
apply (subgoal_tac "y:DOM C") prefer 2 apply (erule GETrSome_DOM)
apply (subgoal_tac "z:DOM C") prefer 2 apply (erule GETrSome_DOM)
apply (case_tac "h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>")
(*h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Nullref*) apply clarsimp
  apply (simp add: freelist_def)
  apply (erule FL.elims, clarsimp)
  apply clarsimp
(*h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<noteq> Nullref*) 
  apply clarsimp
  apply (simp add: freelist_def)
  apply (erule FL.elims, clarify, clarsimp)
  apply (subgoal_tac "\<exists>Rx Sx. (RVal (renv E' y), ha, GETr C y, Rx, Sx) \<in> reg", clarsimp)
  prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=y in allE, clarsimp)
  apply (subgoal_tac "\<exists>Rx Sx. (RVal (renv E' z), ha, GETr C z, Rx, Sx) \<in> reg", clarsimp)
  prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=z in allE, clarsimp)
  apply (rule_tac x="Rx \<union> Rxa \<union> {a}" in exI, rule_tac x="Sx+Sxa+k" in exI, rule_tac x=n in exI, rule_tac x="X" in exI, clarsimp)
  apply (rule, erule FL_Preserved) apply (simp add: sameOH_def) 
  apply rule apply (subgoal_tac "a \<notin> Rx \<and> Rx \<inter> X = {}") prefer 2 apply (simp add: distinctFrom_def) apply (erule_tac x=y in allE, clarsimp) 
                                                                   apply (erule_tac x=Rx in allE,erule impE,fast) apply assumption
             apply (subgoal_tac "a \<notin> Rxa \<and> Rxa \<inter> X = {}") prefer 2 apply (simp add: distinctFrom_def) apply (erule_tac x=z in allE, clarsimp) 
                                                                   apply (erule_tac x=Rxa in allE,erule impE,fast) apply assumption
    apply (erule reg.elims, simp_all, clarsimp) 
    apply (erule reg.elims, simp_all, clarsimp) 
    apply (rule regTree) 
    apply (rule mTREE_NODE) apply simp apply simp apply simp 
                            prefer 2 apply (erule mTREE_Preserved) apply (subgoal_tac "l \<noteq> a", simp add: sameOH_def,fast) apply (simp, simp)
                            prefer 2 apply (erule mTREE_Preserved) apply (subgoal_tac "l \<noteq> a", simp add: sameOH_def,fast) apply simp
                            apply (simp add: regionsDistinct_def) 
                              apply (erule_tac x=y in allE, erule_tac x=z in allE, erule_tac x=R in allE, erule_tac x=Ra in allE, erule impE, clarsimp)
                              apply (rule, rule, erule regTree, simp) apply(rule, erule regTree, simp)
                              apply assumption
                            apply simp
                            apply fast
                            apply clarsimp apply (simp add: Distr1)
   apply (rule, simp add: modified_def, clarsimp) apply (subgoal_tac "l \<noteq> a", simp add: sameOH_def,fast)
   apply rule apply (subgoal_tac "Rx \<inter> X = {} \<and> Rxa \<inter> X = {}", fast) 
              apply (rule, simp add: distinctFrom_def) apply (erule_tac x=y in allE,erule impE,clarsimp) 
                                                       apply (erule_tac x=Rx in allE,erule impE,clarsimp) apply fast apply clarsimp
                    apply (simp add: distinctFrom_def) apply (erule_tac x=z in allE,erule impE,clarsimp) 
                                                       apply (erule_tac x=Rxa in allE,erule impE,clarsimp) apply fast apply clarsimp
  apply (rule,simp add: Bounded_def,rule, rule) apply(rule, rule disjI2, rule disjI2) apply (rule_tac x=y in exI, fastsimp)
                                                apply(rule, rule disjI2, rule disjI2) apply (rule_tac x=z in exI, fastsimp)
  apply (rule,simp add: Bounded_def)
  apply (subgoal_tac "CS=Sx+Sxa", clarsimp)
  apply (erule ContextSize_Unique)
  apply (rule ContextSizeCONS) apply (subgoal_tac "y:{y,z}", assumption,fast) apply simp apply clarsimp
  apply (rule ContextSizeCONS) apply simp apply simp apply clarsimp 
  apply (rule ContextSizeNIL) apply simp+
done
lemma DA_makeTree: 
"\<lbrakk>GETr C y = Some T; T = (TreeET k);GETr C z = Some TT; TT = (TreeET k);y\<noteq>z;n=(Suc m + k);U={y,z}\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg x, RNarg y, RNarg z])) :  DAss U n C T m"
by (rule vdm_conseq, rule DA_MakeTree,auto)
(*>*)

(*<*)
end
(*>*)
