(*<*)
theory DAUA6 = NILList:
(*>*)

(* The lemma below should be somewhere before !!!*)

lemma same_heaps: "h=hh \<Longrightarrow> \<forall> l. sameOH {l} h hh"
apply (simp add: sameOH_def)
done


subsection {* Definition of derived assertions*}

subsubsection {* Types, contexts, regions, size of contexts*}



datatype Type = UnitET | IntET | ListET nat


(*>*)
text {*Region calculation*}
consts reg_ua :: "(val \<times> heap \<times> (Type option) \<times> bool \<times> (locn set) \<times> nat) set"
inductive reg_ua intros
regInt_ua:   "(IVal i ,h,Some IntET, p, {}, 0): reg_ua"
regUnit_ua:   "(v,h,Some UnitET, p, {}, 0): reg_ua"
regListNull_ua:  "(RVal Nullref, h, Some(ListET k), p, {}, 0) : reg_ua"
regListCons_ua: "\<lbrakk>h@@a = Some DIAM;
                h<a\<bullet>DOLLAR> \<noteq> 2;
                a \<notin> R1\<union>R2 ; 
                (IVal h<a\<bullet>F0>, h, Some IntET, p, R1, n1) : reg_ua;
                (RVal h\<lfloor>a\<diamondsuit>F1\<rfloor>, h,  Some(ListET k), p, R2, n2) : reg_ua;
                p \<longrightarrow> R1\<inter>R2={}\<rbrakk> \<Longrightarrow> 
                (RVal (Ref a), h, Some(ListET k), p, {a}\<union>R1\<union>R2 , k+n1+n2): reg_ua"



lemma region_ua_in_heap: "(v, h, T, p, R, m): reg_ua \<Longrightarrow> R \<subseteq> Dom h"
apply (erule reg_ua.induct)
apply simp+
apply (simp add: fmap_lookup_def fmap_dom_def)
apply best
done


lemma reg_ua_Preserved [rule_format]:
"(v,h,T, p, R,S):reg_ua \<Longrightarrow> 
  ((\<forall> l. l : R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (v,h1,T, p, R,S):reg_ua)"
apply (erule reg_ua.induct)
apply (rule impI) apply (rule regInt_ua) 
apply (rule impI) apply (rule regUnit_ua) 
apply (rule impI) apply (rule regListNull_ua)
apply (rule impI) apply (rule regListCons_ua)
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply assumption
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply assumption
done

lemma reg_ua_sameHeap:
"\<lbrakk>(v,h,T, p, R,S):reg_ua; sameOH R h h1\<rbrakk> \<Longrightarrow> (v,h1,T, p, R,S):reg_ua"
apply (rule reg_ua_Preserved)
apply assumption
apply (simp add: sameOH_def)
done

lemma reg_ua_sameHeapRegSubset:
"\<lbrakk>(v,h,T, p, R,S):reg_ua; sameOH R1 h h1; R \<subseteq> R1\<rbrakk> \<Longrightarrow> (v,h1,T, p, R,S):reg_ua"
apply (rule reg_ua_sameHeap)
apply assumption
apply (simp add: sameOH_def, fast)
done


lemma reg_ua_Int: "(Ival i, h, Some IntET, p, R, m): reg_ua \<Longrightarrow> R={} \<and> m=0"
apply (erule reg_ua.cases)
apply clarify+
done

lemma reg_ua_Unit: "(v, h, Some UnitET, p, R, m): reg_ua \<Longrightarrow> R={} \<and> m=0"
apply (erule reg_ua.cases)
apply clarify+
done

lemma reg_ua_Null: "(RVal Nullref, h, Some (ListET k), p, R, m): reg_ua \<Longrightarrow> R={} \<and> m=0"
apply (erule reg_ua.cases)
apply clarify+
done

lemma reg_ua_Cons:
"(RVal (Ref a), h, Some(ListET k), p, R, m): reg_ua \<Longrightarrow>
                h@@a = Some DIAM \<and>
                h<a\<bullet>DOLLAR> \<noteq> 2 \<and>
 (\<exists> R1 R2 n1 n2. 
                a \<notin> R1\<union>R2 \<and>
                (IVal h<a\<bullet>F0>, h, Some IntET, p, R1, n1) : reg_ua \<and>
                (RVal h\<lfloor>a\<diamondsuit>F1\<rfloor>, h,  Some(ListET k), p, R2, n2) : reg_ua \<and>
                (p \<longrightarrow> R1\<inter>R2={}) \<and>
                R={a}\<union>R1\<union>R2 \<and> 
                m=k+n1+n2)"
apply (erule reg_ua.cases)
apply clarify apply clarify apply clarify
apply (rule conjI) apply clarify
apply (rule conjI) apply clarify
apply (rule exI)+
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply clarify
apply (rule conjI) apply clarify
apply clarify
done


lemma reg_ua_Unique[rule_format]: 
"(v, h, T, p, R, S) : reg_ua \<Longrightarrow> ( \<forall> RR SS . (v, h, T, p, RR, SS) : reg_ua \<longrightarrow> (R=RR \<and> S=SS))"
apply (erule reg_ua.induct)

apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Int) apply simp
apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Unit )apply simp
apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Null )apply simp

apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Cons)
apply (erule conjE)+
apply (erule exE)+
apply (erule conjE)+
apply (rename_tac R1' R2' n1' n2')
apply (drule_tac x="R1'" in spec) 
apply (drule_tac x="R2'" in spec) 
apply (drule_tac x="n1'" in spec) 
apply (drule_tac x="n2'" in spec) 
apply safe
done

lemma reg_ua_UniqueReg:
"\<lbrakk>(v, h, T, p, R, S) : reg_ua; (v, h, T, p, RR, SS) : reg_ua\<rbrakk>  \<Longrightarrow> R=RR"
apply (drule  reg_ua_Unique)
apply assumption
apply (erule conjE) apply assumption
done

lemma reg_ua_UniqueNumber:
"\<lbrakk>(v, h, T, p, R, S) : reg_ua; (v, h, T, p, RR, SS) : reg_ua\<rbrakk>  \<Longrightarrow> S=SS"
apply (drule  reg_ua_Unique)
apply assumption
apply (erule conjE) apply assumption
done

lemma reg_ua_WeakFalse:
"(v, h, T, p, R, S) : reg_ua  \<Longrightarrow> (v, h, T, False, R, S) : reg_ua"
apply (erule reg_ua.induct)
apply (rule regInt_ua)
apply (rule regUnit_ua)
apply (rule regListNull_ua)
apply (rule regListCons_ua)
apply assumption
apply assumption
apply assumption
apply assumption
apply assumption
apply clarify
done

lemma reg_ua_WeakTrue:
"(v, h, T, True, R, S) : reg_ua  \<Longrightarrow> (v, h, T, p, R, S) : reg_ua"
apply (case_tac "p=True")
apply clarify
apply (subgoal_tac "p=False")
apply clarify
apply (rule reg_ua_WeakFalse)
apply assumption
apply simp
done

lemma reg_ua_notated [rule_format]:
"(v, h, T, p, R, S) : reg_ua \<Longrightarrow> 
\<forall> R' S' r. v = (RVal r) \<longrightarrow> T = Some (ListET k) \<longrightarrow>
(v, h,  Some (ListET k'), p, R', S') : reg_ua \<longrightarrow> R=R' "
apply  (erule reg_ua.induct)
apply simp
apply simp
apply clarsimp
apply (drule reg_ua_Null) 
apply simp

apply (rule allI)+
apply (rule impI)+
apply (rotate_tac 4)
apply (erule thin_rl)

apply (rotate_tac 5)
apply (erule reg_ua.cases)
apply (rotate_tac 9)
apply fast
apply (rotate_tac 9)
apply fast
apply (rotate_tac 9)
apply fast
apply (rename_tac R1' R2' a' h' k''' n1' n2' p')
apply (erule_tac x="R2'" in allE)
apply (erule_tac x="n2'" in allE)
apply (erule_tac x="h'\<lfloor>a'\<diamondsuit>F1\<rfloor>" in allE)
apply (rotate_tac 15)
apply (drule mp)
apply fast
apply (rotate_tac 15)
apply (drule mp)
apply fast
apply (rotate_tac 15)
apply (drule mp)
apply fast
apply (drule_tac v="IVal h<a\<bullet>F0>" in reg_ua_Unique)
apply fast
apply (erule conjE)+
apply fast
done

lemma reg_ua_Sum [rule_format]:
 " (v, h, T, p, R1, n1) : reg_ua \<Longrightarrow>
\<forall> r k1 k2 R2 n2.  v=(RVal r) \<longrightarrow> T=Some (ListET k1)  \<longrightarrow>
   (v, h, Some (ListET k2) , p, R2, n2) : reg_ua \<longrightarrow> 
   (v, h, Some (ListET (k1+k2)), p, R1, n1+n2): reg_ua"
apply (erule reg_ua.induct)
apply (rule allI)+
apply (rule impI)+
apply simp
apply (rule allI)+
apply (rule impI)+
apply simp
apply (rule allI)+
apply (rule impI)+
apply (drule reg_ua_Null)
apply simp
apply (rule regListNull_ua)

apply (rule allI)+
apply (rule impI)+
apply (rotate_tac 4) apply (erule thin_rl)

apply (rotate_tac 4)
apply (rename_tac R2' n2')
apply (erule reg_ua.cases)
apply fast
apply fast
apply fast
apply simp
apply clarify
apply simp
apply (rename_tac R1' R2' a h k2 n1' n2' p)
apply (erule_tac x="k2" in allE)
apply (erule_tac x="R2'" in allE)
apply (erule_tac x="n2'" in allE)
apply (rotate_tac 11) 
apply (drule mp)
apply assumption
apply (drule_tac R=R1' in reg_ua_Unique) apply assumption
apply (erule conjE)
apply (drule_tac v="RVal h\<lfloor>a\<diamondsuit>F1\<rfloor>" and k=k1 and k'=k2 in reg_ua_notated)
apply simp apply simp   
apply assumption 
apply (drule_tac k="k1+k2" in regListCons_ua)
apply assumption
apply (subgoal_tac "a\<notin> R1'\<union>R2'")
apply assumption
apply fast
apply simp
apply simp
apply assumption
apply (drule reg_ua_Int)
apply simp
apply (subgoal_tac "k1 + k2 + (n2 + n2')=k1 + n2 + (k2 + n2')")
apply simp
apply simp
done

text{*Contexts*}
types Context = "(rname \<leadsto>\<^sub>f Type)"

constdefs DOM:: "Context \<Rightarrow> rname set"
"DOM == fmap_dom"

constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Type option)"
"GETr G x \<equiv> fmap_lookup G x"

lemma DOM_Update: "{x} \<union> (DOM b) = DOM (b(x\<mapsto>\<^sub>fk))" by (simp add: DOM_def)

lemma GETrNDomNone: "x \<notin> DOM C \<Longrightarrow> None = GETr C x"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GETrSomeDom: "GETr C x = Some T \<Longrightarrow> x \<in>  DOM C"
apply (insert  GETrNDomNone)
apply fastsimp
done

lemma GETrNoneNDom: "GETr C x = None \<Longrightarrow> x \<notin> DOM C"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)


lemma GETrSome_DOM:"GETr G x = Some T \<Longrightarrow> x \<in> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)


lemma reg_DOM: "(v, h, GETr G x, p, R, S) : reg_ua \<Longrightarrow> x \<in> DOM G"
apply (erule reg_ua.cases)
apply (simp add:  GETrSome_DOM)
apply (simp add:  GETrSome_DOM)
apply (simp add:  GETrSome_DOM)
apply (simp add:  GETrSome_DOM)
done


constdefs context_sum:: "Context \<Rightarrow> Context \<Rightarrow> Context \<Rightarrow> bool"
"context_sum G1 G2 G == 
(DOM G = DOM G1 \<union> DOM G2) \<and> 
(\<forall> x. 
 (x \<in> DOM G1 - DOM G2 \<longrightarrow> (\<exists> k. GETr G1 x = Some (ListET k) \<and> GETr G x = Some (ListET k) )) \<and> 
 (x \<in> DOM G2 - DOM G1 \<longrightarrow> (\<exists> k. GETr G2 x = Some (ListET k) \<and> GETr G x = Some (ListET k) )) \<and>
 (x \<in> DOM G1 \<inter> DOM G2 \<longrightarrow> (\<exists> k1 k2. GETr G1 x = Some (ListET k1) \<and> GETr G2 x = Some (ListET k2) \<and>  
  GETr G x = Some (ListET (k1+k2)))))"



text{*Size of contexts, i.e. the region inhabited, and the number
      of freelist-cells owned by a context.*}


consts CS::"(env \<times> heap \<times> bool \<times> (rname set) \<times> Context \<times> nat \<times> (locn set) \<times> nat) set"
inductive CS intros
CS_empty: "(E,h,p, {}, C, i, {}, 0) : CS"
CS_1: "\<lbrakk>x \<in> U; 
        (E, h, p, U-{x}, C, 1, R1, m):CS;
        (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R2,n): reg_ua; 
         R1 \<inter> R2 = {}\<rbrakk>
        \<Longrightarrow> (E,h, p, U, C, 1, R1 \<union> R2, m+n) : CS"

CS_2: "\<lbrakk> x \<in> U;
        (E,h, p, U-{x}, C, 2, R1, m):CS;
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p, R2,n): reg_ua;
        p \<longrightarrow> R1 \<inter> R2 = {}\<rbrakk>
        \<Longrightarrow> (E,h, p, U, C, 2, R1 \<union> R2, m+n) : CS"

CS_3: "\<lbrakk>x \<in> U; 
       (E,h, p, U-{x}, C, 3, R1, m):CS;
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, False, R2,n): reg_ua\<rbrakk>
        \<Longrightarrow> (E,h, p, U, C, 3, R1 \<union> R2, m+n) : CS"

lemma CS_emptyU:"(E,h,p, {}, C, i, R, S) : CS \<Longrightarrow> R={} \<and> S=0"
apply (erule CS.cases)
apply clarify
apply clarsimp+
done

lemma CS_1_reverse [rule_format]:
"(E,h, p, U, C, i, R, S) : CS \<Longrightarrow> 
i=1 \<longrightarrow> 
(\<forall> x. x \<in>  U \<longrightarrow> (\<exists> R1 R2 m n.   
(E,h, p, U-{x}, C, i, R1, m):CS \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R2,n): reg_ua \<and>
R1 \<inter> R2 = {} \<and>
R = R1 \<union> R2 \<and>
S=m+n))"
apply (erule CS.induct)
apply clarify

apply (rule impI)
apply (rule allI) apply (rule impI)
apply (drule mp)
apply simp
apply (rename_tac x')
apply (case_tac "x=x'")
apply (rule_tac x=R1 in exI)
apply (rule_tac x=R2 in exI)
apply (rule_tac x=m in exI)
apply (rule_tac x=n in exI)
apply simp

apply (erule_tac x=x' in allE)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rename_tac R1' R2' m' n') 
apply (rule_tac x= "R1' \<union> R2" in exI)
apply (rule_tac x= "R2'" in exI)
apply (rule_tac x= "m'+n" in exI)
apply (rule_tac x=n' in exI)
apply (rule conjI)

apply (rule_tac x="x" and U="U - {x'}" in CS_1)
apply fast
apply (subgoal_tac "U-{x'}-{x}=U-{x}-{x'}")
apply simp
apply fast
apply assumption
apply fast

apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply (rule conjI)
apply fast
apply simp

apply simp
apply simp
done


lemma CS_2_reverse [rule_format]:
"(E,h, p, U, C, i, R, S) : CS \<Longrightarrow> 
i=2 \<longrightarrow> 
(\<forall> x. x \<in>  U \<longrightarrow> (\<exists> R1 R2 m n.   
(E,h, p, U-{x}, C, i, R1, m):CS \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p, R2, n): reg_ua \<and>
(p \<longrightarrow> R1 \<inter> R2 = {}) \<and>
R = R1 \<union> R2 \<and>
S=m+n))"
apply (erule CS.induct)
apply clarify
apply simp

apply (rule impI)
apply (rule allI) apply (rule impI)
apply (drule mp)
apply simp
apply (rename_tac x')
apply (case_tac "x=x'")
apply (rule_tac x=R1 in exI)
apply (rule_tac x=R2 in exI)
apply (rule_tac x=m in exI)
apply (rule_tac x=n in exI)
apply simp

apply (erule_tac x=x' in allE)
apply (rotate_tac 7)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rename_tac R1' R2' m' n') 
apply (rule_tac x= "R1' \<union> R2" in exI)
apply (rule_tac x= "R2'" in exI)
apply (rule_tac x= "m'+n" in exI)
apply (rule_tac x=n' in exI)
apply (rule conjI)

apply (rule_tac x="x" and U="U - {x'}" in CS_2)
apply fast
apply (subgoal_tac "U-{x'}-{x}=U-{x}-{x'}")
apply simp
apply fast
apply assumption
apply fast

apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply (rule conjI)
apply fast
apply simp

apply simp
done

lemma CS_3_reverse [rule_format]:
"(E,h, p, U, C, i, R, S) : CS \<Longrightarrow> 
i=3 \<longrightarrow> 
(\<forall> x. x \<in>  U \<longrightarrow> (\<exists> R1 R2 m n.   
(E,h, p, U-{x}, C, i, R1, m):CS \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, False, R2,n): reg_ua \<and>
R = R1 \<union> R2 \<and>
S=m+n))"
apply (erule CS.induct)
apply clarify
apply simp
apply simp

apply (rule impI)
apply (rule allI) apply (rule impI)
apply (drule mp)
apply simp
apply (rename_tac x')
apply (case_tac "x=x'")
apply (rule_tac x=R1 in exI)
apply (rule_tac x=R2 in exI)
apply (rule_tac x=m in exI)
apply (rule_tac x=n in exI)
apply simp

apply (erule_tac x=x' in allE)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rename_tac R1' R2' m' n') 
apply (rule_tac x= "R1' \<union> R2" in exI)
apply (rule_tac x= "R2'" in exI)
apply (rule_tac x= "m'+n" in exI)
apply (rule_tac x=n' in exI)
apply (rule conjI)

apply (rule_tac x="x" and U="U - {x'}" in CS_3)
apply fast
apply (subgoal_tac "U-{x'}-{x}=U-{x}-{x'}")
apply simp
apply fast
apply assumption

apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply simp
done

lemma CS_reverse:
"\<lbrakk>(E,h, p, U, C, i, R, S) : CS; x\<in> U \<rbrakk> \<Longrightarrow> 
\<exists> R1 R2 p' m n.   
((E,h, p, U-{x}, C, i, R1, m):CS \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p', R2,n): reg_ua \<and>
R = R1 \<union> R2 \<and> S=m+n)"
apply (case_tac "i=1")
apply (drule CS_1_reverse) apply assumption apply assumption 
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x=R1 in exI) 
apply (rule_tac x=R2 in exI) 
apply (rule_tac x=True in exI) 
apply (rule_tac x=m in exI) 
apply (rule_tac x=n in exI)
apply fast
apply (case_tac "i=2")
apply (drule CS_2_reverse) apply assumption apply assumption 
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x=R1 in exI) 
apply (rule_tac x=R2 in exI) 
apply (rule_tac x=p in exI) 
apply (rule_tac x=m in exI) 
apply (rule_tac x=n in exI)
apply fast
apply (case_tac "i=3")
apply (drule CS_3_reverse) apply assumption apply assumption 
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x=R1 in exI) 
apply (rule_tac x=R2 in exI) 
apply (rule_tac x=False in exI) 
apply (rule_tac x=m in exI) 
apply (rule_tac x=n in exI)
apply fast
apply (erule CS.cases)
apply clarsimp
apply simp+
done


lemma CS_preserved [rule_format]:
"(E,h, p, U, C, i, R, S) : CS \<Longrightarrow>
(\<forall> l. l\<in> R \<longrightarrow> sameOH {l} h h') \<longrightarrow>
(E, h', p, U, C, i, R, S) : CS"
apply (erule CS.induct)
apply clarsimp apply (rule CS_empty)

apply (rule impI)
apply (drule mp) 
apply clarsimp
apply (rule CS_1)
apply assumption
apply assumption
apply (rule reg_ua_Preserved)
apply assumption
apply simp
apply clarify

apply (rule impI)
apply (drule mp) 
apply clarsimp
apply (rule CS_2)
apply assumption
apply assumption
apply (rule reg_ua_Preserved)
apply assumption
apply simp
apply assumption

apply (rule impI)
apply (drule mp) 
apply clarsimp
apply (rule CS_3)
apply assumption
apply assumption
apply (rule reg_ua_Preserved)
apply assumption
apply simp
done

lemma CS_sameHeap:
"\<lbrakk> (E,h, p, U, C, i, R, S) : CS; sameOH R h h'\<rbrakk> \<Longrightarrow>
(E, h', p, U, C, i, R, S) : CS"
apply (rule CS_preserved)
apply assumption
apply (simp add: sameOH_def)
done

lemma CS_sameHeapRegSubset:
"\<lbrakk> (E,h, p, U, C, i, R, S) : CS; R\<subseteq>R1; sameOH R1 h h'\<rbrakk> \<Longrightarrow>
(E, h', p, U, C, i, R, S) : CS"
apply (rule CS_preserved)
apply assumption
apply (simp only: sameOH_def)
apply fast
done

lemma CS_1_unique [rule_format]:
"(E,h, p, U, C, i, R, S) : CS \<Longrightarrow> i=1 \<longrightarrow>
(\<forall> R' S'. (E, h, p, U, C, i, R', S') : CS \<longrightarrow> R'=R \<and> S'=S)"
apply (erule CS.induct)
apply clarify apply (rule CS_emptyU) apply assumption

apply (rule impI)
apply (rule allI)+ apply (rule impI)
apply (drule mp)
apply simp
apply (rotate_tac 5)
apply (erule  CS.cases)
apply clarify

apply clarify
apply (rename_tac CC EE RR1 RR2 UU hh mm nn pp xx)

apply (case_tac "x=xx")
apply (erule_tac x=RR1 in allE)
apply (erule_tac x=mm in allE)
apply (drule mp)
apply simp
apply (drule reg_ua_Unique)
apply simp
apply (erule conjE)+
apply (rule conjI)
apply clarify apply clarify

apply (drule_tac x=x and U="UU-{xx}" in CS_1_reverse)
apply clarify
apply fast
apply (erule exE)+
apply (rename_tac R1' R2' m' n')
apply (erule conjE)+
(* add xx to U-{xx}-{x} to get U-{x} *)
apply (subgoal_tac "xx \<in> UU-{x}")
apply (drule_tac x=xx and U="UU-{x}"in CS_1)
apply (subgoal_tac "UU-{x}-{xx}=UU-{xx}-{x}")
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply simp
apply fast
apply assumption
apply fast

apply (erule_tac x="R1' \<union> RR2" in allE)
apply (erule_tac x="m'+nn" in allE)
apply (drule mp)
apply assumption

apply (drule_tac  v="RVal (renv EE x)" in reg_ua_Unique)
apply assumption
apply (erule conjE)+
apply fastsimp
apply fast

apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)
apply simp

apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)
apply simp

apply simp apply simp
done

lemma CS_2_unique [rule_format]:
"(E,h, p, U, C, i, R, S) : CS \<Longrightarrow> i=2 \<longrightarrow>
(\<forall> R' S'. (E, h, p, U, C, i, R', S') : CS \<longrightarrow> R'=R \<and> S'=S)"
apply (erule CS.induct)
apply clarify apply (rule CS_emptyU) apply assumption
apply simp

apply (rule impI)
apply (rule allI)+ apply (rule impI)
apply (drule mp)
apply simp
apply (rotate_tac 5)
apply (erule  CS.cases)
apply clarify
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)  
apply simp

apply clarify
apply (rename_tac CC EE RR1 RR2 UU hh mm nn pp xx)

apply (case_tac "x=xx")
apply (erule_tac x=RR1 in allE)
apply (erule_tac x=mm in allE)
apply (rotate_tac 9)
apply (drule mp)
apply simp
apply (drule reg_ua_Unique)
apply simp
apply (erule conjE)+
apply (rule conjI)
apply clarify apply clarify

apply (drule_tac x=x and U="UU-{xx}" in CS_2_reverse)
apply clarify
apply fast
apply (erule exE)+
apply (rename_tac R1' R2' m' n')
apply (erule conjE)+
(* add xx to U-{xx}-{x} to get U-{x} *)
apply (subgoal_tac "xx \<in> UU-{x}")
apply (drule_tac x=xx and U="UU-{x}"in CS_2)
apply (subgoal_tac "UU-{x}-{xx}=UU-{xx}-{x}")
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply simp
apply fast
apply assumption
apply fast

apply (erule_tac x="R1' \<union> RR2" in allE)
apply (erule_tac x="m'+nn" in allE)
apply (rotate_tac 12)
apply (drule mp)
apply assumption

apply (drule_tac  v="RVal (renv EE x)" in reg_ua_Unique)
apply assumption
apply (erule conjE)+
apply (rotate_tac 1)
apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply fastsimp
apply fast

apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)
apply simp

apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply simp
done

lemma CS_3_unique [rule_format]:
"(E,h, p, U, C, i, R, S) : CS \<Longrightarrow> i=3 \<longrightarrow>
(\<forall> R' S'. (E, h, p, U, C, i, R', S') : CS \<longrightarrow> R'=R \<and> S'=S)"
apply (erule CS.induct)
apply clarify apply (rule CS_emptyU) apply assumption
apply simp apply simp


apply (rule impI)
apply (rule allI)+ apply (rule impI)
apply (drule mp)
apply simp
apply (rotate_tac 4)
apply (erule  CS.cases)
apply clarify
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) 
apply simp

apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) 
apply simp

apply clarify
apply (rename_tac CC EE RR1 RR2 UU hh mm nn pp xx)

apply (case_tac "x=xx")
apply (erule_tac x=RR1 in allE)
apply (erule_tac x=mm in allE)
apply (drule mp)
apply simp
apply (drule reg_ua_Unique)
apply simp
apply (erule conjE)+
apply (rule conjI)
apply clarify apply clarify

apply (drule_tac x=x and U="UU-{xx}" in CS_3_reverse)
apply clarify
apply fast
apply (erule exE)+
apply (rename_tac R1' R2' m' n')
apply (erule conjE)+
(* add xx to U-{xx}-{x} to get U-{x} *)
apply (subgoal_tac "xx \<in> UU-{x}")
apply (drule_tac x=xx and U="UU-{x}"in CS_3)
apply (subgoal_tac "UU-{x}-{xx}=UU-{xx}-{x}")
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) 
apply simp
apply fast
apply assumption

apply (erule_tac x="R1' \<union> RR2" in allE)
apply (erule_tac x="m'+nn" in allE)
apply (drule mp)
apply assumption

apply (drule_tac  v="RVal (renv EE x)" in reg_ua_Unique)
apply assumption
apply (erule conjE)+
apply fastsimp
apply fast
done


lemma CS_uniqueReg:
"\<lbrakk>(E,h, p, U, C, i, R, S) : CS; (E, h, p, U, C, i, R', S'): CS\<rbrakk>   \<Longrightarrow> R'=R"
apply (case_tac "i=1")
apply (drule CS_1_unique) apply assumption  apply assumption 
apply simp
apply (case_tac "i=2")
apply (drule CS_2_unique) apply assumption  apply assumption 
apply simp
apply (case_tac "i=3")
apply (drule CS_3_unique) apply assumption  apply assumption 
apply simp
apply (erule CS.cases)
apply clarsimp
apply (drule CS_emptyU) apply simp
apply simp+
done

lemma CS_uniqueNumber:
"\<lbrakk>(E,h, p, U, C, i, R, S) : CS; (E, h, p, U, C, i, R', S'): CS\<rbrakk>   \<Longrightarrow> S'=S"
apply (case_tac "i=1")
apply (drule CS_1_unique) apply assumption  apply assumption 
apply simp
apply (case_tac "i=2")
apply (drule CS_2_unique) apply assumption  apply assumption 
apply simp
apply (case_tac "i=3")
apply (drule CS_3_unique) apply assumption  apply assumption 
apply simp
apply (erule CS.cases)
apply clarsimp
apply (drule CS_emptyU) apply simp
apply simp+
done

lemma CS_Ufinite:
"(E,h, p, U, C, i, R, S) : CS \<Longrightarrow> finite U"
apply (erule CS.induct)
apply simp+
done

lemma CS_union_aux [rule_format]:
"finite U'\<Longrightarrow> \<forall> E h p U C i R S R' S'.
(E,h, p, U, C, i, R, S) : CS \<longrightarrow> (E, h, p, U\<union>U', C, i, R', S'): CS \<longrightarrow> U \<inter> U' ={} \<longrightarrow>  
R\<subseteq>R' \<and> S \<le> S'"
apply (induct set: Finites)

apply clarsimp 
apply (frule CS_uniqueReg) apply (rotate_tac 1) apply assumption  
apply (drule CS_uniqueNumber) apply assumption  
apply simp

apply (rule allI)+
apply (rule impI)+

apply (case_tac "i=1")
apply (drule_tac x=x and U="U \<union> insert x F" in CS_1_reverse)
apply assumption
apply simp

apply (erule exE)+
apply (erule conjE)+

apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x=U in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=1 in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=S in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)

apply simp
apply (erule conjE)+
apply fastsimp

apply (case_tac "i=2")
apply (drule_tac x=x and U="U \<union> insert x F" in CS_2_reverse)
apply assumption
apply simp

apply (erule exE)+
apply (erule conjE)+

apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x=U in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=2 in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=S in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)

apply simp
apply (erule conjE)+
apply fastsimp

apply (case_tac "i=3")
apply (drule_tac x=x and U="U \<union> insert x F" in CS_3_reverse)
apply assumption
apply simp

apply (erule exE)+
apply (erule conjE)+

apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x=U in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=3 in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=S in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)

apply simp
apply (erule conjE)+
apply fastsimp

apply (rotate_tac 4)
apply (erule CS.cases)
apply clarsimp
apply simp+
done

lemma CS_union:
"\<lbrakk>(E,h, p, U, C, i, R, S) : CS; (E, h, p, U\<union>U', C, i, R', S'): CS; U \<inter> U' ={}\<rbrakk> \<Longrightarrow> 
R\<subseteq>R' \<and> S \<le> S'"
apply (rule_tac U'=U' in CS_union_aux)
apply (drule_tac U="U \<union> U'" in CS_Ufinite)
apply simp
apply assumption
apply assumption
apply assumption
done

lemma CS_2_union_detail [rule_format]:
"(E,h, p, U, C, i, R, S) : CS \<Longrightarrow> 
p=False \<longrightarrow> i=2 \<longrightarrow> 
(\<forall> U' R' S'. (E, h, False, U', C, 2, R', S'): CS \<longrightarrow>
U \<inter> U' ={} \<longrightarrow>
(E, h, p, U \<union> U', C, 2, R\<union> R', S+S'): CS)"
apply (erule CS.induct)
apply (rule impI)+
apply (rule allI)+
apply (rule impI)+ 
apply simp

apply (rule impI)+
apply (rule allI)+
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply simp

apply (rule impI)+
apply (rule allI)+
apply (rule impI)+
apply (drule mp) apply assumption
apply (rotate_tac 4)
apply (drule mp) apply assumption 
apply (erule_tac x=U' in allE)
apply (erule_tac x=R' in allE)
apply (erule_tac x=S' in allE)
apply (rotate_tac 8)
apply (drule mp) apply assumption
apply (rotate_tac 8)
apply (drule mp) apply fast
apply (subgoal_tac "x\<in>U \<union> U'") 
apply (drule_tac x=x and U="U \<union> U'" in CS_2)
apply (subgoal_tac "U - {x} \<union> U'= U \<union> U' - {x}") 
apply simp
apply fast
apply assumption
apply fast 
apply (subgoal_tac "R1 \<union> R' \<union> R2=R1 \<union> R2 \<union> R'")
apply (subgoal_tac "m + S' + n=m + n + S'")
apply simp
apply simp
apply fast 
apply fast

apply (rule impI)+
apply (rule allI)+
apply (rule impI)+
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply simp
done


lemma CS_3_union_detail [rule_format]:
"(E,h, p, U, C, i, R, S) : CS \<Longrightarrow> 
i=3 \<longrightarrow> 
(\<forall> U' R' S'. (E, h, p, U', C, 3, R', S'): CS \<longrightarrow>
U \<inter> U' ={} \<longrightarrow>
(E, h, p, U \<union> U', C, 3, R\<union> R', S+S'): CS)"
apply (erule CS.induct)
apply (rule impI)
apply (rule allI)+
apply (rule impI)+ 
apply simp

apply (rule impI)+
apply (rule allI)+
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply simp

apply (rule impI)+
apply (rule allI)+
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply simp

apply (rule impI)+
apply (rule allI)+
apply (rule impI)+
apply (drule mp) apply assumption
apply (erule_tac x=U' in allE)
apply (erule_tac x=R' in allE)
apply (erule_tac x=S' in allE)
apply (drule mp) apply assumption
apply (drule mp) apply fast
apply (subgoal_tac "x\<in>U \<union> U'") 
apply (drule_tac x=x and U="U \<union> U'" in CS_3)
apply (subgoal_tac "U - {x} \<union> U'= U \<union> U' - {x}") 
apply simp
apply fast
apply assumption
apply (subgoal_tac "R1 \<union> R' \<union> R2=R1 \<union> R2 \<union> R'")
apply (subgoal_tac "m + S' + n=m + n + S'")
apply simp
apply simp
apply fast 
apply fast
done


lemma CS_union_detail [rule_format]:
"(E,h, p, U, C, i, R, S) : CS \<Longrightarrow> 
\<forall> U' R' S'. (E, h, p, U', C, i, R', S'): CS \<longrightarrow>
R \<inter> R' ={} \<longrightarrow>  U \<inter> U' ={} \<longrightarrow>
(E, h, p, U \<union> U', C, i, R\<union> R', S+S'): CS"
apply (erule CS.induct)

apply clarsimp

apply (rule allI)+
apply (rule impI)+
apply (erule_tac x=U' in allE)
apply (erule_tac x=R' in allE)
apply (erule_tac x=S' in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (subgoal_tac "x\<in>U \<union> U'") 
apply (drule_tac x=x and U="U \<union> U'" in CS_1)
apply (subgoal_tac "U - {x} \<union> U'= U \<union> U' - {x}") 
apply simp
apply fast
apply assumption
apply fast 
apply (subgoal_tac "R1 \<union> R' \<union> R2=R1 \<union> R2 \<union> R'")
apply (subgoal_tac "m + S' + n=m + n + S'")
apply simp
apply simp
apply fast 
apply fast

apply (rule allI)+
apply (rule impI)+
apply (erule_tac x=U' in allE)
apply (erule_tac x=R' in allE)
apply (erule_tac x=S' in allE)
apply (rotate_tac 7)
apply (drule mp)
apply assumption
apply (rotate_tac 7)
apply (drule mp)
apply fast
apply (rotate_tac 7)
apply (drule mp)
apply fast
apply (subgoal_tac "x\<in>U \<union> U'") 
apply (drule_tac x=x and U="U \<union> U'" in CS_2)
apply (subgoal_tac "U - {x} \<union> U'= U \<union> U' - {x}") 
apply simp
apply fast
apply assumption
apply fast 
apply (subgoal_tac "R1 \<union> R' \<union> R2=R1 \<union> R2 \<union> R'")
apply (subgoal_tac "m + S' + n=m + n + S'")
apply simp
apply simp
apply fast 
apply fast

apply (rule allI)+
apply (rule impI)+
apply (erule_tac x=U' in allE)
apply (erule_tac x=R' in allE)
apply (erule_tac x=S' in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (subgoal_tac "x\<in>U \<union> U'") 
apply (drule_tac x=x and U="U \<union> U'" in CS_3)
apply (subgoal_tac "U - {x} \<union> U'= U \<union> U' - {x}") 
apply simp
apply fast
apply assumption
apply (subgoal_tac "R1 \<union> R' \<union> R2=R1 \<union> R2 \<union> R'")
apply (subgoal_tac "m + S' + n=m + n + S'")
apply simp
apply simp
apply fast 
apply fast
done


lemma CS_monot:
"\<lbrakk> (E,h, p, U, C, i, R, S) : CS;   (E, h, p, U', C, i, R', S'): CS ; U\<subseteq> U'\<rbrakk> \<Longrightarrow>
R\<subseteq>R' \<and> S \<le> S' "
apply (rule_tac U'="U'- U" in CS_union)
apply assumption
apply (subgoal_tac "U'=U \<union> (U' - U)")
apply simp
apply fastsimp
apply fastsimp
done



lemma CS_subset_aux [rule_format]:
"finite U' \<Longrightarrow> 
\<forall> E h p U C i R S. U'\<subseteq> U \<longrightarrow> (E,h, p, U, C, i, R, S) : CS \<longrightarrow> 
(\<exists> R' S'. (E, h, p, U-U', C, i, R', S'): CS)" 
apply (induct set: Finites)
apply clarsimp

apply (rule allI)+
apply (rule impI)+

apply (drule_tac x=x and U=U in CS_reverse)
apply simp
apply (erule exE)+
apply (erule conjE)+
apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x="U-{x}" in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=i in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)
apply (subgoal_tac "F \<subseteq> U - {x}")
apply (drule mp)
apply assumption
apply (drule mp)
apply assumption
apply clarsimp
apply (subgoal_tac  "U - {x} - F=U - insert x F")
apply fastsimp
apply fast
apply fast
done

lemma subset_fin [rule_format]:
"finite U \<Longrightarrow> \<forall>  U'. U'\<subseteq> U \<longrightarrow> finite U'"
apply (induct set: Finites)
apply simp
apply (rule allI)
apply (rule impI)
apply (erule_tac x="U'-{x}" in allE)
apply (drule mp)
apply fast
apply simp
done

lemma CS_subset_minus [rule_format]:
"\<lbrakk>(E,h, p, U, C, i, R, S) : CS; U'\<subseteq> U\<rbrakk>  \<Longrightarrow>
(\<exists> R' S'. (E, h, p, U-U', C, i, R', S'): CS)"
apply (rule CS_subset_aux) 
apply (drule CS_Ufinite)
apply (rule_tac U=U in subset_fin)
apply assumption apply assumption
apply assumption apply assumption
done

lemma CS_subset [rule_format]:
"\<lbrakk>(E,h, p, U, C, i, R, S) : CS; U'\<subseteq> U\<rbrakk>  \<Longrightarrow>
(\<exists> R' S'. (E, h, p, U', C, i, R', S'): CS)"
apply (drule_tac U'="U-U'" in CS_subset_minus) 
apply fast
apply (subgoal_tac  "U - (U - U')=U'")
apply simp
apply fast
done

lemma CS_1_EquivTrueFalse [rule_format]:
"(E,h,  p, U, G, i, R, K):CS
 \<Longrightarrow> i=1 \<longrightarrow> (\<forall> p'. (E,h, p', U, G, i, R, K):CS)"
apply (erule CS.induct)
apply clarify apply (rule CS_empty)

apply clarify 

apply (rule CS_1)
apply assumption
apply (drule mp)
apply simp
apply (erule_tac x=p' in allE)
apply assumption
apply assumption
apply assumption
apply simp+
done

lemma CS_3_EquivTrueFalse [rule_format]:
"(E,h,  p, U, G, i, R, K):CS
 \<Longrightarrow> i=3 \<longrightarrow> (\<forall> p'. (E,h, p', U, G, i, R, K):CS)"
apply (erule CS.induct)
apply clarify apply (rule CS_empty)
apply simp
apply simp 

apply clarify
apply (rule CS_3)
apply assumption
apply (drule mp)
apply simp
apply (erule_tac x=p' in allE)
apply assumption
apply assumption
done

lemma CS_2_TrueFalse [rule_format]:
"(E,h,  p, U, G, i, R, K):CS \<Longrightarrow>
i=(2::nat) \<longrightarrow> p=True \<longrightarrow> (E,h, False, U, G, i, R, K):CS"
apply (erule CS.induct) 
apply clarify
apply (rule CS_empty)
apply simp
apply (rule impI)+
apply (rule CS_2)
apply assumption
apply (drule mp)
apply simp
apply (rotate_tac 6)
apply (drule mp)
apply assumption
apply assumption
apply (rule reg_ua_WeakFalse)
apply assumption
apply clarify
apply simp
done

lemma CS_UDOM [rule_format]: 
"(E,h, p, U, G, i, R, K):CS \<Longrightarrow> U\<subseteq> DOM G"
apply (erule CS.induct)
apply fast
apply (drule reg_DOM) apply fast
apply (drule reg_DOM) apply fast
apply (drule reg_DOM) apply fast
done

lemma coherent_CS [rule_format]: 
"(E,h, p, U, G, i, R, K):CS \<Longrightarrow> 
\<forall> G' R' K'.  
(\<forall> x. x\<in>U \<longrightarrow> 
(\<exists> k k'. GETr G x = Some (ListET k) \<and>  GETr G' x = Some (ListET k')))
\<longrightarrow>
(E,h, p, U, G', i, R', K'):CS \<longrightarrow> R=R'"
apply (erule CS.induct)
apply (rule allI)+
apply (rule impI)+
apply (drule CS_emptyU)
apply clarify

apply (rule allI)+
apply (rule impI)+
apply (rotate_tac 6)
apply (drule_tac x=x in CS_1_reverse)
apply simp
apply assumption
apply (erule exE)+ apply (erule conjE)+ 
apply (rename_tac R1' R2' m' n')
apply (erule_tac x=G' in allE)
apply (rotate_tac 10)
apply (erule_tac x=R1' in allE)
apply (rotate_tac 10)
apply (erule_tac x=m' in allE)
apply (drule mp)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl)
apply fast

apply (drule mp)
apply  assumption

apply (erule_tac x=x in allE)
apply (drule mp)
apply  assumption
apply (erule exE)+ apply (erule conjE)+
apply simp
apply (drule_tac T="Some (ListET k)" in reg_ua_notated)
apply simp
apply simp
apply  assumption
apply simp

apply (rule allI)+
apply (rule impI)+
apply (rotate_tac 6)
apply (drule_tac x=x in CS_2_reverse)
apply simp
apply assumption
apply (erule exE)+ apply (erule conjE)+ 
apply (rename_tac R1' R2' m' n')
apply (erule_tac x=G' in allE)
apply (rotate_tac 10)
apply (erule_tac x=R1' in allE)
apply (rotate_tac 10)
apply (erule_tac x=m' in allE)
apply (rotate_tac 10)
apply (drule mp)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl)
apply fast

apply (rotate_tac 10)
apply (drule mp)
apply  assumption

apply (erule_tac x=x in allE)
apply (rotate_tac 10)
apply (drule mp)
apply  assumption
apply (erule exE)+ apply (erule conjE)+
apply simp
apply (drule_tac T="Some (ListET k)" in reg_ua_notated)
apply simp
apply simp
apply  assumption
apply simp

apply (rule allI)+
apply (rule impI)+
apply (rotate_tac 5)
apply (drule_tac x=x in CS_3_reverse)
apply simp
apply assumption
apply (erule exE)+ apply (erule conjE)+ 
apply (rename_tac R1' R2' m' n')
apply (erule_tac x=G' in allE)
apply (rotate_tac 8)
apply (erule_tac x=R1' in allE)
apply (rotate_tac 8)
apply (erule_tac x=m' in allE)
apply (drule mp)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply fast

apply (drule mp)
apply  assumption

apply (erule_tac x=x in allE)
apply (drule mp)
apply  assumption
apply (erule exE)+ apply (erule conjE)+
apply simp
apply (drule_tac T="Some (ListET k)" in reg_ua_notated)
apply simp
apply simp
apply  assumption
apply simp
done

lemma rise_CS [rule_format]:
"(E,h, p, U, G, i, R, K):CS 
\<Longrightarrow> \<forall> j. i\<le>j \<and> j \<le> 3 \<longrightarrow> (E,h, p, U, G, j, R, K):CS"
apply (erule CS.induct)

apply (rule allI)
apply (rule impI)
apply (rule CS_empty)

apply (rule allI)
apply (rule impI)

apply (case_tac "j=1") 
apply (drule CS_1)
apply assumption
apply assumption
apply assumption
apply simp

apply (case_tac "j=2") 
apply (erule_tac x=2 in allE)
apply (drule mp)
apply simp
apply (drule_tac x=x in CS_2)
apply assumption
apply (drule_tac p=p in reg_ua_WeakTrue)
apply assumption
apply clarify
apply simp

apply (case_tac "j=3") 
apply (erule_tac x=3 in allE)
apply (drule mp)
apply simp
apply (drule_tac x=x in CS_3)
apply assumption
apply (drule_tac p=False in reg_ua_WeakTrue)
apply assumption
apply simp
apply (erule conjE)
apply simp

apply (rule allI)
apply (rule impI)

apply (case_tac "j=2") 
apply (erule_tac x=2 in allE)
apply (rotate_tac 6)
apply (drule mp)
apply simp
apply (drule_tac x=x in CS_2)
apply assumption
apply assumption
apply clarify
apply simp

apply (case_tac "j=3") 
apply (erule_tac x=3 in allE)
apply (rotate_tac 6)
apply (drule mp)
apply simp
apply (drule_tac x=x in CS_3)
apply assumption
apply (drule reg_ua_WeakFalse)
apply assumption
apply simp
apply (erule conjE)
apply simp

apply (rule allI)
apply (rule impI)

apply (case_tac "j=3") 
apply (erule_tac x=3 in allE)
apply (drule mp)
apply simp
apply (drule_tac x=x in CS_3)
apply assumption
apply assumption
apply simp
apply (erule conjE)
apply simp
done



(********************************************************)


subsubsection {*The heap assertion*}
constdefs freelist::"heap \<Rightarrow> locn set \<Rightarrow> nat \<Rightarrow> bool"
"freelist h F N == (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) : FL"

constdefs modify::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"modify R h hh == \<forall> l . (l: Dom h - R \<longrightarrow> sameOH {l} h hh)"


lemma modify_monot:
"\<lbrakk>modify M h hh; M\<subseteq>M'\<rbrakk> \<Longrightarrow> modify M' h hh"
apply (unfold modify_def)
apply (rule allI)
apply (rule impI)
apply (erule_tac x=l in allE)
apply (drule mp)
apply fast
apply assumption
done


constdefs DAUAss::"(rname set)  \<Rightarrow>(rname set) \<Rightarrow>(rname set) \<Rightarrow>   
                   nat \<Rightarrow> Context \<Rightarrow>  Type \<Rightarrow> nat \<Rightarrow> vdmassn" ("\<lbrace> _ , _ , _ \<ggreater>  _ , _ \<rbrace>" 1000)
"DAUAss U1  U2  U3 n G T m E h h' v p \<equiv>
  (U1 \<union> U2 \<union> U3) \<subseteq>  (DOM G) \<and> 
  (U1 \<inter> U2) ={} \<and> (U1 \<inter> U3) ={}  \<and>  (U2 \<inter> U3) ={} \<and>   
  (\<forall> q F R1 R2 R3. 
    (\<exists> N K1 K2 K3. 
     freelist h F N \<and>
     (E,h,  False, U1, G, 1, R1, K1):CS \<and> 
     (E,h,  False, U2, G, 2, R2, K2):CS \<and> 
     (E,h,  False, U3, G, 3, R3, K3):CS \<and> 
      (R1 \<inter> (R2 \<union> R3)) = {} \<and>
      (R1 \<union> R2 \<union> R3) \<inter> F = {} \<and> 
      n + (K1+K2+K3) + q \<le> N) \<longrightarrow>
    (\<exists> R' S M FF. (v, h' , Some T,  False, R', S) : reg_ua \<and>
                 (freelist h' FF M) \<and> 
                 (R' \<inter> FF = {}) \<and>  
                 (modify (F \<union> R1) h h') \<and>
                 R' \<subseteq> (R1 \<union> R2  \<union> F) \<and> (* th. 4.3 (1) *)
                 FF \<subseteq> (R1 \<union> F) \<and>
                 (m + S + q \<le> M) \<and> 
                 oheap h = oheap h' \<and>
      ( (\<exists> K2. (E,h, True, U2, G, 2, R2, K2): CS) \<longrightarrow>
        (v, h' , Some T, True, R', S) : reg_ua) )  )"

lemma DAUAss_monotone_in_U:
"\<lbrakk>DAUAss U1 U2 U3 n C T m E h hh v p; 
  U1 \<subseteq> UU1; U2 \<subseteq> UU2; U3 \<subseteq> UU3;
  UU1 \<union> UU2 \<union> UU3 \<subseteq> DOM C;
  UU1 \<inter> UU2 ={};  UU1 \<inter> UU3 ={};  UU2 \<inter> UU3 ={} \<rbrakk> \<Longrightarrow> DAUAss UU1 UU2 UU3 n C T m E h hh v p"
apply (unfold  DAUAss_def)
apply (erule conjE)+

apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption

apply (rule allI)+
apply (rule impI)

apply (erule exE)+ apply (erule conjE)+
apply (erule_tac x=q in allE)
apply (erule_tac x=F in allE)

apply (frule_tac U=UU1 and i=1 in CS_subset)
apply assumption
apply (frule_tac U=UU2 and i=2 in CS_subset)
apply assumption
apply (frule_tac U=UU3 and i=3 in CS_subset)
apply assumption
apply (erule exE)+
apply (rename_tac R1' R2' R3' S1' S2' S3')
apply (erule_tac x=R1' in allE)
apply (erule_tac x=R2' in allE)
apply (erule_tac x=R3' in allE)
apply (frule_tac U=U1 and i=1 in CS_monot)  apply assumption apply assumption
apply (frule_tac U=U2 and i=2 in CS_monot)  apply assumption apply assumption
apply (frule_tac U=U3 and i=3 in CS_monot)  apply assumption apply assumption
apply (erule conjE)+

apply (drule mp)
apply (rule exI)+
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption

apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (rule conjI) apply fast
apply (rule conjI) apply fast
apply simp

apply (erule exE)+ apply (erule conjE)+

apply (rule_tac x=R' in exI)
apply (rule_tac x=S in exI)
apply (rule_tac x=M in exI)
apply (rule_tac x=FF in exI)
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption

apply (rule conjI) apply (rule modify_monot) apply assumption
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply fast


apply (erule thin_rl) apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (rotate_tac 1) apply (erule thin_rl)
apply (rotate_tac 6)
apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) 

apply (rule conjI) apply fast
apply (rule conjI) apply fast
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption

apply (rule impI)
apply (drule mp)
apply (erule exE)
apply (drule_tac U=UU2 and i=2 in CS_subset)
apply assumption
apply (erule exE)+
apply (rule_tac x=S2' in exI)
apply (rename_tac R' S')
apply (frule_tac R=R' in CS_2_TrueFalse)
apply simp apply simp 
apply (frule CS_2_unique)
apply simp
apply (rotate_tac 13)
apply assumption
apply simp
apply assumption
done

(****************************************************)


lemma DAUA_null: "\<lbrakk>m \<le> n; T=ListET k\<rbrakk> \<Longrightarrow> GG \<rhd> Null: DAUAss {} {} {} n G T m" 
apply (rule vdm_conseq) apply (rule vdm_null)

apply (rule allI)+ apply (rule impI)
apply (erule conjE)+

apply (unfold DAUAss_def)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule allI)+
apply (rule impI)
apply (erule exE)+
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply (rule_tac x="0" in exI)
apply (rule_tac x="N" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp add: regListNull_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule impI)
apply (simp add: regListNull_ua)
done

lemma DAUA_Int: "\<lbrakk>m \<le> n; T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> expr.Int i: DAUAss {} {} {} n G T m"
apply (rule vdm_conseq) apply (rule vdm_int)
apply (rule allI)+ apply (rule impI)
apply (erule conjE)+

apply (unfold DAUAss_def)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule allI)+
apply (rule impI)
apply (erule exE)+
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply (rule_tac x="0" in exI)
apply (rule_tac x="N" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp add: regInt_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule impI) apply (simp add: regInt_ua)
done


lemma DAUA_IVar: "\<lbrakk>m \<le> n; T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> IVar x: DAUAss {} {} {} n G T m"
apply (rule vdm_conseq) apply (rule vdm_ivar)
apply (rule allI)+ apply (rule impI)
apply (erule conjE)+

apply (unfold DAUAss_def)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule allI)+
apply (rule impI)
apply (erule exE)+
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply (rule_tac x="0" in exI)
apply (rule_tac x="N" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp add: regInt_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule impI) apply (simp add: regInt_ua)
done

lemma DAUA_RVar: "\<lbrakk>m \<le> n; GETr G x = Some T\<rbrakk> \<Longrightarrow> GG \<rhd> RVar x: DAUAss {} {x} {} n G T m"

apply (rule vdm_conseq) apply (rule vdm_rvar)
apply (rule allI)+ apply (rule impI)
apply (erule conjE)+

apply (unfold DAUAss_def)

apply (rule conjI)
apply (simp add:  GETrSomeDom)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule allI)+
apply (rule impI)
apply (erule exE)+
apply (erule conjE)+

apply (rule_tac x="R2" in exI)
apply (rule_tac x="K2" in exI)
apply (rule_tac x="N" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (rotate_tac 7)
apply (drule_tac x=x in CS_2_reverse)
apply simp
apply simp
apply (erule exE)+ apply (erule conjE)+
apply simp
apply (drule_tac i=2 in CS_emptyU)
apply simp

apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply fast
apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule impI)
apply (erule exE)

apply (rotate_tac 7)
apply (drule_tac x=x in CS_2_reverse)
apply simp
apply simp
apply (rotate_tac 4)
apply (drule_tac x=x in CS_2_reverse)
apply simp
apply simp
apply (erule exE)+ apply (erule conjE)+
apply simp
apply (drule_tac i=2 in CS_emptyU)
apply (drule_tac i=2 in CS_emptyU)
apply clarsimp
apply (drule reg_ua_Unique)
apply (rule reg_ua_WeakTrue)
apply assumption
apply simp
done

(* Recall: integer names do not "take part" in U1, U2, U3 *)
lemma DA_Prim: "\<lbrakk>m \<le> n; T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> Primop f x y: DAUAss {} {} {} n G T m"
apply (rule vdm_conseq) apply (rule vdm_prim)
apply (rule allI)+ apply (rule impI)
apply (erule conjE)+

apply (unfold DAUAss_def)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule allI)+
apply (rule impI)
apply (erule exE)+
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply (rule_tac x="0" in exI)
apply (rule_tac x="N" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp add: regInt_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule impI) apply (simp add: regInt_ua)
done

lemma DA_RPrim: "\<lbrakk>GETr G x = Some Tx; GETr G y = Some Ty; m \<le> n; T = IntET\<rbrakk> 
\<Longrightarrow> GG \<rhd> RPrimop f x y: DAUAss {} {} {x, y} n G T m"
apply (rule vdm_conseq) apply (rule vdm_rprim)
apply (rule allI)+ apply (rule impI)
apply (erule conjE)+

apply (unfold DAUAss_def)

apply (rule conjI) apply simp
apply (simp add:  GETrSomeDom)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule allI)+
apply (rule impI)
apply (erule exE)+
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply (rule_tac x="0" in exI)
apply (rule_tac x="N" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp add: regInt_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule impI) apply (simp add: regInt_ua)
done

(**************************************************************)

text{* The first serious step in the proof of any let rule
is an instantiation of CS-s with 1, 2, 3 for the derived
assertions for e1 and partially for e2. Given: the instantiation
of the CS-s for the whole let-expression with the context G.
G is a sum of a contexts for G1 and G2. *}

text{* 1. We start with splitting any of 3 (E,h, p, UI, G, i, R, K):CS  
into 3 parts: 
(E,h, p, UA, G, i, R, K):CS for the variables only of e1, 
(E,h, p, UB, G, i, R, K):CS for the variables only of e2, 
(E,h, p, UC, G, i, R, K):CS for the variables of e1 and e2.
To prove the  corresponding lemma we will use the preconditions:
 UA \<subseteq> DOM G1 - DOM G2;
 UB \<subseteq> DOM G2 - DOM G1;
 UC \<subseteq> DOM G1 \<inter> DOM G2.

In a proof of a let expression we will instantiate
U with UI;
UIA with "(U11 \<union> U12 \<union> U13) - (U21 \<union> U22 \<union> U23)";
UIB with "(U21 \<union> U22 \<union> U23) - (U11 \<union> U12 \<union> U13)";
UIC with "(U11 \<union> U12 \<union> U13) \<inter>  (U21 \<union> U22 \<union> U23)"

When applying the lemma (see below) the subgoals 
"(U11 \<union> U12 \<union> U13) - (U21 \<union> U22 \<union> U23) \<subseteq> DOM G1 - DOM G2"
"(U21 \<union> U22 \<union> U23) - (U11 \<union> U12 \<union> U13) \<subseteq> DOM G2 - DOM G1"
(U11 \<union> U12 \<union> U13) \<inter>  (U21 \<union> U22 \<union> U23)\<subseteq> DOM G1 \<inter> DOM G2"
will appear. In general it does not hold.
It holds in the case when DOM G1=(U11 \<union> U12 \<union> U13)
and DOM G2=(U21 \<union> U22 \<union> U23) as in the usage aspect paper.
We add the conditions to the side conditions of let rules.

The subgoal UI=UIA \<union> UIB \<union> UIC must follow from the 
insantiation above
*}

lemma sum_region_A: 
"\<lbrakk>(RVal (renv E x), h, GETr G x, p, R, n) \<in> reg_ua; 
  context_sum G1 G2 G; x \<in> DOM G1 - DOM G2 \<rbrakk> \<Longrightarrow>
(RVal (renv E x), h, GETr G1 x, p, R, n) \<in> reg_ua"
apply (unfold  context_sum_def)
apply (erule conjE)
apply (erule_tac x=x in allE)
apply (erule conjE)+
apply (drule mp)
apply assumption
apply (erule exE)
apply simp
done

lemma sum_region_B: 
"\<lbrakk>(RVal (renv E x), h, GETr G x, p, R, n) \<in> reg_ua; 
  context_sum G1 G2 G; x \<in> DOM G2 - DOM G1\<rbrakk> \<Longrightarrow>
(RVal (renv E x), h, GETr G2 x, p, R, n) \<in> reg_ua"
apply (unfold  context_sum_def)
apply (erule conjE)
apply (erule_tac x=x in allE)
apply (erule conjE)+
apply (rotate_tac 4)
apply (drule mp)
apply assumption
apply (erule exE)
apply simp
done


lemma sum_region_reverse [rule_format]: 
"(RVal (renv E x), h, T, p, R, n) \<in> reg_ua \<Longrightarrow> 
T = Some (ListET k) \<longrightarrow>
(\<forall> G1 G2. context_sum G1 G2 G \<longrightarrow> GETr G x=Some (ListET k)\<longrightarrow>
x\<in> DOM G1 \<inter>  DOM G2 \<longrightarrow>
(\<exists> n1 n2. (RVal (renv E x), h, GETr G1 x, p, R, n1) \<in> reg_ua
\<and> (RVal (renv E x), h, GETr G2 x, p, R, n2) \<in> reg_ua
\<and> n=n1+n2))"
apply (erule reg_ua.induct)
apply clarify apply clarify
apply clarify
apply (rule_tac x=0 in exI)
apply (rule_tac x=0 in exI)
apply (unfold  context_sum_def)
apply (erule conjE)
apply (erule_tac x=x in allE)
apply (erule conjE)+
apply (rotate_tac 6) apply (drule mp) apply fast
apply (rotate_tac 4) apply (erule thin_rl) apply (erule thin_rl)
apply (erule exE)+
apply (rule conjI)
apply simp
apply (rule regListNull_ua)
apply (rule conjI)
apply simp
apply (rule regListNull_ua)
apply simp

apply (rotate_tac 4) apply (erule_tac thin_rl)
apply (rule impI) apply (drule mp) apply assumption

apply (rule allI)+
apply (erule_tac x=G1 in allE)
apply (erule_tac x=G2 in allE)
apply (rule impI)
apply (rotate_tac 7) apply (drule mp) apply assumption
apply (rule impI)
apply (rotate_tac 8) apply (drule mp) apply assumption
apply (rule impI) 
apply (rotate_tac 9) apply (drule mp) apply assumption
apply (erule exE)+
apply (rename_tac n1' n2')
apply (erule conjE)
apply (erule_tac x=x in allE)
apply (erule conjE)+
apply (rotate_tac 11) apply (erule thin_rl) 
apply (rotate_tac 2) apply (erule thin_rl)
apply (drule mp) apply assumption
apply (erule exE)+
apply (erule conjE)+

apply (rule_tac x="k1+n1+n1'" in exI)
apply (rule_tac x="k2+n1+n2'" in exI)


apply (rule conjI)
apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 5) apply (erule thin_rl)
apply (erule thin_rl)
apply (rotate_tac 1) apply (erule thin_rl) 
apply (rotate_tac 2) apply (erule thin_rl)apply (erule thin_rl)
apply (drule regListCons_ua)
apply assumption apply assumption apply assumption apply simp
apply assumption
apply simp

apply (rule conjI)

apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 5)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 2) apply (erule thin_rl)
apply (drule regListCons_ua)
apply assumption apply assumption apply assumption apply simp
apply assumption
apply simp

apply (drule reg_ua_Int)
apply (erule conjE)
apply simp
done

lemma context_sum_reverse_sum:
"\<lbrakk>context_sum G1 G2 G; x \<in> DOM G\<rbrakk> \<Longrightarrow> \<exists> k. GETr G x = Some (ListET k)"
apply (unfold context_sum_def)
apply fast
done

lemma sum_region_C: 
"\<lbrakk>(RVal (renv E x), h, GETr G x, p, R, n) \<in> reg_ua;
  context_sum G1 G2 G; x\<in> DOM G1 \<inter>  DOM G2 \<rbrakk> \<Longrightarrow> 
\<exists> n1 n2. (RVal (renv E x), h, GETr G1 x, p, R, n1) \<in> reg_ua
\<and> (RVal (renv E x), h, GETr G2 x, p, R, n2) \<in> reg_ua
\<and> n=n1+n2"
apply (frule  context_sum_reverse_sum)
apply (simp only: context_sum_def)
apply fast
apply (erule exE)
apply (rule_tac G=G in sum_region_reverse)
apply assumption
apply assumption
apply assumption
apply assumption
apply assumption
done


lemma sum_split_2: 
"(E,h, p, U, G, i, R, S) : CS \<Longrightarrow> 
p=True \<longrightarrow> i=2 \<longrightarrow>
(\<forall> UA UB UC G1 G2.  context_sum G1 G2 G \<longrightarrow>
 U=UA \<union> UB \<union> UC \<longrightarrow>
 UA \<subseteq> DOM G1 - DOM G2 \<longrightarrow>  
 UB \<subseteq> DOM G2 - DOM G1 \<longrightarrow> 
 UC \<subseteq> DOM G1 \<inter> DOM G2 \<longrightarrow> 
 (\<exists> RA RB RC SA SB SCA SCB.
 (E,h, True, UA, G1, 2, RA, SA) : CS \<and>
 (E,h, True, UB, G2, 2, RB, SB) : CS \<and>
 (E,h, True, UC, G1, 2, RC, SCA) : CS \<and>
 (E,h, True, UC, G2, 2, RC, SCB) : CS \<and>
  R=RA \<union> RB \<union> RC \<and>
  S = SA + SB + SCA +SCB \<and>
  RA \<inter> RB ={} \<and>  RA \<inter> RC ={} \<and> RB \<inter> RC ={}))"
apply (erule CS.induct)

apply (rule impI)+
apply (rule allI)+
apply (rule impI)+
apply (rule_tac x="{}" in exI)
apply (rule_tac x="{}" in exI)
apply (rule_tac x="{}" in exI)
apply (rule_tac x=0 in exI)
apply (rule_tac x=0 in exI)
apply (rule_tac x=0 in exI)
apply (rule_tac x=0 in exI)
apply (subgoal_tac "UA={}")
apply (subgoal_tac "UB={}")
apply (subgoal_tac "UC={}")
apply simp
apply (rule conjI) apply (rule CS_empty)
apply (rule conjI) apply (rule CS_empty)
apply (rule conjI) apply (rule CS_empty)
apply (rule CS_empty)
apply simp apply fast apply fast

apply (rule impI)+
apply (rule allI)+
apply (rule impI)+
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply simp

apply (rule impI)+
apply (rule allI)+
apply (rule impI)+

apply (drule mp) apply assumption
apply (rotate_tac 11)
apply (drule mp) apply assumption

apply (case_tac "x\<in> UA")
apply (erule_tac x="UA-{x}" in allE)
apply (erule_tac x="UB" in allE)
apply (erule_tac x="UC" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (rotate_tac 12) apply (drule mp) apply assumption
apply (rotate_tac 12) apply (drule mp) apply fast
apply (rotate_tac 12) apply (drule mp)apply fast 
apply (rotate_tac 12) apply (drule mp) apply fast
apply (rotate_tac 12) apply (drule mp) apply fast

apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA \<union> R2" in exI)
apply (rule_tac x="RB" in exI)
apply (rule_tac x="RC" in exI)
apply (rule_tac x="SA+n" in exI)
apply (rule_tac x="SB" in exI)
apply (rule_tac x="SCA" in exI)
apply (rule_tac x="SCB" in exI)

apply (rule conjI)
apply (rule_tac x=x and U=UA in CS_2)
apply assumption apply assumption
apply (drule sum_region_A)
apply assumption  
apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) 
apply (rotate_tac 1)apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 1)apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl) apply fast

apply simp apply fast

apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 

apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply fast 
apply (rule conjI) apply fast 
apply assumption 

apply (case_tac "x\<in> UB")
apply (erule_tac x="UA" in allE)
apply (erule_tac x="UB-{x}" in allE)
apply (erule_tac x="UC" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (rotate_tac 13) apply (drule mp) apply assumption 
apply (rotate_tac 13) apply (drule mp) apply fast
apply (rotate_tac 13) apply (drule mp) apply fast
apply (rotate_tac 13) apply (drule mp) apply fast
apply (rotate_tac 13) apply (drule mp) apply fast

apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA" in exI)
apply (rule_tac x="RB \<union> R2" in exI)
apply (rule_tac x="RC" in exI)
apply (rule_tac x="SA" in exI)
apply (rule_tac x="SB+n" in exI)
apply (rule_tac x="SCA" in exI)
apply (rule_tac x="SCB" in exI)

apply (rule conjI) apply simp

apply (rule conjI)
apply (rule_tac x=x and U=UB in CS_2)
apply assumption apply assumption
apply (drule sum_region_B)
apply assumption  
apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl)
apply (rotate_tac 1)apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 1)apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl) apply fast

apply simp apply fast

apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 
apply (rule conjI) apply fast

apply (rule conjI) apply simp
apply (rule conjI) apply fast 
apply (rule conjI) apply assumption 
apply fast


apply (case_tac "x\<in> UC")
apply (erule_tac x="UA" in allE)
apply (erule_tac x="UB" in allE)
apply (erule_tac x="UC-{x}" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (rotate_tac 14) apply (drule mp) apply assumption 
apply (rotate_tac 14) apply (drule mp) apply fast
apply (rotate_tac 14) apply (drule mp) apply fast
apply (rotate_tac 14) apply (drule mp) apply fast
apply (rotate_tac 14) apply (drule mp) apply fast
apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA" in exI)
apply (rule_tac x="RB" in exI)
apply (rule_tac x="RC \<union> R2" in exI)
apply (rule_tac x="SA" in exI)
apply (rule_tac x="SB" in exI)
apply (drule sum_region_C)
apply assumption
apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (rotate_tac 1)apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 1)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply fast

apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="SCA+n1" in exI)
apply (rule_tac x="SCB+n2" in exI)

apply (rule conjI) apply assumption
apply (rule conjI) apply assumption

apply (rule conjI)apply (rule_tac x=x and U=UC in CS_2)
apply assumption apply assumption
apply simp apply fast

apply (rule conjI)
apply (rule_tac x=x and U=UC in CS_2)
apply assumption apply assumption
apply simp apply fast

apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply assumption 
apply (rule conjI) apply fast
apply fast

apply fast
apply (rule impI)+
apply (rule allI)+
apply (rule impI)+
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply simp
done

lemma sum_split_1: 
"(E,h, p, U, G, i, R, S) : CS \<Longrightarrow> 
i=1 \<longrightarrow>
(\<forall> UA UB UC G1 G2.  context_sum G1 G2 G \<longrightarrow>
 U=UA \<union> UB \<union> UC \<longrightarrow>
 UA \<subseteq> DOM G1 - DOM G2 \<longrightarrow>  
 UB \<subseteq> DOM G2 - DOM G1 \<longrightarrow> 
 UC \<subseteq> DOM G1 \<inter> DOM G2 \<longrightarrow> 
 (\<exists> RA RB RC SA SB SCA SCB.
 (E,h, p, UA, G1, 1, RA, SA) : CS \<and>
 (E,h, p, UB, G2, 1, RB, SB) : CS \<and>
 (E,h, p, UC, G1, 1, RC, SCA) : CS \<and>
 (E,h, p, UC, G2, 1, RC, SCB) : CS \<and>
  R=RA \<union> RB \<union> RC \<and>
  S = SA + SB + SCA +SCB \<and>
  RA \<inter> RB ={} \<and>  RA \<inter> RC ={} \<and> RB \<inter> RC ={}))"
apply (erule CS.induct)

apply (rule impI)
apply (rule allI)+
apply (rule impI)+
apply (rule_tac x="{}" in exI)
apply (rule_tac x="{}" in exI)
apply (rule_tac x="{}" in exI)
apply (rule_tac x=0 in exI)
apply (rule_tac x=0 in exI)
apply (rule_tac x=0 in exI)
apply (rule_tac x=0 in exI)
apply (subgoal_tac "UA={}")
apply (subgoal_tac "UB={}")
apply (subgoal_tac "UC={}")
apply simp
apply (rule conjI) apply (rule CS_empty)
apply (rule conjI) apply (rule CS_empty)
apply (rule conjI) apply (rule CS_empty)
apply (rule CS_empty)
apply simp apply fast apply fast

apply (rule impI)+
apply (rule allI)+
apply (rule impI)+

apply (drule mp) apply assumption

apply (case_tac "x\<in> UA")
apply (erule_tac x="UA-{x}" in allE)
apply (erule_tac x="UB" in allE)
apply (erule_tac x="UC" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (drule mp) apply assumption
apply (drule mp) apply fast
apply (drule mp)apply fast 
apply (drule mp) apply fast
apply (drule mp) apply fast

apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA \<union> R2" in exI)
apply (rule_tac x="RB" in exI)
apply (rule_tac x="RC" in exI)
apply (rule_tac x="SA+n" in exI)
apply (rule_tac x="SB" in exI)
apply (rule_tac x="SCA" in exI)
apply (rule_tac x="SCB" in exI)

apply (rule conjI)
apply (rule_tac x=x and U=UA in CS_1)
apply assumption apply assumption
apply (drule sum_region_A)
apply assumption 
apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)  
apply (rotate_tac 1)apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 1)apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl) apply fast

apply assumption apply fast

apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 

apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply fast 
apply (rule conjI) apply fast 
apply assumption 

apply (case_tac "x\<in> UB")
apply (erule_tac x="UA" in allE)
apply (erule_tac x="UB-{x}" in allE)
apply (erule_tac x="UC" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (drule mp) apply assumption 
apply (drule mp) apply fast
apply (drule mp) apply fast
apply (drule mp) apply fast
apply (drule mp) apply fast

apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA" in exI)
apply (rule_tac x="RB \<union> R2" in exI)
apply (rule_tac x="RC" in exI)
apply (rule_tac x="SA" in exI)
apply (rule_tac x="SB+n" in exI)
apply (rule_tac x="SCA" in exI)
apply (rule_tac x="SCB" in exI)

apply (rule conjI) apply simp

apply (rule conjI)
apply (rule_tac x=x and U=UB in CS_1)
apply assumption apply assumption
apply (drule sum_region_B)
apply assumption  
apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)
apply (rotate_tac 1)apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 1)apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl) apply fast

apply assumption apply fast

apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 
apply (rule conjI) apply fast

apply (rule conjI) apply simp
apply (rule conjI) apply fast 
apply (rule conjI) apply assumption 
apply fast


apply (case_tac "x\<in> UC")
apply (erule_tac x="UA" in allE)
apply (erule_tac x="UB" in allE)
apply (erule_tac x="UC-{x}" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (drule mp) apply assumption 
apply (drule mp) apply fast
apply (drule mp) apply fast
apply (drule mp) apply fast
apply (drule mp) apply fast
apply (erule exE)+ apply (erule conjE)+
apply (rule_tac x="RA" in exI)
apply (rule_tac x="RB" in exI)
apply (rule_tac x="RC \<union> R2" in exI)
apply (rule_tac x="SA" in exI)
apply (rule_tac x="SB" in exI)
apply (drule sum_region_C)
apply assumption
apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) 
apply (rotate_tac 1)apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 1)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply fast

apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="SCA+n1" in exI)
apply (rule_tac x="SCB+n2" in exI)

apply (rule conjI) apply assumption
apply (rule conjI) apply assumption

apply (rule conjI)apply (rule_tac x=x and U=UC in CS_1)
apply assumption apply assumption
apply assumption apply fast

apply (rule conjI)
apply (rule_tac x=x and U=UC in CS_1)
apply assumption apply assumption
apply assumption apply fast

apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply assumption 
apply (rule conjI) apply fast
apply fast

apply fast

apply (rule impI)+
apply (rule allI)+
apply (rule impI)+
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply simp

apply (rule impI)+
apply (rule allI)+
apply (rule impI)+
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl)
apply simp
done


lemma sum_split: 
"(E,h, p, U, G, i, R, S) : CS \<Longrightarrow> 
\<forall> UA UB UC G1 G2.  context_sum G1 G2 G \<longrightarrow>
 U=UA \<union> UB \<union> UC \<longrightarrow>
 UA \<subseteq> DOM G1 - DOM G2 \<longrightarrow>  
 UB \<subseteq> DOM G2 - DOM G1 \<longrightarrow> 
 UC \<subseteq> DOM G1 \<inter> DOM G2 \<longrightarrow> 
 (\<exists> RA RB RC SA SB SCA SCB.
 (E,h, p, UA, G1, i, RA, SA) : CS \<and>
 (E,h, p, UB, G2, i, RB, SB) : CS \<and>
 (E,h, p, UC, G1, i, RC, SCA) : CS \<and>
 (E,h, p, UC, G2, i, RC, SCB) : CS \<and>
  R=RA \<union> RB \<union> RC \<and>
  S = SA + SB + SCA +SCB)"
apply (erule CS.induct)

apply (rule allI)+
apply (rule impI)+
apply (rule_tac x="{}" in exI)
apply (rule_tac x="{}" in exI)
apply (rule_tac x="{}" in exI)
apply (rule_tac x=0 in exI)
apply (rule_tac x=0 in exI)
apply (rule_tac x=0 in exI)
apply (rule_tac x=0 in exI)
apply (subgoal_tac "UA={}")
apply (subgoal_tac "UB={}")
apply (subgoal_tac "UC={}")
apply simp
apply (rule conjI) apply (rule CS_empty)
apply (rule conjI) apply (rule CS_empty)
apply (rule conjI) apply (rule CS_empty)
apply (rule CS_empty)
apply simp apply fast apply fast

(* CS_1- branch starts \<dots> *)

apply (rule allI)+
apply (rule impI)+

apply (case_tac "x\<in> UA")
apply (erule_tac x="UA-{x}" in allE)
apply (erule_tac x="UB" in allE)
apply (erule_tac x="UC" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA \<union> R2" in exI)
apply (rule_tac x="RB" in exI)
apply (rule_tac x="RC" in exI)
apply (rule_tac x="SA+n" in exI)
apply (rule_tac x="SB" in exI)
apply (rule_tac x="SCA" in exI)
apply (rule_tac x="SCB" in exI)

apply (rule conjI)
apply (rule_tac x=x and U=UA in CS_1)
apply assumption apply assumption
apply (drule sum_region_A)
apply assumption  apply fast
apply assumption apply fast

apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 

apply (rule conjI) apply fast
apply simp

apply (case_tac "x\<in> UB")
apply (erule_tac x="UA" in allE)
apply (erule_tac x="UB-{x}" in allE)
apply (erule_tac x="UC" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (drule mp) apply assumption
apply (drule mp) apply fast
apply (drule mp) apply fast
apply (drule mp) apply fast
apply (drule mp) apply fast
apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA" in exI)
apply (rule_tac x="RB \<union> R2" in exI)
apply (rule_tac x="RC" in exI)
apply (rule_tac x="SA" in exI)
apply (rule_tac x="SB+n" in exI)
apply (rule_tac x="SCA" in exI)
apply (rule_tac x="SCB" in exI)

apply (rule conjI)
apply assumption
apply (rule conjI)
apply (rule_tac x=x and U=UB in CS_1)
apply assumption apply assumption
apply (drule sum_region_B)
apply assumption  apply fast
apply assumption apply fast

apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 
apply (rule conjI) apply fast
apply simp

apply (case_tac "x\<in> UC")
apply (erule_tac x="UA" in allE)
apply (erule_tac x="UB" in allE)
apply (erule_tac x="UC-{x}" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA" in exI)
apply (rule_tac x="RB" in exI)
apply (rule_tac x="RC \<union> R2" in exI)
apply (rule_tac x="SA" in exI)
apply (rule_tac x="SB" in exI)
apply (drule sum_region_C)
apply assumption
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="SCA+n1" in exI)
apply (rule_tac x="SCB+n2" in exI)

apply (rule conjI)
apply assumption
apply (rule conjI)
apply assumption
apply (rule conjI)
apply (rule_tac x=x and U=UC in CS_1)
apply assumption apply assumption
apply assumption apply fast
apply (rule conjI)
apply (rule_tac x=x and U=UC in CS_1)
apply assumption apply assumption
apply assumption apply fast


apply (rule conjI) apply fast
apply simp

apply fast


(* CS_2-branch starts \<dots> *)

apply (rule allI)+
apply (rule impI)+

apply (case_tac "x\<in> UA")
apply (erule_tac x="UA-{x}" in allE)
apply (erule_tac x="UB" in allE)
apply (erule_tac x="UC" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (rotate_tac 9)
apply (drule mp)
apply assumption
apply (rotate_tac 10)
apply (drule mp)
apply fast
apply (rotate_tac 10)
apply (drule mp)
apply fast
apply (rotate_tac 10)
apply (drule mp)
apply fast
apply (rotate_tac 10)
apply (drule mp)
apply fast
apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA \<union> R2" in exI)
apply (rule_tac x="RB" in exI)
apply (rule_tac x="RC" in exI)
apply (rule_tac x="SA+n" in exI)
apply (rule_tac x="SB" in exI)
apply (rule_tac x="SCA" in exI)
apply (rule_tac x="SCB" in exI)

apply (rule conjI)
apply (rule_tac x=x and U=UA in CS_2)
apply assumption apply assumption
apply (drule sum_region_A)
apply assumption  apply fast
apply assumption apply fast

apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 

apply (rule conjI) apply fast
apply simp

apply (case_tac "x\<in> UB")
apply (erule_tac x="UA" in allE)
apply (erule_tac x="UB-{x}" in allE)
apply (erule_tac x="UC" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (rotate_tac 11)
apply (drule mp)
apply assumption
apply (rotate_tac 11)
apply (drule mp)
apply fast
apply (rotate_tac 11)
apply (drule mp)
apply fast
apply (rotate_tac 11)
apply (drule mp)
apply fast
apply (rotate_tac 11)
apply (drule mp)
apply fast
apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA" in exI)
apply (rule_tac x="RB \<union> R2" in exI)
apply (rule_tac x="RC" in exI)
apply (rule_tac x="SA" in exI)
apply (rule_tac x="SB+n" in exI)
apply (rule_tac x="SCA" in exI)
apply (rule_tac x="SCB" in exI)

apply (rule conjI)
apply assumption
apply (rule conjI)
apply (rule_tac x=x and U=UB in CS_2)
apply assumption apply assumption
apply (drule sum_region_B)
apply assumption  apply fast
apply assumption 
apply fast

apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 
apply (rule conjI) apply fast
apply simp

apply (case_tac "x\<in> UC")
apply (erule_tac x="UA" in allE)
apply (erule_tac x="UB" in allE)
apply (erule_tac x="UC-{x}" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (rotate_tac 12)
apply (drule mp)
apply assumption
apply (rotate_tac 12)
apply (drule mp)
apply fast
apply (rotate_tac 12)
apply (drule mp)
apply fast
apply (rotate_tac 12)
apply (drule mp)
apply fast
apply (rotate_tac 12)
apply (drule mp)
apply fast
apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA" in exI)
apply (rule_tac x="RB" in exI)
apply (rule_tac x="RC \<union> R2" in exI)
apply (rule_tac x="SA" in exI)
apply (rule_tac x="SB" in exI)
apply (drule sum_region_C)
apply assumption
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="SCA+n1" in exI)
apply (rule_tac x="SCB+n2" in exI)

apply (rule conjI)
apply assumption
apply (rule conjI)
apply assumption
apply (rule conjI)
apply (rule_tac x=x and U=UC in CS_2)
apply assumption apply assumption
apply assumption apply fast
apply (rule conjI)
apply (rule_tac x=x and U=UC in CS_2)
apply assumption apply assumption
apply assumption apply fast

apply (rule conjI) apply fast
apply simp

apply fast

(* CS_3- branch starts \<dots> *)

apply (rule allI)+
apply (rule impI)+

apply (case_tac "x\<in> UA")
apply (erule_tac x="UA-{x}" in allE)
apply (erule_tac x="UB" in allE)
apply (erule_tac x="UC" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA \<union> R2" in exI)
apply (rule_tac x="RB" in exI)
apply (rule_tac x="RC" in exI)
apply (rule_tac x="SA+n" in exI)
apply (rule_tac x="SB" in exI)
apply (rule_tac x="SCA" in exI)
apply (rule_tac x="SCB" in exI)

apply (rule conjI)
apply (rule_tac x=x and U=UA in CS_3)
apply assumption apply assumption
apply (drule sum_region_A)
apply assumption  apply fast
apply assumption 

apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 

apply (rule conjI) apply fast
apply simp

apply (case_tac "x\<in> UB")
apply (erule_tac x="UA" in allE)
apply (erule_tac x="UB-{x}" in allE)
apply (erule_tac x="UC" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA" in exI)
apply (rule_tac x="RB \<union> R2" in exI)
apply (rule_tac x="RC" in exI)
apply (rule_tac x="SA" in exI)
apply (rule_tac x="SB+n" in exI)
apply (rule_tac x="SCA" in exI)
apply (rule_tac x="SCB" in exI)

apply (rule conjI)
apply assumption
apply (rule conjI)
apply (rule_tac x=x and U=UB in CS_3)
apply assumption apply assumption
apply (drule sum_region_B)
apply assumption  apply fast
apply assumption

apply (rule conjI) apply assumption 
apply (rule conjI) apply assumption 
apply (rule conjI) apply fast
apply simp

apply (case_tac "x\<in> UC")
apply (erule_tac x="UA" in allE)
apply (erule_tac x="UB" in allE)
apply (erule_tac x="UC-{x}" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2" in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (erule exE)+ apply (erule_tac conjE)+
apply (rule_tac x="RA" in exI)
apply (rule_tac x="RB" in exI)
apply (rule_tac x="RC \<union> R2" in exI)
apply (rule_tac x="SA" in exI)
apply (rule_tac x="SB" in exI)
apply (drule sum_region_C)
apply assumption
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="SCA+n1" in exI)
apply (rule_tac x="SCB+n2" in exI)

apply (rule conjI)
apply assumption
apply (rule conjI)
apply assumption
apply (rule conjI)
apply (rule_tac x=x and U=UC in CS_3)
apply assumption apply assumption
apply assumption
apply (rule conjI)
apply (rule_tac x=x and U=UC in CS_3)
apply assumption apply assumption
apply assumption 

apply (rule conjI) apply fast
apply simp

apply fast
done

(*********************************************************) 


lemma let1_dom: "\<lbrakk> x \<in> U21;
                   U11 \<inter> U12 ={}; U11 \<inter> U13 ={}; U12 \<inter> U13 ={}; 
                   U21 \<inter> U22 ={}; U21 \<inter> U23 ={}; U22 \<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={};
                   U11 \<union> U12 \<union> U13 \<subseteq> D;
                   U21 \<union> U22 \<union> U23 \<subseteq> D \<union> {x}\<rbrakk>
                    \<Longrightarrow> U1 \<union> U2 \<union> U3 \<subseteq> D"
apply auto
done

lemma let1_disj: "\<lbrakk>x \<in> U21;
                   U11 \<inter> U12 ={}; U11 \<inter> U13 ={}; U12 \<inter> U13 ={}; 
                   U21 \<inter> U22 ={}; U21 \<inter> U23 ={}; U22 \<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} \<rbrakk>
                    \<Longrightarrow> U1 \<inter> U2 ={} \<and> U1 \<inter> U3 ={} \<and> U2 \<inter> U3 ={}"
apply auto
done

lemma let1_disj12:"\<lbrakk>x \<in> U21;
                   U11 \<inter> U12 ={}; U11 \<inter> U13 ={}; U12 \<inter> U13 ={}; 
                   U21 \<inter> U22 ={}; U21 \<inter> U23 ={}; U22 \<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} \<rbrakk>
                    \<Longrightarrow> U1 \<inter> U2 ={}"
apply auto
done

lemma let1_disj13:"\<lbrakk>x \<in> U21;
                   U11 \<inter> U12 ={}; U11 \<inter> U13 ={}; U12 \<inter> U13 ={}; 
                   U21 \<inter> U22 ={}; U21 \<inter> U23 ={}; U22 \<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} \<rbrakk>
                    \<Longrightarrow> U1 \<inter> U3 ={}"
apply auto
done

lemma let1_disj23:"\<lbrakk>x \<in> U21;
                   U11 \<inter> U12 ={}; U11 \<inter> U13 ={}; U12 \<inter> U13 ={}; 
                   U21 \<inter> U22 ={}; U21 \<inter> U23 ={}; U22 \<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} \<rbrakk>
                    \<Longrightarrow> U2 \<inter> U3 ={}"
apply auto
done

text{* We will need to isntantiate CS-s
for conetxts G1, G2  with sets U_IJ, given 
a CS for a sum of G1, G2 with U1, U2, U3. 
We consider U_IJs as a subsets of U1, U2, U3
to get these instantiations.*}

lemma    expr_U11: "\<lbrakk>x \<in> U21;
                   U11 \<inter> U12 ={}; U11 \<inter> U13 ={}; U12 \<inter> U13 ={}; 
                   U21 \<inter> U22 ={}; U21 \<inter> U23 ={}; U22 \<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} \<rbrakk>  \<Longrightarrow> U11=U11 \<inter> U1"
apply auto 
done

lemma    expr_U12: "\<lbrakk>x \<in> U21;
                   U11 \<inter> U12 ={}; U11 \<inter> U13 ={}; U12 \<inter> U13 ={}; 
                   U21 \<inter> U22 ={}; U21 \<inter> U23 ={}; U22 \<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} \<rbrakk> \<Longrightarrow> U12 = U12 \<inter> U1"
apply auto 
done


lemma    expr_U13_rough: "\<lbrakk>x \<in> U21;
                   U11 \<inter> U12 ={}; U11 \<inter> U13 ={}; U12 \<inter> U13 ={}; 
                   U21 \<inter> U22 ={}; U21 \<inter> U23 ={}; U22 \<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} \<rbrakk> \<Longrightarrow> 
                   U13 = (U1  \<inter> U13) \<union> (U2  \<inter> U13) \<union>  (U3  \<inter> U13) \<union> ({x}  \<inter> U13)"
apply auto 
done

                   
text{* About the possibility of "shadowing":
 x \<in> U11 \<union> U12 \<union> U13 \<longrightarrow> x \<in> U1, 
see the let-rule from the usage aspect paper! *}

lemma expr_U13' : " \<lbrakk>x \<in> U21;
                   U11 \<inter> U12 ={}; U11 \<inter> U13 ={}; U12 \<inter> U13 ={}; 
                   U21 \<inter> U22 ={}; U21 \<inter> U23 ={}; U22 \<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} ;
                   x \<in> U11 \<union> U12 \<union> U13 \<longrightarrow> x \<in> U1\<rbrakk> \<Longrightarrow> 
                   {x}  \<inter> U13 ={}"
apply auto
done

lemma expr_U13 : " \<lbrakk>x \<in> U21;
                   U11 \<inter> U12 ={}; U11 \<inter> U13 ={}; U12 \<inter> U13 ={}; 
                   U21 \<inter> U22 ={}; U21 \<inter> U23 ={}; U22 \<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} ;
                   x \<in> U11 \<union> U12 \<union> U13 \<longrightarrow> x \<in> U1\<rbrakk> \<Longrightarrow> 
                   U13 = (U1  \<inter> U13) \<union> (U2  \<inter> U13) \<union>  (U3  \<inter> U13)"
apply auto
done


lemma    expr_U21: "\<lbrakk>x \<in> U21;
                   U11 \<inter> U12 ={}; U11 \<inter> U13 ={}; U12 \<inter> U13 ={}; 
                   U21 \<inter> U22 ={}; U21 \<inter> U23 ={}; U22 \<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} \<rbrakk>  \<Longrightarrow> U21=U1 \<inter> U21 \<union> {x}"
apply auto 
done



lemma    expr_U22: "\<lbrakk>x \<in> U21;
                   U11 \<inter> U12 ={}; U11 \<inter> U13 ={}; U12 \<inter> U13 ={}; 
                   U21 \<inter> U22 ={}; U21 \<inter> U23 ={}; U22 \<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} \<rbrakk> \<Longrightarrow> U22 = U2"
apply simp
done


lemma    expr_U23: "\<lbrakk>x \<in> U21;
                   U11 \<inter> U12 ={}; U11 \<inter> U13 ={}; U12 \<inter> U13 ={}; 
                   U21 \<inter> U22 ={}; U21 \<inter> U23 ={}; U22 \<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} \<rbrakk> \<Longrightarrow> 
                   U23 = U3  \<inter> U23"
apply auto 
done

lemma context_sum_subset1:
"\<lbrakk>context_sum G1 G2 G; M \<subseteq> DOM G1 \<rbrakk> \<Longrightarrow> 
M \<subseteq> DOM G"  
apply (unfold context_sum_def)
apply fast
done

lemma context_sum_subset2:
"\<lbrakk>context_sum G1 G2 G; M \<subseteq> DOM G2 \<rbrakk> \<Longrightarrow> 
M \<subseteq> DOM G"  
apply (unfold context_sum_def)
apply fast
done 

constdefs context_restrict:: "Context \<Rightarrow> rname \<Rightarrow> Context \<Rightarrow> bool"
"context_restrict G x G' ==
DOM G' = DOM G -{x} \<and>
(x \<in> DOM G' \<longrightarrow> GETr G x = GETr G' x)"

lemma CS_2_union_reverse_aux [rule_format]:
"finite U' \<Longrightarrow>
\<forall> R S. (E,h, True, U \<union> U', C, 2, R, S) : CS \<longrightarrow>
U \<inter> U' ={} \<longrightarrow>
(\<exists> R' R'' S' S''. (E, h, True, U, C, 2, R', S'): CS \<and>
(E, h, True, U', C, 2, R'', S''): CS \<and>
R=R' \<union> R'' \<and>  S=S'+S''  \<and>
R' \<inter> R'' ={})"
apply (induct set: Finites)

apply (rule allI)+ 
apply (rule impI)+ 
apply (rule_tac x=R in exI)
apply (rule_tac x="{}" in exI)
apply (rule_tac x=S in exI)
apply (rule_tac x=0 in exI)
apply (rule conjI) apply simp
apply (rule conjI) apply (rule CS_empty)
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply simp

apply (rule allI)+ 
apply (rule impI)+
apply (drule_tac x=x in CS_2_reverse) 
apply simp apply simp
apply (erule exE)+ apply (erule conjE)+
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)
apply (rotate_tac 8) apply (drule mp) apply simp
apply (rotate_tac 8) apply (drule mp) apply simp

apply (erule exE)+ apply (erule conjE)+ 
apply (rule_tac x=R' in exI)
apply (rule_tac x=" R''\<union> R2" in exI)
apply (rule_tac x=S' in exI)
apply (rule_tac x="S''+n" in exI)

apply (rule conjI) apply assumption
apply (rule conjI) apply (rule_tac x=x in CS_2)
apply simp apply simp apply assumption apply fast

apply (rule conjI) apply fast
apply (rule conjI) apply simp apply fast
done

lemma CS_2_union_reverse:
"\<lbrakk>(E,h, True, U \<union> U', C, 2, R, S) : CS; U \<inter> U' ={}\<rbrakk> \<Longrightarrow>
(\<exists> R' R'' S' S''. (E, h, True, U, C, 2, R', S'): CS \<and>
(E, h, True, U', C, 2, R'', S''): CS \<and>
R=R' \<union> R'' \<and>  S=S'+S''  \<and>
R' \<inter> R'' ={})"
apply (rule CS_2_union_reverse_aux)
apply (drule_tac U="U \<union> U'" in CS_Ufinite) apply simp
apply assumption apply assumption
done

lemma CS_2_union3_reverse:
"\<lbrakk>(E,h, True, U \<union> U' \<union> U'', C, 2, R, S) : CS; U \<inter> U' ={}; U \<inter> U'' ={}; U' \<inter> U'' ={}\<rbrakk> \<Longrightarrow>
(\<exists> R' R'' R''' S' S'' S'''. (E, h, True, U, C, 2, R', S'): CS \<and>
(E, h, True, U', C, 2, R'', S''): CS \<and> (E, h, True, U'', C, 2, R''', S'''): CS \<and> 
R=R' \<union> R'' \<union> R''' \<and>  S=S'+S''+S'''    \<and>
R' \<inter> R'' ={} \<and> R' \<inter> R''' ={}  \<and> R'' \<inter> R''' ={})"
apply (drule CS_2_union_reverse)
apply fast
apply (erule exE)+ apply (erule conjE)+
apply (drule CS_2_union_reverse)
apply assumption
apply (erule exE)+ apply (erule conjE)+
apply simp apply fast
done

lemma CS_1_union_reverse_aux [rule_format]:
"finite U' \<Longrightarrow>
\<forall> R S. (E,h, p, U \<union> U', C, 1, R, S) : CS \<longrightarrow>
U \<inter> U' ={} \<longrightarrow>
(\<exists> R' R'' S' S''. (E, h, p, U, C, 1, R', S'): CS \<and>
(E, h, p, U', C, 1, R'', S''): CS \<and>
R=R' \<union> R'' \<and>  S=S'+S''  \<and>
R' \<inter> R'' ={})"
apply (induct set: Finites)

apply (rule allI)+ 
apply (rule impI)+ 
apply (rule_tac x=R in exI)
apply (rule_tac x="{}" in exI)
apply (rule_tac x=S in exI)
apply (rule_tac x=0 in exI)
apply (rule conjI) apply simp
apply (rule conjI) apply (rule CS_empty)
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply simp

apply (rule allI)+ 
apply (rule impI)+
apply (drule_tac x=x in CS_1_reverse) 
apply simp apply simp
apply (erule exE)+ apply (erule conjE)+
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)
apply (drule mp) apply simp
apply (drule mp) apply simp

apply (erule exE)+ apply (erule conjE)+ 
apply (rule_tac x=R' in exI)
apply (rule_tac x=" R''\<union> R2" in exI)
apply (rule_tac x=S' in exI)
apply (rule_tac x="S''+n" in exI)

apply (rule conjI) apply assumption
apply (rule conjI) apply (rule_tac x=x in CS_1)
apply simp apply simp apply assumption apply fast

apply (rule conjI) apply fast
apply (rule conjI) apply simp apply fast
done

lemma CS_1_union_reverse:
"\<lbrakk>(E,h, p, U \<union> U', C, 1, R, S) : CS; U \<inter> U' ={}\<rbrakk> \<Longrightarrow>
(\<exists> R' R'' S' S''. (E, h, p, U, C, 1, R', S'): CS \<and>
(E, h, p, U', C, 1, R'', S''): CS \<and>
R=R' \<union> R'' \<and>  S=S'+S''  \<and>
R' \<inter> R'' ={})"
apply (rule CS_1_union_reverse_aux)
apply (drule_tac U="U \<union> U'" in CS_Ufinite) apply simp
apply assumption apply assumption
done

lemma CS_1_union3_reverse:
"\<lbrakk>(E,h, p, U \<union> U' \<union> U'', C, 1, R, S) : CS; U \<inter> U' ={}; U \<inter> U'' ={}; U' \<inter> U'' ={}\<rbrakk> \<Longrightarrow>
(\<exists> R' R'' R''' S' S'' S'''. (E, h, p, U, C, 1, R', S'): CS \<and>
(E, h, p, U', C, 1, R'', S''): CS \<and> (E, h, p, U'', C, 1, R''', S'''): CS \<and> 
R=R' \<union> R'' \<union> R''' \<and>  S=S'+S''+S'''    \<and>
R' \<inter> R'' ={} \<and> R' \<inter> R''' ={}  \<and> R'' \<inter> R''' ={})"
apply (drule CS_1_union_reverse)
apply fast
apply (erule exE)+ apply (erule conjE)+
apply (drule CS_1_union_reverse)
apply assumption
apply (erule exE)+ apply (erule conjE)+
apply simp apply fast
done

lemma CS_union_reverse_aux [rule_format]:
"finite U' \<Longrightarrow>
\<forall> R S. (E,h, p, U \<union> U', C, i, R, S) : CS \<longrightarrow>
U \<inter> U' ={} \<longrightarrow>
(\<exists> R' R'' S' S''. (E, h, p, U, C, i, R', S'): CS \<and>
(E, h, p, U', C, i, R'', S''): CS \<and>
R=R' \<union> R'' \<and>  S=S'+S'')"
apply (induct set: Finites)

apply (rule allI)+ 
apply (rule impI)+ 
apply (rule_tac x=R in exI)
apply (rule_tac x="{}" in exI)
apply (rule_tac x=S in exI)
apply (rule_tac x=0 in exI)
apply (rule conjI) apply simp
apply (rule conjI) apply (rule CS_empty)
apply (rule conjI) apply simp
apply simp

apply (rule allI)+ 
apply (rule impI)+

apply (case_tac "i=1")
apply (drule_tac x=x in CS_1_reverse) 
apply simp apply simp
apply (erule exE)+ apply (erule conjE)+
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)
apply (drule mp) apply simp
apply (drule mp) apply simp

apply (erule exE)+ apply (erule conjE)+ 
apply (rule_tac x=R' in exI)
apply (rule_tac x=" R''\<union> R2" in exI)
apply (rule_tac x=S' in exI)
apply (rule_tac x="S''+n" in exI)

apply (rule conjI) apply assumption
apply (rule conjI) 
apply (subgoal_tac "x\<in> insert x F")
apply (drule_tac x=x in CS_1)
apply simp apply assumption apply fast
apply simp apply simp
 
apply (rule conjI) apply fast
apply simp



apply (case_tac "i=2")
apply (drule_tac x=x in CS_2_reverse) 
apply simp apply simp
apply (erule exE)+ apply (erule conjE)+
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)
apply (rotate_tac 10) apply (drule mp) apply simp
apply (rotate_tac 10) apply (drule mp) apply simp

apply (erule exE)+ apply (erule conjE)+ 
apply (rule_tac x=R' in exI)
apply (rule_tac x=" R''\<union> R2" in exI)
apply (rule_tac x=S' in exI)
apply (rule_tac x="S''+n" in exI)

apply (rule conjI) apply assumption
apply (rule conjI) 
apply (subgoal_tac "x\<in> insert x F")
apply (drule_tac x=x in CS_2)
apply simp apply assumption apply fast
apply simp apply simp
 
apply (rule conjI) apply fast
apply simp

apply (case_tac "i=3")
apply (drule_tac x=x in CS_3_reverse) 
apply simp apply simp
apply (erule exE)+ apply (erule conjE)+
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)
apply (drule mp) apply simp
apply (drule mp) apply simp

apply (erule exE)+ apply (erule conjE)+ 
apply (rule_tac x=R' in exI)
apply (rule_tac x=" R''\<union> R2" in exI)
apply (rule_tac x=S' in exI)
apply (rule_tac x="S''+n" in exI)

apply (rule conjI) apply assumption
apply (rule conjI) 
apply (subgoal_tac "x\<in> insert x F")
apply (drule_tac x=x in CS_3)
apply simp apply assumption apply fast
apply simp 
 
apply (rule conjI) apply fast
apply simp

apply (erule CS.cases) 
apply simp apply simp apply simp apply simp 
done

lemma CS_union_reverse:
"\<lbrakk>(E,h, p, U \<union> U', C, i, R, S) : CS; U \<inter> U' ={}\<rbrakk>\<Longrightarrow>
(\<exists> R' R'' S' S''. (E, h, p, U, C, i, R', S'): CS \<and>
(E, h, p, U', C, i, R'', S''): CS \<and>
R=R' \<union> R'' \<and>  S=S'+S'')"
apply (rule CS_union_reverse_aux)
apply (drule CS_Ufinite)
apply simp apply assumption apply assumption
done

lemma CS_union3_reverse:
"\<lbrakk>(E,h, p, U \<union> U' \<union> U'', C, i, R, S) : CS; U \<inter> U' ={}; U \<inter> U'' ={}; U' \<inter> U'' ={}\<rbrakk> \<Longrightarrow>
(\<exists> R' R'' R''' S' S'' S'''. (E, h, p, U, C, i, R', S'): CS \<and>
(E, h, p, U', C, i, R'', S''): CS \<and> (E, h, p, U'', C, i, R''', S'''): CS \<and> 
R=R' \<union> R'' \<union> R''' \<and>  S=S'+S''+S''')"
apply (drule CS_union_reverse)
apply fast
apply (erule exE)+ apply (erule conjE)+
apply (drule CS_union_reverse)
apply assumption
apply (erule exE)+ apply (erule conjE)+
apply simp apply fast
done

lemma DAUA1_Letr:
     "\<lbrakk> GG \<rhd> e :  DAUAss U11 U12 U13 n G1  T1 l;
        GG \<rhd> ee : DAUAss U21 U22 U23 l G2  T2 m;
       DOM G1=(U11 \<union> U12 \<union> U13);
       DOM G2=(U21 \<union> U22 \<union> U23);
       x \<in> U21;
       U1 = U11 \<union> U12 \<union> (U21 - {x});
       U2 = U22;
       U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
       U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
       U12 \<inter> (U21 \<union> U22 \<union> U23)={} ;
       x \<in> U11 \<union> U12 \<union> U13 \<longrightarrow> x \<in> U1;
       (context_restrict G2 x G2');
       (context_sum G1 G2' G);
       GETr G2 x = Some T1 \<rbrakk>
     \<Longrightarrow> GG \<rhd> (LET rf x = e IN ee END): DAUAss  U1 U2 U3 n G T2 m "
apply (rule vdm_conseq)
apply (erule vdm_letr) apply assumption
apply (erule thin_rl) apply (erule thin_rl)

apply (rule allI)+ apply (rule impI)
apply (erule exE)+ apply (erule conjE)+
apply (rotate_tac 14) apply (erule thin_rl)
apply (unfold  DAUAss_def) apply (erule conjE)+

(***)

apply (rule conjI)
apply (erule thin_rl) apply (erule thin_rl) 
apply (rotate_tac 17) apply (erule thin_rl)
apply (rotate_tac 1)apply (erule thin_rl)
apply (rule_tac x=x and D="DOM G" in  let1_dom)
apply assumption  
apply (rotate_tac 12) apply assumption 
apply (rotate_tac 14) apply assumption 
apply assumption
apply (rotate_tac 13) apply assumption 
apply (rotate_tac 15) apply assumption apply assumption
apply assumption apply assumption
apply assumption
apply assumption apply assumption

apply (rule_tac M="U11 \<union> U12 \<union> U13" in context_sum_subset1)
apply assumption apply assumption 

apply (simp only: context_restrict_def)
apply (simp only: context_sum_def)
apply (rotate_tac 1) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply fast

apply (rule conjI)
apply (erule thin_rl) apply (erule thin_rl)
apply (rotate_tac 7)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl)
apply (rotate_tac 7)apply (erule thin_rl) 
apply (rotate_tac 12)apply (erule thin_rl) 
apply simp apply fast
(***)
apply (rule conjI)
apply (erule thin_rl) apply (erule thin_rl)
apply (rotate_tac 7)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl)
apply (rotate_tac 7)apply (erule thin_rl) 
apply (rotate_tac 12)apply (erule thin_rl) 
apply simp apply fast
(***)
apply (rule conjI)
apply (erule thin_rl) apply (erule thin_rl)
apply (rotate_tac 7)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl)
apply (rotate_tac 7)apply (erule thin_rl) 
apply (rotate_tac 12)apply (erule thin_rl) 
apply simp apply fast

(* The main part *)

apply (rule allI)+ 
apply (rule impI)
apply (erule exE)+
apply (erule conjE)+ 
(***)
apply (drule sum_split_1)
apply (rotate_tac 28) apply (drule mp) apply (simp (no_asm))

apply (erule_tac x="U1 \<inter> (DOM G1 - DOM G2')" in allE)
apply (erule_tac x="U1 \<inter> (DOM G2' - DOM G1)" in allE)
apply (erule_tac x="U1 \<inter> (DOM G1 \<inter>  DOM G2')" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2'" in allE)
apply (rotate_tac 28) apply (drule mp) apply assumption
apply (rotate_tac 28) apply (drule mp)
apply (rotate_tac 19) apply (erule thin_rl)
apply (rotate_tac 1) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (subgoal_tac "U1 \<subseteq> DOM G1 \<union> DOM G2'")
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply fast
apply (simp only: context_sum_def)
apply (simp only: context_restrict_def)
apply fast

apply (rotate_tac 28) apply (drule mp) apply fast
apply (rotate_tac 28) apply (drule mp) apply fast
apply (rotate_tac 28) apply (drule mp) apply fast
apply (erule exE)+
(***)
apply (drule_tac i=2 in sum_split)

apply (erule_tac x="U2 \<inter> (DOM G1 - DOM G2')" in allE)
apply (erule_tac x="U2 \<inter> (DOM G2' - DOM G1)" in allE)
apply (erule_tac x="U2 \<inter> (DOM G1 \<inter>  DOM G2')" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2'" in allE)
apply (rotate_tac 28) apply (drule mp) apply assumption
apply (rotate_tac 28) apply (drule mp)
apply (rotate_tac 19) apply (erule thin_rl)
apply (rotate_tac 1) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (subgoal_tac "U2 \<subseteq> DOM G1 \<union> DOM G2'")
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply fast
apply (erule thin_rl) apply (erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl) 
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl) apply (rotate_tac 1)
apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (subgoal_tac "x \<notin> U2")
apply (simp only: context_restrict_def)
apply fast
apply fast

apply (rotate_tac 28) apply (drule mp) apply fast
apply (rotate_tac 28) apply (drule mp) apply fast
apply (rotate_tac 28) apply (drule mp) apply fast
apply (erule exE)+

apply (rename_tac RA2 RB2 RC2 SA2 SB2 SCA2 SCB2)

(***)
apply (drule_tac i=3 in sum_split)

apply (erule_tac x="U3 \<inter> (DOM G1 - DOM G2')" in allE)
apply (erule_tac x="U3 \<inter> (DOM G2' - DOM G1)" in allE)
apply (erule_tac x="U3 \<inter> (DOM G1 \<inter>  DOM G2')" in allE)
apply (erule_tac x="G1" in allE)
apply (erule_tac x="G2'" in allE)
apply (rotate_tac 28) apply (drule mp) apply assumption
apply (rotate_tac 28) apply (drule mp)
apply (rotate_tac 19) apply (erule thin_rl)
apply (rotate_tac 1) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (subgoal_tac "U3 \<subseteq> DOM G1 \<union> DOM G2'")
apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply fast
apply (rotate_tac 3)
apply (erule thin_rl) 
apply (erule thin_rl) 
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) 
apply (rotate_tac 2)
apply (subgoal_tac "x \<notin> U3")
apply (simp only: context_restrict_def)
apply fast
apply fast

apply (rotate_tac 28) apply (drule mp) apply fast
apply (rotate_tac 28) apply (drule mp) apply fast
apply (rotate_tac 28) apply (drule mp) apply fast
apply (erule exE)+

apply (rename_tac RA3 RB3 RC3 SA3 SB3 SCA3 SCB3)
apply (erule conjE)+

apply (subgoal_tac "(E, h, False, 
U1 \<inter> (DOM G1 - DOM G2') \<inter> U11 \<union> 
U1 \<inter> (DOM G1 - DOM G2') \<inter> U12 \<union>
U1 \<inter> (DOM G1 - DOM G2') \<inter> U13, G1, 1, RA, SA) \<in> CS")
apply (drule CS_1_union3_reverse)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) 
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply fast

apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) 
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply fast

apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) 
apply fast

prefer 2
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (subgoal_tac  "U1 \<inter> (DOM G1 - DOM G2')=U1 \<inter> 
(DOM G1 - DOM G2') \<inter> U11 \<union> U1 \<inter> (DOM G1 - DOM G2') \<inter> U12 \<union> U1 \<inter> (DOM G1 - DOM G2') \<inter> U13")
apply simp apply fast

(*******)

apply (subgoal_tac "(E, h, False, 
U2 \<inter> (DOM G1 - DOM G2') \<inter> U11 \<union> 
U2 \<inter> (DOM G1 - DOM G2') \<inter> U12 \<union>
U2 \<inter> (DOM G1 - DOM G2') \<inter> U13, G1, 2, RA2, SA2) \<in> CS")
apply (drule_tac i=2 in CS_union3_reverse)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) 
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply fast

apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) 
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply fast

apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) 
apply fast

prefer 2
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (subgoal_tac  "U2 \<inter> (DOM G1 - DOM G2')=U2 \<inter> 
(DOM G1 - DOM G2') \<inter> U11 \<union> U2 \<inter> (DOM G1 - DOM G2') \<inter> U12 \<union> U2 \<inter> (DOM G1 - DOM G2') \<inter> U13")
apply simp apply fast

(*******)