(*<*)
theory DAUA2copy = NILList:
(*>*)

subsection {* Definition of derived assertions*}

subsubsection {* Types, contexts, regions, size of contexts*}

datatype Type = UnitET | IntET | ListET nat


(*>*)
text {*Region calculation*}
consts reg_ua :: "(val \<times> heap \<times> (Type option) \<times> bool \<times> (locn set) \<times> nat) set"
inductive reg_ua intros
regInt_ua:   "(IVal i ,h,Some IntET, p, {}, 0): reg_ua"
regUnit_ua:   "(v,h,Some UnitET, p, {}, 0): reg_ua"
regListNull_ua:  "(RVal Nullref, h, Some(ListET k), p, {}, 0) : reg_ua"
regListCons_ua: "\<lbrakk>h@@a = Some DIAM;
                h<a\<bullet>DOLLAR> \<noteq> 2;
                a \<notin> R1\<union>R2 ; 
                (IVal h<a\<bullet>F0>, h, Some IntET, p, R1, n1) : reg_ua;
                (RVal h\<lfloor>a\<diamondsuit>F1\<rfloor>, h,  Some(ListET k), p, R2, n2) : reg_ua;
                p \<longrightarrow> R1\<inter>R2={}\<rbrakk> \<Longrightarrow> 
                (RVal (Ref a), h, Some(ListET k), p, {a}\<union>R1\<union>R2 , k+n1+n2): reg_ua"



lemma region_ua_in_heap: "(v, h, T, p, R, m): reg_ua \<Longrightarrow> R \<subseteq> Dom h"
apply (erule reg_ua.induct)
apply simp+
apply (simp add: fmap_lookup_def fmap_dom_def)
apply best
done


lemma reg_ua_Preserved [rule_format]:
"(v,h,T, p, R,S):reg_ua \<Longrightarrow> 
  ((\<forall> l. l : R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (v,h1,T, p, R,S):reg_ua)"
apply (erule reg_ua.induct)
apply (rule impI) apply (rule regInt_ua) 
apply (rule impI) apply (rule regUnit_ua) 
apply (rule impI) apply (rule regListNull_ua)
apply (rule impI) apply (rule regListCons_ua)
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply assumption
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply assumption
done

lemma reg_ua_sameHeap:
"\<lbrakk>(v,h,T, p, R,S):reg_ua; sameOH R h h1\<rbrakk> \<Longrightarrow> (v,h1,T, p, R,S):reg_ua"
apply (rule reg_ua_Preserved)
apply assumption
apply (simp add: sameOH_def)
done

lemma reg_ua_sameHeapRegSubset:
"\<lbrakk>(v,h,T, p, R,S):reg_ua; sameOH R1 h h1; R \<subseteq> R1\<rbrakk> \<Longrightarrow> (v,h1,T, p, R,S):reg_ua"
apply (rule reg_ua_sameHeap)
apply assumption
apply (simp add: sameOH_def, fast)
done


lemma reg_ua_Int: "(Ival i, h, Some IntET, p, R, m): reg_ua \<Longrightarrow> R={} \<and> m=0"
apply (erule reg_ua.cases)
apply clarify+
done

lemma reg_ua_Unit: "(v, h, Some UnitET, p, R, m): reg_ua \<Longrightarrow> R={} \<and> m=0"
apply (erule reg_ua.cases)
apply clarify+
done

lemma reg_ua_Null: "(RVal Nullref, h, Some (ListET k), p, R, m): reg_ua \<Longrightarrow> R={} \<and> m=0"
apply (erule reg_ua.cases)
apply clarify+
done

lemma reg_ua_Cons:
"(RVal (Ref a), h, Some(ListET k), p, R, m): reg_ua \<Longrightarrow>
                h@@a = Some DIAM \<and>
                h<a\<bullet>DOLLAR> \<noteq> 2 \<and>
 (\<exists> R1 R2 n1 n2. 
                a \<notin> R1\<union>R2 \<and>
                (IVal h<a\<bullet>F0>, h, Some IntET, p, R1, n1) : reg_ua \<and>
                (RVal h\<lfloor>a\<diamondsuit>F1\<rfloor>, h,  Some(ListET k), p, R2, n2) : reg_ua \<and>
                (p \<longrightarrow> R1\<inter>R2={}) \<and>
                R={a}\<union>R1\<union>R2 \<and> 
                m=k+n1+n2)"
apply (erule reg_ua.cases)
apply clarify apply clarify apply clarify
apply (rule conjI) apply clarify
apply (rule conjI) apply clarify
apply (rule exI)+
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply clarify
apply (rule conjI) apply clarify
apply clarify
done


lemma reg_ua_Unique[rule_format]: 
"(v, h, T, p, R, S) : reg_ua \<Longrightarrow> ( \<forall> RR SS . (v, h, T, p, RR, SS) : reg_ua \<longrightarrow> (R=RR \<and> S=SS))"
apply (erule reg_ua.induct)

apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Int) apply simp
apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Unit )apply simp
apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Null )apply simp

apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Cons)
apply (erule conjE)+
apply (erule exE)+
apply (erule conjE)+
apply (rename_tac R1' R2' n1' n2')
apply (drule_tac x="R1'" in spec) 
apply (drule_tac x="R2'" in spec) 
apply (drule_tac x="n1'" in spec) 
apply (drule_tac x="n2'" in spec) 
apply safe
done

lemma reg_ua_UniqueReg:
"\<lbrakk>(v, h, T, p, R, S) : reg_ua; (v, h, T, p, RR, SS) : reg_ua\<rbrakk>  \<Longrightarrow> R=RR"
apply (drule  reg_ua_Unique)
apply assumption
apply (erule conjE) apply assumption
done

lemma reg_ua_UniqueNumber:
"\<lbrakk>(v, h, T, p, R, S) : reg_ua; (v, h, T, p, RR, SS) : reg_ua\<rbrakk>  \<Longrightarrow> S=SS"
apply (drule  reg_ua_Unique)
apply assumption
apply (erule conjE) apply assumption
done

lemma reg_ua_WeakFalse:
"(v, h, T, p, R, S) : reg_ua  \<Longrightarrow> (v, h, T, False, R, S) : reg_ua"
apply (erule reg_ua.induct)
apply (rule regInt_ua)
apply (rule regUnit_ua)
apply (rule regListNull_ua)
apply (rule regListCons_ua)
apply assumption
apply assumption
apply assumption
apply assumption
apply assumption
apply clarify
done

lemma reg_ua_WeakTrue:
"(v, h, T, True, R, S) : reg_ua  \<Longrightarrow> (v, h, T, p, R, S) : reg_ua"
apply (case_tac "p=True")
apply clarify
apply (subgoal_tac "p=False")
apply clarify
apply (rule reg_ua_WeakFalse)
apply assumption
apply simp
done


lemma checker_weakFalse:
"(v, h, T, True, R, S) : reg_ua  \<Longrightarrow> (v, h, T, False, R, S) : reg_ua "
apply (rule reg_ua_WeakFalse)
apply assumption
done


lemma checker_weakTrue:
"(v, h, T, True, R, S) : reg_ua  \<Longrightarrow> (v, h, T, False, R, S) : reg_ua "
apply (rule reg_ua_WeakFalse)
apply assumption
done

text{*Contexts*}
types Context = "(rname \<leadsto>\<^sub>f Type)"

constdefs DOM:: "Context \<Rightarrow> rname set"
"DOM == fmap_dom"

constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Type option)"
"GETr G x \<equiv> fmap_lookup G x"

lemma GETrNDomNone: "x \<notin> DOM C \<Longrightarrow> None = GETr C x"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GETrSomeDom: "GETr C x = Some T \<Longrightarrow> x \<in>  DOM C"
apply (insert  GETrNDomNone)
apply fastsimp
done



lemma GETrNoneNDom: "GETr C x = None \<Longrightarrow> x \<notin> DOM C"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)


text{*Size of contexts, i.e. the region inhabited, and the number
      of freelist-cells owned by a context.*}


consts CS_1::"(env \<times> heap \<times> bool \<times> (rname set) \<times> Context \<times> (locn set) \<times> nat) set"
inductive CS_1 intros
CS_1empty: "(E,h,p, {}, C, {}, 0) : CS_1"
CS_1step: "\<lbrakk>x \<in> U; 
       (E,h, p, U-{x}, C,R1, m):CS_1;
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R2,n): reg_ua; 
        R1 \<inter> R2 = {}\<rbrakk>
        \<Longrightarrow> (E,h, p, U, C, R1 \<union> R2, m+n) : CS_1"



consts CS_2::"(env \<times> heap \<times> bool \<times> (rname set) \<times> Context \<times> (locn set) \<times> nat) set"
inductive CS_2 intros
CS_2empty: "(E,h,p, {}, C, {}, 0) : CS_2"
CS_2step: "\<lbrakk> x \<in> U;
        (E,h, p, U-{x}, C,R1, m):CS_2;
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p, R2,n): reg_ua;
        p \<longrightarrow> R1 \<inter> R2 = {}\<rbrakk>
        \<Longrightarrow> (E,h, p, U, C, R1 \<union> R2, m+n) : CS_2"


consts CS_3::"(env \<times> heap \<times> bool \<times> (rname set) \<times> Context \<times> (locn set) \<times> nat) set"
inductive CS_3 intros
CS_3empty: "(E,h,p, {}, C, {}, 0) : CS_3"
CS_3step: "\<lbrakk>x \<in> U; 
       (E,h, p, U-{x}, C,R1, m):CS_3;
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, False, R2,n): reg_ua\<rbrakk>
        \<Longrightarrow> (E,h, p, U, C, R1 \<union> R2, m+n) : CS_3"


lemma CS_1emptyU:"(E,h,p, {}, C, R, S) : CS_1 \<Longrightarrow> R={} \<and> S=0"
apply (erule CS_1.cases)
apply clarify
apply clarsimp+
done


lemma CS_2emptyU:"(E,h,p, {}, C, R, S) : CS_2 \<Longrightarrow> R={} \<and> S=0"
apply (erule CS_2.cases)
apply clarify
apply clarsimp+
done

lemma CS_3emptyU:"(E,h,p, {}, C, R, S) : CS_3 \<Longrightarrow> R={} \<and> S=0"
apply (erule CS_3.cases)
apply clarify
apply clarsimp+
done

lemma CS_1_reverse [rule_format]:
"(E,h, p, U, C, R, S) : CS_1 \<Longrightarrow>
\<forall> x. x \<in>  U \<longrightarrow> (\<exists> R1 R2 m n.   
(E,h, p, U-{x}, C,R1, m):CS_1 \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R2,n): reg_ua \<and>
R1 \<inter> R2 = {} \<and>
R = R1 \<union> R2 \<and>
S=m+n)"
apply (erule CS_1.induct)
apply clarify

apply (rule allI) apply (rule impI)
apply (rename_tac "R1'" "R2'" U h "m'" "n'" p "x'" x)
apply (case_tac "x=x'")
apply (rule_tac x=R1' in exI)
apply (rule_tac x=R2' in exI)
apply (rule_tac x=m' in exI)
apply (rule_tac x=n' in exI)
apply simp



apply (erule_tac x=x in allE)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x= "R1 \<union> R2'" in exI)
apply (rule_tac x= "R2" in exI)
apply (rule_tac x= "m+n'" in exI)
apply (rule_tac x=n in exI)
apply (rule conjI)

apply (subgoal_tac "x'\<in>U-{x}")
apply (drule_tac x="x'" and U="U - {x}" in CS_1step)
apply (subgoal_tac "U-{x'}-{x}=U-{x}-{x'}")
apply simp
apply fast
apply assumption
apply fast

apply (subgoal_tac "n'+m=m+n'")
apply simp
apply simp

apply fast

apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply (rule conjI)
apply fast
apply simp
done

lemma CS_2_reverse [rule_format]:
"(E,h, p, U, C, R, S) : CS_2 \<Longrightarrow>
\<forall> x. x \<in>  U \<longrightarrow> (\<exists> R1 R2 m n.   
(E,h, p, U-{x}, C,R1, m):CS_2 \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p, R2,n): reg_ua \<and>
(p \<longrightarrow> R1 \<inter> R2 = {}) \<and>
R = R1 \<union> R2 \<and>
S=m+n)"
apply (erule CS_2.induct)
apply clarify

apply (rule allI) apply (rule impI)
apply (rename_tac "R1'" "R2'" U h "m'" "n'" p "x'" x)

apply (case_tac "x=x'")
apply (rule_tac x=R1' in exI)
apply (rule_tac x=R2' in exI)
apply (rule_tac x=m' in exI)
apply (rule_tac x=n' in exI)
apply simp

apply (erule_tac x=x in allE)
apply (rotate_tac 6)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x= "R1 \<union> R2'" in exI)
apply (rule_tac x= "R2" in exI)
apply (rule_tac x= "m+n'" in exI)
apply (rule_tac x=n in exI)
apply (rule conjI)

apply (subgoal_tac "x'\<in>U-{x}")
apply (drule_tac x="x'" and U="U - {x}" in CS_2step)
apply (subgoal_tac "U-{x'}-{x}=U-{x}-{x'}")
apply simp
apply fast
apply assumption
apply fast

apply (subgoal_tac "n'+m=m+n'")
apply simp
apply simp

apply fast

apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply (rule conjI)
apply fast
apply simp
done


lemma CS_3_reverse [rule_format]:
"(E,h, p, U, C, R, S) : CS_3 \<Longrightarrow>
\<forall> x. x \<in>  U \<longrightarrow> (\<exists> R1 R2 m n.   
(E,h, p, U-{x}, C,R1, m):CS_3 \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, False, R2,n): reg_ua \<and>
R = R1 \<union> R2 \<and>
S=m+n)"
apply (erule CS_3.induct)
apply clarify

apply (rule allI) apply (rule impI)
apply (rename_tac "R1'" "R2'" U h "m'" "n'" p "x'" x)

apply (case_tac "x=x'")
apply (rule_tac x=R1' in exI)
apply (rule_tac x=R2' in exI)
apply (rule_tac x=m' in exI)
apply (rule_tac x=n' in exI)
apply simp

apply (erule_tac x=x in allE)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x= "R1 \<union> R2'" in exI)
apply (rule_tac x= "R2" in exI)
apply (rule_tac x= "m+n'" in exI)
apply (rule_tac x=n in exI)
apply (rule conjI)

apply (subgoal_tac "x'\<in>U-{x}")
apply (drule_tac x="x'" and U="U - {x}" in CS_3step)
apply (subgoal_tac "U-{x'}-{x}=U-{x}-{x'}")
apply simp
apply fast
apply assumption

apply (subgoal_tac "n'+m=m+n'")
apply simp
apply simp

apply fast

apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply simp
done



lemma CS_1_preserved [rule_format]:
"(E,h, p, U, C, R, S) : CS_1 \<Longrightarrow>
(\<forall> l. l\<in> R \<longrightarrow> sameOH {l} h h1) \<longrightarrow>
(E, h1, p, U, C, R, S) : CS_1"
apply (erule CS_1.induct)
apply clarsimp apply (rule CS_1empty)

apply (rule impI)
apply (drule mp) 
apply clarsimp
apply (rule CS_1step)
apply assumption
apply assumption
apply (rule reg_ua_Preserved)
apply assumption
apply simp
apply clarify
done

lemma CS_1_sameHeap:
"\<lbrakk> (E,h, p, U, C, R, S) : CS_1; sameOH R h h1\<rbrakk> \<Longrightarrow>
(E, h1, p, U, C, R, S) : CS_1"
apply (rule CS_1_preserved)
apply assumption
apply (simp add: sameOH_def)
done

lemma CS_1_sameHeapRegSubset:
"\<lbrakk> (E,h, p, U, C, R, S) : CS_1; R\<subseteq>R1; sameOH R1 h h1\<rbrakk> \<Longrightarrow>
(E, h1, p, U, C, R, S) : CS_1"
apply (rule CS_1_preserved)
apply assumption
apply (simp only: sameOH_def)
apply fast
done

lemma CS_2_preserved [rule_format]:
"(E,h, p, U, C, R, S) : CS_2 \<Longrightarrow>
(\<forall> l. l\<in> R \<longrightarrow> sameOH {l} h h1) \<longrightarrow>
(E, h1, p, U, C, R, S) : CS_2"
apply (erule CS_2.induct)
apply clarsimp apply (rule CS_2empty)

apply (rule impI)
apply (drule mp) 
apply clarsimp
apply (rule CS_2step)
apply assumption
apply assumption
apply (rule reg_ua_Preserved)
apply assumption
apply simp
apply assumption
done

lemma CS_2_sameHeap:
"\<lbrakk> (E,h, p, U, C, R, S) : CS_2; sameOH R h h1\<rbrakk> \<Longrightarrow>
(E, h1, p, U, C, R, S) : CS_2"
apply (rule CS_2_preserved)
apply assumption
apply (simp add: sameOH_def)
done

lemma CS_2_sameHeapRegSubset:
"\<lbrakk> (E,h, p, U, C, R, S) : CS_2; R\<subseteq>R1; sameOH R1 h h1\<rbrakk> \<Longrightarrow>
(E, h1, p, U, C, R, S) : CS_2"
apply (rule CS_2_preserved)
apply assumption
apply (simp only: sameOH_def)
apply fast
done

lemma CS_3_preserved [rule_format]:
"(E,h, p, U, C, R, S) : CS_3 \<Longrightarrow>
(\<forall> l. l\<in> R \<longrightarrow> sameOH {l} h h1) \<longrightarrow>
(E, h1, p, U, C, R, S) : CS_3"
apply (erule CS_3.induct)
apply clarsimp apply (rule CS_3empty)

apply (rule impI)
apply (drule mp) 
apply clarsimp
apply (rule CS_3step)
apply assumption
apply assumption
apply (rule reg_ua_Preserved)
apply assumption
apply simp
done

lemma CS_3_sameHeap:
"\<lbrakk> (E,h, p, U, C, R, S) : CS_3; sameOH R h h1\<rbrakk> \<Longrightarrow>
(E, h1, p, U, C, R, S) : CS_3"
apply (rule CS_3_preserved)
apply assumption
apply (simp add: sameOH_def)
done

lemma CS_3_sameHeapRegSubset:
"\<lbrakk> (E,h, p, U, C, R, S) : CS_3; R\<subseteq>R1; sameOH R1 h h1\<rbrakk> \<Longrightarrow>
(E, h1, p, U, C, R, S) : CS_3"
apply (rule CS_3_preserved)
apply assumption
apply (simp only: sameOH_def)
apply fast
done

lemma CS_1_unique [rule_format]:
"(E,h, p, U, C, R, S) : CS_1 \<Longrightarrow>
(\<forall> R' S'. (E, h, p, U, C, R', S') : CS_1 \<longrightarrow> R'=R \<and> S'=S)"
apply (erule CS_1.induct)
apply clarify apply (rule CS_1emptyU) apply assumption

apply (rule allI)+ apply (rule impI)
apply (rotate_tac 5)
apply (erule  CS_1.cases)
apply clarify

apply clarify
apply (rename_tac CC EE RR1 RR2 UU hh mm nn pp xx)

apply (case_tac "x=xx")
apply (erule_tac x=RR1 in allE)
apply (erule_tac x=mm in allE)
apply (drule mp)
apply simp
apply (drule reg_ua_Unique)
apply simp
apply (erule conjE)+
apply (rule conjI)
apply clarify apply clarify

apply (drule_tac x=x and U="UU-{xx}" in CS_1_reverse)
apply fast
apply (erule exE)+
apply (rename_tac R1' R2' m' n')
apply (erule conjE)+
(* add xx to U-{xx}-{x} to get U-{x} *)
apply (subgoal_tac "xx \<in> UU-{x}")
apply (drule_tac x=xx and U="UU-{x}"in CS_1step)
apply (subgoal_tac "UU-{x}-{xx}=UU-{xx}-{x}")
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply simp
apply fast
apply assumption
apply fast

apply (erule_tac x="R1' \<union> RR2" in allE)
apply (erule_tac x="m'+nn" in allE)
apply (drule mp)
apply assumption

apply (drule_tac  v="RVal (renv EE x)" in reg_ua_Unique)
apply assumption
apply (erule conjE)+
apply fastsimp
apply fast
done

lemma CS_2_unique [rule_format]:
"(E,h, p, U, C, R, S) : CS_2 \<Longrightarrow>
(\<forall> R' S'. (E, h, p, U, C, R', S') : CS_2 \<longrightarrow> R'=R \<and> S'=S)"
apply (erule CS_2.induct)
apply clarify apply (rule CS_2emptyU) apply assumption

apply (rule allI)+ apply (rule impI)
apply (rotate_tac 5)
apply (erule  CS_2.cases)
apply clarify

apply clarify
apply (rename_tac CC EE RR1 RR2 UU hh mm nn pp xx)

apply (case_tac "x=xx")
apply (erule_tac x=RR1 in allE)
apply (erule_tac x=mm in allE)
apply (rotate_tac 9)
apply (drule mp)
apply simp
apply (drule reg_ua_Unique)
apply simp
apply (erule conjE)+
apply (rule conjI)
apply clarify apply clarify

apply (drule_tac x=x and U="UU-{xx}" in CS_2_reverse)
apply fast
apply (erule exE)+
apply (rename_tac R1' R2' m' n')
apply (erule conjE)+
(* add xx to U-{xx}-{x} to get U-{x} *)
apply (subgoal_tac "xx \<in> UU-{x}")
apply (drule_tac x=xx and U="UU-{x}"in CS_2step)
apply (subgoal_tac "UU-{x}-{xx}=UU-{xx}-{x}")
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply simp
apply fast
apply assumption
apply fast

apply (erule_tac x="R1' \<union> RR2" in allE)
apply (erule_tac x="m'+nn" in allE)
apply (rotate_tac 14)
apply (drule mp)
apply assumption

apply (drule_tac  v="RVal (renv EE x)" in reg_ua_Unique)
apply assumption
apply (erule conjE)+
apply (rule conjI)
apply fast
apply simp
apply fast
done

lemma CS_3_unique [rule_format]:
"(E,h, p, U, C, R, S) : CS_3 \<Longrightarrow>
(\<forall> R' S'. (E, h, p, U, C, R', S') : CS_3 \<longrightarrow> R'=R \<and> S'=S)"
apply (erule CS_3.induct)
apply clarify apply (rule CS_3emptyU) apply assumption

apply (rule allI)+ apply (rule impI)
apply (rotate_tac 4)
apply (erule  CS_3.cases)
apply clarify

apply clarify
apply (rename_tac CC EE RR1 RR2 UU hh mm nn pp xx)

apply (case_tac "x=xx")
apply (erule_tac x=RR1 in allE)
apply (erule_tac x=mm in allE)
apply (drule mp)
apply simp
apply (drule reg_ua_Unique)
apply simp
apply (erule conjE)+
apply (rule conjI)
apply clarify apply clarify

apply (drule_tac x=x and U="UU-{xx}" in CS_3_reverse)
apply fast
apply (erule exE)+
apply (rename_tac R1' R2' m' n')
apply (erule conjE)+
(* add xx to U-{xx}-{x} to get U-{x} *)
apply (subgoal_tac "xx \<in> UU-{x}")
apply (drule_tac x=xx and U="UU-{x}"in CS_3step)
apply (subgoal_tac "UU-{x}-{xx}=UU-{xx}-{x}")
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) 
apply simp
apply fast
apply assumption

apply (erule_tac x="R1' \<union> RR2" in allE)
apply (erule_tac x="m'+nn" in allE)
apply (drule mp)
apply assumption

apply (drule_tac  v="RVal (renv EE x)" in reg_ua_Unique)
apply assumption
apply (erule conjE)+
apply (rule conjI)
apply fast
apply simp
apply fast
done

lemma CS_1_uniqueReg:
"\<lbrakk>(E,h, p, U, C, R, S) : CS_1;(E, h, p, U, C, R', S'): CS_1\<rbrakk>   \<Longrightarrow> R'=R"
apply (drule CS_1_unique)
apply assumption
apply clarify
done

lemma CS_1_uniqueNumber:
"\<lbrakk>(E,h, p, U, C, R, S) : CS_1;(E, h, p, U, C, R', S'): CS_1\<rbrakk>   \<Longrightarrow> S'=S"
apply (drule CS_1_unique)
apply assumption
apply clarify
done

lemma CS_2_uniqueReg:
"\<lbrakk>(E,h, p, U, C, R, S) : CS_2; (E, h, p, U, C, R', S'): CS_2\<rbrakk>   \<Longrightarrow> R'=R"
apply (drule CS_2_unique)
apply assumption
apply clarify
done

lemma CS_2_uniqueNumber:
"\<lbrakk>(E,h, p, U, C, R, S) : CS_2; (E, h, p, U, C, R', S'): CS_2\<rbrakk>   \<Longrightarrow> S'=S"
apply (drule CS_2_unique)
apply assumption
apply clarify
done


lemma CS_3_uniqueReg:
"\<lbrakk>(E,h, p, U, C, R, S) : CS_3; (E, h, p, U, C, R', S'): CS_3\<rbrakk>   \<Longrightarrow> R'=R"
apply (drule CS_3_unique)
apply assumption
apply clarify
done

lemma CS_3_uniqueNumber:
"\<lbrakk>(E,h, p, U, C, R, S) : CS_3; (E, h, p, U, C, R', S'): CS_3\<rbrakk>   \<Longrightarrow> S'=S"
apply (drule CS_3_unique)
apply assumption
apply clarify
done

(********** Finiteness and Monotonicity ***************)

lemma CS_1_Ufinite:
"(E,h, p, U, C, R, S) : CS_1 \<Longrightarrow> finite U"
apply (erule CS_1.induct)
apply simp
apply simp
done


lemma CS_1_monot_aux [rule_format]:
"finite U'\<Longrightarrow> \<forall> E h p U C R S R' S'.
(E,h, p, U, C, R, S) : CS_1 \<and> (E, h, p, U\<union>U', C, R', S'): CS_1 \<and> U \<inter> U' ={} \<longrightarrow>  
R\<subseteq>R' \<and> S \<le> S'"
apply (induct set: Finites)

apply clarsimp 
apply (drule CS_1_unique)
apply assumption
apply simp

apply (rule allI)+
apply (rule impI)+
apply (erule conjE)+

apply (drule_tac x=x and U="U \<union> insert x F" in CS_1_reverse)
apply simp

apply (erule exE)+
apply (erule conjE)+

apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x=U in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=S in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)

apply simp
apply (erule conjE)+
apply fastsimp
done

lemma CS_1_monot:
"\<lbrakk> (E,h, p, U, C, R, S) : CS_1;   (E, h, p, U', C, R', S'): CS_1 ; U\<subseteq> U'\<rbrakk> \<Longrightarrow>
R\<subseteq>R' \<and> S \<le> S' "
apply (rule_tac U'="U'- U" in CS_1_monot_aux)
apply (drule CS_1_Ufinite)
apply (drule CS_1_Ufinite)
apply simp

apply (rule conjI)
apply assumption

apply (rule conjI) apply (subgoal_tac "U'=U \<union> (U' - U)")
apply simp
apply fastsimp
apply fastsimp
done


(***)


lemma CS_2_Ufinite:
"(E,h, p, U, C, R, S) : CS_2 \<Longrightarrow> finite U"
apply (erule CS_2.induct)
apply simp
apply simp
done


lemma CS_2_monot_aux [rule_format]:
"finite U'\<Longrightarrow> \<forall> E h p U C R S R' S'.
(E,h, p, U, C, R, S) : CS_2 \<and> (E, h, p, U\<union>U', C, R', S'): CS_2 \<and> U \<inter> U' ={} \<longrightarrow>  
R\<subseteq>R' \<and> S \<le> S'"
apply (induct set: Finites)

apply clarsimp 
apply (drule CS_2_unique)
apply assumption
apply simp

apply (rule allI)+
apply (rule impI)+
apply (erule conjE)+

apply (drule_tac x=x and U="U \<union> insert x F" in CS_2_reverse)
apply simp

apply (erule exE)+
apply (erule conjE)+

apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x=U in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=S in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)

apply simp
apply (erule conjE)+
apply fastsimp
done

lemma CS_2_monot:
"\<lbrakk> (E,h, p, U, C, R, S) : CS_2;   (E, h, p, U', C, R', S'): CS_2 ; U\<subseteq> U'\<rbrakk> \<Longrightarrow>
R\<subseteq>R' \<and> S \<le> S' "
apply (rule_tac U'="U'- U" in CS_2_monot_aux)
apply (drule CS_2_Ufinite)
apply (drule CS_2_Ufinite)
apply simp

apply (rule conjI)
apply assumption

apply (rule conjI) apply (subgoal_tac "U'=U \<union> (U' - U)")
apply simp
apply fastsimp
apply fastsimp
done

lemma CS_3_Ufinite:
"(E,h, p, U, C, R, S) : CS_3 \<Longrightarrow> finite U"
apply (erule CS_3.induct)
apply simp
apply simp
done


lemma CS_3_monot_aux [rule_format]:
"finite U'\<Longrightarrow> \<forall> E h p U C R S R' S'.
(E,h, p, U, C, R, S) : CS_3 \<and> (E, h, p, U\<union>U', C, R', S'): CS_3 \<and> U \<inter> U' ={} \<longrightarrow>  
R\<subseteq>R' \<and> S \<le> S'"
apply (induct set: Finites)

apply clarsimp 
apply (drule CS_3_unique)
apply assumption
apply simp

apply (rule allI)+
apply (rule impI)+
apply (erule conjE)+

apply (drule_tac x=x and U="U \<union> insert x F" in CS_3_reverse)
apply simp

apply (erule exE)+
apply (erule conjE)+

apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x=U in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=S in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)

apply simp
apply (erule conjE)+
apply fastsimp
done

lemma CS_3_monot:
"\<lbrakk> (E,h, p, U, C, R, S) : CS_3;   (E, h, p, U', C, R', S'): CS_3 ; U\<subseteq> U'\<rbrakk> \<Longrightarrow>
R\<subseteq>R' \<and> S \<le> S' "
apply (rule_tac U'="U'- U" in CS_3_monot_aux)
apply (drule CS_3_Ufinite)
apply (drule CS_3_Ufinite)
apply simp

apply (rule conjI)
apply assumption

apply (rule conjI) apply (subgoal_tac "U'=U \<union> (U' - U)")
apply simp
apply fastsimp
apply fastsimp
done

(*************************************************)

lemma CS_1_subset_aux [rule_format]:
"finite U' \<Longrightarrow> 
\<forall> E h p U C R S. U'\<subseteq> U \<longrightarrow> (E,h, p, U, C, R, S) : CS_1 \<longrightarrow> 
(\<exists> R' S'. (E, h, p, U-U', C, R', S'): CS_1)" 
apply (induct set: Finites)
apply clarsimp
apply (rule allI)+
apply (rule impI)+

apply (drule_tac x=x and U=U in CS_1_reverse)
apply simp
apply (erule exE)+
apply (erule conjE)+
apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x="U-{x}" in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)
apply (subgoal_tac "F \<subseteq> U - {x}")
apply (drule mp)
apply assumption
apply (drule mp)
apply assumption
apply clarsimp
apply (subgoal_tac  "U - {x} - F=U - insert x F")
apply fastsimp
apply fast
apply fast
done

lemma CS_1_subset: "\<lbrakk> (E,h, p, U, C, R, S) : CS_1; U'\<subseteq> U \<rbrakk> 
\<Longrightarrow> \<exists> R' S'. (E, h, p, U', C, R', S'): CS_1"
apply (subgoal_tac "finite (U-U')")
apply (frule_tac U=U and U'="U-U'" in  CS_1_subset_aux)
apply fast
apply assumption
apply (subgoal_tac "U - (U - U')=U'")
apply simp
apply fast
apply (frule CS_1_Ufinite)
apply simp
done


lemma CS_2_subset_aux [rule_format]:
"finite U' \<Longrightarrow> 
\<forall> E h p U C R S. U'\<subseteq> U \<longrightarrow> (E,h, p, U, C, R, S) : CS_2 \<longrightarrow> 
(\<exists> R' S'. (E, h, p, U-U', C, R', S'): CS_2)" 
apply (induct set: Finites)
apply clarsimp
apply (rule allI)+
apply (rule impI)+

apply (drule_tac x=x and U=U in CS_2_reverse)
apply simp
apply (erule exE)+
apply (erule conjE)+
apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x="U-{x}" in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)
apply (subgoal_tac "F \<subseteq> U - {x}")
apply (rotate_tac 7)
apply (drule mp)
apply assumption
apply (rotate_tac 9)
apply (drule mp)
apply assumption
apply clarsimp
apply (subgoal_tac  "U - {x} - F=U - insert x F")
apply fastsimp
apply fast
apply fast
done

lemma CS_2_subset: "\<lbrakk> (E,h, p, U, C, R, S) : CS_2; U'\<subseteq> U \<rbrakk> 
\<Longrightarrow> \<exists> R' S'. (E, h, p, U', C, R', S'): CS_2"
apply (subgoal_tac "finite (U-U')")
apply (frule_tac U=U and U'="U-U'" in  CS_2_subset_aux)
apply fast
apply assumption
apply (subgoal_tac "U - (U - U')=U'")
apply simp
apply fast
apply (frule CS_2_Ufinite)
apply simp
done

lemma CS_3_subset_aux [rule_format]:
"finite U' \<Longrightarrow> 
\<forall> E h p U C R S. U'\<subseteq> U \<longrightarrow> (E,h, p, U, C, R, S) : CS_3 \<longrightarrow> 
(\<exists> R' S'. (E, h, p, U-U', C, R', S'): CS_3)" 
apply (induct set: Finites)
apply clarsimp
apply (rule allI)+
apply (rule impI)+

apply (drule_tac x=x and U=U in CS_3_reverse)
apply simp
apply (erule exE)+
apply (erule conjE)+
apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x="U-{x}" in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x=m in allE)
apply (subgoal_tac "F \<subseteq> U - {x}")
apply (drule mp)
apply assumption
apply (drule mp)
apply assumption
apply clarsimp
apply (subgoal_tac  "U - {x} - F=U - insert x F")
apply fastsimp
apply fast
apply fast
done

lemma CS_3_subset: "\<lbrakk> (E,h, p, U, C, R, S) : CS_3; U'\<subseteq> U \<rbrakk> 
\<Longrightarrow> \<exists> R' S'. (E, h, p, U', C, R', S'): CS_3"
apply (subgoal_tac "finite (U-U')")
apply (frule_tac U=U and U'="U-U'" in  CS_3_subset_aux)
apply fast
apply assumption
apply (subgoal_tac "U - (U - U')=U'")
apply simp
apply fast
apply (frule CS_3_Ufinite)
apply simp
done


subsubsection {*The heap assertion*}
constdefs freelist::"heap \<Rightarrow> locn set \<Rightarrow> nat \<Rightarrow> bool"
"freelist h F N == (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) : FL"

constdefs modify::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"modify R h hh == \<forall> l . (l: Dom h - R \<longrightarrow> sameOH {l} h hh)"

constdefs DAUAss::"(rname set)  \<Rightarrow>(rname set) \<Rightarrow>(rname set) \<Rightarrow>   
                   nat \<Rightarrow> Context \<Rightarrow>  Type \<Rightarrow> nat \<Rightarrow> vdmassn" ("\<lbrace> _ , _ , _ \<ggreater>  _ , _ \<rbrace>" 1000)
"DAUAss U1  U2  U3 n G T m E h h' v p \<equiv>
  (U1 \<union> U2 \<union> U3) \<subseteq>  (DOM G) \<and> 
  (U1 \<inter> U2) ={} \<and> (U1 \<inter> U3) ={}  \<and>  (U2 \<inter> U3) ={} \<and>   
  (\<forall> q F R1 R2 R3. 
    (\<exists> N K1 K2 K3. 
     freelist h F N \<and>
     (E,h,  False, U1, G, R1, K1):CS_1 \<and> 
     (E,h,  False, U2, G, R2, K2):CS_2 \<and> 
     (E,h,  False, U3, G, R3, K3):CS_3 \<and> 
      (R1 \<inter> (R2 \<union> R3)) = {} \<and>
      (R1 \<union> R2 \<union> R3) \<inter> F = {} \<and> 
      n + (K1+K2+K3) + q \<le> N) \<longrightarrow>
    (\<exists> R' S M FF. (v, h' , Some T,  False, R', S) : reg_ua \<and>
                 (freelist h' FF M) \<and> 
                 (R' \<inter> FF = {}) \<and>  
                 (modify (F \<union> R1) h h') \<and>
                 R' \<subseteq> (R1 \<union> R2  \<union> F) \<and> (* th. 4.3 (1) *)
                 FF \<subseteq> (R1 \<union> F) \<and>
                 (m + S + q \<le> M) \<and> 
                 oheap h = oheap h' \<and>
      ( (\<exists> K2. (E,h, True, U2, G, R2, K2): CS_2) \<longrightarrow>
        (v, h' , Some T, True, R', S) : reg_ua) )  )"

lemma CS_1_TrueFalse:
"(E,h,  p, U, G, R, K):CS_1 \<Longrightarrow> (\<forall> p'. (E,h, p', U, G, R, K):CS_1)"
apply (erule CS_1.induct)
apply clarify apply (rule CS_1empty)

apply clarify 

apply (rule CS_1step)
apply assumption
apply (erule_tac x=p' in allE)
apply assumption
apply assumption
apply assumption
done

lemma CS_3_TrueFalse:
"(E,h,  p, U, G, R, K):CS_3 \<Longrightarrow> (\<forall> p'. (E,h, p', U, G, R, K):CS_3)"
apply (erule CS_3.induct)
apply clarify apply (rule CS_3empty)

apply clarify 

apply (rule CS_3step)
apply assumption
apply (erule_tac x=p' in allE)
apply assumption
apply assumption
done

lemma same_heaps: "h=hh \<Longrightarrow> \<forall> l. sameOH {l} h hh"
apply (simp add: sameOH_def)
done

(****************************************************)


lemma DAUA_null: "\<lbrakk>m \<le> n; T=ListET k\<rbrakk> \<Longrightarrow> GG \<rhd> Null: DAUAss {} {} {} n G T m" 
apply (rule vdm_conseq) apply (rule vdm_null)

apply (rule allI)+ apply (rule impI)
apply (erule conjE)+

apply (unfold DAUAss_def)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule allI)+
apply (rule impI)
apply (erule exE)+
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply (rule_tac x="0" in exI)
apply (rule_tac x="N" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp add: regListNull_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule impI)
apply (simp add: regListNull_ua)
done

lemma DAUA_Int: "\<lbrakk>m \<le> n; T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> expr.Int i: DAUAss {} {} {} n G T m"
apply (rule vdm_conseq) apply (rule vdm_int)
apply (rule allI)+ apply (rule impI)
apply (erule conjE)+

apply (unfold DAUAss_def)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule allI)+
apply (rule impI)
apply (erule exE)+
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply (rule_tac x="0" in exI)
apply (rule_tac x="N" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp add: regInt_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule impI) apply (simp add: regInt_ua)
done


lemma DAUA_IVar: "\<lbrakk>m \<le> n; T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> IVar x: DAUAss {} {} {} n G T m"
apply (rule vdm_conseq) apply (rule vdm_ivar)
apply (rule allI)+ apply (rule impI)
apply (erule conjE)+

apply (unfold DAUAss_def)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule allI)+
apply (rule impI)
apply (erule exE)+
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply (rule_tac x="0" in exI)
apply (rule_tac x="N" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp add: regInt_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule impI) apply (simp add: regInt_ua)
done

lemma DAUA_RVar: "\<lbrakk>m \<le> n; GETr G x = Some T\<rbrakk> \<Longrightarrow> GG \<rhd> RVar x: DAUAss {} {x} {} n G T m"

apply (rule vdm_conseq) apply (rule vdm_rvar)
apply (rule allI)+ apply (rule impI)
apply (erule conjE)+

apply (unfold DAUAss_def)

apply (rule conjI)
apply (simp add:  GETrSomeDom)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule allI)+
apply (rule impI)
apply (erule exE)+
apply (erule conjE)+

apply (rule_tac x="R2" in exI)
apply (rule_tac x="K2" in exI)
apply (rule_tac x="N" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (drule_tac x=x in CS_2_reverse)
apply simp
apply (erule exE)+ apply (erule conjE)+
apply simp
apply (drule CS_2emptyU)
apply simp

apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply fast
apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule impI)
apply (erule exE)

apply (drule_tac x=x in CS_2_reverse)
apply simp
apply (drule_tac x=x in CS_2_reverse)
apply simp
apply (erule exE)+ apply (erule conjE)+
apply simp
apply (drule CS_2emptyU)
apply (drule CS_2emptyU)
apply clarsimp
apply (drule reg_ua_Unique)
apply (rule reg_ua_WeakTrue)
apply assumption
apply simp
done

(* Recall: integer names do not "take part" in U1, U2, U3 *)
lemma DA_Prim: "\<lbrakk>m \<le> n; T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> Primop f x y: DAUAss {} {} {} n G T m"
apply (rule vdm_conseq) apply (rule vdm_prim)
apply (rule allI)+ apply (rule impI)
apply (erule conjE)+

apply (unfold DAUAss_def)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule allI)+
apply (rule impI)
apply (erule exE)+
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply (rule_tac x="0" in exI)
apply (rule_tac x="N" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp add: regInt_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule impI) apply (simp add: regInt_ua)
done

lemma DA_RPrim: "\<lbrakk>GETr G x = Some Tx; GETr G y = Some Ty; m \<le> n; T = IntET\<rbrakk> 
\<Longrightarrow> GG \<rhd> RPrimop f x y: DAUAss {} {} {x, y} n G T m"
apply (rule vdm_conseq) apply (rule vdm_rprim)
apply (rule allI)+ apply (rule impI)
apply (erule conjE)+

apply (unfold DAUAss_def)

apply (rule conjI) apply simp
apply (simp add:  GETrSomeDom)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule allI)+
apply (rule impI)
apply (erule exE)+
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply (rule_tac x="0" in exI)
apply (rule_tac x="N" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp add: regInt_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp
apply (rule conjI) apply simp

apply (rule impI) apply (simp add: regInt_ua)
done
(*******************************************)

lemma modify_monot:
"\<lbrakk>modify M h hh; M\<subseteq>M'\<rbrakk> \<Longrightarrow> modify M' h hh"
apply (unfold modify_def)
apply (rule allI)
apply (rule impI)
apply (erule_tac x=l in allE)
apply (drule mp)
apply fast
apply assumption
done

lemma CS_2_TrueFalse:
"(E,h,  True, U, G, R, K):CS_2 \<Longrightarrow>(E,h, False, U, G, R, K):CS_2"
apply (erule CS_2.induct) 
apply (rule CS_2empty)
apply (rule CS_2step)
apply assumption
apply assumption
apply (rule reg_ua_WeakFalse)
apply assumption
apply clarify
done

lemma DAUAss_monotone_in_U:
"\<lbrakk>DAUAss U1 U2 U3 n C T m E h hh v p; 
  U1 \<subseteq> UU1; U2 \<subseteq> UU2; U3 \<subseteq> UU3;
  UU1 \<union> UU2 \<union> UU3 \<subseteq> DOM C;
  UU1 \<inter> UU2 ={};  UU1 \<inter> UU3 ={};  UU2 \<inter> UU3 ={} \<rbrakk> \<Longrightarrow> DAUAss UU1 UU2 UU3 n C T m E h hh v p"
apply (unfold  DAUAss_def)
apply (erule conjE)+

apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption

apply (rule allI)+
apply (rule impI)

apply (erule exE)+ apply (erule conjE)+
apply (erule_tac x=q in allE)
apply (erule_tac x=F in allE)

apply (frule_tac U=UU1 in CS_1_subset)
apply assumption
apply (frule_tac U=UU2 in CS_2_subset)
apply assumption
apply (frule_tac U=UU3 in CS_3_subset)
apply assumption
apply (erule exE)+
apply (rename_tac R1' R2' R3' S1' S2' S3')
apply (erule_tac x=R1' in allE)
apply (erule_tac x=R2' in allE)
apply (erule_tac x=R3' in allE)
apply (frule_tac U=U1 in CS_1_monot)  apply assumption apply assumption
apply (frule_tac U=U2 in CS_2_monot)  apply assumption apply assumption
apply (frule_tac U=U3 in CS_3_monot)  apply assumption apply assumption
apply (erule conjE)+

apply (drule mp)
apply (rule exI)+
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption

apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (rule conjI) apply fast
apply (rule conjI) apply fast
apply simp

apply (erule exE)+ apply (erule conjE)+

apply (rule_tac x=R' in exI)
apply (rule_tac x=S in exI)
apply (rule_tac x=M in exI)
apply (rule_tac x=FF in exI)
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption

apply (rule conjI) apply (rule modify_monot) apply assumption
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply fast

apply (erule thin_rl) apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (rotate_tac 1) apply (erule thin_rl)
apply (rotate_tac 6)
apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl) 
apply (rule conjI) apply fast
apply (rule conjI) apply fast
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption

apply (rule impI)
apply (drule mp)
apply (erule exE)
apply (drule_tac U=UU2 in CS_2_subset)
apply assumption
apply (rule_tac x=S2' in exI)
apply (erule exE)+
apply (frule CS_2_TrueFalse)
apply (frule CS_2_unique)
apply (rotate_tac 13)
apply assumption
apply simp
apply assumption
done
(***************************************************)
(* Some set theory for "usage-aspect" sets*)


(* correctness lemmas:
   U1 \<union> U2 \<union> U3 \<subseteq> DOM G, provided UIJ \<subseteq> DOM;
   U1, U2, U3 are disjoint, provided U11, U12, U13 are and U21, U22, U23 are.
*)

lemma let1_dom: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                   x \<in> U21;
                   U21\<inter> U22 ={};
                   U21\<inter> U23 ={};
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={};

                   (U11 \<union> U12 \<union> U13) \<subseteq> D;
                   (U21 \<union> U22 \<union> U23) \<subseteq> D \<union> {x}\<rbrakk>
                    \<Longrightarrow> U1 \<union> U2 \<union> U3 \<subseteq> D"
apply (subgoal_tac "(U1 \<union> U2 \<union> U3) \<subseteq> D \<union> {x}")
apply (subgoal_tac "x\<notin> U1")
apply (subgoal_tac "x\<notin> U2")
apply (subgoal_tac "x\<notin> U3")
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl)
apply fast

apply fast 
apply fast
apply fast
apply fast
done

lemma let1_disj: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U21;
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={};

                   U11 \<inter> U12 ={};U11 \<inter> U13 ={};U12 \<inter> U13 ={};
                   U21 \<inter> U22 ={};U21 \<inter> U23 ={};U22 \<inter> U23 ={}\<rbrakk>
                    \<Longrightarrow> U1 \<inter> U2 ={} \<and> U1 \<inter> U3 ={} \<and> U2 \<inter> U3 ={}"
apply (rule conjI)
apply fast
apply (rule conjI)
apply fast
apply fast
done

lemma let1_disj12: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U21;
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={};

                   U11 \<inter> U12 ={};U11 \<inter> U13 ={};U12 \<inter> U13 ={};
                   U21 \<inter> U22 ={};U21 \<inter> U23 ={};U22 \<inter> U23 ={}\<rbrakk>
                    \<Longrightarrow> U1 \<inter> U2 ={}"
apply (drule let1_disj)
apply (assumption)
apply (assumption)
apply (erule thin_rl)apply (erule thin_rl) 
apply (assumption)+

apply (erule conjE)+
apply (assumption)
done

lemma let1_disj13: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U21;
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={};

                   U11 \<inter> U12 ={};U11 \<inter> U13 ={};U12 \<inter> U13 ={};
                   U21 \<inter> U22 ={};U21 \<inter> U23 ={};U22 \<inter> U23 ={}\<rbrakk>
                    \<Longrightarrow> U1 \<inter> U3 ={}"
apply (drule let1_disj)
apply (assumption)
apply (assumption)
apply (erule thin_rl)apply (erule thin_rl) 
apply (assumption)+

apply (erule conjE)+
apply (assumption)
done

lemma let1_disj23: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U21;
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={};

                   U11 \<inter> U12 ={};U11 \<inter> U13 ={};U12 \<inter> U13 ={};
                   U21 \<inter> U22 ={};U21 \<inter> U23 ={};U22 \<inter> U23 ={}\<rbrakk>
                    \<Longrightarrow> U2 \<inter> U3 ={}"
apply (drule let1_disj)
apply (assumption)
apply (assumption)
apply (erule thin_rl)apply (erule thin_rl) 
apply (assumption)+

apply (erule conjE)+
apply (assumption)
done


lemma DOM_Update: "{x} \<union> (DOM b) = DOM (b(x\<mapsto>\<^sub>fk))" by (simp add: DOM_def)

lemma rise_CS_12:
"(E,h, p, U, G, R, K):CS_1 \<Longrightarrow>(E,h, p, U, G, R, K):CS_2"
apply (erule CS_1.induct)
apply (rule CS_2empty)
apply (rule CS_2step)
apply assumption
apply assumption
apply (rule reg_ua_WeakTrue)
apply assumption
apply clarify
done

lemma rise_CS_23:
"(E,h, p, U, G, R, K):CS_2 \<Longrightarrow>(E,h, p, U, G, R, K):CS_3"
apply (erule CS_2.induct)
apply (rule CS_3empty)
apply (rule CS_3step)
apply assumption
apply assumption
apply (rule reg_ua_WeakFalse)
apply assumption
done


constdefs context_sum:: "Context \<Rightarrow> Context \<Rightarrow>  Context \<Rightarrow> bool"
"context_sum G1 G2 G == (DOM G = DOM G1 \<union> DOM G2)
\<and> (\<forall> x. x \<in> DOM G1 \<inter> DOM G2 \<longrightarrow>  
(\<exists> k1 k2 . GETr G1 x = Some (ListET k1) \<and>  
           GETr G2 x = Some (ListET k2) \<and>
           GETr G x = Some (ListET (k1+k2))))"

lemma context_reg_ua [rule_format]:
"(v, h, T, p, R, S) : reg_ua \<Longrightarrow> 
\<forall> R' S' r. v = (RVal r) \<longrightarrow> T = Some (ListET k) \<longrightarrow>
(v, h,  Some (ListET k'), p, R', S') : reg_ua \<longrightarrow> R=R' "
apply  (erule reg_ua.induct)
apply simp
apply simp
apply clarsimp
apply (drule reg_ua_Null) 
apply simp

apply (rule allI)+
apply (rule impI)+
apply (rotate_tac 4)
apply (erule thin_rl)

apply (rotate_tac 5)
apply (erule reg_ua.cases)
apply (rotate_tac 9)
apply fast
apply (rotate_tac 9)
apply fast
apply (rotate_tac 9)
apply fast
apply (rename_tac R1' R2' a' h' k''' n1' n2' p')
apply (erule_tac x="R2'" in allE)
apply (erule_tac x="n2'" in allE)
apply (erule_tac x="h'\<lfloor>a'\<diamondsuit>F1\<rfloor>" in allE)
apply (rotate_tac 15)
apply (drule mp)
apply fast
apply (rotate_tac 15)
apply (drule mp)
apply fast
apply (rotate_tac 15)
apply (drule mp)
apply fast
apply (drule_tac v="IVal h<a\<bullet>F0>" in reg_ua_Unique)
apply fast
apply (erule conjE)+
apply fast
done
 

(* lemma DAUA1_Letr:
     "\<lbrakk> GG \<rhd> e :  DAUAss U11 U12 U13 n G1  T1 l;
        GG \<rhd> ee : DAUAss U21 U22 U23 l G2  T2 m;
        x \<notin> U11\<union> U12\<union> U13;
        x \<in> U21;
        U1 = U11\<union> U12 \<union> (U21-{x});
        U2 = U22;
        U3 = (U13-(U21 \<union> U22)) \<union> U23;
        U11 \<inter> (U21 \<union>  U22 \<union> U23)={};
        U12 \<inter> (U21 \<union>  U22 \<union> U23)={}; 
        (context_sum G1 G2 G);
         GETr G2 x = Some T1
        \<rbrakk>
     \<Longrightarrow> GG \<rhd> (LET rf x = e IN ee END): DAUAss  U1 U2 U3 n G T2 m "
*)

end
