(*<*)
theory DAUA1 = NILList:
(*>*)

subsection {* Definition of derived assertions*}

subsubsection {* Types, contexts, regions, size of contexts*}

datatype Type = UnitET | IntET | ListET nat


(*>*)
text {*Region calculation*}
consts reg_ua :: "(val \<times> heap \<times> (Type option) \<times> bool \<times> (locn set) \<times> nat) set"
inductive reg_ua intros
regInt_ua:   "(IVal i ,h,Some IntET, p, {}, 0): reg_ua"
regUnit_ua:   "(v,h,Some UnitET, p, {}, 0): reg_ua"
regListNull_ua:  "(RVal Nullref, h, Some(ListET k), p, {}, 0) : reg_ua"
regListCons_ua: "\<lbrakk>h@@a = Some DIAM;
                h<a\<bullet>DOLLAR> \<noteq> 2;
                a \<notin> R1\<union>R2 ; 
                (IVal h<a\<bullet>F0>, h, Some IntET, p, R1, n1) : reg_ua;
                (RVal h\<lfloor>a\<diamondsuit>F1\<rfloor>, h,  Some(ListET k), p, R2, n2) : reg_ua;
                p \<longrightarrow> R1\<inter>R2={}\<rbrakk> \<Longrightarrow> 
                (RVal (Ref a), h, Some(ListET k), p, {a}\<union>R1\<union>R2 , k+n1+n2): reg_ua"



lemma region_ua_in_heap: "(v, h, T, p, R, m): reg_ua \<Longrightarrow> R \<subseteq> Dom h"
apply (erule reg_ua.induct)
apply simp+
apply (simp add: fmap_lookup_def fmap_dom_def)
apply best
done


lemma reg_ua_Preserved [rule_format]:
"(v,h,T, p, R,S):reg_ua \<Longrightarrow> 
  ((\<forall> l. l : R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (v,h1,T, p, R,S):reg_ua)"
apply (erule reg_ua.induct)
apply (rule impI) apply (rule regInt_ua) 
apply (rule impI) apply (rule regUnit_ua) 
apply (rule impI) apply (rule regListNull_ua)
apply (rule impI) apply (rule regListCons_ua)
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply assumption
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply assumption
done

lemma reg_ua_sameHeap:
"\<lbrakk>(v,h,T, p, R,S):reg_ua; sameOH R h h1\<rbrakk> \<Longrightarrow> (v,h1,T, p, R,S):reg_ua"
apply (rule reg_ua_Preserved)
apply assumption
apply (simp add: sameOH_def)
done

lemma reg_ua_sameHeapRegSubset:
"\<lbrakk>(v,h,T, p, R,S):reg_ua; sameOH R1 h h1; R \<subseteq> R1\<rbrakk> \<Longrightarrow> (v,h1,T, p, R,S):reg_ua"
apply (rule reg_ua_sameHeap)
apply assumption
apply (simp add: sameOH_def, fast)
done


lemma reg_ua_Int: "(Ival i, h, Some IntET, p, R, m): reg_ua \<Longrightarrow> R={} \<and> m=0"
apply (erule reg_ua.cases)
apply clarify+
done

lemma reg_ua_Unit: "(v, h, Some UnitET, p, R, m): reg_ua \<Longrightarrow> R={} \<and> m=0"
apply (erule reg_ua.cases)
apply clarify+
done

lemma reg_ua_Null: "(RVal Nullref, h, Some (ListET k), p, R, m): reg_ua \<Longrightarrow> R={} \<and> m=0"
apply (erule reg_ua.cases)
apply clarify+
done

lemma reg_ua_Cons:
"(RVal (Ref a), h, Some(ListET k), p, R, m): reg_ua \<Longrightarrow>
                h@@a = Some DIAM \<and>
                h<a\<bullet>DOLLAR> \<noteq> 2 \<and>
 (\<exists> R1 R2 n1 n2. 
                a \<notin> R1\<union>R2 \<and>
                (IVal h<a\<bullet>F0>, h, Some IntET, p, R1, n1) : reg_ua \<and>
                (RVal h\<lfloor>a\<diamondsuit>F1\<rfloor>, h,  Some(ListET k), p, R2, n2) : reg_ua \<and>
                (p \<longrightarrow> R1\<inter>R2={}) \<and>
                R={a}\<union>R1\<union>R2 \<and> 
                m=k+n1+n2)"
apply (erule reg_ua.cases)
apply clarify apply clarify apply clarify
apply (rule conjI) apply clarify
apply (rule conjI) apply clarify
apply (rule exI)+
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply clarify
apply (rule conjI) apply clarify
apply clarify
done


lemma reg_ua_Unique[rule_format]: 
"(v, h, T, p, R, S) : reg_ua \<Longrightarrow> ( \<forall> RR SS . (v, h, T, p, RR, SS) : reg_ua \<longrightarrow> (R=RR \<and> S=SS))"
apply (erule reg_ua.induct)

apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Int) apply simp
apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Unit )apply simp
apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Null )apply simp

apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Cons)
apply (erule conjE)+
apply (erule exE)+
apply (erule conjE)+
apply (rename_tac R1' R2' n1' n2')
apply (drule_tac x="R1'" in spec) 
apply (drule_tac x="R2'" in spec) 
apply (drule_tac x="n1'" in spec) 
apply (drule_tac x="n2'" in spec) 
apply safe
done

lemma reg_ua_UniqueReg:
"\<lbrakk>(v, h, T, p, R, S) : reg_ua; (v, h, T, p, RR, SS) : reg_ua\<rbrakk>  \<Longrightarrow> R=RR"
apply (drule  reg_ua_Unique)
apply assumption
apply (erule conjE) apply assumption
done

lemma reg_ua_UniqueNumber:
"\<lbrakk>(v, h, T, p, R, S) : reg_ua; (v, h, T, p, RR, SS) : reg_ua\<rbrakk>  \<Longrightarrow> S=SS"
apply (drule  reg_ua_Unique)
apply assumption
apply (erule conjE) apply assumption
done

lemma reg_ua_WeakFalse:
"(v, h, T, p, R, S) : reg_ua  \<Longrightarrow> (v, h, T, False, R, S) : reg_ua"
apply (erule reg_ua.induct)
apply (rule regInt_ua)
apply (rule regUnit_ua)
apply (rule regListNull_ua)
apply (rule regListCons_ua)
apply assumption
apply assumption
apply assumption
apply assumption
apply assumption
apply clarify
done

lemma reg_ua_WeakTrue [rule_format]:
"(v, h, T, True, R, S) : reg_ua  \<Longrightarrow> (\<forall> p. (v, h, T, p, R, S) : reg_ua)"
(* apply (erule  reg_ua.cases) *)
apply (erule reg_ua.induct)
apply (rule allI) apply (rule regInt_ua)
apply (rule allI) apply (rule regUnit_ua)
apply (rule allI) apply (rule regListNull_ua)
apply (rule allI) apply (rule regListCons_ua)
apply assumption
apply assumption
apply assumption
apply fast
apply fast
apply assumption
apply clarify
done

lemma checker_weakFalse:
"(v, h, T, True, R, S) : reg_ua  \<Longrightarrow> (v, h, T, False, R, S) : reg_ua "
apply (rule reg_ua_WeakFalse)
apply assumption
done

lemma checker_weakTrue:
"(v, h, T, True, R, S) : reg_ua  \<Longrightarrow> (v, h, T, False, R, S) : reg_ua "
apply (rule reg_ua_WeakFalse)
apply assumption
done

text{*Contexts*}
types Context = "(rname \<leadsto>\<^sub>f Type)"

constdefs DOM:: "Context \<Rightarrow> rname set"
"DOM == fmap_dom"

constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Type option)"
"GETr G x \<equiv> fmap_lookup G x"


text{*Size of contexts, i.e. the region inhabited, and the number
      of freelist-cells owned by a context.*}


consts CS_ua::"(env \<times> heap \<times> bool \<times> (rname set) \<times> nat \<times> Context \<times> (locn set) \<times> nat) set"
inductive CS_ua intros
CS_empty: "(E,h,p, {}, i, C, {}, 0) : CS_ua"
CS_1: "\<lbrakk>x \<in> U; 
       (E,h, p, U-{x}, 1, C,R1, m):CS_ua;
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R2,n): reg_ua; 
        R1 \<inter> R2 = {}\<rbrakk>
        \<Longrightarrow> (E,h, p, U, 1, C, R1 \<union> R2, n+m) : CS_ua"
CS_2: "\<lbrakk> x \<in> U;
        (E,h, p, U-{x}, 2, C,R1, m):CS_ua;
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p, R2,n): reg_ua;
        p \<longrightarrow> R1 \<inter> R2 = {}\<rbrakk>
        \<Longrightarrow> (E,h, p, U, 2, C, R1 \<union> R2, n+m) : CS_ua"
CS_3: "\<lbrakk>x \<in> U; 
       (E,h, p, U-{x}, 3, C,R1, m):CS_ua;
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, False, R2,n): reg_ua\<rbrakk>
        \<Longrightarrow> (E,h, p, U, 3, C, R1 \<union> R2, n+m) : CS_ua"

lemma finite_U: "(E,h,p, U, i, C, R, S) : CS_ua \<Longrightarrow> finite U"
apply (erule CS_ua.induct)
apply clarsimp+
done

lemma CS_emptyU:"(E,h,p, {}, i, C, R, S) : CS_ua \<Longrightarrow> R={} \<and> S=0"
apply (erule CS_ua.cases)
apply clarify
apply clarsimp+
done

lemma CS_1_alt:
       "\<lbrakk>(E,h, p, U, 1, C,R1, m):CS_ua;
        x \<notin> U;  
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R2,n): reg_ua; 
        R1 \<inter> R2 = {}\<rbrakk>
        \<Longrightarrow> (E,h, p, U\<union>{x}, 1, C, R1 \<union> R2, n+m) : CS_ua"
apply (rule_tac x=x and U="U\<union>{x}" in CS_1)
apply simp
apply simp
apply assumption
apply assumption
done

lemma CS_1_reverse_aux:
"(E,h, p, U\<union>{x}, 1, C, R, S) : CS_ua \<Longrightarrow>
\<exists> R1 m. (E,h, p, U, 1, C,R1, m):CS_ua"
apply (erule


lemma CS_1_reverse:
"(E,h, p, U\<union>{x}, 1, C, R, S) : CS_ua \<Longrightarrow>
\<exists> R1 R2 m n.
       (E,h, p, U, 1, C,R1, m):CS_ua \<and>
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R2,n): reg_ua \<and> 
        R =R1 \<union> R2 \<and>  S= m+n  \<and>
        R1 \<inter> R2 = {}"
apply (drule
apply clarsimp
apply clarsimp
apply assumption
apply assumption
apply clarify
done


lemma CS_unique [rule_format]:
"finite U  \<Longrightarrow> 
\<forall> E h p  i C R S. (E,h,p, U, i, C,R,S):CS_ua \<longrightarrow>
(\<forall> RR SS. (E,h,p, U, i, C,RR, SS):CS_ua \<longrightarrow> RR=R \<and> SS=S)"
apply (induct set: Finites)

apply (rule allI)+ apply (rule impI) apply (rule allI)+ apply (rule impI)
apply (drule CS_emptyU)+
apply clarify

apply (rule allI)+ apply (rule impI)apply (rule allI)+ apply (rule impI)
apply (erule CS_ua.cases)
apply simp

apply clarsimp


lemma CS_1_reverse:
"\<lbrakk>(E,h,p, U, 1, C,R,S):CS_ua; x \<in> U\<rbrakk>  \<Longrightarrow> 
(\<exists>  R1' R2' n' m'.
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R1',n'): reg_ua \<and>        
       (E,h, p, U-{x}, 1, C,R2', m'):CS_ua \<and>  
        R1' \<inter> R2' = {} \<and>
        R = R1' \<union> R2' \<and>
        S = n'+m')"
apply (drule_tac E=E and h=h and p=p and C=C in CS_1)

apply clarify



 

lemma CS_1_reverse [rule_format]: 
"(E,h,p, U, 1, C,R,S):CS_ua \<Longrightarrow> 
\<forall> x. x : U \<longrightarrow> 
(\<exists>  R1' R2' n' m'.
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R1',n'): reg_ua \<and>        
       (E,h, p, U-{x}, 1, C,R2', m'):CS_ua \<and>  
        R1' \<inter> R2' = {} \<and>
        R = R1' \<union> R2' \<and>
        S = n'+m')"

lemma CS_1_reverse [rule_format]: 
"(E,h,p, U, 1, C,R,S):CS_ua \<Longrightarrow> 
\<forall> x. x : U \<longrightarrow> 
(\<exists>  R1' R2' n' m'.
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R1',n'): reg_ua \<and>        
       (E,h, p, U-{x}, 1, C,R2', m'):CS_ua \<and>  
        R1' \<inter> R2' = {} \<and>
        R = R1' \<union> R2' \<and>
        S = n'+m')"
apply (erule_tac  CS_ua.induct)
apply clarify

apply (rule allI) apply (rename_tac x')
apply (rule impI) apply (case_tac "x=x'")

apply (rule exI)+
apply force

apply (drule_tac x=x' in spec)
apply (drule mp)
apply clarify
apply (erule exE)+
apply (rule exI)+
apply (erule conjE)+
apply (rule conjI)
apply assumption
apply (rule conjI)
apply (frule_tac U="U - {x'}" in CS_1)


lemma CS_1' [rule_format]: 
"(E,h,p, U, i, C,R,S):CS_ua \<Longrightarrow> 
\<forall> x. x : U  \<longrightarrow> i=1 \<longrightarrow>
(\<exists>  R1' R2' n' m'.
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R1',n'): reg_ua \<and>        
       (E,h, p, U-{x}, 1, C,R2', m'):CS_ua \<and>  
        R1' \<inter> R2' = {} \<and>
        R = R1' \<union> R2' \<and>
        S = n'+m')"
apply (erule CS_ua.induct)
apply simp
apply (rule allI) apply (rule impI)+
apply (rename_tac x')
apply (subgoal_tac "x=x' \<or> \<not>x=x'")
apply (erule disjE)
apply fast
apply (drule_tac x="x'" in spec)
apply (drule mp) apply fast
apply (drule mp) apply assumption
apply (erule exE)+
apply (rule_tac x="R1'" in exI)
apply (rule_tac x="R1 \<union> R2'" in exI)
apply (rule_tac x="n'" in exI)
apply (rule_tac x="n+m'" in exI)
apply (erule conjE)+
apply (rule conjI)
apply assumption
apply (rule conjI)
apply (rule_tac U="U-{x'}" and x="x" and n="n" and m="m'" in CS_1)
apply fast
apply assumption
apply (subgoal_tac "U - {x} - {x'}=U - {x'} - {x}") 
apply simp
apply fast
apply fast
apply fast
apply fast
apply (rule conjI)
apply fast
apply (rule conjI)
apply fast
apply simp
apply simp
apply (rule allI) apply (rule impI)+
apply simp
apply (rule allI) apply (rule impI)+
apply simp
done

lemma CS_2' [rule_format]: 
"(E,h,p, U, i, C,R,S):CS_ua \<Longrightarrow> 
\<forall> x. x : U  \<longrightarrow> i=2 \<longrightarrow>
(\<exists>  R1' R2' n' m'.
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p, R1',n'): reg_ua \<and>        
       (E,h, p, U-{x},2 , C,R2', m'):CS_ua \<and>  
        (p \<longrightarrow> R1' \<inter> R2' = {}) \<and>
        R = R1' \<union> R2' \<and>
        S = n'+m')"
apply (erule CS_ua.induct)
apply simp

apply (rule allI) apply (rule impI)+
apply simp

apply (rule allI) apply (rule impI)+
apply (rename_tac x')
apply (subgoal_tac "x=x' \<or> \<not>x=x'")
apply (erule disjE)
apply fast
apply (drule_tac x="x'" in spec)
apply (rotate_tac 9)
apply (drule mp) apply fast
apply (rotate_tac 9)
apply (drule mp) apply assumption
apply (erule exE)+
apply (rule_tac x="R1'" in exI)
apply (rule_tac x="R1 \<union> R2'" in exI)
apply (rule_tac x="n'" in exI)
apply (rule_tac x="n+m'" in exI)
apply (erule conjE)+
apply (rule conjI)
apply assumption
apply (rule conjI)
apply (rule_tac U="U-{x'}" and x="x" and n="n" and m="m'" in CS_2)
apply fast
apply assumption
apply (subgoal_tac "U - {x} - {x'}=U - {x'} - {x}") 
apply simp
apply fast
apply fast
apply fast
apply fast
apply (rule conjI)
apply fast
apply (rule conjI)
apply fast
apply simp
apply simp
apply (rule allI) apply (rule impI)+
apply simp
done

lemma CS_3' [rule_format]: 
"(E,h,p, U, i, C,R,S):CS_ua \<Longrightarrow> 
\<forall> x. x : U  \<longrightarrow> i=3 \<longrightarrow>
(\<exists>  R1' R2' n' m'.
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, False, R1',n'): reg_ua \<and>        
       (E,h, p, U-{x},3  , C,R2', m'):CS_ua \<and>  
        R = R1' \<union> R2' \<and>
        S = n'+m')"
apply (erule CS_ua.induct)
apply simp

apply (rule allI) apply (rule impI)+
apply simp

apply (rule allI) apply (rule impI)+
apply simp

apply (rule allI) apply (rule impI)+
apply (rename_tac x')
apply (subgoal_tac "x=x' \<or> \<not>x=x'")
apply (erule disjE)
apply fast
apply (drule_tac x="x'" in spec)
apply (rotate_tac 9)
apply (drule mp) apply fast
apply (rotate_tac 9)
apply (drule mp) apply assumption
apply (erule exE)+
apply (rule_tac x="R1'" in exI)
apply (rule_tac x="R1 \<union> R2'" in exI)
apply (rule_tac x="n'" in exI)
apply (rule_tac x="n+m'" in exI)
apply (erule conjE)+
apply (rule conjI)
apply assumption
apply (rule conjI)
apply (rule_tac U="U-{x'}" and x="x" and n="n" and m="m'" in CS_3)
apply fast
apply assumption
apply (subgoal_tac "U - {x} - {x'}=U - {x'} - {x}") 
apply simp
apply fast
apply fast
apply fast
apply (rule conjI)
apply fast
apply simp
apply simp
done

lemma CS_unique [rule_format]:"
(E,h,p, U, i, C,R,S):CS_ua \<Longrightarrow> 
\<forall> S' R'. (E,h,p, U, i, C,R',S'):CS_ua \<longrightarrow> R=R' \<and> S=S'"
apply (erule CS_ua.induct)

apply (rule allI)+ apply (rule impI)
apply (frule CS_emp') apply assumption apply simp

apply (rule allI)+ apply (rule impI)
apply (rotate_tac 7)
apply (frule CS_1')apply assumption apply (simp (no_asm))
apply (erule exE)+
apply (erule conjE)+
apply (rotate_tac 8)
apply (erule allE)+
apply (drule mp) apply assumption
apply (erule conjE)
apply (frule reg_ua_Unique)
apply (rotate_tac 7)
apply assumption
apply (erule conjE)
apply fast

apply (rule allI)+ apply (rule impI)
apply (rotate_tac 7)
apply (frule CS_2')apply assumption apply (simp (no_asm))
apply (erule exE)+
apply (erule conjE)+
apply (rotate_tac 9)
apply (erule allE)+
apply (rotate_tac 11) 
apply (drule mp) apply assumption
apply (erule conjE)
apply (frule reg_ua_Unique)
apply (rotate_tac 7)
apply assumption
apply (erule conjE)
apply fast

apply (rule allI)+ apply (rule impI)
apply (rotate_tac 6)
apply (frule CS_3')apply assumption apply (simp (no_asm))
apply (erule exE)+
apply (erule conjE)+
apply (rotate_tac 8)
apply (erule allE)+
apply (drule mp) apply assumption
apply (erule conjE)
apply (frule reg_ua_Unique)
apply (rotate_tac 7)
apply assumption
apply fast
done

(***)

lemma CS_subset [rule_format]:"
(E,h,p, U, i, C,R,S):CS_ua \<Longrightarrow> 
\<forall> U'. U' \<subseteq>  U \<longrightarrow> (\<exists> R' S'. (E,h,p, U', i, C,R',S'):CS_ua 
                            \<and> R'\<subseteq>R \<and> S'\<le> S)"
apply (erule CS_ua.induct)

apply (rule allI)+ apply (rule impI)
apply (rule_tac x="{}" in exI)
apply (rule_tac x="0" in exI)
apply (rule conjI)
apply (rule CS_empty) apply simp apply simp apply simp
apply fast

apply (rule allI)+ apply (rule impI)
apply (subgoal_tac "x\<in>U' \<or> x \<notin> U'")
apply (erule disjE)
apply (drule_tac x="U'-{x}" in spec)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="R1\<union> R'"in exI)
apply (rule_tac x="n+S'"in exI)
apply (rule conjI)
apply (rule_tac x="x" and U="U'" and R="R1 \<union>  R' " and  n="n" and m="S' "in CS_1)
apply fast
apply assumption
apply assumption
apply fast
apply fast
apply simp
apply (rule conjI)
apply fast
apply simp

apply (erule_tac x="U'" in allE)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="R'"in exI)
apply (rule_tac x="S'"in exI)
apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply simp
apply blast

apply (rule allI)+ apply (rule impI)
apply (subgoal_tac "x\<in>U' \<or> x \<notin> U'")
apply (erule disjE)
apply (drule_tac x="U'-{x}" in spec)
apply (rotate_tac 7)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="R1\<union> R'"in exI)
apply (rule_tac x="n+S'"in exI)
apply (rule conjI)
apply (rule_tac x="x" and U="U'" and R="R1 \<union>  R' " and  n="n" and m="S' "in CS_2)
apply fast
apply assumption
apply assumption
apply fast
apply fast
apply simp
apply (rule conjI)
apply fast
apply simp

apply (erule_tac x="U'" in allE)
apply (rotate_tac 7)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="R'"in exI)
apply (rule_tac x="S'"in exI)
apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply simp
apply blast

apply (rule allI)+ apply (rule impI)
apply (subgoal_tac "x\<in>U' \<or> x \<notin> U'")
apply (erule disjE)
apply (drule_tac x="U'-{x}" in spec)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="R1\<union> R'"in exI)
apply (rule_tac x="n+S'"in exI)
apply (rule conjI)
apply (rule_tac x="x" and U="U'" and R="R1 \<union>  R' " and  n="n" and m="S' "in CS_3)
apply fast
apply assumption
apply assumption
apply fast
apply fast
apply (rule conjI)
apply fast
apply simp

apply (erule_tac x="U'" in allE)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="R'"in exI)
apply (rule_tac x="S'"in exI)
apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply simp
apply blast
done


lemma CS_subset' [rule_format]:"
(E,h,p, U, i, C,R,S):CS_ua \<Longrightarrow> 
\<forall> U' R' S'. U' \<subseteq>  U \<and> (E,h,p, U', i, C,R',S'):CS_ua \<longrightarrow>
            R'\<subseteq>R \<and> S'\<le> S"
apply (erule CS_ua.induct)

apply (rule allI)+ apply (rule impI) apply (erule conjE)
apply (subgoal_tac "U'={}")
apply (drule_tac U="U'" and  R=R' and S=S' in CS_emp')
apply assumption
apply simp
apply simp

apply (rule allI)+ apply (rule impI) apply (erule conjE)
apply (subgoal_tac "x\<in>U' \<or> x \<notin> U'")
apply (erule disjE)

apply (drule_tac x="U'-{x}" in spec)
apply (drule_tac x="R' 
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="R1\<union> R'"in exI)
apply (rule_tac x="n+S'"in exI)
apply (rule conjI)
apply (rule_tac x="x" and U="U'" and R="R1 \<union>  R' " and  n="n" and m="S' "in CS_1)
apply fast
apply assumption
apply assumption
apply fast
apply fast
apply simp
apply (rule conjI)
apply fast
apply simp

apply (erule_tac x="U'" in allE)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="R'"in exI)
apply (rule_tac x="S'"in exI)
apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply simp
apply blast

apply (rule allI)+ apply (rule impI)
apply (subgoal_tac "x\<in>U' \<or> x \<notin> U'")
apply (erule disjE)
apply (drule_tac x="U'-{x}" in spec)
apply (rotate_tac 7)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="R1\<union> R'"in exI)
apply (rule_tac x="n+S'"in exI)
apply (rule conjI)
apply (rule_tac x="x" and U="U'" and R="R1 \<union>  R' " and  n="n" and m="S' "in CS_2)
apply fast
apply assumption
apply assumption
apply fast
apply fast
apply simp
apply (rule conjI)
apply fast
apply simp

apply (erule_tac x="U'" in allE)
apply (rotate_tac 7)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="R'"in exI)
apply (rule_tac x="S'"in exI)
apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply simp
apply blast

apply (rule allI)+ apply (rule impI)
apply (subgoal_tac "x\<in>U' \<or> x \<notin> U'")
apply (erule disjE)
apply (drule_tac x="U'-{x}" in spec)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="R1\<union> R'"in exI)
apply (rule_tac x="n+S'"in exI)
apply (rule conjI)
apply (rule_tac x="x" and U="U'" and R="R1 \<union>  R' " and  n="n" and m="S' "in CS_3)
apply fast
apply assumption
apply assumption
apply fast
apply fast
apply (rule conjI)
apply fast
apply simp

apply (erule_tac x="U'" in allE)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x="R'"in exI)
apply (rule_tac x="S'"in exI)
apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply simp
apply blast
done



lemma intersect1 [rule_format]:
"(E,h,p, U, i, C,R,S):CS_ua \<Longrightarrow> 
\<forall> U1 U2 R1 R2 S1 S2. i=1 \<and> 
U1 \<subseteq> U \<and>  U2 \<subseteq> U  \<and>  (U1 \<inter> U2) ={} \<and> 
(E,h,p, U1, 1, C,R1,S1):CS_ua \<and> (E,h,p, U2, 1, C,R2,S2):CS_ua
 \<longrightarrow> (R1 \<inter> R2) ={}"
apply (erule CS_ua.induct)
apply (rule allI)+
apply (rule impI)
apply (erule conjE)+
apply (subgoal_tac "U1 = {}")
apply (subgoal_tac "U2 = {}")
apply (drule_tac E="E" and h="h" and p="p" and i="i" and U="U1" and C="C" in CS_emp')
apply simp
apply (rotate_tac 7)
apply (drule_tac U="U2" in CS_emp')
apply simp
apply fast
apply fast
apply fast

apply (rule allI)+
apply (rule impI)
apply (erule conjE)+
apply (rename_tac R10 R20 S1 S2)        

apply (subgoal_tac "x\<in>U1\<and>x\<in>U2 \<or> x \<notin> U1\<and>x\<in>U2 \<or> x\<notin>U1\<and>x\<notin> U2")
apply (erule disjE)                       
apply (erule conjE)
apply (erule_tac x=U1 in allE)
apply (erule_tac x=U2 in allE)
apply (erule_tac x=R10 in allE)
apply (erule_tac x=R20 in allE)
apply (erule_tac x=S1 in allE)
apply (erule_tac x=S2 in allE)

apply (drule mp)
apply fast
apply assumption

apply (erule disjE)                       
apply (erule conjE)

apply (drule_tac U="U2" and x="x" in CS_1')
apply assumption
apply simp
apply (erule exE)+
apply (erule conjE)+
apply (erule_tac x=U1 in allE)
apply (erule_tac x="U2-{x}" in allE)
apply (erule_tac x=R10 in allE)
apply (erule_tac x=R2' in allE)
apply (erule_tac x=S1 in allE)
apply (erule_tac x=m' in allE)
apply (drule mp)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply blast
apply (rule conjI) apply fast
apply (rule conjI) apply assumption apply assumption

apply (subgoal_tac "R1=R1' \<and>n=n' ")
apply (subgoal_tac "R10 \<subseteq> R2")
apply fast
apply (




subsubsection {*The heap assertion*}
constdefs freelist::"heap \<Rightarrow> locn set \<Rightarrow> nat \<Rightarrow> bool"
"freelist h F N == (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) : FL"

constdefs mod2::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"mod2 R h hh == \<forall> l . (l: Dom h - R \<longrightarrow> sameOH {l} h hh)"

constdefs DAUAss::"(rname set)  \<Rightarrow>(rname set) \<Rightarrow>(rname set) \<Rightarrow>   
                   nat \<Rightarrow> Context \<Rightarrow>  Type \<Rightarrow> nat \<Rightarrow> vdmassn" ("\<lbrace> _ , _ , _ \<ggreater>  _ , _ \<rbrace>" 1000)
"DAUAss U1  U2  U3 n G T m E h hh v p \<equiv>
  (U1 \<union> U2 \<union> U3) \<subseteq>  (DOM G) \<and> 
  (U1 \<inter> U2) ={} \<and> (U1 \<inter> U3) ={}  \<and>  (U2 \<inter> U3) ={} \<and>   
  (\<forall> q F R1 R2 R3. 
    (\<exists> N P1 P2 P3. 
     freelist h F N \<and>
     (E,h,  False, U1, 1, G,R1,P1):CS_ua \<and> 
     (E,h,  False, U2, 2, G,R2,P2):CS_ua \<and> 
     (E,h,  False, U3, 3, G,R3,P3):CS_ua \<and> 
      (R1 \<inter> (R2 \<union> R3)) = {} \<and>
      (R1 \<union> R2 \<union> R3) \<inter> F = {} \<and> 
      n + (P1+P2+P3) + q \<le> N) \<longrightarrow>
    (\<exists> Rv S M FF. (freelist hh FF M) \<and> 
                 (v,hh,Some T,  False, Rv,S) : reg_ua \<and>
                 (mod2 (F \<union> R1) h hh) \<and>
                 (Rv \<inter> FF = {}) \<and>  
                 Rv \<subseteq> (R1 \<union> R2  \<union> F) \<and>
                 FF \<subseteq> (R1 \<union> F) \<and>
                 (m + S + q \<le> M) \<and> 
                 oheap h = oheap hh \<and>
      ( ( \<exists> P2'. (E,h, True, U2, 2, G,R2,P2'):CS_ua)  \<longrightarrow>
        (v,hh,Some T, True, Rv,S) : reg_ua)))"


(***************************************************)
(* Some set theory for "usage-aspect" sets*)


(* correctness lemmas:
   U1 \<union> U2 \<union> U3 \<subseteq> DOM G, provided UIJ \<subseteq> DOM;
   U1, U2, U3 are disjoint, provided U11, U12, U13 are and U21, U22, U23 are.
*)

lemma let1_dom: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U21;
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={};

                   (U11 \<union> U12 \<union> U13) \<subseteq> D;
                   (U21 \<union> U22 \<union> U23) \<subseteq> D\<rbrakk>
                    \<Longrightarrow> U1 \<union> U2 \<union> U3 \<subseteq> D"
apply fast
done

lemma let1_disj: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U21;
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={};

                   U11 \<inter> U12 ={};U11 \<inter> U13 ={};U12 \<inter> U13 ={};
                   U21 \<inter> U22 ={};U21 \<inter> U23 ={};U22 \<inter> U23 ={}\<rbrakk>
                    \<Longrightarrow> U1 \<inter> U2 ={} \<and> U1 \<inter> U3 ={} \<and> U2 \<inter> U3 ={}"
apply (rule conjI)
apply fast
apply (rule conjI)
apply fast
apply fast
done

lemma let2_dom: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U22;
                   U1 = U11 \<union> U21;
                   U2 = (U12-U21) \<union> (U22-(U11 \<union> U12)-{x});
                   U3 = (U13 - (U21 \<union> U22)) \<union>
                        (U23 - (U11 \<union> U12));
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22;

                   (U11 \<union> U12 \<union> U13) \<subseteq> D;
                   (U21 \<union> U22 \<union> U23) \<subseteq> D\<rbrakk>
                    \<Longrightarrow> U1 \<union> U2 \<union> U3 \<subseteq> D"
apply fast
done


lemma let2_disj: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U22;
                   U1 = U11 \<union> U21;
                   U2 = (U12-U21) \<union> (U22-(U11 \<union> U12)-{x});
                   U3 = (U13 - (U21 \<union> U22)) \<union>
                        (U23 - (U11 \<union> U12));
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22;

                   U11 \<inter> U12 ={};U11 \<inter> U13 ={};U12 \<inter> U13 ={};
                   U21 \<inter> U22 ={};U21 \<inter> U23 ={};U22 \<inter> U23 ={}\<rbrakk>
                    \<Longrightarrow> U1 \<inter> U2 ={} \<and> U1 \<inter> U3 ={} \<and> U2 \<inter> U3 ={}"
apply fast
done

lemma let3_dom: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U23;
                   U1 = U11 \<union> U21;
                   U2 = U22;
                   U3 = (U12 - (U21 \<union> U22))  \<union>
                        (U13 - (U21 \<union> U22)) \<union>
                         U23 - {x};
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22 \<union> U23;

                   (U11 \<union> U12 \<union> U13) \<subseteq> D;
                   (U21 \<union> U22 \<union> U23) \<subseteq> D\<rbrakk>
                    \<Longrightarrow> U1 \<union> U2 \<union> U3 \<subseteq> D"
apply fast
done

lemma let3_disj: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U23;
                   U1 = U11 \<union> U21;
                   U2 = U22;
                   U3 = (U12 - (U21 \<union> U22))  \<union>
                        (U13 - (U21 \<union> U22)) \<union>
                         U23 - {x};
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22 \<union> U23;

                   U11 \<inter> U12 ={};U11 \<inter> U13 ={};U12 \<inter> U13 ={};
                   U21 \<inter> U22 ={};U21 \<inter> U23 ={};U22 \<inter> U23 ={}\<rbrakk>
                    \<Longrightarrow> U1 \<inter> U2 ={} \<and> U1 \<inter> U3 ={} \<and> U2 \<inter> U3 ={}"
apply fast
done

(* some auxiliary staff for shared parts of contexts *)
lemma let1_unions: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U21;
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} \<rbrakk>
                    \<Longrightarrow>
                   U1 \<union> U2 \<union> U3 =  
                   U11 \<union> U12 \<union> U13 \<union> (U21 - {x}) \<union> U22 \<union>  U23"
apply fast
done

lemma let1_unions_shared: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U21;
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={};

                   U = (U11 \<union> U12 \<union> U13)\<inter> (U21 \<union> U22 \<union> U23)\<rbrakk>
                    \<Longrightarrow>
                   (U1 \<union> U2 \<union> U3)\<inter> U =  
                   (U11 \<union> U12 \<union> U13)\<inter> U 
                   \<and>
                   (U1 \<union> U2 \<union> U3)\<inter> U = 
                   (U21 \<union> U22 \<union> U23)\<inter> U "
apply fast
done


lemma let2_unions: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U22;
                   U1 = U11 \<union> U21;
                   U2 = (U12-U21) \<union> (U22-(U11 \<union> U12)-{x});
                   U3 = (U13 - (U21 \<union> U22)) \<union>
                        (U23 - (U11 \<union> U12));
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22\<rbrakk>
                    \<Longrightarrow>
                   U1 \<union> U2 \<union> U3 =  
                   U11 \<union> U12 \<union> U13 \<union> U21 \<union> (U22- {x}) \<union>  U23"
apply fast
done

lemma let2_unions_shared: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U22;
                   U1 = U11 \<union> U21;
                   U2 = (U12-U21) \<union> (U22-(U11 \<union> U12)-{x});
                   U3 = (U13 - (U21 \<union> U22)) \<union>
                        (U23 - (U11 \<union> U12));
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22;

                   U = (U11 \<union> U12 \<union> U13)\<inter> (U21 \<union> U22 \<union> U23)\<rbrakk>
                    \<Longrightarrow> 
                   (U1 \<union> U2 \<union> U3)\<inter> U =  
                   (U11 \<union> U12 \<union> U13)\<inter> U 
                   \<and>
                   (U1 \<union> U2 \<union> U3)\<inter> U = 
                   (U21 \<union> U22 \<union> U23)\<inter> U "
apply fast
done

lemma let3_unions: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U23;
                   U1 = U11 \<union> U21;
                   U2 = U22;
                   U3 = (U12 - (U21 \<union> U22))  \<union>
                        (U13 - (U21 \<union> U22)) \<union>
                         U23 - {x};
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22 \<union> U23\<rbrakk>
                    \<Longrightarrow>
                   U1 \<union> U2 \<union> U3 =  
                   U11 \<union> U12 \<union> U13 \<union> U21 \<union> U22 \<union>  (U23- {x})"
apply fast
done


lemma let3_unions_shared: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U23;
                   U1 = U11 \<union> U21;
                   U2 = U22;
                   U3 = (U12 - (U21 \<union> U22))  \<union>
                        (U13 - (U21 \<union> U22)) \<union>
                         U23 - {x};
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22 \<union> U23; 

                   U = (U11 \<union> U12 \<union> U13)\<inter> (U21 \<union> U22 \<union> U23)\<rbrakk>
                    \<Longrightarrow>
                   (U1 \<union> U2 \<union> U3)\<inter> U =  
                   (U11 \<union> U12 \<union> U13)\<inter> U 
                   \<and>
                   (U1 \<union> U2 \<union> U3)\<inter> U = 
                   (U21 \<union> U22 \<union> U23)\<inter> U "
apply fast
done

(* Below there is a trial to pove something stupid.
   It fails, thanks God. *) 
lemma let3_bad: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U23;
                   U1 = U11 \<union> U21;
                   U2 = U22;
                   U3 = (U12 - (U21 \<union> U22))  \<union>
                        (U13 - (U21 \<union> U22)) \<union>
                         U23 - {x};
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22 \<union> U23 \<rbrakk>
                    \<Longrightarrow>
                   U1 \<union> U2  \<union> U3 = U11 \<union> U12  \<union> U13 "
apply auto
oops
