(*<*)
theory DAUA0 = NILList:
(*>*)

subsection {* Definition of derived assertions*}

subsubsection {* Types, contexts, regions, size of contexts*}

datatype Type = UnitET | IntET | ListET nat


(*>*)
text {*Region calculation*}
consts reg_ua :: "(val \<times> heap \<times> (Type option) \<times> bool \<times> (locn set) \<times> nat) set"
inductive reg_ua intros
regInt_ua:   "\<lbrakk>R={}; S=0\<rbrakk> \<Longrightarrow> 
              (IVal i ,h,Some IntET, p, R, S): reg_ua"
regUnit_ua:   "\<lbrakk>R={}; S=0\<rbrakk> \<Longrightarrow> 
               (v,h,Some UnitET, p, R, S): reg_ua"
regListNull_ua:  "\<lbrakk>R={}; S=0\<rbrakk> \<Longrightarrow> 
                   (RVal Nullref, h, Some(ListET k), p, R, S) : reg_ua"
regListCons_ua: "\<lbrakk>h@@a = Some DIAM;
                h<a\<bullet>DOLLAR> \<noteq> 2;
                h\<lfloor>a\<diamondsuit>F1\<rfloor> = r;
                h<a\<bullet>F0>=iv;
                a \<notin> R1\<union>R2 ; 
                (IVal iv, h, Some IntET, p, R1, n1) : reg_ua;
                (RVal r, h,  Some(ListET k), p, R2, n2) : reg_ua;
                p \<longrightarrow> R1\<inter>R2={};
                R={a}\<union>R1\<union>R2 ; 
                m=k+n1+n2\<rbrakk> \<Longrightarrow> (RVal (Ref a), h, Some(ListET k), p, R, m): reg_ua"


(* compare NILList.thy, lemma mLIST_region_in_heap *)
lemma region_ua_in_heap: "(v, h, A, p, R, m): reg_ua \<Longrightarrow> R \<subseteq> Dom h"
apply (erule reg_ua.induct)
apply simp+
apply (rule conjI)
apply (simp add: fmap_lookup_def fmap_dom_def, fast)
apply fast
done

(* compare DAssU2.thy, reg_Preserved *)
lemma reg_ua_Preserved [rule_format]:
"(v,h,T, p, R,S):reg_ua \<Longrightarrow> 
  ((\<forall> l. l : R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (v,h1,T, p, R,S):reg_ua)"
apply (erule reg_ua.induct)
apply (rule impI, rule regInt_ua) apply  assumption+
apply (rule impI, rule regUnit_ua) apply  assumption+
apply (rule impI, rule regListNull_ua) apply  assumption+
apply (rule impI, rule regListCons_ua)
apply (simp add: sameOH_def)+
done

lemma reg_ua_Int: "(Ival i, h, Some IntET, p, R, m): reg_ua \<Longrightarrow> R={} \<and> m=0"
apply (erule reg_ua.elims)
apply simp+
done

lemma reg_ua_Unit: "(v, h, Some UnitET, p, R, m): reg_ua \<Longrightarrow> R={} \<and> m=0"
apply (erule reg_ua.elims)
apply simp+
done

lemma reg_ua_Null: "(RVal Nullref, h, Some (ListET k), p, R, m): reg_ua \<Longrightarrow> R={} \<and> m=0"
apply (erule reg_ua.elims)
apply simp+
done

lemma reg_ua_Cons:
"(RVal (Ref a), h, Some(ListET k), p, R, m): reg_ua \<Longrightarrow>
                h@@a = Some DIAM \<and>
                h<a\<bullet>DOLLAR> \<noteq> 2 \<and>
 (\<exists> R1 R2 n1 n2. 
                a \<notin> R1\<union>R2 \<and>
                (IVal h<a\<bullet>F0>, h, Some IntET, p, R1, n1) : reg_ua \<and>
                (RVal h\<lfloor>a\<diamondsuit>F1\<rfloor>, h,  Some(ListET k), p, R2, n2) : reg_ua \<and>
                (p \<longrightarrow> R1\<inter>R2={}) \<and>
                R={a}\<union>R1\<union>R2 \<and> 
                m=k+n1+n2)"
apply (erule reg_ua.elims)
apply simp apply simp apply simp  
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule exI)+
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply simp
done

(*only testing lemma, no use*)
lemma reg_ua_Cons1:
"(RVal (Ref a), h, Some(ListET k), True, R, m): reg_ua \<Longrightarrow>
                h@@a = Some DIAM \<and>
                h<a\<bullet>DOLLAR> \<noteq> 2 \<and>
 (\<exists> R1 R2 n1 n2. 
                a \<notin> R1\<union>R2 \<and>
                (IVal h<a\<bullet>F0>, h, Some IntET, True, R1, n1) : reg_ua \<and>
                (RVal h\<lfloor>a\<diamondsuit>F1\<rfloor>, h,  Some(ListET k), True, R2, n2) : reg_ua \<and>
                R1\<inter>R2={} \<and> 
                R={a}\<union>R1\<union>R2 \<and> 
                m=k+n1+n2)"
apply (erule reg_ua.elims)
apply simp apply simp apply simp  
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule exI)+
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply simp
done


lemma reg_ua_Cons':
"\<lbrakk>(RVal (Ref a), h, Some(ListET k), p, R, m): reg_ua; h<a\<bullet>F0>=iv; h\<lfloor>a\<diamondsuit>F1\<rfloor>=r \<rbrakk>\<Longrightarrow>
                h@@a = Some DIAM \<and>
                h<a\<bullet>DOLLAR> \<noteq> 2 \<and>
 (\<exists> R1 R2 n1 n2. 
                a \<notin> R1\<union>R2 \<and>
                (IVal iv, h, Some IntET, p, R1, n1) : reg_ua \<and>
                (RVal r, h,  Some(ListET k), p, R2, n2) : reg_ua \<and>
                (p \<longrightarrow> R1\<inter>R2={}) \<and>
                R={a}\<union>R1\<union>R2 \<and> 
                m=k+n1+n2)"
apply (erule reg_ua.elims)
apply simp apply simp apply simp  
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule exI)+
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply simp
done

lemma reg_ua_Unique[rule_format]: 
"(v, h, T, p, R, S) : reg_ua \<Longrightarrow> ( \<forall> RR SS . (v, h, T, p, RR, SS) : reg_ua \<longrightarrow> (R=RR \<and> S=SS))"
apply (erule reg_ua.induct)

apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Int)apply simp
apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Unit )apply simp
apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Null )apply simp

apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Cons')
apply assumption apply assumption
apply (erule conjE)+ apply (erule exE)+
apply (rename_tac R1' R2' n1' n2')
apply (erule conjE)+
apply (drule_tac x="R1'" in spec) 
apply (drule_tac x="R2'" in spec) 
apply (drule_tac x="n1'" in spec) 
apply (drule_tac x="n2'" in spec) 
apply (rotate_tac 18)
apply (erule impE) apply assumption
apply (erule impE) apply assumption
apply simp
done

lemma reg_ua_UniqueGen[rule_format]: 
"(v, h, T, p, R, S) : reg_ua \<Longrightarrow> 
( p \<longrightarrow> (\<forall> RR SS . (v, h, T, False, RR, SS) : reg_ua \<longrightarrow> (R=RR \<and> S=SS)))"
apply (erule reg_ua.induct)

apply (rule impI) apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Int)apply simp
apply (rule impI) apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Unit )apply simp
apply (rule impI) apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Null )apply simp

apply (rule impI) apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Cons')
apply assumption apply assumption
apply (erule conjE)+ apply (erule exE)+
apply (rename_tac R1' R2' n1' n2')
apply (erule conjE)+
apply (drule mp) apply assumption 
apply (drule mp) apply assumption 
apply (drule_tac x="R1'" in spec) 
apply (drule_tac x="R2'" in spec) 
apply (drule_tac x="n1'" in spec) 
apply (drule_tac x="n2'" in spec) 
apply (rotate_tac 19)
apply (erule impE) apply assumption
apply (erule impE) apply assumption
apply simp
done

lemma reg_ua_UniqueGen'[rule_format]: 
 "\<lbrakk>(v, h, T, True, R, S) \<in> reg_ua; (v, h, T, False, RR, SS) \<in> reg_ua\<rbrakk> \<Longrightarrow> R = RR \<and> S = SS"
apply (rule  reg_ua_UniqueGen)
apply assumption
apply simp
apply assumption
done

lemma reg_ua_1Falsetest: "\<lbrakk>h@@a = Some DIAM;
                h<a\<bullet>DOLLAR> \<noteq> 2;
                h\<lfloor>a\<diamondsuit>F1\<rfloor> = r;
                h<a\<bullet>F0>=iv;
                a \<notin> R1\<union>R2 ; 
                (IVal iv, h, Some IntET, p, R1, n1) : reg_ua;
                (RVal r, h,  Some(ListET k), p, R2, n2) : reg_ua;
                p \<longrightarrow> R1\<inter>R2={};
                R={a}\<union>R1\<union>R2 ; 
                m=k+n1+n2\<rbrakk> \<Longrightarrow> (RVal (Ref a), h, Some(ListET k), True, R, m): reg_ua"
apply (rule regListCons_ua)
apply assumption apply assumption apply assumption apply assumption
apply assumption 
oops
(* the def. is OK *)


lemma reg_ua_Drop[rule_format]: 
"(v, h, T, p, R, S) : reg_ua \<Longrightarrow> (p \<longrightarrow> (v, h, T, False, R, S) : reg_ua) " 
apply (erule reg_ua.induct)

apply (rule impI) apply (rule regInt_ua) apply assumption apply assumption
apply (rule impI) apply (rule regUnit_ua) apply assumption apply assumption
apply (rule impI) apply (rule regListNull_ua) apply assumption apply assumption

apply (rule impI) apply (rule regListCons_ua)
apply assumption apply assumption apply assumption apply assumption
apply assumption
apply (drule mp) apply assumption
apply assumption

apply (rotate_tac 8)
apply (drule mp) apply assumption
apply assumption 
apply simp
apply assumption
apply assumption
done

lemma reg_ua_Drop' : 
"(v, h, T, True, R, S) : reg_ua \<Longrightarrow> (v, h, T, False, R, S) : reg_ua"
apply (rule  reg_ua_Drop)
apply simp+
done

text{*Contexts*}
types Context = "(rname \<leadsto>\<^sub>f Type)"

constdefs DOM:: "Context \<Rightarrow> rname set"
"DOM == fmap_dom"

constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Type option)"
"GETr G x \<equiv> fmap_lookup G x"


text{*Size of contexts, i.e. the region inhabited, and the number
      of freelist-cells owned by a context.*}
consts CS_ua::"(env \<times> heap \<times> bool \<times> (rname set) \<times> nat \<times> Context \<times> (locn set) \<times> nat) set"
inductive CS_ua intros
CS_empty: "\<lbrakk>U={};R={}; S=0\<rbrakk> \<Longrightarrow> (E,h,p, U, i, C,R,S) : CS_ua"
CS_1: "\<lbrakk>x: U;  
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R1,n): reg_ua;       
       (E,h, p, U-{x}, 1, C,R2, m):CS_ua; 
        R1 \<inter> R2 = {}; 
        R = R1 \<union> R2;
        S = n+m\<rbrakk>
        \<Longrightarrow> (E,h, p, U, 1, C,R,S) : CS_ua"
CS_2: "\<lbrakk>x: U;  
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p, R1,n): reg_ua;       
       (E,h, p, U-{x}, 2, C,R2, m):CS_ua; 
        p \<longrightarrow> R1 \<inter> R2 = {}; 
        R = R1 \<union> R2;
        S = n+m\<rbrakk>
        \<Longrightarrow> (E,h, p, U, 2, C,R,S) : CS_ua"
CS_3: "\<lbrakk>x: U;  
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, False, R1,n): reg_ua;       
       (E,h, p, U-{x}, 3, C,R2, m):CS_ua;
        R = R1 \<union> R2;
        S = n+m\<rbrakk>
        \<Longrightarrow> (E,h, p, U, 3, C,R,S) : CS_ua"

lemma CS_emp:"U = {} \<Longrightarrow> (E,h,p, U, i, C,{},0):CS_ua"
apply (rule CS_empty)
apply simp+
done

lemma CS_emp':"\<lbrakk> U = {};(E,h,p, U, i, C,R,S):CS_ua \<rbrakk>  \<Longrightarrow> R ={} \<and> S= 0"
apply (erule CS_ua.elims)
apply simp+
done



lemma CS_1' [rule_format]: 
"(E,h,p, U, i, C,R,S):CS_ua \<Longrightarrow> 
\<forall> x. x : U  \<longrightarrow> i=1 \<longrightarrow>
(\<exists>  R1' R2' n' m'.
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R1',n'): reg_ua \<and>        
       (E,h, p, U-{x}, 1, C,R2', m'):CS_ua \<and>  
        R1' \<inter> R2' = {} \<and>
        R = R1' \<union> R2' \<and>
        S = n'+m')"
apply (erule CS_ua.induct)
apply simp
apply (rule allI) apply (rule impI)+
apply (rename_tac x')
apply (subgoal_tac "x=x' \<or> \<not>x=x'")
apply (erule disjE)
apply fast
apply (drule_tac x="x'" in spec)
apply (drule mp) apply fast
apply (drule mp) apply assumption
apply (erule exE)+
apply (rule_tac x="R1'" in exI)
apply (rule_tac x="R1 \<union> R2'" in exI)
apply (rule_tac x="n'" in exI)
apply (rule_tac x="n+m'" in exI)
apply (erule conjE)+
apply (rule conjI)
apply assumption
apply (rule conjI)
apply (rule_tac U="U-{x'}" and x="x" and n="n" and m="m'" in CS_1)
apply fast
apply assumption
apply (subgoal_tac "U - {x} - {x'}=U - {x'} - {x}") 
apply simp
apply fast
apply fast
apply fast
apply fast
apply (rule conjI)
apply fast
apply (rule conjI)
apply fast
apply simp
apply simp
apply (rule allI) apply (rule impI)+
apply simp
apply (rule allI) apply (rule impI)+
apply simp
done

lemma CS_2' [rule_format]: 
"(E,h,p, U, i, C,R,S):CS_ua \<Longrightarrow> 
\<forall> x. x : U  \<longrightarrow> i=2 \<longrightarrow>
(\<exists>  R1' R2' n' m'.
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p, R1',n'): reg_ua \<and>        
       (E,h, p, U-{x},2 , C,R2', m'):CS_ua \<and>  
        (p \<longrightarrow> R1' \<inter> R2' = {}) \<and>
        R = R1' \<union> R2' \<and>
        S = n'+m')"
apply (erule CS_ua.induct)
apply simp

apply (rule allI) apply (rule impI)+
apply simp

apply (rule allI) apply (rule impI)+
apply (rename_tac x')
apply (subgoal_tac "x=x' \<or> \<not>x=x'")
apply (erule disjE)
apply fast
apply (drule_tac x="x'" in spec)
apply (rotate_tac 9)
apply (drule mp) apply fast
apply (rotate_tac 9)
apply (drule mp) apply assumption
apply (erule exE)+
apply (rule_tac x="R1'" in exI)
apply (rule_tac x="R1 \<union> R2'" in exI)
apply (rule_tac x="n'" in exI)
apply (rule_tac x="n+m'" in exI)
apply (erule conjE)+
apply (rule conjI)
apply assumption
apply (rule conjI)
apply (rule_tac U="U-{x'}" and x="x" and n="n" and m="m'" in CS_2)
apply fast
apply assumption
apply (subgoal_tac "U - {x} - {x'}=U - {x'} - {x}") 
apply simp
apply fast
apply fast
apply fast
apply fast
apply (rule conjI)
apply fast
apply (rule conjI)
apply fast
apply simp
apply simp
apply (rule allI) apply (rule impI)+
apply simp
done

lemma CS_3' [rule_format]: 
"(E,h,p, U, i, C,R,S):CS_ua \<Longrightarrow> 
\<forall> x. x : U  \<longrightarrow> i=3 \<longrightarrow>
(\<exists>  R1' R2' n' m'.
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, False, R1',n'): reg_ua \<and>        
       (E,h, p, U-{x},3  , C,R2', m'):CS_ua \<and>  
        R = R1' \<union> R2' \<and>
        S = n'+m')"
apply (erule CS_ua.induct)
apply simp

apply (rule allI) apply (rule impI)+
apply simp

apply (rule allI) apply (rule impI)+
apply simp

apply (rule allI) apply (rule impI)+
apply (rename_tac x')
apply (subgoal_tac "x=x' \<or> \<not>x=x'")
apply (erule disjE)
apply fast
apply (drule_tac x="x'" in spec)
apply (rotate_tac 9)
apply (drule mp) apply fast
apply (rotate_tac 9)
apply (drule mp) apply assumption
apply (erule exE)+
apply (rule_tac x="R1'" in exI)
apply (rule_tac x="R1 \<union> R2'" in exI)
apply (rule_tac x="n'" in exI)
apply (rule_tac x="n+m'" in exI)
apply (erule conjE)+
apply (rule conjI)
apply assumption
apply (rule conjI)
apply (rule_tac U="U-{x'}" and x="x" and n="n" and m="m'" in CS_3)
apply fast
apply assumption
apply (subgoal_tac "U - {x} - {x'}=U - {x'} - {x}") 
apply simp
apply fast
apply fast
apply fast
apply (rule conjI)
apply fast
apply simp
apply simp
done

lemma CS_unique [rule_format]:"
(E,h,p, U, i, C,R,S):CS_ua \<Longrightarrow> 
\<forall> S' R'. (E,h,p, U, i, C,R',S'):CS_ua \<longrightarrow> R=R' \<and> S=S'"
apply (erule CS_ua.induct)

apply (rule allI)+ apply (rule impI)
apply (frule CS_emp') apply assumption apply simp

apply (rule allI)+ apply (rule impI)
apply (rotate_tac 7)
apply (frule CS_1')apply assumption apply (simp (no_asm))
apply (erule exE)+
apply (erule conjE)+
apply (rotate_tac 8)
apply (erule allE)+
apply (drule mp) apply assumption
apply (erule conjE)
apply (frule reg_ua_Unique)
apply (rotate_tac 7)
apply assumption
apply (erule conjE)
apply fast

apply (rule allI)+ apply (rule impI)
apply (rotate_tac 7)
apply (frule CS_2')apply assumption apply (simp (no_asm))
apply (erule exE)+
apply (erule conjE)+
apply (rotate_tac 9)
apply (erule allE)+
apply (rotate_tac 11) 
apply (drule mp) apply assumption
apply (erule conjE)
apply (frule reg_ua_Unique)
apply (rotate_tac 7)
apply assumption
apply (erule conjE)
apply fast

apply (rule allI)+ apply (rule impI)
apply (rotate_tac 6)
apply (frule CS_3')apply assumption apply (simp (no_asm))
apply (erule exE)+
apply (erule conjE)+
apply (rotate_tac 8)
apply (erule allE)+
apply (drule mp) apply assumption
apply (erule conjE)
apply (frule reg_ua_Unique)
apply (rotate_tac 7)
apply assumption
apply fast
done




subsubsection {*The heap assertion*}
constdefs freelist::"heap \<Rightarrow> locn set \<Rightarrow> nat \<Rightarrow> bool"
"freelist h F N == (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) : FL"

constdefs mod2::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"mod2 R h hh == \<forall> l . (l: Dom h - R \<longrightarrow> sameOH {l} h hh)"

constdefs DAUAss::"(rname set)  \<Rightarrow>(rname set) \<Rightarrow>(rname set) \<Rightarrow>   
                   nat \<Rightarrow> Context \<Rightarrow>  Type \<Rightarrow> nat \<Rightarrow> vdmassn" ("\<lbrace> _ , _ , _ \<ggreater>  _ , _ \<rbrace>" 1000)
"DAUAss U1  U2  U3 n G T m E h hh v p \<equiv>
  (U1 \<union> U2 \<union> U3) \<subseteq>  (DOM G) \<and> 
  (U1 \<inter> U2) ={} \<and> (U1 \<inter> U3) ={}  \<and>  (U2 \<inter> U3) ={} \<and>   
  (\<forall> q F R1 R2 R3. 
    (\<exists> N P1 P2 P3. 
     freelist h F N \<and>
     (E,h,  False, U1, 1, G,R1,P1):CS_ua \<and> 
     (E,h,  False, U2, 2, G,R2,P2):CS_ua \<and> 
     (E,h,  False, U3, 3, G,R3,P3):CS_ua \<and> 
      (R1 \<inter> (R2 \<union> R3)) = {} \<and>
      (R1 \<union> R2 \<union> R3) \<inter> F = {} \<and> 
      n + (P1+P2+P3) + q \<le> N) \<longrightarrow>
    (\<exists> Rv S M FF. (freelist hh FF M) \<and> 
                 (v,hh,Some T,  False, Rv,S) : reg_ua \<and>
                 (mod2 (F \<union> R1) h hh) \<and>
                 (Rv \<inter> FF = {}) \<and>  
                 Rv \<subseteq> (R1 \<union> R2  \<union> F) \<and>
                 FF \<subseteq> (R1 \<union> F) \<and>
                 (m + S + q \<le> M) \<and> 
                 oheap h = oheap hh \<and>
      ( ( \<exists> P2'. (E,h, True, U2, 2, G,R2,P2'):CS_ua)  \<longrightarrow>
        (v,hh,Some T, True, Rv,S) : reg_ua)))"


(***************************************************)
(* Some set theory for "usage-aspect" sets*)


(* correctness lemmas:
   U1 \<union> U2 \<union> U3 \<subseteq> DOM G, provided UIJ \<subseteq> DOM;
   U1, U2, U3 are disjoint, provided U11, U12, U13 are and U21, U22, U23 are.
*)

lemma let1_dom: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U21;
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={};

                   (U11 \<union> U12 \<union> U13) \<subseteq> D;
                   (U21 \<union> U22 \<union> U23) \<subseteq> D\<rbrakk>
                    \<Longrightarrow> U1 \<union> U2 \<union> U3 \<subseteq> D"
apply fast
done

lemma let1_disj: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U21;
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={};

                   U11 \<inter> U12 ={};U11 \<inter> U13 ={};U12 \<inter> U13 ={};
                   U21 \<inter> U22 ={};U21 \<inter> U23 ={};U22 \<inter> U23 ={}\<rbrakk>
                    \<Longrightarrow> U1 \<inter> U2 ={} \<and> U1 \<inter> U3 ={} \<and> U2 \<inter> U3 ={}"
apply (rule conjI)
apply fast
apply (rule conjI)
apply fast
apply fast
done

lemma let2_dom: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U22;
                   U1 = U11 \<union> U21;
                   U2 = (U12-U21) \<union> (U22-(U11 \<union> U12)-{x});
                   U3 = (U13 - (U21 \<union> U22)) \<union>
                        (U23 - (U11 \<union> U12));
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22;

                   (U11 \<union> U12 \<union> U13) \<subseteq> D;
                   (U21 \<union> U22 \<union> U23) \<subseteq> D\<rbrakk>
                    \<Longrightarrow> U1 \<union> U2 \<union> U3 \<subseteq> D"
apply fast
done


lemma let2_disj: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U22;
                   U1 = U11 \<union> U21;
                   U2 = (U12-U21) \<union> (U22-(U11 \<union> U12)-{x});
                   U3 = (U13 - (U21 \<union> U22)) \<union>
                        (U23 - (U11 \<union> U12));
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22;

                   U11 \<inter> U12 ={};U11 \<inter> U13 ={};U12 \<inter> U13 ={};
                   U21 \<inter> U22 ={};U21 \<inter> U23 ={};U22 \<inter> U23 ={}\<rbrakk>
                    \<Longrightarrow> U1 \<inter> U2 ={} \<and> U1 \<inter> U3 ={} \<and> U2 \<inter> U3 ={}"
apply fast
done

lemma let3_dom: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U23;
                   U1 = U11 \<union> U21;
                   U2 = U22;
                   U3 = (U12 - (U21 \<union> U22))  \<union>
                        (U13 - (U21 \<union> U22)) \<union>
                         U23 - {x};
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22 \<union> U23;

                   (U11 \<union> U12 \<union> U13) \<subseteq> D;
                   (U21 \<union> U22 \<union> U23) \<subseteq> D\<rbrakk>
                    \<Longrightarrow> U1 \<union> U2 \<union> U3 \<subseteq> D"
apply fast
done

lemma let3_disj: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U23;
                   U1 = U11 \<union> U21;
                   U2 = U22;
                   U3 = (U12 - (U21 \<union> U22))  \<union>
                        (U13 - (U21 \<union> U22)) \<union>
                         U23 - {x};
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22 \<union> U23;

                   U11 \<inter> U12 ={};U11 \<inter> U13 ={};U12 \<inter> U13 ={};
                   U21 \<inter> U22 ={};U21 \<inter> U23 ={};U22 \<inter> U23 ={}\<rbrakk>
                    \<Longrightarrow> U1 \<inter> U2 ={} \<and> U1 \<inter> U3 ={} \<and> U2 \<inter> U3 ={}"
apply fast
done

(* some auxiliary staff for shared parts of contexts *)
lemma let1_unions: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U21;
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={} \<rbrakk>
                    \<Longrightarrow>
                   U1 \<union> U2 \<union> U3 =  
                   U11 \<union> U12 \<union> U13 \<union> (U21 - {x}) \<union> U22 \<union>  U23"
apply fast
done

lemma let1_unions_shared: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U21;
                   U1 = U11 \<union> U12 \<union> (U21 - {x});
                   U2 = U22;
                   U3 = (U13 - (U21 \<union> U22))  \<union>  U23;
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23)={};

                   U = (U11 \<union> U12 \<union> U13)\<inter> (U21 \<union> U22 \<union> U23)\<rbrakk>
                    \<Longrightarrow>
                   (U1 \<union> U2 \<union> U3)\<inter> U =  
                   (U11 \<union> U12 \<union> U13)\<inter> U 
                   \<and>
                   (U1 \<union> U2 \<union> U3)\<inter> U = 
                   (U21 \<union> U22 \<union> U23)\<inter> U "
apply fast
done


lemma let2_unions: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U22;
                   U1 = U11 \<union> U21;
                   U2 = (U12-U21) \<union> (U22-(U11 \<union> U12)-{x});
                   U3 = (U13 - (U21 \<union> U22)) \<union>
                        (U23 - (U11 \<union> U12));
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22\<rbrakk>
                    \<Longrightarrow>
                   U1 \<union> U2 \<union> U3 =  
                   U11 \<union> U12 \<union> U13 \<union> U21 \<union> (U22- {x}) \<union>  U23"
apply fast
done

lemma let2_unions_shared: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U22;
                   U1 = U11 \<union> U21;
                   U2 = (U12-U21) \<union> (U22-(U11 \<union> U12)-{x});
                   U3 = (U13 - (U21 \<union> U22)) \<union>
                        (U23 - (U11 \<union> U12));
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22;

                   U = (U11 \<union> U12 \<union> U13)\<inter> (U21 \<union> U22 \<union> U23)\<rbrakk>
                    \<Longrightarrow> 
                   (U1 \<union> U2 \<union> U3)\<inter> U =  
                   (U11 \<union> U12 \<union> U13)\<inter> U 
                   \<and>
                   (U1 \<union> U2 \<union> U3)\<inter> U = 
                   (U21 \<union> U22 \<union> U23)\<inter> U "
apply fast
done

lemma let3_unions: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U23;
                   U1 = U11 \<union> U21;
                   U2 = U22;
                   U3 = (U12 - (U21 \<union> U22))  \<union>
                        (U13 - (U21 \<union> U22)) \<union>
                         U23 - {x};
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22 \<union> U23\<rbrakk>
                    \<Longrightarrow>
                   U1 \<union> U2 \<union> U3 =  
                   U11 \<union> U12 \<union> U13 \<union> U21 \<union> U22 \<union>  (U23- {x})"
apply fast
done


lemma let3_unions_shared: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U23;
                   U1 = U11 \<union> U21;
                   U2 = U22;
                   U3 = (U12 - (U21 \<union> U22))  \<union>
                        (U13 - (U21 \<union> U22)) \<union>
                         U23 - {x};
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22 \<union> U23; 

                   U = (U11 \<union> U12 \<union> U13)\<inter> (U21 \<union> U22 \<union> U23)\<rbrakk>
                    \<Longrightarrow>
                   (U1 \<union> U2 \<union> U3)\<inter> U =  
                   (U11 \<union> U12 \<union> U13)\<inter> U 
                   \<and>
                   (U1 \<union> U2 \<union> U3)\<inter> U = 
                   (U21 \<union> U22 \<union> U23)\<inter> U "
apply fast
done

(* Below there is a trial to pove something stupid.
   It fails, thanks God. *) 
lemma let3_bad: "\<lbrakk> x \<notin> (U11 \<union> U12 \<union> U13);
                    x \<in> U23;
                   U1 = U11 \<union> U21;
                   U2 = U22;
                   U3 = (U12 - (U21 \<union> U22))  \<union>
                        (U13 - (U21 \<union> U22)) \<union>
                         U23 - {x};
                   U11 \<inter> (U21 \<union> U22 \<union> U23)={}; 
                   U12 \<inter> (U21 \<union> U22 \<union> U23) \<subseteq> U22 \<union> U23 \<rbrakk>
                    \<Longrightarrow>
                   U1 \<union> U2  \<union> U3 = U11 \<union> U12  \<union> U13 "
apply auto
oops
