theory InsSortM_TACTIC = InsSortMCertificate:


method_setup Wp = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast" 

method_setup ltac6 = {* Method.ctxt_args (fn ctxt => Method.METHOD (fn facts => l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
"Main method"

method_setup method_NullGenL = {* Method.ctxt_args (fn ctxt => Method.METHOD (fn facts => null_tac_genl ctxt 1)) *}
 "Method for Nullresult, nulltree and nulllist with left slack"

method_setup method_LetrinvsGenL = {* Method.ctxt_args (fn ctxt => Method.METHOD (fn facts => letrinvRename_tac_genl ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") stop 1)) *}
 "Method for Letrinvoke with left slack"

method_setup method_invsGenL = {* Method.ctxt_args (fn ctxt => Method.METHOD (fn facts => inv_Rename_tac_genl ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 1)) *}
 "Method for invoke with left slack"

method_setup ltac6genl = {* Method.ctxt_args (fn ctxt => Method.METHOD (fn facts => l_tac6_genl (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
 "Main method with left slack"

method_setup WpGenL = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6_genl (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast, left slack" 
(* ---------------------------------------- HW's tools *)

ML_setup {*
  fun weak_only_tac thms tac ctxt i = 
    EVERY
      [localsimp_tac_thms ctxt thms i,  (* expand SPEC, methtable *)
       rtac vcg_weak i]

  fun null_tac_trace ctxt i =
   EVERY [TRY (localsimp_tac ctxt i),
         (tracing ("__ NULL_TAC: trying null rules .. ");
          ((rtac vcg_nullresult i) THEN (localsimp_tac ctxt i))
          ORELSE ((rtac vcg_nulltree i) THEN (localsimp_tac ctxt i))
          ORELSE ((rtac vcg_nulllist i) THEN (localsimp_tac ctxt i)))]

  fun leaf_tac_trace ctxt thms i = 
  FIRST
   [(tracing ("__ LEAF_TAC: trying int, ivar, prim ...");
    resolve_tac [vcg_int, vcg_ivar, vcg_prim] i),
    (tracing ("__ LEAF_TAC: trying rvar ... ");
    EVERY [rtac vcg_rvar i, localsimp_tac ctxt i]),
    (tracing ("__ LEAF_TAC: trying prim ... ");
    resolve_tac [vcg_prim] i),
    (tracing ("__ LEAF_TAC: trying rprim ... ");
    EVERY [resolve_tac [vcg_rprim] i,
           repeat 2 (localsimp_tac ctxt i)]),
    (tracing ("__ LEAF_TAC: trying makelist ... ");
    EVERY [resolve_tac [vcg_makelist] i,
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
           localsimp_tac ctxt i]),
    (tracing ("__ LEAF_TAC: trying makelist_ml ... ");
    EVERY [resolve_tac [vcg_makelist_ml] i,
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
    repeat 3 (localsimp_tac ctxt i)]),
    (tracing ("__ LEAF_TAC: trying makeresult ... ");
    EVERY [resolve_tac [vcg_makeresult] i,
    repeat 2 (localsimp_tac ctxt i)]),
    (tracing ("__ LEAF_TAC: trying maketree ... ");
    EVERY [resolve_tac [vcg_maketree] i,
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
    repeat 2 (localsimp_tac ctxt i)]),
    stop_thms thms ctxt i,
    (tracing ("__ LEAF_TAC: trying inv_Rename ... ");
     inv_Rename_tac ctxt thms i),
   (tracing ("__ LEAF_TAC: THIS LEAF SUCKS ");
    all_tac)]

  fun if_tac_trace ctxt rec_tacTHEN rec_tacELSE i =
   EVERY [rtac vcg_if i,
          (tracing ("__ IF_TAC: doing else... ");
   rec_tacELSE ctxt (i+1)),
          (tracing ("__ IF_TAC: doing then ");
          rec_tacTHEN ctxt i)]

  fun let_tac_trace ctxt thms rec_tac i =
   FIRST [EVERY [rtac vcg_letint i,
                 (tracing ("__ LET_TAC: letint ");
    rec_tac ctxt i)],
          EVERY [rtac vcg_letprim i,
                 (tracing ("__ LET_TAC: letprim ");
    rec_tac ctxt i)],
          EVERY [resolve_tac [vcg_letrprim] i,
                 (tracing ("__ LET_TAC: letrprim ");
          localsimp_tac ctxt i),
          localsimp_tac ctxt i,
          rec_tac ctxt i],
   EVERY [rtac vcg_letnull i,
                 (tracing ("__ LET_TAC: letnull ");
          rec_tac ctxt (i+1)),
                 null_tac_trace ctxt (i+1),
   localsimp_tac ctxt i],

          EVERY [letrmakelist_tac ctxt thms rec_tac i],

   EVERY [rtac vcg_letrmakeresult i,
                 (tracing ("__ LET_TAC: letrmakeresult ");
          repeat 2 (localsimp_tac ctxt i)),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i],
   EVERY [rtac vcg_letrmaketree i,
                 (tracing ("__ LET_TAC: letrmaketree ");
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i]),
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
          repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i]]


   fun l_tac6_trace (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac_trace ctxt (l_tac6_trace thms) (l_tac6_trace thms) i,
           let_tac_trace ctxt thms (l_tac6_trace thms) i,
           call_tac ctxt dmp_defs (l_tac6_trace thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac6_trace thms) (w_tac fun_defs (l_tac6_trace thms)) i,
           match_tac ctxt (l_tac6_trace thms) i,
           letrinvRename_tac ctxt thms (l_tac6_trace thms) i,
           letiinvRename_tac ctxt thms (l_tac6_trace thms) i,
           null_tac_trace ctxt i,
           leaf_tac_trace ctxt thms i]

   fun l_tac6_norec_trace (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac_trace ctxt (stop_thms thms) (stop_thms thms) i,
           let_tac_trace ctxt thms (stop_thms thms) i,
           call_tac ctxt dmp_defs (stop_thms thms ctxt) i,
           dom_tac ctxt fun_defs (stop_thms thms) (w_tac fun_defs (stop_thms thms)) i,
           match_tac ctxt (stop_thms thms) i,
           letrinvRename_tac ctxt thms (stop_thms thms) i,
           letiinvRename_tac ctxt thms (stop_thms thms) i,
           null_tac_trace ctxt i,
           leaf_tac_trace ctxt thms i]

*}

(*method_setup Wp = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast" 
*)
method_setup Wp_trace = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6_trace (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast" 

method_setup Wp_norec_trace = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6_norec_trace (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast" 

method_setup Bonzo1 = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms "meth_defs") stop  ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast" 

method_setup Bonzo2 = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => weak_only_tac (thms "meth_defs") stop  ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast" 

(* ---------------------------------------- Lennart's tools *)

method_setup method_leaf = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => leaf_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 1))  *}
 "Method for solving leaf cases in the derivation."    
 
method_setup method_If = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => if_tac ctxt stop stop 1)) *}
  "Method for If, reduces to two subgoals"

method_setup method_Let = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => let_tac ctxt (thms,thms,thms) stop 1)) *}
  "Method for LetPrim/LetRPrim/LetNull, reduces to one subgoal"

method_setup method_Letinv = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for Letrinvoke"

method_setup method_Letinvs = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             stop 1)) *}
  "Method for Letrinvoke"

(* apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def) *)
method_setup method_Call = {* Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (stop ctxt) 1)) *}
  "Method for Call, leaves dominates subgoal"
(*
method_setup method_CallDom = {* Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (fn ctxt => fn thms => dom_tac ctxt thms (K stop)) 1)) *}
  "Method for Call, leaves dominates subgoal"
*)

(* apply (simp?, (rule DA_NullResult, simp) | rule DA_NullTree | rule DA_NullList) *)
method_setup method_Null = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => null_tac ctxt 1)) *}
  "Method for Nullresult, nulltree and nulllist"

(* FIXME: to combine method_Call with method_Dom or mergepoint stuff, we need to
   ideally need a method which accepts more than one parameter *)

(* apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs) *)
method_setup method_Dom = {* Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => dom_tac ctxt thms stop stop 1)) *}
  "Method for Dom" 

method_setup ltac = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac2 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac2 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac3 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac3 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac4 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac4 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac5 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac5 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

(* method_setup ltac6 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"
*)
method_setup rmd = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for resultmatchd"

method_setup rmds = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt stop 1)) *}
  "test for resultmatchd"

method_setup lmd = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => cons_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for listmatchd"

method_setup lmds = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => cons_matchd_tac ctxt stop 1)) *}
  "test for listmatchd"

method_setup lm = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => cons_match_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for listmatch"

method_setup lms = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => cons_match_tac ctxt stop 1)) *}
  "test for listmatch"

method_setup tmd = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => node_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for treematchd"

method_setup tmds = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => node_matchd_tac ctxt stop 1)) *}
  "test for treematchd"
method_setup tm = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => node_match_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for treematch"

method_setup tms = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => node_match_tac ctxt stop 1)) *}
  "test for treematch"

method_setup method_fast = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => fst_tac 1)) *}
  "Method for fast"

method_setup method_simp = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac ctxt 1)) *}
  "Method for simp"

method_setup method_Weaks = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "meth_defs") stop 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup method_Weak = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup letrmakelist = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letrmakelist_tac ctxt (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup letrmakelists = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letrmakelist_tac ctxt (thms "meth_defs") stop 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup letcons = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => let_cons ctxt (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup letconsML = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => let_cons_ML ctxt (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup method_REN = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => REN_tac 1)) *}
  "Method for starting: use weakening, simplification with args, fast"

(* ------------------------------------------ new stuff  *)

ML {*
  fun null_res_tac ctxt i =
   EVERY [TRY (localsimp_tac ctxt i),
          ((rtac vcg_nullresult i) THEN (localsimp_tac ctxt i)) 
          ORELSE ((rtac vcg_nulltree i) THEN (localsimp_tac ctxt i))
          ORELSE ((rtac vcg_nulllist i) THEN (localsimp_tac ctxt i))]

  fun null_tree_tac ctxt i =
   EVERY [TRY (localsimp_tac ctxt i),
          ((rtac vcg_nulltree i) THEN (localsimp_tac ctxt i))
          ORELSE ((rtac vcg_nullresult i) THEN (localsimp_tac ctxt i))
          ORELSE ((rtac vcg_nulllist i) THEN (localsimp_tac ctxt i))]

  (* --------------------------------------------------------------------------- *)
  (* Version 7 *)

   fun letrinvRename7_tac ctxt (dmp_defs,meth_defs,fun_defs,ctxt_defs) rec_tac i =
          EVERY [rtac vcg_letrinvokeconstRename i,
                 localsimp_tac_thms ctxt ctxt_defs (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1), REN_tac (i+1),
                 localsimp_tac_thms ctxt ([thm "newframe_env_def", thm "evalARGS_def"] @ meth_defs) (i+1),
                 FIRST [ EVERY [localsimp_tac ctxt (i+1),
                                rtac conjI (i+1),
                                repeat 2 (localsimp_tac ctxt (i+1))],
                         localsimp_tac ctxt (i+1)],
                 rec_tac ctxt (i+1),
                 localsimp_tac ctxt i]

  fun let7_tac ctxt thms rec_tac i =
   FIRST [EVERY [rtac vcg_letint i,
   rec_tac ctxt i],
          EVERY [rtac vcg_letprim i,
   rec_tac ctxt i],
          EVERY [resolve_tac [vcg_letrprim] i,
          localsimp_tac ctxt i,
          localsimp_tac ctxt i,
          rec_tac ctxt i],
   EVERY [rtac vcg_letnull i,
          rec_tac ctxt (i+1),
                 null_tac ctxt (i+1),       (* <-- it is a list! *)
   localsimp_tac ctxt i],
          EVERY [rtac vcg_letrmakelist i,
                 FIRST [ EVERY [ TRY (localsimp_tac ctxt i),
                          rec_tac ctxt i,
                                 repeat 2 (localsimp_tac ctxt i)],
                         EVERY [ localsimp_tac ctxt i, (*????*)
                                 rtac conjI i,
                                 repeat 2 (localsimp_tac ctxt i),
                          rec_tac ctxt (i+1),
                                 repeat 2 (localsimp_tac ctxt i)],
                         EVERY [ localsimp_tac ctxt i,
                          rec_tac ctxt (i+1),
                                 repeat 3 (localsimp_tac ctxt i)]]] ,
   EVERY [rtac vcg_letrmakeresult i,
          repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i],
   EVERY [rtac vcg_letrmaketree i,
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
          repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i]]

  fun let7res_tac ctxt thms rec_tac i =
   FIRST [EVERY [rtac vcg_letint i,
   rec_tac ctxt i],
          EVERY [rtac vcg_letprim i,
   rec_tac ctxt i],
          EVERY [resolve_tac [vcg_letrprim] i,
          localsimp_tac ctxt i,
          localsimp_tac ctxt i,
          rec_tac ctxt i],
   EVERY [rtac vcg_letnull i,
          rec_tac ctxt (i+1),
                 null_res_tac ctxt (i+1),   (* <-- it is a res! *)
   localsimp_tac ctxt i],
   EVERY [rtac vcg_letrmakeresult i,
          repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i],
          EVERY [rtac vcg_letrmakelist i,
                 FIRST [ EVERY [ TRY (localsimp_tac ctxt i),
                          rec_tac ctxt i,
                                 repeat 2 (localsimp_tac ctxt i)],
                         EVERY [ localsimp_tac ctxt i, (*????*)
                                 rtac conjI i,
                                 repeat 2 (localsimp_tac ctxt i),
                          rec_tac ctxt (i+1),
                                 repeat 2 (localsimp_tac ctxt i)],
                         EVERY [ localsimp_tac ctxt i,
                          rec_tac ctxt (i+1),
                                 repeat 3 (localsimp_tac ctxt i)]]] ,
   EVERY [rtac vcg_letrmaketree i,
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
          repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i]]

  fun let7tree_tac ctxt thms rec_tac i =
   FIRST [EVERY [rtac vcg_letint i,
   rec_tac ctxt i],
          EVERY [rtac vcg_letprim i,
   rec_tac ctxt i],
          EVERY [resolve_tac [vcg_letrprim] i,
          localsimp_tac ctxt i,
          localsimp_tac ctxt i,
          rec_tac ctxt i],
   EVERY [rtac vcg_letnull i,
          rec_tac ctxt (i+1),
                 null_tree_tac ctxt (i+1),  (* <-- it is a tree! *)
   localsimp_tac ctxt i],
   EVERY [rtac vcg_letrmaketree i,
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
          repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i],
          EVERY [rtac vcg_letrmakelist i,
                 FIRST [ EVERY [ TRY (localsimp_tac ctxt i),
                          rec_tac ctxt i,
                                 repeat 2 (localsimp_tac ctxt i)],
                         EVERY [ localsimp_tac ctxt i, (*????*)
                                 rtac conjI i,
                                 repeat 2 (localsimp_tac ctxt i),
                          rec_tac ctxt (i+1),
                                 repeat 2 (localsimp_tac ctxt i)],
                         EVERY [ localsimp_tac ctxt i,
                          rec_tac ctxt (i+1),
                                 repeat 3 (localsimp_tac ctxt i)]]] ,
   EVERY [rtac vcg_letrmakeresult i,
          repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i]]

  fun cons_matchd7_tac ctxt rec_tac i state = state |> 
    EVERY [rtac vcg_listmatchd i,
           localsimp_tac ctxt (i+1),
             rtac conjI (i+1),
             repeat 2 (localsimp_tac ctxt (i+1)),
           localsimp_tac ctxt (i+1),
    (CHANGED (localsimp_tac ctxt (i+1))),
            rec_tac ctxt (i+1),
            repeat 1 (localsimp_tac ctxt i)]


   fun l_tac7 (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac7 thms) (l_tac7 thms) i,
           let7_tac ctxt thms (l_tac7 thms) i,
           call_tac ctxt dmp_defs (l_tac7 thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac7 thms) (w_tac fun_defs (l_tac7 thms)) i,
           cons_matchd7_tac ctxt (l_tac7 thms) i,
           letrinvRename7_tac ctxt thms (l_tac7 thms) i,
           letiinvRename_tac ctxt thms (l_tac7 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac7res (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac7 thms) (l_tac7 thms) i,
           let7res_tac ctxt thms (l_tac7 thms) i,         (* <-- it is a res! *)
           call_tac ctxt dmp_defs (l_tac7 thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac7 thms) (w_tac fun_defs (l_tac7 thms)) i,
           cons_matchd7_tac ctxt (l_tac7 thms) i,
           letrinvRename7_tac ctxt thms (l_tac7 thms) i,
           letiinvRename_tac ctxt thms (l_tac7 thms) i,
           null_res_tac ctxt i,                            (* <-- it is a res! *)
           leaf_tac ctxt thms i]

   fun l_tac7tree (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac7 thms) (l_tac7 thms) i,
           let7tree_tac ctxt thms (l_tac7 thms) i,           (* <-- it is a tree! *)
           call_tac ctxt dmp_defs (l_tac7 thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac7 thms) (w_tac fun_defs (l_tac7 thms)) i,
           cons_matchd7_tac ctxt (l_tac7 thms) i,
           letrinvRename7_tac ctxt thms (l_tac7 thms) i,
           letiinvRename_tac ctxt thms (l_tac7 thms) i,
           null_tree_tac ctxt i,                               (* <-- it is a tree! *)
           leaf_tac ctxt thms i]

   fun l_tac7s (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt stop stop i,
           let7_tac ctxt thms stop i,
           call_tac ctxt dmp_defs (l_tac7 thms ctxt) i,
           dom_tac ctxt fun_defs stop (w_tac fun_defs stop) i,
           cons_matchd7_tac ctxt stop i,
           letrinvRename7_tac ctxt thms stop i,
           letiinvRename_tac ctxt thms stop i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac7gen v (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = 
    if (v=1) then l_tac7 thms ctxt i state
    else if (v=2) then l_tac7res thms ctxt i state
    else if (v=3) then l_tac7tree thms ctxt i state
    else l_tac7 thms ctxt i state

  (* --------------------------------------------------------------------------- *)
  (* Version 6 tinkering *)

  (* forces all nulls to be Trees!!! works for: Letint, Letprim, LetRPrim, LetNull *)
  fun let_tree_tac ctxt thms rec_tac i =
   FIRST [EVERY [rtac vcg_letint i,
   rec_tac ctxt i],
          EVERY [rtac vcg_letprim i,
   rec_tac ctxt i],
          EVERY [resolve_tac [vcg_letrprim] i,
          localsimp_tac ctxt i,
          localsimp_tac ctxt i,
          rec_tac ctxt i],
   EVERY [rtac vcg_letnull i,
          rec_tac ctxt (i+1),
                 null_tree_tac ctxt (i+1),
   localsimp_tac ctxt i],
          letrmakelist_tac ctxt thms rec_tac i,
   EVERY [rtac vcg_letrmakeresult i,
          repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i],
   EVERY [rtac vcg_letrmaketree i,
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
          repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i]]


   fun l_tac6tree (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac6tree thms) (l_tac6tree thms) i,
           let_tree_tac ctxt thms (l_tac6tree thms) i,
           call_tac ctxt dmp_defs (l_tac6tree thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac6tree thms) (w_tac fun_defs (l_tac6tree thms)) i,
           match_tac ctxt (l_tac6tree thms) i,
           letrinvRename_tac ctxt thms (l_tac6tree thms) i,
           letiinvRename_tac ctxt thms (l_tac6tree thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

  (* forces all nulls to be Trees!!! works for: Letint, Letprim, LetRPrim, LetNull *)
  fun let_res_tac ctxt thms rec_tac i =
   FIRST [EVERY [rtac vcg_letint i,
   rec_tac ctxt i],
          EVERY [rtac vcg_letprim i,
   rec_tac ctxt i],
          EVERY [resolve_tac [vcg_letrprim] i,
          localsimp_tac ctxt i,
          localsimp_tac ctxt i,
          rec_tac ctxt i],
   EVERY [rtac vcg_letnull i,
          rec_tac ctxt (i+1),
                 null_res_tac ctxt (i+1),
   localsimp_tac ctxt i],
          letrmakelist_tac ctxt thms rec_tac i,
   EVERY [rtac vcg_letrmakeresult i,
          repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i],
   EVERY [rtac vcg_letrmaketree i,
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
          repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i]]


   fun l_tac6res (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac6res thms) (l_tac6res thms) i,
           let_tree_tac ctxt thms (l_tac6res thms) i,
           call_tac ctxt dmp_defs (l_tac6res thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac6res thms) (w_tac fun_defs (l_tac6res thms)) i,
           match_tac ctxt (l_tac6res thms) i,
           letrinvRename_tac ctxt thms (l_tac6res thms) i,
           letiinvRename_tac ctxt thms (l_tac6res thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac6gen v (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = 
    if (v=1) then l_tac6 thms ctxt i state
    else if (v=2) then l_tac6res thms ctxt i state
    else if (v=3) then l_tac6tree thms ctxt i state
    else l_tac6 thms ctxt i state

*}

method_setup ltac6tree = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac6tree (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac6res = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac6res (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

ML {* 
 val global_v:int = 1
*}

method_setup ltac6gen = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac6gen global_v (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac7 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac7 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac7gen = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac7gen global_v (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac7s = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac7s (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup method_Let7 = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => let7_tac ctxt (thms,thms,thms) stop 1)) *}
  "Method for LetPrim/LetRPrim/LetNull, reduces to one subgoal"


(* --------------------------------------------------------------------------- *)

end