theory TreeVCG = DAss_ListrulesT2 + DAss_TreerulesT2 + DAss_ResultrulesT2:

subsubsection {* Logical rules*}
lemma DAss_monotone_in_U:
"\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p; U \<subseteq> UU\<rbrakk> \<Longrightarrow> \<lbrace>UU, n, C \<ggreater> T, m\<rbrace> E h hh v p"
(*<*)by (rule DAss_Eq2, rule DAssC_monotone_in_U, erule DAss_Eq1, assumption)(*>*)

lemma DA_Weak: "\<lbrakk>G \<rhd> e : \<lbrace> U , n , C \<ggreater> T , m\<rbrace>; U \<subseteq> UU\<rbrakk> \<Longrightarrow> G \<rhd> e : \<lbrace>UU, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_Weak, erule DA_Eq1, assumption)(*>*)

lemma DAss_Contexts_same_on_U:
"\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> \<lbrace>U, n, D \<ggreater> T, m\<rbrace> E h hh v p"
(*<*)by (rule DAss_Eq2, rule DAssC_Contexts_same_on_U, erule DAss_Eq1, assumption)(*>*)

lemma DA_Contexts_same_on_U:
"\<lbrakk>G \<rhd> e: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> G \<rhd> e: \<lbrace>U, n, D \<ggreater> T, m\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_Contexts_same_on_U, erule DA_Eq1, assumption)(*>*)

lemma DAss_Generalise:
 "\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p;  n \<le> nn; mm \<le> m; U \<subseteq> UU\<rbrakk>  \<Longrightarrow> \<lbrace>UU, nn, C \<ggreater> T, mm\<rbrace> E h hh v p"
(*<*)by (rule DAss_Eq2, rule DAssC_Generalise, erule DAss_Eq1, assumption+)(*>*)

lemma DA_Generalise: 
"\<lbrakk>G \<rhd> e:\<lbrace>U, n, C \<ggreater> T, m\<rbrace>; n \<le> nn; mm \<le> m; U \<subseteq> UU\<rbrakk>
 \<Longrightarrow> G \<rhd> e: \<lbrace>UU, nn, C \<ggreater> T, mm\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_Generalise, erule DA_Eq1, assumption+)(*>*)

lemma DAss_Const: "\<lbrakk>\<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v p; nn = n + k; mm = m + k\<rbrakk> \<Longrightarrow> \<lbrace>U, nn, G \<ggreater> T, mm\<rbrace> E h hh v p"
(*<*)by (rule DAss_Eq2, rule DAssC_Const, erule DAss_Eq1, assumption+)(*>*)

lemma DA_Const: "\<lbrakk>G \<rhd> e: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; nn = n + k; mm = m + k\<rbrakk> \<Longrightarrow> G \<rhd> e: \<lbrace>U, nn, C \<ggreater> T, mm\<rbrace>"
(*<*)
by (rule DA_Eq2, rule DA_C_Const, erule DA_Eq1, assumption+)(*>*)

lemma DAss_PConst0: "\<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v p = \<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v pp"
(*<*)by (simp add: DAssC_PConst0 DAss_Eq)(*>*)

lemma DAss_PConst: "\<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v p \<Longrightarrow> \<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v pp"
(*<*)by (rule DAss_Eq2, rule DAssC_PConst, erule DAss_Eq1)(*>*)

subsection {*Introduction of specification tables*}

consts SPEC::"mname \<Rightarrow> vdmassn"
consts FST :: FS_T	(* unspecified empty table *)
consts vMST :: vMS_T	(* unspecified empty table *)
constdefs sMST :: sMS_T  
"sMST == (\<lambda> C M args E h hh v p. \<forall> EE . (Nullref, fst (methtable C M), args, E,EE):FRAME \<longrightarrow> SPEC M EE h hh v p)"

lemma vcg_invokeconstRename: 
  "\<lbrakk>(c\<bullet>M(L), sMST c M L): G;
     SPEC M = \<lbrace>UU, n, C  \<ggreater> T, m\<rbrace>;
     distinct (fst (methtable c M));
     distinct (ArgList2RnameList L);
     UU = set (ParList2RnameList (fst (methtable c M)));
     U = set (ArgList2RnameList L); 
     UU \<subseteq> DOM C; U \<subseteq> DOM D;
     nk = n+k; mk = m+k;
     (L, fst (methtable c M),f):RENA;
     \<forall> x y . ((lookup f x = Some y) \<longrightarrow> (GETr D x = GETr C y))\<rbrakk>
  \<Longrightarrow> G \<rhd>  (c\<bullet>M(L)) : \<lbrace>U, nk, D \<ggreater> T, mk\<rbrace>"
apply (rule DA_Const)
apply (rule vdm_conseq)
apply (erule vdm_ax)
apply (simp add: sMST_def)
apply clarsimp
apply (subgoal_tac "\<exists> EE . (Nullref, fst (methtable c M), L, E, EE) \<in> FRAME", clarsimp)
prefer 2 apply (erule REN_FRAME) apply assumption+ 
apply (erule_tac x=EE in allE, clarsimp)
apply (erule AdaptRename)
prefer 3
  apply assumption+
apply simp+
apply clarsimp
  apply (erule REN_Env) apply assumption+ 
done

subsection{*Function calls using dominator relation*}
consts isMergePoint :: "funame \<Rightarrow> bool"
consts dominates::"funame \<Rightarrow> (funame list)"

types septuple = "(vdmcontext \<times> expr \<times> (rname set) \<times> nat \<times> Context \<times> Type \<times> nat)"

consts DOM_Call::"(funame list \<times> vdmcontext \<times> funame \<times> vdmassn) set"
inductive DOM_Call intros
DOM_CallNIL [intro]: "\<lbrakk>finite G; G \<rhd> snd(funtable f):P\<rbrakk> \<Longrightarrow> ([],G,f,P) : DOM_Call"
DOM_CallCONS [intro]: "\<lbrakk>(t,{(Call h, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>)} \<union> G,f,P):DOM_Call; 
                        G \<rhd> snd(funtable h): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk>
                      \<Longrightarrow> ( h # t, G, f, P):DOM_Call"

lemma DOM_Call_Sound[rule_format]:
   "(L,G,f,P):DOM_Call \<Longrightarrow> (\<forall> U n C T m . P = \<lbrace>U, n, C \<ggreater> T, m\<rbrace> \<longrightarrow> finite G \<and> G \<rhd> Call f: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>)"
apply (erule DOM_Call.induct)
apply clarsimp
apply (rule DA_Eq2, rule DA_C_Call2, erule DA_Eq1)(*(erule DA_Call2) *)
apply clarsimp
apply (erule_tac x=Ua in allE, erule_tac x=na in allE, erule_tac x=Ca in allE, 
       erule_tac x=Ta in allE, erule_tac x=ma in allE, clarsimp)
apply (rule cut2) prefer 2 apply assumption apply fastsimp+
apply (simp add: contextProvable_def, clarsimp)
apply safe
apply (rule DA_Eq2, rule DA_C_Call2, erule DA_Eq1)
apply (erule vdm_ax)
done

lemma vcg_call: 
  "\<not> isMergePoint f \<and> (dominates f, G, f, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>) \<in> DOM_Call \<or>
  isMergePoint f \<and> U = set (ParList2RnameList (fst (funtable f))) \<and>
	(CALL f, \<lbrace>U, n , restr C (ParList2RnameList (fst (funtable f))) \<ggreater> T , m \<rbrace>) \<in> G \<Longrightarrow>
         G \<rhd>  (CALL f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
apply (erule disjE)
apply clarsimp apply (frule DOM_Call_Sound) apply simp apply simp 
apply clarsimp apply(rule DA_Contexts_same_on_U) 
               apply(erule vdm_ax, clarify, rule RestrIn,fast) 
done
 
subsubsection {*Proof system*}
consts MRG :: "septuple set"
inductive MRG intros
MRG_Int: "n = m \<Longrightarrow> (G, expr.Int i,{}, n, C, IntET, m):MRG"
MRG_IVar: "n = m \<Longrightarrow> (G, IVar x, {}, n, C, IntET, m):MRG"
MRG_RVar: "\<lbrakk>GETr C x = Some T; n = m\<rbrakk> \<Longrightarrow> (G, RVar x, {x}, n, C, T, m):MRG"
MRG_Prim: "n = m \<Longrightarrow> (G, Primop f x y, {}, n, C, IntET, m):MRG"
MRG_RPrim: "\<lbrakk>GETr C x = Some T1; GETr C y = Some S2; n = m\<rbrakk> 
           \<Longrightarrow> (G, RPrimop f x y, {}, n, C, IntET, m):MRG"
MRG_NullList: "\<lbrakk>kN=0\<rbrakk> \<Longrightarrow> (G, Null LLL, {}, n, C, ListET kN kC, n):MRG"
MRG_NullRes: "\<lbrakk>kN=0\<rbrakk> \<Longrightarrow> (G, Null RRR, {}, n, C, ResultET kN TT kS, n):MRG"
MRG_NullTree:"\<lbrakk>kL=0\<rbrakk> \<Longrightarrow> (G, Null TTT, {}, n, C, TreeET kL kN, n):MRG"
(*in the rules for heap-free constructors with annotation null, we would have the following (sound) rules:
MRG_NullList: "\<lbrakk>n=m+kN\<rbrakk> \<Longrightarrow> (G, Null LLL, {}, n, C, ListET kN kC, m):MRG"
MRG_NullRes: "\<lbrakk>n=m+kN\<rbrakk> \<Longrightarrow> (G, Null RRR, {}, n, C, ResultET kN TT kS, m):MRG"
MRG_NullTree:"\<lbrakk>n=m+kL\<rbrakk> \<Longrightarrow> (G, Null TTT, {}, n, C, TreeET kL kN, m):MRG"
But our tactic can't handle that*)
MRG_Letv: "\<lbrakk>(G, e1, U1, n, C, UnitET, m):MRG;
            (G, e2, U2, m, C, T, k) : MRG;
            U1 \<inter> U2 = {}\<rbrakk>
          \<Longrightarrow> (G, LET _ = e1 IN e2 END, U1 \<union> U2, n, C, T, k):MRG"
MRG_Leti: "\<lbrakk>(G, e1, U1, n, C, IntET, m):MRG;
            (G, e2, U2, m, C, T, k):MRG;
            U1 \<inter> U2 = {}\<rbrakk>
          \<Longrightarrow> (G, LET x = e1 IN e2 END, U1 \<union> U2, n, C, T, k):MRG"
MRG_Letr:"\<lbrakk>(G, e1, U1, n, C, T1, m) : MRG;
            (G, e2, U2, m, (x,T1)#C, T2, k):MRG;
           U1 \<inter> (U2-{x}) = {}; T1 \<notin> {IntET, UnitET}\<rbrakk>
         \<Longrightarrow> (G, LET rf x = e1 IN e2 END, U1 \<union> (U2-{x}), n, C, T2, k):MRG"
MRG_LetrNull:"\<lbrakk>(G, e, U2, m, (x,T1)#C, T2, k):MRG;
               (G, Null hint, U1, n, C, T1, m) : MRG;
                U1 \<inter> (U2-{x}) = {}; T1 \<notin> {IntET, UnitET}\<rbrakk>
         \<Longrightarrow> (G, LET rf x = Null hint IN e END, U1 \<union> (U2-{x}), n, C, T2, k):MRG"
MRG_If: "\<lbrakk>(G, e1, U1, n, C, T, m):MRG;
          (G, e2, U2, n, C, T, m):MRG\<rbrakk>
       \<Longrightarrow> (G, IF b THEN e1 ELSE e2, U1 \<union> U2, n, C, T, m):MRG"
MRG_ListMatch: "\<lbrakk>GETr C l = Some (ListET kN kC); nk = n+kC; 
                 (G, e, U, nk, (t,ListET kN kC)#C, T, m):MRG;
                 l \<notin> U - {t}\<rbrakk>
               \<Longrightarrow> (G, LET h = l\<bullet>V0; rf t = l\<diamondsuit>R1 IN e END, (U-{t}) \<union> {l}, n, C, T, m):MRG"
MRG_ListMatchD: "\<lbrakk>GETr C l = Some (ListET kN kC); nk = n+kC+1; l \<noteq> t; 
                  (G, e, U, nk, (t,ListET kN kC)#C, T, m):MRG;
                  l \<notin> U\<rbrakk>
                \<Longrightarrow> (G, LET h = l\<bullet>V0; rf t = l\<diamondsuit>R1; _ = DIAM\<bullet>Free ([RNarg l]) IN e END,
                     (U-{t}) \<union> {l}, n, C, T, m):MRG"
MRG_MakeList: "\<lbrakk>GETr C y = Some (ListET kN kC); n=(Suc m + kC)\<rbrakk>
              \<Longrightarrow> (G, DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg x, RNarg y]), {y}, n, C, ListET kN kC, m):MRG"
MRG_MakeList_ml: "\<lbrakk>GETr C y = Some (ListET kN kC);n=(Suc m + kCC);kNN \<le> kN;kCC \<le> kC\<rbrakk>
                \<Longrightarrow> (G, DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg x, RNarg y]), {y}, n, C, ListET kNN kCC, m):MRG"
MRG_ResultMatch: "\<lbrakk>GETr C l = Some (ResultET kN TT kS); nk = n+kS; 
                   (G, e, U, nk, (t,TT)#C, T, m):MRG;
                   l \<notin> U - {t}\<rbrakk>
                 \<Longrightarrow> (G, LET h = l\<bullet>V0; rf t = l\<diamondsuit>R1 IN e END, (U-{t}) \<union> {l}, n, C, T, m):MRG"
MRG_ResultMatchD: "\<lbrakk>GETr C l = Some (ResultET kN TT kS); nk = n+kS+1; l \<noteq> t; 
                    (G, e, U, nk, (t,TT)#C, T, m):MRG;
                    l \<notin> U\<rbrakk>
                  \<Longrightarrow> (G, LET h = l\<bullet>V0; rf t = l\<diamondsuit>R1; _ = DIAM\<bullet>Free ([RNarg l]) IN e END, 
                       (U-{t}) \<union> {l}, n, C, T, m):MRG"
MRG_MakeResultSome: "\<lbrakk>GETr C y = Some (TreeET kL kN); n=(Suc m + kS)\<rbrakk> \<Longrightarrow>
                     (G, DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg x, RNarg y]), {y}, n, C, 
                      ResultET kN (TreeET kL kN) kS, m):MRG"
MRG_TreeMatch: "\<lbrakk>GETr C t = Some (TreeET kL kN); nk = n+kN; 
                 left \<noteq> right; t \<noteq> left;
                 (G, e, U, nk, (left,TreeET kL kN)#(right,TreeET kL kN)#C, T, m):MRG;
                 t \<notin> U - {left,right}\<rbrakk>
               \<Longrightarrow> (G, LET cont = t\<bullet>V0; rf left = t\<diamondsuit>R1; rf right = t\<diamondsuit>R2 IN e END,
                    (U-{left,right}) \<union> {t}, n, C, T, m):MRG"
MRG_TreeMatchD: "\<lbrakk>GETr C t = Some (TreeET kL kN); nk = n+kN+1; 
                  left \<noteq> right;
                  (G, e, U, nk, (left,TreeET kL kN)#(right,TreeET kL kN)#C, T, m):MRG;
                  t \<notin> U \<union> {left,right}\<rbrakk>
                 \<Longrightarrow> (G, LET cont = t\<bullet>V0; rf left = t\<diamondsuit>R1; rf right = t\<diamondsuit>R2; _ = DIAM\<bullet>Free ([RNarg t]) IN e END,
                      (U-{left,right}) \<union> {t}, n, C, T, m):MRG"
MRG_MakeTree: "\<lbrakk>GETr C y = Some (TreeET kL kN); GETr C z = Some (TreeET kL kN); y\<noteq>z; n=(Suc m + kN)\<rbrakk> \<Longrightarrow>
               (G, DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg x, RNarg y, RNarg z]), {y,z}, n, C, TreeET kL kN, m):MRG"
MRG_InvStat: "\<lbrakk>(c\<bullet>M(L), sMST c M L): G;
               SPEC M = \<lbrace>UU, n, C  \<ggreater> T, m\<rbrace>;
               distinct (fst (methtable c M));
               distinct (ArgList2RnameList L);
               UU = set (ParList2RnameList (fst (methtable c M)));
               U = set (ArgList2RnameList L); 
               UU \<subseteq> DOM C; U \<subseteq> DOM D;
               mk = m+k; nk = n+k;
               (L, fst (methtable c M),f):RENA;
               \<forall> x y . ((lookup f x = Some y) \<longrightarrow> (GETr D x = GETr C y))\<rbrakk>
            \<Longrightarrow> (G, c\<bullet>M(L), U, nk, D, T, mk):MRG"
MRG_Call: "\<lbrakk>(\<not> isMergePoint f \<and> (dominates f, G, f, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>) \<in> DOM_Call) \<or>
            (isMergePoint f \<and> U = set (ParList2RnameList (fst (funtable f))) \<and>
	       (CALL f, \<lbrace>U, n , restr C (ParList2RnameList (fst (funtable f))) \<ggreater> T , m \<rbrace>) \<in> G)\<rbrakk>
           \<Longrightarrow> (G, CALL f, U, n, C, T, m):MRG"
MRG_Weak: "\<lbrakk>(G,e,U,n,C,T,m):MRG; U \<subseteq> UU\<rbrakk> \<Longrightarrow> (G,e,UU,n,C,T,m):MRG"

lemma MRG_sound: "(G,e,U,n,C,T,m):MRG \<Longrightarrow> G \<rhd> e: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
apply (erule MRG.induct, simp_all)
apply (rule DA_Eq2, rule DA_C_Int, simp) 
 apply (rule DA_Eq2, rule DA_C_IVar, simp)
 apply (rule DA_Eq2, erule DA_C_RVar)
 apply (rule DA_Eq2, rule DA_C_Prim, simp)
 apply (rule DA_Eq2, rule DA_C_Rprim, simp add: DOM_def, simp add: DOM_def, simp)
 apply (rule DA_Eq2) apply (rule DA_C_NullList,simp)
 apply (rule DA_Eq2) apply (rule DA_C_NullRes,simp)
 apply (rule DA_Eq2) apply (rule DA_C_NullTree,simp)
 apply (rule DA_Eq2, rule DA_C_Letv, erule DA_Eq1, erule DA_Eq1, simp, assumption)
 apply (rule DA_Eq2, rule DA_C_Leti, erule DA_Eq1, erule DA_Eq1, assumption, simp)
 apply (rule DA_Eq2, rule DA_C_Letr, erule DA_Eq1, erule DA_Eq1, assumption, fast)
 apply (rule DA_Eq2, rule DA_C_Letr, erule DA_Eq1, erule DA_Eq1, assumption, fast)
 apply (rule DA_Eq2, rule DA_C_If, erule DA_Eq1, erule DA_Eq1)
 apply (rule DA_Eq2) apply(erule DA_C_ListMatch[simplified],assumption+, simp, erule DA_Eq1, assumption)
 apply (rule DA_Eq2) apply(erule DA_C_ListMatchD[simplified], assumption+, simp, erule DA_Eq1,assumption+)
 apply (rule DA_Eq2, erule DA_C_MakeList, fastsimp, simp)
 apply (rule DA_Eq2, erule DA_C_MakeList_MemLeak, simp, simp, simp)
 apply (rule DA_Eq2, erule DA_C_ResultMatch[simplified], assumption+, simp, erule DA_Eq1, assumption+)
 apply (rule DA_Eq2, erule DA_C_ResultMatchD[simplified], assumption+, simp, erule DA_Eq1, assumption+)
 apply (rule DA_Eq2, erule DA_C_MakeResultSome) apply fastsimp apply fastsimp apply simp
 apply (rule DA_Eq2, erule DA_C_TreeMatch[simplified], assumption+, simp, erule DA_Eq1, assumption+) apply simp apply assumption
 apply (rule DA_Eq2, erule DA_C_TreeMatchD[simplified], assumption+, simp, erule DA_Eq1, assumption+)
 apply (rule DA_Eq2, erule DA_C_MakeTree, assumption, fastsimp, assumption, simp)
 apply (erule vcg_invokeconstRename, simp+) 
 apply (erule vcg_call)
 apply (erule DA_Weak, assumption)
done


(*Memory leaks:
lemma DA_MakeList_ml:
"\<lbrakk>GETr C y = Some (ListET kN kC);n=(Suc m + kCC);kNN \<le> kN;kCC \<le> kC\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg x, RNarg y])) : \<lbrace>{y}, n, C \<ggreater> ListET kNN kCC, m\<rbrace>"
by (rule DA_Eq2, erule DA_C_MakeList_MemLeak, simp+)

lemma DA_LetrMakeList_ml: 
"\<lbrakk>GETr C y = Some (ListET kN kC);n=(Suc m + kCC);kNN \<le> kN; kCC\<le>kC;
  G \<rhd> e : \<lbrace>U, m, (x,ListET kNN kCC)#C \<ggreater> T, l\<rbrace>; y \<notin> U-{x}; UU={y} \<union> (U-{x})\<rbrakk> \<Longrightarrow>
  G \<rhd> (LET rf x = DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg z, RNarg y])  IN e END) : \<lbrace>UU, n, C \<ggreater> T, l\<rbrace>"
apply (rule DA_Weak)
  apply (rule DA_Eq2) apply simp  
  apply(rule DA_C_Letr[simplified])
    apply (rule DA_Eq1) apply (erule DA_makeList_ml[simplified]) 
      prefer 5 apply (erule DA_Eq1)
      apply simp+
done
*)

subsubsection {*Misc stuff*}

text {* These two aux lemmas are needed in every Consumer2.thy  file *}

lemma triv: "\<lbrakk>x:S; S=S1; x:S1 \<longrightarrow> P\<rbrakk>\<Longrightarrow> P" by simp
(*The appication of this lemma in the consumer2-files can probably be
  eliminated if the definition of SPEC and/or sMST is modified slightly.*)

lemma FRAME_unique[rule_format]:
"(r, a, x, E', E) \<in> FRAME \<Longrightarrow>
         \<forall>  EE. (r, a, x, E', EE) \<in> FRAME \<longrightarrow> E=EE"
apply (erule FRAME.induct)
apply clarsimp
apply (erule FRAME.elims) apply clarsimp apply clarsimp apply clarsimp apply clarsimp
apply (rule, rule) apply (rotate_tac -1)
  apply (erule FRAME.elims) apply clarify apply clarify apply (erule_tac x=EEb in allE, simp) apply clarify apply clarify
apply (rule, rule) apply (rotate_tac -1)
  apply (erule FRAME.elims) apply clarify apply clarify apply clarify apply (erule_tac x=EEb in allE, simp) apply clarify 
apply (rule, rule) apply (rotate_tac -1)
  apply (erule FRAME.elims) apply clarify apply clarify  apply clarify apply clarify apply (erule_tac x=EEb in allE, simp) 
done

text {* These definitions and lemmas are needed in every Wrap.thy file *}

constdefs emptyheap :: "heap"
"emptyheap == (| oheap = emptyfinmap, iheap = (% x r . (0::int)) , rheap = (% x r. Nullref), sheap = (% c r . Nullref) |)"

constdefs emptyenv :: "env"
"emptyenv == (| ienv = emptyi , renv = emptyr |)"

(*<*)
(* U \<subseteq> set args ; *)
consts "set_of_rnames" :: "ARGTYPE \<Rightarrow> rname set"
primrec
 "set_of_rnames [] = {}"
 "set_of_rnames (x#xs) = (case x of
                            INarg iname => set_of_rnames xs
                          | RNarg rname => insert rname (set_of_rnames xs)
                          | VALarg val => set_of_rnames xs)"

lemma CS_Weaken_Env_Aux : "(E', h, U, G, R, P) \<in> CS \<Longrightarrow>
 (\<forall> E . (\<forall> r . r : U \<longrightarrow> E\<lfloor>r\<rfloor>=E'\<lfloor>r\<rfloor>) \<longrightarrow>  (E, h, U, G, R, P) \<in> CS)"
apply (erule CS.induct)
apply clarsimp
apply (rule CS_NIL)
apply simp apply simp
apply clarsimp
apply (rule CS_CONS)
prefer 5
apply simp
prefer 5
apply simp
prefer 4
apply simp
prefer 2
prefer 3
apply (erule_tac x="Ea" in allE)
apply simp
apply simp?
apply assumption
done

lemma CS_Weaken_Env : "\<lbrakk> (E', h, U, G, R, P) \<in> CS ; (\<forall> r . r : U \<longrightarrow> E\<lfloor>r\<rfloor>=E'\<lfloor>r\<rfloor>) \<rbrakk> \<Longrightarrow> (E, h, U, G, R, P) \<in> CS"
apply (frule CS_Weaken_Env_Aux)
apply (erule_tac x="E" in allE)
apply (drule mp)
apply clarsimp
apply simp
done

lemma DAss_Weaken_EnvU: "\<lbrakk> \<forall> r . r : U \<longrightarrow> E\<lfloor>r\<rfloor>=E'\<lfloor>r\<rfloor> ; 
                DAss U n G T m E h hh v p \<rbrakk>
      \<Longrightarrow> DAss U n G  T m E' h hh v p"
apply (simp add:  DAss_def)
apply clarsimp
apply (erule_tac x="q" in allE)
apply (erule_tac x="F" in allE)
apply (erule_tac x="R" in allE)
apply (erule impE) 
apply (rotate_tac -1)
apply (rule_tac x="N" in exI)
apply simp
apply (rule_tac x="P" in exI)
apply (rule conjI)
apply (rule CS_Weaken_Env)
apply (rotate_tac -2)
apply simp
apply clarsimp
apply simp
apply simp
done


lemma card_emptyheap0: "card (Dom emptyheap) = 0"
apply (simp add: emptyheap_def)
done

lemma bonzo_1838: "oheap h = oheap hh ==> Dom h = Dom hh"
apply (simp add: fmap_dom_def)
done

lemma empFree: "freelist emptyheap {} 0"
apply (simp add: freelist_def emptyheap_def)
apply (rule FL_NIL)
done

lemma eq_sym: "(a::oheap)=b ==> b=a"
apply auto
done

lemma DA_Weaken_Context: "\<lbrakk> \<rhd> e : \<lbrace> U, m, C  \<ggreater>  T , n \<rbrace> ; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x \<rbrakk> \<Longrightarrow> \<rhd> e : \<lbrace> U, m, D  \<ggreater>  T , n \<rbrace>"
apply (rule vdm_conseq)
apply simp
apply clarsimp
apply (rule DAss_Contexts_same_on_U)
apply (rotate_tac -1)
apply simp
apply clarsimp
done

end

