theory TestVCG4 = MergeMCertificate :

ML_setup {*
  val basicsimpset_tac = simp_tac HOL_basic_ss
  fun sym_basicsimp i = FIRST [CHANGED (simp_tac HOL_basic_ss i), rtac add_commute i]

  fun localsimp_tac ctxt i = simp_tac (Simplifier.get_local_simpset ctxt) i
  fun localsimp_tac_thms ctxt thms = 
     simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)
  fun simpset_tac_thms t i = simp_tac (HOL_basic_ss addsimps ([fst_conv,snd_conv]@t)) i

  fun repeat 0 tac = all_tac
    | repeat n tac = tac THEN (repeat (n-1) tac)

  val mrg_int = thm "MRG_Int"
  val mrg_ivar = thm "MRG_IVar"
  val mrg_rvar = thm "MRG_RVar"
  val mrg_prim = thm "MRG_Prim"
  val mrg_rprim = thm "MRG_RPrim"
  val mrg_nulllist = thm "MRG_NullList"
  val mrg_nullres = thm "MRG_NullRes"
  val mrg_nulltree = thm "MRG_NullTree"
  val mrg_makelist = thm "MRG_MakeList"
  val mrg_maketree = thm "MRG_MakeTree"
  val mrg_makeresult = thm "MRG_MakeResultSome"
  val mrg_invstat = thm "MRG_InvStat"
  val mrg_letv = thm "MRG_Letv"
  val mrg_leti = thm "MRG_Leti"
  val mrg_letr = thm "MRG_Letr"
  val mrg_letrnull = thm "MRG_LetrNull"
  val mrg_listmatch = thm "MRG_ListMatch"
  val mrg_listmatchd = thm "MRG_ListMatchD"
  val mrg_treematch = thm "MRG_TreeMatch"
  val mrg_treematchd = thm "MRG_TreeMatchD"
  val mrg_resultmatch = thm "MRG_ResultMatch"
  val mrg_resultmatchd = thm "MRG_ResultMatchD"
  val mrg_if = thm "MRG_If"
  val mrg_weak = thm "MRG_Weak"

  val mrg_call = thm "MRG_Call"
  val mrg_domcallnil = thm "DOM_CallNIL"
  val mrg_domcallcons = thm "DOM_CallCONS"

  val rena_nil = thm "RENA_NIL"
  val rena_in = thm "RENA_IN"
  val rena_rn = thm "RENA_RN"

  val mrg_sound = thm "MRG_sound"

  fun getr_tac ctxt i = localsimp_tac ctxt i
  fun getr_clar_tac ctxt i = EVERY [localsimp_tac ctxt i, clarify_tac HOL_cs i]
  fun getr_fast ctxt i = SELECT_GOAL (FIRST [SOLVE (getr_tac ctxt i), EVERY [getr_tac ctxt i, fast_tac (claset()) i]]) i

  fun bsf i = SELECT_GOAL (FIRST [SOLVE (basicsimpset_tac i), EVERY [basicsimpset_tac i, fast_tac (claset()) i]]) i
  fun lsf ctxt i = SELECT_GOAL (FIRST [SOLVE (localsimp_tac ctxt i), EVERY [localsimp_tac ctxt i, fast_tac (claset()) i]]) i

  fun type_tac i = basicsimpset_tac i
  fun context_tac ctxt thms i = localsimp_tac_thms ctxt thms i

  fun stop ctxt thms i = all_tac

  fun ast i = asm_simp_tac (simpset()) i 

  fun ast_thms thms i = 
     asm_simp_tac ((simpset()) addsimps thms) i

  fun ast_fast i =
         SELECT_GOAL (FIRST[SOLVE (ast i),
                            EVERY [ast i,fast_tac (claset()) i]]) i
  fun ast_thms_fast thms i = 
         SELECT_GOAL (FIRST[SOLVE (ast_thms thms i), 
                            EVERY [ast_thms thms i,fast_tac (claset()) i]]) i

  fun RENA_tac i state = state |> 
    FIRST [EVERY [rtac rena_in i, RENA_tac i],
           EVERY [rtac rena_rn i, RENA_tac i],
           rtac rena_nil i]

  fun null_tac ctxt i =
    FIRST [EVERY [rtac mrg_nulllist i, localsimp_tac ctxt i],
           EVERY [rtac mrg_nullres i, localsimp_tac ctxt i],
           EVERY [rtac mrg_nulltree i, localsimp_tac ctxt i]]

  fun null_tac_simp ctxt i = 
     EVERY [SELECT_GOAL (FIRST [null_tac ctxt i, EVERY[localsimp_tac ctxt i, null_tac ctxt i]]) i]

  fun leaf_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i =
   FIRST [EVERY [rtac mrg_int i, localsimp_tac ctxt i],
          EVERY [rtac mrg_ivar i, localsimp_tac ctxt i],
          EVERY [rtac mrg_rvar i, getr_fast ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_prim i, localsimp_tac ctxt i],
          EVERY [rtac mrg_rprim i, repeat 2 (getr_fast ctxt i), localsimp_tac ctxt i],
          EVERY [rtac mrg_maketree i, getr_fast ctxt i, getr_fast ctxt i,
                 localsimp_tac ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_makelist i, getr_fast ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_makeresult i, getr_fast ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_invstat i,
                 localsimp_tac_thms ctxt c_defs i, 
                 localsimp_tac_thms ctxt m_defs i, 
                 ast_thms m_defs i,
                 ast i,
                 ast_thms_fast m_defs i, ast_fast i, 
                 repeat 2 (localsimp_tac_thms ctxt [thm "DOM_def"] i),
                 repeat 2 (localsimp_tac ctxt i),
                 ast_thms m_defs i,
                 RENA_tac i,
                 localsimp_tac ctxt i],
          null_tac_simp ctxt i
         ]

  fun let_tac ctxt thms rectac i = 
      FIRST [EVERY [rtac mrg_letv i, leaf_tac ctxt thms i, rectac i, bsf i],
             EVERY [rtac mrg_leti i, leaf_tac ctxt thms i, rectac i, bsf i],
(*             EVERY [rtac mrg_letrnull i, rectac i, leaf_tac ctxt thms i, lsf ctxt i, bsf i],*)
             EVERY [rtac mrg_letrnull i, rectac i, null_tac_simp ctxt i, lsf ctxt i, bsf i],
             EVERY [rtac mrg_letr i, leaf_tac ctxt thms i, rectac i, lsf ctxt i, bsf i]]

  fun match_tac ctxt rectac i = 
    FIRST [EVERY [rtac mrg_listmatchd i, getr_fast ctxt i, 
                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_resultmatchd i, getr_fast ctxt i, 
                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_treematchd i, (getr_fast ctxt i),
                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_listmatch i, (getr_fast ctxt i),
                  basicsimpset_tac i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_resultmatch i, (getr_fast ctxt i),
                  basicsimpset_tac i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_treematch i, (getr_fast ctxt i),
                  basicsimpset_tac i, localsimp_tac ctxt i, localsimp_tac ctxt i, rectac i, lsf ctxt i]]
  
  fun call_tac ctxt thms tac i =
   EVERY [rtac mrg_call i, 
	  localsimp_tac_thms ctxt thms i,
          tac i]

  fun call_stop_tac ctxt thms tac i =
   EVERY [rtac mrg_call i, 
	  localsimp_tac_thms ctxt thms i,
          stop ctxt thms i]

  fun asm_localsimp_tac ctxt = asm_simp_tac (Simplifier.get_local_simpset ctxt)
  fun funsimp_tac_thms t = simp_tac (HOL_basic_ss addsimps (snd_conv :: t))
  fun domm_tac ctxt thms tac1 tac2 i =
    FIRST [EVERY [rtac mrg_domcallnil i, asm_localsimp_tac ctxt i,
                  funsimp_tac_thms thms i, rtac mrg_sound i,
                  tac1 i],
           EVERY [rtac mrg_domcallcons i, tac1 i,
                  localsimp_tac_thms ctxt thms i,tac2 i],
           EVERY [rtac conjI i,  (* leaves subgoal of form ?U = X *)
                  localsimp_tac_thms ctxt thms i,
	          rtac disjI1 i,
                  localsimp_tac_thms ctxt thms i]]

     (* here: solve a subgoal of the same form, then simplify with MFS_defs to expand method body
        in other subgoals (for each of the dominators?)
	We want to do this to maintain invariant for VCG.
        asm_localsimp_tac_thms ctxt thms 2
     *)
  (* rec_tac : ctxt \<rightarrow> thms \<rightarrow> int \<rightarrow> tactic \<rightarrow> tactic \<rightarrow> int \<rightarrow> tactic*)
  fun dom_tac ctxt thms rec_tac tac2 i =
    let fun domcall n state = state |> 
       ((((rtac mrg_domcallcons i) THEN domcall (n+1))
	 ORELSE
	 (EVERY 
	  ([(rtac mrg_domcallnil i),
	    asm_localsimp_tac ctxt i,
	   (* asm_localsimp_tac_thms ctxt thms i,*)
	    funsimp_tac_thms thms i,
            rtac mrg_sound i,
	    rec_tac i] @
	   (map tac2 (rev (i upto (i+n-1)))))))
	 ORELSE
	 (* solve for a merge point by projecting on the context, 
	    solving a set-equality subgoal *)
	 (EVERY
	  [rtac conjI i,  (* leaves subgoal of form ?U = X *)
           localsimp_tac_thms ctxt thms i,
	   rtac disjI1 i,
	   localsimp_tac_thms ctxt thms i]))
      in domcall 0 end

  fun if_tac rec_tacTHEN rec_tacELSE i =
   EVERY [rtac mrg_if i,
          rec_tacTHEN i,
	  rec_tacELSE i]

  fun w_tac ctxt thms tac i = 
    EVERY
      [TRY(localsimp_tac_thms ctxt thms i),  (* expand SPEC, methtable *)
       rtac mrg_sound i,
       rtac mrg_weak i,
       tac i,
       fast_tac (claset()) i]

  fun main_stop ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> 
    FIRST [if_tac (stop ctxt thms) (stop ctxt thms) i,
           call_tac ctxt (d_defs@m_defs@f_defs@c_defs) (stop ctxt thms) i,(*HWL: all ?_defs???*)
(*           dom_tac ctxt f_defs (stop ctxt thms) (w_tac ctxt f_defs (stop ctxt thms)) i,*)
           domm_tac ctxt f_defs (stop ctxt thms) (w_tac ctxt (f_defs@d_defs@m_defs@c_defs) (stop ctxt thms)) i,
           leaf_tac ctxt thms i,
           match_tac ctxt (stop ctxt thms) i,
           let_tac ctxt thms (stop ctxt thms) i]

   fun main_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> 
    FIRST [if_tac (main_tac ctxt thms) (main_tac ctxt thms) i,
           call_tac ctxt d_defs (main_tac ctxt thms) i,
(*           dom_tac ctxt f_defs (main_tac ctxt thms) (w_tac ctxt f_defs (main_tac ctxt thms)) i,*)
           domm_tac ctxt f_defs (main_tac ctxt thms) (w_tac ctxt f_defs (main_tac ctxt thms)) i,
           leaf_tac ctxt thms i,
           match_tac ctxt (main_tac ctxt thms) i,
           let_tac ctxt thms (main_tac ctxt thms) i]
*}


(* -------------------- Certificate *)
(*
defs
isMergePoint_def: "isMergePoint f == f \<in> {}"
dominates_def: "dominates f == (if f = MergeM'splitAt'f_splitAt then List.filter isMergePoint [MergeM'splitAt'f_0, MergeM'splitAt'f_1] else
                 if f = MergeM'splitAt'f_0 then List.filter isMergePoint [MergeM'splitAt'f_2, MergeM'splitAt'f_3] else
                 if f = MergeM'splitAt'f_1 then List.filter isMergePoint [MergeM'splitAt'f_4, MergeM'splitAt'f_5] else
                 if f = MergeM'merge'f_merge then List.filter isMergePoint [MergeM'merge'f_0, MergeM'merge'f_1] else
                 if f = MergeM'merge'f_1 then List.filter isMergePoint [MergeM'merge'f_2, MergeM'merge'f_3] else
                 if f = MergeM'merge'f_3 then List.filter isMergePoint [MergeM'merge'f_4, MergeM'merge'f_5] else [])"
defs SPEC_def: " SPEC M == (
  if M = MergeM'splitAt then \<lbrace> {MergeM'splitAt'xs}, 0, [(MergeM'splitAt'xs, (ListET 0 0))] \<ggreater> (ListET 0 0), 0\<rbrace>
 else
  if M = MergeM'merge then \<lbrace> {MergeM'merge'lx, MergeM'merge'ly}, 0, [(MergeM'merge'lx, (ListET 0 0)),(MergeM'merge'ly, (ListET 0 0))] \<ggreater> (ListET 0 0), 0\<rbrace>
 else
   (\<lambda> E h hh v p . False))"
constdefs  Context:: vdmcontext
 " Context == {(MergeM\<bullet>MergeM'splitAt([INarg MergeM'splitAt'n, RNarg MergeM'splitAt'xs]), sMST MergeM MergeM'splitAt [INarg MergeM'splitAt'n, RNarg MergeM'splitAt'xs]) ,
(MergeM\<bullet>MergeM'merge([RNarg MergeM'merge'lx, RNarg MergeM'merge'r2]), sMST MergeM MergeM'merge [RNarg MergeM'merge'lx, RNarg MergeM'merge'r2]) ,(MergeM\<bullet>MergeM'merge([RNarg MergeM'merge'r4, RNarg MergeM'merge'lx]), sMST MergeM MergeM'merge [RNarg MergeM'merge'r4, RNarg MergeM'merge'lx]) }" 
lemmas dmp_defs = dominates_def isMergePoint_def
lemmas ctxt_def  = Context_def
lemmas meth_defs = SPEC_def Meth_MergeM'splitAt Meth_MergeM'merge
lemmas splitAt_pdefs = SPEC_def Fun_MergeM'splitAt'f_0 Fun_MergeM'splitAt'f_1 Fun_MergeM'splitAt'f_2 Fun_MergeM'splitAt'f_3 Fun_MergeM'splitAt'f_4 Fun_MergeM'splitAt'f_5 Fun_MergeM'splitAt'f_splitAt  Meth_MergeM'splitAt 
lemmas merge_pdefs = SPEC_def Fun_MergeM'merge'f_0 Fun_MergeM'merge'f_1 Fun_MergeM'merge'f_2 Fun_MergeM'merge'f_3 Fun_MergeM'merge'f_4 Fun_MergeM'merge'f_5 Fun_MergeM'merge'f_merge  Meth_MergeM'merge 

lemmas fun_defs =  Fun_MergeM'splitAt'f_0 Fun_MergeM'splitAt'f_1 Fun_MergeM'splitAt'f_2 Fun_MergeM'splitAt'f_3 Fun_MergeM'splitAt'f_4 Fun_MergeM'splitAt'f_5 Fun_MergeM'splitAt'f_splitAt  
 Fun_MergeM'merge'f_0 Fun_MergeM'merge'f_1 Fun_MergeM'merge'f_2 Fun_MergeM'merge'f_3 Fun_MergeM'merge'f_4 Fun_MergeM'merge'f_5 Fun_MergeM'merge'f_merge  


(* 
 splitAt :: \<lbrace> {MergeM'splitAt'xs}, 0, (emptyfinmap(MergeM'splitAt'xs \<mapsto>\<^sub>f(ListET 0 0))) \<ggreater> (ListET 0 0), 0\<rbrace>

 merge :: \<lbrace> {MergeM'merge'lx, MergeM'merge'ly}, 0, (emptyfinmap(MergeM'merge'lx \<mapsto>\<^sub>f(ListET 0 0))(MergeM'merge'ly \<mapsto>\<^sub>f(ListET 0 0))) \<ggreater> (ListET 0 0), 0\<rbrace>

*)

ML {* val global_v = 1 *}

(*string_of_int :: IntET
 -> (ListET 0 0)
*)
ML {* val global_v_string_of_int = 1 *}

(*stringList_to_intList :: (ListET 1 0) -> (ListET 0 0)*)
ML {* val global_v_stringList_to_intList = 1 *}

(*start :: (ListET 1 0) -> UnitET
*)
ML {* val global_v_start = 1 *}

(*splitAt :: IntET
 -> (ListET 0 0) -> (ListET 0 0)*)
ML {* val global_v_splitAt = 1 *}

(*show_list0 :: (ListET 0 0) -> (ListET 0 0)
*)
ML {* val global_v_show_list0 = 1 *}

(*show_list :: (ListET 0 0) -> (ListET 0 0)
*)
ML {* val global_v_show_list = 1 *}

(*print_string :: (ListET 0 0)
 -> UnitET
*)
ML {* val global_v_print_string = 1 *}

(*merge :: (ListET 0 0) -> (ListET 0 0) -> (ListET 0 0)*)
ML {* val global_v_merge = 1 *}

(*int_of_string :: (ListET 0 0)
 -> IntET
*)
ML {* val global_v_int_of_string = 1 *}
*)

(* -------------------- TACTIC *)

method_setup AST_THMS = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (ast_thms thms 1)))*}
  "Method for asm_simp_tac"
method_setup AST_THMS_FAST = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (ast_thms_fast thms 1)))*}
  "Method for asm_simp_tac"
method_setup LEAF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => leaf_tac ctxt ([],thms "meth_defs",[],thms "ctxt_def") 1))*}
  "Method for leaf rules"
method_setup BS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => basicsimpset_tac 1))*}
  "Method for basic simpset"
method_setup BSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => bsf 1))*}
  "Method for basic simpset + fast"
method_setup SB = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => sym_basicsimp 1))*}
  "Method for symmetric basic simpset"
method_setup GT = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_tac ctxt 1))*}
  "Method for GETr"
method_setup GTC = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_clar_tac ctxt 1))*}
  "Method for GETr with clarify"
method_setup GTF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_fast ctxt 1))*}
  "Method for GETr with fast"
method_setup STT = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => simpset_tac_thms thms 1))*}
  "Method for basic simpset"
method_setup LS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac ctxt 1))*}
  "Method for local simpset"
method_setup LSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => lsf ctxt 1))*}
  "Method for local simpset + fast"
method_setup LSTT = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac_thms ctxt thms 1))*}
  "Method for local_simpset_thms"
method_setup LET = {* Method.thms_ctxt_args (fn t => fn ctxt => 
  Method.METHOD (fn facts => let_tac ctxt ([],thms "meth_defs",t,thms "ctxt_def") (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1))*}
  "Method for local_simpset_thms"
method_setup IF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => if_tac (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def"))  (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1)) *}
  "Method for a Conditional"
method_setup CALL = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => call_tac ctxt pdefs (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1)) *}
  "Method for a Call"
method_setup CALLS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => call_stop_tac ctxt pdefs (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1)) *}
  "Method for a Call"
(*
method_setup IF = {* Method.thms_ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => if_tac ctxt ([],thms "meth_defs",t,thms "ctxt_def") (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1))*}
  "Method for Conditionals"
method_setup CALL = {* Method.thms_ctxt_args (fn t => fn ctxt => 
  Method.METHOD (fn facts => call_tac ctxt ([],thms "meth_defs",t,thms "ctxt_def") (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1))*}
  "Method for Calls"
*)
method_setup MATCH = {* Method.thms_ctxt_args (fn t => fn ctxt => 
  Method.METHOD (fn facts => match_tac ctxt (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1))*}
  "Method for matches"
method_setup SBS = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (sym_basicsimp 1)))*}
  "Method for symbasicsimp"
method_setup ASM_LOC = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => 
    asm_simp_tac (Simplifier.get_local_simpset ctxt) 1))*}
"asm_local_simpset"
method_setup MS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => main_stop ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def") 1)) *}
  "main Method with stop continuation, simplification with args" 
method_setup M = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def") 1)) *}
  "main Method: simplification with args" 
 
method_setup W = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac ctxt ((thms "meth_defs")@(thms "ctxt_def")) (main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def")) 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast" 
method_setup WS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac ctxt (thms "meth_defs") (main_stop ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def")) 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast"

method_setup DOMM = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => domm_tac ctxt pdefs (main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def")) (w_tac ctxt (thms "meth_defs") (main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def"))) 1)) *}
  "parametric Method for DOMM"

method_setup DOMS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => domm_tac ctxt pdefs (stop ctxt []) (stop ctxt []) 1)) *}
  "parametric Method for DOMM; 1-step"

lemma MergeM'merge_DAss_4:
"Context \<rhd> snd (methtable MergeM MergeM'merge) : SPEC MergeM'merge"
apply (W merge_pdefs)
done

lemma MergeM'splitAt_DAss_4:
"Context \<rhd> snd (methtable MergeM MergeM'splitAt) : SPEC MergeM'splitAt"
apply (W splitAt_pdefs)
done



lemma BoNZO:
"Context \<rhd> snd (methtable MergeM MergeM'merge) : SPEC MergeM'merge"
apply simp?
apply (simp add: meth_defs)
apply (rule MRG_sound)
apply (tactic {* rtac mrg_weak 1 *})
apply (rule MRG_Call)
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (rule DOM_CallNIL)
apply fastsimp
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (tactic {* rtac mrg_weak 1 *})
apply (rule MRG_Leti)
apply (rule MRG_RPrim)
apply GT
apply GT
apply simp
apply (rule MRG_If)
apply (tactic {* rtac mrg_weak 1 *})
apply (rule MRG_Call)
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (rule DOM_CallNIL)
apply fastsimp
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (rule MRG_RVar)
apply GT
apply (simp add: meth_defs)
apply fastsimp
apply (tactic {* rtac mrg_weak 1 *})
apply (rule MRG_Call)
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (rule DOM_CallNIL)
apply fastsimp
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (rule MRG_ListMatchD)
apply GT
apply fastsimp
apply fastsimp
apply fastsimp
apply (tactic {* rtac mrg_weak 1 *})
apply (rule MRG_Leti)
apply (rule MRG_RPrim)
apply GT
apply GT
apply simp
apply (rule MRG_If)
apply (tactic {* rtac mrg_weak 1 *})
apply (rule MRG_Call)
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (rule DOM_CallNIL)
apply fastsimp
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (rule MRG_Weak)
apply (rule MRG_MakeList)
apply GT
apply fastsimp
apply fastsimp
apply fastsimp
apply (tactic {* rtac mrg_weak 1 *})
apply (rule MRG_Call)
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (rule DOM_CallNIL)
apply fastsimp
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (rule MRG_ListMatchD)
apply GT
apply fastsimp
apply simp
apply simp
apply (tactic {* rtac mrg_weak 1 *})
apply (rule MRG_Leti)
apply (rule MRG_Prim)
apply simp

apply (rule MRG_If)
apply (tactic {* rtac mrg_weak 1 *})
apply (rule MRG_Call)
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (rule DOM_CallNIL)
apply fastsimp
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (tactic {* rtac mrg_weak 1 *})
apply (rule MRG_Letr)
apply (rule MRG_MakeList)
apply GT
apply fastsimp
apply fastsimp
apply (rule MRG_Letr)
apply AST_THMS
apply (MS merge_pdefs)

apply (rule MRG_MakeList)
apply GT
apply fastsimp+
apply (M merge_pdefs)
apply fastsimp+
defer 1
defer 1
apply fastsimp+
defer 1
(* almost there; 3 side conds left *)
oops

lemma BoNZO_me_too:
"Context \<rhd> snd (methtable MergeM MergeM'merge) : SPEC MergeM'merge"
apply (simp add: meth_defs)
apply (rule MRG_sound)
(* apply (rule MRG_Weak) *)
apply (MS merge_pdefs)
apply (rule DOM_CallNIL)
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (simp add: merge_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (rule MRG_Weak)
apply (M merge_pdefs)
apply fastsimp
done
(* Yipiee *)

(*
lemma BoNZO_the_way_it_should_be:
"Context \<rhd> snd (methtable MergeM MergeM'merge) : SPEC MergeM'merge"
apply (WS merge_pdefs)
oops
*)

(* even shorter *)
lemma MergeM'splitAt_DAss_3:
"Context \<rhd> snd (methtable MergeM MergeM'splitAt) : SPEC MergeM'splitAt"
apply (simp add: splitAt_pdefs)
apply (tactic {* rtac mrg_sound 1 *})
apply (tactic {* rtac mrg_weak 1 *})
apply (simp only: Context_def)
apply (M splitAt_pdefs)
apply fastsimp
done

(* almost fully expanded *)
lemma MergeM'splitAt_DAss:
"Context \<rhd> snd (methtable MergeM MergeM'splitAt) : SPEC MergeM'splitAt"
apply (simp add: meth_defs)
apply (rule MRG_sound)
apply (rule MRG_Weak)
apply (MS splitAt_pdefs)
apply (rule DOM_CallNIL)
apply (simp add: Context_def)
apply (rule MRG_sound)
apply (rule MRG_Weak)
apply (simp add: Fun_MergeM'splitAt'f_splitAt)
apply (M splitAt_pdefs)
apply fastsimp+
done


apply (simp add: merge_pdefs dmp_defs Context_def)
apply (simp add: Fun_MergeM'splitAt'f_splitAt)
apply (rule MRG_Leti)
apply (rule MRG_Int)
apply simp
apply (rule MRG_Leti)
apply (rule MRG_Prim)
apply simp
apply (rule MRG_If)
apply (MS splitAt_pdefs)
apply (rule DOM_CallNIL)
apply (simp add: Context_def)
apply (simp add: splitAt_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (rule MRG_Weak)

apply (rule MRG_Leti)
apply (rule MRG_RPrim)
apply GT
apply GT
apply simp
apply (rule MRG_If)
apply (MS splitAt_pdefs)
apply (rule DOM_CallNIL)
apply (simp add: Context_def)
apply (simp add: splitAt_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (rule MRG_Weak)

apply (rule MRG_RVar)
apply GT
apply simp
apply simp
defer 1
apply (MS splitAt_pdefs)
apply (rule DOM_CallNIL)
apply (simp add: Context_def)
apply (simp add: splitAt_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (rule MRG_Weak)

apply (rule MRG_ListMatchD)
apply GT
apply fastsimp
apply fastsimp
apply fastsimp
apply (rule MRG_Weak)
apply (rule MRG_Letr)
apply (rule MRG_NullList)
apply simp
apply (rule MRG_Letr)
apply (rule MRG_MakeList)
apply GT
apply fastsimp
apply fastsimp
apply (rule MRG_RVar)
apply GT
apply simp
apply fastsimp+

apply (MS splitAt_pdefs)
apply (rule DOM_CallNIL)
apply (simp add: Context_def)

apply (simp add: splitAt_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (rule MRG_Weak)
apply (rule MRG_Leti)
apply (rule MRG_RPrim)
apply GT
apply GT
apply simp
apply (rule MRG_If)
apply (MS splitAt_pdefs)
apply (rule DOM_CallNIL)
apply (simp add: Context_def)

apply (simp add: splitAt_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (rule MRG_Weak)
apply (rule MRG_RVar)
apply GT
apply simp
defer 1
apply (MS splitAt_pdefs)
apply (rule DOM_CallNIL)
apply (simp add: Context_def)

apply (simp add: splitAt_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (rule MRG_Weak)
apply (rule MRG_Leti)
apply (rule MRG_Int)
apply simp
apply (rule MRG_ListMatch)
apply GT
apply fastsimp
apply fastsimp
apply (rule MRG_Leti)
apply (rule MRG_Prim)
apply simp
apply (MS splitAt_pdefs)
apply fastsimp+
done

(* shorter to track down bug in tactic *)
lemma MergeM'splitAt_DAss_2:
"Context \<rhd> snd (methtable MergeM MergeM'splitAt) : SPEC MergeM'splitAt"
apply (simp add: meth_defs)
apply (rule MRG_sound)
(* apply (M  splitAt_pdefs)  *)
(* apply (MS splitAt_pdefs) *)
apply CALL
apply (simp add: splitAt_pdefs dmp_defs)
apply (rule DOM_CallNIL)
apply (simp add: Context_def)
apply (simp add: splitAt_pdefs dmp_defs Context_def)
apply (rule MRG_sound)
apply (rule MRG_Weak)
apply (M splitAt_pdefs)
apply fastsimp
done



lemma Sort_DAss:
"HeapSortContext \<rhd> snd (methtable MergeM MergeM'sort) : SPEC MergeM'sort"
oops
(* by (W sort_prog_defs) *)

lemma Make_heap_DAss:
"Context \<rhd> snd (methtable MergeM MergeM'make_heap) : SPEC MergeM'make_heap"
apply simp?
apply (simp add: meth_defs)
apply (rule MRG_sound)
apply (tactic {* rtac mrg_weak 1 *})
apply (rule MRG_Call)
apply (simp add: mh_prog_defs dmp_defs)
apply (rule DOM_CallNIL)
apply (simp add: mh_prog_defs dmp_defs HeapSortContext_def)
apply (rule MRG_sound)
apply (tactic {* rtac mrg_weak 1 *})
apply (simp add: meth_defs)
apply (rule MRG_Call)
apply (simp add: mh_prog_defs dmp_defs)
apply (rule DOM_CallNIL)
apply (simp add: mh_prog_defs dmp_defs HeapSortContext_def)
apply (rule MRG_sound)

apply (rule disjI)
apply GT
apply (simp add: meth_defs)
apply (M mh_prog_defs)
oops
by (W mh_prog_defs)

lemma Insert_DAss:
"HeapSortContext \<rhd> snd (methtable MergeM MergeM'insert) : SPEC MergeM'insert"
by (W ins_prog_defs)

lemma Removetop_DAss:
"HeapSortContext \<rhd> snd (methtable MergeM MergeM'removetop) : SPEC MergeM'removetop"
by (W rt_prog_defs)

lemma Removesome_DAss:
"HeapSortContext \<rhd> snd (methtable MergeM MergeM'removesome) : SPEC MergeM'removesome"
by (W rs_prog_defs)

lemma Extract_DAss:
"HeapSortContext \<rhd> snd (methtable MergeM MergeM'extract) : SPEC MergeM'extract"
by (W ex_prog_defs)

lemma Siftdown_DAss:
"HeapSortContext \<rhd> snd (methtable MergeM MergeM'siftdown) : SPEC MergeM'siftdown"
apply (W sd_prog_defs)
done (*75secs*)

done
(*
apply (simp add: meth_defs)
apply (rule MRG_sound)
apply (rule MRG_Weak)
apply (M sd_prog_defs)
apply (rule MRG_Call)
  apply (simp add: dmp_defs)
  apply (rule DOM_CallNIL) apply simp
  apply (simp add: sd_prog_defs)
  apply (rule MRG_sound)
    apply (rule MRG_Leti)
    apply LEAF
    apply (rule MRG_If)
      apply (M sd_prog_defs)
      apply (rule MRG_Call)
        apply (simp add: dmp_defs)
        apply (rule DOM_CallNIL) apply simp
        apply (simp add: sd_prog_defs)
        apply (rule MRG_sound)
        apply (rule MRG_TreeMatchD)
          apply GTF
          apply BS
          apply LS
          apply (M sd_prog_defs)
          apply (rule MRG_Leti)
            apply LEAF
            apply (rule MRG_If)
            (^then^)
               apply (M sd_prog_defs)
            (^else^)
               apply (M sd_prog_defs)
(^               apply (rule MRG_Call)
               apply (LSTT dmp_defs)
               apply (DOMM sd_prog_defs)
               apply (rule DOM_CallCONS)
                (&1 of 2&)
                   apply (M sd_prog_defs)
                (&2 of 2&) 
                      apply (tactic {*funsimp_tac_thms (thms "sd_prog_defs") 1*})
                      apply (W sd_prog_defs)
           EVERY [rtac mrg_domcallcons i, tac1 i,
                  localsimp_tac_thms ctxt thms i,tac2 i],*)
apply LS
apply LS
apply LSF
apply LSF
     ^)
*)     
by (Wp sd_prog_defs)(*27secs*)

lemmas DAss_lemmas = Sort_DAss Extract_DAss Insert_DAss Removesome_DAss Make_heap_DAss Removetop_DAss Siftdown_DAss

(*This lemma is absolutely trivial, but it allows us to unfold the HeapsortContext more cautiously*)
lemma triv: "\<lbrakk>x:S; S=S1; x:S1 \<longrightarrow> P\<rbrakk>\<Longrightarrow> P" by simp

lemma HeapSortContext_good: "goodContext FST vMST sMST HeapSortContext"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (rule disjI2, rule disjI2)
apply (erule triv, simp add: HeapSortContext_def)
apply safe
by (simp only: sMST_def, clarsimp, rule vdm_conseq, rule DAss_lemmas, 
    clarify, simp add: SPEC_def , erule DAss_PConst)+

text {*Thus, we can prove that arbitrary invocations of @{text Sort} honour
       the entry in the specification table, in the empty VDM context.*}
theorem HSCorrect: "\<rhd> HS\<bullet>Sort([RNarg x]): sMST HeapSortM Sort [RNarg x]"
apply (rule GCInvs)
apply (rule HeapSortContext_good)
apply (simp_all add: HeapSortContext_def)
apply fastsimp
done 

theorem "\<rhd> HS\<bullet>Sort([RNarg y]): \<lbrace> {y}, 0 , ([(y ,(ListET 0 0)))  \<ggreater> (ListET 0 0) , 0 \<rbrace>"
apply (rule InvokeRename)
apply (rule HSCorrect)
apply (simp_all add: meth_defs newframe_env_def evalARGS_def)
apply (fastsimp intro: REN.intros)
apply simp+
done

end

(* Adaptation lemmas and previous tactics and methods:
lemma Siftdown_Invoke1:
"\<lbrakk>sMST HeapSortM Siftdown [INarg x, RNarg y, RNarg z] E h hh v p; distinct [y,z]\<rbrakk> \<Longrightarrow>
  \<lbrace> {y,z} , 1 , ([(y ,(TreeET 0 0))(z ,(TreeET 0 0))) \<ggreater>  (TreeET 0 0), 0 \<rbrace> E h hh v p"
apply (simp add: SPEC_def)
apply (erule AdaptRename)
apply (subgoal_tac "distinct (fst (methtable HeapSortM Siftdown))", assumption)
apply (simp add: MFS_defs)
apply (subgoal_tac "distinct [INarg x, RNarg y, RNarg z]", assumption)
apply simp
apply (simp add: MFS_defs)
apply (rule REN_IN)
apply (rule REN_RN)
apply (rule REN_RN)
apply (rule REN_NIL)
apply simp
apply simp
apply (simp add: MFS_defs)
apply simp
apply (simp add: MFS_defs)
apply clarsimp
apply (case_tac "xa=y", clarsimp)
apply (case_tac "xa=z", clarsimp)
apply clarsimp
apply clarsimp
apply (case_tac "x=y", clarsimp)
apply (case_tac "x=z", clarsimp)
apply clarsimp
done

(&uses Renaming with functions
lemma Siftdown_Invoke1:
"\<lbrakk>sMST HeapSortM Siftdown [INarg x, RNarg y, RNarg z] E h hh v p; f y = t1_; f z=t2_\<rbrakk> \<Longrightarrow>
  \<lbrace> {y,z} , 1 , ([(y ,(TreeET 0 0))(z ,(TreeET 0 0))) \<ggreater>  (TreeET 0 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (erule DAss_Rename)
apply fastsimp
apply fastsimp
apply clarsimp
apply (erule disjE, rule, simp)
apply (subgoal_tac "renv E z =
            renv \<lparr>ienv = emptyi, renv = emptyr(RN ''self'' := Nullref)\<rparr><w_:=ienv E x>\<lfloor>t1_:=renv E y\<rfloor>\<lfloor>t2_:=renv E z\<rfloor> (f z)", assumption) apply simp
apply simp
apply simp
apply (subgoal_tac "y \<noteq> z", simp) apply fastsimp
apply fastsimp
apply fastsimp
done
&)

lemma LL2: "\<lbrakk>(E, h, U,C,R,m):CS; U = V\<rbrakk> \<Longrightarrow> (E, h, V,C,R,m):CS" (&<&)by simp(&>&)

lemma Siftdown_Invoke:
"\<lbrakk>sMST HeapSortM Siftdown [INarg x, RNarg y, RNarg z] E h hh v p; y \<noteq>z\<rbrakk> \<Longrightarrow>
  \<lbrace> {y,z} , 1 , ([(y ,(TreeET 0 0))(z ,(TreeET 0 0))) \<ggreater>  (TreeET 0 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Make_heap_Invoke:
"sMST HeapSortM Make_heap [RNarg x] E h hh v p 
 \<Longrightarrow> \<lbrace> {x}, 0 , ([(x ,(ListET 0)))  \<ggreater> (TreeET 0 0) , 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Sort_Invoke:
"sMST HeapSortM Sort [RNarg x] E h hh v p 
 \<Longrightarrow> \<lbrace>{x}, 0, [(x ,(ListET 0)) \<ggreater> ListET 0, 0\<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Extract_Invoke:
"sMST HeapSortM Extract [RNarg x] E h hh v p 
\<Longrightarrow> \<lbrace> {x}, 0 , ([(x ,(TreeET 0 0)))  \<ggreater> (ListET 0) , 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Insert_Invoke:
"sMST HeapSortM Insert [INarg x, RNarg y] E h hh v p 
\<Longrightarrow> \<lbrace> {y} , 1 , ([(y ,(TreeET 0 0))) \<ggreater>  (TreeET 0 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Removetop_Invoke:
"sMST HeapSortM Removetop [RNarg x] E h hh v p 
\<Longrightarrow> \<lbrace> {x} , 0 , ([(x ,(TreeET 0 0))) \<ggreater>  (ResultET 0 (TreeET 0 0) 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Removesome_Invoke:
"sMST HeapSortM Removesome [RNarg x] E h hh v p 
\<Longrightarrow> \<lbrace> {x} , 0 , ([(x ,(TreeET 0 0))) \<ggreater>  (ResultET 0 (TreeET 0 0) 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemmas adaptations = 
   Siftdown_Invoke Make_heap_Invoke Sort_Invoke Extract_Invoke
   Insert_Invoke 
   Removetop_Invoke Removesome_Invoke 
(&=================================================================&)
(& Methods &)

ML_setup {&
  fun localsimp_tac ctxt = simp_tac (Simplifier.get_local_simpset ctxt)
  fun asm_localsimp_tac ctxt = asm_simp_tac (Simplifier.get_local_simpset ctxt)
  fun localsimp_tac_thms ctxt thms = 
     simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)
  fun asm_localsimp_tac_thms ctxt thms = 
     asm_simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)

  fun repeat 0 tac = all_tac
    | repeat n tac = tac THEN (repeat (n-1) tac)


  (& Bind Isar ids to ML ids &)
  val vcg_weak = thm "DA_Weak"

  val vcg_int = thm "vcg_int"
  val vcg_ivar = thm "vcg_ivar"
  val vcg_rvar = thm "vcg_rvar"
  val vcg_prim = thm "vcg_prim"
  val vcg_rprim = thm "vcg_rprim"
  val vcg_if = thm "DA_If"
  val vcg_letint = thm "DA_Let_Int"
  val vcg_letprim = thm "vcg_letprim"
  val vcg_letrprim = thm "vcg_letrprim"
  val vcg_letnull = thm "vcg_letnull"
  val vcg_call = thm "vcg_call"

  val vcg_nullresult = thm "DA_NullResult"
  val vcg_nulltree = thm "DA_NullTree"
  val vcg_nulllist = thm "DA_NullList"
  val vcg_listmatchd = thm "vcg_ListMatchD"
  val vcg_treematchd = thm "vcg_TreeMatchD"
  val vcg_resultmatchd = thm "vcg_ResultMatchD"

  val vcg_domcallcons = thm "vcg_domcallcons"
  val vcg_domcallnil = thm "vcg_domcallnil"

  val vcg_makelist = thm "vcg_makelist"
  val vcg_makeresult = thm "vcg_makeresult"
  val vcg_maketree = thm "vcg_maketree"
  val vcg_letrmaketree = thm "vcg_letrmaketree"

  val vcg_letrinvokeconst = thm "vcg_letrinvokeconst"
  val vcg_letrinvokeconstRename = thm "vcg_letrinvokeconstRename"

  val vcg_ren_in = thm "REN_IN"
  val vcg_ren_rn = thm "REN_RN"
  val vcg_ren_nil = thm "REN_NIL"

  val vcg_rinvokeconst = thm "DA_InvokeConst"
  val vcg_rinvokeconstRename = thm "vcg_invokeconstRename"

  val Siftdown_Invoke = thm "Siftdown_Invoke"
  val Make_heap_Invoke = thm "Make_heap_Invoke"
  val Sort_Invoke = thm "Sort_Invoke"
  val Extract_Invoke = thm "Extract_Invoke"
  val Insert_Invoke = thm "Insert_Invoke"
  val Removetop_Invoke = thm "Removetop_Invoke"
  val Removesome_Invoke = thm "Removesome_Invoke"

  (& Define tactics &)

  fun adapt_tac ctxt i =
   FIRST [EVERY [etac Siftdown_Invoke i, localsimp_tac ctxt i],
          etac Make_heap_Invoke i,
          etac Sort_Invoke i,
          etac Extract_Invoke i,
          etac Insert_Invoke i,
          etac Removetop_Invoke i,
          etac Removesome_Invoke i]

   (& apply (fast intro: REN.intros) i.e. (apply (rule REN_IN | rule REN_RN | rule REN_NIL)+&)
   fun REN_tac i state = state |> 
    FIRST [EVERY [rtac vcg_ren_in i, REN_tac i],
           EVERY [rtac vcg_ren_rn i, REN_tac i],
           rtac vcg_ren_nil i]

  fun invr_tac ctxt (f_defs,d_defs,c_defs) i =
          EVERY [rtac vcg_rinvokeconst i,
                 localsimp_tac_thms ctxt c_defs i,
                 clarify_tac HOL_cs i,
                 adapt_tac ctxt i,
                 repeat 3 (localsimp_tac ctxt i)]

  fun invrRename_tac ctxt (f_defs,d_defs,c_defs) i =
          EVERY [rtac vcg_rinvokeconstRename i,
                 localsimp_tac_thms ctxt c_defs i,
                 repeat 3 (localsimp_tac_thms ctxt d_defs i),
                 repeat 6 (localsimp_tac ctxt i),
                 localsimp_tac_thms ctxt d_defs i, REN_tac i,
                 localsimp_tac_thms ctxt d_defs i,
                 localsimp_tac ctxt i]

  fun leaf_tac ctxt thms i = 
  FIRST
   [resolve_tac [vcg_int, vcg_ivar, vcg_rvar, vcg_prim] i,
    (EVERY [resolve_tac [vcg_rprim] i,
	    localsimp_tac ctxt i,
	    localsimp_tac ctxt i]),
    (EVERY [resolve_tac [vcg_makelist] i,
	    repeat 2 (localsimp_tac ctxt i)]),
    (EVERY [resolve_tac [vcg_makeresult] i,
	    repeat 2 (localsimp_tac ctxt i)]),
    (EVERY [resolve_tac [vcg_maketree] i,
	    repeat 4 (localsimp_tac ctxt i)]),
    invrRename_tac ctxt thms i]

  fun if_tac ctxt rec_tacTHEN rec_tacELSE i =
   EVERY [rtac vcg_if i,
	  rec_tacELSE ctxt (i+1),
          rec_tacTHEN ctxt i]
  (& for datatypes &)

  fun null_tac ctxt i =
   EVERY [TRY (localsimp_tac ctxt i),
          ((rtac vcg_nullresult i) THEN (localsimp_tac ctxt i))
          ORELSE (rtac vcg_nulltree i)
          ORELSE (rtac vcg_nulllist i)]


  fun res_matchd_tac ctxt rec_tac i state = state |> 
          EVERY
           [rtac vcg_resultmatchd i,
            localsimp_tac ctxt (i+1),
	    rtac conjI (i+1),
            localsimp_tac ctxt (i+1),
	    rtac conjI (i+1),
            localsimp_tac ctxt (i+1),
	    repeat 3 (localsimp_tac ctxt (i+1)),
            rec_tac ctxt (i+1),
            localsimp_tac ctxt i]

  fun tree_matchd_tac ctxt rec_tac i state = state |> 
          EVERY
           [rtac vcg_treematchd i,
	    repeat 3 (localsimp_tac ctxt (i+1)),
            rec_tac ctxt (i+1),
            localsimp_tac ctxt i]

  fun list_matchd_tac ctxt rec_tac i state = state |> 
    EVERY [(rtac vcg_listmatchd i),
           (localsimp_tac ctxt (i+1)),
           (localsimp_tac ctxt (i+1)),
	   (CHANGED (localsimp_tac ctxt (i+1))),
            rec_tac ctxt (i+1),
            localsimp_tac ctxt i]

  fun matchd_tac ctxt rec_tac i =
   FIRST [list_matchd_tac ctxt rec_tac i,
          tree_matchd_tac ctxt rec_tac i,
          res_matchd_tac ctxt rec_tac i]

  (& works for: Letint, Letprim, LetRPrim, LetNull &)
  fun let_tac ctxt (f_defs,d_defs,c_defs) rec_tac i =
   FIRST [EVERY [rtac vcg_letint i,
		 rec_tac ctxt i],
          EVERY [rtac vcg_letprim i,
		 rec_tac ctxt i],
          EVERY [resolve_tac [vcg_letrprim] i,
	         localsimp_tac ctxt i,
	         localsimp_tac ctxt i,
	         rec_tac ctxt i],
	  EVERY [rtac vcg_letnull i,
	         localsimp_tac ctxt (i+1),
	         localsimp_tac ctxt (i+1),
	         rec_tac ctxt (i+1),
                 null_tac ctxt (i+1),
		 localsimp_tac ctxt i],
	  EVERY [rtac vcg_letrmaketree i,
	         repeat 4 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i]]

   fun letinv_tac ctxt (f_defs,d_defs,c_defs) rec_tac i =
          EVERY [rtac vcg_letrinvokeconst i,
                 localsimp_tac_thms ctxt c_defs (i+1),
                 clarify_tac HOL_cs (i+1),
                 adapt_tac ctxt (i+1),
                 repeat 4 (localsimp_tac ctxt (i+1)),
                 rec_tac ctxt (i+1),
                 localsimp_tac ctxt i]

   fun letrinvRename_tac ctxt (f_defs,d_defs,c_defs) rec_tac i =
          EVERY [rtac vcg_letrinvokeconstRename i,
                 localsimp_tac_thms ctxt c_defs (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1), REN_tac (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 rec_tac ctxt (i+1),
                 localsimp_tac ctxt i]

  fun call_tac ctxt thms tac i =
   EVERY [rtac vcg_call i, 
	  localsimp_tac_thms ctxt thms i,
          tac i]

     (& here: solve a subgoal of the same form, then simplify with MFS_defs to expand method body
        in other subgoals (for each of the dominators?)
	We want to do this to maintain invariant for VCG.
        asm_localsimp_tac_thms ctxt thms 2
     &)
  (& rec_tac : ctxt \<rightarrow> thms \<rightarrow> int \<rightarrow> tactic \<rightarrow> tactic \<rightarrow> int \<rightarrow> tactic&)
  fun dom_tac ctxt thms rec_tac tac2 i =
    let fun domcall n state = state |> 
       ((((rtac vcg_domcallcons i) THEN domcall (n+1))
	 ORELSE
	 (EVERY 
	  ([(rtac vcg_domcallnil i),
	    asm_localsimp_tac ctxt i,
	    asm_localsimp_tac_thms ctxt thms i,
	    rec_tac ctxt i] @
	   (map (tac2 ctxt) (rev (i upto (i+n-1)))))))
	 ORELSE
	 (& solve for a merge point by projecting on the context, 
	    solving a set-equality subgoal &)
	 (EVERY
	  [rtac conjI i,  (& leaves subgoal of form ?U = X &)
           localsimp_tac_thms ctxt thms i,
	   rtac disjI1 i,
	   localsimp_tac_thms ctxt thms i]))
      in domcall 0 end

  fun stop ctxt i = all_tac
  fun stop_thms thms ctxt i = all_tac

  fun fst_tac i = fast_tac (claset()) i

  fun weak_tac ctxt thms tac i = 
    EVERY
      [localsimp_tac_thms ctxt thms i,  (& expand SPEC, methtable &)
       rtac vcg_weak i,
       tac ctxt i]
  
  fun w_tac thms tac ctxt i = 
    EVERY
      [localsimp_tac_thms ctxt thms i,  (& expand SPEC, methtable &)
       rtac vcg_weak i,
       tac ctxt i,
       fst_tac i]

   fun l_tac (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac thms) (l_tac thms) i,
           let_tac ctxt thms (l_tac thms) i,
           call_tac ctxt f_defs (l_tac thms ctxt) i,
           dom_tac ctxt d_defs (l_tac thms) (w_tac d_defs (l_tac thms)) i,
           matchd_tac ctxt (l_tac thms) i,
           letinv_tac ctxt thms (l_tac thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac2 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt stop stop i,
           let_tac ctxt thms (l_tac2 thms) i,
           call_tac ctxt f_defs (l_tac2 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac2 thms) stop i,
           matchd_tac ctxt stop i,
           letinv_tac ctxt thms (l_tac2 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac3 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac3 thms) (l_tac3 thms) i,
           let_tac ctxt thms (l_tac3 thms) i,
           call_tac ctxt f_defs (l_tac3 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac3 thms) stop i,
           res_matchd_tac ctxt (l_tac3 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac4 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt stop (l_tac4 thms) i,
           let_tac ctxt thms (l_tac4 thms) i,
           call_tac ctxt f_defs (l_tac4 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac4 thms) stop i,
           matchd_tac ctxt (l_tac4 thms) i,
           letinv_tac ctxt thms (l_tac4 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac5 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac5 thms) (l_tac5 thms) i,
           let_tac ctxt thms (l_tac5 thms) i,
           call_tac ctxt f_defs (l_tac5 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac5 thms) (w_tac d_defs (l_tac5 thms)) i,
           matchd_tac ctxt (l_tac5 thms) i,
           letinv_tac ctxt thms (l_tac5 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac6 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac6 thms) (l_tac6 thms) i,
           let_tac ctxt thms (l_tac6 thms) i,
           call_tac ctxt f_defs (l_tac6 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac6 thms) (w_tac d_defs (l_tac6 thms)) i,
           matchd_tac ctxt (l_tac6 thms) i,
           letrinvRename_tac ctxt thms (l_tac6 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]
&}
method_setup method_leaf = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => leaf_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 1))  &}
 "Method for solving leaf cases in the derivation."    
 
method_setup method_If = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => if_tac ctxt stop stop 1)) &}
  "Method for If, reduces to two subgoals"

method_setup method_Let = {& Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => let_tac ctxt (thms,thms,thms) stop 1)) &}
  "Method for LetPrim/LetRPrim/LetNull, reduces to one subgoal"

method_setup method_Letinv = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) &}
  "Method for Letrinvoke"

method_setup method_Letinvs = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             stop 1)) &}
  "Method for Letrinvoke"

(& apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def) &)
method_setup method_Call = {& Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (stop ctxt) 1)) &}
  "Method for Call, leaves dominates subgoal"
(&
method_setup method_CallDom = {& Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (fn ctxt => fn thms => dom_tac ctxt thms (K stop)) 1)) &}
  "Method for Call, leaves dominates subgoal"
&)

(& apply (simp?, (rule DA_NullResult, simp) | rule DA_NullTree | rule DA_NullList) &)
method_setup method_Null = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => null_tac ctxt 1)) &}
  "Method for Nullresult, nulltree and nulllist"

(& FIXME: to combine method_Call with method_Dom or mergepoint stuff, we need to
   ideally need a method which accepts more than one parameter &)

(& apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs) &)
method_setup method_Dom = {& Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => dom_tac ctxt thms stop stop 1)) &}
  "Method for Dom" 

method_setup ltac = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac2 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac2 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac3 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac3 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac4 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac4 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac5 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac5 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac6 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup rmd = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) &}
  "test for resultmatchd"

method_setup rmds = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt stop 1)) &}
  "test for resultmatchd"

method_setup lmd = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => list_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) &}
  "test for listmatchd"

method_setup lmds = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => list_matchd_tac ctxt stop 1)) &}
  "test for listmatchd"

method_setup tmd = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => tree_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) &}
  "test for treematchd"

method_setup tmds = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => tree_matchd_tac ctxt stop 1)) &}
  "test for treematchd"
method_setup method_fast = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => fst_tac 1)) &}
  "Method for fast"

method_setup method_simp = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac ctxt 1)) &}
  "Method for simp"

method_setup method_Weaks = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "meth_defs") stop 1)) &}
  "Method for starting: use weakening, simplification with args" 

method_setup method_Weak = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) &}
  "Method for starting: use weakening, simplification with args" 

method_setup method_REN = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => REN_tac 1)) &}
  "Method for starting: use weakening, simplification with args, fast"

*)
