theory InsSortWWrap = ResourcePolicy + InsSortW_Consumer2:

(* --------------------------------------------------------------------------- *)
(* WRAPPER *)

consts init :: mname
       INPUT :: "ARG list"
       l0 :: rname 
       l1 :: rname 

translations 
       "init" == "(MN ''init_'') "
       "l0" == "(RN ''l0_'') "
       "l1" == "(RN ''l1_'') "

constdefs emptyheap :: "heap"
"emptyheap == (| oheap = emptyfinmap, iheap = (% x r . (0::int)) , rheap = (% x r. Nullref), sheap = (% c r . Nullref) |)"

constdefs emptyenv :: "env"
"emptyenv == (| ienv = emptyi , renv = emptyr |)"

(*# UNFOLD_LIB init #*)
constdefs initSpecDA :: "vdmassn"
"initSpecDA  == \<lbrace> {}, 0, [(l1 , (ListET 0 0))] \<ggreater> (ListET 0 0), 0\<rbrace>"

(*<*)
(* U \<subseteq> set args ; *)
consts "set_of_rnames" :: "ARGTYPE \<Rightarrow> rname set"
primrec
 "set_of_rnames [] = {}"
 "set_of_rnames (x#xs) = (case x of
                            INarg iname => set_of_rnames xs
                          | RNarg rname => insert rname (set_of_rnames xs)
                          | VALarg val => set_of_rnames xs)"

lemma CS_Weaken_Env_Aux : "(E', h, U, G, R, P) \<in> CS \<Longrightarrow>
 (\<forall> E . (\<forall> r . r : U \<longrightarrow> E\<lfloor>r\<rfloor>=E'\<lfloor>r\<rfloor>) \<longrightarrow>  (E, h, U, G, R, P) \<in> CS)"
apply (erule CS.induct)
apply clarsimp
apply (rule CS_NIL)
apply simp apply simp
apply clarsimp
apply (rule CS_CONS)
prefer 5
apply simp
prefer 5
apply simp
prefer 4
apply simp
prefer 2
prefer 3
apply (erule_tac x="Ea" in allE)
apply simp
apply simp?
apply assumption
done

lemma CS_Weaken_Env : "\<lbrakk> (E', h, U, G, R, P) \<in> CS ; (\<forall> r . r : U \<longrightarrow> E\<lfloor>r\<rfloor>=E'\<lfloor>r\<rfloor>) \<rbrakk> \<Longrightarrow> (E, h, U, G, R, P) \<in> CS"
apply (frule CS_Weaken_Env_Aux)
apply (erule_tac x="E" in allE)
apply (drule mp)
apply clarsimp
apply simp
done

lemma DAss_Weaken_EnvU: "\<lbrakk> \<forall> r . r : U \<longrightarrow> E\<lfloor>r\<rfloor>=E'\<lfloor>r\<rfloor> ; 
                DAss U n G T m E h hh v p \<rbrakk>
      \<Longrightarrow> DAss U n G  T m E' h hh v p"
apply (simp add:  DAss_def)
apply clarsimp
apply (erule_tac x="q" in allE)
apply (erule_tac x="F" in allE)
apply (erule_tac x="R" in allE)
apply (erule impE) 
apply (rotate_tac -1)
apply (rule_tac x="N" in exI)
apply simp
apply (rule_tac x="P" in exI)
apply (rule conjI)
apply (rule CS_Weaken_Env)
apply (rotate_tac -2)
apply simp
apply clarsimp
apply simp
apply simp
done


lemma card_emptyheap0: "card (Dom emptyheap) = 0"
apply (simp add: emptyheap_def)
done

lemma bonzo_1838: "oheap h = oheap hh ==> Dom h = Dom hh"
apply (simp add: fmap_dom_def)
done

lemma empFree: "freelist emptyheap {} 0"
apply (simp add: freelist_def emptyheap_def)
apply (rule FL_NIL)
done

lemma eq_sym: "(a::oheap)=b ==> b=a"
apply auto
done

lemma DA_Weaken_Context: "\<lbrakk> \<rhd> e : \<lbrace> U, m, C  \<ggreater>  T , n \<rbrace> ; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x \<rbrakk> \<Longrightarrow> \<rhd> e : \<lbrace> U, m, D  \<ggreater>  T , n \<rbrace>"
apply (rule vdm_conseq)
apply simp
apply clarsimp
apply (rule DAss_Contexts_same_on_U)
apply (rotate_tac -1)
apply simp
apply clarsimp
done
(*>*)
(* ------------ *)
(* Main wrapper theorem *)


theorem resourceStatement: " \<rhd> InvokeStatic InsSortW init INPUT : initSpecDA \<Longrightarrow> \<rhd> (LET rf l1 = InvokeStatic InsSortW init INPUT IN InvokeStatic InsSortW sort_ [RNarg l1]
 
  END) : (\<lambda> E h hh v p . (ALL n .  h = emptyheap & E = emptyenv & n = length INPUT
 -->
 (HSize hh < (int HEAP_BOUND) )))"


apply (rule vdm_conseq)
apply (rule vdm_letr)
apply (simp add: initSpecDA_def)
apply (simp add: initSpecDA_def)
apply (erule thin_rl)
apply (insert T_sort  [of "l1"])
apply (simp add: sMST_def SPEC_def)
apply clarsimp
apply (erule_tac x="?EE" in allE)
apply (drule mp)
apply (simp add: meth_defs)
apply (rule FRAME_RN) apply (rule FRAME_NIL) apply simp 
apply (simp add: DAss_def)
apply (erule_tac x="0" in allE) apply (rotate_tac -1)
apply (erule_tac x="{}" in allE) apply (rotate_tac -1)
apply (erule_tac x="{}" in allE) apply (rotate_tac -1)
apply clarsimp
apply (erule impE)
apply (rule_tac x="0" in exI)
apply (rule conjI)
apply (rule empFree)
apply (rule_tac x="0" in exI)
apply (rule conjI)
apply (insert CS_NIL)
defer 1
apply simp
apply clarsimp
apply (subgoal_tac "M=0")
apply clarsimp
apply (erule_tac x="0" in allE) apply (rotate_tac -1)
apply (erule_tac x="{}" in allE) apply (rotate_tac -1)
apply (erule_tac x="{}" in allE) apply (rotate_tac -1)
apply clarsimp
apply (erule impE)
apply (rule_tac x="0" in exI)
apply (rule conjI)
apply simp
apply (rule_tac x="0" in exI)
apply (rule conjI)
apply (rule CS_CONS)
apply simp
apply simp
apply simp
apply (rule CS_NIL)
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply clarsimp
apply (rotate_tac -6) apply (drule eq_sym) apply (rotate_tac -1)
apply (drule bonzo_1838)
apply simp
apply (insert card_emptyheap0)
apply simp
apply (simp add: freelist_def)
apply (rule FL.cases)
apply simp_all
apply simp
apply simp
done

end
