theory R_TACTIC = RCertificate:

ML_setup {*
  val indent = ref 0

  fun spaces 0 s = s
    | spaces n s = spaces (n-1) (" "^s)

  val basicsimpset_tac = simp_tac HOL_basic_ss
  fun sym_basicsimp i = FIRST [CHANGED (simp_tac HOL_basic_ss i), rtac add_commute i]

  fun localsimp_tac ctxt i = simp_tac (Simplifier.get_local_simpset ctxt) i
  fun localsimp_tac_thms ctxt thms = 
     simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)
  fun simpset_tac_thms t i = simp_tac (HOL_basic_ss addsimps ([fst_conv,snd_conv]@t)) i

  fun repeat 0 tac = all_tac
    | repeat n tac = tac THEN (repeat (n-1) tac)

  val mrg_int = thm "MRG_Int"
  val mrg_ivar = thm "MRG_IVar"
  val mrg_rvar = thm "MRG_RVar"
  val mrg_prim = thm "MRG_Prim"
  val mrg_rprim = thm "MRG_RPrim"
  val mrg_nulllist = thm "MRG_NullList"
  val mrg_nullres = thm "MRG_NullRes"
  val mrg_nulltree = thm "MRG_NullTree"
  val mrg_makelist = thm "MRG_MakeList"
  val mrg_maketree = thm "MRG_MakeTree"
  val mrg_makeresult = thm "MRG_MakeResultSome"
  val mrg_invstat = thm "MRG_InvStat"
  val mrg_letv = thm "MRG_Letv"
  val mrg_leti = thm "MRG_Leti"
  val mrg_letr = thm "MRG_Letr"
  val mrg_letrnull = thm "MRG_LetrNull"
  val mrg_listmatch = thm "MRG_ListMatch"
  val mrg_listmatchd = thm "MRG_ListMatchD"
  val mrg_treematch = thm "MRG_TreeMatch"
  val mrg_treematchd = thm "MRG_TreeMatchD"
  val mrg_resultmatch = thm "MRG_ResultMatch"
  val mrg_resultmatchd = thm "MRG_ResultMatchD"
  val mrg_if = thm "MRG_If"
  val mrg_weak = thm "MRG_Weak"

  val mrg_call = thm "MRG_Call"
  val mrg_domcallnil = thm "DOM_CallNIL"
  val mrg_domcallcons = thm "DOM_CallCONS"

  val rena_nil = thm "RENA_NIL"
  val rena_in = thm "RENA_IN"
  val rena_rn = thm "RENA_RN"

  val mrg_sound = thm "MRG_sound"

  fun getr_tac ctxt i = localsimp_tac ctxt i
  fun getr_clar_tac ctxt i = EVERY [localsimp_tac ctxt i, clarify_tac HOL_cs i]
  fun getr_fast ctxt i = SELECT_GOAL (FIRST [SOLVE (getr_tac ctxt i), EVERY [getr_tac ctxt i, fast_tac (claset()) i]]) i

  fun hwl_bsf i = SELECT_GOAL (FIRST [SOLVE (basicsimpset_tac i), EVERY [basicsimpset_tac i, fast_tac (claset()) i], TRY (basicsimpset_tac i)]) i
  fun hwl_lsf ctxt i = SELECT_GOAL (FIRST [SOLVE (localsimp_tac ctxt i), EVERY [localsimp_tac_thms ctxt [thm "set_diff_def"] i]]) i

  fun bsf i = SELECT_GOAL (FIRST [SOLVE (basicsimpset_tac i), EVERY [basicsimpset_tac i, fast_tac (claset()) i]]) i
  fun lsf ctxt i = SELECT_GOAL (FIRST [SOLVE (localsimp_tac ctxt i), EVERY [localsimp_tac ctxt i, fast_tac (claset()) i]]) i

  fun type_tac i = basicsimpset_tac i
  fun context_tac ctxt thms i = localsimp_tac_thms ctxt thms i

  fun stop ctxt thms i = all_tac

  fun ast i = asm_simp_tac (simpset()) i 

  fun ast_thms thms i = 
     asm_simp_tac ((simpset()) addsimps thms) i

  fun ast_fast i =
         SELECT_GOAL (FIRST[SOLVE (ast i),
                            EVERY [ast i,fast_tac (claset()) i]]) i
  fun ast_thms_fast thms i = 
         SELECT_GOAL (FIRST[SOLVE (ast_thms thms i), 
                            EVERY [ast_thms thms i,fast_tac (claset()) i]]) i

  fun RENA_tac i state = state |> 
    (indent := (!indent)+1 ; all_tac)
    THEN
    print_tac (spaces (!indent) "^RENA_TAC: rena_tac ...")
    THEN
    FIRST [EVERY [rtac rena_in i, RENA_tac i],
           EVERY [rtac rena_rn i, RENA_tac i],
           rtac rena_nil i]
    THEN
    print_tac (spaces (!indent) "+RENA_tac ...")
    THEN
    (indent := (!indent)-1 ; all_tac)

  fun null_tac ctxt i =
    FIRST [EVERY [rtac mrg_nulllist i, print_tac (spaces (!indent)  "@@@ nulllist"), localsimp_tac ctxt i],
           EVERY [rtac mrg_nullres i, print_tac (spaces (!indent)  "@@@ nullres"), localsimp_tac ctxt i],
           EVERY [rtac mrg_nulltree i, print_tac (spaces (!indent)  "@@@ nulltree"), localsimp_tac ctxt i]]

  fun null_tac_simp ctxt i = 
     EVERY [SELECT_GOAL (FIRST [null_tac ctxt i, EVERY[localsimp_tac ctxt i, null_tac ctxt i]]) i]

  fun leaf_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i =
   (indent := (!indent)+1 ; all_tac)
   THEN
   print_tac (spaces (!indent) "^LEAF_TAC: leaf_tac ...")
   THEN
   FIRST [EVERY [rtac mrg_int i, localsimp_tac ctxt i],
          EVERY [rtac mrg_ivar i, localsimp_tac ctxt i],
          EVERY [rtac mrg_rvar i, getr_fast ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_prim i, localsimp_tac ctxt i],
          EVERY [rtac mrg_rprim i, repeat 2 (getr_fast ctxt i), localsimp_tac ctxt i],
          EVERY [rtac mrg_maketree i, print_tac (spaces (!indent)  "@@@ maketree"), getr_fast ctxt i, getr_fast ctxt i,
                 localsimp_tac ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_makelist i, print_tac (spaces (!indent)  "@@@ makelist"), getr_fast ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_makeresult i, print_tac (spaces (!indent)  "@@@ makeresult"), getr_fast ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_invstat i,
                 print_tac (spaces (!indent)  "@@@ invstat"), 
                 localsimp_tac_thms ctxt c_defs i, 
                 localsimp_tac_thms ctxt m_defs i, 
                 ast_thms m_defs i,
                 ast i,
                 ast_thms_fast m_defs i, ast_fast i, 
                 repeat 2 (localsimp_tac_thms ctxt [thm "DOM_def"] i),
                 repeat 2 (localsimp_tac ctxt i),
                 ast_thms m_defs i,
                 RENA_tac i,
                 localsimp_tac ctxt i,
                 (* HWL: sometimes more clean-up necessary *)
                 TRY(EVERY[rtac conjI i, localsimp_tac ctxt i, localsimp_tac ctxt i,
                           print_tac (spaces (!indent)  "@@@ BONZO was here (InvokeStatic cleanup)")])],
          null_tac_simp ctxt i
         ]
  THEN
  print_tac (spaces (!indent) "+leaf_tac ...")
  THEN
  (indent := (!indent)-1 ; all_tac)

  fun let_tac ctxt thms rectac i = 
     (indent := (!indent)+1 ; all_tac)
     THEN
      print_tac (spaces (!indent) "^LET_TAC: let_tac ...")
      THEN
      FIRST [EVERY [print_tac (spaces (!indent)  "___ trying letv"), rtac mrg_letv i, print_tac (spaces (!indent)  "@@@ letv"), leaf_tac ctxt thms i, rectac i, bsf i],
             EVERY [print_tac (spaces (!indent)  "___ trying leti"), rtac mrg_leti i, print_tac (spaces (!indent)  "@@@ leti"), leaf_tac ctxt thms i, rectac i, bsf i],
(*           EVERY [rtac mrg_letrnull i, rectac i, leaf_tac ctxt thms i, lsf ctxt i, bsf i],*)
             EVERY [print_tac (spaces (!indent)  "___ trying letrnull"), rtac mrg_letrnull i, print_tac (spaces (!indent) "@@@ letnull"), rectac i, null_tac_simp ctxt i, lsf ctxt i, bsf i],
             EVERY [print_tac (spaces (!indent)  "___ trying letr"), rtac mrg_letr i, print_tac (spaces (!indent) "@@@ letr"), leaf_tac ctxt thms i, rectac i, lsf ctxt i, bsf i]]
  THEN
  print_tac (spaces (!indent) "+LET_tac ...")
  THEN
  (if ((!indent)=1) then no_tac else all_tac)
  THEN
  (indent := (!indent)-1 ; all_tac)


  fun match_tac ctxt rectac i = 
    (indent := (!indent)+1 ; all_tac)
    THEN
    FIRST [
            EVERY [rtac mrg_listmatchd i, 
                   print_tac (spaces (!indent) "@@@ LISTmatchD"),
                  getr_fast ctxt i, 
                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
            EVERY [rtac mrg_resultmatchd i, 
                  print_tac (spaces (!indent) "@@@ RESULTmatchD"),
                  getr_fast ctxt i, 
                   basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
            EVERY [rtac mrg_treematchd i, 
                   print_tac (spaces (!indent) "@@@ TREEmatchD"),
                   (getr_fast ctxt i),
                   basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
            EVERY [rtac mrg_listmatch i, 
                  print_tac (spaces (!indent) "@@@ LISTmatch"),
                  (getr_fast ctxt i),
                  basicsimpset_tac i, rectac i, lsf ctxt i],
            EVERY [rtac mrg_resultmatch i, 
                   print_tac (spaces (!indent) "@@@ RESULTmatch"),
                   (getr_fast ctxt i),
                   basicsimpset_tac i, rectac i, lsf ctxt i],
            EVERY [rtac mrg_treematch i, 
                  print_tac (spaces (!indent) "@@@ TREEmatch"),
                  (getr_fast ctxt i),
                  basicsimpset_tac i, localsimp_tac ctxt i, localsimp_tac ctxt i, rectac i, lsf ctxt i]]
    THEN
    (indent := (!indent)-1 ; all_tac)
  
  (* verbose version reporting every tried tac *)
  fun verbose_main_tac ctxt rectac i = 
    (indent := (!indent)+1 ; all_tac)
    THEN
    FIRST [
            EVERY [print_tac (spaces (!indent) "___ MATCH_TAC: trying LISTmatchD etc ..."),
                  rtac mrg_listmatchd i, 
                  print_tac "++listmatch",
                  getr_fast ctxt i, 
                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
            EVERY [print_tac (spaces (!indent) "___ MATCH_TAC: trying RESULTmatchD etc ..."),
                   rtac mrg_resultmatchd i, 
                  print_tac "++resultmatchD",
                  getr_fast ctxt i, 
                   basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
            EVERY [print_tac (spaces (!indent) "___ MATCH_TAC: trying TREEmatchD etc ..."),
                   rtac mrg_treematchd i, 
                   print_tac "++treematchd",
                   (getr_fast ctxt i),
                   basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
            EVERY [print_tac (spaces (!indent) "___ MATCH_TAC: trying LISTmatch etc ..."),
                  rtac mrg_listmatch i, 
                  print_tac "++listmatchd",
                  (getr_fast ctxt i),
                  basicsimpset_tac i, rectac i, lsf ctxt i],
            EVERY [print_tac (spaces (!indent) "___ MATCH_TAC: trying RESULTmatch etc ..."),
                   rtac mrg_resultmatch i, 
                  print_tac "++resultmatchd",
                   (getr_fast ctxt i),
                   basicsimpset_tac i, rectac i, lsf ctxt i],
            EVERY [print_tac (spaces (!indent) "___ MATCH_TAC: trying TREEmatch etc ..."),
                   rtac mrg_treematch i, 
                  print_tac "++treematchd",
                  (getr_fast ctxt i),
                  basicsimpset_tac i, localsimp_tac ctxt i, localsimp_tac ctxt i, rectac i, lsf ctxt i]]
    THEN
    (indent := (!indent)-1 ; all_tac)
  
  fun call_tac ctxt thms tac i =
   (indent := (!indent)+1 ; all_tac)
   THEN
   print_tac (spaces (!indent) "^CALL_TAC: call_tac ...")
   THEN
   EVERY [rtac mrg_call i, 
	  localsimp_tac_thms ctxt thms i,
          tac i]
   THEN
   print_tac (spaces (!indent) "+call_tac ...")
   THEN
   (indent := (!indent)-1 ; all_tac)

  fun call_stop_tac ctxt thms tac i =
   EVERY [rtac mrg_call i, 
	  localsimp_tac_thms ctxt thms i,
          stop ctxt thms i]

  fun asm_localsimp_tac ctxt = asm_simp_tac (Simplifier.get_local_simpset ctxt)
  fun funsimp_tac_thms t = simp_tac (HOL_basic_ss addsimps (snd_conv :: t))
  fun domm_tac ctxt thms tac1 tac2 i =
    print_tac (spaces (!indent) "^DOMM_TAC: domm_tac ...")
    THEN
    FIRST [EVERY [rtac mrg_domcallnil i, asm_localsimp_tac ctxt i,
                  funsimp_tac_thms thms i, rtac mrg_sound i,
                  tac1 i],
           EVERY [rtac mrg_domcallcons i, tac1 i,
                  localsimp_tac_thms ctxt thms i,tac2 i],
           EVERY [rtac conjI i,  (* leaves subgoal of form ?U = X *)
                  localsimp_tac_thms ctxt thms i,
	          TRY(rtac disjI1 i), (* HWL: not if call was in dom set!! *)
                  localsimp_tac_thms ctxt thms i]]
    THEN
    print_tac (spaces (!indent) "+domm_tac ...")

     (* here: solve a subgoal of the same form, then simplify with MFS_defs to expand method body
        in other subgoals (for each of the dominators?)
	We want to do this to maintain invariant for VCG.
        asm_localsimp_tac_thms ctxt thms 2
     *)
  (* rec_tac : ctxt \<rightarrow> thms \<rightarrow> int \<rightarrow> tactic \<rightarrow> tactic \<rightarrow> int \<rightarrow> tactic*)
  fun dom_tac ctxt thms rec_tac tac2 i =
    let fun domcall n state = state |> 
       ((((rtac mrg_domcallcons i) THEN domcall (n+1))
	 ORELSE
	 (EVERY 
	  ([(rtac mrg_domcallnil i),
	    asm_localsimp_tac ctxt i,
	   (* asm_localsimp_tac_thms ctxt thms i,*)
	    funsimp_tac_thms thms i,
            rtac mrg_sound i,
	    rec_tac i] @
	   (map tac2 (rev (i upto (i+n-1)))))))
	 ORELSE
	 (* solve for a merge point by projecting on the context, 
	    solving a set-equality subgoal *)
	 (EVERY
	  [rtac conjI i,  (* leaves subgoal of form ?U = X *)
           localsimp_tac_thms ctxt thms i,
	   rtac disjI1 i,
	   localsimp_tac_thms ctxt thms i]))
      in domcall 0 end

  fun if_tac rec_tacTHEN rec_tacELSE i =
    (indent := (!indent)+1 ; all_tac)
    THEN
    print_tac (spaces (!indent) "^IF_TAC: if_tac ...")
    THEN
   EVERY [rtac mrg_if i,
          rec_tacTHEN i,
	  rec_tacELSE i]
    THEN
    print_tac (spaces (!indent) "+if_tac ...")
     THEN
     (indent := (!indent)-1 ; all_tac)

  fun w_tac ctxt thms tac i = 
    EVERY
      [TRY(localsimp_tac_thms ctxt thms i),  (* expand SPEC, methtable *)
       rtac mrg_sound i,
       rtac mrg_weak i,
       tac i,
       fast_tac (claset()) i]

  fun main_stop ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> 
    FIRST [if_tac (stop ctxt thms) (stop ctxt thms) i,
           call_tac ctxt (d_defs@m_defs@f_defs@c_defs) (stop ctxt thms) i,(*HWL: all ?_defs???*)
(*           dom_tac ctxt f_defs (stop ctxt thms) (w_tac ctxt f_defs (stop ctxt thms)) i,*)
           domm_tac ctxt f_defs (stop ctxt thms) (w_tac ctxt f_defs (stop ctxt thms)) i,
           leaf_tac ctxt thms i,
           match_tac ctxt (stop ctxt thms) i,
           let_tac ctxt thms (stop ctxt thms) i]

   (* verbose version of the main tac reporting every tried tactic *)
   fun verbose_main_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> 
    (indent := (!indent)+1 ; all_tac)
    THEN
    FIRST [EVERY[print_tac (spaces (!indent) "^IF_TAC: trying if_tac ..."),
                 if_tac (verbose_main_tac ctxt thms) (verbose_main_tac ctxt thms) i,
                 print_tac "+if"],
           EVERY[print_tac (spaces (!indent) "^CALL_TAC: trying call_tac ..."),
                 call_tac ctxt d_defs (verbose_main_tac ctxt thms) i,
                 print_tac "+call"],
(*           dom_tac ctxt f_defs (verbose_main_tac ctxt thms) (w_tac ctxt f_defs (verbose_main_tac ctxt thms)) i,*)
           EVERY[print_tac (spaces (!indent) "^DOMM_TAC: trying domm_tac ..."),
                 domm_tac ctxt f_defs (verbose_main_tac ctxt thms) (w_tac ctxt f_defs (verbose_main_tac ctxt thms)) i,
                 print_tac "+domm"],
           EVERY[print_tac (spaces (!indent) "^LEAF_TAC: trying leaf_tac ..."),
                 leaf_tac ctxt thms i,
                 print_tac "+leaf"],
           EVERY[print_tac (spaces (!indent) "^MATCH_TAC: trying match_tac ..."),
                 match_tac ctxt (verbose_main_tac ctxt thms) i,
                 print_tac "+match"],
           EVERY[print_tac (spaces (!indent) "^LET_TAC: trying let_tac ..."),
                 let_tac ctxt thms (verbose_main_tac ctxt thms) i,
                 print_tac "+let"]]
     THEN
     (indent := (!indent)-1 ; all_tac)

   fun main_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> 
    (indent := (!indent)+1 ; all_tac)
    THEN
    FIRST [EVERY[if_tac (main_tac ctxt thms) (main_tac ctxt thms) i],
           EVERY[call_tac ctxt d_defs (main_tac ctxt thms) i],
(*           dom_tac ctxt f_defs (main_tac ctxt thms) (w_tac ctxt f_defs (main_tac ctxt thms)) i,*)
           EVERY[domm_tac ctxt f_defs (main_tac ctxt thms) (w_tac ctxt f_defs (main_tac ctxt thms)) i],
           EVERY[leaf_tac ctxt thms i],
           EVERY[match_tac ctxt (main_tac ctxt thms) i],
           EVERY[let_tac ctxt thms (main_tac ctxt thms) i]]
     THEN
     (indent := (!indent)-1 ; all_tac)

*}

(* -------------------- TACTIC *)

method_setup AST_THMS = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (ast_thms thms 1)))*}
  "Method for asm_simp_tac"
method_setup AST_THMS_FAST = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (ast_thms_fast thms 1)))*}
  "Method for asm_simp_tac"
method_setup LEAF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => leaf_tac ctxt ([],thms "meth_defs",[],thms "ctxt_def") 1))*}
  "Method for leaf rules"
method_setup BS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => basicsimpset_tac 1))*}
  "Method for basic simpset"
method_setup BSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => bsf 1))*}
  "Method for basic simpset + fast"
method_setup SB = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => sym_basicsimp 1))*}
  "Method for symmetric basic simpset"
method_setup GT = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_tac ctxt 1))*}
  "Method for GETr"
method_setup GTC = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_clar_tac ctxt 1))*}
  "Method for GETr with clarify"
method_setup GTF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_fast ctxt 1))*}
  "Method for GETr with fast"
method_setup STT = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => simpset_tac_thms thms 1))*}
  "Method for basic simpset"
method_setup LS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac ctxt 1))*}
  "Method for local simpset"
method_setup LSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => lsf ctxt 1))*}
  "Method for local simpset + fast"
method_setup LSTT = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac_thms ctxt thms 1))*}
  "Method for local_simpset_thms"
method_setup LET = {* Method.thms_ctxt_args (fn t => fn ctxt => 
  Method.METHOD (fn facts => let_tac ctxt ([],thms "meth_defs",t,thms "ctxt_def") (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1))*}
  "Method for local_simpset_thms"
method_setup IF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => if_tac (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def"))  (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1)) *}
  "Method for a Conditional"
method_setup CALL = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => call_tac ctxt pdefs (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1)) *}
  "Method for a Call"
method_setup CALLS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => call_stop_tac ctxt pdefs (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1)) *}
  "Method for a Call"
(*
method_setup IF = {* Method.thms_ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => if_tac ctxt ([],thms "meth_defs",t,thms "ctxt_def") (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1))*}
  "Method for Conditionals"
method_setup CALL = {* Method.thms_ctxt_args (fn t => fn ctxt => 
  Method.METHOD (fn facts => call_tac ctxt ([],thms "meth_defs",t,thms "ctxt_def") (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1))*}
  "Method for Calls"
*)
method_setup MATCH = {* Method.thms_ctxt_args (fn t => fn ctxt => 
  Method.METHOD (fn facts => match_tac ctxt (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1))*}
  "Method for matches"
method_setup SBS = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (sym_basicsimp 1)))*}
  "Method for symbasicsimp"
method_setup ASM_LOC = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => 
    asm_simp_tac (Simplifier.get_local_simpset ctxt) 1))*}
"asm_local_simpset"
method_setup MS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => main_stop ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def") 1)) *}
  "main Method with stop continuation, simplification with args" 
method_setup M = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def") 1)) *}
  "main Method: simplification with args" 
 
method_setup W = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac ctxt ((thms "meth_defs")@(thms "fun_defs")@(thms "ctxt_def")) (main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def")) 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast" 
method_setup WS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac ctxt ((thms "meth_defs")@(thms "fun_defs")) (main_stop ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def")) 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast"

method_setup DOMM = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => domm_tac ctxt pdefs (main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def")) (w_tac ctxt (thms "meth_defs") (main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def"))) 1)) *}
  "parametric Method for DOMM"

method_setup DOMS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => domm_tac ctxt pdefs (stop ctxt []) (stop ctxt []) 1)) *}
  "parametric Method for DOMM; 1-step"


end
