(*<*)
theory UA1 =  GA13 + NILList:
(*>*)

(* The lemma below should be somewhere before !!!*)

lemma same_heaps: "h=hh \<Longrightarrow> \<forall> l. sameOH {l} h hh"
apply (simp add: sameOH_def)
done


subsection {* Definition of derived assertions*}

subsubsection {* Types, contexts, regions, size of contexts*}



datatype Type = UnitET | IntET | ListET nat


(*>*)
text {*Region calculation*}
consts reg_ua :: "(val \<times> heap \<times> (Type option) \<times> bool \<times> (locn set)) set"
inductive reg_ua intros
regInt_ua:   "(IVal i ,h,Some IntET, p, {}): reg_ua"
regUnit_ua:   "(v,h,Some UnitET, p, {}): reg_ua"
regListNull_ua:  "(RVal Nullref, h, Some(ListET k), p, {}) : reg_ua"
regListCons_ua: "\<lbrakk>h@@a = Some DIAM;
                h<a\<bullet>DOLLAR> \<noteq> 2;
                a \<notin> R1\<union>R2 ; 
                (IVal h<a\<bullet>F0>, h, Some IntET, p, R1) : reg_ua;
                (RVal h\<lfloor>a\<diamondsuit>F1\<rfloor>, h,  Some(ListET k), p, R2) : reg_ua;
                p \<longrightarrow> R1\<inter>R2={}\<rbrakk> \<Longrightarrow> 
                (RVal (Ref a), h, Some(ListET k), p, {a}\<union>R1\<union>R2): reg_ua"



lemma region_ua_in_heap: "(v, h, T, p, R): reg_ua \<Longrightarrow> R \<subseteq> Dom h"
apply (erule reg_ua.induct)
apply simp+
apply (simp add: fmap_lookup_def fmap_dom_def)
apply best
done


lemma reg_ua_Preserved [rule_format]:
"(v,h,T, p, R):reg_ua \<Longrightarrow> 
  ((\<forall> l. l : R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (v,h1,T, p, R):reg_ua)"
apply (erule reg_ua.induct)
apply (rule impI) apply (rule regInt_ua) 
apply (rule impI) apply (rule regUnit_ua) 
apply (rule impI) apply (rule regListNull_ua)
apply (rule impI) apply (rule regListCons_ua)
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply assumption
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply assumption
done

lemma reg_ua_sameHeap:
"\<lbrakk>(v,h,T, p, R):reg_ua; sameOH R h h1\<rbrakk> \<Longrightarrow> (v,h1,T, p, R):reg_ua"
apply (rule reg_ua_Preserved)
apply assumption
apply (simp add: sameOH_def)
done

lemma reg_ua_sameHeapRegSubset:
"\<lbrakk>(v,h,T, p, R):reg_ua; sameOH R1 h h1; R \<subseteq> R1\<rbrakk> \<Longrightarrow> (v,h1,T, p, R):reg_ua"
apply (rule reg_ua_sameHeap)
apply assumption
apply (simp add: sameOH_def, fast)
done


lemma reg_ua_Int: "(Ival i, h, Some IntET, p, R): reg_ua \<Longrightarrow> R={} "
apply (erule reg_ua.cases)
apply clarify+
done

lemma reg_ua_Unit: "(v, h, Some UnitET, p, R): reg_ua \<Longrightarrow> R={}"
apply (erule reg_ua.cases)
apply clarify+
done

lemma reg_ua_Null: "(RVal Nullref, h, Some (ListET k), p, R): reg_ua \<Longrightarrow> R={}"
apply (erule reg_ua.cases)
apply clarify+
done


lemma reg_ua_Cons:
"(RVal (Ref a), h, Some (ListET k), p, R): reg_ua \<Longrightarrow>
                h@@a = Some DIAM \<and>
                h<a\<bullet>DOLLAR> \<noteq> 2 \<and>
 (\<exists> R1 R2. 
                (a \<notin> R1\<union>R2) \<and>
                ((IVal h<a\<bullet>F0>, h, Some IntET, p, R1) : reg_ua) \<and>
                ((RVal h\<lfloor>a\<diamondsuit>F1\<rfloor>, h,  Some(ListET k), p, R2) : reg_ua) \<and>
                (p \<longrightarrow> R1\<inter>R2={}) \<and>
                R={a}\<union>R1\<union>R2 )"
apply (erule reg_ua.cases)
apply clarify apply clarify apply clarify
apply (rule conjI) apply clarify
apply (rule conjI) apply clarify
apply (rule exI)+
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply clarify
apply clarify
done


lemma reg_ua_Unique[rule_format]: 
"(v, h, T, p, R) : reg_ua \<Longrightarrow> ( \<forall> RR. (v, h, T, p, RR) : reg_ua \<longrightarrow> R=RR)"
apply (erule reg_ua.induct)

apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Int) apply simp
apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Unit )apply simp
apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Null )apply simp

apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Cons)
apply (erule conjE)+
apply (erule exE)+
apply (erule conjE)+
apply (rename_tac R1' R2')
apply (drule_tac x="R1'" in spec) 
apply (drule_tac x="R2'" in spec) 
apply safe
done



lemma reg_ua_WeakFalse:
"(v, h, T, p, R) : reg_ua  \<Longrightarrow> (v, h, T, False, R) : reg_ua"
apply (erule reg_ua.induct)
apply (rule regInt_ua)
apply (rule regUnit_ua)
apply (rule regListNull_ua)
apply (rule regListCons_ua)
apply assumption
apply assumption
apply assumption
apply assumption
apply assumption
apply clarify
done

lemma reg_ua_WeakTrue:
"(v, h, T, True, R) : reg_ua  \<Longrightarrow> (v, h, T, p, R) : reg_ua"
apply (case_tac "p=True")
apply clarify
apply (subgoal_tac "p=False")
apply clarify
apply (rule reg_ua_WeakFalse)
apply assumption
apply simp
done


lemma reg_ua_notated [rule_format]:
 "(v, h, T, p, R1) : reg_ua \<Longrightarrow>
\<forall> r R2.  T=Some (ListET k1)  \<longrightarrow> v=RVal r \<longrightarrow>
   (v, h, Some (ListET k2) , p, R2) : reg_ua \<longrightarrow> R1=R2"
apply (erule reg_ua.induct)
apply clarify+

apply (drule reg_ua_Null)
apply simp

apply (rule allI)+
apply (rule impI)+
apply (rename_tac R)
apply (rotate_tac 10)
apply (erule reg_ua.cases)
apply clarify apply clarify apply clarify
apply clarsimp
apply (rename_tac R21 R22 a h p)

apply (erule_tac x=R22 in allE)
apply (rotate_tac 11)
apply (drule mp)
apply assumption

apply (drule reg_ua_Int)
apply (drule reg_ua_Int)
apply simp
done

text{*Contexts*}
types Context = "(rname \<leadsto>\<^sub>f Type)"

constdefs DOM:: "Context \<Rightarrow> rname set"
"DOM == fmap_dom"

constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Type option)"
"GETr G x \<equiv> fmap_lookup G x"

lemma DOM_Update: "{x} \<union> (DOM b) = DOM (b(x\<mapsto>\<^sub>fk))" by (simp add: DOM_def)

lemma GETrNDomNone: "x \<notin> DOM C \<Longrightarrow> None = GETr C x"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GETrSomeDom: "GETr C x = Some T \<Longrightarrow> x \<in>  DOM C"
apply (insert  GETrNDomNone)
apply fastsimp
done

lemma GETrNoneNDom: "GETr C x = None \<Longrightarrow> x \<notin> DOM C"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)


lemma GETrSome_DOM:"GETr G x = Some T \<Longrightarrow> x \<in> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)


lemma reg_DOM: "(v, h, GETr G x, p, R) : reg_ua \<Longrightarrow> x \<in> DOM G"
apply (erule reg_ua.cases)
apply (simp add:  GETrSome_DOM)
apply (simp add:  GETrSome_DOM)
apply (simp add:  GETrSome_DOM)
apply (simp add:  GETrSome_DOM)
done


text{*Size of contexts, i.e. the region inhabited, and the number
      of freelist-cells owned by a context.*}


consts CR::"(env \<times> heap \<times> bool \<times> (rname set) \<times> Context \<times> nat \<times> (locn set)) set"
inductive CR intros
CR_empty: "(E,h,p, {}, C, i, {}) : CR"
CR_1: "\<lbrakk>x \<in> U; 
        (E, h, p, U-{x}, C, 1, R1):CR;
        (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R2): reg_ua; 
         R1 \<inter> R2 = {}\<rbrakk>
        \<Longrightarrow> (E,h, p, U, C, 1, R1 \<union> R2) : CR"

CR_2: "\<lbrakk> x \<in> U;
        (E,h, p, U-{x}, C, 2, R1):CR;
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p, R2): reg_ua;
        p \<longrightarrow> R1 \<inter> R2 = {}\<rbrakk>
        \<Longrightarrow> (E,h, p, U, C, 2, R1 \<union> R2) : CR"

CR_3: "\<lbrakk>x \<in> U; 
       (E,h, p, U-{x}, C, 3, R1):CR;
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, False, R2): reg_ua\<rbrakk>
        \<Longrightarrow> (E,h, p, U, C, 3, R1 \<union> R2) : CR"

lemma CR_emptyU:"(E,h,p, {}, C, i, R) : CR \<Longrightarrow> R={}"
apply (erule CR.cases)
apply clarify+
done

lemma CR_1_reverse [rule_format]:
"(E,h, p, U, C, i, R) : CR \<Longrightarrow> 
i=1 \<longrightarrow> 
(\<forall> x. x \<in>  U \<longrightarrow> (\<exists> R1 R2.   
(E,h, p, U-{x}, C, i, R1):CR \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R2): reg_ua \<and>
R1 \<inter> R2 = {} \<and>
R = R1 \<union> R2))"
apply (erule CR.induct)
apply clarify

apply (rule impI)
apply (rule allI) apply (rule impI)
apply (drule mp)
apply simp
apply (rename_tac x')
apply (case_tac "x=x'")
apply (rule_tac x=R1 in exI)
apply (rule_tac x=R2 in exI)
apply simp

apply (erule_tac x=x' in allE)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rename_tac R1' R2') 
apply (rule_tac x= "R1' \<union> R2" in exI)
apply (rule_tac x= "R2'" in exI)
apply (rule conjI)

apply (rule_tac x="x" and U="U - {x'}" in CR_1)
apply fast
apply (subgoal_tac "U-{x'}-{x}=U-{x}-{x'}")
apply simp
apply fast
apply assumption
apply fast

apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply fast

apply simp
apply simp
done


lemma CR_2_reverse [rule_format]:
"(E,h, p, U, C, i, R) : CR \<Longrightarrow> 
i=2 \<longrightarrow> 
(\<forall> x. x \<in>  U \<longrightarrow> (\<exists> R1 R2.   
(E,h, p, U-{x}, C, i, R1):CR \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p, R2): reg_ua \<and>
(p \<longrightarrow> R1 \<inter> R2 = {}) \<and>
R = R1 \<union> R2))"
apply (erule CR.induct)
apply clarify
apply simp

apply (rule impI)
apply (rule allI) apply (rule impI)
apply (drule mp)
apply simp
apply (rename_tac x')
apply (case_tac "x=x'")
apply (rule_tac x=R1 in exI)
apply (rule_tac x=R2 in exI)
apply simp

apply (erule_tac x=x' in allE)
apply (rotate_tac 7)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rename_tac R1' R2') 
apply (rule_tac x= "R1' \<union> R2" in exI)
apply (rule_tac x= "R2'" in exI)
apply (rule conjI)

apply (rule_tac x="x" and U="U - {x'}" in CR_2)
apply fast
apply (subgoal_tac "U-{x'}-{x}=U-{x}-{x'}")
apply simp
apply fast
apply assumption
apply fast

apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply fast
apply simp
done

lemma CR_3_reverse [rule_format]:
"(E,h, p, U, C, i, R) : CR \<Longrightarrow> 
i=3 \<longrightarrow> 
(\<forall> x. x \<in>  U \<longrightarrow> (\<exists> R1 R2.   
(E,h, p, U-{x}, C, i, R1):CR \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, False, R2): reg_ua \<and>
R = R1 \<union> R2))"
apply (erule CR.induct)
apply clarify
apply simp
apply simp

apply (rule impI)
apply (rule allI) apply (rule impI)
apply (drule mp)
apply simp
apply (rename_tac x')
apply (case_tac "x=x'")
apply (rule_tac x=R1 in exI)
apply (rule_tac x=R2 in exI)
apply simp

apply (erule_tac x=x' in allE)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rename_tac R1' R2') 
apply (rule_tac x= "R1' \<union> R2" in exI)
apply (rule_tac x= "R2'" in exI)
apply (rule conjI)

apply (rule_tac x="x" and U="U - {x'}" in CR_3)
apply fast
apply (subgoal_tac "U-{x'}-{x}=U-{x}-{x'}")
apply simp
apply fast
apply assumption

apply (rule conjI)
apply assumption
apply fast
done

lemma CR_reverse:
"\<lbrakk>(E,h, p, U, C, i, R) : CR; x\<in> U \<rbrakk> \<Longrightarrow> 
\<exists> R1 R2 p'.   
((E,h, p, U-{x}, C, i, R1):CR \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p', R2): reg_ua \<and>
R = R1 \<union> R2 )"
apply (case_tac "i=1")
apply (drule CR_1_reverse) apply assumption apply assumption 
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x=R1 in exI) 
apply (rule_tac x=R2 in exI) 
apply (rule_tac x=True in exI) 
apply fast
apply (case_tac "i=2")
apply (drule CR_2_reverse) apply assumption apply assumption 
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x=R1 in exI) 
apply (rule_tac x=R2 in exI)
apply fast
apply (case_tac "i=3")
apply (drule CR_3_reverse) apply assumption apply assumption 
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x=R1 in exI) 
apply (rule_tac x=R2 in exI) 
apply (rule_tac x=False in exI)
apply fast
apply (erule CR.cases)
apply clarsimp
apply simp+
done


lemma CR_preserved [rule_format]:
"(E,h, p, U, C, i, R) : CR \<Longrightarrow>
(\<forall> l. l\<in> R \<longrightarrow> sameOH {l} h h') \<longrightarrow>
(E, h', p, U, C, i, R) : CR"
apply (erule CR.induct)
apply clarsimp apply (rule CR_empty)

apply (rule impI)
apply (drule mp) 
apply clarsimp
apply (rule CR_1)
apply assumption
apply assumption
apply (rule reg_ua_Preserved)
apply assumption
apply simp
apply clarify

apply (rule impI)
apply (drule mp) 
apply clarsimp
apply (rule CR_2)
apply assumption
apply assumption
apply (rule reg_ua_Preserved)
apply assumption
apply simp
apply assumption

apply (rule impI)
apply (drule mp) 
apply clarsimp
apply (rule CR_3)
apply assumption
apply assumption
apply (rule reg_ua_Preserved)
apply assumption
apply simp
done

lemma CR_sameHeap:
"\<lbrakk> (E,h, p, U, C, i, R) : CR; sameOH R h h'\<rbrakk> \<Longrightarrow>
(E, h', p, U, C, i, R) : CR"
apply (rule CR_preserved)
apply assumption
apply (simp add: sameOH_def)
done

lemma CR_sameHeapRegSubset:
"\<lbrakk> (E,h, p, U, C, i, R) : CR; R\<subseteq>R1; sameOH R1 h h'\<rbrakk> \<Longrightarrow>
(E, h', p, U, C, i, R) : CR"
apply (rule CR_preserved)
apply assumption
apply (simp only: sameOH_def)
apply fast
done

lemma CR_1_unique [rule_format]:
"(E,h, p, U, C, i, R) : CR \<Longrightarrow> i=1 \<longrightarrow>
(\<forall> R'. (E, h, p, U, C, i, R') : CR \<longrightarrow> R'=R)"
apply (erule CR.induct)
apply clarify apply (rule CR_emptyU) apply assumption

apply (rule impI)
apply (rule allI)+ apply (rule impI)
apply (drule mp)
apply simp
apply (rotate_tac 5)
apply (erule  CR.cases)
apply clarify

apply clarify
apply (rename_tac CC EE RR1 RR2 UU hh pp xx)

apply (case_tac "x=xx")
apply (erule_tac x=RR1 in allE)
apply (drule mp)
apply simp
apply (drule reg_ua_Unique)
apply simp
apply clarify 

apply (drule_tac x=x and U="UU-{xx}" in CR_1_reverse)
apply clarify
apply fast
apply (erule exE)+
apply (rename_tac R1' R2')
apply (erule conjE)+
apply (subgoal_tac "xx \<in> UU-{x}")
apply (drule_tac x=xx and U="UU-{x}"in CR_1)
apply (subgoal_tac "UU-{x}-{xx}=UU-{xx}-{x}")
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply simp
apply fast
apply assumption
apply fast

apply (erule_tac x="R1' \<union> RR2" in allE)
apply (drule mp)
apply assumption

apply (drule_tac  v="RVal (renv EE x)" in reg_ua_Unique)
apply assumption
apply fastsimp
apply fast

apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)
apply simp

apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)
apply simp

apply simp apply simp
done

lemma CR_2_unique [rule_format]:
"(E,h, p, U, C, i, R) : CR \<Longrightarrow> i=2 \<longrightarrow>
(\<forall> R'. (E, h, p, U, C, i, R') : CR \<longrightarrow> R'=R)"
apply (erule CR.induct)
apply clarify apply (rule CR_emptyU) apply assumption
apply simp

apply (rule impI)
apply (rule allI)+ apply (rule impI)
apply (drule mp)
apply simp
apply (rotate_tac 5)
apply (erule  CR.cases)
apply clarify
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)  
apply simp

apply clarify
apply (rename_tac CC EE RR1 RR2 UU hh pp xx)

apply (case_tac "x=xx")
apply (erule_tac x=RR1 in allE)
apply (rotate_tac 9)
apply (drule mp)
apply simp
apply (drule reg_ua_Unique)
apply simp
apply clarify

apply (drule_tac x=x and U="UU-{xx}" in CR_2_reverse)
apply clarify
apply fast
apply (erule exE)+
apply (rename_tac R1' R2')
apply (erule conjE)+
(* add xx to U-{xx}-{x} to get U-{x} *)
apply (subgoal_tac "xx \<in> UU-{x}")
apply (drule_tac x=xx and U="UU-{x}"in CR_2)
apply (subgoal_tac "UU-{x}-{xx}=UU-{xx}-{x}")
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) 
apply simp
apply fast
apply assumption
apply fast

apply (erule_tac x="R1' \<union> RR2" in allE)
apply (rotate_tac 12)
apply (drule mp)
apply assumption

apply (drule_tac  v="RVal (renv EE x)" in reg_ua_Unique)
apply assumption
apply (rotate_tac 1)
apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl) apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply fastsimp
apply fast

apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)
apply simp

apply (erule thin_rl)apply (erule thin_rl) apply (erule thin_rl) 
apply simp
done

lemma CR_3_unique [rule_format]:
"(E,h, p, U, C, i, R) : CR \<Longrightarrow> i=3 \<longrightarrow>
(\<forall> R'. (E, h, p, U, C, i, R') : CR \<longrightarrow> R'=R )"
apply (erule CR.induct)
apply clarify apply (rule CR_emptyU) apply assumption
apply simp apply simp


apply (rule impI)
apply (rule allI)+ apply (rule impI)
apply (drule mp)
apply simp
apply (rotate_tac 4)
apply (erule  CR.cases)
apply clarify
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) 
apply simp

apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) 
apply simp

apply clarify
apply (rename_tac CC EE RR1 RR2 UU hh pp xx)

apply (case_tac "x=xx")
apply (erule_tac x=RR1 in allE)
apply (drule mp)
apply simp
apply (drule reg_ua_Unique)
apply simp
apply clarify 

apply (drule_tac x=x and U="UU-{xx}" in CR_3_reverse)
apply clarify
apply fast
apply (erule exE)+
apply (rename_tac R1' R2')
apply (erule conjE)+
(* add xx to U-{xx}-{x} to get U-{x} *)
apply (subgoal_tac "xx \<in> UU-{x}")
apply (drule_tac x=xx and U="UU-{x}"in CR_3)
apply (subgoal_tac "UU-{x}-{xx}=UU-{xx}-{x}")
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) 
apply simp
apply fast
apply assumption

apply (erule_tac x="R1' \<union> RR2" in allE)
apply (drule mp)
apply assumption

apply (drule_tac  v="RVal (renv EE x)" in reg_ua_Unique)
apply assumption
apply fastsimp
apply fast
done


lemma CR_uniqueReg:
"\<lbrakk>(E,h, p, U, C, i, R) : CR; (E, h, p, U, C, i, R'): CR\<rbrakk>   \<Longrightarrow> R'=R"
apply (case_tac "i=1")
apply (drule CR_1_unique) apply assumption  apply assumption 
apply simp
apply (case_tac "i=2")
apply (drule CR_2_unique) apply assumption  apply assumption 
apply simp
apply (case_tac "i=3")
apply (drule CR_3_unique) apply assumption  apply assumption 
apply simp
apply (erule CR.cases)
apply clarsimp
apply (drule CR_emptyU) apply simp
apply simp+
done



lemma CR_Ufinite:
"(E,h, p, U, C, i, R) : CR \<Longrightarrow> finite U"
apply (erule CR.induct)
apply simp+
done

lemma CR_union_aux [rule_format]:
"finite U'\<Longrightarrow> \<forall> E h p U C i R R' .
(E,h, p, U, C, i, R) : CR \<longrightarrow> (E, h, p, U\<union>U', C, i, R'): CR \<longrightarrow> U \<inter> U' ={} \<longrightarrow>  
R\<subseteq>R'"
apply (induct set: Finites)

apply clarsimp 
apply (frule CR_uniqueReg) apply (rotate_tac 1) apply assumption 
apply simp

apply (rule allI)+
apply (rule impI)+

apply (case_tac "i=1")
apply (drule_tac x=x and U="U \<union> insert x F" in CR_1_reverse)
apply assumption
apply simp

apply (erule exE)+
apply (erule conjE)+

apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x=U in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=1 in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=R1 in allE)

apply simp
apply (erule conjE)+
apply fastsimp

apply (case_tac "i=2")
apply (drule_tac x=x and U="U \<union> insert x F" in CR_2_reverse)
apply assumption
apply simp

apply (erule exE)+
apply (erule conjE)+

apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x=U in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=2 in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=R1 in allE)

apply simp
apply (erule conjE)+
apply fastsimp

apply (case_tac "i=3")
apply (drule_tac x=x and U="U \<union> insert x F" in CR_3_reverse)
apply assumption
apply simp

apply (erule exE)+
apply (erule conjE)+

apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x=U in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=3 in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=R1 in allE)

apply simp
apply (erule conjE)+
apply fastsimp

apply (rotate_tac 4)
apply (erule CR.cases)
apply clarsimp
apply simp+
done

lemma CR_union:
"\<lbrakk>(E,h, p, U, C, i, R) : CR; (E, h, p, U\<union>U', C, i, R'): CR; U \<inter> U' ={}\<rbrakk> \<Longrightarrow> 
R\<subseteq>R'"
apply (rule_tac U'=U' in CR_union_aux)
apply (drule_tac U="U \<union> U'" in CR_Ufinite)
apply simp
apply assumption
apply assumption
apply assumption
done

lemma CR_2_union_detail [rule_format]:
"(E,h, p, U, C, i, R) : CR \<Longrightarrow> 
p=False \<longrightarrow> i=2 \<longrightarrow> 
(\<forall> U' R'. (E, h, False, U', C, 2, R'): CR \<longrightarrow>
U \<inter> U' ={} \<longrightarrow>
(E, h, p, U \<union> U', C, 2, R\<union> R'): CR)"
apply (erule CR.induct)
apply (rule impI)+
apply (rule allI)+
apply (rule impI)+ 
apply simp

apply (rule impI)+
apply (rule allI)+
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply simp

apply (rule impI)+
apply (rule allI)+
apply (rule impI)+
apply (drule mp) apply assumption
apply (rotate_tac 4)
apply (drule mp) apply assumption 
apply (erule_tac x=U' in allE)
apply (erule_tac x=R' in allE)
apply (rotate_tac 8)
apply (drule mp) apply assumption
apply (rotate_tac 8)
apply (drule mp) apply fast
apply (subgoal_tac "x\<in>U \<union> U'") 
apply (drule_tac x=x and U="U \<union> U'" in CR_2)
apply (subgoal_tac "U - {x} \<union> U'= U \<union> U' - {x}") 
apply simp
apply fast
apply assumption
apply fast 
apply (subgoal_tac "R1 \<union> R' \<union> R2=R1 \<union> R2 \<union> R'")
apply simp
apply simp
apply fast 
apply fast

apply (rule impI)+
apply (rule allI)+
apply (rule impI)+
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl)
apply simp
done


lemma CR_3_union_detail [rule_format]:
"(E,h, p, U, C, i, R) : CR \<Longrightarrow> 
i=3 \<longrightarrow> 
(\<forall> U' R'. (E, h, p, U', C, 3, R'): CR \<longrightarrow>
U \<inter> U' ={} \<longrightarrow>
(E, h, p, U \<union> U', C, 3, R\<union> R'): CR)"
apply (erule CR.induct)
apply (rule impI)
apply (rule allI)+
apply (rule impI)+ 
apply simp

apply (rule impI)+
apply (rule allI)+
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply simp

apply (rule impI)+
apply (rule allI)+
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply simp

apply (rule impI)+
apply (rule allI)+
apply (rule impI)+
apply (drule mp) apply assumption
apply (erule_tac x=U' in allE)
apply (erule_tac x=R' in allE)
apply (drule mp) apply assumption
apply (drule mp) apply fast
apply (subgoal_tac "x\<in>U \<union> U'") 
apply (drule_tac x=x and U="U \<union> U'" in CR_3)
apply (subgoal_tac "U - {x} \<union> U'= U \<union> U' - {x}") 
apply simp
apply fast
apply assumption
apply (subgoal_tac "R1 \<union> R' \<union> R2=R1 \<union> R2 \<union> R'")
apply simp
apply simp
apply fast 
apply fast
done


lemma CR_union_detail [rule_format]:
"(E,h, p, U, C, i, R) : CR \<Longrightarrow> 
\<forall> U' R'. (E, h, p, U', C, i, R'): CR \<longrightarrow>
R \<inter> R' ={} \<longrightarrow>  U \<inter> U' ={} \<longrightarrow>
(E, h, p, U \<union> U', C, i, R\<union> R'): CR"
apply (erule CR.induct)

apply clarsimp

apply (rule allI)+
apply (rule impI)+
apply (erule_tac x=U' in allE)
apply (erule_tac x=R' in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (subgoal_tac "x\<in>U \<union> U'") 
apply (drule_tac x=x and U="U \<union> U'" in CR_1)
apply (subgoal_tac "U - {x} \<union> U'= U \<union> U' - {x}") 
apply simp
apply fast
apply assumption
apply fast 
apply (subgoal_tac "R1 \<union> R' \<union> R2=R1 \<union> R2 \<union> R'")
apply simp
apply simp
apply fast 
apply fast

apply (rule allI)+
apply (rule impI)+
apply (erule_tac x=U' in allE)
apply (erule_tac x=R' in allE)
apply (rotate_tac 7)
apply (drule mp)
apply assumption
apply (rotate_tac 7)
apply (drule mp)
apply fast
apply (rotate_tac 7)
apply (drule mp)
apply fast
apply (subgoal_tac "x\<in>U \<union> U'") 
apply (drule_tac x=x and U="U \<union> U'" in CR_2)
apply (subgoal_tac "U - {x} \<union> U'= U \<union> U' - {x}") 
apply simp
apply fast
apply assumption
apply fast 
apply (subgoal_tac "R1 \<union> R' \<union> R2=R1 \<union> R2 \<union> R'")
apply simp
apply fast 
apply fast

apply (rule allI)+
apply (rule impI)+
apply (erule_tac x=U' in allE)
apply (erule_tac x=R' in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply fast
apply (drule mp)
apply fast
apply (subgoal_tac "x\<in>U \<union> U'") 
apply (drule_tac x=x and U="U \<union> U'" in CR_3)
apply (subgoal_tac "U - {x} \<union> U'= U \<union> U' - {x}") 
apply simp
apply fast
apply assumption
apply (subgoal_tac "R1 \<union> R' \<union> R2=R1 \<union> R2 \<union> R'")
apply simp
apply fast 
apply fast
done


lemma CR_monot:
"\<lbrakk> (E,h, p, U, C, i, R) : CR;   (E, h, p, U', C, i, R'): CR ; U\<subseteq> U'\<rbrakk> \<Longrightarrow>
R\<subseteq>R'"
apply (rule_tac U'="U'- U" in CR_union)
apply assumption
apply (subgoal_tac "U'=U \<union> (U' - U)")
apply simp
apply fastsimp
apply fastsimp
done



lemma CR_subset_aux [rule_format]:
"finite U' \<Longrightarrow> 
\<forall> E h p U C i R. U'\<subseteq> U \<longrightarrow> (E,h, p, U, C, i, R) : CR \<longrightarrow> 
(\<exists> R'. (E, h, p, U-U', C, i, R'): CR)" 
apply (induct set: Finites)
apply clarsimp

apply (rule allI)+
apply (rule impI)+

apply (drule_tac x=x and U=U in CR_reverse)
apply simp
apply (erule exE)+
apply (erule conjE)+
apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=p in allE)
apply (erule_tac x="U-{x}" in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=i in allE)
apply (erule_tac x=R1 in allE)
apply (subgoal_tac "F \<subseteq> U - {x}")
apply (drule mp)
apply assumption
apply (drule mp)
apply assumption
apply clarsimp
apply (subgoal_tac  "U - {x} - F=U - insert x F")
apply fastsimp
apply fast
apply fast
done

lemma subset_fin [rule_format]:
"finite U \<Longrightarrow> \<forall>  U'. U'\<subseteq> U \<longrightarrow> finite U'"
apply (induct set: Finites)
apply simp
apply (rule allI)
apply (rule impI)
apply (erule_tac x="U'-{x}" in allE)
apply (drule mp)
apply fast
apply simp
done

lemma CR_subset_minus [rule_format]:
"\<lbrakk>(E,h, p, U, C, i, R) : CR; U'\<subseteq> U\<rbrakk>  \<Longrightarrow>
(\<exists> R'. (E, h, p, U-U', C, i, R'): CR)"
apply (rule CR_subset_aux) 
apply (drule CR_Ufinite)
apply (rule_tac U=U in subset_fin)
apply assumption apply assumption
apply assumption apply assumption
done

lemma CR_subset [rule_format]:
"\<lbrakk>(E,h, p, U, C, i, R) : CR; U'\<subseteq> U\<rbrakk>  \<Longrightarrow>
(\<exists> R'. (E, h, p, U', C, i, R'): CR)"
apply (drule_tac U'="U-U'" in CR_subset_minus) 
apply fast
apply (subgoal_tac  "U - (U - U')=U'")
apply simp
apply fast
done

lemma CR_1_EquivTrueFalse [rule_format]:
"(E,h,  p, U, G, i, R):CR
 \<Longrightarrow> i=1 \<longrightarrow> (\<forall> p'. (E,h, p', U, G, i, R):CR)"
apply (erule CR.induct)
apply clarify apply (rule CR_empty)

apply clarify 

apply (rule CR_1)
apply assumption
apply (drule mp)
apply simp
apply (erule_tac x=p' in allE)
apply assumption
apply assumption
apply assumption
apply simp+
done

lemma CR_3_EquivTrueFalse [rule_format]:
"(E,h,  p, U, G, i, R):CR
 \<Longrightarrow> i=3 \<longrightarrow> (\<forall> p'. (E,h, p', U, G, i, R):CR)"
apply (erule CR.induct)
apply clarify apply (rule CR_empty)
apply simp
apply simp 

apply clarify
apply (rule CR_3)
apply assumption
apply (drule mp)
apply simp
apply (erule_tac x=p' in allE)
apply assumption
apply assumption
done

lemma CR_2_TrueFalse [rule_format]:
"(E,h,  p, U, G, i, R):CR \<Longrightarrow>
i=(2::nat) \<longrightarrow> p=True \<longrightarrow> (E,h, False, U, G, i, R):CR"
apply (erule CR.induct) 
apply clarify
apply (rule CR_empty)
apply simp
apply (rule impI)+
apply (rule CR_2)
apply assumption
apply (drule mp)
apply simp
apply (rotate_tac 6)
apply (drule mp)
apply assumption
apply assumption
apply (rule reg_ua_WeakFalse)
apply assumption
apply clarify
apply simp
done

lemma CR_UDOM [rule_format]: 
"(E,h, p, U, G, i, R):CR \<Longrightarrow> U\<subseteq> DOM G"
apply (erule CR.induct)
apply fast
apply (drule reg_DOM) apply fast
apply (drule reg_DOM) apply fast
apply (drule reg_DOM) apply fast
done

(******************)

lemma coherent_CR [rule_format]: 
"(E,h, p, U, G, i, R):CR \<Longrightarrow> 
\<forall> G' R'.  
(\<forall> x. x\<in>U \<longrightarrow> 
(\<exists> k k'. GETr G x = Some (ListET k) \<and>  GETr G' x = Some (ListET k')))
\<longrightarrow>
(E,h, p, U, G', i, R'):CR \<longrightarrow> R=R'"
apply (erule CR.induct)
apply (rule allI)+
apply (rule impI)+
apply (drule CR_emptyU)
apply clarify

apply (rule allI)+
apply (rule impI)+
apply (rotate_tac 6)
apply (drule_tac x=x in CR_1_reverse)
apply simp
apply assumption
apply (erule exE)+ apply (erule conjE)+ 
apply (rename_tac R1' R2)
apply (erule_tac x=G' in allE)
apply (rotate_tac 10)
apply (erule_tac x=R1' in allE)
apply (rotate_tac 10)
apply (drule mp)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl)
apply fast

apply (drule mp)
apply  assumption

apply (erule_tac x=x in allE)
apply (drule mp)
apply  assumption
apply (erule exE)+ apply (erule conjE)+
apply simp
apply (drule reg_ua_notated)
apply simp
apply simp
apply  assumption
apply simp

(*********************)

apply (rule allI)+
apply (rule impI)+
apply (rotate_tac 6)
apply (drule_tac x=x in CR_2_reverse)
apply simp
apply assumption
apply (erule exE)+ apply (erule conjE)+ 
apply (rename_tac R1' R2')
apply (erule_tac x=G' in allE)
apply (rotate_tac 9)
apply (erule_tac x=R1' in allE)
apply (rotate_tac 9)
apply (drule_tac mp)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl)
apply fast
apply (rotate_tac 9)
apply (drule mp)
apply  assumption

apply (erule_tac x=x in allE)
apply (rotate_tac 9)
apply (drule mp)
apply  assumption
apply (erule exE)+ apply (erule conjE)+
apply simp
apply (drule reg_ua_notated)
apply simp
apply simp
apply  assumption
apply simp

(*********************)

apply (rule allI)+
apply (rule impI)+
apply (rotate_tac 5)
apply (drule_tac x=x in CR_3_reverse)
apply simp
apply assumption
apply (erule exE)+ apply (erule conjE)+ 
apply (rename_tac R1' R2')
apply (erule_tac x=G' in allE)
apply (rotate_tac 7)
apply (erule_tac x=R1' in allE)
apply (rotate_tac 7)
apply (drule mp)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply fast

apply (drule mp)
apply  assumption

apply (erule_tac x=x in allE)
apply (drule mp)
apply  assumption
apply (erule exE)+ apply (erule conjE)+
apply simp
apply (drule_tac T="Some (ListET k)" in reg_ua_notated)
apply simp
apply simp
apply  assumption
apply simp
done

lemma rise_CS [rule_format]:
"(E,h, p, U, G, i, R):CR 
\<Longrightarrow> \<forall> j. i\<le>j \<and> j \<le> 3 \<longrightarrow> (E,h, p, U, G, j, R):CR"
apply (erule CR.induct)

apply (rule allI)
apply (rule impI)
apply (rule CR_empty)

apply (rule allI)
apply (rule impI)

apply (case_tac "j=1") 
apply (drule CR_1)
apply assumption
apply assumption
apply assumption
apply simp

apply (case_tac "j=2") 
apply (erule_tac x=2 in allE)
apply (drule mp)
apply simp
apply (drule_tac x=x in CR_2)
apply assumption
apply (drule_tac p=p in reg_ua_WeakTrue)
apply assumption
apply clarify
apply simp

apply (case_tac "j=3") 
apply (erule_tac x=3 in allE)
apply (drule mp)
apply simp
apply (drule_tac x=x in CR_3)
apply assumption
apply (drule_tac p=False in reg_ua_WeakTrue)
apply assumption
apply simp
apply (erule conjE)
apply simp

apply (rule allI)
apply (rule impI)

apply (case_tac "j=2") 
apply (erule_tac x=2 in allE)
apply (rotate_tac 6)
apply (drule mp)
apply simp
apply (drule_tac x=x in CR_2)
apply assumption
apply assumption
apply clarify
apply simp

apply (case_tac "j=3") 
apply (erule_tac x=3 in allE)
apply (rotate_tac 6)
apply (drule mp)
apply simp
apply (drule_tac x=x in CR_3)
apply assumption
apply (drule reg_ua_WeakFalse)
apply assumption
apply simp
apply (erule conjE)
apply simp

apply (rule allI)
apply (rule impI)

apply (case_tac "j=3") 
apply (erule_tac x=3 in allE)
apply (drule mp)
apply simp
apply (drule_tac x=x in CR_3)
apply assumption
apply assumption
apply simp
apply (erule conjE)
apply simp
done



(********************************************************)


subsubsection {*The heap assertion*}
constdefs freelist::"heap \<Rightarrow> locn set \<Rightarrow> bool"
"freelist h F == \<exists> N. (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) : FL"

constdefs modify::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"modify R h hh == \<forall> l . (l: Dom h - R \<longrightarrow> sameOH {l} h hh)"


lemma modify_monot:
"\<lbrakk>modify M h hh; M\<subseteq>M'\<rbrakk> \<Longrightarrow> modify M' h hh"
apply (unfold modify_def)
apply (rule allI)
apply (rule impI)
apply (erule_tac x=l in allE)
apply (drule mp)
apply fast
apply assumption
done

(*****************)

constdefs Scnd::"'a \<times> 'b  \<times> 'c   \<times> 'd  \<Rightarrow> 'b"
"Scnd X  \<equiv>  fst (snd X)"

constdefs Thrd::"'a \<times> 'b  \<times> 'c   \<times> 'd   \<Rightarrow> 'c"
"Thrd X  \<equiv>  fst (snd (snd X))"

constdefs Frth::"'a \<times> 'b  \<times> 'c   \<times> 'd  \<Rightarrow> 'd"
"Frth X   \<equiv>  snd (snd (snd X))"


(*****************)


constdefs scnd::"'a \<times> 'b  \<times> 'c   \<times> 'd  \<times> 'e \<Rightarrow> 'b"
"scnd X  \<equiv>  fst (snd X)"

constdefs thrd::"'a \<times> 'b  \<times> 'c   \<times> 'd  \<times> 'e \<Rightarrow> 'c"
"thrd X  \<equiv>  fst (snd (snd X))"

constdefs frth::"'a \<times> 'b  \<times> 'c   \<times> 'd  \<times> 'e \<Rightarrow> 'd"
"frth X   \<equiv>  fst (snd (snd (snd X)))"

constdefs ffth::"'a \<times> 'b  \<times> 'c   \<times> 'd  \<times> 'e \<Rightarrow> 'e"
"ffth X   \<equiv>  snd (snd (snd (snd X)))"



constdefs context_sum:: "Context \<Rightarrow> Context \<Rightarrow> Context \<Rightarrow> bool"
"context_sum G1 G2 G == 
(DOM G = DOM G1 \<union> DOM G2) \<and> 
(\<forall> x. 
 (x \<in> DOM G1 - DOM G2 \<longrightarrow> (\<exists> k. GETr G1 x = Some (ListET k) \<and> GETr G x = Some (ListET k) )) \<and> 
 (x \<in> DOM G2 - DOM G1 \<longrightarrow> (\<exists> k. GETr G2 x = Some (ListET k) \<and> GETr G x = Some (ListET k) )) \<and>
 (x \<in> DOM G1 \<inter> DOM G2 \<longrightarrow> (\<exists> k1 k2. GETr G1 x = Some (ListET k1) \<and> GETr G2 x = Some (ListET k2) \<and>  
  GETr G x = Some (ListET (k1+k2)))))"


constdefs UAsnPre::
"(rname set) \<times> (rname set) \<times> (rname set) \<times>   Context \<times> Type \<Rightarrow> 
(locn set) \<times>(locn set) \<times> (locn set) \<times> (locn set) \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool" 
"UAsnPre Q X E h  \<equiv>
  (fst Q \<union> scnd Q \<union> thrd Q) \<subseteq>  (DOM (frth Q)) \<and> 
  (fst Q \<inter> scnd Q) ={} \<and> (fst Q \<inter> thrd Q)={}  \<and> (scnd Q \<inter> thrd Q)={}  \<and>     
     freelist h (fst X) \<and>
     (E,h,  False,  fst Q, frth Q, 1, Scnd X):CR \<and> 
     (E,h,  False, scnd Q, frth Q, 2, Thrd X):CR \<and> 
     (E,h,  False, thrd Q, frth Q, 3, Frth X):CR \<and> 
      (Scnd X \<inter> (Thrd X \<union> Frth X)) = {} \<and>
      (Scnd X \<union>  Thrd X \<union> Frth X) \<inter> (fst X) = {}"

constdefs UAsnPost::"(rname set) \<times> (rname set) \<times> (rname set) \<times>   Context \<times> Type \<Rightarrow> 
(locn set) \<times>(locn set) \<times> (locn set) \<times> (locn set)  \<Rightarrow> vdmassn" 
"UAsnPost Q X E h h' v p \<equiv>
    (\<exists> R' FF. (v, h' , Some (ffth Q),  False, R') : reg_ua \<and>
                 (freelist h' FF) \<and> 
                 (R' \<inter> FF = {}) \<and>  
                 (modify (fst X \<union> Scnd X) h h') \<and>
                 R' \<subseteq> ( Scnd X \<union> Thrd X  \<union> fst X) \<and> 
                 FF \<subseteq> ( Scnd X \<union> fst X) \<and> 
                 oheap h = oheap h' \<and>
                 ((E,h, True, scnd Q, frth Q, 2, Thrd X): CR \<longrightarrow>
                 (v, h' , Some (ffth Q), True, R') : reg_ua))"

(*****************************************************)


lemma UA1_Letr:
     "\<lbrakk> \<rhd> e :  ((UAsnPre Q1) \<Rightarrow>  (UAsnPost Q1));
        \<rhd> ee : ((UAsnPre Q2) \<Rightarrow>  (UAsnPost Q2));
       DOM (frth Q1) =(fst Q1 \<union> scnd Q1 \<union> thrd Q1) \<and> 
       DOM (frth Q2) =(fst Q2 \<union> scnd Q2 \<union> thrd Q2)\<and> 
       x \<in> fst Q2 \<and> 
       fst Q = fst Q1 \<union> scnd Q1 \<union> (fst Q2 -{x}) \<and>
       scnd Q = scnd Q2 \<and> 
       thrd Q = (thrd Q1 - (fst Q2 \<union> scnd Q2)) \<union> (thrd Q2) \<and>
       fst Q1  \<inter> (fst Q2 \<union> scnd Q2 \<union> thrd Q2) ={} \<and> 
       fst Q2  \<inter> (fst Q2 \<union> scnd Q2 \<union> thrd Q2) ={} \<and>
       (x \<in> (fst Q1 \<union> scnd Q1 \<union> thrd Q1) \<longrightarrow> x \<in> fst Q1)\<and> 
       (context_restrict (frth Q2) x G2') \<and>
       (context_sum (frth Q1) G2' (frst Q))\<and>
       GETr (frth Q2) x = Some (ffth Q1) \<rbrakk>
     \<Longrightarrow> \<rhd> (LET rf x = e IN ee END):  ((UAsnPre Q) \<Rightarrow>  (UAsnPost Q))"
apply (rule let_decent)
apply assumption
apply (rotate_tac 1) apply assumption
apply (rotate_tac 2) apply assumption
sorry




(***************************************************************************************************************)

