(*<*)
theory UA =  GA16 + UA_aux:
(*>*)



constdefs freelist::"heap \<Rightarrow> locn set \<Rightarrow> bool"
"freelist h F == \<exists> N. (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) : FL"

lemma freelistUnique:
"\<lbrakk>freelist h F; freelist h F'\<rbrakk>\<Longrightarrow> F=F'"
apply (simp only: freelist_def) 
apply (erule exE)+
apply (drule_tac F=F and FF=F' in FL_Unique)
apply assumption
apply fast
done

(*****************)

constdefs Scnd::"'a \<times> 'b  \<times> 'c   \<times> 'd  \<Rightarrow> 'b"
"Scnd X  \<equiv>  fst (snd X)"

constdefs Thrd::"'a \<times> 'b  \<times> 'c   \<times> 'd   \<Rightarrow> 'c"
"Thrd X  \<equiv>  fst (snd (snd X))"

constdefs Frth::"'a \<times> 'b  \<times> 'c   \<times> 'd  \<Rightarrow> 'd"
"Frth X   \<equiv>  snd (snd (snd X))"


(*****************)


constdefs scnd::"'a \<times> 'b  \<times> 'c   \<times> 'd  \<times> 'e \<Rightarrow> 'b"
"scnd X  \<equiv>  fst (snd X)"

constdefs thrd::"'a \<times> 'b  \<times> 'c   \<times> 'd  \<times> 'e \<Rightarrow> 'c"
"thrd X  \<equiv>  fst (snd (snd X))"

constdefs frth::"'a \<times> 'b  \<times> 'c   \<times> 'd  \<times> 'e \<Rightarrow> 'd"
"frth X   \<equiv>  fst (snd (snd (snd X)))"

constdefs ffth::"'a \<times> 'b  \<times> 'c   \<times> 'd  \<times> 'e \<Rightarrow> 'e"
"ffth X   \<equiv>  snd (snd (snd (snd X)))"


constdefs context_sum:: "Context \<Rightarrow> Context \<Rightarrow> Context \<Rightarrow> bool"
"context_sum G1 G2 G == 
(DOM G = DOM G1 \<union> DOM G2) \<and> 
(\<forall> x. 
 (x \<in> DOM G1 - DOM G2 \<longrightarrow> (\<exists> k. GETr G1 x = Some (ListET k) \<and> GETr G x = Some (ListET k) )) \<and> 
 (x \<in> DOM G2 - DOM G1 \<longrightarrow> (\<exists> k. GETr G2 x = Some (ListET k) \<and> GETr G x = Some (ListET k) )) \<and>
 (x \<in> DOM G1 \<inter> DOM G2 \<longrightarrow> (\<exists> k1 k2. GETr G1 x = Some (ListET k1) \<and> GETr G2 x = Some (ListET k2) \<and>  
  GETr G x = Some (ListET (k1+k2)))))"


lemma context_sum_subset_left:
"context_sum G1 G2 G \<Longrightarrow> DOM G1 \<subseteq>  DOM G"
apply (simp only: context_sum_def)
apply (erule conjE)+
apply fast
done

lemma context_sum_subset_right:
"context_sum G1 G2 G \<Longrightarrow> DOM G2 \<subseteq>  DOM G"
apply (simp only: context_sum_def)
apply (erule conjE)+
apply fast
done

lemma context_sum_coherent_left:
"\<lbrakk>context_sum G1 G2 G; U \<subseteq> DOM G1\<rbrakk>
\<Longrightarrow> coherent U G1 G"
apply (simp only: context_sum_def coherent_def)
apply (rule allI impI)+
apply (erule conjE)+
apply (erule_tac x=x in allE)
apply (erule conjE)+
apply (case_tac "x \<in> DOM G2") 
apply (rotate_tac 5)
apply (drule mp) apply fast
apply fast
apply (drule mp) apply fast
apply fast
done

lemma context_sum_coherent_right:
"\<lbrakk>context_sum G1 G2 G; U \<subseteq> DOM G2\<rbrakk>
\<Longrightarrow> coherent U G2 G"
apply (simp only: context_sum_def coherent_def)
apply (rule allI impI)+
apply (erule conjE)+
apply (erule_tac x=x in allE)
apply (erule conjE)+
apply (case_tac "x \<in> DOM G1") 
apply (rotate_tac 5)
apply (drule mp) apply fast
apply fast
apply (rotate_tac 4)
apply (drule mp) apply fast
apply fast
done

lemma context_sum_coherent_operands:
"\<lbrakk>context_sum G1 G2 G; U \<subseteq> DOM G1 \<inter> DOM G2 \<rbrakk>
\<Longrightarrow> coherent U G1 G2"
apply (simp only: context_sum_def coherent_def)
apply (rule allI impI)+
apply (erule conjE)+
apply (erule_tac x=x in allE)
apply (erule conjE)+
apply (rotate_tac 5)
apply (drule mp) apply fast
apply fast
done

constdefs context_minus_var:: "Context \<Rightarrow> rname \<Rightarrow> Context \<Rightarrow> bool"
"context_minus_var G x G' ==
DOM G' = DOM G -{x} \<and>
(\<forall> y. y \<in> DOM G' \<longrightarrow> GETr G y = GETr G' y)"

lemma context_minus_var_DOM:
"context_minus_var G x G' \<Longrightarrow> DOM G' = DOM G -{x}"
apply (simp add: context_minus_var_def)
done

lemma context_minus_var_subset:
"context_minus_var G x G' \<Longrightarrow> DOM G' \<subseteq> DOM G"
apply (simp only: context_minus_var_def) 
apply (erule conjE)
apply fast
done

lemma context_minus_var_coherent:
"\<lbrakk>context_minus_var G x G'; U \<subseteq> DOM G'\<rbrakk>\<Longrightarrow>
coherent U G G'"
apply (simp only: context_minus_var_def coherent_def)
apply (rule allI impI)+
apply (rename_tac x')
apply (erule conjE)+
apply (erule_tac x=x' in allE)
apply (subgoal_tac "x' \<in> DOM G'")
apply (drule mp) apply assumption
apply (frule_tac x=x' and C=G' in GETrDomSome)
apply (erule exE) 
apply (subgoal_tac "GETr G' x'=Some T")
apply simp apply assumption
apply fast
done

constdefs context_minus_set:: "Context \<Rightarrow> (rname set) \<Rightarrow> Context \<Rightarrow> bool"
"context_minus_set G U G' ==
DOM G' = DOM G - U \<and>
(\<forall> y. y \<in> DOM G' \<longrightarrow> GETr G y = GETr G' y)"

lemma context_minus_set_coherent:
"\<lbrakk>context_minus_set G U G'; U' \<subseteq> DOM G'\<rbrakk>\<Longrightarrow>
coherent U' G G'"
apply (simp only: context_minus_set_def coherent_def)
apply (rule allI impI)+
apply (rename_tac x')
apply (erule conjE)+
apply (erule_tac x=x' in allE)
apply (subgoal_tac "x' \<in> DOM G'")
apply (drule mp) apply assumption
apply (frule_tac x=x' and C=G' in GETrDomSome)
apply (erule exE) 
apply (subgoal_tac "GETr G' x'=Some T")
apply simp apply assumption
apply fast
done

subsubsection {*The heap assertion*}

constdefs UAsnPre::
"(rname set) \<times> (rname set) \<times> (rname set) \<times>   Context \<times> Type \<Rightarrow> 
(locn set) \<times>(locn set) \<times> (locn set) \<times> (locn set) \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool" 
"UAsnPre Q X E h  \<equiv>   
     freelist h (fst X) \<and>
     (E,h,  False,  fst Q, frth Q, 1, Scnd X):CR \<and> 
     (E,h,  False, scnd Q, frth Q, 2, Thrd X):CR \<and> 
     (E,h,  False, thrd Q, frth Q, 3, Frth X):CR \<and> 
      Scnd X \<inter> (Thrd X \<union> Frth X) = {} \<and>
      fst X \<inter> (Scnd X \<union>  Thrd X \<union> Frth X)  = {}"

constdefs UAsnPost::"(rname set) \<times> (rname set) \<times> (rname set) \<times>   Context \<times> Type \<Rightarrow> 
(locn set) \<times>(locn set) \<times> (locn set) \<times> (locn set)  \<Rightarrow> vdmassn" 
"UAsnPost Q X E h h' v p \<equiv>
    (\<exists> R' FF. (v, h' , Some (ffth Q),  False, R') : reg_ua \<and>
                 freelist h' FF \<and> 
                 FF \<inter> R' = {} \<and>  
                 modify (fst X \<union> Scnd X) h h' \<and>
                 R' \<subseteq> fst X \<union> Scnd X \<union> Thrd X   \<and> 
                 FF \<subseteq> fst X \<union> Scnd X \<and> 
                 oheap h = oheap h' \<and>
                 ((E,h, True, scnd Q, frth Q, 2, Thrd X): CR \<longrightarrow>
                 (v, h' , Some (ffth Q), True, R') : reg_ua))"



constdefs UAsnClassic::"(rname set)  \<Rightarrow>(rname set) \<Rightarrow>(rname set)\<Rightarrow>   
                        Context \<Rightarrow>  Type \<Rightarrow> vdmassn" ("\<lbrace> _ , _ , _ , _ \<ggreater>  _ \<rbrace>" 1000)
"UAsnClassic U1  U2  U3 G T E h h' v p \<equiv> 
  (\<forall> F R1 R2 R3.
     freelist h F \<and>
     (E,h,  False, U1, G, 1, R1):CR \<and> 
     (E,h,  False, U2, G, 2, R2):CR \<and> 
     (E,h,  False, U3, G, 3, R3):CR \<and> 
      R1 \<inter> (R2 \<union> R3) = {} \<and>
      F \<inter> (R1 \<union> R2 \<union> R3) = {} \<longrightarrow>
    (\<exists> R' FF. (v, h' , Some T,  False, R') : reg_ua \<and>
                 (freelist h' FF) \<and> 
                  FF \<inter> R' = {} \<and>  
                 modify (F \<union> R1) h h' \<and>
                 R' \<subseteq> F \<union> R1 \<union> R2 \<and>
                 FF \<subseteq> F \<union> R1 \<and>
                 oheap h = oheap h' \<and>
      ((E,h, True, U2, G, 2, R2): CR \<longrightarrow>
        (v, h' , Some T, True, R') : reg_ua)))"


lemma ClassicStructured: 
"UAsnClassic U1  U2  U3 G T E h h' v p \<Longrightarrow>
(UAsnPre (U1, U2, U3, G, T) \<Rightarrow> UAsnPost (U1, U2, U3, G, T)) E h h' v p"
apply (simp only: Impl_def)
apply (simp only: UAsnPre_def)
apply (simp only: UAsnPost_def)
apply (simp only: UAsnClassic_def)
apply (simp only: scnd_def thrd_def frth_def ffth_def)
apply (simp only: Scnd_def Thrd_def Frth_def)
apply simp
done

lemma StructuredClassic: 
"(UAsnPre (U1, U2, U3, G, T) \<Rightarrow> UAsnPost (U1, U2, U3, G, T)) E h h' v p \<Longrightarrow>
UAsnClassic U1  U2  U3 G T E h h' v p"
apply (simp only: Impl_def)
apply (simp only: UAsnPre_def)
apply (simp only: UAsnPost_def)
apply (simp only: UAsnClassic_def) 
apply (simp only: scnd_def thrd_def frth_def ffth_def)
apply (simp only: Scnd_def Thrd_def Frth_def)
apply simp
done



(********************** RULES ******************)

text{* Structural Rules *}

lemma  UAsnClassic_monotone_aux:
"\<lbrakk>UAsnClassic U' U'' U''' C T E h hh v p; 
  U' \<subseteq> UU'; U'' \<subseteq> UU''; U''' \<subseteq> UU'''\<rbrakk> \<Longrightarrow>UAsnClassic  UU' UU'' UU''' C T E h hh v p"
apply (simp only:  UAsnClassic_def)

apply (rule allI)+
apply (rule impI)

apply (erule conjE)+
apply (erule_tac x=F in allE)

apply (frule_tac U=UU' in CR_1_subset_reverse)
apply assumption
apply (frule_tac U=UU'' in CR_2_subset_reverse)
apply assumption
apply (frule_tac U=UU''' in CR_3_subset_reverse)
apply assumption
apply (erule exE conjE)+
apply (rename_tac R1' R2' R3')
apply (erule_tac x=R1' in allE)
apply (erule_tac x=R2' in allE)
apply (erule_tac x=R3' in allE)

apply (drule mp) apply fast

apply (erule exE conjE)+
apply (rule_tac x="R'" in exI)
apply (rule_tac x="FF" in exI)
apply (rule conjI, assumption)+
apply (rule conjI) apply (rule modify_monot) 
apply assumption apply fast
apply (rule conjI) apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) apply fast
apply (rule conjI) apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) apply fast
apply (rule conjI) apply assumption 

apply (rule impI)
apply (drule mp) apply (drule_tac U="UU''" and p=True and U'="U''" in CR_2_subset_reverse)
apply assumption
apply (erule exE conjE)+ 
apply (frule_tac U="U''" and i=2 and p=True in CR_2_TrueFalse)
apply simp apply simp 
apply (frule_tac U="U''" and i=2 and p=False and R="R2'" and R'="RR" in CR_uniqueReg)
apply simp+ 
done



lemma UAsnClassic_monotone:
"\<lbrakk>GG \<rhd> e: \<lbrace> U' , U'' , U''' , G \<ggreater>  T \<rbrace>;
  U' \<subseteq> UU'; U'' \<subseteq> UU''; U''' \<subseteq> UU'''\<rbrakk> \<Longrightarrow>
GG \<rhd> e: \<lbrace> UU' , UU'' , UU''' , G \<ggreater>  T \<rbrace>"
apply (rule vdm_conseq) apply assumption
apply (rule allI impI)+
apply (drule_tac U'=U' and U''=U'' and U'''=U''' in UAsnClassic_monotone_aux)
apply assumption+
done

(***************************************************************)


lemma WeakClassic_aux: "
\<lbrakk>UAsnClassic U' U'' U''' G T E h hh v p;
U' \<subseteq> DOM G; U'' \<subseteq> DOM G;  U''' \<subseteq> DOM G; 
context_minus_set G' U G\<rbrakk> 
\<Longrightarrow> UAsnClassic U' U'' U''' G' T  E h hh v p"
apply (simp only: UAsnClassic_def) 
apply (rule allI impI)+
apply (drule_tac G=G' and G'=G and U'="DOM G" in context_minus_set_coherent)
apply simp
apply (erule_tac x=F in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x=R2 in allE)
apply (erule_tac x=R3 in allE)
apply (erule conjE)+
apply (drule mp)
apply (rule conjI, assumption)
apply (rule conjI)
apply (drule_tac i=1 and p=False and U=U' and G=G' and G'=G in coherent_CR)
apply (rule_tac U="DOM G" in coherent_subset) apply assumption+
apply (rule conjI)
apply (drule_tac i=2 and p=False and U=U'' and G=G' and G'=G in coherent_CR)
apply (rule_tac U="DOM G" in coherent_subset) apply assumption+
apply (rule conjI)
apply (drule_tac i=3 and p=False and U=U''' and G=G' and G'=G in coherent_CR)
apply (rule_tac U="DOM G" in coherent_subset) apply assumption+
apply fast

apply (erule exE conjE)+
apply (rule_tac x=R' in exI)
apply (rule_tac x=FF in exI)
apply (rule conjI, assumption)+

apply (rule impI)
apply (drule mp)
apply (drule_tac i=2 and p=True and U=U'' and G=G' and G'=G in coherent_CR)
apply (rule_tac U="DOM G" in coherent_subset) apply assumption+
done


lemma WeakClassic:
"\<lbrakk> GG \<rhd> e: \<lbrace> U' , U'' , U''' , G \<ggreater>  T \<rbrace>;
U' \<subseteq> DOM G; U'' \<subseteq> DOM G;  U''' \<subseteq> DOM G; 
context_minus_set G' U G\<rbrakk> \<Longrightarrow>
GG \<rhd> e: \<lbrace> U' , U'' , U''' , G' \<ggreater>  T \<rbrace>"
apply (rule vdm_conseq)
apply assumption
apply (rule allI impI)+
apply (rule_tac G=G and G'=G' in WeakClassic_aux)
apply assumption+
done



(****)


lemma DropClassic21_aux: "\<lbrakk>UAsnClassic U' U'' U''' G T E h hh v p; 
x\<in> U''; x\<notin> U'\<rbrakk> \<Longrightarrow> UAsnClassic (U'\<union> {x}) (U''-{x}) U''' G T  E h hh v p"
apply (unfold UAsnClassic_def)
apply (rule allI impI)+
apply (erule conjE)+
apply (drule_tac U'=U' and U''="{x}" in CR_1_union_reverse_detailed)
apply fast
apply (erule exE conjE)+
apply (drule_tac U'="U''-{x}" and U''="{x}" and R''=R'' in CR_2_union)
apply simp 
apply (drule_tac U="{x}" and i=1 and j=2 in rise_CR)
apply simp apply assumption apply fast
apply (erule_tac x=F in allE)
apply (erule_tac x=R' in allE)
apply (erule_tac x="R2 \<union> R''" in allE)
apply (erule_tac x=R3 in allE)
apply (drule mp)
apply (rule conjI, assumption)
apply (rule conjI, assumption)
apply (rule conjI) apply (subgoal_tac "U''-{x}\<union> {x}=U''")
apply simp apply fast
apply (rule conjI, assumption)
apply (rule conjI) apply fast
apply fast

apply (erule exE conjE)+
apply (rename_tac Raux' FF)
apply (rule_tac x=Raux' in exI) 
apply (rule_tac x=FF in exI) 

apply (rule conjI, assumption)+
apply (rule conjI)
apply (rule_tac M="F \<union> R'" and M'="F \<union> R1" and h=h and hh=hh in modify_monot)
apply assumption apply fast
apply (rule conjI) apply fast
apply (rule conjI) apply fast
apply (rule conjI, assumption)

apply (rule impI) 
apply (drule_tac U'="U'' - {x}" and U''="{x}" and R''=R'' in CR_2_union) 
apply simp apply (rule_tac p=False in CR_12_singleton)
apply assumption apply fast
apply (drule mp) apply (subgoal_tac "U'' - {x} \<union> {x}=U''")
apply simp apply fast
apply assumption
done


lemma DropClassic21:
"\<lbrakk> GG \<rhd> e: \<lbrace> U', U'', U''', G \<ggreater>  T \<rbrace>;
 x \<in> U''; x \<notin> U'\<rbrakk> \<Longrightarrow>
GG \<rhd> e: \<lbrace>  U'\<union> {x} , U''-{x} , U''' , G \<ggreater>  T \<rbrace>"
apply (rule vdm_conseq)
apply assumption
apply (rule allI impI)+
apply (rule_tac G=G in DropClassic21_aux)
apply assumption+
done


(***)


lemma DropClassic31_aux: "\<lbrakk>UAsnClassic U' U'' U''' G T E h hh v p; 
x\<in> U'''; x\<notin> U'\<rbrakk> \<Longrightarrow> UAsnClassic (U'\<union> {x}) U'' (U'''-{x}) G T  E h hh v p"
apply (unfold UAsnClassic_def)
apply (rule allI impI)+
apply (erule conjE)+
apply (drule_tac U'=U' and U''="{x}" in CR_1_union_reverse_detailed)
apply fast
apply (erule exE conjE)+
apply (drule_tac U'="U'''-{x}" and U''="{x}" and R''=R'' in CR_3_union)
apply simp 
apply (drule_tac U="{x}" and i=1 and j=3 in rise_CR)
apply simp apply assumption
apply (erule_tac x=F in allE)
apply (erule_tac x=R' in allE)
apply (erule_tac x="R2" in allE)
apply (erule_tac x="R3  \<union> R''" in allE)
apply (drule mp)
apply (rule conjI, assumption)
apply (rule conjI, assumption)
apply (rule conjI, assumption)
apply (rule conjI) apply (subgoal_tac "U'''-{x}\<union> {x}=U'''")
apply simp apply fast
apply (rule conjI, fast)
apply fast

apply (erule exE conjE)+
apply (rename_tac Raux' FF)
apply (rule_tac x=Raux' in exI) 
apply (rule_tac x=FF in exI) 

apply (rule conjI, assumption)+
apply (rule conjI)
apply (rule_tac M="F \<union> R'" and M'="F \<union> R1" and h=h and hh=hh in modify_monot)
apply assumption apply fast
apply (rule conjI) apply fast
apply (rule conjI) apply fast
apply (rule conjI, assumption)

apply assumption
done


lemma DropClassicl31:
"\<lbrakk> GG \<rhd> e: \<lbrace> U', U'', U''', G \<ggreater>  T \<rbrace>;
 x \<in> U'''; x \<notin> U'\<rbrakk> \<Longrightarrow>
GG \<rhd> e: \<lbrace>  U'\<union> {x} , U'', U'''-{x}, G \<ggreater>  T \<rbrace>"
apply (rule vdm_conseq)
apply assumption
apply (rule allI impI)+
apply (rule_tac G=G in DropClassic31_aux)
apply assumption+
done

(****************)


lemma DropClassic32_aux: "\<lbrakk>UAsnClassic U' U'' U''' G T E h hh v p; 
x\<in> U'''; x\<notin> U''\<rbrakk> \<Longrightarrow> UAsnClassic U' (U''\<union> {x}) (U'''-{x}) G T  E h hh v p"
apply (unfold UAsnClassic_def)
apply (rule allI impI)+
apply (erule conjE)+
apply (drule_tac U'=U'' and U''="{x}" in CR_2_union_reverse)
apply (erule exE conjE)+
apply (drule_tac U'="U'''-{x}" and U''="{x}" and R''=R'' in CR_3_union)
apply simp 
apply (drule_tac U="{x}" and i=2 and j=3 in rise_CR)
apply simp apply assumption 
apply (erule_tac x=F in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x="R'" in allE)
apply (erule_tac x="R3 \<union> R''" in allE)
apply (drule mp)
apply (rule conjI, assumption)
apply (rule conjI, assumption)
apply (rule conjI, assumption) 
apply (rule conjI) apply (subgoal_tac "U'''-{x}\<union> {x}=U'''")
apply simp apply fast
apply (rule conjI) apply fast
apply fast

apply (erule exE conjE)+
apply (rename_tac Raux' FF)
apply (rule_tac x=Raux' in exI) 
apply (rule_tac x=FF in exI) 

apply (rule conjI, assumption)+
apply (rule conjI) apply fast
apply (rule conjI, assumption)+

apply (rule impI) 
apply (drule_tac U'="U''" and U''="{x}" in CR_2_union_reverse) 
apply (erule exE conjE)+
apply (rename_tac Raux Raux'')
apply (frule_tac U=U'' and R=Raux in CR_2_TrueFalse)
apply simp apply simp
apply (frule_tac i=2 and U=U'' and R=R' and R'=Raux in CR_uniqueReg)
apply assumption
apply (drule mp) apply simp
apply assumption
done


lemma DropClassic32:
"\<lbrakk> GG \<rhd> e: \<lbrace> U', U'', U''', G \<ggreater>  T \<rbrace>;
 x \<in> U'''; x \<notin> U''\<rbrakk> \<Longrightarrow>
GG \<rhd> e: \<lbrace>  U', U''\<union> {x} , U'''-{x}, G \<ggreater>  T \<rbrace>"
apply (rule vdm_conseq)
apply assumption
apply (rule allI impI)+
apply (rule_tac G=G in DropClassic32_aux)
apply assumption+
done

(**************************************************)

lemma RiseIntClassic_aux: 
"UAsnClassic U' U'' U''' G  IntET E h hh v p
 \<Longrightarrow> UAsnClassic U' {} (U'' \<union> U''') G IntET E h hh v p"
apply (simp only: UAsnClassic_def)
apply (rule allI impI)+
apply (erule exE conjE)+
apply (drule_tac U'=U'' and U''=U''' and p=False in CR_3_union_reverse)
apply (erule exE conjE)+
apply (drule_tac U=U'' in CR_32False)
apply simp
apply (erule_tac x=F in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x=R' in allE)
apply (erule_tac x=R'' in allE)
apply (drule mp)
apply (rule conjI, assumption)+
apply (rule conjI, fast)
apply fast

apply (erule exE conjE)+
apply (rename_tac Raux FF)
apply (rule_tac x=Raux in exI)
apply (rule_tac x=FF in exI)
apply (rule conjI, assumption)+
apply (frule_tac reg_ua_Int)
apply (rule conjI, fast) 
apply (rule conjI, assumption)+
apply (drule_tac p=True in reg_ua_IntFalseTrue)
apply simp

apply (rule impI)
apply assumption
done


lemma RiseIntClassic: 
"GG \<rhd> e: \<lbrace> U' , U'' , U''' , G \<ggreater>  IntET \<rbrace> \<Longrightarrow>
GG \<rhd> e: \<lbrace> U' , {} , U''\<union> U''' , G \<ggreater>  IntET \<rbrace>"
apply (rule vdm_conseq)
apply assumption
apply (rule allI impI)+
apply (rule RiseIntClassic_aux)
apply assumption
done

(***)

lemma RiseUnitClassic_aux: 
"UAsnClassic U' U'' U''' G  UnitET E h hh v p
 \<Longrightarrow> UAsnClassic U' {} (U'' \<union> U''') G UnitET E h hh v p"
apply (simp only: UAsnClassic_def)
apply (rule allI impI)+
apply (erule exE conjE)+
apply (drule_tac U'=U'' and U''=U''' and p=False in CR_3_union_reverse)
apply (erule exE conjE)+
apply (drule_tac U=U'' in CR_32False)
apply simp
apply (erule_tac x=F in allE)
apply (erule_tac x=R1 in allE)
apply (erule_tac x=R' in allE)
apply (erule_tac x=R'' in allE)
apply (drule mp)
apply (rule conjI, assumption)+
apply (rule conjI, fast)
apply fast

apply (erule exE conjE)+
apply (rename_tac Raux FF)
apply (rule_tac x=Raux in exI)
apply (rule_tac x=FF in exI)
apply (rule conjI, assumption)+
apply (frule_tac reg_ua_Unit)
apply (rule conjI, fast) 
apply (rule conjI, assumption)+
apply (drule_tac p=True in reg_ua_UnitFalseTrue)
apply simp

apply (rule impI)
apply assumption
done


lemma RiseUnitClassic: 
"GG \<rhd> e: \<lbrace> U' , U'' , U''' , G \<ggreater>  UnitET \<rbrace> \<Longrightarrow>
GG \<rhd> e: \<lbrace> U' , {} , U''\<union> U''' , G \<ggreater>  UnitET \<rbrace>"
apply (rule vdm_conseq)
apply assumption
apply (rule allI impI)+
apply (rule RiseUnitClassic_aux)
apply assumption
done

(****************************************************)


lemma UAsnClassic_null_aux: 
"\<lbrakk>T=ListET k; hh = h; v = RVal Nullref; p = tickRo\<rbrakk> \<Longrightarrow>
 UAsnClassic {} {} {} G T E h hh v p"
apply (unfold UAsnClassic_def)
apply (rule allI)+
apply (rule impI)
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp only: reg_ua_Null)
apply (rule regListNull_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp

apply (rule impI)
apply (simp add: regListNull_ua)
done


lemma UAsnClassic_null: "\<lbrakk>T=ListET k\<rbrakk> \<Longrightarrow> GG \<rhd> Null: \<lbrace> {} , {} , {} , G \<ggreater>  T \<rbrace>"
apply (rule vdm_conseq) apply (rule vdm_null)
apply (rule allI)+
apply (simp add: UAsnClassic_null_aux)
done



lemma UAsnClassic_IVal_aux: 
"\<lbrakk>T=IntET; hh = h; v = IVal i; p = tickRo\<rbrakk> \<Longrightarrow>
 UAsnClassic {} {} {} G T E h hh v p"
apply (unfold UAsnClassic_def)
apply (rule allI)+
apply (rule impI)
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp only: reg_ua_Int)
apply (rule regInt_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp

apply (rule impI)
apply (simp add: regInt_ua)
done


lemma UAsnClassic_IVal: "\<lbrakk>T=IntET\<rbrakk> \<Longrightarrow> GG \<rhd> expr.Int i: \<lbrace> {} , {} , {} , G \<ggreater>  T \<rbrace>"
apply (rule vdm_conseq) apply (rule vdm_int)
apply (rule allI)+
apply (simp add: UAsnClassic_IVal_aux)
done

lemma UAsnClassic_IVar_aux: 
"\<lbrakk>T = IntET; hh = h; v = IVal (ienv E x); p = tickRo\<rbrakk> \<Longrightarrow>
 UAsnClassic {} {} {} G T E h hh v p"
apply (unfold UAsnClassic_def)
apply (rule allI)+
apply (rule impI)
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp only: reg_ua_Int)
apply (rule regInt_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp

apply (rule impI)
apply (simp add: regInt_ua)
done

lemma UAsnClassic_IVar: 
"\<lbrakk>T=IntET\<rbrakk> \<Longrightarrow> 
GG \<rhd> IVar x: \<lbrace> {} , {} , {} , G \<ggreater>  T \<rbrace>"
apply (rule vdm_conseq) apply (rule vdm_ivar)
apply (rule allI)+
apply (simp add: UAsnClassic_IVar_aux)
done

lemma UAsnClassic_RVar_aux: 
"\<lbrakk>GETr G x = Some T; hh = h; v = RVal (renv E x); p = tickRo\<rbrakk> \<Longrightarrow>
 UAsnClassic {} {x} {} G T E h hh v p"
apply (unfold UAsnClassic_def)
apply (rule allI)+
apply (rule impI)
apply (erule conjE)+

apply (rule_tac x="R2" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)

apply (drule_tac x=x and i=2 in CR_2_reverse)
apply simp
apply simp
apply (erule exE)+ apply (erule conjE)+
apply simp
apply (drule_tac i=2 in CR_emptyU)
apply simp


apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply fast
apply (rule conjI) apply fast
apply (rule conjI) apply simp

apply (rule impI)
apply (drule_tac x=x and i=2 and p=True in CR_2_reverse)
apply simp
apply simp
apply (erule exE)+ apply (erule conjE)+
apply simp
apply (drule_tac i=2 in CR_emptyU)
apply simp
done

lemma UAsnClassic_RVar: 
"\<lbrakk>GETr G x = Some T\<rbrakk> \<Longrightarrow>
 GG \<rhd> RVar x:  \<lbrace> {} , {x} , {} , G \<ggreater>  T \<rbrace>"
apply (rule vdm_conseq) apply (rule vdm_rvar)
apply (rule allI)+
apply (simp add: UAsnClassic_RVar_aux  GETrSome_DOM)
done


(* Recall: integer names do not "take part" in U', U'', U''' *)
lemma UAsnClassic_Prim_aux: 
"\<lbrakk>T = IntET; hh = h; v = IVal (f (ienv E x) (ienv E y)); p = mkRescomp 3 0 0 0\<rbrakk> \<Longrightarrow>
UAsnClassic {} {} {} G T E h hh v p"
apply (unfold UAsnClassic_def)

apply (rule allI)+
apply (rule impI)
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp add: regInt_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp

apply (rule impI) apply (simp add: regInt_ua)
done


lemma UAsn_Classic_Prim: "\<lbrakk>T = IntET\<rbrakk> \<Longrightarrow> 
GG \<rhd> Primop f x y:  \<lbrace> {} , {} , {} , G \<ggreater>  T \<rbrace>"
apply (rule vdm_conseq) apply (rule vdm_prim)
apply (rule allI)+
apply (simp add: UAsnClassic_Prim_aux)
done


lemma UAsnClassic_RPrim_aux: 
"\<lbrakk>T = IntET; hh = h; v = IVal (f (renv E x) (renv E y)); p = mkRescomp 3 0 0 0\<rbrakk> \<Longrightarrow>
UAsnClassic {} {} {x, y} G T E h hh v p"
apply (unfold UAsnClassic_def)

apply (rule allI)+
apply (rule impI)
apply (erule conjE)+

apply (rule_tac x="{}" in exI)
apply  (rule_tac x="F" in exI)

apply (rule conjI)
apply (simp add: regInt_ua)

apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: modify_def same_heaps)
apply (rule conjI) apply simp
apply (rule conjI) apply fast
apply (rule conjI) apply simp

apply (rule impI) apply (simp add: regInt_ua)
done


lemma UAsn_Classic_RPrim: "\<lbrakk>GETr G x = Some Tx; GETr G y = Some Ty; T = IntET\<rbrakk> \<Longrightarrow> 
GG \<rhd> RPrimop f x y:  \<lbrace> {} , {} , {x, y} , G \<ggreater>  T \<rbrace>"
apply (rule vdm_conseq) apply (rule vdm_rprim)
apply (rule allI)+
apply (simp add: UAsnClassic_RPrim_aux  GETrSome_DOM)
done


lemma UAsnClassic_If_aux:
"\<lbrakk>ienv E b = 1 \<longrightarrow>  UAsnClassic U' U'' U''' G T E h hh v pp;
  ienv E b = 0 \<longrightarrow>  UAsnClassic U' U'' U''' G T E h hh v pp;
  ienv E b = 1 \<or> ienv E b = 0\<rbrakk>
 \<Longrightarrow>  UAsnClassic U' U'' U''' G T E h hh v p"
apply (unfold UAsnClassic_def)
apply blast
done


 
lemma UAsn_Classic_If: "
\<lbrakk> \<rhd> e :   \<lbrace> U' , U'' , U''' , G \<ggreater>  T \<rbrace>;
  \<rhd> ee :  \<lbrace> U' , U'' , U''' , G \<ggreater>  T \<rbrace>\<rbrakk> \<Longrightarrow> 
 \<rhd> (IF b THEN e ELSE ee) :  \<lbrace>U' , U'' , U''' , G \<ggreater>  T \<rbrace>"
apply (rule vdm_conseq) apply (rule vdm_if)
apply (assumption, assumption)
apply (rule allI)+
apply (erule thin_rl)+
apply simp
apply (rule impI)
apply (erule exE) apply (erule conjE)+
apply (rule UAsnClassic_If_aux)
apply fast+  
done

(***************************)

lemma inter_union3_empty:
"\<lbrakk>X \<inter> A ={}; X \<inter> B ={}; X \<inter> C ={} \<rbrakk> \<Longrightarrow>
X \<inter> (A \<union> B \<union> C) ={}"
apply fast
done

lemma subset_inter_empty:
"\<lbrakk>X\<inter>A={}; Y\<subseteq>  X\<rbrakk>\<Longrightarrow>Y\<inter>  A={}"
apply fast
done

lemma inter_subset_empty:
"\<lbrakk>A\<inter>X={}; Y\<subseteq>  X\<rbrakk>\<Longrightarrow>A \<inter> Y={}"
apply fast
done



lemma  UA1_Letr_Pre1_aux:
"\<lbrakk> (E, h, False, Ui, G, 1, Ri) \<in> CR;
   (E, h, False, Uii, G, 2, Rii) \<in> CR; 
   (E, h, False, Uiii, G, 3, Riii) \<in> CR;
   Ri \<inter> Rii ={};
   Ri \<inter> Riii={};
  
  F\<inter>Ri={}; F\<inter>Rii={};F\<inter>Riii={};
  
  Ui = U'i \<union> U'ii \<union> (U''i - {x});
  Uii = U''ii;
  Uiii = U'iii - (U''i \<union> U''ii) \<union> U''iii;

  U'i \<inter> U''i = {};
  U'i \<inter> U''ii = {};
  U'i \<inter> U''iii = {};
  U'i \<inter> U'ii = {};
  U'ii \<inter> U''i = {};

  x \<notin> U'iii;
  x \<in>  U''i; x\<notin> U''ii; x\<notin> U''iii;

  coherent U'i  G G';
  coherent U'ii G G';
  coherent U'iii G G'

  \<rbrakk> \<Longrightarrow>
          \<exists>R11 Rijj R131 R132 R133 R21 R22 R23.
             (E, h, False, U'i, G', 1, R11) \<in> CR \<and>
             (E, h, False, U'ii, G', 1, Rijj) \<in> CR \<and> 
             (E, h, False, U'iii, G', 3, R131 \<union> R132 \<union> R133) \<in> CR \<and>
              R11 \<inter> R21 ={} \<and> Rijj \<inter> R21 ={} \<and> 
              R11 \<inter> Rijj ={} \<and> R11 \<inter> (R131 \<union> R132 \<union> R133) ={} \<and>
              F\<inter>R11={} \<and>  F\<inter>R21={} \<and> F\<inter>(R131 \<union> R132 \<union> R133)={} \<and> 
              F \<inter> Rijj ={} \<and> F \<inter> R23 ={} \<and> F \<inter> R22 ={} \<and>
             (E, h, False, U''i-{x}, G, 1, R21) \<in> CR \<and>
             (E, h, False, U''ii, G, 2, R22) \<in> CR \<and> 
             (E, h, False, U''iii, G, 3, R23) \<in> CR \<and>
              R21 \<inter> R22 ={} \<and> R21 \<inter> R23 ={} \<and>
              Ri = R11 \<union> Rijj \<union> R21 \<and>
              Rii = R22 \<and>
              Riii = R131 \<union> R23 \<and> R132 \<subseteq> R21 \<and> R133 \<subseteq> R22"

apply (subgoal_tac "(E, h, False, U'i \<union> U'ii \<union> (U''i - {x}) , G, 1, Ri) \<in> CR")
prefer 2 apply fastsimp
apply (drule CR_1_union3_reverse_detailed)
apply assumption apply fast apply fast 
apply (erule exE conjE)+
apply (rename_tac R11 Rijj R21)

apply (subgoal_tac "(E, h, False, U''ii , G, 2, Rii) \<in> CR")
prefer 2 apply fastsimp

apply (subgoal_tac "(E, h, False, U'iii - (U''i \<union> U''ii) \<union> U''iii, G, 3, Riii) \<in> CR")
prefer 2 apply fastsimp
apply (drule CR_3_union_reverse)
apply (erule exE conjE)+
apply (rename_tac R131 R23) 

apply (frule_tac U="U''i -{x}" and U'="U'iii \<inter> U''i" and R=R21
in  CR_1_subset_reverse) 
apply fast apply (erule exE conjE)+
apply (rename_tac R132)
apply (drule_tac U="U'iii \<inter> U''i" and i=1 and j=3 in rise_CR)
apply (simp (no_asm))

apply (frule_tac U="U''ii" and U'="U'iii \<inter> U''ii" in  CR_2_subset_reverse)
apply fast apply (erule exE conjE)+ 
apply (rename_tac R133)
apply (drule_tac U="U'iii \<inter> U''ii" and i=2 and j=3 in rise_CR)
apply (simp (no_asm))

apply (drule_tac U'="U'iii - (U''i \<union> U''ii)" and U''="U'iii \<inter> U''i"
and U'''="U'iii \<inter> U''ii" and R'=R131 and R''=R132 and R'''=R133 
in CR_3_union3) apply assumption+

(***)

apply (rule_tac x=R11 in exI)
apply (rule_tac x=Rijj in exI)
apply (rule_tac x=R131 in exI)
apply (rule_tac x=R132 in exI)
apply (rule_tac x=R133 in exI)
apply (rule_tac x=R21 in exI)
apply (rule_tac x=Rii in exI)
apply (rule_tac x=R23 in exI)

apply (rule conjI)
apply (rule_tac U=U'i and G=G and G'=G' and i=1 and p=False in coherent_CR)
apply assumption+

apply (rule conjI)
apply (rule_tac U=U'ii and G=G and G'=G' and i=1 and p=False in coherent_CR)
apply assumption+

apply (rule conjI)
apply (rule_tac U=U'iii and G=G and G'=G' and i=3 and p=False in coherent_CR)
apply (subgoal_tac "U'iii=(U'iii - (U''i \<union> U''ii)) \<union> (U'iii \<inter> U''i) \<union> (U'iii \<inter> U''ii)")
prefer 2 apply fast apply simp
apply assumption

apply (rule conjI, assumption)+

apply (rule conjI) 
apply (rule_tac X=R11 and A=R131 and B=R132 and C=R133 in inter_union3_empty)
(**)
apply (rule_tac Y=R11 and A=R131 and X=Ri in subset_inter_empty)
apply (rule_tac Y=R131 and A=Ri and X=Riii in inter_subset_empty)
apply assumption 
apply fast apply fast
(**)
apply (rule_tac A=R11 and Y=R132 and X=R21 in inter_subset_empty)
apply assumption+
(**)
apply (rule_tac Y=R11 and A=R133 and X=Ri in subset_inter_empty)
apply (rule_tac Y=R133 and A=Ri and X=Rii in inter_subset_empty)
apply assumption+ 
apply fast

apply (rule conjI)
apply (rule_tac Y=R11 and A=F and X=Ri in inter_subset_empty)
apply assumption apply fast

apply (rule conjI)
apply (rule_tac Y=R21 and A=F and X=Ri in inter_subset_empty)
apply assumption apply fast

apply (rule conjI)
apply (rule_tac X=F and A=R131 and B=R132 and C=R133 in inter_union3_empty)
apply (rule_tac Y=R131 and A=F and X=Riii in inter_subset_empty)
apply assumption apply fast
apply (rule_tac Y=R132 and A=F and X=R21 in inter_subset_empty)
apply (rule_tac Y=R21 and A=F and X=Ri in inter_subset_empty)
apply assumption apply fast apply assumption
apply (rule_tac Y=R133 and A=F and X=Rii in inter_subset_empty)
apply assumption+

apply (rule conjI)
apply (rule_tac Y=Rijj and A=F and X=Ri in inter_subset_empty)
apply assumption apply fast

apply (rule conjI)
apply (rule_tac Y=R23 and A=F and X=Riii in inter_subset_empty)
apply assumption apply fast

apply (rule conjI, assumption)+

apply (rule conjI)
apply (rule_tac Y=R21 and A=Rii and X=Ri in subset_inter_empty)
apply assumption apply fast

apply (rule conjI)
apply (rule_tac Y=R21 and A=R23 and X=Ri in subset_inter_empty)
apply (rule_tac Y=R23 and A=Ri and X=Riii in inter_subset_empty)
apply assumption apply fast apply fast

apply (rule conjI, assumption)
apply (rule conjI, simp (no_asm))
apply (rule conjI, assumption)+
apply assumption
done 

(***)

lemma inter_union2_empty:
"\<lbrakk>X \<inter> A ={}; X \<inter> B ={}\<rbrakk> \<Longrightarrow>
X \<inter> (A \<union> B) ={}"
apply fast
done

lemma inter_sym_empty:
"A \<inter> B ={} \<Longrightarrow>
B\<inter> A={}"
apply fast
done

lemma union2_inter_empty:
"\<lbrakk>A \<inter> X ={}; B \<inter> X ={}\<rbrakk> \<Longrightarrow>
(A \<union> B)\<inter> X ={}"
apply fast
done

lemma interUnionReverse_empty:
"A \<inter> (B \<union> C) ={} \<Longrightarrow> A \<inter> B ={} \<and> A \<inter> C ={}"
apply fast
done

lemma inter_union3Reverse_empty:
"X \<inter> (A \<union> B \<union> C)= {} \<Longrightarrow>
X \<inter> A ={} \<and> X \<inter> B ={} \<and> X \<inter> C ={}"
apply fast
done 



lemma inter_union_empty:
"\<lbrakk>X\<inter> A={}; X\<inter> B={}\<rbrakk> \<Longrightarrow> 
X \<inter> (A \<union> B)={}"
apply fast
done 




(***)


lemma  UA1_Letr_Pre2_aux:
"\<lbrakk> (E, h, False, Ui, G, 1, Ri) \<in> CR;
   (E, h, False, Uii, G, 2, Rii) \<in> CR; 
   (E, h, False, Uiii, G, 3, Riii) \<in> CR;
   Ri \<inter> Rii ={};
   Ri \<inter> Riii={};

  F\<inter>Ri={}; F\<inter>Rii={};F\<inter>Riii={};

  Ui = U'i \<union> U'ii \<union> (U''i - {x});
  Uii = U''ii;
  Uiii = U'iii - (U''i \<union> U''ii) \<union> U''iii;

  U'i \<inter> U''i = {};
  U'i \<inter> U''ii = {};
  U'i \<inter> U''iii = {};
  U'i \<inter> U'ii = {};
  U'ii \<inter> U''i = {};

  x \<notin> U'iii;
  x \<in>  U''i; x\<notin> U''ii; x\<notin> U''iii;



 coherent (U''i -{x}) G G'';
 coherent U''ii G G'';
 coherent U''iii G G'';

 (E, h, False, U'ii, G', 1, Rijj) \<in> CR; 
 (RVal r, hi,  GETr G'' x, False, R') \<in> reg_ua;
 (E, h, True, U'ii, G', 2, Rijj) \<in> CR \<longrightarrow> 
             (RVal r, hi,  GETr G'' x, True, R') \<in> reg_ua;
 modify (F \<union> R11) h hi;
 R' \<subseteq> F \<union> R11 \<union> Rijj;
 FF \<inter> R' ={};



 (E, h, False, U''i-{x}, G, 1, R21) \<in> CR;
 (E, h, False, U''ii, G, 2, R22) \<in> CR;
 (E, h, False, U''iii, G, 3, R23) \<in> CR;

 Ri = R11 \<union> Rijj \<union> R21;
 Rii = R22;
 Riii = R131 \<union> R23;
             
  R11 \<inter> R21 ={};  R11 \<inter> Rijj ={}; R11 \<inter> (R131 \<union> R132 \<union> R133) ={};
  Rijj \<inter> R21 ={};  R21 \<inter> R22 ={};  R21 \<inter> R23 ={};
  R132 \<subseteq> R21; R133 \<subseteq> R22;

  F\<inter>R11={};   F \<inter> Rijj ={}; F\<inter>(R131 \<union> R132 \<union> R133)={};
  F\<inter>R21={};   F \<inter> R22 ={}; F \<inter> R23 ={}


 \<rbrakk> \<Longrightarrow>  (E\<lfloor>x:=r\<rfloor>, hi, False, U''i, G'', 1, R21 \<union> R') \<in> CR \<and>
        (E\<lfloor>x:=r\<rfloor>, hi, False, U''ii, G'', 2, R22) \<in> CR \<and> 
        (E\<lfloor>x:=r\<rfloor>, hi, False, U''iii, G'', 3, R23) \<in> CR  \<and> 
         (R21 \<union> R') \<inter> (R22 \<union> R23)={} \<and> 
        (FF \<subseteq> F \<union> R11 \<longrightarrow> FF \<inter> ((R21 \<union> R') \<union> R22 \<union> R23)={})"

(** jezt geht's los **)
apply (rule conjI)
apply (rule_tac E="E\<lfloor>x:=r\<rfloor>" and x=x in CR_1)
apply (rule_tac E="E\<lfloor>x:=r\<rfloor>" and h=hi and U="U''i-{x}" and G=G and G'=G'' and i=1 in coherent_CR)
prefer 2 apply assumption
(**)
apply (drule_tac E=E and U="U''i-{x}" and x=x and r=r in CR_updEnv)
apply fast
apply (frule_tac E="E\<lfloor>x:=r\<rfloor>" and h=h and p=False and U="U''i -{x}" 
and i=1 and hh=hi and G="G" and R=R21 in CR_nonmodify)
apply assumption
apply (rule_tac X=R21 and A=F and B=R11 in inter_union2_empty)
apply (rule_tac A=F and B=R21 in inter_sym_empty)
apply assumption
apply (rule_tac A=R11 and B=R21 in inter_sym_empty)
apply assumption+

apply (drule mp)
apply (drule_tac U=U'ii and R=Rijj and p=False and p'=True in CR_1_EquivTrueFalse)
apply (simp (no_asm))
apply (drule_tac U=U'ii and R=Rijj  and p=True and i=1 and j=2 in rise_CR)
apply (simp (no_asm))
apply assumption
apply (simp (no_asm))
(**)
apply (rule_tac A=R21 and Y=R' and X="F \<union> R11 \<union> Rijj" in inter_subset_empty)
apply (rule_tac X=R21 and A=F and B=R11 and C=Rijj in inter_union3_empty)
apply (rule_tac A=F and B=R21 in inter_sym_empty) apply assumption
apply (rule_tac B=R21 and A=R11 in inter_sym_empty) apply assumption
apply (rule_tac B=R21 and A=Rijj in inter_sym_empty) apply assumption
apply assumption

(****)
apply (rule conjI)
apply (drule_tac E=E and U="U''ii" and x=x and r=r in CR_updEnv)
apply fast
apply (rule_tac E="E\<lfloor>x:=r\<rfloor>" and h=hi and U="U''ii" and G=G and G'=G'' and i=2 in coherent_CR)
prefer 2 apply assumption
apply (frule_tac E="E\<lfloor>x:=r\<rfloor>" and h=h and p=False and U="U''ii" 
and i=2 and hh=hi and G="G" and R=R22 in CR_nonmodify)
apply assumption
apply (rule_tac X=R22 and A=F and B=R11 in inter_union2_empty)
apply (rule_tac A=F and B=R22 in inter_sym_empty)
apply simp
apply (rule_tac A=R22 and Y=R11 and X=Ri in inter_subset_empty)
apply (rule_tac A=Ri and B=R22 in inter_sym_empty)
apply simp
apply fast
apply simp

(***)
apply (rule conjI)
apply (drule_tac E=E and U="U''iii" and x=x and r=r in CR_updEnv)
apply fast
apply (rule_tac E="E\<lfloor>x:=r\<rfloor>" and h=hi and U="U''iii" and G=G and G'=G'' and i=3 in coherent_CR)
prefer 2 apply assumption
apply (frule_tac E="E\<lfloor>x:=r\<rfloor>" and h=h and p=False and U="U''iii" 
and i=3 and hh=hi and G="G" and R=R23 in CR_nonmodify)
apply assumption
apply (rule_tac X=R23 and A=F and B=R11 in inter_union2_empty)
apply (rule_tac B=R23 and A=F in inter_sym_empty)
apply assumption
apply  (rule_tac A=R11 and Y=R23 and X=Riii in subset_inter_empty)
apply  (rule_tac A=Riii and Y=R11 and X=Ri in inter_subset_empty)
apply (rule_tac B=Riii and A=Ri in inter_sym_empty)
apply assumption apply fast
apply fast
apply assumption

apply (rule conjI)
apply (rule_tac X="R21 \<union> R'" and A="R22" and B="R23" in inter_union_empty)
apply (rule_tac B="R21 \<union> R'" and A="R22" in inter_sym_empty)
apply (rule_tac X="R22" and A="R21" and B="R'" in inter_union_empty)
apply (rule_tac B="R22" and A="R21" in inter_sym_empty)
apply assumption
apply (rule_tac A="R22" and Y="R'" and X="F \<union> R11 \<union> Rijj" in inter_subset_empty)
apply (rule_tac  X="R22" and A="F" and B="R11" and C=Rijj in inter_union3_empty)
apply (rule_tac B="R22" and A="F" in inter_sym_empty)
apply assumption
apply (rule_tac A="R22" and Y="R11" and X="Ri" in inter_subset_empty)
apply (rule_tac A="Ri" and Y="R22" and X="Rii" in subset_inter_empty)
apply (rule_tac A="Ri" and B="Rii" in inter_sym_empty)
apply assumption
apply fast
apply fast
apply (rule_tac A="R22" and Y="Rijj" and X="Ri" in inter_subset_empty)
apply (rule_tac A="Ri" and Y="R22" and X="Rii" in subset_inter_empty)
apply (rule_tac A="Ri" and B="Rii" in inter_sym_empty)
apply assumption
apply fast
apply fast
apply assumption
(**)
apply (rule_tac B="R21 \<union> R'" and A="R23" in inter_sym_empty)
apply (rule_tac X="R23" and A="R21" and B="R'" in inter_union_empty)
apply (rule_tac B="R23" and A="R21" in inter_sym_empty)
apply assumption
apply (rule_tac A="R23" and Y="R'" and X="F \<union> R11 \<union> Rijj" in inter_subset_empty)
apply (rule_tac  X="R23" and A="F" and B="R11" and C=Rijj in inter_union3_empty)
apply (rule_tac B="R23" and A="F" in inter_sym_empty)
apply assumption
apply (rule_tac A="R23" and Y="R11" and X="Ri" in inter_subset_empty)
apply (rule_tac A="Ri" and Y="R23" and X="Riii" in subset_inter_empty)
apply (rule_tac A="Ri" and B="Riii" in inter_sym_empty)
apply assumption
apply fast
apply fast
apply (rule_tac A="R23" and Y="Rijj" and X="Ri" in inter_subset_empty)
apply (rule_tac A="Ri" and Y="R23" and X="Riii" in subset_inter_empty)
apply (rule_tac A="Ri" and B="Riii" in inter_sym_empty)
apply assumption
apply fast
apply fast
apply assumption



apply (rule impI)
apply (rule_tac X=FF and A="R21 \<union> R'" and B=R22 and C=R23 in inter_union3_empty)
apply (rule_tac X=FF and A=R21 and B=R' in inter_union2_empty)
apply (rule_tac A=R21 and Y=FF and X="F \<union> R11" in subset_inter_empty)
apply (rule_tac X=R21 and A=F and B=R11 in union2_inter_empty)
apply assumption+

apply (rule_tac A=R22 and Y=FF and X="F \<union> R11" in subset_inter_empty)
apply (rule_tac X=R22 and A=F and B=R11 in union2_inter_empty)
apply assumption
apply (rule_tac A=R22 and Y=R11 and X="Ri" in subset_inter_empty)
apply simp 
apply fast
apply assumption

apply (rule_tac A=R23 and Y=FF and X="F \<union> R11" in subset_inter_empty)
apply (rule_tac X=R23 and A=F and B=R11 in union2_inter_empty)
apply assumption
apply (rule_tac A=R23 and Y=R11 and X="Ri" in subset_inter_empty)
apply (rule_tac Y=R23 and A=Ri and X="Riii" in inter_subset_empty)
apply assumption apply fast
apply fast apply assumption
done


lemma sameOH_refl:
"sameOH M h h"
apply (unfold sameOH_def)
apply (rule allI impI)+
apply fast
done

lemma sameOH_sym:
"sameOH M h h'\<Longrightarrow> sameOH M h' h"
apply (unfold sameOH_def)
apply (rule allI impI)+
apply (erule_tac x=l in allE)
apply (drule mp) apply assumption
apply simp
done

lemma sameOH_transit:
"\<lbrakk>sameOH M h hi; sameOH M hi h'\<rbrakk> \<Longrightarrow>
sameOH M h h'"
apply (unfold sameOH_def)
apply (rule allI impI)+
apply (erule_tac x=l in allE)
apply (drule mp) apply assumption
apply (erule_tac x=l in allE)
apply (drule mp) apply assumption
apply (erule conjE)+
apply (rule conjI, simp)+
apply simp
done


lemma modify_refl:
"modify M h h"
apply (unfold modify_def)
apply (rule allI)
apply (rule impI)
apply (rule_tac M="{l}" in sameOH_refl)
done

lemma same_oh:
"oheap h = oheap h' \<Longrightarrow> Dom h = Dom h'"
apply (unfold oheap_def)
apply simp
done

lemma modify_sym:
"\<lbrakk>modify M h h'; Dom h = Dom h'\<rbrakk> \<Longrightarrow> modify M h' h"
apply (unfold modify_def)
apply (rule allI)
apply (rule impI)
apply (rule_tac M="{l}" in sameOH_sym)
apply (erule_tac x=l in allE)
apply (drule mp) apply fast
apply assumption
done


lemma modify_transit:
"\<lbrakk>modify M h hi; modify M hi h'; Dom h \<subseteq> Dom hi\<rbrakk> \<Longrightarrow> modify M h h'"
apply (unfold modify_def)
apply (rule allI)
apply (rule impI)
apply (erule_tac x=l in allE)
apply (drule mp) apply assumption
apply (erule_tac x=l in allE)
apply (drule mp) apply fast
apply (rule_tac M="{l}" and h=h and hi=hi and h'=h' in sameOH_transit)
apply assumption+
done


lemma monot_union:
"\<lbrakk>Y\<subseteq>X; A \<subseteq> B\<rbrakk> \<Longrightarrow> Y  \<union> A  \<subseteq> X \<union> B"
apply fast
done

lemma subsetSimp:
"\<lbrakk> A \<subseteq> X; X=Y \<rbrakk> \<Longrightarrow> A \<subseteq> Y"
apply fast
done

lemma subsetTrans:
"\<lbrakk>A\<subseteq> B; B \<subseteq> C \<rbrakk> \<Longrightarrow> A \<subseteq> C"
apply fast
done



lemma  UA1_Letr_Post_aux:
"\<lbrakk>  (E, h, False, Ui, G, 1, Ri) \<in> CR;
   (E, h, False, Uii, G, 2, Rii) \<in> CR; 
   (E, h, False, Uiii, G, 3, Riii) \<in> CR;
   Ri \<inter> Rii ={};
   Ri \<inter> Riii={};

  F\<inter>Ri={}; F\<inter>Rii={};F\<inter>Riii={};

  Ui = U'i \<union> U'ii \<union> (U''i - {x});
  Uii = U''ii;
  Uiii = U'iii - (U''i \<union> U''ii) \<union> U''iii;

  U'i \<inter> U''i = {};
  U'i \<inter> U''ii = {};
  U'i \<inter> U''iii = {};
  U'i \<inter> U'ii = {};
  U'ii \<inter> U''i = {};

  x \<notin> U'iii;
  x \<in>  U''i; x\<notin> U''ii; x\<notin> U''iii;

 
 coherent U''ii G G'';


 modify (F \<union> R11) h ho;
 Fo \<inter> Ro ={};
 Fo \<subseteq> F \<union> R11;
 Ro \<subseteq> F \<union> R11 \<union> Rijj;
 

 (E\<lfloor>x:=ro\<rfloor>, ho, True, U''ii, G'', 2, R22) \<in> CR \<longrightarrow> (v, h',  Some T, True, R') \<in> reg_ua;
  modify (Fo \<union> (R21 \<union> Ro)) ho h'; 
  F' \<inter> R' ={};
  F' \<subseteq> Fo \<union>(R21 \<union> Ro);
  R' \<subseteq> Fo \<union> (R21 \<union> Ro) \<union> R22;
 
  

 Ri = R11 \<union> Rijj \<union> R21;
 Rii = R22;
 Riii = R131 \<union> R23;
             
  R11 \<inter> R21 ={};  R11 \<inter> Rijj ={}; R11 \<inter> (R131 \<union> R132 \<union> R133) ={};
  Rijj \<inter> R21 ={};  R21 \<inter> R22 ={};  R21 \<inter> R23 ={};
  R132 \<subseteq> R21; R133 \<subseteq> R22;

  F\<inter>R11={};   F \<inter> Rijj ={}; F\<inter>(R131 \<union> R132 \<union> R133)={};
  F\<inter>R21={};   F \<inter> R22 ={}; F \<inter> R23 ={};

  Fo\<inter>(R21 \<union> Ro)={};  Fo\<inter> R22={}; Fo\<inter> R23={};

 Dom ho  = Dom h
 
 \<rbrakk> \<Longrightarrow> modify (F \<union> Ri) h h' \<and>  F' \<subseteq> F \<union> Ri \<and> R' \<subseteq> F \<union> Ri \<union> Rii \<and> 
       ((E, h, True, Uii, G, 2, Rii) \<in> CR \<longrightarrow> (v, h',  Some T, True, R') \<in> reg_ua)"
apply (rule conjI)
apply (rule_tac M="F\<union>Ri" and h=h and hi=ho and h'=h' in modify_transit)
apply (rule_tac M="F\<union>R11" and M'="F\<union>Ri" and h=h and hh=ho in modify_monot)
apply assumption
apply fast
apply (rule_tac M'="F\<union>Ri" and M="Fo \<union> (R21 \<union> Ro) " and h=ho and hh=h' in modify_monot)
apply assumption

apply (rule_tac A="Fo \<union> (R21 \<union> Ro)" and Y="F \<union> Ri" and X="F \<union> (R11 \<union> Rijj \<union> R21)" in subsetSimp)
apply (rule_tac A="Fo \<union> (R21 \<union> Ro)" and Y="F \<union> (R11 \<union> Rijj \<union> R21)" 
and X="(F \<union> R11) \<union> (F \<union> R11 \<union> Rijj) \<union>  R21" in subsetSimp)
apply (rule_tac A="Fo \<union> (R21 \<union> Ro)" and B="Fo \<union> Ro \<union> R21" and 
C="(F \<union> R11) \<union> (F \<union> R11 \<union> Rijj)  \<union> R21" in subsetTrans)
apply fast
apply (rule_tac Y="Fo \<union> Ro" and X="F \<union> R11 \<union> (F \<union> R11 \<union> Rijj)" and 
A="R21" and B="R21" in monot_union) 
apply (rule_tac Y="Fo" and X="F \<union> R11" and 
A="Ro" and B="F \<union> R11 \<union> Rijj" in monot_union) 
apply assumption+
apply (simp (no_asm))
apply fast
apply simp
apply simp

apply (rule conjI)
apply (rule_tac A="F'" and Y="F \<union> Ri" and X="F \<union> (R11 \<union> Rijj \<union> R21)" in subsetSimp)
apply (rule_tac A="F'" and B="Fo \<union> (R21 \<union> Ro)" and 
C="F \<union> (R11 \<union> Rijj \<union> R21)" in subsetTrans)
apply assumption
apply (rule_tac A="Fo \<union> (R21 \<union> Ro)" and 
X="F \<union> R11 \<union> (R21 \<union> (F \<union> R11\<union>   Rijj))" and Y="F \<union> (R11 \<union> Rijj \<union> R21)" in subsetSimp)
apply (rule_tac Y="Fo" and X="F \<union> R11" and 
A="R21 \<union> Ro" and B="R21 \<union> (F \<union> R11 \<union> Rijj)" in monot_union)
apply assumption 
apply (rule_tac Y="R21" and X="R21" and 
A="Ro" and B="F \<union> R11 \<union> Rijj" in monot_union)
apply (simp (no_asm))
apply assumption
apply fast
apply (simp)

apply (rule conjI)
apply (rule_tac A="R'" and Y="F \<union> Ri \<union> Rii" and X="F \<union> (R11 \<union> Rijj \<union> R21) \<union> R22" in subsetSimp)
apply (rule_tac A="R'" and B="Fo \<union> (R21 \<union> Ro) \<union> R22" and 
C="F \<union> (R11 \<union> Rijj \<union> R21) \<union> R22" in subsetTrans)
apply simp
apply (rule_tac Y="Fo \<union> (R21 \<union> Ro)" and X="F \<union> (R11 \<union> Rijj \<union> R21)" and 
A="R22" and B="R22" in monot_union)
apply (rule_tac A="Fo \<union> (R21 \<union> Ro)" and 
X="F \<union> R11 \<union> (R21 \<union> (F \<union> R11\<union>   Rijj))" and Y="F \<union> (R11 \<union> Rijj \<union> R21)" in subsetSimp)
apply (rule_tac Y="Fo" and X="F \<union> R11" and 
A="R21 \<union> Ro" and B="R21 \<union> (F \<union> R11 \<union> Rijj)" in monot_union)
apply assumption 
apply (rule_tac Y="R21" and X="R21" and 
A="Ro" and B="F \<union> R11 \<union> Rijj" in monot_union)
apply (simp (no_asm))
apply assumption
apply fast
apply (simp (no_asm))
apply simp

apply (rule impI)
apply (rotate_tac 35)
apply (drule mp)
apply (drule_tac G'=G'' and G=G and U=Uii and i=2 and p=True in coherent_CR)
apply simp
apply (rule_tac E=E and x=x and r=ro and p=True and U=U''ii and i=2 in CR_updEnv)
apply (rule_tac E="E" and h=h and p=True and U="U''ii" 
and i=2 and hh=ho and G="G''" and R=R22 and M="F \<union> R11" in CR_nonmodify)
apply assumption
apply simp
apply (rule_tac X=R22 and A=F and B=R11 in inter_union2_empty)
apply (rule_tac A=F and B=R22 in inter_sym_empty)
apply assumption
apply (rule_tac  A=R22 and X=Ri and Y=R11 in inter_subset_empty)
apply (rule_tac A=Ri and B=R22 in inter_sym_empty)
apply simp
apply fast
apply assumption

apply assumption
done



lemma  UA1_Letr_aux_1:
"\<lbrakk>UAsnPre Q X E h;
  fst Q = fst Q' \<union> scnd Q' \<union> (fst Q'' - {x});
  scnd Q = scnd Q'';
  thrd Q = thrd Q' - (fst Q'' \<union> scnd Q'') \<union> thrd Q'';
  fst Q' \<inter> scnd Q' = {};

  fst Q' \<inter> fst Q'' = {};
  fst Q' \<inter> scnd Q'' = {};
  fst Q' \<inter> thrd Q'' = {};

  scnd Q' \<inter> fst Q'' = {};

  coherent (fst Q')  (frth Q) (frth Q');
  coherent (scnd Q') (frth Q) (frth Q');
  coherent (thrd Q') (frth Q) (frth Q');

  x \<notin> fst Q';  x \<notin> scnd Q';  x \<notin> thrd Q';
  x \<in> fst Q''; x \<notin> scnd Q'';  x \<notin> thrd Q''\<rbrakk> \<Longrightarrow>
          \<exists>Y. UAsnPre Q' Y E h "
apply (unfold UAsnPre_def)
apply (erule conjE)+
apply (drule_tac A="Scnd X" and B="Thrd X" and C="Frth X" in interUnionReverse_empty)
apply (drule_tac A="Scnd X" and B="Thrd X" and C="Frth X" and X="fst X" in inter_union3Reverse_empty)
apply (erule conjE)+
apply (drule_tac Ui="fst Q" and Uii="scnd Q" and Uiii="thrd Q" and G="frth Q" and
       U'i="fst Q'" and U'ii="scnd Q'" and U'iii="thrd Q'" and
       U''i="fst Q''" and U''ii="scnd Q''" and U''iii="thrd Q''" and F="fst X" in   UA1_Letr_Pre1_aux)
apply assumption+
apply (erule exE conjE)+
apply (rule_tac x="(fst X, R11, Rijj, R131 \<union> R132 \<union> R133)" in exI)

(*apply (rule conjI)*)
apply (rule conjI, simp)

apply (rule conjI) 
apply (simp add: Scnd_def)

apply (rule conjI) 
apply (rule_tac U="scnd Q'" and E=E and G="frth Q'" and j=2 and i=1 in rise_CR)
apply (simp add: Thrd_def)
apply (simp (no_asm))

apply (rule conjI) 
apply (simp add: Frth_def)

apply (rule conjI) apply (simp (no_asm) add: Scnd_def Thrd_def Frth_def)
apply (rule_tac X=R11 and A=Rijj and B="R131 \<union> R132 \<union> R133" in inter_union_empty)
apply assumption+

apply (simp (no_asm) add: Scnd_def Thrd_def Frth_def)
apply (rule_tac X="fst X" and A=R11 and B=Rijj and C="R131 \<union> R132 \<union> R133" in inter_union3_empty)
apply assumption+

(*apply (rule conjI)
apply (simp (no_asm))

apply (simp add: Thrd_def)*)
done




lemma  UA1_Letr_aux_2:
"\<lbrakk>
  UAsnPre Q X E h;

  fst Q = fst Q' \<union> scnd Q' \<union> (fst Q'' - {x});
  scnd Q = scnd Q'';
  thrd Q = thrd Q' - (fst Q'' \<union> scnd Q'') \<union> thrd Q'';
  fst Q' \<inter> scnd Q' = {};

  fst Q' \<inter> fst Q'' = {};
  fst Q' \<inter> scnd Q'' = {};
  fst Q' \<inter> thrd Q'' = {};

  scnd Q' \<inter> fst Q'' = {};

  coherent (fst Q')  (frth Q) (frth Q');
  coherent (scnd Q') (frth Q) (frth Q');
  coherent (thrd Q') (frth Q) (frth Q');

  x \<notin> fst Q';  x \<notin> scnd Q';  x \<notin> thrd Q';
  x \<in> fst Q''; x \<notin> scnd Q''; x \<notin> thrd Q'';
  
  GETr (frth Q'') x = Some (ffth Q');

  \<forall> Y. UAsnPre Q' Y E h \<longrightarrow> UAsnPost Q' Y E h ho (RVal r) pi;
 
  coherent (fst Q'' -{x})  (frth Q) (frth Q'');
  coherent (scnd Q'') (frth Q) (frth Q'');
  coherent (thrd Q'') (frth Q) (frth Q'')
  \<rbrakk> \<Longrightarrow>
          \<exists>Z. UAsnPre Q'' Z E\<lfloor>x:=r\<rfloor> ho"
apply (unfold UAsnPre_def)
apply (erule conjE exE)+
apply (frule_tac A="Scnd X" and B="Thrd X" and C="Frth X" in interUnionReverse_empty)
apply (frule_tac X="fst X" and A="Scnd X" and B="Thrd X" and C="Frth X" in inter_union3Reverse_empty)
apply (erule conjE)+
apply (frule_tac Ui="fst Q" and Uii="scnd Q" and Uiii="thrd Q" and G="frth Q" and
       U'i="fst Q'" and U'ii="scnd Q'" and U'iii="thrd Q'" and
       U''i="fst Q''" and U''ii="scnd Q''" and U''iii="thrd Q''" 
       and G'="frth Q'"
       and Ri="Scnd X" and Rii="Thrd X" and Riii="Frth X" 
       in UA1_Letr_Pre1_aux)
apply assumption+
apply (erule exE conjE)+
apply (erule_tac x="(fst X, R11, Rijj,  R131 \<union> R132 \<union> R133)" in allE)
apply (drule mp) 

apply (rule conjI) apply (simp (no_asm))

apply (rule conjI) apply (simp add: Scnd_def)

apply (rule conjI) apply (simp (no_asm) add: Thrd_def)
apply (rule_tac U="scnd Q'" and j=2 and i=1 in rise_CR)
apply assumption
apply (simp (no_asm))

apply (rule conjI) apply (simp add: Frth_def)

apply (rule conjI) apply (simp (no_asm) add: Scnd_def Thrd_def Frth_def)
apply (rule_tac X=R11 and A=Rijj and B="R131 \<union> R132 \<union> R133" in inter_union_empty)
apply assumption+

apply (simp (no_asm) add: Scnd_def Thrd_def Frth_def)
apply (rule_tac X="fst X" and A=R11 and B=Rijj and C="R131 \<union> R132 \<union> R133" in inter_union3_empty)
apply assumption+

apply (unfold UAsnPost_def)
apply (erule conjE exE)+
apply (frule_tac Ui="fst Q" and Uii="scnd Q" and Uiii="thrd Q" and G="frth Q" and
       U'i="fst Q'" and U'ii="scnd Q'" and U'iii="thrd Q'" and
       U''i="fst Q''" and U''ii="scnd Q''" and U''iii="thrd Q''" 
       and G'="frth Q'"
       and G''="frth Q''" and hi=ho and r=r and R'=R' and FF=FF 
       and Ri="Scnd X" and Rii="Thrd X" and Riii="Frth X" 
       and Rijj="Rijj" 
       in UA1_Letr_Pre2_aux)
apply assumption+
apply simp
apply (simp add: Thrd_def)  
apply (simp add: Scnd_def)  
apply (simp add: Scnd_def Thrd_def) 
apply assumption+

apply (erule conjE)+
apply (rule_tac x="(FF, R21 \<union> R', R22, R23)" in exI)

apply (rule conjI, simp (no_asm))

apply (rule conjI, simp add: Scnd_def) 
apply (rule conjI, simp add: Thrd_def) 
apply (rule conjI, simp add: Frth_def)
 
apply (rule conjI) apply (simp (no_asm) add: Scnd_def Thrd_def Frth_def)

apply (simp (no_asm) add: Scnd_def Thrd_def Frth_def)
apply (drule_tac P="FF \<subseteq> fst X \<union> R11" in mp)
apply (simp (no_asm_use) add: Scnd_def Thrd_def Frth_def)
apply assumption
done


lemma  UA1_Letr_aux_3:
"\<lbrakk>
  UAsnPre Q X E h;

  fst Q = fst Q' \<union> scnd Q' \<union> (fst Q'' - {x});
  scnd Q = scnd Q'';
  thrd Q = thrd Q' - (fst Q'' \<union> scnd Q'') \<union> thrd Q'';
  fst Q' \<inter> scnd Q' = {};

  fst Q' \<inter> fst Q'' = {};
  fst Q' \<inter> scnd Q'' = {};
  fst Q' \<inter> thrd Q'' = {};

  scnd Q' \<inter> fst Q'' = {};

  coherent (fst Q')  (frth Q) (frth Q');
  coherent (scnd Q') (frth Q) (frth Q');
  coherent (thrd Q') (frth Q) (frth Q');

  x \<notin> fst Q';  x \<notin> scnd Q';  x \<notin> thrd Q';
  x \<in> fst Q''; x \<notin> scnd Q''; x \<notin> thrd Q'';
  
  GETr (frth Q'') x = Some (ffth Q');

  \<forall> Y. UAsnPre Q' Y E h \<longrightarrow> UAsnPost Q' Y E h ho (RVal ro) po;
 
  coherent (fst Q'' -{x})  (frth Q) (frth Q'');
  coherent (scnd Q'') (frth Q) (frth Q'');
  coherent (thrd Q'') (frth Q) (frth Q'');
  
   \<forall> Z. UAsnPre Q'' Z E\<lfloor>x:=ro\<rfloor> ho \<longrightarrow> UAsnPost Q'' Z E\<lfloor>x:=ro\<rfloor> ho h' v poo;

  ffth Q=T;
  ffth Q''=T

  \<rbrakk> \<Longrightarrow>
          UAsnPost Q X E h h' v p"
apply (unfold UAsnPre_def)
apply (erule conjE exE)+
apply (frule_tac A="Scnd X" and B="Thrd X" and C="Frth X" in interUnionReverse_empty)
apply (frule_tac X="fst X" and A="Scnd X" and B="Thrd X" and C="Frth X" in inter_union3Reverse_empty)
apply (erule conjE)+
apply (frule_tac Ui="fst Q" and Uii="scnd Q" and Uiii="thrd Q" and G="frth Q" and
       U'i="fst Q'" and U'ii="scnd Q'" and U'iii="thrd Q'" and
       U''i="fst Q''" and U''ii="scnd Q''" and U''iii="thrd Q''" 
       and G'="frth Q'"
       and Ri="Scnd X" and Rii="Thrd X" and Riii="Frth X" 
       in UA1_Letr_Pre1_aux)
apply assumption+
apply (erule exE conjE)+
apply (erule_tac x="(fst X, R11, Rijj,  R131 \<union> R132 \<union> R133)" in allE)
apply (drule mp) 

apply (rule conjI) apply (simp (no_asm))

apply (rule conjI) apply (simp add: Scnd_def)

apply (rule conjI) apply (simp (no_asm) add: Thrd_def)
apply (rule_tac U="scnd Q'" and j=2 and i=1 in rise_CR)
apply assumption
apply (simp (no_asm))

apply (rule conjI) apply (simp add: Frth_def)

apply (rule conjI) apply (simp (no_asm) add: Scnd_def Thrd_def Frth_def)
apply (rule_tac X=R11 and A=Rijj and B="R131 \<union> R132 \<union> R133" in inter_union_empty)
apply assumption+

apply (simp (no_asm) add: Scnd_def Thrd_def Frth_def)
apply (rule_tac X="fst X" and A=R11 and B=Rijj and C="R131 \<union> R132 \<union> R133" in inter_union3_empty)
apply assumption+

apply (unfold UAsnPost_def)
apply (erule conjE exE)+
apply (frule_tac Ui="fst Q" and Uii="scnd Q" and Uiii="thrd Q" and G="frth Q" and
       U'i="fst Q'" and U'ii="scnd Q'" and U'iii="thrd Q'" and
       U''i="fst Q''" and U''ii="scnd Q''" and U''iii="thrd Q''" 
       and G'="frth Q'"
       and G''="frth Q''" and hi=ho and r=ro and R'=R' and FF=FF 
       and Ri="Scnd X" and Rii="Thrd X" and Riii="Frth X" 
       and Rijj="Rijj" 
       in UA1_Letr_Pre2_aux)
apply assumption+
apply simp
apply (simp add: Thrd_def)  
apply (simp add: Scnd_def)  
apply (simp add: Scnd_def Thrd_def) 
apply assumption+

apply (erule conjE)+
apply (erule_tac x="(FF, R21 \<union> R', R22, R23)" in allE)

apply (rotate_tac 70)
apply (drule mp)
apply (rule conjI, simp (no_asm))

apply (rule conjI, simp add: Scnd_def) 
apply (rule conjI, simp add: Thrd_def) 
apply (rule conjI, simp add: Frth_def)
 
apply (rule conjI) apply (simp (no_asm) add: Scnd_def Thrd_def Frth_def)

apply (simp (no_asm) add: Scnd_def Thrd_def Frth_def)
apply (drule_tac P="FF \<subseteq> fst X \<union> R11" in mp)
apply (simp (no_asm_use) add: Scnd_def Thrd_def Frth_def)
apply assumption

apply (erule conjE exE)+
apply(rename_tac R'res FFres)

apply (rule_tac x=R'res in exI)
apply (rule_tac x=FFres in exI)

apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: Scnd_def)
apply (rule conjI, assumption) 

apply (drule_tac F="fst X" and Ri="Scnd X" and Rii="Thrd X" and Riii="Frth X"
and R'=R'res and F'=FFres and
Ui="fst Q" and Uii="scnd Q" and Uiii="thrd Q" and G="frth Q" and
       U'i="fst Q'" and U'ii="scnd Q'" and U'iii="thrd Q'" and
       U''i="fst Q''" and U''ii="scnd Q''" and U''iii="thrd Q''"
       and G''="frth Q''" and ho=ho and Fo=FF and Ro=R'  and ro=ro and T="T"
in UA1_Letr_Post_aux)
apply assumption+
apply (simp add: Scnd_def)
apply assumption
apply (simp add: Scnd_def)
apply (simp add: Scnd_def Thrd_def)
apply (simp add: Thrd_def) 
apply (simp add: Scnd_def)
apply assumption
apply (simp add: Scnd_def)
apply (simp add: Scnd_def Thrd_def)
apply assumption+

apply (drule_tac P=" FF \<subseteq> fst X \<union> R11" in mp)
apply (simp add: Scnd_def)
apply (rule_tac A=FF and Y="R21\<union> R'" and X="R21 \<union> R' \<union> R22 \<union> R23" in inter_subset_empty)
apply assumption
apply fast
(**)
apply (drule_tac P=" FF \<subseteq> fst X \<union> R11" in mp)
apply (simp add: Scnd_def)
apply (rule_tac A=FF and Y="R22" and X="R21 \<union> R' \<union> R22 \<union> R23" in inter_subset_empty)
apply assumption
apply fast
(**)
apply (drule_tac P=" FF \<subseteq> fst X \<union> R11" in mp)
apply (simp add: Scnd_def)
apply (rule_tac A=FF and Y="R23" and X="R21 \<union> R' \<union> R22 \<union> R23" in inter_subset_empty)
apply assumption
apply fast

apply (rule_tac h=ho and h'=h in same_oh)
apply simp

apply simp
done

lemma UA1_Letr_11_coherent':
     "\<lbrakk>DOM (frth Q') =(fst Q' \<union> scnd Q' \<union> thrd Q');
       context_sum (frth Q') G  (frth Q)\<rbrakk> \<Longrightarrow>
coherent (fst Q') (frth Q') (frth Q)"
apply (rule_tac U="fst Q'" and G="frth Q" in context_sum_coherent_left)
apply assumption
apply fast
done

lemma UA1_Letr_11_coherent:
     "\<lbrakk>DOM (frth Q') =(fst Q' \<union> scnd Q' \<union> thrd Q');
       context_sum (frth Q') G  (frth Q)\<rbrakk> \<Longrightarrow>
coherent (fst Q') (frth Q) (frth Q')"
apply (rule_tac U="fst Q'" and G="frth Q'" and G'="frth Q" in coherent_sym)
apply (rule_tac Q=Q and Q'=Q' in UA1_Letr_11_coherent')
apply assumption+
done


lemma UA1_Letr_12_coherent':
     "\<lbrakk>DOM (frth Q') =(fst Q' \<union> scnd Q' \<union> thrd Q');
       context_sum (frth Q') G  (frth Q)\<rbrakk> \<Longrightarrow>
coherent (scnd Q') (frth Q') (frth Q)"
apply (rule_tac U="scnd Q'" and G="frth Q" in context_sum_coherent_left)
apply assumption
apply fast
done

lemma UA1_Letr_12_coherent:
     "\<lbrakk>DOM (frth Q') =(fst Q' \<union> scnd Q' \<union> thrd Q');
       context_sum (frth Q') G  (frth Q)\<rbrakk> \<Longrightarrow>
coherent (scnd Q') (frth Q) (frth Q')"
apply (rule_tac U="scnd Q'" and G="frth Q'" and G'="frth Q" in coherent_sym)
apply (rule_tac Q=Q and Q'=Q' in UA1_Letr_12_coherent')
apply assumption+
done

lemma UA1_Letr_13_coherent':
     "\<lbrakk>DOM (frth Q') =(fst Q' \<union> scnd Q' \<union> thrd Q');
       context_sum (frth Q') G  (frth Q)\<rbrakk> \<Longrightarrow>
coherent (thrd Q') (frth Q') (frth Q)"
apply (rule_tac U="thrd Q'" and G="frth Q" in context_sum_coherent_left)
apply assumption
apply fast
done

lemma UA1_Letr_13_coherent:
     "\<lbrakk>DOM (frth Q') =(fst Q' \<union> scnd Q' \<union> thrd Q');
       context_sum (frth Q') G  (frth Q)\<rbrakk> \<Longrightarrow>
coherent (thrd Q') (frth Q) (frth Q')"
apply (rule_tac U="thrd Q'" and G="frth Q'" and G'="frth Q" in coherent_sym)
apply (rule_tac Q=Q and Q'=Q' in UA1_Letr_13_coherent')
apply assumption+
done


lemma UA1_Letr_21_coherent':
     "\<lbrakk> DOM (frth Q'') =(fst Q'' \<union> scnd Q'' \<union> thrd Q'');
       x \<in> fst Q'';
       context_minus_var (frth Q'') x G;
       context_sum (frth Q') G  (frth Q)\<rbrakk> \<Longrightarrow>
coherent (fst Q'' -{x}) (frth Q'') (frth Q)"
apply (frule_tac G="frth Q''" and G'=G and x=x in context_minus_var_DOM)
apply (rule_tac U="fst Q''-{x}" and G="frth Q''" and G'=G and G''="frth Q" in coherent_trans)
apply (rule_tac U="fst Q''-{x}" and G="frth Q''" and G'=G and x=x in context_minus_var_coherent)
apply assumption
apply fast
apply (rule_tac U="fst Q''-{x}" and G="frth Q" in context_sum_coherent_right)
apply assumption
apply fast
done

lemma UA1_Letr_21_coherent:
     "\<lbrakk>DOM (frth Q'') =(fst Q'' \<union> scnd Q'' \<union> thrd Q'');
       x \<in> fst Q'';
       context_minus_var (frth Q'') x G;
       context_sum (frth Q') G  (frth Q)\<rbrakk> \<Longrightarrow>
coherent (fst Q''-{x}) (frth Q) (frth Q'')"
apply (rule_tac U="fst Q''-{x}" and G="frth Q''" and G'="frth Q" in coherent_sym)
apply (rule_tac Q=Q and Q'=Q' in UA1_Letr_21_coherent')
apply assumption+
done


lemma UA1_Letr_22_coherent':
     "\<lbrakk> DOM (frth Q'') =(fst Q'' \<union> scnd Q'' \<union> thrd Q'');
       x \<in> fst Q''; fst Q'' \<inter> scnd Q''={};  
       context_minus_var (frth Q'') x G;
       context_sum (frth Q') G  (frth Q)\<rbrakk> \<Longrightarrow>
coherent (scnd Q'') (frth Q'') (frth Q)"
apply (frule_tac G="frth Q''" and G'=G and x=x in context_minus_var_DOM)
apply (rule_tac U="scnd Q''" and G="frth Q''" and G'=G and G''="frth Q" in coherent_trans)
apply (rule_tac U="scnd Q''" and G="frth Q''" and G'=G and x=x in context_minus_var_coherent)
apply assumption
apply fast
apply (rule_tac U="scnd Q''" and G="frth Q" in context_sum_coherent_right)
apply assumption
apply fast
done

lemma UA1_Letr_22_coherent:
     "\<lbrakk>DOM (frth Q'') =(fst Q'' \<union> scnd Q'' \<union> thrd Q'');
       x \<in> fst Q''; fst Q'' \<inter> scnd Q''={};
       context_minus_var (frth Q'') x G;
       context_sum (frth Q') G  (frth Q)\<rbrakk> \<Longrightarrow>
coherent (scnd Q'') (frth Q) (frth Q'')"
apply (rule_tac U="scnd Q''" and G="frth Q''" and G'="frth Q" in coherent_sym)
apply (rule_tac Q=Q and Q'=Q' and x=x in UA1_Letr_22_coherent')
apply assumption+
done

lemma UA1_Letr_23_coherent':
     "\<lbrakk> DOM (frth Q'') =(fst Q'' \<union> scnd Q'' \<union> thrd Q'');
       x \<in> fst Q''; fst Q'' \<inter> thrd Q''={}; 
       context_minus_var (frth Q'') x G;
       context_sum (frth Q') G  (frth Q)\<rbrakk> \<Longrightarrow>
coherent (thrd Q'') (frth Q'') (frth Q)"
apply (frule_tac G="frth Q''" and G'=G and x=x in context_minus_var_DOM)
apply (rule_tac U="thrd Q''" and G="frth Q''" and G'=G and G''="frth Q" in coherent_trans)
apply (rule_tac U="thrd Q''" and G="frth Q''" and G'=G and x=x in context_minus_var_coherent)
apply assumption
apply fast
apply (rule_tac U="thrd Q''" and G="frth Q" in context_sum_coherent_right)
apply assumption
apply fast
done

lemma UA1_Letr_23_coherent:
     "\<lbrakk> DOM (frth Q'') =(fst Q'' \<union> scnd Q'' \<union> thrd Q'');
       x \<in> fst Q''; fst Q'' \<inter> thrd Q''={}; 
       context_minus_var (frth Q'') x G;
       context_sum (frth Q') G  (frth Q)\<rbrakk> \<Longrightarrow>
coherent (thrd Q'') (frth Q) (frth Q'')"
apply (rule_tac U="thrd Q''" and G="frth Q''" and G'="frth Q" in coherent_sym)
apply (rule_tac Q=Q and Q'=Q' and x=x in UA1_Letr_23_coherent')
apply assumption+
done

lemma inter_empty_ne:
"\<lbrakk>A\<inter>B={}; x\<in>A\<rbrakk> \<Longrightarrow> x \<notin> B"
apply fast
done

lemma union_empty_ne:
"\<lbrakk>X=A \<union> B \<union> C; x \<notin> X\<rbrakk> \<Longrightarrow> x \<notin> A \<and> x \<notin> B \<and> x \<notin> C"
apply fast
done

lemma UA1_Letr1:
"\<forall>E h X. UAsnPre Q X E h \<longrightarrow>
               DOM (frth Q') = fst Q' \<union> scnd Q' \<union> thrd Q' \<and>
               DOM (frth Q'') = fst Q'' \<union> scnd Q'' \<union> thrd Q'' \<and>
               fst Q' \<inter> scnd Q' = {} \<and>
               fst Q' \<inter> thrd Q' = {} \<and>
               scnd Q' \<inter> thrd Q' = {} \<and>
               fst Q'' \<inter> scnd Q'' = {} \<and>
               fst Q'' \<inter> thrd Q'' = {} \<and>
               scnd Q'' \<inter> thrd Q'' = {} \<and>
               x \<in> fst Q'' \<and> x \<notin> DOM (frth Q')\<and>
               fst Q = fst Q' \<union> scnd Q' \<union> (fst Q'' - {x}) \<and>
               scnd Q = scnd Q'' \<and>
               thrd Q = thrd Q' - (fst Q'' \<union> scnd Q'') \<union> thrd Q'' \<and>
               fst Q' \<inter> (fst Q'' \<union> scnd Q'' \<union> thrd Q'') = {} \<and>
               scnd Q' \<inter> (fst Q'' \<union> scnd Q'' \<union> thrd Q'') = {} \<and>
               context_minus_var (frth Q'') x G \<and>
               context_sum (frth Q') G (frth Q) \<and> GETr (frth Q'') x = Some (ffth Q') \<and> 
               ffth Q = ffth Q'' \<longrightarrow>
               (\<exists>Xi. UAsnPre Q' Xi E h)"
apply (rule allI impI)+
apply (erule conjE)+
apply (drule_tac X="fst Q'" and A="fst Q''" and B="scnd Q''" and C="thrd Q''" in inter_union3Reverse_empty)
apply (drule_tac X="scnd Q'" and A="fst Q''" and B="scnd Q''" and C="thrd Q''" in inter_union3Reverse_empty)
apply (frule_tac A="fst Q'" and B="scnd Q'" and C="thrd Q'" and X="DOM (frth Q')" and x=x in union_empty_ne)
apply assumption
apply (erule conjE)+
apply (rule_tac Q=Q and Q'=Q' and Q''=Q'' and X=X and E=E and h=h and x=x in  UA1_Letr_aux_1)
apply assumption+

apply (rule_tac Q=Q and Q'=Q' and G=G in UA1_Letr_11_coherent) 
apply assumption+ 

apply (rule_tac Q=Q and Q'=Q' and G=G in UA1_Letr_12_coherent) 
apply assumption+ 

apply (rule_tac Q=Q and Q'=Q' and G=G in UA1_Letr_13_coherent) 
apply assumption+ 


apply (rule_tac A="fst Q''" and B="scnd Q''" in inter_empty_ne)
apply assumption+

apply (rule_tac A="fst Q''" and B="thrd Q''" in inter_empty_ne)
apply assumption+
done

lemma UA1_Letr2:
"\<forall>E h hi r pi X. UAsnPre Q X E h \<longrightarrow>
               DOM (frth Q') = fst Q' \<union> scnd Q' \<union> thrd Q' \<and>
               DOM (frth Q'') = fst Q'' \<union> scnd Q'' \<union> thrd Q'' \<and>
               fst Q' \<inter> scnd Q' = {} \<and>
               fst Q' \<inter> thrd Q' = {} \<and>
               scnd Q' \<inter> thrd Q' = {} \<and>
               fst Q'' \<inter> scnd Q'' = {} \<and>
               fst Q'' \<inter> thrd Q'' = {} \<and>
               scnd Q'' \<inter> thrd Q'' = {} \<and>
               x \<in> fst Q'' \<and> x \<notin> DOM (frth Q')\<and>
               fst Q = fst Q' \<union> scnd Q' \<union> (fst Q'' - {x}) \<and>
               scnd Q = scnd Q'' \<and>
               thrd Q = thrd Q' - (fst Q'' \<union> scnd Q'') \<union> thrd Q'' \<and>
               fst Q' \<inter> (fst Q'' \<union> scnd Q'' \<union> thrd Q'') = {} \<and>
               scnd Q' \<inter> (fst Q'' \<union> scnd Q'' \<union> thrd Q'') = {} \<and>
               context_minus_var (frth Q'') x G \<and>
               context_sum (frth Q') G (frth Q) \<and> GETr (frth Q'') x = Some (ffth Q') \<and> 
               ffth Q = ffth Q'' \<longrightarrow>
(\<forall>Xi. UAsnPre Q' Xi E h \<longrightarrow> UAsnPost Q' Xi E h hi (RVal r) pi) \<longrightarrow> (\<exists>Xii. UAsnPre Q'' Xii E\<lfloor>x:=r\<rfloor> hi)"
apply (rule allI impI)+
apply (erule conjE)+
apply (drule_tac X="fst Q'" and A="fst Q''" and B="scnd Q''" and C="thrd Q''" in inter_union3Reverse_empty)
apply (drule_tac X="scnd Q'" and A="fst Q''" and B="scnd Q''" and C="thrd Q''" in inter_union3Reverse_empty)
apply (frule_tac A="fst Q'" and B="scnd Q'" and C="thrd Q'" and X="DOM (frth Q')" and x=x in union_empty_ne)
apply assumption
apply (erule conjE)+
apply (rule_tac Q=Q and Q'=Q' and Q''=Q'' and X=X and E=E and h=h and x=x in  UA1_Letr_aux_2)
apply assumption+

apply (rule_tac Q=Q and Q'=Q' and G=G in UA1_Letr_11_coherent) 
apply assumption+ 
apply (rule_tac Q=Q and Q'=Q' and G=G in UA1_Letr_12_coherent) 
apply assumption+

apply (rule_tac Q=Q and Q'=Q' and G=G in UA1_Letr_13_coherent) 
apply assumption+ 

apply (rule_tac A="fst Q''" and B="scnd Q''" in inter_empty_ne)
apply assumption+

apply (rule_tac A="fst Q''" and B="thrd Q''" in inter_empty_ne)
apply assumption+

apply (rule_tac Q=Q and Q'=Q' and Q''=Q'' and G=G and x=x in UA1_Letr_21_coherent) 
apply assumption+ 

apply (drule_tac Q=Q and Q'=Q' and G=G and Q''=Q'' in UA1_Letr_22_coherent) 
apply assumption+ 

apply (drule_tac Q=Q and Q'=Q' and G=G and Q''=Q'' in UA1_Letr_23_coherent) 
apply assumption+
done

lemma UA1_Letr3:
"\<forall>E h  hi r pi h' v pii p X. UAsnPre Q X E h \<longrightarrow>
               DOM (frth Q') = fst Q' \<union> scnd Q' \<union> thrd Q' \<and>
               DOM (frth Q'') = fst Q'' \<union> scnd Q'' \<union> thrd Q'' \<and>
               fst Q' \<inter> scnd Q' = {} \<and>
               fst Q' \<inter> thrd Q' = {} \<and>
               scnd Q' \<inter> thrd Q' = {} \<and>
               fst Q'' \<inter> scnd Q'' = {} \<and>
               fst Q'' \<inter> thrd Q'' = {} \<and>
               scnd Q'' \<inter> thrd Q'' = {} \<and>
               x \<in> fst Q'' \<and> x \<notin> DOM (frth Q')\<and>
               fst Q = fst Q' \<union> scnd Q' \<union> (fst Q'' - {x}) \<and>
               scnd Q = scnd Q'' \<and>
               thrd Q = thrd Q' - (fst Q'' \<union> scnd Q'') \<union> thrd Q'' \<and>
               fst Q' \<inter> (fst Q'' \<union> scnd Q'' \<union> thrd Q'') = {} \<and>
               scnd Q' \<inter> (fst Q'' \<union> scnd Q'' \<union> thrd Q'') = {} \<and>
               context_minus_var (frth Q'') x G \<and>
               context_sum (frth Q') G (frth Q) \<and> GETr (frth Q'') x = Some (ffth Q') \<and> 
               ffth Q = ffth Q''  \<longrightarrow>
(\<forall>Xi. UAsnPre Q' Xi E h \<longrightarrow> UAsnPost Q' Xi E h hi (RVal r) pi) \<longrightarrow>
          (\<forall>Xii. UAsnPre Q'' Xii E\<lfloor>x:=r\<rfloor> hi \<longrightarrow> UAsnPost Q'' Xii E\<lfloor>x:=r\<rfloor> hi h' v pii) \<longrightarrow> UAsnPost Q X E h h' v p"
apply (rule allI impI)+
apply (erule conjE)+
apply (drule_tac X="fst Q'" and A="fst Q''" and B="scnd Q''" and C="thrd Q''" in inter_union3Reverse_empty)
apply (drule_tac X="scnd Q'" and A="fst Q''" and B="scnd Q''" and C="thrd Q''" in inter_union3Reverse_empty)
apply (frule_tac A="fst Q'" and B="scnd Q'" and C="thrd Q'" and X="DOM (frth Q')" and x=x in union_empty_ne)
apply assumption
apply (erule conjE)+
apply (rule_tac Q=Q and Q'=Q' and Q''=Q'' and X=X and E=E and h=h and x=x 
and h'=h' and ho=hi and ro=r and v=v and T="ffth Q''" in  UA1_Letr_aux_3)
apply assumption+

apply (rule_tac Q=Q and Q'=Q' and G=G in UA1_Letr_11_coherent) 
apply assumption+ 

apply (rule_tac Q=Q and Q'=Q' and G=G in UA1_Letr_12_coherent) 
apply assumption+

apply (rule_tac Q=Q and Q'=Q' and G=G in UA1_Letr_13_coherent) 
apply assumption+

apply (rule_tac A="fst Q''" and B="scnd Q''" in inter_empty_ne)
apply assumption+

apply (rule_tac A="fst Q''" and B="thrd Q''" in inter_empty_ne)
apply assumption+

apply (rule_tac Q=Q and Q'=Q' and Q''=Q'' and G=G and x=x in UA1_Letr_21_coherent) 
apply assumption+ 

apply (rule_tac Q=Q and Q'=Q' and G=G and Q''=Q'' in UA1_Letr_22_coherent) 
apply assumption+

apply (rule_tac Q=Q and Q'=Q' and G=G and Q''=Q'' in UA1_Letr_23_coherent) 
apply assumption+
apply (simp (no_asm))
done

lemma UA1_Letr_aux:
     "\<lbrakk> \<rhd> e :  ((UAsnPre Q') \<Rightarrow>  (UAsnPost Q'));
        \<rhd> ee : ((UAsnPre Q'') \<Rightarrow>  (UAsnPost Q''));
        DOM (frth Q') = fst Q' \<union> scnd Q' \<union> thrd Q' \<and>
               DOM (frth Q'') = fst Q'' \<union> scnd Q'' \<union> thrd Q'' \<and>
               fst Q' \<inter> scnd Q' = {} \<and>
               fst Q' \<inter> thrd Q' = {} \<and>
               scnd Q' \<inter> thrd Q' = {} \<and>
               fst Q'' \<inter> scnd Q'' = {} \<and>
               fst Q'' \<inter> thrd Q'' = {} \<and>
               scnd Q'' \<inter> thrd Q'' = {} \<and>
               x \<in> fst Q'' \<and> x \<notin> DOM (frth Q')\<and>
               fst Q = fst Q' \<union> scnd Q' \<union> (fst Q'' - {x}) \<and>
               scnd Q = scnd Q'' \<and>
               thrd Q = thrd Q' - (fst Q'' \<union> scnd Q'') \<union> thrd Q'' \<and>
               fst Q' \<inter> (fst Q'' \<union> scnd Q'' \<union> thrd Q'') = {} \<and>
               scnd Q' \<inter> (fst Q'' \<union> scnd Q'' \<union> thrd Q'') = {} \<and>
               context_minus_var (frth Q'') x G \<and>
               context_sum (frth Q') G (frth Q) \<and> GETr (frth Q'') x = Some (ffth Q') \<and> 
               ffth Q = ffth Q'' \<rbrakk>
     \<Longrightarrow> \<rhd> (LET rf x = e IN ee END):  ((UAsnPre Q) \<Rightarrow>  (UAsnPost Q))"
apply (rule_tac Qi=Q' and Qii=Q'' and Q=Q in let_decent)
apply assumption
apply assumption
apply (rotate_tac 2) apply assumption
apply (rule_tac Q=Q and Q'=Q' and Q''=Q'' in UA1_Letr1)
apply (rule_tac Q=Q and Q'=Q' and Q''=Q'' in UA1_Letr2)
apply (rule_tac Q=Q and Q'=Q' and Q''=Q'' in UA1_Letr3)
done



lemma str_class: 
" \<rhd> e :  (UAsnPre (U1, U2, U3, G, T) \<Rightarrow>  UAsnPost (U1, U2, U3, G, T)) 
\<Longrightarrow> \<rhd> e : (UAsnClassic  U1  U2  U3 G T )"
apply (rule vdm_conseq)
apply assumption
apply (rule allI impI)+
apply (rule StructuredClassic)
apply assumption
done

lemma class_str: 
"\<rhd> e : (UAsnClassic  U1  U2  U3 G T ) \<Longrightarrow> \<rhd> e :  (UAsnPre (U1, U2, U3, G, T) \<Rightarrow>  UAsnPost (U1, U2, U3, G, T)) "
apply (rule vdm_conseq)
apply assumption
apply (rule allI impI)+
apply (rule ClassicStructured)
apply assumption
done

lemma UA1_Letr':
     "\<lbrakk> \<rhd> e : UAsnClassic  U'i  U'ii  U'iii G' T'  ;
        \<rhd> ee : UAsnClassic  U''i  U''ii  U''iii G'' T;
        DOM G' = U'i  \<union> U'ii \<union>   U'iii;
        DOM G'' = U''i  \<union> U''ii \<union>   U''iii;
        U'i \<inter> U'ii = {};
        U'i \<inter> U'iii = {};
        U'ii \<inter> U'iii = {};
        U''i \<inter> U''ii = {};
        U''i \<inter> U''iii = {};
        U''ii \<inter> U''iii = {};
        x \<in> U''i; x\<notin> DOM G';
        Ui=U'i \<union> U'ii \<union>  (U''i -{x});
        Uii=U''ii;
        Uiii=U'iii -(U''i \<union> U''ii) \<union> U''iii;
        U'i \<inter> ( U''i  \<union> U''ii \<union>   U''iii) ={};
        U'ii \<inter> ( U''i  \<union> U''ii \<union>   U''iii) ={};
        context_minus_var G'' x Gi;
        context_sum G' Gi G;
        GETr G'' x = Some T'\<rbrakk>
     \<Longrightarrow> \<rhd> (LET rf x = e IN ee END):  UAsnClassic Ui  Uii  Uiii G T"
apply (rule str_class)
apply (drule_tac e=e in class_str)
apply (drule_tac e=ee in class_str)
apply (rule_tac Q="(Ui, Uii, Uiii, G, T)" and Q'="(U'i, U'ii, U'iii, G', T')" and
 Q''="(U''i, U''ii, U''iii, G'', T)" and G=Gi in UA1_Letr_aux)
apply assumption+

apply (rule conjI) apply (simp (no_asm) add: scnd_def thrd_def frth_def)
apply (rule conjI) apply (simp (no_asm) add: scnd_def thrd_def frth_def)
apply (rule conjI) apply (simp (no_asm) add: scnd_def)
apply (rule conjI) apply (simp (no_asm) add: thrd_def)
apply (rule conjI) apply (simp (no_asm) add: scnd_def thrd_def)
apply (rule conjI) apply (simp (no_asm) add: scnd_def)
apply (rule conjI) apply (simp (no_asm) add: thrd_def)
apply (rule conjI) apply (simp (no_asm) add: scnd_def thrd_def)
apply (rule conjI) apply (simp (no_asm))
apply (rule conjI) apply (simp (no_asm) add: frth_def)
apply (rule conjI) apply (simp (no_asm) add: scnd_def thrd_def frth_def)
apply (rule conjI) apply (simp (no_asm) add: scnd_def)
apply (rule conjI) apply (simp (no_asm) add: scnd_def thrd_def)
apply (rule conjI) apply (simp (no_asm) add: scnd_def thrd_def)
apply (rule conjI) apply (simp (no_asm) add: scnd_def thrd_def)
apply (rule conjI) apply (simp (no_asm) add: frth_def)
apply (rule conjI) apply (simp (no_asm) add: frth_def)
apply (rule conjI) apply (simp (no_asm) add: frth_def ffth_def)
apply (simp (no_asm) add: ffth_def)
done

lemma context_sum_DOM:
"context_sum G1 G2 G \<Longrightarrow>
DOM G = DOM G1 \<union> DOM G2"
apply (simp only: context_sum_def) 
done

lemma trans_:
"\<lbrakk>A=X; B=X\<rbrakk>\<Longrightarrow> A=B"
apply fast
done

lemma trans_gen_:
"\<lbrakk>A=X; B=Y; X=Y\<rbrakk>\<Longrightarrow> A=B"
apply fast
done

lemma trans_gen_union:
"\<lbrakk>A=X; B=Y\<rbrakk>\<Longrightarrow> A\<union>B=X\<union> Y"
apply fast
done

lemma UA1_DOM:
     "\<lbrakk>  DOM G' = U'i  \<union> U'ii \<union>   U'iii;
        DOM G'' = U''i  \<union> U''ii \<union>   U''iii;
        U''i \<inter> U''ii = {};
        U''i \<inter> U''iii = {};
        x \<in> U''i; x\<notin> DOM G';
        Ui=U'i \<union> U'ii \<union>  (U''i -{x});
        Uii=U''ii;
        Uiii=U'iii -(U''i \<union> U''ii) \<union> U''iii;
        context_minus_var G'' x Gi;
        context_sum G' Gi G\<rbrakk>\<Longrightarrow>
DOM G = Ui  \<union> Uii \<union>   Uiii"
apply (drule context_minus_var_DOM)
apply (drule context_sum_DOM)
apply (rule_tac A="DOM G" and X="DOM G' \<union> DOM Gi" and B="Ui \<union> Uii \<union> Uiii"
in trans_)
apply assumption
apply (rule_tac B="DOM G' \<union> DOM Gi" 
and X="U'i \<union> U'ii \<union> (U''i - {x}) \<union> U''ii \<union> U'iii \<union> U''iii"
and 
Y="(U'i \<union> U'ii \<union> U'iii) \<union> (U''i - {x} \<union> U''ii \<union> U''iii)"
and A="Ui \<union> Uii \<union> Uiii" in trans_gen_)
apply fast
prefer 2
apply fast
apply (rule_tac A="DOM G'" and X="U'i \<union> U'ii \<union> U'iii" and
B="DOM Gi" and
Y="(U''i - {x} \<union> U''ii \<union> U''iii)" in trans_gen_union)
apply assumption
apply fast
done

lemma inter_empty_trans:
"\<lbrakk>A=X; B=Y; X\<inter> Y={}\<rbrakk>\<Longrightarrow> A\<inter>B={}"
apply fast
done

lemma UA1_I1:
     "\<lbrakk> U'i \<inter> U''ii = {};
        U'ii \<inter> U''ii = {};
        U''i \<inter> U''ii = {};
        Ui=U'i \<union> U'ii \<union>  (U''i -{x});
        Uii=U''ii\<rbrakk>
     \<Longrightarrow> Ui \<inter> Uii = {}"
apply (rule_tac A=Ui and B=Uii and 
X="U'i \<union> U'ii \<union>  (U''i -{x})" and Y="U''ii " in inter_empty_trans)
apply assumption+
apply (rule_tac A="U''ii" and B="U'i \<union> U'ii \<union> (U''i - {x})" in 
inter_sym_empty)
apply (rule_tac X="U''ii" and A="U'i" and B="U'ii" and 
C="U''i - {x}" in inter_union3_empty)
apply (rule_tac B="U''ii" and A="U'i" in inter_sym_empty)
apply assumption
apply (rule_tac B="U''ii" and A="U'ii" in inter_sym_empty)
apply assumption
apply fast
done

lemma UA1_I2:
     "\<lbrakk> U'i \<inter> U'iii = {};U'i \<inter> U''iii = {};
        U'ii \<inter> U'iii = {};U'ii \<inter> U''iii = {};
        U''i \<inter> U''iii = {};
        Ui=U'i \<union> U'ii \<union>  (U''i -{x});
        Uiii=U'iii -(U''i \<union> U''ii) \<union> U''iii\<rbrakk>
     \<Longrightarrow> Ui \<inter> Uiii = {}"
apply (rule_tac A=Ui and B=Uiii and 
X="U'i \<union> U'ii \<union>  (U''i -{x})" and Y="U'iii -(U''i \<union> U''ii) \<union> U''iii" 
in inter_empty_trans)
apply assumption+
apply (rule_tac A="U'iii - (U''i \<union> U''ii) \<union> U''iii" 
and B="U'i \<union> U'ii \<union> (U''i - {x})" in inter_sym_empty)
apply (rule_tac X="U'iii - (U''i \<union> U''ii) \<union> U''iii "
 and A="U'i" and B="U'ii" and 
C="U''i - {x}" in inter_union3_empty)
apply (rule_tac B="U'iii - (U''i \<union> U''ii) \<union> U''iii" 
and A="U'i" in inter_sym_empty)
apply (rule_tac X="U'i"
 and A="U'iii - (U''i \<union> U''ii)" and B="U''iii" 
in inter_union_empty)
apply fast
apply assumption
apply (rule_tac B="U'iii - (U''i \<union> U''ii) \<union> U''iii" 
and A="U'ii" in inter_sym_empty)
apply (rule_tac X="U'ii"
 and A="U'iii - (U''i \<union> U''ii)" and B="U''iii" 
in inter_union_empty)
apply fast
apply assumption
apply (rule_tac B="U'iii - (U''i \<union> U''ii) \<union> U''iii" 
and A="U''i-{x}" in inter_sym_empty)
apply (rule_tac X="U''i -{x}"
 and A="U'iii - (U''i \<union> U''ii)" and B="U''iii" 
in inter_union_empty)
apply fast
apply fast
done

lemma UA1_I3:
     "\<lbrakk> U''ii \<inter> U''iii = {};
        Uii=U''ii;
        Uiii=U'iii -(U''i \<union> U''ii) \<union> U''iii \<rbrakk>
     \<Longrightarrow> Uii \<inter> Uiii = {}"
apply (rule_tac A=Uii and B=Uiii and 
Y="U'iii -(U''i \<union> U''ii) \<union> U''iii " and X="U''ii " 
in inter_empty_trans)
apply assumption+
apply (rule_tac X="U''ii" and A="U'iii - (U''i \<union> U''ii)" 
and B="U''iii" in inter_union_empty)
apply fast
apply assumption
done

lemma UA1_Letr:
     "\<lbrakk> \<rhd> e : UAsnClassic  U'i  U'ii  U'iii G' T'  ;
        \<rhd> ee : UAsnClassic  U''i  U''ii  U''iii G'' T;
        DOM G' = U'i  \<union> U'ii \<union>   U'iii;
        DOM G'' = U''i  \<union> U''ii \<union>   U''iii;
        U'i \<inter> U'ii = {};
        U'i \<inter> U'iii = {};
        U'ii \<inter> U'iii = {};
        U''i \<inter> U''ii = {};
        U''i \<inter> U''iii = {};
        U''ii \<inter> U''iii = {};
        x \<in> U''i; x\<notin> DOM G';
        Ui=U'i \<union> U'ii \<union>  (U''i -{x});
        Uii=U''ii;
        Uiii=U'iii -(U''i \<union> U''ii) \<union> U''iii;
        U'i \<inter> ( U''i  \<union> U''ii \<union>   U''iii) ={};
        U'ii \<inter> ( U''i  \<union> U''ii \<union>   U''iii) ={};
        context_minus_var G'' x Gi;
        context_sum G' Gi G;
        GETr G'' x = Some T'\<rbrakk>
     \<Longrightarrow> \<rhd> (LET rf x = e IN ee END):  UAsnClassic Ui  Uii  Uiii G T \<and> 
         DOM G = Ui  \<union> Uii \<union>   Uiii \<and> 
         Ui \<inter> Uii = {} \<and> Ui \<inter> Uiii = {} \<and> Uii \<inter> Uiii = {}"
apply (rule conjI)
apply (rule_tac U'i=U'i and U'ii=U'ii and U'iii=U'iii and 
                U''i=U''i and U''ii=U''ii and U''iii=U''iii  in UA1_Letr')
apply assumption+

apply (rule conjI)
apply (rule_tac 
G=G and Ui=Ui and Uii=Uii and Uiii=Uiii and
G'=G' and U'i=U'i and U'ii=U'ii and U'iii=U'iii and
G''=G'' and U''i=U''i and U''ii=U''ii and U''iii=U''iii and
Gi=Gi in UA1_DOM)
apply assumption+

apply (drule_tac X=U'i and A=U''i and  B=U''ii and C=U''iii in inter_union3Reverse_empty)
apply (drule_tac X=U'ii and A=U''i and  B=U''ii and C=U''iii in inter_union3Reverse_empty)
apply (erule conjE)+
 
apply (rule conjI)
apply (rule_tac 
Ui=Ui and Uii=Uii and 
U'i=U'i and U'ii=U'ii and 
U''i=U''i and U''ii=U''ii 
in UA1_I1)
apply assumption+

apply (rule conjI)
apply (rule_tac 
Uiii=Uiii and 
U'i=U'i and U'ii=U'ii and 
U''i=U''i and U'iii=U'iii and  U''iii=U''iii
in UA1_I2)
apply assumption+

apply (rule_tac 
Uiii=Uiii and Uii=Uii and U''ii=U''ii and
U''i=U''i and U'iii=U'iii and  U''iii=U''iii
in UA1_I3)
apply assumption+
done
end

