theory SlackVCG = VCG:

method_setup Wp = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast" 
method_setup method_leaf = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => leaf_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 1))  *}
 "Method for solving leaf cases in the derivation."    
 
method_setup method_If = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => if_tac ctxt stop stop 1)) *}
  "Method for If, reduces to two subgoals"

method_setup method_Let = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => let_tac ctxt (thms,thms,thms) stop 1)) *}
  "Method for LetPrim/LetRPrim/LetNull, reduces to one subgoal"

method_setup method_Letinv = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for Letrinvoke"

method_setup method_Letinvs = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             stop 1)) *}
  "Method for Letrinvoke"

(* apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def) *)
method_setup method_Call = {* Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (stop ctxt) 1)) *}
  "Method for Call, leaves dominates subgoal"
(*
method_setup method_CallDom = {* Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (fn ctxt => fn thms => dom_tac ctxt thms (K stop)) 1)) *}
  "Method for Call, leaves dominates subgoal"
*)

(* apply (simp?, (rule DA_NullResult, simp) | rule DA_NullTree | rule DA_NullList) *)
method_setup method_Null = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => null_tac ctxt 1)) *}
  "Method for Nullresult, nulltree and nulllist"

(* FIXME: to combine method_Call with method_Dom or mergepoint stuff, we need to
   ideally need a method which accepts more than one parameter *)

(* apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs) *)
method_setup method_Dom = {* Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => dom_tac ctxt thms stop stop 1)) *}
  "Method for Dom" 

method_setup ltac = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac2 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac2 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac3 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac3 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac4 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac4 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac5 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac5 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac6 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup rmd = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for resultmatchd"

method_setup rmds = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt stop 1)) *}
  "test for resultmatchd"

method_setup lmd = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => cons_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for listmatchd"

method_setup lmds = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => cons_matchd_tac ctxt stop 1)) *}
  "test for listmatchd"

method_setup tmd = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => node_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for treematchd"

method_setup tmds = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => node_matchd_tac ctxt stop 1)) *}
  "test for treematchd"
method_setup method_fast = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => fst_tac 1)) *}
  "Method for fast"

method_setup method_simp = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac ctxt 1)) *}
  "Method for simp"

method_setup method_Weaks = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "meth_defs") stop 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup method_Weak = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup letrmakelist = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letrmakelist_tac ctxt (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup letrmakelists = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letrmakelist_tac ctxt (thms "meth_defs") stop 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup letcons = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => let_cons ctxt (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup letconsML = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => let_cons_ML ctxt (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup method_REN = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => REN_tac 1)) *}
  "Method for starting: use weakening, simplification with args, fast"

lemma DA_GeneraliseL: 
"\<lbrakk>G \<rhd> e:\<lbrace>U, n, C \<ggreater> T, m\<rbrace>; n \<le> nn\<rbrakk>
 \<Longrightarrow> G \<rhd> e: \<lbrace>U, nn, C \<ggreater> T, m\<rbrace>"
(*<*)by (erule DA_Generalise, auto)

lemma vcg_invokeconstRenameGenL: 
  "\<lbrakk>(c\<bullet>M(L), sMST c M L): G;
     SPEC M = \<lbrace>UU, n, C  \<ggreater> T, m\<rbrace>;
     distinct (fst (methtable c M));
     UU = set (ParList2RnameList (fst (methtable c M))); UU \<subseteq> DOM C;
     U = set (ArgList2RnameList L); U \<subseteq> DOM D;
     distinct L;
     mk = m+k; n+k \<le> nk; 
     (L, fst (methtable c M),f):REN;
     \<forall> E x. x : fmap_dom f \<longrightarrow> (\<forall> y . (fmap_lookup f x = Some y) \<longrightarrow> E\<lfloor>x\<rfloor> = (newframe_env Nullref (fst (methtable c M)) L E)\<lfloor>y\<rfloor>);
     \<forall> x . x : fmap_dom f \<longrightarrow> (\<forall> y . ((fmap_lookup f x = Some y) \<longrightarrow> (GETr D x = GETr C y)))\<rbrakk>
  \<Longrightarrow> G \<rhd>  (c\<bullet>M(L)) : \<lbrace>U, nk, D \<ggreater> T, mk\<rbrace>"
apply (rule DA_GeneraliseL)
apply (rule vcg_invokeconstRename, assumption+) defer 1 apply assumption+ apply simp
done


lemma vcg_letrinvokeconstRenameGenL: 
  "\<lbrakk>U \<inter> (V-{x})={};
    (c\<bullet>M(L), sMST c M L): G;
     SPEC M = \<lbrace>UU, n, C  \<ggreater> T1, m\<rbrace>;
     distinct (fst (methtable c M)); distinct L;
     U = set (ArgList2RnameList L); U \<subseteq> DOM D;
     UU = set (ParList2RnameList (fst (methtable c M))); UU \<subseteq> DOM C;
     nk = n+k; mk = m+ k; T1 \<notin> {IntET, UnitET};
     (L, fst (methtable c M),f):REN;
     \<forall> E x. x : fmap_dom f \<longrightarrow> (\<forall> y . (fmap_lookup f x = Some y) \<longrightarrow> E\<lfloor>x\<rfloor> = (newframe_env Nullref (fst (methtable c M)) L E)\<lfloor>y\<rfloor>);
     \<forall> x . x : fmap_dom f \<longrightarrow> (\<forall> y . ((fmap_lookup f x = Some y) \<longrightarrow> (GETr D x = GETr C y)));
     G \<rhd> e : \<lbrace>V, mk, D(x\<mapsto>\<^sub>fT1) \<ggreater> T, l\<rbrace> ; mk \<le> nk\<rbrakk>
   \<Longrightarrow> G \<rhd>  (LET rf x = c\<bullet>M(L) IN e END) : \<lbrace>U \<union> (V-{x}), nk, D \<ggreater> T, l\<rbrace>"
apply (rule DA_GeneraliseL)
apply (rule vcg_letrinvokeconstRename, assumption+) apply simp
done

lemma NullGenL:
    "\<lbrakk>m \<le> n\<rbrakk> \<Longrightarrow> G \<rhd>  NULL : \<lbrace>U , n , C \<ggreater>  T, m \<rbrace>"
oops

lemma DA_NullTreeGenL: "\<lbrakk>m+kL \<le> n\<rbrakk> \<Longrightarrow> G \<rhd> Null: \<lbrace>{}, n, C \<ggreater> TreeET kL kN, m\<rbrace>"
(*<*) by (rule DA_GeneraliseL, rule DA_NullTree, simp, assumption)(*>*)

lemma DA_NullListGenL: "m+kN \<le> n \<Longrightarrow> G \<rhd> Null: \<lbrace>{}, n, C \<ggreater> ListET kN kC, m\<rbrace>"
(*<*) by (rule DA_GeneraliseL, rule DA_NullList, simp, assumption)(*>*)

lemma DA_NullResGenL: "m+kN \<le> n \<Longrightarrow> GG \<rhd> Null: \<lbrace>{}, n, G \<ggreater> ResultET kN T kS, m\<rbrace>"
(*<*) by (rule DA_GeneraliseL, rule DA_NullRes, simp, assumption)(*>*)

ML_setup {* 
  val vcg_nullresultGenL = thm "DA_NullResGenL"
  val vcg_nulltreeGenL = thm "DA_NullTreeGenL"
  val vcg_nulllistGenL = thm "DA_NullListGenL"

  val vcg_letrinvokeconstRenameGenL = thm "vcg_letrinvokeconstRenameGenL"
  val vcg_invokeconstRenameGenL = thm "vcg_invokeconstRenameGenL"

  fun null_tac_genl ctxt i =
    EVERY [TRY (localsimp_tac ctxt i),
           ((rtac vcg_nullresultGenL i) THEN (localsimp_tac ctxt i))
           ORELSE ((rtac vcg_nulltreeGenL i) THEN (localsimp_tac ctxt i))
           ORELSE ((rtac vcg_nulllistGenL i) THEN (localsimp_tac ctxt i))] 

  fun inv_Rename_tac_genl ctxt (dmp_defs,meth_defs,fun_defs,ctxt_defs) i =
          EVERY [rtac vcg_invokeconstRenameGenL i,

                 (*simpset_tac_thms ctxt_defs i, member i,*)
                 localsimp_tac_thms ctxt ctxt_defs i,

                 repeat 3 (localsimp_tac_thms ctxt meth_defs i),
                 repeat 6 (localsimp_tac ctxt i),
                 simpset_tac_thms meth_defs i, REN_tac i,
                 localsimp_tac_thms ctxt ([thm "newframe_env_def", thm "evalARGS_def"] @ meth_defs) i,
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                         localsimp_tac ctxt i]]

  fun letrinvRename_tac_genl ctxt (dmp_defs,meth_defs,fun_defs,ctxt_defs) rec_tac i =
          EVERY [rtac vcg_letrinvokeconstRenameGenL i,
                 localsimp_tac_thms ctxt ctxt_defs (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1), REN_tac (i+1),
                 localsimp_tac_thms ctxt ([thm "newframe_env_def", thm "evalARGS_def"] @ meth_defs) (i+1),
                 FIRST [ EVERY [localsimp_tac ctxt (i+1),
                                rtac conjI (i+1),
                                repeat 2 (localsimp_tac ctxt (i+1))],
                         localsimp_tac ctxt (i+1)],
                 rec_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt i]

  fun let_tac_genl ctxt thms rec_tac i =
   FIRST [EVERY [rtac vcg_letint i,
		 rec_tac ctxt i],
          EVERY [rtac vcg_letprim i,
		 rec_tac ctxt i],
          EVERY [resolve_tac [vcg_letrprim] i,
	         localsimp_tac ctxt i,
	         localsimp_tac ctxt i,
	         rec_tac ctxt i],
	  EVERY [rtac vcg_letnull i,
	         rec_tac ctxt (i+1),
                 null_tac_genl ctxt (i+1),
		 localsimp_tac ctxt i],
          letrmakelist_tac ctxt thms rec_tac i,
	  EVERY [rtac vcg_letrmakeresult i,
	         repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i],
	  EVERY [rtac vcg_letrmaketree i,
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
	         repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i]]

  fun leaf_tac ctxt thms i = 
  FIRST
   [resolve_tac [vcg_int, vcg_ivar, vcg_prim] i,
    EVERY [rtac vcg_rvar i, localsimp_tac ctxt i],
    resolve_tac [vcg_prim] i,
    EVERY [resolve_tac [vcg_rprim] i,
	   repeat 2 (localsimp_tac ctxt i)],
    EVERY [resolve_tac [vcg_makelist] i,
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
           localsimp_tac ctxt i],
    EVERY [resolve_tac [vcg_makelist_ml] i,
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
	   repeat 3 (localsimp_tac ctxt i)],
    EVERY [resolve_tac [vcg_makeresult] i,
	   repeat 2 (localsimp_tac ctxt i)],
    EVERY [resolve_tac [vcg_maketree] i,
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
	   repeat 2 (localsimp_tac ctxt i)],
    inv_Rename_tac_genl ctxt thms i]

   fun l_tac6_genl (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac6_genl thms) (l_tac6_genl thms) i,
           let_tac_genl ctxt thms (l_tac6_genl thms) i,
           call_tac ctxt dmp_defs (l_tac6_genl thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac6_genl thms) (w_tac fun_defs (l_tac6_genl thms)) i,
           match_tac ctxt (l_tac6_genl thms) i,
           letrinvRename_tac ctxt thms (l_tac6_genl thms) i,
           letiinvRename_tac ctxt thms (l_tac6_genl thms) i,
           null_tac_genl ctxt i,
           leaf_tac ctxt thms i]

*}

method_setup method_NullGenL = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => null_tac_genl ctxt 1)) *}
  "Method for Nullresult, nulltree and nulllist with left slack"

method_setup method_LetrinvsGenL = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letrinvRename_tac_genl ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             stop 1)) *}
  "Method for Letrinvoke with left slack"

method_setup method_invsGenL = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => inv_Rename_tac_genl ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                              1)) *}
  "Method for invoke with left slack"

method_setup ltac6genl = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac6_genl (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method with left slack"

method_setup WpGenL = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6_genl (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast, left slack"

end
