(* Reverse from Predicates adapted for final, ultimate, clarified, kool bytecodelogic *)
(* To use this logic with this proof do: ln -s ~/mrg/progs/BytecodeLogic/*.thy . *)
(* Version to be used in TPHOL paper *)

theory Rev4BCL = mTreeList:

(*  Examples from List.cmlt -> Grail*)

(* List reversal:
Camelot:
let rev' l acc = 
  match l with Nil@d => acc 
             | Cons (h, t)@d => rev' t (Cons (h, acc)@d )

Grail:   
class ListRevInPlace {
   method public static ListRevInPlace$dia_0 rev' (ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 acc) =
   let

      fun f:rev'(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d, ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0 t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val tag = getfield l <int ListRevInPlace$dia_0.$>
      in
         if tag = 0
         then f:0(l, d, ?t0, d#0, h, t, acc, l)
         else f:1(l, d, ?t0, d#0, h, t, acc, l)
      end

      fun f:1(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d, ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0 t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val h = getfield l <int ListRevInPlace$dia_0.f0>
         val t = getfield l <ListRevInPlace$dia_0 ListRevInPlace$dia_0.f1>
         val d#0 = l
         val ?t0 = invokestatic <ListRevInPlace$dia_0 ListRevInPlace$dia_0.fill (ListRevInPlace$dia_0, int, int, ListRevInPlace$dia_0)> (d#0, 1, h, acc)
      in
         invokestatic <ListRevInPlace$dia_0 ListRevInPlace.rev' (ListRevInPlace$dia_0, ListRevInPlace$dia_0)> (t, ?t0)
      end

      fun f:0(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d, ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0 t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val d = l
      in
         acc
      end
   in
      f:rev'(l, d, ?t0, d#0, h, t, acc, l)
   end
}

ToyGrail:
class ListRevInPlace {
   method public static List rev' (List l, List acc) =
   let fun f(List l, List acc) =
        let  tag = getfield l TAG
        in if tag = 0
           then acc
           else let  h = getfield l HD
                     t = getfield l TL
                     one = 1
                     () = putfield l TAG one
                     () = putfield l HD h
                     () = putfield l TL acc
                     acc = l
                     l = t
                in f(l,acc)
                end
   in
      f(l, acc)
   end
}
*)


declare update_lemmas[simp]

consts
  q_       :: iname   
  tag_     :: iname
  b_       :: iname    
  h_       :: iname  

  t_       :: rname  
  l_       :: rname
  acc_     :: rname 

  f_       :: funame   
  
  Revv     :: cname

  revv     :: mname

  callcA :: nat 
  callcB :: nat 
  clockA :: nat 
  clockB :: nat 
  invkcA :: nat 
  invkcB :: nat 
  invkdpthA :: nat 
  invkdpthB :: nat 

  specf :: vdmassn

syntax TAG :: "ifldname"
translations
"TAG" => "DOLLAR"

syntax NIL_TAG :: "int"
translations
"NIL_TAG" => "2"

syntax CONS_TAG :: "int"
translations
"CONS_TAG" => "1"

syntax HD :: "ifldname"
translations
"HD" => "F0"

syntax TL :: "rfldname"
translations
"TL" => "F1"

(*
axioms  meth[simp]:
 "methtable Revv revv = ([RNpar l_, RNpar acc_], CALL f_)"
   
axioms  funtf[simp]:
 "funtable f_ == LET tag_ = GetFi l_ TAG ;
                       b_ = Primop (% x y. if x = NIL_TAG then 1 else 0) tag_ tag_
                 IN IF b_ 
                     THEN RVar acc_ 
                     ELSE LET   h_ = GetFi l_ HD;
                             rf t_ = GetFr l_ TL;
                              tag_ = expr.Int CONS_TAG;
                                 _ = PutFi l_ TAG tag_; 
                                 _ = PutFi l_ HD h_;
                                 _ = PutFr l_ TL acc_
                          IN 
                           Revv\<bullet>revv([RNarg t_, RNarg l_])
                          END
                END"
*)

(* This version uses InvokeStatic rather than Calls.
   Adaptation via good context is used to handle the parameter passing *)

axioms  meth[simp]:
 "methtable Revv revv = ([RNpar l_, RNpar acc_], 
                 LET tag_ = GetFi l_ TAG ;
                       b_ = Primop (% x y. if x = NIL_TAG then 1 else 0) tag_ tag_
                 IN IF b_ 
                     THEN RVar acc_ 
                     ELSE LET   h_ = GetFi l_ HD;
                             rf t_ = GetFr l_ TL;
                              tag_ = expr.Int CONS_TAG;
                                 _ = PutFi l_ TAG tag_; 
                                 _ = PutFi l_ HD h_;
                                 _ = PutFr l_ TL acc_
                          IN 
                           Revv\<bullet>revv([RNarg t_, RNarg l_])
                          END
                END)"

(* The spec of reverse as a table entry *)
consts FST :: FS_T
consts vMST :: vMS_T
consts sMST :: sMS_T
constdefs mySpec :: "bool"
"mySpec == 
 (sMST Revv revv = (\<lambda> args E h hh v p . 
  (\<forall> n a X m b Y. ((evalARGS E args = [RVal (Ref a), RVal (Ref b)] \<and> 
                   (n,a,X,h) \<in> mList \<and> (m,b,Y,h) \<in> mList \<and> X \<inter> Y = {}) 
                   \<longrightarrow> 
                   (HSize h = HSize hh \<and> 
                   p = \<langle> (int (clockA * n + clockB)) (int (callcA * n + callcB))
                         (int (invkcA * n + invkcB)) (invkdpthA * n + invkdpthB)\<rangle>)))))"

axioms vardistinct:     "distinct [tag_,h_,b_,q_] \<and> distinct [q_,b_,h_,tag_] \<and> 
                         distinct[l_,acc_,t_] \<and> distinct [t_,acc_,l_]"

(* The resource consumption of reverse *)
axioms resdefs[simp]: "(callcA = 0) \<and> (callcB = 0) \<and> 
                       (clockA = 29) \<and> (clockB = 13) \<and> 
                       (invkcA = 1)  \<and> (invkcB = 1) \<and>
                       (invkdpthA = 1) \<and> (invkdpthB = 1)"

lemma "\<lbrakk>(n,l,D,h): mList; h<l\<bullet>DOLLAR> \<noteq> NIL_TAG\<rbrakk> \<Longrightarrow> fmap_lookup(oheap h) l = Some DIAM"
apply  (erule mList.elims) apply (simp_all) done

lemma mListElimNIL:
  "\<lbrakk>(n, a, X, h) \<in> mList; h<a\<bullet>DOLLAR> = NIL_TAG\<rbrakk> \<Longrightarrow> n = 0"
by (erule mList.elims, simp_all)

lemma mListElimCONS:
  "\<lbrakk>(n, a, X, h) \<in> mList; h<a\<bullet>DOLLAR> \<noteq> NIL_TAG \<rbrakk> \<Longrightarrow> 0 < n "
by (erule mList.elims, simp_all)

(* context needed for the proof *)
constdefs myContext :: "vdmcontext"
"myContext == {(Revv\<bullet>revv([RNarg t_, RNarg l_]),
                sMST Revv revv [RNarg t_, RNarg l_])}"

(* --------------------------------------------------------------------------- *)

subsection {* Proof from empty context using goodContext etc *}

lemma revv_Aux: "\<lbrakk> mySpec ; G = myContext \<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable Revv revv) : 
      (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable Revv revv)) x E' \<longrightarrow>
                    sMST Revv revv x E' h hh v
                       (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (rule vdm_conseq)
apply simp
(* apply (rule vdm_call) apply (simp only: funtf) apply (rule vdm_conseq) *)
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
apply (rule vdm_if) apply (rule vdm_rvar) prefer 2 apply clarsimp
apply (case_tac "h<a\<bullet>DOLLAR> = NIL_TAG", clarsimp) defer 1  apply clarsimp 
prefer 2
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp? prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp? prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp? prefer 2
apply (rule vdm_ax) apply (simp add: myContext_def mySpec_def)
(* apply (insert vardistinct) *)
apply (subgoal_tac "l_ ~= t_")
apply (simp add: newframe_env_def evalARGS_def myContext_def mySpec_def)
apply (erule thin_rl)
apply clarify
(* apply (case_tac "h<aa\<bullet>DOLLAR> = NIL_TAG") *)
apply (subgoal_tac "aa=ab")
apply simp
apply (subgoal_tac "l_ ~= acc_")
apply simp
apply (erule mList.elims)
  (* NIL case *)
  apply simp
  (* CONS case *)
  apply (erule_tac x="na" in allE)
  apply (erule impE)
  apply (rule_tac x="aaa" in exI)
  apply (rule conjI)
  apply simp
  apply (rule_tac x="Xa" in exI)
  apply (rule conjI)
  apply (rotate_tac -1)
  apply (frule mListSame)
   prefer 2
   apply (insert vardistinct)
   apply (simp add: same_def sameOH_def)
  apply (simp add: same_def sameOH_def)
  apply (rule_tac x="Suc m" in exI)
  apply (rule_tac x="Y \<union> {ab}" in exI)
  apply (rule conjI)
  apply (rule mListCONS)
  apply simp
  apply simp
  apply simp
  prefer 2
  apply simp
  prefer 2
  apply simp
  prefer 3
  apply simp
  apply (frule mListSame)
  prefer 2
  apply simp
   apply (simp add: same_def sameOH_def)
  apply (simp add: newframe_env_def evalARGS_def)
  prefer 2
  apply simp
  prefer 2
  apply simp
  prefer 2
  apply simp
  prefer 2
  apply (simp add: mySpec_def  myContext_def)
  apply clarify
  apply (frule mListElimNIL) 
   apply (simp add: newframe_env_def evalARGS_def)
   apply assumption
  apply clarsimp
done
(* couild be shortened a lot, but why? *)

lemma myContext_good: "\<lbrakk> mySpec \<rbrakk> \<Longrightarrow> goodContext FST vMST sMST myContext"
apply (simp only: goodContext_def myContext_def) apply (rule, rule, rule)
apply (subgoal_tac "(e, P) = (Revv\<bullet>revv([RNarg t_, RNarg l_]), sMST Revv revv [RNarg t_, RNarg l_])")
prefer 2 apply simp
apply (rule disjI2, rule disjI2)
apply clarsimp
apply (drule revv_Aux) apply simp apply simp
apply (simp only: myContext_def)
done
 
theorem "\<lbrakk> mySpec \<rbrakk> \<Longrightarrow> \<rhd> (Revv\<bullet>revv([RNarg x, RNarg y])) : sMST Revv revv [RNarg x, RNarg y]"
apply (rule GCInvs)
apply (erule myContext_good)
apply (simp_all add: myContext_def, auto)
done

end
