(*<*)
theory NILTreeList = VDMderived:
(*>*)
section {*Heap logic for derived assertions: lists, trees, and results*}

subsection{*Representation of lists, trees, results, and the freelist*}
syntax DIAM :: cname
       DOLLAR_F :: rfldname
       DOLLAR_N :: rfldname
       DOLLAR :: ifldname
       R1 :: rfldname
       R2 :: rfldname
       V0 :: ifldname

       Free :: mname
       Make_IIDD  :: mname
       Make_IID  :: mname
       Fill_DIID :: mname
       Fill_DIIDD :: mname

       Alloc :: mname
       freelist_ :: rname
       alloc_b :: iname
       Alloc_q :: funame
       alloc_tl :: rname

       tag_ :: iname
       v0_  :: iname  
       r1_  :: rname  
       r2_  :: rname  
       x_  :: rname  
       node_ :: rname

translations
 "DIAM" == "(CN ''dia_0'') "
 "DOLLAR_F" == "(RFN ''$f'')"
 "DOLLAR_N" == "(RFN ''$n'')"
 "DOLLAR" == "(IFN ''$'')"
 "R1" == "(RFN ''R1'')"
 "R2" == "(RFN ''R2'')"
 "V0" == "(IFN ''V0'')"

 "Free" == "(MN ''Free'')"
 "Make_IID" == "(MN ''Make_IID'')"
 "Make_IIDD" == "(MN ''Make_IIDD'')"
 "Fill_DIID" == "(MN ''Fill_DIID'')"
 "Fill_DIIDD" == "(MN ''Fill_DIIDD'')"

 "tag_" == "(In ''tag'') "
 "v0_" == "(In ''v0'') "
 "r1_" == "(RN ''r1'') "
 "r2_" == "(RN ''r2'') "
 "x_" == "(RN ''?x'') "
 "node_" == "(RN ''node'') "

 "Alloc " == "(MN ''alloc'')"
 "freelist_ " == "(RN ''freelist'')"
 "alloc_b " == "(In ''b'')"
 "Alloc_q " == "(FN ''q'')"
 "alloc_tl " == "(RN ''tl'')"

axioms Meth_Fill_DIIDD:
"methtable DIAM Fill_DIIDD = ([RNpar x_, INpar tag_, INpar v0_, RNpar r1_, RNpar r2_],
                             LET _ = PutFi x_ DOLLAR tag_;
                                 _ = PutFi x_ V0 v0_;
                                 _ = PutFr x_ R1 r1_;
                                 _ = PutFr x_ R2 r2_
                             IN RVar x_ END)"
axioms Meth_Fill_DIID:
"methtable DIAM Fill_DIID = ([RNpar x_, INpar tag_, INpar v0_, RNpar r1_],
                             LET _ = PutFi x_ DOLLAR tag_;
                                 _ = PutFi x_ V0 v0_;
                                 _ = PutFr x_ R1 r1_
                             IN RVar x_ END)"

axioms Meth_Make_IIDD:
"methtable DIAM Make_IIDD = ([INpar tag_, INpar v0_, RNpar r1_, RNpar r2_],
                            LET rf x_ = DIAM\<bullet>Alloc([])
                            IN DIAM\<bullet>Fill_DIIDD ([RNarg x_, INarg tag_, INarg v0_, RNarg r1_, RNarg r2_]) END)"
axioms Meth_Make_IID:
"methtable DIAM Make_IID = ([INpar tag_, INpar v0_, RNpar r1_],
                            LET rf x_ = DIAM\<bullet>Alloc([])
                            IN DIAM\<bullet>Fill_DIID ([RNarg x_, INarg tag_, INarg v0_, RNarg r1_]) END)"

axioms Meth_Alloc:
"methtable DIAM Alloc = ([], LET rf freelist_ = DIAM\<struct>DOLLAR_F;
                                 alloc_b = RPrimop (\<lambda> x y . if x = Nullref then 1 else 0) freelist_ freelist_
                             IN IF alloc_b THEN NEW <DIAM> ([],[]) ELSE CALL Alloc_q END)"
(*Isabelle problem: why must we not use the pretty GetStat/PutStat syntax in the lemma 
  ''Illegal reference to implicit structure #1''??*)
lemma 
"methtable DIAM Alloc = ([], LET rf freelist_ = GetStat DIAM DOLLAR_F;
                                      alloc_b = RPrimop (\<lambda> x y . if x = Nullref then 1 else 0) freelist_ freelist_
                                   IN IF alloc_b THEN NEW <DIAM> ([],[]) ELSE CALL Alloc_q END)"
by (simp add: Meth_Alloc)

axioms Fun_AllocQ:
"funtable Alloc_q = ([RNpar freelist_],
                      LET rf alloc_tl = freelist_\<diamondsuit>DOLLAR_N;
                                    _ = DIAM\<struct>DOLLAR_F := alloc_tl
                      IN RVar freelist_ END)"
lemma "funtable Alloc_q = ([RNpar freelist_],
                           LET rf alloc_tl = freelist_\<diamondsuit>DOLLAR_N;
                                         _ = DIAM\<struct>DOLLAR_F := alloc_tl
                           IN RVar freelist_ END)"
by (simp add: Fun_AllocQ)

axioms Meth_Free:
"methtable DIAM Free = ([RNpar node_],
   LET rf freelist_ = GetStat DIAM DOLLAR_F;
                  _ = PutFr node_ DOLLAR_N freelist_
   IN PutStat DIAM DOLLAR_F node_ END)"

(*representation predicates*)
consts mLIST::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive mLIST intros
mLIST_NIL: "(0,Nullref,{},h) : mLIST"
mLIST_CONS:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> = 5; h\<lfloor>a\<diamondsuit>R1\<rfloor> = r; a \<notin> X; (n,r,X,h):mLIST; m=Suc n;XX=X \<union> {a}\<rbrakk>
          \<Longrightarrow> (m, Ref a, XX, h): mLIST"

lemma mLIST_Unique[rule_format]: "(N, r, F, h) \<in> mLIST \<Longrightarrow> (\<forall> M FF . (M, r, FF, h) \<in> mLIST \<longrightarrow> (F=FF \<and> N=M))"
(*<*)
apply (erule mLIST.induct)
apply clarsimp
apply (erule mLIST.elims, clarsimp, clarsimp)
apply (rule, rule, rule)
apply (rotate_tac -1, erule mLIST.elims, clarify, clarify)
apply (erule_tac x=na in allE, erule_tac x=Xa in allE, erule impE, assumption)
apply clarsimp
done
(*>*)

lemma mLIST_Preserved[rule_format]:
"(n, r, R, h) \<in> mLIST \<Longrightarrow> (\<forall> h1. (\<forall> l. l \<in> R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (n, r, R, h1) \<in> mLIST)"
(*<*)
apply (erule mLIST.induct)
apply clarsimp
apply (rule mLIST_NIL)
apply clarsimp
apply (rule mLIST_CONS)
apply (erule_tac x=a in allE, clarsimp) apply (simp add: sameOH_def)
apply (erule_tac x=a in allE, clarsimp) apply (simp add: sameOH_def)
apply (subgoal_tac "h1\<lfloor>a\<diamondsuit>R1\<rfloor> = h\<lfloor>a\<diamondsuit>R1\<rfloor>", assumption)
  apply (erule_tac x=a in allE, clarsimp, simp add: sameOH_def)
prefer 2 apply (erule_tac x=h1 in allE)
  apply (erule impE) apply clarsimp
  apply assumption
apply assumption
apply fastsimp+
done
(*>*)

lemma mLIST_region_in_heap:"(n, r, R, h) \<in> mLIST \<Longrightarrow> R \<subseteq> Dom h"
(*<*)
apply (erule mLIST.induct,fast)
apply (subgoal_tac "a:Dom h",fast) 
apply (simp add: fmap_lookup_def fmap_dom_def,fastsimp)
done
(*>*)

consts mTREE::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive mTREE intros
mTREE_LEAF: "(0,Nullref,{},h) : mTREE"
mTREE_NODE:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> = 3; 
             h\<lfloor>a\<diamondsuit>R1\<rfloor> = r1; a \<notin> X1; (n1,r1,X1,h):mTREE;
             h\<lfloor>a\<diamondsuit>R2\<rfloor> = r2; a \<notin> X2; (n2,r2,X2,h):mTREE;
             X1 \<inter> X2 = {};m=Suc (n1+n2);X=X1 \<union> X2 \<union> {a}\<rbrakk>
          \<Longrightarrow> (m, Ref a, X, h): mTREE"

lemma mTREE_Unique[rule_format]: "(N, r, F, h) \<in> mTREE \<Longrightarrow> (\<forall> M FF . (M, r, FF, h) \<in> mTREE \<longrightarrow> (F=FF \<and> N=M))"
(*<*)
apply (erule mTREE.induct)
apply clarsimp
apply (erule mTREE.elims, clarsimp, clarsimp)
apply (rule, rule, rule)
apply (rotate_tac -1, erule mTREE.elims, clarify, clarify)
apply (erule_tac x=n1a in allE, erule_tac x=X1a in allE, erule impE, assumption)
apply (erule_tac x=n2a in allE, erule_tac x=X2a in allE, erule impE, assumption)
apply clarsimp
done
(*>*)

lemma mTREE_Preserved[rule_format]:
"(n, r, R, h) \<in> mTREE \<Longrightarrow> (\<forall> h1. (\<forall> l. l \<in> R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (n, r, R, h1) \<in> mTREE)"
(*<*)
apply (erule mTREE.induct)
apply clarsimp
apply (rule mTREE_LEAF)
apply clarsimp
apply (rule mTREE_NODE)
apply (erule_tac x=a in allE, clarsimp) apply (simp add: sameOH_def)
apply (erule_tac x=a in allE, clarsimp) apply (simp add: sameOH_def)
apply (subgoal_tac "h1\<lfloor>a\<diamondsuit>R1\<rfloor> = h\<lfloor>a\<diamondsuit>R1\<rfloor>", assumption)
  apply (erule_tac x=a in allE, clarsimp, simp add: sameOH_def)
prefer 2 apply (erule_tac x=h1 in allE)
  apply (erule impE) apply clarsimp
  apply assumption
apply assumption
apply (subgoal_tac "h1\<lfloor>a\<diamondsuit>R2\<rfloor> = h\<lfloor>a\<diamondsuit>R2\<rfloor>", assumption)
  apply (erule_tac x=a in allE, clarsimp, simp add: sameOH_def)
prefer 2 apply (rotate_tac 5, erule_tac x=h1 in allE)
  apply (erule impE) apply clarsimp
  apply assumption
apply assumption
apply fastsimp+
done
(*>*)

lemma mTREE_region_in_heap:"(n, r, R, h) \<in> mTREE \<Longrightarrow> R \<subseteq> Dom h"
(*<*)
apply (erule mTREE.induct,fast)
apply (subgoal_tac "a:Dom h",fast) 
apply (simp add: fmap_lookup_def fmap_dom_def,fastsimp)
done
(*>*)

consts mRESULT::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive mRESULT intros
mRESULT_NONE: "(0,Nullref,{},h) : mRESULT"
mRESULT_SOME:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> = 1; 
               h\<lfloor>a\<diamondsuit>R1\<rfloor> = r; a \<notin> Y; (n,r,Y,h):mTREE;
               m=Suc n; X=Y \<union> {a}\<rbrakk>
          \<Longrightarrow> (m, Ref a, X, h): mRESULT"

lemma mRESULT_Unique[rule_format]: "(N, r, F, h) \<in> mRESULT \<Longrightarrow> (\<forall> M FF . (M, r, FF, h) \<in> mRESULT \<longrightarrow> (F=FF \<and> N=M))"
(*<*)
apply (erule mRESULT.induct)
apply clarsimp
apply (erule mRESULT.elims, clarsimp, clarsimp)
apply (rule, rule, rule)
apply (rotate_tac -1, erule mRESULT.elims, clarify, clarify)
apply (subgoal_tac "Y = Ya \<and> n=na", simp)
apply (erule mTREE_Unique, assumption)
done
(*>*)

lemma mRESULT_Preserved[rule_format]:
"(n, r, R, h) \<in> mRESULT \<Longrightarrow> (\<forall> h1. (\<forall> l. l \<in> R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (n, r, R, h1) \<in> mRESULT)"
(*<*)
apply (erule mRESULT.induct)
apply clarsimp
apply (rule mRESULT_NONE)
apply clarsimp
apply (rule mRESULT_SOME)
apply (erule_tac x=a in allE, clarsimp) apply (simp add: sameOH_def)
apply (erule_tac x=a in allE, clarsimp) apply (simp add: sameOH_def)
apply (subgoal_tac "h1\<lfloor>a\<diamondsuit>R1\<rfloor> = h\<lfloor>a\<diamondsuit>R1\<rfloor>", assumption)
  apply (erule_tac x=a in allE, clarsimp, simp add: sameOH_def)
apply simp
apply (erule mTREE_Preserved)
apply (erule_tac x=l in allE, clarsimp)
apply simp+
done
(*>*)

lemma mRESULT_region_in_heap:"(n, r, R, h) \<in> mRESULT \<Longrightarrow> R \<subseteq> Dom h"
(*<*)
apply (erule mRESULT.induct,fast)
apply (subgoal_tac "Y \<subseteq> Dom h")
apply (subgoal_tac "a:Dom h",fast) 
apply (simp add: fmap_lookup_def fmap_dom_def,fastsimp)
apply (erule mTREE_region_in_heap)
done
(*>*)

consts FL::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive FL intros
FL_NIL: "(0, Nullref, {},h) : FL"
FL_SUC: "\<lbrakk>h@@a = Some DIAM; a \<notin> X; (n, h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>,X,h):FL\<rbrakk>
        \<Longrightarrow> (Suc n, Ref a,  X \<union> {a}, h) : FL"

lemma FL_Unique[rule_format]: "\<forall> r F h. (N, r, F, h) \<in> FL \<longrightarrow> (\<forall> M FF . (M, r, FF, h) \<in> FL \<longrightarrow> (N=M \<and> F=FF))"
(*<*)
apply clarsimp
apply (induct N)
apply (erule FL.elims, simp_all)
apply (erule FL.elims, simp_all)
apply (erule FL.elims, simp_all)
apply (erule FL.elims, simp_all)
apply fast
done
(*>*)

lemma FL_Preserved[rule_format]: "(n,r, X, h) \<in> FL \<Longrightarrow> (\<forall> h1 . sameOH X h h1 \<longrightarrow> (n, r, X, h1) \<in> FL)"
(*<*)
apply (erule FL.induct)
apply clarsimp apply (rule FL_NIL)
apply clarify apply (rule FL_SUC) apply (simp add: sameOH_def) apply assumption apply (erule_tac x=h1 in allE, erule impE)
  apply (simp_all add: sameOH_def) 
done
(*>*)

lemma FL_UpdateOutside[rule_format]:
"\<forall> h F r v. (N, r, F, h) \<in> FL \<longrightarrow> 
         (\<forall> a . a \<notin> F \<longrightarrow> 
           (N, r, F, 
               h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := v)),
                 sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>) \<in> FL)"
(*<*)
apply (clarsimp, induct N)
apply (erule FL.elims, simp_all, clarsimp) apply (rule FL_NIL)
apply (erule FL.elims, simp_all, clarsimp)
  apply (subgoal_tac "(Suc na, Ref aa, X \<union> {aa}, ha
           \<lparr>rheap := (rheap ha)(DOLLAR_N := (rheap ha DOLLAR_N)(a := v)),
              sheap := (sheap ha)(DIAM := (sheap ha DIAM)(DOLLAR_F := Ref a))\<rparr>)
          \<in> FL", simp) apply (rule FL_SUC)
apply simp
apply simp
apply clarsimp
done
(*>*)
(*<*)
end
(*>*)
