theory MuDAss = TREELIST:

types Tvar = nat

datatype fldname =
  ifldn ifldname
| rfldn rfldname

types A = nat

datatype Tp = 
    intET
  | nodeET "A \<times> Tp \<times> int" 
  | varET Tvar
  | sumET "A \<times> Tp \<times> int" "A \<times> Tp \<times> int"
  | recET "(fldname \<times> Tp) list"
  | muET "(Tvar \<Rightarrow> Tp)"
(*  unitET *)
(*nodeET is used in matches for the cell; 
    the value of type A is the HoJo number,
    the type tp is the type anchored in the node, and
    the int value is the tag, i.e. the content of the DOLLAR field*)
(*the reason for having constructor unitET is that unitET should be heapfree, 
otherwise FREE cannot deliver something of type unitET
constdefs unitET::"Tp"
"unitET \<equiv> recET []"
*)

consts substitution :: "((Tvar \<Rightarrow> Tp) * Tp * Tp) set"
consts listsubstitution :: "((Tvar \<Rightarrow> ((fldname \<times> Tp) list)) * Tp * ((fldname \<times> Tp) list)) set"
syntax
subst :: "[Tvar \<Rightarrow> Tp, Tp, Tp] => bool"
translations "subst s t u" == "(s,t,u) : substitution"

inductive substitution listsubstitution intros
subst_var1: "subst (% v. varET v) p p" 
subst_var2: "subst (% v. varET u) p (varET u)"
subset_node: "\<lbrakk>subst T t U\<rbrakk> \<Longrightarrow> subst (% v. nodeET (n,T v,i)) t (nodeET (n,U,i))"
subst_rec: "\<lbrakk>(S, t, U) :listsubstitution\<rbrakk> \<Longrightarrow> subst (% v. (recET (S v))) t (recET U)"
subst_sum:  "\<lbrakk> subst s1 t u1; subst s2 t u2 \<rbrakk> \<Longrightarrow> subst (% v. sumET (n,s1 v,i) (m,s2 v,j)) t (sumET (n,u1,i) (m,u2,j))"
subst_mu:   "(\<forall> v . subst (% x . (M x v)) p (N v) ) \<Longrightarrow> subst (% x. (muET (M x))) p (muET N)"
subst_int:  "subst (% x . intET) p intET"
(*subst_unit:  "subst (% x . unitET) p unitET"*)

substNil: "(\<lambda> x . [],t,[]): listsubstitution"
substCons: "\<lbrakk>subst s t u; (S,t,U):listsubstitution\<rbrakk> \<Longrightarrow> (\<lambda> x . (fldn,s x) # (S x),t, (fldn,u) # U): listsubstitution"

lemma ext_simp: "((% i. e i) = (% j. f j)) = (! k. e k = f k)";
by(auto)

lemma varET_ext:"((% i. varET j) = (% i. varET k)) = (j = k)"
by (simp add: ext_simp)
lemma nodeET_ext:"((% i. nodeET (n,j,I)) = (% i. nodeET (m,k,J))) = (n=m \<and> j = k \<and> I=J)"
by (simp add: ext_simp)
lemma sumET_ext:"((% i. sumET (n1,j1 i,I1) (m1,k1 i,J1)) = (% i. sumET (n2,j2 i,I2) (m2,k2 i,J2))) = (j1 = j2 \<and> k1=k2 \<and> n1=n2 \<and> m1=m2 \<and> I1=I2 \<and> J1=J2)"
by (simp add: ext_simp, fast)
lemma muET_ext:"((% i. muET (e i)) = (% i. muET (f i))) = (e = f)"
by (simp add: ext_simp)
lemma muET_ext:"((% i. recET (e i)) = (% i. recET (f i))) = (e = f)"
by (simp add: ext_simp)

lemma varET_neq1[simp]:"((% i. varET i) = (% i. varET k)) = False";
apply (simp add: ext_simp) apply (case_tac k) apply auto done

lemma varET_neq2[simp]: "((% i. varET j) ~= (% i. varET i))"
by (rule not_sym, simp)

declare ext_simp [simp]
inductive_cases subst_cases:
"subst (% v. varET v) p pp"
"subst (% v. varET u) p pp"
"subst (% v. nodeET (n,T v,i)) p pp"
"subst (% v. (recET (S v))) t T"
"subst (% v. sumET (n,s1 v,I) (m,s2 v,J)) t T"
"subst (% x. (muET (M x))) p T"
"subst (% x . intET) p T"
(*"subst (% x . unitET) p T"*)

inductive_cases listsubst_cases:
"(\<lambda> x . [],t, L): listsubstitution"
"(\<lambda> x . (fldn,s x) # (S x),t, L): listsubstitution"
declare ext_simp [simp del]

declare subst_cases[elim!]
declare listsubst_cases[elim!]
lemma subst_substlist_unique[rule_format]:
  "(subst f T S1 \<longrightarrow> (\<forall> S2 . subst f T S2 \<longrightarrow> S1=S2)) \<and> 
   ((S,t,U1) \<in> listsubstitution \<longrightarrow> (\<forall> U2 . (S,t,U2):listsubstitution \<longrightarrow> U1=U2))"
apply (rule substitution_listsubstitution.induct) (*
           [of "\<lambda> f T S1 . (\<forall>S2. subst f T S2 \<longrightarrow> S1 = S2)"
               "\<lambda> S t U1. (\<forall>U2. (S, t, U2) \<in> listsubstitution \<longrightarrow> U1 = U2)" f T S1 S t U1])*)
apply clarsimp apply (erule subst_cases) apply simp apply (case_tac u) apply force apply force
defer 1
apply (rule, rule) apply (rotate_tac -1) apply (erule subst_cases) apply simp
apply (rule, rule) apply (rotate_tac -1) apply (erule subst_cases) apply simp
apply (rule, rule) apply (rotate_tac -1) apply (erule subst_cases) apply simp
defer 1 
apply clarsimp 
apply clarsimp
(*unitET: apply clarsimp*)
apply (rule, rule) apply (rotate_tac -1) apply (erule listsubst_cases) apply simp
apply clarsimp apply (erule substitution_listsubstitution.elims) apply clarify+ apply (simp add: varET_neq2) 
  apply (simp add: ext_simp)+ 
apply (rule, rule) apply (erule subst_cases) apply clarsimp apply (rule ext, fast)
done

lemma subst_unique[rule_format]:"(subst f T S1 \<longrightarrow> (\<forall> S2 . subst f T S2 \<longrightarrow> S1=S2))"
by (simp add: subst_substlist_unique) 

consts fldlookup::"heap \<Rightarrow> locn \<Rightarrow> fldname \<Rightarrow> val"
primrec
"fldlookup h l (ifldn F) = IVal(h<l\<bullet>F>)"
"fldlookup h l (rfldn F) = RVal(h\<lfloor>l\<diamondsuit>F\<rfloor>)"

consts models::"(val \<times> heap \<times> Tp \<times> (locn set)) set"
inductive models intros
(*modelsUnit:"(arbitrary, h, unitET,{}):models"*)
modelsInt: "(IVal i,h, intET,{}):models"

modelsNode: "\<lbrakk>h@@l = Some DIAM; h<l\<bullet>DOLLAR>=i; R={l}\<rbrakk> \<Longrightarrow> (RVal (Ref l), h, nodeET (n,T,i), R):models"

modelsSum: "\<lbrakk>h@@l = Some DIAM;  h<l\<bullet>DOLLAR> \<in> {i,j}; i \<noteq> j;
             h<l\<bullet>DOLLAR>=i \<longrightarrow> (RVal (Ref l), h, T, R):models;
             h<l\<bullet>DOLLAR>=j \<longrightarrow> (RVal (Ref l), h, S, R):models\<rbrakk>
              \<Longrightarrow> (RVal (Ref l), h, sumET (n,T,i) (m,S,j), R):models"

modelsRecN:"\<lbrakk>h@@l = Some DIAM; R = {l}\<rbrakk>
              \<Longrightarrow> (RVal (Ref l), h, recET [], R):models"

modelsRecC:"\<lbrakk>h@@l = Some DIAM;
             FT = (F,T);
             (fldlookup h l F, h, T, reg1):models;
             (RVal (Ref l), h, recET FTs, reg2):models;
             l \<notin> reg1; reg1 \<inter> reg2 = {};  R = reg1 \<union> reg2\<rbrakk>
              \<Longrightarrow> (RVal (Ref l), h, recET (FT#FTs), R):models"

modelsMu:"\<lbrakk>h@@l = Some DIAM; subst T (muET T) TT;
           (RVal (Ref l), h, TT, R) : models
           \<rbrakk> \<Longrightarrow> (RVal (Ref l), h, muET T, R) : models"

lemma modelsRec2:"\<lbrakk>h@@l = Some DIAM;
            (fldlookup h l F1, h, T, reg1):models;
            (fldlookup h l F2, h, S, reg2):models;
            reg1 \<inter> reg2 = {}; l \<notin> reg1 \<union> reg2; R = reg1 \<union> reg2 \<union> {l}\<rbrakk>
              \<Longrightarrow> (RVal (Ref l), h, recET [(F1,T),(F2,S)], R):models"
apply (rule models.intros, assumption)
apply simp apply rule apply simp apply simp
apply assumption
apply (rule models.intros, assumption)
apply simp apply rule apply simp apply simp
apply assumption
apply (rule models.intros, assumption)
apply simp+
done

(*consts substR::"(Tvar \<Rightarrow> Tp) \<Rightarrow> Tp \<Rightarrow> (Tp option)"*)
(*for unitET := recET [] we have
lemma modelsUnit: "h@@l=Some DIAM \<Longrightarrow> (RVal (Ref l) ,h, unitET,{l}):models"
by (simp add: unitET_def, erule models.intros, simp+)
*)
(*maybe we should not define unitET as a heap-space-consuming type?, i.e. not as recET [] ??*)

lemma modelsLocn[rule_format]:
"(v, h, T, R) : models \<Longrightarrow> (\<forall> l. v=RVal (Ref l) \<longrightarrow> l:R)"
apply (erule models.induct) 
apply clarsimp
apply clarsimp
apply clarsimp 
  apply (erule disjE)
  apply clarsimp apply clarsimp
apply clarsimp
apply clarsimp
apply clarsimp
done

lemma models_region_in_heap:"(v, h, T, R) \<in> models \<Longrightarrow> R \<subseteq> Dom h"
apply (erule models.induct,fast, simp add: fmap_lookup_def dom_def fmap_dom_def)
apply clarsimp
apply fastsimp
apply(simp add: fmap_lookup_def dom_def fmap_dom_def) 
apply clarsimp
apply (erule disjE)
  apply fastsimp
  apply fast
apply assumption 
done

lemma models_Unique[rule_format]: "(v,h,T,R) \<in> models \<Longrightarrow> (\<forall> RR . (v,h,T,RR) \<in> models \<longrightarrow> R=RR)"
apply (erule models.induct)
apply clarsimp apply (erule models.elims) apply clarsimp apply simp apply simp apply simp apply simp apply clarsimp
apply clarsimp apply (erule models.elims) apply clarsimp apply simp apply simp apply simp apply simp apply clarsimp
apply clarsimp apply (erule models.elims) apply simp apply clarsimp apply clarsimp
  apply (erule disjE) apply clarsimp apply clarsimp
  apply (simp, simp, simp)
apply clarsimp apply (erule models.elims) apply simp apply simp apply simp apply simp apply simp apply clarsimp
apply (rule, rule) apply (rotate_tac -1)  apply(erule models.elims) apply clarify+ apply clarsimp apply clarify
apply clarify
  apply (rotate_tac -1, erule models.elims, clarify+)
  apply (drule subst_unique, assumption) 
  apply (erule_tac x=Ra in allE, clarsimp) 
done

lemma models_Preserved[rule_format]:
  "(v, h, T, R) \<in> models \<Longrightarrow> (\<forall> hh. (\<forall> l. l \<in> R \<longrightarrow> sameOH {l} h hh) \<longrightarrow> (v, hh, T, R) \<in> models)"
apply (erule models.induct)
apply clarsimp apply (rule models.intros)
apply clarsimp apply (rule models.intros) apply (simp add: sameOH_def, simp)
       apply (simp add: sameOH_def, simp)
apply clarsimp
  apply (erule disjE)
  apply clarsimp 
   apply (erule_tac x=hh in allE, clarsimp) 
   apply (frule modelsLocn, simp) 
   apply (subgoal_tac "h<l\<bullet>DOLLAR> = hh<l\<bullet>DOLLAR>", clarsimp)
   prefer 2 apply (erule_tac x=l in allE)  apply (simp add: sameOH_def)
   apply (rule models.intros)
    apply (simp add: sameOH_def)
    apply clarsimp 
    apply clarsimp 
    apply clarsimp 
    apply clarsimp 
  apply clarsimp 
   apply (erule_tac x=hh in allE, clarsimp) 
   apply (frule modelsLocn, simp) 
   apply (subgoal_tac "h<l\<bullet>DOLLAR> = hh<l\<bullet>DOLLAR>", clarsimp)
   prefer 2 apply (erule_tac x=l in allE)  apply (simp add: sameOH_def)
   apply (rule models.intros)
    apply (simp add: sameOH_def)
    apply clarsimp 
    apply clarsimp 
    apply clarsimp 
    apply clarsimp
apply clarsimp
  apply (rule models.intros)
    apply (simp add: sameOH_def)
    apply simp
apply clarsimp
  apply (frule modelsLocn, simp)
  apply (rule models.intros)
  apply (erule_tac x=l in allE, clarsimp)
    apply (simp add: sameOH_def) 
  apply fastsimp 
  apply (erule_tac x=hh in allE) apply clarsimp 
   apply (subgoal_tac "fldlookup hh l F = fldlookup h l F", clarsimp) apply assumption
     apply (erule_tac x=l in allE, clarsimp) apply (case_tac F) apply (simp add: sameOH_def) apply (simp add: sameOH_def)
  apply (rotate_tac 3) apply (erule_tac x=hh in allE) apply clarsimp apply assumption
  apply assumption+
  apply fast
apply clarsimp  apply (rule models.intros)
  apply (drule modelsLocn) apply simp
    apply (simp add: sameOH_def) 
  apply assumption
 apply fast
done

consts modelsET::"(val \<times> heap \<times> Tp \<times> (locn set) \<times> A) set"
inductive modelsET intros
modelsETInt: "(IVal i,h, intET,{}, 0):modelsET"

modelsETSum: "\<lbrakk>h@@l = Some DIAM; h<l\<bullet>DOLLAR> \<in> {i,j}; i \<noteq> j;
               h<l\<bullet>DOLLAR>=i \<longrightarrow> (RVal (Ref l), h, T, R, N):modelsET \<and> NM = n+N;
               h<l\<bullet>DOLLAR>=j \<longrightarrow> (RVal (Ref l), h, S, R, M):modelsET \<and> NM = m+M\<rbrakk>
              \<Longrightarrow> (RVal (Ref l), h, sumET (n,T,i) (m,S,j), R,NM):modelsET"

modelsETNode: "\<lbrakk>h@@l = Some DIAM; h<l\<bullet>DOLLAR>=i; R={l}; n=m\<rbrakk> \<Longrightarrow> (RVal (Ref l), h, nodeET (m,T,i), R,n):modelsET"

modelsETRecN:"\<lbrakk>h@@l = Some DIAM; R={l}\<rbrakk>
              \<Longrightarrow> (RVal (Ref l), h, recET [], R,0):modelsET"

modelsETRecC:"\<lbrakk>h@@l = Some DIAM;
             FT = (F,T); F \<notin> set (map fst FTs);
             (fldlookup h l F, h, T, reg1,N):modelsET;
             (RVal (Ref l), h, recET FTs, reg2,M):modelsET;
             l \<notin> reg1; reg1 \<inter> reg2 = {};  R = reg1 \<union> reg2; NM= N+M\<rbrakk>
              \<Longrightarrow> (RVal (Ref l), h, recET (FT#FTs), R,NM):modelsET"

modelsETMu:"\<lbrakk>h@@l = Some DIAM; subst T (muET T) TT;
             (RVal (Ref l), h, TT, R,N) : modelsET
            \<rbrakk> \<Longrightarrow> (RVal (Ref l), h, muET T, R,N) : modelsET"

lemma modelsETLocn[rule_format]:
"(v, h, T, R,N) : modelsET \<Longrightarrow> (\<forall> l . v=RVal (Ref l) \<longrightarrow> l:R)"
apply (erule modelsET.induct) 
apply clarsimp
apply clarsimp 
apply fastsimp 
apply clarsimp
apply clarsimp
apply clarsimp
apply clarsimp
done

lemma modelsET_isLocn: "(RVal r, h, T, R, S) \<in> modelsET \<Longrightarrow> \<exists> l. r=Ref l"
by (erule modelsET.elims, simp_all)

lemma modelsET_region_in_heap:"(v,h,T, R,N) \<in> modelsET \<Longrightarrow> R \<subseteq> Dom h"
apply (erule modelsET.induct,fast)
apply fastsimp
apply clarsimp apply(simp add: fmap_lookup_def dom_def fmap_dom_def)
apply clarsimp apply(simp add: fmap_lookup_def dom_def fmap_dom_def)
apply clarsimp
apply (erule disjE)
  apply fastsimp
  apply fast
apply assumption 
done

lemma modelsET_Unique[rule_format]: 
"(v,h,T,R,N) \<in> modelsET \<Longrightarrow> (\<forall> RR NN. (v,h,T,RR,NN) \<in> modelsET \<longrightarrow> R=RR \<and> N=NN)"
apply (erule modelsET.induct)
apply clarsimp apply (erule modelsET.elims) apply clarsimp apply simp apply simp apply simp apply simp apply simp
apply clarsimp apply (erule modelsET.elims) apply simp apply clarsimp 
  apply (erule disjE) apply clarsimp apply clarsimp apply clarsimp
  apply (simp, simp, simp)
apply clarsimp apply (erule modelsET.elims) apply simp apply simp apply simp apply simp apply simp apply simp
apply (rule, rule, rule) apply(erule modelsET.elims) apply clarify+ apply simp apply clarsimp apply clarsimp
apply (rule, rule, rule) apply (rotate_tac -1) apply(erule modelsET.elims) apply clarify+  apply simp
  apply (erule_tac x=reg1 in allE,erule_tac x=N in allE) apply (erule impE) apply assumption
  apply (erule_tac x=reg2 in allE,erule_tac x=M in allE) apply (erule impE) apply assumption 
  apply simp 
apply clarify
apply (rotate_tac -1) apply (erule modelsET.elims) apply clarify+
apply (drule subst_unique, assumption) apply clarsimp 
done

lemma modelsET_recET_FldContained[rule_format]:
"\<forall> v h T R N . (v,h,T,R,N) : modelsET \<longrightarrow>
       T = recET FTs \<longrightarrow> (\<forall> l . v = RVal(Ref l) \<longrightarrow> (\<forall> F TT . (F,TT) : set FTs \<longrightarrow> 
         (\<exists> rg1 N1 . (fldlookup h l F, h, TT, rg1,N1):modelsET \<and>
                   l \<notin> rg1 \<and>  rg1 \<subseteq> R \<and> N1 \<le> N)))"
apply (induct_tac FTs)
apply clarsimp
apply clarsimp
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply rule
  apply clarsimp apply (rule, rule, rule, assumption, simp) apply fast
  apply clarsimp apply (erule_tac x="RVal (Ref la)" in allE, erule_tac x=ha in allE,
                        erule_tac x="reg2" in allE, erule_tac x="M" in allE, clarsimp)
                 apply (erule_tac x=F in allE, erule_tac x="TT" in allE, clarsimp)
                 apply (rule, rule, rule, assumption, simp) apply fast
done

lemma modelsET_recET_FldsDistinct[rule_format]:
"(v,h,T,R,N) : modelsET \<Longrightarrow>
       (\<forall> FTs . T = recET FTs \<longrightarrow> distinct (map fst FTs))"
apply (erule modelsET.induct)
apply clarsimp
apply clarsimp
apply clarsimp
apply clarsimp
apply clarsimp
apply clarsimp
done

lemma modelsET_HD_END_aux[rule_format]:
"\<forall> f T l h R N . (RVal (Ref l),h,recET (f#T),R,N) : modelsET \<longrightarrow> length T = n \<longrightarrow> (RVal (Ref l),h,recET (T @ [f]),R,N) : modelsET"
apply (induct_tac n)
apply clarsimp
apply clarsimp
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (case_tac "FTs", clarsimp+)
  apply (rotate_tac 3)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply(erule_tac x="F" in allE, erule_tac x=Ta in allE)
  apply(erule_tac x="FTs" in allE, erule_tac x=l in allE)
  apply(erule_tac x="h" in allE, erule_tac x="reg1 \<union> reg2a" in allE)
  apply(erule_tac x="Na+Ma" in allE, erule impE)
  apply (rule modelsETRecC) 
   apply assumption
   apply fast
   apply simp
   apply assumption
   apply assumption
   apply assumption
   apply fast
   apply simp
   apply simp
apply clarsimp
  apply (rule modelsETRecC) 
   apply assumption
   apply fast
   apply fastsimp
   apply assumption
   apply assumption
   apply assumption
   apply fast
   apply fast
   apply simp
done

lemma modelsET_HD_END[rule_format]:
"\<lbrakk>(RVal (Ref l),h,recET (f#T),R,N) : modelsET\<rbrakk> \<Longrightarrow> (RVal (Ref l),h,recET (T @ [f]),R,N) : modelsET"
by (drule modelsET_HD_END_aux, simp, assumption)

lemma "\<lbrakk>h@@l = Some DIAM;
            (fldlookup h l F1, h, T, reg1,N):modelsET;
            (fldlookup h l F2, h, S, reg2,M):modelsET;F1\<noteq>F2;
            reg1 \<inter> reg2 = {}; l \<notin> reg1 \<union> reg2; R = reg1 \<union> reg2 \<union> {l}\<rbrakk>
              \<Longrightarrow> (RVal (Ref l), h, recET [(F1,T),(F2,S)], R, N + M):modelsET"
apply (rule modelsET.intros, assumption)
apply fastsimp
apply simp
apply assumption
apply (rule modelsET.intros, assumption)
apply fastsimp 
apply simp
apply assumption
apply (rule modelsET.intros, assumption)
apply simp+
done

lemma modelsET_Preserved[rule_format]:
  "(v,h,T,R,N) \<in> modelsET \<Longrightarrow> (\<forall> hh. (\<forall> l. l \<in> R \<longrightarrow> sameOH {l} h hh) \<longrightarrow> (v,hh,T,R,N) \<in> modelsET)"
apply (erule modelsET.induct)
apply clarsimp apply (rule modelsET.intros)
apply clarsimp
  apply (erule disjE)
   apply clarsimp 
     apply(frule modelsETLocn, simp)
     apply (erule_tac x=hh in allE) apply clarsimp
     apply (erule_tac x=l in allE, clarsimp)
     apply (subgoal_tac "h<l\<bullet>DOLLAR> = hh<l\<bullet>DOLLAR>", clarsimp)
     prefer 2 apply (simp add: sameOH_def)
     apply (rule modelsET.intros)
       apply (simp add: sameOH_def)
       apply clarsimp 
       apply assumption 
       apply clarsimp apply fast 
       apply clarsimp 
   apply clarsimp 
     apply(frule modelsETLocn, simp)
     apply (erule_tac x=hh in allE) apply clarsimp
     apply (erule_tac x=l in allE, clarsimp)
     apply (subgoal_tac "h<l\<bullet>DOLLAR> = hh<l\<bullet>DOLLAR>", clarsimp)
     prefer 2 apply (simp add: sameOH_def)
     apply (rule modelsET.intros)
       apply (simp add: sameOH_def)
       apply clarsimp 
       apply assumption 
       apply clarsimp apply fast 
       apply clarsimp
apply (rule modelsET.intros)  
    apply (simp add: sameOH_def) 
    apply (simp add: sameOH_def)
    apply simp
    apply simp
apply clarsimp
  apply (rule modelsET.intros) 
    apply (simp add: sameOH_def)
    apply simp
apply clarsimp
  apply (frule modelsETLocn, simp)
  apply (rule modelsET.intros)
  apply (erule_tac x=l in allE, clarsimp)
    apply (simp add: sameOH_def)
  apply fastsimp 
  apply simp
  apply (erule_tac x=hh in allE) apply clarsimp 
   apply (subgoal_tac "fldlookup hh l F = fldlookup h l F", clarsimp) apply assumption
     apply (erule_tac x=l in allE, clarsimp) apply (case_tac F) apply (simp add: sameOH_def) apply (simp add: sameOH_def)
  apply (rotate_tac 4) apply (erule_tac x=hh in allE) apply clarsimp apply assumption
  apply assumption+
  apply fast
  apply simp
apply clarsimp  apply (rule modelsET.intros)
  apply (drule modelsETLocn) apply simp
    apply (simp add: sameOH_def) 
  apply assumption
 apply fast
done

lemma modelsET_region_in_heap1:"\<lbrakk>(v,h,T,R,S): modelsET; a:R\<rbrakk> \<Longrightarrow> a: Dom h"
by (insert modelsET_region_in_heap, fastsimp)

subsection {*Access paths and contexts*}

datatype AP = 
  varAP rname
| nodeAP rname
| rfldAP AP rfldname

consts locns ::"ref \<Rightarrow> locn set"
primrec
"locns Nullref = {}"
"locns (Ref l) = {l}"

consts evalAP::"AP \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> (ref \<times> (locn set)) option"
primrec
"evalAP (varAP x) E h = (if locns (E\<lfloor>x\<rfloor>) \<subseteq> Dom h then Some (E\<lfloor>x\<rfloor>, locns (E\<lfloor>x\<rfloor>)) else None)"
"evalAP (nodeAP x) E h = (if locns (E\<lfloor>x\<rfloor>) \<subseteq> Dom h then Some (E\<lfloor>x\<rfloor>, locns (E\<lfloor>x\<rfloor>)) else None)"
"evalAP (rfldAP p F) E h = (case evalAP p E h of
                              None \<Rightarrow> None
                            | Some r \<Rightarrow> (case (fst r) of 
                                          Nullref \<Rightarrow> None
                                        | Ref l \<Rightarrow> (if locns(h\<lfloor>l\<diamondsuit>F\<rfloor>) \<subseteq> Dom h
                                                    then Some(h\<lfloor>l\<diamondsuit>F\<rfloor>, (snd r) \<union> (locns (h\<lfloor>l\<diamondsuit>F\<rfloor>)))
                                                    else None)))"

lemma renvEvalAP: "(renv E = renv EE) \<Longrightarrow> evalAP p E h = evalAP p EE h"
by (induct p, simp+)

lemma evalAP_DomAux[rule_format]: "\<forall> v. (evalAP x E h = v \<longrightarrow> (\<forall> r L . v = Some (r, L) \<longrightarrow> L \<subseteq> Dom h))"
apply (induct x)
apply clarsimp
apply clarsimp
apply clarsimp
  apply (case_tac "evalAP AP E h", clarsimp, clarsimp) 
  apply (case_tac a, clarsimp, clarsimp)
  apply (case_tac "locns h\<lfloor>nat\<diamondsuit>rfldname\<rfloor> \<subseteq> Dom h", fastsimp)
  apply clarsimp
done

lemma evalAP_Dom: "evalAP x E h = Some (r, L) \<Longrightarrow> L \<subseteq> Dom h"
by (drule evalAP_DomAux, fastsimp, simp)

lemma evalInclude: "evalAP p E h = Some (Ref l, R) \<Longrightarrow> l : R"
apply (induct p)
apply clarsimp
  apply (case_tac "locns (renv E rname) \<subseteq> Dom h", clarsimp, clarsimp)
apply clarsimp
  apply (case_tac "locns (renv E rname) \<subseteq> Dom h", clarsimp, clarsimp)
apply clarsimp
  apply (case_tac "evalAP AP E h", clarsimp+)
  apply (case_tac a, clarsimp+)
  apply (case_tac "locns h\<lfloor>nat\<diamondsuit>rfldname\<rfloor> \<subseteq> Dom h", fastsimp, clarsimp)
done

lemma sameOHAntiMonotone:"\<lbrakk>sameOH R h hh; S \<subseteq> R\<rbrakk> \<Longrightarrow> sameOH S h hh"
by (simp add: sameOH_def, fastsimp)

lemma sameAntiMonotone:"\<lbrakk>same R h hh; S \<subseteq> R\<rbrakk> \<Longrightarrow> same S h hh"
by (simp add: same_def, clarsimp, erule sameOHAntiMonotone, clarsimp) 

lemma sameOH_Aux1:
  "\<lbrakk>sameOH (b \<union> locns h\<lfloor>l\<diamondsuit>F\<rfloor>) h hh; evalAP AP E h = Some (Ref l, b); locns h\<lfloor>l\<diamondsuit>F\<rfloor> \<subseteq> Dom h;
          evalAP AP E hh = Some (Ref l, b); locns hh\<lfloor>l\<diamondsuit>F\<rfloor> \<subseteq> Dom hh\<rbrakk>
       \<Longrightarrow> hh\<lfloor>l\<diamondsuit>F\<rfloor> = h\<lfloor>l\<diamondsuit>F\<rfloor>"
apply (unfold sameOH_def) 
apply (erule_tac x=l in allE, erule impE) apply (drule evalInclude,fast) apply clarsimp
done
lemma sameOH_Aux2:
  "\<lbrakk>sameOH (b \<union> locns h\<lfloor>l\<diamondsuit>F\<rfloor>) h hh; evalAP AP E h = Some (Ref l, b); locns h\<lfloor>l\<diamondsuit>F\<rfloor> \<subseteq> Dom h;
          evalAP AP E hh = Some (Ref l, b); locns hh\<lfloor>l\<diamondsuit>F\<rfloor> \<subseteq> Dom hh; x \<notin> locns h\<lfloor>l\<diamondsuit>F\<rfloor>; x \<in> locns hh\<lfloor>l\<diamondsuit>F\<rfloor>\<rbrakk>
       \<Longrightarrow> x \<in> b"
apply (unfold sameOH_def) 
apply (erule_tac x=l in allE, erule impE) apply (drule evalInclude,fast) apply clarsimp
done
lemma sameOH_Aux3:
  " \<lbrakk>sameOH (b \<union> locns h\<lfloor>l\<diamondsuit>F\<rfloor>) h hh; evalAP AP E h = Some (Ref l, b); locns h\<lfloor>l\<diamondsuit>F\<rfloor> \<subseteq> Dom h;
          evalAP AP E hh = Some (Ref l, b); locns hh\<lfloor>l\<diamondsuit>F\<rfloor> \<subseteq> Dom hh; x \<notin> locns hh\<lfloor>l\<diamondsuit>F\<rfloor>; x \<in> locns h\<lfloor>l\<diamondsuit>F\<rfloor>\<rbrakk>
       \<Longrightarrow> x \<in> b"
apply (unfold sameOH_def) 
apply (erule_tac x=l in allE, erule impE) apply (drule evalInclude,fast) apply clarsimp
done
lemma evalAP_SameOHAux[rule_format]:
"\<forall> v. (evalAP p E h = v \<longrightarrow> (\<forall> r L . v=Some(r,L) \<longrightarrow> sameOH L h hh \<longrightarrow> evalAP p E hh = v))"
apply (induct p)
  apply clarsimp
  apply (simp add: fmap_dom_def dom_def  fmap_lookup_def sameOH_def, fastsimp)
  apply clarsimp
  apply (simp add: fmap_dom_def dom_def  fmap_lookup_def sameOH_def, fastsimp)
apply clarsimp 
  apply (case_tac "evalAP AP E h", clarsimp+)
  apply (case_tac "a", clarsimp+)
  apply (case_tac "locns h\<lfloor>nat\<diamondsuit>rfldname\<rfloor> \<subseteq> Dom h", clarsimp+) prefer 2 apply clarsimp
  apply (erule impE) apply (erule sameOHAntiMonotone,fast)
  apply clarsimp
  apply safe
    apply (erule sameOH_Aux1,assumption+)
    apply (erule sameOH_Aux2,assumption+)
    apply (erule sameOH_Aux3,assumption+)
apply (case_tac "x \<in> locns h\<lfloor>nat\<diamondsuit>rfldname\<rfloor>")
    apply (unfold sameOH_def)
    apply (erule_tac x=x in allE, erule impE) apply fastsimp
    apply (subgoal_tac "x:Dom h") 
    apply (simp add: dom_def fmap_dom_def fmap_lookup_def) apply fastsimp
    apply (erule_tac x=nat in allE, erule impE, drule evalInclude,fast, clarsimp) 
done
lemma evalAP_Same[rule_format]:
"\<lbrakk>evalAP p E h = Some(r,L); sameOH L h hh\<rbrakk> \<Longrightarrow> evalAP p E hh = Some(r,L)"
by (drule evalAP_SameOHAux, fastsimp, assumption+)

lemma evalAP_Unique[rule_format]:"evalAP p E h = v \<Longrightarrow> (\<forall> w . evalAP p E h = w \<longrightarrow> w=v)"
apply (induct p)
apply simp
apply simp
apply (case_tac "evalAP AP E h", clarsimp+)
done

consts root::"AP \<Rightarrow> rname"
primrec
"root (varAP x) = x"
"root (nodeAP x) = x"
"root (rfldAP p F) = root p"

lemma evalAP_root[rule_format]:"\<forall> v . evalAP p E h = v \<longrightarrow> (\<forall> EE . E\<lfloor>(root p)\<rfloor> = EE\<lfloor>(root p)\<rfloor> \<longrightarrow> evalAP p EE h = v)"
apply (induct p)
apply clarsimp
apply clarsimp
apply (rule, rule, rule, rule)
  apply (subgoal_tac "\<exists> w . evalAP AP E h = w", erule exE)
  apply (erule_tac x=w in allE, erule impE, assumption)
  apply (erule_tac x=EE in allE, erule impE) apply simp
  apply simp
  apply (erule thin_rl) apply simp
done

lemma evalAP_EE:
"evalAP p E h = evalAP q EE h \<Longrightarrow> evalAP (rfldAP p F) E h = evalAP (rfldAP q F) EE h"
by simp

types Context = "(rname \<leadsto>\<^sub>f Tp)"

constdefs DOM:: "Context \<Rightarrow> rname set"
"DOM == fmap_dom"

constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Tp option)"
"GETr G x \<equiv> fmap_lookup G x"

lemma GETrNONE1: "x \<notin> DOM C \<Longrightarrow> None = GETr C x"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GETrNONE2: "GETr C x = None \<Longrightarrow> x \<notin> DOM C"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_Update: "{x} \<union> (DOM b) = DOM (b(x\<mapsto>\<^sub>fT))" by (simp add: DOM_def)

lemma DOM_Update1: "\<lbrakk>y \<in> DOM (C(x\<mapsto>\<^sub>fT)); x \<noteq> y\<rbrakk> \<Longrightarrow> y:DOM C"
by (subgoal_tac "y \<noteq> x", insert DOM_Update, fast,fast)

lemma GETr_Update1: "x \<noteq> y \<Longrightarrow> GETr (G(x\<mapsto>\<^sub>fk)) y = GETr G y"
apply (subgoal_tac "y \<noteq> x")
apply (simp add: GETr_def)
apply (insert FMAPlookup2 [of y x G], auto)
done

lemma GETr_Update1a: "x \<noteq> y \<Longrightarrow> GETr G y = GETr (G(x\<mapsto>\<^sub>fk)) y"
apply (subgoal_tac "y \<noteq> x")
apply (simp add: GETr_def)
apply (insert FMAPlookup2 [of y x G], auto)
done

lemma GETr_Update2: "\<lbrakk>GETr G xa = Some T; x \<noteq> xa\<rbrakk> \<Longrightarrow> GETr (G(x\<mapsto>\<^sub>fk)) xa = Some T"
by (subgoal_tac "GETr (G(x\<mapsto>\<^sub>fk)) xa = GETr G xa", clarsimp, erule GETr_Update1)

lemma GETr_Trans1:"\<lbrakk>GETr C y = S; S=T; x\<noteq>y\<rbrakk> \<Longrightarrow> GETr (C(x\<mapsto>\<^sub>fTT)) y = T"
by (clarsimp, erule GETr_Update1)

lemma GETr_Trans2:"\<lbrakk>S = GETr C y; S=T; x\<noteq>y\<rbrakk> \<Longrightarrow> T = GETr (C(x\<mapsto>\<^sub>fTT)) y"
by (clarsimp, subgoal_tac "GETr (C(x\<mapsto>\<^sub>fTT)) y = GETr C y", clarsimp, erule GETr_Update1)

lemma GETrSome_DOM:"GETr G x = Some T \<Longrightarrow> x \<in> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GETrNone_DOM:"GETr G x = None \<Longrightarrow> x \<notin> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETrSome:"x \<in> DOM G \<Longrightarrow> (\<exists> T . GETr G x = Some T)"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETrNone:"x \<notin> DOM G \<Longrightarrow> GETr G x = None"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETr_DOM: "\<lbrakk>x \<in> DOM D; x \<in> U; GETr C x = GETr D x\<rbrakk> \<Longrightarrow> x \<in> DOM C"
apply (subgoal_tac "\<exists> T. GETr D x = Some T", clarsimp)
apply (rule GETrSome_DOM, clarsimp, simp)
apply (erule DOM_GETrSome)
done

lemma UsedVarsDOM1:
"\<lbrakk>\<forall>x. x \<in> U \<longrightarrow> GETr D x = GETr C x; DOM C \<subseteq> DOM D; x \<in> U; x \<in> DOM D\<rbrakk> \<Longrightarrow> x:DOM C"
apply (erule_tac x=x in allE,clarsimp)
apply (subgoal_tac "\<exists> T . GETr D x = Some T",clarsimp)
apply (rule GETrSome_DOM) apply fast
apply (erule DOM_GETrSome)
done
(*>*)

consts lookup::"('a \<times> 'b) list \<Rightarrow> 'a \<Rightarrow> 'b option"
primrec
"lookup [] a = None"
"lookup (h#t) a = (if fst h = a then Some (snd h) else lookup t a)"

(*consts lookupAP_Rec::"Tp \<Rightarrow> fldname \<Rightarrow> Tp option"
primrec
"lookupAP_Rec intET F = None"
"lookupAP_Rec (nodeET N) F = None"
"lookupAP_Rec (varET x) F = None"
"lookupAP_Rec (sumET S T) F = None"
"lookupAP_Rec (recET L) F = lookup L F"
"lookupAP_Rec (muET T) F = None"

consts lookupAP_Sum::"Tp \<Rightarrow> heap \<Rightarrow> locn \<Rightarrow> fldname \<Rightarrow> Tp option"
primrec
"lookupAP_Sum intET h l F = None"
"lookupAP_Sum (nodeET N) h l F = None"
"lookupAP_Sum (varET x) h l F = None"
"lookupAP_Sum (sumET S T) h l F =
                (if (h<l\<bullet>DOLLAR> = 0) then lookupAP_Rec (fst(snd S)) F else lookupAP_Rec (fst(snd T)) F)"
"lookupAP_Sum (recET L) h l F = None"
"lookupAP_Sum (muET T) h l F = None"
*)

(*is inductive since subst is*)
consts lookupAP::"(Context \<times> AP \<times> env \<times> heap \<times> Tp) set"
inductive lookupAP intros
lookupAP_Var:"\<lbrakk>GETr C x = Some T; E\<lfloor>x\<rfloor> = Ref a; h@@a = Some DIAM\<rbrakk> \<Longrightarrow>(C,varAP x,E,h,T):lookupAP"
lookupAP_Node:"\<lbrakk>GETr C x = Some T; T = nodeET (n,TT,i);
                E\<lfloor>x\<rfloor> = Ref a; h@@a = Some DIAM;
                h<a\<bullet>DOLLAR> = i\<rbrakk> \<Longrightarrow> (C, nodeAP x, E, h, T):lookupAP"
lookupAP_Mu:"\<lbrakk>(C,p,E,h,muET T):lookupAP;
                subst T (muET T) (sumET (kL,recET T1,i) (kR,recET T2,j));
                evalAP p E h = Some (Ref l, LL); h@@l = Some DIAM;
                h<l\<bullet>DOLLAR> \<in> {i,j}; i \<noteq> j;
                h<l\<bullet>DOLLAR> = i \<longrightarrow> lookup T1 (rfldn F) = Some TT;
                h<l\<bullet>DOLLAR> = j \<longrightarrow> lookup T2 (rfldn F) = Some TT
               \<rbrakk> \<Longrightarrow> (C,rfldAP p F,E,h,TT):lookupAP"
lookupAP_Sum:"\<lbrakk>(C,p,E,h,sumET (kL,recET S,i) (kR,recET T,j)):lookupAP;
                evalAP p E h = Some (Ref l, LL); h@@l = Some DIAM;
                h<l\<bullet>DOLLAR> \<in> {i,j}; i \<noteq> j;
                h<l\<bullet>DOLLAR> = i \<longrightarrow> lookup S (rfldn F) = Some TT;
                h<l\<bullet>DOLLAR> = j \<longrightarrow> lookup T (rfldn F) = Some TT
               \<rbrakk> \<Longrightarrow> (C,rfldAP p F,E,h,TT):lookupAP"
lookupAP_RfldNode:"\<lbrakk>(C,p,E,h,nodeET (n, recET T,i)):lookupAP;
                     evalAP p E h = Some (Ref l, LL); h@@l = Some DIAM;
                     lookup T (rfldn F) = Some TT
                   \<rbrakk> \<Longrightarrow> (C,rfldAP p F,E,h,TT):lookupAP"
lookupAP_RfldRec:"\<lbrakk>(C,p,E,h,recET T):lookupAP;
                   evalAP p E h = Some (Ref l, LL); h@@l = Some DIAM;
                   lookup T (rfldn F) = Some TT
                  \<rbrakk> \<Longrightarrow> (C,rfldAP p F,E,h,TT):lookupAP"

lemma lookupAP_Node_GETr:
"\<lbrakk>(C, rfldAP (nodeAP l) F, E, h, T) \<in> lookupAP;
  GETr C l = Some (nodeET (k,recET TT,i)); E\<lfloor>l\<rfloor> = Ref a\<rbrakk>
 \<Longrightarrow> lookup TT (rfldn F) = Some T \<and> h<a\<bullet>DOLLAR>=i"
apply (erule lookupAP.elims, simp_all)
apply clarsimp apply (erule lookupAP.elims, simp_all)
apply clarsimp apply (erule lookupAP.elims, simp_all)
apply clarsimp apply (case_tac "a : Dom h", clarsimp) prefer 2 apply clarsimp
  apply (erule lookupAP.elims, simp_all) 
apply clarsimp apply (erule lookupAP.elims, simp_all)
done


constdefs iTree:: "ifldname \<Rightarrow> rfldname \<Rightarrow> rfldname \<Rightarrow> A \<Rightarrow> A \<Rightarrow> Tp"
"iTree I L R kN kC == muET (\<lambda> X . sumET (kN, recET [(ifldn I,intET)],0) 
                                        (kC, recET [(rfldn L,varET X), (rfldn R,varET X)],1))"

constdefs iList:: "ifldname \<Rightarrow> rfldname \<Rightarrow> A \<Rightarrow> A \<Rightarrow> Tp"
"iList V R kN kC == muET (\<lambda> X . sumET (kN, recET [],0) 
                                     (kC, recET [(ifldn V,intET), (rfldn R,varET X)],1))"

constdefs LT::"rfldname \<Rightarrow> ifldname \<Rightarrow> rfldname \<Rightarrow> ifldname \<Rightarrow> rfldname \<Rightarrow> rfldname \<Rightarrow> Tp"
"LT F VV RR I RRR RRRR == sumET (1,recET [(rfldn F,iList VV RR 2 3)],0) (4,recET [(rfldn F,iTree I RRR RRRR 5 6)],1)"

lemma LT1:
"\<lbrakk>GETr C x = Some(LT F HD TL CONT LEFT RIGHT);
  evalAP (varAP x) E h = Some(Ref l,LL); h@@l = Some DIAM; h<l\<bullet>DOLLAR> =1\<rbrakk>
 \<Longrightarrow> (C,rfldAP (varAP x) F,E,h,iTree CONT LEFT RIGHT 5 6):lookupAP"
apply (rule lookupAP_Sum, simp)
apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (rule lookupAP_Var, simp add: LT_def, fastsimp)
apply assumption+
apply clarsimp+
done
lemma "\<lbrakk>GETr C x = Some(LT F HD TL CONT LEFT RIGHT);
        evalAP (varAP x) E h = Some(Ref l,L); h@@l = Some DIAM; h<l\<bullet>DOLLAR> =1;
        evalAP (rfldAP (varAP x) F) E h = Some(Ref ll,LL); h@@ll = Some DIAM; h<ll\<bullet>DOLLAR> =1
        \<rbrakk> \<Longrightarrow> (C,rfldAP (rfldAP (varAP x) F) RIGHT,E,h,iTree CONT LEFT RIGHT 5 6):lookupAP"
apply (drule LT1, assumption+)
apply (rule lookupAP_Mu) apply (unfold iTree_def, assumption)
    apply (rule substitution_listsubstitution.intros)+
apply assumption+
apply clarsimp+
done

lemma lookupAP_Unique[rule_format]: "(C,p,E,h,T):lookupAP \<Longrightarrow> (\<forall> TT . (C,p,E,h,TT):lookupAP \<longrightarrow> T=TT)"
apply (erule lookupAP.induct)
apply clarsimp
  apply (erule lookupAP.elims)
  apply clarsimp  apply clarsimp apply clarsimp apply clarsimp apply clarsimp apply clarsimp
apply clarsimp
  apply (erule lookupAP.elims)
  apply clarsimp  apply clarsimp apply clarsimp apply clarsimp apply clarsimp apply clarsimp
apply (rule, rule)
  apply (rotate_tac -1, erule lookupAP.elims) apply clarify apply clarify apply clarify
  prefer 2 apply clarify apply (erule_tac x="sumET (kLa, recET S, ia) (kRa, recET Ta, ja)" in allE, erule impE, assumption, clarify)
  prefer 2 apply clarify apply (erule_tac x="nodeET (n, recET Ta, ia)" in allE, erule impE, assumption, clarify)
  prefer 2 apply clarify apply (erule_tac x="recET Ta" in allE, erule impE, assumption, clarify)
  apply (erule_tac x="muET Ta" in allE) apply (rotate_tac -1, erule impE, assumption) 
      apply clarify
      apply (drule subst_unique, assumption)
      apply clarsimp
      apply (erule disjE)
        apply clarsimp
        apply clarsimp
apply (rule, rule) 
  apply (rotate_tac -1)
  apply (erule lookupAP.elims)
  apply clarify apply clarify apply clarify apply (erule_tac x="muET Ta" in allE, erule impE, assumption, clarify)
  prefer 2 apply clarify apply (erule_tac x="nodeET (n, recET Ta, ia)" in allE, erule impE, assumption, clarify)
  prefer 2 apply clarify apply (erule_tac x="recET Ta" in allE, erule impE, assumption, clarify)
  apply clarify apply (erule_tac x="sumET (kLa, recET Sa, ia) (kRa, recET Ta, ja)" in allE, erule impE, assumption, clarify)
  apply clarsimp apply (erule disjE) apply clarsimp apply clarsimp
apply (rule, rule) 
  apply (rotate_tac -1)
  apply (erule lookupAP.elims)
  apply clarify apply clarify apply clarify apply (erule_tac x="muET Ta" in allE, erule impE, assumption, clarify)
  apply clarify apply (erule_tac x="sumET (kL, recET S, ia) (kR, recET Ta, j)" in allE, erule impE, assumption, clarify)
  apply clarify apply (erule_tac x="nodeET (na, recET Ta, ia)" in allE, erule impE, assumption, clarsimp)
  apply clarify apply (erule_tac x="recET Ta" in allE, erule impE, assumption, clarsimp)
apply (rule, rule) 
  apply (rotate_tac -1)
  apply (erule lookupAP.elims)
  apply clarify apply clarify apply clarify apply (erule_tac x="muET Ta" in allE, erule impE, assumption, clarify)
  apply clarify apply (erule_tac x="sumET (kL, recET S, i) (kR, recET Ta, j)" in allE, erule impE, assumption, clarify)
  apply clarify apply (erule_tac x="nodeET (n, recET Ta, i)" in allE, erule impE, assumption, clarsimp)
  apply clarify apply (erule_tac x="recET Ta" in allE, erule impE, assumption, clarsimp)
done

lemma lookupAP_Update2[rule_format]:
"(C, p, E, h, Ta) \<in> lookupAP \<Longrightarrow> (\<forall> y. y \<noteq> root p \<longrightarrow> (C(y\<mapsto>\<^sub>fT), p, E, h, Ta) \<in> lookupAP)"
apply (erule lookupAP.induct)
apply (clarsimp, rule lookupAP_Var) apply (erule GETr_Update2, assumption) apply assumption+
apply (clarsimp, rule lookupAP_Node) apply (erule GETr_Update2, assumption) apply fastsimp apply assumption+
apply clarsimp
apply clarsimp
  apply (erule_tac x=y in allE, clarsimp) 
  apply (erule lookupAP_Mu, assumption+, simp) apply assumption+
apply clarsimp
  apply (erule_tac x=y in allE, clarsimp) 
  apply (erule lookupAP_Sum, assumption+, simp) apply assumption+
apply clarsimp
apply (erule_tac x=y in allE, clarsimp) 
  apply (erule lookupAP_RfldNode, assumption+, simp) 
apply clarsimp
  apply (erule_tac x=y in allE, clarsimp) 
  apply (erule lookupAP_RfldRec, assumption+) 
done

lemma lookupAP_Same[rule_format]:
 "(C, x, E, h, T) \<in> lookupAP \<Longrightarrow> 
 (\<forall> r L . evalAP x E h = Some (r, L) \<longrightarrow> (\<forall> h1 . sameOH L h h1 \<longrightarrow> (C, x, E, h1, T) \<in> lookupAP))"
apply (erule lookupAP.induct)
apply clarsimp
  apply (erule lookupAP_Var, assumption+) apply (simp add: sameOH_def)
apply clarsimp
  apply (erule lookupAP_Node, fastsimp) apply (assumption, simp add: sameOH_def, simp add: sameOH_def)
apply clarsimp
  apply (subgoal_tac "h<l\<bullet>DOLLAR> = h1<l\<bullet>DOLLAR> \<and> h@@l = h1@@l", clarsimp)
  prefer 2 apply (drule evalInclude) apply (simp add: sameOH_def)
  apply (erule_tac x=h1 in allE)
     apply (rotate_tac -1, erule impE)  
     apply (erule sameOHAntiMonotone) apply fast
  apply (erule lookupAP_Mu)
  apply assumption
  apply (erule evalAP_Same) apply (erule sameOHAntiMonotone) apply fast
  apply assumption
  apply clarsimp
  apply assumption+
apply clarsimp
  apply (subgoal_tac "h<l\<bullet>DOLLAR> = h1<l\<bullet>DOLLAR> \<and> h@@l = h1@@l", clarsimp)
  prefer 2 apply (drule evalInclude) apply (simp add: sameOH_def)
  apply (erule_tac x=h1 in allE)
     apply (rotate_tac -1, erule impE)  
     apply (erule sameOHAntiMonotone) apply fast
  apply (erule lookupAP_Sum)
  apply (erule evalAP_Same) apply (erule sameOHAntiMonotone) apply fast
  apply assumption
  apply clarsimp
  apply assumption+
apply clarsimp
  apply (subgoal_tac "h@@l = h1@@l", clarsimp)
  prefer 2 apply (drule evalInclude) apply (simp add: sameOH_def)
  apply (erule_tac x=h1 in allE)
     apply (rotate_tac -1, erule impE)  
     apply (erule sameOHAntiMonotone) apply fast
  apply (erule lookupAP_RfldNode)
  apply (erule evalAP_Same) apply (erule sameOHAntiMonotone) apply fast
  apply assumption+
apply clarsimp
  apply (subgoal_tac "h@@l = h1@@l", clarsimp)
  prefer 2 apply (drule evalInclude) apply (simp add: sameOH_def)
  apply (erule_tac x=h1 in allE)
     apply (rotate_tac -1, erule impE)  
     apply (erule sameOHAntiMonotone) apply fast
  apply (erule lookupAP_RfldRec)
  apply (erule evalAP_Same) apply (erule sameOHAntiMonotone) apply fast
  apply assumption+
done

lemma lookupAP_PreservedE[rule_format]:
"(C, x, E, h, T) \<in> lookupAP \<Longrightarrow> (\<forall> EE . E\<lfloor>(root x)\<rfloor> = EE\<lfloor>(root x)\<rfloor> \<longrightarrow> (C, x, EE, h, T) \<in> lookupAP)"
apply (erule lookupAP.induct)
apply clarsimp
  apply (erule lookupAP_Var) apply (subgoal_tac "renv EE x = Ref a", assumption, simp) apply assumption
apply clarsimp
  apply (erule lookupAP_Node, fastsimp) 
   apply (subgoal_tac "renv EE x = Ref a", assumption, simp) apply (assumption, simp)
apply clarsimp
  apply (erule_tac x=EE in allE, clarsimp)
  apply (erule lookupAP_Mu) apply assumption
  apply (erule evalAP_root, assumption)
  apply assumption
  apply clarsimp
  apply assumption+
apply clarsimp
  apply (erule_tac x=EE in allE, clarsimp)
  apply (erule lookupAP_Sum) 
  apply (erule evalAP_root, assumption)
  apply assumption
  apply clarsimp
  apply assumption+
apply clarsimp
  apply (erule_tac x=EE in allE, clarsimp)
  apply (erule lookupAP_RfldNode) 
  apply (erule evalAP_root, assumption)
  apply assumption+
apply clarsimp
  apply (erule_tac x=EE in allE, clarsimp)
  apply (erule lookupAP_RfldRec) 
  apply (erule evalAP_root, assumption)
  apply assumption+
done

lemma lookup_RfldAP_pq:
  "\<lbrakk>evalAP q E h = evalAP p E h; (C,p,E,h,T):lookupAP;(C,q,E,h,T):lookupAP; 
        (C,rfldAP p F,E,h,S):lookupAP\<rbrakk> \<Longrightarrow>(C,rfldAP q F,E,h,S):lookupAP"
apply (rotate_tac -1)
apply (erule lookupAP.elims, simp_all)
apply clarsimp
  apply (drule lookupAP_Unique, assumption, clarsimp)
  apply (erule lookupAP_Mu, assumption+)
  apply (clarsimp, assumption+)
apply clarsimp
  apply (drule lookupAP_Unique, assumption, clarsimp)
  apply (erule lookupAP_Sum, assumption+)
  apply (clarsimp, assumption+)
apply clarsimp
  apply (drule lookupAP_Unique, assumption, clarsimp)
  apply (erule lookupAP_RfldNode, assumption+)
apply clarsimp
  apply (drule lookupAP_Unique, assumption, clarsimp)
  apply (erule lookupAP_RfldRec, assumption+)
done

lemma lookupAP_Update3[rule_format]:
"(D, p, E, h, Ta) \<in> lookupAP \<Longrightarrow> (\<forall> y . (root p \<noteq> y) \<longrightarrow> (\<forall> C . D=C(y\<mapsto>\<^sub>fT) \<longrightarrow> (C, p, E, h, Ta) \<in> lookupAP))"
apply (erule lookupAP.induct)
apply (clarsimp, rule lookupAP_Var) apply (subgoal_tac "GETr (Ca(y\<mapsto>\<^sub>fT)) x = GETr Ca x", simp) apply (rule GETr_Update1, fast)
     apply assumption+
apply (clarsimp, rule lookupAP_Node) apply (subgoal_tac "GETr (Ca(y\<mapsto>\<^sub>fT)) x = GETr Ca x", simp) apply (rule GETr_Update1, fast)
  apply fast apply assumption+ apply simp
apply clarsimp
  apply (erule_tac x=y in allE, clarsimp) 
  apply (erule_tac x=Ca in allE, clarsimp)
  apply (erule lookupAP_Mu, assumption+, simp)
  apply assumption+
apply clarsimp
  apply (erule_tac x=y in allE, clarsimp)  
  apply (erule_tac x=Ca in allE, clarsimp)
  apply (erule lookupAP_Sum, assumption+, simp) 
  apply assumption+
apply clarsimp
  apply (erule_tac x=y in allE, clarsimp)  
  apply (erule_tac x=Ca in allE, clarsimp)
  apply (erule lookupAP_RfldNode, assumption+, simp) 
apply clarsimp
  apply (erule_tac x=y in allE, clarsimp)  
  apply (erule_tac x=Ca in allE, clarsimp)
  apply (erule lookupAP_RfldRec, assumption+) 
done

lemma lookupAP_Update[rule_format]:
"root p \<noteq> y \<Longrightarrow> ((C, p, E, h, T) \<in> lookupAP) =((C(y\<mapsto>\<^sub>fT), p, E, h, T) \<in> lookupAP)"
apply rule
 apply (erule lookupAP_Update2, fast)
 apply (erule lookupAP_Update3, assumption, simp)
done
       
subsection {*Predicate ContextSize*}
consts Yps::"(env \<times> heap \<times> (AP set) \<times> Context \<times> (locn set) \<times> (locn set) \<times> A) set"
inductive Yps intros
Yps_NIL: "\<lbrakk>U={}; S=0 \<rbrakk> \<Longrightarrow> (E,h,U,C,{},{},S) : Yps"
Yps_CONS: "\<lbrakk>p: U; (C,p,E,h,T):lookupAP; evalAP p E h = Some (Ref l,L1); (RVal (Ref l),h,T, RR1,N1): modelsET;
           (E,h,U-{p},C,L2,RR2,N2):Yps; L1 \<inter> RR2 = {}; L2 \<inter> RR1 = {};
           RR1 \<inter> RR2 = {}; L = L1 \<union> L2; R = RR1 \<union> RR2; N = N1+N2\<rbrakk>
        \<Longrightarrow> (E,h,U,C,L,R,N) : Yps"

lemma Yps_regionsExist[rule_format]:
"(E,h,U,C,L,R,S):Yps \<Longrightarrow> 
 (\<forall> x T . (x:U \<and> (C,x,E,h,T):lookupAP) \<longrightarrow> 
       (\<exists> l LL RR SS . evalAP x E h = Some(Ref l,LL) \<and> (RVal (Ref l),h,T,RR,SS) \<in> modelsET))"
apply (erule Yps.induct)
apply clarsimp 
apply clarsimp
apply (case_tac "x=p", clarsimp) 
apply (drule lookupAP_Unique, assumption, fastsimp) 
apply (erule_tac x=x in allE, erule_tac x=Ta in allE, clarsimp)
done

lemma Yps_contains_region[rule_format]:
"(E, h, U, G, L, R, S) \<in> Yps \<Longrightarrow> 
 (\<forall> x T l LL RR N . x:U \<and> (G,x,E,h,T):lookupAP \<longrightarrow> evalAP x E h = Some(Ref l,LL) \<longrightarrow> (RVal (Ref l),h,T, RR, N) \<in> modelsET \<longrightarrow> (N \<le> S \<and> RR \<subseteq> R \<and> LL \<subseteq> L))" 
apply (erule Yps.induct)
apply clarsimp
apply clarsimp
apply (case_tac "x=p", clarsimp)
apply (drule lookupAP_Unique, assumption, clarsimp)
apply (drule modelsET_Unique, assumption, fastsimp)
apply (erule_tac x=x in allE, erule_tac x=Ta in allE, erule impE, clarsimp)
apply (erule_tac x=la in allE, erule_tac x=LL in allE, clarsimp)
apply (erule_tac x=RR in allE, erule_tac x=Na in allE, clarsimp)
apply fast
done

lemma Yps_delete_nonUsed[rule_format]:
 "(E, h, U, G, L, R, S) \<in> Yps \<Longrightarrow> (\<forall> x . (\<forall> T . \<not> (G,x,E,h,T):lookupAP) \<longrightarrow> (E,h,U-{x},G,L,R,S):Yps)"
apply (erule Yps.induct)
apply clarsimp apply (rule Yps_NIL,simp+)
apply clarsimp apply (erule_tac x=x in allE,clarsimp)
apply (case_tac "x=p", clarsimp+)
apply (rule Yps_CONS)
  apply fast
  apply assumption+
  apply (subgoal_tac "U - {x} - {p} = U - {p} - {x}", clarsimp, assumption) apply fast
  apply assumption+
  apply simp+
done

lemma Yps_delete_Used[rule_format]:
 "(E, h, U, G, L, R, N) \<in> Yps \<Longrightarrow> 
  (\<forall> x T . (x:U \<and> (G,x,E,h,T):lookupAP) \<longrightarrow> (\<forall> l LL n RR. evalAP x E h = Some(Ref l,LL) \<longrightarrow> (RVal (Ref l), h, T, RR, n) \<in> modelsET \<longrightarrow> (\<exists> LLL . (E,h,U-{x},G,LLL,R-RR,N-n):Yps \<and> LLL \<union> LL = L \<and> LL \<inter> R-RR={} \<and> LLL \<inter> RR = {})))"
apply (erule Yps.induct)
apply clarsimp
apply clarsimp 
apply (case_tac "x=p")
apply clarsimp
  apply (drule lookupAP_Unique, assumption, clarsimp)
  apply (drule modelsET_Unique, assumption, clarsimp)
  apply (rule_tac x=L2 in exI, rule)
  apply (subgoal_tac "RR \<union> RR2 - RR = RR2", clarsimp) apply fast
  apply fast
apply (erule_tac x=x in allE,clarsimp)
  apply (erule_tac x=Ta in allE, clarsimp)
  apply (erule_tac x=n in allE,erule_tac x=RR in allE, erule impE, fastsimp, clarsimp) 
  apply (drule Yps_contains_region) apply rule apply (subgoal_tac "x : U - {p}", assumption, fast) 
     apply assumption+ 
  apply (subgoal_tac "U - {p} - {x} = U - {x} - {p}", clarsimp) 
  prefer 2 apply fast
  apply (rule_tac x="LLL\<union>L1" in exI, safe)
  apply (rule Yps_CONS) apply fastsimp apply assumption+ apply fast apply fast apply fast apply fast apply fast 
   apply clarsimp
  apply fast apply fast apply fast apply fast 
done

lemma Yps_split[rule_format]:
"(E, h, U, G, L, R, N) \<in> Yps \<Longrightarrow> 
 (\<forall> x  T. (x:U \<and> (G,x,E,h,T):lookupAP) \<longrightarrow> 
    (\<forall> l LL RR S . evalAP x E h = Some(Ref l,LL) \<longrightarrow> (RVal (Ref l), h, T, RR, S) \<in> modelsET \<longrightarrow>
      (\<exists> n RRR LLL. (E,h,U-{x},G,LLL,RRR,n):Yps \<and> R = RR \<union> RRR \<and> RR \<inter> RRR = {} \<and> N = S + n \<and>
                     LLL \<union> LL = L \<and> LL \<inter> RRR = {} \<and> LLL \<inter> RR={} )))" 
apply (erule Yps.induct)
apply clarsimp
apply clarsimp
apply (case_tac "x=p")
apply clarsimp
  apply (drule lookupAP_Unique, assumption, clarsimp)
  apply (drule modelsET_Unique, assumption, clarsimp)
  apply (rule_tac x=RR2 in exI, rule_tac x=L2 in exI, safe) 
apply (erule_tac x=x in allE, erule_tac x=Ta in allE, erule impE, fastsimp)
  apply (erule_tac x=la in allE, erule_tac x=LL in allE, clarsimp)
  apply (erule_tac x=RR in allE, erule_tac x=S in allE, clarsimp)
  apply (rule, rule, rule) 
  apply (rule Yps_CONS)
  apply (subgoal_tac "p: U -{x}", assumption,fast)
  apply assumption+
  apply (subgoal_tac "U - {x} - {p} = U - {p} - {x}", clarsimp, assumption) apply fast
  apply fast
  apply fast
  apply fast
  apply simp+
  apply (rule, fast)+
done

lemma TpTriv: "\<forall>k. varET k = T \<Longrightarrow> False"
apply (induct T, auto)
apply (subgoal_tac "0=nat") apply (subgoal_tac "1=nat", clarsimp) apply fast apply fast 
done

lemma Yps_Unique[rule_format]:
"(E,h,U,C,L,R,S):Yps \<Longrightarrow> (\<forall> LL RR n . (E,h,U,C,LL,RR,n):Yps \<longrightarrow> L=LL \<and> R = RR \<and> S = n)"
apply (erule Yps.induct)
(*1*)
apply clarsimp apply (erule Yps.elims, clarsimp,clarsimp)
(*2*)
apply (rule,rule, rule, rule)
apply (rotate_tac -1, drule Yps_split) apply rule apply assumption+
apply (erule exE)+
apply (erule conjE)+
apply (erule_tac x=LLL in allE, erule_tac x=RRR in allE, erule_tac x=na in allE, erule impE) apply assumption
apply clarsimp apply fast
done

lemma Yps_UnusedU_ContextExtension[rule_format]:
"(E, h, U, C, L, R, N) \<in> Yps \<Longrightarrow> 
 (\<forall> x . (\<forall> p . x = root p \<longrightarrow> p \<notin> U) \<longrightarrow> (E, h, U, C(x\<mapsto>\<^sub>fT), L, R,N) \<in> Yps)"
apply (erule Yps.induct)
(*1*) apply (clarsimp,rule Yps_NIL, simp,simp)
(*2*) apply clarsimp 
      apply (erule_tac x=x in allE, clarsimp)
      apply (rule Yps_CONS,assumption) 
      apply (erule lookupAP_Update2) apply fast
      apply assumption+
      apply simp+
done

lemma Yps_SPLIT[rule_format]: 
"(E, h, U, C, L, R, S) \<in> Yps \<Longrightarrow> (\<forall> U1 U2 . U1 \<union> U2 = U \<longrightarrow> U1 \<inter> U2 = {} \<longrightarrow>
 (\<exists> LL1 LL2 RR1 RR2 n1 n2 . (E, h, U1, C, LL1, RR1, n1) \<in> Yps \<and> (E, h, U2, C, LL2, RR2, n2) \<in> Yps \<and> 
                             L = LL1 \<union> LL2 \<and> R = RR1 \<union> RR2 \<and> RR1 \<inter> RR2 = {} \<and>
                             LL1 \<inter> RR2 = {} \<and> LL2 \<inter> RR1 = {} \<and> n1 + n2 = S))"
apply (erule Yps.induct, simp_all)
apply (rule,rule,rule,rule, rule Yps_NIL, simp, simp)
apply (rule,rule,rule Yps_NIL, simp,simp)
apply simp 
(*Case CONS*)
apply clarsimp apply (erule disjE)
(* p:U1*)
  apply (erule_tac x="U1-{p}" in allE, erule_tac x=U2 in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x="L1\<union>LL1" in exI, rule_tac x="LL2" in exI, 
         rule_tac x="RR1\<union>RR1a" in exI, rule_tac x="RR2a" in exI, rule_tac x="N1+n1" in exI, clarsimp)
  apply rule apply (erule Yps_CONS,assumption+) apply fast apply fast apply fast apply simp+ 
             apply fast 
(* p:U2*)
  apply (erule_tac x=U1 in allE, erule_tac x="U2-{p}" in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x="LL1" in exI, rule_tac x="L1\<union>LL2" in exI,
         rule_tac x="RR1a" in exI, rule_tac x="RR1\<union>RR2a" in exI, rule_tac x="n1" in exI, clarsimp)
  apply rule apply (erule Yps_CONS,assumption+) apply fast apply fast apply fast apply simp+ 
             apply fast 
done

lemma YpsPreserved[rule_format]:
"(E,h,U,C,L,R,S):Yps \<Longrightarrow> (\<forall> EE . (\<forall> x . x : U \<longrightarrow> E\<lfloor>(root x)\<rfloor> = EE\<lfloor>(root x)\<rfloor>) \<longrightarrow> (EE,h,U,C,L,R,S):Yps)"
apply (erule Yps.induct)
(*NIL*)
apply clarsimp
apply (rule Yps_NIL) apply (simp, simp)
(*CONS*)
apply clarsimp
apply (rule Yps_CONS, assumption)
  apply (erule lookupAP_PreservedE)
  apply fastsimp
  apply (erule evalAP_root, fast)
  apply assumption
  apply fastsimp
  apply simp+
done

lemma YpsPreservedU[rule_format]:
"(E,h,U,C,L,R,S):Yps \<Longrightarrow> ((\<forall> x . x : U \<longrightarrow> evalAP x E h = evalAP x EE h) \<longrightarrow> 
                              (\<forall> D . (\<forall> x . x : U \<longrightarrow> (\<forall> T . (C,x,E,h,T):lookupAP \<longrightarrow> (D,x,EE,h,T):lookupAP)) \<longrightarrow>
                                     (EE,h,U,D,L,R,S):Yps))"
apply (erule Yps.induct)
(*NIL*)
apply clarsimp
apply (rule Yps_NIL) apply (simp, simp)
(*CONS*)
apply clarsimp         
apply (rule Yps_CONS, assumption) apply fastsimp
apply assumption+
apply (erule_tac x=D in allE)
  apply (rotate_tac -1, erule impE, clarsimp)
  apply assumption
apply simp+
done

lemma Yps_DisjointEntries:
"\<lbrakk>(E, h, U, C, L, R, n) \<in> Yps; x \<in> U; y:U; x\<noteq>y; (C,x,E,h,T):lookupAP; (C,y,E,h,S):lookupAP;
         evalAP x E h = Some(Ref l,Rx); (RVal (Ref l),h,T,Sx,N):modelsET; 
        evalAP y E h = Some(Ref ll,Ry); (RVal (Ref ll),h,S,Sy,M):modelsET \<rbrakk> \<Longrightarrow> Sx \<inter> Sy = {}"
apply (drule Yps_split) apply fastsimp apply assumption+ apply clarsimp
apply (drule Yps_split) apply (rule, subgoal_tac "y:U-{x}", assumption, fast) apply assumption+ apply clarsimp
apply fastsimp
done

lemma lookupAppend:"\<lbrakk>rfldn F \<notin> fst ` set X\<rbrakk> \<Longrightarrow> lookup (X @ (rfldn F, T) # L) (rfldn F) = Some T"
by (induct X, auto)

lemma AP_inject: "x \<noteq> rfldAP x RR"
by (induct x, clarsimp+)

constdefs modif::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"modif R h hh == sameOH (Dom h - R) h hh"

lemma modif_Sameheap[simp]: "modif R h h"
(*<*) by (simp add: modif_def same_def sameOH_def)(*>*)

lemma modif_monotone:"\<lbrakk>modif Z h hh; Z \<subseteq> ZZ\<rbrakk> \<Longrightarrow> modif ZZ h hh"
by (simp add: modif_def, erule sameOHAntiMonotone,fast)

(*
lemma sameOH_Letv:
  "\<lbrakk>evalAP x E h = Some (r, L1); (RVal r, h, T, RR1, N) \<in> modelsET;
         (RR1 \<union> L1) \<inter> F = {};(RR1 \<union> L1) \<inter> RR1a = {};
          modif (F \<union> RR1a) h h1; oheap h = oheap h1\<rbrakk>
       \<Longrightarrow> sameOH (RR1 \<union> L1) h h1"
apply  (simp add: modif_def)
apply (erule sameOHAntiMonotone)
apply (drule evalAP_Dom) apply simp 
apply (drule modelsET_region_in_heap) apply simp
apply fast
done
lemma YpsPreserved_h_h1[rule_format]:
"(E, h, U2, C, LL2, RR2, n2) \<in> Yps \<Longrightarrow>
  (\<forall> LL1 RR1 F . (LL1 \<union> LL2 \<union> (RR1 \<union> RR2)) \<inter> F = {} \<longrightarrow>
                  RR1 \<inter> RR2 = {} \<longrightarrow> LL1 \<inter> RR2 = {} \<longrightarrow> LL2 \<inter> RR1 = {} \<longrightarrow>
                  modif (F \<union> RR1) h h1 \<longrightarrow>
                  oheap h = oheap h1 \<longrightarrow>
                  (E, h1, U2, C, LL2, RR2, n2) \<in> Yps)"
apply (erule Yps.induct)
apply clarsimp apply (rule Yps_NIL, simp, simp) 
apply clarsimp
apply (subgoal_tac "sameOH (RR1 \<union> L1) h h1")
  apply (erule Yps_CONS) 
  apply (erule lookupAP_Same, assumption)
    apply (erule sameOHAntiMonotone) apply fast
  apply (erule evalAP_Same) apply (erule sameOHAntiMonotone) apply fast
  apply (erule modelsET_Preserved)
    apply (erule sameOHAntiMonotone) apply fast 
  apply (erule_tac x=LL1 in allE)
  apply (erule_tac x=RR1a in allE)
  apply (erule_tac x=F in allE)
  apply clarsimp
  apply (erule impE) apply fast
  apply (erule impE) apply fast
  apply (erule impE) apply fast
  apply (erule impE) apply fast
  apply assumption+
  apply simp+
apply (rotate_tac 5, erule thin_rl)
apply (erule sameOH_Letv) apply assumption+ prefer 3 apply assumption apply fast apply fast apply simp 
done*)
lemma YpsPreserved_h_h1[rule_format]:
"(E, h, U, C, L, R, N) \<in> Yps \<Longrightarrow>
    (L \<union> R) \<inter> F = {} \<longrightarrow> modif F h h1 \<longrightarrow>
     oheap h = oheap h1 \<longrightarrow> (E, h1, U, C, L, R, N) \<in> Yps"
apply (erule Yps.induct)
apply clarsimp apply (rule Yps_NIL, simp, simp) 
apply clarsimp
apply (frule modelsET_region_in_heap) 
apply (frule evalAP_Dom)
apply (subgoal_tac "sameOH (RR1 \<union> L1) h h1")
prefer 2 apply (rotate_tac 5, erule thin_rl)
  apply (simp add: modif_def sameOH_def, clarsimp)
  apply rule
    apply (clarsimp, erule_tac x=la in allE, erule impE) apply fast apply assumption
    apply (clarsimp, erule_tac x=la in allE, erule impE) apply fast apply assumption
apply (erule Yps_CONS) 
  apply (erule lookupAP_Same, assumption)
    apply (erule sameOHAntiMonotone) apply fast
  apply (erule evalAP_Same) apply (erule sameOHAntiMonotone) apply fast
  apply (erule modelsET_Preserved)
    apply (erule sameOHAntiMonotone) apply fast 
  apply clarsimp
  apply (erule impE) apply fast
  apply assumption+
  apply simp+
done
(*
lemma YpsPreserved_h_h1[rule_format]:
"(E, h, U2, C, LL2, RR2, n2) \<in> Yps \<Longrightarrow>
  (\<forall> LL1 RR1 F . (LL1 \<union> LL2 \<union> (RR1 \<union> RR2)) \<inter> F = {} \<longrightarrow>
                  RR1 \<inter> RR2 = {} \<longrightarrow> LL1 \<inter> RR2 = {} \<longrightarrow> LL2 \<inter> RR1 = {} \<longrightarrow>
                  modif (F \<union> RR1) h h1 \<longrightarrow>
                  oheap h = oheap h1 \<longrightarrow>
                  (E, h1, U2, C, LL2, RR2, n2) \<in> Yps)"
apply clarsimp
apply (erule YpsPreserved_h_h1)
apply (subgoal_tac "(LL2 \<union> RR2) \<inter> (F \<union> RR1) = {}", assumption, fast)
apply assumption+
done
*)

constdefs freelist::"heap \<Rightarrow> locn set \<Rightarrow> nat \<Rightarrow> bool"
"freelist h F N == (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) : FL"

constdefs DAss::"(AP set) \<Rightarrow> nat \<Rightarrow> Context \<Rightarrow>  Tp \<Rightarrow> nat \<Rightarrow> vdmassn" ("\<lbrace> _ , _ , _ \<ggreater>  _ , _ \<rbrace>" 1000)
"DAss U n G T m E h hh v p \<equiv>
  (\<forall> q F R. 
    (\<exists> N P L. freelist h F N \<and> (E,h,U,G,L,R,P):Yps \<and> (L \<union> R) \<inter> F = {} \<and> n + P + q \<le> N) \<longrightarrow>
    (\<exists> Rv S M FF. (freelist hh FF M) \<and> 
                 (v,hh,T,Rv,S) : modelsET \<and>
                 (modif (F \<union> R) h hh) \<and>
                 Rv \<inter> FF = {} \<and>  
                 (Rv \<union> FF) \<subseteq> (R \<union> F) \<and>
                 (m + S + q \<le> M) \<and>
                 oheap h = oheap hh))"

lemma DAss_monotone_in_U:
"\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p; U \<subseteq> UU\<rbrakk> \<Longrightarrow> \<lbrace>UU, n, C \<ggreater> T, m\<rbrace> E h hh v p"
apply (simp add: DAss_def,clarsimp)
apply (frule Yps_SPLIT,subgoal_tac "U \<union> (UU-U) = UU", assumption,fast,fast, clarsimp)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=RR1 in allE)
apply (erule impE, safe) apply fastsimp
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modif_monotone, fast)
apply fast 
apply fast 
done

lemma DAss_Contexts_same_on_U:
"\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p; 
  \<forall> x. x:U \<longrightarrow> (\<forall> S. ((D,x,E,h,S):lookupAP) = ((C,x,E,h,S):lookupAP))\<rbrakk>
 \<Longrightarrow> \<lbrace>U, n, D \<ggreater> T, m\<rbrace> E h hh v p"
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI)
apply (rule_tac x=L in exI, safe)
apply (erule YpsPreservedU, simp, fast)
done

lemma DAss_SlackL:
 "\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p;  n \<le> nn\<rbrakk>  \<Longrightarrow> \<lbrace>U, nn, C \<ggreater> T, m\<rbrace> E h hh v p"
apply (simp add: DAss_def, clarsimp) 
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE)
apply (erule impE, safe)
apply fastsimp
done

lemma DAss_SlackR:
 "\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p;  mm \<le> m\<rbrakk>  \<Longrightarrow> \<lbrace>U, n, C \<ggreater> T, mm\<rbrace> E h hh v p"
apply (simp add: DAss_def, clarsimp) 
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE)
apply (erule impE, safe)
apply fastsimp
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, simp)
done

lemma DAss_Generalise:
 "\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p;  n \<le> nn; mm \<le> m; U \<subseteq> UU\<rbrakk>  \<Longrightarrow> \<lbrace>UU, nn, C \<ggreater> T, mm\<rbrace> E h hh v p"
apply (rule DAss_SlackR)
apply (rule DAss_SlackL)
apply (erule DAss_monotone_in_U)
apply assumption+
done

lemma DAss_Shift: "\<lbrakk>\<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v p; nn = n + k; mm = m + k\<rbrakk> \<Longrightarrow> \<lbrace>U, nn, G \<ggreater> T, mm\<rbrace> E h hh v p"
apply (simp add: DAss_def, clarsimp)
apply (erule_tac x="q+k" in allE, erule_tac x=F in allE, erule_tac x=R in allE)
  apply (erule impE,safe) apply fastsimp 
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
done

lemma DAssC_PConst0: "\<lbrace>U, n, G \<ggreater> T, m\<rbrace> = \<lbrace>U, n, G \<ggreater> T, m\<rbrace>"
by (simp add: DAss_def)

lemma DAssC_PConst: "\<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v p \<Longrightarrow> \<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v pp"
by (simp add: DAss_def)

lemma DAss_PreservedU[rule_format]:
"\<lbrace>U,n,C \<ggreater> T, m\<rbrace> E h hh v p \<Longrightarrow> ((renv EE = renv E) \<longrightarrow> \<lbrace>U,n,C \<ggreater> T, m\<rbrace> EE h hh v p)"
apply (simp add: DAss_def, clarsimp)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE)
apply (rule_tac x=N in exI, simp)
apply (rule_tac x=P in exI, rule_tac x=L in exI, simp)
apply (erule YpsPreservedU) apply (erule renvEvalAP) apply (erule lookupAP_PreservedE) apply simp 
apply assumption
done
  
subsection {*Proof rules -- part I*}
lemma SHIFT: "\<lbrakk>G \<rhd> e: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; nn = n + k; mm = m + k\<rbrakk> \<Longrightarrow> G \<rhd> e: \<lbrace>U, nn, C \<ggreater> T, mm\<rbrace>"
apply (erule vdm_conseq, clarsimp)
apply (erule DAss_Shift, simp, simp)
done

(*null rules not applicable, since our types do not model the bang operator
lemma DA_C_NullTree: "\<lbrakk>n=m+kL\<rbrakk> \<Longrightarrow> G \<rhd> Null: \<lbrace>{}, n, C \<ggreater> TreeET kL kN, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: DAssComplex_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=kL in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe)
apply (rule regTree) apply (rule mTREE_LEAF) apply simp
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done

lemma DA_C_NullList: "\<lbrakk>n=m+kN\<rbrakk> \<Longrightarrow> G \<rhd> Null: \<lbrace>{}, n, C \<ggreater> ListET kN kC, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: DAssComplex_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=kN in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe)
apply (rule regList) apply (rule mLIST_NIL) apply simp
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done

lemma DA_C_NullRes: "\<lbrakk>n=m+kN\<rbrakk> \<Longrightarrow> GG \<rhd> Null: \<lbrace>{}, n, G \<ggreater> ResultET kN TT kS, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: DAssComplex_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=kN in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe)
apply (rule regResultNONE, simp, simp)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done
lemma DA_C_Null: "\<lbrakk>T \<notin> {UnitET, IntET}; n = k+m; 
                   \<forall> kL kN. T = TreeET kL kN \<longrightarrow> k = kL;
                   \<forall> kN TT kS. T = ResultET kN TT kS \<longrightarrow> k=kN;
                   \<forall> kN kC. T = ListET kN kC \<longrightarrow> k=kN\<rbrakk> \<Longrightarrow> GG \<rhd> Null: \<lbrace>{}, n, G \<ggreater> T, m\<rbrace>"
apply (case_tac T, simp_all)
apply (rule DA_C_NullList, simp)
apply (rule DA_C_NullTree, simp)
apply (rule DA_C_NullRes, simp)
done
*)

lemma INT: "G \<rhd> expr.Int i: \<lbrace>{}, n, C \<ggreater> intET, n\<rbrace>"
apply (rule vdm_conseq, rule vdm_int)
apply (simp add: DAss_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule modelsETInt)
apply simp
done

lemma IVAR: "G \<rhd> IVar x: \<lbrace>{}, n, C \<ggreater> intET, n\<rbrace>"
apply (rule vdm_conseq, rule vdm_ivar)
apply (simp add: DAss_def, clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule modelsETInt)
apply simp
done

lemma RVAR: "\<lbrakk>GETr C x = Some T\<rbrakk> \<Longrightarrow> G \<rhd> RVar x: \<lbrace>{varAP x}, n, C \<ggreater> T, n\<rbrace>"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: DAss_def, safe)
apply (erule Yps.elims, simp_all, clarsimp)
apply (erule Yps.elims, simp_all, clarsimp)
apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (erule lookupAP.elims, simp_all, clarsimp)
apply fast
done

lemma PRIM: "G \<rhd> Primop f x y: \<lbrace>{}, n, C \<ggreater> intET, n\<rbrace>"
apply (rule vdm_conseq, rule vdm_prim, simp add: DAss_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule modelsETInt)
apply simp
done

lemma RPRIM:
"\<lbrakk>x: DOM C; y:DOM C\<rbrakk> \<Longrightarrow> G \<rhd> RPrimop f x y: \<lbrace>{varAP x,varAP y}, n, C \<ggreater> intET, n\<rbrace>"
apply (rule vdm_conseq, rule vdm_rprim, simp add: DAss_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule modelsETInt)
apply simp
done

lemma WEAK: "\<lbrakk>G \<rhd> e : \<lbrace> U , n , C \<ggreater> T , m\<rbrace>; U \<subseteq> UU\<rbrakk> \<Longrightarrow> G \<rhd> e : \<lbrace>UU, n, C \<ggreater> T, m\<rbrace>"
by (erule vdm_conseq, clarsimp, erule DAss_monotone_in_U,fast) 

lemma SLACKL: 
"\<lbrakk>G \<rhd> e:\<lbrace>U, n, C \<ggreater> T, m\<rbrace>; n \<le> nn\<rbrakk>
 \<Longrightarrow> G \<rhd> e: \<lbrace>U, nn, C \<ggreater> T, m\<rbrace>"
by (erule vdm_conseq, clarsimp, erule DAss_SlackL, assumption)

lemma SLACKR: 
"\<lbrakk>G \<rhd> e:\<lbrace>U, n, C \<ggreater> T, m\<rbrace>; mm \<le> m\<rbrakk>
 \<Longrightarrow> G \<rhd> e: \<lbrace>U, n, C \<ggreater> T, mm\<rbrace>"
by (erule vdm_conseq, clarsimp, erule DAss_SlackR, assumption)

lemma GENERALISE: 
"\<lbrakk>G \<rhd> e:\<lbrace>U, n, C \<ggreater> T, m\<rbrace>; n \<le> nn; mm \<le> m; U \<subseteq> UU\<rbrakk>
 \<Longrightarrow> G \<rhd> e: \<lbrace>UU, nn, C \<ggreater> T, mm\<rbrace>"
by (erule vdm_conseq, clarsimp, erule DAss_Generalise, assumption+)

subsection {*Micro-assertions and match-rules*}
constdefs roots::"AP set \<Rightarrow> rname set"
"roots P == { x . \<exists> p. p:P \<and> root p =x}"

consts mYps::"(env \<times> heap \<times> (AP set) \<times> (AP option) \<times> (AP list) \<times> (locn set) \<times> (locn set) \<times> 
              Context \<times> (locn set) \<times> (locn set) \<times> A) set"
inductive mYps intros
mYps_NONE: "\<lbrakk>(E,h,U,C,L,R,N):Yps\<rbrakk> \<Longrightarrow> (E,h,U,None,[],{},{},C,L,R,N) : mYps"
mYps_SOME: "\<lbrakk>(E,h,U,C,L,R,N):Yps; evalAP (nodeAP x) E h = Some(Ref l,{l}); l \<notin> L \<union> R; x \<notin> roots U; h@@l= Some DIAM;
             GETr C x = Some(nodeET(k, recET T,i)); h<l\<bullet>DOLLAR> = i; M=N+k
            \<rbrakk> \<Longrightarrow> (E,h,U,Some (nodeAP x),[],{l},{l},C,L,R,M):mYps"
mYps_FLD: "\<lbrakk>(rfldAP x F) \<notin> set Flds;
            (E,h,U,Some x, Flds,LL,RR,C,L,R,N):mYps; 
            evalAP (rfldAP x F) E h = Some(Ref l,LF); 
            (C,rfldAP x F,E,h,T):lookupAP;
            (RVal (Ref l),h,T, RR1,N1): modelsET;
            RR1 \<inter> (RR \<union> R \<union> L) = {};
            RRR = RR \<union> RR1;
            M=N+N1
            \<rbrakk> \<Longrightarrow> (E,h,U,Some x, (rfldAP x F) # Flds,LL,RRR,C,L,R,M):mYps"


lemma "(E,h,U,cell,flds,hl,rg,C,L,R,N):mYps \<Longrightarrow> rg \<inter> R ={}"
by (erule mYps.induct, simp_all, fastsimp)

lemma mYps_SPLIT[rule_format]: 
"(E, h, U, ND, APs, L1, Rg1, C, L, R, S) \<in> mYps \<Longrightarrow> (\<forall> U1 U2 . U1 \<union> U2 = U \<longrightarrow> U1 \<inter> U2 = {} \<longrightarrow>
 (\<exists> LL1 LL2 RR1 RR2 n1 n2 . (E, h, U1, ND, APs, L1, Rg1, C, LL1, RR1, n1) \<in> mYps \<and> 
                            (E, h, U2, None, [], {}, {}, C, LL2, RR2, n2) \<in> mYps \<and> 
                            L = LL1 \<union> LL2 \<and> R = RR1 \<union> RR2 \<and> (RR1 \<union> Rg1) \<inter> RR2 = {} \<and>
                            LL1 \<inter> RR2 = {} \<and> LL2 \<inter> RR1 = {} \<and>  n1 + n2 = S))"
apply (erule mYps.induct, simp_all)
apply clarsimp
  apply (drule Yps_SPLIT) apply simp apply assumption 
    apply clarsimp apply (rule_tac x=LL1 in exI, rule_tac x=LL2 in exI)
                   apply (rule_tac x=RR1 in exI, rule_tac x=RR2 in exI)
                   apply (rule_tac x=n1 in exI, rule)
                    apply (erule mYps_NONE)
                   apply (rule_tac x=n2 in exI, simp)
                    apply (erule mYps_NONE)
apply clarsimp 
  apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (drule Yps_SPLIT) apply simp apply assumption 
    apply (erule exE)+ apply (erule conjE)+
     apply (rule_tac x=LL1 in exI, rule_tac x=LL2 in exI)
     apply (rule_tac x=RR1 in exI, rule_tac x=RR2 in exI)
     apply (rule_tac x="n1+k" in exI, rule)
                    apply (erule mYps_SOME) apply simp apply fast apply (simp add: roots_def) apply fastsimp
                         apply assumption apply assumption apply simp apply simp
     apply (rule_tac x=n2 in exI, simp)
                    apply (erule mYps_NONE)
apply clarsimp
  apply (case_tac "evalAP x E h", clarsimp) apply clarsimp
  apply (case_tac "a", clarsimp) apply clarsimp
  apply (case_tac "locns h\<lfloor>nat\<diamondsuit>F\<rfloor> \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (erule_tac x=U1 in allE, erule_tac x=U2 in allE, clarsimp)
     apply (rule_tac x=LL1 in exI, rule_tac x=LL2 in exI)
     apply (rule_tac x=RR1a in exI, rule_tac x=RR2 in exI)
     apply (rule_tac x="n1+N1" in exI, rule)
        apply (erule mYps_FLD) apply simp 
          apply simp apply (subgoal_tac "l=l \<and> insert l b = insert l b", assumption, simp) 
          apply assumption apply assumption apply fast apply simp apply simp apply simp
     apply fast
done

consts get_rfldAPs::"(fldname \<times> Tp) list \<Rightarrow> rname \<Rightarrow> AP list"
primrec
"get_rfldAPs [] x = []"
"get_rfldAPs (h#t) x = (case (fst h) of
                        ifldn F \<Rightarrow> get_rfldAPs t x
                      | rfldn F \<Rightarrow> (rfldAP (nodeAP x) F) # (get_rfldAPs t x))"

consts ND2APset :: "AP option \<Rightarrow> AP set"
primrec
"ND2APset None = {}"
"ND2APset (Some p) = {p}"

lemma mYpsPreservedU[rule_format]:
"(E,h,U,ND,APs,L1,RR,C,L,R,N):mYps \<Longrightarrow> 
    ((\<forall> x . x : U \<union> (ND2APset ND) \<union> (set APs) \<longrightarrow> evalAP x E h = evalAP x EE h) \<longrightarrow> 
     (\<forall> D . (\<forall> x . x : U \<union> (set APs) \<longrightarrow> (\<forall> T . (C,x,E,h,T):lookupAP \<longrightarrow> (D,x,EE,h,T):lookupAP)) \<longrightarrow>
             (\<forall> x . ND = Some(nodeAP x) \<longrightarrow> (\<forall> T . (C,nodeAP x,E,h,T):lookupAP \<longrightarrow> 
                           (\<exists> k i REC1 REC2. T = nodeET(k,recET REC1,i) \<and> (D,nodeAP x,EE,h,nodeET(k,recET REC2,i)):lookupAP))) \<longrightarrow>
     (EE,h,U,ND,APs,L1,RR,D,L,R,N):mYps))"
apply (erule mYps.induct)
(*NONE*)
apply clarsimp
apply (rule mYps_NONE) apply (erule YpsPreservedU) apply fast apply fast 
(*SOME*)
apply rule
apply rule
apply rule
apply rule
apply (rotate_tac -1)
apply (erule_tac x=x in allE, clarsimp)
    apply (erule_tac x="nodeET (k, recET T,h<l\<bullet>DOLLAR>)" in allE, erule impE) apply (erule lookupAP_Node) apply fast
    apply (erule_tac x="nodeAP x" in allE, clarsimp) 
    apply (case_tac "locns (renv EE x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
    apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
    apply (subgoal_tac "renv EE x = Ref l", assumption, simp)
    apply clarsimp
    apply simp
apply clarsimp
  apply (rule mYps_SOME) 
  apply (erule YpsPreservedU) apply fast apply fast
  apply fastsimp
  apply fast
  apply assumption+
  apply (erule_tac x="nodeAP x" in allE, clarsimp)
  apply (case_tac "locns (renv EE x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (subgoal_tac "GETr D x = Some (nodeET(k, recET REC2, h<l\<bullet>DOLLAR>))", assumption)
  apply (erule lookupAP.elims, simp+) 
(*FLD*)
apply rule
apply rule
apply rule
apply rule
apply (rule mYps_FLD) 
  apply assumption
  apply (erule impE) apply fastsimp
  apply (erule_tac x=D in allE, erule impE)
    apply fastsimp
    apply clarsimp
    apply assumption
  apply (subgoal_tac "evalAP (rfldAP x F) EE h = Some (Ref l, LF)", assumption)
    apply (erule_tac x="rfldAP x F" in allE, clarsimp)
  apply (rotate_tac -2)
    apply (erule_tac x="rfldAP x F" in allE, clarsimp)
    apply (erule_tac x="T" in allE, clarsimp) apply assumption
  apply assumption
  apply assumption
  apply simp
  apply simp
done

lemma get_rfldAPs_isRFLD[rule_format]:
 "\<forall> p x . p \<in> set (get_rfldAPs FTs x) \<longrightarrow>
          (\<exists>F. p = rfldAP (nodeAP x) F \<and> (\<exists>T. (rfldn F, T) \<in> set FTs))"
apply (induct_tac FTs, auto)
apply (case_tac a, auto) apply fast
done

lemma mYps_Apregions:"(E,h,U,X, Flds,LL,RR,C,L,R,N):mYps \<Longrightarrow> LL \<subseteq> RR"
by (erule mYps.induct, auto)

lemma mYps_NodelocDom[rule_format]: 
"(E, h,U, ND, Flds, LL,RR,C, L, R, P) \<in> mYps \<Longrightarrow> (\<forall> x. ND= Some (nodeAP x) \<longrightarrow> E\<lfloor>x\<rfloor> = Ref a \<longrightarrow> a \<in> Dom h \<and> h@@a = Some DIAM)"
apply (erule mYps.induct, simp_all)
apply clarsimp
apply (case_tac "a:Dom h", auto)
done

(*lemma mYpsPreserved1[rule_format]:
"\<lbrakk> (RVal (Ref l), h, recET REC, reg2, M) \<in> modelsET; renv E x = Ref l; x \<notin> roots U;
          (E, h, U, C, L2, RR2, N2) \<in> Yps; 
          (E, h, U, Some (nodeAP x), get_rfldAPs REC x, {l}, reg2, C(x\<mapsto>\<^sub>fnodeET (kC, recET REC)), L2, RR2, kC + (M + N2)) \<in> mYps\<rbrakk>
       \<Longrightarrow> (E, h, U, Some (nodeAP x), get_rfldAPs REC x, {l}, reg2, C(x\<mapsto>\<^sub>fnodeET (kC, recET ((ifldn F, intET) # REC))), L2, RR2, kC + (M + N2)) \<in> mYps"
apply (erule mYpsPreservedU)
apply simp
prefer 2 apply clarsimp 
         apply (erule lookupAP.elims, simp_all, clarsimp)
         apply (simp add: GETr_def, clarsimp)
         apply (rule lookupAP_Node)
         apply (simp add: GETr_def)
         apply fastsimp
apply (frule modelsETLocn, simp)
apply (frule modelsET_region_in_heap)
apply (subgoal_tac "l:Dom h")
prefer 2 apply fast
apply (erule disjE)
  apply (rule lookupAP_Update2)
    apply (erule lookupAP_Update3)
      prefer 2 apply simp
      apply (simp add: roots_def)
    apply (simp add: roots_def, fast)
apply (frule get_rfldAPs_isRFLD, clarsimp)
  apply (rule lookupAP_RfldNode)
    apply (rule lookupAP_Node) apply (simp add: GETr_def) apply fast
    apply fastsimp
    apply simp apply fast 
    apply simp
    apply (erule lookupAP.elims, simp_all, clarsimp)+
    prefer 2 apply clarsimp   
             apply (erule lookupAP.elims, simp_all)
    apply (simp add: GETr_def)
done
*)

lemma mYps_GETr_DOLLAR:
"\<lbrakk>(E, h, U, Some (nodeAP l), APs, {a}, rg, C, L, R, P) \<in> mYps;
  E\<lfloor>l\<rfloor> = Ref a; GETr C l = Some (nodeET (k, recET T, i)); APs = get_rfldAPs T l\<rbrakk>
\<Longrightarrow> h<a\<bullet>DOLLAR>=i"
apply (erule mYps.elims, simp_all, clarsimp)
apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
apply (case_tac "locns (h\<lfloor>a\<diamondsuit>F\<rfloor>) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (drule lookupAP_Node_GETr, assumption+) apply clarsimp 
done


lemma get_rfldEmpty[rule_format]:
"get_rfldAPs T x = [] \<longrightarrow> (rfldn F, b) : set T \<longrightarrow> False"
apply (induct_tac T)
apply simp
apply clarsimp
apply (case_tac "a", clarsimp+) 
done

lemma get_rfldsEmpty_modelsET[rule_format]:
"\<forall> T. h@@l = Some DIAM \<longrightarrow> GETr C x = Some (nodeET (k, recET T, i)) \<longrightarrow>
       (\<forall>F TT. (ifldn F, TT) \<in> set T \<longrightarrow> TT = intET) \<longrightarrow>  get_rfldAPs TT x = [] \<longrightarrow> 
       (\<exists> X . T = X @ TT) \<longrightarrow> distinct (map fst T) \<longrightarrow>
        (RVal (Ref l), h, recET TT, {l}, 0) \<in> modelsET"
apply (induct_tac TT)
apply clarsimp apply (erule modelsETRecN, simp)
apply clarsimp
apply (case_tac "a")
  apply clarsimp
    apply (erule modelsET.elims, simp_all, clarsimp)
    apply (rule modelsETRecC)
      apply assumption apply fast apply simp 
      apply (subgoal_tac "b=intET", clarsimp) apply (rule modelsETInt, fast)
      apply (rule modelsETRecN) apply assumption apply simp
      apply (simp, simp, simp, simp)
  apply clarsimp
    apply (rule modelsETRecC)
      apply assumption apply fast apply simp 
      apply (subgoal_tac "b=intET", clarsimp) apply (rule modelsETInt, fast)
      defer 1 apply simp apply fast apply simp apply simp
      apply (rule modelsETRecC) apply assumption apply fastsimp apply simp
      apply (simp, simp, simp, simp)
  apply (simp, simp)
done

lemma Yps_empty[rule_format]: "(E, h, U, C, L, R, N) \<in> Yps \<Longrightarrow> U = {} \<longrightarrow> L={} \<and> R={} \<and> N=0"
by (erule Yps.induct, simp_all, clarsimp)

lemma mYps_NodelocReg[rule_format]: 
"(E, h,U, ND, Flds, LL,RR,C, L, R, P) \<in> mYps \<Longrightarrow> 
  (\<forall> p. ND= Some p \<longrightarrow> (\<exists> x a. p = nodeAP x \<and> E\<lfloor>x\<rfloor> = Ref a \<and> LL={a} \<and> a:RR))"
apply (erule mYps.induct, simp_all)
apply auto 
apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp+) 
done

lemma mYps_NodelocSize[rule_format]:
"(E, h,U, ND, Flds, LL,RR,C, L, R, P) \<in> mYps \<Longrightarrow> 
 (\<forall> l. ND = Some(nodeAP l) \<longrightarrow> (\<forall> k T i . GETr C l = Some (nodeET (k, recET T, i)) \<longrightarrow> k \<le> P))"
by (erule mYps.induct, simp_all, clarsimp)

lemma modelsET_OH[rule_format]:
"(RVal (Ref l), h, T, R,N) : modelsET \<Longrightarrow> h@@l = Some DIAM"
by (erule modelsET.elims, simp+) 

lemma fst_set_list[rule_format]: "x \<notin> fst ` set L \<longrightarrow> (x, T) \<in> set L \<longrightarrow> False"
by (induct_tac L, auto)

lemma modelsET_REC_modelsET_REC1[rule_format]:
"\<forall> REC R N v h E x. (v,h,recET REC,R,N) : modelsET \<longrightarrow>
         v = RVal(E\<lfloor>x\<rfloor>) \<longrightarrow> get_rfldAPs REC x = get_rfldAPs REC1 x \<longrightarrow>
         (\<forall> F TT . (F,TT) : set REC \<longrightarrow> (\<exists> FF . F = rfldn FF)) \<longrightarrow>
         distinct (map fst REC1) \<longrightarrow>
         (\<forall> F TT.  (F,TT) : set REC1 \<longrightarrow> ((\<forall> FF . F=ifldn FF \<longrightarrow> TT = intET) \<and> (\<forall> FF . F = rfldn FF \<longrightarrow> Some TT = lookup REC F))) \<longrightarrow>
       (v,h,recET REC1,R,N) : modelsET"
apply (induct_tac REC1)
apply clarsimp 
  apply (erule modelsET.elims, simp_all) 
  apply clarsimp apply (erule modelsETRecN, simp)
  apply clarsimp apply (erule_tac x="F" in allE, clarsimp) apply (erule impE, fast) apply clarsimp 
apply clarsimp 
  apply (frule modelsET_isLocn, clarsimp)
  apply (frule modelsET_OH)
  apply (case_tac a)
  apply clarsimp apply (rule modelsETRecC) 
                   apply assumption
                   apply fastsimp
                   apply simp
                   apply simp apply (erule_tac x="ifldn ifldname" in allE, erule_tac x=b in allE, clarsimp)
                     apply (rule modelsETInt)
                   apply (erule_tac x=REC in allE, erule_tac x=R in allE, erule_tac x=N in allE)
                     apply (erule_tac x="RVal (Ref l)" in allE, erule_tac x=h in allE, clarsimp)
                     apply (erule_tac x="E" in allE, erule_tac x=x in allE, clarsimp) apply assumption
                   apply fast
                   apply fast
                   apply simp
                   apply simp
  apply clarsimp apply (subgoal_tac "Some b = lookup REC (rfldn rfldname)", clarsimp) 
                 prefer 2 apply (erule_tac x="rfldn rfldname" in allE, erule_tac x=b in allE, clarsimp)
                 apply (case_tac REC, clarsimp)
                 apply clarsimp
                 apply (subgoal_tac "\<exists>FF. a = rfldn FF", clarsimp) 
                 prefer 2 apply (erule_tac x=a in allE, fastsimp) 
                 apply (erule modelsET.elims, simp_all, clarsimp) 
                 apply (rule modelsETRecC)
                   apply assumption
                   apply fast
                   apply simp
                   apply simp
                   apply (erule_tac x=FTs in allE, erule_tac x=reg2 in allE, erule_tac x=M in allE)
                     apply (erule_tac x="RVal (Ref la)" in allE, erule_tac x=ha in allE, clarsimp)
                     apply (erule_tac x=E in allE, erule_tac x=x in allE, clarsimp) 
                     apply (erule impE) apply fast 
                     apply (erule impE, clarsimp) apply (rotate_tac 1)
                       apply (erule_tac x="rfldn rfldname" in allE, erule_tac x=TT in allE, erule impE, assumption)
                       apply (erule conjE) apply (erule_tac x="rfldname" in allE, clarsimp)
                       apply (drule fst_set_list, assumption) apply simp 
                     apply assumption
                     apply assumption
                     apply assumption
                     apply simp
                     apply simp
done

lemma get_rfld_notin[rule_format]:
"\<forall> F x . rfldn F \<notin> fst ` set FTs \<longrightarrow> rfldAP (nodeAP x) F \<notin> set (get_rfldAPs FTs x)"
apply (induct_tac FTs)
apply clarsimp
apply clarsimp
apply (case_tac a)
apply clarsimp
apply clarsimp
done

lemma modelsET_Unfold[rule_format]:
"\<forall> RR1 N1 .(v,h,recET REC, RR1,N1): modelsET \<longrightarrow> (\<exists> X . T = X @ REC) \<longrightarrow>
       (\<forall> rfldAPs N .  
          v=RVal (E\<lfloor>x\<rfloor>) \<longrightarrow>  E\<lfloor>x\<rfloor> = Ref l \<longrightarrow> h<l\<bullet>DOLLAR> = i \<longrightarrow>
        x \<notin> roots U \<longrightarrow> rfldAPs = get_rfldAPs REC x \<longrightarrow> List.distinct (List.map fst T) \<longrightarrow>
        (E,h,U,C,L2,RR2,N2):Yps \<longrightarrow> {l} \<inter> RR2 = {} \<longrightarrow> L2 \<inter> RR1 = {} \<longrightarrow>
            RR1 \<inter> RR2 = {} \<longrightarrow> N = kC+N1+N2 \<longrightarrow>
       (E,h,U,Some (nodeAP x), rfldAPs, {l}, RR1,
                       C(x\<mapsto>\<^sub>f nodeET(kC, recET T,i)),L2,RR2,N) : mYps)"
apply (induct_tac REC)
apply clarsimp
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (rule mYps_SOME)
    apply (erule Yps_UnusedU_ContextExtension) apply (simp add: roots_def) apply fast
    apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
    apply fast
    apply assumption
    apply assumption
    apply (simp add: GETr_def) apply fast
    apply simp
    apply simp
apply clarsimp
apply (case_tac a)
apply clarsimp
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims,simp_all)
apply clarsimp
  apply (frule modelsETLocn, simp)
  apply (frule modelsET_region_in_heap)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (frule modelsET_isLocn, clarsimp)
  apply (frule modelsETLocn, simp)
  apply (frule modelsET_region_in_heap)
  apply (subgoal_tac "l:Dom h") prefer 2 apply fast
  apply (subgoal_tac "la:Dom h") prefer 2 apply fast
  apply (erule_tac x=reg2 in allE, erule_tac x=M in allE, clarsimp)
  apply (erule impE, fast)
  apply (erule impE, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, simp) 
      apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply fast
  apply (rule mYps_FLD) 
   prefer 2 apply assumption
   apply (erule get_rfld_notin)
   apply simp apply (rule, simp, simp)
   apply (rule lookupAP_RfldNode)
              apply (rule lookupAP_Node) apply (simp add: GETr_def,fastsimp) apply fastsimp apply assumption+ apply simp
              apply simp apply(rule, fast, simp)
              apply assumption
              apply (erule lookupAppend)
        apply assumption
   apply (erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl) 
    apply (rotate_tac 2)
    apply (erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl)
    apply (erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl) apply fast
   apply (erule thin_rl)+ apply fast
   apply simp
done

lemma muUNFOLD[rule_format]:
"\<lbrakk>GETr C x = Some(recET REC); distinct (map fst REC);
  evalAP (varAP x) E h = Some(Ref l,X);h<l\<bullet>DOLLAR> = i;
     (E,h,U \<union> {varAP x},C,L,R,N):Yps; x \<notin> roots U;
     rfldAPs = get_rfldAPs REC x\<rbrakk>
 \<Longrightarrow> \<exists> LL RR RRR. (E,h,U,Some (nodeAP x), rfldAPs, {l}, RRR,
                       C(x\<mapsto>\<^sub>f nodeET(kC, recET REC,i)),LL,RR,kC+N) : mYps
                   \<and> R = RRR \<union> RR \<and> RRR \<inter> RR = {} \<and> L={l} \<union> LL"
apply clarsimp
apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (drule Yps_SPLIT) apply (subgoal_tac "{varAP x} \<union> U = insert (varAP x) U", assumption, simp)
  apply (simp add: roots_def)
  apply (case_tac "varAP x : U", erule_tac x= "varAP x" in allE, clarsimp, assumption)
apply clarsimp
apply (erule Yps.elims, simp_all, clarsimp) 
apply (rotate_tac -6)
apply (erule Yps.elims, simp_all, clarsimp) 
apply (frule modelsET_isLocn, clarsimp)
  apply (frule modelsETLocn, simp)
  apply (frule modelsET_region_in_heap)
apply (erule lookupAP.elims, simp_all, clarsimp)
apply (rule_tac x="LL2" in exI) apply (rule_tac x="RR2" in exI) apply (rule_tac x="RR1a" in exI, simp)
apply (erule modelsET_Unfold)
apply simp+
done

constdefs muDAss::"(AP set) \<Rightarrow> (AP option) \<Rightarrow> (AP list) \<Rightarrow>
            nat \<Rightarrow> Context \<Rightarrow>  Tp \<Rightarrow> nat \<Rightarrow> vdmassn" ("\<parallel> _, _, _ , _ , _ \<ggreater>  _ , _ \<parallel>" 1000)
"muDAss U c flds n G T m E h hh v p \<equiv>
  (\<forall> q F R rg. 
    (\<exists> N P L cl. freelist h F N \<and> (E,h,U,c,flds,cl,rg,G,L,R,P):mYps \<and> (L \<union> R \<union> cl \<union> rg) \<inter> F = {} \<and> n + P + q \<le> N) \<longrightarrow>
    (\<exists> Rv S M FF. (freelist hh FF M) \<and> 
                 (v,hh,T,Rv,S) : modelsET \<and>
                 (modif (F \<union> R \<union> rg) h hh) \<and>
                 Rv \<inter> FF = {} \<and>  
                 (Rv \<union> FF) \<subseteq> (rg \<union> R \<union> F) \<and>
                 (m + S + q \<le> M) \<and>
                 oheap h = oheap hh))"

lemma DAss_MuDass:
"\<parallel> U, None, [] , C , n \<ggreater>  T , m \<parallel> = \<lbrace> U , C , n \<ggreater>  T , m\<rbrace>"
apply (rule, rule, rule, rule, rule)
apply (simp add: DAss_def muDAss_def, rule)
apply clarsimp
  apply (erule_tac x=q in allE)
  apply (erule_tac x=F in allE)
  apply (erule_tac x=R in allE)
  apply (erule_tac x="{}" in allE, simp)
  apply (erule impE) prefer 2 apply assumption
  apply (rule_tac x=N in exI, simp)
  apply (rule_tac x=P in exI)
  apply (rule_tac x=L in exI)
  apply (rule_tac x="{}" in exI, simp)
  apply (erule mYps_NONE)
apply clarsimp
  apply (subgoal_tac "cl={} \<and> rg={}", clarsimp)
  prefer 2 apply (erule mYps.elims, simp_all)
  apply (erule_tac x=q in allE)
  apply (erule_tac x=F in allE)
  apply (erule_tac x=R in allE)
  apply (erule impE) prefer 2 apply assumption
  apply (rule_tac x=N in exI, simp)
  apply (rule_tac x=P in exI)
  apply (rule_tac x=L in exI, simp)
  apply (erule mYps.elims, simp_all)
done

lemma muDass_monotone_in_U:
"\<lbrakk>\<parallel>U, ND, APs, n, C \<ggreater> T, m\<parallel> E h hh v p; U \<subseteq> V\<rbrakk> \<Longrightarrow> \<parallel>V, ND, APs, n, C \<ggreater> T, m\<parallel> E h hh v p"
apply (simp add: muDAss_def,clarsimp)
apply (frule mYps_SPLIT)
apply (subgoal_tac "U \<union> (V-U) = V", assumption,fast,fast, clarsimp)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=RR1 in allE, erule_tac x=rg in allE)
apply (erule impE, safe) apply fastsimp
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modif_monotone, fast)
apply fast 
apply fast 
done

lemma LETGETFI:
"\<lbrakk>G \<rhd> e : \<parallel>U, Some (nodeAP l),V, n, C \<ggreater> T, m\<parallel>;
  GETr C l = Some(nodeET(k, recET TT,i));
  lookup TT (ifldn F) = Some intET\<rbrakk>
\<Longrightarrow>  G \<rhd> (LET x = l\<bullet>F IN e END) : \<parallel>U, Some (nodeAP l), V,n, C \<ggreater> T, m\<parallel>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi) 
apply assumption
apply clarsimp 
apply (simp add: muDAss_def, clarsimp)
apply (erule_tac x=q in allE)
apply (erule_tac x=Fa in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=rg in allE, erule impE)
prefer 2 apply assumption
apply (rule_tac x=N in exI, simp)
apply (rule_tac x=P in exI)
apply (rule_tac x=L in exI)
apply (rule_tac x=cl in exI, simp)
apply (erule mYpsPreservedU)
  apply (rule renvEvalAP, rule,simp)
  apply (erule lookupAP_PreservedE, simp)
  apply clarsimp apply (erule lookupAP.elims, simp_all)
  apply clarsimp apply (rule_tac x=TT in exI) apply (erule lookupAP_Node) apply fastsimp
  apply simp+
done

lemma mYps_CONS[rule_format]:
"(Ea, ha, V, ND, APs, LL, RR, C, La, Ra, Na) \<in> mYps \<Longrightarrow>
 (\<forall> t U la T RR1 N1. varAP t \<notin> V \<longrightarrow> U = insert (varAP t) V \<longrightarrow> (\<forall>p. p \<in> U \<longrightarrow> (\<exists>x. p = varAP x)) \<longrightarrow>
             renv Ea t = Ref la \<longrightarrow>
             GETr C t = Some T \<longrightarrow>
             (RVal (Ref la), ha, T, RR1, N1) \<in> modelsET \<longrightarrow> RR1 \<inter> (RR \<union> Ra \<union> La) = {} \<longrightarrow>
         (Ea, ha, U, ND, APs, LL, RR, C, insert la La, Ra \<union> RR1, Na + N1) \<in> mYps)"
apply (erule mYps.induct, simp_all)
apply clarsimp
  apply (frule modelsETLocn, simp)
  apply (frule modelsET_OH)
  apply (frule modelsET_region_in_heap)
  apply (subgoal_tac "la : Dom h")
  prefer 2 apply fast
  apply (rule mYps_NONE)
    apply (rule Yps_CONS, fast)
    apply (erule lookupAP_Var) apply assumption+
    apply simp apply (rule, fast,fast)
    apply assumption
    apply clarsimp apply assumption
    apply fast
    apply fast
    apply fast
    apply simp
    apply fast
    apply simp
apply clarsimp
  apply (frule modelsETLocn, simp)
  apply (frule modelsET_OH)
  apply (frule modelsET_region_in_heap)
  apply (subgoal_tac "la : Dom h")
  prefer 2 apply fast
  apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (rule mYps_SOME)
    apply (rule Yps_CONS, fast)
      apply (erule lookupAP_Var) apply assumption+
      apply simp apply (rule, fast,fast)
      apply assumption
      apply clarsimp apply assumption
      apply fast
      apply fast
      apply fast
      apply simp
      apply fast
      apply simp
    apply simp
    apply fast
    apply (simp add: roots_def, clarsimp) apply (erule disjE) apply clarsimp apply fastsimp
    apply assumption
    apply assumption
    apply simp
    apply simp
apply clarsimp
  apply (case_tac "evalAP x E h", clarsimp+)
  apply (case_tac a, clarsimp+)
  apply (case_tac "locns h\<lfloor>nat\<diamondsuit>F\<rfloor> \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (rotate_tac 5)
  apply (frule modelsETLocn, simp)
  apply (frule modelsET_OH)
  apply (frule modelsET_region_in_heap)
  apply (subgoal_tac "la : Dom h")
  prefer 2 apply fast
  apply (rule mYps_FLD)
    apply assumption
    apply (erule_tac x=t in allE, clarsimp)
      apply (erule_tac x=RR1a in allE, erule_tac x=N1a in allE, clarsimp)
      apply (erule impE) apply fast
      apply assumption
      apply simp apply (rule, simp, simp)
      apply assumption
      apply assumption
      apply (rotate_tac 12) apply (erule thin_rl, fast)
      apply simp
      apply simp
done

lemma LETGETFR_noWaste:
"\<lbrakk>G \<rhd> e : \<parallel>U, Some (nodeAP l),APs, n, C(t\<mapsto>\<^sub>fS) \<ggreater> T, m\<parallel>; l \<notin> roots U; varAP t:U;
  \<forall> p. p:U \<longrightarrow> (\<exists> x . p=varAP x);
  \<forall> p. p: set APs \<longrightarrow> root p = l;
  GETr C l = Some(nodeET(k, recET TT,i));
  lookup TT (rfldn FLD) = Some S\<rbrakk>
\<Longrightarrow>  G \<rhd> (LET rf t = l\<diamondsuit>FLD IN e END) : \<parallel>U-{varAP t}, Some (nodeAP l), (rfldAP (nodeAP l) FLD) # APs,n, C \<ggreater> T, m\<parallel>"
apply (rule vdm_conseq) 
apply (rule vdm_letr, rule vdm_getfr) 
apply assumption
apply (erule thin_rl)
apply clarsimp 
apply (subgoal_tac "l \<noteq> t")
prefer 2 apply (simp add: roots_def) apply (erule_tac x= "varAP t" in allE, fastsimp)
apply (simp add: muDAss_def, clarsimp)
apply (frule mYps_NodelocDom, simp, simp, clarsimp)
apply (erule mYps.elims, simp_all, clarsimp)
apply (case_tac "locns ha\<lfloor>a\<diamondsuit>FLD\<rfloor> \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
apply (drule mYpsPreservedU)
  apply (subgoal_tac "evalAP x Ea ha = evalAP x (Ea\<lfloor>t:=Ref la\<rfloor>) ha", assumption)
    apply (rule evalAP_root, simp) apply (subgoal_tac "root x \<noteq> t", simp)
      apply simp apply (erule disjE)
        apply simp apply (erule disjE)
        apply (erule_tac x=x in allE, clarsimp) 
        apply (rotate_tac 2, erule_tac x=x in allE, clarsimp)
  apply (subgoal_tac "t \<noteq> root x")
    apply (rule lookupAP_Update2) 
      apply (erule lookupAP_PreservedE) 
      apply simp
      apply assumption
    apply simp apply (erule disjE)
      apply (erule_tac x=x in allE, clarsimp) 
        apply (rotate_tac 3, erule_tac x=x in allE, clarsimp)
  apply clarsimp apply (rotate_tac -1, erule lookupAP.elims, simp_all, clarsimp)
    apply (rule_tac x=TT in exI)
    apply (subgoal_tac "(C(t\<mapsto>\<^sub>fS), nodeAP l, E\<lfloor>t:=Ref la\<rfloor>, h,
           nodeET (k, recET TT,h<a\<bullet>DOLLAR>)) \<in> lookupAP", assumption)
    apply (rule lookupAP_Node) apply (erule GETr_Update2,fast) apply fastsimp
    apply simp
    apply assumption
    apply simp
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x="Ra\<union>RR1" in allE, erule_tac x=RR in allE, erule impE)
  apply (rule_tac x=N in exI, simp)
  apply (rule_tac x="Na+N1" in exI, rule_tac x="insert la La" in exI, rule_tac x=LL in exI, simp)
prefer 2 apply clarsimp
  apply (rule_tac x=Rv in exI, 
         rule_tac x=Sa in exI, 
         rule_tac x=M in exI, 
         rule_tac x=FF in exI, simp)
  apply (rule,erule modif_monotone, fast) apply fast
apply rule prefer 2
apply rule apply (drule modelsETLocn, simp) apply fast
  apply fast
apply (erule mYps_CONS) apply (subgoal_tac "varAP t \<notin> U - {varAP t}", assumption, fast)
  apply fast
  apply fast
  apply simp
  apply (simp add: GETr_def)
  apply (drule lookupAP_Node_GETr, assumption+, clarsimp)
apply clarsimp 
done

lemma LETGETFR_Waste:
"\<lbrakk>G \<rhd> e : \<parallel>U, Some (nodeAP l),APs, n, C(t\<mapsto>\<^sub>fS) \<ggreater> T, m\<parallel>; l \<notin> roots U; varAP t \<notin> U;
  \<forall> p. p:U \<longrightarrow> (\<exists> x . p=varAP x); l \<noteq> t;
  \<forall> p. p: set APs \<longrightarrow> root p = l;
  GETr C l = Some(nodeET(k, recET TT,i));
  lookup TT (rfldn FLD) = Some S\<rbrakk>
\<Longrightarrow>  G \<rhd> (LET rf t = l\<diamondsuit>FLD IN e END) : \<parallel>U-{varAP t}, Some (nodeAP l), APs,n, C \<ggreater> T, m\<parallel>"
apply (rule vdm_conseq) 
apply (rule vdm_letr, rule vdm_getfr) 
apply assumption
apply (erule thin_rl)
apply clarsimp 
apply (simp add: muDAss_def, clarsimp)
apply (frule mYps_NodelocDom, simp, simp)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x="R" in allE, erule_tac x=rg in allE, erule impE)
prefer 2 apply assumption
apply (rule_tac x=N in exI, simp)
  apply (rule_tac x="P" in exI, rule_tac x="L" in exI, rule_tac x=cl in exI, simp)
apply (erule mYpsPreservedU)
  apply simp apply (erule disjE)
   apply simp apply (erule disjE)
   apply (rule evalAP_root) apply simp apply (erule_tac x=x in allE, clarsimp) apply (subgoal_tac "t \<noteq> xa", simp) apply fast
   apply (rule evalAP_root) apply simp apply (rotate_tac 3, erule_tac x=x in allE, clarsimp) 
   apply (rule lookupAP_Update2)
    apply (erule lookupAP_PreservedE) apply simp 
       apply (erule disjE) apply (erule_tac x=x in allE, clarsimp) apply (subgoal_tac "t \<noteq> xa", simp) apply fast
       apply (rotate_tac 3, erule_tac x=x in allE, clarsimp)
    apply (simp,erule disjE) apply (erule_tac x=x in allE, clarsimp) 
       apply (rotate_tac 3, erule_tac x=x in allE, clarsimp) 
   apply clarsimp
    apply (erule lookupAP.elims, simp_all, clarsimp)
    apply (rule_tac x=TT in exI)
    apply (rule lookupAP_Node) apply (erule GETr_Update2, fast) apply fastsimp apply simp+
done

lemma muWEAK:"\<lbrakk>G \<rhd> e : \<parallel> U, Some(nodeAP x),APs, n, C \<ggreater> T, m \<parallel>; U \<subseteq> V\<rbrakk> \<Longrightarrow>
              G \<rhd> e : \<parallel> V, Some(nodeAP x), APs, n, C \<ggreater> T, m \<parallel>"
apply (erule vdm_conseq, clarsimp)
apply (erule muDass_monotone_in_U, simp)
done

lemma muWEAK_AP:"G \<rhd> e : \<parallel> U, Some(nodeAP x),APs, n, C \<ggreater> T, m \<parallel> \<Longrightarrow>
              G \<rhd> e : \<parallel> U, Some(nodeAP x),(rfldAP (nodeAP x) FLD) # APs, n, C \<ggreater> T, m \<parallel>"
apply (erule vdm_conseq)
apply (simp add: muDAss_def, clarsimp)
apply (erule mYps.elims, simp_all, clarsimp)
apply (case_tac "locns (renv Ea x) \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
apply (case_tac "Ea\<lfloor>x\<rfloor>", clarsimp) apply clarsimp
apply (case_tac "locns ha\<lfloor>nat\<diamondsuit>FLD\<rfloor> \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
apply (erule_tac x=q in allE, erule_tac x=F in allE)
apply (erule_tac x=Ra in allE, erule_tac x=RR in allE, erule impE)
prefer 2
  apply clarsimp
  apply (rule_tac x=Rv in exI, 
         rule_tac x=S in exI, 
         rule_tac x=M in exI, 
         rule_tac x=FF in exI, simp)
  apply (rule,erule modif_monotone, fast) apply fast
apply (rule_tac x= N in exI, simp)
apply (rule_tac x=Na in exI, rule_tac x=La in exI, rule_tac x=LL in exI, simp)
apply fast
done

lemma LETGETFR_Waste_WeakAP:
"\<lbrakk>G \<rhd> e : \<parallel>U, Some (nodeAP l),APs, n, C(t\<mapsto>\<^sub>fS) \<ggreater> T, m\<parallel>; l \<notin> roots U; varAP t \<notin> U;
  \<forall> p. p:U \<longrightarrow> (\<exists> x . p=varAP x); l \<noteq> t;
  \<forall> p. p: set APs \<longrightarrow> root p = l;
  GETr C l = Some(nodeET(k, recET TT,i));
  lookup TT (rfldn FLD) = Some S\<rbrakk>
\<Longrightarrow>  G \<rhd> (LET rf t = l\<diamondsuit>FLD IN e END) : \<parallel>U, Some (nodeAP l), (rfldAP (nodeAP l) FLD) # APs,n, C \<ggreater> T, m\<parallel>"
apply (rule muWEAK_AP)
apply (drule LETGETFR_Waste)
apply assumption+
apply clarsimp
done

lemma LETGETFR:
"\<lbrakk>AP = (rfldAP (nodeAP l) FLD) # APs; l \<noteq> t; \<forall> p. p: set APs \<longrightarrow> root p = l;
  GETr C l = Some(nodeET(k, recET TT,i));
  lookup TT (rfldn FLD) = Some S;
  G \<rhd> e : \<parallel>U, Some (nodeAP l),APs, n, C(t\<mapsto>\<^sub>fS) \<ggreater> T, m\<parallel>; l \<notin> roots U; 
  \<forall> p. p:U \<longrightarrow> (\<exists> x . p=varAP x); 
  V = U-{varAP t} \<rbrakk>
\<Longrightarrow>  G \<rhd> (LET rf t = l\<diamondsuit>FLD IN e END) : \<parallel>V, Some (nodeAP l), AP,n, C \<ggreater> T, m\<parallel>"
apply (subgoal_tac "G \<rhd> (LET rf t = l\<diamondsuit>FLD IN e END) : \<parallel>U-{varAP t}, Some (nodeAP l), (rfldAP (nodeAP l) FLD) # APs,n, C \<ggreater> T, m\<parallel>", clarsimp)
apply (case_tac "varAP t : U")
apply (erule LETGETFR_noWaste[simplified], assumption+) 
apply (rule muWEAK_AP , drule LETGETFR_Waste, assumption+)
done

lemma UNFOLD:
   "\<lbrakk>\<parallel>U, Some(nodeAP x), rfldAPs,n,C(x\<mapsto>\<^sub>fnodeET (k,recET REC,h<l\<bullet>DOLLAR>)) \<ggreater> T, m\<parallel> E h hh v p; 
       E\<lfloor>x\<rfloor> = Ref l; 
       distinct (map fst REC); x \<notin> roots U; rfldAPs = get_rfldAPs REC x;
       GETr C x = Some(muET S); subst S (muET S) (sumET (kL,recET L,i) (kR,recET R,j));
       h<l\<bullet>DOLLAR> = i \<longrightarrow> (k=kL \<and> REC =L); h<l\<bullet>DOLLAR> =j \<longrightarrow> (k=kR \<and> REC =R)\<rbrakk> \<Longrightarrow>
    \<lbrace>U \<union> {varAP x}, n, C \<ggreater> T, m\<rbrace> E h hh v p"
apply (simp add: DAss_def muDAss_def, clarsimp)
apply (drule Yps_SPLIT)
apply (subgoal_tac "{varAP x} \<union> U = insert (varAP x) U", assumption, simp) 
  apply (erule thin_rl, simp add: roots_def, case_tac "varAP x : U") apply (erule_tac x="varAP x" in allE, clarsimp, fast)
apply clarsimp
apply (erule Yps.elims, simp_all, clarsimp)
apply (rotate_tac -4)
apply (erule Yps.elims, simp_all, clarsimp)
apply (case_tac "l \<in> Dom h", clarsimp) prefer 2 apply clarsimp
apply (erule lookupAP.elims)
defer 1 apply clarsimp+
apply (frule modelsETLocn, simp)
  apply (frule modelsET_region_in_heap)
apply (erule modelsET.elims, simp_all, clarsimp)
apply (drule subst_unique, assumption, clarsimp)
apply (erule modelsET.elims, simp_all, clarsimp)
(*  apply (case_tac "varAP x : U")
    apply (simp add: roots_def) apply (erule_tac x="varAP x" in allE, clarsimp)
    apply clarsimp*)
apply (erule_tac x=q in allE, erule_tac x=F in allE,erule_tac x=RR2 in allE,erule_tac x=Ra in allE)
apply (rotate_tac -1, erule impE)
  prefer 2 apply (subgoal_tac "F \<union> RR2 \<union> Ra = F \<union> (Ra \<union> RR2)", clarsimp) apply (erule thin_rl)+ apply fast
apply (rule_tac x=N in exI, simp)
apply (erule disjE)
 apply clarsimp
  apply (drule modelsET_Unfold)
  apply (rule_tac x="[]" in exI, simp)
  apply (subgoal_tac "RVal (Ref l) = RVal (renv E x)", assumption, simp)
  apply assumption
  apply simp
  apply assumption
  apply simp
  apply assumption
  apply assumption
  apply fast
  apply fast
  apply fast
  apply simp
  apply (rule_tac x="kL + Nb + n2" in exI, simp)
  apply fast
 apply clarsimp
  apply (drule modelsET_Unfold)
  apply (rule_tac x="[]" in exI, simp)
  apply (subgoal_tac "RVal (Ref l) = RVal (renv E x)", assumption, simp)
  apply assumption
  apply simp
  apply assumption
  apply simp
  apply assumption
  apply assumption
  apply fast
  apply fast
  apply fast
  apply simp
  apply (rule_tac x="kR + M + n2" in exI, simp)
  apply fast
done

(*Notice that while the else-branch in the prog holds whenever DOLLAR \<noteq> i holds, 
  we can prove the claim using an assumption for e2 which uses DOLLAR=j. That's because of the
  typing, of course - but we need to unfold DAss (not muDAss) in the proof*)
lemma MATCH:
      "\<lbrakk>GETr C x = Some (muET S); subst S (muET S) (sumET (kL,recET T1,i) (kR,recET T2,j)); i \<noteq> j;
        distinct (map fst T1); distinct (map fst T2);
        G \<rhd> e1 : \<parallel>U,Some (nodeAP x), get_rfldAPs T1 x, n,C(x\<mapsto>\<^sub>f(nodeET(kL,recET T1,i))) \<ggreater> T, m\<parallel>;
        G \<rhd> e2 : \<parallel>U,Some (nodeAP x), get_rfldAPs T2 x, n,C(x\<mapsto>\<^sub>f(nodeET(kR,recET T2,j))) \<ggreater> T, m\<parallel>;
        x \<notin> roots U\<rbrakk>
       \<Longrightarrow>
        G \<rhd> (LET t = x\<bullet>DOLLAR; 
                  b = Primop (\<lambda> x y . if x=i then 1 else 0) t t 
             IN IF b THEN e1 ELSE e2 END): \<lbrace>U \<union> {varAP x},n,C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
apply (rule vdm_leti, rule vdm_prim)
apply (rule vdm_if) apply assumption apply assumption
apply (rotate_tac 5, erule thin_rl, erule thin_rl) 
apply clarsimp
apply (rule DAssC_PConst)
apply (case_tac"h<a\<bullet>DOLLAR> = i" )
  apply clarsimp  
    apply (rule DAss_PreservedU)
      apply (erule UNFOLD[simplified])
        apply simp
        apply assumption+
        apply simp
        apply assumption+
        apply simp
        apply simp
      apply (rule, simp)
  apply clarsimp
    apply (rule DAss_PreservedU)
    prefer 2 apply (subgoal_tac "renv E = renv (E<t:=h<a\<bullet>DOLLAR>><b:=0>)", assumption, rule, simp)
    apply (simp add: DAss_def, clarsimp) 
    apply (subgoal_tac "h<a\<bullet>DOLLAR> = j", clarsimp)
    prefer 2 apply (drule Yps_SPLIT) apply (subgoal_tac "{varAP x} \<union> U = insert (varAP x) U", assumption, simp)
      apply (case_tac "varAP x : U", simp add: roots_def, erule_tac x= "varAP x" in allE) apply clarsimp apply fast
      apply clarsimp
      apply (erule Yps.elims, simp_all, clarsimp)
      apply (case_tac "a \<in> Dom ha", clarsimp) prefer 2 apply clarsimp
      apply (erule lookupAP.elims, simp_all)
      apply clarsimp
      apply (erule modelsET.elims, simp_all, clarsimp)
      apply (drule subst_unique, assumption) apply clarsimp
      apply (erule modelsET.elims, simp_all)
    apply (drule UNFOLD[simplified])
        apply simp
        apply assumption+
        apply simp
        apply assumption+
        apply simp
        apply simp
      apply (simp add: DAss_def)
      apply fast
done

lemma MATCH_WEAK:
      "\<lbrakk>GETr C x = Some (muET S); subst S (muET S) (sumET (kL,recET T1,i) (kR,recET T2,j)); i \<noteq> j;
        distinct (map fst T1); distinct (map fst T2);
        G \<rhd> e1 : \<parallel>V,Some (nodeAP x), get_rfldAPs T1 x, n,C(x\<mapsto>\<^sub>f(nodeET(kL,recET T1,i))) \<ggreater> T, m\<parallel>;
        G \<rhd> e2 : \<parallel>W,Some (nodeAP x), get_rfldAPs T2 x, n,C(x\<mapsto>\<^sub>f(nodeET(kR,recET T2,j))) \<ggreater> T, m\<parallel>;
        U = V \<union> W;
        x \<notin> roots U\<rbrakk>
       \<Longrightarrow>
        G \<rhd> (LET t = x\<bullet>DOLLAR; 
                  b = Primop (\<lambda> x y . if x=i then 1 else 0) t t 
             IN IF b THEN e1 ELSE e2 END): \<lbrace>U \<union> {varAP x},n,C \<ggreater> T, m\<rbrace>"
apply (erule MATCH, assumption+)
apply (erule muWEAK, fast) 
apply (erule muWEAK, fast) 
apply assumption
done

lemma END_MATCH: "\<lbrakk>G \<rhd> e : \<lbrace>U,n,C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow> G \<rhd> e : \<parallel>U, None, [], n, C \<ggreater> T, m\<parallel>"
by (simp add: DAss_MuDass)

lemma muDA_SOME: "\<lbrakk>G \<rhd> e : \<parallel>U,None,[],n,C \<ggreater> T, m\<parallel>; x \<notin> roots U\<rbrakk> \<Longrightarrow> G \<rhd> e : \<parallel>U, Some(nodeAP x), [], n, C \<ggreater> T, m\<parallel>"
apply (erule vdm_conseq)
apply (simp add: muDAss_def, clarsimp)
apply (erule_tac x=q in allE, erule_tac x=F in allE)
apply (erule mYps.elims, simp_all, clarsimp)
apply (case_tac "locns (renv Ea x) \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
apply (erule_tac x=Ra in allE, erule_tac x="{}" in allE, erule impE)
  apply (rule_tac x=N in exI, simp)
  apply (rule, rule, rule, rule)
   apply (erule mYps_NONE)
   apply (rule, fast) apply simp
apply clarsimp
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, simp)
apply (rule, erule modif_monotone, fast) apply fast
done

lemma NON_DESTR: "\<lbrakk>G \<rhd> e : \<lbrace>U,n,C \<ggreater> T, m\<rbrace>; x \<notin> roots U\<rbrakk> \<Longrightarrow> G \<rhd> e : \<parallel>U, Some(nodeAP x), [], n, C \<ggreater> T, m\<parallel>"
by (rule muDA_SOME, erule END_MATCH, assumption)

lemma FREE: "\<lbrakk>G \<rhd> e : \<lbrace>U,nn,C \<ggreater> T, m\<rbrace>; nn = n+1\<rbrakk> \<Longrightarrow> 
                    G \<rhd> (LET _ = DIAM\<bullet>Free([RNarg x]) IN e END): \<parallel>U, Some(nodeAP x), [], n, C \<ggreater> T, m\<parallel>"
apply (rule vdm_conseq) 
apply (rule vdm_letv) 
  apply (subgoal_tac "G \<rhd>  (DIAM\<bullet>Free([RNarg x])) : (\<lambda> E h hh v p . \<forall> a . E\<lfloor>x\<rfloor> = Ref a \<longrightarrow> hh =
                  h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                   sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>)", assumption) 
  prefer 2 apply assumption
apply (rule vdm_invokestatic)
apply (simp add: Meth_Free)
apply (rule vdm_conseq) 
apply (rule vdm_letr, rule vdm_getstat)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_putstat) 
apply clarsimp
  apply (simp add: newframe_env_def) 
  apply (simp add: evalARGS_def self_def)
apply (simp add: muDAss_def, clarsimp)
  apply (erule thin_rl, erule mYps.elims, simp_all, clarsimp)
apply (case_tac "locns (renv Ea x) \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
apply (simp add: DAss_def)
apply (erule_tac x=q in allE, erule_tac x="insert l F" in allE, erule_tac x="Ra" in allE, erule impE)
prefer 2 apply clarsimp
  apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, simp)
  apply (simp add: modif_def sameOH_def, clarsimp)
  apply (erule_tac x=la in allE, erule impE)
    apply clarsimp
  apply (erule conjE)
   apply (erule_tac x="rfield" in allE)
    apply (case_tac "rfield = DOLLAR_N", clarsimp)
    apply clarsimp
apply (rule_tac x="Suc N" in exI, rule)
  apply (simp add: freelist_def)
  apply (rule FL_SUC[simplified]) apply simp apply assumption
  apply simp
  apply (erule FL_UpdateOutside, assumption)  
apply (rule_tac x=Na in exI, rule_tac x=La in exI, simp)
apply (subgoal_tac "(RVal (Ref l), ha, nodeET (k, recET T,ha<l\<bullet>DOLLAR>), {l}, k) \<in> modelsET")
prefer 2
  apply (erule modelsETNode, simp, simp, simp) 
apply (erule YpsPreserved_h_h1)
prefer 2 apply (subgoal_tac "modif (F \<union> {l}) ha
           (ha\<lparr>rheap := (rheap ha)(DOLLAR_N := (rheap ha DOLLAR_N)(l := ha\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                 sheap := (sheap ha)(DIAM := (sheap ha DIAM)(DOLLAR_F := Ref l))\<rparr>)", assumption) 
         apply (simp add: modif_def sameOH_def)
apply fast
apply simp
done

(*specialisations to iList type:
lemma CONS_UNFOLDrec[rule_format]:
"\<lbrakk>(C,varAP x,E,h,recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]):lookupAP;
  evalAP (varAP x) E h = Some(Ref l,X); 
  (E,h,U \<union> {varAP x},C,L,R,N):Yps; x \<notin> roots U;LL \<inter> RRR = {}\<rbrakk>
 \<Longrightarrow> (\<exists> LL RR RRR. (E,h,U,Some (nodeAP x), [rfldAP (nodeAP x) TL], {l},RRR,
                       C(x\<mapsto>\<^sub>f nodeET(kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)])),LL,RR,kC+N) : mYps
                   \<and> R = RRR \<union> RR \<and> RRR \<inter> RR = {} \<and> L={l} \<union> LL)"
apply (frule Yps_regionsExist, rule, fast, assumption)
apply clarsimp
apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (drule Yps_split, rule, fast)
  apply assumption
  apply simp apply fast
  apply assumption
apply clarsimp
apply (case_tac "varAP x : U")
  apply (simp add: roots_def) apply (erule_tac x="varAP x" in allE, clarsimp)
apply clarsimp
apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (rotate_tac -3)
  apply (erule modelsET.elims, simp_all, clarsimp)
(&  apply (rotate_tac -3)
  apply (erule modelsET.elims, simp_all, clarsimp)&)
  apply (frule modelsET_isLocn, clarsimp)
  apply (subgoal_tac "reg1 \<subseteq> Dom h")
  prefer 2 apply (erule modelsET_region_in_heap)
  apply (subgoal_tac "la:reg1")
  prefer 2 apply (erule modelsETLocn, simp)
(&  apply (erule modelsET.elims, simp_all, clarsimp)&)
  apply (rule_tac x= LLL in exI, simp)
  apply (rule_tac x= RRRa in exI)
  apply (rule_tac x= "{l} \<union> reg1" in exI, simp)
  apply (rule mYps_FLD)
    apply (rule mYps_SOME) apply (erule Yps_UnusedU_ContextExtension) apply (simp add: roots_def) apply fast 
                   apply fastsimp
                   apply fast
                   apply assumption
                   apply assumption
                   apply (simp add: GETr_def) apply fast
                   apply simp
    apply clarsimp
        apply (rule, clarsimp) 
        apply (subgoal_tac "la=la \<and> {la,l}={la,l}", assumption, simp)
        apply fast
    apply (rule lookupAP_RfldNode) 
       apply (rule lookupAP_Node) apply(simp add: GETr_def) apply fastsimp
       apply simp apply ((erule thin_rl)+,fast)
       apply simp apply ((erule thin_rl)+,fast)
       apply simp 
    apply assumption
    apply fast
    apply simp
    apply simp
done

lemma CONS_UNFOLD[rule_format]:
"\<lbrakk>GETr C x = Some(recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]);
  evalAP (varAP x) E h = Some(Ref l,X); h<l\<bullet>DOLLAR> \<noteq> 0;
  (E,h,U \<union> {varAP x},C,L,R,N):Yps; x \<notin> roots U;LL \<inter> RRR = {}\<rbrakk>
 \<Longrightarrow> (\<exists> LL RR RRR. (E,h,U,Some (nodeAP x), [rfldAP (nodeAP x) TL], {l},RRR,
                       C(x\<mapsto>\<^sub>f nodeET(kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)])),LL,RR,kC+N) : mYps
                   \<and> R = RRR \<union> RR \<and> RRR \<inter> RR = {} \<and> L={l} \<union> LL)"
apply (rule CONS_UNFOLDrec)
apply (erule lookupAP_Var)
apply assumption+
done

lemma CONS_FOLDrec[rule_format]:
"\<lbrakk>(C,varAP x,E,h,recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]):lookupAP;
  evalAP (varAP x) E h = Some(Ref l,X); h@@l=Some DIAM;
  x \<notin> roots U; LL \<inter> RRR = {};
  (E,h,U,Some (nodeAP x), [rfldAP (nodeAP x) TL], {l},RRR,
   C(x\<mapsto>\<^sub>f nodeET(kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)])),LL,RR,kC+N) : mYps;
  R = RRR \<union> RR; RRR \<inter> RR = {}; L={l} \<union> LL\<rbrakk>
\<Longrightarrow> (E,h,U \<union> {varAP x},C,L,R,N):Yps"
apply (erule mYps.elims, simp_all, clarsimp)
apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (case_tac "locns h\<lfloor>l\<diamondsuit>TL\<rfloor> \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (erule mYps.elims, simp_all, clarsimp)
apply (simp add: GETr_def, clarsimp)
apply (rotate_tac 1)
apply (erule lookupAP.elims,simp_all, clarsimp)+
prefer 2 apply clarsimp
  apply (erule lookupAP.elims,simp_all, clarsimp)+
  apply (erule lookupAP.elims,simp_all)
apply (rule Yps_CONS)
  apply fast
  apply (erule lookupAP_Var)
  apply simp apply fast
  apply (rule modelsETRecC, assumption)
        apply fastsimp
        apply simp apply (rule modelsETInt)
        apply (rule modelsETRecC, assumption)
          apply fastsimp
          apply (simp add: GETr_def, clarsimp) apply assumption  
          apply (erule modelsETRecN, simp)
                 apply assumption
                 apply fast
                 apply simp
                 apply simp
                 apply simp
                 apply simp
                 apply simp
                 apply simp
                 apply simp
      apply (case_tac "varAP x : U")
        apply (simp add: roots_def) apply (erule_tac x="varAP x" in allE, clarsimp)
      apply clarsimp 
      apply (erule YpsPreservedU) apply simp
             apply (erule lookupAP_Update3) prefer 2 apply simp apply (simp add: roots_def) 
         apply fast 
         apply fast
         apply fast 
         apply simp 
         apply simp 
         apply simp 
done

lemma CONS_FOLD[rule_format]:
"\<lbrakk>GETr C x = Some(recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]);
  evalAP (varAP x) E h = Some(Ref l,X);  h@@l=Some DIAM;
  x \<notin> roots U; LL \<inter> RRR = {};
  (E,h,U,Some (nodeAP x), [rfldAP (nodeAP x) TL], {l},RRR,
   C(x\<mapsto>\<^sub>f nodeET(kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)])),LL,RR,kC+N) : mYps;
  R = RRR \<union> RR; RRR \<inter> RR = {}; L={l} \<union> LL\<rbrakk>
\<Longrightarrow> (E,h,U \<union> {varAP x},C,L,R,N):Yps"
apply (rule CONS_FOLDrec)
apply (erule lookupAP_Var)
apply assumption+
done

lemma LETGET_HD:
"\<lbrakk>G \<rhd> e : \<parallel>U, Some (nodeAP l),V, n, C \<ggreater> T, m\<parallel>;
  GETr C l = Some(nodeET(k, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]))\<rbrakk>
\<Longrightarrow>  G \<rhd> (LET x = l\<bullet>HD IN e END) : \<parallel>U, Some (nodeAP l), V,n, C \<ggreater> T, m\<parallel>"
apply (rule vdm_conseq, rule vdm_leti)
apply (rule vdm_getfi) 
apply assumption
apply clarsimp 
apply (simp add: muDAss_def, clarsimp)
apply (erule_tac x=q in allE)
apply (erule_tac x=F in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=rg in allE, erule impE)
prefer 2 apply assumption
apply (rule_tac x=N in exI, simp)
apply (rule_tac x=P in exI)
apply (rule_tac x=L in exI)
apply (rule_tac x=cl in exI, simp)
apply (erule mYpsPreservedU)
  apply (rule renvEvalAP, rule,simp)
  apply (erule lookupAP_PreservedE, simp)
  apply clarsimp apply (erule lookupAP.elims, simp_all)
  apply clarsimp apply (erule lookupAP_Node) apply fastsimp
done

lemma LETGET_TL:
"\<lbrakk>G \<rhd> e : \<parallel>U, Some (nodeAP l),[], n, C(t\<mapsto>\<^sub>f(iList HD TL kN kC)) \<ggreater> T, m\<parallel>; l \<notin> roots U; varAP t:U;
  \<forall> p. p:U \<longrightarrow> (\<exists> x . p=varAP x);
  GETr C l = Some(nodeET(k, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]))\<rbrakk>
\<Longrightarrow>  G \<rhd> (LET rf t = l\<diamondsuit>TL IN e END) : \<parallel>U-{varAP t}, Some (nodeAP l), [rfldAP (nodeAP l) TL],n, C \<ggreater> T, m\<parallel>"
apply (rule vdm_conseq) 
apply (rule vdm_letr, rule vdm_getfr) 
apply assumption
apply (erule thin_rl)
apply clarsimp 
apply (subgoal_tac "l \<noteq> t")
prefer 2 apply (simp add: roots_def) apply (erule_tac x= "varAP t" in allE, fastsimp)
apply (simp add: muDAss_def, clarsimp)
apply (frule mYps_NodelocDom, simp, simp)
apply (erule mYps.elims, simp_all, clarsimp)
apply (case_tac "locns ha\<lfloor>a\<diamondsuit>TL\<rfloor> \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
apply (erule mYps.elims, simp_all, clarsimp) 
apply (erule lookupAP.elims, simp_all, clarsimp)+
prefer 2 
  apply clarsimp
  apply (erule lookupAP.elims, simp_all)
apply (erule_tac x=q in allE)
apply (erule_tac x=F in allE)
apply (erule_tac x="RR1\<union>R"  in allE)
apply (erule_tac x="{lb}" in allE, erule impE)
prefer 2 apply clarsimp
  apply (rule_tac x=Rv in exI, 
         rule_tac x=S in exI, 
         rule_tac x=M in exI, 
         rule_tac x=FF in exI, simp)
  apply (erule modif_monotone, fast)
apply (rule_tac x=N in exI, simp)
apply (rule_tac x="Nb+k+N1" in exI)
apply (rule_tac x="insert la L" in exI)
apply (rule_tac x="{lb}" in exI, simp)
apply rule prefer 2 apply rule apply (drule modelsETLocn, simp) apply fast apply fastsimp
apply (rule mYps_SOME)
(&1&)
  apply (frule modelsETLocn, simp)
  apply (erule Yps_CONS)
    apply (rule lookupAP_Var, simp add: GETr_def)
    apply simp apply (rule, fast, fast)
    apply assumption
    apply (erule YpsPreservedU)
     apply (rule evalAP_root, simp) apply (subgoal_tac "root x \<noteq> t", clarsimp) 
         apply (erule_tac x=x in allE, fastsimp)
     apply (drule lookupAP_Update2)
       apply (subgoal_tac "t \<noteq> root x", assumption) apply (erule_tac x=x in allE, clarsimp) 
       apply (drule lookupAP_PreservedE) 
       prefer 2 apply simp
       apply (subgoal_tac "t \<noteq> root x", simp) apply (erule_tac x=x in allE, clarsimp)     
     apply fast apply fast apply fast apply fast apply simp apply simp
(&2&) apply simp
(&3&)  apply (drule modelsETLocn, simp) apply fast
(&4&)  apply assumption
(&5&)  apply assumption
(&6&)  apply (erule GETr_Update2, fast)
(&7&)  apply simp
done

lemma LETGET_HDTL:
"\<lbrakk>G \<rhd> e : \<parallel>U, Some (nodeAP l),[], n, C(t\<mapsto>\<^sub>f(iList HD TL kN kC)) \<ggreater> T, m\<parallel>;  l \<notin> roots U; varAP t:U;
  \<forall> p. p:U \<longrightarrow> (\<exists> x . p=varAP x);
  GETr C l = Some(nodeET(k, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]))\<rbrakk>
\<Longrightarrow>  G \<rhd> (LET h = l\<bullet>HD; rf t = l\<diamondsuit>TL IN e END) : \<parallel>U-{varAP t}, Some (nodeAP l), [rfldAP (nodeAP l) TL],n, C \<ggreater> T, m\<parallel>"
apply (rule LETGET_HD)
apply (erule LETGET_TL)
apply assumption+
done*)

lemma "\<lbrakk>GETr C l = Some(iList HD TL kN kC); l \<noteq> t\<rbrakk> \<Longrightarrow>
        G \<rhd> (LET tg = l\<bullet>DOLLAR; 
                b = Primop (\<lambda> x y . if x=0 then 1 else 0) tg tg 
             IN IF b THEN expr.Int 5 ELSE (LET h = l\<bullet>HD; rf t = l\<diamondsuit>TL IN IVar h END) END) : \<lbrace>{varAP l},0,C \<ggreater> intET, 0\<rbrace>"
apply (rule WEAK)
  apply (rule MATCH_WEAK) 
    apply (simp add: iList_def)
    apply (rule substitution_listsubstitution.intros)+
    apply simp
    apply simp
    apply simp 
    apply simp apply (rule NON_DESTR)
              apply (rule INT)
                apply (simp add: roots_def)
    apply simp apply (rule LETGETFI) 
                 apply (rule LETGETFR) 
                   apply simp
                   apply simp
                   apply simp
                   apply (simp add: GETr_def) apply (rule, fast, fast)
                   apply simp
                   apply (rule NON_DESTR)
                     apply (rule IVAR)
                     apply (simp add: roots_def)
                   apply (simp add: roots_def)
                   apply simp
                   apply simp
                 apply (simp add: GETr_def) apply (rule, fast, fast)
                 apply simp
   apply simp
   apply (simp add: roots_def)
apply simp
done
                 
lemma "\<lbrakk>GETr C x = Some(iTree I L R kN kC); x \<noteq> l; x \<noteq> t; L \<noteq> R\<rbrakk> \<Longrightarrow>
        G \<rhd> (LET tg = x\<bullet>DOLLAR; 
                   b = Primop (\<lambda> x y . if x=0 then 1 else 0) tg tg 
             IN IF b THEN LET h = x\<bullet>I IN IVar h END ELSE (LET rf t = x\<diamondsuit>L; rf t = x\<diamondsuit>R IN expr.Int 27 END) END) : \<lbrace>{varAP x},0,C \<ggreater> intET, 0\<rbrace>"
apply (rule WEAK)
  apply (rule MATCH_WEAK) 
    apply (simp add: iTree_def)
    apply (rule substitution_listsubstitution.intros)+
    apply simp
    apply simp
    apply simp
    apply simp apply (rule LETGETFI) 
                 apply (rule NON_DESTR)
                   apply (rule IVAR)
                   apply (simp add: roots_def)
                 apply (simp add: GETr_def) apply (rule, fast, fast)
                 apply simp
    apply simp apply (rule LETGETFR) 
                   apply simp
                   apply simp
                   apply simp
                   apply (simp add: GETr_def) apply (rule, fast, fast)
                   apply simp
                   apply (rule LETGETFR) 
                     apply simp
                     apply simp
                     apply simp
                     apply (rule GETr_Update2) 
                       apply (simp add: GETr_def) apply (rule, fast, fast)
                       apply fastsimp
                     apply simp
                     apply (rule NON_DESTR)
                       apply (rule INT)
                       apply (simp add: roots_def)
                     apply (simp add: roots_def)
                     apply simp
                     apply simp
                     apply (simp add: roots_def)
                     apply simp
                     apply simp
                     apply simp
                     apply (simp add: roots_def)
                     apply simp
done

(*The following lemma rightly fails: the order of the GetFr instructions is
  not the one we expect from the definition of type iTree*)
lemma "\<lbrakk>GETr C x = Some(iTree I L R kN kC); x \<noteq> l; x \<noteq> t; L \<noteq> R\<rbrakk> \<Longrightarrow>
        G \<rhd> (LET tg = x\<bullet>DOLLAR; 
                   b = Primop (\<lambda> x y . if x=0 then 1 else 0) tg tg 
             IN IF b THEN LET h = x\<bullet>I IN IVar h END ELSE (LET rf t = x\<diamondsuit>R; rf t = x\<diamondsuit>L IN expr.Int 27 END) END) : \<lbrace>{varAP x},0,C \<ggreater> intET, 0\<rbrace>"
apply (rule WEAK)
  apply (rule MATCH_WEAK) 
    apply (simp add: iTree_def)
    apply (rule substitution_listsubstitution.intros)+
    apply simp
    apply simp
    apply simp
    apply simp apply (rule LETGETFI) 
                 apply (rule NON_DESTR)
                   apply (rule IVAR)
                   apply (simp add: roots_def)
                 apply (simp add: GETr_def) apply (rule, fast, fast)
                 apply simp
    apply simp apply (rule LETGETFR)
oops

lemma "\<lbrakk>GETr C x = Some(iTree I L R kN kC); x \<noteq> l; x \<noteq> t; L \<noteq> R\<rbrakk> \<Longrightarrow>
        G \<rhd> (LET tg = x\<bullet>DOLLAR; 
                   b = Primop (\<lambda> x y . if x=0 then 1 else 0) tg tg 
             IN IF b THEN LET h = x\<bullet>I; _ = DIAM\<bullet>Free([RNarg x]) IN IVar h END
                     ELSE LET rf t = x\<diamondsuit>L; rf t = x\<diamondsuit>R; _ = DIAM\<bullet>Free([RNarg x]) IN expr.Int 27 END
             END) : \<lbrace>{varAP x},0,C \<ggreater> intET, 1\<rbrace>"
apply (rule WEAK)
  apply (rule MATCH_WEAK) 
    apply (simp add: iTree_def)
    apply (rule substitution_listsubstitution.intros)+
    apply simp
    apply simp
    apply simp
    apply simp apply (rule LETGETFI) 
                 apply (rule FREE)
                   apply (rule IVAR)
                   apply simp
                 apply (simp add: GETr_def) apply (rule, fast, fast)
                 apply simp
    apply simp apply (rule LETGETFR) 
                   apply simp
                   apply simp
                   apply simp
                   apply (simp add: GETr_def) apply (rule, fast, fast)
                   apply simp
                   apply (rule LETGETFR) 
                     apply simp
                     apply simp
                     apply simp
                     apply (rule GETr_Update2) 
                       apply (simp add: GETr_def) apply (rule, fast, fast)
                       apply fastsimp
                     apply simp
                     apply (rule FREE)
                       apply (rule INT)
                       apply simp
                     apply (simp add: roots_def)
                     apply simp
                     apply simp
                     apply (simp add: roots_def)
                     apply simp
                     apply simp
                     apply simp
                     apply (simp add: roots_def)
                     apply simp
done

(*lemma mYpsPreserved_h_h1[rule_format]:
"(E, h, U, ND, APs, L, R, C, LL, RR, n2) \<in> mYps \<Longrightarrow>
   (R \<union> LL \<union> RR) \<inter> F = {} \<longrightarrow> modif F h h1 \<longrightarrow>
                  oheap h = oheap h1 \<longrightarrow>
                  (E, h1, U, ND, APs, L, R, C, LL, RR, n2) \<in> mYps"
apply (erule mYps.induct)
(-NONE-)
apply clarsimp apply (rule mYps_NONE)
                 apply (erule YpsPreserved_h_h1, assumption+) 
(-SOME-)
apply clarsimp
apply (case_tac "locns (renv E x) \<subseteq> Dom h1", clarsimp) prefer 2 apply clarsimp
  apply (rule mYps_SOME)
    apply (erule YpsPreserved_h_h1, assumption+)
    apply simp
    apply fast
    apply assumption+
    apply simp
(-FLD-)
apply clarsimp
apply (case_tac "evalAP x E h", clarsimp+)
apply (case_tac "a", clarsimp+)
apply (case_tac "locns (h\<lfloor>nat\<diamondsuit>Fa\<rfloor>) \<subseteq> Dom h1", clarsimp) prefer 2 apply clarsimp
apply (drule  mYps_NodelocReg) apply simp apply clarsimp
apply (case_tac "a: Dom h1", clarsimp) prefer 2 apply clarsimp
apply (erule impE) apply fast
apply (frule modelsET_region_in_heap)
apply (frule modelsETLocn, simp)
apply (subgoal_tac "sameOH {l, nat} h h1")
prefer 2  apply (simp add: modif_def)
    apply (erule sameOHAntiMonotone) apply fast  
apply (subgoal_tac "evalAP (rfldAP (nodeAP xa) Fa) E h = Some(Ref l, {l,nat})")
prefer 2 apply simp
apply (subgoal_tac "evalAP (rfldAP (nodeAP xa) Fa) E h1 = Some(Ref l, {l,nat})")
prefer 2 apply (erule evalAP_Same, assumption)  
apply (erule mYps_FLD) 
  apply assumption 
  apply (erule lookupAP_Same) apply assumption+ 
  apply (erule modelsET_Preserved)
      apply (simp add: modif_def) apply (erule sameOHAntiMonotone) apply fast
      apply fast
      apply simp
      apply simp
done*)

lemma evalAP_PutFi[rule_format]:
"\<forall> l LL . (evalAP p E h = Some (Ref l, LL) \<longrightarrow>
      evalAP p E (h\<lparr>iheap := \<lambda>u. if u = FLD then \<lambda>u. if u = a then i else h<u\<bullet>FLD> else iheap h u\<rparr>) =
        Some (Ref l, LL))"
apply (induct p)
apply clarsimp
apply clarsimp
apply clarsimp
  apply (case_tac "evalAP AP E h", clarsimp+)
  apply (case_tac "aa", clarsimp+) 
  apply (case_tac "locns h\<lfloor>nat\<diamondsuit>rfldname\<rfloor> \<subseteq> Dom h", clarsimp+)
done

lemma lookupAP_PutFi[rule_format]:
"(C, p, E, h, T) \<in> lookupAP \<Longrightarrow>  
(\<forall> FLD hh. DOLLAR \<noteq> FLD \<longrightarrow> hh = h\<lparr>iheap := (iheap h)(FLD := (iheap h FLD)(a := i))\<rparr> \<longrightarrow> (C, p, E, hh,T) \<in> lookupAP)"
apply (erule lookupAP.induct, simp_all)
apply clarsimp
  apply (erule lookupAP_Var) apply (assumption, simp)
apply clarsimp
  apply (erule lookupAP_Node, fastsimp) apply (assumption, simp, simp)
apply clarsimp
  apply (drule evalAP_PutFi)
  apply (erule_tac x=FLD in allE, clarsimp)
  apply (erule lookupAP_Mu) apply assumption+ 
  apply clarsimp
  apply clarsimp
  apply simp
  apply simp
  apply simp
apply clarsimp
  apply (drule evalAP_PutFi)
  apply (erule_tac x=FLD in allE, clarsimp)
  apply (erule lookupAP_Sum) apply assumption+ 
  apply clarsimp 
  apply clarsimp
  apply assumption
  apply simp
  apply simp
apply clarsimp
  apply (drule evalAP_PutFi)
  apply (erule_tac x=FLD in allE, clarsimp)
  apply (erule lookupAP_RfldNode) apply assumption+
  apply simp
  apply assumption
apply clarsimp
  apply (drule evalAP_PutFi)
  apply (erule_tac x=FLD in allE, clarsimp)
  apply (erule lookupAP_RfldRec) apply (assumption, simp, assumption)
done

lemma PutFi_Triv:
"h\<lparr>iheap := (iheap h)(FLD := (iheap h FLD)(a := i))\<rparr> = h\<lparr>iheap := \<lambda>u. if u = FLD then \<lambda>u. if u = a then i else h<u\<bullet>FLD> else iheap h u\<rparr>"
apply (rule, clarsimp)
apply (rule, clarsimp)
apply (rule, clarsimp)
apply (rule, clarsimp)
apply (rule, clarsimp)
apply simp
done

lemma modelsET_PutFi[rule_format]:
"(RVal (Ref l), h, T, RR1, N1) \<in> modelsET \<Longrightarrow>
   (DOLLAR \<noteq> FLD \<longrightarrow> (RVal (Ref l), h\<lparr>iheap := (iheap h)(FLD := (iheap h FLD)(a := i))\<rparr>, T, RR1, N1) \<in> modelsET)"
apply (erule modelsET.induct, simp_all)
apply clarsimp
  apply (rule modelsETInt) 
apply clarsimp 
  apply (rule modelsETSum) 
    apply simp
    apply clarsimp
    apply assumption
    apply clarsimp apply (rule, assumption, simp)
    apply clarsimp apply (rule, assumption, simp)
apply clarsimp 
  apply (rule modelsETNode) 
    apply simp
    apply simp
    apply simp
    apply simp
apply clarsimp 
  apply (rule modelsETRecN) 
    apply simp
    apply simp
prefer 2
apply clarsimp
  apply (rule modelsETMu)
    apply simp
    apply assumption+
apply clarsimp 
  apply (rule modelsETRecC) 
    apply simp
    apply fastsimp
    apply simp
    apply (case_tac F)
    apply clarsimp apply (erule modelsET.elims, simp_all)
    apply safe apply (rule modelsETInt)
done

lemma YpsPreserved_PutFi[rule_format]:
"(E,h,U,C,L,R,N) \<in> Yps \<Longrightarrow>
 (DOLLAR \<noteq> FLD  \<longrightarrow>
  (E,h\<lparr>iheap := (iheap h)(FLD := (iheap h FLD)(a := i))\<rparr>,U,C,L,R,N) \<in> Yps)"
apply (erule Yps.induct, simp_all)
apply clarsimp
  apply (rule Yps_NIL, simp, simp)
apply clarify
  apply (erule Yps_CONS)
  apply (erule lookupAP_PutFi) apply assumption  apply (simp add: PutFi_Triv)
  apply (erule evalAP_PutFi)
  apply (drule modelsET_PutFi, assumption)  apply (simp add: PutFi_Triv)
  apply (simp add: PutFi_Triv)
  apply assumption+
  apply simp+
done

lemma mYpsPreserved_PutFi[rule_format]:
"(E, h, U, ND, APs, L, R, C, LL, RR, n2) \<in> mYps \<Longrightarrow>
   DOLLAR \<noteq> FLD  \<longrightarrow> (E, h\<lparr>iheap := (iheap h)(FLD := (iheap h FLD)(a := i))\<rparr>, U, ND, APs, L, R, C, LL, RR, n2) \<in> mYps"
apply (erule mYps.induct)
(*NONE*)
apply clarsimp apply (rule mYps_NONE)
               apply (drule YpsPreserved_PutFi) apply simp apply (simp add: PutFi_Triv)
(*SOME*)
apply clarsimp
apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (rule mYps_SOME)
    apply (drule YpsPreserved_PutFi) apply assumption apply (simp add: PutFi_Triv)
    apply (rule evalAP_PutFi) apply simp 
    apply fast
    apply assumption+
    apply simp
    apply assumption+
    apply simp
(*FLD*)
apply clarsimp
apply (case_tac "evalAP x E h", clarsimp+)
apply (case_tac "aa", clarsimp+)
apply (case_tac "locns (h\<lfloor>nat\<diamondsuit>F\<rfloor>) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (drule  mYps_NodelocReg) apply simp apply clarsimp
apply (case_tac "aa: Dom h", clarsimp) prefer 2 apply clarsimp
apply (frule modelsET_region_in_heap)
apply (frule modelsETLocn, simp)
apply (erule mYps_FLD) 
  apply simp 
  apply simp apply (rule, fast, simp) 
  apply (erule lookupAP_PutFi, assumption) apply (simp add:PutFi_Triv)
  apply (drule modelsET_PutFi, assumption) apply (simp add:PutFi_Triv) 
  apply fast 
  apply simp 
  apply simp 
done 

lemma LETPUTFI:
"\<lbrakk>G \<rhd> e : \<parallel>U, Some (nodeAP l),V, n, C \<ggreater> T, m\<parallel>;
  GETr C l = Some(nodeET(k, recET TT,i)); DOLLAR \<noteq> FLD;
  lookup TT (ifldn FLD) = Some intET\<rbrakk>
\<Longrightarrow>  G \<rhd> (LET _ = l\<bullet>FLD := x IN e END) : \<parallel>U, Some (nodeAP l), V,n, C \<ggreater> T, m\<parallel>"
apply (rule vdm_conseq, rule vdm_letv, rule vdm_putfi) 
apply assumption
apply clarsimp 
apply (simp add: muDAss_def, clarsimp)
apply (erule mYps.elims, simp_all, clarsimp)
  apply (case_tac "a: Dom ha", clarsimp) prefer 2 apply clarsimp
  apply (erule_tac x=q in allE)
  apply (erule_tac x=F in allE)
  apply (erule_tac x=Ra in allE)
  apply (erule_tac x="{la}" in allE, erule impE)
  prefer 2 apply clarsimp
    apply (rule_tac x=Rv in exI)
    apply (rule_tac x=S in exI)
    apply (rule_tac x=M in exI)
    apply (rule_tac x=FF in exI, simp)
    apply (simp add: modif_def sameOH_def, clarsimp)
    apply (erule_tac x=laa in allE, clarsimp)
    apply (erule_tac x=ifield in allE)
    apply (case_tac "ifield = FLD", clarsimp, clarsimp)
  apply (rule_tac x=N in exI, simp, rule)
    apply (simp add: freelist_def)
    apply (erule FL_Preserved) apply (simp add: sameOH_def) 
  apply (rule_tac x="Na+k" in exI)
  apply (rule_tac x=La in exI)
  apply (rule_tac x="{la}" in exI, simp)
  apply (rule mYps_SOME)
    apply (erule YpsPreserved_PutFi, fast)
    apply (simp add: evalAP_PutFi)
    apply fast
    apply assumption
    apply simp
    apply assumption
    apply simp
    apply simp
(*Case FLD*)
apply clarsimp
  apply (case_tac "a: Dom ha", clarsimp) prefer 2 apply clarsimp
  apply (case_tac "locns ha\<lfloor>a\<diamondsuit>Fa\<rfloor> \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
  apply (frule modelsETLocn, simp)
  apply (frule  mYps_NodelocReg, simp, simp, clarsimp)
  apply (erule_tac x=q in allE)
  apply (erule_tac x=F in allE)
  apply (erule_tac x=Ra in allE)
  apply (erule_tac x="RR \<union> RR1" in allE, erule impE)
  prefer 2 apply clarsimp
    apply (rule_tac x=Rv in exI)
    apply (rule_tac x=S in exI)
    apply (rule_tac x=M in exI)
    apply (rule_tac x=FF in exI, simp)
    apply (simp add: modif_def sameOH_def)
    apply clarsimp
    apply (erule_tac x=laa in allE, clarsimp)
    apply (erule_tac x=ifield in allE)
    apply (case_tac "ifield = FLD", clarsimp)
    apply (case_tac "laa=a", fast, clarsimp)
    apply clarsimp
  apply (rule_tac x=N in exI, simp, rule)
    apply (simp add: freelist_def)
    apply (erule FL_Preserved) apply (simp add: sameOH_def) 
  apply (rule_tac x="Na+N1" in exI)
  apply (rule_tac x=La in exI)
  apply (rule_tac x="{a}" in exI, simp)
  apply (rule mYps_FLD)
      apply simp
      apply (erule mYpsPreserved_PutFi) apply assumption 
      apply (simp add: evalAP_PutFi) apply (rule, fast, simp) 
      apply (erule lookupAP_PutFi) apply assumption apply (simp add: PutFi_Triv)
      apply (erule modelsET_PutFi) apply assumption 
      apply fast 
      apply simp 
      apply simp
done

lemma modelsET_PutFr_Aux[rule_format]:
"(v, h, S, R, N) \<in> modelsET \<Longrightarrow> (\<forall> l a. v=RVal (Ref l) \<longrightarrow> a \<notin> R \<longrightarrow> l \<noteq> a \<longrightarrow>
(RVal (Ref l), h\<lparr>rheap := \<lambda>u. if u = FLD then \<lambda>u. if u = a then renv E x else h\<lfloor>u\<diamondsuit>FLD\<rfloor> else rheap h u\<rparr>, S, R, N) \<in> modelsET)"
apply (erule modelsET.induct, simp_all, clarsimp)
apply (rule modelsETSum)
    apply simp
    apply clarsimp
    apply assumption
    apply clarsimp apply (erule_tac x=a in allE, clarsimp) apply (rule, assumption, simp)
    apply clarsimp apply (erule_tac x=a in allE, clarsimp) apply (rule, assumption, simp)
apply clarsimp
  apply (rule modelsETNode) apply (simp, simp, simp, simp)
apply clarsimp
  apply (rule modelsETRecN) apply (simp, simp)
prefer 2 
  apply clarsimp 
  apply (rule modelsETMu) apply simp apply assumption  apply (erule_tac x=a in allE, clarsimp)
apply clarsimp
  apply (erule_tac x=aa in allE, clarsimp)
  apply (rule modelsETRecC) apply simp apply (simp, fastsimp) apply simp 
    prefer 2 apply assumption 
    prefer 4 apply simp
    prefer 4 apply simp
    defer 1 apply assumption+
    apply (case_tac "F=rfldn FLD", clarsimp+)
    apply (frule modelsET_isLocn, clarsimp)
    apply (erule_tac x=aa in allE)
      apply (drule modelsETLocn, simp)
      apply fast
    apply (case_tac "F")
    apply clarsimp apply (erule modelsET.elims, simp_all, clarsimp) apply (rule modelsETInt)
    apply clarsimp 
      apply (frule modelsET_isLocn, clarsimp)
    apply (erule_tac x=aa in allE)
      apply (drule modelsETLocn, simp)
      apply fast
done

lemma modelsET_PutFr[rule_format]:
"\<lbrakk>(RVal (Ref l), h, S, R, N) \<in> modelsET; a \<notin> R\<rbrakk> \<Longrightarrow>
 (RVal (Ref l), h\<lparr>rheap := \<lambda>u. if u = FLD then \<lambda>u. if u = a then renv E x else h\<lfloor>u\<diamondsuit>FLD\<rfloor> else rheap h u\<rparr>, S, R, N) \<in> modelsET"
apply (frule modelsET_PutFr_Aux)
apply simp
apply assumption
apply (frule modelsETLocn, simp, fast)
apply assumption
done

consts FLD_list::"AP \<Rightarrow> fldname option"
primrec
"FLD_list (varAP x) = None"
"FLD_list (nodeAP x) = None"
"FLD_list (rfldAP p F) = Some(rfldn F)"

consts mkFLD_list::"AP list \<Rightarrow> fldname list"
primrec
"mkFLD_list [] = []"
"mkFLD_list (h # t) = (case FLD_list h of None \<Rightarrow> mkFLD_list t | Some F \<Rightarrow> F # (mkFLD_list t))"

lemma Distinct_Triv: 
"\<lbrakk>FLDS = X @ (mkFLD_list ((rfldAP (nodeAP l) FLD) # APs)); distinct FLDS\<rbrakk> \<Longrightarrow>
  rfldn FLD \<notin> set (mkFLD_list APs)"
by simp

lemma mYps_PutFr[rule_format]:
"(E, h, U, ND, APs, {a}, rg, C, L, R, n1) \<in> mYps \<Longrightarrow>
       (\<forall> l . ND = Some (nodeAP l) \<longrightarrow>
          x \<noteq> l \<longrightarrow>
          GETr C x = Some S \<longrightarrow>
          GETr C l = Some (nodeET (k, recET TT,i)) \<longrightarrow> distinct (map fst TT) \<longrightarrow> lookup TT (rfldn FLD) = Some S \<longrightarrow> 
          renv E l = Ref a \<longrightarrow> rfldn FLD \<notin> set (mkFLD_list APs) \<longrightarrow>
          (E, h, {varAP x}, None, [], {}, {}, C, LL2, RR2, n2) \<in> mYps \<longrightarrow> (R \<union> rg) \<inter> RR2 = {} \<longrightarrow> L \<inter> RR2 = {}
          \<longrightarrow> LL2 \<inter> R = {} \<longrightarrow>
        (E, h\<lparr>rheap := (rheap h)(FLD := (rheap h FLD)(a := renv E x))\<rparr>, U, Some (nodeAP l), APs, {a}, rg, C, L, R, n1) \<in> mYps)"
apply (erule mYps.induct, simp_all)
apply clarsimp
  apply (case_tac "a: Dom h", clarsimp) prefer 2 apply clarsimp
  apply (rule mYps_SOME)
    apply (erule YpsPreserved_h_h1) apply (subgoal_tac "(L \<union> R) \<inter> {a} = {}", assumption, fast)
    apply (simp add: modif_def sameOH_def)
    apply simp
    apply simp
    apply fast
    apply assumption
    apply simp
    apply assumption
    apply simp
    apply simp
apply clarsimp
  apply (frule mYps_NodelocReg, simp, clarsimp)
  apply (subgoal_tac "a \<notin> RR1") prefer 2 apply fast
  apply (case_tac "a: Dom h", clarsimp) prefer 2 apply clarsimp
  apply (case_tac "locns h\<lfloor>a\<diamondsuit>F\<rfloor> \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (erule impE) apply (erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl)
                      apply (erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl) apply fast
(*  apply (rotate_tac 1)
  apply (erule mYps.elims, simp_all, clarsimp)
  apply (rotate_tac -1)
  apply (erule Yps.elims, simp_all, clarsimp)
  apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (erule Yps.elims, simp_all, clarsimp)*)
  apply (frule lookupAP_Node_GETr, assumption+, clarsimp)
  apply (rule mYps_FLD)
      apply assumption
      apply assumption
      apply clarsimp apply (rule, rule, fast) 
        apply (rule, rule, fast, simp)
      apply (frule mYps_NodelocDom, simp, assumption, simp) 
        apply (rule lookupAP_RfldNode)
          apply (erule lookupAP_Node) apply fastsimp
          apply simp 
          apply simp 
          apply clarsimp 
          apply simp apply (rule, fast, simp)
          apply simp
          apply simp
      apply (erule modelsET_PutFr) apply fast
      apply fast
      apply simp
      apply simp
done

lemma mYps_Some_Dollar[rule_format]:
"(E, h, U, ND, APs, cl, rg, C, L, R, N) \<in> mYps \<Longrightarrow> 
(\<forall> l. ND = Some (nodeAP l) \<longrightarrow> (\<forall> a k T i . GETr C l = Some (nodeET (k, recET T, i)) \<longrightarrow> E\<lfloor>l\<rfloor> = Ref a \<longrightarrow> h<a\<bullet>DOLLAR> = i))"
apply (erule mYps.induct, simp_all)
apply clarsimp
apply (case_tac "a: Dom h", clarsimp+)
done

lemma LET_INT:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow> G \<rhd> (LET z = expr.Int i IN e END): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_int, assumption)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI)
apply (rule_tac x=L in exI,safe)
apply (erule YpsPreservedU)
apply (rule evalAP_root) apply simp apply simp
apply (erule lookupAP_PreservedE, simp)
done

lemma LET_PRIM:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow> G \<rhd> (LET z = Primop f x y IN e END): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_prim, assumption)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI)
apply (rule_tac x=L in exI, safe)
apply (erule YpsPreserved, simp)
done

lemma LET_RPRIM:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; x : DOM C; y : DOM C
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END): \<lbrace>{varAP x, varAP y} \<union> U, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_rprim, assumption)
apply (simp add: DAss_def, safe)
apply (drule Yps_SPLIT)
  apply (subgoal_tac "((insert (varAP x) (insert (varAP y) U) - U)) \<union> U = insert (varAP x) (insert (varAP y) U)", assumption)
  apply fast
  apply fast
apply clarsimp
apply (erule_tac x=q in allE, erule_tac x=F in allE,erule_tac x=RR2 in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
  apply (rule_tac x=n2 in exI)
  apply (rule_tac x=LL2 in exI, safe)
  apply (erule YpsPreserved, simp)
  apply fast
  apply fast
  apply simp
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply(erule modif_monotone, fast) 
apply fast 
apply fast
done


lemma modif_h_h1:
"\<lbrakk>modif A h h1; B \<subseteq> A; modif (B \<union> C) h1 hh; Dom h1 = Dom h\<rbrakk>
  \<Longrightarrow> modif (A \<union> C) h hh"
apply (simp add: modif_def sameOH_def)
apply clarsimp
apply (erule_tac x=l in allE)
apply (erule impE, clarsimp)
apply (erule_tac x=l in allE)
apply (erule impE, clarsimp, fast)
apply clarsimp
done

lemma mod_Letv:
"\<lbrakk>modif (F \<union> RR1) h h1; Rv \<union> FF \<subseteq> RR1 \<union> F;
   modif (FF \<union> RR2) h1 hh; Dom h1 = Dom h\<rbrakk>
\<Longrightarrow> modif (F \<union> (RR1 \<union> RR2)) h hh"
apply (drule modif_h_h1) prefer 2 apply assumption apply fast apply assumption 
apply (erule modif_monotone) apply clarsimp
done

lemma Subseteq_LETV: "\<lbrakk>A \<subseteq> B \<union> C; D \<union> C \<subseteq> E \<union> F\<rbrakk> \<Longrightarrow> A \<subseteq> E \<union> B \<union> F" 
by fast

lemma LETV:
      "\<lbrakk>G \<rhd> e : \<lbrace>U1, n, C \<ggreater> T, m\<rbrace>; G \<rhd> ee : \<lbrace>U2, m, C \<ggreater> T2, k\<rbrace>;
        U1 \<inter> U2 = {}\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): \<lbrace>U1 \<union> U2, n, C \<ggreater> T2, k\<rbrace>"
apply (rule vdm_conseq,erule vdm_letv, assumption)
apply (erule thin_rl, erule thin_rl,simp add: DAss_def, safe)
apply (drule Yps_SPLIT, simp, assumption, clarsimp) 
apply (rotate_tac 2)
apply (erule_tac x="n2+q" in allE, erule_tac x=F in allE, erule_tac x=RR1 in allE, erule impE, clarsimp)
  apply (rule_tac x=N in exI, safe)
  apply (rule_tac x=n1 in exI, clarsimp)
  apply (rule_tac x=LL1 in exI, clarsimp) apply fast  
apply (erule_tac x="S+q" in allE, erule_tac x=FF in allE,erule_tac x=RR2 in allE, erule impE, clarsimp)
  apply (rule_tac x=M in exI, safe)
  apply (rule_tac x=n2 in exI)
  apply (rule_tac x=LL2 in exI, safe)
  prefer 2 apply fast
  prefer 2 apply fast 
  prefer 2 apply clarsimp
  apply (erule YpsPreserved_h_h1)
  prefer 2 apply assumption apply fast apply simp
apply (rule_tac x=Rva in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, clarsimp)
  apply (rule, erule mod_Letv, assumption+, simp)
apply (erule Subseteq_LETV, assumption)
done

lemma LETI:
      "\<lbrakk>G \<rhd> e : \<lbrace>U1, n, C \<ggreater> intET, m\<rbrace>; G \<rhd> ee : \<lbrace>U2, m, C \<ggreater> T2, k\<rbrace>;
        U1 \<inter> U2 = {}\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET x = e IN ee END): \<lbrace>U1 \<union> U2, n, C \<ggreater> T2, k\<rbrace>"
apply (rule vdm_conseq,erule vdm_leti, assumption)
apply (erule thin_rl, erule thin_rl,simp add: DAss_def, safe)
apply (drule Yps_SPLIT, simp, assumption, clarsimp)
apply (erule_tac x="n2+q" in allE, erule_tac x=F in allE, erule_tac x=RR1 in allE)
  apply (erule impE) 
  apply (rule_tac x=N in exI, safe)
  apply (rule_tac x=n1 in exI, rule_tac x=LL1 in exI, clarsimp) apply fast  
apply (erule_tac x="S+q" in allE, erule_tac x=FF in allE,erule_tac x=RR2 in allE, erule impE, clarsimp)
  apply (rule_tac x=M in exI, safe)
  apply (rule_tac x=n2 in exI, rule_tac x=LL2 in exI, clarsimp, rule)
  apply (rule YpsPreserved)
  apply (erule YpsPreserved_h_h1) prefer 2 apply assumption apply fast apply simp
  apply simp
apply fast 
apply (rule_tac x=Rva in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, clarsimp)
  apply (rule, erule mod_Letv, assumption+, simp)
  apply (erule Subseteq_LETV, assumption)
done

lemma setTriv: "\<lbrakk>RR2 \<inter> FF = {} \<and> Rv \<inter> FF = {} \<and> LL2 \<inter> FF = {}\<rbrakk>
       \<Longrightarrow> (RR2 \<union> Rv \<union> LL2) \<inter> FF = {}"
by fast

lemma LETR:
     "\<lbrakk> G \<rhd> e : \<lbrace>U1, n, C \<ggreater> T1, m\<rbrace>;
        G \<rhd> ee : \<lbrace>U2, m, C(x\<mapsto>\<^sub>fT1) \<ggreater> T2, k\<rbrace>;
        U1 \<inter> (U2-{varAP x}) = {}; T1 \<noteq> intET; \<forall> p. p : U2-{varAP x} \<longrightarrow> root p \<noteq> x\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = e IN ee END): \<lbrace>U1 \<union> (U2-{varAP x}), n, C \<ggreater> T2, k\<rbrace>"
apply (rule vdm_conseq,erule vdm_letr, assumption)
apply (erule thin_rl, erule thin_rl,simp add: DAss_def, safe)
apply (drule Yps_SPLIT, simp, assumption, clarsimp) 
apply (erule_tac x="n2+q" in allE, erule_tac x=F in allE, erule_tac x=RR1 in allE)
  apply(erule impE) 
  apply (rule_tac x=N in exI, safe)
  apply (rule_tac x=n1 in exI, rule_tac x=LL1 in exI, clarsimp) apply fast
apply (frule modelsET_isLocn, clarsimp)
apply (frule modelsETLocn, simp)
apply (frule modelsET_region_in_heap)
apply (rotate_tac 8) apply (drule  YpsPreservedU) 
  apply (subgoal_tac "evalAP xa E h = evalAP xa E\<lfloor>x:=Ref l\<rfloor> h", assumption) 
    apply (rule evalAP_root) apply simp apply (erule_tac x=xa in allE, erule impE) apply fastsimp apply simp
  apply (subgoal_tac "(C(x\<mapsto>\<^sub>fT1),xa, E\<lfloor>x:=Ref l\<rfloor>, h, T) \<in> lookupAP")
  prefer 2 apply (rule lookupAP_Update2) 
             apply (erule lookupAP_PreservedE) apply (erule_tac x=xa in allE, erule impE) apply fastsimp apply simp
            apply (erule_tac x=xa in allE, clarsimp)
     apply assumption
apply (rotate_tac -1) apply (drule  YpsPreserved_h_h1) prefer 2 apply assumption apply (rotate_tac -5, erule thin_rl) apply fast
  apply simp
apply (case_tac "varAP x : U2")
(*varAP x : U2*)
  apply (erule_tac x=q in allE, erule_tac x=FF in allE,erule_tac x="Rv\<union>RR2" in allE)
  apply (erule impE)
  apply (rule_tac x=M in exI, safe)
  apply (rule_tac x="S+n2" in exI, rule_tac x="insert l LL2" in exI, simp)
  apply rule
    apply (rule Yps_CONS, assumption)
      apply (rule lookupAP_Var) apply(simp add: GETr_def, simp) apply (erule modelsET_OH)
      apply clarsimp apply (rule, rule, rule) apply fastsimp apply simp apply fast
      apply assumption
      apply assumption
      apply fast
      apply fast
      apply fast
      apply simp
      apply simp
      apply simp
      apply (rule, fast)
      apply (rotate_tac 3)
      apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (rotate_tac 2)
      apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl)
      apply (rotate_tac 1)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) apply fast
  apply (rule_tac x=Rva in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, clarsimp)
  apply rule
   apply (rule modif_monotone)
     apply (erule modif_h_h1) prefer 2 apply assumption 
      apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) apply (rotate_tac 1) 
      apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) 
      apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) 
      apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) apply fast apply simp
    apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) apply (rotate_tac 2) 
      apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) 
      apply (erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) 
      apply (erule thin_rl, erule thin_rl, erule thin_rl) apply fast 
     apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) apply (rotate_tac 2) 
      apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) 
      apply (erule thin_rl, erule thin_rl) 
      apply (erule thin_rl, erule thin_rl, erule thin_rl) apply fast
(*varAP x \<notin> U2*)
  apply (erule_tac x="S+q" in allE, erule_tac x=FF in allE,erule_tac x="RR2" in allE)
  apply (erule impE)
  apply (rule_tac x=M in exI, safe)
  apply (rule_tac x="n2" in exI, rule_tac x="LL2" in exI, simp)
  apply fast
  apply (rule_tac x=Rva in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, clarsimp)
  apply rule
   apply (rule modif_monotone)
     apply (erule modif_h_h1) prefer 2 apply assumption 
      apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) apply (rotate_tac 1) 
      apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) 
      apply (erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) 
      apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) apply fast apply simp
    apply ((erule thin_rl)+, fast)
    apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) apply (rotate_tac 2) 
      apply (erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule thin_rl, erule thin_rl, erule thin_rl) 
      apply (erule thin_rl, erule thin_rl) 
      apply (erule thin_rl, erule thin_rl, erule thin_rl) apply fast
done

lemma IF: 
     "\<lbrakk>G \<rhd> e1 : \<lbrace>U1, n, C \<ggreater> T, m\<rbrace>; G \<rhd> e2 : \<lbrace>U2, n, C \<ggreater> T, m\<rbrace>\<rbrakk>
     \<Longrightarrow> G \<rhd> (IF b THEN e1 ELSE e2): \<lbrace>U1 \<union> U2, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, erule vdm_if, assumption, erule thin_rl, erule thin_rl, clarsimp)
apply (rule DAssC_PConst, erule disjE)
apply clarsimp 
apply (erule DAss_monotone_in_U,fast)
apply clarsimp 
apply (erule DAss_monotone_in_U,fast)
done

lemma CALL:
"\<lbrakk>(G \<union> {(CALL f, \<lambda> E h hh v p . \<exists> pp. tkcall pp = p \<and> \<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v pp)}) \<rhd> 
   snd(funtable f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow>
 G \<rhd> (CALL f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, erule Call1)
apply clarsimp
apply (erule DAssC_PConst) 
done
lemma DA_C_Invs:
"\<lbrakk>({(c\<bullet>mn(args), \<lbrace>U, n, C \<ggreater> T, m\<rbrace>)} \<union> G) \<rhd> (snd (methtable c mn)) :  
    (\<lambda> E h hh v p  . \<forall> E'. E = newframe_env Nullref (fst (methtable c mn)) args E'  \<longrightarrow> 
                     (\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E' h hh v (\<langle>3 0 1 1\<rangle> \<oplus> p) )) \<rbrakk> \<Longrightarrow>
   G \<rhd> (c\<bullet>mn(args)) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>" 
by (rule vdm_conseq, erule vdm_invokestatic, clarsimp)

lemma muRVar_aux1[rule_format]:
"\<forall> T . fmap_lookup (oheap h) a = Some DIAM \<longrightarrow> GETr C l = Some (nodeET (k, recET T, h<a\<bullet>DOLLAR>)) \<longrightarrow>
       (\<forall> F TTT. (ifldn F, TTT) : set TT \<longrightarrow> TTT = intET) \<longrightarrow> distinct (map fst T) \<longrightarrow>
          (\<exists> X . T = X @ TT) \<longrightarrow> get_rfldAPs TT l = [] \<longrightarrow> renv E l = Ref a \<longrightarrow>
       (RVal (Ref a), h, recET TT, {a}, 0) \<in> modelsET"
apply (induct_tac TT)
apply clarsimp 
  apply (erule modelsETRecN, simp)
apply clarsimp 
  apply (case_tac "aa", clarsimp) prefer 2 apply clarsimp
  apply (erule modelsETRecC)
   apply fastsimp
   apply simp
   apply simp apply (subgoal_tac "b=intET", clarsimp) apply (rule modelsETInt) apply fast 
   apply assumption
   apply simp apply simp apply simp apply simp
done

lemma distinct_lookup: "\<lbrakk>distinct (map fst L); (rfldn F, T) \<in> set L\<rbrakk> \<Longrightarrow> Some T = lookup L (rfldn F)"
by (induct L, auto, drule fst_set_list, assumption, simp)

lemma get_rfld_notin2[rule_format]:
"\<forall> l F . rfldAP (nodeAP l) F \<notin> set (get_rfldAPs L l) \<longrightarrow> rfldn F \<notin> fst ` set L"
apply (induct_tac L)
apply clarsimp
apply clarsimp
apply (case_tac a, clarsimp, clarsimp)
apply (erule_tac x=l in allE, erule_tac x=F in allE, clarsimp)  apply (erule fst_set_list, assumption)
done

lemma mYps_Node_modelsET_REC_aux[rule_format]:
"\<forall> E h U ND L R C LL RR P S T l k i Q . (E, h, U, ND, Flds, L, R, C, LL, RR, P) \<in> mYps \<longrightarrow> U = {} \<longrightarrow>
       ND = Some (nodeAP l) \<longrightarrow>
       GETr C l = Some(nodeET(k,recET T,i)) \<longrightarrow> distinct Flds \<longrightarrow>
       (\<exists> X . get_rfldAPs T l = X @ Flds) \<longrightarrow> Q = P-k \<longrightarrow>
       (\<forall> a . E\<lfloor>l\<rfloor> = Ref a \<longrightarrow> h@@a = Some DIAM \<longrightarrow> get_rfldAPs S l = Flds \<longrightarrow> 
              (\<forall> F TT . (F,TT) : set S \<longrightarrow> (\<exists> FF . F = rfldn FF \<and> Some TT = lookup T F)) \<longrightarrow>
        (RVal (Ref a), h, recET S, L \<union> R, Q) \<in> modelsET)"
apply (induct_tac Flds)
apply clarsimp
  apply (erule mYps.elims, simp_all)
  apply clarsimp 
  apply (drule Yps_empty, simp, clarsimp)
  apply (case_tac "a : Dom ha", clarsimp) prefer 2 apply clarsimp
  apply (case_tac S)
    apply clarsimp apply (rule modelsETRecN) apply (assumption, simp)
    apply clarsimp apply (erule_tac x=a in allE, erule_tac x=b in allE, clarsimp) 
apply clarsimp
  apply (erule mYps.elims, simp_all, clarsimp)
  apply (case_tac "aa : Dom ha", clarsimp) prefer 2 apply clarsimp 
  apply (case_tac "locns ha\<lfloor>aa\<diamondsuit>F\<rfloor> \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp 
  apply (case_tac S)
  apply clarsimp
  apply clarsimp
  apply (subgoal_tac "\<exists>FF. a = rfldn FF \<and> Some b = lookup T a", clarsimp)
  prefer 2 apply (erule_tac x=a in allE, erule_tac x=b in allE, clarsimp) 
  apply (drule lookupAP_Node_GETr, assumption+, clarsimp)
  apply (frule mYps_NodelocReg, simp, clarsimp) 
    apply (rule modelsETRecC)
      apply assumption
      apply fastsimp
      apply simp  apply (erule get_rfld_notin2)
      apply simp 
      apply (erule_tac x=Ea in allE, erule_tac x=ha in allE, erule_tac x="Some(nodeAP l)" in allE)
        apply (erule_tac x="{aa}" in allE, erule_tac x=RRa in allE, erule_tac x="Ca" in allE)
        apply (erule_tac x=La in allE, erule_tac x=Ra in allE, erule_tac x="N" in allE, clarsimp)
        apply (erule_tac x=list in allE, clarsimp, assumption)
      apply (erule thin_rl, fast)
      apply (erule thin_rl, fast)
      apply (erule thin_rl, fast)
      apply (erule thin_rl, drule mYps_NodelocSize, simp, assumption) apply arith
done

lemma get_rfldAPs_filter:"get_rfldAPs [(F, TT)\<in>T . \<exists>FF. F = rfldn FF] l = get_rfldAPs T l"
by (induct_tac T, auto, case_tac a, auto)
lemma lookup_filter: "lookup T (rfldn G) = lookup [(F, TT)\<in>T . \<exists>FF. F = rfldn FF] (rfldn G)"
by (induct_tac T, auto)

lemma distinct_map_distinct_get_rflds[rule_format]:
"\<forall> l . distinct (map fst T) \<longrightarrow> distinct (get_rfldAPs T l)"
apply (induct_tac T)
apply clarsimp+
apply (case_tac "a", clarsimp+)  apply (drule get_rfld_notin) apply fast
done

lemma mYps_Node_modelsET_REC[rule_format]:
"\<lbrakk>(E, h, {}, Some (nodeAP l), get_rfldAPs T l, L, R, C, LL, RR, P) \<in> mYps;
       GETr C l = Some(nodeET(k,recET T,i));
       Ref a = E\<lfloor>l\<rfloor>; h@@a = Some DIAM;
         distinct (map fst T) ;
         (\<forall> F TT.  (F,TT) : set T \<longrightarrow> ((\<forall> FF . F=ifldn FF \<longrightarrow> TT = intET) \<and> (\<forall> FF . F = rfldn FF \<longrightarrow> Some TT = lookup T F)))\<rbrakk>
 \<Longrightarrow> (RVal (Ref a), h, recET T, L \<union> R, P-k) \<in> modelsET"
apply (rule modelsET_REC_modelsET_REC1)
apply (rule mYps_Node_modelsET_REC_aux, assumption+)
apply (simp, simp) apply assumption apply (erule distinct_map_distinct_get_rflds) 
apply fast apply (simp, simp) apply assumption
apply (subgoal_tac "get_rfldAPs (List.filter (\<lambda> (F,TT::Tp) . \<exists> FF . F = rfldn FF) T) l = get_rfldAPs T l", assumption)
apply (rule get_rfldAPs_filter)
apply (case_tac "F", clarsimp, clarsimp)
apply simp
apply (rule get_rfldAPs_filter)
apply (case_tac "F", clarsimp, clarsimp)
apply assumption
apply (case_tac "F", clarsimp, clarsimp)
apply (rule lookup_filter)
done

lemma muRVAR_L:
"\<lbrakk>GETr C l = Some(nodeET(kL, recET L,i));
  APs = get_rfldAPs L l; distinct (map fst L);
  T = muET S;
  subst S (muET S) (sumET (kL,recET L,i) (kR,recET R,j));i\<noteq>j; 
  (\<forall> F TTT. (ifldn F, TTT) : set L \<longrightarrow> TTT = intET)\<rbrakk>
\<Longrightarrow> G \<rhd> RVar l : \<parallel>{}, Some (nodeAP l), APs, n, C \<ggreater> T, n\<parallel>"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: muDAss_def, clarsimp)
apply (frule mYps_NodelocReg, simp, clarsimp)
apply (frule mYps_NodelocDom, simp, assumption, clarsimp)
apply (frule mYps_GETr_DOLLAR, assumption+, simp)
apply (frule mYps_NodelocSize, simp, assumption)
apply (drule mYps_Node_modelsET_REC)
  apply assumption
  apply (subgoal_tac "Ref a = renv E l", assumption, simp)
  apply assumption
  apply assumption
  apply rule apply fast apply clarsimp 
  apply (erule distinct_lookup, assumption) 
apply clarsimp
apply (rule_tac x="insert a rg" in exI, rule_tac x="P" in exI, rule_tac x=N in exI, rule_tac x=F in exI, simp)
apply rule
  apply (rule modelsETMu)
    apply assumption
    apply assumption
    apply (rule modelsETSum)
      apply assumption
      apply simp
      apply assumption
      apply clarsimp apply rule apply assumption apply simp 
      apply clarsimp 
      apply fast 
done

lemma muRVAR_R:
"\<lbrakk>GETr C l = Some(nodeET(kR, recET R,j));
  APs = get_rfldAPs R l; distinct (map fst R);
  T = muET S; 
  subst S (muET S) (sumET (kL,recET L,i) (kR,recET R,j));
  i\<noteq>j;
  (\<forall> F TTT. (ifldn F, TTT) : set R \<longrightarrow> TTT = intET)\<rbrakk>
\<Longrightarrow> G \<rhd> RVar l : \<parallel>{}, Some (nodeAP l), APs, n, C \<ggreater> T, n\<parallel>"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: muDAss_def, clarsimp)
apply (frule mYps_NodelocReg, simp, clarsimp)
apply (frule mYps_NodelocDom, simp, assumption, clarsimp)
apply (frule mYps_GETr_DOLLAR, assumption+, simp)
apply (frule mYps_NodelocSize, simp, assumption)
apply (drule mYps_Node_modelsET_REC)
  apply assumption
  apply (subgoal_tac "Ref a = renv E l", assumption, simp)
  apply assumption
  apply assumption
  apply rule apply fast apply clarsimp 
  apply (erule distinct_lookup, assumption) 
apply clarsimp
apply (rule_tac x="insert a rg" in exI, rule_tac x="P" in exI, rule_tac x=N in exI, rule_tac x=F in exI, simp)
apply rule
  apply (rule modelsETMu)
    apply assumption
    apply assumption
    apply (rule modelsETSum)
      apply assumption
      apply simp
      apply assumption
      apply clarsimp 
      apply clarsimp apply rule apply assumption apply simp 
      apply fast 
done

lemma FILL:
"\<lbrakk>GETr C l = Some(nodeET(k, recET TT,j));
  G \<rhd> e : \<parallel>U, Some (nodeAP l), [],n, C(l\<mapsto>\<^sub>f(nodeET(k, recET TT,i))) \<ggreater> T, n\<parallel>; 
  l \<notin> roots U;
  (\<forall> p . p:U \<longrightarrow> (\<exists> x . p = varAP x))
 \<rbrakk> \<Longrightarrow> G \<rhd> (LET _ = l\<bullet>DOLLAR := tg IN e END) : 
            (\<lambda> E h hh v p . E<tg>=i \<longrightarrow> \<lbrace>insert (varAP l) U, n, C \<ggreater> T, n\<rbrace> E h hh v p)"
apply (rule vdm_conseq, rule vdm_letv, rule vdm_putfi)
apply assumption
apply (simp add:muDAss_def DAss_def, clarsimp)
apply (drule Yps_SPLIT)
  apply (subgoal_tac "{varAP l} \<union> U = insert (varAP l) U", assumption, fast)
  apply (case_tac "varAP l : U") apply (simp add: roots_def) apply fastsimp apply fast
apply clarsimp
apply (erule Yps.elims, simp+, clarsimp)
apply (case_tac "a : Dom ha", clarsimp) prefer 2 apply clarsimp
apply (rotate_tac -9)
apply (drule Yps_empty, simp, clarsimp)
apply (subgoal_tac "la : RR1a") prefer 2 apply(erule modelsETLocn, simp)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=RR2 in allE, erule_tac x=RR1a in allE, erule impE)
prefer 2 apply (subgoal_tac "F \<union> RR2 \<union> RR1a = F \<union> (RR1a \<union> RR2)", clarsimp)
  apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, simp)
    apply (simp add: modif_def sameOH_def, clarsimp) 
    apply (subgoal_tac "la \<noteq> laa") apply (erule_tac x=laa in allE, clarsimp) apply (erule_tac x=ifield in allE)
      apply (case_tac "ifield=DOLLAR", clarsimp, clarsimp) 
  apply fast
  apply fast
apply (rule_tac x=N in exI, simp, rule)
apply (simp add: freelist_def) apply (erule FL_Preserved, simp add: sameOH_def)
apply (rule_tac x="N1+n2" in exI, rule_tac x=LL2 in exI, rule_tac x="{la}" in exI, simp, rule)
prefer 2 apply fast
apply (erule lookupAP.elims, simp_all, clarsimp)
apply (erule modelsET.elims, simp_all, clarsimp)
apply (rule mYps_SOME)
      apply (rule YpsPreservedU)
        apply (erule YpsPreserved_h_h1)
          prefer 2 apply (subgoal_tac "modif (insert la F) ha (ha\<lparr>iheap := (iheap ha)(DOLLAR := (iheap ha DOLLAR)(la := ienv E tg))\<rparr>)", assumption)
          apply (simp add: modif_def sameOH_def)
          apply fast
          apply simp
       apply simp
       apply (erule lookupAP.elims, simp_all, clarsimp) 
         apply (rule lookupAP_Var) apply (erule GETr_Update2)
           apply (simp add: roots_def) apply fastsimp
       apply simp
       apply simp
       apply (erule_tac x="nodeAP xa" in allE, clarsimp) 
       apply (erule_tac x="rfldAP p Fa" in allE, clarsimp) 
       apply (erule_tac x="rfldAP p Fa" in allE, clarsimp) 
       apply (erule_tac x="rfldAP p Fa" in allE, clarsimp) 
       apply (erule_tac x="rfldAP p Fa" in allE, clarsimp) 
apply (simp add: GETr_def)
done

lemma mkFLDlist_notin[rule_format]:
"\<forall> FLD l . rfldn FLD \<notin> set (mkFLD_list APs) \<longrightarrow> rfldAP (nodeAP l) FLD \<notin> set APs"
by (induct_tac APs, clarsimp+, case_tac "a", clarsimp+)

lemma mYps_GETr_DOLLAR2:
"\<lbrakk>(E, h, U, Some (nodeAP l), APs, {a}, rg, C, L, R, P) \<in> mYps;
  E\<lfloor>l\<rfloor> = Ref a; GETr C l = Some (nodeET (k, recET T, i)); APs @ X = get_rfldAPs T l\<rbrakk>
\<Longrightarrow> h<a\<bullet>DOLLAR>=i"
apply (erule mYps.elims, simp_all, clarsimp)
apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
apply (case_tac "locns (h\<lfloor>a\<diamondsuit>F\<rfloor>) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (drule lookupAP_Node_GETr, assumption+) apply clarsimp 
done


lemma rfldAP_F_rfldAP_G[rule_format]:
"F \<noteq> G \<longrightarrow> rfldAP (nodeAP l) F \<notin> set L \<longrightarrow>
          rfldAP (nodeAP l) G \<notin> set L  \<longrightarrow> rfldAP (nodeAP l) G \<notin> set (L @ [rfldAP (nodeAP l) F])"
by (induct_tac L, clarsimp+)


lemma mYps_HD_END_aux[rule_format]:
"\<forall> l FLD APs a RR E h C L R N U. 
 (E, h, U, Some (nodeAP l), (rfldAP (nodeAP l) FLD) # APs, {a}, RR, C, L, R, N) \<in> mYps \<longrightarrow> length APs = n \<longrightarrow> 
 (E, h, U, Some (nodeAP l), APs @ [rfldAP (nodeAP l) FLD], {a} ,RR, C, L, R, N) \<in> mYps"
apply (induct_tac n)
apply clarsimp
apply clarsimp
  apply (erule mYps.elims, simp_all, clarsimp)
  apply (case_tac "locns (renv Ea l) \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
  apply (case_tac "renv Ea l", clarsimp+)
  apply (case_tac "locns ha\<lfloor>nat\<diamondsuit>F\<rfloor> \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
  apply (case_tac "Flds", clarsimp+)
  apply (erule mYps.elims, simp_all, clarsimp)
  apply (case_tac "locns h\<lfloor>nat\<diamondsuit>Fa\<rfloor> \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply(erule_tac x="l" in allE, erule_tac x=F in allE)
  apply(erule_tac x="Flds" in allE, erule_tac x=a in allE)
  apply(erule_tac x="RR \<union> RR1" in allE, erule_tac x="E" in allE)
  apply(erule_tac x="h" in allE, erule_tac x="C" in allE)
  apply(erule_tac x="L" in allE, erule_tac x="R" in allE)
  apply(erule_tac x="N+N1" in allE, erule_tac x="U" in allE, erule impE)
  apply (rule mYps_FLD) 
    apply assumption+
    apply simp apply (rule, simp, simp)
    apply assumption+
    apply fast
    apply simp
    apply simp
apply clarsimp
  apply (rule mYps_FLD)
   apply (erule rfldAP_F_rfldAP_G, assumption+)
   apply simp apply (rule, simp, simp)
   apply assumption+
   apply fast
   apply fast
   apply simp
done

lemma mYps_HD_END[rule_format]:
"(E, h, U, Some (nodeAP l), (rfldAP (nodeAP l) FLD) # APs, {a}, RR, C, L, R, N) \<in> mYps \<Longrightarrow>
 (E, h, U, Some (nodeAP l), APs @ [rfldAP (nodeAP l) FLD], {a} ,RR, C, L, R, N) \<in> mYps"
by (drule mYps_HD_END_aux, fast, assumption)

lemma LETPUTFR:
"\<lbrakk>GETr C l = Some(nodeET(k, recET TT,i));
  lookup TT (rfldn FLD) = Some S;
  APs @ X = get_rfldAPs TT l ;
  t \<noteq> l; rfldn FLD \<notin> set (mkFLD_list APs);
  GETr C t = Some S; distinct (map fst TT);
  G \<rhd> e : \<parallel>U, Some (nodeAP l),APs @ [rfldAP (nodeAP l) FLD], n, C \<ggreater> T, m\<parallel>; 
  \<forall> p. p:U \<longrightarrow> (\<exists> x . p=varAP x);
  t \<notin> roots U
  \<rbrakk>
\<Longrightarrow>  G \<rhd> (LET _ = l\<diamondsuit>FLD := t IN e END) : \<parallel>U \<union> {varAP t}, Some (nodeAP l), APs,n, C \<ggreater> T, m\<parallel>"
apply (rule vdm_conseq) apply (rule vdm_letv, rule vdm_putfr) 
apply assumption
apply (rotate_tac -3, erule thin_rl)
apply clarsimp 
apply (simp add: muDAss_def, clarsimp)
apply (frule mYps_NodelocReg, simp, clarsimp)
apply (frule mYps_NodelocDom, simp, simp, clarsimp)
apply (drule mYps_SPLIT)
apply (subgoal_tac "U \<union> {varAP t} = insert (varAP t) U", assumption, simp)
  apply (rotate_tac -9, erule thin_rl)
   apply (case_tac "varAP t : U") 
         apply (simp add: roots_def) apply(rotate_tac 9) apply(erule_tac x="varAP t" in allE, clarsimp)  apply fast
apply clarsimp
apply (subgoal_tac "(E, h\<lparr>rheap := (rheap h)(FLD := (rheap h FLD)(a := renv E t))\<rparr>,U,
                     Some (nodeAP l), APs, {a}, rg, C, LL1, RR1, n1) \<in> mYps")
  apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x="RR1" in allE, erule_tac x="rg\<union>RR2" in allE, erule impE)
  prefer 2 apply clarsimp
    apply (rule_tac x=Rv in exI)
    apply (rule_tac x=Sa in exI)
    apply (rule_tac x=M in exI)
    apply (rule_tac x=FF in exI, simp)
    apply rule prefer 2 apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                        apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
                        apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                        apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
                                             apply fast
    apply (simp add: modif_def sameOH_def, clarsimp)
    apply (subgoal_tac "la \<noteq> a")
    prefer 2 apply fast
    apply (erule_tac x=la in allE, clarsimp)
    apply (erule_tac x=rfield in allE)
    apply (case_tac "rfield = FLD", clarsimp, clarsimp)
  apply (rule_tac x=N in exI, simp, rule)
    apply (simp add: freelist_def)
    apply (erule FL_Preserved) apply (simp add: sameOH_def) 
  apply (rule_tac x="n1+n2" in exI)
  apply (rule_tac x=LL1 in exI)
  apply (rule_tac x="{a}" in exI, simp)
  apply rule prefer 2 apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                      apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                      apply (rotate_tac 5)
                      apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply fast
      apply (rotate_tac -5)
      apply (erule mYps.elims, simp_all, clarsimp)
      apply (rotate_tac -1)
      apply (erule Yps.elims, simp_all, clarsimp)
      apply (drule Yps_empty, simp, clarsimp)
      apply (case_tac "locns (renv E t) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
      apply (erule lookupAP.elims, simp_all, clarsimp)
apply (rule mYps_HD_END)
  apply (frule mYps_GETr_DOLLAR2) apply assumption apply assumption apply assumption
  apply (rule mYps_FLD)
    apply (erule mkFLDlist_notin)
    apply assumption
    apply simp apply (rule, simp, simp)
    apply (rule lookupAP_RfldNode)
      apply (erule lookupAP_Node) apply fast
      apply assumption
      apply simp
      apply simp
      apply simp apply (rule, simp, simp)
      apply simp
      apply assumption
      apply (erule modelsET_Preserved) apply (simp add: sameOH_def, clarsimp) apply (drule mYps_NodelocReg, simp) apply fastsimp
      apply fast
      apply simp
      apply simp

apply (erule mYps_PutFr) apply simp apply assumption+
done
(*an earlier rule for putfr:
lemma LETPUTFR:
"\<lbrakk>GETr C l = Some(nodeET(k, recET TT,i));
  lookup TT (rfldn FLD) = Some S;
  \<forall> p. p: set APs \<longrightarrow> (\<exists> F. p = rfldAP (nodeAP l) F);
  t \<noteq> l; 
  GETr C t = Some S; FLDS = (map fst TT); distinct FLDS; 
  FLDS = X @ (mkFLD_list ((rfldAP (nodeAP l) FLD) # APs));
  G \<rhd> e : \<parallel>U, Some (nodeAP l),(rfldAP (nodeAP l) FLD) # APs, n, C \<ggreater> T, m\<parallel>; 
  \<forall> p. p:U \<longrightarrow> (\<exists> x . p=varAP x);
  t \<notin> roots U
  \<rbrakk>
\<Longrightarrow>  G \<rhd> (LET _ = l\<diamondsuit>FLD := t IN e END) : \<parallel>U \<union> {varAP t}, Some (nodeAP l), APs,n, C \<ggreater> T, m\<parallel>"
apply (frule Distinct_Triv, assumption)
apply (rule vdm_conseq) 
apply (rule vdm_letv, rule vdm_putfr) 
apply assumption
apply (rotate_tac -4, erule thin_rl)
apply clarsimp 
apply (simp add: muDAss_def, clarsimp)
apply (frule mYps_NodelocReg, simp, clarsimp)
apply (frule mYps_NodelocDom, simp, simp)
apply (drule mYps_SPLIT)
apply (subgoal_tac "U \<union> {varAP t} = insert (varAP t) U", assumption, simp)
  apply (rotate_tac -8, erule thin_rl)
   apply (case_tac "varAP t : U") 
         apply (simp add: roots_def) apply(rotate_tac 8) apply(erule_tac x="varAP t" in allE, clarsimp)  apply fast
apply clarsimp
apply (subgoal_tac "(E, h\<lparr>rheap := (rheap h)(FLD := (rheap h FLD)(a := renv E t))\<rparr>,U,
                     Some (nodeAP l), APs, {a}, rg, C, LL1, RR1, n1) \<in> mYps")
  apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x="RR1" in allE, erule_tac x="rg\<union>RR2" in allE, erule impE)
  prefer 2 apply clarsimp
    apply (rule_tac x=Rv in exI)
    apply (rule_tac x=Sa in exI)
    apply (rule_tac x=M in exI)
    apply (rule_tac x=FF in exI, simp)
    apply rule prefer 2 apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                        apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
                        apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                        apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
                                             apply fast
    apply (simp add: modif_def sameOH_def, clarsimp)
    apply (subgoal_tac "la \<noteq> a")
    prefer 2 apply fast
    apply (erule_tac x=la in allE, clarsimp)
    apply (erule_tac x=rfield in allE)
    apply (case_tac "rfield = FLD", clarsimp, clarsimp)
  apply (rule_tac x=N in exI, simp, rule)
    apply (simp add: freelist_def)
    apply (erule FL_Preserved) apply (simp add: sameOH_def) 
  apply (rule_tac x="n1+n2" in exI)
  apply (rule_tac x=LL1 in exI)
  apply (rule_tac x="{a}" in exI, simp)
  apply rule prefer 2 apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                      apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                      apply (rotate_tac 5)
                      apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply fast
      apply (rotate_tac -5)
      apply (erule mYps.elims, simp_all, clarsimp)
      apply (rotate_tac -1)
      apply (erule Yps.elims, simp_all, clarsimp)
      apply (erule Yps.elims, simp_all, clarsimp)
      apply (case_tac "locns (renv Ea t) \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
      apply (erule lookupAP.elims, simp_all, clarsimp)
      apply (rule mYps_FLD)
        apply (erule mkFLDlist_notin)
        apply assumption
        apply simp apply (rule, fast, simp)
        apply (rule lookupAP_RfldNode)
          apply (rule lookupAP_Node) apply assumption
          apply simp apply (rule, simp) apply (rule, simp, simp)
          apply simp
          apply simp
          apply simp apply (erule mYps_Some_Dollar) apply fast apply assumption apply assumption
          apply simp apply (rule, simp, simp)
          apply simp
          apply assumption
          apply (erule modelsET_Preserved) apply (simp add: sameOH_def) apply fast
          apply fast 
          apply simp
          apply simp 
apply (erule mYps_PutFr) apply simp apply assumption+
done 
*)

text{*Example for fill: the cons-case for lists*}
lemma muRVAR_LIST:
"\<lbrakk>GETr C l = Some(nodeET(kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)],1))\<rbrakk>
\<Longrightarrow> G \<rhd> RVar l : \<parallel>{}, Some (nodeAP l), [rfldAP (nodeAP l) TL], n, C \<ggreater> iList HD TL kN kC, n\<parallel>"
apply (erule muRVAR_R)
  apply simp
  apply simp
  apply (simp add: iList_def)
  apply (simp add: iList_def, (rule substitution_listsubstitution.intros)+ )
  apply simp
  apply simp
done

lemma FILL_LIST_TL:
"\<lbrakk>GETr C l = Some(nodeET(kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)],1));
  GETr C t = Some(iList HD TL kN kC); t \<noteq> l\<rbrakk>
\<Longrightarrow> G \<rhd> (LET  _ = l\<diamondsuit>TL := t IN RVar l END) : \<parallel>{varAP t}, Some (nodeAP l), [],n, C \<ggreater> iList HD TL kN kC, n\<parallel>"
apply (rule LETPUTFR[simplified])
  apply assumption
  apply simp
  apply simp
  apply assumption
  apply simp
  apply assumption
  apply simp
  apply simp apply (erule muRVAR_LIST) 
  apply simp
  apply (simp add: roots_def)
done
lemma FILL_LIST_HDTL:
"\<lbrakk>GETr C l = Some(nodeET(kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)],1));
  GETr C t = Some(iList HD TL kN kC); t \<noteq> l; DOLLAR \<noteq> HD\<rbrakk>
\<Longrightarrow> G \<rhd> (LET  _ = l\<bullet>HD := x; _ = l\<diamondsuit>TL := t IN RVar l END) : \<parallel>{varAP t}, Some (nodeAP l), [],n, C \<ggreater> iList HD TL kN kC, n\<parallel>"
apply (rule LETPUTFI[simplified])
  apply (erule FILL_LIST_TL)
    apply assumption
    apply assumption
  apply assumption
  apply assumption
  apply simp
done

lemma FILL_LIST:
"\<lbrakk>GETr C l = Some(nodeET(kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)],j)); 
  GETr C t = Some(iList HD TL kN kC); t \<noteq> l; DOLLAR \<noteq> HD\<rbrakk>
\<Longrightarrow> G \<rhd> (LET  _ = l\<bullet>DOLLAR := tg;_ = l\<bullet>HD := x; _ = l\<diamondsuit>TL := t IN RVar l END) : 
     (\<lambda> E h hh v p . E<tg>=1 \<longrightarrow> \<lbrace>{varAP l, varAP t}, n, C \<ggreater> iList HD TL kN kC, n\<rbrace> E h hh v p)"
apply (rule FILL)
  apply assumption
  apply (rule FILL_LIST_HDTL) 
    apply (simp add: GETr_def)
    apply (erule GETr_Update2, fast)
    apply assumption
    apply assumption
  apply (simp add: roots_def, fast) 
  apply simp
done

text {*Two more examples for fill: nodes and leafs of trees*}
lemma muRVAR_TREE:
"\<lbrakk>GETr C l = Some(nodeET(kC, recET [(rfldn L,iTree I L R kN kC), (rfldn R,iTree I L R kN kC)],1));
  L \<noteq> R\<rbrakk>
\<Longrightarrow> G \<rhd> RVar l : \<parallel>{}, Some (nodeAP l), [rfldAP (nodeAP l) L, rfldAP (nodeAP l) R], n, C \<ggreater> iTree I L R kN kC, n\<parallel>"
apply (rule muRVAR_R)
  apply assumption
  apply simp
  apply clarsimp
  apply (simp add: iTree_def)
  apply (simp add: iTree_def, (rule substitution_listsubstitution.intros)+ )
  apply simp
  apply simp
done

lemma FILL_TREE_NODE:
"\<lbrakk>GETr C t = Some(nodeET(kC, recET [(rfldn L,iTree I L R kN kC), (rfldn R,iTree I L R kN kC)],j));
  GETr C l = Some(iTree I L R kN kC); L \<noteq> R; t\<noteq>l;
  GETr C r = Some(iTree I L R kN kC); t\<noteq>r; l\<noteq>r\<rbrakk>
\<Longrightarrow> G \<rhd> (LET  _ = t\<bullet>DOLLAR := tg; _ = t\<diamondsuit>L := l; _ = t\<diamondsuit>R := r IN RVar t END) : 
     (\<lambda> E h hh v p . E<tg>=1 \<longrightarrow> \<lbrace>{varAP t, varAP l, varAP r}, n, C \<ggreater> iTree I L R kN kC, n\<rbrace> E h hh v p)"
apply (rule FILL)
  apply assumption
  apply (rule LETPUTFR[simplified])
    apply (simp add: GETr_def) apply fastsimp
    apply simp
    apply simp
    apply fast
    apply simp
    apply (erule GETr_Update2, assumption)
    apply simp
    apply simp apply (rule LETPUTFR[simplified])
                 apply (simp add: GETr_def) apply fastsimp
                 apply simp
                 apply simp
                 apply fast
                 apply simp apply fast
                 apply (erule GETr_Update2, assumption)
                 apply simp
                 apply simp apply (rule muRVAR_R)
                              apply (simp add: GETr_def)
                              apply fastsimp
                              apply simp
                              apply simp
                              apply (simp add: iTree_def)
                              apply (simp add: iTree_def, (rule substitution_listsubstitution.intros)+)
                              apply simp
                              apply simp
                 apply simp
                 apply (simp add: roots_def)
    apply simp
    apply (simp add: roots_def)
  apply (simp add: roots_def) apply fastsimp
  apply simp
done

lemma FILL_TREE_LEAF:
"\<lbrakk>GETr C t = Some(nodeET(kL, recET [(ifldn I,intET)],j)); DOLLAR \<noteq> I\<rbrakk>
\<Longrightarrow> G \<rhd> (LET  _ = t\<bullet>DOLLAR := tg; _ = t\<bullet>I := x IN RVar t END) : 
     (\<lambda> E h hh v p . E<tg>=0 \<longrightarrow> \<lbrace>{varAP t}, n, C \<ggreater> iTree I L R kL kN, n\<rbrace> E h hh v p)"
apply (rule FILL)
  apply assumption
  apply (rule LETPUTFI)
    apply (rule muRVAR_L)
      apply (simp add: GETr_def) apply fastsimp
      apply simp
      apply simp
      apply (simp add: iTree_def)
      apply (rule substitution_listsubstitution.intros)+  
      apply simp
      apply simp
    apply (simp add: GETr_def, fastsimp)
    apply simp
    apply simp
  apply (simp add: roots_def)
  apply fast
done

subsubsection{*Renaming*}
constdefs RenameCond1::"(AP set) \<Rightarrow> (AP \<leadsto>\<^sub>f AP) \<Rightarrow> (AP set) \<Rightarrow> bool"
"RenameCond1 U f UU == (\<forall> x . x:U \<longrightarrow> (\<exists> y. fmap_lookup f x = Some y \<and> y:UU))"

constdefs RenameCond2::"(AP set) \<Rightarrow> (AP \<leadsto>\<^sub>f AP) \<Rightarrow> (AP set) \<Rightarrow> bool"
"RenameCond2 U f UU == (\<forall> y . y:UU \<longrightarrow> (\<exists> x. fmap_lookup f x = Some y \<and> x:U))"

constdefs RenameCond3::"(AP set) \<Rightarrow> (AP \<leadsto>\<^sub>f AP) \<Rightarrow> (AP set) \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> Context \<Rightarrow> Context \<Rightarrow> bool"
"RenameCond3 U f UU E h EE G GG == (\<forall> x y . (x:U \<and> fmap_lookup f x = Some y) \<longrightarrow> (y : UU \<and> evalAP x E h = evalAP y EE h \<and> (\<forall> T . ((G,x,E,h,T):lookupAP) = ((GG,y,EE,h,T):lookupAP))))"

constdefs RenameCond4::"(AP set) \<Rightarrow> (AP \<leadsto>\<^sub>f AP) \<Rightarrow> (AP set) \<Rightarrow> bool"
"RenameCond4 U f UU == (\<forall> x1 x2 y1 y2 . (x1:U \<and> x2:U \<and> x1\<noteq>x2 \<and> fmap_lookup f x1 = y1 \<and> fmap_lookup f x2 = y2) \<longrightarrow> y1 \<noteq> y2)"

constdefs RenameCond5:: "AP list \<Rightarrow> bool"
"RenameCond5 P == (\<forall> x . x:set P \<longrightarrow> root x \<noteq> self)"

lemma Yps_Preserved_Rename[rule_format]:
"(E,h,U,C,L,R,S):Yps \<Longrightarrow> 
  (\<forall> EE D UU. (RenameCond1 U f UU \<and> RenameCond2 U f UU \<and> 
               RenameCond3 U f UU E h EE C D \<and> RenameCond4 U f UU) \<longrightarrow>
          (EE,h,UU,D,L,R,S):Yps)"
(*<*)
apply (erule Yps.induct)
(*NIL*)
apply clarsimp
apply (rule Yps_NIL) apply (simp add: RenameCond2_def, simp) 
(*CONS*)
apply clarsimp
apply (subgoal_tac "\<exists> y . fmap_lookup f p = Some y \<and> y:UU", clarsimp)
prefer 2 apply (simp add: RenameCond1_def) 
apply (erule Yps_CONS)
(*1*) apply (simp add: RenameCond3_def) 
(*2*) apply (simp add: RenameCond3_def) apply fastsimp
(*3*) apply assumption 
(*4*) apply (erule_tac x=EE in allE)
      apply (erule_tac x=D in allE)
      apply (erule_tac x="UU - {y}" in allE, erule impE)
        apply rule
          apply (simp add: RenameCond1_def RenameCond4_def, clarsimp)
          apply (erule_tac x=x in allE, clarsimp)
          apply (erule_tac x=p in allE)
          apply (erule_tac x=x in allE, clarsimp)
        apply rule apply (simp add: RenameCond2_def, clarsimp)
          apply (erule_tac x=ya in allE, fastsimp)
        apply rule apply (simp add: RenameCond3_def RenameCond4_def, clarsimp)
          apply rule 
            apply (erule_tac x=x in allE)
            apply (erule_tac x=ya in allE, clarsimp)
            apply (erule_tac x=p in allE)
            apply (erule_tac x=x in allE)
            apply (erule_tac x=y in allE, clarsimp)
            apply (erule_tac x=p in allE, clarsimp)
          apply (simp add: RenameCond4_def)
      apply assumption
(*5*) apply assumption 
(*6-11*) apply simp+
done

lemma DAss_Rename[rule_format]:
       "\<lbrakk>\<lbrace>UU, n, GG \<ggreater> T, m\<rbrace> EE h hh v p; 
         RenameCond1 U f UU; RenameCond2 U f UU; RenameCond3 U f UU E h EE G GG; RenameCond4 U f UU\<rbrakk>
       \<Longrightarrow> \<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v p"
apply (simp add: DAss_def, clarsimp)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE)
apply (rule_tac x=N in exI, simp)
apply (rule_tac x=P in exI, simp)
apply (rule_tac x=L in exI, simp)
apply (erule Yps_Preserved_Rename, fast, clarsimp)
done

consts REN::"(ARGTYPE \<times> PARAMTYPE \<times> (AP \<leadsto>\<^sub>f AP)) set"
inductive REN intros
REN_NIL: "([], [], emptyfinmap):REN"
REN_IN: "(args, pars, f):REN \<Longrightarrow> ((INarg x) # args, (INpar y) # pars, f):REN"
REN_IV: "(args, pars, f):REN \<Longrightarrow> ((VALarg (IVal i)) # args, (INpar y) # pars, f):REN"
REN_RN: "\<lbrakk>(args, pars, f):REN\<rbrakk>\<Longrightarrow> ((RNarg x) # args, (RNpar y) # pars, f((varAP x)\<mapsto>\<^sub>f(varAP y))):REN"

consts ParList2RnameList:: "PARAMTYPE \<Rightarrow> AP list"
primrec
"ParList2RnameList [] = []"
"ParList2RnameList (h # t) = (case h of 
                                (INpar x) \<Rightarrow> (ParList2RnameList t)
                              | (RNpar x) \<Rightarrow> (varAP x)#(ParList2RnameList t))"

consts ArgList2RnameList:: "ARGTYPE \<Rightarrow> AP list"
primrec
"ArgList2RnameList [] = []"
"ArgList2RnameList (h # t) = (case h of 
                                (INarg x) \<Rightarrow> (ArgList2RnameList t)
                              | (RNarg x) \<Rightarrow> (varAP x) #(ArgList2RnameList t)
                              | (VALarg v) \<Rightarrow> (ArgList2RnameList t))"

lemma AL2RL_p1:"a \<in> set (ArgList2RnameList args) \<Longrightarrow> (\<exists> y. a = varAP y \<and> RNarg y : set args)"
by (induct args, auto, case_tac aa, auto)

lemma PL2RL_p1:"a \<in> set (ParList2RnameList pars) \<Longrightarrow> (\<exists> y . a = varAP y \<and> RNpar y : set pars)"
by (induct pars, auto, case_tac aa, auto)

declare DOM_def[simp]
declare GETr_def[simp]
declare FMAPlookup1[simp]

lemma REN_property1[rule_format]:
"\<lbrakk>(A, P, f) \<in> REN\<rbrakk> \<Longrightarrow> distinct A \<longrightarrow>
 RenameCond1 (set (ArgList2RnameList A)) f (set (ParList2RnameList P))"
apply (erule REN.induct)
apply (simp add: RenameCond1_def)
apply (simp add: RenameCond1_def)
apply (simp add: RenameCond1_def)
apply (simp add: RenameCond1_def, clarsimp)
apply (erule_tac x=xa in allE, clarsimp)
apply (rule_tac x=ya in exI, simp)
apply (drule AL2RL_p1, clarsimp)
apply (subgoal_tac "varAP yb \<noteq> varAP x", auto)
done

lemma REN_property2[rule_format]:
"\<lbrakk>(A, P, f) \<in> REN\<rbrakk> \<Longrightarrow> distinct A \<longrightarrow>
 RenameCond2 (set (ArgList2RnameList A)) f (set (ParList2RnameList P))"
apply (simp add: RenameCond2_def)
apply (erule REN.induct)
apply simp
apply simp
apply simp
apply clarsimp
apply (rule, clarsimp)
apply (rule_tac x="varAP x" in exI, clarsimp)
apply clarsimp
apply (erule_tac x="ya" in allE, clarsimp)
apply (rule_tac x="xa" in exI, clarsimp)
apply (drule AL2RL_p1, clarsimp)
apply (subgoal_tac "varAP yb \<noteq> varAP x", auto)
done

lemma REN_property4a:
"\<lbrakk>(A, P, f) \<in> REN\<rbrakk> \<Longrightarrow> distinct P \<longrightarrow> (\<forall> x y . fmap_lookup f x = Some y \<longrightarrow> x:set (ArgList2RnameList A) \<and> y :set (ParList2RnameList P))"
apply (erule REN.induct)
apply simp
apply simp
apply simp
apply clarsimp
apply (case_tac "xa=varAP x", auto)
done


lemma REN_property4[rule_format]:
"\<lbrakk>(A, P, f) \<in> REN\<rbrakk> \<Longrightarrow> distinct P \<longrightarrow>
 RenameCond4 (set (ArgList2RnameList A)) f (set (ParList2RnameList P))"
apply (simp add: RenameCond4_def)
apply (erule REN.induct)
apply simp
apply simp
apply simp
apply clarsimp
apply (case_tac "x1=varAP x", clarsimp)
(*1*) apply (case_tac "x2=varAP x")
  (*1*) apply clarsimp
  (*2*) apply clarsimp
    apply (subgoal_tac "fmap_lookup f x2 = Some (varAP y)")
    prefer 2 apply simp 
    apply (drule REN_property4a, erule impE, simp) 
    apply (rotate_tac -1, erule_tac x=x2 in allE)
    apply (rotate_tac -1,erule_tac x="varAP y" in allE, erule impE) apply simp
    apply (erule conjE)
    apply (drule PL2RL_p1, simp)
(*2*) apply (case_tac "x2=varAP x")
  (*1*) apply clarsimp
        apply (drule REN_property4a, clarsimp) 
        apply (rotate_tac -1, erule_tac x=x1 in allE, rotate_tac -1,erule_tac x="varAP y" in allE, clarsimp)
        apply (drule PL2RL_p1, simp)
  (*2*) apply clarsimp 
done

lemma AdaptRename:
"\<lbrakk>\<lbrace>UU, n, C  \<ggreater> T, m\<rbrace> EE h hh v p;
        distinct P;
        distinct L;
        (L, P ,f):REN;
        U = set (ArgList2RnameList L); roots U \<subseteq> DOM G;
        UU = set (ParList2RnameList P); roots UU \<subseteq> DOM C;
        \<forall> x y . ((fmap_lookup f (varAP x) = Some (varAP y)) \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>y\<rfloor>);
        \<forall> x y . ((fmap_lookup f (varAP x) = Some (varAP y)) \<longrightarrow> (GETr G x = GETr C y))\<rbrakk> \<Longrightarrow>
       \<lbrace>U , n , G \<ggreater> T, m \<rbrace> E h hh v p"
apply (erule DAss_Rename)
apply (simp, erule REN_property1, assumption)
apply (simp, erule REN_property2, assumption)
prefer 2 apply (simp, erule REN_property4, assumption) 
apply (simp add: RenameCond3_def, clarsimp)
apply (frule REN_property4a, clarsimp)
apply (erule_tac x=x in allE)
apply (erule_tac x=y in allE)
apply clarsimp
apply (drule  AL2RL_p1)
apply (drule  PL2RL_p1)
apply clarsimp
apply rule
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (rule lookupAP_Var, fastsimp, assumption+)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (rule lookupAP_Var, fastsimp+) 
done

consts x :: rname
       z :: rname
       tg :: iname
       y :: iname
       head :: iname
       tail :: rname
       lst :: rname
       FILL :: mname
       HD :: ifldname
       TL :: rfldname

axioms MT_FILL:
   "methtable DIAM FILL = ([RNpar x, INpar tg, INpar y, RNpar z],
                             LET _ = PutFi x DOLLAR tg;
                                 _ = PutFi x HD y;
                                 _ = PutFr x TL z
                             IN RVar x END) \<and> x \<noteq> z \<and> tg \<noteq> y \<and> DOLLAR \<noteq> HD"


declare DOM_def[simp del]
declare GETr_def[simp del]
declare FMAPlookup1[simp del]

lemma "\<lbrakk>tail \<noteq> lst\<rbrakk> \<Longrightarrow>
       G \<rhd> (DIAM\<bullet>FILL([RNarg lst, VALarg (IVal 1), INarg head, RNarg tail])):
      (\<lambda> E h hh v p  . \<lbrace>{varAP lst, varAP tail}, n, (C(lst\<mapsto>\<^sub>fnodeET(kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)],j)))(tail\<mapsto>\<^sub>fiList HD TL kN kC) \<ggreater> iList HD TL kN kC, n\<rbrace> E h hh v p)"
apply (rule DA_C_Invs)
apply (simp add: MT_FILL newframe_env_def evalARGS_def)
apply (rule vdm_conseq)
apply (subgoal_tac "insert (DIAM\<bullet>FILL([RNarg lst, VALarg (IVal 1), INarg head, RNarg tail]), \<lbrace> {varAP lst, varAP tail} , n , C(lst\<mapsto>\<^sub>f
            nodeET (kC, recET [(ifldn HD, intET), (rfldn TL, iList HD TL kN kC)], j))(tail\<mapsto>\<^sub>f
            iList HD TL kN kC) \<ggreater>  iList HD TL kN kC , n \<rbrace>)
     G \<rhd>  (LET  _ =x\<bullet>DOLLAR := tg ;  _ =x\<bullet>HD := y ;  _ =x\<diamondsuit>TL := z  IN RVar x END) :(\<lambda> E h hh v p . E<tg>=1 \<longrightarrow> \<lbrace>{varAP x, varAP z}, n, C(x\<mapsto>\<^sub>f
            nodeET (kC, recET [(ifldn HD, intET), (rfldn TL, iList HD TL kN kC)], j))(z\<mapsto>\<^sub>f
            iList HD TL kN kC) \<ggreater>  iList HD TL kN kC , n \<rbrace> E h hh v p)", assumption)
apply (rule FILL_LIST) apply (insert MT_FILL)
  apply (rule GETr_Update2, simp add: GETr_def)  apply fastsimp
  apply (simp add: GETr_def)
apply fastsimp
apply fastsimp
apply clarsimp
apply (rule DAssC_PConst)
apply (erule DAss_Rename)
  apply (subgoal_tac " RenameCond1 {varAP lst, varAP tail} 
                                   ((emptyfinmap((varAP lst)\<mapsto>\<^sub>f(varAP x)))((varAP tail)\<mapsto>\<^sub>f(varAP z)))
                                   {varAP x, varAP z}", assumption)
apply (simp add: RenameCond1_def)
  apply (rule_tac x="varAP x" in exI, simp) apply (insert FMAPlookup2 [of "varAP lst" "varAP tail" "emptyfinmap(varAP lst\<mapsto>\<^sub>fvarAP x)" "Some (varAP x)" "varAP z"], clarsimp) 
apply (simp add: RenameCond2_def, clarsimp)
apply rule
  apply clarsimp 
  apply (rule_tac x="varAP lst" in exI, clarsimp) 
  apply clarsimp 
  apply (rule_tac x="varAP tail" in exI, clarsimp) 
apply (simp add: RenameCond3_def, clarsimp)
  apply (erule impE, fastsimp)
  apply (erule disjE)
  apply clarsimp 
  apply rule apply (erule lookupAP.elims, simp_all, clarsimp)  
             apply (rule lookupAP_Var) 
               apply (rule GETr_Update2) apply (simp add: GETr_def) apply (insert FMAPlookup2 [of "lst" "tail" "C(lst\<mapsto>\<^sub>fnodeET (kC, recET [(ifldn HD, intET), (rfldn TL, iList HD TL kN kC)], j))" "Some(nodeET (kC, recET [(ifldn HD, intET), (rfldn TL, iList HD TL kN kC)], j))" "iList HD TL kN kC"])
               apply clarsimp apply (erule impE, clarsimp) apply clarsimp
               apply fastsimp
               apply simp 
               apply assumption
            apply clarsimp apply (erule impE, clarsimp)  apply (erule lookupAP.elims, simp_all, clarsimp)  
             apply (rule lookupAP_Var) 
               apply (rule GETr_Update2) apply (simp add: GETr_def) apply (insert FMAPlookup2 [of "x" "z" "C(x\<mapsto>\<^sub>fnodeET (kC, recET [(ifldn HD, intET), (rfldn TL, iList HD TL kN kC)], j))" "Some(nodeET (kC, recET [(ifldn HD, intET), (rfldn TL, iList HD TL kN kC)], j))" "iList HD TL kN kC"])
               apply clarsimp 
               apply fastsimp
               apply simp 
               apply assumption 

  apply clarsimp 
  apply (erule impE, clarsimp) 
  apply rule apply (erule lookupAP.elims, simp_all, clarsimp)  
             apply (rule lookupAP_Var) apply (simp add: GETr_def)
              apply simp 
              apply assumption
          apply (erule lookupAP.elims, simp_all, clarsimp)  
             apply (rule lookupAP_Var) apply (simp add: GETr_def)
              apply simp 
              apply assumption
apply (simp add: RenameCond4_def, fastsimp)
done

consts SPEC::"mname \<Rightarrow> vdmassn"
constdefs sMST :: sMS_T  
"sMST == (\<lambda> C M args E h hh v p. SPEC M (newframe_env Nullref (fst (methtable C M)) args E) h hh v p)"

lemma InvokeRename:
  "\<lbrakk>G \<rhd> (c\<bullet>M(L)): sMST c M L; 
        SPEC M = \<lbrace>UU, n, C  \<ggreater> T, m\<rbrace>;
        distinct (fst (methtable c M)); distinct L;
        (L, fst (methtable c M), f) \<in> REN;
        U = set (ArgList2RnameList L); roots U \<subseteq> DOM D;
        UU = set (ParList2RnameList (fst (methtable c M))); roots UU \<subseteq> DOM C;
     \<forall> E x . x:fmap_dom f \<longrightarrow> (\<forall> y . (fmap_lookup f x = Some y) \<longrightarrow> E\<lfloor>x\<rfloor> = (newframe_env Nullref (fst (methtable c M)) L E)\<lfloor>y\<rfloor>);
     \<forall> x . x:fmap_dom f \<longrightarrow> (\<forall> y . ((fmap_lookup f x = Some y) \<longrightarrow> (GETr D x = GETr C y)))\<rbrakk>
      \<Longrightarrow> G \<rhd> (c\<bullet>M(L)):\<lbrace> U, n , D  \<ggreater> T , m \<rbrace>"
sorry 


lemma "\<lbrakk>tail \<noteq> lst; SPEC FILL = (\<lambda> E h hh v p . \<lbrace>{varAP l, varAP t}, n, C \<ggreater> iList HD TL kN kC, n\<rbrace> E h hh v p)\<rbrakk> \<Longrightarrow>
       G \<rhd> (DIAM\<bullet>FILL([RNarg lst, VALarg (IVal 1), INarg head, RNarg tail])):
      (\<lambda> E h hh v p  . \<lbrace>{varAP lst, varAP tail}, n, (C(lst\<mapsto>\<^sub>fnodeET(kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)],j)))(tail\<mapsto>\<^sub>fiList HD TL kN kC) \<ggreater> iList HD TL kN kC, n\<rbrace> E h hh v p)"
apply (rule InvokeRename)
defer 1
apply assumption
apply (simp add: MT_FILL)
apply fastsimp
apply (simp add: MT_FILL)
  apply (rule REN.intros)
  apply (rule REN.intros)
apply simp
apply (simp add: roots_def DOM_def) apply clarsimp apply fastsimp 
apply (simp add: MT_FILL)
apply simp
apply (rule vdm_conseq)
apply (rule FILL_LIST)
  apply assumption
  apply assumption
  apply assumption
  

apply (rule FILL_LIST
done

lemma FILL_LIST_TL:
"\<lbrakk>GETr C t = Some(nodeET(kC, recET TT,1)); 
  GETr C r = Some(iTree I L R kN kC); L \<noteq> R; t\<noteq>r;
  TT = [(rfldn L,iTree I L R kN kC), (rfldn R,iTree I L R kN kC)]\<rbrakk>
\<Longrightarrow> G \<rhd> (LET  _ = t\<diamondsuit>R := r IN RVar t END) : \<parallel>{varAP r}, Some (nodeAP t), [],n, C \<ggreater> iTree I L R kN kC, n\<parallel>"
apply (rule LETPUTFR[simplified])
  apply assumption
  apply simp
  apply simp
  apply fast
  apply assumption
  apply simp
  apply simp
  apply simp
  apply (erule muRVAR_R) apply simp apply assumption apply simp apply simp
  apply simp
  apply (simp add: roots_def)
done
lemma FILL_LIST_HDTL:
"\<lbrakk>GETr C l = Some(nodeET(kC, recET TT,1)); GETr C t = Some(iList HD TL kN kC); t \<noteq> l; DOLLAR \<noteq> HD;
  TT = [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]\<rbrakk>
\<Longrightarrow> G \<rhd> (LET  _ = l\<bullet>HD := x; _ = l\<diamondsuit>TL := t IN RVar l END) : \<parallel>{varAP t}, Some (nodeAP l), [],n, C \<ggreater> iList HD TL kN kC, n\<parallel>"
apply (rule LETPUTFI[simplified])
  apply (rule FILL_LIST_TL)
    apply assumption
    apply assumption
    apply assumption
    apply assumption
  apply assumption
  apply assumption
  apply simp
done

lemma FILL_LIST:
"\<lbrakk>GETr C l = Some(nodeET(kC, recET TT,j)); 
  GETr C t = Some(iList HD TL kN kC); 
  t \<noteq> l; DOLLAR \<noteq> HD;
  TT = [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]\<rbrakk>
\<Longrightarrow> G \<rhd> (LET  _ = l\<bullet>DOLLAR := tg;_ = l\<bullet>HD := x; _ = l\<diamondsuit>TL := t IN RVar l END) : 
     (\<lambda> E h hh v p . E<tg>=1 \<longrightarrow> \<lbrace>{varAP l, varAP t}, n, C \<ggreater> iList HD TL kN kC, n\<rbrace> E h hh v p)"
apply (erule FILL)
defer 1 apply (simp add: roots_def, fast) 
        apply fast 
apply (rule FILL_LIST_HDTL) 
  apply (simp add: GETr_def)
  apply (erule GETr_Update2, fast)
  apply assumption
  apply assumption
  apply simp
done


constdefs LIST_FILL_SPEC::"ifldname \<Rightarrow> rfldname \<Rightarrow> ARGTYPE \<Rightarrow> vdmassn"
"LIST_FILL_SPEC HD TL args E h hh v p == (\<forall> TAG HEAD TAIL LST C kN kC j n. args = [INarg TAG, INarg HEAD, RNarg TAIL, RNarg LST] \<longrightarrow>
                                    E<TAG> = 1 \<longrightarrow> GETr C LST = Some(nodeET(kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)],j)) \<longrightarrow>
                                    \<parallel>{varAP TAIL}, Some (nodeAP LST), [],n, C \<ggreater> iList HD TL kN kC, n\<parallel> E h hh v p)"

constdefs Pre::"int \<Rightarrow> rname \<Rightarrow> iname \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"Pre i l x P == (\<lambda> E h hh v p . (\<exists> a . E\<lfloor>l\<rfloor> = Ref a \<and> a : Dom h \<and> h<a\<bullet>DOLLAR>=E<x> \<and> E<x>=i \<and> P E h hh v p))"

lemma "\<lbrakk>methtable DIAM FILL = LIST_FILL HD TL tg h t l;
       sMST DIAM FILL = LIST_FILL_SPEC HD TL\<rbrakk> \<Longrightarrow>
     G \<rhd> (DIAM\<bullet>FILL ([VALarg (IVal 1), INarg head, RNarg tail, RNarg lst])) :
        \<parallel>{varAP tail}, Some (nodeAP lst), [],n, C \<ggreater> iList HD TL kN kC, n\<parallel>"
apply (rule vdm_conseq, rule vdm_invokestatic)
apply (simp add: LIST_FILL_def)

apply (rule vdm_conseq, rule vdm_letv, rule vdm_putfi) 
apply assumption
apply (erule thin_rl)
apply (simp add: Pre_def muDAss_def DAss_def, clarsimp) 
apply (frule Yps_regionsExist) 
  apply (rule, fast)
  apply (erule lookupAP_Var)
apply clarsimp
apply (drule Yps_split) 
  apply (rule, fast)
  apply (erule lookupAP_Var)
  apply simp apply (rule, simp, simp)
  apply assumption
apply clarsimp
apply (subgoal_tac "U - {varAP l} = U", clarsimp)
prefer 2 apply (case_tac "varAP l : U", simp add: roots_def) apply (erule_tac x="varAP l" in allE, clarsimp) apply fast
  apply (erule_tac x=q in allE)
  apply (erule_tac x=F in allE)
  apply (erule_tac x=RRR in allE)
  apply (erule_tac x="RR" in allE, erule impE)
  prefer 2 apply clarsimp
    apply (rule_tac x=Rv in exI)
    apply (rule_tac x=S in exI)
    apply (rule_tac x=M in exI)
    apply (rule_tac x=FF in exI, simp)
    apply (simp add: modif_def sameOH_def, clarsimp)
    apply (erule_tac x=laa in allE, clarsimp)
    apply (erule_tac x=ifield in allE)
    apply (case_tac "ifield = DOLLAR", clarsimp, clarsimp)
  apply (rule_tac x=N in exI, simp, rule)
    apply (simp add: freelist_def)
    apply (erule FL_Preserved) apply (simp add: sameOH_def) 
  apply (rule_tac x="Na+k" in exI)
  apply (rule_tac x=La in exI)
  apply (rule_tac x="{la}" in exI, simp)
  apply (rule mYps_SOME)
    defer 1 (*apply (erule YpsPreserved_PutFi)*)
    apply (simp add: evalAP_PutFi)
    apply fast
    apply assumption
    apply simp
    apply (simp add: GETr_def) apply (rule, simp, rule, simp, simp)
    apply simp
    apply simp
(*Case FLD*)
apply clarsimp
  apply (case_tac "locns ha\<lfloor>a\<diamondsuit>Fa\<rfloor> \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
  apply (frule modelsETLocn, simp)
  apply (frule  mYps_NodelocReg, simp, simp, clarsimp)
  apply (erule_tac x=q in allE)
  apply (erule_tac x=F in allE)
  apply (erule_tac x=Ra in allE)
  apply (erule_tac x="RR \<union> RR1" in allE, erule impE)
  prefer 2 apply clarsimp
    apply (rule_tac x=Rv in exI)
    apply (rule_tac x=S in exI)
    apply (rule_tac x=M in exI)
    apply (rule_tac x=FF in exI, simp)
    apply (simp add: modif_def sameOH_def)
    apply clarsimp
    apply (erule_tac x=laa in allE, clarsimp)
    apply (erule_tac x=ifield in allE)
    apply (case_tac "ifield = DOLLAR", clarsimp)
    apply (case_tac "laa=a", fast, clarsimp)
    apply clarsimp
  apply (rule_tac x=N in exI, simp, rule)
    apply (simp add: freelist_def)
    apply (erule FL_Preserved) apply (simp add: sameOH_def) 
  apply (rule_tac x="Na+N1" in exI)
  apply (rule_tac x=La in exI)
  apply (rule_tac x="{a}" in exI, simp)
  apply (rule mYps_FLD)
      defer 1 (*apply (erule mYpsPreserved_PutFi) apply assumption *)
      apply (simp add: evalAP_PutFi) apply (rule, fast, simp) 
      apply (erule lookupAP_PutFi) apply assumption apply (simp add: PutFi_Triv)
      apply (erule modelsET_PutFi) apply assumption 
      apply fast 
      apply simp 
      apply simp
done


lemma FILL_LIST:
"\<lbrakk>GETr C l = Some(nodeET(kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)],j)); DOLLAR \<noteq> HD;
  GETr C t = Some(iList HD TL kN kC); t \<noteq> l\<rbrakk> \<Longrightarrow>
        G \<rhd> (LET tg = expr.Int 1;
                   _ = l\<bullet>DOLLAR := tg;
                   _ = l\<bullet>HD := x;
                   _ = l\<diamondsuit>TL := t 
             IN RVar l END) : \<parallel>{varAP t}, Some (nodeAP l), [],n, C \<ggreater> iList HD TL kN kC, n\<parallel>"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule LETPUTFI)
  prefer 2 apply assumption 
  prefer 2 apply assumption
  prefer 2 apply simp
  apply (rule LETPUTFR)
    apply assumption
    apply simp
    defer 1 
    apply assumption
    apply assumption
    apply simp
    apply simp
    defer 1
    apply (subgoal_tac "G \<rhd>  RVar l : \<parallel> {}, Some (nodeAP l), rfldAP (nodeAP l) TL # [] , n , C \<ggreater>  iList HD TL kN kC , n \<parallel>", assumption)
    defer 1
    apply simp
    apply (simp add: roots_def)
    defer 1 apply simp
            apply simp
      apply (rule vdm_conseq, rule vdm_rvar) 
      apply (simp add: muDAss_def, clarsimp)
      apply (erule mYps.elims, simp_all, clarsimp)
      apply (case_tac "locns (renv Ea l) \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
      apply (case_tac " renv Ea l", clarsimp) apply clarsimp
      apply (case_tac "locns ha\<lfloor>nat\<diamondsuit>TL\<rfloor> \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
      apply (erule mYps.elims, simp_all, clarsimp)
      apply (erule Yps.elims, simp_all, clarsimp)
      apply (rule_tac x="insert laa RR1" in exI)
      apply (rule_tac x="N1+kC" in exI)
      apply (rule_tac x="N" in exI)
      apply (rule_tac x="F" in exI, simp add: iList_def)
apply (subgoal_tac "ha<laa\<bullet>DOLLAR>=1")
      apply (rule modelsETMu, assumption)
         apply (rule substitution_listsubstitution.intros)+ 
         apply (rule modelsETSum, assumption)
         apply simp
         apply simp
         apply clarsimp
         apply clarsimp apply rule prefer 2 apply simp
         apply (erule lookupAP.elims, simp_all)
           apply clarsimp apply (erule lookupAP.elims, simp_all)
           apply clarsimp apply (erule lookupAP.elims, simp_all)
           apply clarsimp apply (erule lookupAP.elims, simp_all)
           apply clarsimp
           prefer 2 apply clarsimp apply (erule lookupAP.elims, simp_all)
         apply (rule modelsETRecC, assumption)
           apply fastsimp
           apply simp apply (rule modelsETInt)
           apply (rule modelsETRecC, assumption)
             apply fastsimp
             apply simp 
             apply (rule modelsETRecN, assumption)
               apply simp
             apply assumption
             apply simp
             apply simp
             apply simp
             apply simp
             apply simp
             apply simp
             apply simp
defer 1 
apply clarsimp
   
apply assumption
apply clarsimp 
apply (erule thin_rl)
apply (simp add: muDAss_def, clarsimp)
  apply (frule mYps_NodelocReg, simp, clarsimp)
  apply (erule_tac x=q in allE)
  apply (erule_tac x=F in allE)
  apply (erule_tac x=R in allE)
  apply (erule_tac x="rg" in allE, erule impE)
  prefer 2 apply clarsimp
    apply (rule_tac x=Rv in exI)
    apply (rule_tac x=S in exI)
    apply (rule_tac x=M in exI)
    apply (rule_tac x=FF in exI, simp)
    apply (simp add: modif_def sameOH_def, clarsimp)
    apply (subgoal_tac "la \<noteq> a") prefer 2 apply fast
    apply (erule_tac x=la in allE, clarsimp)
    apply (erule_tac x=ifield in allE)
    apply (case_tac "ifield = DOLLAR", clarsimp, clarsimp)
  apply (rule_tac x=N in exI, simp, rule)
    apply (simp add: freelist_def)
    apply (erule FL_Preserved) apply (simp add: sameOH_def) 
  apply (rule_tac x="P" in exI)
  apply (rule_tac x=L in exI)
  apply (rule_tac x="{a}" in exI, simp)
    apply (erule YpsPreserved_PutFi)
    apply (simp add: evalAP_PutFi)
    apply fast
    apply assumption
    apply simp
    apply assumption
    apply simp
    apply simp
(*Case FLD*)
apply clarsimp
  apply (case_tac "a: Dom ha", clarsimp) prefer 2 apply clarsimp
  apply (case_tac "locns ha\<lfloor>a\<diamondsuit>Fa\<rfloor> \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
  apply (frule modelsETLocn, simp)
  apply (frule  mYps_NodelocReg, simp, simp, clarsimp)
  apply (erule_tac x=q in allE)
  apply (erule_tac x=F in allE)
  apply (erule_tac x=Ra in allE)
  apply (erule_tac x="RR \<union> RR1" in allE, erule impE)
  prefer 2 apply clarsimp
    apply (rule_tac x=Rv in exI)
    apply (rule_tac x=S in exI)
    apply (rule_tac x=M in exI)
    apply (rule_tac x=FF in exI, simp)
    apply (simp add: modif_def sameOH_def)
    apply clarsimp
    apply (erule_tac x=laa in allE, clarsimp)
    apply (erule_tac x=ifield in allE)
    apply (case_tac "ifield = FLD", clarsimp)
    apply (case_tac "laa=a", fast, clarsimp)
    apply clarsimp
  apply (rule_tac x=N in exI, simp, rule)
    apply (simp add: freelist_def)
    apply (erule FL_Preserved) apply (simp add: sameOH_def) 
  apply (rule_tac x="Na+N1" in exI)
  apply (rule_tac x=La in exI)
  apply (rule_tac x="{a}" in exI, simp)
  apply (rule mYps_FLD)
      apply (erule mYpsPreserved_PutFi) apply assumption 
      apply (simp add: evalAP_PutFi) apply (rule, fast, simp) 
      apply (erule lookupAP_PutFi) apply assumption apply (simp add: PutFi_Triv)
      apply (erule modelsET_PutFi) apply assumption 
      apply fast 
      apply simp 
      apply simp
done

lemma ListFold:"\<lbrakk>\<lbrace> U , n , C(l\<mapsto>\<^sub>fiList HD TL kN kC) \<ggreater>  T , m \<rbrace> E h hh v p; 
                  E\<lfloor>l\<rfloor> = Ref la; h<la\<bullet>DOLLAR>=1; V = U - {varAP l}; 
                  l \<notin> roots V;
                  GETr C l = Some (nodeET (kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)],1))\<rbrakk> \<Longrightarrow>
                  \<parallel> V, Some (nodeAP l), [rfldAP (nodeAP l) TL] , n, C \<ggreater>  T , m \<parallel> E h hh v p"
apply (subgoal_tac "\<lbrace> U \<union> {varAP l}, n , C(l\<mapsto>\<^sub>fiList HD TL kN kC) \<ggreater>  T , m \<rbrace> E h hh v p") 
prefer 2 apply (erule DAss_monotone_in_U, fast)
apply (erule thin_rl, rotate_tac -1)
apply (simp add: DAss_def muDAss_def, clarsimp)
apply (erule mYps.elims, simp_all, clarsimp)
apply (case_tac "la : Dom h", clarsimp) prefer 2 apply clarsimp
apply (case_tac "locns (h\<lfloor>la\<diamondsuit>TL\<rfloor>) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (erule mYps.elims, simp_all, clarsimp)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x="{la} \<union> RR1 \<union> R" in allE, erule impE)
    prefer 2 apply clarsimp apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, simp)
       apply (erule modif_monotone, fast) 
apply (rule_tac x=N in exI, simp)
apply (rule_tac x="Nb+N1+kC" in exI, rule_tac x="{la} \<union> L" in exI,simp, rule)
prefer 2 apply fast
apply (erule lookupAP.elims, simp_all, clarsimp)
             apply (erule lookupAP.elims, simp_all, clarsimp)
             apply (erule lookupAP.elims, simp_all, clarsimp)
             prefer 2 apply clarsimp
                apply (erule lookupAP.elims, simp_all)
             apply (erule lookupAP.elims, simp_all, clarsimp)
    apply (rule Yps_CONS) apply (subgoal_tac "varAP l : insert (varAP l) U", assumption, fast)
      apply (rule lookupAP_Var) apply (simp add: GETr_def)
      apply simp apply (rule, simp, simp)
      apply (simp add: iList_def)
         apply (rule modelsETMu) apply simp 
         apply (rule substitution_listsubstitution.intros)+ 
         apply (rule modelsETSum) apply simp 
         apply clarsimp 
           apply simp
           apply clarsimp
          apply clarsimp
          apply rule 
           apply (rule modelsETRecC) apply (simp, fastsimp) apply simp apply (rule modelsETInt)
           apply (rule modelsETRecC) apply (simp, fastsimp) apply simp
           apply (rule modelsETRecN) apply (simp, simp) apply assumption  apply fast  apply simp  apply simp 
            apply simp  apply simp  apply simp  apply simp  apply simp
       apply (subgoal_tac "((insert (varAP l) U) - {(varAP l)}) = U - {(varAP l)}", clarsimp) prefer 2 apply fast
       apply (erule YpsPreservedU) apply simp apply (erule lookupAP_Update2) apply (simp add:roots_def) 
                     apply (erule_tac x=x in allE, clarsimp)
       apply fast 
       apply fast
       apply fast
       apply fast 
       apply simp
       apply simp
done

lemma  ListFOLD:"\<lbrakk>G \<rhd> e: \<lbrace> U , n , C(l\<mapsto>\<^sub>fiList HD TL kN kC) \<ggreater>  T , m \<rbrace>;  V = U - {varAP l}; 
                  l \<notin> roots V;
                  GETr C l = Some (nodeET (kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)],1))\<rbrakk> \<Longrightarrow>
                  G \<rhd> e: \<parallel> V, Some (nodeAP l), [rfldAP (nodeAP l) TL] , n, C \<ggreater>  T , m \<parallel>"
apply (erule vdm_conseq, clarsimp)
apply (simp add: muDAss_def, clarsimp)
apply (frule mYps.elims, simp_all, clarsimp)
apply (case_tac "locns (renv Ea l) \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
apply (case_tac "renv Ea l", clarsimp) apply clarsimp
apply (case_tac "locns ha\<lfloor>nat\<diamondsuit>TL\<rfloor> \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
apply (drule  ListFold)
  apply assumption+
  apply (rotate_tac 6)
  apply (drule mYps.elims, simp_all)
apply (simp add: muDAss_def)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=Ra in allE, erule_tac x="RR \<union> RR1" in allE, fast)
done
(*
lemma FillAux[rule_format]:
"\<lbrakk> \<parallel> V \<union> {varAP t}, Some (nodeAP l), [] , n , C \<ggreater>  T , m \<parallel> E h hh v p;
   V = U - {varAP l}\<rbrakk>
\<Longrightarrow> \<parallel> V, Some (nodeAP l), [rfldAP (varAP l) F] , n , C \<ggreater>  T , m \<parallel> E h hh v p"
apply (simp add: muDAss_def, clarsimp)
apply (erule mYps.elims, simp_all, clarsimp)
done

lemma FILL[rule_format]:
"\<lbrakk> G \<rhd> e : \<parallel> U, Some (nodeAP l), [] , n , C \<ggreater>  T , m \<parallel>; 
   varAP t : U; V=U - {varAP l}\<rbrakk>
\<Longrightarrow> G \<rhd> e : \<parallel> V, Some (nodeAP l), [rfldAP (varAP l) F] , n , C \<ggreater>  T , m \<parallel>"
apply (erule vdm_conseq)
apply (case_tac "varAP l :U")
apply (clarify, rule FillAux) prefer 2 apply simp
 apply (subgoal_tac "\<parallel> U - {varAP l} \<union> {varAP l}, Some (nodeAP l), [] , n , C \<ggreater>  T , m \<parallel> E h hh v p", assumption)
 apply (subgoal_tac "U - {varAP l} \<union> {varAP l} = U", clarsimp, fast)
apply (clarify, rule FillAux) prefer 2 apply (subgoal_tac "U - {varAP l} = U - {varAP l}", assumption, simp)
 apply (subgoal_tac "\<parallel> U - {varAP l} \<union> {varAP t}, Some (nodeAP l), [] , n , C \<ggreater>  T , m \<parallel> E h hh v p", assumption)
 apply (subgoal_tac "U - {varAP l} \<union> {varAP t} = U", clarsimp, fast)
done
*)
lemma FILL_List:
      "\<lbrakk>G \<rhd> e : \<lbrace>U,n,C(l\<mapsto>\<^sub>f(iList HD TL kN kC)) \<ggreater> T, m\<rbrace>; \<forall> p. p:U \<longrightarrow> (\<exists> x . p = varAP x); t\<noteq> l;
        GETr C t = Some (iList HD TL kN kC);
        t \<notin> roots U;
        GETr C l = Some (nodeET (kC, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)],1))\<rbrakk>
     \<Longrightarrow>
        G \<rhd> (LET _ = l\<diamondsuit>TL := t 
             IN e END): \<parallel>U \<union> {varAP t},Some (nodeAP l), [], n,C \<ggreater> T, m\<parallel>"
apply (rule muWEAK)
  apply (rule LETPUTFR)
    apply assumption
    apply simp
    apply simp
    apply assumption
    apply assumption
    apply simp
    apply simp
    apply simp
    apply (rule ListFOLD) (*This is the Dass-assumtpion*)
      apply assumption
      apply simp
      apply assumption
(*now back to letputfr -- APs is now filled*)
  apply simp
  apply simp
  apply assumption
  apply simp
  apply (simp add: roots_def)
apply clarsimp
  apply (rule FillAux)

prefer 2    apply simp
    apply simp
    apply assumption
     apply (simp add: roots_def) 
     apply assumption
prefer 4 apply assumption
 apply simp
apply simp
apply simp
apply simp
apply clarsimp
apply (rule L) 
defer 1 apply assumption+
apply simp+
done

lemma FILL:
      "\<lbrakk>G \<rhd> e : \<lbrace>U,n,C(x\<mapsto>\<^sub>f(muET S)) \<ggreater> T, m\<rbrace>;
        subst S (muET S) (sumET (kL,recET T1) (kR,recET T2));
        GETr C x = Some (nodeET (kL, recET T1)); 
        distinct (map fst T1);
        G \<rhd> e : \<parallel>U,Some (nodeAP x), get_rfldAPs T1 x, n,C(x\<mapsto>\<^sub>f(nodeET(kL,recET T1))) \<ggreater> T, m\<parallel>;
        x \<notin> roots U\<rbrakk>
       \<Longrightarrow>
        G \<rhd> (LET t = x\<bullet>DOLLAR; 
                  b = Primop (\<lambda> x y . if x=0 then 1 else 0) t t 
             IN IF b THEN e1 ELSE e2 END): \<lbrace>U \<union> {varAP x},n,C \<ggreater> T, m\<rbrace>"
G \<rhd> e : \<lbrace>U,n,C \<ggreater> T, m\<rbrace>; 
        GETr C t = Some(iList HD TL kN kC); l \<noteq> t; varAP t \<notin> U\<rbrakk> \<Longrightarrow>
        G \<rhd> (LET tg = expr.Int 1;
                   _ = l\<bullet>DOLLAR := tg;
                   _ = l\<bullet>DOLLAR := x;
                   _ = l\<diamondsuit>FLD := t 
             IN e END) : \<lbrace>U \<union> {varAP t},n,C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
apply (rule vdm_leti, rule vdm_prim)
apply (rule vdm_if) apply assumption apply assumption
apply (rotate_tac 4, erule thin_rl, erule thin_rl) 
apply clarsimp
apply (case_tac"h<a\<bullet>DOLLAR> = 0" )
  apply clarsimp 
    apply (rule DAssC_PConst) 
    apply (rule DAss_PreservedU)
      apply (erule UNFOLD[simplified])
        apply simp
        apply assumption+
        apply simp
        apply assumption+
        apply simp
        apply simp
      apply (rule, simp)
  apply clarsimp 
    apply (rule DAssC_PConst) 
    apply (rule DAss_PreservedU)
      apply (erule UNFOLD[simplified])
        apply simp
        apply assumption+
        apply simp
        apply assumption+
        apply simp
        apply simp
      apply (rule, simp)
done

lemma "\<lbrakk>G \<rhd> e : \<lbrace>U,n,C \<ggreater> T, m\<rbrace>; 
        GETr C t = Some(iList HD TL kN kC); l \<noteq> t; varAP t \<notin> U\<rbrakk> \<Longrightarrow>
        G \<rhd> (LET tg = expr.Int 1;
                   _ = l\<bullet>DOLLAR := tg;
                   _ = l\<bullet>DOLLAR := x;
                   _ = l\<diamondsuit>FLD := t 
             IN e END) : \<lbrace>U \<union> {varAP t},n,C \<ggreater> T, m\<rbrace>"
apply (rule WEAK)
apply (rule LETI) 
apply (rule INT)
apply (insert LETPUTFI)

apply (rule WEAK)
  apply (rule MATCH_WEAK) 
    apply (simp add: iList_def)
    apply (rule substitution_listsubstitution.intros)+
    apply simp
    apply simp
    apply simp apply (rule NON_DESTR)
                apply (rule INT)
                apply (simp add: roots_def)
    apply simp apply (rule LETGETFI) 
                 apply (rule LETGETFR) 
                   apply simp
                   apply simp
                   apply simp
                   apply (simp add: GETr_def) apply (rule, fast, fast)
                   apply simp
                   apply (rule NON_DESTR)
                     apply (rule IVAR)
                     apply (simp add: roots_def)
                   apply (simp add: roots_def)
                   apply simp
                   apply simp
                 apply (simp add: GETr_def) apply (rule, fast, fast)
                 apply simp
   apply simp
   apply (simp add: roots_def)
apply simp
done
                 

lemma LETPUTFI_DOLLAR:
"\<lbrakk>G \<rhd> e : \<parallel>U, Some (nodeAP l),V, n, C \<ggreater> T, m\<parallel>;
  GETr C l = Some(nodeET(k, recET TT)); 
  lookup TT (ifldn DOLLAR) = Some intET\<rbrakk>
\<Longrightarrow>  G \<rhd> (LET _ = l\<bullet>DOLLAR := x IN e END) : \<parallel>U, Some (nodeAP l), V,n, C \<ggreater> T, m\<parallel>"
apply (rule vdm_conseq, rule vdm_letv, rule vdm_putfi) 
apply assumption
apply clarsimp 
apply (simp add: muDAss_def, clarsimp)
apply (erule mYps.elims, simp_all, clarsimp)
  apply (case_tac "a: Dom ha", clarsimp) prefer 2 apply clarsimp
  apply (erule_tac x=q in allE)
  apply (erule_tac x=F in allE)
  apply (erule_tac x=Ra in allE)
  apply (erule_tac x="{la}" in allE, erule impE)
  prefer 2 apply clarsimp
    apply (rule_tac x=Rv in exI)
    apply (rule_tac x=S in exI)
    apply (rule_tac x=M in exI)
    apply (rule_tac x=FF in exI, simp)
    apply (simp add: modif_def sameOH_def, clarsimp)
    apply (erule_tac x=laa in allE, clarsimp)
    apply (erule_tac x=ifield in allE)
    apply (case_tac "ifield = DOLLAR", clarsimp, clarsimp)
  apply (rule_tac x=N in exI, simp, rule)
    apply (simp add: freelist_def)
    apply (erule FL_Preserved) apply (simp add: sameOH_def) 
  apply (rule_tac x="Na+k" in exI)
  apply (rule_tac x=La in exI)
  apply (rule_tac x="{la}" in exI, simp)
  apply (rule mYps_SOME)
    apply (erule YpsPreserved_PutFi, fast)
    apply (simp add: evalAP_PutFi)
    apply fast
    apply assumption
    apply simp
    apply assumption
    apply simp
(*Case FLD*)

apply clarsimp
  apply (case_tac "a: Dom ha", clarsimp) prefer 2 apply clarsimp
  apply (case_tac "locns ha\<lfloor>a\<diamondsuit>Fa\<rfloor> \<subseteq> Dom ha", clarsimp) prefer 2 apply clarsimp
  apply (frule modelsETLocn, simp)
  apply (frule  mYps_NodelocReg, simp, simp, clarsimp)
  apply (erule_tac x=q in allE)
  apply (erule_tac x=F in allE)
  apply (erule_tac x=Ra in allE)
  apply (erule_tac x="RR \<union> RR1" in allE, erule impE)
  prefer 2 apply clarsimp
    apply (rule_tac x=Rv in exI)
    apply (rule_tac x=S in exI)
    apply (rule_tac x=M in exI)
    apply (rule_tac x=FF in exI, simp)
    apply (simp add: modif_def sameOH_def)
    apply clarsimp
    apply (erule_tac x=laa in allE, clarsimp)
    apply (erule_tac x=ifield in allE)
    apply (case_tac "ifield = FLD", clarsimp)
    apply (case_tac "laa=a", fast, clarsimp)
    apply clarsimp
  apply (rule_tac x=N in exI, simp, rule)
    apply (simp add: freelist_def)
    apply (erule FL_Preserved) apply (simp add: sameOH_def) 
  apply (rule_tac x="Na+N1" in exI)
  apply (rule_tac x=La in exI)
  apply (rule_tac x="{a}" in exI, simp)
  apply (rule mYps_FLD)
      apply (erule mYpsPreserved_PutFi) apply assumption 
      apply (simp add: evalAP_PutFi) apply (rule, fast, simp) 
      apply (erule lookupAP_PutFi) apply assumption apply (simp add: PutFi_Triv)
      apply (erule modelsET_PutFi) apply assumption 
      apply fast 
      apply simp 
      apply simp
done



done
subsubsection{*Renaming*}
constdefs RenameCond1::"(AP set) \<Rightarrow> (AP \<leadsto>\<^sub>f AP) \<Rightarrow> (AP set) \<Rightarrow> bool"
"RenameCond1 U f UU == (\<forall> x . x:U \<longrightarrow> (\<exists> y. fmap_lookup f x = Some y \<and> y:UU))"

constdefs RenameCond2::"(AP set) \<Rightarrow> (AP \<leadsto>\<^sub>f AP) \<Rightarrow> (AP set) \<Rightarrow> bool"
"RenameCond2 U f UU == (\<forall> y . y:UU \<longrightarrow> (\<exists> x. fmap_lookup f x = Some y \<and> x:U))"

constdefs RenameCond3::"(AP set) \<Rightarrow> (AP \<leadsto>\<^sub>f AP) \<Rightarrow> (AP set) \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> Context \<Rightarrow> Context \<Rightarrow> bool"
"RenameCond3 U f UU E h EE G GG == (\<forall> x y . (x:U \<and> fmap_lookup f x = Some y) \<longrightarrow> (y : UU \<and> evalAP x E h = evalAP y EE h \<and> (\<forall> T . ((G,x,E,h,T):lookupAP) = ((GG,y,EE,h,T):lookupAP))))"

constdefs RenameCond4::"(AP set) \<Rightarrow> (AP \<leadsto>\<^sub>f AP) \<Rightarrow> (AP set) \<Rightarrow> bool"
"RenameCond4 U f UU == (\<forall> x1 x2 y1 y2 . (x1:U \<and> x2:U \<and> x1\<noteq>x2 \<and> fmap_lookup f x1 = y1 \<and> fmap_lookup f x2 = y2) \<longrightarrow> y1 \<noteq> y2)"

constdefs RenameCond5:: "AP list \<Rightarrow> bool"
"RenameCond5 P == (\<forall> x . x:set P \<longrightarrow> root x \<noteq> self)"

lemma Yps_Preserved_Rename[rule_format]:
"(E,h,U,C,L,R,S):Yps \<Longrightarrow> 
  (\<forall> EE D UU. (RenameCond1 U f UU \<and> RenameCond2 U f UU \<and> 
               RenameCond3 U f UU E h EE C D \<and> RenameCond4 U f UU) \<longrightarrow>
          (EE,h,UU,D,L,R,S):Yps)"
(*<*)
apply (erule Yps.induct)
(*NIL*)
apply clarsimp
apply (rule Yps_NIL) apply (simp add: RenameCond2_def, simp) 
(*CONS*)
apply clarsimp
apply (subgoal_tac "\<exists> y . fmap_lookup f p = Some y \<and> y:UU", clarsimp)
prefer 2 apply (simp add: RenameCond1_def) 
apply (erule Yps_CONS)
(*1*) apply (simp add: RenameCond3_def) 
(*2*) apply (simp add: RenameCond3_def) apply fastsimp
(*3*) apply assumption 
(*4*) apply (erule_tac x=EE in allE)
      apply (erule_tac x=D in allE)
      apply (erule_tac x="UU - {y}" in allE, erule impE)
        apply rule
          apply (simp add: RenameCond1_def RenameCond4_def, clarsimp)
          apply (erule_tac x=x in allE, clarsimp)
          apply (erule_tac x=p in allE)
          apply (erule_tac x=x in allE, clarsimp)
        apply rule apply (simp add: RenameCond2_def, clarsimp)
          apply (erule_tac x=ya in allE, fastsimp)
        apply rule apply (simp add: RenameCond3_def RenameCond4_def, clarsimp)
          apply rule 
            apply (erule_tac x=x in allE)
            apply (erule_tac x=ya in allE, clarsimp)
            apply (erule_tac x=p in allE)
            apply (erule_tac x=x in allE)
            apply (erule_tac x=y in allE, clarsimp)
            apply (erule_tac x=p in allE, clarsimp)
          apply (simp add: RenameCond4_def)
      apply assumption
(*5*) apply assumption 
(*6-11*) apply simp+
done

lemma DAss_Rename[rule_format]:
       "\<lbrakk>\<lbrace>UU, n, GG \<ggreater> T, m\<rbrace> EE h hh v p; 
         RenameCond1 U f UU; RenameCond2 U f UU; RenameCond3 U f UU E h EE G GG; RenameCond4 U f UU\<rbrakk>
       \<Longrightarrow> \<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v p"
apply (simp add: DAss_def, clarsimp)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE)
apply (rule_tac x=N in exI, simp)
apply (rule_tac x=P in exI, simp)
apply (rule_tac x=L in exI, simp)
apply (erule Yps_Preserved_Rename, fast, clarsimp)
done


lemma LETGETFI:
"\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; GETr C l = Some(recET R); lookup R (ifldn F)=Some intET\<rbrakk>
      \<Longrightarrow>  G \<rhd> (LET x = l\<bullet>F IN e END) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule LETI)
apply (rule vdm_conseq, rule vdm_getfi) 
prefer 2 apply assumption
apply clarsimp apply (subgoal_tac "\<lbrace> {} , n , C \<ggreater>  intET , n \<rbrace> E h h (IVal h<a\<bullet>F>) (mkRescomp 2 0 0 0)", assumption)
defer 1
apply fast
apply simp
apply (simp add: DAss_def, clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x=N in exI, rule_tac x=Fa in exI, safe)
apply (rule modelsETInt)
apply simp
done

lemma LETGETFI_Node:
"\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; GETr C l = Some(nodeET(k,recET R)); lookup R (ifldn F)=Some intET\<rbrakk>
      \<Longrightarrow>  G \<rhd> (LET x = l\<bullet>F IN e END) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule LETI)
apply (rule vdm_conseq, rule vdm_getfi) 
prefer 2 apply assumption
apply clarsimp apply (subgoal_tac "\<lbrace> {} , n , C \<ggreater>  intET , n \<rbrace> E h h (IVal h<a\<bullet>F>) (mkRescomp 2 0 0 0)", assumption)
defer 1
apply fast
apply simp
apply (simp add: DAss_def, clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x=N in exI, rule_tac x=Fa in exI, safe)
apply (rule modelsETInt)
apply simp
done

constdefs myProp::"env \<Rightarrow> heap \<Rightarrow> rname \<Rightarrow> ((fldname \<times> Tp) list) \<Rightarrow> ((fldname \<times> Tp) list) \<Rightarrow> fldname \<Rightarrow> Tp \<Rightarrow> bool"
"myProp E h x LL RR FF TT == (\<forall> a . ((E\<lfloor>x\<rfloor> = Ref a) \<longrightarrow> 
                           ((a:Dom h) \<and>
                            ((h<a\<bullet>DOLLAR> = 0) \<longrightarrow> (lookup LL FF = Some TT)) \<and>
                            ((h<a\<bullet>DOLLAR> \<noteq> 0) \<longrightarrow> (lookup RR FF = Some TT)))))"

lemma LETGETFR1:
"\<lbrakk>G \<rhd> e : \<lbrace>U, n, C(x\<mapsto>\<^sub>f(muET TT)) \<ggreater> T, m\<rbrace>; GETr C l = Some(muET T1); 
        subst T1 (muET T1) (sumET (kL,recET L) (kR,recET RR)); 
        rfldAP (varAP l) F \<notin> U; \<forall> E h . (myProp E h l L RR (rfldn F) (muET TT));
        \<forall> p. p:U \<longrightarrow> root p = x \<longrightarrow> p=varAP x\<rbrakk>
      \<Longrightarrow>  G \<rhd> (LET rf x = l\<diamondsuit>F IN e END) : \<lbrace>(U-{varAP x}) \<union> {rfldAP (varAP l) F}, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule LETR)
prefer 2 apply assumption
prefer 2 apply (subgoal_tac "{rfldAP (varAP l) F} \<inter> (U - {varAP x}) = {}", assumption, fast)
prefer 2 apply fast
prefer 2 apply fast
prefer 2 apply fastsimp
apply (rule vdm_conseq, rule vdm_getfr)
apply clarsimp
apply (erule thin_rl)
apply (erule_tac x=E in allE, erule_tac x=h in allE, simp add: myProp_def)
apply (simp add: DAss_def, clarsimp)
  apply (erule Yps.elims, clarsimp+) 
  apply (erule Yps.elims, clarsimp) prefer 2 apply clarsimp 
  apply (case_tac "locns h\<lfloor>a\<diamondsuit>F\<rfloor> \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (rule_tac x=RR1 in exI)
  apply (rule_tac x=N1 in exI)
  apply (rule_tac x=N in exI)
  apply (rule_tac x=Fa in exI, simp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
    apply (erule lookupAP.elims, simp_all, clarsimp)
    apply (drule subst_unique, assumption, clarsimp+)
    apply (case_tac "h<laa\<bullet>DOLLAR> = 0", clarsimp+)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all)
done
lemma LETGETFR2:
 "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C(x\<mapsto>\<^sub>f(muET TT)) \<ggreater> T, m\<rbrace>; GETr C l = Some(muET T1); 
        subst T1 (muET T1) (sumET (kL,recET L) (kR,recET RR)); 
        rfldAP (varAP l) F \<notin> U; 
        lookup L (rfldn F) = Some (muET TT);
        lookup RR (rfldn F) = Some (muET TT);
        \<forall> p. p:U \<longrightarrow> root p = x \<longrightarrow> p=varAP x\<rbrakk>
      \<Longrightarrow>  G \<rhd> (LET rf x = l\<diamondsuit>F IN e END) : \<lbrace>(U-{varAP x}) \<union> {rfldAP (varAP l) F}, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule LETR)
prefer 2 apply assumption
prefer 2 apply (subgoal_tac "{rfldAP (varAP l) F} \<inter> (U - {varAP x}) = {}", assumption, fast)
prefer 2 apply fast
prefer 2 apply fast
prefer 2 apply fastsimp
apply (rule vdm_conseq, rule vdm_getfr)
apply clarsimp
apply (erule thin_rl)
(*apply (erule_tac x=E in allE, erule_tac x=h in allE, simp add: myProp_def)*)
apply (simp add: DAss_def, clarsimp)
  apply (erule Yps.elims, clarsimp+) 
  apply (erule Yps.elims, clarsimp) prefer 2 apply clarsimp 
  apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (case_tac "locns h\<lfloor>a\<diamondsuit>F\<rfloor> \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (rule_tac x=RR1 in exI)
  apply (rule_tac x=N1 in exI)
  apply (rule_tac x=N in exI)
  apply (rule_tac x=Fa in exI, simp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (drule subst_unique, assumption, clarsimp+)
  apply (case_tac "h<laa\<bullet>DOLLAR> = 0", clarsimp+)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all)
done

lemma LETGETFR:
"\<lbrakk>G \<rhd> e : \<lbrace>U, n, C(x\<mapsto>\<^sub>f(muET TT)) \<ggreater> T, m\<rbrace>; GETr C l = Some(recET RR); 
        rfldAP (varAP l) F \<notin> U; lookup RR (rfldn F) = Some (muET TT);
        \<forall> p. p:U \<longrightarrow> root p = x \<longrightarrow> p=varAP x\<rbrakk>
      \<Longrightarrow>  G \<rhd> (LET rf x = l\<diamondsuit>F IN e END) : \<lbrace>(U-{varAP x}) \<union> {rfldAP (varAP l) F}, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule LETR)
prefer 2 apply assumption
prefer 2 apply (subgoal_tac "{rfldAP (varAP l) F} \<inter> (U - {varAP x}) = {}", assumption, fast)
prefer 2 apply fast
prefer 2 apply fast
prefer 2 apply fastsimp
apply (rule vdm_conseq, rule vdm_getfr)
apply clarsimp
apply (erule thin_rl)
apply (simp add: DAss_def, clarsimp)
  apply (erule Yps.elims, clarsimp+) 
  apply (erule Yps.elims, clarsimp) prefer 2 apply clarsimp 
  apply (case_tac "a:Dom h", clarsimp) prefer 2 apply clarsimp
  apply (case_tac "locns h\<lfloor>a\<diamondsuit>F\<rfloor> \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (rule_tac x=RR1 in exI)
  apply (rule_tac x=N1 in exI)
  apply (rule_tac x=N in exI)
  apply (rule_tac x=Fa in exI, simp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all)
done

lemma LETGETFR1_Node:
"\<lbrakk>G \<rhd> e : \<lbrace>U, n, C(x\<mapsto>\<^sub>f(muET TT)) \<ggreater> T, m\<rbrace>; GETr C l = Some(nodeET (k,muET T1)); 
        subst T1 (muET T1) (sumET (kL,recET L) (kR,recET RR)); 
        rfldAP (varAP l) F \<notin> U; \<forall> E h . (myProp E h l L RR (rfldn F) (muET TT));
        \<forall> p. p:U \<longrightarrow> root p = x \<longrightarrow> p=varAP x\<rbrakk>
      \<Longrightarrow>  G \<rhd> (LET rf x = l\<diamondsuit>F IN e END) : \<lbrace>(U-{varAP x}) \<union> {rfldAP (varAP l) F}, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule LETR)
prefer 2 apply assumption
prefer 2 apply (subgoal_tac "{rfldAP (varAP l) F} \<inter> (U - {varAP x}) = {}", assumption, fast)
prefer 2 apply fast
prefer 2 apply fast
prefer 2 apply fastsimp
apply (rule vdm_conseq, rule vdm_getfr)
apply clarsimp
apply (erule thin_rl)
apply (erule_tac x=E in allE, erule_tac x=h in allE, simp add: myProp_def)
apply (simp add: DAss_def, clarsimp)
  apply (erule Yps.elims, clarsimp+) 
  apply (erule Yps.elims, clarsimp) prefer 2 apply clarsimp 
  apply (case_tac "locns h\<lfloor>a\<diamondsuit>F\<rfloor> \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (rule_tac x=RR1 in exI)
  apply (rule_tac x=N1 in exI)
  apply (rule_tac x=N in exI)
  apply (rule_tac x=Fa in exI, simp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
    apply (erule lookupAP.elims, simp_all, clarsimp+)
    apply (erule lookupAP.elims, simp_all, clarsimp+)
    apply (erule lookupAP.elims, simp_all, clarsimp+)
    apply (erule lookupAP.elims, simp_all)
done
lemma LETGETFR2_Node:
 "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C(x\<mapsto>\<^sub>f(muET TT)) \<ggreater> T, m\<rbrace>; GETr C l = Some(nodeET (k, muET T1)); 
        subst T1 (muET T1) (sumET (kL,recET L) (kR,recET RR)); 
        rfldAP (varAP l) F \<notin> U; 
        lookup L (rfldn F) = Some (muET TT);
        lookup RR (rfldn F) = Some (muET TT);
        \<forall> p. p:U \<longrightarrow> root p = x \<longrightarrow> p=varAP x\<rbrakk>
      \<Longrightarrow>  G \<rhd> (LET rf x = l\<diamondsuit>F IN e END) : \<lbrace>(U-{varAP x}) \<union> {rfldAP (varAP l) F}, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule LETR)
prefer 2 apply assumption
prefer 2 apply (subgoal_tac "{rfldAP (varAP l) F} \<inter> (U - {varAP x}) = {}", assumption, fast)
prefer 2 apply fast
prefer 2 apply fast
prefer 2 apply fastsimp
apply (rule vdm_conseq, rule vdm_getfr)
apply clarsimp
apply (erule thin_rl)
(*apply (erule_tac x=E in allE, erule_tac x=h in allE, simp add: myProp_def)*)
apply (simp add: DAss_def, clarsimp)
  apply (erule Yps.elims, clarsimp+) 
  apply (erule Yps.elims, clarsimp) prefer 2 apply clarsimp 
  apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (case_tac "locns h\<lfloor>a\<diamondsuit>F\<rfloor> \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (rule_tac x=RR1 in exI)
  apply (rule_tac x=N1 in exI)
  apply (rule_tac x=N in exI)
  apply (rule_tac x=Fa in exI, simp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all)
done

lemma LETGETFR_Node:
"\<lbrakk>G \<rhd> e : \<lbrace>U, n, C(x\<mapsto>\<^sub>f(muET TT)) \<ggreater> T, m\<rbrace>; 
  GETr C l = Some(nodeET(k,recET RR)); 
  rfldAP (varAP l) F \<notin> U; lookup RR (rfldn F) = Some (muET TT);
  \<forall> p. p:U \<longrightarrow> root p = x \<longrightarrow> p=varAP x\<rbrakk>
 \<Longrightarrow>  G \<rhd> (LET rf x = l\<diamondsuit>F IN e END) : \<lbrace>(U-{varAP x}) \<union> {rfldAP (varAP l) F}, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule LETR)
prefer 2 apply assumption
prefer 2 apply (subgoal_tac "{rfldAP (varAP l) F} \<inter> (U - {varAP x}) = {}", assumption, fast)
prefer 2 apply fast
prefer 2 apply fast
prefer 2 apply fastsimp
apply (rule vdm_conseq, rule vdm_getfr)
apply clarsimp
apply (erule thin_rl)
apply (simp add: DAss_def, clarsimp)
  apply (erule Yps.elims, clarsimp+) 
  apply (erule Yps.elims, clarsimp) prefer 2 apply clarsimp 
  apply (case_tac "a:Dom h", clarsimp) prefer 2 apply clarsimp
  apply (case_tac "locns h\<lfloor>a\<diamondsuit>F\<rfloor> \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (rule_tac x=RR1 in exI)
  apply (rule_tac x=N1 in exI)
  apply (rule_tac x=N in exI)
  apply (rule_tac x=Fa in exI, simp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (erule lookupAP.elims, simp_all)
done

lemma "GETr C l = Some(recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]) \<Longrightarrow>
       G \<rhd> (LET h = l\<bullet>HD; rf t = l\<diamondsuit>TL IN RVar t END) : \<lbrace>{rfldAP (varAP l) TL}, m, C \<ggreater> iList HD TL kN kC, m\<rbrace>"
apply (rule WEAK)
apply (rule LETGETFI)
prefer 2 apply simp
prefer 2 apply simp
apply (rule LETGETFR)
prefer 2 apply simp
prefer 3 apply (simp add: iList_def)
apply (rule RVAR)
apply (simp add: iList_def GETr_def)
apply simp
apply simp
apply simp
done

lemma "\<lbrakk>GETr C l = Some(recET [(rfldn TL,iList HD TL kN kC), (rfldn RR,iTree I TL RR kL kR)]); 
        h \<noteq> l; TL \<noteq> RR;t \<noteq> h;l \<noteq> h\<rbrakk> \<Longrightarrow>
       G \<rhd> (LET rf h = l\<diamondsuit>TL; rf t = l\<diamondsuit>RR IN RVar h END) : \<lbrace>{rfldAP (varAP l) TL,rfldAP (varAP l) RR}, m, C \<ggreater> iList HD TL kN kC, m\<rbrace>"
apply (rule WEAK)
apply (rule LETGETFR)
prefer 2 apply simp
prefer 3 apply (simp add: iList_def)
apply (rule LETGETFR)
prefer 2 apply (erule GETr_Update2, simp)
prefer 3 apply (simp add: iTree_def)
apply (rule RVAR) apply (rule GETr_Update2) 
                  apply (simp add: iList_def GETr_def)
                  apply simp
apply simp
apply simp
apply simp
apply simp
apply fastsimp
done

lemma "GETr C l = Some(nodeET(k,recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)])) \<Longrightarrow>
       G \<rhd> (LET h = l\<bullet>HD; rf t = l\<diamondsuit>TL IN RVar t END) : \<lbrace>{rfldAP (varAP l) TL}, m, C \<ggreater> iList HD TL kN kC, m\<rbrace>"
apply (rule WEAK)
apply (rule LETGETFI_Node)
prefer 2 apply fastsimp
prefer 2 apply simp
apply (rule LETGETFR_Node)
prefer 2 apply fastsimp
prefer 3 apply (simp add: iList_def)
apply (rule RVAR)
apply (simp add: iList_def GETr_def)
apply simp
apply simp
apply simp
done

lemma "\<lbrakk>GETr C l = Some(nodeET(k,recET [(rfldn TL,iList HD TL kN kC), (rfldn RR,iTree I TL RR kL kR)])); 
        h \<noteq> l; TL \<noteq> RR;t \<noteq> h;l \<noteq> h\<rbrakk> \<Longrightarrow>
       G \<rhd> (LET rf h = l\<diamondsuit>TL; rf t = l\<diamondsuit>RR IN RVar h END) : \<lbrace>{rfldAP (varAP l) TL,rfldAP (varAP l) RR}, m, C \<ggreater> iList HD TL kN kC, m\<rbrace>"
apply (rule WEAK)
apply (rule LETGETFR_Node)
prefer 2 apply fastsimp
prefer 3 apply (simp add: iList_def)
apply (rule LETGETFR_Node)
prefer 2 apply (erule GETr_Update2, simp)
prefer 3 apply (simp add: iTree_def)
apply (rule RVAR) apply (rule GETr_Update2) 
                  apply (simp add: iList_def GETr_def)
                  apply simp
apply simp
apply simp
apply simp
apply simp
apply fastsimp
done

lemma "\<lbrakk>(E,h,{nodeAP x, rfldAP (varAP x) TL},C(x\<mapsto>\<^sub>f(nodeET(kC,recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]))),L,R,N) : Yps;
        evalAP (varAP x) E h = Some(Ref l,{l}); h<l\<bullet>DOLLAR> \<noteq> 0\<rbrakk>
       \<Longrightarrow> (E,h,{varAP x},C(x\<mapsto>\<^sub>f(iList HD TL kN kC)),L,R,N) : Yps"
apply (frule Yps_regionsExist, rule) 
  apply (subgoal_tac "nodeAP x\<in> {nodeAP x, rfldAP (varAP x) TL}", assumption, fast)
  apply (rule lookupAP_Node) apply (simp add: GETr_def) apply fastsimp
apply clarsimp
apply (drule Yps_split, rule)
  apply (subgoal_tac "nodeAP x\<in> {nodeAP x, rfldAP (varAP x) TL}", assumption, fast)
  apply (rule lookupAP_Node) apply (simp add: GETr_def) apply fastsimp
  apply fastsimp
  apply assumption
apply clarsimp
apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (frule Yps_regionsExist, rule) 
  apply fast
  apply (rule lookupAP_RfldNode) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def) apply fastsimp
    apply simp apply (rule, fast, fast)
    apply simp
apply clarsimp
apply (case_tac "locns h\<lfloor>l\<diamondsuit>TL\<rfloor> \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (drule Yps_split, rule)
  apply fast
  apply (rule lookupAP_RfldNode) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def) apply fastsimp
    apply simp apply (rule, fast, fast)
    apply simp
    apply simp apply (rule, fast) apply (subgoal_tac "{la,l}={la,l}", assumption, fast)
    apply assumption
apply (erule exE)+
apply (erule conjE)+
apply (erule modelsET.elims, simp_all) apply clarsimp 
done
(*the following lemma does not hold since the L-regions of rfldAP x F paths overlaps with the
R-region of nodeAP x paths
lemma "\<lbrakk>(E,h,{varAP x},C(x\<mapsto>\<^sub>f(iList HD TL kN kC)),L,R,N) : Yps;
        evalAP (varAP x) E h = Some(Ref l,{l}); h<l\<bullet>DOLLAR> \<noteq> 0\<rbrakk>
       \<Longrightarrow> (E,h,{nodeAP x, rfldAP (varAP x) TL},C(x\<mapsto>\<^sub>f(nodeET(kC,recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]))),L,R,N) : Yps"
apply (frule Yps_regionsExist, rule) 
  apply fast
  apply (rule lookupAP_Var) apply (simp add: GETr_def) 
apply clarsimp
apply (drule Yps_split, rule)
  apply fast
  apply (rule lookupAP_Var) apply (simp add: GETr_def) 
  apply fastsimp
  apply assumption
apply clarsimp
apply (case_tac "locns (renv E x) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (erule Yps.elims, simp_all, clarsimp)
apply (rule Yps_CONS)
  apply (subgoal_tac "nodeAP x \<in> {nodeAP x, rfldAP (varAP x) TL}", assumption, fast)
  apply (rule lookupAP_Node) apply (simp add: GETr_def) apply fastsimp
  apply fastsimp
  apply (subgoal_tac "(RVal (Ref l), h, nodeET (kC, recET [(ifldn HD, intET), (rfldn TL, iList HD TL kN kC)]), {l}, kC)
               \<in> modelsET", assumption)
    apply (rule modelsETNode)  apply (erule modelsET.elims, simp+) 
    apply (subgoal_tac "(E, h, {rfldAP (varAP x) TL}, C(x\<mapsto>\<^sub>fnodeET (kC, recET [(ifldn HD, intET), (rfldn TL, iList HD TL kN kC)])),
                {l}, RR-{l}, SS-kC) \<in> Yps", assumption)
defer 1
apply fast
apply fast
apply fast
apply fast
apply (drule modelsETLocn, simp) apply fast
apply (subgoal_tac "kC \<le> SS") apply simp 
  apply (simp add: iList_def)
    apply (erule modelsET.elims, simp_all, clarsimp)
      apply (erule modelsET.elims, simp_all)
(-now the deferred goal-)
apply (simp add: iList_def)
apply (erule modelsET.elims, simp_all, clarsimp)
apply (erule modelsET.elims, simp_all, clarsimp)
apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)+
prefer 2
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)+
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (drule TpTriv, simp)
apply (erule modelsET.elims, simp_all, clarsimp)
apply (rotate_tac -3)
apply (erule modelsET.elims, simp_all, clarsimp)
apply (rotate_tac -3)
apply (erule modelsET.elims, simp_all, clarsimp)
apply (rotate_tac -2)
apply (frule modelsET_isLocn, clarsimp)
apply (frule modelsET_region_in_heap)
apply (frule modelsETLocn, simp) 
apply (rotate_tac -5, erule thin_rl)
apply (rule Yps_CONS)
  apply fast
  apply (rule lookupAP_RfldNode) apply (rule lookupAP_Var, simp add: GETr_def, fastsimp)
    apply fastsimp
    apply simp
    apply clarsimp apply (rule, clarsimp)
     apply (subgoal_tac "la=la \<and> {la,l}={la,l}", assumption, fast)
     apply fast
    apply assumption
    apply clarsimp apply (rule Yps_NIL, simp, simp)
    apply simp
    apply simp
    apply simp
defer 1
apply (erule modelsET.elims, simp+)
apply (erule modelsET.elims, simp+)
    apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)+
    prefer 2
      apply clarsimp
      apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)+
      apply (erule modelsET.elims, simp_all)
      apply (erule modelsET.elims, simp_all, clarsimp+)
      apply (erule modelsET.elims, simp_all, clarsimp+)
      apply (drule TpTriv) apply simp
    apply (erule modelsET.elims, simp_all, clarsimp+)
    apply (rotate_tac -3)
    apply (erule modelsET.elims, simp_all, clarsimp+)
    apply (rotate_tac -3)
    apply (erule modelsET.elims, simp_all, clarsimp+)
    apply (rotate_tac -2)
    apply (frule modelsET_isLocn, clarsimp)
    apply (frule modelsET_region_in_heap)
  apply (frule modelsETLocn, simp) 
apply (rule Yps_CONS) 
  apply (subgoal_tac "nodeAP x \<in> {nodeAP x, rfldAP (varAP x) TL}", assumption, fast)
  apply (rule lookupAP_Node) apply (simp add: GETr_def) apply fastsimp
  apply simp apply (subgoal_tac "l=l \<and> {l} ={l}", assumption, fast)
  apply (erule modelsETNode) apply (simp, simp)
  apply clarsimp
    apply (rule Yps_CONS)
      apply fast
      apply (rule lookupAP_RfldNode)
        apply (rule lookupAP_Var, simp add: GETr_def, fastsimp) 
        apply simp apply (subgoal_tac "l=l \<and> {l} = {l}", assumption, fast)
        apply simp
    apply simp apply (rule, clarsimp)
      apply (subgoal_tac "la = la \<and> {la,l}={la,l}", assumption, fast)
      apply fast
    apply assumption
    apply clarsimp apply (rule Yps_NIL, simp, simp)
    apply simp
    apply simp
    apply simp 
    apply simp
    apply simp
    apply simp
    apply 
  apply (drule TpTriv)
apply (rotate_tac -2)
apply (rule modelsET.elims, simp_all, clarsimp+)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)+
apply (rule modelsET.elims, simp_all add: iList_def, clarsimp+)
  apply (erule substitution_listsubstitution.elims, simp_all)

apply (rule modelsET.elims, simp_all, clarsimp+)
apply (rule modelsET.elims, simp_all, clarsimp+)
apply (frule Yps_regionsExist, rule) 
  apply fast
  apply (rule lookupAP_RfldNode) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def) apply fastsimp
    apply simp apply (rule, fast, fast)
    apply simp
apply clarsimp
apply (case_tac "locns h\<lfloor>l\<diamondsuit>TL\<rfloor> \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (drule Yps_split, rule)
  apply fast
  apply (rule lookupAP_RfldNode) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def) apply fastsimp
    apply simp apply (rule, fast, fast)
    apply simp
    apply simp apply (rule, fast) apply (subgoal_tac "{la,l}={la,l}", assumption, fast)
    apply assumption
apply (erule exE)+
apply (erule conjE)+
apply (erule modelsET.elims, simp_all) apply clarsimp 
done
apply simp apply simp apply simp
apply clarify

apply (rule Yps_CONS, fast)
  apply (rule lookupAP_Var) apply (simp add: GETr_def) 
  apply simp apply (subgoal_tac "l=l \<and> {l}={l}", assumption,fast)
  apply (simp add: iList_def)
  apply (rule modelsETMu) 
  apply fastsimp
  apply assumption
apply clarsimp
apply (rule modelsETNode)
apply (frule Yps_contains_region)
done
*)

constdefs P::"AP set \<Rightarrow> rname \<Rightarrow> bool"
" P U z == (\<forall> p. p:U \<longrightarrow> ((\<forall> y F . p = rfldAP y F \<longrightarrow> y = varAP z) \<and> (\<forall> x . p = nodeAP x \<longrightarrow> x=z)))"

lemma "\<lbrakk>G \<rhd> e : \<lbrace>U,n,C(l\<mapsto>\<^sub>f(nodeET(k,recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]))) \<ggreater> T, m\<rbrace>;
        {nodeAP l, rfldAP (varAP l) TL} \<subseteq> U;
        varAP l \<notin> U;
        P U l;
        V = (U - {nodeAP l, rfldAP (varAP l) TL}) \<union> {varAP l}\<rbrakk> \<Longrightarrow>
       G \<rhd> e : \<lbrace>V,n,C(l\<mapsto>\<^sub>f(iList HD TL kN kC)) \<ggreater> T, m\<rbrace>"
apply (erule vdm_conseq, simp add: DAss_def, clarsimp)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE)
prefer 2 apply assumption
apply (rule_tac x=N in exI, simp)
apply (rule_tac x=Pa in exI, rule_tac x=L in exI, simp)
apply (frule Yps_regionsExist, rule)
  apply (subgoal_tac "varAP l \<in> insert (varAP l) (U - {nodeAP l, rfldAP (varAP l) TL})", assumption, fast)
  apply (rule lookupAP_Var, simp add: GETr_def)
apply clarsimp
apply (case_tac "locns (renv E l) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (drule Yps_split, rule)
  apply (subgoal_tac "varAP l \<in> insert (varAP l) (U - {nodeAP l, rfldAP (varAP l) TL})", assumption, fast)
  apply (rule lookupAP_Var, simp add: GETr_def)
  apply fastsimp
  apply assumption
apply clarsimp
apply (simp add: iList_def)
apply (erule modelsET.elims, simp_all, clarsimp)
apply (erule modelsET.elims, simp_all, clarsimp)
apply (case_tac "h<la\<bullet>DOLLAR> = 0")
prefer 2 (*this branch does not hold*)
  apply clarsimp 
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)+
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (rotate_tac -3)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (rotate_tac -3)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (frule modelsET_isLocn, clarsimp)
  prefer 2
    apply (erule modelsET.elims, simp_all, clarsimp)
    apply (erule modelsET.elims, simp_all, clarsimp)
    apply (erule modelsET.elims, simp_all, clarsimp)
    apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)+
    apply (drule TpTriv, simp)
  apply (erule Yps_CONS)
    apply (rule lookupAP_Node) apply (simp add: GETr_def) apply simp apply fastsimp
    apply simp apply (subgoal_tac "la = la \<and> {la} = {la}", assumption, simp)
    apply (erule modelsETNode) apply (simp, simp)
    apply (rule Yps_CONS) 
      apply (subgoal_tac "rfldAP (varAP l) TL : U - {nodeAP l}", assumption, fast)
      apply (rule lookupAP_RfldNode)
        apply (rule lookupAP_Var) apply (simp add: GETr_def, fastsimp)
        apply simp apply (subgoal_tac "la = la \<and> {la} = {la}", assumption, simp)
        apply simp
      apply simp apply rule apply clarsimp apply (subgoal_tac "lb = lb \<and> {lb,la} = {lb,la}", assumption, simp)
                          apply (subgoal_tac "lb : reg1a") apply (subgoal_tac "reg1a \<subseteq> Dom ha",fast) 
                            apply(erule modelsET_region_in_heap) apply(erule modelsETLocn, simp)
      apply assumption
      apply (subgoal_tac "U - {nodeAP l} - {rfldAP (varAP l) TL} = U - {nodeAP l, rfldAP (varAP l) TL}", clarsimp)
        prefer 2 apply fast
        apply (erule YpsPreservedU) 
          apply simp
        prefer 2 (*needs another precondition*) apply (subgoal_tac "lb : reg1a", fast) apply (erule modelsETLocn, simp)
        prefer 2 (*needs another precondition*) apply fast
        prefer 2 (*needs another precondition*) apply fast
        prefer 2 (*needs another precondition*) apply simp
        prefer 2 (*needs another precondition*) apply simp
        prefer 2 (*needs another precondition*) apply simp
        prefer 2 (*needs another precondition*) apply fast
        prefer 2 (*needs another precondition*) apply fast


    apply (erule modelsETNode) apply (simp, simp)

done
match rules

lemma Match_Aux1[rule_format]:
"\<forall> S . (C, x, E, h, S) \<in> lookupAP \<longrightarrow> 
       (\<forall> z U kL T1 kR T2 a TT. z= root x \<longrightarrow> varAP z \<notin> U \<longrightarrow> 
                             GETr C (root x) = Some (sumET (kL, recET T1) (kR, recET T2)) \<longrightarrow>
                             renv E z = Ref a \<longrightarrow> x \<in> U \<longrightarrow> P U z \<longrightarrow>
                             ((h<a\<bullet>DOLLAR> = 0 \<longrightarrow> TT=T1) \<and> (h<a\<bullet>DOLLAR> \<noteq> 0 \<longrightarrow> TT=T2)) \<longrightarrow>
                             (C(z\<mapsto>\<^sub>f(recET TT)), x, E, h, S) \<in> lookupAP)"
apply (induct x)
apply clarsimp
apply clarsimp
  apply (erule lookupAP.elims, clarsimp+)
apply (subgoal_tac "AP=varAP (root AP)", clarsimp)
prefer 2 apply (simp add: P_def)
apply (erule lookupAP.elims,simp_all)
  apply clarsimp
    apply (erule lookupAP.elims,simp_all)
  apply clarsimp
    apply (subgoal_tac "a=l", clarsimp) prefer 2 apply (case_tac p,clarsimp+)
      apply (case_tac "a \<in> Dom h", clarsimp+) 
      apply (subgoal_tac "(C(root p\<mapsto>\<^sub>frecET TT), rfldAP (varAP (root p)) F, E, h, TTa) \<in> lookupAP", simp)
       apply (rule lookupAP_Rec)?? 
       apply (rule lookupAP_Var) apply (simp add: GETr_def)
          apply fastsimp
          apply clarsimp
          apply (subgoal_tac "(C, varAP (root p), E, h, sumET (aa, b) (ab, ba)) \<in> lookupAP")
          prefer 2 apply simp
          apply (rotate_tac -1, erule lookupAP.elims, simp_all, clarsimp)
          apply (case_tac "l \<in> Dom h", clarsimp) 
          apply (case_tac "h<l\<bullet>DOLLAR> = 0", clarsimp+)
  apply (subgoal_tac "(C(root p\<mapsto>\<^sub>frecET TT), rfldAP (varAP (root p)) F, E, h, TTa) \<in> lookupAP", simp)
       apply (rule lookupAP_Rec) 
       apply (rule lookupAP_Var) apply (simp add: GETr_def)
          apply fastsimp
          apply clarsimp
          apply (subgoal_tac "(C, varAP (root p), E, h, recET T) \<in> lookupAP")
          prefer 2 apply simp
          apply (rotate_tac -1, erule lookupAP.elims, simp_all)
done

lemma Match_Aux2[rule_format]:
"\<forall> S . (D, x, E, h, S) \<in> lookupAP \<longrightarrow> 
       (\<forall> C z U kL T1 kR T2 a TT. D=C(z\<mapsto>\<^sub>f(recET TT)) \<longrightarrow> z= root x \<longrightarrow> varAP z \<notin> U \<longrightarrow> 
                             GETr C (root x) = Some (sumET (kL, recET T1) (kR, recET T2)) \<longrightarrow>
                             renv E z = Ref a \<longrightarrow> x \<in> U \<longrightarrow> P U z \<longrightarrow>
                             ((h<a\<bullet>DOLLAR> = 0 \<longrightarrow> TT=T1) \<and> (h<a\<bullet>DOLLAR> \<noteq> 0 \<longrightarrow> TT=T2)) \<longrightarrow>
                             (C, x, E, h, S) \<in> lookupAP)"
apply (induct x)
apply clarsimp
apply clarsimp
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (simp add: GETr_def)
apply clarsimp
apply (subgoal_tac "AP=varAP (root AP)", clarsimp)
prefer 2 apply (simp add: P_def)
apply (erule lookupAP.elims,simp_all)
  apply clarsimp
    apply (erule lookupAP.elims,simp_all, clarsimp) apply (simp add: GETr_def)
  apply clarsimp
      apply (subgoal_tac "(C(root p\<mapsto>\<^sub>frecET TT), varAP (root p), E, h, sumET (aa, b) (ab, ba)) \<in> lookupAP")
      prefer 2 apply simp
      apply (rotate_tac -1) apply (erule lookupAP.elims, simp_all, clarsimp) apply (simp add: GETr_def)
  apply clarsimp
      apply (subgoal_tac "(C(root p\<mapsto>\<^sub>frecET TT), varAP (root p), E, h, recET T) \<in> lookupAP")
      prefer 2 apply simp
      apply (rotate_tac -1) apply (erule lookupAP.elims, simp_all, clarsimp) apply (simp add: GETr_def)
      apply clarsimp
      apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
      apply (rule lookupAP_Sum??)
       apply (rule lookupAP_Var) apply (simp add: GETr_def)
          apply fastsimp
          apply fastsimp
          apply simp
          apply (case_tac "h<l\<bullet>DOLLAR> = 0", clarsimp, clarsimp)
done

lemma "\<lbrakk>GETr C x = Some (sumET (kL,recET T1) (kR,recET T2));
        G \<rhd> e1 : \<lbrace>U,n,C(x\<mapsto>\<^sub>f(recET T1)) \<ggreater> T, m\<rbrace>;
        G \<rhd> e2 : \<lbrace>U,n,C(x\<mapsto>\<^sub>f(recET T2)) \<ggreater> T, m\<rbrace>;
        varAP x \<notin> U; P U x\<rbrakk>
       \<Longrightarrow>
        G \<rhd> (LET t = x\<bullet>DOLLAR; b = Primop (\<lambda> x y . if x=0 then 1 else 0) t t IN IF b THEN e1 ELSE e2 END): \<lbrace>U,n,C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
apply (rule vdm_leti, rule vdm_prim)
apply (rule vdm_if) apply assumption apply assumption
apply (rotate_tac 1, erule thin_rl, erule thin_rl) 
apply clarsimp
apply (case_tac"h<a\<bullet>DOLLAR> = 0" )
  apply clarsimp apply (rule DAssC_PConst)
                 apply (rule DAss_Contexts_same_on_U) apply (erule DAss_PreservedU, rule, simp)
    apply clarsimp
    apply (case_tac "root xa = x") 
    prefer 2 apply rule apply (erule lookupAP_Update2, fast) apply (erule lookupAP_Update3, assumption, simp) 
    apply clarsimp apply rule apply (erule Match_Aux1) apply simp apply assumption+ apply clarsimp
                              apply (erule Match_Aux2) apply (simp, simp) apply assumption+ apply clarsimp
  apply clarsimp apply (rule DAssC_PConst)
                 apply (rule DAss_Contexts_same_on_U) apply (erule DAss_PreservedU, rule, simp)
    apply clarsimp
    apply (case_tac "root xa = x") 
    prefer 2 apply rule apply (erule lookupAP_Update2, fast) apply (erule lookupAP_Update3, assumption, simp) 
    apply clarsimp apply rule apply (erule Match_Aux1) apply simp apply assumption+ apply clarsimp
                              apply (erule Match_Aux2) apply (simp, simp) apply assumption+ apply clarsimp
done
                   

lemma Match_Aux1a[rule_format]:
"\<forall> S . (C, x, E, h, S) \<in> lookupAP \<longrightarrow> 
       (\<forall> z U kL T1 kR T2 a TT. z= root x \<longrightarrow> varAP z \<notin> U \<longrightarrow> 
                             GETr C (root x) = Some (muET SS) \<longrightarrow>
                             subst SS (muET SS) (sumET (kL,recET T1) (kR,recET T2)) \<longrightarrow>
                             renv E z = Ref a \<longrightarrow> x \<in> U \<longrightarrow> P U z \<longrightarrow>
                             ((h<a\<bullet>DOLLAR> = 0 \<longrightarrow> TT=T1) \<and> (h<a\<bullet>DOLLAR> \<noteq> 0 \<longrightarrow> TT=T2)) \<longrightarrow>
                             (C(z\<mapsto>\<^sub>f(recET TT)), x, E, h, S) \<in> lookupAP)"
apply (induct x)
apply clarsimp
apply clarsimp
  apply (erule lookupAP.elims, simp_all)
apply clarsimp
apply (subgoal_tac "AP=varAP (root AP)", clarsimp)
prefer 2 apply (simp add: P_def)
apply (erule lookupAP.elims,simp_all)
  apply clarsimp
    apply (erule lookupAP.elims,simp_all) apply clarsimp
    apply (drule subst_unique, assumption, clarsimp)
    apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
    apply (rule lookupAP_Rec) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def) apply fastsimp
    apply (case_tac "h<l\<bullet>DOLLAR> = 0", clarsimp,clarsimp)
  apply clarsimp
    apply (subgoal_tac "a=l", clarsimp) prefer 2 apply (case_tac p,clarsimp+)
    apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
    apply (case_tac "a \<in> Dom h", clarsimp) apply clarsimp
    apply (subgoal_tac "(C(root p\<mapsto>\<^sub>frecET TT), rfldAP (varAP (root p)) F, E, h, TTa) \<in> lookupAP", simp)
    apply (rule lookupAP_Rec) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def)
    apply fastsimp
    apply clarsimp
    apply (subgoal_tac "(C, varAP (root p), E, h, sumET (aa, b) (ab, ba)) \<in> lookupAP")
    prefer 2 apply simp
    apply (rotate_tac -1, erule lookupAP.elims, simp_all, clarsimp)
  apply (subgoal_tac "(C(root p\<mapsto>\<^sub>frecET TT), rfldAP (varAP (root p)) F, E, h, TTa) \<in> lookupAP", simp)
    apply (rule lookupAP_Rec) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def)
    apply fastsimp
    apply clarsimp
    apply (subgoal_tac "(C, varAP (root p), E, h, recET T) \<in> lookupAP")
    prefer 2 apply simp
    apply (rotate_tac -1, erule lookupAP.elims, simp_all)
done

lemma Match_Aux2a[rule_format]:
"\<forall> S . (D, x, E, h, S) \<in> lookupAP \<longrightarrow> 
       (\<forall> C z U kL T1 kR T2 a TT. D=C(z\<mapsto>\<^sub>f(recET TT)) \<longrightarrow> z= root x \<longrightarrow> varAP z \<notin> U \<longrightarrow> 
                             GETr C (root x) = Some (muET SS) \<longrightarrow>
                             subst SS (muET SS) (sumET (kL,recET T1) (kR,recET T2)) \<longrightarrow>
                             renv E z = Ref a \<longrightarrow> x \<in> U \<longrightarrow> P U z \<longrightarrow>
                             ((h<a\<bullet>DOLLAR> = 0 \<longrightarrow> TT=T1) \<and> (h<a\<bullet>DOLLAR> \<noteq> 0 \<longrightarrow> TT=T2)) \<longrightarrow>
                             (C, x, E, h, S) \<in> lookupAP)"
apply (induct x)
apply clarsimp
apply clarsimp
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (simp add: GETr_def)
apply clarsimp
apply (subgoal_tac "AP=varAP (root AP)", clarsimp)
prefer 2 apply (simp add: P_def)
apply (erule lookupAP.elims,simp_all)
  apply clarsimp
    apply (erule lookupAP.elims,simp_all, clarsimp) apply (simp add: GETr_def)
  apply clarsimp
      apply (subgoal_tac "(C(root p\<mapsto>\<^sub>frecET TT), varAP (root p), E, h, sumET (aa, b) (ab, ba)) \<in> lookupAP")
      prefer 2 apply simp
      apply (rotate_tac -1) apply (erule lookupAP.elims, simp_all, clarsimp) apply (simp add: GETr_def)
  apply clarsimp
      apply (subgoal_tac "(C(root p\<mapsto>\<^sub>frecET TT), varAP (root p), E, h, recET T) \<in> lookupAP")
      prefer 2 apply simp
      apply (rotate_tac -1) apply (erule lookupAP.elims, simp_all, clarsimp) apply (simp add: GETr_def)
      apply clarsimp
      apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
      apply (rule lookupAP_Mu)
       apply (rule lookupAP_Var) apply (simp add: GETr_def)
          apply fastsimp
          apply fastsimp
          apply simp
          apply (case_tac "h<l\<bullet>DOLLAR> = 0", clarsimp, clarsimp)
done

lemma Match:
      "\<lbrakk>GETr C x = Some (muET S);
        subst S (muET S) (sumET (kL,recET T1) (kR,recET T2));
        G \<rhd> e1 : \<lbrace>U,n,C(x\<mapsto>\<^sub>f(recET T1)) \<ggreater> T, m\<rbrace>;
        G \<rhd> e2 : \<lbrace>U,n,C(x\<mapsto>\<^sub>f(recET T2)) \<ggreater> T, m\<rbrace>;
        varAP x \<notin> U; P U x\<rbrakk>
       \<Longrightarrow>
        G \<rhd> (LET t = x\<bullet>DOLLAR; b = Primop (\<lambda> x y . if x=0 then 1 else 0) t t IN IF b THEN e1 ELSE e2 END): \<lbrace>U,n,C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
apply (rule vdm_leti, rule vdm_prim)
apply (rule vdm_if) apply assumption apply assumption
apply (rotate_tac 2, erule thin_rl, erule thin_rl) 
apply clarsimp
apply (case_tac"h<a\<bullet>DOLLAR> = 0" )
  apply clarsimp apply (rule DAssC_PConst)
                 apply (rule DAss_Contexts_same_on_U) apply (erule DAss_PreservedU, rule, simp)
    apply clarsimp
    apply (case_tac "root xa = x") 
    prefer 2 apply rule apply (erule lookupAP_Update2, fast) apply (erule lookupAP_Update3, assumption, simp) 
    apply clarsimp apply rule apply (erule Match_Aux1a) apply simp apply assumption+ apply clarsimp
                              apply (erule Match_Aux2a) apply (simp, simp) apply assumption+ apply clarsimp
  apply clarsimp apply (rule DAssC_PConst)
                 apply (rule DAss_Contexts_same_on_U) apply (erule DAss_PreservedU, rule, simp)
    apply clarsimp
    apply (case_tac "root xa = x") 
    prefer 2 apply rule apply (erule lookupAP_Update2, fast) apply (erule lookupAP_Update3, assumption, simp) 
    apply clarsimp apply rule apply (erule Match_Aux1a) apply simp apply assumption+ apply clarsimp
                              apply (erule Match_Aux2a) apply (simp, simp) apply assumption+ apply clarsimp
done



constdefs P2::"env \<Rightarrow> heap \<Rightarrow> AP set \<Rightarrow> Context \<Rightarrow> 
               AP set \<Rightarrow> Context  \<Rightarrow> bool"
"P2 E h V C U D == (\<forall> L R n . (E, h, V, C, L, R, n) \<in> Yps \<longrightarrow> (\<exists> M S m . (E, h, U, D, M, S, m) \<in> Yps))"
probably, tyhe lemmea doies not hold in this generality:
lemma "\<lbrakk>P2 E h V C U D; W \<inter> U={};W \<inter> V = {}\<rbrakk> \<Longrightarrow>
      \<lbrace>U \<union> W,n,C \<ggreater> T, m\<rbrace> E h hh v p \<longrightarrow> \<lbrace>V \<union> W,nn,C \<ggreater> T, m\<rbrace> E h hh v p"
apply clarsimp
apply (simp add: DAss_def, clarsimp)
apply (drule Yps_SPLIT, simp, fast, clarsimp)
apply (subgoal_tac "\<exists> M S m . (E, h, U, D, M, S, m) \<in> Yps", clarsimp)
prefer 2 apply (simp add: P2_def) apply fast
apply (erule_tac x="q" in allE)
apply (erule_tac x=F in allE, erule_tac x="RR2 \<union> S" in allE, erule impE)
  apply rule apply (rule, fast)
here

done
GETr C l = Some(recET visited);
             \<forall> x IFld RFld iy ry ee. e \<noteq> x\<bullet>IFld \<and> e \<noteq> x\<diamondsuit>RFld \<and> 
                                 e \<noteq> LET iy = x\<bullet>IFld IN ee END \<and> e \<noteq> LET rf ry = x\<diamondsuit>RFld IN ee END \<and>
                                 e \<noteq> DIAM\<bullet>Free([RNarg l]) \<and> e \<noteq> LET _ = DIAM\<bullet>Free([RNarg l]) IN ee END\<rbrakk> 
             \<Longrightarrow> (C,e,l,[],visited,[],e):Match"
Match_I:"\<lbrakk>GETr C l = Some(recET (visited @ ((ifldn F,intET)#toCome)));
          (C,e,l,P,visited @ [(ifldn F,intET)],toCome,ee):Match\<rbrakk>
          \<Longrightarrow> (C,e,l,P,visited,(ifldn F,intET)#toCome,LET x = l\<bullet>F IN ee END):Match"
Match_R:"\<lbrakk>GETr C l = Some(recET (visited @ ((rfldn F,muET T)#toCome)));
          (C,e,l,P,visited @ [(rfldn F,muET T)],toCome,ee):Match\<rbrakk>
          \<Longrightarrow> (C,e,l,(x,rfldAP (varAP l) F,muET T)#P,visited,(rfldn F,mutET T)#toCome,LET rf x = l\<diamondsuit>F IN ee END):Match"
consts Match::"(Context \<times> expr \<times> rname \<times> ((rname \<times> AP \<times> Tp) list) \<times> ((fldname \<times> Tp) list) \<times> ((fldname \<times> Tp) list) \<times> expr) set"
inductive Match intros
Match_NIL: "\<lbrakk>GETr C l = Some(recET visited);
             \<forall> x IFld RFld iy ry ee. e \<noteq> x\<bullet>IFld \<and> e \<noteq> x\<diamondsuit>RFld \<and> 
                                 e \<noteq> LET iy = x\<bullet>IFld IN ee END \<and> e \<noteq> LET rf ry = x\<diamondsuit>RFld IN ee END \<and>
                                 e \<noteq> DIAM\<bullet>Free([RNarg l]) \<and> e \<noteq> LET _ = DIAM\<bullet>Free([RNarg l]) IN ee END\<rbrakk> 
             \<Longrightarrow> (C,e,l,[],visited,[],e):Match"
Match_I:"\<lbrakk>GETr C l = Some(recET (visited @ ((ifldn F,intET)#toCome)));
          (C,e,l,P,visited @ [(ifldn F,intET)],toCome,ee):Match\<rbrakk>
          \<Longrightarrow> (C,e,l,P,visited,(ifldn F,intET)#toCome,LET x = l\<bullet>F IN ee END):Match"
Match_R:"\<lbrakk>GETr C l = Some(recET (visited @ ((rfldn F,muET T)#toCome)));
          (C,e,l,P,visited @ [(rfldn F,muET T)],toCome,ee):Match\<rbrakk>
          \<Longrightarrow> (C,e,l,(x,rfldAP (varAP l) F,muET T)#P,visited,(rfldn F,mutET T)#toCome,LET rf x = l\<diamondsuit>F IN ee END):Match"

lemma "(C,e,l,P,vis,tc,ee):Match \<Longrightarrow>
       (\<forall> U T m n. G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace> \<longrightarrow> 
        G \<rhd> ee : \<lbrace>(U-P) \<union> Q, n, D \<ggreater> T, m\<rbrace>)"
done
Match_I:"\<lbrakk>(C,e,l,D(l\<mapsto>\<^sub>frecET LL),P,Q,ee):Match \<rbrakk> 
          \<Longrightarrow> (C,LET x = l\<bullet>F IN e END,l,D(l\<mapsto>\<^sub>f(recET ((ifldn F, intET)#LL))),P,Q,ee):Match"
Match_R:"\<lbrakk>x \<noteq> l;  
           (C(x\<mapsto>\<^sub>fT),e,l,D(l\<mapsto>\<^sub>frecET LL),P,Q,ee):Match \<rbrakk> 
          \<Longrightarrow> (C,LET rf x = l\<diamondsuit>F IN e END,l,D(l\<mapsto>\<^sub>f(recET ((rfldn F,T)#LL))),insert (varAP x) P,insert (rfldAP (varAP l) F) Q,ee):Match"

consts Match::"(Context \<times> expr \<times> rname \<times> Context \<times> AP set \<times> AP set \<times> expr) set"
inductive Match intros
Match_NIL: "\<lbrakk>\<forall> x IFld RFld iy ry ee. e \<noteq> x\<bullet>IFld \<and> e \<noteq> x\<diamondsuit>RFld \<and> 
                                 e \<noteq> LET iy = x\<bullet>IFld IN ee END \<and> e \<noteq> LET rf ry = x\<diamondsuit>RFld IN ee END \<and>
                                 e \<noteq> DIAM\<bullet>Free([RNarg l]) \<and> e \<noteq> LET _ = DIAM\<bullet>Free([RNarg l]) IN ee END\<rbrakk> 
             \<Longrightarrow> (C,e,l,C(l\<mapsto>\<^sub>f(recET [])),{},{},e):Match"
Match_I:"\<lbrakk>(C,e,l,D(l\<mapsto>\<^sub>frecET LL),P,Q,ee):Match \<rbrakk> 
          \<Longrightarrow> (C,LET x = l\<bullet>F IN e END,l,D(l\<mapsto>\<^sub>f(recET ((ifldn F, intET)#LL))),P,Q,ee):Match"
Match_R:"\<lbrakk>x \<noteq> l;  
           (C(x\<mapsto>\<^sub>fT),e,l,D(l\<mapsto>\<^sub>frecET LL),P,Q,ee):Match \<rbrakk> 
          \<Longrightarrow> (C,LET rf x = l\<diamondsuit>F IN e END,l,D(l\<mapsto>\<^sub>f(recET ((rfldn F,T)#LL))),insert (varAP x) P,insert (rfldAP (varAP l) F) Q,ee):Match"

constdefs List:: "ifldname \<Rightarrow> rfldname \<Rightarrow> A \<Rightarrow> A \<Rightarrow> Tp \<Rightarrow> Tp"
"List V R kN kC T == muET (\<lambda> X . sumET (kN, recET []) 
                                       (kC, recET [(ifldn V,intET), (rfldn R,varET X)]))"

lemma "\<lbrakk>t \<noteq> l; e = RVar t\<rbrakk> \<Longrightarrow>
         (C, LET h =l\<bullet>HD; rf t = l\<diamondsuit>TL IN e END,l,(C(t\<mapsto>\<^sub>fList HD TL kN kC intET))(l\<mapsto>\<^sub>frecET [(ifldn HD,intET), (rfldn TL,List HD TL kN kC intET)]),
             {(varAP t)},{rfldAP (varAP l) TL},e):Match"
apply (rule Match_I) 
apply (rule Match_R[simplified]) apply simp 
apply (rule Match_NIL) apply simp 
done

constdefs Tree:: "rfldname \<Rightarrow> rfldname \<Rightarrow> A \<Rightarrow> A \<Rightarrow> Tp \<Rightarrow> Tp"
"Tree L R kN kC T == muET (\<lambda> X . sumET (kN, intET) 
                                       (kC, recET [(rfldn L,varET X), (rfldn R,varET X)]))"

lemma "\<lbrakk>l \<noteq> t; r \<noteq> t; e = RVar r\<rbrakk> \<Longrightarrow>
         (C, LET rf l = t\<diamondsuit>L; rf r = t\<diamondsuit>R IN e END,t,
           ((C(l\<mapsto>\<^sub>fTree L R kN kC intET))(r\<mapsto>\<^sub>fTree L R kN kC intET))
            (t\<mapsto>\<^sub>frecET [(rfldn L,Tree L R kN kC intET), (rfldn R,Tree L R kN kC intET)]),
             {varAP l, varAP r},{rfldAP (varAP t) L, rfldAP (varAP t) R},e):Match"
apply (rule Match_R) apply simp
apply (rule Match_R) apply simp 
apply (rule Match_NIL) apply simp 
done

lemma MatchQ:"(C,e,l,D,P,Q,ee):Match \<Longrightarrow> (\<forall> p. p:Q \<longrightarrow> (\<exists> F. p = rfldAP (varAP l) F))"
apply (erule Match.induct)
apply clarsimp
apply assumption
apply clarsimp
done
(*
lemma Case_MatchNil:
"(\<forall>y. (\<exists>F. rfldAP y F \<in> U) \<longrightarrow> y = varAP l) \<longrightarrow> varAP l \<notin> U \<longrightarrow> x \<in> U \<longrightarrow>
    (\<forall> S . ((C(l\<mapsto>\<^sub>frecET []), x, E, h, S) \<in> lookupAP) = ((C, x, E, h, S) \<in> lookupAP))"
apply (induct x)
apply clarsimp
  apply rule apply (erule lookupAP.elims) apply clarsimp apply (rule lookup_VarAP)
     apply (subgoal_tac "GETr C x = GETr (C(l\<mapsto>\<^sub>frecET [])) x", simp)  apply (rule GETr_Update1a, fast) 
     apply clarsimp 
  apply (erule lookupAP.elims) apply clarsimp apply (rule lookup_VarAP)
     apply (subgoal_tac "GETr C x = GETr (C(l\<mapsto>\<^sub>frecET [])) x", simp)  apply (rule GETr_Update1a, fast) 
     apply clarsimp 
apply clarsimp
  apply rule apply (erule lookupAP.elims, clarsimp+) apply (rule lookup_RfldAP)
     apply (subgoal_tac "GETr C x = GETr (C(l\<mapsto>\<^sub>frecET [])) x", simp)  apply (rule GETr_Update1a, fast) 
     apply clarsimp 
  apply (erule lookupAP.elims) apply clarsimp apply (rule lookup_VarAP)
     apply (subgoal_tac "GETr C x = GETr (C(l\<mapsto>\<^sub>frecET [])) x", simp)  apply (rule GETr_Update1a, fast) 
     apply clarsimp 
apply clarsimp
*)

lemma Match:
  "(C,e,l,D,P,Q,ee): Match \<Longrightarrow>
   (\<forall> U T m n. G \<rhd> ee : \<lbrace>U, n, C \<ggreater> T, m\<rbrace> \<longrightarrow> 
               (\<forall> x F . rfldAP x F : U \<longrightarrow> x = varAP l) \<longrightarrow>
    G \<rhd> e : \<lbrace>(U-P) \<union> Q, n, D \<ggreater> T, m\<rbrace>)"
apply (erule Match.induct)
(*MatchNil*)
  apply clarsimp apply (erule thin_rl)
  apply (erule vdm_conseq, clarsimp)
  apply (erule DAss_Contexts_same_on_U)
  apply clarsimp
  defer 1 (*possobly wroing if l is in the U-set for ee?*)
(*MatchIFld*)
apply clarsimp
  apply (frule MatchQ)
  apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
  apply (erule_tac x=U in allE, erule_tac x=T in allE)
  apply (erule_tac x=m in allE, erule_tac x=n in allE, clarsimp, assumption)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl)
    apply (simp add: DAss_def, clarsimp)
    apply (erule_tac x=q in allE, erule_tac x=Fa in allE, erule_tac x=R in allE)
     apply (rotate_tac -1, erule impE) prefer 2 apply assumption
     apply (rule_tac x=N in exI, simp)
     apply (rule_tac x=Pa in exI)
     apply (rule_tac x=L in exI, simp)
     apply (erule YpsPreservedU) apply (rule evalAP_root, simp, simp)
     apply (rule lookupAP_PreservedE) 
     prefer 2 apply (subgoal_tac "renv E (root xa) = renv E<x:=h<a\<bullet>F>> (root xa)", assumption, simp)
oops
(*     apply (erule Match_IfldAux) prefer 3 apply assumption prefer 3 apply assumption
       apply fast apply fast apply assumption+*)
lemma Match_IfldAux[rule_format]:
"\<forall> T. (D(l\<mapsto>\<^sub>frecET ((ifldn F, intET) # LL)), x, E, h, T) \<in> lookupAP \<longrightarrow>
      (\<forall>x. (\<exists>F. rfldAP x F \<in> U) \<longrightarrow> x = varAP l) \<longrightarrow> 
      (\<forall>p. p \<in> Q \<longrightarrow> (\<exists>F. p = rfldAP (varAP l) F)) \<longrightarrow> 
      renv E l = Ref a \<longrightarrow>
      x \<in> U - P \<union> Q \<longrightarrow>
     (D(l\<mapsto>\<^sub>frecET LL), x, E, h, T) \<in> lookupAP"
apply (induct x)
apply clarsimp
  apply rule
  apply clarsimp apply (erule lookupAP.elims, clarsimp) apply (rule lookup_VarAP) apply (erule GETr_Update2, fast)
                 apply clarsimp
  apply fast
apply clarsimp
  apply rule
  apply clarsimp apply (erule lookupAP.elims, clarsimp, clarsimp) 
                 apply (erule_tac x="muET Ta" in allE, clarsimp)
                 apply (rotate_tac 1, erule_tac x=p in allE) 
                 apply (rotate_tac -1, erule impE, fast)
                 apply clarsimp
                 apply (erule lookupAP.elims, clarsimp, clarsimp)
  apply clarsimp apply (erule lookupAP.elims, clarsimp, clarsimp) 
                 apply (erule_tac x="muET Ta" in allE, clarsimp)
                 apply (erule_tac x="rfldAP p Fa" in allE, clarsimp)
                 apply (erule lookupAP.elims, clarsimp+)
done

(*suspicion: all paths in Q are of the form l.F. For all paths in U that are of the form x.F we have x=l!!
lemma "(C, x, E, h, T) \<in> lookupAP \<Longrightarrow>
       varAP (root x) \<notin> U \<longrightarrow> U \<inter> Q = {} \<longrightarrow> root x \<notin> roots Q \<longrightarrow>
       GETr C (root x) = Some (recET ((ifldn F, intET) # LL)) \<longrightarrow>
       E\<lfloor>(root x)\<rfloor> = Ref a \<longrightarrow> x \<notin> Q \<longrightarrow>
        x \<in> U \<longrightarrow> x \<notin> P  \<longrightarrow> (C(root x\<mapsto>\<^sub>frecET LL), x, E, h, T) \<in> lookupAP"
apply (erule lookupAP.induct)
apply clarsimp
apply clarsimp
apply (rule lookup_RfldAP)

lemma "(C, x, E, h, Ta) \<in> lookupAP \<Longrightarrow> 
        (\<forall>p. p \<in> Q \<longrightarrow> (\<exists>F. p = rfldAP (varAP l) F)) \<longrightarrow> varAP l \<notin> U \<longrightarrow> U \<inter> Q = {} \<longrightarrow>
          GETr C l = Some (recET ((ifldn F, intET) # LL)) \<longrightarrow> renv E l = Ref a \<longrightarrow>
           x \<in> U - P \<union> Q \<longrightarrow>
          (C(l\<mapsto>\<^sub>frecET LL), x, E, h, Ta) \<in> lookupAP"
apply (induct x)
apply (erule lookupAP.elims, clarsimp)
  apply rule apply clarsimp apply (rule lookup_VarAP) apply (erule GETr_Update2, fast)
             apply clarsimp apply fast
  apply clarsimp
apply (erule lookupAP.elims, clarsimp)
  apply clarsimp
  apply rule apply clarsimp apply (rule lookup_RfldAP) apply (erule GETr_Update2, fast)
             apply clarsimp apply fast
  apply clarsimp

apply (case_tac xa)
apply clarsimp
  apply (case_tac "rname = l")
  apply clarsimp apply fast 
  apply (erule lookupAP.elims, simp_all, clarsimp)
                 apply (rule lookup_VarAP) apply (erule GETr_Update2, fast)
apply clarsimp
apply (erule disjE)
  apply clarsimp
*)
lemma Match_IfldAux[rule_format]:
"\<forall> C E h T. (C, x, E, h, T) \<in> lookupAP \<longrightarrow>
                  (\<forall> l Q. (\<forall>p. p \<in> Q \<longrightarrow> (\<exists>F. p = rfldAP (varAP l) F)) \<longrightarrow>
                          (\<forall> U . (\<forall>x. (\<exists>F. rfldAP x F \<in> U) \<longrightarrow> x = varAP l) \<longrightarrow>
                                  varAP l \<notin> U \<longrightarrow> U \<inter> Q = {} \<longrightarrow>
                                  (\<forall> F LL . GETr C l = Some (recET ((ifldn F, intET) # LL)) \<longrightarrow> 
                                            (\<forall> a P. renv E l = Ref a \<longrightarrow>
                                                    x \<in> U - P \<union> Q \<longrightarrow> 
                                                    (C(l\<mapsto>\<^sub>frecET LL), x, E, h, T) \<in> lookupAP))))"
apply (induct x)
apply clarsimp
  apply rule
  apply clarsimp apply (erule lookupAP.elims, clarsimp) apply (rule lookup_VarAP) apply (erule GETr_Update2, fast)
                 apply clarsimp
  apply fast
apply clarsimp
  apply rule
  apply clarsimp apply (erule lookupAP.elims, clarsimp, clarsimp) 
                 apply (erule_tac x=Ca in allE, erule_tac x=Ea in allE, 
                        erule_tac x=ha in allE, erule_tac x="muET Ta" in allE, clarsimp)
                 apply (erule_tac x=l in allE, erule_tac x=Q in allE, clarsimp)
                 apply (erule_tac x=U in allE, clarsimp)
                 apply (rotate_tac 1, erule_tac x=p in allE) 
                 apply (rotate_tac -1, erule impE, rule_tac x=Fa in exI, assumption)
                 apply clarsimp
                 apply (erule lookupAP.elims, clarsimp, clarsimp)
  apply clarsimp apply (erule lookupAP.elims, clarsimp, clarsimp) 
                 apply (erule_tac x=Ca in allE, erule_tac x=Ea in allE, 
                        erule_tac x=ha in allE, erule_tac x="muET Ta" in allE, clarsimp)
                 apply (erule_tac x=l in allE, erule_tac x=Q in allE, clarsimp)
                 apply (erule_tac x=U in allE, clarsimp)
                 apply (erule_tac x="rfldAP p Fa" in allE, clarsimp)
                 apply (erule lookupAP.elims, clarsimp+)
done
lemma Match_IfldAux[rule_format]:
"\<forall> T. (C, x, E, h, T) \<in> lookupAP \<longrightarrow>
                  (\<forall> l Q. (\<forall>p. p \<in> Q \<longrightarrow> (\<exists>F. p = rfldAP (varAP l) F)) \<longrightarrow>
                          (\<forall> U . (\<forall>x. (\<exists>F. rfldAP x F \<in> U) \<longrightarrow> x = varAP l) \<longrightarrow>
                                  varAP l \<notin> U \<longrightarrow> U \<inter> Q = {} \<longrightarrow>
                                  (\<forall> F LL . GETr C l = Some (recET ((ifldn F, intET) # LL)) \<longrightarrow> 
                                            (\<forall> a P. renv E l = Ref a \<longrightarrow>
                                                    x \<in> U - P \<union> Q \<longrightarrow> 
                                                    (C(l\<mapsto>\<^sub>frecET LL), x, E, h, T) \<in> lookupAP))))"
apply (induct x)
apply clarsimp
  apply rule
  apply clarsimp apply (erule lookupAP.elims, clarsimp) apply (rule lookup_VarAP) apply (erule GETr_Update2, fast)
                 apply clarsimp
  apply fast
apply clarsimp
  apply rule
  apply clarsimp apply (erule lookupAP.elims, clarsimp, clarsimp) 
                 apply (erule_tac x="muET Ta" in allE, clarsimp)
                 apply (erule_tac x=l in allE, erule_tac x=Q in allE, clarsimp)
                 apply (erule_tac x=U in allE, clarsimp)
                 apply (rotate_tac 1, erule_tac x=p in allE) 
                 apply (rotate_tac -1, erule impE, rule_tac x=Fa in exI, assumption)
                 apply clarsimp
                 apply (erule lookupAP.elims, clarsimp, clarsimp)
  apply clarsimp apply (erule lookupAP.elims, clarsimp, clarsimp) 
                 apply (erule_tac x="muET Ta" in allE, clarsimp)
                 apply (erule_tac x=l in allE, erule_tac x=Q in allE, clarsimp)
                 apply (erule_tac x=U in allE, clarsimp)
                 apply (erule_tac x="rfldAP p Fa" in allE, clarsimp)
                 apply (erule lookupAP.elims, clarsimp+)
done

lemma Match_IfldAux[rule_format]:
"\<forall> T. (C, x, E, h, T) \<in> lookupAP \<longrightarrow>
                  (\<forall>p. p \<in> Q \<longrightarrow> (\<exists>F. p = rfldAP (varAP l) F)) \<longrightarrow>
                          (\<forall>x. (\<exists>F. rfldAP x F \<in> U) \<longrightarrow> x = varAP l) \<longrightarrow>
                                  varAP l \<notin> U \<longrightarrow> U \<inter> Q = {} \<longrightarrow>
                                   GETr C l = Some (recET ((ifldn F, intET) # LL)) \<longrightarrow> 
                                           renv E l = Ref a \<longrightarrow>
                                                    x \<in> U - P \<union> Q \<longrightarrow> 
                                                    (C(l\<mapsto>\<^sub>frecET LL), x, E, h, T) \<in> lookupAP"
apply (induct x)
apply clarsimp
  apply rule
  apply clarsimp apply (erule lookupAP.elims, clarsimp) apply (rule lookup_VarAP) apply (erule GETr_Update2, fast)
                 apply clarsimp
  apply fast
apply clarsimp
  apply rule
  apply clarsimp apply (erule lookupAP.elims, clarsimp, clarsimp) 
                 apply (erule_tac x="muET Ta" in allE, clarsimp)
                 apply (rotate_tac 1, erule_tac x=p in allE) 
                 apply (rotate_tac -1, erule impE, fast)
                 apply clarsimp
                 apply (erule lookupAP.elims, clarsimp, clarsimp)
  apply clarsimp apply (erule lookupAP.elims, clarsimp, clarsimp) 
                 apply (erule_tac x="muET Ta" in allE, clarsimp)
                 apply (erule_tac x="rfldAP p Fa" in allE, clarsimp)
                 apply (erule lookupAP.elims, clarsimp+)
done

lemma MATCH[rule_format]: 
  "(C,e,l,D,P,Q,ee): Match \<Longrightarrow>
   (\<forall> U T m n. G \<rhd> ee : \<lbrace>U, n, C \<ggreater> T, m\<rbrace> \<longrightarrow> 
               (\<forall> x F . rfldAP x F : U \<longrightarrow> x = varAP l) \<longrightarrow>
               U \<inter> (Q \<union> {varAP l}) = {} \<longrightarrow> 
    G \<rhd> e : \<lbrace>(U-P) \<union> Q, n, D \<ggreater> T, m\<rbrace>)"
apply (erule Match.induct)
(*MatchNil*)
  apply clarsimp
(*MatchIFld*)
apply clarsimp
  apply (frule MatchQ)
  apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
  apply (erule_tac x=U in allE, erule_tac x=T in allE)
  apply (erule_tac x=m in allE, erule_tac x=n in allE, clarsimp, assumption)
  apply (rotate_tac 2, erule thin_rl)
    apply (simp add: DAss_def, clarsimp)
    apply (erule_tac x=q in allE, erule_tac x=Fa in allE, erule_tac x=R in allE)
     apply (rotate_tac -1, erule impE) prefer 2 apply assumption
     apply (rule_tac x=N in exI, simp)
     apply (rule_tac x=Pa in exI)
     apply (rule_tac x=L in exI, simp)
     apply (erule YpsPreservedU) apply (rule evalAP_root, simp, simp)
     apply (rule lookupAP_PreservedE) 
     prefer 2 apply (subgoal_tac "renv E (root xa) = renv E<x:=h<a\<bullet>F>> (root xa)", assumption, simp)
     apply (erule Match_IfldAux) prefer 3 apply assumption prefer 3 apply assumption
       apply fast apply fast apply assumption+
(*MatchRFld*)
apply clarsimp
  apply (frule MatchQ)
  apply (rule vdm_conseq, rule vdm_letr, rule vdm_getfr)here
  apply (erule_tac x=U in allE, erule_tac x=T in allE)
  apply (erule_tac x=m in allE, erule_tac x=n in allE, clarsimp) apply assumption
  apply (rotate_tac 2, erule thin_rl)
    apply (simp add: DAss_def, clarsimp)
    apply (erule_tac x=q in allE, erule_tac x=Fa in allE, erule_tac x=R in allE)
     apply (rotate_tac -1, erule impE) prefer 2 apply assumption
     apply (rule_tac x=N in exI, simp)
     apply (rule_tac x=Pa in exI)
     apply (rule_tac x=L in exI, simp)
     apply (erule YpsPreservedU) apply (rule evalAP_root, simp, simp)
     apply (rule lookupAP_PreservedE) 
     prefer 2 apply (subgoal_tac "renv E (root xa) = renv E<x:=h<a\<bullet>F>> (root xa)", assumption, simp)
     apply (erule Match_IfldAux) prefer 3 apply assumption prefer 3 apply assumption
       apply fast apply fast apply assumption+
done

     apply (case_tac "")here
     apply (case_tac "root xa = l")
     (*root xa = l*) apply (subgoal_tac "xa \<notin> Q") prefer 2 apply (simp add: roots_def) apply (erule disjE, fast) apply fast 
       apply clarsimp here
  apply (erule lookupAP_IFLD, assumption+) 
    apply (case_tac "xa:U") apply (subgoal_tac "root xa:roots ") apply fastsimp
     apply (rule lookupAP_Update2) apply (erule lookupAP_PreservedE, simp)
    apply (rule_tac x="{}" in exI, rule_tac x=0 in exI)
    apply (rule_tac x=N in exI, rule_tac x=Fa in exI) apply simp
    apply (rule, rule modelsETInt) apply fast
    apply fast
    apply clarsimp
    apply (erule DAss_Contexts_same_on_U, clarsimp)
      apply (rule, clarsimp)
      prefer 2 (* is incorrect, but only on Int*)
      apply clarsimp apply (case_tac "(C, x, E, h, S) \<in> lookupAP", clarsimp) apply (erule lookupAP_Update2) 
            apply (case_tac "root x=l", clarsimp) apply clarsimp
  apply (erule FREE) apply simp apply fast
  apply clarsimp
(*Case IFLD*)
lemma MATCH[rule_format]: 
  "(C,e,l,D,P,Q,ee): Match \<Longrightarrow>
   (\<forall> U T m n. G \<rhd> ee : \<lbrace>U, n, D \<ggreater> T, m\<rbrace> \<longrightarrow> 
               (\<forall> x F . rfldAP x F : U \<longrightarrow> x = varAP l) \<longrightarrow>
               U \<inter> (Q \<union> {varAP l}) = {} \<longrightarrow> 
    G \<rhd> e : \<lbrace>(U-P) \<union> Q, n, C \<ggreater> T, m\<rbrace>)"
apply (erule Match.induct)
(*MatchNil*)
  apply clarsimp
(*MatchIFld*)
apply clarsimp
  apply (frule MatchQ)
  apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
  apply (erule_tac x=U in allE, erule_tac x=T in allE)
  apply (erule_tac x=m in allE, erule_tac x=n in allE, clarsimp) apply assumption
  apply (rotate_tac 2, erule thin_rl)
    apply (simp add: DAss_def, clarsimp)
    apply (erule_tac x=q in allE, erule_tac x=Fa in allE, erule_tac x=R in allE)
     apply (rotate_tac -1, erule impE) prefer 2 apply assumption
     apply (rule_tac x=N in exI, simp)
     apply (rule_tac x=Pa in exI)
     apply (rule_tac x=L in exI, simp)
     apply (erule YpsPreservedU) apply (rule evalAP_root, simp, simp)
     apply (rule lookupAP_PreservedE) 
     prefer 2 apply (subgoal_tac "renv E (root xa) = renv E<x:=h<a\<bullet>F>> (root xa)", assumption, simp)
     apply (erule Match_IfldAux) prefer 3 apply assumption prefer 3 apply assumption
       apply fast apply fast apply assumption+
(*MatchRFld*)
apply clarsimp
  apply (frule MatchQ)
  apply (rule vdm_conseq, rule vdm_letr, rule vdm_getfr)
here
  apply (erule_tac x=U in allE, erule_tac x=T in allE)
  apply (erule_tac x=m in allE, erule_tac x=n in allE, clarsimp) apply assumption
  apply (rotate_tac 2, erule thin_rl)
    apply (simp add: DAss_def, clarsimp)
    apply (erule_tac x=q in allE, erule_tac x=Fa in allE, erule_tac x=R in allE)
     apply (rotate_tac -1, erule impE) prefer 2 apply assumption
     apply (rule_tac x=N in exI, simp)
     apply (rule_tac x=Pa in exI)
     apply (rule_tac x=L in exI, simp)
     apply (erule YpsPreservedU) apply (rule evalAP_root, simp, simp)
     apply (rule lookupAP_PreservedE) 
     prefer 2 apply (subgoal_tac "renv E (root xa) = renv E<x:=h<a\<bullet>F>> (root xa)", assumption, simp)
     apply (erule Match_IfldAux) prefer 3 apply assumption prefer 3 apply assumption
       apply fast apply fast apply assumption+
done

     apply (case_tac "")here
     apply (case_tac "root xa = l")
     (*root xa = l*) apply (subgoal_tac "xa \<notin> Q") prefer 2 apply (simp add: roots_def) apply (erule disjE, fast) apply fast 
       apply clarsimp here
  apply (erule lookupAP_IFLD, assumption+) 
    apply (case_tac "xa:U") apply (subgoal_tac "root xa:roots ") apply fastsimp
     apply (rule lookupAP_Update2) apply (erule lookupAP_PreservedE, simp)
    apply (rule_tac x="{}" in exI, rule_tac x=0 in exI)
    apply (rule_tac x=N in exI, rule_tac x=Fa in exI) apply simp
    apply (rule, rule modelsETInt) apply fast
    apply fast
    apply clarsimp
    apply (erule DAss_Contexts_same_on_U, clarsimp)
      apply (rule, clarsimp)
      prefer 2 (* is incorrect, but only on Int*)
      apply clarsimp apply (case_tac "(C, x, E, h, S) \<in> lookupAP", clarsimp) apply (erule lookupAP_Update2) 
            apply (case_tac "root x=l", clarsimp) apply clarsimp
  apply (erule FREE) apply simp apply fast
  apply clarsimp
(*Case IFLD*)


lemma DA_Alloc:
"G \<rhd>  (DIAM\<bullet>Alloc([])) : 
    (\<lambda> E h hh v p . (h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Nullref \<longrightarrow>
                      hh = \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM), iheap = iheap h, rheap = rheap h, sheap = sheap h\<rparr> \<and> 
                      v = RVal (Ref (freshloc (Dom h)))) \<and> 
                    (h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<noteq> Nullref \<longrightarrow> 
                      (\<exists> h1 r. (\<exists>a. h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Ref a \<and> h1 = h \<and> r = h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>) \<and>
                                hh = h1\<lparr>sheap := (sheap h1)(DIAM := (sheap h1 DIAM)(DOLLAR_F := r))\<rparr> \<and>
                                v = RVal h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)))"
(*<*)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Alloc)
apply (rule CtxtWeakSingleton)
apply (rule vdm_conseq, rule vdm_letr, rule vdm_getstat)
apply (rule vdm_leti,rule vdm_rprim)
apply (rule vdm_if, rule vdm_new)
apply (rule Call1, simp add: Fun_AllocQ)
apply (rule CtxtWeakSingleton)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letv, rule vdm_putstat, rule vdm_rvar)
apply clarsimp 
apply (simp only: newObj_def newframe_env_def evalARGS_def) apply (simp add:self_def) apply clarsimp
done

(*needs modifications: unitET, class name in modelsET should not be "C" but "DIAM" from FL-predicate*)
lemma FREE: "\<lbrakk>GETr C x = Some (recET []); m=n+1\<rbrakk> \<Longrightarrow> G \<rhd> (DIAM\<bullet>Free([RNarg x])) : \<lbrace>{varAP x}, n, C \<ggreater> unitET, m\<rbrace>"
(*lemma FREE: "\<lbrakk>GETr C x = Some T; m=n+1; T \<notin> {intET, unitET}\<rbrakk> \<Longrightarrow> G \<rhd> (DIAM\<bullet>Free([RNarg x])) : \<lbrace>{varAP x}, n, C \<ggreater> unitET, m\<rbrace>"*)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Free)
apply (rule vdm_conseq) 
apply (rule vdm_letr, rule vdm_getstat)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_putstat) 
apply (frule GETrSome_DOM)
apply (simp add: DAss_def, clarsimp)
apply (subgoal_tac "(C,varAP x,E',h,recET []):lookupAP")
prefer 2 apply (erule lookup_VarAP)
apply (subgoal_tac "E'\<lfloor>x\<rfloor> = Ref a") 
prefer 2 apply (simp add: newframe_env_def evalARGS_def self_def)
apply (frule Yps_regionsExist, fastsimp, clarsimp)
apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI)
apply (subgoal_tac "l :R")
prefer 2 apply (drule Yps_split, fastsimp) apply fastsimp apply assumption apply clarsimp
apply (erule modelsETLocn, simp)
apply (rule_tac x="Suc N" in exI, rule_tac x="F \<union> {l}" in exI, safe)
apply (simp add: freelist_def)
  apply (subgoal_tac "(Suc N, Ref l, F \<union> {l}, h
           \<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(l := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
              sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref l))\<rparr>)
          \<in> FL", simp)
  apply (rule FL_SUC)
  apply simp apply (erule modelsET.elims, simp_all, fast)
  apply (erule FL_UpdateOutside, fast)  
defer 1 (*does not hold for this definition of unitET*) 
apply (simp add: modif_def sameOH_def)
sorry
(*due to unitET*)


consts MatchD::"(Context \<times> expr \<times> rname \<times> Context \<times> AP set \<times> AP set \<times> expr) set"
inductive MatchD intros
MatchD_NIL: "\<lbrakk>GETr C l = Some (recET [])\<rbrakk> 
             \<Longrightarrow> (C,LET _ = DIAM\<bullet>Free([RNarg l]) IN ee END,l,C,{},{},ee):MatchD"
MatchD_I:"\<lbrakk>GETr C l = Some (recET L); L=(ifldn F, intET) # LL;
           (C(l\<mapsto>\<^sub>f(recET LL)),e,l,D,P,Q,ee):MatchD \<rbrakk> 
          \<Longrightarrow> (C,LET x = l\<bullet>F IN e END,l,D,P,Q,ee):MatchD"
MatchD_R:"\<lbrakk>x \<noteq> l; GETr C l = Some (recET L); L=(rfldn F, T) # LL;
           (C(l\<mapsto>\<^sub>f(recET LL)),e,l,D,P,Q,ee):MatchD \<rbrakk> 
          \<Longrightarrow> (C,LET rf x = l\<diamondsuit>F IN e END,l,D(x\<mapsto>\<^sub>fT),insert (varAP x) P,insert (rfldAP (varAP l) F) Q,ee):MatchD"

constdefs List:: "ifldname \<Rightarrow> rfldname \<Rightarrow> A \<Rightarrow> A \<Rightarrow> Tp \<Rightarrow> Tp"
"List V R kN kC T == muET (\<lambda> X . sumET (kN, recET []) 
                                       (kC, recET [(ifldn V,intET), (rfldn R,varET X)]))"

lemma "\<lbrakk>GETr C l = Some (recET [(ifldn HD,intET), (rfldn TL,List HD TL kN kC T)]); t \<noteq> l\<rbrakk> \<Longrightarrow> 
         (C, LET h =l\<bullet>HD; rf t = l\<diamondsuit>TL; _ = DIAM\<bullet>Free([RNarg l]) IN e END,l,C(l\<mapsto>\<^sub>frecET [(rfldn TL, List HD TL kN kC T)])(l\<mapsto>\<^sub>frecET [])(t\<mapsto>\<^sub>f(List HD TL kN kC T)),{(varAP t)},{rfldAP (varAP l) TL},e):MatchD"
apply (rule MatchD_I) apply simp apply simp
apply (rule MatchD_R) apply simp apply (simp add: GETr_def) apply fastsimp
apply (rule MatchD_NIL) apply (simp add: GETr_def)
done



constdefs roots::"AP set \<Rightarrow> rname set"
"roots P == { x . \<exists> p. p:P \<and> root p =x}"

lemma MATCHD[rule_format]: 
  "(C,e,l,D,P,Q,ee): MatchD \<Longrightarrow>
   (\<forall> U n T m nk. G \<rhd> ee : \<lbrace>U, nk, D \<ggreater> T, m\<rbrace> \<longrightarrow> nk = n+1 \<longrightarrow> U \<inter> (Q \<union> {varAP l}) = {} \<longrightarrow> l \<notin> (roots Q) \<longrightarrow>
    G \<rhd> e : \<lbrace>(U-P) \<union> Q, n, C \<ggreater> T, m\<rbrace>)"
apply (erule MatchD.induct)
(*MatchNIL*)
  apply clarsimp
  apply (rule vdm_conseq, rule LETV)
  apply (erule FREE, simp)
  apply assumption
  apply fast
  apply (simp add: DAss_def, clarsimp)
  apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE)
   apply (rule_tac x=N in exI, simp)
   apply (rule_tac x=P in exI)
   apply (rule_tac x=L in exI, simp)
   apply (rule Yps_CONS) apply (subgoal_tac "varAP l : insert (varAP l) U", assumption, fast)
     apply (erule lookup_VarAP)
  apply rule
  apply (subgoal_tac "(C,varAP l,E',h,recET []):lookupAP")
  prefer 2 apply (erule lookup_VarAP)
  apply (subgoal_tac "E'\<lfloor>l\<rfloor> = Ref a") 
  prefer 2 apply (simp add: newframe_env_def evalARGS_def self_def)
  apply (frule Yps_regionsExist, fastsimp, clarsimp)
  apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
  apply (rule_tac x="{}" in exI, rule_tac x=0 in exI)
  apply (rule_tac x="Suc N" in exI, rule_tac x="F \<union> {l}" in exI, safe)
  prefer 2 apply (drule Yps_split) apply fastsimp apply fastsimp apply assumption
             apply clarsimp defer 1 (-does not hold for this definition of unitET-) 
  apply (simp add: freelist_def)
  apply (subgoal_tac "(Suc N, Ref l, F \<union> {l}, h
           \<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(l := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
              sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref l))\<rparr>)
          \<in> FL", simp)
  apply (rule FL_SUC)
  apply simp apply (erule modelsET.elims, simp_all)
  apply simp apply (erule FL_UpdateOutside, assumption)  
  apply (rule regUnit)
apply (simp add: modified_def, clarsimp)
  apply (simp add: sameOH_def)
  apply (simp add: regionsExist_def, clarsimp)
  apply (erule_tac x=Rx in allE, erule impE, fast)
  apply (subgoal_tac "a: Rx", fast) apply (erule Ref_reg, assumption)
apply (simp add: Bounded_def)
apply (simp add: Bounded_def)
  apply (rule disjI2)
  apply (simp add: regionsExist_def, clarsimp)
  apply (rule_tac x=Rx in exI, rule, fast)
  apply (erule Ref_reg, assumption)
apply simp



  prefer 2 apply assumption
  apply (erule FREE) apply simp 
  apply clarsimp
  apply (simp add: DAss_def, clarsimp)
defer 1(*   apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE)
    apply (rule_tac x=N in exI, simp)
    apply (rule_tac x=P in exI)
    apply (rule_tac x=L in exI, simp)
    apply (rule Yps_CONS) apply fast apply (erule lookup_VarAP) 
done*)
(*Case IFLD*)
apply clarsimp
  apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
  apply (erule_tac x=U in allE) apply (erule_tac x=n in allE) 
           apply (erule_tac x=T in allE) apply (erule_tac x=m in allE) 
           apply (erule impE, assumption) 
           apply (erule impE, clarsimp) apply assumption
  apply (rotate_tac 2, erule thin_rl)
    apply (simp add: DAss_def, clarsimp)
    apply (erule_tac x=q in allE, erule_tac x=Fa in allE, erule_tac x=R in allE)
     apply (rotate_tac -1, erule impE) prefer 2 apply assumption
     apply (rule_tac x=N in exI, simp)
     apply (rule_tac x=Pa in exI)
     apply (rule_tac x=L in exI, simp)
     apply (erule YpsPreservedU) apply (rule evalAP_root, simp, simp)
  apply (erule lookupAP_IFLD, assumption+) 
    apply (case_tac "xa:U") apply (subgoal_tac "root xa:roots ") apply fastsimp
     apply (rule lookupAP_Update2) apply (erule lookupAP_PreservedE, simp)
    apply (rule_tac x="{}" in exI, rule_tac x=0 in exI)
    apply (rule_tac x=N in exI, rule_tac x=Fa in exI) apply simp
    apply (rule, rule modelsETInt) apply fast
    apply fast
    apply clarsimp
    apply (erule DAss_Contexts_same_on_U, clarsimp)
      apply (rule, clarsimp)
      prefer 2 (* is incorrect, but only on Int*)
      apply clarsimp apply (case_tac "(C, x, E, h, S) \<in> lookupAP", clarsimp) apply (erule lookupAP_Update2) 
            apply (case_tac "root x=l", clarsimp) apply clarsimp
  apply (erule FREE) apply simp apply fast
  apply clarsimp
(*Case IFLD*)

lemma "(C, xa, E, h, Ta) \<in> lookupAP \<Longrightarrow>
        (\<forall> l U Q F LL P a. varAP l \<notin> U \<longrightarrow> U \<inter> Q = {} \<longrightarrow> (\<forall> p. (p : Q \<longrightarrow> (\<exists> pp FF. p = rfldAP pp FF)) \<and> (p:U \<longrightarrow> p \<noteq> varAP l)) \<longrightarrow>
          GETr C l = Some (recET ((ifldn F, intET) # LL)) \<longrightarrow>
          renv E l = Ref a \<longrightarrow> xa \<in> U - P \<union> Q \<longrightarrow>
          (C(l\<mapsto>\<^sub>frecET LL), xa, E<x:=h<a\<bullet>F>>, h, Ta) \<in> lookupAP)"
apply clarsimp
apply rule
  apply clarsimp apply (erule_tac x=xa in allE, clarsimp)
  apply (erule lookupAP.elims)
  apply clarsimp  apply (rule lookup_VarAP) apply (erule GETr_Update2) apply fast
  apply clarsimp 
    apply (rule lookup_RfldAP)

lemma lookupAP_IFLD[rule_format]:
  "(C, xa, E, h, Ta) \<in> lookupAP
       \<Longrightarrow> (\<forall> l F LL x a . GETr C l = Some (recET ((ifldn F, intET) # LL)) \<longrightarrow> 
                (C(l\<mapsto>\<^sub>frecET LL), xa, E<x:=h<a\<bullet>F>>, h, Ta) \<in> lookupAP)"
apply (erule lookupAP.induct)
apply clarsimp
oops
(*  apply (case_tac "x = l") apply (subgoal_tac "T=recET ((ifldn F, intET) # LL)", clarsimp)
  apply (rule lookup_VarAP)
apply (erule lookupAP.elims, simp_all, clarsimp)
apply (rule lookup_RfldAP)
apply clarsimp (&apply (rule lookup_VarAP) apply (erule GETr_Update2, fastsimp)&)
apply clarsimp
apply (erule_tac x=la in allE, erule_tac x=Fa in allE, erule_tac x=LLa in allE)
apply clarsimp(&
apply (erule_tac x=x in allE, erule_tac x=a in allE)&)
apply (rule lookup_RfldAP) apply assumption apply (rule evalAP_root, simp, simp)
apply assumption+
done
*)
lemma Unfold2[rule_format]:
  "(E, h, U, C, L, R, S) \<in> Yps \<Longrightarrow> 
    (\<forall> x T. x \<in> U \<longrightarrow> (C,x,E,h,muET T):lookupAP \<longrightarrow>
        (\<forall> kL FldsL kR FldsR . subst T (muET T) (sumET (kL,recET FldsL) (kR, recET FldsR)) \<longrightarrow>
                               (rfldn F,TT) # TL = FldsL \<longrightarrow>
                               (\<forall> l L. evalAP x E h = Some(Ref l,L) \<longrightarrow> h<l\<bullet>DOLLAR> = 0 \<longrightarrow> 
                                       rfldAP x F \<notin> U)))"
apply clarsimp
apply (frule Yps_regionsExist) apply fastsimp apply clarsimp
apply (subgoal_tac "(C, rfldAP x F, E, h, TT) \<in> lookupAP")
prefer 2 apply (erule lookup_RfldAP, assumption+) apply clarsimp+
apply (frule Yps_regionsExist)
   apply (subgoal_tac "rfldAP x F:U \<and> (C, rfldAP x F,E,h,TT):lookupAP", assumption) apply simp
apply clarsimp
apply (case_tac "locns h\<lfloor>l\<diamondsuit>F\<rfloor> \<subseteq> Dom h") prefer 2 apply clarsimp+
apply (erule modelsET.elims,simp_all, clarsimp)
apply (drule subst_unique, assumption, clarsimp)
apply (drule Yps_DisjointEntries, assumption)
  prefer 2 apply (rule AP_inject, assumption+) 
  apply (erule modelsETMu) apply assumption+
  apply simp apply rule apply simp apply simp 
  apply assumption 
  apply (rotate_tac -2)
    apply (erule modelsET.elims, simp_all, clarsimp)
  apply (rotate_tac -1)
    apply (erule modelsET.elims, simp_all, clarsimp)
  apply (drule modelsET_Unique, assumption, clarsimp)
  apply (frule modelsET_isLocn, erule exE)
  apply (drule modelsETLocn, simp)
apply fast
done

consts mkUset::"AP \<Rightarrow> (fldname \<times> Tp) list \<Rightarrow> AP set"
primrec
"mkUset x [] = {}"
"mkUset x (h#t) = (case fst h of ifldn F \<Rightarrow> mkUset x t
                               | rfldn F \<Rightarrow> insert (rfldAP x F) (mkUset x t))"

lemma UnfoldSum_L_Nil[rule_format]:
"\<lbrakk>(RVal (Ref l),h,sumET (kL,recET []) (kR, recET FldsR),R,N):modelsET;
        h<l\<bullet>DOLLAR> = 0\<rbrakk> \<Longrightarrow> (R={l} \<and> N=kL)"
apply (erule modelsET.elims, simp_all)
apply clarsimp
apply (erule modelsET.elims, simp_all)
done

lemma UnfoldSum_L_IFLD[rule_format]:
"\<lbrakk>(RVal (Ref l),h,sumET (kL,recET ((ifldn F,T)#TL)) (kR, recET FldsR),R,N):modelsET;
        h<l\<bullet>DOLLAR> = 0\<rbrakk> \<Longrightarrow> (RVal (Ref l),h,sumET (kL,recET TL) (kR, recET FldsR),R,N):modelsET \<and> l:R"
apply (erule modelsET.elims, simp_all)
apply clarsimp
apply (erule modelsET.elims, simp_all)
apply clarsimp
apply (erule modelsET.elims, simp_all)
apply clarsimp
apply rule
apply (erule modelsETSum)
apply clarsimp
apply fastsimp
apply (erule modelsETLocn, simp)
done

lemma UnfoldSum_L_RFLD[rule_format]:
"\<lbrakk>(RVal (Ref l),h,sumET (kL,recET ((rfldn F,T)#TL)) (kR, recET FldsR),R,N):modelsET;
        h<l\<bullet>DOLLAR> = 0\<rbrakk> \<Longrightarrow> (\<exists> Rg1 N1 Rg2 N2 . (fldlookup h l (rfldn F),h,T,Rg1,N1):modelsET \<and>
                                               (RVal (Ref l),h,sumET (kL,recET TL) (kR, recET FldsR),Rg2,N2):modelsET \<and>
                                                   l : Rg2 \<and> Rg1 \<inter> Rg2 = {} \<and> Rg1 \<union> Rg2 = R \<and> N=N1+N2)"
apply (erule modelsET.elims, simp_all)
apply clarsimp
apply (erule modelsET.elims, simp_all)
apply clarsimp
apply (rule_tac x=reg1 in exI, rule_tac x=Na in exI, simp)
apply (rule_tac x=reg2 in exI, simp)
apply rule
apply (erule modelsETSum)
apply clarsimp
apply fastsimp
apply (erule modelsETLocn, simp)
done

lemma UnfoldMu_L_Nil[rule_format]:
"\<lbrakk>(RVal (Ref l),h,muET T,R,N):modelsET; subst T (muET T) (sumET (kL,recET []) (kR, recET FldsR));
        h<l\<bullet>DOLLAR> = 0\<rbrakk> \<Longrightarrow> (R={l} \<and> N=kL)"
apply (erule modelsET.elims, simp_all)
apply clarsimp
apply (drule subst_unique, assumption, clarsimp)
apply (erule UnfoldSum_L_Nil, assumption)
done

lemma UnfoldMu_L_IFLD[rule_format]:
"\<lbrakk>(RVal (Ref l),h,muET T,R,N):modelsET; subst T (muET T) (sumET (kL,recET ((ifldn F,TT)#TL)) (kR, recET FldsR));
        h<l\<bullet>DOLLAR> = 0\<rbrakk> \<Longrightarrow> (RVal (Ref l),h,sumET (kL,recET TL) (kR, recET FldsR),R,N):modelsET \<and> l:R"
apply (erule modelsET.elims, simp_all)
apply clarsimp
apply (drule subst_unique, assumption, clarsimp)
apply (erule UnfoldSum_L_IFLD)
apply assumption
done

lemma UnfoldMu_L_RFLD[rule_format]:
"\<lbrakk>(RVal (Ref l),h,muET T,R,N):modelsET; subst T (muET T) (sumET (kL,recET ((rfldn F,TT)#TL)) (kR, recET FldsR));
        h<l\<bullet>DOLLAR> = 0\<rbrakk> \<Longrightarrow> (\<exists> Rg1 N1 Rg2 N2 . (fldlookup h l (rfldn F),h,TT,Rg1,N1):modelsET \<and>
                                               (RVal (Ref l),h,sumET (kL,recET TL) (kR, recET FldsR),Rg2,N2):modelsET \<and>
                                                   l : Rg2 \<and> Rg1 \<inter> Rg2 = {} \<and> Rg1 \<union> Rg2 = R \<and> N=N1+N2)"
apply (erule modelsET.elims, simp_all)
apply clarsimp
apply (drule subst_unique, assumption, clarsimp)
apply (drule UnfoldSum_L_RFLD, assumption)
apply simp
done


end
(*
end
subsection {&&Contexts&&}
text {&&Now that we have also an integer type we should allow all variables in the domain.
Also a list-representation may be better. What about types of unit?&&}
types Context = "(rname \<leadsto>\<^sub>f Tp)"

constdefs DOM:: "Context \<Rightarrow> rname set"
"DOM == fmap_dom"

constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Tp option)"
"GETr G x \<equiv> fmap_lookup G x"

(&&<&&)
lemma GetNONE1: "x \<notin> DOM C \<Longrightarrow> None = GETr C x"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GetNONE2: "GETr C x = None \<Longrightarrow> x \<notin> DOM C"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_Update: "{x} \<union> (DOM b) = DOM (b(x\<mapsto>\<^sub>fT))" by (simp add: DOM_def)

lemma DOM_Update1: "\<lbrakk>y \<in> DOM (C(x\<mapsto>\<^sub>fT)); x \<noteq> y\<rbrakk> \<Longrightarrow> y:DOM C"
by (subgoal_tac "y \<noteq> x", insert DOM_Update, fast,fast)
lemma GETr_Update1: "x \<noteq> y \<Longrightarrow> GETr (G(x\<mapsto>\<^sub>fk)) y = GETr G y"
apply (subgoal_tac "y \<noteq> x")
apply (simp add: GETr_def)
apply (insert FMAPlookup2 [of y x G], auto)
done

lemma GETr_Update1a: "x \<noteq> y \<Longrightarrow> GETr G y = GETr (G(x\<mapsto>\<^sub>fk)) y"
apply (subgoal_tac "y \<noteq> x")
apply (simp add: GETr_def)
apply (insert FMAPlookup2 [of y x G], auto)
done

lemma GETr_Update2: "\<lbrakk>GETr G xa = Some T; x \<noteq> xa\<rbrakk> \<Longrightarrow> GETr (G(x\<mapsto>\<^sub>fk)) xa = Some T"
by (subgoal_tac "GETr (G(x\<mapsto>\<^sub>fk)) xa = GETr G xa", clarsimp, erule GETr_Update1)

lemma GETr_Trans1:"\<lbrakk>GETr C y = S; S=T; x\<noteq>y\<rbrakk> \<Longrightarrow> GETr (C(x\<mapsto>\<^sub>fTT)) y = T"
by (clarsimp, erule GETr_Update1)

lemma GETr_Trans2:"\<lbrakk>S = GETr C y; S=T; x\<noteq>y\<rbrakk> \<Longrightarrow> T = GETr (C(x\<mapsto>\<^sub>fTT)) y"
by (clarsimp, subgoal_tac "GETr (C(x\<mapsto>\<^sub>fTT)) y = GETr C y", clarsimp, erule GETr_Update1)

lemma GETrSome_DOM:"GETr G x = Some T \<Longrightarrow> x \<in> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GETrNone_DOM:"GETr G x = None \<Longrightarrow> x \<notin> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETrSome:"x \<in> DOM G \<Longrightarrow> (\<exists> T . GETr G x = Some T)"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETrNone:"x \<notin> DOM G \<Longrightarrow> GETr G x = None"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETr_DOM: "\<lbrakk>x \<in> DOM D; x \<in> U; GETr C x = GETr D x\<rbrakk> \<Longrightarrow> x \<in> DOM C"
apply (subgoal_tac "\<exists> T. GETr D x = Some T", clarsimp)
apply (rule GETrSome_DOM, clarsimp, simp)
apply (erule DOM_GETrSome)
done

lemma UsedVarsDOM1:
"\<lbrakk>\<forall>x. x \<in> U \<longrightarrow> GETr D x = GETr C x; DOM C \<subseteq> DOM D; x \<in> U; x \<in> DOM D\<rbrakk> \<Longrightarrow> x:DOM C"
apply (erule_tac x=x in allE,clarsimp)
apply (subgoal_tac "\<exists> T . GETr D x = Some T",clarsimp)
apply (rule GETrSome_DOM) apply fast
apply (erule DOM_GETrSome)
done
(&&>&&)

subsection {&&Predicate Yps&&}

consts Yps::"(env \<times> heap \<times> (rname set) \<times> Context \<times> A) set"
inductive Yps intros
YpsNIL: "\<lbrakk>U={}; S=0 \<rbrakk> \<Longrightarrow> (E,h,U,C,S) : Yps"
YpsCONS: "\<lbrakk>x: U; GETr C x = Some T; (RVal (E\<lfloor>x\<rfloor>),h,T, R,N): modelsET;
                   (E,h,U-{x},C,M):Yps; S = N+M\<rbrakk>
                  \<Longrightarrow> (E,h,U,C,S) : Yps"

(&&<&&)
lemma Yps_regionsExist[rule_format]:
"(E,h,U,C,S):Yps \<Longrightarrow> 
 (\<forall> x T . (x:U \<and> GETr C x = Some T)\<longrightarrow> (\<exists> R S . (RVal (E\<lfloor>x\<rfloor>),h,T,R,S) \<in> modelsET))"
apply (erule Yps.induct)
apply clarsimp 
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply fast
apply (erule_tac x=xa in allE, fastsimp)
done

lemma Yps_contains_region[rule_format]:
"(E, h, U, G, CS) \<in> Yps \<Longrightarrow> 
 (\<forall> x T R S . x:U \<and> GETr G x = Some T \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>),h,T, R, S) \<in> modelsET \<longrightarrow> S \<le> CS)" 
apply (erule Yps.induct)
apply clarsimp
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply (drule modelsET_Unique, assumption) apply clarsimp 
apply (erule_tac x=xa in allE, erule_tac x=Ta in allE, erule impE, clarsimp)
apply (erule_tac x=Ra in allE, erule_tac x=Sa in allE, clarsimp) 
done

lemma Yps_delete_nonUsed[rule_format]:
 "(E, h, U, G, CS) \<in> Yps \<Longrightarrow> (\<forall> x. x \<notin> DOM G \<longrightarrow> (E,h,U-{x},G,CS):Yps)"
apply (erule Yps.induct)
apply clarsimp apply (rule YpsNIL,simp+)
apply clarsimp apply (erule_tac x=xa in allE,clarsimp)
  apply (subgoal_tac "x:DOM C") prefer 2 apply (erule GETrSome_DOM)
  apply (case_tac "x=xa",clarsimp) apply (rule YpsCONS) prefer 2 apply assumption apply fast
  prefer 2 apply (subgoal_tac "U - {xa} - {x} = U - {x} - {xa}", clarsimp, assumption) apply fast
  apply simp apply simp
done

lemma Yps_delete_Used[rule_format]:
 "(E, h, U, G, N) \<in> Yps \<Longrightarrow> 
  (\<forall> x T . (x:U \<and> GETr G x = Some T) \<longrightarrow> (\<forall> n R.(RVal (E\<lfloor>x\<rfloor>), h, T, R, n) \<in> modelsET \<longrightarrow>(E,h,U-{x},G,N-n):Yps))"
apply (erule Yps.induct)
apply clarsimp
apply clarsimp 
  apply (case_tac "xa=x",clarsimp) apply (drule modelsET_Unique, assumption, clarsimp)
  apply (erule_tac x=xa in allE,clarsimp)
  apply (erule_tac x=n in allE, erule impE, fastsimp) 
  apply (subgoal_tac "U - {x} - {xa} = U - {xa} - {x}", clarsimp) apply (rule YpsCONS) prefer 3 apply assumption
    apply (fast, assumption+) apply (subgoal_tac "n \<le> M",clarsimp) 
    apply (erule Yps_contains_region) prefer 2 apply (assumption, fast)
  apply fast
done

lemma Yps_split[rule_format]:
"(E, h, U, G, CS) \<in> Yps \<Longrightarrow> (\<forall> x  T. (x:U \<and> GETr G x = Some T) \<longrightarrow> (\<forall> R S . (RVal (E\<lfloor>x\<rfloor>), h, T, R, S) \<in> modelsET \<longrightarrow>
  (\<exists> n . (E,h,U-{x},G,n):Yps \<and> CS = S + n)))" 
apply (erule Yps.induct)
apply clarsimp
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply (drule modelsET_Unique, assumption, clarsimp)
apply (erule_tac x=xa in allE, erule_tac x=Ta in allE, erule impE, fastsimp)
apply (erule_tac x=Ra in allE, erule_tac x=Sa in allE, clarsimp)
apply (rule YpsCONS)
apply (subgoal_tac "x: U -{xa}", assumption,fast)
apply assumption+
apply (subgoal_tac "U - {x} - {xa} = U - {xa} - {x}", clarsimp, assumption)
apply fast
apply simp
done

lemma Yps_Unique[rule_format]:
"(E,h,U,C,S):Yps \<Longrightarrow> (\<forall> n . (E,h,U,C,n):Yps \<longrightarrow> S = n)"
apply (erule Yps.induct)
(&&1&&)
apply clarsimp apply (erule Yps.elims, clarsimp,clarsimp)
(&&2&&)
apply (rule, rule) 
apply (rotate_tac -1, erule Yps.elims)
(&&2a&&) apply(fast)
(&&2b&&) apply clarify
  apply (case_tac "x=xa", clarify)
  apply (erule_tac x=Ma in allE, clarsimp)
  apply (simp add: modelsET_Unique)
  (&&x \<noteq> xa&&)
  apply (drule Yps_split) apply fastsimp apply assumption apply clarsimp
  apply (frule Yps_split) apply fastsimp apply assumption apply clarsimp
  apply (subgoal_tac "Ua - {xa} - {x} = Ua - {x} - {xa}", clarsimp)
  prefer 2 apply fast
  apply (erule_tac x="Na+na" in allE, erule impE)
    apply (rule YpsCONS) apply fastsimp 
    apply assumption
    prefer 3 apply simp
    apply assumption+
  apply clarsimp
done

lemma Yps_UnusedU_ContextExtension[rule_format]:
"(E, h, U, C, nn) \<in> Yps \<Longrightarrow> 
 (\<forall> x . x \<notin> U \<longrightarrow> (E, h, U, C(x\<mapsto>\<^sub>fT), nn) \<in> Yps)"
apply (erule Yps.induct)
(&&1&&) apply (clarsimp,rule YpsNIL, simp,simp)
(&&2&&) apply clarsimp apply (subgoal_tac "xa \<noteq> x") prefer 2 apply fast
      apply (rule YpsCONS,assumption) 
      apply (subgoal_tac "GETr (C(xa\<mapsto>\<^sub>fT)) x = Some Ta",assumption)
      apply (erule GETr_Update2, fast)
      apply assumption
      apply fastsimp
      apply simp
done

lemma SizePreserved_h_h1[rule_format]:
"(E, h, U, C, CS) \<in> Yps \<Longrightarrow> 
   (\<forall> h1 . (\<forall> x T. (x : U \<and> GETr C x = Some T) \<longrightarrow> (\<forall> R n .(RVal (E\<lfloor>x\<rfloor>),h, T, R, n) : modelsET \<longrightarrow> (\<forall> l . l : R \<longrightarrow> sameOH {l} h h1)))
          \<longrightarrow> (E, h1, U, C, CS) \<in> Yps)"
apply (erule Yps.induct)
apply clarsimp apply (rule YpsNIL, simp, simp) 
apply clarsimp
apply (rule YpsCONS) 
prefer 5 apply simp 
prefer 4 apply fastsimp
apply assumption
apply assumption
apply (rule modelsET_Preserved, assumption, fastsimp)
done

lemma Yps_SPLIT[rule_format]: 
"(E, h, U, C, CS) \<in> Yps \<Longrightarrow> (\<forall> U1 U2 . U1 \<union> U2 = U \<longrightarrow> U1 \<inter> U2 = {} \<longrightarrow>
 (\<exists> n1 n2 . (E, h, U1, C, n1) \<in> Yps \<and> (E, h, U2, C, n2) \<in> Yps \<and> n1 + n2 = CS))"
apply (erule Yps.induct, simp_all)
apply (rule YpsNIL, simp,simp)
(&&Case CONS&&)
apply clarsimp apply (erule disjE)
(&& x:U1&&)
  apply (erule_tac x="U1-{x}" in allE, erule_tac x=U2 in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x="N+n1" in exI, clarsimp)
  apply (erule YpsCONS,assumption+, simp)
(&& x:U2&&)
  apply (erule_tac x=U1 in allE, erule_tac x="U2-{x}" in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x=n1 in exI, clarsimp)
  apply (erule YpsCONS,assumption+, simp)
done

lemma YpsPreserved[rule_format]:
"(E,h,U,C,S):Yps \<Longrightarrow> ((\<forall> x . x : U \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>) \<longrightarrow> (EE,h,U,C,S):Yps)"
apply (erule Yps.induct)
(&&NIL&&)
apply clarsimp
apply (rule YpsNIL) apply (simp, simp)
(&&CONS&&)
apply clarsimp
apply (frule GETrSome_DOM)
apply (erule YpsCONS)
apply (assumption+,simp)
done

lemma YpsPreservedU[rule_format]:
"(E,h,U,C,S):Yps \<Longrightarrow> ((\<forall> x . x : U \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>) \<longrightarrow> 
                              (\<forall> D . (\<forall> x . x : U \<longrightarrow> (\<forall> T . GETr C x = Some T \<longrightarrow> GETr D x = Some T)) \<longrightarrow>
                                     (EE,h,U,D,S):Yps))"
apply (erule Yps.induct)
(&&NIL&&)
apply clarsimp
apply (rule YpsNIL) apply (simp, simp)
(&&CONS&&)
apply clarsimp
apply (frule GETrSome_DOM) 
apply (erule_tac x=x in allE,clarsimp)
apply (subgoal_tac "GETr C x = GETr D x")
prefer 2 apply (drule DOM_GETrSome) apply fastsimp          
apply (erule YpsyyyyyCONS) 
apply (simp)
apply assumption
apply (erule_tac x=D in allE) apply (clarsimp, assumption)
apply simp
done
(&&>&&)

text{&&Some tests to demonstrate that for the list datatype, the modelsET predicate calculates the desired numbers.&&}
lemma ListNil:"\<lbrakk>T=List V R0 kN kC intET; (RVal (Ref l), h, T, R,N):modelsET;h<l\<bullet>DOLLAR> = 0\<rbrakk> \<Longrightarrow> N=kN"
apply (simp add: List_def, clarsimp)
apply (erule modelsET.elims, simp_all, clarsimp)
apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all)
done
lemma ListConsNil:"\<lbrakk>T=List V R0 kN kC intET; (RVal (Ref l), h, T, R,N):modelsET;h<l\<bullet>DOLLAR> \<noteq> 0;
        h\<lfloor>l\<diamondsuit>R0\<rfloor> = Ref ll; ll \<noteq> l;h<ll\<bullet>DOLLAR> = 0\<rbrakk> \<Longrightarrow> N=kN+kC"
apply (simp add: List_def, clarsimp)
apply (erule modelsET.elims, simp_all, clarsimp)
apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (rotate_tac -3)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (rule ListNil) apply (simp add: List_def) apply assumption apply simp
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all)
done
lemma ListConsConsNil:"\<lbrakk>T=List V R0 kN kC intET; (RVal (Ref l), h, T, R,N):modelsET;
           h<l\<bullet>DOLLAR> \<noteq> 0; h\<lfloor>l\<diamondsuit>R0\<rfloor> = Ref ll; ll \<noteq> l; 
           h<ll\<bullet>DOLLAR> \<noteq> 0; h\<lfloor>ll\<diamondsuit>R0\<rfloor> = Ref lll; lll \<noteq> ll; lll \<noteq> l; 
           h<lll\<bullet>DOLLAR> = 0\<rbrakk> \<Longrightarrow> N=kN+kC+kC"
apply (simp add: List_def, clarsimp)
apply (erule modelsET.elims, simp_all, clarsimp)
apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (rotate_tac -2)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (rotate_tac -3)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (rule ListConsNil) apply (simp add: List_def) apply assumption apply simp apply assumption+
apply (erule substitution_listsubstitution.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all, clarsimp)
  apply (erule modelsET.elims, simp_all)
done

done
end
*)
(*

constdefs P::"AP set \<Rightarrow> rname \<Rightarrow> bool"
" P U z == (\<forall> p. p:U \<longrightarrow> ((\<forall> y F . p = rfldAP y F \<longrightarrow> y = varAP z) \<and> (\<forall> x . p = nodeAP x \<longrightarrow> x=z)))"

lemma Match_Aux1a[rule_format]:
"\<forall> S . (C, x, E, h, S) \<in> lookupAP \<longrightarrow> 
       (\<forall> z U kL T1 kR T2 a TT. z= root x \<longrightarrow> varAP z \<notin> U \<longrightarrow> 
                             GETr C (root x) = Some (muET SS) \<longrightarrow>
                             subst SS (muET SS) (sumET (kL,recET T1) (kR,recET T2)) \<longrightarrow>
                             renv E z = Ref a \<longrightarrow> x \<in> U \<longrightarrow> P U z \<longrightarrow>
                             ((h<a\<bullet>DOLLAR> = 0 \<longrightarrow> TT=T1) \<and> (h<a\<bullet>DOLLAR> \<noteq> 0 \<longrightarrow> TT=T2)) \<longrightarrow>
                             (C(z\<mapsto>\<^sub>f(recET TT)), x, E, h, S) \<in> lookupAP)"
apply (induct x)
apply clarsimp
apply clarsimp
  apply (erule lookupAP.elims, simp_all)
apply clarsimp
apply (subgoal_tac "AP=varAP (root AP)", clarsimp)
prefer 2 apply (simp add: P_def)
apply (erule lookupAP.elims,simp_all)
  apply clarsimp
    apply (erule lookupAP.elims,simp_all) apply clarsimp
    apply (drule subst_unique, assumption, clarsimp)
    apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
    apply (rule lookupAP_RfldRec) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def) apply fastsimp
    apply (case_tac "h<l\<bullet>DOLLAR> = 0", clarsimp,clarsimp)
  apply clarsimp
    apply (subgoal_tac "a=l", clarsimp) prefer 2 apply (case_tac p,clarsimp+)
    apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
    apply (case_tac "a \<in> Dom h", clarsimp) apply clarsimp
    apply (subgoal_tac "(C(root p\<mapsto>\<^sub>frecET TT), rfldAP (varAP (root p)) F, E, h, TTa) \<in> lookupAP", simp)
    apply (rule lookupAP_RfldRec) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def)
    apply fastsimp
    apply clarsimp
    apply (subgoal_tac "(C, varAP (root p), E, h, sumET (aa, b) (ab, ba)) \<in> lookupAP")
    prefer 2 apply simp
    apply (rotate_tac -1, erule lookupAP.elims, simp_all)
  apply clarsimp
    apply (subgoal_tac "(C(root p\<mapsto>\<^sub>frecET TT), rfldAP (varAP (root p)) F, E, h, TTa) \<in> lookupAP", simp)
    apply (rule lookupAP_RfldRec) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def)
    apply fastsimp
    apply clarsimp
    apply (erule lookupAP.elims, simp_all)
  apply clarsimp
    apply (subgoal_tac "(C(root p\<mapsto>\<^sub>frecET TT), rfldAP (varAP (root p)) F, E, h, TTa) \<in> lookupAP", simp)
    apply (rule lookupAP_RfldRec) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def)
    apply fastsimp
    apply clarsimp
    apply (erule lookupAP.elims, simp_all)
done

lemma Match_Aux2a[rule_format]:
"\<forall> S . (D, x, E, h, S) \<in> lookupAP \<longrightarrow> 
       (\<forall> C z U kL T1 kR T2 a TT. D=C(z\<mapsto>\<^sub>f(recET TT)) \<longrightarrow> z= root x \<longrightarrow> varAP z \<notin> U \<longrightarrow> 
                             GETr C (root x) = Some (muET SS) \<longrightarrow>
                             subst SS (muET SS) (sumET (kL,recET T1) (kR,recET T2)) \<longrightarrow>
                             renv E z = Ref a \<longrightarrow> x \<in> U \<longrightarrow> P U z \<longrightarrow>
                             ((h<a\<bullet>DOLLAR> = 0 \<longrightarrow> TT=T1) \<and> (h<a\<bullet>DOLLAR> \<noteq> 0 \<longrightarrow> TT=T2)) \<longrightarrow>
                             (C, x, E, h, S) \<in> lookupAP)"
apply (induct x)
apply clarsimp
apply clarsimp
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (simp add: GETr_def)
apply clarsimp
apply (subgoal_tac "AP=varAP (root AP)", clarsimp)
prefer 2 apply (simp add: P_def)
apply (erule lookupAP.elims,simp_all)
  apply clarsimp
    apply (erule lookupAP.elims,simp_all, clarsimp) apply (simp add: GETr_def)
  apply clarsimp
      apply (subgoal_tac "(C(root p\<mapsto>\<^sub>frecET TT), varAP (root p), E, h, sumET (aa, b) (ab, ba)) \<in> lookupAP")
      prefer 2 apply simp
      apply (rotate_tac -1) apply (erule lookupAP.elims, simp_all, clarsimp) apply (simp add: GETr_def)
  apply clarsimp
      apply (erule lookupAP.elims, simp_all, clarsimp)
      apply (simp add: GETr_def)
  apply clarsimp
      apply (erule lookupAP.elims, simp_all, clarsimp)
      apply (simp add: GETr_def)
      apply (case_tac "a:Dom h",clarsimp) prefer 2 apply clarsimp
      apply (rule lookupAP_Mu)
       apply (rule lookupAP_Var) apply (simp add: GETr_def)
          apply fastsimp
          apply fastsimp
          apply simp
          apply (case_tac "h<l\<bullet>DOLLAR> = 0", clarsimp, clarsimp)
done

lemma Match:
      "\<lbrakk>GETr C x = Some (muET S);
        subst S (muET S) (sumET (kL,recET T1) (kR,recET T2));
        G \<rhd> e1 : \<lbrace>U,n,C(x\<mapsto>\<^sub>f(recET T1)) \<ggreater> T, m\<rbrace>;
        G \<rhd> e2 : \<lbrace>U,n,C(x\<mapsto>\<^sub>f(recET T2)) \<ggreater> T, m\<rbrace>;
        varAP x \<notin> U; P U x\<rbrakk>
       \<Longrightarrow>
        G \<rhd> (LET t = x\<bullet>DOLLAR; b = Primop (\<lambda> x y . if x=0 then 1 else 0) t t IN IF b THEN e1 ELSE e2 END): \<lbrace>U,n,C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
apply (rule vdm_leti, rule vdm_prim)
apply (rule vdm_if) apply assumption apply assumption
apply (rotate_tac 2, erule thin_rl, erule thin_rl) 
apply clarsimp
apply (case_tac"h<a\<bullet>DOLLAR> = 0" )
  apply clarsimp apply (rule DAssC_PConst)
                 apply (rule DAss_Contexts_same_on_U) apply (erule DAss_PreservedU, rule, simp)
    apply clarsimp
    apply (case_tac "root xa = x") 
    prefer 2 apply rule apply (erule lookupAP_Update2, fast) apply (erule lookupAP_Update3, assumption, simp) 
    apply clarsimp apply rule apply (erule Match_Aux1a) apply simp apply assumption+ apply clarsimp
                              apply (erule Match_Aux2a) apply (simp, simp) apply assumption+ apply clarsimp
  apply clarsimp apply (rule DAssC_PConst)
                 apply (rule DAss_Contexts_same_on_U) apply (erule DAss_PreservedU, rule, simp)
    apply clarsimp
    apply (case_tac "root xa = x") 
    prefer 2 apply rule apply (erule lookupAP_Update2, fast) apply (erule lookupAP_Update3, assumption, simp) 
    apply clarsimp apply rule apply (erule Match_Aux1a) apply simp apply assumption+ apply clarsimp
                              apply (erule Match_Aux2a) apply (simp, simp) apply assumption+ apply clarsimp
done

lemma MATCH_Aux1a[rule_format]:
"\<forall> S . (C, x, E, h, S) \<in> lookupAP \<longrightarrow> 
       (\<forall> z U kL T1 kR T2 a TT. z= root x \<longrightarrow> varAP z \<notin> U \<longrightarrow> 
                             GETr C (root x) = Some (muET SS) \<longrightarrow>
                             subst SS (muET SS) (sumET (kL,recET T1) (kR,recET T2)) \<longrightarrow>
                             renv E z = Ref a \<longrightarrow> x \<in> U \<longrightarrow> P U z \<longrightarrow>
                             ((h<a\<bullet>DOLLAR> = 0 \<longrightarrow> k=kL \<and> TT=T1) \<and> (h<a\<bullet>DOLLAR> \<noteq> 0 \<longrightarrow> k=kR \<and> TT=T2)) \<longrightarrow>
                             (C(z\<mapsto>\<^sub>f(nodeET(k,recET TT))), x, E, h, S) \<in> lookupAP)"
apply (induct x)
apply clarsimp
apply clarsimp
  apply (erule lookupAP.elims, simp_all)
apply clarsimp
apply (subgoal_tac "AP=varAP (root AP)", clarsimp)
prefer 2 apply (simp add: P_def)
apply (erule lookupAP.elims,simp_all)
  apply clarsimp
    apply (erule lookupAP.elims,simp_all) apply clarsimp
    apply (drule subst_unique, assumption, clarsimp)
    apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
    apply (rule lookupAP_RfldNode) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def) apply (rule, fast, fast)
    apply simp apply (rule, fast,fast)
    apply (case_tac "h<l\<bullet>DOLLAR> = 0", clarsimp,clarsimp)
  apply clarsimp
    apply (subgoal_tac "a=l", clarsimp) prefer 2 apply (case_tac p,clarsimp+)
    apply (case_tac "a \<in> Dom h", clarsimp) prefer 2 apply clarsimp
    apply (case_tac "a \<in> Dom h", clarsimp) apply clarsimp apply clarsimp
    apply (subgoal_tac "(C(root p\<mapsto>\<^sub>f(nodeET(k,recET TT))), rfldAP (varAP (root p)) F, E, h, TTa) \<in> lookupAP", simp)
    apply (rule lookupAP_RfldNode) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def) apply (rule, fast, fast)
    apply simp apply (rule, fast, fast)
    apply (subgoal_tac "(C, varAP (root p), E, h, sumET (aa, b) (ab, ba)) \<in> lookupAP")
    prefer 2 apply simp
    apply (rotate_tac -1, erule lookupAP.elims, simp_all)
  apply clarsimp
    apply (subgoal_tac "(C(root p\<mapsto>\<^sub>f(nodeET(k,recET TT))), rfldAP (varAP (root p)) F, E, h, TTa) \<in> lookupAP", simp)
    apply (rule lookupAP_RfldNode) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def) apply (rule, fast, fast)
    apply fastsimp
    apply clarsimp
    apply (erule lookupAP.elims, simp_all)
  apply clarsimp
    apply (subgoal_tac "(C(root p\<mapsto>\<^sub>f(nodeET(k,recET TT))), rfldAP (varAP (root p)) F, E, h, TTa) \<in> lookupAP", simp)
    apply (rule lookupAP_RfldNode) 
    apply (rule lookupAP_Var) apply (simp add: GETr_def) apply (rule, fast, fast)
    apply fastsimp
    apply clarsimp
    apply (erule lookupAP.elims, simp_all)
done

lemma MATCH_Aux2a[rule_format]:
"\<forall> S . (D, x, E, h, S) \<in> lookupAP \<longrightarrow> 
       (\<forall> C z U kL T1 kR T2 a TT. D=C(z\<mapsto>\<^sub>f(nodeET(k,recET TT))) \<longrightarrow> z= root x \<longrightarrow> varAP z \<notin> U \<longrightarrow> 
                             GETr C (root x) = Some (muET SS) \<longrightarrow>
                             subst SS (muET SS) (sumET (kL,recET T1) (kR,recET T2)) \<longrightarrow>
                             renv E z = Ref a \<longrightarrow> x \<in> U \<longrightarrow> P U z \<longrightarrow>
                             ((h<a\<bullet>DOLLAR> = 0 \<longrightarrow> k=kL \<and> TT=T1) \<and> (h<a\<bullet>DOLLAR> \<noteq> 0 \<longrightarrow> k=kR \<and> TT=T2)) \<longrightarrow>
                             (C, x, E, h, S) \<in> lookupAP)"
apply (induct x)
apply clarsimp
apply clarsimp
  apply (erule lookupAP.elims, simp_all, clarsimp)
  apply (simp add: GETr_def)
  apply clarsimp
  apply (rule lookupAP_Node) 
sorry
(*apply clarsimp
apply (subgoal_tac "AP=varAP (root AP)", clarsimp)
prefer 2 apply (simp add: P_def)
apply (erule lookupAP.elims,simp_all)
  apply clarsimp
    apply (erule lookupAP.elims,simp_all, clarsimp) apply (simp add: GETr_def)
  apply clarsimp
      apply (subgoal_tac "(C(root p\<mapsto>\<^sub>frecET TT), varAP (root p), E, h, sumET (aa, b) (ab, ba)) \<in> lookupAP")
      prefer 2 apply simp
      apply (rotate_tac -1) apply (erule lookupAP.elims, simp_all, clarsimp) apply (simp add: GETr_def)
  apply clarsimp
      apply (erule lookupAP.elims, simp_all, clarsimp)
      apply (simp add: GETr_def)
  apply clarsimp
      apply (erule lookupAP.elims, simp_all, clarsimp)
      apply (simp add: GETr_def)
      apply (case_tac "a:Dom h",clarsimp) prefer 2 apply clarsimp
      apply (rule lookupAP_Mu)
       apply (rule lookupAP_Var) apply (simp add: GETr_def)
          apply fastsimp
          apply fastsimp
          apply simp
          apply (case_tac "h<l\<bullet>DOLLAR> = 0", clarsimp, clarsimp)
done
*)
lemma MATCH:
      "\<lbrakk>GETr C x = Some (muET S);
        subst S (muET S) (sumET (kL,recET T1) (kR,recET T2));
        G \<rhd> e1 : \<parallel>U,Some (nodeAP x), get_rfldAPs T1 x, n,C(x\<mapsto>\<^sub>f(nodeET(kL,recET T1))) \<ggreater> T, m\<parallel>;
        G \<rhd> e2 : \<lbrace>U,n,C(x\<mapsto>\<^sub>f(nodeET(kR,recET T2))) \<ggreater> T, m\<rbrace>;
        varAP x \<notin> U; P U x\<rbrakk>
       \<Longrightarrow>
        G \<rhd> (LET t = x\<bullet>DOLLAR; b = Primop (\<lambda> x y . if x=0 then 1 else 0) t t IN IF b THEN e1 ELSE e2 END): \<lbrace>U,n,C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
apply (rule vdm_leti, rule vdm_prim)
apply (rule vdm_if) apply assumption apply assumption
apply (rotate_tac 2, erule thin_rl, erule thin_rl) 
apply clarsimp
apply (case_tac"h<a\<bullet>DOLLAR> = 0" )
  apply clarsimp apply (simp add: DAss_def muDAss_def, clarsimp) 
    apply (erule_tac x=qapply (rule DAssC_PConst)
                 apply (rule DAss_Contexts_same_on_U) apply (erule DAss_PreservedU, rule, simp)
    apply clarsimp
    apply (case_tac "root xa = x") 
    prefer 2 apply rule apply (erule lookupAP_Update2, fast) apply (erule lookupAP_Update3, assumption, simp) 
    apply clarsimp apply rule apply (erule MATCH_Aux1a) apply simp apply assumption+ apply clarsimp
                              apply (erule Match_Aux2a) apply (simp, simp) apply assumption+ apply clarsimp
  apply clarsimp apply (rule DAssC_PConst)
                 apply (rule DAss_Contexts_same_on_U) apply (erule DAss_PreservedU, rule, simp)
    apply clarsimp
    apply (case_tac "root xa = x") 
    prefer 2 apply rule apply (erule lookupAP_Update2, fast) apply (erule lookupAP_Update3, assumption, simp) 
    apply clarsimp apply rule apply (erule Match_Aux1a) apply simp apply assumption+ apply clarsimp
                              apply (erule Match_Aux2a) apply (simp, simp) apply assumption+ apply clarsimp
done

lemma LETGET_HDTL_DAss:
"\<lbrakk>G \<rhd> e : \<parallel>U, Some (nodeAP l),[], n, C(t\<mapsto>\<^sub>f(iList HD TL kN kC)) \<ggreater> T, m\<parallel>;  l \<notin> roots U; varAP t:U;
  \<forall> p. p:U \<longrightarrow> (\<exists> x . p=varAP x);
  GETr C l = Some(nodeET(k, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]))\<rbrakk>
\<Longrightarrow>  G \<rhd> (LET h = l\<bullet>HD; rf t = l\<diamondsuit>TL IN e END) : \<lbrace>(U-{varAP t}) \<union> {varAP l},n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq)
apply (erule LETGET_HDTL)
  apply assumption+
apply clarsimp
apply (simp add: DAss_def muDAss_def, clarsimp)
apply (frule Yps_regionsExist)
  apply (rule, subgoal_tac "varAP l : insert (varAP l) (U - {varAP t})", assumption) apply fast
  apply (erule lookupAP_Var) 
apply clarsimp
apply (frule modelsETLocn, simp)
apply (frule modelsET_region_in_heap)
apply (case_tac "locns (renv E l) \<subseteq> Dom h", clarsimp) prefer 2 apply clarsimp
apply (drule Yps_split)
  apply (rule, subgoal_tac "varAP l : insert (varAP l) (U - {varAP t})", assumption) apply fast
  apply (erule lookupAP_Var) 
  apply clarsimp apply ((erule thin_rl)+, rule, fast, fast)
  apply assumption
apply clarsimp
apply (subgoal_tac "U - {varAP t} - {varAP l} = U - {varAP t}", clarsimp)
prefer 2 apply (case_tac "varAP l:U ") apply (simp add: roots_def) apply (erule_tac x="varAP l" in allE, clarsimp)
  apply clarsimp here -- maybe dont unfold Yps yet

apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=RRR in allE, erule_tac x=L in allE, erule impE)
  apply (rule_tac x=N in exI, simp)
  apply

lemma "\<lbrakk>G \<rhd> e : \<parallel>U, Some (nodeAP l),[], n, C(t\<mapsto>\<^sub>f(iList HD TL kN kC)) \<ggreater> T, m\<parallel>;  l \<notin> roots U; varAP t:U;
       \<forall> p. p:U \<longrightarrow> (\<exists> x . p=varAP x)\<rbrakk> \<Longrightarrow> 
      G \<rhd> (LET h = l\<bullet>HD; rf t = l\<diamondsuit>TL IN e END) : \<lbrace> U \<union> {varAP l} , n , C(l\<mapsto>\<^sub>frecET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]) \<ggreater>  T , m \<rbrace>"
apply (rule vdm_conseq)
  apply (erule LETGET_HDTL)
   apply assumption
   apply assumption
   apply assumption defer 1
apply clarsimp
  apply (simp add: DAss_def muDAss_def, clarsimp)
  apply (frule Yps_regionsExist)
    apply (rule, subgoal_tac "varAP l : insert (varAP l) U", assumption, fast)
    apply (rule lookupAP_Var) apply (simp add: GETr_def)
   apply (subgoal_tac "\<exists> LL RR RRR. (E,h,U,Some (nodeAP l), rfldAPs [(ifldn HD, intET), (rfldn TL, iList HD TL kN kC)], {l}, RRR,
                       C(l\<mapsto>\<^sub>f nodeET(kC, recET [(ifldn HD, intET), (rfldn TL, iList HD TL kN kC)])),LL,RR,kC+N) : mYps
                      \<and> R = RRR \<union> RR \<and> RRR \<inter> RR = {} \<and> L={l} \<union> LL")
  apply (subgoal_tac "(E, h, U \<union> {varAP l}, C(l\<mapsto>\<^sub>frecET [(ifldn HD, intET), (rfldn TL, iList HD TL kN kC)]), L, R, P) \<in> Yps",
      drule muUNFOLD)
  apply (erule_tac x=q in allE, erule_tac x=F in allE)
done
lemma muUNFOLD[rule_format]:
"\<lbrakk>GETr C x = Some(recET REC); distinct (map fst REC);
  evalAP (varAP x) E h = Some(Ref l,X);
     (E,h,U \<union> {varAP x},C,L,R,N):Yps; x \<notin> roots U;
     rfldAPs = get_rfldAPs REC x\<rbrakk>
 \<Longrightarrow> \<exists> LL RR RRR. (E,h,U,Some (nodeAP x), rfldAPs, {l}, RRR,
                       C(x\<mapsto>\<^sub>f nodeET(kC, recET REC)),LL,RR,kC+N) : mYps
                   \<and> R = RRR \<union> RR \<and> RRR \<inter> RR = {} \<and> L={l} \<union> LL
*)
(*lemma LETGET_HDTL:
"\<lbrakk>G \<rhd> e : \<parallel>U, Some (nodeAP l),[], n, C(t\<mapsto>\<^sub>f(iList HD TL kN kC)) \<ggreater> T, m\<parallel>;  l \<notin> roots U; varAP t:U;
  \<forall> p. p:U \<longrightarrow> (\<exists> x . p=varAP x);
  GETr C l = Some(nodeET(k, recET [(ifldn HD,intET), (rfldn TL,iList HD TL kN kC)]))\<rbrakk>
\<Longrightarrow>  G \<rhd> (LET h = l\<bullet>HD; rf t = l\<diamondsuit>TL IN e END) : \<parallel>U-{varAP t}, Some (nodeAP l), [rfldAP (nodeAP l) TL],n, C \<ggreater> T, m\<parallel>
*)
*)
