theory ISCertificate2 = ISCertificate1:

(*
ML_setup {*
 fun PrintMe tac i thm st = st |>  
   SUBGOAL (fn (prop,_) =>
      let val concl = Logic.strip_assums_concl prop in
          case concl of 
	  (Const ("Trueprop", _) $
	   (Const (_,_) $ G $ expr $ P)) =>
	      (case expr of 
		  Const("Expr.Call",_) $ Free(fnname,_) =>
		   (tracing ("^^ it is a CALL " ^ fnname); all_tac)
		| _ => (tracing "^^ it is not a CALL"; all_tac))
       end)

 fun print_me_tac tac i thm  = SUBGOAL (fn _ => (PrintMe tac i)) i thm
*}
*)

ML_setup {*
  fun weak_only_tac thms tac ctxt i = 
    EVERY
      [localsimp_tac_thms ctxt thms i,  (* expand SPEC, methtable *)
       rtac vcg_weak i]

  fun null_tac_trace ctxt i =
   EVERY [TRY (localsimp_tac ctxt i),
         (tracing ("__ NULL_TAC: trying null rules .. ");
          ((rtac vcg_nullresult i) THEN (localsimp_tac ctxt i))
          ORELSE ((rtac vcg_nulltree i) THEN (localsimp_tac ctxt i))
          ORELSE ((rtac vcg_nulllist i) THEN (localsimp_tac ctxt i)))]

  fun leaf_tac_trace ctxt thms i = 
  FIRST
   [(tracing ("__ LEAF_TAC: trying int, ivar, prim ...");
    resolve_tac [vcg_int, vcg_ivar, vcg_prim] i),
    (tracing ("__ LEAF_TAC: trying rvar ... ");
    EVERY [rtac vcg_rvar i, localsimp_tac ctxt i]),
    (tracing ("__ LEAF_TAC: trying prim ... ");
    resolve_tac [vcg_prim] i),
    (tracing ("__ LEAF_TAC: trying rprim ... ");
    EVERY [resolve_tac [vcg_rprim] i,
	   repeat 2 (localsimp_tac ctxt i)]),
    (tracing ("__ LEAF_TAC: trying makelist ... ");
    EVERY [resolve_tac [vcg_makelist] i,
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
           localsimp_tac ctxt i]),
    (tracing ("__ LEAF_TAC: trying makelist_ml ... ");
    EVERY [resolve_tac [vcg_makelist_ml] i,
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
	   repeat 3 (localsimp_tac ctxt i)]),
    (tracing ("__ LEAF_TAC: trying makeresult ... ");
    EVERY [resolve_tac [vcg_makeresult] i,
	   repeat 2 (localsimp_tac ctxt i)]),
    (tracing ("__ LEAF_TAC: trying maketree ... ");
    EVERY [resolve_tac [vcg_maketree] i,
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
	   repeat 2 (localsimp_tac ctxt i)]),
    stop_thms thms ctxt i,
    (tracing ("__ LEAF_TAC: trying inv_Rename ... ");
     inv_Rename_tac ctxt thms i),
   (tracing ("__ LEAF_TAC: THIS LEAF SUCKS ");
    all_tac)]

  fun if_tac_trace ctxt rec_tacTHEN rec_tacELSE i =
   EVERY [rtac vcg_if i,
          (tracing ("__ IF_TAC: doing else... ");
	  rec_tacELSE ctxt (i+1)),
          (tracing ("__ IF_TAC: doing then ");
          rec_tacTHEN ctxt i)]

  fun let_tac_trace ctxt thms rec_tac i =
   FIRST [EVERY [rtac vcg_letint i,
                 (tracing ("__ LET_TAC: letint ");
		  rec_tac ctxt i)],
          EVERY [rtac vcg_letprim i,
                 (tracing ("__ LET_TAC: letprim ");
		  rec_tac ctxt i)],
          EVERY [resolve_tac [vcg_letrprim] i,
                 (tracing ("__ LET_TAC: letrprim ");
	         localsimp_tac ctxt i),
	         localsimp_tac ctxt i,
	         rec_tac ctxt i],
	  EVERY [rtac vcg_letnull i,
                 (tracing ("__ LET_TAC: letnull ");
	         rec_tac ctxt (i+1)),
                 null_tac_trace ctxt (i+1),
		 localsimp_tac ctxt i],
          (tracing ("__ LET_TAC: letrmakelist ");
           letrmakelist_tac ctxt thms rec_tac i,
	  EVERY [rtac vcg_letrmakeresult i,
                 (tracing ("__ LET_TAC: letrmakeresult ");
	         repeat 2 (localsimp_tac ctxt i)),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i],
	  EVERY [rtac vcg_letrmaketree i,
                 (tracing ("__ LET_TAC: letrmaketree ");
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i]),
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
	         repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i]]

   fun l_tac6_trace (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac_trace ctxt (l_tac6_trace thms) (l_tac6_trace thms) i,
           let_tac_trace ctxt thms (l_tac6_trace thms) i,
           call_tac ctxt dmp_defs (l_tac6_trace thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac6_trace thms) (w_tac fun_defs (l_tac6_trace thms)) i,
           match_tac ctxt (l_tac6_trace thms) i,
           letrinvRename_tac ctxt thms (l_tac6_trace thms) i,
           letiinvRename_tac ctxt thms (l_tac6_trace thms) i,
           null_tac_trace ctxt i,
           leaf_tac_trace ctxt thms i]

   fun l_tac6_norec_trace (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac_trace ctxt (stop_thms thms) (stop_thms thms) i,
           let_tac_trace ctxt thms (stop_thms thms) i,
           call_tac ctxt dmp_defs (stop_thms thms ctxt) i,
           dom_tac ctxt fun_defs (stop_thms thms) (w_tac fun_defs (stop_thms thms)) i,
           match_tac ctxt (stop_thms thms) i,
           letrinvRename_tac ctxt thms (stop_thms thms) i,
           letiinvRename_tac ctxt thms (stop_thms thms) i,
           null_tac_trace ctxt i,
           leaf_tac_trace ctxt thms i]

*}
(*
method_setup print_me = {*
  Method.no_args
    (Method.SIMPLE_METHOD' HEADGOAL (print_me_tac (all_tac) ))  *}
  "petaQ bortaS"
*)
method_setup Wp = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast" 

method_setup Wp_trace = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6_trace (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast" 

method_setup Wp_norec_trace = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6_norec_trace (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast" 


method_setup Bonzo1 = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms "meth_defs") stop  ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast" 

method_setup Bonzo2 = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => weak_only_tac (thms "meth_defs") stop  ctxt 1)) *}
 "parametric Method for starting: use weakening, simplification with args, fast" 

(* needs debugging; generic Wp tactic doesn't work *)
lemma ins_Correct: " Context \<rhd> snd (methtable IS IS'ins) : SPEC IS'ins" 
apply (Wp_norec_trace ins_pdefs)

apply (simp add: ins_pdefs)
apply (rule vcg_call)
apply (simp add: dmp_defs)
apply (rule vcg_domcallnil)
apply (simp add: Context_def)
apply (simp add: ins_pdefs)
apply (rule vdm_conseq)
apply (rule vcg_letrprim)
prefer 4
apply clarsimp
apply simp
apply simp
apply simp
apply (Bonzo2 ins_pdefs)
apply (rule DA_If)
prefer 3
apply fastsimp
apply (rule vcg_call)
apply (simp add: dmp_defs)
apply (rule vcg_domcallnil)
apply simp
apply (simp add: ins_pdefs)
apply (rule vdm_conseq)
apply (rule vcg_letnull)
prefer 3
apply (rule DA_NullList)

apply (tactic {* all_tac *})
apply (tactic {* no_tac *})

apply clarsimp
sorry

lemma sort_Correct: " Context \<rhd> snd (methtable IS IS'sort) : SPEC IS'sort" 
 by (Wp sort_pdefs)

lemmas MethodbodiesCorrect =  ins_Correct sort_Correct

end
