theory InsSortDestrProof = InsSortDestrProg + VCG:

defs
isMergePoint_def: "isMergePoint f == False"

dominates_def:
"dominates f == []"

defs SPEC_def:"SPEC M == 
  (if M = Ins then \<lbrace> {l_}, 1, emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0 0)) \<ggreater> ListET 0 0, 0\<rbrace> else
  if M = Sort then \<lbrace> {l_}, 0, emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0 0)) \<ggreater> ListET 0 0, 0\<rbrace> else
  (\<lambda> E h hh v p . False))"
text{*FST and vMST remain unspecified.*}

text {*In order to prove the body correct we define a 
       context which contains an one entry for each syntactic method invocation.*}
constdefs  InsSortContext:: vdmcontext
"InsSortContext \<equiv> {(InsSort\<bullet>Ins([INarg a_,RNarg v2_]), sMST InsSort Ins [INarg a_, RNarg v2_]),
                   (InsSort\<bullet>Ins([INarg v3_,RNarg l_]), sMST InsSort Ins [INarg v3_, RNarg l_]),
                   (InsSort\<bullet>Sort([RNarg v2_]), sMST InsSort Sort [RNarg v2_])}"
lemmas context_simp = InsSortContext_def

lemma InsContext_finite[simp]: "finite InsSortContext"
by (simp add: InsSortContext_def)

lemmas dmp_defs = dominates_def isMergePoint_def 
lemmas meth_defs = Meth_Ins Meth_Sort SPEC_def
lemmas ins_pdefs = Meth_Ins Fun_fIns Fun_fzeroIns Fun_foneIns Fun_ftwoIns Fun_fthreeIns SPEC_def
lemmas sort_pdefs = Meth_Sort Fun_fSort Fun_fzeroSort Fun_foneSort Meth_Ins SPEC_def
lemmas ctxt_def  = InsSortContext_def

method_setup Wp = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast" 

lemma Sort_DAss:
"InsSortContext \<rhd> snd (methtable InsSort Sort) : SPEC Sort"
by (Wp sort_pdefs)

lemma Ins_DAss:
"InsSortContext \<rhd> snd (methtable InsSort Ins) : SPEC Ins"
by (Wp ins_pdefs)

lemmas DAss_lemmas = Sort_DAss Ins_DAss

(*This lemma is absolutely trivial, but it allows us to unfold the InssortContext more cautiously*)
lemma triv: "\<lbrakk>x:S; S=S1; x:S1 \<longrightarrow> P\<rbrakk>\<Longrightarrow> P" by simp

lemma InsSortContext_good: "goodContext FST vMST sMST InsSortContext"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (rule disjI2, rule disjI2)
apply (erule triv, simp add: InsSortContext_def)
apply safe
by (simp only: sMST_def, clarsimp, rule vdm_conseq, rule DAss_lemmas, 
    clarify, simp add: SPEC_def , erule DAss_PConst)+

text {*Thus, we can prove that arbitrary invocations of @{text Sort} honour
       the entry in the specification table, in the empty VDM context.*}
theorem ISCorrect: "\<rhd> InsSort\<bullet>Sort([RNarg x]): sMST InsSort Sort [RNarg x]"
apply (rule GCInvs)
apply (rule InsSortContext_good)
apply (simp_all add: InsSortContext_def)
apply fastsimp
done 

theorem "\<rhd> InsSort\<bullet>Sort([RNarg y]): \<lbrace> {y}, 0 , (emptyfinmap(y \<mapsto>\<^sub>f(ListET 0 0)))  \<ggreater> (ListET 0 0) , 0 \<rbrace>"
apply (rule InvokeRename)
apply (rule ISCorrect)
apply (simp_all add: meth_defs newframe_env_def evalARGS_def)
apply (fastsimp intro: REN.intros)
apply simp+
done

end
