theory InsSortWrap = InsSortCertificate23:

section {* 4. WRAPPER for heap bound *}

consts init :: mname
       INPUT :: "ARG list"

syntax
       wrap_r1_ :: rname

translations
     "wrap_r1_" == "(RN ''Wrapper'main'wrap_r1_'') "

constdefs emptyheap :: "heap"
"emptyheap == (| oheap = emptyfinmap, iheap = (\<lambda> x r . (0::int)) , rheap = (\<lambda> x r. Nullref), sheap = (\<lambda> c r . Nullref) |)"

constdefs emptyenv :: "env"
"emptyenv == (| ienv = emptyi , renv = emptyr |)"

(* spec of <init> *)
constdefs initTable :: "bool"
"initTable == (sMST InsSort init =
   (\<lambda> args E h hh v p . 
                   (\<forall> n  . 
                      h = emptyheap \<and> E = emptyenv \<and> n = length args
                      \<longrightarrow>
                      (\<exists> a z X Xfl Nfl .
                       v = RVal (Ref a) \<and> 
                       (z,n,Ref a,X,hh) \<in> mLIST \<and>
                       freelist hh Xfl Nfl \<and> X \<inter> Xfl = {} \<and>
                       ((HSize hh) = (HSize h) + (int n))))))"

consts fullContext :: "vdmcontext"

constdefs isFullContext :: "bool"
"isFullContext == (Context \<subseteq> fullContext) \<and> (InsSort\<bullet>InsSort'sort([RNarg wrap_r1_]), sMST InsSort InsSort'sort [RNarg wrap_r1_]) : fullContext \<and> (\<forall> l . (InsSort\<bullet>init(l), sMST InsSort init l) \<in> fullContext)"

lemma bonzo[rule_format]: "\<And> C M x y a. [| fst (methtable C M) = [RNpar y] |] ==> 
             Ref a = renv (newframe_env Nullref (fst (methtable C M)) [RNarg x] emptyenv\<lfloor>x:=Ref a\<rfloor>) y"
apply clarsimp
apply (simp add: newframe_env_def evalARGS_def)
done

(* prove vanilla resource property; needs context in this version *)
theorem wrappedThm: "\<lbrakk>  initTable ; isFullContext \<rbrakk> \<Longrightarrow> 
                    \<forall> INPUT . fullContext \<rhd> (LET rf wrap_r1_ = InsSort\<bullet>init(INPUT) 
                                              IN 
                                                InsSort\<bullet>InsSort'sort([RNarg wrap_r1_]) 
                                              END) : (\<lambda> E h hh v p . 
     (\<forall> n  .
        h = emptyheap \<and> E = emptyenv \<and> n = length INPUT
        \<longrightarrow>
        (HSize hh <= (int n))))"
apply (rule allI)
apply (rule vdm_conseq)
apply (rule vdm_letr)
(* use spec of init for let-header *)
apply (rule vdm_ax) 
apply (simp only: isFullContext_def) apply (erule conjE)+
apply (erule_tac x="INPUT" in allE)
apply fastsimp
(* use spec of sort for let-body *)
apply (rule vdm_ax) 
apply (simp only: isFullContext_def) apply (erule conjE)+
apply simp
(*
apply (rule set_rev_mp)
 prefer 2 
 apply simp
 apply (simp add: Context_def)
*)
(* 1 subgoal: the vanilla theorem on space consumption
   it always has the following structure: 
     pre-heap and env is empty  -->  post-heap-size is bounded  *)
apply clarify
apply (simp add: initTable_def sMST_def SPEC_def)
(* apply (erule thin_rl) *) (* nuke spec of init; not needed anymore *)
apply clarify
apply (simp add: DAss_def)
apply (rename_tac Nfl)
(* now fill in data in the unfolded DAss; ToDo: don't unfold at all! *)
apply (erule_tac x="0" in allE)
apply (erule_tac x="Xfl" in allE)
apply (erule_tac x="X" in allE)
apply (drule mp)
apply (rule_tac x="Nfl" in exI) 
 (* freelist *)
 apply (rule conjI) apply assumption
 (* regionsExist *)
 apply (rule_tac x="0" in exI)
 apply (rule conjI)
 apply (simp add: regionsExist_def)
 apply clarify?
  apply (rule CS_CONS)
  apply simp
  apply simp defer 1
  apply simp apply (rule CS_NIL)
   apply simp
   apply simp
   apply simp
   apply simp
   apply simp
  apply simp
  prefer 2
  (* 1 subgoal: ... : reg *)
  apply (rule regList)
  apply (subgoal_tac "Ref a = renv (newframe_env Nullref (fst (methtable InsSort InsSort'sort))
                  [RNarg wrap_r1_] emptyenv\<lfloor>wrap_r1_:=Ref a\<rfloor>)
            l_7_")
   apply simp
   apply (rule bonzo)
   apply (simp add: meth_defs)
 apply simp
(* bounded size of result heap *)
apply (erule exE)+ apply (erule conjE)+
apply clarsimp
apply (subgoal_tac "int (card (Dom emptyheap)) = 0")
 apply clarsimp
 apply (simp add: emptyheap_def)
done

end

