theory InsSortCertificate3 = InsSortCertificate2:
(*This file could be either produced by the producer or the consumer,
  since it only depends on information available in the Grail-file*)

(*Anyway, the generation of the first two lemmas is trivial (they are hardwired),
and the rest depends on wrapper/policy/..*)

(*This lemma is absolutely trivial, but it allows us to unfold the 
  Context more cautiously. For now, we keep it literally in the certificate,
  although I should probably move it to the VCG image file, or eliminate it
  completely.*)
lemma triv: "\<lbrakk>x:S; S=S1; x:S1 \<longrightarrow> P\<rbrakk>\<Longrightarrow> P" by simp

(*Likewise, the name, statement, and proof of the following lemma are hardwired*)
lemma Context_good: "goodContext FST vMST sMST Context"
apply (simp only: goodContext_def)
apply (intro strip)
apply (rule disjI2)+
apply (erule triv, simp add: ctxt_def,safe)
by (simp add: sMST_def, intro strip, rule vdm_conseq,
rule MethodbodiesCorrect,intro strip,simp add: SPEC_def , erule DAss_PConst)+


consts PRE_CONST_InsSort'sort :: nat
consts PRE_FACT_InsSort'sort :: nat
consts POST_CONST_InsSort'sort :: nat
consts POST_FACT_InsSort'sort :: nat

defs PRE_CONST_InsSort'sort_def: "PRE_CONST_InsSort'sort  == 0"
defs PRE_FACT_InsSort'sort_def: "PRE_FACT_InsSort'sort   == 0"
defs POST_CONST_InsSort'sort_def: "POST_CONST_InsSort'sort == 0"
defs POST_FACT_InsSort'sort_def: "POST_FACT_InsSort'sort  == 0"

declare
 PRE_CONST_InsSort'sort_def
 PRE_FACT_InsSort'sort_def
 POST_CONST_InsSort'sort_def
 POST_FACT_InsSort'sort_def
[simp]

(*don't know what the top-level claim should be - here is one that refers to 
  the entry for sort in the method specification table*)
theorem T: "\<rhd> InsSort\<bullet>InsSort'sort([RNarg x]): sMST InsSort InsSort'sort [RNarg x]"
by( fastsimp intro: Context_good GCInvs simp: ctxt_def)

(*maybe the following form is more suitable for the wrapper?*)
theorem TT: "\<rhd> InsSort\<bullet>InsSort'sort([RNarg y]): \<lbrace> {y}, 0 , (emptyfinmap(y \<mapsto>\<^sub>f(ListET 0 0)))  \<ggreater> (ListET 0 0) , 0 \<rbrace>"
by (fastsimp intro: InvokeRename T REN.intros 
             simp add: meth_defs newframe_env_def evalARGS_def)

(*maybe the following form is more suitable for the wrapper?*)
theorem TT': "\<rhd> InsSort\<bullet>InsSort'sort([RNarg y]): \<lbrace> {y}, PRE_CONST_InsSort'sort , (emptyfinmap(y \<mapsto>\<^sub>f(ListET 0 PRE_FACT_InsSort'sort)))  \<ggreater> (ListET 0 POST_FACT_InsSort'sort) , POST_CONST_InsSort'sort \<rbrace>"
apply (simp add: PRE_CONST_InsSort'sort_def PRE_FACT_InsSort'sort_def POST_CONST_InsSort'sort_def POST_FACT_InsSort'sort_def)
apply (rule TT)
done

theorem TT': "\<rhd> InsSort\<bullet>InsSort'sort([RNarg y]): \<lbrace> {y}, PRE_CONST_InsSort'sort , (emptyfinmap(y \<mapsto>\<^sub>f(ListET 0 PRE_FACT_InsSort'sort)))  \<ggreater> (ListET 0 POST_FACT_InsSort'sort) , POST_CONST_InsSort'sort \<rbrace>"
apply (simp add: PRE_CONST_InsSort'sort_def PRE_FACT_InsSort'sort_def POST_CONST_InsSort'sort_def POST_FACT_InsSort'sort_def)
by (fastsimp intro: InvokeRename T REN.intros 
             simp add: meth_defs newframe_env_def evalARGS_def)



(*maybe some stuff for the wrapper should go here, depending what kind of
 policies we want.*)

(* --------------------------------------------------------------------------- *)
(* WRAPPER for heap bound *)

consts init :: mname
(*
       x :: rname
       y :: rname
*)
       INPUT :: "ARG list"

constdefs emptyheap :: "heap"
"emptyheap == (| oheap = emptyfinmap, iheap = (\<lambda> x r . (0::int)) , rheap = (\<lambda> x r. Nullref), sheap = (\<lambda> c r . Nullref) |)"

constdefs emptyenv :: "env"
"emptyenv == (| ienv = emptyi , renv = emptyr |)"

consts PRE_CONST_init :: nat
consts PRE_FACT_init :: nat

defs PRE_CONST_init_def: "PRE_CONST_init == 0"
defs PRE_FACT_init_def: "PRE_FACT_init == 1"

declare
 PRE_CONST_init_def
 PRE_FACT_init_def
 [simp]
 
(* spec of <init> *)
constdefs initTable :: "bool"
"initTable == (sMST InsSort init =
   (\<lambda> args E h hh v p . 
                   (\<forall> n  . 
                      h = emptyheap \<and> E = emptyenv \<and> n = length args
                      \<longrightarrow>
                      (\<exists> a z X Xfl Nfl .
                       v = RVal (Ref a) \<and> 
                       (z,n,Ref a,X,hh) \<in> mLIST \<and>
                       freelist hh Xfl Nfl \<and> X \<inter> Xfl = {} \<and>
                       HSize hh = HSize h + (int (PRE_CONST_init + PRE_FACT_init * n))))))"


consts fullContext :: "vdmcontext"

constdefs isFullContext :: "bool"
"isFullContext == (Context \<subseteq> fullContext) \<and> (\<forall> l . (InsSort\<bullet>init(l), sMST InsSort init l) \<in> fullContext)"

lemma bonzo[rule_format]: "\<And> C M x y a. [| fst (methtable C M) = [RNpar y] |] ==> 
             Ref a = renv (newframe_env Nullref (fst (methtable C M)) [RNarg x] emptyenv\<lfloor>x:=Ref a\<rfloor>) y"
apply clarsimp
apply (simp add: newframe_env_def evalARGS_def)
done

(* prove vanilla resource property; needs context in this version *)
theorem wrappedThm: "\<lbrakk>  initTable ; isFullContext \<rbrakk> \<Longrightarrow> 
                    \<forall> INPUT . fullContext \<rhd> (LET rf InsSort'sort'r1 = InsSort\<bullet>init(INPUT) 
                                              IN 
                                                InsSort\<bullet>InsSort'sort([RNarg InsSort'sort'r1]) 
                                              END) : (\<lambda> E h hh v p . 
     (\<forall> n  .
        h = emptyheap \<and> E = emptyenv \<and> n = length INPUT
        \<longrightarrow>
        (HSize hh <= int ((PRE_CONST_init + PRE_CONST_InsSort'sort) + (PRE_FACT_init + PRE_FACT_InsSort'sort) * n) )))"
apply (rule allI)
apply (rule vdm_conseq)
apply (rule vdm_letr)
(* use spec of init for let-header *)
apply (rule vdm_ax) 
apply (simp only: isFullContext_def) apply (erule conjE)+
apply (erule_tac x="INPUT" in allE)
apply fastsimp
(* use spec of sort for let-body *)
apply (rule vdm_ax) 
apply (simp only: isFullContext_def) apply (erule conjE)+
apply (rule set_rev_mp)
 prefer 2 
 apply simp
 apply (simp add: Context_def)
(* 1 subgoal: the vanilla theorem on space consumption
   it always has the following structure: 
     pre-heap and env is empty  -->  post-heap-size is bounded  *)
apply clarify
apply (simp add: initTable_def sMST_def SPEC_def)
apply (erule thin_rl) (* nuke spec of init; not needed anymore *)
apply clarify
apply (simp add: DAss_def)
apply (rename_tac Nfl)
(* now fill in data in the unfolded DAss; ToDo: don't unfold at all! *)
apply (erule_tac x="0" in allE)
apply (erule_tac x="Xfl" in allE)
apply (erule_tac x="X" in allE)
apply (drule mp)
apply (rule_tac x="Nfl" in exI) 
 (* freelist *)
 apply (rule conjI) apply assumption
 (* regionsExist *)
 apply (rule_tac x="0" in exI)
 apply (rule conjI)
 apply (simp add: regionsExist_def)
 apply clarify?
  apply (rule CS_CONS)
  apply simp
  apply simp defer 1
  apply simp apply (rule CS_NIL)
   apply simp
   apply simp
   apply simp
   apply simp
   apply simp
  apply simp
  prefer 2
  (* 1 subgoal: ... : reg *)
  apply (rule regList)
  apply (subgoal_tac "Ref a = renv (newframe_env Nullref (fst (methtable InsSort InsSort'sort))
                  [RNarg InsSort'sort'r1] emptyenv\<lfloor>InsSort'sort'r1:=Ref a\<rfloor>)
            InsSort'sort'l")
   apply simp
   apply (rule bonzo)
   apply (simp add: meth_defs)
 apply simp
(* bounded size of result heap *)
apply (erule exE)+ apply (erule conjE)+
apply clarsimp
apply (subgoal_tac "int (card (Dom emptyheap)) = 0")
 apply clarsimp
 apply (simp add: emptyheap_def)
done

end

