theory InsSort2 = DAss_rulesU2:

subsection{*Insertion into list*}

text {* Camelot file:progs/Camelot/examples/InsSort.cmlt
        Grail file: camelot -g -n InsSort
        
*}

syntax a_    :: iname
       b_    :: iname
       v3_   :: iname
       v2_   :: rname
       l_    :: rname 

       fIns :: funame
       fzeroIns :: funame
       foneIns :: funame
       ftwoIns :: funame
       fthreeIns :: funame
       Ins :: mname

       fSort :: funame
       fzeroSort :: funame
       foneSort :: funame
       Sort :: mname

translations
 "a_" == "(In ''a'') "
 "b_" == "(In ''b'') "
 "v3_" == "(In ''v3'') "
 "v2_" == "(RN ''v2'') "
 "l_" == "(RN ''l'') "
 "fIns" == "(FN ''fIns'') "
 "fzeroIns" == "(FN ''f_zeroIns'')"
 "foneIns" == "(FN ''f_oneIns'')"
 "ftwoIns" == "(FN ''f_twoIns'')"
 "fthreeIns" == "(FN ''f_threeIns'')"
 "Ins" == "(MN ''Ins'')"
 "fSort" == "(FN ''fSort'') "
 "fzeroSort" == "(FN ''f_zeroSort'')"
 "foneSort" == "(FN ''f_oneSort'')"
 "Sort" == "(MN ''Sort'')"

axioms Meth_Ins: 
"methtable DIAM Ins = ([INpar a_,RNpar l_], CALL fIns)"

axioms Fun_fIns:
"funtable fIns = ([RNpar l_],
                    LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                    IN IF b_ THEN CALL fzeroIns ELSE CALL foneIns END)"

axioms Fun_fzeroIns:
"funtable fzeroIns = ([RNpar l_],
                       LET rf l_ = Null 
                       IN DIAM\<bullet>Make_IID ([VALarg (IVal 1),INarg a_, RNarg l_]) END)"

axioms Fun_foneIns:
"funtable foneIns =
       ([RNpar l_],
        LET v3_ = GetFi l_ F0;
         rf v2_ = GetFr l_ F1;
              _ = DIAM\<bullet>Free ([RNarg l_]);
             b_ = Primop (\<lambda> x y . if x < y then 1 else 0) a_ v3_
        IN IF b_ THEN CALL ftwoIns ELSE CALL fthreeIns END)"

axioms Fun_ftwoIns:
"funtable ftwoIns =
      ([RNpar v2_, INpar v3_],
       LET rf l_ = DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v3_, RNarg v2_])
       IN DIAM\<bullet>Make_IID([VALarg (IVal 1), INarg a_, RNarg l_]) END)"

axioms Fun_fthreeIns:
"funtable fthreeIns =
      ([RNpar v2_, INpar v3_],
        LET rf l_ = DIAM\<bullet>Ins([INarg a_, RNarg v2_])
        IN DIAM\<bullet>Make_IID([VALarg (IVal 1), INarg v3_, RNarg l_]) END)"

axioms Meth_Sort: 
"methtable DIAM Sort = ([RNpar l_], CALL fSort)"

axioms Fun_fSort:
"funtable fSort = ([RNpar l_],
                    LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                    IN IF b_ THEN CALL fzeroSort ELSE CALL foneSort END)"

axioms Fun_fzeroSort:
"funtable fzeroSort = ([],Null)"

axioms Fun_foneSort:
"funtable foneSort =
      ([RNpar l_],
        LET v3_ = GetFi l_ F0;
         rf v2_ = GetFr l_ F1;
              _ = DIAM\<bullet>Free ([RNarg l_]);
          rf l_ = DIAM\<bullet>Sort ([RNarg v2_])
        IN DIAM\<bullet>Ins ([INarg v3_, RNarg l_]) END)"

end
