(*<*)
theory GenSafetyPolicy = VDMSoundRecPC + VDMCompletePC:
(*>*)



lemma weak_spec [rule_format]: "G \<rhd> e : P \<Longrightarrow> \<forall> G'. G \<subseteq> G' \<longrightarrow> G' \<rhd> e : P"
(* proof by induction *)
apply (erule vdm_proof.induct)
apply (rule allI impI)+ apply (rule vdm_null)
apply (rule allI impI)+ apply (rule vdm_int)
apply (rule allI impI)+ apply (rule vdm_ivar)
apply (rule allI impI)+ apply (rule vdm_rvar)
apply (rule allI impI)+ apply (rule vdm_prim)
apply (rule allI impI)+ apply (rule vdm_rprim)
apply (rule allI impI)+ apply (rule vdm_getfi)
apply (rule allI impI)+ apply (rule vdm_getfr)
apply (rule allI impI)+ apply (rule vdm_putfi)
apply (rule allI impI)+ apply (rule vdm_putfr)
apply (rule allI impI)+ apply (rule vdm_getstat)
apply (rule allI impI)+ apply (rule vdm_putstat)
apply (rule allI impI)+ apply (rule vdm_new)
(***)
apply (rule allI impI)+ apply (rule vdm_if)
apply (erule_tac x=G' in allE)
apply (drule mp) apply assumption
apply assumption
apply (rotate_tac 3)
apply (erule_tac x=G' in allE)
apply (drule mp) apply assumption
apply assumption
(***)
apply (rule allI impI)+ apply (rule vdm_leti)
apply (erule_tac x=G' in allE)
apply (drule mp) apply assumption
apply assumption
apply (rotate_tac 3)
apply (erule_tac x=G' in allE)
apply (drule mp) apply assumption
apply assumption
(***)
apply (rule allI impI)+ apply (rule vdm_letr)
apply (erule_tac x=G' in allE)
apply (drule mp) apply assumption
apply assumption
apply (rotate_tac 3)
apply (erule_tac x=G' in allE)
apply (drule mp) apply assumption
apply assumption
(***)
apply (rule allI impI)+ apply (rule vdm_letv)
apply (erule_tac x=G' in allE)
apply (drule mp) apply assumption
apply assumption
apply (rotate_tac 3)
apply (erule_tac x=G' in allE)
apply (drule mp) apply assumption
apply assumption
(***)
apply (rule allI impI)+ apply (rule vdm_call)
apply (erule_tac x="({(CALL f, P)} \<union> G')" in allE)
apply (drule mp) apply fast apply assumption
(***)
apply (rule allI impI)+ apply (rule vdm_invokestatic)
apply (erule_tac x="({(C\<bullet>mn(args), P)} \<union> G')" in allE)
apply (drule mp) apply fast apply assumption
(***)
apply (rule allI impI)+ apply (rule vdm_invoke)
apply (rule allI)
apply (erule_tac x=C in allE)
apply (erule conjE)
apply (erule_tac x="({(x\<diamondsuit>mn(args), P)} \<union> G')" in allE)
apply (drule mp) apply fast apply assumption
(***)
apply (rule allI impI)+ apply (rule vdm_ax)
apply fast
(***)
apply (rule allI impI)+ apply (rule vdm_conseq)
apply (erule_tac x=G' in allE)
apply (drule mp) apply fast apply assumption
apply assumption
done

lemma weak_empty_spec:
" \<rhd> e : P \<Longrightarrow> G \<rhd> e : P"
apply (rule_tac G'=G and G="{}" in weak_spec)
apply assumption apply fast
done



section {* Generic Safety Policy*}

text {* The initial interest arised due to the difficulties with proof
of let-rules for different instances and necessity of 
proof modularisation. *}
text {* The further research was inspired by Wildmoser-Nipkow
paper "Cerifying Macine Code Safety \<dots>" (pointed by Alberto) containing
some generics in its part 2.3. *}

subsection {* Generic semantical safety policy *}

text {* The notion of "validity" is subsituted with
more specific notion of "safety". "Safety" is 
"validiy", where an assertion P has a specific form
"PolicyPred \<Rightarrow> PolicyPost" called "safety policy". *}


constdefs  safe :: 
"expr \<Rightarrow>  ('a \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool) \<Rightarrow> ('a \<Rightarrow> vdmassn) \<Rightarrow> bool"  
"safe e PolicyPre PolicyPost   \<equiv> 
\<forall> E h hh v p . \<forall> X. (E \<turnstile> h,e \<Down> hh,v,p) \<longrightarrow> PolicyPre X E h \<longrightarrow>  PolicyPost X E h hh v p"

(*** ??? or P \<longrightarrow> PlicyPre \<longrightarrow> PolicyPost **)
(*constdefs safe_ctxt ::
"vdmtuple set \<Rightarrow> ('a \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool) \<Rightarrow> ('a \<Rightarrow> vdmassn) \<Rightarrow> bool"
"safe_ctxt G PolicyPre PolicyPost  \<equiv>
\<forall> (e,P) \<in> G . safe e PolicyPre PolicyPost"

constdefs  safe_in_ctxt :: 
"vdmtuple set \<Rightarrow> expr \<Rightarrow>  ('a \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool) \<Rightarrow> ('a \<Rightarrow> vdmassn) \<Rightarrow> bool"  
"safe_in_ctxt G e PolicyPre PolicyPost   \<equiv> 
safe_ctxt G PolicyPre PolicyPost \<longrightarrow> safe e PolicyPre PolicyPost"
*)

text {* Generlisation: an expression is safe if
a set of assumption about calls (from a context) is valid *}

constdefs  safe_in_ctxt :: 
"vdmtuple set \<Rightarrow> expr \<Rightarrow>  ('a \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool) \<Rightarrow> ('a \<Rightarrow> vdmassn) \<Rightarrow> bool"  
"safe_in_ctxt G e PolicyPre PolicyPost   \<equiv> 
|\<Turnstile> G  \<longrightarrow> safe e PolicyPre PolicyPost"


subsection {* Generic Assertion : Syntactical safety policy *}

constdefs Impl :: "('a \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool) \<Rightarrow> ('a \<Rightarrow> vdmassn) \<Rightarrow> vdmassn"
                    ("_ \<Rightarrow> _" 1000)
"Impl Fpre  Fpost  \<equiv> \<lambda> E h h' v p. \<forall> X.  Fpre X E h \<longrightarrow>  Fpost X E h h' v p"


lemma Impl_sound:
"\<rhd> e : (Fpre \<Rightarrow> Fpost) \<Longrightarrow> safe e Fpre Fpost"
apply (drule vdm_sound)
apply (simp only: vdm_valid_def)
apply (simp only: safe_def)
apply (simp only: Impl_def)
apply fast
done

axioms strongContextFin: "finite strongContext"


lemma Impl_complete:
"safe e Fpre Fpost \<Longrightarrow> \<rhd> e : (Fpre \<Rightarrow> Fpost)"
apply (rule vdm_complete)
apply (rule strongContextFin)
apply (simp only: vdm_valid_def)
apply (simp only: safe_def)
apply (simp only: Impl_def)
apply fast
done

lemma Impl_sound_ctxt:
"G \<rhd> e : (Fpre \<Rightarrow> Fpost) \<Longrightarrow> safe_in_ctxt G e Fpre Fpost"
apply (drule vdm_sound_ctxt)
apply (simp only: vdm_valid_in_ctxt_def)
apply (simp only: safe_in_ctxt_def)
apply (rule impI)
apply (drule mp) apply assumption
apply (simp only: vdm_valid_def)
apply (simp only: safe_def)
apply (simp only: Impl_def)
apply fast
done

text {* ??? *}
text {* Completeness on any G is not proven. Anyway, we eveintually
are interested in pure safety of the form "safe e Pre Post",
that is in specification on the empty context. Nonempty contexts
are used as intermediate steps in deriving specifications. *}


section {* Generic derived rules *}

lemma gvdm_basic:
"\<lbrakk>G \<rhd> cmd : Pbasic; 
\<forall> E h hh v p . (Pbasic  E h hh v p ) \<longrightarrow> ((Fpre \<Rightarrow> Fpost)  E h hh v p ) \<rbrakk> \<Longrightarrow>
G \<rhd> cmd : Fpre \<Rightarrow> Fpost"
apply (rule_tac P=Pbasic and Q="Fpre \<Rightarrow> Fpost" in vdm_conseq)
apply assumption+
done

lemma gvdm_if: 
"\<lbrakk> G \<rhd> e1 : (Fpre \<Rightarrow> Fpost); 
   G \<rhd> e2 : (Fpre \<Rightarrow> Fpost);
   \<exists> (Fpost' :: 'a \<Rightarrow> env \<Rightarrow>heap \<Rightarrow> heap \<Rightarrow> val \<Rightarrow> bool). 
    \<forall> E h hh v p. \<forall> X. Fpost'  X E h hh v = Fpost X  E h hh v p\<rbrakk> \<Longrightarrow> 
   G \<rhd> (IF x THEN e1 ELSE e2) : Fpre \<Rightarrow> Fpost" 
apply (rule_tac Q="Fpre \<Rightarrow> Fpost" in vdm_conseq)
apply (rule vdm_if)
apply assumption+

apply (erule thin_rl) apply (erule thin_rl) 
apply (rule allI impI)+
apply (erule exE conjE)+
apply (simp only: Impl_def)

apply (erule disjE)
apply simp+
done

(**********)

lemma let_aux_1:"
\<lbrakk>\<forall> E h. \<forall> X. Gpre Q X E h  \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<exists> X .Gpre Qi X E h );
Gpre Q X E h; 
G Q Qi Qii
\<rbrakk>\<Longrightarrow> \<exists> Xi .Gpre Qi Xi E h"
apply fast
done

lemma let_aux_3:
"\<lbrakk>\<forall> E h hi r pi. \<forall> X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow>
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow>
Gpost Qi Xi E h hi (RVal r) pi) \<longrightarrow> (\<exists> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi); 
Gpre Q X E h; 
G Q Qi Qii;
\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi;
Gpre Qi Xi E h
\<rbrakk>\<Longrightarrow>(\<exists> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi)"
apply fast
done


lemma let_aux_3_nondecent:
"\<lbrakk>\<forall> E h hi r pi. \<forall> X. 
Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> 
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi) 
\<longrightarrow> A E h hi (RVal r) pi \<longrightarrow> (\<exists> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi); 

Gpre Q X E h; 
G Q Qi Qii; 
Gpre Qi Xi E h;
\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi;
A E h hi (RVal r) pi
\<rbrakk>\<Longrightarrow>(\<exists> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi)"
apply fast
done

lemma let_aux_5:"
\<lbrakk> 
\<forall> E h hi r pi h' v pii p.\<forall> X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow>
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi)  \<longrightarrow>
(\<forall> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi \<longrightarrow>  Gpost Qii Xii E\<lfloor>x:=r\<rfloor> hi h' v pii) \<longrightarrow> 
Gpost Q X E h h' v p;

Gpre Q X E h;
G Q Qi Qii;
Gpre Qi Xi E h;
\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi;
Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi;
\<forall> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi \<longrightarrow>  Gpost Qii Xii E\<lfloor>x:=r\<rfloor> hi h' v pii\<rbrakk>
\<Longrightarrow>Gpost Q X  E h h' v p"
apply fast
done

lemma let_aux_5_nondecent:"
\<lbrakk> 
\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow>
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi)  \<longrightarrow>
A E h hi (RVal r) pi \<longrightarrow>
(\<forall> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi \<longrightarrow>  Gpost Qii Xii E\<lfloor>x:=r\<rfloor> hi h' v pii) \<longrightarrow> 
Gpost Q X E h h' v p;

Gpre Q X E h;
G Q Qi Qii;
A E h hi (RVal r) pi;
Gpre Qi Xi E h;
\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi;
Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi;
\<forall> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi \<longrightarrow>  Gpost Qii Xii E\<lfloor>x:=r\<rfloor> hi h' v pii\<rbrakk>
\<Longrightarrow>Gpost Q X  E h h' v p"
apply fast
done


lemma let_decent_aux: "
\<lbrakk>
\<forall> X. Gpre Qi X E h \<longrightarrow> Gpost Qi X E h hi (RVal r) pi;
\<forall> X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi  \<longrightarrow> Gpost Qii X  E\<lfloor>x:=r\<rfloor> hi h' v pii;

G Q Qi Qii;

\<forall> E h. \<forall> X. Gpre Q X E h  \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<exists> Xi .Gpre Qi Xi E h );
 
\<forall> E h hi r pi. \<forall> X. 
Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi)  \<longrightarrow> 
(\<exists> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi); 

\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow>
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi)  \<longrightarrow>
(\<forall> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi \<longrightarrow>  Gpost Qii Xii E\<lfloor>x:=r\<rfloor> hi h' v pii)  \<longrightarrow> 
Gpost Q X E h h' v p

\<rbrakk> \<Longrightarrow>  \<forall> X . Gpre Q X E h \<longrightarrow> Gpost Q X E h h' v p"
(** proof **)
apply (rule allI impI)+ 
apply (drule_tac Gpre=Gpre and G=G and Q=Q and Qi=Qi and X=X and 
E=E and h=h in let_aux_1)
apply assumption+
apply (erule exE)

apply (drule_tac Gpre=Gpre and G=G and Q=Q and X=X and E=E and h=h and hi=hi and Xi=Xi
                  and Qi=Qi and pi=pi and r=r in let_aux_3)
apply assumption+
apply (erule exE)

apply (rule_tac Gpre=Gpre and G=G and E=E and X=X and h=h and x=x and v=v and 
                 Q=Q and Qi=Qi and Qii=Qii and Xii=Xii and
                 hi=hi and h'=h' and p=p and r=r and pii=pii in let_aux_5)
apply assumption+
done

lemma let_nondecent_aux: "
\<lbrakk>
\<forall> X. Gpre Qi X E h \<longrightarrow> Gpost Qi X E h hi (RVal r) pi;
\<forall> X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi  \<longrightarrow> Gpost Qii X  E\<lfloor>x:=r\<rfloor> hi h' v pii;

G Q Qi Qii;
A E h hi (RVal r) pi;

\<forall> E h. \<forall> X. Gpre Q X E h  \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<exists> Xi .Gpre Qi Xi E h );
 
\<forall> E h hi r pi. \<forall> X. 
Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> 
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi) \<longrightarrow> 
A E h hi (RVal r) pi \<longrightarrow>
(\<exists> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi); 

\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow>
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi)  \<longrightarrow>
A E h hi (RVal r) pi \<longrightarrow>
(\<forall> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi  \<longrightarrow> Gpost Qii Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii) \<longrightarrow> 
Gpost Q X E h h' v p

\<rbrakk> \<Longrightarrow>  \<forall> X . Gpre Q X E h \<longrightarrow> Gpost Q X E h h' v p"
(** proof **)
apply (rule allI impI)+ 
apply (drule_tac Gpre=Gpre and G=G and Q=Q and Qi=Qi and X=X and 
E=E and h=h in let_aux_1)
apply assumption+
apply (erule exE)

apply (drule_tac Gpre=Gpre and G=G and Q=Q and X=X and E=E and h=h and hi=hi and Xi=Xi
                  and Qi=Qi and pi=pi and r=r in let_aux_3_nondecent)
apply assumption+
apply (erule exE)

apply (rule_tac Gpre=Gpre and G=G and E=E and X=X and h=h and x=x and v=v and 
                 Q=Q and Qi=Qi and Qii=Qii and Xii=Xii and
                 hi=hi and h'=h' and p=p and r=r and pii=pii in let_aux_5_nondecent)
apply assumption+
done


lemma let_nondecent_aux': "
\<lbrakk>
\<forall> X. Gpre Qi X E h \<longrightarrow> Gpost Qi X E h hi (RVal r) pi;
\<forall> X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi  \<longrightarrow> Gpost Qii X  E\<lfloor>x:=r\<rfloor> hi h' v pii;

G Q Qi Qii;
A E h hi (RVal r) pi;

\<forall> E h. \<forall> X. Gpre Q X E h  \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<exists> Xi .Gpre Qi Xi E h );
 
\<forall> E h hi r pi. \<forall> X. 
Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> 
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi) \<longrightarrow> 
A E h hi (RVal r) pi \<longrightarrow>
(\<exists> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi); 

\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow>
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi)  \<longrightarrow>
A E h hi (RVal r) pi \<longrightarrow>
(\<forall> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi  \<longrightarrow> Gpost Qii Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii) \<longrightarrow> 
Gpost Q X E h h' v p;

Gpre Q X E h
\<rbrakk> \<Longrightarrow>  Gpost Q X E h h' v p"

(** proof **)
apply (frule_tac E=E and x=x and Q=Q and Qi=Qi and Qii=Qii and h=h and h'=h' and A=A 
        and Gpre=Gpre and G=G in let_nondecent_aux)
apply assumption+ 
apply fast
done



lemma gvdm_let_decent: "\<lbrakk>
G \<rhd> e1: (Gpre Qi) \<Rightarrow> (Gpost Qi);
G \<rhd> e2: (Gpre Qii) \<Rightarrow>(Gpost Qii);
SideCond Q Qi Qii;

\<forall> E h. \<forall> X. Gpre Q X E h  \<longrightarrow>  SideCond  Q Qi Qii \<longrightarrow> (\<exists> Xi .Gpre Qi Xi E h );
 
\<forall> E h hi r pi. \<forall> X. 
Gpre Q X E h \<longrightarrow> SideCond  Q Qi Qii \<longrightarrow> 
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi)  \<longrightarrow> 
(\<exists> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi); 

\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre Q X E h \<longrightarrow> SideCond  Q Qi Qii \<longrightarrow>
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi)  \<longrightarrow>
(\<forall> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi \<longrightarrow>  Gpost Qii Xii E\<lfloor>x:=r\<rfloor> hi h' v pii)  \<longrightarrow> 
Gpost Q X E h h' v p


\<rbrakk> \<Longrightarrow>  G \<rhd> (Letr x e1 e2) : (Gpre Q) \<Rightarrow> (Gpost Q)"
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply assumption+
apply (erule thin_rl) apply (erule thin_rl)

apply (rule allI impI)+
apply (erule exE conjE)+ 
apply (rename_tac hi r)

apply (unfold Impl_def)
apply (rule let_decent_aux)
apply assumption+
done


constdefs ConjAssn :: "vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
 ("_ \<star>   _" 1000)
"ConjAssn P1 P2 \<equiv> \<lambda>  E h h' v p. (P1 E h h' v p) \<and> (P2 E h h' v p)"


lemma let_nondecent': "\<lbrakk>
G \<rhd> e1: ((Gpre Qi) \<Rightarrow> (Gpost Qi)) \<star>  A;
G \<rhd> e2: (Gpre Qii) \<Rightarrow> (Gpost Qii);
SideCond Q Qi Qii;

\<forall> E h. \<forall> X. Gpre Q X E h  \<longrightarrow> SideCond Q Qi Qii \<longrightarrow> (\<exists> Xi .Gpre Qi Xi E h );
\<forall> E h hi r pi. \<forall> X. 
Gpre Q X E h \<longrightarrow> SideCond Q Qi Qii \<longrightarrow> 
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi) \<longrightarrow> 
A E h hi (RVal r) pi \<longrightarrow>
(\<exists> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi); 

\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre Q X E h \<longrightarrow> SideCond Q Qi Qii \<longrightarrow>
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi)  \<longrightarrow>
A E h hi (RVal r) pi \<longrightarrow>
(\<forall> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi  \<longrightarrow> Gpost Qii Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii) \<longrightarrow> 
Gpost Q X E h h' v p 

\<rbrakk> \<Longrightarrow>  G \<rhd> (Letr x e1 e2) : (Gpre Q) \<Rightarrow> (Gpost Q)"
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply assumption+
apply (erule thin_rl) apply (erule thin_rl)

apply (rule allI impI)+
apply (erule exE conjE)+
apply (rename_tac hi r)
apply (unfold ConjAssn_def)
apply (unfold Impl_def)
apply (erule conjE)
apply (rule_tac A=A and Gpre=Gpre and E=E and h'=hh and v=v and G=SideCond 
       and Q=Q and r=r and p=p and x=x 
       and pi=p1 and Qi=Qi and hi=hi and Qii=Qii and pii=p2 in let_nondecent_aux)
apply assumption+
done



lemma ConjAssn_valid: "\<lbrakk>\<Turnstile> e:P; \<Turnstile> e:Q\<rbrakk> \<Longrightarrow> \<Turnstile> e : P \<star>  Q"
by (simp add: vdm_valid_def  ConjAssn_def)

lemma vdm_ConjI_aux: "\<lbrakk>\<rhd> e:P; \<rhd> e:Q; finite strongContext\<rbrakk> \<Longrightarrow> \<rhd> e : P \<star>  Q"
apply (drule vdm_sound)
apply (drule vdm_sound)
apply (drule ConjAssn_valid, assumption)
apply (drule vdm_complete) 
prefer 2 apply assumption+
done


lemma vdm_conjI : "\<lbrakk> \<rhd> e :P; \<rhd> e : Q\<rbrakk>    \<Longrightarrow>   \<rhd> e : P \<star> Q"
apply (rule vdm_ConjI_aux)
apply assumption+
apply (rule strongContextFin)
done

(* proof by induction, ath the very beginning of this file 
"\<lbrakk> G \<rhd> e :P; G \<rhd> e : Q\<rbrakk>    \<Longrightarrow>   G \<rhd> e : P \<star> Q" *)

lemma gvdm_let_nondecent: "\<lbrakk>
\<rhd> e1: (Gpre Qi) \<Rightarrow> (Gpost Qi);
\<rhd> e2: (Gpre Qii) \<Rightarrow> (Gpost Qii);
\<rhd> e1: A;
SideCond Q Qi Qii;
\<forall> E h. \<forall> X. Gpre Q X E h  \<longrightarrow> SideCond Q Qi Qii \<longrightarrow> (\<exists> Xi .Gpre Qi Xi E h );

\<forall> E h hi r pi. \<forall> X. 
Gpre Q X E h \<longrightarrow>  SideCond  Q Qi Qii \<longrightarrow> 
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi) \<longrightarrow> 
A E h hi (RVal r) pi \<longrightarrow>
(\<exists> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi); 

\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre Q X E h \<longrightarrow>  SideCond  Q Qi Qii \<longrightarrow>
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi)  \<longrightarrow>
A E h hi (RVal r) pi \<longrightarrow>
(\<forall> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi  \<longrightarrow> Gpost Qii Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii) \<longrightarrow> 
Gpost Q X E h h' v p

\<rbrakk> \<Longrightarrow>  \<rhd> (Letr x e1 e2) : (Gpre Q) \<Rightarrow>  (Gpost Q)"
apply (rule_tac  SideCond=SideCond  and Q=Q and A=A in let_nondecent')
apply (rule_tac vdm_conjI)
apply assumption+
done

lemma gvdm_let_nondecent_concrete: "\<lbrakk>
\<rhd> e1: (Gpre Qi) \<Rightarrow> (Gpost Qi);
\<rhd> e2: (Gpre Qii) \<Rightarrow> (Gpost Qii);
\<rhd> e1: (A Qii);
 SideCond Q Qi Qii;
\<forall> E h. \<forall> X. Gpre Q X E h  \<longrightarrow>  SideCond Q Qi Qii \<longrightarrow> (\<exists> Xi .Gpre Qi Xi E h );
 
\<forall> E h hi r pi. \<forall> X. 
Gpre Q X E h \<longrightarrow>  SideCond Q Qi Qii \<longrightarrow> 
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi) \<longrightarrow> 
(A Qii) E h hi (RVal r) pi \<longrightarrow>
(\<exists> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi); 

\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre Q X E h \<longrightarrow>  SideCond Q Qi Qii \<longrightarrow>
(\<forall> Xi. Gpre Qi Xi E h \<longrightarrow> Gpost Qi Xi E h hi (RVal r) pi)  \<longrightarrow>
(A Qii) E h hi (RVal r) pi \<longrightarrow>
(\<forall> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi  \<longrightarrow> Gpost Qii Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii) \<longrightarrow> 
Gpost Q X E h h' v p
\<rbrakk> \<Longrightarrow>  \<rhd> (Letr x e1 e2) : (Gpre Q) \<Rightarrow>  (Gpost Q)"
apply (rule_tac  SideCond=SideCond and Q=Q and A="A Qii" in gvdm_let_nondecent)
apply assumption+
done


text  {*combinations  Fpre \<cdot> Gpre \<longrightarrow> Fpost \<cdot>\<cdot> Gpost *} 



constdefs ConjAssnPre :: "('a \<Rightarrow> 'c \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool) \<Rightarrow> ('b \<Rightarrow> 'd  \<Rightarrow>  env \<Rightarrow> heap \<Rightarrow> bool) \<Rightarrow> 
                        'a \<times> 'b \<Rightarrow> 'c \<times> 'd \<Rightarrow>  env \<Rightarrow> heap \<Rightarrow> bool"
 ("_ \<cdot> _" 1000)
"ConjAssnPre G F  \<equiv>  \<lambda> Q. \<lambda> X. \<lambda> E h. G (fst Q) (fst X) E h \<and> F (snd Q) (snd X) E h"


constdefs ConjAssnPost :: "('a \<Rightarrow> 'c \<Rightarrow> vdmassn) \<Rightarrow> ('b \<Rightarrow>'d \<Rightarrow>  vdmassn) \<Rightarrow> 
                           ('a \<times> 'b \<Rightarrow> 'c \<times> 'd \<Rightarrow> vdmassn)"
 ("_ \<cdot>\<cdot>  _" 1000)
"ConjAssnPost G F \<equiv>   \<lambda> Q. \<lambda> X. \<lambda> E h h' v  p. (G (fst Q) (fst X) E h h' v p) \<and> (F (snd Q) (snd X) E h h' v p)"


constdefs ConjStatic :: "('a \<Rightarrow> 'a \<Rightarrow> 'a \<Rightarrow> bool) \<Rightarrow> ('b \<Rightarrow>'b \<Rightarrow>'b \<Rightarrow>  bool) \<Rightarrow> 
                        'a \<times> 'b \<Rightarrow>  'a \<times> 'b \<Rightarrow> 'a \<times> 'b \<Rightarrow> bool"
 ("_  \<otimes>   _" 1000)
"ConjStatic G F \<equiv>   \<lambda> Q Qi Qii. G (fst Q) (fst Qi) (fst Qii) \<and> F (snd Q) (snd Qi) (snd Qii)"


lemma weak_combo_aux:
"\<lbrakk>(Gpre Q \<Rightarrow> Gpost Q) E h hh v p; 
  (Fpre P \<Rightarrow> Fpost P) E h hh v p\<rbrakk> \<Longrightarrow>
((Gpre \<cdot> Fpre) (Q, P)  \<Rightarrow> (Gpost \<cdot>\<cdot> Fpost) (Q, P)) E h hh v p"
apply (simp only: Impl_def)
apply (simp only: ConjAssnPre_def)
apply (simp only: ConjAssnPost_def)
apply (rule allI impI)+
apply (erule conjE)
(**)
apply (erule_tac x="fst X" in allE)
apply (drule mp) apply simp
(**)
apply (erule_tac x="snd X" in allE)
apply (drule mp) apply simp
(**)
apply (rule conjI)
apply simp+
done

(** use weak_combo to prove combined assertions
for basic commands, if-rule, calls and invocations **)
lemma weak_combo:
"\<lbrakk> \<rhd> e : Gpre Q \<Rightarrow> Gpost Q; \<rhd> e : Fpre P \<Rightarrow> Fpost P\<rbrakk> \<Longrightarrow>
\<rhd> e : (Gpre \<cdot> Fpre) (Q, P)  \<Rightarrow> (Gpost \<cdot>\<cdot> Fpost) (Q, P)"
apply (drule_tac P="Gpre Q \<Rightarrow> Gpost Q" and Q=" Fpre P \<Rightarrow> Fpost P" in vdm_conjI)
apply assumption
apply (erule thin_rl)
apply (simp only: ConjAssn_def)
apply (rule vdm_conseq)
apply assumption
apply (erule thin_rl)
apply (rule allI impI)+
apply (rule weak_combo_aux)
apply fast+
done

lemma weak_combo_ctxt:
"\<lbrakk>G \<rhd> e : ((Gpre Q) \<Rightarrow> (Gpost Q)) \<star> ((Fpre P) \<Rightarrow> (Fpost P))\<rbrakk> \<Longrightarrow>
G \<rhd> e : (Gpre \<cdot> Fpre) (Q, P)  \<Rightarrow> (Gpost \<cdot>\<cdot> Fpost) (Q, P)" 
apply (rule vdm_conseq)
apply assumption
apply (erule thin_rl)
apply (simp only: ConjAssn_def)
apply (rule allI impI)+
apply (rule weak_combo_aux)
apply fast+
done

text {* combined let-rule *}
lemma let_combo_aux: "
\<lbrakk> 
\<forall> X. ((Gpre \<cdot> Fpre) Qi X E h) \<longrightarrow> 
(((Gpost ::('a \<Rightarrow> 'c \<Rightarrow> vdmassn)) \<cdot>\<cdot> 
(Fpost :: ('b \<Rightarrow>'d \<Rightarrow>  vdmassn))) Qi X E h hi (RVal r) pi);

\<forall> X. ((Gpre \<cdot> Fpre) Qii X E\<lfloor>x:=r\<rfloor> hi) \<longrightarrow> ((Gpost \<cdot>\<cdot> Fpost) Qii X E\<lfloor>x:=r\<rfloor> hi h' v pii);

(G \<otimes> F) Q Qi Qii ;

\<forall> E h hi r pi. \<forall> X. Fpre (snd Q) X E h \<longrightarrow> F (snd Q) (snd Qi) (snd Qii) \<longrightarrow> A E h hi (RVal r) pi ;

\<forall> E h. \<forall>  X. 
((Gpre \<cdot>  Fpre) Q X E h )\<longrightarrow> (G \<otimes> F) Q Qi Qii \<longrightarrow> (\<exists> X . ((Gpre \<cdot> Fpre) Qi  X E h)) ;

\<forall> E h hi r pi. 
\<forall>  X. ((Gpre \<cdot>  Fpre) Q X E h )\<longrightarrow> (G \<otimes> F) Q Qi Qii 
\<longrightarrow> (\<forall> X. ((Gpre \<cdot> Fpre) Qi X E h) \<longrightarrow> ((Gpost  \<cdot>\<cdot> Fpost) Qi X E h hi (RVal r) pi))
\<longrightarrow> A E h hi (RVal r) pi
 \<longrightarrow> (\<exists> X. ((Gpre \<cdot> Fpre) Qii X E\<lfloor>x:=r\<rfloor> hi)) ;

\<forall> E h hi r pi h' v pii p. 
\<forall>  X. ((Gpre \<cdot>  Fpre) Q X E h )\<longrightarrow> (G \<otimes> F) Q Qi Qii 
\<longrightarrow> (\<forall> X. ((Gpre \<cdot> Fpre) Qi X E h) \<longrightarrow> ((Gpost  \<cdot>\<cdot> Fpost) Qi X E h hi (RVal r) pi))
\<longrightarrow> A E h hi (RVal r) pi
\<longrightarrow> (\<forall> Xii. ((Gpre \<cdot>  Fpre) Qii Xii E\<lfloor>x:=r\<rfloor> hi) \<longrightarrow> 
((Gpost \<cdot>\<cdot> Fpost) Qii Xii E\<lfloor>x:=r\<rfloor> hi h' v pii))\<longrightarrow>
((Gpost \<cdot>\<cdot> Fpost Q) X E h h' v p) ;

(Gpre \<cdot> Fpre) Q X E h

\<rbrakk> \<Longrightarrow> (Gpost \<cdot>\<cdot> Fpost) Q X E h h' v p"

apply (rule_tac Gpre ="Gpre \<cdot> Fpre" and pi=pi and hi=hi and G="G \<otimes> F"  and E=E and h=h and
                r=r and x= x and Q=Q and Qi=Qi and Qii=Qii and A=A and
                pii=pii and Gpost ="Gpost \<cdot>\<cdot> Fpost"  in let_nondecent_aux')
apply assumption+

apply (simp only: ConjAssnPre_def ConjStatic_def) apply (erule conjE)+
apply (rotate_tac 2) 
apply (erule_tac x="E" in allE)
apply (rotate_tac 9) 
apply (erule_tac x="h" in allE)
apply (rotate_tac 9) 
apply (erule_tac x="hi" in allE)
apply (rotate_tac 9) 
apply (erule_tac x="r" in allE)
apply (rotate_tac 9) 
apply (erule_tac x="pi" in allE)
apply (rotate_tac 9) 
apply (erule_tac x="snd X" in allE)
apply (drule mp) apply assumption 
apply clarify

apply assumption+
done


lemma gvdm_let_combo: "\<lbrakk>
\<rhd> e1: (((Gpre \<cdot> Fpre) Qi) \<Rightarrow> ((Gpost \<cdot>\<cdot> Fpost) Qi));
\<rhd> e2: (((Gpre \<cdot> Fpre) Qii) \<Rightarrow>((Gpost \<cdot>\<cdot> Fpost) Qii));

(* \<rhd> e1: A;*)

(G \<otimes> F) Q Qi Qii;

\<forall> E h hi r pi. \<forall> X. Fpre (snd Q) X E h \<longrightarrow> F (snd Q) (snd Qi) (snd Qii) \<longrightarrow> A E h hi (RVal r) pi;

\<forall> E h. \<forall>  X. 
((Gpre \<cdot>  Fpre) Q X E h )\<longrightarrow> (G \<otimes> F) Q Qi Qii \<longrightarrow> (\<exists> X . ((Gpre \<cdot>  Fpre) Qi  X E h));

\<forall> E h hi r pi. 
\<forall>  X. ((Gpre \<cdot>  Fpre) Q X E h )\<longrightarrow> (G \<otimes> F) Q Qi Qii 
\<longrightarrow> (\<forall> X. ((Gpre \<cdot> Fpre) Qi X E h) \<longrightarrow> ((Gpost  \<cdot>\<cdot> Fpost) Qi X E h hi (RVal r) pi))
\<longrightarrow> A E h hi (RVal r) pi
 \<longrightarrow> (\<exists> X. ((Gpre \<cdot>  Fpre) Qii X E\<lfloor>x:=r\<rfloor> hi));

\<forall> E h hi r pi h' v pii p. 
\<forall>  X. ((Gpre \<cdot>  Fpre) Q X E h )\<longrightarrow> (G \<otimes> F) Q Qi Qii 
\<longrightarrow> (\<forall> X. ((Gpre \<cdot> Fpre) Qi X E h) \<longrightarrow> ((Gpost  \<cdot>\<cdot> Fpost) Qi X E h hi (RVal r) pi))
\<longrightarrow> A E h hi (RVal r) pi
\<longrightarrow> (\<forall> Xii. ((Gpre \<cdot>  Fpre) Qii Xii E\<lfloor>x:=r\<rfloor> hi) \<longrightarrow> 
((Gpost \<cdot>\<cdot> Fpost) Qii Xii E\<lfloor>x:=r\<rfloor> hi h' v pii))\<longrightarrow>
((Gpost \<cdot>\<cdot> Fpost Q) X E h h' v p)

\<rbrakk> \<Longrightarrow> \<rhd> (Letr x e1 e2) : (((Gpre \<cdot> Fpre) Q) \<Rightarrow> ((Gpost \<cdot>\<cdot> Fpost) Q))" 
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply assumption+
apply (erule thin_rl) apply (erule thin_rl)

apply (rule allI impI)+
apply (erule exE conjE)+
apply (rename_tac hi r)
apply (unfold Impl_def)
apply (rule allI impI)+
apply (rule_tac A=A and Gpre=Gpre and Fpre=Fpre and F=F 
       and E=E and h'=hh and v=v and G=G and Q=Q and r=r and p=p and x=x 
       and pi=p1 and Qi=Qi and hi=hi and Qii=Qii and pii=p2 in let_combo_aux)
apply assumption+
done

end