(* DoubleInv from Predicates adapted for final, ultimate, clarified, kool bytecodelogic *)
(* To use this logic with this proof do: ln -s ~/mrg/progs/BytecodeLogic/*.thy . *)
(* Version to be used in TPHOL paper *)

theory DoubleInv4BCL = mTreeList:

(*Cmaelot:

let double l = match l with Nil@d => Nil@d
                          | Cons(h,t)@d => Cons(h,Cons(h,double t)@d)


COmpiler Output:
  class Double {
   method public static Double$dia_0 double (Double$dia_0 l) =
   let

      fun f:double(Double$dia_0 l) =
      let
         val v4 = getfield l <int Double$dia_0.$>
      in
         if v4 = 0
         then f:0(l)
         else f:1(l)
      end

      fun f:1(Double$dia_0 l) =
      let
         val v4 = getfield l <int Double$dia_0.f0>
         val v3 = getfield l <Double$dia_0 Double$dia_0.f1>
         val v2 = l
         val v1 = invokestatic <Double$dia_0 Double.double (Double$dia_0)> (v3)
         val l = invokestatic <Double$dia_0 Double$dia_0.fill (Double$dia_0, int, int, Double$dia_0)> (v2, 1, v4, v1)
      in
         invokestatic <Double$dia_0 Double$dia_0.make (int, int, Double$dia_0)> (1, v4, l)
      end

      
      fun f:0(Double$dia_0 l) =
         invokestatic <Double$dia_0 Double$dia_0.fill (Double$dia_0, int)> (l, 0)
   in
      f:double(l)
   end
}

Pretty-printed with invokestatic:
class Double {
   method public static List double (List l) =
   let
      fun f(l) =
      let val v4 = getfield l TAG
      in
         if v4 = 0
         then putfield l TAG 0
         else f1(l)
      end

      fun f1(List l) =
      let
         val v4 = getfield l HD
         val v3 = getfield l TL
         val v2 = l
         val v1 = invokestatic <List.double (v3)

         val () = putfield v2 TAG 1
         val () = putfield v2 HD v4
         val () = putfield v2 TL v1
         val l = v2
      in new List(TAG:=1, HD:=v4, TL:= l)
      end

   in
      f(l)
   end
}
*)

(* resources *)
constdefs clockA::nat "clockA == 37"
          clockB::nat "clockB == 17"
          callcA::nat "callcA == 0"
          callcB::nat "callcB == 0"
          invkcA::nat "invkcA == 1"
          invkcB::nat "invkcB == 0"
          invkdpthA::nat "invkdpthA == 1"
          invkdpthB::nat "invkdpthB == 0"
          
consts
    v4     :: iname   
    one     :: iname 
    zero     :: iname 
    consTag     :: iname 
    nilTag     :: iname 
    b       :: iname

    l       :: rname  
    v3 :: rname 
    v2 :: rname
    v1       :: rname

    double   :: mname  
    d   :: mname  

    specm :: vdmassn 

    LST :: cname

(* code *)
axioms methtm[simp]:
"methtable LST double == ([RNpar l],
            (LET v4 = GetFi l DOLLAR;
                 b  = Primop (% x y. if x = 2 then 1 else 0) v4 v4
               IN IF b 
                  THEN LET nilTag = expr.Int 2;
                              _ = PutFi l DOLLAR nilTag
                       IN RVar l END
                  ELSE LET v4 = GetFi l F0;
                        rf v3 = GetFr l F1;
                        rf v2 = RVar l;
                        rf v1 = LST\<bullet>double([RNarg v3]);
                      consTag = expr.Int 1;
                           _  = PutFi v2 DOLLAR consTag;
                           _  = PutFi v2 F0 v4;
                           _  = PutFr v2 F1 v1;
                         rf l = RVar v2
                      IN NEW <DIAM> ([(DOLLAR,one), (F0,v4)],[(F1,l)]) 
                      END
              END))"

(*
axioms me[simp]:
"methtable LST do == ([RNpar p],
            (LET rf l = RVar p;
                   v4 = GetFi l DOLLAR;
                   b  = Primop (% x y. if x = 0 then 1 else 0) v4 v4
               IN IF b 
                  THEN LET nilTag = expr.Int 0;
                              _ = PutFi l DOLLAR nilTag
                       IN RVar l END
                  ELSE RVar l
              END))"

axioms m[simp]:
"methtable LST d == ([RNpar p],
            (LET rf l = RVar p;
                   v4 = GetFi l DOLLAR;
                   b  = Primop (% x y. if x = 0 then 1 else 0) v4 v4
               IN 
              RVar l
              END))"

lemma xxx: "\<rhd>  snd (methtable LST d) : \<lambda>  E h hh v p . True"
apply (simp add: m)
oops

lemma yyy: "\<rhd>  snd (methtable LST do) : \<lambda>  E h hh v p . True"
apply (simp add: me)
oops


lemma zzz: "\<rhd>  snd (methtable LST double) : \<lambda>  E h hh v p . True"
apply (simp add: methtm)
oops
*)

(* specification as a table entry *)
consts FST :: FS_T
consts vMST :: vMS_T
consts sMST :: sMS_T

constdefs mySpec ::  "bool"
"mySpec == (sMST LST double
            = (\<lambda> args E h hh v p . 
                    (\<forall> n a X. 
                           ((evalARGS E args =[RVal (Ref a)] \<and>  
                            (n,a,X,h) \<in> mList) 
                            \<longrightarrow>
                            HSize hh = HSize h + (int n) \<and> 
                            p = \<langle> (int(35 * n + 18)) 0 (int(n + 1)) (n + 1)\<rangle>))))"

axioms vardistinct: "distinct [v4,one,zero,b] \<and> distinct [b,zero,one,v4] \<and>
                     distinct [l,v1,v2,v3] \<and> distinct [v3,v2,v1,l]"

subsection {* Proof relative to mySpec *}
text {* main resource property *}

lemma "\<lbrakk> mySpec \<rbrakk> \<Longrightarrow> \<rhd> (LST\<bullet>double([RNarg v3])): (sMST LST double [RNarg v3])"
apply (rule vdm_invokestatic) apply simp
apply (rule vdm_conseq)
(*apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2*)
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
apply (rule vdm_if)
apply (rule vdm_leti, rule vdm_int) prefer 3 apply (simp add: mySpec_def)
apply (case_tac "h<a\<bullet>DOLLAR> \<noteq> 2", clarsimp) defer 1 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi) apply (rule vdm_rvar) apply clarsimp defer 1

apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_ax) apply simp prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_new) apply clarsimp 
apply (insert vardistinct)
apply (simp_all add: newObj_def newframe_env_def mySpec_def)
apply clarsimp
apply (erule mList.elims) apply (simp_all) apply (clarsimp)
apply (erule_tac x="na" in allE)
apply (erule impE)
apply (rule_tac x="aa" in exI)
apply (rule conjI)
defer 1
apply (rule_tac x="Xa" in exI)
apply assumption
prefer 2
apply (erule mList.elims) apply (simp_all) apply (simp add: evalARGS_def)
done

(* --------------------------------------------------------------------------- *)

subsection {* Proof from empty context using goodContext etc *}

text {* the one using good context *}

constdefs myContext :: "vdmcontext"
"myContext == {(LST\<bullet>double([RNarg v3]), sMST LST double [RNarg v3])}"

lemma double_Aux: "\<lbrakk>mySpec; G = myContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable LST double) : 
      (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable LST double)) x E' \<longrightarrow>
                    sMST LST double x E' h hh v
                       (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (rule vdm_conseq)
apply simp
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
apply (rule vdm_if)
apply (rule vdm_leti, rule vdm_int) prefer 3 apply clarsimp
apply (case_tac "h<a\<bullet>DOLLAR> \<noteq> 2", clarsimp) defer 1 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi) apply (rule vdm_rvar) apply clarsimp defer 1
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) 
apply (subgoal_tac "v3 ~= v1")
apply (rule vdm_ax, simp add: myContext_def) defer 1
apply (rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_new) apply clarsimp 
apply (insert vardistinct)
apply (simp_all add: newObj_def newframe_env_def mySpec_def)
apply clarsimp
apply (erule mList.elims) apply (simp_all) apply (clarsimp)
apply (erule_tac x="na" in allE)
apply (erule impE)
apply (rule_tac x="aaa" in exI)
apply (rule conjI)
defer 1
apply (rule_tac x="Xa" in exI)
apply assumption
prefer 2
apply clarify
apply (erule mList.elims) apply (simp_all) apply (simp add: evalARGS_def)
done

lemma myContext_good: "\<lbrakk> mySpec \<rbrakk> \<Longrightarrow> goodContext FST vMST sMST myContext"
apply (simp only: goodContext_def) apply (rule, rule, rule)
apply (subgoal_tac "(e, P) = ((LST\<bullet>double([RNarg v3])), sMST LST double [RNarg v3])")
prefer 2 apply (simp add: myContext_def)
apply (rule disjI2, rule disjI2)
apply clarsimp
apply (drule double_Aux) apply simp apply simp
done

theorem " \<lbrakk> mySpec \<rbrakk> \<Longrightarrow> \<rhd> LST\<bullet>double([RNarg x]) : sMST LST double [RNarg x]"
apply (rule GCInvs)
apply (erule myContext_good)
apply (simp_all add: myContext_def, auto)
done

end
