(*<*)
theory DAss_rulesU3 = DAssU3:
(*>*)

subsection {*Rules*}

subsubsection {* Logical rules*}

lemma preDAss_antimonotone_U: "\<lbrakk>preDAss q F R E C V h n N P; U \<subseteq> V\<rbrakk> \<Longrightarrow> \<exists> PP RR. preDAss q F RR E C U h n N PP \<and> RR \<subseteq> R \<and> PP \<le> P"
(*<*) by (simp add: preDAss_def, clarsimp, frule CS_SPLIT, subgoal_tac "U \<union> (V-U) = V", assumption, fastsimp+)(*>*)

lemma preDAss_antimonotone_N: "\<lbrakk>preDAss q F R E C U h n N P; nn \<le> n\<rbrakk> \<Longrightarrow> preDAss q F R E C U h nn N P"
(*<*) by (simp add: preDAss_def, fastsimp) (*>*)

lemma postDAss_monotone_R: "\<lbrakk>postDAss q F R T h hh m v Rv S M FF; R \<subseteq> RR\<rbrakk> \<Longrightarrow> postDAss q F RR T h hh m v Rv S M FF"
(*<*)by (simp add: postDAss_def, clarsimp, fastsimp intro: mod2_monotone)(*>*)

lemma postDAss_antimonotone_M: "\<lbrakk>postDAss q F R T h hh m v Rv S M FF; mm \<le> m\<rbrakk> \<Longrightarrow> postDAss q F R T h hh mm v Rv S M FF"
(*<*) by (simp add: postDAss_def, fastsimp)(*>*)

lemma DAss_monotone_in_U:
"\<lbrakk>\<lbrace> U, n, C \<ggreater> T, m \<rbrace> E h hh v p; U \<subseteq> V\<rbrakk> \<Longrightarrow> \<lbrace> V, n, C \<ggreater> T, m \<rbrace> E h hh v p"
(*<*) apply (simp add: DASS_def,clarsimp,drule preDAss_antimonotone_U, assumption, clarsimp)
      apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=RR in allE, erule impE, fastsimp)
      apply (clarsimp, drule postDAss_monotone_R, assumption, fastsimp)
done
(*>*)

lemma preDAss_same_on_U: "\<lbrakk>preDAss q F R E C U h n N P; \<forall> x. x:U \<longrightarrow> GETr C x = GETr D x\<rbrakk> \<Longrightarrow> preDAss q F R E D U h n N P"
(*<*) by (simp add: preDAss_def, clarsimp, drule CS_SameOnU, erule_tac x=x in allE, erule impE, assumption+)(*>*)


lemma DAss_Contexts_same_on_U:
"\<lbrakk>G \<rhd> e: \<lbrace> U, n, C \<ggreater> T, m \<rbrace>; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> G \<rhd> e: \<lbrace> U, n, D \<ggreater> T, m \<rbrace>"
(*<*) by (erule vdm_conseq, clarsimp, simp add: DASS_def, safe,
          drule preDAss_same_on_U, assumption, fast)(*>*)

lemma DA_Weak: "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; U \<subseteq> V\<rbrakk> \<Longrightarrow> G \<rhd> e : \<lbrace>V, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (erule vdm_conseq, clarsimp, erule DAss_monotone_in_U,fast) (*>*)

lemma DAss_Generalise:
 "\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p;  n \<le> nn; mm \<le> m; U \<subseteq> V\<rbrakk>  \<Longrightarrow> \<lbrace>V, nn, C \<ggreater> T, mm\<rbrace> E h hh v p"
(*<*)
apply (simp add: DASS_def, clarsimp)
apply (drule preDAss_antimonotone_U, assumption, clarsimp)
apply (drule preDAss_antimonotone_N, assumption)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=RR in allE, erule impE, fastsimp, clarsimp)
apply (rule, rule, rule, rule) apply (rule postDAss_antimonotone_M)
apply (rule postDAss_monotone_R, fastsimp, fast)
apply assumption
done
(*>*)

lemma DA_Generalise: 
"\<lbrakk>G \<rhd> e:\<lbrace>U, n, C \<ggreater> T, m\<rbrace>; n \<le> nn; mm \<le> m; U \<subseteq> V\<rbrakk> \<Longrightarrow> G \<rhd> e: \<lbrace>V, nn, C \<ggreater> T, mm\<rbrace>"
(*<*)
by (erule vdm_conseq, clarsimp, erule DAss_Generalise, assumption+)
(*>*)

lemma DAss_Const: "\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p; nn = n + k; mm = m + k\<rbrakk> \<Longrightarrow> \<lbrace>U, nn, C \<ggreater> T, mm\<rbrace> E h hh v p"
(*<*)
apply (simp add: DASS_def preDAss_def postDAss_def, clarsimp)
apply (erule_tac x="q+k" in allE, erule_tac x=F in allE, erule_tac x=R in allE, clarsimp)
apply (erule impE,safe) apply fastsimp 
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
done
(*>*)

lemma DA_Const: "\<lbrakk>G \<rhd> e: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; nn = n + k; mm = m + k\<rbrakk> \<Longrightarrow> G \<rhd> e: \<lbrace>U, nn, C \<ggreater> T, mm\<rbrace>"
(*<*)by (erule vdm_conseq, insert DAss_Const, fast)(*>*)

(*<*)
lemma DAss_PConst0: "\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p = \<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v pp"
by (simp add: DASS_def)
(*>*)
lemma DAss_PConst: "\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p \<Longrightarrow> \<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v pp"
(*<*)
by (simp add: DASS_def)
(*>*)

subsubsection {*Rules for primitive operations*}
lemma DA_Null: "\<lbrakk>m \<le> n; T=ListET k\<rbrakk> \<Longrightarrow> G \<rhd> Null: \<lbrace>{}, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: DASS_def preDAss_def postDAss_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe)
apply (rule regList, rule mLIST_NIL, simp)
apply simp
done
lemma DA_null: "\<lbrakk>m \<le> n; T=ListET k;U={}\<rbrakk> \<Longrightarrow> GG \<rhd> Null: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
by (clarsimp,rule DA_Null,auto)
(*>*)

lemma DA_Int: "\<lbrakk>m \<le> n; T = IntET\<rbrakk> \<Longrightarrow> G \<rhd> expr.Int i: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_conseq, rule vdm_int)
apply (simp add: DASS_def preDAss_def postDAss_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule regInt)
apply simp
done
lemma DA_int: "\<lbrakk>m \<le> n; T = IntET;U={}\<rbrakk> \<Longrightarrow> G \<rhd> expr.Int i: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
by (clarsimp,rule DA_Int,auto)
(*>*)

lemma DA_IVar: "\<lbrakk>m \<le> n; T = IntET\<rbrakk> \<Longrightarrow> G \<rhd> IVar x: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (simp add: DASS_def preDAss_def postDAss_def, clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule regInt)
apply simp
done
lemma DA_ivar: "\<lbrakk>m \<le> n; T = IntET;U={}\<rbrakk> \<Longrightarrow> G \<rhd> IVar x: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
by (clarsimp,rule DA_IVar,auto)
(*>*)

lemma DA_RVar: "\<lbrakk>GETr C x = Some T; m \<le> n\<rbrakk> \<Longrightarrow> G \<rhd> RVar x: \<lbrace>{x}, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: DASS_def preDAss_def postDAss_def, safe)
apply (frule CS_regionsExist, safe, simp, erule GETrSome_DOM)
apply (rule_tac x=RR in exI, rule_tac x=na in exI, rule_tac x=N in exI, rule_tac x=F in exI, clarsimp)
apply (drule CS_containsRegion, simp, simp)
apply fastsimp
done
lemma DA_rvar: "\<lbrakk>GETr C x = Some T; m \<le> n; U={x}\<rbrakk> \<Longrightarrow> G \<rhd> RVar x: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
by (clarsimp,rule DA_RVar,auto)
(*>*)

lemma DA_Prim: "\<lbrakk>m \<le> n; T = IntET\<rbrakk> \<Longrightarrow> G \<rhd> Primop f x y: \<lbrace>{}, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_conseq, rule vdm_prim, simp add: DASS_def preDAss_def postDAss_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply simp
done
lemma DA_prim: "\<lbrakk>m \<le> n; T = IntET;U={}\<rbrakk> \<Longrightarrow> G \<rhd> Primop f x y: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
by (clarsimp,rule DA_Prim,auto)
(*>*)

lemma DA_Rprim: "\<lbrakk>x: DOM C; y:DOM C; m \<le> n; T = IntET\<rbrakk> \<Longrightarrow> G \<rhd> RPrimop f x y: \<lbrace>{x,y}, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_conseq, rule vdm_rprim, simp add: DASS_def preDAss_def postDAss_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply simp
done
lemma DA_rprim:
"\<lbrakk>x: DOM C; y:DOM C; m \<le> n; T = IntET; U={x,y}\<rbrakk> \<Longrightarrow> G \<rhd> RPrimop f x y: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
by (clarsimp,rule DA_Rprim,auto)
(*>*)

subsubsection {*General let-rules*}
lemma Impl1:
"\<lbrakk>\<exists>R S M FF. freelist hh FF M \<and>
             (v, hh, Some T, R, S) \<in> reg \<and>
             mod2 (F \<union> X) h hh \<and> R \<inter> FF = {} \<and> R \<union> FF \<subseteq> X \<union> F \<and> m + S + q \<le> M \<and> oheap h = oheap hh;
  X \<subseteq> Y\<rbrakk>
 \<Longrightarrow> \<exists>R S M FF. freelist hh FF M \<and>
                (v, hh, Some T, R, S) \<in> reg \<and>
                mod2 (F \<union> Y) h hh \<and> R \<inter> FF = {} \<and> R \<union> FF \<subseteq> Y \<union> F \<and> m + S + q \<le> M \<and> oheap h = oheap hh"
by (clarsimp,
    rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe,
    erule mod2_monotone, fast+)

lemma mod2_transitive:
"\<lbrakk>mod2 (F \<union> R1) h h1; mod2 (FF \<union> R2) h1 hh; 
  oheap h = oheap hh; oheap h1 = oheap hh; FF \<subseteq> R1 \<union> F\<rbrakk> 
 \<Longrightarrow> mod2 (F \<union> (R1 \<union> R2)) h hh"
(*<*)
apply (simp add: mod2_def, clarsimp)
  apply (erule_tac x=l in allE, erule impE, clarsimp)
  apply (erule_tac x=l in allE, erule impE, clarsimp)
  apply fast
  apply (erule SameOHTransitive, assumption, simp)
done
(*>*)
(*
lemma LetvAux1:
"\<lbrakk>postDAss (q+P) F R1 UnitET h h1 k w;(E, h1, V, C, R, P) \<in> CS; R \<inter> (R1 \<union> F)= {}\<rbrakk> \<Longrightarrow> \<exists> F. preDAss q F R E C V h1 k"
apply (simp add: postDAss_def preDAss_def, clarsimp)
apply (rule_tac x=FF in exI, rule_tac x=M in exI, simp)
apply (rule_tac x=P in exI, simp)
apply (erule reg.elims, simp_all, clarsimp)
apply fast
done
*)



(*<*)
lemma preDAss_Fold:
"\<lbrakk>freelist h F N; n + (P + n2) + q \<le> N; (E, h, U, C, R1, P) \<in> CS; R1 \<inter> F = {};m=n2 + q\<rbrakk>
 \<Longrightarrow> preDAss m F R1 E C U h n N P"
by (unfold preDAss_def, fastsimp)
(*>*)
(*<*)
lemma preDAss_Unfold:
"preDAss q F R E G U h n N P \<Longrightarrow> (freelist h F N \<and> (E,h,U,G,R,P):CS \<and> R \<inter> F = {} \<and> n + P + q \<le> N)"
by (simp add: preDAss_def)
(*>*)
lemma postDAss_Mod2:
"postDAss q F R T h h1 k v RR S M FF \<Longrightarrow> mod2 (F \<union> R) h h1" (*<*)by (simp add: postDAss_def)(*>*)
(*<*)
lemma LetvAux1_1:
"\<lbrakk>postDAss (n2 + q) F R1 TT h h1 k w Rv S M FF; R1 \<inter> R2 = {};(R1 \<union> R2) \<inter> F = {};(E, h1, V, C, R2, n2) \<in> CS\<rbrakk>
       \<Longrightarrow> \<exists> N P . preDAss q FF R2 E C V h1 k N P"
by (simp add: postDAss_def, clarsimp, rule_tac x=M in exI, rule, simp add: preDAss_def, safe,
    assumption, fast, simp)(*>*)
(*<*)
lemma LetvAux1_2:
"\<lbrakk>postDAss (n2 + q) F R1 TT h h1 k w Rv S M FF;  postDAss q FF R2 T h1 hh m v Rva Sa Ma FFa;
  (R1 \<union> R2) \<inter> F = {}; R1 \<inter> R2 = {}\<rbrakk>
 \<Longrightarrow> postDAss q F (R1 \<union> R2) T h hh m v Rva Sa Ma FFa"
by (simp add: postDAss_def, safe, erule mod2_transitive, assumption+, fast+)(*>*)
(*<*)
lemma LetvAux1:
"\<lbrakk>\<forall>q F R. (\<exists>N. Ex (preDAss q F R E C V h1 k N)) \<longrightarrow> (\<exists>Rv S M. Ex (postDAss q F R T h1 hh m v Rv S M));
        freelist h F N; (R1 \<union> R2) \<inter> F = {}; n + (n1 + n2) + q \<le> N; R1 \<inter> R2 = {}; 
       postDAss (n2 + q) F R1 TT h h1 k w Rv S M x; (E, h1, V, C, R2, n2) \<in> CS\<rbrakk>
       \<Longrightarrow> \<exists>Rv S M. Ex (postDAss q F (R1 \<union> R2) T h hh m v Rv S M)"
(*<*)
apply (frule LetvAux1_1, assumption+)
apply (erule_tac x= q in allE, erule_tac x=x in allE, erule_tac x=R2 in allE, erule impE, fastsimp, clarsimp)
apply (rule_tac x=Rva in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI)
apply (drule LetvAux1_2, assumption+, fast)
done(*>*)

lemma DA_Letv:
      "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> TT, k\<rbrace>; G \<rhd> ee : \<lbrace>V, k, C \<ggreater> T, m\<rbrace>; 
        TT = UnitET; U \<inter> V = {}\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): \<lbrace>U \<union> V, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_conseq,erule vdm_letv, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DASS_def, safe)
apply (drule preDAss_Unfold, clarsimp)
apply (drule CS_SPLIT, simp, assumption, clarsimp)
apply (erule_tac x="n2+q" in allE, erule_tac x=F in allE, erule_tac x=R1 in allE, erule impE, clarsimp)
apply (drule preDAss_Fold, assumption+, fast, simp, fast)
apply clarsimp
apply (erule LetvAux1, assumption+)
apply (erule CS_Preserved_h_h1) apply (erule postDAss_Mod2) apply fast 
done(*>*)
lemma DA_letv:
      "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> TT, k\<rbrace>;
        G \<rhd> ee : \<lbrace>V, k, C \<ggreater> T, m\<rbrace>; TT = UnitET;
        U \<inter> V = {}; W = U \<union> V\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): \<lbrace>W, n, C \<ggreater> T, m\<rbrace>"
by (rule vdm_conseq, rule DA_Letv, auto)
(*>*)

lemma DA_Leti:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> TT, k\<rbrace>; G \<rhd> ee : \<lbrace>V, k, C \<ggreater> T, m\<rbrace>; U \<inter> V = {}; TT = IntET\<rbrakk>
  \<Longrightarrow> G \<rhd> (LET x = e IN ee END): \<lbrace>U \<union> V, n, C \<ggreater> T, m\<rbrace>"
(*<*)apply (rule vdm_conseq,erule vdm_leti, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DASS_def, safe)
apply (drule preDAss_Unfold, clarsimp)
apply (drule CS_SPLIT, simp, assumption, clarsimp)
apply (erule_tac x="n2+q" in allE, rotate_tac -1, erule_tac x=F in allE, erule_tac x=R1 in allE, erule impE)
apply (drule preDAss_Fold, assumption+, fast, simp, fast)
apply clarsimp
apply (erule LetvAux1, assumption+)
apply (rule CS_Preserved_h_h1) apply (erule CS_PreservedU, simp+) apply (erule postDAss_Mod2) apply fast 
done(*>*)
(*
lemma DA_Leti:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> TT, k\<rbrace>; G \<rhd> ee : \<lbrace>V, k, C \<ggreater> T, m\<rbrace>; U \<inter> V = {}; TT = IntET\<rbrakk>
  \<Longrightarrow> G \<rhd> (LET x = e IN ee END): \<lbrace>U \<union> V, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq,erule vdm_leti, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAss_def, safe)
apply (drule CS_SPLIT)
apply (simp, assumption)
apply clarsimp
apply (erule_tac x="n2+q" in allE, erule_tac x=F in allE, erule_tac x=R1 in allE)
apply (erule impE)
apply (rule_tac x=N in exI, clarsimp)
apply (rule_tac x=n1 in exI, clarsimp)
apply fast
apply clarsimp
apply (erule_tac x=q in allE, erule_tac x=FF in allE,erule_tac x=R2 in allE, erule impE, clarsimp)
apply (rule_tac x=M in exI, clarsimp)
apply (rule_tac x=n2 in exI, clarsimp)
apply (rule, rule CS_Preserved_h_h1) apply (erule CS_PreservedU, simp+)
apply fast
apply fast
apply clarsimp
apply (rule_tac x=Rva in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
apply (simp add: mod2_def, clarsimp)
  apply (erule_tac x=l in allE, erule impE, clarsimp)
  apply (erule_tac x=l in allE, erule impE, clarsimp)
  apply fast
  apply (erule SameOHTransitive, assumption, simp)
apply fast
apply fast
done
*)
lemma DA_leti:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> TT, k\<rbrace>; G \<rhd> ee : \<lbrace>V, k, C \<ggreater> T, m\<rbrace>;
    U \<inter> V = {}; TT = IntET; W = U \<union> V\<rbrakk>
  \<Longrightarrow> G \<rhd> (LET x = e IN ee END): \<lbrace>W, n, C \<ggreater> T, m\<rbrace>"
by (rule vdm_conseq, rule DA_Leti, auto)
(*>*)

lemma LetrAux1a:
"\<lbrakk>(R1 \<union> R2) \<inter> F = {}; (E, h, V - {x}, C, R2, n2) \<in> CS;  R1 \<inter> R2 = {}; x \<in> V;
  postDAss (n2 + q) F R1 T h h1 k (RVal r) Rv S M FF\<rbrakk>
 \<Longrightarrow> \<exists>N P. preDAss q FF (Rv \<union> R2) E\<lfloor>x:=r\<rfloor> (C(x\<mapsto>\<^sub>fT)) V h1 k N P"
apply (rule, rule, simp add: postDAss_def preDAss_def, safe)
  apply assumption
  apply (erule CS_CONS, simp add: GETr_def)
    apply (rule CS_Preserved_h_h1, erule CS_PreservedU, subgoal_tac "xa \<noteq> x", simp,fast,
           erule GETr_Update2, fast, assumption, fast)
    apply fast
    apply simp
    apply simp
  apply fast
  apply fast
  apply simp
done
lemma LetrAux1b:
"\<lbrakk>(R1 \<union> R2) \<inter> F = {}; (E, h, V, C, R2, n2) \<in> CS; R1 \<inter> R2 = {}; x \<notin> V;
  postDAss (n2 + q) F R1 T h h1 k (RVal r) Rv S M FF\<rbrakk>
\<Longrightarrow> \<exists>N P. preDAss q FF R2 E\<lfloor>x:=r\<rfloor> (C(x\<mapsto>\<^sub>fT)) V h1 k N P"
  apply (rule, rule, simp add: postDAss_def preDAss_def, safe)
  apply assumption
  apply (rule CS_Preserved_h_h1, erule CS_PreservedU, subgoal_tac "xa \<noteq> x", simp,fast,
         erule GETr_Update2, fast, assumption, fast)
    apply fast
    apply simp
done

lemma LetrAux2a:
"\<lbrakk>postDAss (n2 + q) F R1 TT h h1 k w Rv S M FF;
  postDAss q FF (Rv \<union> R2) T h1 hh m v Rva Sa Ma FFa\<rbrakk>
 \<Longrightarrow> \<exists>Rv S M FF. postDAss q F (R1 \<union> R2) T h hh m v Rv S M FF"
apply (rule, rule, rule, rule, simp add: postDAss_def, safe)
apply assumption+
apply (erule mod2_transitive) 
      apply (subgoal_tac "FF \<union> (Rv \<union> R2) = (FF \<union> Rv) \<union> R2", clarsimp, assumption, fast)
      apply assumption+
      apply fast
apply fast+
done
lemma LetrAux2b:
"\<lbrakk>postDAss (n2 + q) F R1 TT h h1 k w Rv S M FF;
  postDAss q FF R2 T h1 hh m v Rva Sa Ma FFa\<rbrakk>
 \<Longrightarrow> \<exists>Rv S M FF. postDAss q F (R1 \<union> R2) T h hh m v Rv S M FF"
apply (rule, rule, rule, rule, simp add: postDAss_def, safe)
apply assumption+
apply (erule mod2_transitive) 
      apply assumption+
      apply fast
apply fast+
done

lemma DA_Letr:
  "\<lbrakk> G \<rhd> e : \<lbrace>U, n, C \<ggreater> TT, k\<rbrace>; G \<rhd> ee : \<lbrace>V, k, C(x\<mapsto>\<^sub>fTT) \<ggreater> T, m\<rbrace>;
     U \<inter> (V-{x}) = {}; TT = ListET K\<rbrakk>
  \<Longrightarrow> G \<rhd> (LET rf x = e IN ee END): \<lbrace>U \<union> (V-{x}), n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_conseq,erule vdm_letr, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DASS_def, safe)
apply (drule preDAss_Unfold, clarsimp)
apply (drule CS_SPLIT, simp, assumption, clarsimp)
apply (erule_tac x="n2+q" in allE, erule_tac x=F in allE, erule_tac x=R1 in allE)
apply (erule impE, drule preDAss_Fold, assumption+, fast, simp, fast)
apply clarsimp
apply (case_tac "x:V")
(*x:V*)
  apply (erule_tac x=q in allE, erule_tac x=xa in allE, erule_tac x="Rv \<union> R2" in allE, erule impE, clarsimp)
  apply (drule LetrAux1a, assumption+)
  apply clarsimp 
  apply (drule LetrAux2a, assumption+)
(*x \<notin>V*)
  apply (erule_tac x=q in allE, erule_tac x=xa in allE, erule_tac x="R2" in allE, erule impE, clarsimp)
  apply (drule LetrAux1b, assumption+)
  apply clarsimp 
  apply (drule LetrAux2b, assumption+)
done
lemma DA_letr:
     "\<lbrakk> G \<rhd> e : \<lbrace>U, n, C \<ggreater> TT, k\<rbrace>; G \<rhd> ee : \<lbrace>V, k, C(x\<mapsto>\<^sub>fTT) \<ggreater> T, m\<rbrace>;
     U \<inter> (V-{x}) = {}; TT = ListET K; W=(U \<union> (V-{x}))\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = e IN ee END): \<lbrace>W, n, C \<ggreater> T, m\<rbrace>"
by (rule vdm_conseq, rule DA_Letr, auto)
(*>*)

subsubsection {* Rules for let-primop combinations *}
lemma DA_Let_Int:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow> G \<rhd> (LET z = expr.Int i IN e END): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*) by (rule DA_leti, rule DA_int, auto)(*>*)

lemma DA_Let_Prim:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow> G \<rhd> (LET z = Primop f x y IN e END): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*) by(rule DA_leti, rule DA_prim, auto)(*>*)

lemma DA_Let_RPrim:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; x : DOM C; y : DOM C
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END): \<lbrace>{x,y} \<union> U, n, C \<ggreater> T, m\<rbrace>"
(*<*)(* since the data structures pointed to by x and y are not used
        in rprim, we dont need to require {x,y} \<inter> U = {}. Hence, the proof
        does not follow from DA_leti and DA_rprim, but unfolds the definitions.*)
apply (rule vdm_conseq, rule vdm_leti, rule vdm_rprim)
apply (assumption, clarsimp)
apply (simp add: DASS_def preDAss_def postDAss_def, safe)
apply (frule CS_SPLIT)
apply (subgoal_tac "U \<union> ((insert x (insert y U))-U)=insert x (insert y U)", assumption, fast, simp) 
apply clarsimp
apply (erule_tac x=q in allE, erule_tac x=F in allE,erule_tac x=R1 in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=n1 in exI, safe)
apply (erule CS_PreservedU) apply simp+
apply fastsimp
apply simp
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: mod2_def)
apply fast
apply fast
done
lemma DA_Let_rprim:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; x : DOM C; y : DOM C; V = ({x,y} \<union> U)
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END): \<lbrace>V, n, C \<ggreater> T, m\<rbrace>"
by (rule vdm_conseq, erule DA_Let_RPrim,auto)
(*>*)

lemma DA_Let_HD: 
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; x: DOM C\<rbrakk>
  \<Longrightarrow> G \<rhd> (LET h = GetFi x F0 IN e END): \<lbrace>{x} \<union> U, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi, assumption)
apply (erule thin_rl, clarsimp)
apply (simp add: DASS_def preDAss_def postDAss_def, safe)
apply (frule CS_SPLIT)
apply (subgoal_tac "U \<union> ((insert x U) - U) = insert x U", assumption, fast, simp)
apply clarsimp
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R1 in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=n1 in exI, safe)
apply (erule CS_PreservedU) apply simp+
apply fastsimp
apply simp
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: mod2_def)
apply fast
apply fast
done
lemma DA_Let_hd: 
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; x: DOM C; V=({x} \<union> U)
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET h = GetFi x F0 IN e END): \<lbrace>V, n, C \<ggreater> T, m\<rbrace>"
by (rule vdm_conseq, rule DA_Let_HD, auto)
(*>*)

lemma regLessList:"(RVal (Ref a), h, Some (ListET k), R, n) \<in> reg \<Longrightarrow> k \<le> n"
by (erule reg.elims, simp_all, clarsimp, erule mLIST.elims, simp_all)

lemma DA_Let_TL: 
  "\<lbrakk>GETr C y = Some (ListET k); nk = n+k; 
    G \<rhd> e : \<lbrace>U, nk, C(x\<mapsto>\<^sub>f(ListET k)) \<ggreater> T, m\<rbrace>;
    y \<notin> U - {x}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = GetFr y F1 IN e END) : \<lbrace>(U-{x}) \<union> {y}, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule DA_letr,rule vdm_conseq,rule vdm_getfr) defer 1
  apply assumption
  apply (subgoal_tac "{y} \<inter> (U - {x}) = {}", assumption, fast)
  apply simp
  apply simp
apply (rotate_tac 2, erule thin_rl, clarsimp)
apply (frule GETrSome_DOM)
apply (simp add: DASS_def preDAss_def postDAss_def, clarsimp)
apply (subgoal_tac "y \<in> {y} \<inter> DOM C") prefer 2 apply simp
apply (frule CS_regionsExist, assumption, clarsimp)
apply (drule CS_split) apply (subgoal_tac "y:{y}", assumption, simp)
apply (simp add: GETr_def, clarsimp)
apply (frule regLessList)
apply (drule reg_F1)
apply (rule_tac x="RR-{a}" in exI, rule_tac x="na-k" in exI, rule_tac x=N in exI, rule_tac x=F in exI, fastsimp)
done
lemma DA_Let_tl: 
  "\<lbrakk>GETr C y = Some (ListET k); nk = n+k; 
    G \<rhd> e : \<lbrace>U, nk, C(x\<mapsto>\<^sub>f(ListET k)) \<ggreater> T, m\<rbrace>; y \<notin> U; V=((U-{x}) \<union> {y})\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = GetFr y F1 IN e END) : \<lbrace>V, n, C \<ggreater> T, m\<rbrace>"
by (rule vdm_conseq, rule DA_Let_TL, auto)
(*>*)



lemma DA_If: 
  "\<lbrakk> G \<rhd> e1 : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; G \<rhd> e2 : \<lbrace>V, n, C \<ggreater> T, m\<rbrace>\<rbrakk>
  \<Longrightarrow> G \<rhd> (IF b THEN e1 ELSE e2): \<lbrace>U \<union> V, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_conseq, erule vdm_if, assumption, erule thin_rl, erule thin_rl, safe)
apply (rule DAss_PConst, erule DAss_monotone_in_U,fast)+
done
lemma DA_if: 
     "\<lbrakk> G \<rhd> e1 : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; 
        G \<rhd> e2 : \<lbrace>V, n, C \<ggreater> T, m\<rbrace>; W=U \<union> V\<rbrakk>
     \<Longrightarrow> G \<rhd> (IF b THEN e1 ELSE e2): \<lbrace>W, n, C \<ggreater> T, m\<rbrace>"
by (rule vdm_conseq, rule DA_If, auto)
(*>*)

lemma DA_Call0:
"\<lbrakk>(G \<union> {(CALL f, \<lambda> E h hh v p . \<exists> pp. tkcall pp = p \<and> \<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v pp)}) \<rhd> snd(funtable f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*) by (rule vdm_conseq, erule Call1, clarsimp, erule DAss_PConst) (*>*)

lemma DA_Call:
"\<lbrakk>(G \<union> {(CALL f, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>)}) \<rhd> snd(funtable f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk>
 \<Longrightarrow> G \<rhd> (CALL f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*) by (rule vdm_call, simp, erule vdm_conseq, clarsimp, erule DAss_PConst)(*>*)

lemma DA_Call2:
"\<lbrakk>G \<rhd> snd(funtable f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow> G \<rhd> (CALL f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*) by (rule vdm_call, simp, rule CtxtWeakSingleton, 
          erule vdm_conseq, clarsimp, erule DAss_PConst)(*>*)

lemma Cut2Call:"\<lbrakk>(D \<union> {(Call f, Q)}) \<rhd> e : P; finite D; contextProvable (D \<union> {(Call f,Q)}) D\<rbrakk> \<Longrightarrow> D \<rhd> e : P"
(*<*) by (rule cut2, auto) (*apply rule cut2 prefer 2 apply (assumption, fast+)*) (*>*)

lemma DA_Invs:
"\<lbrakk>({(c\<bullet>mn(args), \<lbrace>U, n, C \<ggreater> T, m\<rbrace>)} \<union> G) \<rhd> (snd (methtable c mn)) :  
    (\<lambda> E h hh v p  . \<forall> E'. E = newframe_env Nullref (fst (methtable c mn)) args E'  \<longrightarrow> 
                     (\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E' h hh v (\<langle>3 0 1 1\<rangle> \<oplus> p) )) \<rbrakk> \<Longrightarrow>
   G \<rhd> (c\<bullet>mn(args)) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>" 
(*<*)by (rule vdm_conseq, erule vdm_invokestatic, clarsimp)(*>*)

lemma Reg_Class:
"\<lbrakk>(RVal (Ref a), h, Some T, R, n) \<in> reg; T \<notin> {UnitET, IntET}\<rbrakk>
\<Longrightarrow> fmap_lookup (oheap h) a = Some DIAM"
by (erule reg.elims, simp_all, clarsimp, erule mLIST.elims, simp_all)

lemma DA_Free: 
  "\<lbrakk>GETr C x = Some T; T=(ListET k);m=n+1\<rbrakk> 
  \<Longrightarrow> G \<rhd> (DIAM\<bullet>Free ([RNarg x])) :  \<lbrace>{x}, n, C \<ggreater> UnitET, m\<rbrace>"
(*<*)
apply (rule vdm_invokestatic, simp, rule CtxtWeakSingleton)
apply (simp add: Meth_Free)
apply (rule vdm_conseq) 
apply (rule vdm_letr, rule vdm_getstat)
apply (rule vdm_letv, rule vdm_putfr, rule vdm_putstat)
apply (frule GETrSome_DOM)
apply (simp add: DASS_def, clarsimp)
apply (simp add: newframe_env_def evalARGS_def self_def preDAss_def, clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="Suc N" in exI, rule_tac x="F \<union> {a}" in exI)
apply (erule CS.elims, clarsimp, clarsimp, erule CS.elims, clarsimp, frule Ref_reg)
prefer 2 apply clarsimp
apply (simp add: postDAss_def, safe)
apply (simp add: freelist_def)
  apply (subgoal_tac "(Suc N, Ref a, F \<union> {a}, h
           \<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
              sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>)
          \<in> FL", simp)
  apply (rule FL_SUC, simp add: Reg_Class, fast, rule FL_UpdateOutside, simp, fast)
apply (rule regUnit)
apply (simp add: mod2_def sameOH_def)
done
lemma DA_free: 
  "\<lbrakk>GETr C x = Some T; T=(ListET k);m=n+1;U={x}\<rbrakk> 
  \<Longrightarrow> G \<rhd> (DIAM\<bullet>Free ([RNarg x])) : \<lbrace>{x}, n, C \<ggreater> UnitET, m\<rbrace>"
by (rule vdm_conseq,rule DA_Free, auto)
(*>*)

lemma preDAss_sameOnU:
"\<lbrakk>preDAss q F R E C U h n N P; \<forall> x. x:U \<longrightarrow> E\<lfloor>x\<rfloor>=EE\<lfloor>x\<rfloor>\<rbrakk> \<Longrightarrow> preDAss q F R EE C U h n N P"
by (simp add: preDAss_def, clarsimp, erule CS_PreservedU, simp, assumption) 

lemma DA_ListMatch: 
  "\<lbrakk>GETr C l = Some (ListET k); nk = n+k; 
    G \<rhd> e : \<lbrace>U, nk, C(t\<mapsto>\<^sub>f(ListET k)) \<ggreater> T, m\<rbrace>;
    l \<notin> U - {t}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET h = GetFi l F0; rf t = GetFr l F1 IN e END) : \<lbrace>(U-{t}) \<union> {l}, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
apply (rule DA_Let_TL,assumption+)
apply (simp add: DASS_def, clarsimp)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, rotate_tac -1, erule impE, rule, rule)
apply (erule preDAss_sameOnU, simp)
apply simp
done
(*>*)

lemma FreeSpec:
"G \<rhd>  (DIAM\<bullet>Free([RNarg l])) : 
       (\<lambda> E h hh v p . \<exists> a . E\<lfloor>l\<rfloor> = Ref a \<and>
                             hh = h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                                    sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr> \<and> 
                             v = arbitrary \<and> p = (mkRescomp 12 0 1 (Suc 0)))"
apply (rule vdm_invokestatic)
apply (simp, rule CtxtWeakSingleton)
apply (simp add: Meth_Free) 
apply (rule vdm_conseq) 
apply (rule vdm_letr, rule vdm_getstat,rule vdm_letv, rule vdm_putfr, rule vdm_putstat)
apply (simp add: self_def newframe_env_def evalARGS_def, clarsimp)
done 

lemma CSExtend:
"\<lbrakk>(E,h,U-{x},C,R,S) : CS; (RVal (E\<lfloor>x\<rfloor>), h, Some T, R1,n): reg; R1 \<inter> R = {}\<rbrakk>
\<Longrightarrow> \<exists> RR SS. (E,h,U,C(x\<mapsto>\<^sub>fT),RR,SS) : CS \<and> 
             (x:U \<longrightarrow>  RR = R \<union> R1 \<and> SS = n+S) \<and> 
             (x \<notin> U \<longrightarrow> RR = R \<and> SS = S)"
apply (case_tac "x:U", clarsimp)
apply (erule CS_CONS) apply (simp add: GETr_def)
  apply (erule CS_SameOnU)
  apply (rule GETr_Update1a, fast)
  apply (assumption,fast,simp)
apply clarsimp
  apply (erule CS_SameOnU)
  apply (rule GETr_Update1a, fast)
done

lemma CS_PreservedU_FWD:
"(E, ha, U - {t}, C, R2, n2) \<in> CS \<Longrightarrow> (E<h:=ha<a\<bullet>F0>>\<lfloor>t:=ha\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>, ha, U - {t}, C, R2, n2) \<in> CS"
by (erule CS_PreservedU, subgoal_tac "x \<noteq> t", simp, fast, assumption)

lemma mod2_Free:
"mod2 {a} h (h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
               sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>)"
by (simp add: mod2_def sameOH_def)

lemma DA_ListMatchD: 
  "\<lbrakk>GETr C l = Some (ListET k); nk = n+k+1; 
    G \<rhd> e : \<lbrace>U, nk, C(t\<mapsto>\<^sub>f(ListET k)) \<ggreater> T, m\<rbrace>;
    l \<notin> U; l \<noteq> t\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET h = GetFi l F0; rf t = GetFr l F1; _ = DIAM\<bullet>Free ([RNarg l]) IN e END) : \<lbrace>(U-{t}) \<union> {l}, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi, rule vdm_letr, rule vdm_getfr, rule vdm_letv)
apply (rule FreeSpec)
apply assumption
apply clarsimp
apply (frule GETrSome_DOM)
apply (simp add: DASS_def, safe)  
apply (drule preDAss_Unfold, clarsimp)
apply (drule CS_SPLIT)
apply (subgoal_tac "{l} \<union> (U - {t}) = insert l (U - {t})", assumption,fast,fast)
apply clarsimp
apply (erule CS.elims, clarsimp, clarsimp)
apply (rotate_tac -2) apply (erule CS.elims, clarsimp) prefer 2 apply clarsimp
apply (frule Ref_reg)
apply (frule reg_F1)
apply (frule regLessList)
apply (drule CS_PreservedU_FWD)
apply (frule CSExtend) apply simp apply fast apply clarsimp
apply (erule_tac x=q in allE, erule_tac x="F \<union> {a}" in allE, erule_tac x=RR in allE)
apply (rotate_tac -1, erule impE, clarsimp)
  apply (rule_tac x="Suc N" in exI, rule_tac x=SS in exI)
  apply (simp add: preDAss_def)
  apply (rule,simp add: freelist_def)
        apply (subgoal_tac "(Suc N, Ref a, F \<union> {a}, 
                             h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)), 
                               sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>) \<in> FL", simp) 
        apply(rule FL_SUC) apply simp
             apply (erule Reg_Class, simp)
             apply fast
             apply simp apply (erule FL_UpdateOutside) apply fast 
  apply (rule, erule CS_Preserved_h_h1, rule mod2_Free, fast)
  apply (rule, fast)
  apply (rule, fast)
  apply fastsimp
(*last goal*)
apply clarsimp
apply (rule, rule, rule, rule)
apply (simp add: postDAss_def, clarsimp)
apply (rule, assumption)
apply (rule, assumption)
apply simp
apply (rule, simp add: mod2_def, clarsimp)
  apply (subgoal_tac "la \<noteq> a")
  apply (erule_tac x=la in allE, rotate_tac -1, erule impE, fastsimp)  
  apply (simp add: sameOH_def, clarsimp)
      apply (erule_tac x=rfield in allE) apply (case_tac "rfield = DOLLAR_N", clarsimp, clarsimp)
  apply fast
apply (erule SubsetTransitive, fast) 
done
(*>*)
(*Old proof:
lemma DA_ListMatchD: 
  "\<lbrakk>GETr C l = Some (ListET k); nk = n+k+1; 
    G \<rhd> e : \<lbrace>U, nk, C(t\<mapsto>\<^sub>f(ListET k)) \<ggreater> T, m\<rbrace>;
    l \<notin> U; l \<noteq> t\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET h = GetFi l F0; rf t = GetFr l F1; _ = DIAM\<bullet>Free ([RNarg l]) IN e END) : \<lbrace>(U-{t}) \<union> {l}, n, C \<ggreater> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi, rule vdm_letr, rule vdm_getfr, rule vdm_letv)
apply (rule FreeSpec)
apply assumption
apply clarsimp
apply (frule GETrSome_DOM)
apply (simp add: DASS_def preDAss_def postDAss_def, safe)  
apply (drule CS_SPLIT)
apply (subgoal_tac "{l} \<union> (U - {t}) = insert l (U - {t})", assumption,fast,fast)
apply clarsimp
apply (rotate_tac -3) apply (erule CS.elims, clarsimp, clarsimp)
apply (rotate_tac -2) apply (erule CS.elims, clarsimp) prefer 2 apply clarsimp
apply (frule Ref_reg)
apply (frule reg_F1)
apply (subgoal_tac "k \<le> na")
prefer 2 apply (erule reg.elims, simp_all) apply clarsimp apply (erule mLIST.elims, simp_all) 
apply (case_tac "t:U")
(-t:U-)
  apply (erule_tac x=q in allE, erule_tac x="F \<union> {a}" in allE, erule_tac x="R2 \<union> (R1a - {a})" in allE, erule impE, clarsimp)
  apply (rule_tac x="Suc N" in exI, rule)
  apply (simp add: freelist_def)
        apply (subgoal_tac "(Suc N, Ref a, F \<union> {a}, 
                             h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)), 
                               sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>) \<in> FL", simp) 
        apply(rule FL_SUC) apply simp
             apply (erule reg.elims, simp_all)
             apply (erule mLIST.elims, simp_all) 
             apply fast
             apply (erule FL_UpdateOutside) apply fast 
  apply (rule_tac x="n2 + (na-k)" in exI, rule)
    apply (erule CS_CONS)
    apply simp
    apply (rule reg_Preserved) apply (simp add: GETr_def)
    apply (simp add: sameOH_def)
    apply (rule CS_Preserved_h_h1)
      apply (erule CS_PreservedU, simp, erule GETr_Update2, fastsimp)
      prefer 2 apply (subgoal_tac "R1a \<inter> R2 = {}", assumption, simp) 
      apply (simp add: mod2_def sameOH_def) 
    apply fast
    apply fast
    apply arith
    apply rule apply fast
    apply rule apply fast
    apply simp
    apply clarsimp
    apply (rule_tac x= Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
    apply (rule, simp add: mod2_def, clarsimp)
      apply (subgoal_tac "la \<notin> insert a (R2 \<union> (R1a - {a}) \<union> F)")
      prefer 2 apply fast
      apply (subgoal_tac "la \<noteq> a")
      prefer 2 apply fast
      apply (erule_tac x=la in allE, clarsimp)
      prefer 2 apply fast
      apply (simp add: sameOH_def, safe)
      apply (erule_tac x=rfield in allE) apply (case_tac "rfield = DOLLAR_N", clarsimp, clarsimp)
(-t\<notin>U-)
  apply (erule_tac x=q in allE, erule_tac x="F \<union> {a}" in allE, erule_tac x=R2 in allE, erule impE, clarsimp)
  apply (rule_tac x="Suc N" in exI, rule)
  apply (simp add: freelist_def)
        apply (subgoal_tac "(Suc N, Ref a, F \<union> {a}, 
                             h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)), 
                               sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>) \<in> FL", simp) 
        apply(rule FL_SUC) apply simp
             apply (erule reg.elims, simp_all)
             apply (erule mLIST.elims, simp_all) 
             apply fast
             apply (erule FL_UpdateOutside) apply fast 
  apply (rule_tac x=n2 in exI, rule)
    apply (rule CS_Preserved_h_h1)
      apply (erule CS_PreservedU) apply (subgoal_tac "x \<noteq> t", simp, fast) apply(erule GETr_Update2, fastsimp)
      prefer 2 apply (subgoal_tac "R1a \<inter> R2 = {}", assumption, simp) 
      apply (simp add: mod2_def sameOH_def) 
    apply (rule, fast)
    apply (rule, fast)
    apply simp
    apply clarsimp
    apply (rule_tac x= Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
    apply (rule, simp add: mod2_def, clarsimp)
      apply (subgoal_tac "la \<noteq> a")
      prefer 2 apply fast
      apply (erule_tac x=la in allE, clarsimp)
      prefer 2 apply fast
      apply (simp add: sameOH_def, safe)
      apply (erule_tac x=rfield in allE) apply (case_tac "rfield = DOLLAR_N", clarsimp, clarsimp)
done
*)

lemma FillSpec:"G \<rhd>  (DIAM\<bullet>Fill_DIID([RNarg x_, INarg tag_, INarg v0_, RNarg v1_])) : 
       (\<lambda> E h hh v p . \<forall> a . (E\<lfloor>x_\<rfloor> = Ref a \<longrightarrow>  hh=(h\<lparr>iheap := (iheap h)
                      (DOLLAR := (iheap h DOLLAR)
                         (a := ienv (newframe_env Nullref [RNpar x_, INpar tag_, INpar v0_, RNpar v1_]
                                      [RNarg x_, INarg tag_, INarg v0_, RNarg v1_] E)
                                tag_)),
                      iheap := (iheap h)
                        (DOLLAR := (iheap h DOLLAR)
                           (a := ienv (newframe_env Nullref [RNpar x_, INpar tag_, INpar v0_, RNpar v1_]
                                        [RNarg x_, INarg tag_, INarg v0_, RNarg v1_] E)
                                  tag_),
                         F0 := (iheap h F0)
                           (a := ienv (newframe_env Nullref [RNpar x_, INpar tag_, INpar v0_, RNpar v1_]
                                        [RNarg x_, INarg tag_, INarg v0_, RNarg v1_] E)
                                  v0_)),
                      rheap := (rheap h)
                        (F1 := (rheap h F1)
                           (a := renv (newframe_env Nullref [RNpar x_, INpar tag_, INpar v0_, RNpar v1_]
                                        [RNarg x_, INarg tag_, INarg v0_, RNarg v1_] E)
                                  v1_))\<rparr>) \<and>  v = (RVal (Ref a))))"
apply (rule vdm_invokestatic)
apply (simp add: Meth_Fill_DIID)
apply (rule CtxtWeakSingleton)
apply (rule vdm_conseq)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfr, rule vdm_rvar, clarsimp)
apply (simp add: newObj_def newframe_env_def evalARGS_def self_def) 
done

lemma AllocSpec:
"G \<rhd>  (DIAM\<bullet>Alloc([])) : (\<lambda> E h hh v p . 
        (h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Nullref \<longrightarrow>
            hh = \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM), 
                  iheap = iheap h, rheap = rheap h,
                  sheap = sheap h\<rparr> \<and> 
            v = RVal (Ref (freshloc (Dom h)))) \<and> 
         (h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<noteq> Nullref \<longrightarrow> 
            (\<exists> h1 r. (\<exists>a. h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Ref a \<and> h1 = h \<and> r = h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>) \<and>
                      hh = h1\<lparr>sheap := (sheap h1)(DIAM := (sheap h1 DIAM)(DOLLAR_F := r))\<rparr> \<and>
                      v = RVal h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)))"
apply (rule vdm_invokestatic)
apply (simp add: Meth_Alloc)
apply (rule CtxtWeakSingleton)
apply (rule vdm_conseq)
apply (rule vdm_letr, rule vdm_getstat)
apply (rule vdm_leti, rule vdm_rprim)
apply (rule vdm_if)
apply (rule vdm_new)
apply (rule Call1, simp add: Fun_AllocQ)
apply (rule CtxtWeakSingleton)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letv, rule vdm_putstat, rule vdm_rvar)
apply (simp only: newObj_def newframe_env_def evalARGS_def self_def, clarsimp)
done
        
lemma DA_Make_IID: 
"\<lbrakk>GETr C y = Some T; T = (ListET k);n=(Suc m + k)\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg x, RNarg y])) : \<lbrace>{y}, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_invokestatic, simp) 
apply (rule CtxtWeakSingleton)
apply (simp add: Meth_Make_IID DASS_def, clarsimp)
apply (rule vdm_conseq, rule vdm_letr)
apply (rule AllocSpec)
apply (rule FillSpec)
apply clarsimp
apply (simp add: newObj_def newframe_env_def evalARGS_def self_def)
apply (frule GETrSome_DOM)
(*apply (subgoal_tac "y:DOM C") prefer 2 apply (erule GETrSome_DOM)*)
apply (case_tac "h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>")
prefer 2 
(*h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<noteq> Nullref*) 
  apply (simp add: preDAss_def, clarsimp)
  apply (simp add: freelist_def)
  apply (erule FL.elims, clarify, clarsimp)
  apply (rule_tac x="R \<union> {a}" in exI, rule_tac x="xa+k" in exI, rule_tac x=n in exI, rule_tac x="X" in exI, clarsimp)
  apply (simp add: postDAss_def freelist_def)
  apply (rule,erule FL_Preserved) apply (simp add: sameOH_def) 
  apply rule apply (erule CS.elims, clarsimp, clarsimp)
             apply (erule CS.elims, clarsimp) prefer 2 apply clarsimp
             apply (erule reg.elims, clarsimp) apply (rule regList) apply (subgoal_tac "(Suc nb,Ref a, R \<union> {a}, h
           \<lparr>sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>)), iheap := (iheap h)(DOLLAR := (iheap h DOLLAR)(a := 1)),
              iheap := (iheap h)(DOLLAR := (iheap h DOLLAR)(a := 1), F0 := (iheap h F0)(a := ienv Ea x)),
              rheap := (rheap h)(F1 := (rheap h F1)(a := renv Ea y))\<rparr>)
          \<in> mLIST", simp)
     apply (rule mLIST_CONS) apply simp apply simp apply simp 
        apply assumption apply (erule mLIST_Preserved) apply (subgoal_tac "l \<noteq> a", simp add: sameOH_def,fast)
     apply simp apply (clarify, clarify)
  apply (simp add: mod2_def sameOH_def) 

(*h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Nullref*)
  apply (simp add: preDAss_def postDAss_def, clarsimp) 
  apply (simp add: freelist_def)
  apply (erule FL.elims, clarsimp)
  apply clarsimp
done
lemma DA_make_IID: 
"\<lbrakk>GETr C y = Some T; T = (ListET k);n=(Suc m + k);U={y}\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg x, RNarg y])) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
by (rule vdm_conseq, rule DA_Make_IID,auto)
(*>*)

(*<*)
end
(*>*)
(*
lemma regionsExist_TL:
"\<lbrakk>GETr C y = Some (ListET k); renv E y = Ref a; regionsExist (insert y (U - {x})) C h E\<rbrakk> 
  \<Longrightarrow> regionsExist U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>"
apply (simp add: regionsExist_def, safe)
apply (case_tac "xa = x", clarsimp) 
apply (erule_tac x=y in allE, erule impE, clarsimp) apply (erule GETrSome_DOM)
apply clarsimp apply (erule reg.elims, simp_all, clarsimp)
  apply (erule mLIST.elims, simp_all, clarsimp)
  apply (simp add: GETr_def) apply (rule, rule, erule regList)
  apply simp
apply (erule_tac x=xa in allE, erule impE, clarsimp)
apply (simp add: DOM_def)
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp)
apply (rule GETr_Update1, fast)
done

lemma regionsDistinct_TL:
"\<lbrakk>GETr C y = Some (ListET k); y \<notin> U; renv E y = Ref a; regionsExist (insert y (U - {x})) C h E;
  regionsDistinct (insert y (U - {x})) C h E\<rbrakk> 
  \<Longrightarrow> regionsDistinct U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>"
apply (simp add: regionsDistinct_def regionsExist_def, safe)
apply (case_tac "xa = x", clarsimp) 
apply (case_tac "xx = x", clarsimp)
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply clarsimp
apply (erule_tac x=y in allE, erule_tac x=xx in allE, erule_tac x=Rxa in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
apply (rule, simp add: DOM_def)
apply (rule, fast)
apply (rule, fast)
apply (rule,subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xx = GETr C xx", clarsimp, assumption)
apply (erule GETr_Update1)
apply (simp add: GETr_def)
apply (erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -3, erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -2, erule mLIST.elims, simp_all, clarsimp)
apply (subgoal_tac "n=nb \<and> R=X", clarsimp)
prefer 2 apply (erule mLIST_Unique, assumption)
apply fast
(%xa \<noteq> x%)
apply (case_tac "xx = x", clarsimp)
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply clarsimp
apply (erule_tac x=xa in allE, erule_tac x=y in allE, erule_tac x=Rx in allE, erule_tac x=Rxa in allE, erule impE, clarsimp)
apply (rule, simp add: DOM_def)
apply (rule, fast)
apply (rule,rule, subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp, assumption)
apply (rule GETr_Update1, fast)
apply (rule,fast)
apply (simp add: GETr_def)
apply (rotate_tac 8)
apply (erule reg.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -2, erule mLIST.elims, simp_all, clarsimp)
apply (subgoal_tac "n=nb \<and> R=X", clarsimp)
prefer 2 apply (erule mLIST_Unique, assumption)
apply fast
(% xx \<noteq> x%)
apply (erule_tac x=xa in allE, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp)
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xx = GETr C xx", clarsimp)
apply (rule, erule reg_DOM)
apply (rule, erule reg_DOM)
apply (rule, rule, fast)
apply (rule, fast)
apply (rule GETr_Update1, fast)
apply (rule GETr_Update1, fast)
apply fast
done

lemma distinctFrom_TL:
"\<lbrakk>GETr C y = Some (ListET k); y \<notin> U; renv E y = Ref a; regionsExist (insert y (U - {x})) C h E;
  distinctFrom (insert y (U - {x})) C h E F\<rbrakk>
  \<Longrightarrow> distinctFrom U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> F"
apply (simp add: distinctFrom_def regionsExist_def, safe)
apply (case_tac "xa = x", clarsimp) 
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply clarsimp
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply (erule_tac x=Rxa in allE, clarsimp)
apply (erule impE, rule, fast)
apply (erule reg.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -2, erule mLIST.elims, simp_all, clarsimp)
apply (subgoal_tac "n=nb \<and> R=X", clarsimp)
prefer 2 apply (erule mLIST_Unique, assumption)
apply fast
apply (rotate_tac 3, erule thin_rl)
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp)
apply (erule_tac x=xa in allE, erule impE, clarsimp)
apply (erule reg_DOM)
apply fast
apply (rule GETr_Update1,fast)
done

lemma modified_TL:
"\<lbrakk>GETr C y = Some (ListET k); y \<notin> U; renv E y = Ref a; regionsExist (insert y (U - {x})) C h E;
  modified F U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> hh\<rbrakk>
  \<Longrightarrow> modified F (insert y (U - {x})) C h E hh"
apply (simp add: modified_def regionsExist_def, safe)
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=l in allE, erule impE, clarsimp)
apply (case_tac "z=x", clarsimp)
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply clarsimp
apply (erule_tac x=y in allE, erule_tac x=Rx in allE, erule impE, clarsimp)
apply (rule, assumption)
apply (simp add: GETr_def)
apply (erule reg.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -2, erule mLIST.elims, simp_all, clarsimp)
apply (subgoal_tac "n=nb \<and> R=X", clarsimp)
apply (erule mLIST_Unique, assumption)
(%z \<noteq> x%)
apply (rotate_tac 3, erule thin_rl)
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) z = GETr C z", clarsimp)
apply (erule_tac x=z in allE,erule_tac x=Rz in allE, erule impE, clarsimp)
apply (rule,erule reg_DOM)
apply fast
apply fast
apply (rule GETr_Update1,fast)
done

lemma Bounded_TL:
"\<lbrakk>GETr C y = Some (ListET k); y \<notin> U; renv E y = Ref a; regionsExist (insert y (U - {x})) C h E;
  Bounded R F U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>\<rbrakk>
  \<Longrightarrow> Bounded R F (insert y (U - {x})) C h E"
apply (simp add: Bounded_def regionsExist_def)
apply (rule, rule)
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=l in allE, erule impE, clarsimp)
apply (erule disjE, simp)
apply (subgoal_tac "\<exists>xa. (xa = y \<or> xa \<in> U \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (case_tac "xa=x")
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply (rule_tac x=y in exI)
apply clarsimp
apply (rule_tac x=Rxa in exI,rule, rule_tac x=Sxa in exI, simp)
apply (simp add: GETr_def)
apply (erule reg.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -2, erule mLIST.elims, simp_all, clarsimp)
apply (subgoal_tac "n=nb \<and> Ra=X", clarsimp)
apply (erule mLIST_Unique, assumption)
(%xa \<noteq> x%)
apply (subgoal_tac "\<exists>xa. (xa = y \<or> xa \<in> U \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply (rule_tac x=xa in exI, simp add: DOM_def)
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp, fast)
apply (rule GETr_Update1,fast)
done
*)
(*
lemma regionsExist_TL2:
"\<lbrakk>GETr C x = Some (ListET k); renv E x = Ref a; x \<in> U; x \<in> DOM C; regionsExist U C h E\<rbrakk>
       \<Longrightarrow> regionsExist U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>"
apply (simp add: regionsExist_def,clarsimp) 
    apply (case_tac "x = xa",clarsimp)
    (%x = xa%) apply (erule_tac x=x in allE, clarsimp, simp add: GETr_def)
             apply (erule reg.elims, clarsimp)
             apply (erule mLIST.elims, clarsimp,clarsimp)
             apply (rule, rule,erule regList) apply simp apply clarsimp apply clarsimp
    (%x \<noteq> xa%) apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp) 
             apply (subgoal_tac "xa:DOM C",fast)
             apply (erule DOM_Update1, assumption)
             apply (erule GETr_Update1)
done

lemma regionsDistinct_TL2:
"\<lbrakk>GETr C x = Some (ListET k); renv E x = Ref a; x \<in> U; x \<in> DOM C; regionsExist U C h E; regionsDistinct U C h E\<rbrakk>
 \<Longrightarrow> regionsDistinct U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>"
apply (simp add: regionsDistinct_def, clarsimp) 
apply (case_tac "xa = x", clarsimp)
(%xa = x%) 
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE, rotate_tac -1, 
       erule_tac x=R in allE, rotate_tac -1, erule_tac x=Rxx in allE, erule impE, safe)
   apply (erule DOM_Update1, assumption)
   apply fastsimp
   apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xx = GETr C xx", clarsimp,fast) 
   apply (erule GETr_Update1)
   apply (rotate_tac -4, erule reg.elims, clarsimp) apply (erule mLIST.elims, clarsimp, clarsimp)
   apply (erule reg.elims, clarsimp)
   apply (subgoal_tac "n=na \<and> R=X", clarsimp,fast) 
   apply (erule mLIST_Unique, assumption)
   apply (clarsimp, clarsimp)
   apply (clarsimp, clarsimp)
(%xa \<noteq> x%) 
apply clarsimp
  apply (case_tac "xx=x",clarsimp)
  (%xx=x%)
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (erule_tac x=xa in allE, rotate_tac -1, erule_tac x=x in allE, rotate_tac -1, 
       erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=R in allE, erule impE, safe)
  apply (erule DOM_Update1,fast)
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp,fast) 
  apply (rule GETr_Update1,fast)
  apply fastsimp
  apply (rotate_tac -2, erule reg.elims, clarsimp) apply (erule mLIST.elims, clarsimp, clarsimp)
  apply (rotate_tac 8, erule reg.elims, clarsimp)
  apply (subgoal_tac "n=na \<and> R=X", clarsimp,fast) 
  apply (erule mLIST_Unique, assumption)
  apply (clarsimp, clarsimp)
  apply (clarsimp, clarsimp)
  (%xx=x%)
  apply (erule_tac x=xa in allE, rotate_tac -1, erule_tac x=xx in allE, rotate_tac -1, 
       erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Rxx in allE, erule impE, safe)
   apply (erule DOM_Update1,fast)
   apply (erule DOM_Update1,fast)
   apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp,fast) 
   apply (rule GETr_Update1,fast)
   apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xx = GETr C xx", clarsimp,fast) 
   apply (rule GETr_Update1,fast)
   apply fast
done

lemma distinctFrom_TL2:
"\<lbrakk>GETr C x = Some (ListET k); renv E x = Ref a; x \<in> U; x \<in> DOM C; regionsExist U C h E; distinctFrom U C h E F\<rbrakk>
\<Longrightarrow> distinctFrom U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> F"
apply (simp add: distinctFrom_def,clarsimp) 
apply (case_tac "x = xa",clarsimp)
(%x = xa%) 
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (erule_tac x=x in allE, clarsimp, simp add: GETr_def)
  apply (erule_tac x=R in allE, erule impE,fast)
  apply (erule reg.elims, clarsimp)
  apply (erule reg.elims, clarsimp)
  apply (rotate_tac -2, erule mLIST.elims, clarsimp,clarsimp)
  apply (subgoal_tac "n=nb \<and> Ra=X",clarsimp) 
  apply (erule mLIST_Unique, assumption)
  apply (clarsimp, clarsimp)
  apply (clarsimp, clarsimp)
(%x \<noteq> xa%) 
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp) 
  apply (subgoal_tac "xa:DOM C",fast)
  apply (erule DOM_Update1, assumption)
  apply (erule GETr_Update1)
done 

lemma modified_TL2:
"\<lbrakk>GETr C x = Some (ListET k); renv E x = Ref a; x \<in> U; x \<in> DOM C; regionsExist U C h E;
          modified F U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> hh; R \<inter> FF = {}\<rbrakk>
       \<Longrightarrow> modified F U C h E hh"
apply (simp add: modified_def,clarsimp) 
apply (erule_tac x=l in allE, erule impE, clarsimp)
apply (case_tac "z = x",clarsimp)
(%z = x%) 
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (erule_tac x=x in allE, clarsimp, simp add: GETr_def)
  apply (erule_tac x=Ra in allE, erule impE,fast)
  apply (erule reg.elims, clarsimp)
  apply (erule reg.elims, clarsimp)
  apply (rotate_tac -2, erule mLIST.elims, clarsimp,clarsimp)
  apply (subgoal_tac "n=nb \<and> Ra=X",clarsimp) 
  apply (erule mLIST_Unique, assumption)
  apply (clarsimp, clarsimp)
  apply (clarsimp, clarsimp)
(%z \<noteq> x%) 
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) z = GETr C z", clarsimp) 
  apply (subgoal_tac "z:DOM C",fast)
  apply (erule DOM_Update1,fast)
  apply (rule GETr_Update1, fast)
apply assumption
done 

lemma Bounded_TL2:
"\<lbrakk>GETr C x = Some (ListET k); renv E x = Ref a; x \<in> U;x \<in> DOM C; regionsExist U C h E;
  Bounded R F U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>\<rbrakk>
\<Longrightarrow> Bounded R F U C h E"
apply (simp add: Bounded_def) 
apply (rule, rule)
apply (erule_tac x=l in allE, erule impE, clarsimp)
apply (erule disjE, simp)
apply (subgoal_tac "\<exists>x. x \<in> U \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp, clarsimp)
apply (case_tac "xa = x",clarsimp)
(%xa = x%) 
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (rule_tac x=x in exI,clarsimp, simp add: GETr_def)
  apply (rule_tac x=Ra in exI)
  apply (rule, fast)
  apply (erule reg.elims, clarsimp)
  apply (erule reg.elims, clarsimp)
  apply (rotate_tac -2, erule mLIST.elims, clarsimp,clarsimp)
  apply (subgoal_tac "n=nb \<and> Ra=X",clarsimp) 
  apply (erule mLIST_Unique, assumption)
  apply (clarsimp, clarsimp)
  apply (clarsimp, clarsimp)
(%xa \<noteq> x%) 
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp) 
  apply (subgoal_tac "xa:DOM C",fast)
  apply (erule DOM_Update1,fast)
  apply (rule GETr_Update1, fast)
done 
(%>%)
*)
(*
lemma reg_h_h1_letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; x:DOM C; x:U2;
 (RVal E\<lfloor>x\<rfloor>, h, GETr C x, R, S) \<in> reg\<rbrakk>
 \<Longrightarrow> (RVal E\<lfloor>x\<rfloor>, h1, GETr C x, R, S) \<in> reg"
apply (rule reg_Preserved,assumption,clarsimp)
apply (simp add: modified_def, erule_tac x=l in allE, erule impE, safe)
apply (simp add: distinctFrom_def)
apply (erule_tac x=x in allE,clarsimp,fast) 
apply (erule reg_region_in_heap1, assumption)
apply (subgoal_tac "x \<noteq> z")
apply (simp add: regionsDistinct_def,fast)
apply fast
done

lemma reg_h1_h_letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; x:DOM C; x:U2;
  (RVal E\<lfloor>x\<rfloor>, h1, GETr C x, R, S) \<in> reg\<rbrakk>
 \<Longrightarrow> (RVal E\<lfloor>x\<rfloor>, h, GETr C x, R, S) \<in> reg"
apply (subgoal_tac "\<exists> RR SS . (RVal E\<lfloor>x\<rfloor>, h, GETr C x, RR, SS) \<in> reg", clarsimp)
apply (subgoal_tac "(RVal (renv E x), h1, GETr C x, RR, SS) \<in> reg")
apply (subgoal_tac "R=RR \<and> S=SS", clarsimp)
apply (erule reg_Unique, assumption)
apply (erule reg_h_h1_letv, assumption+)
apply (simp add: regionsExist_def)
done

lemma regEx_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E; 
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; \<forall> x . x:U2 \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> regionsExist U2 C h1 EE"
apply (simp (no_asm) add: regionsExist_def, clarsimp)
apply (erule impE,fast)
apply (subgoal_tac "\<exists>Rx Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg", clarsimp)
apply (rule_tac x=Rx in exI, rule_tac x=Sx in exI)
apply (erule reg_h_h1_letv, assumption+)
apply (simp add: regionsExist_def)
done

lemma regsDist_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; \<forall> x . x:U2 \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> regionsDistinct U2 C h1 EE"
apply (simp (no_asm) add: regionsDistinct_def, clarsimp)
apply (erule impE,fast)
apply (subgoal_tac "(RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg")
apply (subgoal_tac "(RVal (renv E xx), h, GETr C xx, Rxx, Sxx) \<in> reg")
apply (simp add: regionsDistinct_def,fast)
apply (erule reg_h1_h_letv, assumption+, simp)
apply (erule reg_h1_h_letv, assumption+, simp)
done

lemma distFr_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1;
  Bounded FF F U1 C h E; \<forall> x . x:U2 \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> distinctFrom U2 C h1 EE FF"
apply (simp (no_asm)add: distinctFrom_def, clarsimp)
apply (erule impE,fast)
apply (simp add: Bounded_def)
apply (subgoal_tac "Rx \<inter> (F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)})={}")
apply fast
apply (subgoal_tac "(RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg")
apply (subgoal_tac "Rx \<inter> F \<subseteq> {}")
apply (subgoal_tac "Rx \<inter> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)} \<subseteq>  {}",fast)
apply (rule, clarsimp)
apply (subgoal_tac "x \<noteq> z", simp add: regionsDistinct_def) apply fast
apply fast
apply (simp add: distinctFrom_def,fast)
apply (erule reg_h1_h_letv, assumption+)
done

lemma mod_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E; 
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1;
  Bounded FF F U1 C h E; modified FF U2 C h1 EE hh; \<forall> x . x:(U1 \<union> U2) \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> modified F (U1 \<union> U2) C h E hh"
apply (simp add: modified_def, clarsimp)
apply (subgoal_tac "modified F U1 C h E h1")
prefer 2 apply (simp add: modified_def)
apply (erule_tac x=l in allE, erule impE,clarsimp) apply fast
apply (erule SameOHTransitive)
apply (erule_tac x=l in allE, erule impE) apply rule
apply (simp add: Bounded_def)
apply (subgoal_tac "l \<notin> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}",fast)
apply clarsimp
apply fast
apply rule apply (simp add: modified_def) apply (erule_tac x=l in allE, erule impE,fast) apply (simp add: sameOH_def)
  apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
apply clarsimp
apply (subgoal_tac "(RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg",fast)
apply (erule reg_h1_h_letv, assumption+)
apply fast
done

lemma Bnd_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E; 
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; Bounded FF F U1 C h E;
  Bounded Ra FF U2 C h1 EE; \<forall> x . x:(U1 \<union> U2) \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> Bounded Ra F (U1 \<union> U2) C h E"
apply (simp add: Bounded_def)
apply (rule, rule)
apply (rotate_tac -3, erule_tac x=l in allE, erule impE,simp, erule disjE)
apply (subgoal_tac "l : F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply (subgoal_tac "l : F \<or> l: {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply (erule disjE,simp)
apply (subgoal_tac "\<exists>x. (x \<in> U1 \<or> x \<in> U2) \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",simp)
apply clarsimp
apply fast
apply (subgoal_tac "\<exists>x. (x \<in> U1 \<or> x \<in> U2) \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",simp)
apply clarsimp
apply (subgoal_tac "(RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg",fast)
apply (erule reg_h1_h_letv, assumption+)
done
*)
(*
lemma CS_Preserved_h_h1[rule_format]:
"(E, h, U, C, R, n) \<in> CS \<Longrightarrow> 
   (\<forall> h1 . (\<forall> x RR S . x : U \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>),h, GETr C x, RR, S) : reg \<longrightarrow> (\<forall> l . l : RR \<longrightarrow> sameOH {l} h h1))
          \<longrightarrow> (E, h1, U, C, R, n) \<in> CS)"
apply (erule CS.induct)
apply clarsimp apply (rule CS_NIL, simp, simp)
apply clarsimp
apply (rule CS_CONS, assumption) 
apply (rule reg_Preserved, assumption) apply (erule_tac x=x in allE,clarsimp) 
  apply (erule_tac x=R1 in allE,erule impE,fast)
  apply fast
apply fast
apply simp+
done
*)
(*
lemma CS_Preserved_h_h1[rule_format]:
"(E, h, U, C, R, n) \<in> CS \<Longrightarrow> (\<forall> RR. mod2 RR U h hh \<longrightarrow> RR \<inter> R = {} \<longrightarrow> (E, hh, U, C, R, n) \<in> CS)"
apply (erule CS.induct)
apply clarsimp apply (rule CS_NIL, simp, simp)
apply clarsimp
apply (erule CS_CONS)
apply (rule reg_Preserved, assumption) defer 1 
apply (erule_tac x=RR in allE, erule impE)
apply (simp add: mod2_def)
apply (erule impE, fast)
apply assumption+
apply simp+
apply (simp add: mod2_def)
apply clarsimp
apply (rotate_tac 2, erule thin_rl)
apply (erule_tac x=l in allE, erule impE, safe)
apply (erule reg_region_in_heap1, assumption)
apply fast
done
*)
(*
lemma regEx_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {}; regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
          distinctFrom (U1 \<union> (U2 - {x})) C h E F; modified F U1 C h E h1; (RVal r, h1, Some (ListET K), R, S) \<in> reg\<rbrakk>
 \<Longrightarrow> regionsExist U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor>"
apply (simp (no_asm) add: regionsExist_def, clarsimp)
apply (case_tac "xa=x",simp add: GETr_def,fast)
apply (subgoal_tac "xa : DOM C")
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa", clarsimp)
apply (subgoal_tac "\<exists>Rx Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg", clarsimp)
apply (rule_tac x=Rx in exI, rule_tac x=Sx in exI)
apply (erule reg_h_h1_letv, assumption+)
apply fast
apply assumption
apply (simp add: regionsExist_def) 
apply (rule GETr_Update1, fast)
apply (insert DOM_Update,fast)
done

lemma regsDist_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {}; regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
  distinctFrom (U1 \<union> (U2 - {x})) C h E F; (RVal r, h1, Some (ListET K), R, S) \<in> reg; modified F U1 C h E h1;
  R \<inter> FF = {}; Bounded R F U1 C h E\<rbrakk>
 \<Longrightarrow> regionsDistinct U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor>"
apply (simp add: regionsDistinct_def, clarsimp)
apply (subgoal_tac " regionsDistinct (U1 \<union> (U2 - {x})) C h E")
prefer 2 apply (simp add: regionsDistinct_def)
apply (case_tac "xa = x", clarsimp)
(%xa=x%)
  apply (case_tac "xx=x")
  (%xx=x%) apply clarsimp
  (%xx\<noteq>x%) apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xx = GETr C xx", clarsimp)
    apply (subgoal_tac "xx:DOM C")
    apply (subgoal_tac "R=Rx \<and> S=Sx", clarsimp)
    apply (simp add: Bounded_def, rule, rule)
    apply (subgoal_tac "(RVal (renv E xx), h, GETr C xx, Rxx, Sxx) \<in> reg")
    prefer 2 apply(erule reg_h1_h_letv, assumption+, fast, assumption+)
    apply (erule_tac x=xa in allE, erule impE,clarsimp)
    apply (erule disjE)
    (%1%) apply (rotate_tac 2, erule thin_rl, simp add: distinctFrom_def)
          apply (erule_tac x=xx in allE, erule impE, clarsimp) apply fast
    (%2%) apply clarsimp apply (subgoal_tac "xx \<noteq> xaa")
          apply (erule_tac x=xaa in allE, erule_tac x=xx in allE)
          apply (erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp) apply fast 
          apply fast apply (rotate_tac 2, erule thin_rl, fast)
    apply simp 
    apply (erule reg_Unique) apply (simp add: GETr_def)
    apply (erule DOM_Update1, fast)
    apply (rule GETr_Update1, fast)
(% xa \<noteq> x%)
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa", clarsimp)
  apply (subgoal_tac "xa:DOM C")
  apply (case_tac "xx=x")
    (% xx=x%)
    apply clarsimp
    apply (subgoal_tac "R=Rxx \<and> S=Sxx", clarsimp)
    apply (simp add: Bounded_def, rule, rule)
    apply (subgoal_tac "(RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg")
    prefer 2 apply(erule reg_h1_h_letv, assumption+, fast, assumption+)
    apply (erule_tac x=xaa in allE, erule impE,clarsimp)
    apply (erule disjE)
    (%1%) apply (rotate_tac 2, erule thin_rl, simp add: distinctFrom_def)
          apply (erule_tac x=xa in allE, erule impE, clarsimp) apply fast
    (%2%) apply clarsimp apply (subgoal_tac "xa \<noteq> xb")
          apply (erule_tac x=xa in allE, erule_tac x=xb in allE)
          apply (erule_tac x=Rx in allE, erule_tac x=Rxa in allE, erule impE, clarsimp) apply fast 
          apply fast apply (rotate_tac 2, erule thin_rl, fast)
    apply simp 
    apply (erule reg_Unique) apply (simp add: GETr_def)
    (% xx \<noteq> x%)
    apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xx = GETr C xx", clarsimp)
    apply (subgoal_tac "xx:DOM C")
    apply (erule_tac x=xa in allE, erule_tac x=xx in allE)
    apply (erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
    apply (rule, rule) apply (erule  reg_h1_h_letv, assumption+, fast, assumption)
    apply (rule) apply (erule  reg_h1_h_letv, assumption+, fast, assumption)
    apply simp
    apply (erule DOM_Update1, fast)
    apply (rule GETr_Update1, fast)
  apply (erule DOM_Update1, fast)
  apply (rule GETr_Update1, fast)
done

lemma distFrom_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {};regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
          distinctFrom (U1 \<union> (U2 - {x})) C h E F; (RVal r, h1, Some (ListET K), R, S) \<in> reg; modified F U1 C h E h1;
          R \<inter> FF = {}; Bounded R F U1 C h E; Bounded FF F U1 C h E\<rbrakk>
       \<Longrightarrow> distinctFrom U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor> FF"
apply (simp add: distinctFrom_def, clarsimp)
apply (subgoal_tac "distinctFrom (U1 \<union> (U2 - {x})) C h E F")
prefer 2 apply (simp add: distinctFrom_def)
apply (case_tac "xa=x", clarsimp)
(%xa=x%)
    apply (subgoal_tac "R=Rx \<and> S=Sx", clarsimp)
    apply (erule reg_Unique) apply (simp add: GETr_def)
(%xa\<noteq>x%)
    apply (subgoal_tac "(RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg")
    prefer 2 apply(erule reg_h1_h_letv, assumption+)
             apply (erule DOM_Update1, fast)
             apply fast
             apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa", clarsimp)
             apply (rule GETr_Update1, fast)
    apply (subgoal_tac "\<forall>l. l \<in> FF \<longrightarrow> l \<in> F \<or> (\<exists>x. x \<in> U1 \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx))")
    prefer 2 apply (simp add: Bounded_def)
    apply (subgoal_tac "Rx \<inter> (F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}) = {}", fast)
    apply (subgoal_tac "Rx \<inter> F = {} \<and>
                        Rx \<inter> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)} = {}",fast)
    apply rule
    (%1%) apply (erule_tac x=xa in allE, erule impE,clarsimp)
          apply (erule DOM_Update1, fast) apply fast
    (%2%) apply (rule,rule, clarsimp)
          apply (subgoal_tac "xa\<noteq>z")
          apply (simp add: regionsDistinct_def) 
          apply (erule_tac x=xa in allE, erule_tac x=z in allE, erule_tac x=Rx in allE, erule_tac x=Rz in allE, erule impE,clarsimp)
          apply (rule, erule DOM_Update1, fast) apply (rule,fast,fast)
          apply fast
          apply fast
   apply simp
done

lemma mod_Letr:
"\<lbrakk>U1 \<inter> (U2-{x}) = {}; regionsExist (U1 \<union> (U2-{x})) C h E; regionsDistinct (U1 \<union> (U2-{x})) C h E; 
  modified F U1 C h E h1; distinctFrom (U1 \<union> (U2-{x})) C h E F; Bounded FF F U1 C h E;
  modified FF U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor> hh; 
  (RVal r, h1, Some (ListET K), R, S) \<in> reg; Bounded R F U1 C h E\<rbrakk>
 \<Longrightarrow> modified F (U1 \<union> (U2-{x})) C h E hh"
apply (simp add: modified_def, clarsimp)
apply (subgoal_tac "modified F U1 C h E h1")
prefer 2 apply (simp add: modified_def)
apply (subgoal_tac "modified FF U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor> hh")
prefer 2 apply (simp add: modified_def)
apply (erule_tac x=l in allE, erule impE,clarsimp) apply (rotate_tac -6, erule_tac x=z in allE) apply fast
apply (erule SameOHTransitive)
apply (erule_tac x=l in allE, erule impE) apply rule
apply (subgoal_tac "\<forall>l. l \<in> FF \<longrightarrow> l \<in> F \<or> (\<exists>x. x \<in> U1 \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx))")
prefer 2 apply (simp add: Bounded_def)
apply (rotate_tac 5, erule thin_rl)
apply (subgoal_tac "l \<notin> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", fast)
apply clarsimp
apply fast
apply (rule, simp add: modified_def) apply (erule_tac x=l in allE, erule impE, fastsimp) apply (simp add: sameOH_def) apply (simp add: fmap_dom_def fmap_lookup_def dom_def) 
  apply clarsimp
apply (case_tac "z = x", clarsimp)
(%z=x%) apply (subgoal_tac "R=Rz \<and> S=Sz", clarsimp)
  apply (simp add: Bounded_def)
  apply (erule_tac x=l in allE, clarsimp)
  apply fast
  apply (erule reg_Unique) apply (simp add: GETr_def)
(% z \<noteq> x%) apply (subgoal_tac "z : DOM C")
  apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
  apply (subgoal_tac "(RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg",fast)
  apply (erule reg_h1_h_letv, assumption+)
  apply fast
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) z = GETr C z", clarsimp)
  apply (rule GETr_Update1, fast)
  apply fast
  apply (erule DOM_Update1, fast)
apply assumption
apply fast
done

lemma Bnd_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {};  regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
          distinctFrom (U1 \<union> (U2 - {x})) C h E F; (RVal r, h1, Some (ListET K), R, S) \<in> reg; modified F U1 C h E h1;
          R \<inter> FF = {}; Bounded R F U1 C h E; Bounded FF F U1 C h E; 
           modified FF U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor> hh;
          Bounded Ra FF U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor>\<rbrakk>
       \<Longrightarrow> Bounded Ra F (U1 \<union> (U2 - {x})) C h E"
apply (simp add: Bounded_def)
apply (rule, rule)
apply (rotate_tac -2, erule_tac x=l in allE, erule impE,simp, erule disjE)
apply (subgoal_tac "l : F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply (subgoal_tac "l : F \<or> l: {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply (erule disjE, simp)
apply (subgoal_tac "\<exists>xa. (xa \<in> U1 \<or> xa \<in> U2 \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (rotate_tac 8, erule thin_rl)
apply fast
apply (erule exE, (erule conjE)+)+ apply (erule exE)
apply (case_tac "xa=x")
(%xa=x%)
  apply (subgoal_tac "R=Rx \<and> S=Sx")
  apply (erule_tac x=l in allE, erule impE, clarsimp)
  apply (erule disjE, simp)
  apply (subgoal_tac "\<exists>xa. (xa \<in> U1 \<or> xa \<in> U2 \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
  apply clarsimp apply fast
  apply (erule reg_Unique) apply (simp add: GETr_def)
(%xa\<noteq>x%)
apply (subgoal_tac "\<exists>xa. (xa \<in> U1 \<or> xa \<in> U2 \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (subgoal_tac "xa : DOM C")
apply (rotate_tac 8, erule thin_rl)
apply (subgoal_tac "(RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg",fast)
apply (erule reg_h1_h_letv, assumption+)
apply fast
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa", clarsimp)
apply (rule GETr_Update1, fast)
apply (erule DOM_Update1, fast)
done
*)
