(*<*)
theory Flatten4 = mTreeList:
(*>*)

subsection{*Append and flatten*}

text {* Camelot code:
\begin{verbatim}
type itree = Leaf of int | Node of itree * itree
type ilist = Nil | Cons of int * ilist

let append l1 l2 = match l1 with Nil@_ => l2
                               | Cons(h,t)@_ => Cons(h,append t l2)

let flatten1 t = match t with Leaf(i) => Cons(i,Nil)
                           | Node(l,r) => append (flatten1 l) (flatten1 r)

let flatten2 t = match t with Leaf(i)@_ => Cons(i,Nil)
                           | Node(l,r)@_ => append (flatten2 l) (flatten2 r)

Analysis:
  append   : <0>, ilist[Nil(<0>)|Cons(int,#,<0>)] -> ilist[Nil(<0>)|Cons(int,#,<0>)]  -> ilist[Nil(<0>)|Cons(int,#,<0>)], <1>;
  flatten1 : <0>, itree[Leaf(int,<2>)|Node(#,#,<0>)] -> ilist[Nil(<0>)|Cons(int,#,<0>)], <0>;
  flatten2 : <1>, itree[Leaf(int,<0>)|Node(#,#,<0>)] -> ilist[Nil(<0>)|Cons(int,#,<0>)], <0>;
\end{verbatim}
Grail code:
\begin{verbatim}
method public static TreeList$dia_0 flatten2 (TreeList$dia_0 t) =
 let fun f:flatten2(TreeList$dia_0 t) =
      let val v4 = getfield t <int TreeList$dia_0.$>
      in if v4 = 0
         then f:0(t)
         else f:1(t)
      end

     fun f:1(TreeList$dia_0 t) =
      let val v3 = getfield t <TreeList$dia_0 TreeList$dia_0.f1>
          val v2 = getfield t <TreeList$dia_0 TreeList$dia_0.f2>
          val () = invokestatic <void TreeList$dia_0.free (TreeList$dia_0)> (t)
          val v1 = invokestatic <TreeList$dia_0 TreeList.flatten2 (TreeList$dia_0)> (v3)
          val t = invokestatic <TreeList$dia_0 TreeList.flatten2 (TreeList$dia_0)> (v2)
      in invokestatic <TreeList$dia_0 TreeList.append (TreeList$dia_0, TreeList$dia_0)> (v1, t)
      end

     fun f:0(TreeList$dia_0 t) =
      let val v4 = getfield t <int TreeList$dia_0.f0>
          val () = invokestatic <void TreeList$dia_0.free (TreeList$dia_0)> (t)
          val t = invokestatic <TreeList$dia_0 TreeList$dia_0.make (int)> (2)
      in invokestatic <TreeList$dia_0 TreeList$dia_0.make (int, int, TreeList$dia_0)> (3, v4, t)
      end
 in f:flatten2(t) end

method public static TreeList$dia_0 flatten1 (TreeList$dia_0 t) =
 let fun f:flatten1(TreeList$dia_0 t) =
      let val v4 = getfield t <int TreeList$dia_0.$>
      in if v4 = 0
         then f:0(t)
         else f:1(t)
      end

     fun f:1(TreeList$dia_0 t) =
      let val v3 = getfield t <TreeList$dia_0 TreeList$dia_0.f1>
          val v2 = getfield t <TreeList$dia_0 TreeList$dia_0.f2>
          val v1 = invokestatic <TreeList$dia_0 TreeList.flatten1 (TreeList$dia_0)> (v3)
          val t = invokestatic <TreeList$dia_0 TreeList.flatten1 (TreeList$dia_0)> (v2)
      in invokestatic <TreeList$dia_0 TreeList.append (TreeList$dia_0, TreeList$dia_0)> (v1, t)
      end

     fun f:0(TreeList$dia_0 t) =
      let val v4 = getfield t <int TreeList$dia_0.f0>
          val t = invokestatic <TreeList$dia_0 TreeList$dia_0.make (int)> (2)
      in invokestatic <TreeList$dia_0 TreeList$dia_0.make (int, int, TreeList$dia_0)> (3, v4, t)
      end
 in f:flatten1(t) end

method public static TreeList$dia_0 append (TreeList$dia_0 l1, TreeList$dia_0 l2) =
 let fun f:append(TreeList$dia_0 l1, TreeList$dia_0 l2) =
      let val v3 = getfield l1 <int TreeList$dia_0.$>
      in if v3 = 2
         then f:0(l1, l2)
         else f:1(l1, l2)
      end

     fun f:1(TreeList$dia_0 l1, TreeList$dia_0 l2) =
      let val v3 = getfield l1 <int TreeList$dia_0.f0>
          val v2 = getfield l1 <TreeList$dia_0 TreeList$dia_0.f1>
          val () = invokestatic <void TreeList$dia_0.free (TreeList$dia_0)> (l1)
          val l1 = invokestatic <TreeList$dia_0 TreeList.append (TreeList$dia_0, TreeList$dia_0)> (v2, l2)
      in invokestatic <TreeList$dia_0 TreeList$dia_0.make (int, int, TreeList$dia_0)> (3, v3, l1)
      end

     fun f:0(TreeList$dia_0 l1, TreeList$dia_0 l2) =
      let val () = invokestatic <void TreeList$dia_0.free (TreeList$dia_0)> (l1)
      in l2
      end
   in f:append(l1, l2)
   end
\end{verbatim}
*}

syntax b_  :: iname
       t_   :: rname
       v1_  :: rname 
       v2_  :: rname 
       v3_  :: rname
       vA3_  :: iname
       v4_  :: iname
 
       l1_  :: rname 
       l2_  :: rname 

       fFlatten1 :: funame
       fzeroFlatten1 :: funame
       foneFlatten1  :: funame
       Flatten1 :: mname

       fFlatten2 :: funame
       fzeroFlatten2 :: funame
       foneFlatten2  :: funame
       Flatten2 :: mname

       fAppend :: funame
       fzeroAppend :: funame
       foneAppend  :: funame
       Append :: mname


translations
 "b_" == "(In ''b'') "
 "t_" == "(RN ''t'') "
 "v1_" == "(RN ''v1'') "
 "v2_" == "(RN ''v2'') "
 "v3_" == "(RN ''v3'') "
 "vA3_" == "(In ''vA3'') "
 "v4_" == "(In ''v4'') "
 "l1_" == "(RN ''l1'') "
 "l2_" == "(RN ''l2'') "
 "fFlatten1" == "(FN ''fFlatten1'') "
 "fzeroFlatten1" == "(FN ''f_zeroFlatten1'')"
 "foneFlatten1" == "(FN ''f_oneFlatten1'')"
 "Flatten1" == "(MN ''Flatten1'')"
 "fFlatten2" == "(FN ''fFlatten2'') "
 "fzeroFlatten2" == "(FN ''f_zeroFlatten2'')"
 "foneFlatten2" == "(FN ''f_oneFlatten2'')"
 "Flatten2" == "(MN ''Flatten2'')"
 "fAppend" == "(FN ''fAppend'') "
 "fzeroAppend" == "(FN ''f_zeroAppend'')"
 "foneAppend" == "(FN ''f_oneAppend'')"
 "Append" == "(MN ''Append'')"

axioms Meth_Flatten1: 
"methtable DIAM Flatten1 = ([RNpar t_], CALL fFlatten1)"
lemma "methtable DIAM Flatten1 = ([RNpar t_], CALL fFlatten1)" by (simp add: Meth_Flatten1)

axioms Fun_fFlatten1:
"funtable fFlatten1 = LET v4_ = GetFi t_ DOLLAR;
                          b_ = Primop (\<lambda> z y. if z = 0 then 1 else 0) v4_ v4_
                     IN IF b_ THEN CALL fzeroFlatten1 ELSE CALL foneFlatten1 END"
lemma "funtable fFlatten1 = LET v4_ = GetFi t_ DOLLAR;
                                 b_ = Primop (\<lambda> z y. if z = 0 then 1 else 0) v4_ v4_
                            IN IF b_ THEN CALL fzeroFlatten1 ELSE CALL foneFlatten1 END" 
by (simp add: Fun_fFlatten1)

axioms Fun_foneFlatten1:
"funtable foneFlatten1 =
      LET rf v3_ = GetFr t_ F1;
          rf v2_ = GetFr t_ F2;
          rf v1_ = DIAM\<bullet>Flatten1 ([RNarg v3_]);
           rf t_ = DIAM\<bullet>Flatten1 ([RNarg v2_])
      IN DIAM\<bullet>Append ([RNarg v1_, RNarg t_]) END"

lemma "funtable foneFlatten1 =
      LET rf v3_ = GetFr t_ F1;
          rf v2_ = GetFr t_ F2;
          rf v1_ = DIAM\<bullet>Flatten1 ([RNarg v3_]);
           rf t_ = DIAM\<bullet>Flatten1 ([RNarg v2_])
      IN DIAM\<bullet>Append ([RNarg v1_, RNarg t_]) END"
by (simp add: Fun_foneFlatten1)

axioms Fun_fzeroFlatten1:
"funtable fzeroFlatten1 =
      LET v4_ = GetFi t_ F0;
        rf t_ = DIAM\<bullet>Make_I ([VALarg (IVal 2)])
      IN DIAM\<bullet>Make_IID ([VALarg (IVal 3), INarg v4_, RNarg t_])
      END"
lemma "funtable fzeroFlatten1 =
      LET v4_ = GetFi t_ F0;
        rf t_ = DIAM\<bullet>Make_I ([VALarg (IVal 2)])
      IN DIAM\<bullet>Make_IID ([VALarg (IVal 3), INarg v4_, RNarg t_])
      END"
by (simp add: Fun_fzeroFlatten1)

axioms Meth_Flatten2: 
"methtable DIAM Flatten2 = ([RNpar t_], CALL fFlatten2)"
lemma "methtable DIAM Flatten2 = ([RNpar t_], CALL fFlatten2)" by (simp add: Meth_Flatten2)

axioms Fun_fFlatten2:
"funtable fFlatten2 = LET v4_ = GetFi t_ DOLLAR;
                          b_ = Primop (\<lambda> z y. if z = 0 then 1 else 0) v4_ v4_
                     IN IF b_ THEN CALL fzeroFlatten2 ELSE CALL foneFlatten2 END"
lemma "funtable fFlatten2 = LET v4_ = GetFi t_ DOLLAR;
                                 b_ = Primop (\<lambda> z y. if z = 0 then 1 else 0) v4_ v4_
                            IN IF b_ THEN CALL fzeroFlatten2 ELSE CALL foneFlatten2 END" 
by (simp add: Fun_fFlatten2)

axioms Fun_foneFlatten2:
"funtable foneFlatten2 =
      LET rf v3_ = GetFr t_ F1;
          rf v2_ = GetFr t_ F2;
               _ = DIAM\<bullet>Free ([RNarg t_]);
          rf v1_ = DIAM\<bullet>Flatten2 ([RNarg v3_]);
           rf t_ = DIAM\<bullet>Flatten2 ([RNarg v2_])
      IN DIAM\<bullet>Append ([RNarg v1_, RNarg t_]) END"
lemma "funtable foneFlatten2 =
      LET rf v3_ = GetFr t_ F1;
          rf v2_ = GetFr t_ F2;
               _ = DIAM\<bullet>Free ([RNarg t_]);
          rf v1_ = DIAM\<bullet>Flatten2 ([RNarg v3_]);
           rf t_ = DIAM\<bullet>Flatten2 ([RNarg v2_])
      IN DIAM\<bullet>Append ([RNarg v1_, RNarg t_]) END"
by (simp add: Fun_foneFlatten2)

axioms Fun_fzeroFlatten2:
"funtable fzeroFlatten2 =
      LET v4_ = GetFi t_ F0;
            _ = DIAM\<bullet>Free ([RNarg t_]);
        rf t_ = DIAM\<bullet>Make_I ([VALarg (IVal 2)])
      IN DIAM\<bullet>Make_IID ([VALarg (IVal 3), INarg v4_, RNarg t_])
      END"
lemma "funtable fzeroFlatten2 =
      LET v4_ = GetFi t_ F0;
            _ = DIAM\<bullet>Free ([RNarg t_]);
        rf t_ = DIAM\<bullet>Make_I ([VALarg (IVal 2)])
      IN DIAM\<bullet>Make_IID ([VALarg (IVal 3), INarg v4_, RNarg t_])
      END"
by (simp add: Fun_fzeroFlatten2)

axioms Meth_Append: 
"methtable DIAM Append = ([RNpar l1_, RNpar l2_], CALL fAppend)"
lemma "methtable DIAM Append = ([RNpar l1_, RNpar l2_], CALL fAppend)" by (simp add: Meth_Append)
axioms Fun_fAppend:
"funtable fAppend = LET vA3_ = GetFi l1_ DOLLAR;
                         b_ = Primop (\<lambda> z y. if z = 2 then 1 else 0) vA3_ vA3_
                    IN IF b_ THEN CALL fzeroAppend ELSE CALL foneAppend END"
lemma "funtable fAppend = LET vA3_ = GetFi l1_ DOLLAR;
                               b_ = Primop (\<lambda> z y. if z = 2 then 1 else 0) vA3_ vA3_
                          IN IF b_ THEN CALL fzeroAppend ELSE CALL foneAppend END"
by (simp add: Fun_fAppend)

axioms Fun_fzeroAppend:
"funtable fzeroAppend = LET _ = DIAM\<bullet>Free ([RNarg l1_]) IN RVar l2_ END"
lemma "funtable fzeroAppend = LET _ = DIAM\<bullet>Free([RNarg l1_]) IN RVar l2_ END" 
by (simp add: Fun_fzeroAppend)

axioms Fun_foneAppend:
"funtable foneAppend =
      LET vA3_ = GetFi l1_ F0;
        rf v2_ = GetFr l1_ F1;
             _ = DIAM\<bullet>Free ([RNarg l1_]);
        rf l1_ = DIAM\<bullet>Append ([RNarg v2_, RNarg l2_])
      IN DIAM\<bullet>Make_IID ([VALarg (IVal 3), INarg vA3_, RNarg l1_]) END"
lemma "funtable foneAppend = 
      LET vA3_ = GetFi l1_ F0;
        rf v2_ = GetFr l1_ F1;
             _ = DIAM\<bullet>Free ([RNarg l1_]);
        rf l1_ = DIAM\<bullet>Append ([RNarg v2_, RNarg l2_])
      IN DIAM\<bullet>Make_IID ([VALarg (IVal 3), INarg vA3_, RNarg l1_]) END"
by (simp add: Fun_foneAppend)
(*
text {*Auxiliary lemmas on fresh locations.*}
lemma freshlocInsert1[simp, rule_format]: 
"\<forall> h . freshloc (Dom h) \<noteq> freshloc (insert (freshloc (Dom h)) (Dom h))"
apply clarsimp
apply (subgoal_tac "freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> insert (freshloc (Dom h)) (Dom h)")
apply (subgoal_tac "freshloc (Dom h) : insert (freshloc (Dom h)) (Dom h)")
prefer 2 apply simp
prefer 2 apply (rule freshloc, fast)
apply auto
done

lemma freshlocInsert2[simp]: 
"fmap_lookup (oheap h(freshloc (Dom h)\<mapsto>\<^sub>fC)(freshloc (insert (freshloc (Dom h)) (Dom h))\<mapsto>\<^sub>fC)) (freshloc (Dom h)) = Some C"
by (simp add: FMAPlookup3)

lemma freshlocInsert3[simp]: 
"freshloc (insert (freshloc (Dom h)) (Dom h)) \<noteq> freshloc (Dom h)"
by (insert freshlocInsert1 [of h], fastsimp)

lemma freshlocInsert4[simp]: 
"freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> Dom h"
apply (subgoal_tac "freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> (insert (freshloc (Dom h)) (Dom h))")
apply (subgoal_tac "Dom h \<subseteq> insert (freshloc (Dom h)) (Dom h)", fast, fast, rule freshloc, fast)
done

lemma freshlocInsert5[simp]:
   "same (Dom h)  h \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM)(freshloc (insert (freshloc (Dom h)) (Dom h))\<mapsto>\<^sub>fDIAM),
                     iheap = (iheap h)
                      (DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := 2, freshloc (insert (freshloc (Dom h)) (Dom h)) := 3),
                       F0 := (iheap h F0)(freshloc (insert (freshloc (Dom h)) (Dom h)) := h<a\<bullet>F0>)),
                     rheap = (rheap h)(F1 := (rheap h F1)(freshloc (insert (freshloc (Dom h)) (Dom h)) := Ref (freshloc (Dom h)))),
                     sheap = sheap h\<rparr>"
by (simp add: same_def sameOH_def FMAPlookup3) 
*)

subsubsection {*Verification of @{text append} and @{text flatten}*}
lemma Lookup_SameOH: "\<lbrakk>h@@a = Some C; sameOH X h h1; a : X\<rbrakk> \<Longrightarrow> h1@@a = Some C"
by (simp add: sameOH_def)
lemma Lookup_DOM: "h@@l = Some C \<Longrightarrow> l : Dom h"
by (simp add: fmap_lookup_def fmap_dom_def dom_def)

text {*First, we define a context which associates all syntactically occurring method calls
       to their specifications.
       The entries for \verb|fill| and \verb|alloc| allow to discharge the assumptions in the auxiliary lemmas
       for the \verb|make| methods. Notice that the context has several entries for
       the methods \verb|Make_IID|, \verb|Append| and \verb|Flatten|.*}
constdefs flattenContext:: vdmcontext
"flattenContext \<equiv> {(DIAM\<bullet>Free([RNarg l1_]), MS DIAM Free [RNarg l1_]),
                    (DIAM\<bullet>Free([RNarg t_]), MS DIAM Free [RNarg t_]),
                    (DIAM\<bullet>Alloc ([]), MS DIAM Alloc []),
                    (DIAM\<bullet>Make_I([VALarg (IVal 2)]), MS DIAM Make_I [VALarg (IVal 2)]),
                    (DIAM\<bullet>Make_IID([VALarg (IVal 3), INarg vA3_, RNarg l1_]), 
                         MS DIAM Make_IID [VALarg (IVal 3), INarg vA3_, RNarg l1_]),
                    (DIAM\<bullet>Make_IID([VALarg (IVal 3), INarg v4_, RNarg t_]), 
                         MS DIAM Make_IID [VALarg (IVal 3), INarg v4_, RNarg t_]),
                    (DIAM\<bullet>Append([RNarg v2_,RNarg l2_]), MS DIAM Append [RNarg v2_,RNarg l2_]),
                    (DIAM\<bullet>Append([RNarg v1_, RNarg t_]), MS DIAM Append [RNarg v1_, RNarg t_]),
                    (DIAM\<bullet>Flatten1 ([RNarg v3_]), MS DIAM Flatten1 [RNarg v3_]),  
                    (DIAM\<bullet>Flatten1 ([RNarg v2_]), MS DIAM Flatten1 [RNarg v2_]),
                    (DIAM\<bullet>Flatten2 ([RNarg v3_]), MS DIAM Flatten2 [RNarg v3_]),  
                    (DIAM\<bullet>Flatten2 ([RNarg v2_]), MS DIAM Flatten2 [RNarg v2_])}" 

text {*Next, we give the specifications of the two methods.*}
constdefs appendSpec::bool
"appendSpec == 
(MS DIAM Append = 
  (\<lambda> args E h hh v p. 
     (\<forall> Ups1 Ups2 ll1 ll2 X1 X2 n X. (evalARGS E args =[RVal (Ref ll1), RVal (Ref ll2)] \<and> 
                                        (Ups1,ll1,X1,h): mList \<and> (Ups2,ll2,X2,h): mList \<and> 
                                        (n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL \<and> X1 \<inter> X2 = {} \<and> X1 \<inter> X = {} \<and> X \<inter> X2 = {}) \<longrightarrow> 
                                     (\<exists> a Z XX. v = RVal (Ref a) \<and> (Ups1+Ups2,a,Z,hh):mList \<and> 
                                                (Suc n, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, XX, hh) : FL \<and> XX \<inter> Z = {} \<and> 
                                                Z \<subseteq> X1 \<union> X2 \<union> X \<and> XX \<subseteq> X \<union> X1 \<and> 
                                                sameOH ((Dom h)-(X \<union> X1)) h hh \<and> Dom hh = Dom h))))"

lemma Append_Aux:
"\<lbrakk>appendSpec; free_Spec; make_IID_Spec; fill_DIID_Spec; alloc_Spec; G = flattenContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Append) : 
                    (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Append)) x E' \<longrightarrow>
                                       MS DIAM Append x E' h hh v
                                          (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (simp add: Meth_Append)
apply (rule vdm_conseq)
apply (rule Call1, simp add: Fun_fAppend, safe)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_fzeroAppend)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_foneAppend)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
txt {*end of simple VCG*}
apply (simp add: IMPLIES_def appendSpec_def newframe_env_def evalARGS_def, clarsimp) apply(erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims, simp add: predicates) apply clarsimp
apply (simp add: free_Spec_def newframe_env_def evalARGS_def, clarsimp) apply(erule thin_rl)
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letvComb_def) apply (clarsimp)
apply (simp add: free_Spec_def newframe_env_def evalARGS_def, clarsimp) apply(erule thin_rl)
apply (simp add: letrComb_def) apply (clarsimp)
apply (simp add: make_IID_Spec_def newframe_env_def evalARGS_def) apply(erule thin_rl)
txt {* end of extended vcg, now discharge the 2 side conditions*}
prefer 2
txt {*Case NIL*}
apply (erule mList.elims, simp_all, clarsimp)
apply (rule_tac x=X2 in exI)
apply (rule, rule mListSameOH, assumption, simp add: sameOH_def)
apply (rule_tac x="X \<union> {a}" in exI, rule)
apply (rule FL_SUC, simp_all)
apply (erule FL_SameOH, simp add: sameOH_def)
apply (rule, fast)
apply (simp add: sameOH_def)
txt {*Case CONS*}
apply (erule mList.elims, simp_all, clarsimp)
apply (erule_tac x=na in allE, erule_tac x=Ups2 in allE, 
       erule_tac x=Xa in allE, erule_tac x=X2 in allE)
apply (rotate_tac -1)
apply (erule_tac x="Suc n" in allE, erule_tac x="X \<union> {a}" in allE)
apply (erule impE)
  apply (rule, erule mListSameOH, simp add: sameOH_def)
  apply (rule, erule mListSameOH, simp add: sameOH_def)
  apply (rule, rule FL_SUC, simp_all) 
  apply (erule FL_SameOH, simp add: sameOH_def)
apply clarsimp
apply (erule_tac x="Suc (Suc n)" in allE, clarsimp)
apply (erule impE, rule, assumption, safe)
apply (rule_tac x=l in exI, clarsimp)
apply(rotate_tac 5)
apply (subgoal_tac "l : XX") prefer 2 apply (erule FL.elims, simp_all, clarsimp)
apply (subgoal_tac "l \<notin> Z") prefer 2 apply fast
apply (simp add: predicates, clarsimp)
  apply(rule_tac x="Z \<union> {la}" in exI)
  apply (rule, rule mListCONS, simp_all)
  apply (erule FL.elims, simp_all)
  apply (erule mListSameOH, simp add: sameOH_def)
  apply (erule FL.elims, simp_all, clarsimp)
  apply (rule_tac x=Xb in exI, clarsimp, rule)
  apply (rule FL_SameOH, assumption, simp add: sameOH_def)
  apply (rule, fast)
apply (simp add: sameOH_def)
apply clarsimp
apply (rule, clarsimp)
apply clarsimp
apply (erule_tac x=l in allE, clarsimp)
apply (rule, clarsimp)
apply (erule_tac x=F1 in allE, clarsimp)
apply clarsimp
apply (erule_tac x=rfield in allE)
apply (case_tac "rfield = DOLLAR_N", clarsimp, clarsimp)
done
(*
constdefs flatten2Spec::bool
"flatten2Spec == 
(MS DIAM Flatten2 = 
  (\<lambda> args E h hh v p. 
     (\<forall> Ups Y ll X n. (evalARGS E args = [RVal (Ref ll)] \<and> (Ups,ll,Y,h): mTree \<and> 
                       (Suc n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL \<and> X \<inter> Y = {}) \<longrightarrow>
                      (\<exists> a Z XX. v = RVal (Ref a) \<and> (2 ^ Ups,a,Z,hh):mList \<and> 
                                 (n, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, XX, hh) : FL \<and> XX \<inter> Z = {} \<and> XX \<subseteq> X \<and> Z \<subseteq> X \<union> Y \<and> 
                                 sameOH ((Dom h)- (Y\<union>X)) h hh \<and> Dom hh = Dom h))))"
*)
constdefs flatten2Spec::bool
"flatten2Spec == 
(MS DIAM Flatten2 = 
  (\<lambda> args E h hh v p.  
     (\<forall> Ups Y ll X n. (evalARGS E args = [RVal (Ref ll)] \<and> (Ups,ll,Y,h): mTree \<and> 
                       (Suc n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL \<and> X \<inter> Y = {}) \<longrightarrow>
                      (\<exists> a Z XX k. v = RVal (Ref a) \<and> (2 ^ Ups,a,Z,hh):mList \<and> 
                                 (k, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, XX, hh) : FL \<and> XX \<inter> Z = {} \<and> XX \<subseteq> X \<and> Z \<subseteq> X \<union> Y \<and> 
                                 sameOH ((Dom h)- (Y\<union>X)) h hh \<and> Dom hh = Dom h \<and>  n \<le> k))))"

lemma flatten2_Aux:
"\<lbrakk>flatten2Spec; free_Spec; make_I_Spec; make_IID_Spec; appendSpec; alloc_Spec; G = flattenContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Flatten2) : 
                   (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Flatten2)) x E' \<longrightarrow>
                                      MS DIAM Flatten2 x E' h hh v
                                        (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p)))) "
apply (simp add:  Meth_Flatten2)
apply (rule vdm_conseq)
apply (rule Call1, simp add: Fun_fFlatten2)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_fzeroFlatten2)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule Call1, simp add: Fun_foneFlatten2)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply clarsimp
txt {*end of simple VCG*}
apply (simp add: flatten2Spec_def newframe_env_def evalARGS_def, auto)
apply (erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, safe)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letvComb_def, clarsimp)
apply (simp add: free_Spec_def newframe_env_def evalARGS_def, erule thin_rl, clarsimp) 
apply (simp add: letrComb_def, clarsimp)
apply (simp add: make_I_Spec_def newframe_env_def evalARGS_def)
apply (erule thin_rl)
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates) 
apply (simp add: letvComb_def, clarsimp)
apply (simp add: free_Spec_def newframe_env_def evalARGS_def, erule thin_rl, clarsimp) 
apply (simp add: letrComb_def, clarsimp)
txt {*end of extended VCG. Now discharge the 2 side conditions*}
prefer 2
txt {*Case LEAF*}
apply (erule mTree.elims, simp_all, clarsimp)
apply (erule_tac x="Suc n" in allE, clarsimp)
apply (erule FL.elims, simp_all, clarsimp)
apply (erule impE, rule_tac x="Xa \<union> {a}" in exI)
  apply (rule FL_SUC, simp_all) 
  apply (erule FL.elims, simp_all, clarsimp)
  apply (subgoal_tac "ha\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Ref a", clarsimp)  
    apply (erule FL_SameOH, simp add: sameOH_def)
    apply (erule FL.elims, simp_all, clarsimp)
      
apply(, rule_tac x="X \<union> {a}" in exI)apply (rule FL_SUC, simp_all)
apply (rule FL_SameOH, assumption, simp add: sameOH_def)
apply (simp add: predicates, clarsimp)
apply (simp add: make_IID_Spec_def newframe_env_def evalARGS_def, erule thin_rl)
apply (erule_tac x="(Suc n)" in allE, clarsimp)
apply (erule impE, rule)
apply (rule FL_SameOH, assumption, simp add: sameOH_def)
apply clarsimp
apply (rule_tac x=l in exI, simp)
apply (subgoal_tac "l : X") prefer 2 apply (erule FL.elims, simp_all, clarsimp)
apply (subgoal_tac "l \<noteq> a") prefer 2 apply fast
apply (simp add: predicates, clarsimp)
apply (rule_tac x="{a} \<union> {la}" in exI, rule)
apply (rule mListCONS, simp_all) apply (erule FL.elims, simp_all)
apply (rule mListNIL, simp_all)
apply (erule FL.elims, simp_all, clarsimp)
apply (rule_tac x="Xa" in exI, rule)
apply (erule FL_SameOH, simp add: sameOH_def)
apply safe
apply (simp add: sameOH_def)
apply (erule mTree.elims, simp_all)
txt{*Case node*}
apply (subgoal_tac "ll:Y")
apply (erule mTree.elims, simp_all, clarsimp)
apply (erule_tac x=na in allE, erule_tac x=X1 in allE, erule_tac x="X \<union> {a}" in allE)
apply (rotate_tac -1)
apply (erule_tac x="Suc n" in allE, erule impE)
apply (rule, erule mTreeSameOH, simp add: sameOH_def)
apply (rule, rule FL_SUC, simp_all)
apply (erule FL.elims, simp_all, clarsimp)
apply (erule FL.elims, simp_all, clarsimp)

??
apply (simp add: make_I_Spec_def newframe_env_def evalARGS_def, erule thin_rl)
apply (erule_tac x="Suc (Suc n)" in allE, clarsimp)
apply (erule impE, rule_tac x="X \<union> {a}" in exI)
apply (rule FL_SUC, simp_all)
apply (rule FL_SameOH, assumption, simp add: sameOH_def)
apply clarsimp
apply (simp add: predicates, clarsimp)
apply (simp add: make_IID_Spec_def newframe_env_def evalARGS_def, erule thin_rl)
apply (erule_tac x="(Suc n)" in allE, clarsimp)
apply (erule impE, rule)
apply (rule FL_SameOH, assumption, simp add: sameOH_def)
apply clarsimp
apply (rule_tac x=l in exI, simp)
apply (subgoal_tac "l : X") prefer 2 apply (erule FL.elims, simp_all, clarsimp)
apply (subgoal_tac "l \<noteq> a") prefer 2 apply fast
apply (simp add: predicates, clarsimp)
apply (rule_tac x="{a} \<union> {la}" in exI, rule)
apply (rule mListCONS, simp_all) apply (erule FL.elims, simp_all)
apply (rule mListNIL, simp_all)
apply (erule FL.elims, simp_all, clarsimp)
apply (rule_tac x="Xa" in exI, rule)
apply (erule FL_SameOH, simp add: sameOH_def)
apply safe
apply (simp add: sameOH_def)
apply (erule mTree.elims, simp_all)
apply (rule mListCONS, simp_all) apply (erule FL.elims, simp_all)
apply (rule mListNIL, simp_all)

apply (erule impE, rule, erule FL_SameOH, simp add: sameOH_def)
apply clarsimp
apply (case_tac "n=0", clarsimp)
  (*1*)
  apply (rule_tac x="{aa} \<union> {freshloc (Dom h)}" in exI, rule)
  apply (rule mListCONS, simp_all)
  defer 1
  apply (rule mListNIL, simp_all)
  defer 1 defer 1
  apply (rule_tac x=Xa in exI, rule)
  apply (subgoal_tac "freshloc (Dom h) \<notin> Xa")
  apply (erule FL_SameOH) apply( simp add: sameOH_def)
  apply clarsimp
oops
(*third goal is false -- we had an alloc!!!*)


constdefs flatten1Spec::bool
"flatten1Spec == 
(MS DIAM Flatten1 = 
  (\<lambda> args E h hh v p. 
     (\<forall> Ups Y ll X m. (evalARGS E args = [RVal (Ref ll)] \<and> (Ups,ll,Y,h): mTree \<and> 
                       (2^(Ups+1)+m, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL \<and> X \<inter> Y = {}) \<longrightarrow>
                      (\<exists> a Z XX. v = RVal (Ref a) \<and> (2 ^ Ups,a,Z,hh):mList \<and> 
                                 (m, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, XX, hh) : FL \<and> XX \<inter> Z = {} \<and> XX \<subseteq> X \<and> Z \<subseteq> X \<union> Y \<and> 
                                 sameOH ((Dom h)- (Y \<union> X)) h hh \<and> Dom hh = Dom h))))"

lemma flatten1_Aux:
"\<lbrakk>flatten1Spec; make_I_Spec; make_IID_Spec; appendSpec; alloc_Spec; G = flattenContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Flatten1) : 
                   (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Flatten1)) x E' \<longrightarrow>
                                      MS DIAM Flatten1 x E' h hh v
                                        (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p)))) "
apply (simp add:  Meth_Flatten1)
apply (rule vdm_conseq)
apply (rule Call1, simp add: Fun_fFlatten1)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_fzeroFlatten1)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule Call1, simp add: Fun_foneFlatten1)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply clarsimp
txt {*end of simple VCG*}
apply (simp add: flatten1Spec_def newframe_env_def evalARGS_def, clarsimp) 
apply (erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, safe)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def, clarsimp)
apply (simp add: make_I_Spec_def newframe_env_def evalARGS_def, erule thin_rl) 
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def, clarsimp)
apply (simp add: appendSpec_def newframe_env_def evalARGS_def)
apply (rotate_tac 2, erule thin_rl) 
txt {*end of extended VCG. Now discharge the 2 side conditions*}
prefer 2
txt {*Case LEAF*}
apply (erule mTree.elims, simp_all, clarsimp)
apply (erule_tac x="Suc (Suc m)" in allE, clarsimp)
apply (erule impE, rule, assumption)
apply clarsimp
apply (simp add: predicates, clarsimp)
apply (simp add: make_IID_Spec_def newframe_env_def evalARGS_def, erule thin_rl) 
apply (erule FL.elims,simp_all, clarsimp)
apply (erule_tac x="Suc m" in allE)
apply (erule impE, rule, erule FL_SameOH, simp add: sameOH_def)
apply clarsimp
apply (simp add: predicates, clarsimp)
apply (subgoal_tac "la : Xa") prefer 2 apply (erule FL.elims, simp_all)
apply (rule_tac x="{aa} \<union> {la}" in exI, rule)
apply (rule mListCONS, simp_all)
  apply (erule FL.elims, simp_all)
  apply fast
apply (rule mListNIL, simp_all)
  apply fast
apply (erule FL.elims, simp_all, clarsimp)
apply (rule_tac x=X in exI, safe)
apply (erule FL_SameOH, simp add: sameOH_def) 
apply (simp add: sameOH_def) 
txt {*Case NODE*}
apply (erule mTree.elims, simp_all, clarsimp)
apply (erule_tac x="n" in allE, erule_tac x="X1" in allE, erule_tac x="X" in allE, clarsimp)
apply (rotate_tac -1)
apply (erule_tac x="2 * 2 ^ n + m" in allE, clarsimp)
apply (erule impE)
apply (rotate_tac 8, erule thin_rl,rotate_tac 1, erule thin_rl) apply fast
apply clarsimp
apply (subgoal_tac "Z \<inter> X2 = {}")
  prefer 2 apply (rotate_tac 8, erule thin_rl,rotate_tac 1, erule thin_rl) apply fast 
apply (erule_tac x=n in allE, erule_tac x=X2 in allE, erule_tac x=XX in allE)
apply (rotate_tac -1, erule_tac x=m in allE, clarsimp)
apply (erule impE)
apply (rotate_tac 9, erule thin_rl)
apply (rule, rule mTreeSameOH, assumption) apply (rule SameOHSubset, assumption) apply (subgoal_tac "X2 \<subseteq> Dom ha", fast) apply (rule mTreeDom, assumption)
apply fast
apply clarsimp
apply (erule_tac x="2^n" in allE, erule_tac x="2^n" in allE, erule_tac x="Z" in allE, 
       erule_tac x="Za" in allE, erule_tac x="m" in allE, erule_tac x="XXa" in allE, clarsimp)
apply (erule impE, rule)
apply (rule mListSameOH, assumption) apply (erule SameOHSubset) apply (subgoal_tac "Z \<subseteq> Dom h1", fast)
  apply (erule mListDom) 
apply rule
  apply safe
  apply (subgoal_tac "xa \<notin> XX") prefer 2 apply fast
  apply (subgoal_tac "xa \<notin> X2") prefer 2 apply fast
  apply (subgoal_tac "xa : XX \<union> X2", safe) apply fast apply fast
apply clarsimp
apply (rule_tac x=Zb in exI, safe)
  apply (subgoal_tac "2 ^ n + 2 ^ n = (2::nat) * 2 ^ n", clarsimp) apply arith
apply (rule_tac x=XXb in exI, clarsimp, rule) defer 1
sorry ?? Suc m = m??
apply (simp add: predicates, clarsimp)
apply (simp add: make_IID_Spec_def newframe_env_def evalARGS_def, erule thin_rl) 
apply (erule FL.elims,simp_all, clarsimp)
apply (erule_tac x="Suc m" in allE)
apply (erule impE, rule, erule FL_SameOH, simp add: sameOH_def)
apply clarsimp
apply (simp add: predicates, clarsimp)



lemma flatten1_Aux:
"\<lbrakk>flatten1Spec; make_I_Spec; make_IID_Spec; appendSpec; alloc_Spec; G = flattenContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Flatten1) : 
                   (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Flatten1)) x E' \<longrightarrow>
                                      MS DIAM Flatten1 x E' h hh v
                                        (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p)))) "
apply (simp add:  Meth_Flatten1)
apply (rule vdm_conseq)
apply (rule Call1, simp add: Fun_fFlatten1)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_fzeroFlatten1)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule Call1, simp add: Fun_foneFlatten1)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply clarsimp
txt {*end of simple VCG*}
apply (simp add: flatten1Spec_def newframe_env_def evalARGS_def, clarsimp) 
apply (erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates) apply (simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, safe)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def, clarsimp)
apply (simp add: make_I_Spec_def newframe_env_def evalARGS_def, erule thin_rl) 
apply (simp add: make_IID_Spec_def newframe_env_def evalARGS_def, erule thin_rl) 
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def, clarsimp)
apply (simp add: appendSpec_def newframe_env_def evalARGS_def)
apply (rotate_tac 2, erule thin_rl) 
txt {*end of extended VCG. Now discharge the 2 side conditions*}
prefer 2
txt {*Case LEAF*}
apply (erule mTree.elims, simp_all, clarsimp)
apply (erule_tac x="Suc m" in allE, clarsimp)
apply (erule impE, rule, assumption)
apply clarsimp
apply (simp add: predicates newObj_def, clarsimp)
apply (erule FL.elims,simp_all, clarsimp)
apply (erule_tac x=n in allE)
apply (erule impE, rule, erule FL_SameOH, simp add: sameOH_def)
apply clarsimp
apply (case_tac "n=0", clarsimp)
  (*1*)
  apply (rule_tac x="{aa} \<union> {freshloc (Dom h)}" in exI, rule)
  apply (rule mListCONS, simp_all)
  defer 1
  apply (rule mListNIL, simp_all)
  defer 1 defer 1
  apply (rule_tac x=Xa in exI, rule)
  apply (subgoal_tac "freshloc (Dom h) \<notin> Xa")
  apply (erule FL_SameOH) apply( simp add: sameOH_def)
  apply clarsimp
oops
(*third goal is false -- we had an alloc!!!*)





apply (simp add: fill_DI_Spec_def newframe_env_def evalARGS_def predicates, clarsimp)
apply (erule thin_rl)
apply (simp add: make_IID_Spec_def newframe_env_def evalARGS_def predicates newObj_def)
apply (erule thin_rl)
apply (erule_tac x="Suc n" in allE, erule impE)
apply (rule_tac x=X in exI, erule FL_SameOH) apply (simp add: sameOH_def)
apply (clarsimp)
apply (erule FL.elims, simp_all, clarsimp)
apply (rule_tac x="{a} \<union> {aa}" in exI, rule)
apply (rule mListCONS) apply (simp, simp, simp, simp)
apply (rule mListNIL) apply (simp, simp)
apply (rule_tac x=Xa in exI, simp, rule)
apply (erule FL_SameOH, simp add: sameOH_def)
apply (safe)
apply (simp add: sameOH_def)
txt {*Case NODE*}
apply (erule mTree.elims, simp_all, clarsimp)
  txt{*apply spec to first invocation*}
  apply (erule_tac x=na in allE)
  apply (erule_tac x=X1 in allE)
  apply (erule_tac x=X in allE)
  apply (rotate_tac -1)
  apply (erule_tac x="n" in allE, clarsimp)
  apply(erule impE, fast, safe)
  txt{* prove that second tree did not get destroyed during first invocation*}
  apply (subgoal_tac "(na, a2, X2, h1) \<in> mTree")
    prefer 2 
    apply (rule mTreeSameOH, assumption) apply (erule SameOHSubset) apply (subgoal_tac "X2 \<subseteq> Dom ha", fast) apply (erule mTreeDom)
  txt{*apply spec to second invocation*}
  apply (erule_tac x=na in allE)
  apply (erule_tac x=X2 in allE)
  apply (erule_tac x=XX in allE)
  apply (erule_tac x="n - 2 * 2 ^ na" in allE, clarsimp)
  apply (erule impE) apply (rule, fast) apply arith
  txt{* prove that the result list from the first invocation did not get destroyed during second invocation*}
  apply clarsimp
  apply (subgoal_tac "(2 ^ na, aa, Z, h1a) \<in> mList")
    prefer 2 
    apply (rule mListSameOH, assumption) apply (erule SameOHSubset) apply (subgoal_tac "Z \<subseteq> Dom h1", fast) apply (erule mListDom)
  txt{*now unfold and apply spec of append*}
  apply (simp add: appendSpec_def evalARGS_def) apply (rotate_tac 6, erule thin_rl)
  apply (erule_tac x="2 ^ na" in allE, erule_tac x="2 ^ na" in allE, erule_tac x=Z in allE,erule_tac x=Za in allE)
  apply (erule_tac x="n - 3 * 2 ^ na" in allE, erule_tac x="XXa" in allE)
  apply (erule impE)  apply (rule, assumption) apply (rule, assumption)  apply (rule, assumption) apply (rule, fast) apply (rule, fast) apply (rule, fast)
  apply simp
defer 1
  apply clarsimp
  apply (rule_tac x=Zb in exI)
  apply (subgoal_tac "(2::nat) ^ na + 2 ^ na = 2 * 2 ^ na", simp) 
  apply (rule_tac x=XXb in exI, simp)
  apply rule defer 1
  apply rule 
  apply (erule SubsetTransitive)
  apply (erule SubsetTransitive, simp)
  apply rule
  apply (erule SubsetTransitive) defer 1
  apply (rule SameOHTransitive, assumption)
  apply (rule SameOHTransitive, assumption)
  apply (rule SameOHTransitive, assumption)
  apply (rule SameOHTriv)
  apply simp apply fast
  apply fast
  apply (erule SameOHImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
apply (rule Sa
  apply (rule, rule, assumption) 
apply (rule, fast)
apply (rule, fast)
apply (rule, fast)
    apply (subgoal_tac "Z \<subseteq> Dom h1", fast) apply (erule mListDom)
  apply clarsimp
  apply (rule_tac x= Zb in exI)
  apply rule
  apply (subgoal_tac "(2::nat) ^ n + (2::nat) ^ n = (2::nat) * (2::nat) ^ n", simp) apply arith
  apply rule
  apply (subgoal_tac "Dom ha \<subseteq> Dom h1a \<inter> Dom h1", fast)
    apply (subgoal_tac "Dom ha \<subseteq> Dom h1")
    apply (subgoal_tac "Dom h1 \<subseteq> Dom h1a", fast)
    apply (erule SameImpliesDomsubset)
    apply (erule SameImpliesDomsubset)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTriv)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
done
Proof of AppendAux)



(*
lemma ExecAppend0:
"\<lbrakk>Ups1 = 0; evalARGS E args =[RVal (Ref ll1), RVal (Ref ll2)];
       (Ups1,ll1,X1,h): mList; (Ups2,ll2,X2,h): mList;
       (n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL; X1 \<inter> X2 = {}; X1 \<inter> X = {}; X \<inter> X2 = {};
        E \<turnstile> h,DIAM\<bullet>Append(args) \<Down> hh,v,p\<rbrakk>
       \<Longrightarrow> (\<exists> a Z XX. v = RVal (Ref a) \<and> (Ups1+Ups2,a,Z,hh):mList \<and> 
                                       (Suc n, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, XX, hh) : FL \<and> XX \<inter> Z = {} \<and> Z \<subseteq> X1 \<union> X2 \<union> X \<and> XX \<subseteq> X \<union> X1 \<and> 
                                                sameOH ((Dom h)-X1) h hh \<and> Dom hh = Dom h)"
apply (simp add: sem_def, clarsimp)
apply (erule mList.elims, simp_all, clarsimp)
apply (elim eval_cases, safe)
apply (simp add: Meth_Append newframe_env_def)
apply (elim eval_cases, safe)
apply (simp add: Fun_fAppend)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
(- fzero -)
apply (simp add: Fun_fzeroAppend)
apply (elim eval_cases, safe)
apply (simp add: Meth_Free newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (rule_tac x=X2 in exI, clarsimp)
apply (rule, erule mListSameOH)
  apply (simp add: sameOH_def)
apply (rule_tac x="X \<union> {ll1}" in exI, rule)
  apply (rule FL_SUC, simp_all)
  apply (erule FL_SameOH, simp add: sameOH_def)
  apply (rule, fast)
  apply (simp add: sameOH_def)
done

lemma ExecAppend1:
"\<lbrakk>Ups1 = 1; evalARGS E args =[RVal (Ref ll1), RVal (Ref ll2)];
       (Ups1,ll1,X1,h): mList; (Ups2,ll2,X2,h): mList;
       (n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL; X1 \<inter> X2 = {}; X1 \<inter> X = {}; X \<inter> X2 = {};
        E \<turnstile> h,DIAM\<bullet>Append(args) \<Down> hh,v,p\<rbrakk>
       \<Longrightarrow> (\<exists> a Z XX. v = RVal (Ref a) \<and> (Ups1+Ups2,a,Z,hh):mList \<and> 
                                       (Suc n, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, XX, hh) : FL \<and> XX \<inter> Z = {} \<and> Z \<subseteq> X1 \<union> X2 \<union> X \<and> XX \<subseteq> X \<union> X1 \<and> 
                                                sameOH ((Dom h)-X1) h hh \<and> Dom hh = Dom h)"
apply (simp add: sem_def, clarsimp)
apply (erule mList.elims, simp_all, clarsimp)
apply (rotate_tac 2)
apply (erule mList.elims, simp_all, clarsimp)
apply (elim eval_cases, safe)
apply (simp add: Meth_Append newframe_env_def)
apply (elim eval_cases, safe)
apply (simp add: Fun_fAppend)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
(- fone -)
apply (simp add: Fun_foneAppend)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
apply (simp add: Meth_Append newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (simp add: Fun_fAppend)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
(- fzero -)
apply (simp add: Fun_fzeroAppend)
apply (elim eval_cases, safe)
apply (simp add: Meth_Free newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def, auto)
apply (simp add: Meth_Fill_DIID newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
apply (rule_tac x="X2 \<union> {aa}" in exI, clarify, rule)
apply (rule mListCONS, simp_all)
apply (erule mListSameOH, simp add: sameOH_def)
apply (rule_tac x="X \<union> {a}" in exI, rule)
  apply (rule FL_SUC, simp_all)
  apply (erule FL_SameOH, simp add: sameOH_def)
  apply (rule, fast)
  apply (rule, fast)
  apply (simp add: sameOH_def)
done
*)



lemma ExecFlatten0:
"\<lbrakk>Ups = 0; evalARGS E args = [RVal (Ref ll)]; (Ups,ll,Y,h): mTree;
  (Suc n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL; X \<inter> Y = {};
        E \<turnstile> h,DIAM\<bullet>Flatten(args) \<Down> hh,v,p\<rbrakk>
 \<Longrightarrow> (\<exists> a Z XX. v = RVal (Ref a) \<and> (2 ^ Ups,a,Z,hh):mList \<and> 
                                 (n, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, XX, hh) : FL \<and> XX \<inter> Z = {} \<and> XX \<subseteq> X \<and> 
                                 sameOH ((Dom h)- (Y \<union> X)) h hh \<and> Dom hh = Dom h)"
apply (simp add: sem_def, clarsimp)
apply (erule mTree.elims, simp_all, clarsimp)
apply (erule FL.elims, simp_all, clarsimp)
apply (elim eval_cases, safe)
apply (simp add: Meth_Flatten newframe_env_def)
apply (elim eval_cases, safe)
apply (simp add: Fun_fFlatten)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
apply (simp add: Fun_fzeroFlatten)
apply (elim eval_cases, safe)
apply (simp add: Meth_Fill_DI newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def, auto)
apply (simp add: Meth_Make_IID newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
apply (simp add: Meth_Alloc newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
apply (simp add: Meth_Fill_DIID newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def, auto)
apply (simp add: Fun_AllocQ)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
apply (rule_tac x="{ll} \<union> {ab}" in exI, safe)
apply (rule mListCONS, simp_all)
apply (rule mListNIL, simp_all)
apply (rule_tac x="X" in exI, safe)
apply (erule FL_SameOH, simp add: sameOH_def)
apply (simp add: sameOH_def)
done

lemma ExecFlatten1:
"\<lbrakk>Ups = 1; evalARGS E args = [RVal (Ref ll)]; (Ups,ll,Y,h): mTree;
  (Suc n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL; X \<inter> Y = {};
        E \<turnstile> h,DIAM\<bullet>Flatten(args) \<Down> hh,v,p\<rbrakk>
 \<Longrightarrow> (\<exists> a Z XX. v = RVal (Ref a) \<and> (2 ^ Ups,a,Z,hh):mList \<and> 
                                 (n, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, XX, hh) : FL \<and> XX \<inter> Z = {} \<and> XX \<subseteq> X \<and> 
                                 sameOH ((Dom h)- (Y \<union> X)) h hh \<and> Dom hh = Dom h)"
apply (simp add: sem_def, clarsimp)
apply (erule mTree.elims, simp_all, clarsimp)
apply (erule mTree.elims, simp_all, clarsimp)
apply (erule mTree.elims, simp_all, clarsimp)
apply (erule FL.elims, simp_all, clarsimp)
apply (elim eval_cases, safe)
apply (simp add: Meth_Flatten newframe_env_def)
apply (elim eval_cases, safe)
apply (simp add: Fun_fFlatten)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
apply (simp add: Fun_foneFlatten)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def newframe_env_def evalARGS_def, auto)
  apply (simp add: Meth_Flatten newframe_env_def evalARGS_def)
  apply (elim eval_cases, safe)
apply (subgoal_tac "\<lparr>ienv = emptyi,
             renv = emptyr
               (self := Nullref)\<rparr>\<lfloor>t_:=Ref a\<rfloor> \<turnstile> h , LET v4_ =t_\<bullet>DOLLAR; b_ =Primop (\<lambda>z y. if z = 0 then 1 else 0) v4_ v4_
                                                   IN IF b_ THEN CALL fzeroFlatten ELSE CALL foneFlatten END \<Down>na (h1b , RVal rb , pb)")
  prefer 2 apply (simp add: Fun_fFlatten)
  apply (rotate_tac -3, erule thin_rl)
  apply (elim eval_cases, safe)
  apply (simp_all add: emptyi_def emptyr_def)
  (*unfoild both fzeroFlattens*)
  apply safe
  apply (simp add: Fun_fzeroFlatten)
  apply (elim eval_cases, safe)
  apply (simp add: Meth_Fill_DI newframe_env_def evalARGS_def)
  apply (elim eval_cases, safe)
  apply (simp_all add: emptyi_def emptyr_def, auto)
  apply (simp add: Meth_Make_IID newframe_env_def evalARGS_def)
  apply (elim eval_cases, safe)
  apply (simp_all add: emptyi_def emptyr_def)
  apply (simp add: Meth_Alloc newframe_env_def evalARGS_def)
  apply (elim eval_cases, safe)
  apply (simp_all add: emptyi_def emptyr_def)
  apply (simp add: Fun_AllocQ)
  apply (elim eval_cases, safe)
  apply (simp_all add: emptyi_def emptyr_def)
  apply (simp add: Meth_Fill_DIID newframe_env_def evalARGS_def)
  apply (elim eval_cases, safe)
  apply (simp_all add: emptyi_def emptyr_def, auto)
(* Now unfold the second flatten*)
  apply (simp add: Fun_fFlatten)
  apply (elim eval_cases, safe)
  apply (simp_all add: emptyi_def emptyr_def)
  (*unfoild both fzeroFlattens*)
  apply safe
  apply (simp add: Fun_fzeroFlatten)
  apply (elim eval_cases, safe)
  apply (simp add: Meth_Fill_DI newframe_env_def evalARGS_def)
  apply (elim eval_cases, safe)
  apply (simp_all add: emptyi_def emptyr_def, auto)
  apply (simp add: Meth_Make_IID newframe_env_def evalARGS_def)
  apply (elim eval_cases, safe)
  apply (simp_all add: emptyi_def emptyr_def)
  apply (simp add: Meth_Alloc newframe_env_def evalARGS_def)
  apply (elim eval_cases, safe)
  apply (simp_all add: emptyi_def emptyr_def)
(*here a newObj is needed - hence the freelist did not provode sufficiently many dianmods!!!*)
  apply (simp add: newObj_def emptyi_def emptyr_def)
  apply (simp add: Meth_Fill_DIID newframe_env_def evalARGS_def)
  apply (elim eval_cases, safe)
  apply (simp_all add: emptyi_def emptyr_def, auto)
  apply (simp add: Meth_Append newframe_env_def evalARGS_def)
  apply (elim eval_cases, safe)
apply (simp add: Fun_fAppend)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
(* fzero*)
apply (simp add: Fun_fzeroAppend)
apply (elim eval_cases, safe)
apply (simp add: Meth_Free newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def, auto)
apply (subgoal_tac "aa \<noteq>  freshloc (Dom h)", clarsimp)
  apply (subgoal_tac "aa : Dom h", safe, simp)
  apply (erule Lookup_DOM)
apply (subgoal_tac "a \<noteq>  freshloc (Dom h)", clarsimp)
  prefer 2 apply (subgoal_tac "a : Dom h", safe, simp)
           apply (erule Lookup_DOM)
apply (simp add: Fun_foneAppend)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
apply (simp add: Meth_Append newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (simp add: Fun_fAppend)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
(* fzero*)
apply (simp add: Fun_fzeroAppend)
apply (elim eval_cases, safe)
apply (simp add: Meth_Free newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def, auto)
apply (simp add: Meth_Fill_DIID newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (subgoal_tac "aa \<noteq>  freshloc (Dom h)", clarsimp)
  prefer 2 apply (subgoal_tac "aa : Dom h", safe, simp)
           apply (erule Lookup_DOM)
defer 1
apply (subgoal_tac "a \<noteq>  freshloc (Dom h)", clarsimp)
      apply (subgoal_tac "a : Dom h", safe, simp)
      apply (erule Lookup_DOM)

  apply (simp add: Fun_AllocQ)
  apply (elim eval_cases, safe)
  apply (simp_all add: emptyi_def emptyr_def)
  apply (simp add: Meth_Fill_DIID newframe_env_def evalARGS_def)
  apply (elim eval_cases, safe)
  apply (simp_all add: emptyi_def emptyr_def, auto)
apply (simp add: Meth_Append newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (simp add: Fun_fAppend)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def)
???
done(* fzero*)
apply (simp add: Fun_fzeroAppend)
apply (elim eval_cases, safe)
apply (simp add: Meth_Free newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (simp_all add: emptyi_def emptyr_def, auto)
apply (simp add: Meth_Fill_DIID newframe_env_def evalARGS_def)
apply (elim eval_cases, safe)
apply (subgoal_tac "aa \<noteq>  freshloc (Dom h)", clarsimp)
  prefer 2 apply (subgoal_tac "aa : Dom h", safe, simp)
           apply (erule Lookup_DOM)
apply (simp_all add: emptyi_def emptyr_def)
apply (simp_all add: emptyi_def emptyr_def)
(* fzero*)
apply (simp add: Fun_fzeroAppend)
apply (elim eval_cases, safe)
apply (rule_tac x="X2 \<union> {aa}" in exI, clarify, rule)
apply (rule mListCONS, simp_all)
apply (erule mListSameOH, simp add: sameOH_def)
apply (rule_tac x="X \<union> {a}" in exI, rule)
  apply (rule FL_SUC, simp_all)
  apply (erule FL_SameOH, simp add: sameOH_def)
  apply (rule, fast)
  apply (rule, fast)
  apply (simp add: sameOH_def)
  apply (simp_all add: emptyi_def emptyr_def, auto)

apply (simp_all add: emptyi_def emptyr_def)
apply (rule_tac x="{ll} \<union> {ab}" in exI, safe)
apply (rule mListCONS, simp_all)
apply (rule mListNIL, simp_all)
apply (rule_tac x="X" in exI, safe)
apply (erule FL_SameOH, simp add: sameOH_def)
apply (simp add: sameOH_def)
done

lemma Append_Aux:
"\<lbrakk>appendSpec; free_Spec; fill_DIID_Spec; alloc_Spec; G = flattenContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Append) : 
                    (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Append)) x E' \<longrightarrow>
                                       MS DIAM Append x E' h hh v
                                          (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (simp add: Meth_Append)
apply (rule vdm_conseq)
apply (rule Call1, simp add: Fun_fAppend, safe)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_fzeroAppend)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_foneAppend)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
defer 1
txt {*end of simple VCG*}
apply (simp add: IMPLIES_def appendSpec_def newframe_env_def evalARGS_def, clarsimp) apply(erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims, simp add: predicates) apply clarsimp
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def) apply (clarsimp)
txt {* end of extended vcg, now discharge the 2 side conditions*}
prefer 2
txt {*Case NIL*}
apply (erule mList.elims, simp_all, clarsimp)
apply (simp only: free_Spec_def evalARGS_def predicates, clarsimp, erule thin_rl)
apply (rule_tac x=X2 in exI)
apply (rule, rule mListSameOH, assumption, simp add: sameOH_def)
apply (rule_tac x="X \<union> {a}" in exI, rule)
apply (rule FL_SUC, simp_all)
apply (erule FL_SameOH, simp add: sameOH_def)
apply (rule, fast)
apply (simp add: sameOH_def)
txt {*Case CONS*}
apply (erule mList.elims, simp_all, clarsimp)
apply (erule_tac x=na in allE, erule_tac x=Ups2 in allE, 
       erule_tac x=Xa in allE, erule_tac x=X2 in allE,
       erule_tac x="n" in allE, erule_tac x="X" in allE, clarsimp)
apply (simp only: fill_DIID_Spec_def evalARGS_def predicates, clarsimp)
apply (rotate_tac 1, erule thin_rl)
apply (subgoal_tac "a \<notin> Z")
  apply(rule_tac x="Z \<union> {a}" in exI)
  apply (rule, rule mListCONS, simp_all) 
    apply (rule Lookup_SameOH, assumption, assumption)
    apply (subgoal_tac "a : Dom ha", fast) apply (erule Lookup_DOM)
  apply (erule mListSameOH, simp add: sameOH_def)
  apply (rule_tac x=XX in exI, simp, rule)
  apply (rule FL_SameOH, assumption) 
  apply (simp add: same_def)
  apply (erule SameOHSubset)
  apply (subgoal_tac "XX \<subseteq> Dom h1", fast) apply (erule FL_Dom)
  apply (rule, fast)
  apply (rule, fast)
  apply (rule, fast)
  apply (simp add: same_def)
  apply (rule SameOHTransitive)
  apply (erule SameOHSubset)
  apply fast
  apply assumption
  apply fast
apply fast
done

lemma flatten_Aux:
"\<lbrakk>flattenSpec; fill_DI_Spec; make_IID_Spec; appendSpec; alloc_Spec; G = flattenContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Flatten) : 
                   (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Flatten)) x E' \<longrightarrow>
                                      MS DIAM Flatten x E' h hh v
                                        (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p)))) "
apply (simp add:  Meth_Flatten)
apply (rule vdm_conseq)
apply (rule Call1, simp add: Fun_fFlatten)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_fzeroFlatten)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule Call1, simp add: Fun_foneFlatten)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply clarsimp
txt {*end of simple VCG*}
apply (simp add: flattenSpec_def newframe_env_def evalARGS_def, clarsimp) 
apply (erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates) apply (simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, safe)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def, clarsimp)
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def, clarsimp)
txt {*end of extended VCG. Now discharge the 2 side conditions*}
prefer 2
txt {*Case LEAF*}
apply (erule mTree.elims, simp_all, clarsimp)
apply (simp add: fill_DI_Spec_def newframe_env_def evalARGS_def predicates, clarsimp)
apply (erule thin_rl)
apply (simp add: make_IID_Spec_def newframe_env_def evalARGS_def predicates newObj_def)
apply (erule thin_rl)
apply (erule_tac x="Suc n" in allE, erule impE)
apply (rule_tac x=X in exI, erule FL_SameOH) apply (simp add: sameOH_def)
apply (clarsimp)
apply (erule FL.elims, simp_all, clarsimp)
apply (rule_tac x="{a} \<union> {aa}" in exI, rule)
apply (rule mListCONS) apply (simp, simp, simp, simp)
apply (rule mListNIL) apply (simp, simp)
apply (rule_tac x=Xa in exI, simp, rule)
apply (erule FL_SameOH, simp add: sameOH_def)
apply (safe)
apply (simp add: sameOH_def)
txt {*Case NODE*}
apply (erule mTree.elims, simp_all, clarsimp)
  txt{*apply spec to first invocation*}
  apply (erule_tac x=na in allE)
  apply (erule_tac x=X1 in allE)
  apply (erule_tac x=X in allE)
  apply (rotate_tac -1)
  apply (erule_tac x="n" in allE, clarsimp)
  apply(erule impE, fast, safe)
  txt{* prove that second tree did not get destroyed during first invocation*}
  apply (subgoal_tac "(na, a2, X2, h1) \<in> mTree")
    prefer 2 
    apply (rule mTreeSameOH, assumption) apply (erule SameOHSubset) apply (subgoal_tac "X2 \<subseteq> Dom ha", fast) apply (erule mTreeDom)
  txt{*apply spec to second invocation*}
  apply (erule_tac x=na in allE)
  apply (erule_tac x=X2 in allE)
  apply (erule_tac x=XX in allE)
  apply (erule_tac x="n - 2 * 2 ^ na" in allE, clarsimp)
  apply (erule impE) apply (rule, fast) apply arith
  txt{* prove that the result list from the first invocation did not get destroyed during second invocation*}
  apply clarsimp
  apply (subgoal_tac "(2 ^ na, aa, Z, h1a) \<in> mList")
    prefer 2 
    apply (rule mListSameOH, assumption) apply (erule SameOHSubset) apply (subgoal_tac "Z \<subseteq> Dom h1", fast) apply (erule mListDom)
  txt{*now unfold and apply spec of append*}
  apply (simp add: appendSpec_def evalARGS_def) apply (rotate_tac 6, erule thin_rl)
  apply (erule_tac x="2 ^ na" in allE, erule_tac x="2 ^ na" in allE, erule_tac x=Z in allE,erule_tac x=Za in allE)
  apply (erule_tac x="n - 3 * 2 ^ na" in allE, erule_tac x="XXa" in allE)
  apply (erule impE)  apply (rule, assumption) apply (rule, assumption)  apply (rule, assumption) apply (rule, fast) apply (rule, fast) apply (rule, fast)
  apply simp
defer 1
  apply clarsimp
  apply (rule_tac x=Zb in exI)
  apply (subgoal_tac "(2::nat) ^ na + 2 ^ na = 2 * 2 ^ na", simp) 
  apply (rule_tac x=XXb in exI, simp)
  apply rule defer 1
  apply rule 
  apply (erule SubsetTransitive)
  apply (erule SubsetTransitive, simp)
  apply rule
  apply (erule SubsetTransitive) defer 1
  apply (rule SameOHTransitive, assumption)
  apply (rule SameOHTransitive, assumption)
  apply (rule SameOHTransitive, assumption)
  apply (rule SameOHTriv)
  apply simp apply fast
  apply fast
  apply (erule SameOHImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
apply (rule Sa
  apply (rule, rule, assumption) 
apply (rule, fast)
apply (rule, fast)
apply (rule, fast)
    apply (subgoal_tac "Z \<subseteq> Dom h1", fast) apply (erule mListDom)
  apply clarsimp
  apply (rule_tac x= Zb in exI)
  apply rule
  apply (subgoal_tac "(2::nat) ^ n + (2::nat) ^ n = (2::nat) * (2::nat) ^ n", simp) apply arith
  apply rule
  apply (subgoal_tac "Dom ha \<subseteq> Dom h1a \<inter> Dom h1", fast)
    apply (subgoal_tac "Dom ha \<subseteq> Dom h1")
    apply (subgoal_tac "Dom h1 \<subseteq> Dom h1a", fast)
    apply (erule SameImpliesDomsubset)
    apply (erule SameImpliesDomsubset)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTriv)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
done

text {*Now, the proof that \verb|flattenContext| is good follows from
       the auxiliary lemmas for all entries.*}
lemma flattenContext_good: 
"\<lbrakk>appendSpec; flattenSpec; fill_DI_Spec; make_I_Spec; fill_DIID_Spec; make_IID_Spec\<rbrakk>
 \<Longrightarrow> goodContext flattenContext"
apply (simp add: goodContext_def flattenContext_def) apply safe
(* Fill_DI*)
apply (erule Fill_DI_Aux)
(* Fill_DIID*)c
apply (erule Fill_DIID_Aux)
(* Make_I*)
apply (erule Make_I_Aux, assumption, simp add: flattenContext_def)
(* Make_IID*)
apply (erule Make_IID_Aux, assumption, simp add: flattenContext_def)
apply (erule Make_IID_Aux, assumption, simp add: flattenContext_def)
(*Append*)
apply (erule Append_Aux, assumption, assumption, simp add: flattenContext_def)
apply (erule Append_Aux, assumption, assumption, simp add: flattenContext_def)
(* Flatten *)
apply (erule flatten_Aux, assumption, assumption, assumption, simp add: flattenContext_def)
apply (erule flatten_Aux, assumption, assumption, assumption, simp add: flattenContext_def)
done

text {*Finally, we prove that an invocation of \verb|flatten| satisifies the
       specification -- notice that the specification is fulfilled for ANY variable \verb|a|.*}
theorem
"\<lbrakk>appendSpec; flattenSpec; fill_DI_Spec; make_I_Spec; fill_DIID_Spec; make_IID_Spec\<rbrakk>
 \<Longrightarrow> \<rhd> DIAM\<bullet>Flatten([a]): MS DIAM Flatten [a]"
apply (rule GC)
apply (rule flattenContext_good)
apply (simp_all, simp_all add: InvContext_def flattenContext_def, auto)
done

text{*In particular an invocation with an integer parameter (ill-typed!) does satisfy
      the specification \verb|MS DIAM Flatten|:*}
lemma
"\<lbrakk>appendSpec; flattenSpec; fill_DI_Spec; make_I_Spec; fill_DIID_Spec; make_IID_Spec\<rbrakk>
 \<Longrightarrow> \<rhd> DIAM\<bullet>Flatten([INarg a]): MS DIAM Flatten [INarg a]"
apply (rule GC)
apply (rule flattenContext_good)
apply (simp_all, simp_all add: InvContext_def flattenContext_def, auto)
done 

text {*However, the specification for integer parameters is trivial:*}
lemma 
"\<lbrakk>flattenSpec\<rbrakk> \<Longrightarrow> MS DIAM Flatten [INarg a] = (\<lambda> E h hh v p . True)"
by (simp add: flattenSpec_def evalARGS_def)

text{*and so is a specification for a list of variables which is longer than one:*}
lemma "flattenSpec \<Longrightarrow> MS DIAM Flatten [RNarg a, RNarg b] = (\<lambda> E h hh v p . True)"
by (simp add: flattenSpec_def evalARGS_def)
(*<*)
end
(*>*)
