(*<*)
theory Flatten3 = mTreeList:
(*>*)

subsection{*Append and flatten*}
text {* Stffens analysis with Nil@d???*}
text {* Camelot code:
\begin{verbatim}
  type itree = Leaf of int | Node of itree * itree
  type ilist = Nil | Cons of int * ilist

  let append l1 l2 = match l1 with Nil@d => l2
                                 | Cons(h,t)@d => Cons(h,append t l2)@d

  let flatten t = match t with Leaf(i)@d => Cons(i,Nil@d)
                             | Node(l,r)@d => append (flatten l) (flatten r)
Analysis:
append: <0>, ilist[Nil(<0>)|Cons(int,#,<0>)] \<rightarrow> ilist[Nil(<0>)|Cons(int,#,<0>)] \<rightarrow> ilist[Nil(<0>)|Cons(int,#,<0>)], <1>
flatten: <1>, itree[Leaf(int,<0>)|Node(#,#,<0>)] \<rightarrow> ilist[Nil(<0>)|Cons(int,#,<0>)], <0>
\end{verbatim}
Grail code:
\begin{verbatim}
   method public static TreeList$dia_0 flatten (TreeList$dia_0 t) =
   let fun f:flatten(TreeList$dia_0 t) =
         let val v4 = getfield t <int TreeList$dia_0.$>
         in if v4 = 0 then f:0(t) else f:1(t)
         end

       fun f:1(TreeList$dia_0 t) =
         let val v3 = getfield t <TreeList$dia_0 TreeList$dia_0.f1>
             val v2 = getfield t <TreeList$dia_0 TreeList$dia_0.f2>
             val v1 = invokestatic <TreeList$dia_0 TreeList.flatten (TreeList$dia_0)> (v3)
             val t = invokestatic <TreeList$dia_0 TreeList.flatten (TreeList$dia_0)> (v2)
         in invokestatic <TreeList$dia_0 TreeList.append (TreeList$dia_0, TreeList$dia_0)> (v1, t)
         end

       fun f:0(TreeList$dia_0 t) =
         let val v4 = getfield t <int TreeList$dia_0.f0>
             val v1 = t
             val t = invokestatic <TreeList$dia_0 TreeList$dia_0.fill (TreeList$dia_0, int)> (v1, 2)
         in invokestatic <TreeList$dia_0 TreeList$dia_0.make (int, int, TreeList$dia_0)> (3, v4, t)
         end
   in f:flatten(t)
   end

   method public static TreeList$dia_0 append (TreeList$dia_0 l1, TreeList$dia_0 l2) =
   let fun f:append(TreeList$dia_0 l1, TreeList$dia_0 l2) =
         let val v4 = getfield l1 <int TreeList$dia_0.$>
         in if v4 = 2
            then f:0(l1, l2)
            else f:1(l1, l2)
         end

       fun f:1(TreeList$dia_0 l1, TreeList$dia_0 l2) =
         let val v4 = getfield l1 <int TreeList$dia_0.f0>
             val v3 = getfield l1 <TreeList$dia_0 TreeList$dia_0.f1>
             val v2 = l1
             val l1 = invokestatic <TreeList$dia_0 TreeList.append (TreeList$dia_0, TreeList$dia_0)> (v3, l2)
         in invokestatic <TreeList$dia_0 TreeList$dia_0.fill (TreeList$dia_0, int, int, TreeList$dia_0)> (v2, 3, v4, l1)
         end

       fun f:0(TreeList$dia_0 l1, TreeList$dia_0 l2) = l2
   in f:append(l1, l2)
   end
\end{verbatim}

*}

syntax b_  :: iname
       t_   :: rname
       v1_  :: rname 
       v2_  :: rname 
       v3_  :: rname
       v4_  :: iname
 
       l1_  :: rname 
       l2_  :: rname 

       fFlatten :: funame
       fzeroFlatten :: funame
       foneFlatten  :: funame
       Flatten :: mname

       fAppend :: funame
       fzeroAppend :: funame
       foneAppend  :: funame
       Append :: mname


translations
 "b_" == "(In ''b'') "
 "t_" == "(RN ''t'') "
 "v1_" == "(RN ''v1'') "
 "v2_" == "(RN ''v2'') "
 "v3_" == "(RN ''v3'') "
 "v4_" == "(In ''v4'') "
 "l1_" == "(RN ''l1'') "
 "l2_" == "(RN ''l2'') "
 "fFlatten" == "(FN ''fFlatten'') "
 "fzeroFlatten" == "(FN ''f_zeroFlatten'')"
 "foneFlatten" == "(FN ''f_oneFlatten'')"
 "Flatten" == "(MN ''Flatten'')"
 "fAppend" == "(FN ''fAppend'') "
 "fzeroAppend" == "(FN ''f_zeroAppend'')"
 "foneAppend" == "(FN ''f_oneAppend'')"
 "Append" == "(MN ''Append'')"

axioms Meth_Flatten: 
"methtable DIAM Flatten = ([RNpar t_], CALL fFlatten)"
lemma "methtable DIAM Flatten = ([RNpar t_], CALL fFlatten)" by (simp add: Meth_Flatten)

axioms Fun_fFlatten:
"funtable fFlatten = LET v4_ = GetFi t_ DOLLAR;
                          b_ = Primop (\<lambda> z y. if z = 0 then 1 else 0) v4_ v4_
                     IN IF b_ THEN CALL fzeroFlatten ELSE CALL foneFlatten END"
lemma "funtable fFlatten = LET v4_ = GetFi t_ DOLLAR;
                          b_ = Primop (\<lambda> z y. if z = 0 then 1 else 0) v4_ v4_
                     IN IF b_ THEN CALL fzeroFlatten ELSE CALL foneFlatten END" by (simp add: Fun_fFlatten)
axioms Fun_fzeroFlatten:
"funtable fzeroFlatten = LET v4_ = GetFi t_ F0;
                          rf v1_ = RVar t_;
                          rf t_ = DIAM\<bullet>Fill_DI ([RNarg v1_, VALarg (IVal 2)])
                         IN DIAM\<bullet>Make_IID ([VALarg (IVal 3), INarg v4_, RNarg t_])
                         END"
lemma "funtable fzeroFlatten = LET v4_ = GetFi t_ F0;
                          rf v1_ = RVar t_;
                          rf t_ = DIAM\<bullet>Fill_DI ([RNarg v1_, VALarg (IVal 2)])
                         IN DIAM\<bullet>Make_IID ([VALarg (IVal 3), INarg v4_, RNarg t_])
                         END" by (simp add: Fun_fzeroFlatten)
axioms Fun_foneFlatten:
"funtable foneFlatten = LET rf v3_ = GetFr t_ F1;
                            rf v2_ = GetFr t_ F2;
                            rf v1_ = DIAM\<bullet>Flatten ([RNarg v3_]);
                             rf t_ = DIAM\<bullet>Flatten ([RNarg v2_])
                        IN DIAM\<bullet>Append ([RNarg v1_,RNarg t_]) END"
lemma "funtable foneFlatten = LET rf v3_ = GetFr t_ F1;
                            rf v2_ = GetFr t_ F2;
                            rf v1_ = DIAM\<bullet>Flatten ([RNarg v3_]);
                             rf t_ = DIAM\<bullet>Flatten ([RNarg v2_])
                        IN DIAM\<bullet>Append ([RNarg v1_,RNarg t_]) END" by (simp add: Fun_foneFlatten)
axioms Meth_Append: 
"methtable DIAM Append = ([RNpar l1_, RNpar l2_], CALL fAppend)"
lemma "methtable DIAM Append = ([RNpar l1_, RNpar l2_], CALL fAppend)" by (simp add: Meth_Append)
axioms Fun_fAppend:
"funtable fAppend = LET v4_ = GetFi l1_ DOLLAR;
                         b_ = Primop (\<lambda> z y. if z = 2 then 1 else 0) v4_ v4_
                    IN IF b_ THEN CALL fzeroAppend ELSE CALL foneAppend END"
lemma "funtable fAppend = LET v4_ = GetFi l1_ DOLLAR;
                         b_ = Primop (\<lambda> z y. if z = 2 then 1 else 0) v4_ v4_
                    IN IF b_ THEN CALL fzeroAppend ELSE CALL foneAppend END" by (simp add: Fun_fAppend)
axioms Fun_fzeroAppend:
"funtable fzeroAppend = RVar l2_"
lemma "funtable fzeroAppend = RVar l2_" by (simp add: Fun_fzeroAppend)
axioms Fun_foneAppend:
"funtable foneAppend = LET v4_ = GetFi l1_ F0;
                         rf v3_ = GetFr l1_ F1;
                         rf v2_ = RVar l1_;
                         rf l1_ = DIAM\<bullet>Append([RNarg v3_, RNarg l2_])
                       IN DIAM\<bullet>Fill_DIID([RNarg v2_, VALarg (IVal 3), INarg v4_, RNarg l1_]) END"
lemma "funtable foneAppend = LET v4_ = GetFi l1_ F0;
                         rf v3_ = GetFr l1_ F1;
                         rf v2_ = RVar l1_;
                         rf l1_ = DIAM\<bullet>Append([RNarg v3_, RNarg l2_])
                       IN DIAM\<bullet>Fill_DIID([RNarg v2_, VALarg (IVal 3), INarg v4_, RNarg l1_]) END" by (simp add: Fun_foneAppend)

text {*Auxiliary lemmas on fresh locations.*}
lemma freshlocInsert1[simp, rule_format]: 
"\<forall> h . freshloc (Dom h) \<noteq> freshloc (insert (freshloc (Dom h)) (Dom h))"
apply clarsimp
apply (subgoal_tac "freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> insert (freshloc (Dom h)) (Dom h)")
apply (subgoal_tac "freshloc (Dom h) : insert (freshloc (Dom h)) (Dom h)")
prefer 2 apply simp
prefer 2 apply (rule freshloc, fast)
apply auto
done

lemma freshlocInsert2[simp]: 
"fmap_lookup (oheap h(freshloc (Dom h)\<mapsto>\<^sub>fC)(freshloc (insert (freshloc (Dom h)) (Dom h))\<mapsto>\<^sub>fC)) (freshloc (Dom h)) = Some C"
by (simp add: FMAPlookup3)

lemma freshlocInsert3[simp]: 
"freshloc (insert (freshloc (Dom h)) (Dom h)) \<noteq> freshloc (Dom h)"
by (insert freshlocInsert1 [of h], fastsimp)

lemma freshlocInsert4[simp]: 
"freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> Dom h"
apply (subgoal_tac "freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> (insert (freshloc (Dom h)) (Dom h))")
apply (subgoal_tac "Dom h \<subseteq> insert (freshloc (Dom h)) (Dom h)", fast, fast, rule freshloc, fast)
done

lemma freshlocInsert5[simp]:
   "same (Dom h)  h \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM)(freshloc (insert (freshloc (Dom h)) (Dom h))\<mapsto>\<^sub>fDIAM),
                     iheap = (iheap h)
                      (DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := 2, freshloc (insert (freshloc (Dom h)) (Dom h)) := 3),
                       F0 := (iheap h F0)(freshloc (insert (freshloc (Dom h)) (Dom h)) := h<a\<bullet>F0>)),
                     rheap = (rheap h)(F1 := (rheap h F1)(freshloc (insert (freshloc (Dom h)) (Dom h)) := Ref (freshloc (Dom h)))),
                     sheap = sheap h\<rparr>"
by (simp add: same_def sameOH_def FMAPlookup3) 

subsubsection {*Verification of @{text append} and @{text flatten}*}
text {*We first give the specifications of the two methods.*}
constdefs appendSpec::bool
"appendSpec == 
(MS DIAM Append = 
  (\<lambda> args E h hh v p. 
     (\<forall> Ups1 Ups2 ll1 ll2 X1 X2 n X. (evalARGS E args =[RVal (Ref ll1), RVal (Ref ll2)] \<and> 
                                        (Ups1,ll1,X1,h): mList \<and> (Ups2,ll2,X2,h): mList \<and> 
                                        (n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL \<and> X1 \<inter> X2 = {} \<and> X1 \<inter> X = {} \<and> X \<inter> X2 = {}) \<longrightarrow> 
                                     (\<exists> a Z. v = RVal (Ref a) \<and> (Ups1+Ups2,a,Z,hh):mList \<and> 
                                                (n, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, hh) : FL \<and> X \<inter> Z = {} \<and> Z \<subseteq> X1 \<union> X2 \<union> X \<and> 
                                                sameOH ((Dom h)-(X1 \<union> X)) h hh \<and> Dom hh = Dom h))))"
text {*Notice that the freelist in the conclusion uses the same heap region as in  the premise!*}
text {*Should this be (n + 1, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, hh) : FL in the conclusion?*}
consts flattenSpec::bool 


text {*Next, we define a context which associates all method calls to their specifications.
       The first two entries allow to discharge the assumptions in the auxiliary lemmas
       for the \verb|make| methods. Notice that the context has several entries for
       the methods \verb|Make_IID|, \verb|Append| and \verb|Flatten|.*}
constdefs flattenContext:: vdmcontext
"flattenContext \<equiv> {(DIAM\<bullet>Alloc ([]), MS DIAM Alloc []),
                    (DIAM\<bullet>Fill_DI ([RNarg v1_, VALarg (IVal 2)]), MS DIAM Fill_DI [RNarg v1_, VALarg (IVal 2)]),
                    (DIAM\<bullet>Fill_DIID ([RNarg v2_, VALarg (IVal 3), INarg v4_, RNarg l1_]),
                         MS DIAM Fill_DIID [RNarg v2_, VALarg (IVal 3), INarg v4_, RNarg l1_]),
                    (DIAM\<bullet>Make_IID([VALarg (IVal 3), INarg v4_, RNarg t_]), 
                         MS DIAM Make_IID [VALarg (IVal 3), INarg v4_, RNarg t_]),
                    (DIAM\<bullet>Append([RNarg v3_,RNarg l2_]), MS DIAM Append [RNarg v3_,RNarg l2_]),
                    (DIAM\<bullet>Append([RNarg v1_, RNarg t_]), MS DIAM Append [RNarg v1_, RNarg t_]),
                    (DIAM\<bullet>Flatten ([RNarg v3_]), MS DIAM Flatten [RNarg v3_]),  
                    (DIAM\<bullet>Flatten ([RNarg v2_]), MS DIAM Flatten [RNarg v2_])}" 
text {*In this context, the bodies of the ''application methods'' \verb|Append|
       and \verb|Flatten| are now shown to satisfy their respective specifications --
       the usage of the additional context variable \verb|G| is a simple trick to
       allow the application of these lemmas as \verb|erules|.*}

lemma Lookup_SameOH: "\<lbrakk>h@@a = Some C; sameOH X h h1; a : X\<rbrakk> \<Longrightarrow> h1@@a = Some C"
by (simp add: sameOH_def)
lemma Lookup_DOM: "h@@l = Some C \<Longrightarrow> l : Dom h"
by (simp add: fmap_lookup_def fmap_dom_def dom_def)

lemma Append_Aux:
"\<lbrakk>appendSpec; fill_DIID_Spec; alloc_Spec; G = flattenContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Append) : 
                    (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Append)) x E' \<longrightarrow>
                                       MS DIAM Append x E' h hh v
                                          (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (simp add: Meth_Append)
apply (rule vdm_conseq)
apply (rule Call1, simp add: Fun_fAppend, safe)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_fzeroAppend)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_foneAppend)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
defer 1
txt {*end of simple VCG*}
apply (simp add: IMPLIES_def appendSpec_def newframe_env_def evalARGS_def, clarsimp) apply(erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims, simp add: predicates) apply clarsimp
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def) apply (clarsimp)
txt {* end of extended vcg, now discharge the 2 side conditions*}
prefer 2
txt {*Case NIL*}
apply (erule mList.elims, simp_all, clarsimp)
apply (rule_tac x=X2 in exI, simp)
apply (rule, fast)
apply (rule SameOHSubset)
apply (rule SameOHTriv, fast)
txt {*Case CONS*}
apply (erule mList.elims, simp_all, clarsimp)
apply (erule_tac x=na in allE, erule_tac x=Ups2 in allE, 
       erule_tac x=Xa in allE, erule_tac x=X2 in allE,
       erule_tac x="n" in allE, erule_tac x="X" in allE, clarsimp)
apply (simp only: fill_DIID_Spec_def evalARGS_def predicates, clarsimp, erule thin_rl)
apply (subgoal_tac "a \<notin> Z")
  apply(rule_tac x="Z \<union> {a}" in exI)
  apply (rule, rule mListCONS, simp_all) 
    apply (rule Lookup_SameOH, assumption, assumption)
    apply (subgoal_tac "a : Dom ha", fast) apply (erule Lookup_DOM)
  apply (erule mListSameOH, simp add: sameOH_def)
  apply (rule, erule FL_SameOH, simp add: sameOH_def)
  apply (rule, fast)
  apply (subgoal_tac "a \<notin> Dom ha - insert a (Xa \<union> X)")
  apply (simp add: sameOH_def)
  apply fast
apply fast
done

defs flattenSpec_def:
"flattenSpec == 
(MS DIAM Flatten = 
  (\<lambda> args E h hh v p. 
     (\<forall> Ups Y ll X n. (evalARGS E args = [RVal (Ref ll)] \<and> (Ups,ll,Y,h): mTree \<and> 
                       (, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL \<and> X \<inter> Y = {}) \<longrightarrow>
                      (\<exists> a Z XX. v = RVal (Ref a) \<and> (2 ^ Ups,a,Z,hh):mList \<and> 
                                 (n, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, XX, hh) : FL \<and> XX \<inter> Z = {} \<and> XX \<subseteq> X \<and> 
                                 sameOH ((Dom h)- (Y \<union> X)) h hh \<and> Dom hh = Dom h))))"


text {*Verification fails - but Steffen's analysis reported that the whole program is infeasible!*}
lemma flatten_Aux:
"\<lbrakk>flattenSpec; fill_DI_Spec; make_IID_Spec; appendSpec; alloc_Spec; G = flattenContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Flatten) : 
                   (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Flatten)) x E' \<longrightarrow>
                                      MS DIAM Flatten x E' h hh v
                                        (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p)))) "
apply (simp add:  Meth_Flatten)
apply (rule vdm_conseq)
apply (rule Call1, simp add: Fun_fFlatten)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_fzeroFlatten)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule Call1, simp add: Fun_foneFlatten)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply clarsimp
txt {*end of simple VCG*}
apply (simp add: flattenSpec_def newframe_env_def evalARGS_def, clarsimp) 
apply (erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates) apply (simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, safe)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def, clarsimp)
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def, clarsimp)
txt {*end of extended VCG. Now discharge the 2 side conditions*}
prefer 2
txt {*Case LEAF*}
apply (erule mTree.elims, simp_all, clarsimp)
apply (simp add: fill_DI_Spec_def newframe_env_def evalARGS_def predicates, clarsimp)
apply (erule thin_rl)
apply (simp add: make_IID_Spec_def newframe_env_def evalARGS_def predicates newObj_def)
apply (erule thin_rl)
apply (erule_tac x="Suc n" in allE, erule impE)
apply (rule_tac x=X in exI, erule FL_SameOH) apply (simp add: sameOH_def)
apply (clarsimp)
apply (erule FL.elims, simp_all, clarsimp)
apply (rule_tac x="{a} \<union> {aa}" in exI, rule)
apply (rule mListCONS) apply (simp, simp, simp, simp)
apply (rule mListNIL) apply (simp, simp)
apply (rule_tac x=Xa in exI, simp, rule)
apply (erule FL_SameOH, simp add: sameOH_def)
apply (safe)
apply (simp add: sameOH_def)
txt {*Case NODE*}
apply (erule mTree.elims, simp_all, clarsimp)
  txt{*apply spec to first invocation*}
  apply (erule_tac x=na in allE)
  apply (erule_tac x=X1 in allE)
  apply (erule_tac x=X in allE)
  apply (rotate_tac -1)
  apply (erule_tac x="n" in allE, clarsimp)
  apply(erule impE, fast, safe)
  txt{* prove that second tree did not get destroyed during first invocation*}
  apply (subgoal_tac "(na, a2, X2, h1) \<in> mTree")
    prefer 2 
    apply (rule mTreeSameOH, assumption) apply (erule SameOHSubset) apply (subgoal_tac "X2 \<subseteq> Dom ha", fast) apply (erule mTreeDom)
  txt{*apply spec to second invocation*}
  apply (erule_tac x=na in allE)
  apply (erule_tac x=X2 in allE)
  apply (erule_tac x=XX in allE)
  apply (erule_tac x="n - 2 * 2 ^ na" in allE, clarsimp)
  apply (erule impE) apply (rule, fast) apply arith
  txt{* prove that the result list from the first invocation did not get destroyed during second invocation*}
  apply clarsimp
  apply (subgoal_tac "(2 ^ na, aa, Z, h1a) \<in> mList")
    prefer 2 
    apply (rule mListSameOH, assumption) apply (erule SameOHSubset) apply (subgoal_tac "Z \<subseteq> Dom h1", fast) apply (erule mListDom)
  txt{*now unfold and apply spec of append*}
  apply (simp add: appendSpec_def evalARGS_def) apply (rotate_tac 6, erule thin_rl)
  apply (erule_tac x="2 ^ na" in allE, erule_tac x="2 ^ na" in allE, erule_tac x=Z in allE,erule_tac x=Za in allE)
  apply (erule_tac x="n - 3 * 2 ^ na" in allE, erule_tac x="XXa" in allE)
  apply (erule impE)  apply (rule, assumption) apply (rule, assumption)  apply (rule, assumption) apply (rule, fast) apply (rule, fast) apply (rule, fast)
  apply simp
defer 1
  apply clarsimp
  apply (rule_tac x=Zb in exI)
  apply (subgoal_tac "(2::nat) ^ na + 2 ^ na = 2 * 2 ^ na", simp) 
  apply (rule_tac x=XXb in exI, simp)
  apply rule defer 1
  apply rule 
  apply (erule SubsetTransitive)
  apply (erule SubsetTransitive, simp)
  apply rule
  apply (erule SubsetTransitive) defer 1
  apply (rule SameOHTransitive, assumption)
  apply (rule SameOHTransitive, assumption)
  apply (rule SameOHTransitive, assumption)
  apply (rule SameOHTriv)
  apply simp apply fast
  apply fast
  apply (erule SameOHImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
apply (rule Sa
  apply (rule, rule, assumption) 
apply (rule, fast)
apply (rule, fast)
apply (rule, fast)
    apply (subgoal_tac "Z \<subseteq> Dom h1", fast) apply (erule mListDom)
  apply clarsimp
  apply (rule_tac x= Zb in exI)
  apply rule
  apply (subgoal_tac "(2::nat) ^ n + (2::nat) ^ n = (2::nat) * (2::nat) ^ n", simp) apply arith
  apply rule
  apply (subgoal_tac "Dom ha \<subseteq> Dom h1a \<inter> Dom h1", fast)
    apply (subgoal_tac "Dom ha \<subseteq> Dom h1")
    apply (subgoal_tac "Dom h1 \<subseteq> Dom h1a", fast)
    apply (erule SameImpliesDomsubset)
    apply (erule SameImpliesDomsubset)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTriv)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
done

text {*Now, the proof that \verb|flattenContext| is good follows from
       the auxiliary lemmas for all entries.*}
lemma flattenContext_good: 
"\<lbrakk>appendSpec; flattenSpec; fill_DI_Spec; make_I_Spec; fill_DIID_Spec; make_IID_Spec\<rbrakk>
 \<Longrightarrow> goodContext flattenContext"
apply (simp add: goodContext_def flattenContext_def) apply safe
(* Fill_DI*)
apply (erule Fill_DI_Aux)
(* Fill_DIID*)
apply (erule Fill_DIID_Aux)
(* Make_I*)
apply (erule Make_I_Aux, assumption, simp add: flattenContext_def)
(* Make_IID*)
apply (erule Make_IID_Aux, assumption, simp add: flattenContext_def)
apply (erule Make_IID_Aux, assumption, simp add: flattenContext_def)
(*Append*)
apply (erule Append_Aux, assumption, assumption, simp add: flattenContext_def)
apply (erule Append_Aux, assumption, assumption, simp add: flattenContext_def)
(* Flatten *)
apply (erule flatten_Aux, assumption, assumption, assumption, simp add: flattenContext_def)
apply (erule flatten_Aux, assumption, assumption, assumption, simp add: flattenContext_def)
done

text {*Finally, we prove that an invocation of \verb|flatten| satisifies the
       specification -- notice that the specification is fulfilled for ANY variable \verb|a|.*}
theorem
"\<lbrakk>appendSpec; flattenSpec; fill_DI_Spec; make_I_Spec; fill_DIID_Spec; make_IID_Spec\<rbrakk>
 \<Longrightarrow> \<rhd> DIAM\<bullet>Flatten([a]): MS DIAM Flatten [a]"
apply (rule GC)
apply (rule flattenContext_good)
apply (simp_all, simp_all add: InvContext_def flattenContext_def, auto)
done

text{*In particular an invocation with an integer parameter (ill-typed!) does satisfy
      the specification \verb|MS DIAM Flatten|:*}
lemma
"\<lbrakk>appendSpec; flattenSpec; fill_DI_Spec; make_I_Spec; fill_DIID_Spec; make_IID_Spec\<rbrakk>
 \<Longrightarrow> \<rhd> DIAM\<bullet>Flatten([INarg a]): MS DIAM Flatten [INarg a]"
apply (rule GC)
apply (rule flattenContext_good)
apply (simp_all, simp_all add: InvContext_def flattenContext_def, auto)
done 

text {*However, the specification for integer parameters is trivial:*}
lemma 
"\<lbrakk>flattenSpec\<rbrakk> \<Longrightarrow> MS DIAM Flatten [INarg a] = (\<lambda> E h hh v p . True)"
by (simp add: flattenSpec_def evalARGS_def)

text{*and so is a specification for a list of variables which is longer than one:*}
lemma "flattenSpec \<Longrightarrow> MS DIAM Flatten [RNarg a, RNarg b] = (\<lambda> E h hh v p . True)"
by (simp add: flattenSpec_def evalARGS_def)
(*<*)
end
(*>*)
