(*<*)
theory Flatten2 = mTreeList:
(*>*)

subsection{*Append and flatten*}

text {* Camelot code:
\begin{verbatim}
  type itree = Leaf of int | Node of itree * itree
  type ilist = Nil | Cons of int * ilist

  let append l1 l2 = match l1 with Nil => l2
                                 | Cons(h,t) => Cons(h,append t l2)

  let flatten t = match t with Leaf(i) => Cons(i,Nil)
                             | Node(l,r) => append (flatten l) (flatten r)
\end{verbatim}
Grail code:
\begin{verbatim}
  method public static TreeList$dia_0 flatten (TreeList$dia_0 t) =
   let fun f:flatten(TreeList$dia_0 t) =
         let val v4 = getfield t <int TreeList$dia_0.$>
         in if v4 = 0
            then f:0(t)
            else f:1(t)
         end

       fun f:1(TreeList$dia_0 t) =
         let val v3 = getfield t <TreeList$dia_0 TreeList$dia_0.f1>
             val v2 = getfield t <TreeList$dia_0 TreeList$dia_0.f2>
             val v1 = invokestatic <TreeList$dia_0 TreeList.flatten (TreeList$dia_0)> (v3)
             val t = invokestatic <TreeList$dia_0 TreeList.flatten (TreeList$dia_0)> (v2)
         in invokestatic <TreeList$dia_0 TreeList.append (TreeList$dia_0, TreeList$dia_0)> (v1, t)
         end

       fun f:0(TreeList$dia_0 t) =
         let val v4 = getfield t <int TreeList$dia_0.f0>
             val t = invokestatic <TreeList$dia_0 TreeList$dia_0.make (int)> (2)
         in invokestatic <TreeList$dia_0 TreeList$dia_0.make (int, int, TreeList$dia_0)> (3, v4, t)
         end
   in f:flatten(t) end

  method public static TreeList$dia_0 append (TreeList$dia_0 l1, TreeList$dia_0 l2) =
   let fun f:append(TreeList$dia_0 l1, TreeList$dia_0 l2) =
         let val v3 = getfield l1 <int TreeList$dia_0.$>
         in if v3 = 2
            then f:0(l2)
            else f:1(l1, l2)
         end

       fun f:1(TreeList$dia_0 l1, TreeList$dia_0 l2) =
         let val v3 = getfield l1 <int TreeList$dia_0.f0>
             val v2 = getfield l1 <TreeList$dia_0 TreeList$dia_0.f1>
             val l1 = invokestatic <TreeList$dia_0 TreeList.append (TreeList$dia_0, TreeList$dia_0)> (v2, l2)
         in invokestatic <TreeList$dia_0 TreeList$dia_0.make (int, int, TreeList$dia_0)> (3, v3, l1)
         end

       fun f:0(TreeList$dia_0 l2) = l2
   in f:append(l1, l2) end
\end{verbatim}

*}

syntax b_  :: iname
       t_   :: rname
       v2_  :: rname 
       v3_  :: rname
       v4_  :: iname
 
       l1_  :: rname 
       l2_  :: rname 
       vv3_ :: iname

       fFlatten :: funame
       fzeroFlatten :: funame
       foneFlatten  :: funame
       Flatten :: mname

       fAppend :: funame
       fzeroAppend :: funame
       foneAppend  :: funame
       Append :: mname


translations
 "b_" == "(In ''b'') "
 "t_" == "(RN ''t'') "
 "v2_" == "(RN ''v2'') "
 "v3_" == "(RN ''v3'') "
 "v4_" == "(In ''v4'') "
 "l1_" == "(RN ''l1'') "
 "l2_" == "(RN ''l2'') "
 "vv3_" == "(In ''vv3'') "
 "fFlatten" == "(FN ''fFlatten'') "
 "fzeroFlatten" == "(FN ''f_zeroFlatten'')"
 "foneFlatten" == "(FN ''f_oneFlatten'')"
 "Flatten" == "(MN ''Flatten'')"
 "fAppend" == "(FN ''fAppend'') "
 "fzeroAppend" == "(FN ''f_zeroAppend'')"
 "foneAppend" == "(FN ''f_oneAppend'')"
 "Append" == "(MN ''Append'')"

axioms Meth_Flatten: 
"methtable DIAM Flatten = ([RNpar t_], CALL fFlatten)"

axioms Fun_fFlatten:
"funtable fFlatten = LET v4_ = GetFi t_ DOLLAR;
                          b_ = Primop (\<lambda> z y. if z = 0 then 1 else 0) v4_ v4_
                     IN IF b_ THEN CALL fzeroFlatten ELSE CALL foneFlatten END"
axioms Fun_fzeroFlatten:
"funtable fzeroFlatten = LET v4_ = GetFi t_ F0;
                          rf t_ = DIAM\<bullet>Make_I ([VALarg (IVal 2)])
                         IN DIAM\<bullet>Make_IID ([VALarg (IVal 3), INarg v4_, RNarg t_])
                         END"

axioms Fun_foneFlatten:
"funtable foneFlatten = LET rf v3_ = GetFr t_ F1;
                            rf v2_ = GetFr t_ F2;
                            rf v1_ = DIAM\<bullet>Flatten ([RNarg v3_]);
                             rf t_ = DIAM\<bullet>Flatten ([RNarg v2_])
                        IN DIAM\<bullet>Append ([RNarg v1_,RNarg t_]) END"

axioms Meth_Append: 
"methtable DIAM Append = ([RNpar l1_, RNpar l2_], CALL fAppend)"

axioms Fun_fAppend:
"funtable fAppend = LET vv3_ = GetFi l1_ DOLLAR;
                         b_ = Primop (\<lambda> z y. if z = 2 then 1 else 0) vv3_ vv3_
                    IN IF b_ THEN CALL fzeroAppend ELSE CALL foneAppend END"

axioms Fun_fzeroAppend:
"funtable fzeroAppend = RVar l2_"

axioms Fun_foneAppend:
"funtable foneAppend = LET vv3_ = GetFi l1_ F0;
                         rf v2_ = GetFr l1_ F1;
                         rf l1_ = DIAM\<bullet>Append([RNarg v2_, RNarg l2_])
                       IN DIAM\<bullet>Make_IID([VALarg (IVal 3), INarg vv3_, RNarg l1_]) END"

text {*Auxiliary lemmas on fresh locations.*}
lemma freshlocInsert1[simp, rule_format]: 
"\<forall> h . freshloc (Dom h) \<noteq> freshloc (insert (freshloc (Dom h)) (Dom h))"
apply clarsimp
apply (subgoal_tac "freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> insert (freshloc (Dom h)) (Dom h)")
apply (subgoal_tac "freshloc (Dom h) : insert (freshloc (Dom h)) (Dom h)")
prefer 2 apply simp
prefer 2 apply (rule freshloc, fast)
apply auto
done

lemma freshlocInsert2[simp]: 
"fmap_lookup (oheap h(freshloc (Dom h)\<mapsto>\<^sub>fC)(freshloc (insert (freshloc (Dom h)) (Dom h))\<mapsto>\<^sub>fC)) (freshloc (Dom h)) = Some C"
by (simp add: FMAPlookup3)

lemma freshlocInsert3[simp]: 
"freshloc (insert (freshloc (Dom h)) (Dom h)) \<noteq> freshloc (Dom h)"
by (insert freshlocInsert1 [of h], fastsimp)

lemma freshlocInsert4[simp]: 
"freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> Dom h"
apply (subgoal_tac "freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> (insert (freshloc (Dom h)) (Dom h))")
apply (subgoal_tac "Dom h \<subseteq> insert (freshloc (Dom h)) (Dom h)", fast, fast, rule freshloc, fast)
done

lemma freshlocInsert5[simp]:
   "same (Dom h)  h \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM)(freshloc (insert (freshloc (Dom h)) (Dom h))\<mapsto>\<^sub>fDIAM),
                     iheap = (iheap h)
                      (DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := 2, freshloc (insert (freshloc (Dom h)) (Dom h)) := 3),
                       F0 := (iheap h F0)(freshloc (insert (freshloc (Dom h)) (Dom h)) := h<a\<bullet>F0>)),
                     rheap = (rheap h)(F1 := (rheap h F1)(freshloc (insert (freshloc (Dom h)) (Dom h)) := Ref (freshloc (Dom h)))),
                     sheap = sheap h\<rparr>"
by (simp add: same_def sameOH_def FMAPlookup3) 

subsubsection {*Verification of @{text append} and @{text flatten}*}
text {*We first give the specifications of the two methods.*}
constdefs appendSpec::bool
"appendSpec == 
(MS DIAM Append = 
  (\<lambda> args E h hh v p. 
     (\<forall> Ups1 Ups2 ll1 ll2 X1 X2 n X. (evalARGS E args =[RVal (Ref ll1), RVal (Ref ll2)] \<and> 
                                        (Ups1,ll1,X1,h): mList \<and> (Ups2,ll2,X2,h): mList \<and> 
                                        (n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL \<and> X1 \<inter> X2 = {} \<and> X1 \<inter> X = {} \<and> X \<inter> X2 = {} \<and> Ups1 \<le> n) \<longrightarrow> 
                                     (\<exists> a Z XX. v = RVal (Ref a) \<and> (Ups1+Ups2,a,Z,hh):mList \<and> 
                                                (n - Ups1, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, XX, hh) : FL \<and> XX \<inter> Z = {} \<and> a: (X \<union> X2) \<and> XX \<subseteq> X \<and> Z \<subseteq> X2 \<union> (X - XX) \<and> 
                                                sameOH ((Dom h)-(X1 \<union> X)) h hh \<and> Dom hh = Dom h))))"
consts flattenSpec::bool 


text {*Next, we define a context which associates all method calls to their specifications.
       The first two entries allow to discharge the assumptions in the auxiliary lemmas
       for the \verb|make| methods. Notice that the context has several entries for
       the methods \verb|Make_IID|, \verb|Append| and \verb|Flatten|.*}
constdefs flattenContext:: vdmcontext
"flattenContext \<equiv> {(DIAM\<bullet>Alloc ([]), MS DIAM Alloc []),
                    (DIAM\<bullet>Fill_DI ([RNarg x_, INarg tag_]), MS DIAM Fill_DI [RNarg x_, INarg tag_]),
                    (DIAM\<bullet>Fill_DIID ([RNarg x_, INarg tag_, INarg v0_, RNarg v1_]),
                         MS DIAM Fill_DIID [RNarg x_, INarg tag_, INarg v0_, RNarg v1_]),
                    (DIAM\<bullet>Make_I([VALarg (IVal 2)]), MS DIAM Make_I [VALarg (IVal 2)]),
                    (DIAM\<bullet>Make_IID([VALarg (IVal 3), INarg vv3_, RNarg l1_]), 
                         MS DIAM Make_IID [VALarg (IVal 3), INarg vv3_, RNarg l1_]),
                    (DIAM\<bullet>Make_IID([VALarg (IVal 3), INarg v4_, RNarg t_]),
                         MS DIAM Make_IID [VALarg (IVal 3), INarg v4_, RNarg t_]),
                    (DIAM\<bullet>Append([RNarg v2_,RNarg l2_]), MS DIAM Append [RNarg v2_,RNarg l2_]),
                    (DIAM\<bullet>Append([RNarg v1_, RNarg t_]), MS DIAM Append [RNarg v1_, RNarg t_]),
                    (DIAM\<bullet>Flatten ([RNarg v3_]), MS DIAM Flatten [RNarg v3_]),  
                    (DIAM\<bullet>Flatten ([RNarg v2_]), MS DIAM Flatten [RNarg v2_])}" 
text {*In this context, the bodies of the ''application methods'' \verb|Append|
       and \verb|Flatten| are now shown to satisfy their respective specifications --
       the usage of the additional context variable \verb|G| is a simple trick to
       allow the application of these lemmas as \verb|erules|.*}
lemma l1: "\<lbrakk>fmap_lookup (oheap h) ac = Some DIAM; ac \<notin> Z; (na + Ups2, ab, Z, h) \<in> mList;
             rUpd (iUpd (iUpd (sUpd Same DIAM DOLLAR_F (rdotVE (constVE (RVal (Ref ac))) DOLLAR_N)) (constVE (RVal (Ref ac))) DOLLAR (constVE (IVal 3)))
                 (constVE (RVal (Ref ac))) F0 (constVE (IVal ha<a\<bullet>F0>)))
           (constVE (RVal (Ref ac))) F1 (constVE (RVal (Ref ab)))
           \<lparr>ienv = emptyi, renv = emptyr(self := Nullref)\<rparr>\<lfloor>l1_:=Ref a\<rfloor>\<lfloor>l2_:=Ref ll2\<rfloor><vv3_:=ha<a\<bullet>DOLLAR>><b_:=0><vv3_:=ha<a\<bullet>F0>>\<lfloor>v2_:=Ref aa\<rfloor>\<lfloor>l1_:=Ref ab\<rfloor> h
           hh \<rbrakk> \<Longrightarrow> (Suc (na + Ups2), ac, Z \<union> {ac}, hh) \<in> mList"
by (rule mListCONS, simp_all add: predicates newObj_def, erule mListSameOH, simp add: sameOH_def)

lemma Append_Aux:
"\<lbrakk>appendSpec; make_I_Spec; make_IID_Spec; alloc_Spec; G = flattenContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Append) : 
                    (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Append)) x E' \<longrightarrow>
                                       MS DIAM Append x E' h hh v
                                          (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (simp add: Meth_Append)
apply (rule vdm_conseq)
apply (rule Call1, simp add: Fun_fAppend, safe)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_fzeroAppend)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_foneAppend)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
defer 1
txt {*end of simple VCG*}
apply (simp add: IMPLIES_def appendSpec_def newframe_env_def evalARGS_def, clarsimp) apply(erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims, simp add: predicates) apply clarsimp
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def) apply (clarsimp)
txt {* end of extended vcg, now discharge the 2 side conditions*}
prefer 2
txt {*Case NIL*}
apply (erule mList.elims, simp_all, clarsimp)
apply (rule_tac x=X2 in exI, simp)
apply (rule_tac x=X in exI, simp)
apply rule
apply (erule mList.elims, simp_all)
apply (rule SameOHSubset)
apply (rule SameOHTriv, fast)
txt {*Case CONS*}
apply (erule mList.elims, simp_all, safe)
apply (subgoal_tac "\<exists> l . ha\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Ref l \<and> l:X", clarsimp)
prefer 2 apply (erule FL.elims, simp_all, clarsimp)
apply (erule_tac x=na in allE, erule_tac x=Ups2 in allE, 
       erule_tac x=Xa in allE, erule_tac x=X2 in allE,
       erule_tac x="n" in allE, erule_tac x="X" in allE, clarsimp)
apply (simp add:  make_IID_Spec_def evalARGS_def)
apply (rotate_tac 1, erule thin_rl)
apply (erule_tac x="n-na" in allE) apply(erule impE, rule_tac x="XX" in exI, clarsimp)
apply (subgoal_tac "\<exists> nn. n - na = Suc nn")
prefer 2 apply arith
apply (erule exE) apply clarsimp 
apply (rule_tac x=la in exI, rule, simp)
apply (subgoal_tac "la : XX") prefer 2 apply (rotate_tac -11) apply (erule FL.elims, simp_all, clarsimp) 
apply (subgoal_tac "la \<notin> Z") prefer 2 apply fast
apply (rotate_tac -13) apply (erule FL.elims, simp_all, clarsimp)
apply (rule_tac x="Z \<union> {ac}" in exI, rule)
apply (rule l1) prefer 3 apply assumption apply assumption apply assumption apply assumption
apply (subgoal_tac "n - Suc na = nb", simp) prefer 2 apply arith
apply (rule_tac x="Xb" in exI, simp)
apply (simp add: predicates newObj_def)
apply (rule)
  apply (erule FL_SameOH)
  apply (simp add: sameOH_def)
apply (rule, erule SubsetTransitive, fast)
apply (rule SameOHTransitive)
apply (erule SameOHSubset) apply fast
apply (subgoal_tac "sameOH (Dom h - {ac})
           h (h\<lparr>sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := h\<lfloor>ac\<diamondsuit>DOLLAR_N\<rfloor>)), iheap := (iheap h)(DOLLAR := (iheap h DOLLAR)(ac := 3)),
                  iheap := (iheap h)(DOLLAR := (iheap h DOLLAR)(ac := 3), F0 := (iheap h F0)(ac := ha<a\<bullet>F0>)),
                  rheap := (rheap h)(F1 := (rheap h F1)(ac := Ref ab))\<rparr>)", assumption)
apply (subgoal_tac "ac \<notin> Dom h - {ac}")
apply (simp add: sameOH_def)
apply fast
apply fast
done

text {*An alternative proof of lemma @{text AppendAux} uses @{text vdm_conseq} and MakeIIDSpec 2*}
(*lemma Append_Aux:
"\<lbrakk>appendSpec; make_I_Spec; make_IID_Spec; alloc_Spec; G = flattenContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Append) : 
                    (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Append)) x E' \<longrightarrow>
                                       MS DIAM Append x E' h hh v
                                          (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (simp add: Meth_Append)
apply (rule vdm_conseq)
apply (rule Call1, simp add: Fun_fAppend, safe)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_fzeroAppend)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_foneAppend)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_conseq)
apply (rule vdm_ax, simp add: flattenContext_def)
apply (subgoal_tac "\<forall> E h hh v p. MS DIAM Make_IID [VALarg (IVal 3), INarg vv3_, RNarg l1_] E h hh v p \<longrightarrow>
                                  MakeIID_Spec2 [VALarg (IVal 3), INarg vv3_, RNarg l1_] E h hh v p", assumption)
defer 1
txt {*end of simple VCG*}
apply (simp add: IMPLIES_def appendSpec_def newframe_env_def evalARGS_def, clarsimp) apply(erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims, simp add: predicates) apply clarsimp
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def) apply (clarsimp)
txt {* end of extended vcg, now discharge the 2 side conditions*}
prefer 2
txt {*Case NIL*}
apply (erule mList.elims, simp_all, clarsimp)
apply (rule_tac x=X2 in exI, simp)
apply (rule_tac x=X in exI, simp)
apply rule
apply (erule mList.elims, simp_all)
apply (rule SameOHSubset)
apply (rule SameOHTriv, fast)
txt {*Case CONS*}
apply (erule mList.elims, simp_all, safe)
apply (subgoal_tac "\<exists> l . ha\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Ref l \<and> l:X", clarsimp)
prefer 2 apply (erule FL.elims, simp_all, clarsimp)
apply (erule_tac x=na in allE, erule_tac x=Ups2 in allE, 
       erule_tac x=Xa in allE, erule_tac x=X2 in allE,
       erule_tac x="n" in allE, erule_tac x="X" in allE, clarsimp)
apply (simp add:  MakeIID_Spec2_def evalARGS_def)
apply (erule_tac x="n-na" in allE, erule_tac x="XX" in allE, clarsimp)
apply (subgoal_tac "\<exists> nn. n - na = Suc nn")
prefer 2 apply (arith)
apply (erule exE) apply (erule_tac x=nn in allE) apply (erule impE, assumption)
apply (erule exE, (erule conjE)+)
apply (rule_tac x=la in exI, rule, assumption)
apply (subgoal_tac "la \<notin> Z")
  prefer 2 apply fast
apply (rotate_tac -3, erule thin_rl, clarsimp) (-remove Dom hh = Dom ha -- we still have Dom ha = Dom hh-)
apply (rule_tac x="Z \<union> {la}" in exI, rule)
apply (rule l1) prefer 3 apply assumption apply (rotate_tac -12) apply (erule FL.elims, simp_all)
apply clarsimp
apply (subgoal_tac "n - Suc na = nn", simp) prefer 2 apply arith
apply (rule_tac x="XX - {la}" in exI, simp)
apply (rule, fast)
apply (rule, fast)
apply (rule, fast)
apply (rule SameOHTransitive)
apply (erule SameOHSubset) apply fast
apply assumption
apply fast
oops
the rest follows fomr the lamma relating the two specs
*)

defs flattenSpec_def:
"flattenSpec == 
(MS DIAM Flatten = 
  (\<lambda> args E h hh v p. 
     (\<forall> Ups Y ll X n. (evalARGS E args = [RVal (Ref ll)] \<and> (Ups,ll,Y,h): mTree \<and> 
                       (n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL \<and> X \<inter> Y = {} \<and> 2 * 2^Ups \<le> n) \<longrightarrow>
                      (\<exists> a Z XX. v = RVal (Ref a) \<and> (2 ^ Ups,a,Z,hh):mList \<and> 
                                 (n - (2 * 2^Ups), hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, XX, hh) : FL \<and> XX \<inter> Z = {} \<and> XX \<subseteq> X \<and> Z \<subseteq> X - XX \<and> 
                                 sameOH ((Dom h)- X) h hh \<and> Dom hh = Dom h))))"

lemma fmaplookup_DOM[simp]: "fmap_lookup (oheap h) l = Some C \<Longrightarrow> l : Dom h"
by (simp add: fmap_lookup_def fmap_dom_def dom_def)

text {*Verification fails - but Steffen's analysis reported that the whole program is infeasible!*}
lemma flatten_Aux:
"\<lbrakk>appendSpec; flattenSpec; make_I_Spec; make_IID_Spec; alloc_Spec; G = flattenContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Flatten) : 
                   (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Flatten)) x E' \<longrightarrow>
                                      MS DIAM Flatten x E' h hh v
                                        (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p)))) "
apply (simp add:  Meth_Flatten)
apply (rule vdm_conseq)
apply (rule Call1, simp add: Fun_fFlatten)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_fzeroFlatten)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule Call1, simp add: Fun_foneFlatten)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply clarsimp
txt {*end of simple VCG*}
apply (simp add: flattenSpec_def newframe_env_def evalARGS_def, clarsimp) 
apply (rotate_tac 1, erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates) apply (simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, safe)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def, clarsimp)
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def, clarsimp)
txt {*end of extended VCG. Now discharge the 2 side conditions*}
prefer 2
txt {*Case LEAF*}
apply (erule mTree.elims, simp_all, clarsimp)
apply (simp add: make_I_Spec_def newframe_env_def evalARGS_def predicates newObj_def)
apply (erule thin_rl)
apply (erule_tac x="n" in allE, erule impE, rule, assumption, clarsimp)
apply (erule impE, arith, clarsimp)
apply (simp add: make_IID_Spec_def newframe_env_def evalARGS_def predicates newObj_def)
apply (erule thin_rl)
apply (erule FL.elims,  simp_all, clarsimp)
apply (erule_tac x="na" in allE, erule impE)
apply (rule_tac x=Xa in exI, erule FL_SameOH) apply (simp add: sameOH_def)
apply (clarsimp)
apply (erule impE, arith, clarsimp)
apply (rule_tac x=l in exI, simp)
apply (erule FL.elims, simp_all, clarsimp)
apply (rule_tac x="{aa} \<union> {ab}" in exI, rule)
apply (rule mListCONS, simp_all) 
apply (rule mListNIL, simp_all)
apply (rule_tac x=X in exI, simp, rule)
apply (erule FL_SameOH, simp add: sameOH_def)
apply (safe)
apply (simp add: sameOH_def)
txt {*Case NODE*}
apply (erule mTree.elims, simp_all, clarsimp)
  txt{*apply spec to first invocation*}
  apply (erule_tac x=na in allE)
  apply (erule_tac x=X1 in allE)
  apply (erule_tac x=X in allE)
  apply (rotate_tac -1)
  apply (erule_tac x="n" in allE, clarsimp)
  apply(erule impE, fast, safe)
  txt{* prove that second tree did not get destroyed during first invocation*}
  apply (subgoal_tac "(na, a2, X2, h1) \<in> mTree")
    prefer 2 
    apply (rule mTreeSameOH, assumption) apply (erule SameOHSubset) apply (subgoal_tac "X2 \<subseteq> Dom ha", fast) apply (erule mTreeDom)
  txt{*apply spec to second invocation*}
  apply (erule_tac x=na in allE)
  apply (erule_tac x=X2 in allE)
  apply (erule_tac x=XX in allE)
  apply (erule_tac x="n - 2 * 2 ^ na" in allE, clarsimp)
  apply (erule impE) apply (rule, fast) apply arith
  txt{* prove that the result list from the first invocation did not get destroyed during second invocation*}
  apply clarsimp
  apply (subgoal_tac "(2 ^ na, aa, Z, h1a) \<in> mList")
    prefer 2 
    apply (rule mListSameOH, assumption) apply (erule SameOHSubset) apply (subgoal_tac "Z \<subseteq> Dom h1", fast) apply (erule mListDom)
  txt{*now unfold and apply spec of append*}
  apply (simp add: appendSpec_def evalARGS_def) apply (rotate_tac 6, erule thin_rl)
  apply (erule_tac x="2 ^ na" in allE, erule_tac x="2 ^ na" in allE, erule_tac x=Z in allE,erule_tac x=Za in allE)
  apply (erule_tac x="n - 3 * 2 ^ na" in allE, erule_tac x="XXa" in allE)
  apply (erule impE)  apply (rule, assumption) apply (rule, assumption)  apply (rule, assumption) apply (rule, fast) apply (rule, fast) apply (rule, fast)
  apply simp
defer 1
  apply clarsimp
  apply (rule_tac x=Zb in exI)
  apply (subgoal_tac "(2::nat) ^ na + 2 ^ na = 2 * 2 ^ na", simp) 
  apply (rule_tac x=XXb in exI, simp)
  apply rule defer 1
  apply rule 
  apply (erule SubsetTransitive)
  apply (erule SubsetTransitive, simp)
  apply rule
  apply (erule SubsetTransitive) defer 1
  apply (rule SameOHTransitive, assumption)
  apply (rule SameOHTransitive, assumption)
  apply (rule SameOHTransitive, assumption)
  apply (rule SameOHTriv)
  apply simp apply fast
  apply fast
  apply (erule SameOHImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
apply (rule Sa
  apply (rule, rule, assumption) 
apply (rule, fast)
apply (rule, fast)
apply (rule, fast)
    apply (subgoal_tac "Z \<subseteq> Dom h1", fast) apply (erule mListDom)
  apply clarsimp
  apply (rule_tac x= Zb in exI)
  apply rule
  apply (subgoal_tac "(2::nat) ^ n + (2::nat) ^ n = (2::nat) * (2::nat) ^ n", simp) apply arith
  apply rule
  apply (subgoal_tac "Dom ha \<subseteq> Dom h1a \<inter> Dom h1", fast)
    apply (subgoal_tac "Dom ha \<subseteq> Dom h1")
    apply (subgoal_tac "Dom h1 \<subseteq> Dom h1a", fast)
    apply (erule SameImpliesDomsubset)
    apply (erule SameImpliesDomsubset)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTriv)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
done

text {*Now, the proof that \verb|flattenContext| is good follows from
       the auxiliary lemmas for all entries.*}
lemma flattenContext_good: 
"\<lbrakk>appendSpec; flattenSpec; fill_DI_Spec; make_I_Spec; fill_DIID_Spec; make_IID_Spec\<rbrakk>
 \<Longrightarrow> goodContext flattenContext"
apply (simp add: goodContext_def flattenContext_def) apply safe
(* Fill_DI*)
apply (erule Fill_DI_Aux)
(* Fill_DIID*)
apply (erule Fill_DIID_Aux)
(* Make_I*)
apply (erule Make_I_Aux, assumption, simp add: flattenContext_def)
(* Make_IID*)
apply (erule Make_IID_Aux, assumption, simp add: flattenContext_def)
apply (erule Make_IID_Aux, assumption, simp add: flattenContext_def)
(*Append*)
apply (erule Append_Aux, assumption, assumption, simp add: flattenContext_def)
apply (erule Append_Aux, assumption, assumption, simp add: flattenContext_def)
(* Flatten *)
apply (erule flatten_Aux, assumption, assumption, assumption, simp add: flattenContext_def)
apply (erule flatten_Aux, assumption, assumption, assumption, simp add: flattenContext_def)
done

text {*Finally, we prove that an invocation of \verb|flatten| satisifies the
       specification -- notice that the specification is fulfilled for ANY variable \verb|a|.*}
theorem
"\<lbrakk>appendSpec; flattenSpec; fill_DI_Spec; make_I_Spec; fill_DIID_Spec; make_IID_Spec\<rbrakk>
 \<Longrightarrow> \<rhd> DIAM\<bullet>Flatten([a]): MS DIAM Flatten [a]"
apply (rule GC)
apply (rule flattenContext_good)
apply (simp_all, simp_all add: InvContext_def flattenContext_def, auto)
done

text{*In particular an invocation with an integer parameter (ill-typed!) does satisfy
      the specification \verb|MS DIAM Flatten|:*}
lemma
"\<lbrakk>appendSpec; flattenSpec; fill_DI_Spec; make_I_Spec; fill_DIID_Spec; make_IID_Spec\<rbrakk>
 \<Longrightarrow> \<rhd> DIAM\<bullet>Flatten([INarg a]): MS DIAM Flatten [INarg a]"
apply (rule GC)
apply (rule flattenContext_good)
apply (simp_all, simp_all add: InvContext_def flattenContext_def, auto)
done 

text {*However, the specification for integer parameters is trivial:*}
lemma 
"\<lbrakk>flattenSpec\<rbrakk> \<Longrightarrow> MS DIAM Flatten [INarg a] = (\<lambda> E h hh v p . True)"
by (simp add: flattenSpec_def evalARGS_def)

text{*and so is a specification for a list of variables which is longer than one:*}
lemma "flattenSpec \<Longrightarrow> MS DIAM Flatten [RNarg a, RNarg b] = (\<lambda> E h hh v p . True)"
by (simp add: flattenSpec_def evalARGS_def)
(*<*)
end
(*>*)
