(*<*)
theory Flatten2 = mTreeList:
(*>*)

subsection{*Flattening a tree*}

text {* Camelot code:
\begin{verbatim}
  type itree = Leaf of int | Node of itree * itree
  type ilist = Nil | Cons of int * ilist

  let append l1 l2 = match l1 with Nil => l2
                                 | Cons(h,t) => Cons(h,append t l2)

  let flatten t = match t with Leaf(i) => Cons(i,Nil)
                             | Node(l,r) => append (flatten l) (flatten r)
\end{verbatim}
Grail code:
\begin{verbatim}
  method public static TreeList$dia_0 flatten (TreeList$dia_0 t) =
   let fun f:flatten(TreeList$dia_0 t) =
         let val v4 = getfield t <int TreeList$dia_0.$>
         in if v4 = 0
            then f:0(t)
            else f:1(t)
         end

       fun f:1(TreeList$dia_0 t) =
         let val v3 = getfield t <TreeList$dia_0 TreeList$dia_0.f1>
             val v2 = getfield t <TreeList$dia_0 TreeList$dia_0.f2>
             val v1 = invokestatic <TreeList$dia_0 TreeList.flatten (TreeList$dia_0)> (v3)
             val t = invokestatic <TreeList$dia_0 TreeList.flatten (TreeList$dia_0)> (v2)
         in invokestatic <TreeList$dia_0 TreeList.append (TreeList$dia_0, TreeList$dia_0)> (v1, t)
         end

       fun f:0(TreeList$dia_0 t) =
         let val v4 = getfield t <int TreeList$dia_0.f0>
             val t = invokestatic <TreeList$dia_0 TreeList$dia_0.make (int)> (2)
         in invokestatic <TreeList$dia_0 TreeList$dia_0.make (int, int, TreeList$dia_0)> (3, v4, t)
         end
   in f:flatten(t) end

  method public static TreeList$dia_0 append (TreeList$dia_0 l1, TreeList$dia_0 l2) =
   let fun f:append(TreeList$dia_0 l1, TreeList$dia_0 l2) =
         let val v3 = getfield l1 <int TreeList$dia_0.$>
         in if v3 = 2
            then f:0(l2)
            else f:1(l1, l2)
         end

       fun f:1(TreeList$dia_0 l1, TreeList$dia_0 l2) =
         let val v3 = getfield l1 <int TreeList$dia_0.f0>
             val v2 = getfield l1 <TreeList$dia_0 TreeList$dia_0.f1>
             val l1 = invokestatic <TreeList$dia_0 TreeList.append (TreeList$dia_0, TreeList$dia_0)> (v2, l2)
         in invokestatic <TreeList$dia_0 TreeList$dia_0.make (int, int, TreeList$dia_0)> (3, v3, l1)
         end

       fun f:0(TreeList$dia_0 l2) = l2
   in f:append(l1, l2) end
\end{verbatim}
and in class \verb|TreeList$dia_0| we have (amongst other tings):
\begin{verbatim}
   method public static TreeList$dia_0 make (int tag) =
     let val ?x = invokestatic <TreeList$dia_0 TreeList$dia_0.alloc ()> ()
     in invokestatic <TreeList$dia_0 TreeList$dia_0.fill (TreeList$dia_0, int)> (?x, tag)
     end

   method public static TreeList$dia_0 make (int tag, int v0, TreeList$dia_0 v1) =
     let val ?x = invokestatic <TreeList$dia_0 TreeList$dia_0.alloc ()> ()
     in invokestatic <TreeList$dia_0 TreeList$dia_0.fill (TreeList$dia_0, int, int, TreeList$dia_0)> (?x, tag, v0, v1)
     end

   method public static TreeList$dia_0 fill (TreeList$dia_0 ?x, int tag) =
     let val () = putfield ?x <int TreeList$dia_0.$> tag
     in ?x
     end

   method public static TreeList$dia_0 fill (TreeList$dia_0 ?x, int tag, int v0, TreeList$dia_0 v1) =
     let val () = putfield ?x <int TreeList$dia_0.$> tag
         val () = putfield ?x <int TreeList$dia_0.f0> v0
         val () = putfield ?x <TreeList$dia_0 TreeList$dia_0.f1> v1
     in ?x
     end
\end{verbatim}
*}

syntax b_  :: iname
       tag_ :: iname
       x_   :: rname
       t_   :: rname 
       v0_  :: iname  
       v1_  :: rname 
       v2_  :: rname 
       v3_  :: rname
       v4_  :: iname
 
       l1_  :: rname 
       l2_  :: rname 
       vv3_ :: iname

       fFlatten :: funame
       fzeroFlatten :: funame
       foneFlatten  :: funame
       Flatten :: mname

       fAppend :: funame
       fzeroAppend :: funame
       foneAppend  :: funame
       Append :: mname

       Make_I    :: mname
       Make_IID  :: mname
       Fill_DI   :: mname
       Fill_DIID :: mname

translations
 "b_" == "(In ''b'') "
 "tag_" == "(In ''tag'') "
 "x_" == "(RN ''?x'') "
 "t_" == "(RN ''t'') "
 "v0_" == "(In ''v0'') "
 "v1_" == "(RN ''v1'') "
 "v2_" == "(RN ''v2'') "
 "v3_" == "(RN ''v3'') "
 "v4_" == "(In ''v4'') "
 "l1_" == "(RN ''l1'') "
 "l2_" == "(RN ''l2'') "
 "vv3_" == "(In ''vv3'') "
 "fFlatten" == "(FN ''fFlatten'') "
 "fzeroFlatten" == "(FN ''f_zeroFlatten'')"
 "foneFlatten" == "(FN ''f_oneFlatten'')"
 "Flatten" == "(MN ''Flatten'')"
 "fAppend" == "(FN ''fAppend'') "
 "fzeroAppend" == "(FN ''f_zeroAppend'')"
 "foneAppend" == "(FN ''f_oneAppend'')"
 "Append" == "(MN ''Append'')"
 "Make_I" == "(MN ''Make_I'')"
 "Make_IID" == "(MN ''Make_IID'')"
 "Fill_DI" == "(MN ''Fill_DI'')"
 "Fill_DIID" == "(MN ''Fill_DIID'')"

axioms Meth_Make_I:
"methtable DIAM Make_I = ([INpar tag_], LET rf x_ = NEW <DIAM> ([],[]) (*alloc*)
                                        IN DIAM\<bullet>Fill_DI ([RNarg x_, INarg tag_]) END)"

axioms Meth_Make_IID:
"methtable DIAM Make_IID = ([INpar tag_, INpar v0_, RNpar v1_],
                            LET rf x_ = NEW <DIAM> ([],[]) (*alloc*)
                           IN DIAM\<bullet>Fill_DIID ([RNarg x_, INarg tag_, INarg v0_, RNarg v1_]) END)"

axioms Meth_Fill_DI:
"methtable DIAM Fill_DI = ([RNpar x_, INpar tag_],
                           LET _ = PutFi x_ DOLLAR tag_
                           IN RVar x_ END)"

axioms Meth_Fill_DIID:
"methtable DIAM Fill_DIID = ([RNpar x_, INpar tag_, INpar v0_, RNpar v1_],
                             LET _ = PutFi x_ DOLLAR tag_;
                                 _ = PutFi x_ F0 v0_;
                                 _ = PutFr x_ F1 v1_
                             IN RVar x_ END)"

axioms Meth_Flatten: 
"methtable DIAM Flatten = ([RNpar t_], CALL fFlatten)"

axioms Fun_fFlatten:
"funtable fFlatten = LET v4_ = GetFi t_ DOLLAR;
                          b_ = Primop (\<lambda> z y. if z = 0 then 1 else 0) v4_ v4_
                     IN IF b_ THEN CALL fzeroFlatten ELSE CALL foneFlatten END"
axioms Fun_fzeroFlatten:
"funtable fzeroFlatten = LET v4_ = GetFi t_ F0;
                          rf t_ = DIAM\<bullet>Make_I ([VALarg (IVal 2)])
                         IN DIAM\<bullet>Make_IID ([VALarg (IVal 3), INarg v4_, RNarg t_])
                         END"

axioms Fun_foneFlatten:
"funtable foneFlatten = LET rf v3_ = GetFr t_ F1;
                            rf v2_ = GetFr t_ F2;
                            rf v1_ = DIAM\<bullet>Flatten ([RNarg v3_]);
                             rf t_ = DIAM\<bullet>Flatten ([RNarg v2_])
                        IN DIAM\<bullet>Append ([RNarg v1_,RNarg t_]) END"

axioms Meth_Append: 
"methtable DIAM Append = ([RNpar l1_, RNpar l2_], CALL fAppend)"

axioms Fun_fAppend:
"funtable fAppend = LET vv3_ = GetFi l1_ DOLLAR;
                         b_ = Primop (\<lambda> z y. if z = 2 then 1 else 0) vv3_ vv3_
                    IN IF b_ THEN CALL fzeroAppend ELSE CALL foneAppend END"

axioms Fun_fzeroAppend:
"funtable fzeroAppend = RVar l2_"

axioms Fun_foneAppend:
"funtable foneAppend = LET vv3_ = GetFi l1_ F0;
                         rf v2_ = GetFr l1_ F1;
                         rf l1_ = DIAM\<bullet>Append([RNarg v2_, RNarg l2_])
                       IN DIAM\<bullet>Make_IID([VALarg (IVal 3), INarg vv3_, RNarg l1_]) END"

text {*Auxiliary lemmas on fresh locations.*}
lemma freshlocInsert1[simp, rule_format]: 
"\<forall> h . freshloc (Dom h) \<noteq> freshloc (insert (freshloc (Dom h)) (Dom h))"
apply clarsimp
apply (subgoal_tac "freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> insert (freshloc (Dom h)) (Dom h)")
apply (subgoal_tac "freshloc (Dom h) : insert (freshloc (Dom h)) (Dom h)")
prefer 2 apply simp
prefer 2 apply (rule freshloc, fast)
apply auto
done

lemma freshlocInsert2[simp]: 
"fmap_lookup (oheap h(freshloc (Dom h)\<mapsto>\<^sub>fC)(freshloc (insert (freshloc (Dom h)) (Dom h))\<mapsto>\<^sub>fC)) (freshloc (Dom h)) = Some C"
by (simp add: FMAPlookup3)

lemma freshlocInsert3[simp]: 
"freshloc (insert (freshloc (Dom h)) (Dom h)) \<noteq> freshloc (Dom h)"
by (insert freshlocInsert1 [of h], fastsimp)

lemma freshlocInsert4[simp]: 
"freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> Dom h"
apply (subgoal_tac "freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> (insert (freshloc (Dom h)) (Dom h))")
apply (subgoal_tac "Dom h \<subseteq> insert (freshloc (Dom h)) (Dom h)", fast, fast, rule freshloc, fast)
done

lemma freshlocInsert5[simp]:
   "same (Dom h)  h \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM)(freshloc (insert (freshloc (Dom h)) (Dom h))\<mapsto>\<^sub>fDIAM),
                     iheap = (iheap h)
                      (DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := 2, freshloc (insert (freshloc (Dom h)) (Dom h)) := 3),
                       F0 := (iheap h F0)(freshloc (insert (freshloc (Dom h)) (Dom h)) := h<a\<bullet>F0>)),
                     rheap = (rheap h)(F1 := (rheap h F1)(freshloc (insert (freshloc (Dom h)) (Dom h)) := Ref (freshloc (Dom h)))),
                     sheap = sheap h\<rparr>"
by (simp add: same_def sameOH_def FMAPlookup3) 

subsection {*Specifications*}
constdefs fill_DI_Spec::bool
"fill_DI_Spec \<equiv> 
(MS DIAM Fill_DI = 
  (\<lambda> args E h hh v p. (\<forall> l_x i_tag. evalARGS E args =[RVal (Ref l_x), IVal i_tag] \<longrightarrow>
                                     (v = RVal (Ref l_x) \<and> same ((Dom h)-{l_x}) h hh \<and> 
                                      iUpd Same (constVE (RVal (Ref l_x))) DOLLAR (constVE (IVal i_tag)) E h hh))))"

constdefs fill_DIID_Spec::bool
"fill_DIID_Spec \<equiv> 
(MS DIAM Fill_DIID = 
  (\<lambda> args E h hh v p. (\<forall> l_x i_tag i_v0 r_v1. evalARGS E args = [RVal (Ref l_x), IVal i_tag, IVal i_v0, RVal r_v1] \<longrightarrow>
                                              (v = RVal (Ref l_x) \<and> same ((Dom h)-{l_x}) h hh \<and> 
                                               rUpd (iUpd (iUpd Same (constVE (RVal (Ref l_x))) DOLLAR (constVE (IVal i_tag)))
                                                          (constVE (RVal (Ref l_x)))
                                                          F0 
                                                          (constVE (IVal i_v0)))
                                                    (constVE (RVal (Ref l_x)))
                                                    F1 
                                                   (constVE (RVal r_v1)) E h hh))))"

text {*In fact the second clauses of both conclusions are implied by the third ones:*}
lemma "iUpd Same (constVE (RVal (Ref l_x))) DOLLAR (constVE (IVal i_tag)) E h hh
       \<longrightarrow> same ((Dom h)-{l_x}) h hh"
by (simp add: predicates same_def sameOH_def)

lemma "rUpd (iUpd (iUpd Same (constVE (RVal (Ref l_x))) DOLLAR (constVE (IVal i_tag)))
                  (constVE (RVal (Ref l_x))) F0 (constVE (IVal i_v0)))
            (constVE (RVal (Ref l_x))) F1 (constVE (RVal r_v1)) E h hh \<longrightarrow>
       same ((Dom h)-{l_x}) h hh"
by (simp add: predicates same_def sameOH_def)

constdefs make_I_Spec::bool
"make_I_Spec \<equiv> 
(MS DIAM Make_I = 
  (\<lambda> args E h hh v p. (\<forall> i_tag. evalARGS E args =[IVal i_tag] \<longrightarrow>
                                (\<exists> l_x . v = RVal (Ref l_x)  \<and> same (Dom h) h hh \<and> 
                                         iUpd (extendHE Same DIAM l_x [] []) 
                                              (constVE (RVal (Ref l_x))) DOLLAR (constVE (IVal i_tag)) E h hh))))"

constdefs make_IID_Spec::bool
"make_IID_Spec \<equiv> 
(MS DIAM Make_IID = 
  (\<lambda> args E h hh v p. (\<forall> i_tag i_v0 r_v1. evalARGS E args =[IVal i_tag, IVal i_v0, RVal r_v1] \<longrightarrow>
                                          (\<exists> l_x . v = RVal (Ref l_x) \<and> same (Dom h) h hh \<and> 
                                                   rUpd (iUpd (iUpd (extendHE Same DIAM l_x [] [])
                                                                    (constVE (RVal (Ref l_x))) DOLLAR (constVE (IVal i_tag)))
                                                              (constVE (RVal (Ref l_x))) F0 (constVE (IVal i_v0)))
                                                        (constVE (RVal (Ref l_x))) F1 (constVE (RVal r_v1)) E h hh))))"

text {*Again the second clauses of both conclusions are implied by the third ones:*}
lemma "iUpd (extendHE Same DIAM l_x [] []) 
            (constVE (RVal (Ref l_x))) DOLLAR (constVE (IVal i_tag)) E h hh \<longrightarrow>
       same (Dom h) h hh"
by (simp add: predicates newObj_def, clarsimp, rule SameExtend2, simp)

lemma "rUpd (iUpd (iUpd (extendHE Same DIAM l_x [] [])
                        (constVE (RVal (Ref l_x))) DOLLAR (constVE (IVal i_tag)))
                  (constVE (RVal (Ref l_x))) F0 (constVE (IVal i_v0)))
            (constVE (RVal (Ref l_x))) F1 (constVE (RVal r_v1)) E h hh \<longrightarrow>
       same (Dom h) h hh"
by (simp add: predicates newObj_def, clarsimp, rule SameExtend1, simp)

constdefs appendSpec::bool
"appendSpec == 
(MS DIAM Append = 
  (\<lambda> args E h hh v p. 
     (\<forall> Ups1 Ups2 ll1 ll2 X1 X2. (evalARGS E args =[RVal (Ref ll1), RVal (Ref ll2)] \<and> 
                                        (Ups1,ll1,X1,h): mList \<and> (Ups2,ll2,X2,h): mList \<and> X1 \<inter> X2 = {}) \<longrightarrow> 
                                 (\<exists> a Z . v = RVal (Ref a) \<and> (Ups1+Ups2,a,Z,hh):mList \<and> 
                                          (Z \<inter> Dom h) = X2 \<and> same (Dom h) h hh))))"

constdefs flattenSpec::bool
"flattenSpec == 
(MS DIAM Flatten = 
  (\<lambda> args E h hh v p. 
     (\<forall> Ups ll X. (evalARGS E args = [RVal (Ref ll)] \<and> (Ups,ll,X,h): mTree) \<longrightarrow>
                  (\<exists> a Z . v = RVal (Ref a) \<and> (2 ^ Ups,a,Z,hh):mList \<and> (Z \<inter> Dom h) = {} \<and> same (Dom h) h hh))))"

subsubsection {*Verification*}
text {*We first prove that the bodies of the standard methods satisfy their
       specifications -- the fill methods in any contexts, the make
       methods in contexts which contain entries for the appropriate fill methods.*}
lemma Fill_DIID_Aux:
"fill_DIID_Spec \<Longrightarrow> 
  G \<rhd> snd (methtable DIAM Fill_DIID) : 
      (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Fill_DIID)) x E' \<longrightarrow>
                         MS DIAM Fill_DIID x E' h hh v
                            (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (simp add:  Meth_Fill_DIID)
apply (rule vdm_conseq)
apply (rule vdmC_basics)+
apply (simp add: fill_DIID_Spec_def newframe_env_def evalARGS_def, clarsimp)
apply (erule thin_rl) 
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule primElims, simp add: predicates)
apply (simp add: same_def sameOH_def)
apply clarsimp
done

lemma Make_IID_Aux: 
"\<lbrakk>fill_DIID_Spec; make_IID_Spec; 
  (DIAM\<bullet>Fill_DIID ([RNarg x_, INarg tag_, INarg v0_, RNarg v1_]),
                         MS DIAM Fill_DIID [RNarg x_, INarg tag_, INarg v0_, RNarg v1_]) : G\<rbrakk>
\<Longrightarrow>  G \<rhd> snd (methtable DIAM Make_IID) :
      (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Make_IID)) x E' \<longrightarrow>
                         MS DIAM Make_IID x E' h hh v
                            (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))" 
apply (simp add:  Meth_Make_IID)
apply (rule vdm_conseq)
apply (rule vdmC_basics)+
apply (rule vdm_ax, assumption)
apply (simp add: make_IID_Spec_def fill_DIID_Spec_def newframe_env_def evalARGS_def, clarsimp)
apply (erule thin_rl, erule thin_rl) 
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: predicates newObj_def, clarsimp)
apply (rule SameExtend1)
apply simp
done

lemma Fill_DI_Aux:
"fill_DI_Spec \<Longrightarrow> 
  G \<rhd> snd (methtable DIAM Fill_DI) : 
      (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Fill_DI)) x E' \<longrightarrow>
                         MS DIAM Fill_DI x E' h hh v
                            (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (simp add:  Meth_Fill_DI)
apply (rule vdm_conseq)
apply (rule vdmC_basics)+
apply (simp add: fill_DI_Spec_def newframe_env_def evalARGS_def, clarsimp)
apply (erule thin_rl) 
apply (erule letElims, simp add: valExpr_predicates)
apply (erule primElims, simp add: predicates)
apply (simp add: same_def sameOH_def)
apply clarsimp
done

lemma Make_I_Aux: 
"\<lbrakk>fill_DI_Spec; make_I_Spec; 
  (DIAM\<bullet>Fill_DI ([RNarg x_, INarg tag_]),
                         MS DIAM Fill_DI [RNarg x_, INarg tag_]) : G\<rbrakk>
\<Longrightarrow> G \<rhd> snd (methtable DIAM Make_I) :
        (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Make_I)) x E' \<longrightarrow>
                           MS DIAM Make_I x E' h hh v
                              (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))" 
apply (simp add:  Meth_Make_I)
apply (rule vdm_conseq)
apply (rule vdmC_basics)+
apply (rule vdm_ax, assumption)
apply (simp add: make_I_Spec_def fill_DI_Spec_def newframe_env_def evalARGS_def, clarsimp) 
apply (erule thin_rl, erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: predicates newObj_def, clarsimp)
apply (rule SameExtend2)
apply simp
done

text {*Next, we define a context which associates all method calls to their specifications.
       The first two entries allow to discharge the assumptions in the auxiliary lemmas
       for the \verb|make| methods. Notice that the context has several entries for
       the methods \verb|Make_IID|, \verb|Append| and \verb|Flatten|.*}
constdefs flattenContext:: vdmcontext
"flattenContext \<equiv> {(DIAM\<bullet>Fill_DI ([RNarg x_, INarg tag_]), MS DIAM Fill_DI [RNarg x_, INarg tag_]),
                    (DIAM\<bullet>Fill_DIID ([RNarg x_, INarg tag_, INarg v0_, RNarg v1_]),
                         MS DIAM Fill_DIID [RNarg x_, INarg tag_, INarg v0_, RNarg v1_]),
                    (DIAM\<bullet>Make_I([VALarg (IVal 2)]), MS DIAM Make_I [VALarg (IVal 2)]),
                    (DIAM\<bullet>Make_IID([VALarg (IVal 3), INarg vv3_, RNarg l1_]), 
                         MS DIAM Make_IID [VALarg (IVal 3), INarg vv3_, RNarg l1_]),
                    (DIAM\<bullet>Make_IID([VALarg (IVal 3), INarg v4_, RNarg t_]),
                         MS DIAM Make_IID [VALarg (IVal 3), INarg v4_, RNarg t_]),
                    (DIAM\<bullet>Append([RNarg v2_,RNarg l2_]), MS DIAM Append [RNarg v2_,RNarg l2_]),
                    (DIAM\<bullet>Append([RNarg v1_, RNarg t_]), MS DIAM Append [RNarg v1_, RNarg t_]),
                    (DIAM\<bullet>Flatten ([RNarg v3_]), MS DIAM Flatten [RNarg v3_]),  
                    (DIAM\<bullet>Flatten ([RNarg v2_]), MS DIAM Flatten [RNarg v2_])}" 
text {*In this context, the bodies of the ''application methods'' \verb|Append|
       and \verb|Flatten| are now shown to satisfy their respective specifications --
       the usage of the additional context variable \verb|G| is a simple trick to
       allow the application of these lemmas as \verb|erules|.*}
lemma Append_Aux:
"\<lbrakk>appendSpec; make_I_Spec; make_IID_Spec; G = flattenContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Append) : 
                    (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Append)) x E' \<longrightarrow>
                                       MS DIAM Append x E' h hh v
                                          (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (simp add: Meth_Append)
apply (rule vdm_conseq)
apply (rule Call1, simp add: Fun_fAppend, safe)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_fzeroAppend)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_foneAppend)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
txt {*end of simple VCG*}
apply (simp add: IMPLIES_def appendSpec_def newframe_env_def evalARGS_def, clarsimp) apply(erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims, simp add: predicates) apply clarsimp
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def) apply (clarsimp)
txt {* end of extended vcg, now discharge the 2 side conditions*}
prefer 2
txt {*Case NIL*}
apply (erule mList.elims, simp_all)
apply (rule_tac x=X2 in exI, simp)
apply (subgoal_tac "X2 \<subseteq> Dom h", fast) apply (erule mListDom)
txt {*Case CONS*}
apply (erule mList.elims, simp_all, safe)
apply (erule_tac x=n in allE, erule_tac x=Ups2 in allE, erule_tac x=X in allE, erule_tac x=X2 in allE)
apply (erule impE, simp)
apply clarify
apply (simp add:  make_IID_Spec_def evalARGS_def)
apply clarsimp
apply (rotate_tac 1, erule thin_rl)
apply (simp add: predicates newObj_def)
apply clarify
apply (rule, rule)
apply (rule mListCONS, simp_all)
apply (subgoal_tac "freshloc (Dom h1) \<notin> Z", assumption) apply (erule mListFresh)
apply (rule mListSame, assumption) apply (rule SameExtend1) apply (erule mListFresh)
apply rule
txt {*this should have a MUCH shorter proof!*}
  apply (subgoal_tac "Dom ha \<subseteq> Dom h1") prefer 2 apply (erule SameImpliesDomsubset)
  apply (subgoal_tac "Z \<subseteq> Dom h1") prefer 2 apply (erule mListDom)
  apply rule apply rule prefer 2 apply fast
  apply (subgoal_tac "xa : (insert (freshloc (Dom h1)) Z) \<and> xa : Dom ha", clarsimp) 
  apply (subgoal_tac "freshloc (Dom h1) \<notin> Dom h1", fast) apply simp 
  apply simp
apply (rule SameTransitive, assumption)
apply (rule SameExtend1)  prefer 2  apply (erule SameImpliesDomsubset)
apply simp
done

lemma flatten_Aux:
"\<lbrakk>appendSpec; flattenSpec; make_I_Spec; make_IID_Spec; G = flattenContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Flatten) : 
                   (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Flatten)) x E' \<longrightarrow>
                                      MS DIAM Flatten x E' h hh v
                                        (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p)))) "
apply (simp add:  Meth_Flatten)
apply (rule vdm_conseq)
apply (rule Call1, simp add: Fun_fFlatten)
apply (rule vdmC_basics)+
apply (rule Call1, simp add: Fun_fzeroFlatten)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule Call1, simp add: Fun_foneFlatten)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp add: flattenContext_def)
apply (rule vdm_ax, simp add: flattenContext_def)
apply clarsimp
txt {*end of simple VCG*}
apply (simp add: flattenSpec_def newframe_env_def evalARGS_def, clarsimp) 
apply (rotate_tac 1, erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates) apply (simp add: valExpr_predicates)
apply (erule letElims, simp add: predicates)
apply clarsimp
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def, clarsimp)
txt {*end of extended VCG. Now discharge the 2 side conditions*}
prefer 2
txt {*Case LEAF*}
apply (simp add: make_I_Spec_def make_IID_Spec_def newframe_env_def evalARGS_def predicates newObj_def, clarsimp)
apply (erule thin_rl, erule thin_rl)
apply (erule mTree.elims, simp_all, clarsimp)
apply (rule, rule)
apply (rule mListCONS, simp_all)
prefer 2 apply (rule mListNIL, simp_all) 
txt {*Case NODE*}
apply (erule mTree.elims, simp_all, clarsimp)
  txt{*apply spec to first invocation*}
  apply (erule_tac x=n in allE, erule impE, rule , assumption, clarsimp)
  txt{* prove that second tree did not get destroyed during first invocation*}
  apply (subgoal_tac "(n, a2, X2, h1) \<in> mTree")
    prefer 2 
    apply (rule mTreeSame, assumption) apply (erule SameSubset) apply (erule mTreeDom)
  txt{*apply spec to second invocation*}
  apply (erule_tac x=n in allE, erule impE, rule , assumption, clarsimp)
  txt{* prove that the result list from the first invocation did not get destroyed during second invocation*}
  apply (subgoal_tac "(2 ^ n, aa, Z, h1a) \<in> mList")
    prefer 2 
    apply (rule mListSame, assumption) apply (erule SameSubset) apply (erule mListDom)
  txt{*now unfold and apply spec of append*}
  apply (simp add: appendSpec_def evalARGS_def) apply (rotate_tac 3, erule thin_rl)
  apply (erule_tac x="2 ^ n" in allE, erule_tac x="2 ^ n" in allE, erule_tac x=Z in allE,erule_tac x=Za in allE)
  apply (erule impE)  apply (rule, assumption) apply (rule, assumption) 
    apply (subgoal_tac "Z \<subseteq> Dom h1", fast) apply (erule mListDom)
  apply clarsimp
  apply (rule_tac x= Zb in exI)
  apply rule
  apply (subgoal_tac "(2::nat) ^ n + (2::nat) ^ n = (2::nat) * (2::nat) ^ n", simp) apply arith
  apply rule
  apply (subgoal_tac "Dom ha \<subseteq> Dom h1a \<inter> Dom h1", fast)
    apply (subgoal_tac "Dom ha \<subseteq> Dom h1")
    apply (subgoal_tac "Dom h1 \<subseteq> Dom h1a", fast)
    apply (erule SameImpliesDomsubset)
    apply (erule SameImpliesDomsubset)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTriv)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
done

text {*Now, the proof that \verb|flattenContext| is good follows from
       the auxiliary lemmas for all entries.*}
lemma flattenContext_good: 
"\<lbrakk>appendSpec; flattenSpec; fill_DI_Spec; make_I_Spec; fill_DIID_Spec; make_IID_Spec\<rbrakk>
 \<Longrightarrow> goodContext flattenContext"
apply (simp add: goodContext_def flattenContext_def) apply safe
(* Fill_DI*)
apply (erule Fill_DI_Aux)
(* Fill_DIID*)
apply (erule Fill_DIID_Aux)
(* Make_I*)
apply (erule Make_I_Aux, assumption, simp add: flattenContext_def)
(* Make_IID*)
apply (erule Make_IID_Aux, assumption, simp add: flattenContext_def)
apply (erule Make_IID_Aux, assumption, simp add: flattenContext_def)
(*Append*)
apply (erule Append_Aux, assumption, assumption, simp add: flattenContext_def)
apply (erule Append_Aux, assumption, assumption, simp add: flattenContext_def)
(* Flatten *)
apply (erule flatten_Aux, assumption, assumption, assumption, simp add: flattenContext_def)
apply (erule flatten_Aux, assumption, assumption, assumption, simp add: flattenContext_def)
done

text {*Finally, we prove that an invocation of \verb|flatten| satisifies the
       specification -- notice that the specification is fulfilled for ANY variable \verb|a|.*}
theorem
"\<lbrakk>appendSpec; flattenSpec; fill_DI_Spec; make_I_Spec; fill_DIID_Spec; make_IID_Spec\<rbrakk>
 \<Longrightarrow> \<rhd> DIAM\<bullet>Flatten([a]): MS DIAM Flatten [a]"
apply (rule GC)
apply (rule flattenContext_good)
apply (simp_all, simp_all add: InvContext_def flattenContext_def, auto)
done

text{*In particular an invocation with an integer parameter (ill-typed!) does satisfy
      the specification \verb|MS DIAM Flatten|:*}
lemma
"\<lbrakk>appendSpec; flattenSpec; fill_DI_Spec; make_I_Spec; fill_DIID_Spec; make_IID_Spec\<rbrakk>
 \<Longrightarrow> \<rhd> DIAM\<bullet>Flatten([INarg a]): MS DIAM Flatten [INarg a]"
apply (rule GC)
apply (rule flattenContext_good)
apply (simp_all, simp_all add: InvContext_def flattenContext_def, auto)
done 

text {*However, the specification for integer parameters is trivial:*}
lemma 
"\<lbrakk>flattenSpec\<rbrakk> \<Longrightarrow> MS DIAM Flatten [INarg a] = (\<lambda> E h hh v p . True)"
by (simp add: flattenSpec_def evalARGS_def)

text{*and so is a specification for a list of variables which is longer than one:*}
lemma "flattenSpec \<Longrightarrow> MS DIAM Flatten [RNarg a, RNarg b] = (\<lambda> E h hh v p . True)"
by (simp add: flattenSpec_def evalARGS_def)
(*<*)
end
(*>*)
