(*<*)
theory Flatten = mTreeList:
(*>*)

subsection{*Flattening a tree*}

text {* Camelot code:
\begin{verbatim}
  type itree = Leaf of int | Node of itree * itree
  type ilist = Nil | Cons of int * ilist

  let append l1 l2 = match l1 with Nil => l2
                                 | Cons(h,t) => Cons(h,append t l2)

  let flatten t = match t with Leaf(i) => Cons(i,Nil)
                             | Node(l,r) => append (flatten l) (flatten r)
\end{verbatim}
Grail code:
\begin{verbatim}
  method public static TreeList$dia_0 flatten (TreeList$dia_0 t) =
   let fun f:flatten(TreeList$dia_0 t) =
         let val v4 = getfield t <int TreeList$dia_0.$>
         in if v4 = 0
            then f:0(t)
            else f:1(t)
         end

       fun f:1(TreeList$dia_0 t) =
         let val v3 = getfield t <TreeList$dia_0 TreeList$dia_0.f1>
             val v2 = getfield t <TreeList$dia_0 TreeList$dia_0.f2>
             val v1 = invokestatic <TreeList$dia_0 TreeList.flatten (TreeList$dia_0)> (v3)
             val t = invokestatic <TreeList$dia_0 TreeList.flatten (TreeList$dia_0)> (v2)
         in invokestatic <TreeList$dia_0 TreeList.append (TreeList$dia_0, TreeList$dia_0)> (v1, t)
         end

       fun f:0(TreeList$dia_0 t) =
         let val v4 = getfield t <int TreeList$dia_0.f0>
             val t = invokestatic <TreeList$dia_0 TreeList$dia_0.make (int)> (2)
         in invokestatic <TreeList$dia_0 TreeList$dia_0.make (int, int, TreeList$dia_0)> (3, v4, t)
         end
   in f:flatten(t) end

  method public static TreeList$dia_0 append (TreeList$dia_0 l1, TreeList$dia_0 l2) =
   let fun f:append(TreeList$dia_0 l1, TreeList$dia_0 l2) =
         let val v3 = getfield l1 <int TreeList$dia_0.$>
         in if v3 = 2
            then f:0(l2)
            else f:1(l1, l2)
         end

       fun f:1(TreeList$dia_0 l1, TreeList$dia_0 l2) =
         let val v3 = getfield l1 <int TreeList$dia_0.f0>
             val v2 = getfield l1 <TreeList$dia_0 TreeList$dia_0.f1>
             val l1 = invokestatic <TreeList$dia_0 TreeList.append (TreeList$dia_0, TreeList$dia_0)> (v2, l2)
         in invokestatic <TreeList$dia_0 TreeList$dia_0.make (int, int, TreeList$dia_0)> (3, v3, l1)
         end

       fun f:0(TreeList$dia_0 l2) = l2
   in f:append(l1, l2) end
\end{verbatim}
*}

syntax b_  :: iname
       tag_ :: iname
       x_   :: rname
       t_   :: rname 
       v0_  :: iname  
       v1_  :: rname 
       v2_  :: rname 
       v3_  :: rname
       v4_  :: iname
 
       l1_  :: rname 
       l2_  :: rname 
       vv3_ :: iname

       fFlatten :: funame
       fzeroFlatten :: funame
       foneFlatten  :: funame
       Flatten :: mname

       fAppend :: funame
       fzeroAppend :: funame
       foneAppend  :: funame
       Append :: mname

translations
 "b_" == "(In ''b'') "
 "tag_" == "(In ''tag'') "
 "x_" == "(RN ''?x'') "
 "t_" == "(RN ''t'') "
 "v0_" == "(In ''v0'') "
 "v1_" == "(RN ''v1'') "
 "v2_" == "(RN ''v2'') "
 "v3_" == "(RN ''v3'') "
 "v4_" == "(In ''v4'') "
 "l1_" == "(RN ''l1'') "
 "l2_" == "(RN ''l2'') "
 "vv3_" == "(In ''vv3'') "
 "fFlatten" == "(FN ''fFlatten'') "
 "fzeroFlatten" == "(FN ''f_zeroFlatten'')"
 "foneFlatten" == "(FN ''f_oneFlatten'')"
 "Flatten" == "(MN ''Flatten'')"
 "fAppend" == "(FN ''fAppend'') "
 "fzeroAppend" == "(FN ''f_zeroAppend'')"
 "foneAppend" == "(FN ''f_oneAppend'')"
 "Append" == "(MN ''Append'')"

axioms Meth_Flatten: 
"methtable DIAM Flatten = ([RNpar t_], CALL fFlatten)"

axioms Fun_fFlatten:
"funtable fFlatten = LET v4_ = GetFi t_ DOLLAR;
                          b_ = Primop (\<lambda> z y. if z = 0 then 1 else 0) v4_ v4_
                     IN IF b_ THEN CALL fzeroFlatten ELSE CALL foneFlatten END"
axioms Fun_fzeroFlatten:
"funtable fzeroFlatten = LET v4_ = GetFi t_ F0;
                           tag_ = expr.Int 2;
                          rf t_ = NEW <DIAM> ([],[]); (*alloc*)
                              _ = PutFi t_ DOLLAR tag_;

                           tag_ = expr.Int 3;
                            v0_ = IVar v4_;
                         rf v1_ = RVar t_;
                          rf x_ = NEW <DIAM> ([],[]); (*alloc*)
                              _ = PutFi x_ DOLLAR tag_;
                              _ = PutFi x_ F0 v0_;
                              _ = PutFr x_ F1 v1_
                         IN RVar x_ END"

axioms Fun_foneFlatten:
"funtable foneFlatten = LET rf v3_ = GetFr t_ F1;
                            rf v2_ = GetFr t_ F2;
                            rf v1_ = DIAM\<bullet>Flatten ([RNarg v3_]);
                             rf t_ = DIAM\<bullet>Flatten ([RNarg v2_])
                        IN DIAM\<bullet>Append ([RNarg v1_,RNarg t_]) END"

axioms Meth_Append: 
"methtable DIAM Append = ([RNpar l1_, RNpar l2_], CALL fAppend)"

axioms Fun_fAppend:
"funtable fAppend = LET vv3_ = GetFi l1_ DOLLAR;
                         b_ = Primop (\<lambda> z y. if z = 2 then 1 else 0) vv3_ vv3_
                    IN IF b_ THEN CALL fzeroAppend ELSE CALL foneAppend END"

axioms Fun_fzeroAppend:
"funtable fzeroAppend = RVar l2_"

axioms Fun_foneAppend:
"funtable foneAppend = LET vv3_ = GetFi l1_ F0;
                         rf v2_ = GetFr l1_ F1;
                         rf l1_ = DIAM\<bullet>Append([RNarg v2_, RNarg l2_]);

                           tag_ = expr.Int 3;
                          rf x_ = NEW <DIAM> ([],[]);(*alloc*)
                              _ = PutFi x_ DOLLAR tag_;
                              _ = PutFi x_ F0 vv3_;
                              _ = PutFr x_ F1 l1_
                       IN RVar x_ END"

text {*Auxiliary lemmas on fresh locations.*}
lemma freshlocInsert1[simp, rule_format]: 
"\<forall> h . freshloc (Dom h) \<noteq> freshloc (insert (freshloc (Dom h)) (Dom h))"
apply clarsimp
apply (subgoal_tac "freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> insert (freshloc (Dom h)) (Dom h)")
apply (subgoal_tac "freshloc (Dom h) : insert (freshloc (Dom h)) (Dom h)")
prefer 2 apply simp
prefer 2 apply (rule freshloc, fast)
apply auto
done

lemma freshlocInsert2[simp]: 
"fmap_lookup (oheap h(freshloc (Dom h)\<mapsto>\<^sub>fC)(freshloc (insert (freshloc (Dom h)) (Dom h))\<mapsto>\<^sub>fC)) (freshloc (Dom h)) = Some C"
by (simp add: FMAPlookup3)

lemma freshlocInsert3[simp]: 
"freshloc (insert (freshloc (Dom h)) (Dom h)) \<noteq> freshloc (Dom h)"
by (insert freshlocInsert1 [of h], fastsimp)

lemma freshlocInsert4[simp]: 
"freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> Dom h"
apply (subgoal_tac "freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> (insert (freshloc (Dom h)) (Dom h))")
apply (subgoal_tac "Dom h \<subseteq> insert (freshloc (Dom h)) (Dom h)", fast, fast, rule freshloc, fast)
done

lemma freshlocInsert5[simp]:
   "same (Dom h)  h \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM)(freshloc (insert (freshloc (Dom h)) (Dom h))\<mapsto>\<^sub>fDIAM),
                     iheap = (iheap h)
                      (DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := 2, freshloc (insert (freshloc (Dom h)) (Dom h)) := 3),
                       F0 := (iheap h F0)(freshloc (insert (freshloc (Dom h)) (Dom h)) := h<a\<bullet>F0>)),
                     rheap = (rheap h)(F1 := (rheap h F1)(freshloc (insert (freshloc (Dom h)) (Dom h)) := Ref (freshloc (Dom h)))),
                     sheap = sheap h\<rparr>"
by (simp add: same_def sameOH_def FMAPlookup3) 

subsubsection{*Verification of append*}
text {*We first show the verification of $\verb|append|$ in isolation.*}
constdefs appendSpec::bool
"appendSpec == (MS DIAM Append = 
     (\<lambda> args E h hh v p. 
        (\<forall> l1 l2 Ups1 Ups2 ll1 ll2 X1 X2. (args =[RNarg l1,RNarg l2] \<and> 
                                     E\<lfloor>l1\<rfloor> = Ref ll1 \<and> (Ups1,ll1,X1,h): mList \<and> 
                                     E\<lfloor>l2\<rfloor> = Ref ll2 \<and> (Ups2,ll2,X2,h): mList \<and> X1 \<inter> X2 = {}) \<longrightarrow> 
                                    (\<exists> a Z . v = RVal (Ref a) \<and> (Ups1+Ups2,a,Z,hh):mList \<and> 
                                             (Z \<inter> Dom h) = X2 \<and> same (Dom h) h hh))))"

lemma appendVDMcontext:
"appendSpec \<Longrightarrow> goodContext {(DIAM\<bullet>Append([RNarg v2_,RNarg l2_]), MS DIAM Append [RNarg v2_,RNarg l2_])}"
apply (simp add: goodContext_def) apply clarsimp 
apply (simp add: Meth_Append)
apply (rule vdm_conseq)
apply (rule Call1)
apply (simp add: Fun_fAppend, safe)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: Fun_fzeroAppend)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: Fun_foneAppend)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp)
apply (rule vdmC_basics)+

txt {*end of simple VCG*}

apply (simp add: IMPLIES_def appendSpec_def newframe_env_def evalARGS_def, clarsimp) apply(erule thin_rl)
apply (erule letElims, simp add: predicates)
apply (erule letElims, simp add: predicates, simp add: predicates)
apply (erule letElims, simp add: predicates) apply clarsimp
prefer 2
apply clarsimp
apply (erule letElims, simp add: predicates)
apply (erule letElims, simp add: predicates)
apply (simp add: letrComb_def) apply (clarsimp)
apply (erule letElims)
apply (erule letElims, simp add: predicates)
apply (erule letElims, simp add: predicates)
apply (erule letElims, simp add: predicates)
apply (erule letElims, simp add: predicates)
apply (erule primElims, simp add: predicates newObj_def)

txt {* end of extended vcg, now discharge the 2 side conditions*}

prefer 2
apply (erule mList.elims, simp_all)
apply (rule_tac x=X2 in exI, simp)
apply (subgoal_tac "X2 \<subseteq> Dom h", fast) apply (erule mListDom)

txt {*Case CONS*}

apply (erule mList.elims, simp_all, safe)
apply (erule_tac x=n in allE)
apply (erule_tac x=Ups2 in allE) 
apply (erule_tac x=X in allE)
apply (erule_tac x=X2 in allE)
apply (erule impE, simp)
apply clarsimp
apply (rule, rule)
apply (rule mListCONS, simp_all)
apply (subgoal_tac "freshloc (Dom h1) \<notin> Z", assumption) apply (erule mListFresh)
apply (rule mListSame, assumption) apply (rule SameExtend1) apply (erule mListFresh)
apply rule
txt {*this should have a MUCH shorter proof!*}
  apply (subgoal_tac "Dom ha \<subseteq> Dom h1") prefer 2 apply (erule SameImpliesDomsubset)
  apply (subgoal_tac "Z \<subseteq> Dom h1") prefer 2 apply (erule mListDom)
  apply rule apply rule prefer 2 apply fast
  apply (subgoal_tac "x : (insert (freshloc (Dom h1)) Z) \<and> x : Dom ha", clarsimp) 
  apply (subgoal_tac "freshloc (Dom h1) \<notin> Dom h1", fast) apply simp 
  apply simp
apply (rule SameTransitive, assumption)
apply (rule SameExtend1)  prefer 2  apply (erule SameImpliesDomsubset)
apply simp
done

subsubsection {*Verification of flatten*}
constdefs flattenSpec::bool
"flattenSpec == (MS DIAM Flatten = 
     (\<lambda> args E h hh v p. 
        (\<forall> t Ups ll X. (args =[RNarg t] \<and> E\<lfloor>t\<rfloor> = Ref ll \<and> (Ups,ll,X,h): mTree) \<longrightarrow>
                        (\<exists> a Z . v = RVal (Ref a) \<and> (2 ^ Ups,a,Z,hh):mList \<and> (Z \<inter> Dom h) = {} \<and> same (Dom h) h hh))))"


constdefs flattenContext:: vdmcontext
"flattenContext \<equiv> {(DIAM\<bullet>Append([RNarg v2_,RNarg l2_]), MS DIAM Append [RNarg v2_,RNarg l2_]), 
                   (DIAM\<bullet>Append([RNarg v1_, RNarg t_]), MS DIAM Append [RNarg v1_, RNarg t_]),
                   (DIAM\<bullet>Flatten ([RNarg v3_]), MS DIAM Flatten [RNarg v3_]),
                   (DIAM\<bullet>Flatten ([RNarg v2_]), MS DIAM Flatten [RNarg v2_])}"

lemma flattenContext_good: "\<lbrakk>appendSpec; flattenSpec\<rbrakk> \<Longrightarrow> goodContext flattenContext"
apply (simp add: goodContext_def flattenContext_def) apply safe
apply (simp add: Meth_Append)
apply (rule vdm_conseq)
apply (rule Call1)
apply (simp add: Fun_fAppend, safe)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: Fun_fzeroAppend)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: Fun_foneAppend)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp)
apply (rule vdmC_basics)+
defer 1
apply (simp add: Meth_Append)
apply (rule vdm_conseq)
apply (rule Call1)
apply (simp add: Fun_fAppend, safe)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: Fun_fzeroAppend)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: Fun_foneAppend)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp)
apply (rule vdmC_basics)+
defer 1
(*unroll flatten*)
apply (simp add: Meth_Flatten)
apply (rule vdm_conseq)
apply (rule Call1)
apply (simp add: Fun_fFlatten, safe)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: Fun_fzeroFlatten)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: Fun_foneFlatten)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp)
apply (rule vdm_ax, simp)
defer 1
apply (simp add: Meth_Flatten)
apply (rule vdm_conseq)
apply (rule Call1)
apply (simp add: Fun_fFlatten, safe)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: Fun_fzeroFlatten)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: Fun_foneFlatten)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp)
apply (rule vdm_ax, simp)
defer 1
(*end of VCG*)
(*first elimination for append*)
apply (simp add: IMPLIES_def appendSpec_def newframe_env_def evalARGS_def, clarsimp) apply(erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates) apply clarsimp
apply (erule primElims, simp add: valExpr_predicates)
apply clarsimp
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def) apply (clarsimp)
apply (erule letElims)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule primElims, simp add: valExpr_predicates newObj_def)
apply clarsimp
(* end of extended vcg, now discharge the 2 side conditions*)
prefer 2
apply (erule mList.elims, simp_all)
apply (rule_tac x=X2 in exI, simp)
apply (subgoal_tac "X2 \<subseteq> Dom h", fast) apply (erule mListDom)
(*Case CONS*)
apply (erule mList.elims, simp_all, safe)
apply (erule_tac x=n in allE)
apply (erule_tac x=Ups2 in allE) 
apply (erule_tac x=X in allE)
apply (erule_tac x=X2 in allE)
apply (erule impE, simp)
apply clarsimp
apply (rule, rule)
apply (rule mListCONS, simp_all)
apply (subgoal_tac "freshloc (Dom h1) \<notin> Z", assumption) apply (erule mListFresh)
apply (rule mListSame, assumption) apply (rule SameExtend1) apply (erule mListFresh)
apply rule
(*this should have a MUCH shorter proof!*)
  apply (subgoal_tac "Dom ha \<subseteq> Dom h1") prefer 2 apply (erule SameImpliesDomsubset)
  apply (subgoal_tac "Z \<subseteq> Dom h1") prefer 2 apply (erule mListDom)
  apply rule apply rule prefer 2 apply fast
  apply (subgoal_tac "x : (insert (freshloc (Dom h1)) Z) \<and> x : Dom ha", clarsimp) 
  apply (subgoal_tac "freshloc (Dom h1) \<notin> Dom h1", fast) apply simp 
  apply simp
apply (rule SameTransitive, assumption)
apply (rule SameExtend1)  prefer 2  apply (erule SameImpliesDomsubset)
apply simp
(*second elimination for append (same proof) *)
apply (simp add: IMPLIES_def appendSpec_def newframe_env_def evalARGS_def, clarsimp) apply(erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates) apply clarsimp
apply (erule primElims, simp add: valExpr_predicates)
apply clarsimp
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def) apply (clarsimp)
apply (erule letElims)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule primElims, simp add: valExpr_predicates newObj_def)
apply clarsimp
(* end of extended vcg, now discharge the 2 side conditions*)
prefer 2
apply (erule mList.elims, simp_all)
apply (rule_tac x=X2 in exI, simp)
apply (subgoal_tac "X2 \<subseteq> Dom h", fast) apply (erule mListDom)
(*Case CONS*)
apply (erule mList.elims, simp_all, safe)
apply (erule_tac x=n in allE)
apply (erule_tac x=Ups2 in allE) 
apply (erule_tac x=X in allE)
apply (erule_tac x=X2 in allE)
apply (erule impE, simp)
apply clarsimp
apply (rule, rule)
apply (rule mListCONS, simp_all)
apply (subgoal_tac "freshloc (Dom h1) \<notin> Z", assumption) apply (erule mListFresh)
apply (rule mListSame, assumption) apply (rule SameExtend1) apply (erule mListFresh)
apply rule
(*this should have a MUCH shorter proof!*)
  apply (subgoal_tac "Dom ha \<subseteq> Dom h1") prefer 2 apply (erule SameImpliesDomsubset)
  apply (subgoal_tac "Z \<subseteq> Dom h1") prefer 2 apply (erule mListDom)
  apply rule apply rule prefer 2 apply fast
  apply (subgoal_tac "x : (insert (freshloc (Dom h1)) Z) \<and> x : Dom ha", clarsimp) 
  apply (subgoal_tac "freshloc (Dom h1) \<notin> Dom h1", fast) apply simp 
  apply simp
apply (rule SameTransitive, assumption)
apply (rule SameExtend1)  prefer 2  apply (erule SameImpliesDomsubset)
apply simp

(*first elimination for flatten*)
apply (simp add: IMPLIES_def flattenSpec_def newframe_env_def evalARGS_def, clarsimp) apply(rotate_tac 1, erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims)
(*first branch*)
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule primElims, simp add: valExpr_predicates newObj_def, clarsimp)
prefer 2
(*second branch*)
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def, clarsimp)
(* end of extended vcg, now discharge the 2 side conditions*)
prefer 2
(*Case Leaf*)
apply (erule mTree.elims, simp_all, clarsimp)
apply (rule, rule)
apply (rule mListCONS, simp_all)
prefer 2
  apply (rule mListNIL, simp_all) 
(*Case Node*)
apply (erule mTree.elims, simp_all, clarsimp)
  (*apply spec to first invocation*)
  apply (erule_tac x=n in allE, erule impE, rule , assumption, clarsimp)
  (* prove that second tree did not get destroyed during first invocation*)
  apply (subgoal_tac "(n, a2, X2, h1) \<in> mTree")
    prefer 2 
    apply (rule mTreeSame, assumption) apply (erule SameSubset) apply (erule mTreeDom)
  (*apply spec to second invocation*)
  apply (erule_tac x=n in allE, erule impE, rule , assumption, clarsimp)
  (* prove that the result list from the first invocation did not get destroyed during second invocation*)
  apply (subgoal_tac "(2 ^ n, aa, Z, h1a) \<in> mList")
    prefer 2 
    apply (rule mListSame, assumption) apply (erule SameSubset) apply (erule mListDom)
  (*now unfold and apply spec of append*)
  apply (simp add: appendSpec_def) apply (rotate_tac 1, erule thin_rl)
  apply (erule_tac x="2 ^ n" in allE, erule_tac x="2 ^ n" in allE, erule_tac x=Z in allE,erule_tac x=Za in allE)
  apply (erule impE) apply (rule, assumption) apply (rule, assumption) 
    apply (subgoal_tac "Z \<subseteq> Dom h1", fast) apply (erule mListDom)
  apply clarsimp
  apply (rule_tac x= Zb in exI)
  apply rule
  apply (subgoal_tac "(2::nat) ^ n + (2::nat) ^ n = (2::nat) * (2::nat) ^ n", simp) apply arith
  apply rule
  apply (subgoal_tac "Dom ha \<subseteq> Dom h1a \<inter> Dom h1", fast)
    apply (subgoal_tac "Dom ha \<subseteq> Dom h1")
    apply (subgoal_tac "Dom h1 \<subseteq> Dom h1a", fast)
    apply (erule SameImpliesDomsubset)
    apply (erule SameImpliesDomsubset)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTriv)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
  
(*second elimination for flatten*)
apply (simp add: IMPLIES_def flattenSpec_def newframe_env_def evalARGS_def, clarsimp) apply(rotate_tac 1, erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims)
(*first branch*)
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule primElims, simp add: valExpr_predicates newObj_def, clarsimp)
prefer 2
(*second branch*)
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letrComb_def, clarsimp)
(* end of extended vcg, now discharge the 2 side conditions*)
prefer 2
(*Case Leaf*)
apply (erule mTree.elims, simp_all, clarsimp)
apply (rule, rule)
apply (rule mListCONS, simp_all)
prefer 2
  apply (rule mListNIL, simp_all) 
(*Case Node*)
apply (erule mTree.elims, simp_all, clarsimp)
  (*apply spec to first invocation*)
  apply (erule_tac x=n in allE, erule impE, rule , assumption, clarsimp)
  (* prove that second tree did not get destroyed during first invocation*)
  apply (subgoal_tac "(n, a2, X2, h1) \<in> mTree")
    prefer 2 
    apply (rule mTreeSame, assumption) apply (erule SameSubset) apply (erule mTreeDom)
  (*apply spec to second invocation*)
  apply (erule_tac x=n in allE, erule impE, rule , assumption, clarsimp)
  (* prove that the result list from the first invocation did not get destroyed during second invocation*)
  apply (subgoal_tac "(2 ^ n, aa, Z, h1a) \<in> mList")
    prefer 2 
    apply (rule mListSame, assumption) apply (erule SameSubset) apply (erule mListDom)
  (*now unfold and apply spec of append*)
  apply (simp add: appendSpec_def) apply (rotate_tac 1, erule thin_rl)
  apply (erule_tac x="2 ^ n" in allE, erule_tac x="2 ^ n" in allE, erule_tac x=Z in allE,erule_tac x=Za in allE)
  apply (erule impE) apply (rule, assumption) apply (rule, assumption) 
    apply (subgoal_tac "Z \<subseteq> Dom h1", fast) apply (erule mListDom)
  apply clarsimp
  apply (rule_tac x= Zb in exI)
  apply rule
  apply (subgoal_tac "(2::nat) ^ n + (2::nat) ^ n = (2::nat) * (2::nat) ^ n", simp) apply arith
  apply rule
  apply (subgoal_tac "Dom ha \<subseteq> Dom h1a \<inter> Dom h1", fast)
    apply (subgoal_tac "Dom ha \<subseteq> Dom h1")
    apply (subgoal_tac "Dom h1 \<subseteq> Dom h1a", fast)
    apply (erule SameImpliesDomsubset)
    apply (erule SameImpliesDomsubset)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTransitive, assumption)
  apply (rule SameTriv)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
  apply (erule SameImpliesDomsubset)
done

lemma singleFlattenGood:
"\<lbrakk>appendSpec; flattenSpec\<rbrakk> \<Longrightarrow> goodContext {(DIAM\<bullet>Flatten ([RNarg v2_]), MS DIAM Flatten [RNarg v2_])}"
apply (rule GoodContextCut1)
apply (subgoal_tac "goodContext {(DIAM\<bullet>Flatten ([RNarg v3_]), MS DIAM Flatten [RNarg v3_]),
                                 (DIAM\<bullet>Flatten ([RNarg v2_]), MS DIAM Flatten [RNarg v2_])}", assumption)
apply (rule GoodContextCut1)
apply (subgoal_tac "goodContext {(DIAM\<bullet>Append([RNarg v1_, RNarg t_]), MS DIAM Append [RNarg v1_, RNarg t_]),
                                 (DIAM\<bullet>Flatten ([RNarg v3_]), MS DIAM Flatten [RNarg v3_]),
                                 (DIAM\<bullet>Flatten ([RNarg v2_]), MS DIAM Flatten [RNarg v2_])}", assumption)
apply (rule GoodContextCut1)
apply (subgoal_tac "goodContext flattenContext", assumption)
apply (erule flattenContext_good, assumption)
apply (subgoal_tac "(DIAM\<bullet>Append([RNarg v2_,RNarg l2_]), MS DIAM Append [RNarg v2_,RNarg l2_]): flattenContext", assumption, simp add: flattenContext_def)
apply (simp add: flattenContext_def)
apply (subgoal_tac "(DIAM\<bullet>Append([RNarg v1_, RNarg t_]), MS DIAM Append [RNarg v1_, RNarg t_]) \<in> {(DIAM\<bullet>Append([RNarg v1_, RNarg t_]), MS DIAM Append [RNarg v1_, RNarg t_]), (DIAM\<bullet>Flatten([RNarg v3_]), MS DIAM Flatten [RNarg v3_]),
          (DIAM\<bullet>Flatten([RNarg v2_]), MS DIAM Flatten [RNarg v2_])}", assumption, simp)
apply simp
apply (subgoal_tac "(DIAM\<bullet>Flatten([RNarg v3_]), MS DIAM Flatten [RNarg v3_]) \<in> {(DIAM\<bullet>Flatten([RNarg v3_]), MS DIAM Flatten [RNarg v3_]),
          (DIAM\<bullet>Flatten([RNarg v2_]), MS DIAM Flatten [RNarg v2_])}", assumption, simp)
apply simp
done

text {*It may be surprising to see that the specification is fulfilled dor ANY variable a*}
lemma "\<lbrakk>appendSpec; flattenSpec\<rbrakk> \<Longrightarrow> \<rhd> DIAM\<bullet>Flatten([a]): MS DIAM Flatten [a]"
by (rule EmptyProof, insert singleFlattenGood, fast)

text{*In particular an invocation with an integer parameter (ill-typed!) does satisfy
      the specification MS DIAM FLATTEN:*}
lemma "\<lbrakk>appendSpec; flattenSpec\<rbrakk> \<Longrightarrow> \<rhd> DIAM\<bullet>Flatten([INarg a]): MS DIAM Flatten [INarg a]"
by (rule EmptyProof, insert singleFlattenGood, fast)

text {*However, the specification for integer variables is trivial:*}
lemma "flattenSpec \<Longrightarrow> MS DIAM Flatten [INarg a] = (\<lambda> E h hh v p . True)"
by (simp add: flattenSpec_def)

text{*and so is a specification for a list of variables which is longer than one:*}
lemma "flattenSpec \<Longrightarrow> MS DIAM Flatten [RNarg a, RNarg b] = (\<lambda> E h hh v p . True)"
by (simp add: flattenSpec_def)
(*<*)
end
(*>*)
