theory Eat_TCO = DAss_rulesU:

(*DAssAdaptU currently not needed (will  contain the proof of the ADAPT lemma below*)

subsection{*Insertion into list*)Reverse function with free*}

text {* Camelot code:
\begin{verbatim}
type ilist = !Nil | Cons of int * ilist
let eat l = match l with Nil -> () | Cons(_,t)@_ -> eat t
\end{verbatim}

Grail code: (with tail-call optimisation switsched ON*)
\begin{verbatim}
method static public void eat (InsSort$dia_0 l) =
  let fun f:eat(InsSort$dia_0 l) =
         if l = null[InsSort$dia_0] then f:0() else f:1(l)

      fun f:1(InsSort$dia_0 l) =
      let val v2 = getfield l <int InsSort$dia_0.f1>
          val v1 = getfield l <InsSort$dia_0 InsSort$dia_0.f0>
          val () = invokestatic <void InsSort$dia_0.free (InsSort$dia_0)> (l)
          val l = v1
      in  f:eat(l) end

      fun f:0() = ()
   in f:eat(l)
   end
\end{verbatim}
*}

syntax b_    :: iname
       v3_   :: iname
       v2_   :: rname
       l_    :: rname 

       fEat :: funame
       fzeroEat :: funame
       foneEat :: funame
       Eat :: mname

translations
 "b_" == "(In ''b'') "
 "v3_" == "(In ''v3'') "
 "v2_" == "(RN ''v2'') "
 "l_" == "(RN ''l'') "
 "fEat" == "(FN ''fEat'') "
 "fzeroEat" == "(FN ''f_zeroEat'')"
 "foneEat" == "(FN ''f_oneEat'')"
 "Eat" == "(MN ''Eat'')"

axioms Meth_Eat: 
"methtable DIAM Eat = ([RNpar l_], CALL fEat)"
lemma "methtable DIAM Eat = ([RNpar l_], CALL fEat)" by (simp add: Meth_Eat)

axioms Fun_fEat:
"funtable fEat = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                    IN IF b_ THEN CALL fzeroEat ELSE CALL foneEat END"
lemma "funtable fEat = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                    IN IF b_ THEN CALL fzeroEat ELSE CALL foneEat END"
by (simp add: Fun_fEat)

(*I am cheating here - null is not the correct value*)
axioms Fun_fzeroEat:
"funtable fzeroEat = Null"
lemma  "funtable fzeroEat = Null"
by (simp add: Fun_fzeroEat)

axioms Fun_foneEat:
"funtable foneEat =
       LET v3_ = GetFi l_ F0;
        rf v2_ = GetFr l_ F1;
             _ = DIAM\<bullet>Free ([RNarg l_]);
         rf l_ = RVar v2_
       IN CALL fEat END"
lemma "funtable foneEat =
       LET v3_ = GetFi l_ F0;
        rf v2_ = GetFr l_ F1;
             _ = DIAM\<bullet>Free ([RNarg l_]);
         rf l_ = RVar v2_
       IN CALL fEat END"
by (simp add: Fun_foneEat)

text {*Here is what Steffen's analysis claims:
 \begin{verbatim}
  eat        : 0, iList[0|int,#,0] -> unit, 0
 \end<verbatim} *}

text {*This corresponds to the following specifications, formalised from the viewpoint of the
       method bodies: the contexts (in second parameter of @{text DAss}) are the contexts in which
       the method bodies are typed*}
constdefs Eat_Spec::vdmassn
"Eat_Spec == DAss {l_} 0 (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0))) (ListET 0) 0"

text {*In order to prove the body correct we define a context with an entry for the method, 
       plus one for the recursively called function - which has the same spec since its free
       variables are the method parameters and DAss is independent from cost component p!*}
constdefs  EatContext:: vdmcontext
"EatContext \<equiv> {(DIAM\<bullet>Eat([RNarg l_]), Eat_Spec), (Call fEat, Eat_Spec)}"

text {*We first prove the claim for the function fEat - again, the lemma is
       formalised for the function body (not the function call), in preparation
       for the goodContext-lemma.*}
lemma fEat_DAss:
"\<lbrakk>G = EatContext\<rbrakk> \<Longrightarrow> G \<rhd> (funtable fEat) : Eat_Spec"
apply (simp add: Eat_Spec_def Fun_fEat, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*first branch*)
apply (rule DA_Call)
apply (simp only: Fun_fzeroEat)
apply (rule DA_Null) apply (simp, simp)
(*second branch*)
apply (rule DA_Call)
apply (simp only:  Fun_foneEat)
apply (rule DA_MatchD) apply (simp add: GETr_def) apply simp 
apply (rule DA_Letr)
apply (rule DA_RVar)
apply (simp add: GETr_def)
defer 1
(*recursive call to fEat*)
apply (rule vdm_conseq)
apply (rule vdm_ax)
apply simp apply (simp add: EatContext_def) apply (simp add: Eat_Spec_def, clarsimp)
   apply(rule DAss_EnvsContexts_same_on_U2)
  prefer 3 apply assumption
  apply clarsimp
  apply (simp add: GETr_def)
(*recursive call to fEat now finished*) 
apply (simp add: DOM_def)
apply fastsimp+
done

text {*The claim regarding the method Eat follows essentially from the previous lemma.*} 
lemma Eat_DAss:
"\<lbrakk>G = EatContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable DIAM Eat) : Eat_Spec"
apply (simp add: Meth_Eat)
apply (rule vdm_conseq)
apply (rule DA_Call)
apply (insert fEat_DAss, simp add: Eat_Spec_def)
apply (rule CtxtWeakSingleton, fast)
apply (simp add: Eat_Spec_def)
done

text {*We require the specification table at method @{text Eat} to contain entries
       which relate to the assertion @{text Eat_Spec}, and the function to the
       spec of the body -- it is the top level function in that method!.*}
constdefs EatTable::bool
"EatTable == 
  (MS DIAM Eat = (\<lambda> args E h hh v p . Eat_Spec (newframe_env Nullref (fst (methtable DIAM Eat)) args E) h hh v p)) \<and>
  (spectable fEat = Eat_Spec)"

lemma Eat_Spec_Framecorrect: "EatTable \<Longrightarrow> MS DIAM Eat [RNarg l_] = Eat_Spec"
apply (simp add: EatTable_def Meth_Eat newframe_env_def evalARGS_def)
apply (rule, rule, rule, rule, rule, simp add: Eat_Spec_def)
apply (rule DAss_Envs_same_on_U)
apply (simp_all add: DOM_def)
done
text{*The proofs use lemma @{text DAss_Envs_same_on_U}*}

text {*For a specification table satisfying EatSortTable, \verb|EatSortContext| is a good context.*}
lemma EatContext_good: "EatTable \<Longrightarrow> goodContext EatContext"
apply (simp add: goodContext_def EatContext_def, safe)
(*Eat*)
apply (simp add:  Eat_Spec_Framecorrect)
apply (rule vdm_conseq)
apply (rule Eat_DAss)
apply (simp add: EatContext_def)
apply clarsimp
apply (simp add: EatTable_def Eat_Spec_def)
apply (rule DAss_PConst)
apply (simp add: Eat_Spec_def)
(*fEat*)
apply (simp add:  EatTable_def)
apply (rule vdm_conseq)
apply (rule fEat_DAss)
apply (simp add: EatContext_def)
apply clarsimp
apply (simp add: EatTable_def Eat_Spec_def)
apply (rule DAss_PConst)
apply (simp)
done
text {*The proof contains two parts, one for the method Eat and one for the function fEat.
       Both follow easily from the above lemmas Eat_DAss and fEat_DAss.*}

text {*Thus, we can prove that arbitrary invocations of @{text Eat} honour
       the specifications in the empty VDM context.*}
theorem "\<lbrakk>EatTable\<rbrakk> \<Longrightarrow> \<rhd> DIAM\<bullet>Eat([RNarg x]): MS DIAM Eat [RNarg x]"
apply (rule GCInvs)
apply (erule EatContext_good)
apply (simp_all add: EatContext_def)
apply (rule, simp)
apply (insert Eat_Spec_Framecorrect, fastsimp)
done 

end
