theory Eat = DAss_rulesU:

(*DAssAdaptU currently not needed (will  contain the proof of the ADAPT lemma below*)

subsection{*Insertion into list*)Reverse function with free*}

text {* Camelot code:
\begin{verbatim}
type ilist = !Nil | Cons of int * ilist
let eat l = match l with Nil -> () | Cons(_,t)@_ -> eat t
\end{verbatim}

Grail code:
\begin{verbatim}
method static public void eat (InsSort$dia_0 l) =
  let fun f:eat(InsSort$dia_0 l) =
         if l = null[InsSort$dia_0] then f:0() else f:1(l)

      fun f:1(InsSort$dia_0 l) =
      let val v2 = getfield l <int InsSort$dia_0.f1>
          val v1 = getfield l <InsSort$dia_0 InsSort$dia_0.f0>
          val () = invokestatic <void InsSort$dia_0.free (InsSort$dia_0)> (l)
      in invokestatic <void InsSort.eat (InsSort$dia_0)> (v1)
      end

      fun f:0() = ()
   in f:eat(l)
   end
\end{verbatim}
*}

syntax b_    :: iname
       v3_   :: iname
       v2_   :: rname
       l_    :: rname 

       fEat :: funame
       fzeroEat :: funame
       foneEat :: funame
       Eat :: mname

translations
 "b_" == "(In ''b'') "
 "v3_" == "(In ''v3'') "
 "v2_" == "(RN ''v2'') "
 "l_" == "(RN ''l'') "
 "fEat" == "(FN ''fEat'') "
 "fzeroEat" == "(FN ''f_zeroEat'')"
 "foneEat" == "(FN ''f_oneEat'')"
 "Eat" == "(MN ''Eat'')"

axioms Meth_Eat: 
"methtable DIAM Eat = ([RNpar l_], CALL fEat)"
lemma "methtable DIAM Eat = ([RNpar l_], CALL fEat)" by (simp add: Meth_Eat)

axioms Fun_fEat:
"funtable fEat = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                    IN IF b_ THEN CALL fzeroEat ELSE CALL foneEat END"
lemma "funtable fEat = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                    IN IF b_ THEN CALL fzeroEat ELSE CALL foneEat END"
by (simp add: Fun_fEat)

(*I am cheating here - null is not the correct value*)
axioms Fun_fzeroEat:
"funtable fzeroEat = Null"
lemma  "funtable fzeroEat = Null"
by (simp add: Fun_fzeroEat)

axioms Fun_foneEat:
"funtable foneEat =
       LET v3_ = GetFi l_ F0;
        rf v2_ = GetFr l_ F1;
             _ = DIAM\<bullet>Free ([RNarg l_])
       IN DIAM\<bullet>Eat ([RNarg v2_]) END"
lemma "funtable foneEat =
       LET v3_ = GetFi l_ F0;
        rf v2_ = GetFr l_ F1;
             _ = DIAM\<bullet>Free ([RNarg l_])
       IN DIAM\<bullet>Eat ([RNarg v2_]) END"
by (simp add: Fun_foneEat)

text {*Here is what Steffen's analysis claims:
 \begin{verbatim}
  eat        : 0, int -> iList[0|int,#,0] -> iList[0|int,#,0], 0
 \end<verbatim} *}

text {*This corresponds to the following specifications, formalised from the viewpoint of the
       method bodies: the contexts (in second parameter of @{text DAss}) are the contexts in which
       the method bodies are typed*}
constdefs Eat_Spec::vdmassn
"Eat_Spec == DAss {l_} 0 (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0))) (ListET 0) 0"

text {*In order to prove the body correct we define a context which contaeat an single entry for each method.*}
constdefs  EatContext:: vdmcontext
"EatContext \<equiv> {(DIAM\<bullet>Eat([RNarg l_]), Eat_Spec)}"


lemma Call2:
"\<lbrakk>G \<rhd> (funtable f) : P\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : (\<lambda> E h hh v p. \<exists> p'. tkcall p' = p \<and> P E h hh v p')"
(*<*)
apply (rule vdm_call)
apply clarsimp
apply(drule  CtxtWeakSingleton)
apply (subgoal_tac "P = (\<lambda> E h hh v p.
                         \<exists> p'. (clock p' = clock p \<and> callc p' = callc p \<and>
                                invkc p' = invkc p \<and> invkdpth p' = invkdpth p \<and> 
                                P E h hh v p'))", simp)
apply (rule, rule, rule, rule, rule)
apply auto
apply (subgoal_tac "p' = p", simp+)
done
(*>*)


lemma DA_Call2:
"\<lbrakk>G \<rhd> (funtable f) : DAss U n C T m\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : DAss U n C T m"
apply (rule DA_Call)
apply(drule  CtxtWeakSingleton)
apply (auto)
done


lemmas code_simp  = Fun_fEat  Fun_fzeroEat Fun_foneEat
declare code_simp [simp]

(* all but top_level, ie Meth_Eat *)

lemmas DA_intros =  DA_Null DA_Int  DA_Call2 DA_Let_RPrim DA_If DA_MatchD

lemma Eat_DAss:
"EatContext = G\<Longrightarrow> G \<rhd> snd (methtable DIAM Eat) : Eat_Spec"
apply clarify
apply (simp add: Eat_Spec_def Meth_Eat)
apply (rule DA_Weak)
apply ((rule DA_intros) | simp)+
apply (simp_all (no_asm) add: DOM_def)
(*first branch*)
 apply (simp add: GETr_def)
(*invocation of eat*)
apply (rule DA_Generalise)
apply (rule ADAPT)
  (*lookup from context*)
  apply (simp only: EatContext_def Eat_Spec_def) 
apply fast
defer 1 defer 1
  (*calculation of renaming*)
  apply (fast intro:getRenaming.intros)
  (*verify that context at applications site arises from context in
    specification via the renaming*)
  apply (rule RenContextCONS,fastsimp) 
    apply (simp_all (no_asm) add: GETr_def)
  apply (rule RenContextNIL) 
  (*the last side condition of ADAPT*)
apply auto
(*invocation of eat now finished*) 
done


text {*We require the specification table at method @{text Eat} to contain entries
       which relate to the assertion @{text Eat_Spec}.*}
constdefs EatTable::bool
"EatTable == 
  (MS DIAM Eat = (\<lambda> args E h hh v p . Eat_Spec (newframe_env Nullref (fst (methtable DIAM Eat)) args E) h hh v p))"
text{*The proofs use lemma @{text DAss_Envs_same_on_U}*}


lemma Eat_Spec_Framecorrect: "EatTable \<Longrightarrow> MS DIAM Eat [RNarg l_] = Eat_Spec"
apply (simp add: EatTable_def  newframe_env_def evalARGS_def Eat_Spec_def Meth_Eat)
apply (force intro!: DAss_Envs_same_on_U intro:ext)
done






text {*For a specification table satisfying EatSortTable, \verb|EatSortContext| is a good context.*}
lemma EatContext_good: "EatTable \<Longrightarrow> goodContext EatContext"
apply (simp (no_asm)add: goodContext_def EatContext_def )
(*Eat*)
apply safe
apply (simp only: Eat_Spec_Framecorrect)
apply (rule vdm_conseq)
apply (rule Eat_DAss)
apply (simp add: EatContext_def)
apply (simp add: EatTable_def Eat_Spec_def)
apply (blast intro:DAss_PConst)
done

text {*Thus, we can prove that arbitrary invocations of @{text Eat} and  @{text Sort} honour
       their entries in the specification table, in the empty VDM context.*}
theorem "\<lbrakk>EatTable\<rbrakk> \<Longrightarrow> \<rhd> DIAM\<bullet>Eat([RNarg x]): MS DIAM Eat [RNarg x]"
apply (rule GCInvs)
apply (erule EatContext_good)
apply (simp_all add: EatContext_def)
apply (auto)
apply (simp only: Eat_Spec_Framecorrect)
done 


declare code_simp [simp del]

end
