theory DerivedAssertions = Comb:
syntax DIAM :: cname
       DOLLAR_F :: rfldname
       DOLLAR_N :: rfldname
       DOLLAR :: ifldname
       F0 :: ifldname
       F1 :: rfldname
       F2 :: rfldname

translations
 "DIAM" == "(CN ''dia_0'') "
 "DOLLAR_F" == "(RFN ''$f'')"
 "DOLLAR_N" == "(RFN ''$n'')"
 "DOLLAR" == "(IFN ''$'')"
 "F0" == "(IFN ''f0'')"
 "F1" == "(RFN ''f1'')"
 "F2" == "(RFN ''f2'')"

lemma SubsetTriv:"\<lbrakk>x:X; X \<subseteq> Y\<rbrakk> \<Longrightarrow> x:Y" by fast

datatype
 extType = IntET | ListET nat

types
 extContext = "(iname list) \<times> ((rname \<times> nat) list)"

constdefs ContextRDom:: "extContext \<Rightarrow> rname set"
"ContextRDom G == List.set (List.map (\<lambda> (a,b) .a) (snd G))"

constdefs GETi :: "extContext \<Rightarrow> iname \<Rightarrow> (extType option)"
"GETi G x \<equiv> (if x mem (fst G) then (Some IntET) else None)"

consts GETrAux :: "((rname \<times> nat) list) \<Rightarrow> extType option"
primrec
"GETrAux [] = None"
"GETrAux (h # t) = Some (ListET (snd h))"

constdefs GETr :: "extContext \<Rightarrow> rname \<Rightarrow> (extType option)"
"GETr G x \<equiv> GETrAux (filter (\<lambda> y . x = fst y) (snd G))"

constdefs INSi :: "extContext \<Rightarrow> iname \<Rightarrow> extContext"
"INSi G x \<equiv> (x # List.filter (\<lambda> y . y \<noteq> x) (fst G), snd G)"

constdefs INSr :: "extContext \<Rightarrow> rname \<Rightarrow> nat \<Rightarrow> extContext"
"INSr G x k \<equiv> (fst G, (x,k) # List.filter (\<lambda> (y,kk) . y \<noteq> x) (snd G))"

consts mLIST::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive mLIST intros
mLIST_NIL: "(0,Nullref,{},h) : mLIST"
mLIST_CONS:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> \<noteq> 2; h\<lfloor>a\<diamondsuit>F1\<rfloor> = r; a \<notin> X; (n,r,X,h):mLIST\<rbrakk>
          \<Longrightarrow> (Suc n, Ref a, X \<union> {a}, h): mLIST"

lemma mLIST_Unique[rule_format]: "\<forall> r F h. (N, r, F, h) \<in> mLIST \<longrightarrow> (\<forall> M FF . (M, r, FF, h) \<in> mLIST \<longrightarrow> (N=M \<and> F=FF))"
apply clarsimp
apply (induct N)
apply (erule mLIST.elims, simp_all)
apply (erule mLIST.elims, simp_all)
apply (erule mLIST.elims, simp_all)
apply (erule mLIST.elims, simp_all)
apply clarsimp
apply fast
done

consts FL::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive FL intros
FL_NIL: "(0, Nullref, {},h) : FL"
FL_SUC: "\<lbrakk>h@@a = Some DIAM; a \<notin> X; (n, h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>,X,h):FL\<rbrakk>
        \<Longrightarrow> (Suc n, Ref a,  X \<union> {a}, h) : FL"

lemma FL_Unique[rule_format]: "\<forall> r F h. (N, r, F, h) \<in> FL \<longrightarrow> (\<forall> M FF . (M, r, FF, h) \<in> FL \<longrightarrow> (N=M \<and> F=FF))"
apply clarsimp
apply (induct N)
apply (erule FL.elims, simp_all)
apply (erule FL.elims, simp_all)
apply (erule FL.elims, simp_all)
apply (erule FL.elims, simp_all)
apply fast
done

text {*Region calculation -we assume type correctness.*}
consts reg :: "(val \<times> heap \<times> (extType option) \<times> (locn set) \<times> nat) set"
inductive reg intros
regNone:  "(v,h,None,{},0):reg"
regList:  "\<lbrakk>(n, r, R, h) : mLIST; m = k*n\<rbrakk> \<Longrightarrow> (RVal r, h, Some(ListET k), R, m): reg"
regInt:   "(IVal i ,h,Some IntET,{}, 0): reg"

consts ContextSize::"(env \<times> heap \<times> extContext \<times> nat) set"
inductive ContextSize intros
ContextSizeNIL: "(E,h,(iContext,[]), 0) : ContextSize"
ContextSizeCONS: "\<lbrakk>(RVal (E\<lfloor>x\<rfloor>), h, Some (ListET k), R,n): reg ;
                   (E,h,(iContext,t),m):ContextSize; 
                   x \<notin> ContextRDom(iContext,t)\<rbrakk>
                  \<Longrightarrow> (E,h,(iContext,(x,k) # t), n+m) : ContextSize"

lemma ContextSizePreserved[rule_format]:
"\<forall> E h S C1 . (E,h,(C1,C),S):ContextSize \<longrightarrow> (\<forall> EE. (\<forall> x . x : ContextRDom (C1,C) \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>)
                                          \<longrightarrow> (\<forall> D . snd D = C \<longrightarrow> (EE,h,D,S):ContextSize))"
apply clarsimp
apply (induct "C")
(*NIL*)
apply (erule ContextSize.elims, simp_all, clarsimp)
apply (rule ContextSizeNIL)
(*CONS*)
apply (erule ContextSize.elims, clarsimp, clarify)
apply (rule ContextSizeCONS)
apply (subgoal_tac "(RVal (renv EE x), ha, Some (ListET k), R, n) \<in> reg", assumption)
apply (erule thin_rl) apply (subgoal_tac "renv Ea x = renv EE x", clarsimp)
  apply (erule_tac x=x in allE, erule impE) apply (simp add: ContextRDom_def) apply assumption
apply (subgoal_tac "\<forall>x. x \<in> ContextRDom (iContext, t) \<longrightarrow> renv Ea x = renv EE x")
apply (rotate_tac 1, erule thin_rl, erule thin_rl) apply blast
apply (erule thin_rl, clarsimp)
apply (erule_tac x=xa in allE, erule impE) apply (simp add: ContextRDom_def)
apply assumption
apply (erule thin_rl)
apply (simp add:ContextRDom_def) 
done

constdefs DAss::"nat \<Rightarrow> extContext \<Rightarrow> (rname set) \<Rightarrow> extType \<Rightarrow> nat \<Rightarrow> (rname set) \<Rightarrow> (rname set) \<Rightarrow> vdmassn"
"DAss n G X A nn Y Z E h hh v p \<equiv> 
  X \<subseteq> (ContextRDom G) \<and> Y \<subseteq> (ContextRDom G) \<and> Z \<subseteq> (ContextRDom G) \<and> 
  (\<forall> F N. 
    ((N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) : FL \<and>  
     (\<forall> x. (x:ContextRDom G) \<longrightarrow> (\<exists> Rx Sx . (RVal (E\<lfloor>x\<rfloor>),h,GETr G x,Rx,Sx): reg)) \<and> 
     (\<forall> x xx Rx Rxx Sx Sxx. 
             (x : X \<and> xx : X \<and> x \<noteq> xx \<and> (RVal (E\<lfloor>x\<rfloor>),h,GETr G x,Rx,Sx): reg \<and> (RVal (E\<lfloor>xx\<rfloor>),h,GETr G xx,Rxx,Sxx): reg) \<longrightarrow>
             Rx \<inter> Rxx = {}) \<and>
     (\<forall> x Rx Sx. (x: ContextRDom G \<and> (RVal (E\<lfloor>x\<rfloor>), h, GETr G x,Rx,Sx):reg) \<longrightarrow>  Rx \<inter> F = {})) \<longrightarrow>
    (\<exists> R S M FF. (M, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, FF, hh) : FL \<and>
                 (v,hh,Some A,R,S) : reg \<and>
                 (\<forall> y Ry Sy. (y:Y \<and> (RVal (E\<lfloor>y\<rfloor>), h, GETr G y, Ry, Sy):reg) \<longrightarrow> Ry \<inter> R = {}) \<and>  
                 (\<forall> l . (l \<notin> F \<and> (\<forall> z Rz Sz. (z : Z \<and> (RVal (E\<lfloor>z\<rfloor>), h, GETr G z, Rz, Sz):reg) \<longrightarrow> l \<notin> Rz))
                       \<longrightarrow> sameOH {l} h hh) \<and>
                 (R \<inter> FF = {}) \<and> 
                 (FF \<subseteq> F \<union> {l . \<exists> z Rz Sz.  z:Z \<and> (RVal (E\<lfloor>z\<rfloor>), h, GETr G z, Rz, Sz):reg \<and> l:Rz}) \<and> 
                 (\<forall> q CS. (E,h,G,CS):ContextSize \<longrightarrow> n + CS + q \<le> N \<longrightarrow> nn + S + q \<le> M) \<and>
                 oheap h = oheap hh))"

lemma DAss_Generalise:
 "\<lbrakk>DAss n C X IntET nn Y Z E h hh v p; n \<le> m; X \<subseteq> XX; YY \<subseteq> Y; Z \<subseteq> ZZ; XX \<union> ZZ \<subseteq> ContextRDom C; mm \<le> nn; C=CC\<rbrakk>
 \<Longrightarrow> DAss m CC XX IntET mm YY ZZ E h hh v p"
apply (clarsimp)
apply (simp add: DAss_def, clarsimp)
apply (rule, rotate_tac 9, erule thin_rl, fast)
apply (rule, rotate_tac 9, erule thin_rl, erule SubsetTransitive, assumption)
apply (rule, rotate_tac 9, erule thin_rl, fast)
apply clarsimp
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE) apply clarsimp apply (rotate_tac 11, erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE)
                   apply (rotate_tac -1, erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Rxx in allE)
                   apply (erule impE, clarsimp) apply (rotate_tac -1, erule thin_rl, erule thin_rl, fast) 
                   apply simp
apply clarsimp
apply (rule_tac x=R in exI, rule_tac x=S in exI)
apply (rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (rotate_tac 15, erule_tac x=y in allE, rotate_tac -1, erule_tac x=Ry in allE, erule impE)
  apply rule apply (erule SubsetTriv, assumption) apply (rule, simp)
  apply (erule thin_rl, rotate_tac 2, erule thin_rl, rotate_tac 15, erule thin_rl, erule thin_rl, erule thin_rl) apply fast
apply (erule_tac x=l in allE, erule impE, clarsimp) apply (rotate_tac -4, erule_tac x=z in allE, rotate_tac -1, erule_tac x=Rz in allE)
  apply (erule impE, rotate_tac 7) apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                                   apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                                   apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                                   apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, fast)
  apply simp
  apply simp
apply (rotate_tac 10) apply (erule thin_rl, erule thin_rl, erule thin_rl)
                     apply (rotate_tac 2, erule thin_rl, erule thin_rl)
                     apply (rotate_tac 2, erule thin_rl)
apply (subgoal_tac "\<exists>z. z \<in> Z \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr CC z, Rz, Sz) \<in> reg) \<and> x \<in> Rz)", clarsimp)
  apply (rule_tac x=z in exI, fast)
  apply (subgoal_tac "x : F \<union> {l. \<exists>z. z \<in> Z \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr CC z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", fast) 
  apply (erule SubsetTriv, assumption)
apply (rotate_tac -4, erule_tac x=q in allE)
  apply (rotate_tac -1, erule_tac x=CS in allE, clarsimp)
done

lemma DA_Generalise: 
"\<lbrakk>G \<rhd> e: DAss n C X IntET nn Y Z; n \<le> m; X \<subseteq> XX; YY \<subseteq> Y; Z \<subseteq> ZZ; XX \<union> ZZ \<subseteq> ContextRDom C; mm \<le> nn\<rbrakk>
 \<Longrightarrow> G \<rhd> e: DAss m C XX IntET mm YY ZZ"
apply (erule vdm_conseq)
apply clarsimp
apply (erule DAss_Generalise, fast+)
done

lemma DA_Null: "G \<rhd> Null: DAss 0 ([],[]) {} (ListET k) 0 {} {}"
apply (rule vdm_conseq)
apply (rule vdm_null)
apply (simp add: DAss_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe)
apply (rule regList)
apply (rule mLIST_NIL, simp)
apply (simp add: sameOH_def)
apply (erule ContextSize.elims, simp_all)
done

lemma DA_Int: "G \<rhd> expr.Int i: DAss 0 ([],[]) {} IntET 0 {} {}"
apply (rule vdm_conseq)
apply (rule vdm_int)
apply (simp add: DAss_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule regInt)
apply (simp add: sameOH_def)
apply (erule ContextSize.elims, simp_all)
done

lemma DA_IVar: "G \<rhd> IVar x: DAss 0 ([x],[]) {} IntET 0 {} {}"
apply (rule vdm_conseq)
apply (rule vdm_ivar)
apply (simp add: DAss_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule regInt)
apply (simp add: sameOH_def)
apply (erule ContextSize.elims, simp_all)
done

lemma DA_RVar: "G \<rhd> RVar x: DAss 0 ([],[(x,k)]) {x} (ListET k) 0 {} {}"
apply (rule vdm_conseq)
apply (rule vdm_rvar)
apply (simp add: DAss_def, simp add: ContextRDom_def, clarsimp)
apply (erule_tac x=Rx in allE)
apply (erule impE, rule)
 apply (assumption)
apply (rule_tac x=Rx in exI, rule_tac x=Sx in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (simp add: GETr_def)
apply (simp add: sameOH_def)
apply (erule ContextSize.elims, simp_all, clarsimp)
apply (erule ContextSize.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, safe)
apply (simp add: GETr_def, safe)
apply (erule reg.elims, simp_all, safe)
apply (insert mLIST_Unique, fast)
done


lemma DA_Prim: "G \<rhd> Primop f x y: DAss 0 ([x,y],[]) {} IntET 0 {} {}"
apply (rule vdm_conseq)
apply (rule vdm_prim, simp add: DAss_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply (simp add: sameOH_def)
apply (erule ContextSize.elims, simp_all)
done

lemma DA_Rprim: "G \<rhd> RPrimop f x y: DAss 0 ([],[(x,k),(y,k)]) {} IntET 0 {} {}"
apply (rule vdm_conseq)
apply (rule vdm_rprim, simp add: DAss_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply (simp add: sameOH_def)
apply (erule ContextSize.elims, simp_all)
done

(* we prefer the let-tl rule below
lemma DA_GetF_TL: "G \<rhd> GetFr x F1: DAss 0 ([],[(x,k)]) {} (ListET k) k {} {}"
apply (rule vdm_conseq)
apply (rule vdm_getfr, simp add: DAss_def, safe)
apply (erule_tac x=x in allE)
apply (erule impE, simp add: ContextRDom_def, clarsimp)
apply (erule_tac x=x in allE, erule_tac x=Rx in allE)
apply (erule impE, rule)
 apply (simp add: ContextRDom_def)
 apply (rule, simp)
apply (erule reg.elims, simp_all add: GETr_def, safe)
apply (erule mLIST.elims, simp_all, safe)
apply (rule_tac x="X" in exI, rule_tac x="k * na" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (erule regList, simp)
apply (simp add: sameOH_def)
apply (erule ContextSize.elims, simp_all, clarsimp)
apply (erule ContextSize.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, safe)
apply (rotate_tac -2)
apply (erule mLIST.elims, simp_all, safe)
apply (subgoal_tac "na = nc \<and> X = Xa",clarsimp)
apply (erule mLIST_Unique, assumption)
done

lemma DA_GetF_HD: "G \<rhd> GetFi x F0: DAss 0 ([],[(x,k)]) {} IntET 0 {} {}"
apply (rule vdm_conseq)
apply (rule vdm_getfi, simp add: DAss_def, safe)
apply (erule_tac x=x in allE)
apply (erule impE, simp add: ContextRDom_def, clarsimp)
apply (erule_tac x=x in allE, erule_tac x=Rx in allE)
apply (erule impE, rule)
 apply (simp add: ContextRDom_def)
 apply (rule, simp)
apply (erule reg.elims, simp_all add: GETr_def, safe)
apply (erule mLIST.elims, simp_all, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply (simp add: sameOH_def)
apply (erule ContextSize.elims, simp_all)
done

lemma DA_GetF_TAG: "G \<rhd> GetFi x DOLLAR: DAss 0 ([],[(x,k)]) {} IntET 0 {} {}"
apply (rule vdm_conseq)
apply (rule vdm_getfi, simp add: DAss_def, safe)
apply (erule_tac x=x in allE)
apply (erule impE, simp add: ContextRDom_def, clarsimp)
apply (erule_tac x=x in allE, erule_tac x=Rx in allE)
apply (erule impE, rule)
 apply (simp add: ContextRDom_def)
 apply (rule, simp)
apply (erule reg.elims, simp_all add: GETr_def, safe)
apply (erule mLIST.elims, simp_all, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply (simp add: sameOH_def)
apply (erule ContextSize.elims, simp)apply simp
done
*)

text {*Union of disjoint contexts*}
consts ContextUnion::"(extContext \<times> extContext \<times> extContext) set"
inductive ContextUnion intros
ContextUNION : 
"\<lbrakk>(set (fst C)) \<inter> (set (fst D)) = {};(ContextRDom C) \<inter> (ContextRDom D) = {}; E = ((fst C) @ (fst D), (snd C) @ (snd D))\<rbrakk>
\<Longrightarrow> (C,D,E): ContextUnion"
(*"\<lbrakk> (set (fst C)) \<inter> (set (fst D)) = {};(ContextRDom C) \<inter> (ContextRDom D) = {}\<rbrakk>
\<Longrightarrow> (C,D,((fst C) @ (fst D), (snd C) @ (snd D))): ContextUnion"
*)

lemma UnionGet1Aux[rule_format]:
"\<forall> a x k . ContextRDom (a, b) \<inter> ContextRDom ([], [(x, k)]) = {} \<longrightarrow> GETr (a, b @ [(x, k)]) x = Some (ListET k)"
apply clarsimp
apply (induct b)
apply(simp add: ContextRDom_def GETr_def)
apply (subgoal_tac "GETr (aa, list @ [(x, k)]) x = Some (ListET k)")
prefer 2 apply (subgoal_tac "ContextRDom (aa, list) \<inter> ContextRDom ([], [(x, k)]) = {}") apply fast 
         apply (erule thin_rl) apply (simp add: ContextRDom_def)
apply(simp add: ContextRDom_def GETr_def)
apply auto
done

lemma UnionGet1:
"\<lbrakk>(C, ([], [(x, k)]), D) \<in> ContextUnion; T = Some(ListET k)\<rbrakk> \<Longrightarrow> GETr D x = T"
by (erule ContextUnion.elims, simp_all, clarsimp, erule UnionGet1Aux)

lemma UnionGet2Aux[rule_format]:
"\<forall> a x k y. ContextRDom (a, b) \<inter> ContextRDom ([], [(x, k)]) = {} \<longrightarrow> y \<noteq> x \<longrightarrow> GETr (a, b @ [(x, k)]) y = GETr (a, b) y"
apply clarsimp
apply (induct b)
apply(simp add: ContextRDom_def GETr_def)
apply (subgoal_tac "GETr (aa, list @ [(x, k)]) y = GETr (aa, list) y")
prefer 2 apply (subgoal_tac "ContextRDom (aa, list) \<inter> ContextRDom ([], [(x, k)]) = {}") apply fast 
         apply (erule thin_rl) apply (simp add: ContextRDom_def)
apply(simp add: ContextRDom_def GETr_def)
done

lemma UnionGet2:
"\<lbrakk>(C, ([], [(x, k)]), D) \<in> ContextUnion; y \<noteq> x; GETr C y = T\<rbrakk> \<Longrightarrow> GETr D y = T"
by (erule ContextUnion.elims, simp_all, clarsimp, erule UnionGet2Aux, assumption)

lemma UnionGet3:
"\<lbrakk>(([], [(x, k)]), C, D) \<in> ContextUnion; T = Some(ListET k)\<rbrakk> \<Longrightarrow> GETr D x = T"
by (erule ContextUnion.elims, simp_all, clarsimp, simp add: GETr_def)

lemma UnionGet4:
"\<lbrakk>(([], [(x, k)]), C, D) \<in> ContextUnion; y \<noteq> x; GETr C y = T\<rbrakk> \<Longrightarrow> T = GETr D y"
by (erule ContextUnion.elims, simp_all, clarsimp, simp add: GETr_def)

lemma UnionGet5Aux[rule_format]:
"\<forall> x a aa ba .
x \<in> ContextRDom (a, b) \<longrightarrow> ContextRDom (a, b) \<inter> ContextRDom (aa, ba) = {} \<longrightarrow> GETr (a @ aa, b @ ba) x = GETr (a, b) x"
apply clarsimp
apply (induct b)
apply (simp add: ContextRDom_def GETr_def)
apply (simp add: ContextRDom_def GETr_def)
apply auto
done

lemma UnionGet5:
  "\<lbrakk>x \<in> ContextRDom C1; (C1, C2, C) \<in> ContextUnion\<rbrakk> \<Longrightarrow> GETr C x = GETr C1 x"
by (erule ContextUnion.elims, simp_all, clarsimp,erule UnionGet5Aux, assumption)

lemma UnionGet6Aux[rule_format]:
"\<forall> x aa ba a.
x \<in> ContextRDom (aa, ba) \<longrightarrow> ContextRDom (a, b) \<inter> ContextRDom (aa, ba) = {} \<longrightarrow>  GETr (a @ aa, b @ ba) x = GETr (aa, ba) x"
apply clarsimp
apply (induct b)
apply (simp add: ContextRDom_def GETr_def)
apply (simp add: ContextRDom_def GETr_def)
apply auto
done

lemma UnionGet6:
  "\<lbrakk>x \<in> ContextRDom C2; (C1, C2, C) \<in> ContextUnion\<rbrakk> \<Longrightarrow> GETr C x = GETr C2 x"
by (erule ContextUnion.elims, clarsimp, erule UnionGet6Aux, assumption)

lemma "(C1, C2, C) \<in> ContextUnion \<longrightarrow> (\<exists> D . (C2,C1,D): ContextUnion)"
apply clarsimp
apply (erule ContextUnion.elims, simp_all, clarsimp)
apply (rule, rule, rule ContextUNION, auto)
done

lemma MemAux1[rule_format]: "\<forall> x b . x mem a @ x # b" by (clarsimp, induct a, auto)
lemma MemAux2[rule_format]: "\<forall> x A b. x mem (a @ b) \<longrightarrow> x mem (a @ A # b)" by(clarsimp, induct a, auto)
lemma MemAux3[rule_format]: "\<forall> x A. A \<noteq> x \<longrightarrow> x mem a @ A # b \<longrightarrow> x mem a @ b"
by(clarsimp, induct a, simp, induct b, simp, fastsimp)

lemma MemAux[rule_format]: "\<forall> ab x . (x mem (ac @ ab)) = (x mem (ab @ ac))"
apply clarsimp
apply (induct ac)
apply clarsimp
apply auto
apply (rule MemAux1)
apply (erule MemAux2)
apply (erule MemAux3, assumption)
done

lemma "\<lbrakk>(C1, C2, C) \<in> ContextUnion; (C2, C1, D) \<in> ContextUnion\<rbrakk> \<Longrightarrow> GETi C x = GETi D x"
apply (erule ContextUnion.elims, simp_all, clarsimp)
apply (erule ContextUnion.elims, simp_all, clarsimp)
apply (simp add: GETi_def MemAux)
done

lemma GetNONE1: "x \<notin> ContextRDom C \<Longrightarrow> None = GETr C x"
apply (subgoal_tac "filter (\<lambda> y . x = fst y) (snd C) = []")
apply (simp add: GETr_def)
apply (simp add: ContextRDom_def)
apply (induct "snd C", auto)
done

lemma Filter1[rule_format]: "\<forall> a x. [y\<in>a @ l . x = fst y] = [] \<longrightarrow> [y\<in>l . x = fst y] = []"
apply (induct l)
apply simp
apply clarify
apply (erule_tac x="aa @ [(a, b)]" in allE, erule_tac x=x in allE)
apply auto
done

lemma GetNONE2: "GETr C x = None \<Longrightarrow> x \<notin> ContextRDom C"
apply (simp add: GETr_def)
apply (subgoal_tac "[y\<in>snd C . x = fst y] = []")
prefer 2 apply (induct "snd C", simp) apply auto
apply (simp add: ContextRDom_def, auto) apply (induct "snd C", simp) 
apply (subgoal_tac "[y\<in>list . x = fst y] = []", fastsimp)
apply (rule Filter1)
apply (subgoal_tac "[y\<in>[a] @ list . x = fst y] = []", assumption)
apply simp
done

lemma GetrAux[rule_format]:
"\<forall> ab ac a t. ContextRDom (ac, bc) \<inter> ContextRDom (ab, bb) = {} \<longrightarrow> (\<forall> x. GETr (ac @ ab, bc @ bb) x = GETr (ab @ ac, bb @ bc) x)"
apply clarsimp
apply (case_tac "GETr (ac @ ab, bc @ bb) x", clarsimp)
  apply (rule GetNONE1)
  apply (subgoal_tac "x \<notin> ContextRDom (ac @ ab, bc @ bb)", simp add: ContextRDom_def)
  apply (erule GetNONE2)
apply clarsimp
apply (case_tac "x : ContextRDom (ac,bc)")
  apply (induct bb) 
   apply (simp add: GETr_def)
   apply (subgoal_tac "x \<notin> ContextRDom (ab, a # list)")
   apply (subgoal_tac "x \<noteq> fst a \<and> x \<notin> ContextRDom (ab, list)", clarsimp)
   apply (simp add: GETr_def)
   apply (subgoal_tac "ContextRDom (ac, bc) \<inter> ContextRDom (ab, list) = {}", fast)
   apply (simp add: ContextRDom_def)
   apply (simp add: ContextRDom_def)
   apply auto
  apply (induct bc) 
   apply (simp add: GETr_def)
   apply (subgoal_tac "x \<notin> ContextRDom (ac, list)")
   apply (subgoal_tac "x \<noteq> fst a \<and> x \<notin> ContextRDom (ab, list)", clarsimp)
   apply (simp add: GETr_def)
   apply (subgoal_tac "ContextRDom (ac, list) \<inter> ContextRDom (ab, bb) = {}", fast) 
   apply (simp add: ContextRDom_def)
   apply (simp add: ContextRDom_def)
   apply auto
   apply (simp add: ContextRDom_def)
done

lemma UnionExtensionallySymmetric: "\<lbrakk>(C1, C2, C) \<in> ContextUnion; (C2, C1, D) \<in> ContextUnion\<rbrakk> \<Longrightarrow> GETr C x = GETr D x"
apply (erule ContextUnion.elims, simp_all, clarsimp)
apply (erule ContextUnion.elims, simp_all, clarsimp)
apply (erule GetrAux)
done

lemma ContextUnion_Dom1:
  "\<lbrakk>x \<in> ContextRDom C1; (C1, C2, C) \<in> ContextUnion\<rbrakk> \<Longrightarrow> x \<in> ContextRDom C"
by (erule ContextUnion.elims, simp add: ContextRDom_def)

lemma ContextUnion_Dom2:
  "\<lbrakk>x \<in> ContextRDom C2; (C1, C2, C) \<in> ContextUnion\<rbrakk> \<Longrightarrow> x \<in> ContextRDom C"
by (erule ContextUnion.elims, simp add: ContextRDom_def)

lemma ContextUnion_Distinct:
  "\<lbrakk>x \<in> ContextRDom C1; y \<in> ContextRDom C2; (C1, C2, C) \<in> ContextUnion\<rbrakk> \<Longrightarrow> y \<noteq> x"
by (erule ContextUnion.elims, simp add: ContextRDom_def, fast)

lemma ContextSize_Icontext_irrelevant[rule_format]:
"\<forall> E h iC1 iC2 m . (E, h, (iC1, t), m) \<in> ContextSize \<longrightarrow> (E, h, (iC2, t), m) \<in> ContextSize"
apply (clarsimp, induct t)
apply (erule ContextSize.elims, simp_all, clarsimp)
apply (rule ContextSizeNIL)
apply (erule ContextSize.elims, clarify, clarify)
apply (erule ContextSizeCONS, fast)
apply (erule thin_rl, simp add: ContextRDom_def)
done

lemma ContextUnion_ContextSizeAux[rule_format]:
"(E, h, (Ci,Cr), CS) \<in> ContextSize \<Longrightarrow> 
  (\<forall> Ci1 Ci2 l1 l2. l1 @ l2 = Cr \<longrightarrow> 
    (\<exists> CS1 CS2. (E, h, (Ci1,l1) , CS1) \<in> ContextSize \<and> (E, h, (Ci2,l2), CS2) \<in> ContextSize \<and> CS1 + CS2 = CS))"
apply (erule ContextSize.induct)
apply clarsimp
apply (rule ContextSizeNIL)
apply clarsimp
apply (case_tac "l1", clarsimp)
  apply (rule_tac x=0 in exI, clarsimp)
  apply (rule, rule ContextSizeNIL)
  apply (rule ContextSizeCONS, assumption) apply (erule ContextSize_Icontext_irrelevant) 
    apply (simp add: ContextRDom_def)
apply (erule_tac x=Ci1 in allE)
apply (erule_tac x=Ci2 in allE)
apply (erule_tac x=list in allE)
apply (erule_tac x=l2 in allE, clarsimp)
apply (rule, rule)
  apply (rule ContextSizeCONS, assumption, assumption) 
    apply (simp add: ContextRDom_def)
  apply (rule, rule, assumption, simp)
done

lemma ContextUnion_ContextSize:
"\<lbrakk>(C1, C2, C) \<in> ContextUnion; (E, h, C, CS) \<in> ContextSize\<rbrakk> \<Longrightarrow> 
 \<exists> CS1 CS2. (E, h, C1, CS1) \<in> ContextSize \<and> (E, h, C2, CS2) \<in> ContextSize \<and> CS1 + CS2 = CS"
apply (subgoal_tac "\<exists>CS1 CS2. (E, h, (fst C1, snd C1), CS1) \<in> ContextSize \<and> (E, h, (fst C2, snd C2), CS2) \<in> ContextSize \<and> CS1 + CS2 = CS", simp)
apply (rule ContextUnion_ContextSizeAux)
apply (subgoal_tac "(E, h, (fst C1 @ fst C2, snd C1 @ snd C2), CS) \<in> ContextSize", assumption)
apply (erule ContextUnion.elims, simp_all)
done

lemma DA_Weaken: 
"\<lbrakk>G \<rhd> e: DAss n C1 X IntET nn Y Z; (C1,C2,C):ContextUnion\<rbrakk> \<Longrightarrow> G \<rhd> e: DAss n C X IntET nn Y Z"
apply (erule vdm_conseq)
apply (simp add: DAss_def, safe)
apply (rule ContextUnion_Dom1) apply (erule SubsetTriv, assumption)
apply assumption
apply (rule ContextUnion_Dom1) apply (erule SubsetTriv, assumption)
apply assumption
apply (rule ContextUnion_Dom1) apply (erule SubsetTriv, assumption)
apply assumption
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (rotate_tac -1, erule impE)
prefer 2
  apply clarsimp 
  apply (rule_tac x=R in exI, rule_tac x=S in exI)
  apply (rule_tac x=M in exI, rule_tac x=FF in exI)
  apply clarsimp
  apply rule apply clarsimp apply (subgoal_tac "GETr C y = GETr C1 y", clarsimp)
    apply (rotate_tac 11, erule_tac x=y in allE, erule_tac x=Ry in allE, erule impE) apply (rule, rule ContextUnion_Dom1)
    apply (erule SubsetTriv, assumption, assumption)
    apply (rule, clarsimp, assumption)
    apply (rotate_tac -11, erule_tac x=y in allE, erule_tac x=Ry in allE, clarsimp) 
    apply (rule UnionGet5, erule SubsetTriv, assumption, assumption)
  apply rule apply clarsimp apply (erule_tac x=l in allE, erule impE) apply (rule, assumption) apply (clarsimp)
    apply(rotate_tac -4, erule_tac x=z in allE)
    apply (erule_tac x=Rz in allE, erule impE, clarsimp) apply (rule_tac x=Sz in exI) 
    apply (subgoal_tac "GETr C z = GETr C1 z", clarsimp)
    apply (rule UnionGet5, erule SubsetTriv, assumption, assumption)
    apply (rotate_tac 8, erule_tac x=z in allE, erule impE) apply(rule ContextUnion_Dom1)
    apply (erule SubsetTriv, assumption, assumption)
    apply simp
    apply simp
  apply rule apply clarsimp 
    apply (subgoal_tac "x:{l. \<exists>z. z \<in> Z \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C1 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
    prefer 2 apply (subgoal_tac "x : F \<union> {l. \<exists>z. z \<in> Z \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C1 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", simp)
             apply (erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl )
             apply (erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl,erule thin_rl, erule thin_rl, erule thin_rl)
             apply(rotate_tac 1, erule thin_rl)
             apply fast
    apply clarsimp apply (rule_tac x=z in exI, subgoal_tac "GETr C z = GETr C1 z", clarsimp)
      apply (rule_tac x=Rz in exI, clarsimp)
      apply (rule_tac x=Sz in exI, clarsimp)
    apply (rule UnionGet5) apply (erule SubsetTriv, assumption, assumption)
  apply clarsimp 
    apply (subgoal_tac "\<exists> CS1 CS2. (E, h, C1, CS1) \<in> ContextSize \<and> (E, h, C2, CS2) \<in> ContextSize \<and> CS1 + CS2 = CS")
    prefer 2 apply (erule ContextUnion_ContextSize, assumption)
    apply clarsimp 
apply safe
apply (erule_tac x=x in allE, erule impE, erule ContextUnion_Dom1, assumption)
  apply clarsimp apply (subgoal_tac "GETr C x = GETr C1 x", rule, rule, clarsimp, assumption)
  apply (erule UnionGet5, assumption)
apply (subgoal_tac "x: ContextRDom C1 \<and> xx: ContextRDom C1", clarsimp)
  apply (subgoal_tac "x: ContextRDom C \<and> xx: ContextRDom C", clarsimp)
  apply (subgoal_tac "GETr C x = GETr C1 x \<and> GETr C xx = GETr C1 xx", clarsimp)
  apply (rotate_tac 10, erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE)
    apply clarsimp apply (erule impE, rule) apply (erule_tac x=x in allE, clarsimp) apply (rule, simp)apply (rule, simp)
    apply (rotate_tac -6, erule thin_rl, erule thin_rl) apply fast
  apply safe
    apply (erule UnionGet5, assumption)
    apply (erule UnionGet5, assumption)
    apply (erule ContextUnion_Dom1, assumption)
    apply (erule ContextUnion_Dom1, assumption)
    apply (erule SubsetTriv, assumption)
    apply (erule SubsetTriv, assumption)
apply (rotate_tac 6, erule thin_rl)
  apply (subgoal_tac "x: ContextRDom C", clarsimp)
  apply (subgoal_tac "GETr C x = GETr C1 x")
  apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=Rx in allE, clarsimp)
    apply (erule impE) apply (rule, simp) apply (rotate_tac -4, erule thin_rl, fast)
    apply (erule UnionGet5, assumption)
    apply (erule ContextUnion_Dom1, assumption)
done

lemma mLIST_Preserved[rule_format]:
"\<forall> r R h . (n, r, R, h) \<in> mLIST \<longrightarrow> (\<forall> h1. (\<forall> l. l \<in> R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (n, r, R, h1) \<in> mLIST)"
apply safe
apply (induct n)
apply (erule mLIST.elims, safe)
apply (rule mLIST_NIL)
apply (erule mLIST.elims, safe)
apply (rule mLIST_CONS) 
apply (erule thin_rl) apply (simp add: sameOH_def)
apply (erule thin_rl) apply (simp add: sameOH_def)
apply (erule thin_rl) apply (simp add: sameOH_def)
apply (erule thin_rl) apply (simp add: sameOH_def)
apply (subgoal_tac "(na, ha\<lfloor>a\<diamondsuit>F1\<rfloor>, X, h1) \<in> mLIST")
  apply (erule thin_rl)
  apply (subgoal_tac "h1\<lfloor>a\<diamondsuit>F1\<rfloor> = ha\<lfloor>a\<diamondsuit>F1\<rfloor>", clarsimp)
  apply (erule_tac x=a in allE, clarsimp, simp add: sameOH_def)
apply (subgoal_tac "\<forall>l. l \<in> X \<longrightarrow> sameOH {l} ha h1")
apply (rotate_tac 1, erule thin_rl)
apply fast
apply fast
done

lemma regionPreserved:"\<lbrakk>(v,h,T,R,S):reg; \<forall> l. l : R \<longrightarrow> sameOH {l} h h1\<rbrakk> \<Longrightarrow> (v,h1,T,R,S):reg"
apply (erule reg.elims, safe)
apply (rule regNone)
apply (rule regList)
  apply (subgoal_tac "(n, r, R, h1) \<in> mLIST", assumption) apply (erule mLIST_Preserved, fast)
  apply simp
apply (rule regInt)
done

lemma reg_Unique[rule_format]: "(v, h, T, R, S) : reg \<Longrightarrow> (\<forall> RR SS . (v, h, T, RR, SS) : reg \<longrightarrow> (R=RR \<and> S=SS))"
apply (erule reg.induct)
apply clarsimp
apply (erule reg.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, clarsimp)apply (subgoal_tac "n = na \<and> R = Ra", clarsimp)
apply (rule mLIST_Unique, assumption, assumption)
apply clarsimp
apply (erule reg.elims, simp_all)
done

lemma DAss_PConst: "DAss n G X A nn Y Z E h hh v p \<Longrightarrow> DAss n G X A nn Y Z E h hh v pp"
by (simp add: DAss_def)

lemma DA_Let_RPrim:
  "\<lbrakk>(C, ([z],[]), Cz) : ContextUnion;
    GETr C x = Some k;
    GETr C y = Some k;
    G \<rhd> e : DAss n Cz X A m Y Z
   \<rbrakk>\<Longrightarrow> 
   G \<rhd> (LET z = RPrimop f x y IN e END): DAss n C X A m Y Z"
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply (rule vdm_rprim)
apply assumption
apply (rotate_tac -1, erule thin_rl, clarsimp)
apply (subgoal_tac "DAss n C X A m Y Z E h hh v p2")
apply (erule DAss_PConst)
apply (subgoal_tac "ContextRDom C = ContextRDom Cz")
prefer 2 apply (erule ContextUnion.elims, clarsimp)
         apply (simp add: ContextRDom_def)
apply (subgoal_tac "\<forall> x . x: ContextRDom C \<longrightarrow> GETr Cz x = GETr C x")
prefer 2 apply (clarsimp) apply (rule UnionGet5) apply simp apply simp
apply (simp add: DAss_def, safe)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE)
apply rule apply clarsimp apply (subgoal_tac "xa : ContextRDom Cz \<and> xx : ContextRDom Cz", clarsimp) 
           prefer 2 apply (rule, erule SubsetTriv, assumption, erule SubsetTriv, assumption) 
           apply (rotate_tac 10, erule_tac x=xa in allE)
           apply (rotate_tac -1, erule_tac x=xx in allE)
           apply (erule_tac x=Rx in allE, erule_tac x=Rxx in allE)
           apply (erule impE) apply clarsimp
             apply rule apply (rule_tac x=Sx in exI, clarsimp) apply (rule_tac x=Sxx in exI, clarsimp) 
           apply simp
  apply clarsimp apply (rotate_tac -3, erule_tac x=xa in allE, erule_tac x=Rx in allE, clarsimp)
apply clarsimp
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
apply rule apply clarsimp apply (rotate_tac 13) apply (erule_tac x=ya in allE, erule_tac x=Ry in allE)
           apply (erule impE, clarsimp) apply (rule_tac x=Sy in exI) apply (rotate_tac 12)
           apply (erule_tac x=ya in allE) apply (erule impE) apply (erule SubsetTriv, assumption) apply clarsimp
           apply simp
apply rule apply clarsimp apply (erule_tac x=l in allE) apply (erule impE, clarsimp) apply (rotate_tac -4, erule_tac x=za in allE, erule_tac x=Rz in allE)
           apply (erule impE, rule, assumption, rule_tac x=Sz in exI)
           apply (erule_tac x=za in allE) apply (erule impE, erule SubsetTriv, assumption) apply clarsimp
           apply simp apply simp
apply rule apply clarsimp apply (subgoal_tac "xa : {l. \<exists>z. z \<in> Z \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr Cz z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", clarsimp)
                            apply (rule_tac x=za in exI, clarsimp) apply (rule_tac x=Rz in exI, clarsimp)
                            apply (rule_tac x=Sz in exI, erule_tac x=za in allE, erule impE, erule SubsetTriv, assumption) 
                            apply clarsimp
                          apply (erule thin_rl, erule thin_rl, erule thin_rl, 
                                 erule thin_rl, erule thin_rl, erule thin_rl, 
                                 erule thin_rl, erule thin_rl, erule thin_rl,
                                 erule thin_rl, erule thin_rl, erule thin_rl, 
                                 erule thin_rl, erule thin_rl, erule thin_rl, 
                                 erule thin_rl, erule thin_rl)
                            apply (rotate_tac 1, erule thin_rl) apply fast
apply clarsimp apply (rotate_tac -4,erule_tac x=q in allE) apply(rotate_tac -1, erule_tac x=CS in allE)
  apply (erule impE)
  prefer 2 apply clarsimp
apply (subgoal_tac "\<exists> C1 C2 . (E, h, (C1,C2), CS) \<in> ContextSize \<and> C = (C1,C2)",clarsimp)
apply (erule ContextSizePreserved)
apply simp
apply (erule ContextUnion.elims, simp_all, clarsimp)
apply (rule_tac x="fst C" in exI, rule_tac x="snd C" in exI, simp)
done

lemma DA_Let_HD: 
  "\<lbrakk>G \<rhd> e : DAss n Ch X A m Y Z;
    (C, ([h],[]), Ch) : ContextUnion;
    GETr C x = Some (ListET k)
   \<rbrakk>\<Longrightarrow> 
   G \<rhd> (LET h = GetFi x F0 IN e END): DAss n C X A m Y Z"
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply (rule vdm_getfi)
apply assumption
apply (erule thin_rl, clarsimp)
apply (subgoal_tac "DAss n C X A m Y Z E ha hh v p2")
apply (erule DAss_PConst)
apply (subgoal_tac "ContextRDom C = ContextRDom Ch")
prefer 2 apply (erule ContextUnion.elims, clarsimp)
         apply (simp add: ContextRDom_def)
apply (subgoal_tac "\<forall> x . x: ContextRDom C \<longrightarrow> GETr Ch x = GETr C x")
prefer 2 apply (clarsimp) apply (rule UnionGet5) apply simp apply simp
apply (simp add: DAss_def, safe)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE)
apply rule apply clarsimp apply (subgoal_tac "xa : ContextRDom Ch \<and> xx : ContextRDom Ch", clarsimp) 
           prefer 2 apply (rule, erule SubsetTriv, assumption, erule SubsetTriv, assumption) 
           apply (rotate_tac 10, erule_tac x=xa in allE)
           apply (rotate_tac -1, erule_tac x=xx in allE)
           apply (erule_tac x=Rx in allE, erule_tac x=Rxx in allE)
           apply (erule impE) apply clarsimp
             apply rule apply (rule_tac x=Sx in exI, clarsimp) apply (rule_tac x=Sxx in exI, clarsimp) 
           apply simp
  apply clarsimp apply (rotate_tac -3, erule_tac x=xa in allE, erule_tac x=Rx in allE, clarsimp)
apply clarsimp
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
apply rule apply clarsimp apply (rotate_tac 13) apply (erule_tac x=y in allE, erule_tac x=Ry in allE)
           apply (erule impE, clarsimp) apply (rule_tac x=Sy in exI) apply (rotate_tac 12)
           apply (erule_tac x=y in allE) apply (erule impE) apply (erule SubsetTriv, assumption) apply clarsimp
           apply simp
apply rule apply clarsimp apply (erule_tac x=l in allE) apply (erule impE, clarsimp) apply (rotate_tac -4, erule_tac x=z in allE, erule_tac x=Rz in allE)
           apply (erule impE, rule, assumption, rule_tac x=Sz in exI)
           apply (erule_tac x=z in allE) apply (erule impE, erule SubsetTriv, assumption) apply clarsimp
           apply simp apply simp
apply rule apply clarsimp apply (subgoal_tac "xa : {l. \<exists>z. z \<in> Z \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), ha, GETr Ch z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", clarsimp)
                            apply (rule_tac x=z in exI, clarsimp) apply (rule_tac x=Rz in exI, clarsimp)
                            apply (rule_tac x=Sz in exI, erule_tac x=z in allE, erule impE, erule SubsetTriv, assumption) 
                            apply clarsimp
                          apply (erule thin_rl, erule thin_rl, erule thin_rl, 
                                 erule thin_rl, erule thin_rl, erule thin_rl, 
                                 erule thin_rl, erule thin_rl, erule thin_rl,
                                 erule thin_rl, erule thin_rl, erule thin_rl, 
                                 erule thin_rl, erule thin_rl, erule thin_rl, 
                                 erule thin_rl, erule thin_rl)
                            apply (rotate_tac 1, erule thin_rl) apply fast
apply clarsimp apply (rotate_tac -4,erule_tac x=q in allE) apply(rotate_tac -1, erule_tac x=CS in allE)
  apply (erule impE)
  prefer 2 apply clarsimp
apply (subgoal_tac "\<exists> C1 C2 . (E, ha, (C1,C2), CS) \<in> ContextSize \<and> C = (C1,C2)",clarsimp)
apply (erule ContextSizePreserved)
apply simp
apply (erule ContextUnion.elims, simp_all, clarsimp)
apply (rule_tac x="fst C" in exI, rule_tac x="snd C" in exI, simp)
done


lemma SizePreservedAux[rule_format]:
"(E, h, (C1,C2), CS) \<in> ContextSize \<Longrightarrow> 
(\<forall> h1. (\<forall> x R . x : ContextRDom (C1,C2) \<longrightarrow> ((\<exists> n . (RVal (E\<lfloor>x\<rfloor>),h, GETr (C1, C2) x, R, n) : reg) \<longrightarrow> (\<forall> l . l : R \<longrightarrow> sameOH {l} h h1))) 
 \<longrightarrow> (E, h1, (C1,C2),CS) \<in> ContextSize)"
apply (erule ContextSize.induct)
apply clarsimp
apply (rule ContextSizeNIL)
apply clarsimp
apply (rule ContextSizeCONS) defer 1
apply (erule_tac x=h1 in allE, erule impE)
apply clarsimp
apply (erule_tac x=xa in allE, erule impE) apply (simp add: ContextRDom_def)
apply (erule_tac x=Ra in allE, erule impE)
apply (rule_tac x=na in exI) apply (simp add: GETr_def) apply (simp add: ContextRDom_def) apply auto 
apply (rule regionPreserved, assumption)
apply (rotate_tac 2)
apply (erule thin_rl, clarsimp) 
apply (erule_tac x=x in allE, simp add: ContextRDom_def)
apply (erule_tac x=R in allE, erule impE) apply (rule_tac x= n in exI, simp add: GETr_def) apply fast
done

lemma SizePreserved:
"\<lbrakk>(E, h, C, CS) \<in> ContextSize;
   \<forall> x R n . x : ContextRDom C \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>),h, GETr C x, R, n) : reg \<longrightarrow> (\<forall> l . l : R \<longrightarrow> sameOH {l} h h1)
 \<rbrakk> \<Longrightarrow> (E, h1, C, CS) \<in> ContextSize"
apply clarsimp
apply (subgoal_tac "(E, h1, (fst C, snd C), CS) \<in> ContextSize", simp)
apply (rule SizePreservedAux)
prefer 2 apply simp
apply (erule_tac x=x in allE, clarsimp)
apply fast
apply clarsimp
done

lemma GETrTail:
"y \<notin> ContextRDom (a, b) \<Longrightarrow> GETr (a, b @ [(y, k)]) y = Some (ListET k)"
apply (induct b)
apply (simp add: GETr_def ContextRDom_def)
apply (simp add: GETr_def ContextRDom_def)
apply auto
done

(*Problem: the region of the result of e needs to be disjoint from any regions in D--
  but the definition of DAss requires Y \<subseteq> ContextRDom G.
Maybe we need to weaken the derivation of for e to "GD \<rhd> e : Dass .."???
lemma DA_Letr:
      "\<lbrakk>GG \<rhd> e : DAss n G eX (ListET k) n1 Y eX;
        GG \<rhd> ee : DAss n1 C eeX B n2 {} eeX;
        (D, ([],[(y,k)]), C) : ContextUnion;
        (G,D,GD) : ContextUnion; 
        eeX = ContextRDom C;
        eX = ContextRDom G;
        Y = ContextRDom D;
        X = ContextRDom GD\<rbrakk>
     \<Longrightarrow> GG \<rhd> (LET rf y = e IN ee END): DAss n GD X B n2 {} X"
apply (subgoal_tac "y \<notin> ContextRDom D \<and> insert y (ContextRDom D) = ContextRDom C", clarsimp)
  prefer 2 apply (erule ContextUnion.elims, clarsimp) apply (simp add: ContextRDom_def)
apply (subgoal_tac "ContextRDom GD =(ContextRDom G) \<union> ContextRDom D", clarsimp)
  prefer 2 apply (rotate_tac -3, erule ContextUnion.elims, clarsimp) apply (simp add: ContextRDom_def) 
apply (rule vdm_conseq)
apply (erule vdm_letr, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAss_def, safe)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE) 
  apply(rotate_tac 5, erule thin_rl)
  apply (rule, clarsimp)
    (*existence of Rx*)
    apply (rotate_tac 3) apply (erule thin_rl, erule thin_rl) 
    apply (erule_tac x=x in allE, clarsimp)
    apply (subgoal_tac "GETr GD x = GETr G x", rule_tac x=Rx in exI, rule_tac x=Sx in exI, clarsimp)
    apply (erule UnionGet5, assumption)
  apply (rule, clarsimp)
    (*Disjointness of Rx Rxx*)
    apply (rotate_tac 2) apply (erule thin_rl)
    apply (rotate_tac 1) apply (erule thin_rl)
    apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE)
    apply (erule impE) apply (rule, fast) apply (rule, fast) apply (rule, fast) 
      apply (rule, rule, subgoal_tac "GETr GD x = GETr G x", simp)
      apply (erule UnionGet5, assumption)
      apply (rule, subgoal_tac "GETr GD xx = GETr G xx", simp)
      apply (erule UnionGet5, assumption)
      apply simp
    apply clarsimp
    (* Disjointness of Rx and F*)
    apply (rotate_tac 2) apply (erule thin_rl, erule thin_rl)
    apply (erule_tac x=x in allE, erule_tac x=Rx in allE) 
    apply (erule impE) apply (rule, fast)
      apply (rule, subgoal_tac "GETr GD x = GETr G x", simp)
      apply (erule UnionGet5, assumption)
    apply simp
apply clarsimp
apply (subgoal_tac "\<forall> v hhh x R S. x : ContextRDom C \<longrightarrow> 
                                 (v, hhh, GETr C x, R, S) \<in> reg \<longrightarrow> 
                                 ((x = y \<longrightarrow> GETr C x = Some (ListET k) \<and> (v,hhh,Some (ListET k),R,S) : reg) \<and> (x \<noteq> y \<longrightarrow> (v, hhh, GETr D x, R, S) \<in> reg))")
prefer 2 apply (rotate_tac 5, erule thin_rl)
         apply clarsimp
         apply rule apply clarsimp apply (erule ContextUnion.elims, clarsimp) 
                   apply (subgoal_tac "GETr (a, b @ [(y, k)]) y = Some (ListET k)", clarsimp) apply (erule GETrTail) 
         apply clarsimp
         apply (subgoal_tac "GETr D x = GETr C x", clarsimp)
         apply (erule ContextUnion.elims, clarsimp) apply (simp add: GETr_def)
apply (subgoal_tac "\<forall> v hhh x R S. x : ContextRDom C \<longrightarrow> 
                                 ((x = y \<longrightarrow> (v, hhh, Some (ListET k), R, S) \<in> reg \<longrightarrow> (v, hhh, GETr C x, R, S) \<in> reg) \<and> 
                                  (x \<noteq> y \<longrightarrow> (v, hhh, GETr D x, R, S) \<in> reg \<longrightarrow> (v, hhh, GETr C x, R, S) \<in> reg))")
prefer 2 apply (rotate_tac 5, erule thin_rl) apply (erule thin_rl,erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply (rotate_tac 2)
         apply (erule thin_rl, erule thin_rl, rotate_tac 1, erule thin_rl, erule thin_rl, rotate_tac 1, erule thin_rl)
         apply clarsimp
         apply (rule, clarsimp) apply (subgoal_tac "GETr C y = Some (ListET k)", clarsimp) apply (erule ContextUnion.elims, clarsimp)  apply (erule GETrTail)
         apply clarsimp
         apply (subgoal_tac "GETr D x = GETr C x", clarsimp)
         apply (erule ContextUnion.elims, clarsimp)  apply (simp add: GETr_def)
apply (subgoal_tac "\<forall> x R S. x : ContextRDom D \<longrightarrow> 
                                 (RVal (E\<lfloor>x\<rfloor>), h, GETr GD x, R, S) \<in> reg \<longrightarrow> 
                                 (RVal (E\<lfloor>x\<rfloor>), h1, GETr D x, R, S) \<in> reg")
prefer 2
  apply (rotate_tac -2, erule thin_rl, erule thin_rl)
  apply (rotate_tac 5, erule thin_rl)
  apply clarsimp
  apply (subgoal_tac "GETr GD x = GETr D x", simp)
  apply (rule regionPreserved, assumption)
  apply clarsimp
  apply (erule_tac x=l in allE, erule impE)
    apply rule
    apply (rotate_tac 2) apply (erule thin_rl)
    apply (erule_tac x= x in allE, rotate_tac -1, erule_tac x= Ra in allE)
    apply (erule impE)
      apply rule apply clarsimp 
      apply (rule, clarsimp, assumption)
    apply (erule thin_rl)
    apply (rotate_tac 2, erule thin_rl)
    apply (rotate_tac 2, erule thin_rl)
    apply fast
    apply clarsimp
    apply (rotate_tac 2, erule thin_rl)
    apply (erule_tac x=x in allE, rotate_tac -1, 
           erule_tac x=z in allE, rotate_tac -1,
           erule_tac x=Ra in allE, rotate_tac -1, 
           erule_tac x=Rz in allE, clarsimp)
    apply (erule thin_rl, erule impE)
      apply rule apply(erule ContextUnion_Distinct, assumption, assumption) 
      apply (rule, rule, assumption)
      apply (subgoal_tac "GETr GD z = GETr G z", clarsimp)
      apply (rule, assumption)
      apply (erule UnionGet5, assumption)
      apply (rotate_tac 2, erule thin_rl, rotate_tac 2, erule thin_rl, fast)
    apply assumption
  apply (erule  UnionGet6, assumption)
apply(subgoal_tac "\<forall>x. x \<in> ContextRDom D \<longrightarrow> 
                       (\<forall> R S. (RVal (renv E x), h1, GETr D x, R, S) \<in> reg \<longrightarrow> 
                       (RVal (renv E x), h, GETr GD x, R, S) \<in> reg)")
prefer 2
  apply (rotate_tac -3, erule thin_rl, erule thin_rl)
  apply (rotate_tac 6, erule thin_rl)
  apply (rotate_tac 3, erule thin_rl, erule thin_rl)
  apply (rotate_tac 2, erule thin_rl, erule thin_rl)
  apply clarsimp
  apply (erule_tac x=x in allE, clarsimp)
  apply (erule_tac x=x in allE)
  apply clarsimp
  apply (subgoal_tac "GETr GD x = GETr D x", simp)
  apply (erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Sx in allE, clarsimp) 
  apply (subgoal_tac "Rx = Ra \<and> Sx = Sa", clarsimp)
  apply (erule reg_Unique, assumption)
  apply (erule UnionGet6, assumption)
apply (erule_tac x=FF in allE, rotate_tac -1)
apply (erule_tac x=M in allE)
apply (rotate_tac -1, erule impE)
  apply (rule, assumption)
  apply rule apply clarify
     apply (case_tac "x=y", clarify) apply (rule_tac x=R in exI, rule_tac x=S in exI)
                                     apply (rotate_tac -5, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
                                     apply (subgoal_tac "GETr C y = Some (ListET k)", clarsimp)
                                     apply (erule ContextUnion.elims, simp, clarsimp) apply (erule GETrTail)
             apply (subgoal_tac "x: ContextRDom D") prefer 2 apply(rotate_tac 4)
                                                             apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                                                             apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                                                             apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, fast)
                apply (erule_tac x=x in allE, clarify) apply (rotate_tac -7) 
                apply (erule_tac x=x in allE, erule_tac x=Rx in allE, erule_tac x=Sx in allE, clarify)
                apply (rotate_tac -2)
                apply (erule_tac x="RVal (renv E x)" in allE, erule_tac x=h1 in allE, rotate_tac -1)
                apply (erule_tac x=x in allE, erule_tac x=Rx in allE, erule_tac x=Sx in allE, clarify)
                apply (rule_tac x=Rx in exI, rule_tac x=Sx in exI, simp)
  apply rule apply clarify
             apply (case_tac "x=y", clarify) (* we have xx \<noteq> y by xx \<noteq> x*)
             apply (subgoal_tac "xx \<in> ContextRDom D") prefer 2
                apply (rotate_tac 4, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
                apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                apply (erule thin_rl, erule thin_rl, fast) (* here is where* the problem with R and D becomes apparent*)
              apply (rotate_tac 4, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply (erule_tac x=xx in allE, erule_tac x=Rxx in allE)
              apply (erule impE, rule, assumption) apply (rule_tac x=Sxx in exI)
                apply (erule_tac x="RVal (renv E\<lfloor>y:=r\<rfloor> xx)" in allE, erule_tac x=h1 in allE, rotate_tac -1)
                apply (erule_tac x="xx" in allE, erule_tac x=Rxx in allE, rotate_tac -1, erule_tac x=Sxx in allE, clarify)
                apply (rotate_tac -2, erule thin_rl, erule impE, clarsimp)


                apply (rotate_tac -9, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply clarsimp
             apply (rotate_tac 6) apply (erule_tac x=x in allE, rotate_tac -1) apply (erule_tac x=xx in allE, rotate_tac -1)
                                  apply (erule_tac x=Rx in allE, rotate_tac -1) apply (erule_tac x=Rxx in allE, rotate_tac -1)
             apply (erule impE)
               apply (rule, erule ContextUnion_Dom2, assumption) 
               apply (rule, erule ContextUnion_Dom2, assumption) 
               apply (rule, assumption)
               apply (rule) apply (erule thin_rl)
                            apply (erule_tac x="RVal (renv E x)" in allE, rotate_tac -1)
                            apply (erule_tac x="h1" in allE, rotate_tac -1)
                            apply (erule_tac x="x" in allE, rotate_tac -1)
                            apply (erule_tac x="Rx" in allE, rotate_tac -1)
                            apply (erule_tac x="Sx" in allE, rotate_tac -1)
                            apply (erule impE, assumption)
                            apply (erule impE, assumption)
                            apply (rotate_tac 9)
                            apply (erule_tac x=x in allE, rotate_tac -1, erule impE, assumption)
                            apply (rotate_tac -1, erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Sx in allE, rotate_tac -1)
                            apply (erule impE, assumption) apply (rule, assumption)
                            apply (erule thin_rl)
                            apply (erule_tac x="RVal (renv E xx)" in allE, rotate_tac -1)
                            apply (erule_tac x="h1" in allE, rotate_tac -1)
                            apply (erule_tac x="xx" in allE, rotate_tac -1)
                            apply (erule_tac x="Rxx" in allE, rotate_tac -1)
                            apply (erule_tac x="Sxx" in allE, rotate_tac -1)
                            apply (erule impE, assumption)
                            apply (erule impE, assumption)
                            apply (rotate_tac 9)
                            apply (erule_tac x=xx in allE, rotate_tac -1, erule impE, assumption)
                            apply (rotate_tac -1, erule_tac x=Rxx in allE, rotate_tac -1, erule_tac x=Sxx in allE, rotate_tac -1)
                            apply (erule impE, assumption) apply (rule, assumption)
             apply (assumption)
   apply clarify
     apply (subgoal_tac "x \<in> ContextRDom D") prefer 2
                apply (rotate_tac -6, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply clarsimp
     apply (rotate_tac 7) apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=Rx in allE, rotate_tac -1)
     apply (erule impE, rule, erule ContextUnion_Dom2, assumption)
     apply (erule_tac x="RVal (renv E x)" in allE, rotate_tac -1)
     apply (erule_tac x="h1" in allE, rotate_tac -1)
     apply (erule_tac x="x" in allE, rotate_tac -1)
     apply (erule_tac x="Rx" in allE, rotate_tac -1)
     apply (erule_tac x="Sx" in allE, rotate_tac -1)
     apply (erule impE, assumption)
     apply (erule impE, assumption)
     apply (rotate_tac 9)
     apply (erule_tac x=x in allE, rotate_tac -1, erule impE, assumption)
     apply (rotate_tac -1, erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Sx in allE, rotate_tac -1)
     apply (erule impE, assumption) apply (rule, assumption)
   apply (subgoal_tac "Rx \<inter> {l. \<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)} = {}")
     apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (rotate_tac 1)
     apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (rotate_tac 2, erule thin_rl, erule thin_rl)
     apply fast
   apply (rule, rule)
     apply (subgoal_tac "xa \<in> Rx \<and> xa :{l. \<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
     prefer 2 apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply (rotate_tac 3, erule thin_rl, erule thin_rl)
              apply fast
     apply (erule conjE)
     apply (subgoal_tac "\<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> xa \<in> Rz)")
     prefer 2 apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply (rotate_tac 3, erule thin_rl, erule thin_rl)
              apply fast
     apply (erule exE, (erule conjE)?)+
     apply (subgoal_tac "x \<noteq> z")
     prefer 2 apply (erule ContextUnion_Distinct, assumption, assumption)
     apply (rotate_tac 2, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (rotate_tac 12) apply (erule thin_rl)
     apply(erule_tac x=x in allE, rotate_tac -1) 
     apply(erule_tac x=z in allE, rotate_tac -1)
     apply(erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Rz in allE)
     apply (erule impE)
     apply (rule, erule ContextUnion_Dom2, assumption)
     apply (rule, erule ContextUnion_Dom1, assumption)
     apply (rule, erule ContextUnion_Distinct, assumption, assumption)
     apply rule apply (erule_tac x="RVal (renv E x)" in allE, rotate_tac -1)
                apply (erule_tac x="h1" in allE, rotate_tac -1)
                apply (erule_tac x="x" in allE, rotate_tac -1)
                apply (erule_tac x="Rx" in allE, rotate_tac -1)
                apply (erule_tac x="Sx" in allE, rotate_tac -1)
                apply (erule impE, assumption)
                apply (erule impE, assumption)
                apply (rotate_tac 11)
                apply (erule_tac x=x in allE, rotate_tac -1, erule impE, assumption)
                apply (rotate_tac -1, erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Sx in allE, rotate_tac -1)
                apply (erule impE, assumption) apply (rule, assumption)
                apply (rotate_tac 10, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                apply (subgoal_tac "GETr GD z = GETr G z", rule_tac x=Sz in exI, clarsimp)
                apply (erule UnionGet5, assumption)
                apply (rotate_tac 10, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
    apply fast
    apply safe
apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
   apply (erule_tac x=l in allE) 
      apply (erule impE, rule, assumption)
        apply (rule, rule, rule, erule conjE) 
                    apply(rotate_tac -3, erule_tac x=z in allE, rotate_tac -1, 
                          erule_tac x=Rz in allE, rotate_tac -1, erule impE)
                    apply (rule, erule ContextUnion_Dom1, assumption)
                    apply (erule exE, subgoal_tac "GETr GD z = GETr G z")
                    apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                    apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                    apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                    apply (rule_tac x=Sz in exI, clarsimp) 
                    apply (erule UnionGet5, assumption)
                    apply assumption
                    apply (erule SameOHTransitive)
                    apply (erule_tac x=l in allE, rotate_tac -1, erule impE)
                      apply rule apply (subgoal_tac "l \<notin> F \<union> {l. \<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
                        apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                               erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                        apply (rotate_tac 3, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                             erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                             erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl )
                        apply fast
                        apply (rotate_tac 14, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                        apply clarsimp apply (erule_tac x=z in allE, rotate_tac -1, erule_tac x=Rz in allE, erule impE)
                        apply (rule,erule ContextUnion_Dom1, assumption)
                        apply (subgoal_tac "GETr GD z = GETr G z", clarsimp) apply (rule, assumption)
                        apply (erule UnionGet5, assumption)
                        apply clarsimp
                      apply (rule, rule, rule) apply (erule conjE, erule exE)
                        apply (rotate_tac -3, erule_tac x=z in allE, rotate_tac -1, erule_tac x=Rz in allE, rotate_tac -1, erule impE)
                        apply (subgoal_tac "z : ContextRDom D", rotate_tac -1) apply (rule, erule ContextUnion_Dom2, assumption)
                        apply (rotate_tac -8) apply (erule_tac x=z in allE, rotate_tac -1, erule impE, assumption)
                        apply (rotate_tac -1, erule_tac x=Rz in allE, rotate_tac -1, erule_tac x=Sz in allE)
                        apply (rotate_tac -1, erule impE)
                           apply (rotate_tac -3) apply (erule_tac x="RVal (renv E z)" in allE, rotate_tac -1)
                                                 apply (erule_tac x="h1" in allE, rotate_tac -1)
                                                 apply (erule_tac x="z" in allE, rotate_tac -1)
                                                 apply (erule_tac x="Rz" in allE, rotate_tac -1)
                                                 apply (erule_tac x="Sz" in allE, rotate_tac -1)
                           apply (erule impE, assumption)
                           apply (erule impE, assumption) 
                           apply assumption
                    apply (rule, assumption)
                    apply (rotate_tac 16, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply clarsimp
                 apply assumption
              apply assumption
            apply (rotate_tac 14, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply simp
          apply (subgoal_tac "x \<in> FF \<or> x:{l. \<exists>z. z \<in> ContextRDom C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h1, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
                      apply (erule disjE) apply (rotate_tac 5, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                                               erule thin_rl, erule thin_rl, erule thin_rl)
                                          apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                                               erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                                               erule thin_rl)
                                          apply (rotate_tac 2, erule thin_rl) apply clarsimp
                                          apply (subgoal_tac "x : F \<union> {l. \<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
                                          prefer 2 apply (rotate_tac -1, erule thin_rl, fast)
                                          apply (subgoal_tac "x:F \<or> x : {l. \<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
                                          prefer 2 apply simp
                                          apply (erule disjE) apply simp
                                          apply (subgoal_tac "\<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> x \<in> Rz)")
                                          prefer 2 apply simp
                                          apply clarsimp
                                          apply (rule_tac x=z in exI, rule)
                                          apply (erule ContextUnion_Dom1, assumption)
                                          apply (subgoal_tac "GETr GD z = GETr G z", clarsimp)
                                          apply (rule, rule, rule, assumption, assumption)
                                          apply (erule UnionGet5, assumption)
                                        apply (rotate_tac 5, erule thin_rl, erule thin_rl, erule thin_rl)
                                        apply(rotate_tac 2, erule thin_rl)
                                        apply(rotate_tac 2, erule thin_rl)
                                        apply (subgoal_tac "\<exists>z. z \<in> ContextRDom C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h1, GETr C z, Rz, Sz) \<in> reg) \<and> x \<in> Rz)")
                                        prefer 2 apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply simp
                                        apply (erule exE, erule conjE, erule exE, erule conjE,erule exE)
                                        apply (subgoal_tac "z:ContextRDom D", rotate_tac -1)
                                        apply (rule_tac x=z in exI) apply (rule, erule ContextUnion_Dom2, assumption)
                                        apply (erule_tac x="RVal (renv E z)" in allE, rotate_tac -1)
                                        apply (erule_tac x="h1" in allE, rotate_tac -1)
                                        apply (erule_tac x="z" in allE, rotate_tac -1)
                                        apply (erule_tac x="Rz" in allE, rotate_tac -1)
                                        apply (erule_tac x="Sz" in allE, rotate_tac -1)
                                        apply (erule impE, assumption)
                                        apply (erule impE, assumption)
                                        apply (rotate_tac 2, erule thin_rl, erule thin_rl)
                                        apply (erule_tac x="z" in allE)
                                        apply (erule impE, assumption, rotate_tac -1)
                                        apply (erule_tac x="Rz" in allE, rotate_tac -1)
                                        apply (erule_tac x="Sz" in allE, rotate_tac -1)
                                        apply (erule impE, assumption)  
                                        apply (rule_tac x=Rz in exI, clarsimp)
                                        apply (rule_tac x=Sz in exI, clarsimp)
                                        apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, clarsimp)          
          apply (erule thin_rl, erule thin_rl, erule thin_rl,erule thin_rl, erule thin_rl, erule thin_rl)        
          apply (erule thin_rl, erule thin_rl, erule thin_rl,erule thin_rl, erule thin_rl, erule thin_rl)        
          apply (erule thin_rl, erule thin_rl, erule thin_rl,erule thin_rl, erule thin_rl, erule thin_rl)        
          apply (erule thin_rl, erule thin_rl, erule thin_rl,erule thin_rl)
          apply (rotate_tac 2, erule thin_rl) apply fastsimp
     apply (subgoal_tac "\<exists> CS1 CS2. (E, h, G, CS1) \<in> ContextSize \<and> (E, h, D, CS2) \<in> ContextSize \<and> CS1 + CS2 = CS", safe)
     prefer 2 apply (erule ContextUnion_ContextSize, assumption)
     apply (rotate_tac 13)
     apply (erule_tac x="CS2 + q" in allE, rotate_tac -1, erule_tac x=CS1 in allE)
     apply (erule impE, assumption)
     apply (erule impE, arith) 
     apply (rotate_tac 10)
     apply (erule_tac x=q in allE, rotate_tac -1, erule_tac x="S + CS2" in allE)
     apply (erule impE) prefer 2
     apply (erule impE, arith, assumption) 
   apply (erule reg.elims, safe)
   apply (subgoal_tac "(E<y:=ia>,ha,C, CS2) \<in> ContextSize", erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            simp)
   apply (rule ContextSizePreserved)
   apply (subgoal_tac "(E,ha,(fst D,snd D), CS2) \<in> ContextSize", assumption)
   apply (rule SizePreserved)
   apply (subgoal_tac "(E,h,D, CS2) \<in> ContextSize", rotate_tac 19, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply clarsimp
    apply assumption
    apply assumption
   apply (rotate_tac 19) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, clarsimp)
   apply (rotate_tac -7) 
   apply (erule_tac x=l in allE, erule impE)
   apply (subgoal_tac "x: ContextRDom D", rotate_tac -1)
   apply rule apply (rotate_tac -2) apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=R in allE, erule impE)
                  apply rule apply(erule ContextUnion_Dom2, assumption) 
                  apply (rule_tac x=na in exI)
                  apply (subgoal_tac "GETr GD x = GETr D x", clarsimp) apply (erule UnionGet6, assumption)
   apply (rotate_tac 10, erule thin_rl)
   apply (rotate_tac 12, erule thin_rl, erule thin_rl) apply fast
   apply clarsimp
   apply (subgoal_tac "x:ContextRDom D", rotate_tac -1)
   apply (rotate_tac -6) apply (erule_tac x=x in allE, rotate_tac -1) apply (erule_tac x=z in allE, rotate_tac -1)
                         apply (erule_tac x=R in allE, rotate_tac -1) apply (erule_tac x=Rz in allE, rotate_tac -1)
                         apply (erule impE)
                            apply (rule, erule ContextUnion_Dom2, assumption)
                            apply (rule, erule ContextUnion_Dom1, assumption)
                            apply (rule, subgoal_tac "ContextRDom G \<inter> ContextRDom D = {}")
                            apply (rotate_tac -2, erule thin_rl, rotate_tac 1, erule thin_rl, rotate_tac 13, erule thin_rl, fast) 
                            apply( rotate_tac -5, erule ContextUnion.elims, clarsimp)
                            apply rule apply (rule_tac x=na in exI, subgoal_tac "GETr GD x = GETr D x", clarsimp)
                                       apply (erule UnionGet6, assumption)
                                       apply (rule_tac x=Sz in exI, subgoal_tac "GETr GD z = GETr G z", clarsimp)
                                       apply (erule UnionGet5, assumption)
                            apply (rotate_tac -2, erule thin_rl, rotate_tac 1, erule thin_rl, rotate_tac 13, erule thin_rl, fast)
                          apply clarsimp
                        apply clarsimp
                      apply assumption
                   apply ((erule thin_rl)+, simp)
apply (erule ContextUnion.elims, safe) apply ((erule thin_rl)+, simp)
sorry 
*)

lemma DA_Letv:
      "\<lbrakk>G \<rhd> e : DAss n C1 X1 A n1 {} X1;
        G \<rhd> ee : DAss n1 C2 X2 B n2 {} X2;
        (C1,C2,C) : ContextUnion; 
        X = ContextRDom C;
        X1 = ContextRDom C1;
        X2 = ContextRDom C2\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): DAss n C X B n2 {} X"
apply (subgoal_tac "X = X1 \<union> X2", clarsimp)
  prefer 2 apply (erule ContextUnion.elims, clarsimp) apply (simp add: ContextRDom_def)
apply (rule vdm_conseq)
apply (erule vdm_letv, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAss_def, safe)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE) 
  apply(rotate_tac 2, erule thin_rl)
  apply (subgoal_tac "ContextRDom C1 \<subseteq> ContextRDom C")
    prefer 2 apply(erule thin_rl, erule thin_rl, erule thin_rl, 
                                 erule thin_rl, erule thin_rl, fast)
  apply (rule, clarsimp)
    (*existence of Rx*)
    apply (rotate_tac 2) apply (erule thin_rl, erule thin_rl) 
    apply (erule_tac x=x in allE, erule impE, fast)
    apply (subgoal_tac "GETr C x = GETr C1 x", clarsimp)
    apply (erule UnionGet5, assumption)
  apply (rule, clarsimp)
    (*Disjointness of Rx Rxx*)
    apply (rotate_tac 1) apply (erule thin_rl)
    apply (rotate_tac 1) apply (erule thin_rl)
    apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE)
    apply (erule impE) apply (rule, fast) apply (rule, fast) apply (rule, fast) 
      apply (rule, rule, subgoal_tac "GETr C x = GETr C1 x", simp)
      apply (erule UnionGet5, assumption)
      apply (rule, subgoal_tac "GETr C xx = GETr C1 xx", simp)
      apply (erule UnionGet5, assumption)
      apply simp
    apply (rule, clarsimp)
    (* Disjointness of Rx and F*)
    apply (rotate_tac 1) apply (erule thin_rl, erule thin_rl)
    apply (erule_tac x=x in allE, erule_tac x=Rx in allE) 
    apply (erule impE) apply (rule, fast)
      apply (rule, subgoal_tac "GETr C x = GETr C1 x", simp)
      apply (erule UnionGet5, assumption)
    apply simp
apply clarsimp
apply (subgoal_tac "\<forall> x R S. x : ContextRDom C2 \<longrightarrow> 
                                 (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, R, S) \<in> reg \<longrightarrow> 
                                 (RVal (E\<lfloor>x\<rfloor>), h1, GETr C2 x, R, S) \<in> reg")
prefer 2
  apply (rotate_tac 2, erule thin_rl)
  apply clarsimp
  apply (subgoal_tac "GETr C x = GETr C2 x", simp)
  apply (rule regionPreserved, assumption)
  apply clarsimp
  apply (erule_tac x=l in allE, erule impE)
    apply rule
    apply (rotate_tac 2) apply (erule thin_rl)
    apply (erule_tac x= x in allE, rotate_tac -1, erule_tac x= Ra in allE)
    apply (erule impE)
      apply rule apply (erule ContextUnion_Dom2, assumption)
      apply (rule, simp)
    apply (rotate_tac 4, erule thin_rl)
    apply (rotate_tac 8, erule thin_rl)
    apply fast
    apply clarsimp
    apply (rotate_tac 1, erule thin_rl)
    apply (erule_tac x=x in allE, rotate_tac -1, 
           erule_tac x=z in allE, rotate_tac -1,
           erule_tac x=Ra in allE, rotate_tac -1, 
           erule_tac x=Rz in allE, clarsimp)
    apply (erule thin_rl, erule impE)
      apply rule apply(erule ContextUnion_Dom2, assumption) 
      apply rule apply(erule ContextUnion_Dom1, assumption) 
      apply rule apply(erule ContextUnion_Distinct, assumption, assumption) 
      apply (rule, rule, assumption)
      apply (subgoal_tac "GETr C z = GETr C1 z", clarsimp)
      apply (rule, assumption)
      apply (erule UnionGet5, assumption)
    apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
    apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
    apply fast
    apply simp
  apply (erule  UnionGet6, assumption)
apply(subgoal_tac "\<forall>x. x \<in> ContextRDom C2 \<longrightarrow> 
                       (\<forall>R S. (RVal (renv E x), h1, GETr C2 x, R, S) \<in> reg \<longrightarrow> 
                       (RVal (renv E x), h, GETr C x, R, S) \<in> reg)")
prefer 2
  apply clarsimp
  apply (rotate_tac 2, erule thin_rl)
  apply (rotate_tac 2, erule thin_rl)
  apply (rotate_tac 1)
  apply (subgoal_tac "GETr C x = GETr C2 x", simp)
  apply (erule_tac x=x in allE, clarsimp)
  apply (erule_tac x=x in allE)
  apply (erule impE) apply (erule ContextUnion_Dom2, assumption)
  apply clarsimp
  apply (rotate_tac -2) apply (erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Sx in allE, clarsimp) 
  apply (subgoal_tac "Rx = Ra \<and> Sx = Sa", clarsimp)
  apply (erule reg_Unique, assumption)
  apply (erule UnionGet6, assumption)
apply (subgoal_tac "\<forall> CS2. (E, h, C2, CS2) \<in> ContextSize \<longrightarrow> (E, h1, C2, CS2) \<in> ContextSize")
prefer 2 apply (clarify, erule SizePreserved)
         apply (rotate_tac 2, erule thin_rl)
         apply clarify apply (erule_tac x=l in allE, erule impE)
         apply (rule, erule_tac x=x in allE, rotate_tac -1, erule_tac x=Ra in allE, erule impE)
         apply (rule, erule thin_rl, erule thin_rl, erule thin_rl, 
                      erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, fast)
           apply (rule_tac x=na in exI) apply (subgoal_tac "GETr C x = GETr C2 x", clarsimp) apply (erule UnionGet6, assumption)
          apply (erule thin_rl, erule thin_rl, erule thin_rl, 
                 erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, fast)
          apply clarify apply (rotate_tac 2, erule_tac x=x in allE, rotate_tac -1, 
                               erule_tac x=z in allE, erule_tac x=Ra in allE, erule_tac x=Rz in allE)
                        apply (erule impE)
                        apply rule apply (erule thin_rl, erule thin_rl, erule thin_rl, 
                                          erule thin_rl, erule thin_rl, erule thin_rl, 
                                          erule thin_rl, erule thin_rl, erule thin_rl, fast)
                        apply rule apply (erule thin_rl, erule thin_rl, erule thin_rl, 
                                          erule thin_rl, erule thin_rl, erule thin_rl, 
                                          erule thin_rl, erule thin_rl, erule thin_rl, fast)
                        apply rule apply (erule ContextUnion_Distinct, assumption, assumption)
                        apply rule apply (rule_tac x=na in exI, subgoal_tac "GETr C x = GETr C2 x")
                                   apply  (erule thin_rl, erule thin_rl, erule thin_rl, 
                                          erule thin_rl, erule thin_rl, erule thin_rl, 
                                          erule thin_rl, erule thin_rl, erule thin_rl, clarsimp)
                                   apply (erule UnionGet6, assumption)
                         apply (rule_tac x=Sz in exI, subgoal_tac "GETr C z = GETr C1 z")
                                   apply  (erule thin_rl, erule thin_rl, erule thin_rl, 
                                          erule thin_rl, erule thin_rl, erule thin_rl, 
                                          erule thin_rl, erule thin_rl, erule thin_rl, clarsimp)
                                   apply (erule UnionGet5, assumption)
                         apply  (erule thin_rl, erule thin_rl, erule thin_rl, 
                                          erule thin_rl, erule thin_rl, erule thin_rl, 
                                          erule thin_rl, erule thin_rl, erule thin_rl, fast)
  apply assumption
apply (erule_tac x=FF in allE, rotate_tac -1)
apply (erule_tac x=M in allE)
apply (rotate_tac -1, erule impE)
  apply (rule, assumption)
  apply rule apply (rule, rule) apply (erule_tac x=x in allE, rotate_tac -1) apply (erule impE, erule ContextUnion_Dom2, assumption)
             apply (rotate_tac 5) apply (erule exE, erule exE, erule_tac x=x in allE, rotate_tac -1)
             apply (erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Sx in allE, rotate_tac -1)
             apply (erule impE, assumption)
             apply (erule impE, assumption)
             apply (rule, rule, assumption)
  apply rule apply clarify 
             apply (rotate_tac 4) apply (erule_tac x=x in allE, rotate_tac -1) apply (erule_tac x=xx in allE, rotate_tac -1)
                                  apply (erule_tac x=Rx in allE, rotate_tac -1) apply (erule_tac x=Rxx in allE, rotate_tac -1)
             apply (erule impE)
               apply (rule, erule ContextUnion_Dom2, assumption) 
               apply (rule, erule ContextUnion_Dom2, assumption) 
               apply (rule, assumption)
               apply (rule) apply (erule thin_rl) apply (erule_tac x=x in allE, rotate_tac -1, erule impE, assumption)
                            apply (rotate_tac -1, erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Sx in allE, rotate_tac -1)
                            apply (erule impE, assumption) apply (rule, assumption)
                apply (erule thin_rl) apply (erule_tac x=xx in allE, rotate_tac -1, erule impE, assumption)
                apply (rotate_tac -1, erule_tac x=Rxx in allE, rotate_tac -1, erule_tac x=Sxx in allE, rotate_tac -1)
                apply (erule impE, assumption) apply (rule, assumption)
             apply (assumption)
   apply clarify
     apply (rotate_tac 5) apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=Rx in allE, rotate_tac -1)
     apply (erule impE, rule, erule ContextUnion_Dom2, assumption)
     apply (erule_tac x=x in allE, rotate_tac -1, erule impE, assumption)
     apply (rotate_tac -1, erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Sx in allE)
     apply (rotate_tac -1, erule impE, assumption, rule, assumption)
   apply (subgoal_tac "Rx \<inter> {l. \<exists>z. z \<in> ContextRDom C1 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C1 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)} = {}") 
     apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (rotate_tac 1)
     apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply fast
   apply (rule, rule)
     apply (subgoal_tac "xa \<in> Rx \<and> xa : {l. \<exists>z. z \<in> ContextRDom C1 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C1 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
     prefer 2 apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply fast
     apply (erule conjE)
     apply (subgoal_tac "\<exists>z. z \<in> ContextRDom C1 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C1 z, Rz, Sz) \<in> reg) \<and> xa \<in> Rz)")
     prefer 2 apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply fast
     apply (erule exE, (erule conjE)?)+
     apply (subgoal_tac "x \<noteq> z")
     prefer 2 apply (erule ContextUnion_Distinct, assumption, assumption)
     apply (rotate_tac 2, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (rotate_tac 7) apply (erule thin_rl)
     apply(erule_tac x=x in allE, rotate_tac -1) 
     apply(erule_tac x=z in allE, rotate_tac -1)
     apply(erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Rz in allE)
     apply (erule impE)
     apply (rule, erule ContextUnion_Dom2, assumption)
     apply (rule, erule ContextUnion_Dom1, assumption)
     apply (rule, erule ContextUnion_Distinct, assumption, assumption)
     apply rule apply(erule_tac x=x in allE) apply (erule impE, assumption) 
                apply (rotate_tac -1, erule_tac x=Rx in allE) apply (rotate_tac -1, erule_tac x=Sx in allE) 
                apply (erule impE, assumption) apply (rule, assumption)
       apply (rule_tac x=Sz in exI) apply (subgoal_tac "GETr C z = GETr C1 z", clarsimp) apply (erule UnionGet5, assumption)
     apply (rotate_tac -8, erule thin_rl, erule thin_rl)
     apply fast
  apply (erule thin_rl)+ apply fast
apply clarsimp 
         apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, clarsimp)
         apply rule apply (rotate_tac 15, erule thin_rl, rotate_tac -15) apply clarsimp apply (erule_tac x=l in allE, clarsimp)
                    apply (erule impE, clarsimp)
                    apply(rotate_tac -4, erule_tac x=z in allE, rotate_tac -1, erule_tac x=Rz in allE, rotate_tac -1, erule impE)
                    apply (rule, erule ContextUnion_Dom1, assumption)
                    apply (subgoal_tac "GETr C z = GETr C1 z", rule, simp) apply (erule UnionGet5, assumption)
                    apply simp 
                    apply (erule SameOHTransitive)
                    apply (erule_tac x=l in allE, rotate_tac -1, erule impE)
                      apply rule apply (subgoal_tac "l \<notin> F \<union> {l. \<exists>z. z \<in> ContextRDom C1 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C1 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
                        apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                               erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                        apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                             erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                             erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl )
                        apply fast
                        apply clarsimp apply (rotate_tac -4,erule_tac x=z in allE, rotate_tac -1, erule_tac x=Rz in allE, erule impE)
                        apply (rule,erule ContextUnion_Dom1, assumption)
                        apply (subgoal_tac "GETr C z = GETr C1 z", clarsimp) apply (rule, assumption)
                        apply (erule UnionGet5, assumption)
                        apply clarsimp
                      apply (rule, rule, rule) apply (erule conjE, erule exE)
                        apply (rotate_tac -3, erule_tac x=z in allE, rotate_tac -1, erule_tac x=Rz in allE, rotate_tac -1, erule impE)
                        apply (rule, erule ContextUnion_Dom2, assumption)
                        apply (rotate_tac -8) apply (erule_tac x=z in allE, rotate_tac -1, erule impE, clarsimp)
                        apply (rotate_tac -1, erule_tac x=Rz in allE, rotate_tac -1, erule_tac x=Sz in allE)
                        apply (rotate_tac -1, erule impE, assumption)
                        apply (rule, assumption)
                        apply assumption
                    apply assumption
                    apply simp
         apply rule apply (rotate_tac 15, erule thin_rl, rotate_tac -15) apply (erule SubsetTransitive)
           apply rule apply (subgoal_tac "x \<in> FF \<or> x: {l. \<exists>z. z \<in> ContextRDom C2 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h1, GETr C2 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
                      apply (erule disjE) apply (rotate_tac 2, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                                               erule thin_rl, erule thin_rl, erule thin_rl)
                                          apply (rotate_tac 2, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                                               erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                                               erule thin_rl)
                                          apply (subgoal_tac "x : F \<union> {l. \<exists>z. z \<in> ContextRDom C1 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C1 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
                                          prefer 2 apply fast
                                          apply (subgoal_tac "x:F \<or> x : {l. \<exists>z. z \<in> ContextRDom C1 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C1 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
                                          prefer 2 apply simp
                                          apply (erule disjE) apply simp
                                          apply (subgoal_tac "\<exists>z. z \<in> ContextRDom C1 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C1 z, Rz, Sz) \<in> reg) \<and> x \<in> Rz)")
                                          prefer 2 apply simp
                                          apply (subgoal_tac "\<exists>z. z \<in> ContextRDom C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> x \<in> Rz)", simp)
                                          apply (clarsimp, rule_tac x=z in exI)
                                          apply (rule, erule ContextUnion_Dom1, assumption)
                                          apply (subgoal_tac "GETr C z = GETr C1 z", clarsimp)
                                          apply (rule, rule, rule, assumption, assumption)
                                          apply (erule UnionGet5, assumption)
                                        apply (rotate_tac 2, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                                        apply(rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            erule thin_rl, erule thin_rl, erule thin_rl) 
                                        apply (rotate_tac 2, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                                        apply (subgoal_tac "\<exists>z. z \<in> ContextRDom C2 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h1, GETr C2 z, Rz, Sz) \<in> reg) \<and> x \<in> Rz)")
                                        prefer 2 apply simp
                                        apply (subgoal_tac "\<exists>z. z \<in> ContextRDom C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> x \<in> Rz)", simp)
                                     apply (clarsimp, rule_tac x=z in exI) apply (rule, erule ContextUnion_Dom2, assumption)
                                     apply (erule_tac x=z in allE, clarsimp)
                                     apply (erule_tac x=Rz in allE, erule_tac x=Sz in allE, clarsimp)
                                     apply (rule, rule, rule, assumption, assumption)
                      apply simp
           apply (clarsimp) apply (rotate_tac 3, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                                 erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                            apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl)
                            apply (rotate_tac 1, erule thin_rl, erule thin_rl,
                                                 erule thin_rl, erule thin_rl, erule thin_rl)
                            apply (subgoal_tac "\<exists> CS1 CS2. (E, h, C1, CS1) \<in> ContextSize \<and> (E, h, C2, CS2) \<in> ContextSize \<and> CS1 + CS2 = CS", clarsimp)
                            apply (rotate_tac 1, erule_tac x="CS2 + q" in allE, rotate_tac -1, erule_tac x=CS1 in allE)
                            apply (erule_tac x="CS2" in allE, clarsimp) 
            apply (erule ContextUnion_ContextSize, assumption)
done

lemma Aux: "\<lbrakk>x : Dc; X \<subseteq> (Dc -{x})\<union>{t}\<rbrakk> \<Longrightarrow> (X - {t}) \<union> {x} \<subseteq> Dc"
by fast

lemma Aux1: "\<lbrakk>x : Dc; X \<subseteq> (Dc -{x})\<union>{t}; z: (X - {t}) \<union> {x}\<rbrakk> \<Longrightarrow> z:  Dc"
by (insert Aux, fast)

lemma CSize_LetTL:
      "\<lbrakk>(E, h, C, k+CS) \<in> ContextSize;
        (Cx, ([], [(x, k)]), C) \<in> ContextUnion;
        (([], [(t, k)]), Cx, Ct) \<in> ContextUnion;
        renv E x = Ref a\<rbrakk>
       \<Longrightarrow>(E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>, h, Ct, CS) \<in> ContextSize"
apply (subgoal_tac "\<exists> CS1 CS2. (E, h, Cx, CS1) \<in> ContextSize \<and> (E, h, ([],[(x,k)]), CS2) \<in> ContextSize \<and> CS1 + CS2 = k + CS", clarsimp)
prefer 2 apply (erule ContextUnion_ContextSize, assumption)
apply (rotate_tac -2)
apply (erule ContextSize.elims, simp_all, clarsimp)
apply (rotate_tac 3)
apply (erule ContextUnion.elims, clarsimp)
apply (rotate_tac 2)
apply (erule ContextSize.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, clarsimp)
apply (erule mLIST.elims, simp_all, clarsimp)
apply (subgoal_tac "(RVal (E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>\<lfloor>t\<rfloor>), h, Some (ListET k), X, k*n): reg")
prefer 2
  apply (subgoal_tac "(RVal (h\<lfloor>a\<diamondsuit>F1\<rfloor>), h, Some (ListET k), X, k*n): reg")
  apply clarsimp
  apply (erule regList, simp)
apply (subgoal_tac "(E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>, h, (aa, (t, k) # ba), (k * n) + CS1) \<in> ContextSize")
apply (subgoal_tac "k * n + CS1 = (CS1 + (k * n))", clarsimp) apply simp
apply (erule ContextSizeCONS)
apply (erule ContextSizePreserved)
apply (subgoal_tac "xa \<noteq> t", simp)
apply (erule ContextUnion.elims, simp_all, clarsimp)
apply (simp add: ContextRDom_def)
apply (simp add: ContextRDom_def)
done

lemma DA_Let_TL: 
  "\<lbrakk>G \<rhd> e : DAss nk Ct X A m Y Z;
    (Cx, ([],[(x,k)]), C) : ContextUnion;
    (([],[(t,k)]), Cx, Ct) : ContextUnion;
    GETr C x = Some (ListET k);
    nk = n+k; YY = Y-{t}; ZZ = (Z -{t})\<union> {x}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf t = GetFr x F1 IN e END) : DAss n C (ContextRDom C) A m YY ZZ"
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply (rule vdm_getfr)
apply assumption
apply (erule thin_rl, clarsimp)
apply (subgoal_tac "DAss n C (ContextRDom C) A m (Y - {t}) (insert x (Z-{t})) E h hh v p2")
apply (erule DAss_PConst)
apply (subgoal_tac "ContextRDom C = ContextRDom Cx \<union> {x} \<and> x \<notin> ContextRDom Cx")
prefer 2 apply (erule ContextUnion.elims, clarsimp)
         apply (simp add: ContextRDom_def)
apply (subgoal_tac "ContextRDom Ct = ContextRDom Cx \<union> {t} \<and> t \<notin> ContextRDom Cx")
prefer 2 apply (rotate_tac 1, erule ContextUnion.elims, clarsimp)
         apply (simp add: ContextRDom_def)
apply (subgoal_tac "GETr Ct t = Some (ListET k)")
prefer 2 apply (erule UnionGet3, simp) 
apply (simp add: DAss_def, clarsimp)
apply (subgoal_tac "Y - {t} \<subseteq> insert x (ContextRDom Cx) \<and>
                    insert x (Z - {t}) \<subseteq> insert x (ContextRDom Cx)", clarsimp)
prefer 2 apply rule apply(rotate_tac -1, erule thin_rl) apply fast
         apply(rotate_tac -1, erule thin_rl) apply fast
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE)
apply rule apply clarsimp 
  apply rule apply clarsimp apply (erule_tac x=x in allE, clarsimp)
    apply (erule reg.elims, simp_all, clarsimp)
    apply (erule mLIST.elims, simp_all, clarsimp)
    apply (rule, rule, erule regList, simp)
  apply (erule_tac x=xa in allE, clarsimp)
    apply (subgoal_tac "xa \<noteq> t")
    prefer 2 apply (clarsimp)
    apply (subgoal_tac "xa \<noteq> x")
    prefer 2 apply (clarsimp)
    apply clarsimp
    apply (subgoal_tac "GETr C xa = GETr Ct xa", rule, rule, simp)
      apply (erule UnionGet2, assumption)
      apply(erule UnionGet4, assumption, simp)
apply rule apply clarsimp 
       apply (rotate_tac -6, erule thin_rl)
       apply (case_tac "xa: ContextRDom Cx")
         apply (subgoal_tac "xa \<noteq> x") prefer 2 apply clarsimp
         apply(case_tac "xx: ContextRDom Cx") 
           apply (subgoal_tac "xx \<noteq> x") prefer 2 apply clarsimp
           apply (subgoal_tac "xa \<noteq> t \<and> xx \<noteq> t", clarsimp) 
             apply (rotate_tac -7) apply (erule_tac x=xa in allE, rotate_tac -1) 
           apply (erule_tac x=xx in allE, rotate_tac -1) apply (erule_tac x=Rx in allE, erule_tac x=Rxx in allE, rotate_tac -1)
           apply (erule impE, clarsimp, rule) apply (subgoal_tac "GETr C xa = GETr Ct xa", rule, clarsimp, assumption)
                                                apply (erule UnionGet2, assumption)  apply (erule UnionGet4, assumption, simp)
                                              apply (subgoal_tac "GETr C xx = GETr Ct xx", rule, clarsimp, assumption)
                                                apply (erule UnionGet2, assumption)  apply (erule UnionGet4, assumption, simp)
           apply simp              
           apply (rule, clarsimp, clarsimp)
         apply (subgoal_tac "xx = t", clarsimp)
           apply (erule_tac x=x in allE, clarsimp) 
             apply (subgoal_tac "Rxx \<subseteq> Rxa \<and> Rx \<inter> Rxa = {}", clarsimp) apply (rotate_tac -6, erule thin_rl) apply fast
             apply rule apply (rotate_tac 4, erule reg.elims, simp_all, clarsimp)
                        apply(erule reg.elims, simp_all, clarsimp) apply (rotate_tac -2, erule mLIST.elims, simp_all)
                        apply (subgoal_tac "nb=n \<and> Xa = R", clarsimp)
                        apply (erule mLIST_Unique, assumption)
             apply (erule_tac x=xa in allE, rotate_tac -1, erule_tac x=x in allE, erule_tac x=Rx in allE, erule_tac x=Rxa in allE)
               apply (erule impE, clarsimp)
               apply (rule, subgoal_tac "GETr C xa = GETr Ct xa", rule, clarsimp, assumption) 
                            apply (erule UnionGet2, assumption) apply (erule UnionGet4, assumption, simp)
               apply (rule, assumption)
             apply simp
           apply (subgoal_tac "xx : insert t (ContextRDom Cx)", clarsimp) apply (erule SubsetTriv, assumption)
       apply (subgoal_tac "xa = t", clarsimp)
           apply (erule_tac x=x in allE, clarsimp) 
             apply (subgoal_tac "Rx \<subseteq> Rxa \<and> Rxa \<inter> Rxx = {}", clarsimp) apply (rotate_tac -4, erule thin_rl) apply fast
             apply rule apply (erule reg.elims, simp_all, clarsimp)
                        apply(rotate_tac -3, erule reg.elims, simp_all, clarsimp) apply (rotate_tac -2, erule mLIST.elims, simp_all)
                        apply (subgoal_tac "nb=n \<and> Xa = R", clarsimp)
                        apply (erule mLIST_Unique, assumption)
             apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE, erule_tac x=Rxa in allE, erule_tac x=Rxx in allE)
               apply (erule impE, clarsimp)
               apply (subgoal_tac "xx : (ContextRDom Cx)", clarsimp)
                 apply rule apply fast
                 apply (rule, rule, assumption)
                 apply (subgoal_tac "GETr C xx = GETr Ct xx", rule, clarsimp, assumption) 
                        apply (erule UnionGet2, fast) apply (erule UnionGet4, fast, simp)
                 apply (subgoal_tac "xx : insert t (ContextRDom Cx)", clarsimp) apply (erule SubsetTriv, assumption)
               apply simp
       apply (subgoal_tac "xa : insert t (ContextRDom Cx)", clarsimp) apply (erule SubsetTriv, assumption) 
apply clarsimp
  apply (erule disjE)
  apply clarsimp apply(rotate_tac -2, erule_tac x=x in allE, erule_tac x=x in allE, clarsimp)
    apply(erule_tac x=Rxa in allE) apply (erule impE, rule_tac x=Sxa in exI, simp)
    apply (subgoal_tac "Rx \<subseteq> Rxa") apply (rotate_tac 16, erule thin_rl) apply fast
      apply (rotate_tac -2, erule reg.elims, simp_all, erule reg.elims, simp_all, clarsimp)
      apply (erule mLIST.elims, simp_all, clarsimp)
      apply (subgoal_tac "nb = na \<and> Xa = Ra", clarsimp)
      apply (erule mLIST_Unique, assumption)
  apply(subgoal_tac "xa \<noteq> t \<and> xa \<noteq> x", clarsimp) prefer 2 apply (rule, clarsimp, clarsimp)
    apply(rotate_tac -5, erule_tac x=xa in allE, rotate_tac -1, erule_tac x=Rx in allE)
    apply (erule impE, clarsimp) apply (subgoal_tac "GETr C xa = GETr Ct xa", rule, clarsimp, assumption)
                                         apply (erule UnionGet2, assumption) apply (erule UnionGet4, assumption, simp)
    apply simp
apply clarsimp
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
apply rule apply clarsimp apply (rotate_tac 19) apply (erule_tac x=y in allE, erule_tac x=Ry in allE)
           apply (erule impE, clarsimp) apply (rule_tac x=Sy in exI)
           apply (subgoal_tac "y \<noteq> x") prefer 2 apply (subgoal_tac "y : ContextRDom Cx", clarsimp) 
                                                apply (subgoal_tac "y : insert t (ContextRDom Cx)", clarsimp)
                                                apply (erule SubsetTriv, assumption)
           apply (subgoal_tac "GETr C y = GETr Ct y", clarsimp)
               apply (erule UnionGet2, assumption) apply (erule UnionGet4, assumption, simp) 
           apply simp
apply rule apply clarsimp apply (erule_tac x=l in allE) apply (erule impE, clarsimp) 
           apply (case_tac "z=x")
           apply clarsimp apply (subgoal_tac "x=t", clarsimp) apply (rotate_tac -4, erule_tac x=t in allE, erule_tac x=t in allE, clarsimp)
                            apply (erule_tac x=Rx in allE, erule impE) apply (rule, assumption)
                            apply (subgoal_tac "Rz \<subseteq> Rx") apply (rotate_tac 17, erule thin_rl, erule thin_rl)
                              apply (rotate_tac 2, erule thin_rl) apply (rotate_tac 2, erule thin_rl) apply fast
                            apply (rotate_tac -2, erule reg.elims, simp_all, clarsimp) apply (erule reg.elims, simp_all, clarsimp)
                            apply(erule mLIST.elims, simp_all, clarsimp)
                            apply (subgoal_tac "na=nb \<and> Rb=Xa", clarsimp) apply (erule mLIST_Unique, assumption)
                          apply (subgoal_tac "x : insert t (ContextRDom Cx)", clarsimp) apply (erule SubsetTriv, assumption)
           apply (case_tac "z=t")
           apply clarsimp apply (rotate_tac -5, erule_tac x=x in allE, erule_tac x=x in allE, clarsimp)
                            apply (erule_tac x=Rx in allE, erule impE) apply (rule, assumption)
                            apply (subgoal_tac "Rz \<subseteq> Rx") apply (rotate_tac 19, erule thin_rl, erule thin_rl)
                              apply (rotate_tac 2, erule thin_rl) apply (rotate_tac 2, erule thin_rl) apply fast
                            apply (rotate_tac -2, erule reg.elims, simp_all, clarsimp) apply (erule reg.elims, simp_all, clarsimp)
                            apply(erule mLIST.elims, simp_all, clarsimp)
                            apply (subgoal_tac "na=nb \<and> Rb=Xa", clarsimp) apply (erule mLIST_Unique, assumption)
           apply (rotate_tac -6, erule_tac x=z in allE, erule_tac x=Rz in allE)
             apply (erule impE, clarsimp) apply (subgoal_tac "GETr C z = GETr Ct z", rule, clarsimp, assumption) 
               apply (erule UnionGet2, assumption) apply (erule UnionGet4, assumption, simp) 
             apply simp
apply rule apply clarsimp 
           apply (subgoal_tac "\<exists>z. z \<in> Z \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> z), h, GETr Ct z, Rz, Sz) \<in> reg) \<and> xa \<in> Rz)")
           prefer 2 apply (subgoal_tac "xa : {l. \<exists>z. z \<in> Z \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> z), h, GETr Ct z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", clarsimp) apply (rotate_tac 15, erule thin_rl, erule thin_rl, erule thin_rl)
                   apply (rotate_tac 2, erule thin_rl, erule thin_rl)
                   apply (rotate_tac 2, erule thin_rl, erule thin_rl)
                   apply (rotate_tac 2, erule thin_rl, erule thin_rl) 
                   apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                   apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
                   apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)apply fast
           apply clarsimp apply (rotate_tac 16, erule thin_rl, erule thin_rl)
             apply(case_tac "z=t", clarsimp) apply (rule_tac x=x in exI, clarsimp)
               apply (rotate_tac -1, erule_tac x=x in allE, clarsimp) apply (rule_tac x=Rx in exI)
               apply (rule, rule_tac x=Sx in exI, simp)
               apply (rule SubsetTriv) prefer 2 apply(subgoal_tac "Rz \<subseteq> Rx", assumption)
                            apply (rotate_tac 2, erule reg.elims, simp_all, clarsimp) apply (erule reg.elims, simp_all, clarsimp)
                            apply(rotate_tac -2, erule mLIST.elims, simp_all, clarsimp)
                            apply (subgoal_tac "na = nb \<and> Ra=Xa", clarsimp) apply(erule mLIST_Unique, assumption)
             apply(subgoal_tac "z \<noteq> x") prefer 2 apply (subgoal_tac "z : ContextRDom Cx", clarsimp) 
                                                 apply (subgoal_tac "z : insert t (ContextRDom Cx)", clarsimp) 
                                                 apply (erule SubsetTriv, assumption) 
             apply (rule_tac x=z in exI, clarsimp) apply (rule_tac x=Rz in exI, clarsimp) 
               apply (rule_tac x=Sz in exI, subgoal_tac "GETr C z = GETr Ct z",clarsimp) 
                                            apply (erule UnionGet2, assumption) apply (erule UnionGet4, assumption, simp) 
apply clarsimp apply(rotate_tac -4, erule_tac x=q in allE) apply (rotate_tac -1, erule_tac x="CS - k" in allE)
               apply (subgoal_tac "CS = k + (CS -k)")
               apply (erule impE) apply (rule CSize_LetTL) apply (subgoal_tac "(E, h, C, k + (CS - k)) \<in> ContextSize", assumption) 
                  apply clarsimp 
               apply assumption 
               apply assumption 
               apply assumption 
               apply clarsimp 
               apply (subgoal_tac "\<exists> CS1 CS2. (E, h, Cx, CS1) \<in> ContextSize \<and> (E, h, ([], [(x, k)]), CS2) \<in> ContextSize \<and> CS1 + CS2 = CS")
               prefer 2 apply (erule ContextUnion_ContextSize, assumption)
                 apply clarsimp apply (rotate_tac -1, erule ContextSize.elims) apply(clarsimp) apply clarsimp
                 apply (rotate_tac -3, erule reg.elims) apply clarsimp apply clarsimp 
                 apply (rotate_tac -2, erule mLIST.elims, clarsimp) apply clarsimp 
                 apply clarsimp
done

lemma DA_Leti:
      "\<lbrakk>GG \<rhd> e : DAss n G eX IntET n1 {} eX;
        GG \<rhd> ee : DAss n1 C eeX B n2 {} eeX;
        (D, ([y],[]), C) : ContextUnion;
        (G,D,GD) : ContextUnion; 
        eeX = ContextRDom C;
        eX = ContextRDom G;
        X = ContextRDom GD\<rbrakk>
     \<Longrightarrow> GG \<rhd> (LET y = e IN ee END): DAss n GD X B n2 {} X"
apply (subgoal_tac "X = eeX \<union> eX \<and> ContextRDom D = ContextRDom C", clarsimp)
  prefer 2 apply (erule ContextUnion.elims, clarsimp)apply (erule ContextUnion.elims, clarsimp) apply (simp add: ContextRDom_def) apply fast
apply (rule vdm_conseq)
apply (erule vdm_leti, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAss_def, safe)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE) 
  apply(rotate_tac 4, erule thin_rl)
  apply (subgoal_tac "ContextRDom G \<subseteq> ContextRDom GD")
    prefer 2 apply(erule thin_rl, erule thin_rl, erule thin_rl, 
                                 erule thin_rl, erule thin_rl, fast)
  apply (rule, clarsimp)
    (*existence of Rx*)
    apply (rotate_tac 2) apply (erule thin_rl, erule thin_rl) 
    apply (erule_tac x=x in allE, erule impE, fast)
    apply (subgoal_tac "GETr GD x = GETr G x", clarsimp)
    apply (erule UnionGet5, assumption)
  apply (rule, clarsimp)
    (*Disjointness of Rx Rxx*)
    apply (rotate_tac 1) apply (erule thin_rl)
    apply (rotate_tac 1) apply (erule thin_rl)
    apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE)
    apply (erule impE) apply (rule, fast) apply (rule, fast) apply (rule, fast) 
      apply (rule, rule, subgoal_tac "GETr GD x = GETr G x", simp)
      apply (erule UnionGet5, assumption)
      apply (rule, subgoal_tac "GETr GD xx = GETr G xx", simp)
      apply (erule UnionGet5, assumption)
      apply simp
    apply clarsimp
    (* Disjointness of Rx and F*)
    apply (rotate_tac 1) apply (erule thin_rl, erule thin_rl)
    apply (erule_tac x=x in allE, erule_tac x=Rx in allE) 
    apply (erule impE) apply (rule, fast)
      apply (rule, subgoal_tac "GETr GD x = GETr G x", simp)
      apply (erule UnionGet5, assumption)
    apply simp
apply clarsimp
apply (subgoal_tac "\<forall> v hhh x R S. x : ContextRDom C \<longrightarrow> 
                                 (v, hhh, GETr C x, R, S) \<in> reg \<longrightarrow> 
                                 (v, hhh, GETr D x, R, S) \<in> reg")
prefer 2 apply (rotate_tac 4, erule thin_rl)
         apply clarsimp
         apply (subgoal_tac "GETr D x = GETr C x", clarsimp)
         apply (erule ContextUnion.elims, clarsimp) apply (simp add: GETr_def)
apply (subgoal_tac "\<forall> v hhh x R S. x : ContextRDom C \<longrightarrow> 
                                 (v, hhh, GETr D x, R, S) \<in> reg \<longrightarrow> 
                                 (v, hhh, GETr C x, R, S) \<in> reg")
prefer 2 apply (rotate_tac 4, erule thin_rl)
         apply clarsimp
         apply (subgoal_tac "GETr D x = GETr C x", clarsimp)
         apply (erule ContextUnion.elims, clarsimp) apply (simp add: GETr_def)
apply (subgoal_tac "\<forall> x R S. x : ContextRDom D \<longrightarrow> 
                                 (RVal (E\<lfloor>x\<rfloor>), h, GETr GD x, R, S) \<in> reg \<longrightarrow> 
                                 (RVal (E\<lfloor>x\<rfloor>), h1, GETr D x, R, S) \<in> reg")
prefer 2
  apply (rotate_tac -2, erule thin_rl, erule thin_rl)
  apply (rotate_tac 4, erule thin_rl)
  apply clarsimp
  apply (subgoal_tac "GETr GD x = GETr D x", simp)
  apply (rule regionPreserved, assumption)
  apply clarsimp
  apply (erule_tac x=l in allE, erule impE)
    apply rule
    apply (rotate_tac 2) apply (erule thin_rl)
    apply (erule_tac x= x in allE, rotate_tac -1, erule_tac x= Ra in allE)
    apply (erule impE)
      apply rule apply (subgoal_tac "x \<in> ContextRDom D", rotate_tac -1) apply (erule ContextUnion_Dom2, assumption) apply clarsimp
      apply (rule, simp)
    apply (rotate_tac 4, erule thin_rl)
    apply (rotate_tac 10, erule thin_rl)
    apply fast
    apply clarsimp
    apply (rotate_tac 1, erule thin_rl)
    apply (erule_tac x=x in allE, rotate_tac -1, 
           erule_tac x=z in allE, rotate_tac -1,
           erule_tac x=Ra in allE, rotate_tac -1, 
           erule_tac x=Rz in allE, clarsimp)
    apply (erule thin_rl, erule impE)
      apply (subgoal_tac "x:ContextRDom D", rotate_tac -1)
      apply rule apply(erule ContextUnion_Dom2, assumption) 
      apply rule apply(erule ContextUnion_Dom1, assumption) 
      apply rule apply(erule ContextUnion_Distinct, assumption, assumption) 
      apply (rule, rule, assumption)
      apply (subgoal_tac "GETr GD z = GETr G z", clarsimp)
      apply (rule, assumption)
      apply (erule UnionGet5, assumption)
      apply clarsimp
    apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
    apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
    apply fast
    apply simp
  apply (subgoal_tac "x \<in> ContextRDom D", rotate_tac -1) 
  apply (erule  UnionGet6, assumption)
  apply clarsimp
apply(subgoal_tac "\<forall>x. x \<in> ContextRDom D \<longrightarrow> 
                       (\<forall>R S. (RVal (renv E x), h1, GETr D x, R, S) \<in> reg \<longrightarrow> 
                       (RVal (renv E x), h, GETr GD x, R, S) \<in> reg)")
prefer 2
  apply (rotate_tac -3, erule thin_rl, erule thin_rl)
  apply (rotate_tac 5, erule thin_rl)
  apply (rotate_tac 2, erule thin_rl, erule thin_rl)
  apply clarsimp
  apply (erule_tac x=x in allE, clarsimp)
  apply (erule_tac x=x in allE)
  apply (erule impE) apply (subgoal_tac "x \<in> ContextRDom D", rotate_tac -1) apply (erule ContextUnion_Dom2, assumption) apply clarsimp
  apply clarsimp
  apply (subgoal_tac "GETr GD x = GETr D x", simp)
  apply (rotate_tac -3) apply (erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Sx in allE, clarsimp) 
  apply (subgoal_tac "Rx = Ra \<and> Sx = Sa", clarsimp)
  apply (erule reg_Unique, assumption)
  apply (subgoal_tac "x \<in> ContextRDom D", rotate_tac -1) apply (erule UnionGet6, assumption) apply clarsimp
apply (erule_tac x=FF in allE, rotate_tac -1)
apply (erule_tac x=M in allE)
apply (rotate_tac -1, erule impE)
  apply (rule, assumption)
  apply rule apply (rule, rule) apply (subgoal_tac "x: ContextRDom D", rotate_tac -1) apply (erule_tac x=x in allE, rotate_tac -1) 
             apply (erule impE, erule ContextUnion_Dom2, assumption)
             apply (rotate_tac -6, erule thin_rl) apply (erule exE, erule exE, erule_tac x=x in allE, rotate_tac -1)
             apply (erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Sx in allE, rotate_tac -1)
             apply (erule impE, assumption)
             apply (erule impE, assumption)
             apply (erule_tac x="RVal (renv E x)" in allE, rotate_tac -1)
             apply (erule_tac x="h1" in allE, rotate_tac -1)
             apply (erule_tac x="x" in allE, rotate_tac -1)
             apply (erule_tac x="Rx" in allE, rotate_tac -1)
             apply (erule_tac x="Sx" in allE, rotate_tac -1)
             apply (erule impE, assumption)
             apply (erule impE, assumption)
             apply (rule, rule, assumption)
             apply (rotate_tac -3, erule thin_rl, erule thin_rl, clarsimp)
  apply rule apply clarify
             apply (subgoal_tac "x \<in> ContextRDom D") prefer 2
                apply (rotate_tac -9, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply clarsimp
             apply (subgoal_tac "xx \<in> ContextRDom D") prefer 2 
                apply (rotate_tac -9, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply clarsimp
             apply (rotate_tac 6) apply (erule_tac x=x in allE, rotate_tac -1) apply (erule_tac x=xx in allE, rotate_tac -1)
                                  apply (erule_tac x=Rx in allE, rotate_tac -1) apply (erule_tac x=Rxx in allE, rotate_tac -1)
             apply (erule impE)
               apply (rule, erule ContextUnion_Dom2, assumption) 
               apply (rule, erule ContextUnion_Dom2, assumption) 
               apply (rule, assumption)
               apply (rule) apply (erule thin_rl)
                            apply (erule_tac x="RVal (renv E x)" in allE, rotate_tac -1)
                            apply (erule_tac x="h1" in allE, rotate_tac -1)
                            apply (erule_tac x="x" in allE, rotate_tac -1)
                            apply (erule_tac x="Rx" in allE, rotate_tac -1)
                            apply (erule_tac x="Sx" in allE, rotate_tac -1)
                            apply (erule impE, assumption)
                            apply (erule impE, assumption)
                            apply (rotate_tac 9)
                            apply (erule_tac x=x in allE, rotate_tac -1, erule impE, assumption)
                            apply (rotate_tac -1, erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Sx in allE, rotate_tac -1)
                            apply (erule impE, assumption) apply (rule, assumption)
                            apply (erule thin_rl)
                            apply (erule_tac x="RVal (renv E xx)" in allE, rotate_tac -1)
                            apply (erule_tac x="h1" in allE, rotate_tac -1)
                            apply (erule_tac x="xx" in allE, rotate_tac -1)
                            apply (erule_tac x="Rxx" in allE, rotate_tac -1)
                            apply (erule_tac x="Sxx" in allE, rotate_tac -1)
                            apply (erule impE, assumption)
                            apply (erule impE, assumption)
                            apply (rotate_tac 9)
                            apply (erule_tac x=xx in allE, rotate_tac -1, erule impE, assumption)
                            apply (rotate_tac -1, erule_tac x=Rxx in allE, rotate_tac -1, erule_tac x=Sxx in allE, rotate_tac -1)
                            apply (erule impE, assumption) apply (rule, assumption)
             apply (assumption)
   apply clarify
     apply (subgoal_tac "x \<in> ContextRDom D") prefer 2
                apply (rotate_tac -6, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply clarsimp
     apply (rotate_tac 7) apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=Rx in allE, rotate_tac -1)
     apply (erule impE, rule, erule ContextUnion_Dom2, assumption)
     apply (erule_tac x="RVal (renv E x)" in allE, rotate_tac -1)
     apply (erule_tac x="h1" in allE, rotate_tac -1)
     apply (erule_tac x="x" in allE, rotate_tac -1)
     apply (erule_tac x="Rx" in allE, rotate_tac -1)
     apply (erule_tac x="Sx" in allE, rotate_tac -1)
     apply (erule impE, assumption)
     apply (erule impE, assumption)
     apply (rotate_tac 9)
     apply (erule_tac x=x in allE, rotate_tac -1, erule impE, assumption)
     apply (rotate_tac -1, erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Sx in allE, rotate_tac -1)
     apply (erule impE, assumption) apply (rule, assumption)
   apply (subgoal_tac "Rx \<inter> {l. \<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)} = {}")
     apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (rotate_tac 1)
     apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (rotate_tac 2, erule thin_rl, erule thin_rl)
     apply fast
   apply (rule, rule)
     apply (subgoal_tac "xa \<in> Rx \<and> xa :{l. \<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
     prefer 2 apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply (rotate_tac 3, erule thin_rl, erule thin_rl)
              apply fast
     apply (erule conjE)
     apply (subgoal_tac "\<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> xa \<in> Rz)")
     prefer 2 apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
              apply (rotate_tac 3, erule thin_rl, erule thin_rl)
              apply fast
     apply (erule exE, (erule conjE)?)+
     apply (subgoal_tac "x \<noteq> z")
     prefer 2 apply (erule ContextUnion_Distinct, assumption, assumption)
     apply (rotate_tac 2, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
     apply (rotate_tac 12) apply (erule thin_rl)
     apply(erule_tac x=x in allE, rotate_tac -1) 
     apply(erule_tac x=z in allE, rotate_tac -1)
     apply(erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Rz in allE)
     apply (erule impE)
     apply (rule, erule ContextUnion_Dom2, assumption)
     apply (rule, erule ContextUnion_Dom1, assumption)
     apply (rule, erule ContextUnion_Distinct, assumption, assumption)
     apply rule apply (erule_tac x="RVal (renv E x)" in allE, rotate_tac -1)
                apply (erule_tac x="h1" in allE, rotate_tac -1)
                apply (erule_tac x="x" in allE, rotate_tac -1)
                apply (erule_tac x="Rx" in allE, rotate_tac -1)
                apply (erule_tac x="Sx" in allE, rotate_tac -1)
                apply (erule impE, assumption)
                apply (erule impE, assumption)
                apply (rotate_tac 11)
                apply (erule_tac x=x in allE, rotate_tac -1, erule impE, assumption)
                apply (rotate_tac -1, erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Sx in allE, rotate_tac -1)
                apply (erule impE, assumption) apply (rule, assumption)
                apply (rotate_tac 10, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                apply (subgoal_tac "GETr GD z = GETr G z", rule_tac x=Sz in exI, clarsimp)
                apply (erule UnionGet5, assumption)
                apply (rotate_tac 10, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
    apply fast
    apply safe
apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
   apply (erule_tac x=l in allE) 
      apply (erule impE, rule, assumption)
        apply (rule, rule, rule, erule conjE) 
                    apply(rotate_tac -3, erule_tac x=z in allE, rotate_tac -1, 
                          erule_tac x=Rz in allE, rotate_tac -1, erule impE)
                    apply (rule, erule ContextUnion_Dom1, assumption)
                    apply (erule exE, subgoal_tac "GETr GD z = GETr G z")
                    apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                    apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                    apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                    apply (rule_tac x=Sz in exI, clarsimp) 
                    apply (erule UnionGet5, assumption)
                    apply assumption
                    apply (erule SameOHTransitive)
                    apply (erule_tac x=l in allE, rotate_tac -1, erule impE)
                      apply rule apply (subgoal_tac "l \<notin> F \<union> {l. \<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
                        apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                               erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                        apply (rotate_tac 3, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                             erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                             erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl )
                        apply fast
                        apply (rotate_tac 14, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
                        apply clarsimp apply (erule_tac x=z in allE, rotate_tac -1, erule_tac x=Rz in allE, erule impE)
                        apply (rule,erule ContextUnion_Dom1, assumption)
                        apply (subgoal_tac "GETr GD z = GETr G z", clarsimp) apply (rule, assumption)
                        apply (erule UnionGet5, assumption)
                        apply clarsimp
                      apply (rule, rule, rule) apply (erule conjE, erule exE)
                        apply (rotate_tac -3, erule_tac x=z in allE, rotate_tac -1, erule_tac x=Rz in allE, rotate_tac -1, erule impE)
                        apply (subgoal_tac "z : ContextRDom D", rotate_tac -1) apply (rule, erule ContextUnion_Dom2, assumption)
                        apply (rotate_tac -8) apply (erule_tac x=z in allE, rotate_tac -1, erule impE, assumption)
                        apply (rotate_tac -1, erule_tac x=Rz in allE, rotate_tac -1, erule_tac x=Sz in allE)
                        apply (rotate_tac -1, erule impE)
                           apply (rotate_tac -3) apply (erule_tac x="RVal (renv E z)" in allE, rotate_tac -1)
                                                 apply (erule_tac x="h1" in allE, rotate_tac -1)
                                                 apply (erule_tac x="z" in allE, rotate_tac -1)
                                                 apply (erule_tac x="Rz" in allE, rotate_tac -1)
                                                 apply (erule_tac x="Sz" in allE, rotate_tac -1)
                           apply (erule impE, assumption)
                           apply (erule impE, assumption) 
                           apply assumption
                    apply (rule, assumption)
                    apply (rotate_tac 16, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply clarsimp
                 apply assumption
              apply assumption
            apply (rotate_tac 14, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply simp
          apply (subgoal_tac "x \<in> FF \<or> x:{l. \<exists>z. z \<in> ContextRDom C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h1, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
                      apply (erule disjE) apply (rotate_tac 5, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                                               erule thin_rl, erule thin_rl, erule thin_rl)
                                          apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                                               erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, 
                                                               erule thin_rl)
                                          apply (rotate_tac 2, erule thin_rl) apply clarsimp
                                          apply (subgoal_tac "x : F \<union> {l. \<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
                                          prefer 2 apply (rotate_tac -1, erule thin_rl, fast)
                                          apply (subgoal_tac "x:F \<or> x : {l. \<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
                                          prefer 2 apply simp
                                          apply (erule disjE) apply simp
                                          apply (subgoal_tac "\<exists>z. z \<in> ContextRDom G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> x \<in> Rz)")
                                          prefer 2 apply simp
                                          apply clarsimp
                                          apply (rule_tac x=z in exI, rule)
                                          apply (erule ContextUnion_Dom1, assumption)
                                          apply (subgoal_tac "GETr GD z = GETr G z", clarsimp)
                                          apply (rule, rule, rule, assumption, assumption)
                                          apply (erule UnionGet5, assumption)
                                        apply (rotate_tac 5, erule thin_rl, erule thin_rl, erule thin_rl)
                                        apply(rotate_tac 2, erule thin_rl)
                                        apply(rotate_tac 2, erule thin_rl)
                                        apply (subgoal_tac "\<exists>z. z \<in> ContextRDom C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h1, GETr C z, Rz, Sz) \<in> reg) \<and> x \<in> Rz)")
                                        prefer 2 apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply simp
                                        apply (erule exE, erule conjE, erule exE, erule conjE,erule exE)
                                        apply (subgoal_tac "z:ContextRDom D", rotate_tac -1)
                                        apply (rule_tac x=z in exI) apply (rule, erule ContextUnion_Dom2, assumption)
                                        apply (erule_tac x="RVal (renv E z)" in allE, rotate_tac -1)
                                        apply (erule_tac x="h1" in allE, rotate_tac -1)
                                        apply (erule_tac x="z" in allE, rotate_tac -1)
                                        apply (erule_tac x="Rz" in allE, rotate_tac -1)
                                        apply (erule_tac x="Sz" in allE, rotate_tac -1)
                                        apply (erule impE, assumption)
                                        apply (erule impE, assumption)
                                        apply (rotate_tac 2, erule thin_rl, erule thin_rl)
                                        apply (erule_tac x="z" in allE)
                                        apply (erule impE, assumption, rotate_tac -1)
                                        apply (erule_tac x="Rz" in allE, rotate_tac -1)
                                        apply (erule_tac x="Sz" in allE, rotate_tac -1)
                                        apply (erule impE, assumption)  
                                        apply (rule_tac x=Rz in exI, clarsimp)
                                        apply (rule_tac x=Sz in exI, clarsimp)
                                        apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, clarsimp)          
          apply (erule thin_rl, erule thin_rl, erule thin_rl,erule thin_rl, erule thin_rl, erule thin_rl)        
          apply (erule thin_rl, erule thin_rl, erule thin_rl,erule thin_rl, erule thin_rl, erule thin_rl)        
          apply (erule thin_rl, erule thin_rl, erule thin_rl,erule thin_rl, erule thin_rl, erule thin_rl)        
          apply (erule thin_rl, erule thin_rl, erule thin_rl,erule thin_rl)
          apply (rotate_tac 2, erule thin_rl) apply fastsimp
     apply (subgoal_tac "\<exists> CS1 CS2. (E, h, G, CS1) \<in> ContextSize \<and> (E, h, D, CS2) \<in> ContextSize \<and> CS1 + CS2 = CS", safe)
     prefer 2 apply (erule ContextUnion_ContextSize, assumption)
     apply (rotate_tac 13)
     apply (erule_tac x="CS2 + q" in allE, rotate_tac -1, erule_tac x=CS1 in allE)
     apply (erule impE, assumption)
     apply (erule impE, arith) 
     apply (rotate_tac 10)
     apply (erule_tac x=q in allE, rotate_tac -1, erule_tac x="S + CS2" in allE)
     apply (erule impE) prefer 2
     apply (erule impE, arith, assumption) 
   apply (erule reg.elims, safe)
   apply (subgoal_tac "(E<y:=ia>,ha,C, CS2) \<in> ContextSize", erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl,
                                                            simp)
   apply (rule ContextSizePreserved)
   apply (subgoal_tac "(E,ha,(fst D,snd D), CS2) \<in> ContextSize", assumption)
   apply (rule SizePreserved)
   apply (subgoal_tac "(E,h,D, CS2) \<in> ContextSize", rotate_tac 19, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) apply clarsimp
    apply assumption
    apply assumption
   apply (rotate_tac 19) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, clarsimp)
   apply (rotate_tac -7) 
   apply (erule_tac x=l in allE, erule impE)
   apply (subgoal_tac "x: ContextRDom D", rotate_tac -1)
   apply rule apply (rotate_tac -2) apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=R in allE, erule impE)
                  apply rule apply(erule ContextUnion_Dom2, assumption) 
                  apply (rule_tac x=na in exI)
                  apply (subgoal_tac "GETr GD x = GETr D x", clarsimp) apply (erule UnionGet6, assumption)
   apply (rotate_tac 10, erule thin_rl)
   apply (rotate_tac 12, erule thin_rl, erule thin_rl) apply fast
   apply clarsimp
   apply (subgoal_tac "x:ContextRDom D", rotate_tac -1)
   apply (rotate_tac -6) apply (erule_tac x=x in allE, rotate_tac -1) apply (erule_tac x=z in allE, rotate_tac -1)
                         apply (erule_tac x=R in allE, rotate_tac -1) apply (erule_tac x=Rz in allE, rotate_tac -1)
                         apply (erule impE)
                            apply (rule, erule ContextUnion_Dom2, assumption)
                            apply (rule, erule ContextUnion_Dom1, assumption)
                            apply (rule, subgoal_tac "ContextRDom G \<inter> ContextRDom D = {}")
                            apply (rotate_tac -2, erule thin_rl, rotate_tac 1, erule thin_rl, rotate_tac 13, erule thin_rl, fast) 
                            apply( rotate_tac -5, erule ContextUnion.elims, clarsimp)
                            apply rule apply (rule_tac x=na in exI, subgoal_tac "GETr GD x = GETr D x", clarsimp)
                                       apply (erule UnionGet6, assumption)
                                       apply (rule_tac x=Sz in exI, subgoal_tac "GETr GD z = GETr G z", clarsimp)
                                       apply (erule UnionGet5, assumption)
                            apply (rotate_tac -2, erule thin_rl, rotate_tac 1, erule thin_rl, rotate_tac 13, erule thin_rl, fast)
                          apply clarsimp
                        apply clarsimp
                      apply assumption
                   apply ((erule thin_rl)+, simp)
apply (erule ContextUnion.elims, safe) apply ((erule thin_rl)+, simp)
done

lemma DA_Free: "G \<rhd> (DIAM\<bullet>Free ([RNarg x])) :  DAss 0 ([],[(x,k)]) {} (ListET k) 1 {} {x}"
sorry text {*needs a treatment of getstatic -- extend steffen-contexts by entries for ststic fields?
apply (rule vdm_conseq)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Free)
apply (rule vdm_conseq)
apply (rule DA_Letr)
*}

lemma DA_Make_IID: "G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal i), INarg x, RNarg y])) :  DAss (Suc k) ([x],[(y,k)]) {y} (ListET k) 0 {} {}"
sorry text {*needs specs for alloc and fill
apply (rule vdm_conseq)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Make_IID)
apply (rule vdm_conseq)
apply (rule DA_Letr)
*}

end
