theory DAssertSep = Comb:

(******************* NATURAL ARITHMETICS GEMS **********************)

lemma arithDistr:  "(k::nat) * n - k*m = k * (n - m)"
apply (induct k)
apply simp
apply simp
apply arith
done


lemma arithDistrOne:  "k * n - k = k * (n - (1::nat))"
apply (induct k)
apply simp
apply simp
apply arith
done

lemma arithBad: "(k::nat)+(n -k)=n"
oops


lemma natAux:"(a::nat)+b =c \<Longrightarrow> a=c-b"
apply arith
done

lemma natAuxMult:"(m::nat)+k =k*n \<Longrightarrow> m=k*(n-(1::nat))"
apply (subgoal_tac "m=k*n-k")
apply (subgoal_tac "k * n - k =k * (n - 1)")
apply simp 
apply (simp only: arithDistrOne)
apply arith
done

lemma arithLeq: "\<lbrakk>(m::nat)=k* n; 0<n\<rbrakk> \<Longrightarrow> k\<le> m"
apply auto
done


(****************************************************************)

syntax DIAM :: cname
       DOLLAR_F :: rfldname
       DOLLAR_N :: rfldname
       DOLLAR :: ifldname
       F0 :: ifldname
       F1 :: rfldname
       F2 :: rfldname

translations
 "DIAM" == "(CN ''dia_0'') "
 "DOLLAR_F" == "(RFN ''$f'')"
 "DOLLAR_N" == "(RFN ''$n'')"
 "DOLLAR" == "(IFN ''$'')"
 "F0" == "(IFN ''f0'')"
 "F1" == "(RFN ''f1'')"
 "F2" == "(RFN ''f2'')"

consts mLIST::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive mLIST intros
mLIST_NIL: "(0,Nullref,{},h) : mLIST"
mLIST_CONS:"\<lbrakk>h@@a = Some DIAM; 
             h<a\<bullet>DOLLAR> \<noteq> 2; 
             h\<lfloor>a\<diamondsuit>F1\<rfloor> = r; 
             a \<notin> X; 
             (n,r,X,h):mLIST;
             n'=Suc n;
             r'=Ref a;
             X' = X \<union> {a}\<rbrakk>
          \<Longrightarrow> (n', r', X', h): mLIST"


consts FL::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive FL intros
FL_NIL[intro!]: "(0, Nullref, {},h) : FL"
FL_SUC[intro!]: "\<lbrakk>h@@a = Some DIAM; a \<notin> X; (n, h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>,X,h):FL\<rbrakk>
        \<Longrightarrow> (Suc n, Ref a,  X \<union> {a}, h) : FL"


(************** Lemmas about a freelist ***************************)

lemma flistNonNullNonEmpty : "(m, Ref loc, X, h) : FL \<Longrightarrow> X ~= {}"
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistNonNullLoc : "(m, Ref loc, X, h) : FL \<Longrightarrow> loc \<in> X"
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistNonNullLoc' : "\<lbrakk> (m, r, X, h)  \<in>  FL; 
                           r =  Ref loc \<rbrakk>  \<Longrightarrow> loc \<in> X"
apply (erule FL.cases)
apply simp
apply simp
done


lemma flistNonNullNonZero : "(m, Ref loc, X, h) : FL \<Longrightarrow> m ~= 0"
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistNonNullPositive : "(m, Ref loc, X, h) : FL \<Longrightarrow>  0<m"
apply (erule FL.cases)
apply simp
apply simp
done



lemma flistSameOH [rule_format]: "(m, r, X, h)  \<in>  FL
                                \<Longrightarrow>
                                (\<forall> Y hh. X\<subseteq> Y \<longrightarrow> 
                                                 sameOH Y h hh \<longrightarrow>
                                                 (m, r, X, hh)  \<in>  FL)"
apply (erule FL.induct)
apply clarify
apply clarify
apply (rule FL_SUC)
apply (unfold sameOH_def)
apply simp
apply simp
apply simp
apply force
done

lemma flistZeroNull: "(0, r, X, h)  \<in>  FL \<Longrightarrow> r=Nullref"
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistZeroEmpty: "(0, r, X, h)  \<in>  FL \<Longrightarrow> X={}"
apply (erule FL.cases)
apply simp
apply simp
done


lemma flistNullEmpty: " (m, Nullref, X, h) \<in>  FL \<Longrightarrow> {}=X"
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistNullZero: "(m, Nullref, X, h)  \<in>  FL \<Longrightarrow> 0=m"
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistTail: "\<lbrakk> (m, r, X, h)  \<in>  FL; 
                    r =  Ref loc \<rbrakk> 
                                \<Longrightarrow>
                  (m-(1::nat), rheap h DOLLAR_N loc,  X-{loc}, h) \<in>  FL"   
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistTail': "\<lbrakk> (m, Ref loc , X, h)  \<in>  FL\<rbrakk> 
                                \<Longrightarrow>
                             (m-(1::nat), rheap h DOLLAR_N loc,  X-{loc}, h) \<in>  FL"   
apply (erule FL.cases)
apply simp
apply simp
done



lemma funcFL [rule_format]: "(m, r, Y, h) \<in> FL \<Longrightarrow>
                            (\<forall> YY mm. (mm, r, YY, h) \<in> FL  \<longrightarrow> Y=YY \<and> m=mm)"
apply (erule FL.induct)
apply (rule allI)+
apply (rule impI)
apply (rule conjI)
apply (erule flistNullEmpty) 
apply (erule flistNullZero)

apply (rule allI)+
apply (rule impI)

apply (subgoal_tac "0<mm")
apply (subgoal_tac " a \<in> YY")
apply (subgoal_tac "(mm-(1::nat), h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>, YY- {a}, h) \<in> FL")

apply (erule allE)+
apply (drule mp)
apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)
apply (assumption)

apply (erule conjE)
apply (rule conjI)

apply fastsimp
apply simp

apply (rule flistTail')
apply (assumption)

apply (frule flistNonNullLoc)
apply assumption
 
apply (frule flistNonNullPositive)
apply assumption
done

(****** operations on heap that do not change freelist ******************)

lemma FLIfld:
  "\<lbrakk>(m, r, X, h) \<in> FL\<rbrakk> \<Longrightarrow>  (m, r, X, h<loc'\<bullet>Fld := f'>) \<in> FL"
apply (erule FL.induct)
apply (rule FL_NIL)
apply (subgoal_tac "a=loc'\<or> a~=loc'")
prefer 2
apply clarify
apply (erule disjE)

apply (rule FL_SUC)
apply simp
apply assumption
apply simp

apply (rule FL_SUC)
apply simp
apply assumption
apply simp
done

lemma FLRfld:
  "\<lbrakk>(m, r, X, h) \<in> FL; Fld ~= DOLLAR_N\<rbrakk> \<Longrightarrow>  (m, r, X, h\<lfloor>loc\<diamondsuit>Fld := f\<rfloor>) \<in> FL"
apply (erule FL.induct)
apply (rule FL_NIL)
apply (subgoal_tac "a=loc\<or> a~=loc")
prefer 2
apply clarify
apply (erule disjE)

apply (rule FL_SUC)
apply simp
apply assumption
apply fastsimp

apply (rule FL_SUC)
apply simp
apply assumption
apply fastsimp
done

lemma FLRfldElsewhere [rule_format]:
  "\<lbrakk>(m, r, X, h) \<in> FL\<rbrakk> \<Longrightarrow>  \<forall> loc. loc\<notin> X \<longrightarrow> (m, r, X, h\<lfloor>loc\<diamondsuit>DOLLAR_N := f\<rfloor>) \<in> FL"
apply (erule FL.induct)
apply (rule allI)
apply (rule impI)
apply (rule FL_NIL)

apply (rule allI)
apply (rule impI)
apply (rule FL_SUC)
apply simp
apply assumption

apply (erule allE)
apply (subgoal_tac "loc\<notin> X")
apply (subgoal_tac "loc ~= a")
apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)

apply (drule mp)
apply assumption

apply (subgoal_tac "h\<lfloor>loc\<diamondsuit>DOLLAR_N:=f\<rfloor>\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>=h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>")
apply simp
apply simp
apply simp
apply simp
done


lemma FLSfld:
  "\<lbrakk>(m, r, X, h) \<in> FL\<rbrakk> 
    \<Longrightarrow>  (m, r, X, h \<lparr>sheap := (sheap h)(c := (sheap h c)(f:=r'))\<rparr>) \<in> FL"
apply (erule FL.induct)
apply (rule FL_NIL)

apply (rule FL_SUC)
apply simp
apply assumption
apply simp
done




lemma FLRfldSfld:
  "\<lbrakk>(m, r, X, h\<lfloor>loc\<diamondsuit>F:=r'\<rfloor>) \<in> FL\<rbrakk> 
    \<Longrightarrow>  (m, r, X, h\<lfloor>loc\<diamondsuit>F:=r'\<rfloor> \<lparr>sheap := (sheap h)(c := (sheap h c)(f:=r''))\<rparr>) \<in> FL"
apply (subgoal_tac "(m, r, X, h\<lfloor>loc\<diamondsuit>F:=r'\<rfloor> \<lparr>sheap := (sheap h\<lfloor>loc\<diamondsuit>F:=r'\<rfloor>)(c := (sheap h\<lfloor>loc\<diamondsuit>F:=r'\<rfloor> c)(f:=r''))\<rparr>) \<in> FL")
apply simp
apply (rule FLSfld)
apply assumption
done

lemma FLRfldSfld':
  "\<lbrakk>(m, r, X, h\<lfloor>a\<diamondsuit>F:=r'\<rfloor> \<lparr>sheap := (sheap h)(c := (sheap h c)(f:=r''))\<rparr>) \<in> FL\<rbrakk> 
    \<Longrightarrow> (m, r, X, h\<lparr>rheap := (rheap h)(F:= (rheap h F)(a := r')),
                   sheap := (sheap h)(c := (sheap h c)(f:=r''))\<rparr>) \<in> FL"
apply simp 
done

lemma FLRfldSfld'':
  "\<lbrakk>(m, r, X, h\<lfloor>a\<diamondsuit>F:=r'\<rfloor>) \<in> FL\<rbrakk>
    \<Longrightarrow>  (m, r, X, h\<lparr>rheap := (rheap h)(F:= (rheap h F)(a := r')),
                    sheap := (sheap h)(c := (sheap h c)(f:=r''))\<rparr>) \<in> FL"
apply (rule  FLRfldSfld')
apply (rule FLRfldSfld)
apply assumption
done


(******* increase the length of FL by one ******)

lemma incrFL [rule_format]:
  "\<lbrakk>(m, r, X, h) \<in> FL\<rbrakk> \<Longrightarrow>  \<forall> loc. loc\<notin> X \<longrightarrow> h@@loc = Some DIAM \<longrightarrow> (Suc m, Ref loc, X\<union>{loc}, h\<lfloor>loc\<diamondsuit>DOLLAR_N := r\<rfloor>) \<in> FL"
apply (rule allI)
apply (rule impI)+
apply (rule FL_SUC)
apply simp
apply assumption
apply (rule FLRfldElsewhere)
apply simp
apply assumption
done

(*************** simliar lemmas about mLIST ********************)

(*consts mLIST::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive mLIST intros
mLIST_NIL: "(0,Nullref,{},h) : mLIST"
mLIST_CONS:"\<lbrakk>h@@a = Some DIAM; 
             h<a\<bullet>DOLLAR> \<noteq> 2; 
             h\<lfloor>a\<diamondsuit>F1\<rfloor> = r; 
             a \<notin> X; 
             (n,r,X,h):mLIST;
             n'=Suc n;
             r'=Ref a;
             X' = X \<union> {a}\<rbrakk>
          \<Longrightarrow> (n', r', X', h): mLIST"*)


lemma sameLIST[rule_format] : "(n, r, X, h): mLIST \<Longrightarrow>  
                    (\<forall> hh. sameOH X h hh \<longrightarrow> (n, r, X, hh): mLIST)"
apply (erule mLIST.induct) 
apply clarify
apply (rule mLIST_NIL)
apply (rule allI)
apply (rule impI)
apply (rule mLIST_CONS)
apply (simp add:  sameOH_def)
apply (simp add:  sameOH_def)
apply (simp add:  sameOH_def)
apply assumption
apply (erule_tac x=hh in allE)
apply (simp add:  sameOH_def)
apply assumption
apply assumption
apply assumption
done

lemma LISTNullEmpty : "(m, Nullref, X, h) :mLIST  \<Longrightarrow> X={}"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNullEmpty' : "(m, Nullref, X, h) :mLIST  \<Longrightarrow> {}=X"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNullZero : "(m, Nullref, X, h) :mLIST   \<Longrightarrow> m=0"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNullZero' : "(m, Nullref, X, h) :mLIST   \<Longrightarrow> 0=m"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNonNullPosit : "(m, Ref loc, X, h) :mLIST  \<Longrightarrow> 0<m"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNonNullPosit' : "\<lbrakk>(m, r, X, h) :mLIST; r = Ref loc\<rbrakk>  \<Longrightarrow> 0<m"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNonNullLoc : "(m, Ref loc, X, h) :mLIST  \<Longrightarrow> loc \<in> X"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNonNullLoc' : "\<lbrakk>(m, r, X, h) :mLIST;
                         r = Ref loc\<rbrakk>  \<Longrightarrow> loc \<in> X"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNonNullSomeDIA : "(m, Ref loc, X, h) :mLIST  \<Longrightarrow> h@@loc = Some DIAM"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma mLIST_TL: "\<lbrakk> (m, Ref loc , X, h)  \<in> mLIST\<rbrakk> \<Longrightarrow>
                             (m-(1::nat), rheap h F1 loc,  X-{loc}, h) \<in>  mLIST"   
apply (erule mLIST.cases)
apply simp
apply simp
done

lemma mLIST_TL': "\<lbrakk> (m, r, X, h)  \<in>  mLIST; r =  Ref loc\<rbrakk> 
                                \<Longrightarrow>
                  (m-(1::nat), rheap h F1 loc,  X-{loc}, h) \<in>  mLIST"   
apply (erule mLIST.cases)
apply simp
apply simp
done

lemma mLIST_TL_Pos: "\<lbrakk> (m+(1::nat), Ref loc , X, h)  \<in> mLIST\<rbrakk> \<Longrightarrow>
                             (m, rheap h F1 loc,  X-{loc}, h) \<in>  mLIST"   
apply (erule mLIST.cases)
apply simp
apply simp
done

lemma mLIST_TL_Pos': "\<lbrakk> (m+(1::nat), r, X, h)  \<in>  mLIST; r =  Ref loc\<rbrakk> 
                                \<Longrightarrow>
                  (m, rheap h F1 loc,  X-{loc}, h) \<in>  mLIST"   
apply (erule mLIST.cases)
apply simp
apply simp
done

lemma mLIST_TL_Pos_: "\<lbrakk> (m, Ref loc , X, h)  \<in> mLIST; m=m'+(1::nat)\<rbrakk> \<Longrightarrow>
                             (m', rheap h F1 loc,  X-{loc}, h) \<in>  mLIST"   
apply (erule mLIST.cases)
apply simp
apply simp
done

lemma mLIST_TL_Pos_': "\<lbrakk> (m, r, X, h)  \<in>  mLIST; m=m'+(1::nat); r =  Ref loc\<rbrakk> 
                                \<Longrightarrow>
                  (m', rheap h F1 loc,  X-{loc}, h) \<in>  mLIST"   
apply (erule mLIST.cases)
apply simp
apply simp
done


lemma mLIST_func_X[rule_format]: "(m, r, X, h)  \<in>  mLIST \<Longrightarrow> 
                   \<forall> m' X'. (m', r, X', h)  \<in>  mLIST  \<longrightarrow> X=X'"
apply (erule mLIST.induct)
apply clarify
apply (rule LISTNullEmpty')
apply assumption
apply (rule allI)+
apply (rule impI)

apply (frule_tac m=m' and loc=a in mLIST_TL')
apply assumption

apply (erule_tac x="m'-(1::nat)" in allE)
apply (erule_tac x="X'a-{a}" in allE)
apply simp
apply (frule_tac  loc=a in LISTNonNullLoc)
apply fastsimp
done


lemma mLIST_func_X'[rule_format]: "\<lbrakk>(m, r, X, h)  \<in>  mLIST\<rbrakk> \<Longrightarrow> 
                   \<forall> m' X' r'. (m', r', X', h)  \<in>  mLIST  \<longrightarrow> r=r' \<longrightarrow> X=X'"
apply (erule mLIST.induct)
apply clarify
apply (rule LISTNullEmpty')
apply assumption

apply clarify
apply (frule_tac m=m' and loc=a in mLIST_TL')
apply (simp (no_asm))
apply (erule_tac x="m'-(1::nat)" in allE)
apply (erule_tac x="X'a-{a}" in allE)
apply (erule_tac x="h\<lfloor>a\<diamondsuit>F1\<rfloor>" in allE)
apply (drule mp)
apply assumption
apply simp
apply (frule  LISTNonNullLoc)
apply fast
done


lemma mLIST_func_m[rule_format]: "(m, r, X, h)  \<in>  mLIST \<Longrightarrow> 
                   \<forall> m' X'. (m', r, X', h)  \<in>  mLIST  \<longrightarrow> m=m'"
apply (erule mLIST.induct)
apply clarify
apply (rule LISTNullZero')
apply assumption
apply (rule allI)+
apply (rule impI)
apply (frule_tac m=m' and loc=a in mLIST_TL')
apply (simp (no_asm))
apply (erule_tac x="m'-(1::nat)" in allE)
apply (erule_tac x="X'a-{a}" in allE)
apply (drule mp)
apply simp
apply (frule_tac  loc=a and r=r' in LISTNonNullPosit')
apply assumption
apply clarsimp
done

lemma mLIST_func_m'[rule_format]: "\<lbrakk>(m, r, X, h)  \<in>  mLIST\<rbrakk> \<Longrightarrow> 
                   \<forall> m' X' r'. (m', r', X', h)  \<in>  mLIST  \<longrightarrow> r=r' \<longrightarrow> m=m'"
apply (erule mLIST.induct)
apply clarify
apply (rule LISTNullZero')
apply assumption

apply clarify
apply (frule_tac m=m' and loc=a in mLIST_TL')
apply (simp (no_asm))
apply (erule_tac x="m'-(1::nat)" in allE)
apply (erule_tac x="X'a-{a}" in allE)
apply (erule_tac x="h\<lfloor>a\<diamondsuit>F1\<rfloor>" in allE)
apply (drule mp)
apply assumption
apply simp
apply (frule_tac loc=a in  LISTNonNullPosit)
apply simp
done

(******************* CONTEXT *******************************)

datatype Type = IntET | ListET nat

types Context = "(iname set) \<times> (rname \<leadsto>\<^sub>f nat)"

constdefs DOM:: "Context \<Rightarrow> rname set"
"DOM G == fmap_dom (snd G)"


(*************  "Region"(Upsilon)  relation *******************************)


consts reg :: "(val \<times> heap \<times> (Type option) \<times> (locn set) \<times> nat) set"
inductive reg intros
regNone:  "(v,h,None,{},0):reg"
regList:  "\<lbrakk>(n, r, R, h) : mLIST; m = k*n\<rbrakk> \<Longrightarrow> (RVal r, h, Some(ListET k), R, m): reg"
regInt:   "(IVal i ,h,Some IntET,{}, 0): reg"

lemma reg_sameOH:  
                 "\<lbrakk>(v, h, A, R, m) \<in>  reg; sameOH R h hh\<rbrakk> 
                     \<Longrightarrow> (v, hh, A, R, m) \<in>  reg"
apply (erule reg.cases)
apply clarsimp
apply (rule regNone)

apply clarsimp
apply (rule regList)
apply (rule sameLIST)
apply assumption
apply assumption
apply (simp (no_asm))
apply clarsimp
apply (rule regInt)
done

lemma sameCommute : "sameOH R hh h  \<Longrightarrow> sameOH R h hh"
apply (unfold sameOH_def)
apply simp
done

lemma reg_sameOH':  
                 "\<lbrakk>(v, h, A, R, m) \<in>  reg; sameOH R hh h\<rbrakk> 
                     \<Longrightarrow> (v, hh, A, R, m) \<in>  reg"
apply (frule sameCommute)
apply (rule_tac h=h and hh=hh in reg_sameOH)
apply assumption
apply assumption
done

lemma regList_km:  "(RVal (Ref loc), h, Some(ListET k), R, m) \<in>  reg  \<Longrightarrow> k\<le>m"
apply (erule reg.cases)
apply simp
apply (frule_tac loc=loc in LISTNonNullPosit')
apply simp
apply (rule_tac n=n in arithLeq)
apply simp
apply assumption
apply simp
done

lemma regList_km':  "\<lbrakk>(RVal r, h, Some(ListET k), R, m) \<in>  reg; r =Ref loc\<rbrakk> 
                     \<Longrightarrow> k\<le>m"
apply (erule reg.cases)
apply simp
apply (frule_tac loc=loc in LISTNonNullPosit')
apply simp
apply (rule_tac n=n in arithLeq)
apply simp
apply assumption
apply simp
done

lemma regList_km_Le:  "\<lbrakk>(RVal (Ref loc), h, Some(ListET k), R, m) \<in>  reg; m+q \<le> N  \<rbrakk> 
                     \<Longrightarrow> k+(m-k)+q \<le> N"
apply (frule_tac loc=loc in regList_km)
apply arith
done

lemma regList_km_Le':  "\<lbrakk>(RVal r, h, Some(ListET k), R, m) \<in>  reg; r =Ref loc; m+q \<le> N  \<rbrakk> 
                     \<Longrightarrow> k+(m-k)+q \<le> N"
apply (frule_tac loc=loc in regList_km')
apply assumption
apply arith
done

lemma regList_km_LeAdd:  "\<lbrakk>(RVal (Ref loc), h, Some(ListET k), R, m) \<in>  reg; m+(m'::nat)+q \<le> N  \<rbrakk> 
                     \<Longrightarrow> k+(m-k)+q \<le> N"
apply (frule_tac loc=loc in regList_km)
apply arith
done

lemma regList_km_LeAdd':  "\<lbrakk>(RVal r, h, Some(ListET k), R, m) \<in>  reg; r=Ref loc; m+(m'::nat)+q \<le> N  \<rbrakk> 
                     \<Longrightarrow> k+(m-k)+q \<le> N"
apply (rule_tac loc=loc and h=h and R=R in regList_km_LeAdd)
apply simp
apply assumption
done

lemma regListNonNullLoc:
"(RVal (Ref loc), h, Some(ListET k), R, m) \<in>  reg \<Longrightarrow> loc \<in>  R"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
apply (rule LISTNonNullLoc')
apply assumption
apply simp
apply simp
done

lemma regListNonNullLoc':
"\<lbrakk>(RVal r, h, Some(ListET k), R, m) \<in>  reg; r =Ref loc\<rbrakk> \<Longrightarrow> loc \<in>  R"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
apply (rule LISTNonNullLoc')
apply assumption
apply simp
apply simp
done

lemma regListNonNullSomeDIA:
"(RVal (Ref loc), h, Some(ListET k), R, m) \<in>  reg \<Longrightarrow> h@@loc = Some DIAM"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
apply (rule LISTNonNullSomeDIA)
apply simp
apply simp
done

lemma regListNonNullSomeDIA':
"\<lbrakk>(RVal r, h, Some(ListET k), R, m) \<in>  reg; r =Ref loc\<rbrakk>  \<Longrightarrow> h@@loc = Some DIAM"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
apply (rule LISTNonNullSomeDIA)
apply simp
apply simp
done


lemma regListTL:
"(RVal (Ref loc), h, Some(ListET k), R, m) \<in>  reg  \<Longrightarrow> 
 (RVal h\<lfloor>loc\<diamondsuit>F1\<rfloor> , h, Some(ListET k), R-{loc}, (m-k)) \<in>  reg"
apply (erule reg.cases)
apply simp

apply simp
apply (erule conjE)+
apply (rule regList)
apply (rule mLIST_TL')
apply assumption
apply simp
apply (simp add: arithDistrOne)
apply simp 
done


lemma regListTL':
"\<lbrakk>(RVal r, h, Some(ListET k), R, m) \<in>  reg; r =Ref loc\<rbrakk>  \<Longrightarrow> (RVal h\<lfloor>loc\<diamondsuit>F1\<rfloor> , h, Some(ListET k), R-{loc}, (m-k)) \<in>  reg"
apply (erule reg.cases)
apply simp

apply simp
apply (erule conjE)+
apply (rule regList)
apply (rule mLIST_TL')
apply assumption
apply simp
apply (simp add: arithDistrOne)
apply simp 
done


lemma regListTL_Add:
"(RVal (Ref loc), h, Some(ListET k), R, m+k) \<in>  reg  \<Longrightarrow> 
 (RVal h\<lfloor>loc\<diamondsuit>F1\<rfloor> , h, Some(ListET k), R-{loc}, m) \<in>  reg"
apply (erule reg.cases)
apply simp

apply simp
apply (erule conjE)+
apply (rule regList)
apply (rule_tac m=n in mLIST_TL')
apply assumption
apply simp
apply (rule natAuxMult)
apply simp
apply simp 
done


lemma regListTL_Add':
"\<lbrakk>(RVal r, h, Some(ListET k), R, m+k) \<in>  reg; r =Ref loc\<rbrakk>  \<Longrightarrow> (RVal h\<lfloor>loc\<diamondsuit>F1\<rfloor> , h, Some(ListET k), R-{loc}, m) \<in>  reg"
apply (erule reg.cases)
apply simp

apply simp
apply (erule conjE)+
apply (rule regList)
apply (rule_tac m=n in mLIST_TL')
apply assumption
apply simp
apply (rule natAuxMult)
apply simp
apply simp 
done

lemma reg_None: "(RVal r, h, None, R, m) \<in> reg \<Longrightarrow> R = {}"
apply (erule reg.elims)
apply simp
apply simp
apply simp
done


lemma reg_List:" \<lbrakk>(n, r, R, h) \<in> mLIST; m = k * n; (RVal r, h, Some (ListET k), R', m') \<in> reg \<rbrakk>  \<Longrightarrow> R=R'"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
 
apply (rule mLIST_func_X)
apply assumption
apply assumption

apply simp
done



lemma regListFunc_R[rule_format]: "(RVal r, h, A, R, m) \<in>  reg \<Longrightarrow>
                                   \<forall> R' m'.  (RVal r, h, A, R', m') \<in>  reg 
                                     \<longrightarrow> R'=R"
apply (erule reg.elims)
apply (clarify)
apply (rule reg_None)
apply assumption

apply (rule allI)+
apply (rule impI)
apply simp
apply (erule conjE)+
apply (frule reg_List) 
apply assumption
apply assumption
apply simp

apply (clarify)
done

lemma reg_NoneZero: "(RVal r, h, None, R, m) \<in> reg \<Longrightarrow> m=0"
apply (erule reg.elims)
apply simp
apply simp
apply simp
done

lemma reg_NoneZero': "(RVal r, h, None, R, m) \<in> reg \<Longrightarrow> 0=m"
apply (erule reg.elims)
apply simp
apply simp
apply simp
done


lemma reg_ListM:" \<lbrakk>(n, r, R, h) \<in> mLIST; m = k * n; (RVal r, h, Some (ListET k), R', m') \<in> reg \<rbrakk>  \<Longrightarrow> m'=m"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
 
apply (simp add: mLIST_func_m)

apply simp
done

lemma reg_ListM':" \<lbrakk>(n, r, R, h) \<in> mLIST; m = k * n; (RVal r, h, Some (ListET k), R', m') \<in> reg \<rbrakk>  \<Longrightarrow> m=m'"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
 
apply (simp add: mLIST_func_m)

apply simp
done


lemma regListFunc_m: "\<lbrakk> (RVal r, h, A, R, m) \<in>  reg; (RVal r, h, A, R', m') \<in>  reg \<rbrakk> 
                                    \<Longrightarrow> m=m'"
apply (erule reg.elims)
apply simp
apply (erule conjE)+
apply (rule reg_NoneZero)
apply fast

apply simp
apply (erule conjE)+
apply (frule_tac m'=m' in reg_ListM) 
apply assumption
apply assumption
apply simp

apply (clarify)
done

lemma regListFunc_Rm : "\<lbrakk>(RVal r, h, A, R, m) \<in>  reg;(RVal r, h, A, R', m') \<in>  reg \<rbrakk> \<Longrightarrow>
                         R=R' \<and> m=m'"
apply (rule conjI)  
apply (rule  regListFunc_R)
apply assumption
apply assumption
apply (rule regListFunc_m)
apply assumption
apply assumption
done 

(***************************************************************)

constdefs GETi :: "Context \<Rightarrow> iname \<Rightarrow> (Type option)"
"GETi G x \<equiv> (if x : (fst G) then (Some IntET) else None)"

constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Type option)"
"GETr G x \<equiv> (case (fmap_lookup (snd G) x) of None \<Rightarrow> None | (Some i) \<Rightarrow> Some (ListET i))"

constdefs INSi :: "Context \<Rightarrow> iname \<Rightarrow> Context"
"INSi G x \<equiv> (insert x (fst G), snd G)"

constdefs INSr :: "Context \<Rightarrow> rname \<Rightarrow> nat \<Rightarrow> Context"
"INSr G x k \<equiv> (fst G, (snd G)(x\<mapsto>\<^sub>fk))"


consts Union::"(Context \<times> Context \<times> Context) set"
inductive Union intros
UNION : 
"\<lbrakk>(fst C) \<inter> (fst D) = {};
  fst E = (fst C) \<union> (fst D);
  (DOM C) \<inter> (DOM D) = {}; 
  DOM E = DOM C \<union> DOM D;
  \<forall> x . x:DOM C \<longrightarrow> GETr C x = GETr E x; 
  \<forall> x . x:DOM D \<longrightarrow> GETr D x = GETr E x\<rbrakk>
\<Longrightarrow> (C,D,E): Union"

(*************************************************************)

lemma unSubset1: "\<lbrakk> X \<subseteq> DOM C; (C,D,E): Union \<rbrakk> \<Longrightarrow> X \<subseteq> DOM E"
apply (erule Union.elims)
apply force
done

lemma unSubset2: "\<lbrakk> X \<subseteq> DOM D; (C,D,E): Union \<rbrakk> \<Longrightarrow> X \<subseteq> DOM E"
apply (erule Union.elims)
apply force
done

(********* Usage Aspects  ***********************************)

(* we consider only "p = oo" case, Lennart's def of reg assume it *)

(* to have drop-rule provable
   one may specify usage aspects in the form not
   "if and only if", but "at least";
   to get U3 \<subseteq> U2 \<subseteq> U1 *)  

constdefs usAs1 :: "Context \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> (rname set) \<Rightarrow> bool"
"usAs1 G E h hh X == True" (* no information *)


constdefs usAs2 :: "Context \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> (rname set) \<Rightarrow> bool"
"usAs2 G E h hh    X == X \<subseteq>  DOM G \<and> 
                                 (\<forall> x R S. x \<in> X \<longrightarrow> 
                                 (RVal E\<lfloor>x\<rfloor>, h, GETr G x, R, S) \<in>  reg \<longrightarrow> 
                                 (sameOH R h hh))"

constdefs usAs3 :: "Context \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> 
                    val \<Rightarrow> (Type option) \<Rightarrow> (rname set) \<Rightarrow> bool"
"usAs3 G E h hh v A X ==  X \<subseteq>  DOM G \<and> 
                          (\<forall> x R S RV SV. x \<in> X \<longrightarrow> 
                                      (RVal E\<lfloor>x\<rfloor>, h, GETr G x, R, S) \<in>  reg \<longrightarrow> 
                                      (sameOH R h hh) \<and>
                                      ((v, hh, A, RV, SV) \<in>  reg \<longrightarrow> (RV \<inter> R = {})))"


lemma drop_32 : "usAs3 G E h hh v A X \<Longrightarrow>
                 usAs2 G E h hh X"
apply (simp only:  usAs3_def usAs2_def)
apply blast
done

lemma un2 : "\<lbrakk>usAs2 G E h hh X; 
              usAs2 G E h hh Y; 
              Z=X \<union> Y \<rbrakk> \<Longrightarrow> usAs2 G E h hh Z"
apply (unfold usAs2_def)
apply blast
done

lemma un3 : "\<lbrakk>usAs3 G E h hh v A X; 
              usAs3 G E h hh v A Y; 
              Z=X \<union> Y \<rbrakk> \<Longrightarrow> usAs3 G E h hh v A Z"
apply (unfold usAs3_def)
apply blast
done


lemma int2 : "\<lbrakk>usAs2 G E h hh X; Z=X\<inter> Y \<rbrakk> \<Longrightarrow> usAs2 G E h hh Z"
apply (unfold usAs2_def)
apply blast
done

lemma int3 : "\<lbrakk>usAs3 G E h hh v A X; 
               Z=X\<inter> Y \<rbrakk> \<Longrightarrow> usAs3 G E h hh v A Z"
apply (unfold usAs3_def)
apply blast
done

lemma int2' : "\<lbrakk>usAs2 G E h hh X; Z=Y\<inter> X \<rbrakk> \<Longrightarrow> usAs2 G E h hh Z"
apply (unfold usAs2_def)
apply blast
done

lemma int3' : "\<lbrakk>usAs3 G E h hh v A X; Z=Y\<inter> X \<rbrakk> \<Longrightarrow> usAs3 G E h hh v A Z"
apply (unfold usAs3_def)
apply blast
done

lemma sameComp :"\<lbrakk>sameOH X h h1; sameOH X h1 hh\<rbrakk> \<Longrightarrow> sameOH X h hh"
apply (unfold sameOH_def) 
apply (rule allI)
apply (rule impI)
apply (rule conjI)
apply simp

apply (rule conjI)
apply (rule allI)
apply simp

apply (rule allI)
apply simp
done


lemma comp2 : "\<lbrakk>usAs2 G E h h1 X; usAs2 G E h1 hh X\<rbrakk> \<Longrightarrow> usAs2 G E h hh X"
apply (unfold usAs2_def)
apply (rule conjI)
apply blast
apply (rule allI)+
apply (rule impI)+
apply (erule conjE)+
apply (erule_tac x=x in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=S in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply assumption
apply (erule_tac x=x in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=S in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply (rule_tac h=h and hh=h1  in reg_sameOH)
apply assumption
apply assumption
apply (rule sameComp)
apply assumption
apply assumption
done



lemma comp3 : "\<lbrakk>usAs3 G E h h1 v A X; 
                usAs3 G E h1 hh v A X\<rbrakk> \<Longrightarrow> usAs3 G E h hh v A X"
apply (unfold usAs3_def)
apply (erule conjE)+

apply (rule conjI)
apply blast

apply (rule allI)+
apply (rule impI)+

apply (rule conjI)

apply (erule_tac x=x in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=S in allE)
apply (erule_tac x=RV in allE)
apply (erule_tac x=SV in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply assumption
apply (erule_tac x=x in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=S in allE)
apply (erule_tac x=RV in allE)
apply (erule_tac x=SV in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply (rule_tac h=h and hh=h1  in reg_sameOH)
apply assumption
apply (erule conjE)
apply assumption
apply (erule conjE)+
apply (rule sameComp)
apply assumption
apply assumption

apply (rule impI)
apply (erule_tac x=x in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=S in allE)
apply (erule_tac x=RV in allE)
apply (erule_tac x=SV in allE)
apply (drule mp)
apply assumption
apply (drule mp)
apply assumption
apply (erule_tac x=x in allE)
apply (erule_tac x=R in allE)
apply (erule_tac x=S in allE)
apply (erule_tac x=RV in allE)
apply (erule_tac x=SV in allE)
apply (drule mp)
apply assumption
apply (erule conjE)+
apply (frule_tac h=h and hh=h1  in reg_sameOH)
apply assumption
apply (drule mp)
apply assumption
apply (erule conjE)
apply (rotate_tac 6) 
apply (erule thin_rl)
apply (drule mp)
apply assumption
apply assumption
done

(***************************************************************************)

constdefs FL_sep_val:: "val \<Rightarrow> (Type option) \<Rightarrow> heap \<Rightarrow> bool"
"FL_sep_val v A h  == \<forall>  F N R S. (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) \<in> FL \<longrightarrow>
                                  (v, h, A, R, S) \<in>  reg \<longrightarrow>
                                   R \<inter> F ={}"

constdefs FL_sep_set:: "Context \<Rightarrow> (rname set) \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool"
" FL_sep_set G X E h  == X \<subseteq>  DOM G \<and> 
                         (\<forall> x. x\<in> X \<longrightarrow>  FL_sep_val (RVal E\<lfloor>x\<rfloor>) (GETr G x) h)" 

lemma FL_Sep_set_weak : "\<lbrakk> FL_sep_set G X E h; 
                           Y\<subseteq>X \<rbrakk> \<Longrightarrow> FL_sep_set G Y E h"
apply (simp only: FL_sep_set_def)
apply (erule conjE)+ 

apply (rule conjI)
apply blast

apply (rule allI)
apply (rule impI)
apply (erule_tac x=x in allE)
apply (drule mp)
apply fast
apply (assumption)
done

lemma FL_Sep_set_weak_impl : "\<lbrakk> FL_sep_set G X E h \<longrightarrow> P; 
                                X\<subseteq>Y;
                                FL_sep_set G Y E h\<rbrakk> \<Longrightarrow> P"
apply (frule  FL_Sep_set_weak)
apply assumption
apply (drule mp)
apply assumption
apply assumption
done

lemma FL_Sep_set_weak_impl' : "\<lbrakk> FL_sep_set G X E h \<longrightarrow> P; 
                                 X\<subseteq>Y \<rbrakk> \<Longrightarrow> FL_sep_set G Y E h \<longrightarrow> P"
apply (rule impI)
apply (rule FL_Sep_set_weak_impl)
apply assumption
apply assumption
apply assumption
done

(***************** The Assertion ********************************)

(* \<Gamma>, n \<turnstile> e: A, nn *)
(* E, h \<turnstile> e \<leadsto>  v, hh *)

constdefs sepPairs :: "Context \<Rightarrow> ((rname \<times> rname)  set) \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool" 
"sepPairs G P E h == 
P \<subseteq> (DOM G) \<times> (DOM G) \<and> 
(\<forall> p R1 S1 R2 S2. p \<in> P \<longrightarrow> 
                 (RVal E\<lfloor>(fst p)\<rfloor>, h, GETr G (fst p), R1, S1) \<in>  reg \<longrightarrow>
                 (RVal E\<lfloor>(snd p)\<rfloor>, h, GETr G (fst p), R2, S2) \<in>  reg \<longrightarrow>
                  R1 \<inter> R2 ={})"

constdefs projEl_1 :: "((rname \<times> rname) set) \<Rightarrow> rname \<Rightarrow> (rname set)"
"projEl_1 S x == {y.  \<exists> z. z \<in> S \<and> fst z = x \<and> snd z = y}"

constdefs projEl_2 :: "((rname \<times> rname) set) \<Rightarrow> rname \<Rightarrow> (rname set)"
"projEl_2 S x == {y.  \<exists> z. z \<in> S \<and> snd z = x \<and> fst z = y}"

constdefs projEl :: "((rname \<times> rname) set) \<Rightarrow> rname \<Rightarrow> (rname set)"
"projEl S x == {y.  \<exists> z. z \<in> S \<and> fst z = x \<and> snd z = y} \<union> 
               {y.  \<exists> z. z \<in> S \<and> fst z = y \<and> snd z = x}"


(* p is local-global: "this" value is sep. (oo) or shared with others  *)
(* the defs below are tooooo  strong,
   they corresponds "directly" to the papers definition, 
   since "sep_flag" dmands that a given rname
   must be "separated" from ALL rnames of the context.
   See relativised (w.r.t. SP) definitions below. 
   
constdefs sep_flag :: "Context \<Rightarrow> 
                       ((rname \<times> rname) set) \<Rightarrow> rname \<Rightarrow>  (Type option) \<Rightarrow>
                       env \<Rightarrow> heap \<Rightarrow> bool"
"sep_flag G SP x A E h == sepPairs G SP E h \<and> 
                          (\<forall> y.  x \<in> DOM G \<longrightarrow> 
                                 y \<in> DOM G \<longrightarrow> y~=x \<longrightarrow>
                                 ((x, y ) \<in> SP \<or> (y, x)\<in> SP))"


consts meaningful_val :: "(val \<times>  (Type option) \<times>   heap \<times> bool)  set"
inductive meaningful_val intros
meaningful_val_INT: "(IVal v, Some IntET, h, p) \<in> meaningful_val"
meaningful_val_LIST:"\<lbrakk>(RVal v, h, Some (ListET k), R, S) \<in>  reg\<rbrakk>
                      \<Longrightarrow> (RVal v, Some (ListET k), h, p)\<in>  meaningful_val"



constdefs overlap_safety_1 :: "Context \<Rightarrow> env \<Rightarrow> heap \<Rightarrow>
                               (rname set) \<Rightarrow> (rname set) \<Rightarrow> bool \<Rightarrow> bool"
"overlap_safety_1 G E h U2 U3 p == \<forall> x. x \<in> DOM G \<longrightarrow> 
                                   (x \<in> U2 \<longrightarrow>
                                   (x \<in> U3 \<longrightarrow> (RVal E\<lfloor>x\<rfloor>, GETr G x, h, False) \<in> meaningful_val) \<and> 
                                   (x \<notin>  U3 \<longrightarrow> (RVal E\<lfloor>x\<rfloor>, GETr G x, h, p) \<in> meaningful_val))
                                   \<and>
                                   (x\<notin> U2 \<longrightarrow> (RVal E\<lfloor>x\<rfloor>, GETr G x, h, True) \<in> meaningful_val)"

*)

(* "p" is used w.r.t SP, i.e. 
   w.r.t. rnames which are KNOWN to be separated from the rname.

   Soundness  of approximation should be validate by a statement
   sepPairs G SP E h. 

   To understand the difference, imagine that we have a tensor type as well.
    Then the inductive set below will be "smaller" then the corresponding 
    definition of the tensor product in the paper.*)

consts meaningful_val :: "(Context \<times> val \<times>  (Type option) \<times>   env \<times> heap \<times> ((rname \<times> rname) set) \<times> bool)  set"
inductive meaningful_val intros
(* meaningful_val_TENSOR: "\<lbrakk> x \<in> DOM G; 
                             y \<in> DOM G;
                             GETr G x = Some A;
                             GETr G y = Some B;
                             if p then (((x, y) \<in> SP \<or> (y, x)\<in> SP) \<and> 
                                        sepPairs G SP E h)
                           \<rbrakk> \<Longrightarrow>  (RVal (RPrimop_tens x y), Some (A \<otimes> B), E, h, SP, p) \<in> meaningful_val" *)
meaningful_val_LIST:"\<lbrakk>(RVal r, h, Some (ListET k), R, S) \<in>  reg\<rbrakk>
                      \<Longrightarrow> (G, RVal r, Some (ListET k), E, h, SP, p)\<in>  meaningful_val"

(* comapre with the paper:
   for instance, if x \<notin> U2, then it is safely to update the guys 
   corresponding x from SP, p =True.
   p = True iff one should take info from SP in account,
   otherwise - not necessary *)
   
constdefs overlap_safety_1 :: " Context \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> 
                                (rname set) \<Rightarrow> (rname set) \<Rightarrow>
                               ((rname \<times> rname) set) \<Rightarrow> bool \<Rightarrow> bool"
"overlap_safety_1 G E h  U2 U3 SP p == 
                                   (\<forall> x. x \<in> DOM G \<longrightarrow> 
                                   (x \<in> U2 \<longrightarrow>
                                   (x \<in> U3 \<longrightarrow> (G, RVal E\<lfloor>x\<rfloor>,  GETr G x, E, h, SP, False) \<in> meaningful_val)\<and>
                                   (x \<notin>  U3 \<longrightarrow> (G, RVal E\<lfloor>x\<rfloor>, GETr G x, E, h, SP, p) \<in> meaningful_val))
                                   \<and>
                                   (x\<notin> U2 \<longrightarrow> (G, RVal E\<lfloor>x\<rfloor>, GETr G x, E, h, SP, True) \<in> meaningful_val))"


constdefs overlap_safety_2 :: "Context \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> (rname set) \<Rightarrow> (rname set) \<Rightarrow>
                               ((rname \<times> rname) set) \<Rightarrow> bool \<Rightarrow> bool"
"overlap_safety_2 G E h U2 U3 SP p == \<forall> x y.
                                      (x, y) \<notin> SP \<longrightarrow> x \<in> U2 \<and> y \<in> U2 \<and> 
                                                     (p \<longrightarrow> (x \<in> U3 \<or> y \<in> U3))"


constdefs overlap_safety :: "Context \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> (rname set) \<Rightarrow> (rname set) \<Rightarrow>
                               ((rname \<times> rname) set) \<Rightarrow> bool \<Rightarrow> bool"
"overlap_safety G E h U2 U3 SP p == (overlap_safety_1 G E h U2 U3 SP p) \<and> 
                                    (overlap_safety_2 G E h U2 U3 SP p)"

constdefs DAssertSP::" Context \<Rightarrow> ((rname \<times> rname)  set) \<Rightarrow>
                       (rname set) \<Rightarrow> (rname set) \<Rightarrow> 
                       env \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> val \<Rightarrow> (Type option) \<Rightarrow> bool \<Rightarrow> bool"
"DAssertSP G SP U2 U3 E h hh v A p == 
 sepPairs G SP E h \<and> 
 usAs2 G E h hh U2 \<and> 
 usAs3 G E h hh v A U3 \<and>
 (overlap_safety G E h U2 U3 SP p  \<longrightarrow>  (G, v, A, E, h, SP, p)\<in>  meaningful_val) \<and> 
 (FL_sep_set G (DOM G) E h  \<longrightarrow> (\<exists> NN FF. (NN, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, FF, hh) \<in> FL \<and> FL_sep_val v A hh))"


constdefs DA_SP::"Context \<Rightarrow> ((rname \<times> rname) set) \<Rightarrow> (rname set) \<Rightarrow> (rname set) \<Rightarrow>
                   (Type option) \<Rightarrow> bool \<Rightarrow> vdmassn"
"DA_SP G SP U2 U3 A pp == (\<lambda> E h hh v p . DAssertSP G SP U2 U3 E h hh v A pp)"

constdefs unitedReg :: "Context \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> (locn set)"
"unitedReg G E h == { loc. \<exists> x R S. x \<in> DOM G \<and> 
                                  (RVal E\<lfloor>x\<rfloor>, h, GETr G x, R, S) \<in> reg \<and>   
                                  loc \<in> R }"

lemma 4_4_1 : "\<lbrakk> DAssertSP G SP U2 U3 E h hh v A p;
                (v, hh, A, R, S) \<in>  reg;
                UR =  unitedReg E h;
                (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) \<in> FL\<rbrakk> \<Longrightarrow>  R \<subseteq> UR \<union> F"
apply (



(* Citations:
   "The rule LET is somewhat intricate. The context is split into 3 pieces:
    variables, specific to the definition e1, in \<Gamma>; variables, specific to the body
    of e2, in \<Theta>; and common variables, in \<Delta>1, \<Delta>2, which may be used
    in different aspects in e1 and e2\<dots>

    If we have 2 contexts, \<Delta>1, \<Delta>2, which only differ on usage aspects,
    so (dom \<Delta>1) = (dom \<Delta>2), and \<Delta>1(x)= \<Delta>2 for all x,
    we define a merged conext   (\<Delta>1 \<and>\<Delta>2) with
    (dom \<Delta>1),  (\<Delta>1 \<and>\<Delta>2)(x)= \<Delta>1(x) and
     (\<Delta>1 \<and> \<Delta>2)[x]=min(\<Delta>1(x), \<Delta>2(x)).
     The merged context takes the "worst" u. a. of each variable.

    Different i-s, different side conditions; 
    may be not all of them will take place in Grail
 *)  

(* \<Delta>1[x]=3, i=2 *)
(* DOM Delta \<subseteq> U13; side cond. *)

   (* a result copy(l)  is not shared with l *)
   (* let x:= copy(l) in append(x, l) *)

 
(* to get the one from the paper, just instantiate SP=(DOM G) \<times> (DOM G)-{(x, x). x \<in> DOM G} *)

 lemma DA_SP_letr_sc_2_3:
 "\<lbrakk>G  \<rhd> e1 : DA_SP C1 SP1 U12 U13 A1 p;
   G  \<rhd> e2 : DA_SP C2 SP2 U22 U23 A2 p;

   DOM Gamma \<inter> DOM Delta ={};
   DOM Theta \<inter> DOM Delta ={};
   DOM Gamma \<inter> DOM Theta ={};

   x \<notin> DOM Theta;
   x \<notin> DOM Delta;

   (Gamma, Delta, C1) \<in> Union;
   (Delta, INSr Theta x k, C2) \<in> Union;

   DOM Delta \<subseteq> U12; 

   x \<in> U23;  

   (Gamma, Theta, Theta') \<in> Union;
   (Theta', Delta, C) \<in> Union;

   U2 =  (DOM Theta \<inter>  U22) \<union> 
         ((DOM Delta) \<inter> U12 \<inter> U22);

 (* rising of u.a. for Gamma *)
   U3 =    DOM Gamma \<union> 
          (DOM Theta \<inter> U23)\<union>   
          (DOM Delta \<inter> U13  \<inter> U23);

   SP2 = SP1\<inter> (U12 \<times> U12) 
         - ({(x', y). x = x' \<and> y \<notin> U13} \<union> {(y, x'). x = x' \<and>y \<notin> U13}) 
         \<union> ({(x', y). x = x' \<and>y \<in>  U13} \<union> {(y, x'). x = x' \<and>y \<in>  U13})
   
   \<rbrakk>
  \<Longrightarrow> G  \<rhd> (LET rf x = e1 IN e2 END): DA_SP C SP U2 U3 A2 p"


(********** about freelist management **********************)

lemma myUnionLeft: "{a}\<union> B= insert a B"
apply simp
done

lemma Fst:"fst (a, b)=a"
apply simp
done


lemma Snd:"snd (a, b)=b"
apply simp
done


(************************************************************)


syntax Free :: mname
       node_ :: rname
       freelist_ :: rname
translations
"Free" == "(MN ''free'')"
"node_" == "(RN ''node'')"
"freelist_" == "(RN ''freelist'')"

axioms Meth_Free:
"methtable DIAM Free = ([RNpar node_], LET rf freelist_ = DIAM\<struct>DOLLAR_F;
                                                     _ = PutFr node_ DOLLAR_N freelist_
                                       IN DIAM\<struct>DOLLAR_F:=node_ END)"

lemma DASep_Free: "x \<in> DOM G \<Longrightarrow>
                   \<rhd> (DIAM\<bullet>Free ([RNarg x])) :  DASep  G SP  None {x} {} (proj x SP)"
apply (rule vdm_invokestatic)
apply (simp only: Meth_Free)
apply (simp only: Snd)
apply (rule vdm_conseq)

apply (rule vdm_letr)
apply (rule vdm_getstat)
apply (rule vdm_letv)
apply (rule vdm_putfr)
apply (rule vdm_putstat)

(* end of VCG *)

sorry