theory DAssertLP = Comb:


(******************* NATURAL ARITHMETICS GEMS **********************)

lemma arithDistr:  "(k::nat) * n - k*m = k * (n - m)"
apply (induct k)
apply simp
apply simp
apply arith
done


lemma arithDistrOne:  "k * n - k = k * (n - (1::nat))"
apply (induct k)
apply simp
apply simp
apply arith
done

lemma arithBad: "(k::nat)+(n -k)=n"
oops


lemma natAux:"(a::nat)+b =c \<Longrightarrow> a=c-b"
apply arith
done

lemma natAuxMult:"(m::nat)+k =k*n \<Longrightarrow> m=k*(n-(1::nat))"
apply (subgoal_tac "m=k*n-k")
apply (subgoal_tac "k * n - k =k * (n - 1)")
apply simp 
apply (simp only: arithDistrOne)
apply arith
done

lemma arithLeq: "\<lbrakk>(m::nat)=k* n; 0<n\<rbrakk> \<Longrightarrow> k\<le> m"
apply auto
done


(****************************************************************)



syntax DIAM :: cname
       DOLLAR_F :: rfldname
       DOLLAR_N :: rfldname
       DOLLAR :: ifldname
       F0 :: ifldname
       F1 :: rfldname
       F2 :: rfldname

translations
 "DIAM" == "(CN ''dia_0'') "
 "DOLLAR_F" == "(RFN ''$f'')"
 "DOLLAR_N" == "(RFN ''$n'')"
 "DOLLAR" == "(IFN ''$'')"
 "F0" == "(IFN ''f0'')"
 "F1" == "(RFN ''f1'')"
 "F2" == "(RFN ''f2'')"


datatype
 extType = IntET | ListET nat 


types
 extContext = "(iname list) \<times> ((rname \<times> nat) list)"

constdefs ContextRDom:: "extContext \<Rightarrow> rname set"
"ContextRDom G == List.set (List.map (\<lambda> (a,b) .a) (snd G))"

constdefs GETi :: "extContext \<Rightarrow> iname \<Rightarrow> (extType option)"
"GETi G x \<equiv> (if x mem (fst G) then (Some IntET) else None)"

consts GETrAux :: "((rname \<times> nat) list) \<Rightarrow> extType option"
primrec
"GETrAux [] = None"
"GETrAux (h # t) = Some (ListET (snd h))"

constdefs GETr :: "extContext \<Rightarrow> rname \<Rightarrow> (extType option)"
"GETr G x \<equiv> GETrAux (filter (\<lambda> y . x = fst y) (snd G))"

constdefs INSi :: "extContext \<Rightarrow> iname \<Rightarrow> extContext"
"INSi G x \<equiv> (x # List.filter (\<lambda> y . y \<noteq> x) (fst G), snd G)"

constdefs INSr :: "extContext \<Rightarrow> rname \<Rightarrow> nat \<Rightarrow> extContext"
"INSr G x k \<equiv> (fst G, (x,k) # List.filter (\<lambda> (y,kk) . y \<noteq> x) (snd G))"


consts mLIST::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive mLIST intros
mLIST_NIL[intro!]: "(0,Nullref,{},h) : mLIST"
mLIST_CONS[intro!]:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> \<noteq> 2; h\<lfloor>a\<diamondsuit>F1\<rfloor> = r; a \<notin> X; (n,r,X,h):mLIST\<rbrakk>
          \<Longrightarrow> (Suc n, Ref a, X \<union> {a}, h): mLIST"

consts reg :: "(val \<times> heap \<times> (extType option) \<times> (locn set) \<times> nat) set"
inductive reg intros
regNone:  "(v,h,None,{},0):reg"
regList:  "\<lbrakk>(n, r, R, h) : mLIST; m = k*n\<rbrakk> \<Longrightarrow> (RVal r, h, Some(ListET k), R, m): reg"
regInt:   "(IVal i ,h,Some IntET,{}, 0): reg"

consts ContextSize::"(env \<times> heap \<times> extContext \<times> nat) set"
inductive ContextSize intros
ContextSizeNIL[intro!]: "(E,h,(iContext,[]), 0) : ContextSize"
ContextSizeCONS[intro!]: "\<lbrakk>(RVal (E\<lfloor>x\<rfloor>), h, Some (ListET k), R,n): reg ;
                   (E,h,(iContext,t),m):ContextSize\<rbrakk>
                  \<Longrightarrow> (E,h,(iContext,(x,k) # t), n+m) : ContextSize"

(*Union of disjoint contexts*)
consts ContextUnion::"(extContext \<times> extContext \<times> extContext) set"
inductive ContextUnion intros
ContextUNION : 
"\<lbrakk> (set (fst C)) \<inter> (set (fst D)) = {};(ContextRDom C) \<inter> (ContextRDom D) = {}\<rbrakk>
\<Longrightarrow> (C,D,((fst C) @ (fst D), (snd C) @ (snd D))): ContextUnion"

consts FL::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive FL intros
FL_NIL[intro!]: "(0, Nullref, {},h) : FL"
FL_SUC[intro!]: "\<lbrakk>h@@a = Some DIAM; a \<notin> X; (n, h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>,X,h):FL\<rbrakk>
        \<Longrightarrow> (Suc n, Ref a,  X \<union> {a}, h) : FL"

(************** Lemmas about a freelist ***************************)

lemma flistNonNullNonEmpty : "(m, Ref loc, X, h) : FL \<Longrightarrow> X ~= {}"
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistNonNullLoc : "(m, Ref loc, X, h) : FL \<Longrightarrow> loc \<in> X"
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistNonNullLoc' : "\<lbrakk> (m, r, X, h)  \<in>  FL; 
                           r =  Ref loc \<rbrakk>  \<Longrightarrow> loc \<in> X"
apply (erule FL.cases)
apply simp
apply simp
done


lemma flistNonNullNonZero : "(m, Ref loc, X, h) : FL \<Longrightarrow> m ~= 0"
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistNonNullPositive : "(m, Ref loc, X, h) : FL \<Longrightarrow>  0<m"
apply (erule FL.cases)
apply simp
apply simp
done



lemma flistSameOH [rule_format]: "(m, r, X, h)  \<in>  FL
                                \<Longrightarrow>
                                (\<forall> Y hh. X\<subseteq> Y \<longrightarrow> 
                                                 sameOH Y h hh \<longrightarrow>
                                                 (m, r, X, hh)  \<in>  FL)"
apply (erule FL.induct)
apply clarify
apply clarify
apply (rule FL_SUC)
apply (unfold sameOH_def)
apply simp
apply simp
apply simp
apply force
done

lemma flistZeroNull: "(0, r, X, h)  \<in>  FL \<Longrightarrow> r=Nullref"
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistZeroEmpty: "(0, r, X, h)  \<in>  FL \<Longrightarrow> X={}"
apply (erule FL.cases)
apply simp
apply simp
done


lemma flistNullEmpty: " (m, Nullref, X, h) \<in>  FL \<Longrightarrow> {}=X"
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistNullZero: "(m, Nullref, X, h)  \<in>  FL \<Longrightarrow> 0=m"
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistTail: "\<lbrakk> (m, r, X, h)  \<in>  FL; 
                    r =  Ref loc \<rbrakk> 
                                \<Longrightarrow>
                  (m-(1::nat), rheap h DOLLAR_N loc,  X-{loc}, h) \<in>  FL"   
apply (erule FL.cases)
apply simp
apply simp
done

lemma flistTail': "\<lbrakk> (m, Ref loc , X, h)  \<in>  FL\<rbrakk> 
                                \<Longrightarrow>
                             (m-(1::nat), rheap h DOLLAR_N loc,  X-{loc}, h) \<in>  FL"   
apply (erule FL.cases)
apply simp
apply simp
done



lemma funcFL [rule_format]: "(m, r, Y, h) \<in> FL \<Longrightarrow>
                            (\<forall> YY mm. (mm, r, YY, h) \<in> FL  \<longrightarrow> Y=YY \<and> m=mm)"
apply (erule FL.induct)
apply (rule allI)+
apply (rule impI)
apply (rule conjI)
apply (erule flistNullEmpty) 
apply (erule flistNullZero)

apply (rule allI)+
apply (rule impI)

apply (subgoal_tac "0<mm")
apply (subgoal_tac " a \<in> YY")
apply (subgoal_tac "(mm-(1::nat), h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>, YY- {a}, h) \<in> FL")

apply (erule allE)+
apply (drule mp)
apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)
apply (assumption)

apply (erule conjE)
apply (rule conjI)

apply fastsimp
apply simp

apply (rule flistTail')
apply (assumption)

apply (frule flistNonNullLoc)
apply assumption
 
apply (frule flistNonNullPositive)
apply assumption
done

(****** operations on heap that do not change freelist ******************)

lemma FLIfld:
  "\<lbrakk>(m, r, X, h) \<in> FL\<rbrakk> \<Longrightarrow>  (m, r, X, h<loc'\<bullet>Fld := f'>) \<in> FL"
apply (erule FL.induct)
apply (rule FL_NIL)
apply (subgoal_tac "a=loc'\<or> a~=loc'")
prefer 2
apply clarify
apply (erule disjE)

apply (rule FL_SUC)
apply simp
apply assumption
apply simp

apply (rule FL_SUC)
apply simp
apply assumption
apply simp
done

lemma FLRfld:
  "\<lbrakk>(m, r, X, h) \<in> FL; Fld ~= DOLLAR_N\<rbrakk> \<Longrightarrow>  (m, r, X, h\<lfloor>loc\<diamondsuit>Fld := f\<rfloor>) \<in> FL"
apply (erule FL.induct)
apply (rule FL_NIL)
apply (subgoal_tac "a=loc\<or> a~=loc")
prefer 2
apply clarify
apply (erule disjE)

apply (rule FL_SUC)
apply simp
apply assumption
apply fastsimp

apply (rule FL_SUC)
apply simp
apply assumption
apply fastsimp
done

lemma FLRfldElsewhere [rule_format]:
  "\<lbrakk>(m, r, X, h) \<in> FL\<rbrakk> \<Longrightarrow>  \<forall> loc. loc\<notin> X \<longrightarrow> (m, r, X, h\<lfloor>loc\<diamondsuit>DOLLAR_N := f\<rfloor>) \<in> FL"
apply (erule FL.induct)
apply (rule allI)
apply (rule impI)
apply (rule FL_NIL)

apply (rule allI)
apply (rule impI)
apply (rule FL_SUC)
apply simp
apply assumption

apply (erule allE)
apply (subgoal_tac "loc\<notin> X")
apply (subgoal_tac "loc ~= a")
apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)

apply (drule mp)
apply assumption

apply (subgoal_tac "h\<lfloor>loc\<diamondsuit>DOLLAR_N:=f\<rfloor>\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>=h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>")
apply simp
apply simp
apply simp
apply simp
done


lemma FLSfld:
  "\<lbrakk>(m, r, X, h) \<in> FL\<rbrakk> 
    \<Longrightarrow>  (m, r, X, h \<lparr>sheap := (sheap h)(c := (sheap h c)(f:=r'))\<rparr>) \<in> FL"
apply (erule FL.induct)
apply (rule FL_NIL)

apply (rule FL_SUC)
apply simp
apply assumption
apply simp
done




lemma FLRfldSfld:
  "\<lbrakk>(m, r, X, h\<lfloor>loc\<diamondsuit>F:=r'\<rfloor>) \<in> FL\<rbrakk> 
    \<Longrightarrow>  (m, r, X, h\<lfloor>loc\<diamondsuit>F:=r'\<rfloor> \<lparr>sheap := (sheap h)(c := (sheap h c)(f:=r''))\<rparr>) \<in> FL"
apply (subgoal_tac "(m, r, X, h\<lfloor>loc\<diamondsuit>F:=r'\<rfloor> \<lparr>sheap := (sheap h\<lfloor>loc\<diamondsuit>F:=r'\<rfloor>)(c := (sheap h\<lfloor>loc\<diamondsuit>F:=r'\<rfloor> c)(f:=r''))\<rparr>) \<in> FL")
apply simp
apply (rule FLSfld)
apply assumption
done

lemma FLRfldSfld':
  "\<lbrakk>(m, r, X, h\<lfloor>a\<diamondsuit>F:=r'\<rfloor> \<lparr>sheap := (sheap h)(c := (sheap h c)(f:=r''))\<rparr>) \<in> FL\<rbrakk> 
    \<Longrightarrow> (m, r, X, h\<lparr>rheap := (rheap h)(F:= (rheap h F)(a := r')),
                   sheap := (sheap h)(c := (sheap h c)(f:=r''))\<rparr>) \<in> FL"
apply simp 
done

lemma FLRfldSfld'':
  "\<lbrakk>(m, r, X, h\<lfloor>a\<diamondsuit>F:=r'\<rfloor>) \<in> FL\<rbrakk>
    \<Longrightarrow>  (m, r, X, h\<lparr>rheap := (rheap h)(F:= (rheap h F)(a := r')),
                    sheap := (sheap h)(c := (sheap h c)(f:=r''))\<rparr>) \<in> FL"
apply (rule  FLRfldSfld')
apply (rule FLRfldSfld)
apply assumption
done


(******* increase the length of FL by one ******)

lemma incrFL [rule_format]:
  "\<lbrakk>(m, r, X, h) \<in> FL\<rbrakk> \<Longrightarrow>  \<forall> loc. loc\<notin> X \<longrightarrow> h@@loc = Some DIAM \<longrightarrow> (Suc m, Ref loc, X\<union>{loc}, h\<lfloor>loc\<diamondsuit>DOLLAR_N := r\<rfloor>) \<in> FL"
apply (rule allI)
apply (rule impI)+
apply (rule FL_SUC)
apply simp
apply assumption
apply (rule FLRfldElsewhere)
apply simp
apply assumption
done

(*************** simliar lemmas about mLIST ********************)

(*consts mLIST::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive mLIST intros
mLIST_NIL: "(0,Nullref,{},h) : mLIST"
mLIST_CONS:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> \<noteq> 2; h\<lfloor>a\<diamondsuit>F1\<rfloor> = r; a \<notin> X; (n,r,X,h):mLIST\<rbrakk>
          \<Longrightarrow> (Suc n, Ref a, X \<union> {a}, h): mLIST"*)

lemma LISTNullEmpty : "(m, Nullref, X, h) :mLIST  \<Longrightarrow> X={}"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNullEmpty' : "(m, Nullref, X, h) :mLIST  \<Longrightarrow> {}=X"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNullZero : "(m, Nullref, X, h) :mLIST   \<Longrightarrow> m=0"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNullZero' : "(m, Nullref, X, h) :mLIST   \<Longrightarrow> 0=m"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNonNullPosit : "(m, Ref loc, X, h) :mLIST  \<Longrightarrow> 0<m"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNonNullPosit' : "\<lbrakk>(m, r, X, h) :mLIST; r = Ref loc\<rbrakk>  \<Longrightarrow> 0<m"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNonNullLoc : "(m, Ref loc, X, h) :mLIST  \<Longrightarrow> loc \<in> X"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNonNullLoc' : "\<lbrakk>(m, r, X, h) :mLIST;
                         r = Ref loc\<rbrakk>  \<Longrightarrow> loc \<in> X"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma LISTNonNullSomeDIA : "(m, Ref loc, X, h) :mLIST  \<Longrightarrow> h@@loc = Some DIAM"
apply (erule  mLIST.cases)
apply simp
apply simp
done

lemma mLIST_TL: "\<lbrakk> (m, Ref loc , X, h)  \<in> mLIST\<rbrakk> \<Longrightarrow>
                             (m-(1::nat), rheap h F1 loc,  X-{loc}, h) \<in>  mLIST"   
apply (erule mLIST.cases)
apply simp
apply simp
done

lemma mLIST_TL': "\<lbrakk> (m, r, X, h)  \<in>  mLIST; r =  Ref loc\<rbrakk> 
                                \<Longrightarrow>
                  (m-(1::nat), rheap h F1 loc,  X-{loc}, h) \<in>  mLIST"   
apply (erule mLIST.cases)
apply simp
apply simp
done

lemma mLIST_TL_Pos: "\<lbrakk> (m+(1::nat), Ref loc , X, h)  \<in> mLIST\<rbrakk> \<Longrightarrow>
                             (m, rheap h F1 loc,  X-{loc}, h) \<in>  mLIST"   
apply (erule mLIST.cases)
apply simp
apply simp
done

lemma mLIST_TL_Pos': "\<lbrakk> (m+(1::nat), r, X, h)  \<in>  mLIST; r =  Ref loc\<rbrakk> 
                                \<Longrightarrow>
                  (m, rheap h F1 loc,  X-{loc}, h) \<in>  mLIST"   
apply (erule mLIST.cases)
apply simp
apply simp
done

lemma mLIST_TL_Pos_: "\<lbrakk> (m, Ref loc , X, h)  \<in> mLIST; m=m'+(1::nat)\<rbrakk> \<Longrightarrow>
                             (m', rheap h F1 loc,  X-{loc}, h) \<in>  mLIST"   
apply (erule mLIST.cases)
apply simp
apply simp
done

lemma mLIST_TL_Pos_': "\<lbrakk> (m, r, X, h)  \<in>  mLIST; m=m'+(1::nat); r =  Ref loc\<rbrakk> 
                                \<Longrightarrow>
                  (m', rheap h F1 loc,  X-{loc}, h) \<in>  mLIST"   
apply (erule mLIST.cases)
apply simp
apply simp
done


lemma mLIST_func_X[rule_format]: "(m, r, X, h)  \<in>  mLIST \<Longrightarrow> 
                   \<forall> m' X'. (m', r, X', h)  \<in>  mLIST  \<longrightarrow> X=X'"
apply (erule mLIST.induct)
apply clarify
apply (rule LISTNullEmpty')
apply assumption
apply (rule allI)+
apply (rule impI)

apply (frule_tac m=m' and loc=a in mLIST_TL')
apply (simp (no_asm))
apply (erule_tac x="m'-(1::nat)" in allE)
apply (erule_tac x="X'-{a}" in allE)
apply (frule_tac  loc=a in LISTNonNullLoc)
apply fastsimp
done


lemma mLIST_func_X'[rule_format]: "\<lbrakk>(m, r, X, h)  \<in>  mLIST\<rbrakk> \<Longrightarrow> 
                   \<forall> m' X' r'. (m', r', X', h)  \<in>  mLIST  \<longrightarrow> r=r' \<longrightarrow> X=X'"
apply (erule mLIST.induct)
apply clarify
apply (rule LISTNullEmpty')
apply assumption

apply clarify
apply (frule_tac m=m' and loc=a in mLIST_TL')
apply (simp (no_asm))
apply (erule_tac x="m'-(1::nat)" in allE)
apply (erule_tac x="X'-{a}" in allE)
apply (erule_tac x="h\<lfloor>a\<diamondsuit>F1\<rfloor>" in allE)
apply (drule mp)
apply assumption
apply simp
apply (frule  LISTNonNullLoc)
apply fast
done


lemma mLIST_func_m[rule_format]: "(m, r, X, h)  \<in>  mLIST \<Longrightarrow> 
                   \<forall> m' X'. (m', r, X', h)  \<in>  mLIST  \<longrightarrow> m=m'"
apply (erule mLIST.induct)
apply clarify
apply (rule LISTNullZero')
apply assumption
apply (rule allI)+
apply (rule impI)
apply (frule_tac m=m' and loc=a in mLIST_TL')
apply (simp (no_asm))
apply (erule_tac x="m'-(1::nat)" in allE)
apply (erule_tac x="X'-{a}" in allE)
apply (frule_tac  loc=a in LISTNonNullPosit)
apply clarsimp
done

lemma mLIST_func_m'[rule_format]: "\<lbrakk>(m, r, X, h)  \<in>  mLIST\<rbrakk> \<Longrightarrow> 
                   \<forall> m' X' r'. (m', r', X', h)  \<in>  mLIST  \<longrightarrow> r=r' \<longrightarrow> m=m'"
apply (erule mLIST.induct)
apply clarify
apply (rule LISTNullZero')
apply assumption

apply clarify
apply (frule_tac m=m' and loc=a in mLIST_TL')
apply (simp (no_asm))
apply (erule_tac x="m'-(1::nat)" in allE)
apply (erule_tac x="X'-{a}" in allE)
apply (erule_tac x="h\<lfloor>a\<diamondsuit>F1\<rfloor>" in allE)
apply (drule mp)
apply assumption
apply simp
apply (frule  LISTNonNullPosit)
apply arith
done



(************* Leammas about "region"(Upsilon)  relation *******************************)

(*
consts reg :: "(val \<times> heap \<times> (extType option) \<times> (locn set) \<times> nat) set"
inductive reg intros
regNone:  "(v,h,None,{},0):reg"
regList:  "\<lbrakk>(n, r, R, h) : mLIST; m = k*n\<rbrakk> \<Longrightarrow> (RVal r, h, Some(ListET k), R, m): reg"
regInt:   "(IVal i ,h,Some IntET,{}, 0): reg"
*)

lemma regList_km:  "(RVal (Ref loc), h, Some(ListET k), R, m) \<in>  reg  \<Longrightarrow> k\<le>m"
apply (erule reg.cases)
apply simp
apply (frule_tac loc=loc in LISTNonNullPosit')
apply simp
apply (rule_tac n=n in arithLeq)
apply simp
apply assumption
apply simp
done

lemma regList_km':  "\<lbrakk>(RVal r, h, Some(ListET k), R, m) \<in>  reg; r =Ref loc\<rbrakk> 
                     \<Longrightarrow> k\<le>m"
apply (erule reg.cases)
apply simp
apply (frule_tac loc=loc in LISTNonNullPosit')
apply simp
apply (rule_tac n=n in arithLeq)
apply simp
apply assumption
apply simp
done

lemma regList_km_Le:  "\<lbrakk>(RVal (Ref loc), h, Some(ListET k), R, m) \<in>  reg; m+q \<le> N  \<rbrakk> 
                     \<Longrightarrow> k+(m-k)+q \<le> N"
apply (frule_tac loc=loc in regList_km)
apply arith
done

lemma regList_km_Le':  "\<lbrakk>(RVal r, h, Some(ListET k), R, m) \<in>  reg; r =Ref loc; m+q \<le> N  \<rbrakk> 
                     \<Longrightarrow> k+(m-k)+q \<le> N"
apply (frule_tac loc=loc in regList_km')
apply assumption
apply arith
done

lemma regList_km_LeAdd:  "\<lbrakk>(RVal (Ref loc), h, Some(ListET k), R, m) \<in>  reg; m+(m'::nat)+q \<le> N  \<rbrakk> 
                     \<Longrightarrow> k+(m-k)+q \<le> N"
apply (frule_tac loc=loc in regList_km)
apply arith
done

lemma regList_km_LeAdd':  "\<lbrakk>(RVal r, h, Some(ListET k), R, m) \<in>  reg; r=Ref loc; m+(m'::nat)+q \<le> N  \<rbrakk> 
                     \<Longrightarrow> k+(m-k)+q \<le> N"
apply (rule_tac loc=loc and h=h and R=R in regList_km_LeAdd)
apply simp
apply assumption
done

lemma regListNonNullLoc:
"(RVal (Ref loc), h, Some(ListET k), R, m) \<in>  reg \<Longrightarrow> loc \<in>  R"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
apply (rule LISTNonNullLoc')
apply assumption
apply simp
apply simp
done

lemma regListNonNullLoc':
"\<lbrakk>(RVal r, h, Some(ListET k), R, m) \<in>  reg; r =Ref loc\<rbrakk> \<Longrightarrow> loc \<in>  R"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
apply (rule LISTNonNullLoc')
apply assumption
apply simp
apply simp
done

lemma regListNonNullSomeDIA:
"(RVal (Ref loc), h, Some(ListET k), R, m) \<in>  reg \<Longrightarrow> h@@loc = Some DIAM"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
apply (rule LISTNonNullSomeDIA)
apply simp
apply simp
done

lemma regListNonNullSomeDIA':
"\<lbrakk>(RVal r, h, Some(ListET k), R, m) \<in>  reg; r =Ref loc\<rbrakk>  \<Longrightarrow> h@@loc = Some DIAM"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
apply (rule LISTNonNullSomeDIA)
apply simp
apply simp
done


lemma regListTL:
"(RVal (Ref loc), h, Some(ListET k), R, m) \<in>  reg  \<Longrightarrow> 
 (RVal h\<lfloor>loc\<diamondsuit>F1\<rfloor> , h, Some(ListET k), R-{loc}, (m-k)) \<in>  reg"
apply (erule reg.cases)
apply simp

apply simp
apply (erule conjE)+
apply (rule regList)
apply (rule mLIST_TL')
apply assumption
apply simp
apply (simp add: arithDistrOne)
apply simp 
done


lemma regListTL':
"\<lbrakk>(RVal r, h, Some(ListET k), R, m) \<in>  reg; r =Ref loc\<rbrakk>  \<Longrightarrow> (RVal h\<lfloor>loc\<diamondsuit>F1\<rfloor> , h, Some(ListET k), R-{loc}, (m-k)) \<in>  reg"
apply (erule reg.cases)
apply simp

apply simp
apply (erule conjE)+
apply (rule regList)
apply (rule mLIST_TL')
apply assumption
apply simp
apply (simp add: arithDistrOne)
apply simp 
done


lemma regListTL_Add:
"(RVal (Ref loc), h, Some(ListET k), R, m+k) \<in>  reg  \<Longrightarrow> 
 (RVal h\<lfloor>loc\<diamondsuit>F1\<rfloor> , h, Some(ListET k), R-{loc}, m) \<in>  reg"
apply (erule reg.cases)
apply simp

apply simp
apply (erule conjE)+
apply (rule regList)
apply (rule_tac m=n in mLIST_TL')
apply assumption
apply simp
apply (rule natAuxMult)
apply simp
apply simp 
done


lemma regListTL_Add':
"\<lbrakk>(RVal r, h, Some(ListET k), R, m+k) \<in>  reg; r =Ref loc\<rbrakk>  \<Longrightarrow> (RVal h\<lfloor>loc\<diamondsuit>F1\<rfloor> , h, Some(ListET k), R-{loc}, m) \<in>  reg"
apply (erule reg.cases)
apply simp

apply simp
apply (erule conjE)+
apply (rule regList)
apply (rule_tac m=n in mLIST_TL')
apply assumption
apply simp
apply (rule natAuxMult)
apply simp
apply simp 
done

lemma reg_None: "(RVal r, h, None, R, m) \<in> reg \<Longrightarrow> R = {}"
apply (erule reg.elims)
apply simp
apply simp
apply simp
done


lemma reg_List:" \<lbrakk>(n, r, R, h) \<in> mLIST; m = k * n; (RVal r, h, Some (ListET k), R', m') \<in> reg \<rbrakk>  \<Longrightarrow> R=R'"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
 
apply (rule mLIST_func_X)
apply assumption
apply assumption

apply simp
done



lemma regListFunc_R[rule_format]: "(RVal r, h, A, R, m) \<in>  reg \<Longrightarrow>
                                   \<forall> R' m'.  (RVal r, h, A, R', m') \<in>  reg 
                                     \<longrightarrow> R'=R"
apply (erule reg.elims)
apply (clarify)
apply (rule reg_None)
apply assumption

apply (rule allI)+
apply (rule impI)
apply simp
apply (erule conjE)+
apply (frule reg_List) 
apply assumption
apply assumption
apply simp

apply (clarify)
done

lemma reg_NoneZero: "(RVal r, h, None, R, m) \<in> reg \<Longrightarrow> m=0"
apply (erule reg.elims)
apply simp
apply simp
apply simp
done

lemma reg_NoneZero': "(RVal r, h, None, R, m) \<in> reg \<Longrightarrow> 0=m"
apply (erule reg.elims)
apply simp
apply simp
apply simp
done


lemma reg_ListM:" \<lbrakk>(n, r, R, h) \<in> mLIST; m = k * n; (RVal r, h, Some (ListET k), R', m') \<in> reg \<rbrakk>  \<Longrightarrow> m'=m"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
 
apply (simp add: mLIST_func_m)

apply simp
done

lemma reg_ListM':" \<lbrakk>(n, r, R, h) \<in> mLIST; m = k * n; (RVal r, h, Some (ListET k), R', m') \<in> reg \<rbrakk>  \<Longrightarrow> m=m'"
apply (erule reg.elims)
apply simp
apply simp
apply (erule conjE)+
 
apply (simp add: mLIST_func_m)

apply simp
done


lemma regListFunc_m: "\<lbrakk> (RVal r, h, A, R, m) \<in>  reg; (RVal r, h, A, R', m') \<in>  reg \<rbrakk> 
                                    \<Longrightarrow> m=m'"
apply (erule reg.elims)
apply simp
apply (erule conjE)+
apply (rule reg_NoneZero)
apply fast

apply simp
apply (erule conjE)+
apply (frule_tac m'=m' in reg_ListM) 
apply assumption
apply assumption
apply simp

apply (clarify)
done

lemma regListFunc_Rm : "\<lbrakk>(RVal r, h, A, R, m) \<in>  reg;(RVal r, h, A, R', m') \<in>  reg \<rbrakk> \<Longrightarrow>
                         R=R' \<and> m=m'"
apply (rule conjI)  
apply (rule  regListFunc_R)
apply assumption
apply assumption
apply (rule regListFunc_m)
apply assumption
apply assumption
done 
(************* From the Life of ConstSize ******************************)

(*consts ContextSize::"(env \<times> heap \<times> extContext \<times> nat) set"
inductive ContextSize intros
ContextSizeNIL[intro!]: "(E,h,(iContext,[]), 0) : ContextSize"
ContextSizeCONS[intro!]: "\<lbrakk>(RVal (E\<lfloor>x\<rfloor>), h, Some (ListET k), R,n): reg ;
                         (E,h,(iContext,t),m):ContextSize\<rbrakk>
                         \<Longrightarrow> (E,h,(iContext,(x,k) # t), n+m) : ContextSize"
*)

lemma contSizeNull: "(E, h, (l, []), CS) \<in> ContextSize \<Longrightarrow> CS=0"
apply (erule ContextSize.elims)
apply simp
apply simp
done

lemma contSizeNull': "\<lbrakk>(E, h, C, CS) \<in> ContextSize; snd C =[] \<rbrakk>
                  \<Longrightarrow> CS=0"
apply (erule ContextSize.elims)
apply simp
apply simp
done


lemma anothIntList: "(E, h, (fstC, sndC), CS) \<in> ContextSize \<Longrightarrow>
                     (E, h, (fstC', sndC), CS) \<in> ContextSize" 
apply (erule ContextSize.induct)
apply (rule ContextSizeNIL)
apply (rule ContextSizeCONS)
apply assumption
apply assumption
done 

lemma contSizeCons: "\<lbrakk> (E, h, (iContext, (x, k) # t), m) \<in> ContextSize;  
                       (RVal (renv E x), h, Some (ListET k), R, n) \<in> reg \<rbrakk> 
                       \<Longrightarrow>  (E, h, (iContext, t), m-n) \<in> ContextSize"
apply (erule  ContextSize.elims)
apply simp

apply simp
apply (erule conjE)+
apply (frule_tac R=R and m=n in regListFunc_Rm)
apply (erule thin_rl)
apply assumption
apply (erule conjE)
apply simp
done

lemma contSizeCons': "\<lbrakk> (E, h, (iContext, a # t), m) \<in> ContextSize; a=(x, k);  
                       (RVal (renv E x), h, Some (ListET k), R, n) \<in> reg \<rbrakk> 
                       \<Longrightarrow>  (E, h, (iContext, t), m-n) \<in> ContextSize"
apply (erule  ContextSize.elims)
apply simp

apply simp
apply (erule conjE)+
apply (frule_tac R=R and m=n in regListFunc_Rm)
apply (erule thin_rl)apply (erule thin_rl)
apply assumption
apply (erule conjE)
apply simp
done

lemma contSizeConsLeq : "\<lbrakk> (E, h, (iContext, (x, k) # t), m) \<in> ContextSize;  
                          (RVal (renv E x), h, Some (ListET k), R, n) \<in> reg \<rbrakk> 
                       \<Longrightarrow>  n \<le> m"
apply (erule  ContextSize.elims)
apply simp

apply simp
apply (erule conjE)+
apply (frule_tac R=R and m=n in regListFunc_m)
apply (erule thin_rl)
apply assumption
apply simp
done

lemma contSizeConsLeq': "\<lbrakk> (E, h, (iContext, a # t), m) \<in> ContextSize; a=(x, k);  
                           (RVal (renv E x), h, Some (ListET k), R, n) \<in> reg \<rbrakk> 
                       \<Longrightarrow>  n \<le> m"
apply (erule  ContextSize.elims)
apply simp

apply simp
apply (erule conjE)+
apply (frule_tac R=R and m=n in regListFunc_m)
apply (erule thin_rl)apply (erule thin_rl)
apply assumption
apply simp
done

lemma contSizeFunc[rule_format]: "(E, h, (ins,rns), CS) \<in> ContextSize \<Longrightarrow>
                     \<forall> CS'.  (E, h, (ins, rns), CS') \<in> ContextSize  \<longrightarrow>   CS'=CS"
apply (erule ContextSize.induct)
apply (rule allI)
apply (rule impI)
apply (rule contSizeNull)
apply assumption

apply (rule allI)
apply (rule impI)

apply (frule_tac contSizeCons)
apply assumption
apply (erule_tac x="CS'-n" in allE)
apply (drule mp)
apply assumption
apply (frule_tac m=CS' in contSizeConsLeq)
apply assumption
apply arith
done

lemma contSizeFunc': "\<lbrakk>(E, h, C, CS) \<in> ContextSize; C=D;
                       (E, h, D, CS') \<in> ContextSize\<rbrakk>  \<Longrightarrow>   CS'=CS"
apply simp
apply (rule_tac E=E and h=h and ins="fst D" and rns="snd D" in contSizeFunc)
apply simp
apply simp
done

lemma contSizeFuncGen[rule_format]: "(E, h, (ins,rns), CS) \<in> ContextSize \<Longrightarrow>
                                   \<forall> CS'.  (E, h, (ins', rns), CS') \<in> ContextSize  \<longrightarrow>   CS'=CS"
apply (erule ContextSize.induct)
apply (rule allI)
apply (rule impI)
apply (rule contSizeNull)
apply assumption

apply (rule allI)
apply (rule impI)

apply (frule_tac contSizeCons)
apply assumption
apply (erule_tac x="CS'-n" in allE)
apply (drule mp)
apply assumption
apply (frule_tac m=CS' in contSizeConsLeq)
apply assumption
apply arith
done

lemma contSizeFuncGen': "\<lbrakk>(E, h, C, CS) \<in> ContextSize; snd C = snd D;
                          (E, h, D, CS') \<in> ContextSize\<rbrakk>  \<Longrightarrow>   CS'=CS"
apply (rule_tac E=E and h=h and ins="fst C" and ins'="fst D" and rns="snd D" in contSizeFuncGen)
apply (subgoal_tac "C=(fst C, snd D)")
apply simp
apply  (subgoal_tac "C=(fst C, snd C)")
apply simp
apply (simp (no_asm))
apply simp
done

lemma contUnion_empty1: "\<lbrakk>(C1,C2, C) : ContextUnion; snd C1=[]\<rbrakk>
                         \<Longrightarrow> snd C = snd C2"
apply (erule ContextUnion.elims)
apply simp
done

lemma contUnion_empty1': "\<lbrakk>(C1,C2, C) : ContextUnion; snd C1=[]\<rbrakk>
                         \<Longrightarrow> C = (fst C1 @ fst C2, snd C2)"
apply (erule ContextUnion.elims)
apply simp
done

lemma contUnion_empty1_: "\<lbrakk>((iContext, []), C2, C) \<in>  ContextUnion\<rbrakk>
                         \<Longrightarrow> C = (iContext @ fst C2, snd C2)"
apply (erule ContextUnion.elims)
apply fastsimp
done


lemma contUnionSize_empty1: "\<lbrakk>((iContext, []), C2, C) : ContextUnion;  
                             (E, h, C, CS) \<in> ContextSize; 
                             (E, h, C2, CS2) \<in> ContextSize\<rbrakk>
                         \<Longrightarrow> CS=CS2"
apply (frule contUnion_empty1_)
apply (rule_tac E=E and h=h and C=C2 and CS=CS2 and D=C and CS'=CS in contSizeFuncGen')
apply assumption
apply simp
apply simp
done


lemma contUnion_empty2: "\<lbrakk>(C1,C2, C) : ContextUnion; snd C2=[]\<rbrakk>
                         \<Longrightarrow> snd C = snd C1"
apply (erule ContextUnion.elims)
apply simp
done

lemma contUnion_empty2': "\<lbrakk>(C1,C2, C) : ContextUnion; snd C2=[]\<rbrakk>
                         \<Longrightarrow> C = (fst C1 @ fst C2, snd C1)"
apply (erule ContextUnion.elims)
apply simp
done

lemma contUnion_cons1: "\<lbrakk>(C1,C2, C) : ContextUnion; snd C1= a # t\<rbrakk>
                         \<Longrightarrow> snd C = a # (t @ snd C2)"
apply (erule ContextUnion.elims)
apply simp
done

lemma contUnion_cons1': "\<lbrakk>(C1,C2, C) : ContextUnion; snd C1= a # t\<rbrakk>
                         \<Longrightarrow> C = (fst C1 @ fst C2, a # (t @ snd C2))"
apply (erule ContextUnion.elims)
apply simp
done

lemma contUnion_cons2: "\<lbrakk>(C1,C2, C) : ContextUnion; snd C2= a # t\<rbrakk>
                         \<Longrightarrow> snd C = (snd C1 @ [a]) @ t"
apply (erule ContextUnion.elims)
apply simp
done

lemma contUnion_cons2': "\<lbrakk>(C1,C2, C) : ContextUnion; snd C2= a # t\<rbrakk>
                         \<Longrightarrow> C = (fst C1 @ fst C2, (snd C1 @ [a]) @ t)"
apply (erule ContextUnion.elims)
apply simp
done

lemma contUnionCons_aux : "\<lbrakk>((iContext, a#t),C2, C) : ContextUnion;
                            C1=(iContext, t)\<rbrakk>\<Longrightarrow>
                           (C1, C2, (fst C1 @ fst C2, snd C1 @ snd C2)) \<in> ContextUnion"
apply (intro ContextUNION)
apply (erule ContextUnion.elims)
apply fastsimp
apply (erule ContextUnion.elims)
apply simp
apply (erule conjE)+
apply (simp only: ContextRDom_def)
apply fastsimp
done

lemma contUnionCons_aux' : "\<lbrakk>((iContext, a#t),C2, C) : ContextUnion\<rbrakk>\<Longrightarrow>
                             ((iContext, t), C2, iContext @ fst C2, t @ snd C2) \<in> ContextUnion"
apply (frule contUnionCons_aux)
apply simp
apply fastsimp
done

lemma contUnionCons_Size : "\<lbrakk>((iContext, (x, k)#t),C2, C) : ContextUnion;
                              (E, h, C, CS)  \<in> ContextSize;
                              (RVal E\<lfloor>x\<rfloor> , h, Some (ListET k), R, n) \<in> reg
                              \<rbrakk>\<Longrightarrow>
                             (E, h, (iContext @ fst C2, t @ snd C2), CS-n)  \<in> ContextSize"
apply (erule ContextUnion.elims)
apply simp
apply  (erule conjE)+
apply  (rule contSizeCons)
apply fastsimp
apply assumption
done

lemma contUnionCons_Leq : "\<lbrakk>((iContext, (x, k)#t),C2, C) : ContextUnion;
                              (E, h, C, CS)  \<in> ContextSize;
                              (RVal E\<lfloor>x\<rfloor> , h, Some (ListET k), R, n) \<in> reg
                              \<rbrakk>\<Longrightarrow>
                              n\<le> CS"
apply  (rule_tac E=E and h=h and iContext="iContext @ fst C2" and x=x and k=k and t="t @ snd C2" in contSizeConsLeq)
apply (erule ContextUnion.elims)
apply fastsimp
apply assumption
done

(**********************************************************************)
(*
lemma contSizeConsGen_aux: "\<forall> E h iContext x k t2 m k R n.
                            (E, h, (iContext, t1 @ ((x, k) # t2)), m) \<in> ContextSize \<longrightarrow> 
                              (RVal (renv E x), h, Some (ListET k), R, n) \<in> reg \<longrightarrow>  
                              (E, h, (iContext, t1 @ t2), m-n) \<in> ContextSize"
apply (induct t1)
apply (rule allI)+
apply (rule impI)+
apply simp
apply (rule contSizeCons)
apply (assumption)
apply (assumption)

apply (rule allI)+
apply (rule impI)+

apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x=iContext in allE)
apply (erule_tac x=x in allE)
apply (erule_tac x=k in allE)
apply (erule_tac x=t2 in allE)
apply (erule_tac x="m-n" in allE)

apply (rule contSizeCons)

apply (erule conjE)+
apply (frule_tac R=R and m=n in regListFunc_Rm)
apply (erule thin_rl)
apply simp
apply assumption
apply (erule conjE)
apply simp
oops


lemma contSizeConsGen_aux: "\<lbrakk> (E, h, (iContext, t1 @ ((x, k) # t2)), m) \<in> ContextSize;  
                          (RVal (renv E x), h, Some (ListET k), R, n) \<in> reg \<rbrakk> 
                       \<Longrightarrow>  (E, h, (iContext, t1 @ t2), m-n) \<in> ContextSize"
apply (erule  ContextSize.elims)
apply simp

apply simp
apply (erule conjE)+
apply (frule_tac R=R and m=n in regListFunc_Rm)
apply (erule thin_rl)
apply simp
apply assumption
apply (erule conjE)
apply simp
oops

lemma contSizeCons': "\<lbrakk> (E, h, (iContext, a # t), m) \<in> ContextSize; a=(x, k);  
                       (RVal (renv E x), h, Some (ListET k), R, n) \<in> reg \<rbrakk> 
                       \<Longrightarrow>  (E, h, (iContext, t), m-n) \<in> ContextSize"
apply (erule  ContextSize.elims)
apply simp

apply simp
apply (erule conjE)+
apply (frule_tac R=R and m=n in regListFunc_Rm)
apply (erule thin_rl)apply (erule thin_rl)
apply assumption
apply (erule conjE)
apply simp
oops

lemma contSizeConsLeq : "\<lbrakk> (E, h, (iContext, (x, k) # t), m) \<in> ContextSize;  
                          (RVal (renv E x), h, Some (ListET k), R, n) \<in> reg \<rbrakk> 
                       \<Longrightarrow>  n \<le> m"
apply (erule  ContextSize.elims)
apply simp

apply simp
apply (erule conjE)+
apply (frule_tac R=R and m=n in regListFunc_m)
apply (erule thin_rl)
apply assumption
apply simp
oops

lemma contSizeConsLeq': "\<lbrakk> (E, h, (iContext, a # t), m) \<in> ContextSize; a=(x, k);  
                           (RVal (renv E x), h, Some (ListET k), R, n) \<in> reg \<rbrakk> 
                       \<Longrightarrow>  n \<le> m"
apply (erule  ContextSize.elims)
apply simp

apply simp
apply (erule conjE)+
apply (frule_tac R=R and m=n in regListFunc_m)
apply (erule thin_rl)apply (erule thin_rl)
apply assumption
apply simp
oops


lemma contUnionConsGen_Size : "\<lbrakk>(C1, (iContext, t1 @ ((x, k)#t2)), C) : ContextUnion;
                              (E, h, C, CS)  \<in> ContextSize;
                              (RVal E\<lfloor>x\<rfloor> , h, Some (ListET k), R, n) \<in> reg
                              \<rbrakk>\<Longrightarrow>
                             (E, h, (fst C1 @ iContext, snd C1 @ (t1 @ t2)), CS-n)  \<in> ContextSize"
apply (erule ContextUnion.elims)
apply simp
apply  (erule conjE)+
apply  (rule contSizeCons)
apply fastsimp
apply assumption
oops

lemma contUnionCons_Leq : "\<lbrakk>((iContext, (x, k)#t),C2, C) : ContextUnion;
                              (E, h, C, CS)  \<in> ContextSize;
                              (RVal E\<lfloor>x\<rfloor> , h, Some (ListET k), R, n) \<in> reg
                              \<rbrakk>\<Longrightarrow>
                              n\<le> CS"
apply  (rule_tac E=E and h=h and iContext="iContext @ fst C2" and x=x and k=k and t="t @ snd C2" in contSizeConsLeq)
apply (erule ContextUnion.elims)
apply fastsimp
apply assumption
oops
*)
(*******************************************************)

lemma contUnion_v_aux[rule_format]: "(E, h, (ins, rns), CS1) \<in> ContextSize  \<Longrightarrow>
                                    \<forall> C C2 CS CS2. 
                                    ((ins, rns), C2,C ) : ContextUnion  \<longrightarrow> 
                                    (E, h, C, CS) \<in> ContextSize  \<longrightarrow> 
                                    (E, h, C2, CS2) \<in> ContextSize  \<longrightarrow> 
                                    CS=CS1+CS2"
apply (erule ContextSize.induct)

apply (rule allI)+
apply (rule impI)+
apply simp
apply (rule contUnionSize_empty1)
apply assumption
apply assumption
apply assumption

apply (rule allI)+
apply (rule impI)+

apply (frule contUnionCons_aux')
apply (erule_tac x="(iContext @ fst C2, t @ snd C2)" in allE)
apply (erule_tac x=C2 in allE)
apply (erule_tac x="CS-n" in allE)
apply (erule_tac x=CS2 in allE)
apply (drule mp)
apply assumption

apply (frule_tac E=E and h=h and C=C in contUnionCons_Size)
apply (assumption)
apply (assumption)
apply (drule mp)
apply assumption

apply (drule mp)
apply assumption
apply (frule_tac E=E and h=h and C=C and CS=CS in contUnionCons_Leq)
apply assumption
apply assumption

apply arith
done 


lemma contUnion_v:"\<lbrakk> (E, h, C, CS) \<in> ContextSize;  
                     (E, h, C1, CS1) \<in> ContextSize;
                     (E, h, C2, CS2) \<in> ContextSize;
                     (C1, C2,C ) : ContextUnion \<rbrakk> \<Longrightarrow>
                     CS=CS1+CS2"
apply  (rule_tac E=E and h=h and ins="fst C1" and rns="snd C1" and C=C in contUnion_v_aux) 
apply simp
apply simp
apply assumption
apply assumption
done

lemma contSizeExists :  "(E, h, (ins, a#t), CS) \<in> ContextSize  \<Longrightarrow> \<exists> x k n R. a=(x, k) \<and> 
                                                                  (RVal E\<lfloor>x\<rfloor>, h, Some(ListET k), R, n) \<in>  reg"    
apply (erule  ContextSize.elims)
apply clarsimp

apply blast
done


lemma contUnion_v_aux_1[rule_format]: "\<forall> E h C CS C2 ins . ((ins, rns), C2,C ) : ContextUnion \<longrightarrow>
                                                           (E, h, C, CS) \<in> ContextSize  \<longrightarrow>
                                                           (\<exists> CS1.  (E, h, (ins, rns), CS1)  \<in> ContextSize)"
apply (induct rns)
apply (rule allI)+
apply (rule impI)+
apply (rule_tac x=0 in exI)
apply (rule ContextSizeNIL)

apply (rule allI)+
apply (rule impI)+


apply (frule contUnionCons_aux')

apply (subgoal_tac "(E, h, ((ins @ fst C2), a # (list @ snd C2)), CS) \<in>  ContextSize")
apply (frule contSizeExists)
apply (erule exE)+
apply (erule conjE)

apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x="(ins @ fst C2, list @ snd C2)" in allE)
apply (erule_tac x="CS-n" in allE)
apply (erule_tac x=C2 in allE)
apply (erule_tac x=ins in allE)
apply (drule mp)
apply assumption

apply (drule mp)
apply (simp)
apply (frule contSizeCons)
apply (assumption)
apply (assumption)
apply (erule exE)
apply (rule_tac x="n+CS1" in exI)
apply simp
apply (rule ContextSizeCONS)
apply assumption
apply assumption

apply (erule thin_rl)

apply (subgoal_tac "C=(ins @ fst C2, a # list @ snd C2)")
apply simp
apply (erule ContextUnion.elims) 
apply fastsimp
done

lemma contUnion_v_aux_1': "\<forall> rns E h C CS C2 ins . ((ins, rns), C2,C ) : ContextUnion \<longrightarrow>
                                                           (E, h, C, CS) \<in> ContextSize  \<longrightarrow>
                                                           (\<exists> CS1.  (E, h, (ins, rns), CS1)  \<in> ContextSize)"
apply clarify
apply (rule  contUnion_v_aux_1)
apply assumption
apply assumption
done

lemma contUnion_v_exists_1:"\<lbrakk>(E, h, C, CS) \<in> ContextSize;
                             (C1, C2,C ) : ContextUnion \<rbrakk> \<Longrightarrow>
                             \<exists> CS1. (E, h, C1, CS1) \<in> ContextSize"
apply (insert contUnion_v_aux_1') 
apply (erule_tac x="snd C1" in  allE)
apply (erule_tac x="E" in  allE)
apply (erule_tac x="h" in  allE)
apply (erule_tac x="C" in  allE)
apply (erule_tac x="CS" in  allE)
apply (erule_tac x="C2" in  allE)
apply (erule_tac x="fst C1" in  allE)
apply simp
done


lemma ContexUION_aux: "\<lbrakk>  (set (fst C)) \<inter> (set (fst D)) = {};
                         (ContextRDom C) \<inter> (ContextRDom D) = {};
                          fst C' = (fst C) @ (fst D);
                          snd C' = (snd C) @ (snd D)\<rbrakk>
                       \<Longrightarrow> (C,D, C'): ContextUnion"
apply (frule ContextUNION)
apply assumption
apply (subgoal_tac "C' = (fst C @ fst D, snd C @ snd D)")
apply fastsimp
apply (subgoal_tac "C'=(fst C', snd C')")
apply fastsimp
apply (simp (no_asm))
done

lemma contUnion_cons2_subtr_aux[rule_format]: "\<forall> C1 ins a t C.
                                              (C1, (ins, a # t),C ) : ContextUnion \<longrightarrow> 
                                              (C1, (ins, t), (fst C1 @ ins, snd C1 @ t)) : ContextUnion"
apply (rule allI)+
apply (rule impI)
apply (erule ContextUnion.elims)
apply simp
apply (erule conjE)+
apply (rule ContexUION_aux)
apply fastsimp
apply (simp only: ContextRDom_def)
apply fastsimp
apply simp
apply simp
done

consts restr:: "('a list) \<Rightarrow> 'a \<Rightarrow> ('a list)"
primrec
"restr [] x = []"
"restr (h#t) x = (if x=h then t else h#(restr t x))"

lemma contsizeMemSubtr_aux[rule_format]: "\<forall> E h C CS  ins x k.
                                          (E, h, (ins, rns), CS) \<in> ContextSize  \<longrightarrow>
                                          (x, k) mem rns \<longrightarrow>
                                          (\<exists> n R. (RVal E\<lfloor>x\<rfloor> , h, Some (ListET k), R, n) \<in> reg \<and>
                                                  (E, h, (ins, restr rns (x, k)), CS -n) \<in> ContextSize)"
apply (induct rns)
apply clarsimp

apply (rule allI)+
apply (rule impI)+

sorry

(*
                             
lemma contUnion_v_aux_2[rule_format]: "\<forall> E h C CS C1 ins . (C1, (ins, rns),C ) : ContextUnion \<longrightarrow>
                                                           (E, h, C, CS) \<in> ContextSize  \<longrightarrow>
                                                           (\<exists> CS2.  (E, h, (ins, rns), CS2)  \<in> ContextSize)"
apply (induct rns)
apply (rule allI)+
apply (rule impI)+
apply (rule_tac x=0 in exI)
apply (rule ContextSizeNIL)

apply (rule allI)+
apply (rule impI)+

apply (frule  contUnion_cons2_subtr_aux)

apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x="(fst C1 @ ins, snd C1  @ list)" in allE)
apply (erule_tac x=CS in allE)
apply (erule_tac x=C1 in allE)
apply (erule_tac x=ins in allE)
apply (simp)
apply (drule mp)
apply assumption

apply (subgoal_tac "(E, h, ((ins @ fst C2), a # (list @ snd C2)), CS) \<in>  ContextSize")
apply (frule contSizeExists)
apply (erule exE)+
apply (erule conjE)

apply (erule_tac x=E in allE)
apply (erule_tac x=h in allE)
apply (erule_tac x="(ins @ fst C2, list @ snd C2)" in allE)
apply (erule_tac x="CS-n" in allE)
apply (erule_tac x=C2 in allE)
apply (erule_tac x=ins in allE)
apply (drule mp)
apply assumption

apply (drule mp)
apply (simp)
apply (frule contSizeCons)
apply (assumption)
apply (assumption)
apply (erule exE)
apply (rule_tac x="n+CS1" in exI)
apply simp
apply (rule ContextSizeCONS)
apply assumption
apply assumption

apply (erule thin_rl)

apply (subgoal_tac "C=(ins @ fst C2, a # list @ snd C2)")
apply simp
apply (erule ContextUnion.elims) 
apply fastsimp
done

lemma contUnion_v_aux_1': "\<forall> rns E h C CS C2 ins . ((ins, rns), C2,C ) : ContextUnion \<longrightarrow>
                                                           (E, h, C, CS) \<in> ContextSize  \<longrightarrow>
                                                           (\<exists> CS1.  (E, h, (ins, rns), CS1)  \<in> ContextSize)"
apply clarify
apply (rule  contUnion_v_aux_1)
apply assumption
apply assumption
done

lemma contUnion_v_exists_1:"\<lbrakk>(E, h, C, CS) \<in> ContextSize;
                             (C1, C2,C ) : ContextUnion \<rbrakk> \<Longrightarrow>
                             \<exists> CS1. (E, h, C1, CS1) \<in> ContextSize"
apply (insert contUnion_v_aux_1') 
apply (erule_tac x="snd C1" in  allE)
apply (erule_tac x="E" in  allE)
apply (erule_tac x="h" in  allE)
apply (erule_tac x="C" in  allE)
apply (erule_tac x="CS" in  allE)
apply (erule_tac x="C2" in  allE)
apply (erule_tac x="fst C1" in  allE)
apply simp
done

lemma contUnion_v_exists_2:"\<lbrakk>(E, h, C, CS) \<in> ContextSize;
                             (C1, C2,C ) : ContextUnion \<rbrakk> \<Longrightarrow>
                             \<exists> CS2. (E, h, C2, CS2) \<in> ContextSize"

*)

(********* THE Assertion ***********************************)



constdefs pairInCont :: "((rname \<times> rname) set) \<Rightarrow> extContext \<Rightarrow> bool"
"pairInCont S G ==
(\<forall> x. x \<in>  S \<longrightarrow> ((fst x) \<in> ContextRDom G \<and> (snd x) \<in> ContextRDom G))" 

lemma pairInContExtCont :"\<lbrakk>pairInCont S G; ContextRDom G  \<subseteq>  ContextRDom G'\<rbrakk> 
                            \<Longrightarrow> pairInCont S G' "
apply (simp only: pairInCont_def)
apply fast
done

constdefs sepSetReg :: "(rname set) \<Rightarrow> env\<Rightarrow> heap \<Rightarrow> (locn set) \<Rightarrow> bool" 
"sepSetReg X E h F == 
\<forall> x A R S. x\<in> X \<longrightarrow> (RVal E\<lfloor>x\<rfloor>, h, A, R, S) \<in>  reg \<longrightarrow>  R \<inter> F ={}"

constdefs sepPairsReg :: "((rname \<times> rname) set) \<Rightarrow> env\<Rightarrow> heap \<Rightarrow> bool" 
"sepPairsReg P E h ==
\<forall> p A1 R1 S1 A2 R2 S2. p \<in> P \<longrightarrow> 
                       (RVal E\<lfloor>(fst p)\<rfloor>, h, A1, R1, S1) \<in>  reg \<longrightarrow>
                       (RVal E\<lfloor>(snd p)\<rfloor>, h, A2, R2, S2) \<in>  reg \<longrightarrow>
                        R1 \<inter> R2 ={}"

constdefs staySameReg :: "(rname set) \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool"                  
"staySameReg   X h E hh      == \<forall>  x A R S loc . x \<in>  X  \<longrightarrow> 
                                              (RVal E\<lfloor>x\<rfloor>, h, A, R, S) \<in>  reg \<longrightarrow> 
                                              loc \<in> R  \<longrightarrow>  
                                              sameOH {loc} h hh"


constdefs DAssert::"extContext \<Rightarrow> ((rname \<times> rname) set) \<Rightarrow>  nat \<Rightarrow> 
                       env \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> val \<Rightarrow>
                      (extType option) \<Rightarrow> (rname set) \<Rightarrow> (rname set) \<Rightarrow> nat \<Rightarrow> 
                       bool"
(* To represent in Grail Theorem 1 from the POPL'03 paper *)
(* \<Gamma>, n \<turnstile> e: A, nn *)
(* E, h \<turnstile> e \<leadsto> ^{bs} v, hh *)
(* G - a "context", "variables \<Rightarrow> types", as "\Gamma" in the paper;
   SP - a set of rname-pairs x,y, s.t. x and y points to sep. regions in env. E;
   StSm - a set of rnames, pointing to regions, not touched by eval.
   SV - a set of rnames, pointing to regions separated from out-value region *)
"DAssert G SP n E h hh v A StSm SV nn ==
((pairInCont SP G)  \<and> StSm \<subseteq> (ContextRDom G) \<and> SV \<subseteq> StSm  \<and>         
(\<forall> F N q CS. (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) \<in> FL \<longrightarrow>
              sepPairsReg SP E h  \<longrightarrow> 
              sepSetReg (ContextRDom G) E h F \<longrightarrow>
              (E,h,G,CS) \<in> ContextSize \<longrightarrow>
               n + CS + q \<le> N \<longrightarrow>
              (\<exists> R CS' NN FF.
              (NN , hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, FF, hh) \<in> FL \<and>
              (v,hh, A,R, CS') \<in>  reg \<and>
              R \<inter> FF ={} \<and>
              staySameReg StSm h E hh \<and>
              sepSetReg StSm E hh FF \<and>
              sepSetReg SV E hh R  \<and> 
              nn + CS' + q \<le> NN  \<and> 
              oheap h = oheap hh)))"


constdefs DA::"extContext \<Rightarrow> ((rname \<times> rname) set) \<Rightarrow> nat \<Rightarrow> 
               (extType option) \<Rightarrow> (rname set) \<Rightarrow> (rname set) \<Rightarrow> nat \<Rightarrow> vdmassn"
"DA G SP n A StSm SV nn == (\<lambda> E h hh v p . DAssert  G SP n E h hh v A StSm SV nn)"

(***********************************************************************)

lemma myUnionLeft: "{a}\<union> B= insert a B"
apply simp
done

lemma Fst:"fst (a, b)=a"
apply simp
done

lemma Snd:"snd (a, b)=b"
apply simp
done


(********** about freelist management **********************)

syntax Free :: mname
       node_ :: rname
       freelist_ :: rname
translations
"Free" == "(MN ''free'')"
"node_" == "(RN ''node'')"
"freelist_" == "(RN ''freelist'')"

axioms Meth_Free:
"methtable DIAM Free = ([RNpar node_], LET rf freelist_ = DIAM\<struct>DOLLAR_F;
                                                     _ = PutFr node_ DOLLAR_N freelist_
                                       IN DIAM\<struct>DOLLAR_F:=node_ END)"



lemma DA_Free: "\<rhd> (DIAM\<bullet>Free ([RNarg x])) :  (DA ([],[(x, k)]) {} 0 None {} {} 1)"
apply (rule vdm_invokestatic)
apply (simp only: Meth_Free)
apply (simp only: Snd)
apply (rule vdm_conseq)

apply (rule vdm_letr)
apply (rule vdm_getstat)
apply (rule vdm_letv)
apply (rule vdm_putfr)
apply (rule vdm_putstat)

(* end of VCG *)

apply (simp only: Fst)
apply clarify
apply (unfold DA_def)
apply (unfold DAssert_def)

apply (rule conjI)
apply (simp add: pairInCont_def)

apply (rule conjI)
apply (simp add: ContextRDom_def)

apply (rule conjI)
apply simp

apply (rule allI)+
apply (rule impI)+

apply (rule exI)+

apply (rule conjI)
apply simp
apply (rule  FLRfldSfld'')

apply (rule incrFL)
apply assumption

apply (erule  ContextSize.elims)
apply simp

apply (frule regListNonNullLoc')
apply (simp add: newframe_env_def evalARGS_def)
apply (simp add: sepSetReg_def ContextRDom_def)
apply (erule conjE)+
apply (erule allE)+
apply fastsimp

apply (erule  ContextSize.elims)
apply simp

apply (frule regListNonNullSomeDIA')
apply (simp add: newframe_env_def evalARGS_def)
apply simp

apply (rule conjI)
apply (rule regNone)

apply (rule conjI)
apply simp

apply (rule conjI)
apply (simp add: staySameReg_def)

apply (rule conjI)
apply (simp add: sepSetReg_def)

apply (rule conjI)
apply (simp add: sepSetReg_def)


apply (rule conjI)
apply arith

apply simp
done


(**********************DERIVED RULES*************************************)

lemma DA_Null: "G \<rhd> Null: DA ([],[]) {} 0 None {} {} 0"
apply (rule vdm_conseq)
apply (rule vdm_null)
apply (simp only: DA_def DAssert_def)
apply (rule allI)+
apply (rule impI)
apply (erule conjE)+ 
apply (rule conjI) apply (simp add: pairInCont_def)
apply (rule conjI) apply (simp add: ContextRDom_def)
apply (rule conjI) apply (simp)
apply (rule allI)+
apply (rule impI)+
apply (rule exI)+
apply (rule conjI) apply simp
apply (rule conjI) apply (rule regNone)
apply (rule conjI) apply simp
apply (rule conjI) apply (simp add: staySameReg_def) 
apply (rule conjI) apply (simp add: sepSetReg_def)
apply (rule conjI) apply (simp add: sepSetReg_def)
apply (rule conjI) apply simp
apply simp 
done



lemma DA_GetF_TL: "G \<rhd> GetFr x F1: DA ([],[(x,k)]) {} 0 (Some (ListET k)) {x} {} k"
apply (rule vdm_conseq)
apply (rule vdm_getfr)
apply (rule allI)+
apply (rule impI)
apply (erule exE)
apply (erule conjE)+ 
apply (simp only: DA_def DAssert_def)
apply (rule conjI) apply (simp add: pairInCont_def) 
apply (rule conjI) apply (simp add: ContextRDom_def)
apply (rule conjI) apply (simp)
apply (rule allI)+
apply (rule impI)+

apply (erule ContextSize.cases)
apply simp

apply (rule exI)+
apply (rule conjI) apply assumption
apply (rule conjI) apply (rule  regListTL) apply simp

apply (rule conjI) apply (simp only: sepSetReg_def ContextRDom_def)
apply fastsimp

apply (rule conjI) apply (simp add: staySameReg_def sameOH_def)

apply (rule conjI) apply (simp add: sepSetReg_def ContextRDom_def)

apply (rule conjI) apply (simp (no_asm) only: sepSetReg_def)
apply simp

apply (rule conjI) apply simp
apply (erule conjE)+
apply (rule regList_km_LeAdd) 
apply assumption
apply assumption
apply simp
done

(*
def. of DAsser: "if members of SP are in CotextRDom C2=X2= "staySame for e" " \<dots>
 *)

(***************************************************************)


(*

lemma DA_Letv:
      "\<lbrakk>(C1,C2,C) : ContextUnion; 
        X =  ContextRDom C;
        X1 = ContextRDom C1;
        X2 = ContextRDom C2;
        G \<rhd> e :  DA C1 SP n None X2 {} n0;
        G \<rhd> ee : DA C2 SP n0 A StSm SV n'\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): DA C SP n A StSm SV n'"

apply (rule vdm_conseq)
apply (rule vdm_letv)
apply assumption
apply assumption
apply (rule allI)+
apply (rule impI)+
apply (erule exE)+
apply (erule conjE)+
apply (rotate_tac 4) apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 2) apply (erule thin_rl)

apply (simp (no_asm) only:  DA_def DAssert_def)

apply (rule conjI)
apply (simp only:  DA_def DAssert_def)
apply (erule conjE)+
apply (rule_tac G=C1 and G'=C in pairInContExtCont)
apply assumption
apply (erule ContextUnion.elims)
apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply simp
apply (erule conjE)+
apply (simp (no_asm) only: ContextRDom_def)
apply fastsimp

apply (rule conjI)
apply (simp only:  DA_def DAssert_def)
apply (erule conjE)+
apply (erule ContextUnion.elims)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 3)
apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 5)
apply (erule thin_rl)
apply simp
apply (erule conjE)+
apply (erule thin_rl)apply (erule thin_rl)
apply (simp only: ContextRDom_def)
apply force

apply (rule conjI)
apply (simp only:  DA_def DAssert_def)


apply (rule allI)+
apply (rule impI)+

apply (simp only:  DA_def DAssert_def)
apply (erule conjE)+

apply (frule contUnion_v_exists_1)
apply assumption
apply (frule contUnion_v_exists_2)
apply assumption
apply (erule exE)+
apply (erule_tac x=F in allE)
apply (erule_tac x=N in allE)
apply (erule_tac x="q+CS2" in allE)
apply (erule_tac x="CS1" in allE)
apply (drule mp)
apply assumption
apply simp

apply (subgoal_tac "sepSetReg (ContextRDom C1) E h F")
apply (drule mp)
apply assumption

apply (subgoal_tac "n + CS1 + (q + CS2) \<le> N")
apply (drule mp)
apply assumption

apply (erule exE)+
apply (erule conjE)+

apply (erule_tac x="FF" in allE)
apply (erule_tac x="NN" in allE)
apply (drule mp)
apply assumption
apply (subgoal_tac "sepPairsReg SP E h1")
apply (drule mp)
apply assumption
apply (subgoal_tac "sepSetReg (ContextRDom C1) E h F")
apply (drule mp)
apply assumption
apply (erule_tac x=q in allE)
apply (erule_tac x=CS2 in allE)
apply (subgoal_tac "(E, h1, C2, CS2) \<in> ContextSize")
apply (drule mp)
apply assumption

apply (subgoal_tac "n0 + CS2 + q \<le> NN")
apply (drule mp)
apply assumption

apply (erule exE)+
apply (erule conjE)+

apply (rule exI)+
apply (rule conjI)
apply assumption
apply (rule conjI)
apply assumption
apply (rule conjI)
apply assumption

apply (rule conjI)
apply assumption



apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
sorry
*)

(********************* WEAKER ASSERTION **************************************)
(********************* ONLY SEPS  ********************************************)


constdefs DAssertSep::"extContext \<Rightarrow> ((rname \<times> rname) set) \<Rightarrow> 
                       env \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> val \<Rightarrow>
                      (extType option) \<Rightarrow> (rname set) \<Rightarrow> (rname set) \<Rightarrow>  
                       bool"
(* \<Gamma>, n \<turnstile> e: A, nn *)
(* E, h \<turnstile> e \<leadsto> ^{bs} v, hh *)
(* G - a "context", "variables \<Rightarrow> types", as "\Gamma" in the paper;
   SP - a set of rname-pairs x,y, s.t. x and y points to sep. regions in env. E;
   StSm - a set of rnames pointing to regions that have not been changed;
   SV - a set of rnames, pointing to regions separated from out-value region *)
"DAssertSep G SP E h hh v A StSm SV  ==
((pairInCont SP G)  \<and> StSm \<subseteq> (ContextRDom G) \<and> SV \<subseteq> StSm  \<and>         
(\<forall> F N . (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) \<in> FL \<longrightarrow>
          sepPairsReg SP E h  \<longrightarrow> 
          (\<exists> R CS' NN FF.
          (NN , hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, FF, hh) \<in> FL \<and>
          (v,hh, A,R, CS') \<in>  reg \<and>
          R \<inter> FF ={} \<and>
          staySameReg StSm h E hh \<and>
          sepSetReg StSm E hh FF \<and>
          sepSetReg SV E hh R  \<and>  
          oheap h = oheap hh)))"

constdefs DASep::"extContext \<Rightarrow> ((rname \<times> rname) set) \<Rightarrow> 
                 (extType option) \<Rightarrow> (rname set) \<Rightarrow> (rname set) \<Rightarrow> vdmassn"
"DASep G SP A StSm SV  == (\<lambda> E h hh v p . DAssertSep  G SP E h hh v A StSm SV )"

lemma DASep_Letv:
      "\<lbrakk>(C1,C2,C) : ContextUnion; 
        X =  ContextRDom C; (*  static approximation of free variables e   *)
        X1 = ContextRDom C1;(*  static approximation of free variables e1  *)
        X2 = ContextRDom C2;(*  static approximation of free variables e2  *)
        X2 \<subseteq> StSm0;(* static approximation of ben. sharing *)
        SP0 \<subseteq> SP;
        G \<rhd> e :  DASep C1 SP None StSm0 Junk;
        G \<rhd> ee : DASep C2 SP0 A StSm SV\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): DASep C SP A StSm SV "
apply (rule vdm_conseq)
apply (rule vdm_letv)
apply assumption
apply assumption
apply (rule allI)+
apply (rule impI)+
apply (erule exE)+
apply (erule conjE)+
apply (rotate_tac 5) apply (erule thin_rl)apply (erule thin_rl)

apply (simp (no_asm) only:  DASep_def DAssertSep_def)

apply (rule conjI)
apply (simp only:  DASep_def DAssertSep_def)
apply (erule conjE)+
apply (rule_tac G=C1 and G'=C in pairInContExtCont)
apply assumption
apply (erule ContextUnion.elims)
apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply simp
apply (erule conjE)+
apply (simp (no_asm) only: ContextRDom_def)
apply fastsimp

apply (rule conjI)
apply (simp only:  DASep_def DAssertSep_def)
apply (erule conjE)+
apply (erule ContextUnion.elims)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply simp
apply (erule conjE)+
apply (simp only: ContextRDom_def)
apply simp
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)
apply fast

apply (rule conjI)
apply (simp only:  DASep_def DAssertSep_def)

apply (rule allI)+
apply (rule impI)+

apply (simp only:  DASep_def DAssertSep_def)
apply (erule conjE)+

apply (erule_tac x=F in allE)
apply (erule_tac x=N in allE)

apply (drule mp)
apply assumption
apply (drule mp)
apply (simp (no_asm))

apply (erule exE)+
apply (erule conjE)+

apply (erule_tac x=FF in allE)
apply (erule_tac x=NN in allE)
apply (drule mp)
apply assumption
(*********************************************)

(*******************************************************************)


constdefs DAssertStrong::"extContext \<Rightarrow> ((rname \<times> rname) set) \<Rightarrow> 
                       env \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> val \<Rightarrow>
                      (extType option) \<Rightarrow> (rname set) \<Rightarrow> (rname set) \<Rightarrow>  
                       bool"
(* \<Gamma>, n \<turnstile> e: A, nn *)
(* E, h \<turnstile> e \<leadsto> ^{bs} v, hh *)
(* G - a "context", "variables \<Rightarrow> types", as "\Gamma" in the paper;
   SP - a set of rname-pairs x,y, s.t. x and y points to sep. regions in env. E;
   StSm - a set of rnames pointing to regions that have not been changed;
   SV - a set of rnames, pointing to regions separated from out-value region *)
"DAssertSep G SP E h hh v A StSm SV  ==
((pairInCont SP G)  \<and> StSm \<subseteq> (ContextRDom G) \<and> SV \<subseteq> StSm  \<and>         
(\<forall> F N . (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) \<in> FL \<longrightarrow>
          sepPairsReg SP E h  \<longrightarrow> 
          (\<exists> R CS' NN FF.
          (NN , hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, FF, hh) \<in> FL \<and>
          (v,hh, A,R, CS') \<in>  reg \<and>
          R \<inter> FF ={} \<and>
          staySameReg StSm h E hh \<and>
          sepSetReg StSm E hh FF \<and>
          sepSetReg SV E hh R  \<and>  
          oheap h = oheap hh)))"

constdefs DASep::"extContext \<Rightarrow> ((rname \<times> rname) set) \<Rightarrow> 
                 (extType option) \<Rightarrow> (rname set) \<Rightarrow> (rname set) \<Rightarrow> vdmassn"
"DASep G SP A StSm SV  == (\<lambda> E h hh v p . DAssertSep  G SP E h hh v A StSm SV )"

lemma DASep_Letv:
      "\<lbrakk>(C1,C2,C) : ContextUnion; 
        X =  ContextRDom C;
        X1 = ContextRDom C1;
        X2 = ContextRDom C2;
        X2 \<subseteq> StSm0;(* static approximation of ben. sharing *)
        G \<rhd> e :  DASep C1 SP None StSm0 X0;
        G \<rhd> ee : DASep C2 SP0 A StSm SV\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): DASep C SP A StSm SV "
apply (rule vdm_conseq)
apply (rule vdm_letv)
apply assumption
apply assumption
apply (rule allI)+
apply (rule impI)+
apply (erule exE)+
apply (erule conjE)+
apply (rotate_tac 5) apply (erule thin_rl)apply (erule thin_rl)

apply (simp (no_asm) only:  DASep_def DAssertSep_def)

apply (rule conjI)
apply (simp only:  DASep_def DAssertSep_def)
apply (erule conjE)+
apply (rule_tac G=C1 and G'=C in pairInContExtCont)
apply assumption
apply (erule ContextUnion.elims)
apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply simp
apply (erule conjE)+
apply (simp (no_asm) only: ContextRDom_def)
apply fastsimp

apply (rule conjI)
apply (simp only:  DASep_def DAssertSep_def)
apply (erule conjE)+
apply (erule ContextUnion.elims)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl)apply (erule thin_rl)
apply (erule thin_rl)apply (erule thin_rl)
apply simp
apply (erule conjE)+
apply (simp only: ContextRDom_def)
apply simp
apply (erule thin_rl)apply (erule thin_rl)
apply fast

apply (rule conjI)
apply (simp only:  DASep_def DAssertSep_def)

apply (rule allI)+
apply (rule impI)+

apply (simp only:  DASep_def DAssertSep_def)
apply (erule conjE)+

apply (erule_tac x=F in allE)
apply (erule_tac x=N in allE)

apply (drule mp)
apply assumption
apply (drule mp)
apply (simp (no_asm))

apply (erule exE)+
apply (erule conjE)+

apply (erule_tac x=FF in allE)
apply (erule_tac x=NN in allE)
apply (drule mp)
apply assumption
sorry