theory DAss_rules = DAss :

section {*Rules for derived assertions*}

subsection {* Logical rules*}

lemma DA_Generalise: 
"\<lbrakk>G \<rhd> e: DAss n C X T nn Y Z; n \<le> m; X \<subseteq> XX; YY \<subseteq> Y; Z \<subseteq> ZZ; XX \<union> ZZ \<subseteq> DOM C; mm \<le> nn\<rbrakk>
 \<Longrightarrow> G \<rhd> e: DAss m C XX T mm YY ZZ"
by (erule vdm_conseq, clarsimp, erule DAss_Generalise, fast+)

lemma DA_Weaken: 
"\<lbrakk>G \<rhd> e: DAss n C1 X T nn Y Z; (C1,C2,C):Union\<rbrakk> \<Longrightarrow> G \<rhd> e: DAss n C X T nn Y Z"
apply (erule vdm_conseq, simp add: DAss_def, safe)
apply (rule Union_DOM1) apply (erule SubsetTriv, assumption, assumption)
apply (rule Union_DOM1) apply (erule SubsetTriv, assumption, assumption)
apply (rule Union_DOM1) apply (erule SubsetTriv, assumption, assumption)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE, safe)
  apply (erule Union_regionsExist_CC1, assumption)
  apply (erule Union_regionsDistinct_CC1, assumption, assumption)
  apply (erule Union_distinctFrom_CC1, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
  apply (erule Union_distinctFrom_C1C, assumption, assumption)
  apply (erule Union_unmodified_C1C, assumption, assumption)
  apply (erule Union_Result_bounded_C1C, assumption)
  apply (erule Union_FL_bounded_C1C, assumption, assumption)
  apply (erule Union_Size_restricted_C1C, assumption)
done

text{*We also have the following implication:
DAss_PConst: "DAss n G X A nn Y Z E h hh v p \<Longrightarrow> DAss n G X A nn Y Z E h hh v pp
whose proof is in file Dass.thy
*}

subsection {*Rules for primitive operations*}
text {*These rules come in weak and strong forms. Using the former ones should reduce the need
to apply DA_Weaken, for the price of obtaining more verification conditions.*}

lemma DA_Null_strong: "GG \<rhd> Null: DAss n G {} (ListET k) n (DOM G) {}"
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: DAss_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe)
apply (rule regList, rule mLIST_NIL, simp)
apply (rule distinctFrom_Triv2)
apply (rule unmodified_Sameheap)
apply (rule Result_bounded_Empty)
apply (rule FL_bounded_SameF)
apply (rule Size_restricted_Const)
done
lemma DA_Null_weak: "\<lbrakk>X \<subseteq> DOM G; Y \<subseteq> DOM G; Z \<subseteq> DOM G; m \<le> n\<rbrakk> \<Longrightarrow> GG \<rhd> Null: DAss n G X (ListET k) m Y Z"
by (rule DA_Generalise, rule DA_Null_strong, auto)

lemma DA_Int_strong: "GG \<rhd> expr.Int i: DAss n G {} IntET n (DOM G) {}"
apply (rule vdm_conseq, rule vdm_int)
apply (simp add: DAss_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule regInt)
apply (rule distinctFrom_Triv2)
apply (rule unmodified_Sameheap)
apply (rule Result_bounded_Empty)
apply (rule FL_bounded_SameF)
apply (rule Size_restricted_Const)
done
lemma DA_Int_weak: "\<lbrakk>X \<subseteq> DOM G; Y \<subseteq> DOM G; Z \<subseteq> DOM G; m \<le> n\<rbrakk> \<Longrightarrow> GG \<rhd> expr.Int i: DAss n G X IntET m Y Z"
by (rule DA_Generalise, rule DA_Int_strong, auto)

lemma DA_IVar_strong: "GG \<rhd> IVar x: DAss n G {} IntET n (DOM G) {}"
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (simp add: DAss_def, clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule regInt)
apply (rule distinctFrom_Triv2)
apply (rule unmodified_Sameheap)
apply (rule Result_bounded_Empty)
apply (rule FL_bounded_SameF)
apply (rule Size_restricted_Const)
done
lemma DA_IVar_weak: "\<lbrakk>X \<subseteq> DOM G;Z \<subseteq> DOM G; m \<le> n\<rbrakk> \<Longrightarrow> GG \<rhd> IVar x: DAss n G X IntET m ((DOM G)-X) Z"
by (rule DA_Generalise, rule DA_IVar_strong, auto)

lemma DA_RVar_strong: "GETr G x = Some T \<Longrightarrow> GG \<rhd> RVar x: DAss n G {x} T n {} {}"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: DAss_def, safe)
apply (erule GETrSome_DOM)
apply (subgoal_tac "\<exists> R S . (RVal (E\<lfloor>x\<rfloor>),h,Some T,R,S):reg", safe) prefer 2 apply (erule regionsExist_Lookup, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule distinctFrom_Triv1)
apply (rule unmodified_Sameheap)
apply (erule distinctFrom_Lookup, subgoal_tac "(RVal (renv E x), h, GETr G x, R, S) \<in> reg", assumption, clarsimp, assumption, assumption)
apply (erule Result_bounded_lookup) apply (subgoal_tac "(RVal (renv E x), h, GETr G x, R, S) \<in> reg",assumption,clarsimp)
apply (rule FL_bounded_SameF) 
apply (simp add: Size_restricted_def)
apply clarsimp
apply (subgoal_tac "S \<le> CS", clarsimp)
apply (erule ContextSize_contains_region)
apply (erule GETrSome_DOM)
apply (clarsimp, assumption)
done
lemma DA_RVar_weak: "\<lbrakk>GETr G x = Some T; x:X; X \<subseteq> DOM G;Z \<subseteq> DOM G; m \<le> n\<rbrakk> \<Longrightarrow> GG \<rhd> RVar x: DAss n G X T m (X-{x}) Z"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: DAss_def, rule, fast)
apply safe
apply (subgoal_tac "\<exists> R S . (RVal (E\<lfloor>x\<rfloor>),h,Some T,R,S):reg", safe) prefer 2 apply (erule regionsExist_Lookup, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (simp add: distinctFrom_def regionsDistinct_def,clarsimp)
  apply (rotate_tac 8, erule thin_rl, erule_tac x=xa in allE, erule_tac x=x in allE, fastsimp)
apply (rule unmodified_Sameheap)
apply (erule distinctFrom_Lookup, subgoal_tac "(RVal (renv E x), h, GETr G x, R, S) \<in> reg", assumption, clarsimp, assumption, assumption)
apply (erule Result_bounded_lookup) apply (subgoal_tac "(RVal (renv E x), h, GETr G x, R, S) \<in> reg",assumption,clarsimp)
apply (rule FL_bounded_SameF) 
apply (simp add: Size_restricted_def)
apply clarsimp
apply (subgoal_tac "S \<le> CS", clarsimp)
apply (erule ContextSize_contains_region)
apply (erule GETrSome_DOM)
apply (clarsimp, assumption)
done

lemma DA_Prim_strong: "GG \<rhd> Primop f x y: DAss n G {} IntET n (DOM G) {}"
apply (rule vdm_conseq, rule vdm_prim, simp add: DAss_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply (rule distinctFrom_Triv2)
apply (rule unmodified_Sameheap)
apply (rule Result_bounded_Empty)
apply (rule FL_bounded_SameF)
apply (rule Size_restricted_Const)
done
lemma DA_Prim_weak: "\<lbrakk>X \<subseteq> DOM G; Y \<subseteq> DOM G; Z \<subseteq> DOM G; m \<le> n\<rbrakk> \<Longrightarrow> GG \<rhd> Primop f x y: DAss n G X IntET m Y Z"
by (rule DA_Generalise, rule DA_Prim_strong, auto)

lemma DA_Rprim_strong: 
"\<lbrakk>GETr G x = Some (ListET k1); GETr G y = Some (ListET k2)\<rbrakk> \<Longrightarrow> GG \<rhd> RPrimop f x y: DAss n G {} IntET n (DOM G) {}"
apply (rule vdm_conseq, rule vdm_rprim, simp add: DAss_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply (rule distinctFrom_Triv2)
apply (rule unmodified_Sameheap)
apply (rule Result_bounded_Empty)
apply (rule FL_bounded_SameF)
apply (rule Size_restricted_Const)
done
lemma DA_Rprim_weak: 
"\<lbrakk>GETr G x = Some (ListET k1); GETr G y = Some (ListET k2);
  X \<subseteq> DOM G; Y \<subseteq> DOM G; Z \<subseteq> DOM G; m \<le> n\<rbrakk> \<Longrightarrow> GG \<rhd> RPrimop f x y: DAss n G X IntET m Y Z"
by (rule DA_Generalise, rule DA_Rprim_strong, auto)


subsection {* Rules for let-primop combinations *}

lemma DA_Let_RPrim:
  "\<lbrakk>G \<rhd> e : DAss n Cz X A m Y Z;
    (C, ({z},emptyfinmap), Cz) : Union;
    GETr C x = Some k;
    GETr C y = Some k
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END): DAss n C X A m Y Z"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_rprim)
apply assumption
apply (erule thin_rl, clarsimp)
apply (subgoal_tac "DAss n C X A m Y Z E h hh v p2")
apply (erule DAss_PConst)
apply (subgoal_tac "DOM C = DOM Cz")
prefer 2 apply (erule Union.elims, simp add: DOM_def, clarsimp)
apply (subgoal_tac "\<forall> x . x: DOM C \<longrightarrow> GETr Cz x = GETr C x")
prefer 2 apply (clarsimp) apply (rule UnionGet5) apply simp apply simp
apply (simp add: DAss_def, safe)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE, safe)
apply (erule regionsExist1, assumption, assumption, rule,simp)
apply (erule regionsDistinct1, assumption, assumption, rule, simp)
apply (erule distinctFrom1, assumption, assumption, rule, simp)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule distinctFrom1, clarsimp, simp, rule, simp)
apply (erule unmodified1, clarsimp, simp, rule, simp)
apply (erule Result_bounded1, assumption, rule, simp)
apply (erule FL_bounded1, clarsimp, simp, rule, simp)
apply (erule Size_restricted1, clarsimp, simp, rule, simp)
done

lemma DA_Let_HD: 
  "\<lbrakk>G \<rhd> e : DAss n Ch X A m Y Z;
    (C, ({h},emptyfinmap), Ch) : Union;
    GETr C x = Some (ListET k)
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET h = GetFi x F0 IN e END): DAss n C X A m Y Z"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
apply assumption
apply (erule thin_rl, clarsimp)
apply (subgoal_tac "DAss n C X A m Y Z E ha hh v p2")
apply (erule DAss_PConst)
apply (subgoal_tac "DOM C = DOM Ch")
prefer 2 apply (erule Union.elims, simp add: DOM_def, clarsimp)
apply (subgoal_tac "\<forall> x . x: DOM C \<longrightarrow> GETr Ch x = GETr C x")
prefer 2 apply (clarsimp) apply (rule UnionGet5) apply simp apply simp
apply (simp add: DAss_def, safe)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE, safe)
apply (erule regionsExist1, assumption, assumption, rule,simp)
apply (erule regionsDistinct1, assumption, assumption, rule, simp)
apply (erule distinctFrom1, assumption, assumption, rule, simp)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule distinctFrom1, clarsimp, simp, rule, simp)
apply (erule unmodified1, clarsimp, simp, rule, simp)
apply (erule Result_bounded1, assumption, rule, simp)
apply (erule FL_bounded1, clarsimp, simp, rule, simp)
apply (erule Size_restricted1, clarsimp, simp, rule, simp)
done

lemma DA_Let_TL: 
  "\<lbrakk>G \<rhd> e : DAss nk Ct X A m Y Z;
    (Cx, ({}, emptyfinmap(x\<mapsto>\<^sub>f k)), C) \<in> Union;
    (Cx, ({}, emptyfinmap(t\<mapsto>\<^sub>f k)), Ct) \<in> Union;
    GETr C x = Some (ListET k);
    nk = n+k; YY = Y-{t}; ZZ = (Z -{t})\<union> {x}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf t = GetFr x F1 IN e END) : DAss n C (DOM C) A m YY ZZ"
apply (clarsimp,rule vdm_conseq, rule vdm_letr, rule vdm_getfr)
apply assumption
apply (erule thin_rl, clarsimp)
apply (subgoal_tac "DAss n C (DOM C) A m (Y - {t}) (insert x (Z-{t})) E h hh v p2")
apply (erule DAss_PConst)
apply (subgoal_tac "DOM C = DOM Cx \<union> {x} \<and> x \<notin> DOM Cx")
prefer 2 apply (erule Union.elims, clarsimp)
         apply (simp add: DOM_def)
apply (subgoal_tac "DOM Ct = DOM Cx \<union> {t} \<and> t \<notin> DOM Cx")
prefer 2 apply (rotate_tac 1, erule Union.elims, clarsimp)
         apply (simp add: DOM_def)
apply (simp add: DAss_def, safe)
apply (rotate_tac -5, erule thin_rl, fast)
apply (rotate_tac -5, erule thin_rl, fast)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE) 
  apply safe
  apply (erule Union_regionsExist_CCt, assumption+)
  apply (erule Union_regionsDistinct_CCt, assumption+)
  apply (erule Union_distinctFrom_CCt, assumption+)
  
  apply clarsimp
  apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
  apply (erule Union_distinctFrom_CtC, assumption+)
  apply (erule Union_unmodified_CtC, assumption+)
  apply (erule Union_Result_bounded_CtC, assumption+)
  apply (erule Union_FL_bounded_CtC, assumption+)
  apply(erule Union_Size_restricted_CtC, assumption+)
done

subsection {*General let-rules*}
text {*Future work should aim at deriving more general rules.
       In particular taking all Y-sets to be empty is quite restrictive.
       Possibly a closer analysis may allow one to weaken (or eliminate?)
       the condition Result_bounded from the definition of the DAss predicate.
       (Idea: instantiate the Y of the judgement for "e" by "DOM D").
       Also identifying the Z-sets with the X-sets is just a temporary fix.
       *}

lemma DA_Letv:
      "\<lbrakk>G \<rhd> e : DAss n C1 X1 A n1 {} X1;
        G \<rhd> ee : DAss n1 C2 X2 B n2 {} X2;
        (C1,C2,C) : Union; 
        X = DOM C;
        X1 = DOM C1;
        X2 = DOM C2\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): DAss n C X B n2 {} X"
apply (subgoal_tac "X = X1 \<union> X2", clarsimp)
  prefer 2 apply (erule Union.elims, clarsimp) 
apply (rule vdm_conseq,erule vdm_letv, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAss_def, safe)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE) 
  apply(rotate_tac 2, erule thin_rl)
  apply safe
  apply (erule Union_regionsExist_CC1, assumption)
  apply (erule Union_regionsDistinct_CC1, simp, erule regionsDistinct_antimonotone, fast)
  apply (erule Union_distinctFrom_CC1, assumption)
  
  apply (erule_tac x=FF in allE, erule_tac x=M in allE, clarsimp)
  apply (erule impE, safe)
  apply (erule regionsExist_Letv, assumption+,simp)
  apply (erule regionsDistinct_Letv, assumption+,simp)
  apply (erule distinctFrom_Letv, assumption+,simp)

  apply clarsimp
  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (simp add: distinctFrom_def)
  apply (erule unmodified_Letv, assumption+,simp)
  apply (erule Result_bounded_Letv, assumption+,clarsimp,simp)
  apply (erule FL_bounded_Letv, assumption+, simp)
  apply (erule Size_restricted_Letv, assumption+, simp)
done

lemma DA_Leti:
      "\<lbrakk>GG \<rhd> e : DAss n G eX IntET n1 {} eX;
        GG \<rhd> ee : DAss n1 C eeX B n2 {} eeX;
        (D, ({y},emptyfinmap), C) : Union;
        (G,D,GD) : Union; 
        eeX = DOM C;
        eX = DOM G;
        X = DOM GD\<rbrakk>
     \<Longrightarrow> GG \<rhd> (LET y = e IN ee END): DAss n GD X B n2 {} X"
apply (subgoal_tac "X = eeX \<union> eX \<and> DOM D = DOM C", clarsimp)
  prefer 2 apply (erule Union.elims, clarsimp)apply (erule Union.elims, clarsimp) apply (simp add: DOM_def) apply fast
apply (rule vdm_conseq, erule vdm_leti, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAss_def, safe)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE) 
  apply(rotate_tac 4, erule thin_rl)
  apply safe
  apply (erule Union_regionsExist_CC1, assumption)
  apply (erule Union_regionsDistinct_CC1, simp, erule regionsDistinct_antimonotone, fast)
  apply (erule Union_distinctFrom_CC1, assumption)
  
  apply (erule_tac x=FF in allE, erule_tac x=M in allE, clarsimp)
  apply (erule impE, safe)
  apply (erule regionsExist_Leti,assumption+,rule,simp)
  apply (erule regionsDistinct_Leti, assumption+,rule,simp)
  apply (erule distinctFrom_Leti, assumption+,rule,simp)

  apply clarsimp
  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (simp add: distinctFrom_def)
  apply (erule unmodified_Leti, assumption+, rule, simp)
  apply (erule Result_bounded_Leti, assumption+, rule, simp)
  apply (erule FL_bounded_Leti, assumption+, rule, simp)
  apply (erule Size_restricted_Leti, assumption+, rule, simp)
done

lemma DA_Letr:
      "\<lbrakk>
        GG \<rhd> e : DAss n G eX (ListET k) n1 {} eX;
        GG \<rhd> ee : DAss n1 C eeX B n2 {} eeX;
        (D, ({},emptyfinmap(y\<mapsto>\<^sub>fk)), C) : Union;
        (G,D,GD) : Union; 
        eeX = DOM C;
        eX = DOM G;
        X = DOM GD\<rbrakk>
     \<Longrightarrow> GG \<rhd> (LET rf y = e IN ee END): DAss n GD X B n2 {} X"
apply (subgoal_tac "DOM GD = DOM G \<union> DOM D \<and> insert y (DOM D) = DOM C", clarsimp)
  prefer 2 apply (erule Union.elims, clarsimp)apply (erule Union.elims, clarsimp) apply (simp add: DOM_def) 
apply (rule vdm_conseq, erule vdm_letr, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAss_def, safe)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE) 
  apply(rotate_tac 4, erule thin_rl)
  apply safe
  apply (erule Union_regionsExist_CC1, assumption)
  apply (erule Union_regionsDistinct_CC1, simp, erule regionsDistinct_antimonotone, fast)
  apply (erule Union_distinctFrom_CC1, clarsimp)
  
  apply (erule_tac x=FF in allE, erule_tac x=M in allE, clarsimp)
  apply (erule impE, safe)
  apply (erule regionsExist_Letr,assumption+,clarsimp+,assumption)
  apply (erule regionsDistinct_Letr, assumption+, clarsimp+, assumption+)
  apply (rule distinctFrom_Letr, assumption+, clarsimp+, assumption+)

  apply clarsimp
  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (rule distinctFrom_Triv1)
  apply (erule unmodified_Letr, assumption+,clarsimp+,assumption+) 
  apply (erule Result_bounded_Letr, assumption+,clarsimp+,assumption+) 
  apply (subgoal_tac " FL_bounded FFa F (DOM GD) GD h E", clarsimp,
         erule FL_bounded_Letr,assumption+,clarsimp+,assumption+)
  apply (erule Size_restricted_Letr, assumption+,clarsimp+, assumption+)
done

subsection {*Hypothetical / experimental rules*}
text {*These rules are currently unproven and may be wrong.*}

lemma DA_Free: "GETr G x = Some (ListET k) \<Longrightarrow> GG \<rhd> (DIAM\<bullet>Free ([RNarg x])) :  DAss 0 G {x} (ListET k) 1 {} {x}"
sorry
(*apply (rule vdm_conseq)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Free)
apply (rule vdm_conseq)
apply (rule DA_Letr)
*)

(*lemma DA_Make_IID: "G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal i), INarg x, RNarg y])) :  DAss (Suc k) ([x],[(y,k)]) {y} (ListET k) 0 {} {}"
sorry 
*)
text {*needs specs for alloc and fill
apply (rule vdm_conseq)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Make_IID)
apply (rule vdm_conseq)
apply (rule DA_Letr)
*}

end
