theory DAssU = NILList:

(*variation of DAss.thy with: 
 - no integer contexts
 - no sets X,Y,Z but usage sets U which are the outcome of a ''linear type inference''
*)

lemma SubsetTriv:"\<lbrakk>x:X; X \<subseteq> Y\<rbrakk> \<Longrightarrow> x:Y" by fast

datatype Type = UnitET | IntET | ListET nat

types Context = "(rname \<leadsto>\<^sub>f Type)"

constdefs DOM:: "Context \<Rightarrow> rname set"
"DOM == fmap_dom"

(*lemma DOM_Update: "DOM b \<subseteq> DOM (b(x\<mapsto>\<^sub>fk))" by (simp add: DOM_def, fast)*)
lemma DOM_Update: "{x} \<union> (DOM b) = DOM (b(x\<mapsto>\<^sub>fk))" by (simp add: DOM_def)

constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Type option)"
"GETr G x \<equiv> fmap_lookup G x"

constdefs INSr :: "Context \<Rightarrow> rname \<Rightarrow> Type \<Rightarrow> Context"
"INSr G x T \<equiv> G(x\<mapsto>\<^sub>fT)"

lemma GETrSome_DOM:"GETr G x = Some T \<Longrightarrow> x \<in> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GETrNone_DOM:"GETr G x = None \<Longrightarrow> x \<notin> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETrSome:"x \<in> DOM G \<Longrightarrow> (\<exists> T . GETr G x = Some T)"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETrNone:"x \<notin> DOM G \<Longrightarrow> GETr G x = None"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GETr_Update1: "x \<noteq> y \<Longrightarrow> GETr (G(x\<mapsto>\<^sub>fk)) y = GETr G y"
apply (subgoal_tac "y \<noteq> x")
apply (simp add: GETr_def)
apply (insert FMAPlookup2 [of y x G], auto)
done

lemma GETr_Update1a: "x \<noteq> y \<Longrightarrow> GETr G y = GETr (G(x\<mapsto>\<^sub>fk)) y"
apply (subgoal_tac "y \<noteq> x")
apply (simp add: GETr_def)
apply (insert FMAPlookup2 [of y x G], auto)
done

lemma GETr_Update2: "\<lbrakk>GETr G xa = Some T; x \<noteq> xa\<rbrakk> \<Longrightarrow> GETr (G(x\<mapsto>\<^sub>fk)) xa = Some T"
by (subgoal_tac "GETr (G(x\<mapsto>\<^sub>fk)) xa = GETr G xa", clarsimp, erule GETr_Update1)

text {*Extensional equality of contexts*}
constdefs Equal::"Context \<Rightarrow> Context \<Rightarrow> bool"
"Equal C D == (DOM C = DOM D) \<and> (\<forall> x . x:DOM C \<longrightarrow> GETr C x = GETr D x)"
lemma Equal_reflexive: "Equal C C" by (simp add: Equal_def)
lemma Equal_symmetric: "Equal C D = Equal D C" by (simp add: Equal_def, auto)
lemma Equal_transitive: "\<lbrakk>Equal C D; Equal D E\<rbrakk> \<Longrightarrow> Equal C E" by (simp add: Equal_def)

lemma Equal_DOM: "\<lbrakk>Equal G emptyfinmap; x \<in> DOM G\<rbrakk> \<Longrightarrow> A" by (simp add: Equal_def DOM_def)

text {*Region calculation*}
consts reg :: "(val \<times> heap \<times> (Type option) \<times> (locn set) \<times> nat) set"
inductive reg intros
regList:  "\<lbrakk>(n, r, R, h) : mLIST; m = k*n\<rbrakk> \<Longrightarrow> (RVal r, h, Some(ListET k), R, m): reg"
regInt:   "(IVal i ,h,Some IntET,{}, 0): reg"
regUnit:   "(v,h,Some UnitET,{}, 0): reg"

lemma reg_DOM:"(RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, n) \<in> reg \<Longrightarrow> x:DOM G"
apply (subgoal_tac "\<exists> T . GETr G x = Some T", clarsimp) apply (erule GETrSome_DOM)
apply (case_tac "GETr G x", clarsimp) 
apply (erule reg.elims, clarsimp, clarsimp,clarsimp)
apply (rule_tac x=a in exI, assumption)
done

lemma reg_Preserved:"\<lbrakk>(v,h,T,R,S):reg; \<forall> l. l : R \<longrightarrow> sameOH {l} h h1\<rbrakk> \<Longrightarrow> (v,h1,T,R,S):reg"
apply (erule reg.elims, safe)
apply (rule regList)
  apply (subgoal_tac "(n, r, R, h1) \<in> mLIST", assumption) apply (erule mLIST_Preserved, fast)
  apply simp
apply (rule regInt)
apply (rule regUnit)
done

lemma reg_Unique[rule_format]: "(v, h, T, R, S) : reg \<Longrightarrow> (\<forall> RR SS . (v, h, T, RR, SS) : reg \<longrightarrow> (R=RR \<and> S=SS))"
apply (erule reg.induct)
apply clarsimp
apply (erule reg.elims, simp_all, clarsimp)
apply (subgoal_tac "n = na \<and> R = Ra", clarsimp)
apply (rule mLIST_Unique, assumption, assumption)
apply clarsimp
apply (erule reg.elims, simp_all)
apply clarsimp
apply (erule reg.elims, simp_all)
done

consts ContextSize::"(env \<times> heap \<times> (rname set) \<times> Context \<times> nat) set"
inductive ContextSize intros
ContextSizeNIL: "\<lbrakk>U={}; S=0 \<rbrakk> \<Longrightarrow> (E,h,U,C, S) : ContextSize"
ContextSizeCONS: "\<lbrakk>x: U;  (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, R,n): reg;
                   (E,h,U-{x},C,m):ContextSize; S = n+m\<rbrakk>
                  \<Longrightarrow> (E,h,U,C,S) : ContextSize"
(*ContextSizeNotUsed:"\<lbrakk>x:U; x \<notin> DOM C; (E,h,U-{x},C,S):ContextSize\<rbrakk> \<Longrightarrow> (E,h,U,C,S) : ContextSize"*)

lemma ContextSize_regionsExist[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> (\<forall> x . x:(U \<inter> DOM C)\<longrightarrow> (\<exists> R S . (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, R, S) \<in> reg))"
apply (erule ContextSize.induct)
apply clarsimp 
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply fast
apply (erule_tac x=xa in allE, clarsimp)
(*apply clarsimp apply fast*)
done

lemma ContextSize_contains_region[rule_format]:
"(E, h, U, G, CS) \<in> ContextSize \<Longrightarrow> (\<forall> x R S . x:U \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, S) \<in> reg \<longrightarrow> S \<le> CS)" 
apply (erule ContextSize.induct)
apply clarsimp
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply (subgoal_tac "R=Ra \<and> n=Sa",clarsimp) 
apply (erule reg_Unique, assumption)
apply ( erule_tac x=xa in allE, erule impE, clarsimp)
apply (erule_tac x=Ra in allE, erule_tac x=Sa in allE, clarsimp)
(* apply clarsimp
apply (subgoal_tac "xa \<noteq> x",fast)
apply (subgoal_tac "xa:DOM C", fast)
apply (erule reg_DOM)*)
done

lemma ContextSize_delete_nonUsed[rule_format]:
 "(E, h, U, G, CS) \<in> ContextSize \<Longrightarrow> (\<forall> x. x \<notin> DOM G \<longrightarrow> (E,h,U-{x},G,CS):ContextSize)"
apply (erule ContextSize.induct)
apply clarsimp apply (rule ContextSizeNIL,simp+)
apply clarsimp apply (erule_tac x=xa in allE,clarsimp)
  apply (subgoal_tac "x:DOM C") prefer 2 apply (erule reg_DOM)
  apply (case_tac "x=xa",clarsimp) apply (rule ContextSizeCONS) prefer 2 apply assumption apply fast
  apply (subgoal_tac "U - {xa} - {x} = U - {x} - {xa}", clarsimp, assumption) apply fast apply simp
(*apply clarsimp apply (erule_tac x=xa in allE,clarsimp)
  apply (case_tac "x=xa",clarsimp) apply (rule ContextSizeNotUsed)
  apply (subgoal_tac "x:U-{xa}", assumption, fast) apply assumption 
  apply (subgoal_tac "U - {xa} - {x} = U - {x} - {xa}", clarsimp) apply fast *)
done

lemma ContextSize_delete_Used[rule_format]:
 "(E, h, U, G, CS) \<in> ContextSize \<Longrightarrow> 
  (\<forall> x R S . x:U \<longrightarrow> (\<forall> n.(RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, n) \<in> reg \<longrightarrow>(E,h,U-{x},G,CS-n):ContextSize))"
apply (erule ContextSize.induct)
apply clarsimp
apply clarsimp 
  apply (case_tac "xa=x",clarsimp) apply (subgoal_tac "R=Ra \<and> n=na",clarsimp) apply (erule reg_Unique, assumption)
  apply (erule_tac x=xa in allE,clarsimp)
  apply (erule_tac x=Ra in allE, erule_tac x=na in allE, clarsimp) 
  apply (subgoal_tac "U - {x} - {xa} = U - {xa} - {x}", clarsimp) apply (rule ContextSizeCONS) prefer 3 apply assumption
    apply (fast, assumption) apply (subgoal_tac "na \<le> m",clarsimp) 
    apply (erule ContextSize_contains_region) prefer 2 apply (assumption, fast)
  apply fast
(*apply clarsimp apply (subgoal_tac "xa \<noteq> x") apply (erule_tac x=xa in allE,erule impE,clarsimp)
  apply (erule_tac x=R in allE, erule_tac x=n in allE, clarsimp)
  apply (rule ContextSizeNotUsed) prefer 2 apply (assumption, fast) 
  apply (subgoal_tac "U - {xa} - {x} = U - {x} - {xa}", clarsimp) apply fast 
  apply (subgoal_tac "xa : DOM C", fast, erule reg_DOM)*)
done

lemma ContextSize_split[rule_format]:
"(E, h, U, G, CS) \<in> ContextSize \<Longrightarrow> (\<forall> x R S . x:U \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, S) \<in> reg \<longrightarrow>
  (\<exists> n . (E,h,U-{x},G,n):ContextSize \<and> CS = S + n))" 
apply (erule ContextSize.induct)
apply clarsimp
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply (subgoal_tac "R=Ra \<and> n=Sa",clarsimp) 
apply (erule reg_Unique, assumption)
apply (erule_tac x=xa in allE, erule impE, clarsimp)
apply (erule_tac x=Ra in allE, erule_tac x=Sa in allE, clarsimp)
apply (rule ContextSizeCONS)
apply (subgoal_tac "x: U -{xa}", assumption,fast)
apply assumption
prefer 2 apply simp
apply (subgoal_tac "U - {x} - {xa} = U - {xa} - {x}", clarsimp)
apply fast
(*
apply clarsimp
apply (subgoal_tac "xa \<noteq> x")
prefer 2 apply (subgoal_tac "xa:DOM C", fast) apply (erule reg_DOM)
apply (erule_tac x=xa in allE, clarsimp)
apply (erule_tac x=R in allE, erule_tac x=Sa in allE, clarsimp) 
apply (subgoal_tac "U - {x} - {xa} = U - {xa} - {x}", clarsimp)
apply (rule ContextSizeNotUsed) prefer 3 apply assumption apply fast apply assumption
apply fast*)
done

lemma ContextSize_Unique[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> (\<forall> n . (E,h,U,C,n):ContextSize \<longrightarrow> S = n)"
apply (erule ContextSize.induct)
(*1*)
apply clarsimp apply (erule ContextSize.elims, clarsimp,clarsimp)
(*2*)
apply (rule, rule) 
apply (rotate_tac -1, erule ContextSize.elims)
(*2a*) apply(fast)
(*2b*) apply clarify
  apply (case_tac "x=xa", clarify)
  apply (erule_tac x=ma in allE, clarsimp)
  apply (simp add: reg_Unique)
  (*x \<noteq> xa*)
  apply (subgoal_tac "\<exists> N .(Ea,ha,Ua-{xa}-{x},Ca,N):ContextSize \<and> ma = n + N",clarify)
  prefer 2 apply (erule ContextSize_split) apply fast apply assumption
  apply (subgoal_tac "\<exists> N .(Ea,ha,Ua-{x}-{xa},Ca,N):ContextSize \<and> m = nb + N",clarify)
  prefer 2 apply (erule ContextSize_split) apply fast apply assumption
  apply (erule_tac x="nb+N" in allE, erule impE)
  prefer 2 apply clarsimp
  apply (rule ContextSizeCONS) apply (subgoal_tac "xa : Ua - {x}", assumption,fast)
  apply assumption 
  prefer 2 apply simp
  apply (subgoal_tac "Ua - {xa} - {x} = Ua - {x} - {xa}", clarsimp,fast)
done
(*lemma ContextSize_Unique[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> (\<forall> n . (E,h,U,C,n):ContextSize \<longrightarrow> S = n)"
apply (erule ContextSize.induct)
(+1+)
apply clarsimp apply (erule ContextSize.elims, clarsimp,clarsimp,clarsimp)
(+2+)
apply (rule, rule) 
apply (rotate_tac -1, erule ContextSize.elims)
(+2a+) apply(fast)
(+2b+) apply clarify
  apply (case_tac "x=xa", clarify)
  apply (erule_tac x=ma in allE, clarsimp)
  apply (simp add: reg_Unique)
  (+x \<noteq> xa+)
  apply (subgoal_tac "\<exists> N .(Ea,ha,Ua-{xa}-{x},Ca,N):ContextSize \<and> ma = n + N",clarify)
  prefer 2 apply (erule ContextSize_split) apply fast apply assumption
  apply (subgoal_tac "\<exists> N .(Ea,ha,Ua-{x}-{xa},Ca,N):ContextSize \<and> m = nb + N",clarify)
  prefer 2 apply (erule ContextSize_split) apply fast apply assumption
  apply (erule_tac x="nb+N" in allE, erule impE)
  prefer 2 apply clarsimp
  apply (rule ContextSizeCONS) apply (subgoal_tac "xa : Ua - {x}", assumption,fast)
  apply assumption 
  prefer 2 apply simp
  apply (subgoal_tac "Ua - {xa} - {x} = Ua - {x} - {xa}", clarsimp,fast)
(+2c+) apply clarify
  apply (subgoal_tac "x:DOM Ca") prefer 2 apply (erule reg_DOM)
  apply (subgoal_tac "x \<noteq> xa") prefer 2 apply fast
  apply (subgoal_tac "(Ea, ha, Ua, Ca, Sa) \<in> ContextSize")
  prefer 2 apply (rule ContextSizeNotUsed) prefer 2 apply assumption+
  apply (subgoal_tac "(Ea, ha, Ua - {x}, Ca, Sa - n) \<in> ContextSize")
  prefer 2 apply (erule ContextSize_delete_Used) apply assumption+
  apply (erule_tac x="Sa - n" in allE, clarsimp)
  apply (subgoal_tac "n \<le> Sa", clarsimp) apply (erule ContextSize_contains_region) prefer 2 apply (assumption,fast)
(+3+)
apply (rule, rule) 
apply (rotate_tac -1, erule ContextSize.elims)
(+3a+) apply(fast)
(+3b+)  apply clarify
  apply (subgoal_tac "xa:DOM Ca") prefer 2 apply (erule reg_DOM)
  apply (subgoal_tac "xa \<noteq> x") prefer 2 apply fast
  apply (subgoal_tac "(Ea, ha, Ua, Ca, na+m) \<in> ContextSize")
  prefer 2 apply (rule ContextSizeCONS) prefer 2 apply assumption+ apply simp
  apply (subgoal_tac "(Ea, ha, Ua - {x}, Ca, na + m) \<in> ContextSize",fast)
  apply (erule ContextSize_delete_nonUsed,assumption) 
(+3c+)
apply clarify
  apply (case_tac "x=xa", clarify)
  apply (erule_tac x=Sa in allE, clarsimp)
  (+x \<noteq> xa+)
  apply (subgoal_tac "(Ea,ha,Ua,Ca,Sa):ContextSize")
  prefer 2 apply (rule ContextSizeNotUsed) prefer 3 apply assumption+
  apply (subgoal_tac "(Ea,ha,Ua-{x},Ca,Sa):ContextSize", fast)
  apply (erule ContextSize_delete_nonUsed, assumption)
done
*)

lemma SizePreserved_h_h1[rule_format]:
"(E, h, U, C, CS) \<in> ContextSize \<Longrightarrow> 
   (\<forall> h1 . (\<forall> x R n . x : U \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>),h, GETr C x, R, n) : reg \<longrightarrow> (\<forall> l . l : R \<longrightarrow> sameOH {l} h h1))
          \<longrightarrow> (E, h1, U, C, CS) \<in> ContextSize)"
apply (erule ContextSize.induct)
apply clarsimp apply (rule ContextSizeNIL, simp, simp)
apply clarsimp
apply (rule ContextSizeCONS) 
apply (assumption)
apply (rule reg_Preserved, assumption) apply (erule_tac x=x in allE,clarsimp) 
  apply (erule_tac x=R in allE,erule impE,fast)
  apply fast
apply fast
apply simp
(*
apply clarsimp
apply (rule ContextSizeNotUsed) 
apply (assumption)
apply assumption
apply fast*)
done

lemma ContextSize_SPLIT[rule_format]: 
"(E, h, U, C, CS) \<in> ContextSize \<Longrightarrow> (\<forall> U1 U2 . U1 \<union> U2 = U \<longrightarrow> U1 \<inter> U2 = {} \<longrightarrow>
 (\<exists> n1 n2 . (E, h, U1, C, n1) \<in> ContextSize \<and> (E, h, U2, C, n2) \<in> ContextSize \<and> n1 + n2 = CS))"
apply (erule ContextSize.induct, simp_all)
apply (rule ContextSizeNIL, simp,simp)
(*Case CONS*)
apply clarsimp apply (erule disjE)
(* x:U1*)
  apply (erule_tac x="U1-{x}" in allE, erule_tac x=U2 in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x="n+n1" in exI, clarsimp)
  apply (erule ContextSizeCONS,assumption+, simp)
(* x:U2*)
  apply (erule_tac x=U1 in allE, erule_tac x="U2-{x}" in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x=n1 in exI, clarsimp)
  apply (erule ContextSizeCONS,assumption+, simp)
(*Case NotUsed+)
apply clarsimp apply (erule disjE)
(+ x:U1+)
  apply (erule_tac x="U1-{x}" in allE, erule_tac x=U2 in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x=n1 in exI, clarsimp)
  apply (erule ContextSizeNotUsed,assumption+)
(+ x:U2+)
  apply (erule_tac x=U1 in allE, erule_tac x="U2-{x}" in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x=n1 in exI, clarsimp)
  apply (erule ContextSizeNotUsed,assumption+)*)
done

lemma ContextSizePreserved[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> ((\<forall> x . x : U \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>) \<longrightarrow> (EE,h,U,C,S):ContextSize)"
apply (erule ContextSize.induct)
(*NIL*)
apply clarsimp
apply (rule ContextSizeNIL) apply (simp, simp)
(*CONS*)
apply clarsimp
apply (subgoal_tac "x:DOM C")
prefer 2 apply (erule reg_DOM)
apply (erule ContextSizeCONS)
apply (assumption+,simp)
(*NotUsed
apply clarsimp
apply (erule ContextSizeNotUsed,assumption+)*)
done

lemma ContextSizePreservedU[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> ((\<forall> x . x : U \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>) \<longrightarrow> 
                              (\<forall> D . (\<forall> x . x : U \<longrightarrow> (\<forall> T . GETr C x = Some T \<longrightarrow> GETr D x = Some T)) \<longrightarrow>
                                     (EE,h,U,D,S):ContextSize))"
apply (erule ContextSize.induct)
(*NIL*)
apply clarsimp
apply (rule ContextSizeNIL) apply (simp, simp)
(*CONS*)
apply clarsimp
apply (subgoal_tac "x:DOM C")
prefer 2 apply (erule reg_DOM) 
apply (erule_tac x=x in allE,clarsimp)
apply (subgoal_tac "GETr C x = GETr D x")
prefer 2 apply (subgoal_tac "\<exists> T . GETr C x = Some T") apply (erule_tac x=x in allE,clarsimp) 
         apply (erule DOM_GETrSome)
apply (erule ContextSizeCONS) 
apply (simp) 
apply (erule_tac x=D in allE) apply (clarsimp, assumption)
apply simp
done
(*
lemma ContextSizePreservedU[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> ((\<forall> x . x : U \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>) \<longrightarrow> 
                              (\<forall> D . DOM C \<subseteq> DOM D \<longrightarrow> 
                                     (\<forall> x . x : U\<longrightarrow> GETr C x = GETr D x) \<longrightarrow>
                                     (EE,h,U,D,S):ContextSize))"
apply (erule ContextSize.induct)
(+NIL+)
apply clarsimp
apply (rule ContextSizeNIL) apply (simp, simp)
(+CONS+)
apply clarsimp
apply (subgoal_tac "x:DOM C")
prefer 2 apply (erule_tac x=x in allE)+ apply clarsimp 
  apply (subgoal_tac "x:DOM D") 
  apply (subgoal_tac "\<exists> T . GETr D x = Some T", clarsimp) 
  apply (subgoal_tac "\<exists> T . GETr C x = Some T", clarsimp) apply(erule GETrSome_DOM) apply fast 
  apply (simp add: DOM_GETrSome) apply (erule reg_DOM) 
apply (subgoal_tac "renv E x = renv EE x")
prefer 2 apply (erule_tac x=x in allE,clarsimp)
apply (subgoal_tac "GETr C x = GETr D x")
prefer 2 apply (rotate_tac -3, erule_tac x=x in allE,clarsimp) 
apply (erule ContextSizeCONS) 
apply (assumption) 
apply (erule_tac x=D in allE) apply (clarsimp,assumption)
apply simp
(+NotUsed+)
apply clarsimp
apply (erule_tac x=D in allE, clarsimp)
apply (rule ContextSizeNotUsed,assumption) apply (erule_tac x=x in allE)+ apply clarsimp
  apply (subgoal_tac "\<exists> T . GETr C x = Some T",clarsimp)
  apply (subgoal_tac "x : DOM C",fast) apply (erule GETrSome_DOM)
  apply (subgoal_tac "\<exists> T . GETr D x = Some T",clarsimp) apply (erule DOM_GETrSome)
apply assumption
done*)

lemma ContextSizePreservedEqual[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> ((\<forall> x . x : DOM C \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>) 
                                          \<longrightarrow> (\<forall> D . (Equal D C \<longrightarrow> (EE,h,U,D,S):ContextSize)))"
apply (erule ContextSize.induct)
(*NIL*)
apply clarsimp
apply (rule ContextSizeNIL) apply (simp, simp)
(*CONS*)
apply clarsimp
apply (subgoal_tac "x:DOM C")
prefer 2 apply (erule reg_DOM)
apply (erule ContextSizeCONS)
apply (erule_tac x=x in allE, clarsimp)
apply (erule_tac x=C in allE, erule impE, simp add: Equal_reflexive)
apply (simp add: Equal_def, clarsimp)
apply (erule_tac x=D in allE, clarsimp)
apply assumption
apply simp
(*NotUsed
apply clarsimp
apply (erule_tac x=D in allE, clarsimp)
apply (erule ContextSizeNotUsed, simp add: Equal_def,assumption)*)
done

constdefs freelist::"heap \<Rightarrow> locn set \<Rightarrow> nat \<Rightarrow> bool"
"freelist h F N == (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) : FL"

constdefs regionsExist::"(rname set) \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"regionsExist U G h E == (\<forall> x. (x:(DOM G) \<inter> U) \<longrightarrow> (\<exists> Rx Sx . (RVal (E\<lfloor>x\<rfloor>),h,GETr G x,Rx,Sx): reg))"

constdefs regionsDistinct::"rname set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"regionsDistinct X G h E == 
  (\<forall> x xx Rx Rxx Sx Sxx. (x : (X \<inter> DOM G) \<and> xx : (X \<inter> DOM G) \<and> x \<noteq> xx \<and> (RVal (E\<lfloor>x\<rfloor>),h,GETr G x,Rx,Sx): reg \<and> 
                           (RVal (E\<lfloor>xx\<rfloor>),h,GETr G xx,Rxx,Sxx): reg) \<longrightarrow>
                          Rx \<inter> Rxx = {})"

constdefs distinctFrom::"rname set \<Rightarrow> Context => heap \<Rightarrow> env \<Rightarrow> locn set \<Rightarrow> bool"
"distinctFrom X G h E F == (\<forall> x . x:(X \<inter> DOM G) \<longrightarrow> (\<forall> Rx Sx. (RVal (E\<lfloor>x\<rfloor>), h, GETr G x,Rx,Sx):reg \<longrightarrow>  Rx \<inter> F = {}))"

constdefs modified::"locn set \<Rightarrow> rname set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool"
"modified F Z G h E hh == (\<forall> l . (l \<notin> F \<and> (\<forall> z Rz Sz. (z : (Z \<inter> DOM G) \<and> (RVal (E\<lfloor>z\<rfloor>), h, GETr G z, Rz, Sz):reg) \<longrightarrow> l \<notin> Rz))
                             \<longrightarrow> sameOH {l} h hh)"

constdefs Size_restricted::"nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> rname set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"Size_restricted n N nn S M U G h E == (\<forall> q CS. (E,h,U,G,CS):ContextSize \<longrightarrow> n + CS + q \<le> N \<longrightarrow> nn + S + q \<le> M)"

constdefs Bounded::"locn set \<Rightarrow> locn set \<Rightarrow> rname set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"Bounded L F U G h E == (\<forall> l. l:L \<longrightarrow> l:F \<or> (\<exists> x Rx Sx. x:(U \<inter> (DOM G)) \<and> (RVal (E\<lfloor>x\<rfloor>), h, GETr G x, Rx, Sx):reg \<and> l:Rx))"

constdefs DAss::"(rname set) \<Rightarrow> nat \<Rightarrow> Context \<Rightarrow>  Type \<Rightarrow> nat \<Rightarrow> vdmassn" ("\<lbrace> _ , _ , _ \<ggreater>  _ , _ \<rbrace>" 1000)
"DAss U n G T nn E h hh v p \<equiv>
  (\<forall> F N. 
    (freelist h F N \<and> (regionsExist U G h E) \<and> (regionsDistinct U G h E) \<and> (distinctFrom U G h E F)) \<longrightarrow>
    (\<exists> R S M FF. (freelist hh FF M) \<and> 
                 (v,hh,Some T,R,S) : reg \<and>
                 (modified F U G h E hh) \<and>
                 (R \<inter> FF = {}) \<and>  
                 (Bounded R F U G h E) \<and>
                 (Bounded FF F U G h E) \<and> 
                 (Size_restricted n N nn S M U G h E) \<and>
                 oheap h = oheap hh))"

lemma regionsExist_Lookup: "\<lbrakk>regionsExist U G h E; x:U; GETr G x = Some T\<rbrakk> \<Longrightarrow> (\<exists> R S . (RVal (E\<lfloor>x\<rfloor>),h,Some T,R,S):reg)"
by (simp add: regionsExist_def, erule_tac x=x in allE, insert GETrSome_DOM, auto)

lemma regionsExist_antimonotone:"\<lbrakk>regionsExist XX G h E; X \<subseteq> XX\<rbrakk> \<Longrightarrow> regionsExist X G h E"
by (simp add: regionsExist_def, fast)

lemma regionsDistinct_antimonotone:"\<lbrakk>regionsDistinct XX G h E; X \<subseteq> XX\<rbrakk> \<Longrightarrow> regionsDistinct X G h E"
by (simp add: regionsDistinct_def, fast)

lemma distinctFrom_antimonotone:"\<lbrakk>distinctFrom XX G h E R; X \<subseteq> XX\<rbrakk> \<Longrightarrow> distinctFrom X G h E R"
by (simp add: distinctFrom_def, fast)

lemma modified_monotone:"\<lbrakk>modified F Z G h E hh; Z \<subseteq> ZZ\<rbrakk> \<Longrightarrow> modified F ZZ G h E hh"
by (simp add: modified_def, fast)

lemma Bounded_monotone:
"\<lbrakk>Bounded L F U G h E; LL \<subseteq> L; F \<subseteq> FF; U \<subseteq> UU\<rbrakk> \<Longrightarrow> Bounded LL FF UU G h E"
by (simp add: Bounded_def, fast)

lemma ContextSize_monotone_in_U[rule_format]:
"(E, h, U, D, NN) \<in> ContextSize \<Longrightarrow>
       (\<forall> UU N . (E, h, UU, D, N) \<in> ContextSize \<longrightarrow> U \<subseteq> UU \<longrightarrow>  NN \<le> N)"
apply (erule ContextSize.induct)
apply clarsimp 
apply clarsimp
apply (subgoal_tac "\<exists> M . (E,h,UU-{x},C,M):ContextSize \<and> N = n + M")
prefer 2 apply (erule ContextSize_split) apply fast apply assumption
apply clarsimp
apply (erule_tac x="UU-{x}" in allE, erule_tac x=M in allE, erule impE,clarsimp)
apply fast
(*case non-used
apply clarsimp
apply (subgoal_tac "(E,h,UU-{x},C,N):ContextSize")
apply (erule_tac x="UU-{x}" in allE, erule_tac x=N in allE, fast)
apply (erule ContextSize_delete_nonUsed, assumption)*)
done

lemma ContextSize_existsAux[rule_format]: 
"\<forall> U . ((U,N) : cardR \<longrightarrow> (\<forall> E h C UU. UU \<subseteq> U \<longrightarrow> U \<subseteq> DOM C \<longrightarrow> 
                      regionsExist U C h E \<longrightarrow> (\<exists> S . (E,h,UU,C,S):ContextSize)))"
apply (induct N) 
apply clarsimp apply (rule_tac x=0 in exI, rule ContextSizeNIL) 
  apply (erule cardR.elims, simp,simp, simp)
apply clarsimp
apply (erule cardR.elims,clarsimp,clarsimp)
apply (erule_tac x=A in allE, clarsimp)
apply (erule_tac x= E in allE, erule_tac x=h in allE, erule_tac x=C in allE)
apply (case_tac "a:UU")
apply (erule_tac x="UU-{a}" in allE, erule impE)
apply fast
apply (erule impE, clarsimp)
apply (erule impE)
apply (erule regionsExist_antimonotone,fast)
apply clarsimp 
apply (simp add: regionsExist_def) apply (erule_tac x=a in allE, clarsimp)
apply (rule_tac x="Sx+S" in exI, rule ContextSizeCONS)
prefer 2 apply assumption+ apply simp
apply (erule_tac x="UU" in allE, erule impE)
apply fast
apply (erule impE,clarsimp)
apply (erule impE)
apply (erule regionsExist_antimonotone,fast)
apply clarsimp 
done

lemma ContextSize_exists[rule_format]: 
"\<lbrakk>UU \<subseteq> U; U \<subseteq> DOM C; regionsExist U C h E\<rbrakk> \<Longrightarrow> (\<exists> S . (E,h,UU,C,S):ContextSize)"
apply (subgoal_tac "\<exists> n . (U,n):cardR", clarsimp)
apply (erule ContextSize_existsAux,assumption+)
apply (simp add: finite_dom_fmap DOM_def finite_imp_cardR finite_subset)
done

lemma Size_restricted_monotone: 
"\<lbrakk>Size_restricted m N n S M U C h E; U \<subseteq> UU; regionsExist UU C h E; m \<le> mm; nn \<le> n\<rbrakk> 
 \<Longrightarrow> Size_restricted mm N nn S M UU C h E"
apply (simp add: Size_restricted_def,clarsimp)
apply (subgoal_tac "\<exists> n1 n2 . (E, h, U, C, n1) \<in> ContextSize \<and> (E, h, UU-U, C, n2) \<in> ContextSize \<and> n1 + n2 = CS",clarsimp)
apply (erule_tac x=q in allE, erule_tac x=n1 in allE, clarsimp)
apply (erule ContextSize_SPLIT,fast,fast)
done

lemma distinctFrom_Triv1: "distinctFrom {} G h E F" by (simp add: distinctFrom_def)

lemma distinctFrom_Triv2: "distinctFrom X G h E {}" by (simp add: distinctFrom_def)

lemma modified_Sameheap: "modified F Z G h E h" by (simp add: modified_def sameOH_def)

lemma Bounded_SameF: "Bounded F F U G h E" by (simp add: Bounded_def)

lemma Size_restricted_Const: "Size_restricted n N n 0 N U G h E" by (simp add: Size_restricted_def)

lemma Bounded_Empty: "Bounded {} F U G h E" by (simp add: Bounded_def)

lemma distinctFrom_Lookup:"\<lbrakk>distinctFrom U G h E F; (RVal (renv E x), h, GETr G x, R, S) \<in> reg; x:U;
                            xa \<in> R; xa \<in> F\<rbrakk> \<Longrightarrow> A"
apply (simp add: distinctFrom_def)
apply (erule_tac x=x in allE, erule impE)
apply (erule reg.elims, safe) apply (erule GETrSome_DOM)
apply auto
done

lemma Bounded_lookup:
"\<lbrakk>regionsExist U G h E; x:U; (RVal (renv E x), h, GETr G x, R, S) \<in> reg\<rbrakk> \<Longrightarrow> Bounded R F U G h E"
apply (simp add: Bounded_def)
apply (rule, rule)
apply (subgoal_tac "\<exists>x. x: U \<and> x \<in> DOM G \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr G x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",clarsimp)
apply (rule_tac x=x in exI, safe)
apply (erule reg_DOM)
apply fast
done

lemma GetNONE1: "x \<notin> DOM C \<Longrightarrow> None = GETr C x"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GetNONE2: "GETr C x = None \<Longrightarrow> x \<notin> DOM C"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma Equal_GETr: "Equal C D \<Longrightarrow> GETr C x = GETr D x"
apply (simp add: Equal_def)
apply (case_tac "x:DOM C", fast)
apply (subgoal_tac "GETr C x = None")
apply (subgoal_tac "GETr D x = None", clarsimp)
apply (rule DOM_GETrNone, clarsimp)
apply (erule DOM_GETrNone)
done

lemma ContextSize_IcontextIenv_irrelevant[rule_format]:
"(E, h, U, C, m) \<in> ContextSize \<Longrightarrow> (\<forall> D . Equal C D \<longrightarrow> (\<forall> EE . renv E = renv EE \<longrightarrow> (EE, h, U, D, m) \<in> ContextSize))"
apply (erule ContextSize.induct)
(*1*) apply clarsimp apply (rule ContextSizeNIL)
  apply (simp, simp)
(*2*) apply clarsimp
  apply (erule_tac x=D in allE, clarsimp)
  apply (erule_tac x=EE in allE, clarsimp)
  apply (subgoal_tac "GETr C x = GETr D x", clarsimp)
  apply (erule ContextSizeCONS, assumption, assumption, simp)
  apply (simp add: Equal_def, clarsimp)
  apply (erule_tac x=x in allE, erule impE)
  apply (subgoal_tac "x: DOM C", clarsimp, erule reg_DOM)
  apply simp
(*3 apply clarsimp
  apply (erule_tac x=D in allE, clarsimp)
  apply (erule_tac x=EE in allE, clarsimp)
  apply (erule ContextSizeNotUsed, simp add: Equal_def,assumption)*)
done

lemma regionsExist1:
"\<lbrakk>regionsExist U C h E; \<forall>x. x \<in> U \<inter> (DOM D) \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> regionsExist U D h EE"
by (simp add: regionsExist_def)

lemma regionsDistinct1:
"\<lbrakk>regionsDistinct X C h E; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> regionsDistinct X D h EE"
apply (simp add: regionsDistinct_def, clarsimp)
apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, safe)
apply auto
done

lemma distinctFrom1:
"\<lbrakk>distinctFrom X C h E R; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> distinctFrom X D h EE R"
apply (simp add: distinctFrom_def)
done

lemma modified1:
"\<lbrakk>modified F Z C h E hh; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> modified F Z D h EE hh"
apply (simp add: modified_def, clarsimp)
apply (erule_tac x=l in allE, erule impE, safe)
apply (erule_tac x=z in allE, erule impE)
apply (subgoal_tac "z:DOM C", clarsimp, erule reg_DOM)
apply (erule_tac x=z in allE, erule_tac x=Rz in allE, auto)
done

lemma Bounded1:
"\<lbrakk>Bounded R F U D h EE; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; renv E = renv EE\<rbrakk> \<Longrightarrow> Bounded R F U C h E"
apply (simp add: Bounded_def, rule, rule)
apply (erule_tac x=l in allE, erule impE, simp)
apply (erule disjE, simp)
apply (subgoal_tac "\<exists>x. x: U  \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv EE x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",simp)
apply clarsimp
apply (erule_tac x=x in allE, clarsimp)
apply (rule_tac x=x in exI, safe)
apply (erule reg_DOM)
apply fast
done

lemma Size_restricted1:
"\<lbrakk>Size_restricted n N m S M U C h E; \<forall>x. x \<in> (DOM D) \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> 
 Size_restricted n N m S M U D h EE"
apply (simp add: Size_restricted_def, clarsimp)
apply (subgoal_tac "(E, h, U, C, CS) \<in> ContextSize")
prefer 2 apply (erule ContextSize_IcontextIenv_irrelevant)
  apply (simp add: Equal_def)
apply simp
apply fast
done

lemma reg_F1: "\<lbrakk>(RVal (Ref a),h, Some(ListET k),R,n):reg\<rbrakk> \<Longrightarrow> (RVal (h\<lfloor>a\<diamondsuit>F1\<rfloor>),h,Some(ListET k), R-{a},n-k):reg"
apply (erule reg.elims, simp_all, clarsimp)
apply (erule mLIST.elims, simp_all, clarsimp)
apply (erule regList, simp)
done
end
