theory DAss = NILList:

lemma SubsetTriv:"\<lbrakk>x:X; X \<subseteq> Y\<rbrakk> \<Longrightarrow> x:Y" by fast

datatype Type = IntET | ListET nat

types Context = "(iname set) \<times> (rname \<leadsto>\<^sub>f nat)"

constdefs DOM:: "Context \<Rightarrow> rname set"
"DOM G == fmap_dom (snd G)"

lemma DOM_Update: "DOM (a, b) \<subseteq> DOM (a, b(x\<mapsto>\<^sub>fk))" by (simp add: DOM_def, fast)

constdefs GETi :: "Context \<Rightarrow> iname \<Rightarrow> (Type option)"
"GETi G x \<equiv> (if x : (fst G) then (Some IntET) else None)"

constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Type option)"
"GETr G x \<equiv> (case (fmap_lookup (snd G) x) of None \<Rightarrow> None | (Some i) \<Rightarrow> Some (ListET i))"

constdefs INSi :: "Context \<Rightarrow> iname \<Rightarrow> Context"
"INSi G x \<equiv> (insert x (fst G), snd G)"

constdefs INSr :: "Context \<Rightarrow> rname \<Rightarrow> nat \<Rightarrow> Context"
"INSr G x k \<equiv> (fst G, (snd G)(x\<mapsto>\<^sub>fk))"

lemma GETrSome_DOM:"GETr G x = Some T \<Longrightarrow> x \<in> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def, split option.split_asm, auto)

lemma GETrNone_DOM:"GETr G x = None \<Longrightarrow> x \<notin> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def, split option.split_asm, auto)

lemma DOM_GETrSome:"x \<in> DOM G \<Longrightarrow> (\<exists> T . GETr G x = Some T)"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def, auto)

lemma DOM_GETrNone:"x \<notin> DOM (a, b) \<Longrightarrow> GETr (a, b) x = None"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GETr_Update1: "x \<noteq> y \<Longrightarrow> GETr (X, b(x\<mapsto>\<^sub>fk)) y = GETr (Y, b) y"
apply (subgoal_tac "y \<noteq> x")
apply (simp add: GETr_def)
apply (split option.split, auto)
apply (split option.split, auto)
apply (insert FMAPlookup2 [of y x b], auto)
done

lemma GETr_Update2: "\<lbrakk>GETr (a,b) xa = Some T; x \<noteq> xa\<rbrakk> \<Longrightarrow> GETr (a,b(x\<mapsto>\<^sub>fk)) xa = Some T"
by (subgoal_tac "GETr (a,b(x\<mapsto>\<^sub>fk)) xa = GETr (a,b) xa", clarsimp, erule GETr_Update1)

text {*Extensional equality of contexts*}
constdefs EqualR::"Context \<Rightarrow> Context \<Rightarrow> bool"
"EqualR C D == (DOM C = DOM D) \<and> (\<forall> x . x:DOM C \<longrightarrow> GETr C x = GETr D x)"
lemma EqualR_reflexive: "EqualR C C" by (simp add: EqualR_def)
lemma EqualR_symmetric: "EqualR C D = EqualR D C" by (simp add: EqualR_def, auto)
lemma EqualR_transitive: "\<lbrakk>EqualR C D; EqualR D E\<rbrakk> \<Longrightarrow> EqualR C E" by (simp add: EqualR_def)
lemma EqualR_Triv: "EqualR (a, b) (X, Z) \<Longrightarrow> EqualR (aa, b) (Y, Z)" by (simp add: EqualR_def DOM_def GETr_def)

lemma EqualR_DOM: "\<lbrakk>EqualR (a, b) (X, emptyfinmap); x \<in> DOM (a, b)\<rbrakk> \<Longrightarrow> A" by (simp add: EqualR_def DOM_def)

constdefs Equal::"Context \<Rightarrow> Context \<Rightarrow> bool"
"Equal C D == (fst C = fst D) \<and> EqualR C D"
lemma Equal_reflexive: "Equal C C" by (simp add: Equal_def EqualR_reflexive)
lemma Equal_symmetric: "Equal C D = Equal D C" by (simp add: Equal_def EqualR_symmetric, auto)
lemma Equal_transitive: "\<lbrakk>Equal C D; Equal D E\<rbrakk> \<Longrightarrow> Equal C E" by (simp add: Equal_def, clarsimp, erule EqualR_transitive, assumption)

text {*Region calculation*}
consts reg :: "(val \<times> heap \<times> (Type option) \<times> (locn set) \<times> nat) set"
inductive reg intros
(*regNone:  "(v,h,None,{},0):reg" -- I now think that values for wehich we don't know a type should have no size at all. This simplifies 
                                     the definition of distrinctFrom - predicate*)
regList:  "\<lbrakk>(n, r, R, h) : mLIST; m = k*n\<rbrakk> \<Longrightarrow> (RVal r, h, Some(ListET k), R, m): reg"
regInt:   "(IVal i ,h,Some IntET,{}, 0): reg"

lemma reg_DOM:"(RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, n) \<in> reg \<Longrightarrow> x:DOM G"
apply (subgoal_tac "\<exists> T . GETr G x = Some T", clarsimp) apply (erule GETrSome_DOM)
apply (case_tac "GETr G x", clarsimp) 
apply (erule reg.elims, clarsimp, clarsimp)
apply (rule_tac x=a in exI, assumption)
done

lemma reg_Preserved:"\<lbrakk>(v,h,T,R,S):reg; \<forall> l. l : R \<longrightarrow> sameOH {l} h h1\<rbrakk> \<Longrightarrow> (v,h1,T,R,S):reg"
apply (erule reg.elims, safe)
apply (rule regList)
  apply (subgoal_tac "(n, r, R, h1) \<in> mLIST", assumption) apply (erule mLIST_Preserved, fast)
  apply simp
apply (rule regInt)
done

lemma reg_Unique[rule_format]: "(v, h, T, R, S) : reg \<Longrightarrow> (\<forall> RR SS . (v, h, T, RR, SS) : reg \<longrightarrow> (R=RR \<and> S=SS))"
apply (erule reg.induct)
apply clarsimp
apply (erule reg.elims, simp_all, clarsimp)
apply (subgoal_tac "n = na \<and> R = Ra", clarsimp)
apply (rule mLIST_Unique, assumption, assumption)
apply clarsimp
apply (erule reg.elims, simp_all)
done

text {*Union of disjoint contexts*}
consts Union::"(Context \<times> Context \<times> Context) set"
inductive Union intros
UNION : 
"\<lbrakk>(fst C) \<inter> (fst D) = {};
  fst E = (fst C) \<union> (fst D);
  (DOM C) \<inter> (DOM D) = {}; 
  DOM E = DOM C \<union> DOM D;
  \<forall> x . x:DOM C \<longrightarrow> GETr C x = GETr E x; 
  \<forall> x . x:DOM D \<longrightarrow> GETr D x = GETr E x\<rbrakk>
\<Longrightarrow> (C,D,E): Union"

lemma EqualUnion: "\<lbrakk>Equal C (A, B(x\<mapsto>\<^sub>fk)); x \<notin> fmap_dom B\<rbrakk> \<Longrightarrow> ((A,B),({},emptyfinmap(x\<mapsto>\<^sub>fk)),C) : Union"
apply (simp add: Equal_def EqualR_def, clarsimp)
apply (rule UNION)
apply (simp_all add: DOM_def)
apply clarsimp
apply (subgoal_tac "x \<noteq> xa")
apply (erule_tac x=xa in allE, clarsimp, subgoal_tac "GETr (fst C, B(x\<mapsto>\<^sub>fk)) xa = GETr (fst C, B) xa", clarsimp, erule GETr_Update1)
apply fast
apply (simp add: GETr_def)
done

consts ContextSize::"(env \<times> heap \<times> Context \<times> nat) set"
inductive ContextSize intros
ContextSizeNIL: "\<lbrakk>Equal C (X,emptyfinmap); S=0 \<rbrakk> \<Longrightarrow> (E,h,C, S) : ContextSize"
ContextSizeCONS: "\<lbrakk>(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, R,n): reg;
                   (E,h,D,m):ContextSize; 
                   x \<notin> DOM D; Equal C (fst D, (snd D)(x\<mapsto>\<^sub>fk)); S = n+m\<rbrakk>
                  \<Longrightarrow> (E,h,C,S) : ContextSize"

lemma ContextSizePreservedEqual[rule_format]:
"(E,h,C,S):ContextSize \<Longrightarrow> ((\<forall> x . x : DOM C \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>) 
                                          \<longrightarrow> (\<forall> D . (Equal D C \<longrightarrow> (EE,h,D,S):ContextSize)))"
apply (erule ContextSize.induct)
(*NIL*)
apply clarsimp
apply (rule ContextSizeNIL) apply (erule Equal_transitive, assumption) apply simp
(*CONS*)
apply clarsimp
apply (subgoal_tac "x:DOM (a,b)") 
prefer 2 apply (erule reg_DOM)
apply (subgoal_tac "E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>", clarsimp)
prefer 2 apply (erule_tac x=x in allE, clarsimp)
apply (rule ContextSizeCONS)
prefer 3 apply assumption
apply (subgoal_tac "GETr (a, b) x = GETr (ab, bb) x",clarsimp,assumption)
apply (subgoal_tac "Equal (a,b) (ab,bb)", simp add: Equal_def EqualR_def) apply (simp add: Equal_symmetric)
apply (erule impE) apply clarsimp
  apply (erule_tac x=xa in allE, erule impE)
  apply (simp add: Equal_def EqualR_def DOM_def)
  apply assumption
apply (erule_tac x=aa in allE, erule_tac x=ba in allE) apply (erule impE, rule Equal_reflexive) apply assumption
apply simp
apply (erule Equal_transitive,assumption)
apply simp
done

lemma ContextSize_contains_region[rule_format]:
"(E, h, G, CS) \<in> ContextSize \<Longrightarrow> (\<forall> x R S . x:DOM G \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, S) \<in> reg \<longrightarrow> S \<le> CS)" 
apply (erule ContextSize.induct)
apply safe
apply(simp add: Equal_def, clarsimp)
apply (erule EqualR_DOM, assumption)
apply (erule reg.elims, safe)
apply (case_tac "x=xa", clarsimp)
apply (erule reg.elims, safe)
apply (subgoal_tac "n=na \<and> R=Rb", clarsimp) apply (erule mLIST_Unique, assumption) 
apply (erule_tac x=xa in allE, erule_tac x=Ra in allE, erule_tac x=Sa in allE, erule impE)
prefer 2 apply (subgoal_tac "GETr (a,b) xa = GETr (aa, ba) xa", clarsimp) 
  apply (simp add: Equal_def EqualR_def)
apply clarsimp
apply (erule GETr_Update1)
apply (simp add: Equal_def EqualR_def DOM_def, fast)
done

constdefs freelist::"heap \<Rightarrow> locn set \<Rightarrow> nat \<Rightarrow> bool"
"freelist h F N == (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) : FL"

constdefs regionsExist::"Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"regionsExist G h E == (\<forall> x. (x:DOM G) \<longrightarrow> (\<exists> Rx Sx . (RVal (E\<lfloor>x\<rfloor>),h,GETr G x,Rx,Sx): reg))"

constdefs regionsDistinct::"rname set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"regionsDistinct X G h E == 
  (\<forall> x xx Rx Rxx Sx Sxx. (x : X \<and> xx : X \<and> x \<noteq> xx \<and> (RVal (E\<lfloor>x\<rfloor>),h,GETr G x,Rx,Sx): reg \<and> 
                           (RVal (E\<lfloor>xx\<rfloor>),h,GETr G xx,Rxx,Sxx): reg) \<longrightarrow>
                          Rx \<inter> Rxx = {})"
constdefs distinctFrom::"rname set \<Rightarrow> Context => heap \<Rightarrow> env \<Rightarrow> locn set \<Rightarrow> bool"
"distinctFrom X G h E F == (\<forall> x . x:X \<longrightarrow> (\<forall> Rx Sx. (RVal (E\<lfloor>x\<rfloor>), h, GETr G x,Rx,Sx):reg \<longrightarrow>  Rx \<inter> F = {}))"

constdefs unmodified::"locn set \<Rightarrow> rname set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool"
"unmodified F Z G h E hh == (\<forall> l . (l \<notin> F \<and> (\<forall> z Rz Sz. (z : Z \<and> (RVal (E\<lfloor>z\<rfloor>), h, GETr G z, Rz, Sz):reg) \<longrightarrow> l \<notin> Rz))
                             \<longrightarrow> sameOH {l} h hh)"

constdefs FL_bounded::"locn set \<Rightarrow> locn set \<Rightarrow> rname set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"FL_bounded FF F Z G h E == (FF \<subseteq> F \<union> {l . \<exists> z Rz Sz.  z:Z \<and> (RVal (E\<lfloor>z\<rfloor>), h, GETr G z, Rz, Sz):reg \<and> l:Rz})"

constdefs Size_restricted::"nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"Size_restricted n N nn S M G h E == (\<forall> q CS. (E,h,G,CS):ContextSize \<longrightarrow> n + CS + q \<le> N \<longrightarrow> nn + S + q \<le> M)"

constdefs Result_bounded::"locn set \<Rightarrow> locn set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"Result_bounded R F G h E == (\<forall> l. l:R \<longrightarrow> l:F \<or> (\<exists> x Rx Sx. x:DOM G \<and> (RVal (E\<lfloor>x\<rfloor>), h, GETr G x, Rx, Sx):reg \<and> l:Rx))"

constdefs DAss::"nat \<Rightarrow> Context \<Rightarrow> (rname set) \<Rightarrow> Type \<Rightarrow> nat \<Rightarrow> (rname set) \<Rightarrow> (rname set) \<Rightarrow> vdmassn"
"DAss n G X A nn Y Z E h hh v p \<equiv> 
  X \<subseteq> (DOM G) \<and> Y \<subseteq> (DOM G) \<and> Z \<subseteq> (DOM G) \<and> 
  (\<forall> F N. 
    (freelist h F N \<and> (regionsExist G h E) \<and> (regionsDistinct X G h E) \<and> (distinctFrom (DOM G) G h E F)) \<longrightarrow>
    (\<exists> R S M FF. (freelist hh FF M) \<and> 
                 (v,hh,Some A,R,S) : reg \<and>
                 (distinctFrom Y G h E R) \<and>  
                 (unmodified F Z G h E hh) \<and>
                 (R \<inter> FF = {}) \<and> 
                 (Result_bounded R F G h E) \<and>
                 (FL_bounded FF F Z G h E) \<and> 
                 (Size_restricted n N nn S M G h E) \<and>
                 oheap h = oheap hh))"

lemma regionsExist_Lookup: "\<lbrakk>regionsExist G h E; GETr G x = Some T\<rbrakk> \<Longrightarrow> (\<exists> R S . (RVal (E\<lfloor>x\<rfloor>),h,Some T,R,S):reg)"
by (simp add: regionsExist_def, erule_tac x=x in allE, insert GETrSome_DOM, auto)

lemma regionsDistinct_antimonotone:"\<lbrakk>regionsDistinct XX G h E; X \<subseteq> XX\<rbrakk> \<Longrightarrow> regionsDistinct X G h E"
by (simp add: regionsDistinct_def, fast)

lemma distinctFrom_antimonotone:"\<lbrakk>distinctFrom XX G h E R; X \<subseteq> XX\<rbrakk> \<Longrightarrow> distinctFrom X G h E R"
by (simp add: distinctFrom_def, fast)

lemma unmodified_monotone:"\<lbrakk>unmodified F Z G h E hh; Z \<subseteq> ZZ\<rbrakk> \<Longrightarrow> unmodified F ZZ G h E hh"
by (simp add: unmodified_def, fast)

lemma FL_bounded_monotone:"\<lbrakk>FL_bounded FF F Z G h E; Z \<subseteq> ZZ\<rbrakk> \<Longrightarrow> FL_bounded FF F ZZ G h E"
by (simp add: FL_bounded_def, fast)

lemma Result_bounded_antimonotone:"\<lbrakk>Result_bounded R F G h E; RR \<subseteq> R; F \<subseteq> FF\<rbrakk> \<Longrightarrow> Result_bounded RR FF G h E"
by (simp add: Result_bounded_def, fast)

(*better word for monotone here?*)
lemma Size_restricted_monotone: "\<lbrakk>Size_restricted n N nn S M CC h E; mm \<le> nn; n \<le> m\<rbrakk> \<Longrightarrow> Size_restricted m N mm S M CC h E"
by (simp add: Size_restricted_def, clarsimp, erule_tac x=q in allE, erule_tac x=CS in allE, clarsimp)

lemma distinctFrom_Triv1: "distinctFrom {} G h E F" by (simp add: distinctFrom_def)

lemma distinctFrom_Triv2: "distinctFrom X G h E {}" by (simp add: distinctFrom_def)

lemma unmodified_Sameheap: "unmodified F Z G h E h" by (simp add: unmodified_def sameOH_def)

lemma FL_bounded_SameF: "FL_bounded F F Z G h E" by (simp add: FL_bounded_def, fast)

lemma Size_restricted_Const: "Size_restricted n N n 0 N G h E" by (simp add: Size_restricted_def)

lemma Result_bounded_Empty: "Result_bounded {} F G h E" by (simp add: Result_bounded_def)

lemma distinctFrom_Lookup:"\<lbrakk>distinctFrom (DOM G) G h E F; (RVal (renv E x), h, GETr G x, R, S) \<in> reg; xa \<in> R; xa \<in> F\<rbrakk> \<Longrightarrow> A"
apply (simp add: distinctFrom_def)
apply (erule_tac x=x in allE, erule impE)
apply (erule reg.elims, safe) apply (erule GETrSome_DOM)
apply auto
done

lemma DAss_Generalise:
 "\<lbrakk>DAss n C X T nn Y Z E h hh v p; n \<le> m; X \<subseteq> XX; YY \<subseteq> Y; Z \<subseteq> ZZ; XX \<union> ZZ \<subseteq> DOM C; mm \<le> nn; C=CC\<rbrakk>
 \<Longrightarrow> DAss m CC XX T mm YY ZZ E h hh v p"
apply (clarsimp)
apply (simp add: DAss_def, clarsimp)
apply (rule, rotate_tac 9, erule thin_rl, fast)
apply (rule, rotate_tac 9, erule thin_rl, erule SubsetTransitive, assumption)
apply (rule, rotate_tac 9, erule thin_rl, fast)
apply clarsimp
apply (erule_tac x=F in allE, erule_tac x=N in allE, safe)
apply (erule regionsDistinct_antimonotone, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule distinctFrom_antimonotone, assumption)
apply (erule unmodified_monotone, assumption)
apply (erule FL_bounded_monotone, assumption)
apply (erule Size_restricted_monotone, assumption, assumption) 
done

lemma Result_bounded_lookup:
"\<lbrakk>regionsExist G h E; (RVal (renv E x), h, GETr G x, R, S) \<in> reg\<rbrakk> \<Longrightarrow> Result_bounded R F G h E"
apply (simp add: Result_bounded_def)
apply (rule, rule)
apply (subgoal_tac "\<exists>x. x \<in> DOM G \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr G x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",clarsimp)
apply (rule_tac x=x in exI, safe)
apply (erule reg_DOM)
apply fast
done

lemma UnionGet5: "\<lbrakk>x \<in> DOM C1; (C1, C2, C) \<in> Union\<rbrakk> \<Longrightarrow> GETr C x = GETr C1 x"
by (erule Union.elims, clarsimp)

lemma UnionGet6: "\<lbrakk>x \<in> DOM C2; (C1, C2, C) \<in> Union\<rbrakk> \<Longrightarrow> GETr C x = GETr C2 x"
by (erule Union.elims, clarsimp)

lemma Union_symmetric: "(C1, C2, C) \<in> Union \<Longrightarrow> (C2,C1,C): Union"
by (erule Union.elims, clarsimp, rule UNION, auto)

lemma Union_unique: "\<lbrakk>(C1, C2, C) \<in> Union; (C1,C2,D): Union\<rbrakk> \<Longrightarrow> Equal C D"
by (erule Union.elims,erule Union.elims,simp add: Equal_def EqualR_def)

lemma GetNONE1: "x \<notin> DOM C \<Longrightarrow> None = GETr C x"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GetNONE2: "GETr C x = None \<Longrightarrow> x \<notin> DOM C"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def, split option.split_asm, auto)

lemma Union_DOM1: "\<lbrakk>x \<in> DOM C1; (C1, C2, C) \<in> Union\<rbrakk> \<Longrightarrow> x \<in> DOM C"
by (erule Union.elims,fast)

lemma Union_DOM2: "\<lbrakk>x \<in> DOM C2; (C1, C2, C) \<in> Union\<rbrakk> \<Longrightarrow> x \<in> DOM C"
by (erule Union.elims, fast)

lemma Union_Distinct: "\<lbrakk>x \<in> DOM C1; y \<in> DOM C2; (C1, C2, C) \<in> Union\<rbrakk> \<Longrightarrow> y \<noteq> x"
by (erule Union.elims, fast)

lemma EqualR_GETr: "EqualR (a, b) (ab, bb) \<Longrightarrow> GETr (a, b) x = GETr (ab, bb) x"
apply (simp add: EqualR_def)
apply (case_tac "x:DOM (a,b)", fast)
apply (subgoal_tac "GETr (a,b) x = None")
apply (subgoal_tac "GETr (ab,bb) x = None", clarsimp)
apply (rule DOM_GETrNone, clarsimp)
apply (erule DOM_GETrNone)
done

lemma ContextSize_IcontextIenv_irrelevant[rule_format]:
"(E, h, C, m) \<in> ContextSize \<Longrightarrow> (\<forall> D . EqualR C D \<longrightarrow> (\<forall> EE . renv E = renv EE \<longrightarrow> (EE, h, D, m) \<in> ContextSize))"
apply (erule ContextSize.induct)
apply clarsimp apply (rule ContextSizeNIL)
apply (simp add: Equal_def EqualR_def DOM_def) apply rule
apply (simp add: Equal_def)
apply clarsimp
apply (subgoal_tac "GETr (aa, b) x = GETr (ab, bb) x", clarsimp)
prefer 2 apply (erule EqualR_GETr)
apply (erule ContextSizeCONS)
prefer 4 apply simp
apply (erule_tac x=ab in allE, erule_tac x=ba in allE)
apply (erule impE, simp add: EqualR_def DOM_def GETr_def)
apply (erule_tac x=EE in allE, erule impE, simp)
apply assumption
apply (simp add: DOM_def)
apply (subgoal_tac "Equal (ab, bb) (fst (ab, ba), snd (ab, ba)(x\<mapsto>\<^sub>fk))",assumption)
apply simp
apply (simp add: Equal_def)
apply (subgoal_tac "EqualR (ab, bb) (aa,b)") prefer 2 apply (simp add: EqualR_symmetric)
apply (subgoal_tac "EqualR (ab, bb) (aa, ba(x\<mapsto>\<^sub>fk))") prefer 2 apply (erule EqualR_transitive, assumption)
apply (simp add: EqualR_def DOM_def GETr_def)
done

lemma UnionExists[rule_format]:
"(C, D, E) \<in> Union \<Longrightarrow> (\<forall> x aa ba . x \<notin> DOM (aa, ba) \<longrightarrow> Equal C (aa, ba(x\<mapsto>\<^sub>fk)) \<longrightarrow> (\<exists> A B. ((aa, ba), D, A, B) \<in> Union))"
apply (erule Union.elims, clarsimp)
apply (simp add: Equal_def EqualR_def, clarsimp)
apply (rule_tac x="aaa \<union> aa" in exI)
apply (subgoal_tac "\<exists> C . (baa,ba,C):FMAP_DisjUnion",clarsimp) prefer 2 apply (rule DisjUnionExists, simp add: DOM_def)
apply (rule_tac x=C in exI)
apply (rule UNION)
apply (simp_all add: DOM_def)
apply (erule DisjUnion_doms_union)
apply clarsimp apply (subgoal_tac "fmap_lookup C xa = fmap_lookup baa xa") prefer 2 apply (erule DisjUnion_lookup1,assumption) 
  apply(simp add: GETr_def)
apply clarsimp apply (subgoal_tac "fmap_lookup C xa = fmap_lookup ba xa") prefer 2 apply (erule DisjUnion_lookup2,assumption) 
  apply(simp add: GETr_def)
done

lemma ContextSize_split[rule_format]:
"(E,h,C1,S1):ContextSize \<Longrightarrow> (\<forall> C2 S2 . (E,h,C2,S2):ContextSize \<longrightarrow> (\<forall> C . (C1,C2,C):Union \<longrightarrow> (E,h,C,S1+S2):ContextSize))"
apply (erule ContextSize.induct)
apply (simp add: Equal_def EqualR_def, clarsimp)
apply (erule ContextSize_IcontextIenv_irrelevant)
apply (erule Union.elims, clarsimp)
  apply (simp add: EqualR_def DOM_def)
  apply simp
apply clarsimp
apply (subgoal_tac "GETr (a, b) x = GETr (ac, bc) x",clarsimp)
prefer 2 apply (erule Union.elims, clarsimp) apply (erule_tac x=x in allE) apply (erule impE, erule reg_DOM) apply assumption
apply (rule ContextSize_IcontextIenv_irrelevant)
defer 1
apply (subgoal_tac "EqualR (ac,bc) (ac, bc)", assumption) apply (simp add: EqualR_reflexive)
apply simp
apply (subgoal_tac "\<exists> A B . ((aa, ba),(ab, bb),(A,B)): Union",clarsimp)
apply (erule ContextSizeCONS)
prefer 4 apply simp
apply (subgoal_tac "(E, h, (A,B), m + S2) \<in> ContextSize", assumption)
apply (erule_tac x=ab in allE, erule_tac x=bb in allE, erule_tac x=S2 in allE,clarsimp)
apply (subgoal_tac "x \<notin> DOM (ab,bb)") apply (rotate_tac -2, erule Union.elims, clarsimp)
apply (subgoal_tac "x: DOM(a,b)") apply (erule Union.elims, clarsimp) apply (erule thin_rl, erule thin_rl, fast)
apply (simp add: Equal_def EqualR_def DOM_def)
apply (simp) apply (erule thin_rl, erule thin_rl)
  apply (erule Union.elims, erule Union.elims, clarsimp)
  apply (simp add: Equal_def, safe)
  apply (subgoal_tac "EqualR (ag \<union> ah, bf) (ag \<union> ah, bi(x\<mapsto>\<^sub>fk))", assumption)
apply (simp add: EqualR_def DOM_def, safe)
apply (simp add: GETr_def)
apply (subgoal_tac "GETr (ag, bg(x\<mapsto>\<^sub>fk)) xa = GETr (ag, bg) xa",clarsimp) prefer 2 apply (rule GETr_Update1) apply fast
apply (subgoal_tac "GETr (ag \<union> ah, bi(x\<mapsto>\<^sub>fk)) xa = GETr (ag \<union> ah, bi) xa",clarsimp) apply (rule GETr_Update1) apply fast
apply (subgoal_tac "GETr (ag \<union> ah, bi(x\<mapsto>\<^sub>fk)) xa = GETr (ag \<union> ah, bi) xa",clarsimp) apply (rule GETr_Update1) apply fast
apply (erule UnionExists, assumption+)
done

lemma Union_Empty1:"\<lbrakk>EqualR C (X, emptyfinmap); (C1, C2, C) \<in> Union\<rbrakk> \<Longrightarrow> EqualR C1 (A, emptyfinmap)"
by (erule Union.elims, simp add: EqualR_def DOM_def)

lemma Union_Empty2:"\<lbrakk>EqualR C (X, emptyfinmap); (C1, C2, C) \<in> Union\<rbrakk> \<Longrightarrow> EqualR C2 (A, emptyfinmap)"
by (erule Union.elims, simp add: EqualR_def DOM_def)
(* needs induction principle for finite maps
lemma SizeExists:"\<exists> S. (E,h,C,S):ContextSize"
apply (case_tac "snd C = emptyfinmap")
apply (rule_tac x=0 in exI) apply (rule ContextSizeNIL) apply (simp add: Equal_def EqualR_def DOM_def) apply simp
apply (subgoal_tac "\<exists> B x k. snd C = B(x\<mapsto>\<^sub>fk) \<and> x \<notin> fmap_dom B",clarsimp,rule)
apply (rule ContextSizeCONS)*)

lemma SPLIT[rule_format]:
"(C1, C2, C) \<in> Union \<Longrightarrow> (\<forall> D x k . Equal C (fst D, snd D(x\<mapsto>\<^sub>fk)) \<longrightarrow> 
        ((\<exists>CC k. Equal C1 (fst C1, CC(x\<mapsto>\<^sub>fk)) \<and> x \<notin> DOM (fst C1, CC)) \<or> (\<exists>CC k. Equal C2 (fst C2, CC(x\<mapsto>\<^sub>fk)) \<and> x \<notin> DOM (fst C2, CC))))"
apply (erule Union.induct)
apply clarsimp
sorry

lemma Union_ContextSize[rule_format]:
"(E, h, C, CS) \<in> ContextSize \<Longrightarrow> (\<forall> C1 C2 . (C1, C2, C) \<in> Union \<longrightarrow>
 (\<exists> CS1 CS2. (E, h, C1, CS1) \<in> ContextSize \<and> (E, h, C2, CS2) \<in> ContextSize \<and> CS1 + CS2 = CS))"
apply (erule ContextSize.induct)
apply clarsimp
  apply rule
  apply (rule ContextSizeNIL) apply (simp add: Equal_def, clarsimp) apply(rule, simp, erule Union_Empty1, assumption, simp)
  apply (rule ContextSizeNIL) apply (simp add: Equal_def, clarsimp) apply(rule, simp, erule Union_Empty2, assumption, simp)
apply (rule,rule, rule)
apply (subgoal_tac "((\<exists>CC k. Equal C1 (fst C1, CC(x\<mapsto>\<^sub>fk)) \<and> x \<notin> DOM (fst C1, CC)) \<or> 
                     (\<exists>CC k. Equal C2 (fst C2, CC(x\<mapsto>\<^sub>fk)) \<and> x \<notin> DOM (fst C2, CC)))", erule disjE)
(*1*)
apply ((erule exE)+, erule conjE)
apply (erule_tac x="(fst C1,CC)" in allE, erule_tac x=C2 in allE, erule impE)
prefer 2 apply(erule exE, erule exE, erule conjE, erule conjE)
         apply (rule_tac x="n+CS1" in exI, rule_tac x=CS2 in exI, simp)
         apply (rule ContextSizeCONS) apply (subgoal_tac "(RVal (renv E x), h, GETr C1 x, R, n) \<in> reg",assumption) 
                                      apply (subgoal_tac "GETr C x = GETr C1 x",clarsimp) apply (rule UnionGet5)
                                      apply (simp add: Equal_def EqualR_def DOM_def) apply assumption
            prefer 2 apply (rotate_tac 3,assumption) apply assumption apply simp apply simp
apply (rule UNION) apply (erule Union.elims, clarsimp)
                   apply (erule Union.elims, clarsimp, simp add: Equal_def EqualR_def)
                   apply (erule Union.elims, clarsimp, simp add: Equal_def EqualR_def DOM_def)
                   apply (erule Union.elims, simp add: Equal_def EqualR_def DOM_def, clarsimp)
                       apply (rotate_tac 6, erule thin_rl, erule thin_rl, rotate_tac 1, erule thin_rl, rotate_tac 3, erule thin_rl)
                       apply (rule, rule) apply (subgoal_tac "x \<noteq> xa") apply (subgoal_tac "xa:insert x (fmap_dom CC \<union> fmap_dom be)",fast)
                                          apply fast apply fast
                              apply(rule) apply (subgoal_tac "x \<noteq> xa") apply (subgoal_tac "xa:insert x (fmap_dom ba)", fast)
                                          apply fast apply fast
                   apply (rule allI, rule)
                   apply (subgoal_tac "x \<noteq> xa")
                   apply (subgoal_tac "GETr (fst C1, CC) xa = GETr C1 xa \<and> xa:DOM C1", 
                          subgoal_tac "GETr C1 xa = GETr C xa \<and> xa:DOM C", subgoal_tac "GETr C xa = GETr D xa",clarsimp)
                   apply (simp add: Equal_def EqualR_def, clarsimp) apply (erule GETr_Update1)
                   apply (erule Union.elims,clarify) apply fast
                   apply (simp add: Equal_def EqualR_def, clarsimp) apply (erule_tac x=xa in allE)
                   apply (erule impE, simp add: DOM_def,rule) apply (subgoal_tac "GETr (ab, CC(x\<mapsto>\<^sub>fka)) xa = GETr (ab, CC) xa",clarsimp)
                   apply (erule GETr_Update1) apply(simp add: DOM_def)
                   apply fast
                   apply (rule allI, rule)
                   apply (subgoal_tac "x \<noteq> xa")
                   apply (subgoal_tac "GETr C2 xa = GETr C xa \<and> xa:DOM C", subgoal_tac "GETr C xa = GETr D xa",clarsimp)
                   apply (simp add: Equal_def EqualR_def, clarsimp) apply (erule GETr_Update1)
                   apply (erule Union.elims,clarify) apply fast
                   apply (subgoal_tac "xa \<noteq> x", fast) apply (rule Union_Distinct) prefer 2 apply assumption prefer 2 apply assumption
                   apply (simp add: Equal_def EqualR_def DOM_def) 
(*2*)
apply ((erule exE)+, erule conjE)
apply (erule_tac x=C1 in allE, erule_tac x="(fst C2,CC)" in allE, erule impE)
prefer 2 apply(erule exE, erule exE, erule conjE, erule conjE)
         apply (rule_tac x=CS1 in exI, rule_tac x="n+CS2" in exI, simp)
         apply (rule ContextSizeCONS) apply (subgoal_tac "(RVal (renv E x), h, GETr C2 x, R, n) \<in> reg",assumption) 
                                      apply (subgoal_tac "GETr C x = GETr C2 x",clarsimp) apply (rule UnionGet6)
                                      apply (simp add: Equal_def EqualR_def DOM_def) apply assumption
            prefer 2 apply (rotate_tac 3,assumption) apply assumption apply simp apply simp
apply (rule UNION) apply (erule Union.elims, clarsimp)
                   apply (erule Union.elims, clarsimp, simp add: Equal_def EqualR_def)
                   apply (erule Union.elims, clarsimp, simp add: Equal_def EqualR_def DOM_def)
                   apply (erule Union.elims, simp add: Equal_def EqualR_def DOM_def, clarsimp)
                       apply (rotate_tac 6, erule thin_rl, erule thin_rl, rotate_tac 1, erule thin_rl, rotate_tac 3, erule thin_rl)
                       apply (rule, rule) apply (subgoal_tac "x \<noteq> xa") apply (subgoal_tac "xa:insert x (fmap_dom bd \<union> fmap_dom CC)", fast)
                                          apply fast apply fast
                              apply(rule) apply (subgoal_tac "x \<noteq> xa") apply (subgoal_tac "xa:insert x (fmap_dom ba)", fast)
                                          apply fast apply fast
                   apply (rule allI, rule)
                   apply (subgoal_tac "x \<noteq> xa")
                   apply (subgoal_tac "GETr C1 xa = GETr C xa \<and> xa:DOM C", subgoal_tac "GETr C xa = GETr D xa",clarsimp)
                   apply (simp add: Equal_def EqualR_def, clarsimp) apply (erule GETr_Update1)
                   apply (erule Union.elims,clarify) apply fast
                   apply (rule Union_Distinct) apply assumption prefer 2 apply assumption
                   apply (simp add: Equal_def EqualR_def DOM_def)                    
                   apply (rule allI, rule)
                   apply (subgoal_tac "x \<noteq> xa")
                   apply (subgoal_tac "GETr (fst C2, CC) xa = GETr C2 xa \<and> xa:DOM C2", 
                          subgoal_tac "GETr C2 xa = GETr C xa \<and> xa:DOM C", subgoal_tac "GETr C xa = GETr D xa",clarsimp)
                   apply (simp add: Equal_def EqualR_def, clarsimp) apply (erule GETr_Update1)
                   apply (erule Union.elims,clarify) apply fast
                   apply (simp add: Equal_def EqualR_def, clarsimp) apply (erule_tac x=xa in allE)
                   apply (erule impE, simp add: DOM_def,rule) apply (subgoal_tac "GETr (ac, CC(x\<mapsto>\<^sub>fka)) xa = GETr (ac, CC) xa",clarsimp)
                   apply (erule GETr_Update1) apply(simp add: DOM_def)
                   apply fast
(*3*)
apply (erule SPLIT,assumption)
done

lemma Union_distinctFrom_C1C: "\<lbrakk>(C1, C2, C) \<in> Union; Y \<subseteq> DOM C1; distinctFrom Y C1 h E R\<rbrakk> \<Longrightarrow> distinctFrom Y C h E R"
apply (erule Union.elims, simp add: distinctFrom_def, clarsimp)
apply (erule_tac x=x in allE, clarsimp)
apply (erule_tac x=x in allE, erule impE, erule SubsetTriv, assumption)
apply (erule_tac x=Rx in allE, erule impE)
apply (rule_tac x=Sx in exI, clarsimp)
apply assumption
done

lemma Union_unmodified_C1C: "\<lbrakk>(C1, C2, C) \<in> Union;  Z \<subseteq> DOM C1; unmodified F Z C1 h E hh\<rbrakk> \<Longrightarrow> unmodified F Z C h E hh"
apply (erule Union.elims, simp add: unmodified_def, clarsimp)
apply (erule_tac x=l in allE, erule impE, clarsimp)
apply (erule_tac x=z in allE, erule impE, erule SubsetTriv, assumption)
apply (rotate_tac 6)
apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
apply (rule_tac x=Sz in exI, clarsimp)
apply simp
apply assumption
done

lemma Union_FL_bounded_C1C: "\<lbrakk>(C1, C2, C) \<in> Union; Z \<subseteq> DOM C1; FL_bounded FF F Z C1 h E\<rbrakk> \<Longrightarrow> FL_bounded FF F Z C h E" 
apply (erule Union.elims, simp add: FL_bounded_def, clarsimp)
apply (subgoal_tac "x:{l. \<exists>z. z \<in> Z \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr (a, b) z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", clarsimp)
apply (erule_tac x=z in allE, erule impE, erule SubsetTriv, assumption)
apply (rule_tac x=z in exI, auto)
done

lemma Union_Size_restricted_C1C:
"\<lbrakk>(C1, C2, C) \<in> Union; Size_restricted n N nn S M C1 h E\<rbrakk> \<Longrightarrow> Size_restricted n N nn S M C h E"
apply (simp add: Size_restricted_def, clarsimp)
apply (subgoal_tac "\<exists> CS1 CS2. (E, h, C1, CS1) \<in> ContextSize \<and> (E, h, C2, CS2) \<in> ContextSize \<and> CS1 + CS2 = CS", clarsimp)
apply (erule Union_ContextSize, assumption)
done

lemma Union_Result_bounded_C1C:
"\<lbrakk>(C1, C2, C) \<in> Union;  Result_bounded R F C1 h E\<rbrakk> \<Longrightarrow>  Result_bounded R F C h E"
apply (simp add: Result_bounded_def)
apply (rule, rule)
apply (erule_tac x=l in allE, erule impE,clarsimp)
apply (erule disjE) apply simp
apply (subgoal_tac "\<exists>x. x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (subgoal_tac "x:DOM C")
apply (subgoal_tac "GETr C x = GETr C1 x")
apply (rule_tac x=x in exI, clarsimp,fast)
apply (erule Union.elims, clarsimp)
apply (erule Union_DOM1,assumption)
done

lemma Union_regionsExist_CC1:"\<lbrakk>(C1, C2, C) \<in> Union; regionsExist C h E\<rbrakk> \<Longrightarrow> regionsExist C1 h E"
by (erule Union.elims, simp add: regionsExist_def)

lemma Union_regionsDistinct_CC1:"\<lbrakk>(C1, C2, C) \<in> Union; X \<subseteq> DOM C1; regionsDistinct X C h E\<rbrakk> \<Longrightarrow> regionsDistinct X C1 h E"
apply (erule Union.elims, simp add: regionsDistinct_def, clarsimp)
apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE, rotate_tac -1)
apply (erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Rxx in allE, rotate_tac -1, erule impE, clarsimp)
apply rule
apply (erule_tac x=x in allE, erule impE, erule SubsetTriv, assumption, rule_tac x=Sx in exI, clarsimp)
apply (erule_tac x=xx in allE, erule impE, erule SubsetTriv, assumption, rule_tac x=Sxx in exI, clarsimp)
apply assumption
done

lemma Union_distinctFrom_CC1:"\<lbrakk>(C1, C2, C) \<in> Union; distinctFrom (DOM C) C h E F\<rbrakk> \<Longrightarrow> distinctFrom (DOM C1) C1 h E F"
by (erule Union.elims, simp add: distinctFrom_def)

lemma DAss_PConst: "DAss n G X A nn Y Z E h hh v p \<Longrightarrow> DAss n G X A nn Y Z E h hh v pp"
by (simp add: DAss_def)

lemma regionsExist1:
"\<lbrakk>regionsExist C h E; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> regionsExist D h EE"
by (simp add: regionsExist_def)

lemma regionsDistinct1:
"\<lbrakk>regionsDistinct X C h E; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> regionsDistinct X D h EE"
apply (simp add: regionsDistinct_def, clarsimp)
apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, safe)
apply (erule_tac x=x in allE, erule impE, erule reg_DOM, auto)
apply (erule_tac x=xx in allE, erule impE, erule reg_DOM, auto)
done

lemma distinctFrom1:
"\<lbrakk>distinctFrom X C h E R; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> distinctFrom X D h EE R"
apply (simp add: distinctFrom_def, clarsimp)
apply (erule_tac x=x in allE, clarsimp)
apply (erule_tac x=x in allE, erule impE, erule reg_DOM, auto)
done

lemma unmodified1:
"\<lbrakk>unmodified F Z C h E hh; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> unmodified F Z D h EE hh"
apply (simp add: unmodified_def, clarsimp)
apply (erule_tac x=l in allE, erule impE, safe)
apply (erule_tac x=z in allE, erule impE)
apply (subgoal_tac "z:DOM C", clarsimp, erule reg_DOM)
apply (erule_tac x=z in allE, erule_tac x=Rz in allE, auto)
done

lemma Result_bounded1:
"\<lbrakk>Result_bounded R F D h EE; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; renv E = renv EE\<rbrakk> \<Longrightarrow> Result_bounded R F C h E"
apply (simp add: Result_bounded_def, rule, rule)
apply (erule_tac x=l in allE, erule impE, simp)
apply (erule disjE, simp)
apply (subgoal_tac "\<exists>x. x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv EE x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",simp)
apply clarsimp
apply (erule_tac x=x in allE, clarsimp)
apply (rule_tac x=x in exI, safe)
apply (erule reg_DOM)
apply fast
done

lemma FL_bounded1:
"\<lbrakk>FL_bounded FF F Z C h E; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> FL_bounded FF F Z D h EE"
apply (simp add: FL_bounded_def, clarsimp)
apply (subgoal_tac "x:{l. \<exists>z. z \<in> Z \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv EE z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", safe)
apply (erule_tac x=z in allE, erule impE)
apply (subgoal_tac "z:DOM C", clarsimp, erule reg_DOM)
apply auto
apply (rule_tac x=z in exI, auto)
done

lemma Size_restricted1:
"\<lbrakk>Size_restricted n N m S M C h E; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> 
 Size_restricted n N m S M D h EE"
apply (simp add: Size_restricted_def, clarsimp)
apply (subgoal_tac "(E, h, C, CS) \<in> ContextSize")
prefer 2 apply (erule ContextSize_IcontextIenv_irrelevant)
  apply (simp add: EqualR_def, simp)
apply fast
done

lemma regionsExist_Letv:
"\<lbrakk>(C1, C2, C) \<in> Union; unmodified F (DOM C1) C1 h E h1; distinctFrom (DOM C) C h E F;
   regionsDistinct (DOM C) C h E; regionsExist C h E; renv E = renv EE\<rbrakk> \<Longrightarrow> regionsExist C2 h1 EE"
apply (simp add: regionsExist_def, clarsimp)
apply (erule_tac x=x in allE, erule impE, erule Union_DOM2, assumption, safe)
apply (rule_tac x=Rx in exI, rule_tac x=Sx in exI)
apply (rule reg_Preserved)
apply (subgoal_tac "GETr C x = GETr C2 x", clarsimp, assumption) apply (erule UnionGet6, assumption)
apply (simp add: unmodified_def, clarsimp)
apply (erule_tac x=l in allE, erule impE, safe)
apply (simp add: distinctFrom_def, erule_tac x=x in allE, erule impE, erule Union_DOM2, assumption)
apply fast
apply (simp add: regionsDistinct_def)
  apply (subgoal_tac "x \<noteq> z") prefer 2 apply (erule Union_Distinct, assumption, assumption)
  apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=z in allE, erule_tac x=Rx in allE, erule_tac x=Rz in allE, erule impE, safe)
  apply (erule Union_DOM2, assumption)
  apply (erule Union_DOM1, assumption)
  apply fast
  apply (subgoal_tac "GETr C z = GETr C1 z", clarsimp, fast) apply (erule UnionGet5, assumption)
  apply fast
done

lemma regionsExist_Leti:
"\<lbrakk>(D, ({y}, emptyfinmap), C) \<in> Union; (G, D, GD) \<in> Union; unmodified F (DOM G) G h E h1;
  distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E;
  renv E = renv EE\<rbrakk> \<Longrightarrow> regionsExist C h1 EE"
apply (subgoal_tac "regionsExist D h1 EE")
prefer 2 apply (erule regionsExist_Letv,assumption+)
apply (simp add: regionsExist_def, clarsimp)
apply (subgoal_tac "DOM C = DOM D", clarsimp)
apply (subgoal_tac "GETr C x = GETr D x",clarsimp) 
apply (erule Union.elims, clarsimp)
apply (erule Union.elims, clarsimp, simp add: DOM_def)
done

lemma regionsExist_Letr:
"\<lbrakk>(D, ({}, emptyfinmap(y\<mapsto>\<^sub>fk)), C) \<in> Union; (G, D, GD) \<in> Union; unmodified F (DOM G) G h E h1;
  distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E; (RVal r, h1, Some (ListET k), R, S) \<in> reg
 \<rbrakk> \<Longrightarrow> regionsExist C h1 E\<lfloor>y:=r\<rfloor>"
apply (subgoal_tac "regionsExist D h1 E")
prefer 2 apply (erule regionsExist_Letv,assumption+,simp)
apply (simp add: regionsExist_def, clarsimp)
apply (case_tac "x=y",clarsimp)
(*x=y*)
apply (subgoal_tac "GETr C y = Some (ListET k)",clarsimp,fast)
apply (erule Union.elims, clarsimp, simp add: DOM_def GETr_def)
(* x \<noteq> y*)
apply (subgoal_tac "x:DOM D")
apply (subgoal_tac "GETr C x = GETr D x",clarsimp)
apply (rotate_tac -4, erule_tac x=x in allE, clarsimp)
apply (erule Union.elims, clarsimp, simp add: DOM_def GETr_def)
apply (erule Union.elims, clarsimp, simp add: DOM_def)
done

lemma Union_sameOH_h_h1:
"\<lbrakk>(C1, C2, C) \<in> Union; unmodified F (DOM C1) C1 h E h1; distinctFrom (DOM C) C h E F;
  regionsDistinct (DOM C) C h E; (RVal (renv E x), h, GETr C2 x, R, S) \<in> reg; l \<in> R\<rbrakk>
 \<Longrightarrow> sameOH {l} h h1"
apply (simp add: unmodified_def)  
apply (erule_tac x=l in allE)
apply (subgoal_tac "x:DOM C2") prefer 2 apply (erule reg_DOM)
apply (subgoal_tac "x:DOM C") prefer 2 apply (erule Union_DOM2, assumption)
apply (subgoal_tac "GETr C x = GETr C2 x") prefer 2 apply (erule UnionGet6, assumption)
apply (erule impE, safe)
apply (simp add: distinctFrom_def) 
apply (erule_tac x=x in allE, clarsimp) apply fast 
apply (simp add: regionsDistinct_def) 
apply (subgoal_tac "x \<noteq> z") prefer 2 apply (erule Union_Distinct, assumption, assumption)
apply (subgoal_tac "z:DOM C") prefer 2 apply (erule Union_DOM1, assumption)
apply (subgoal_tac "GETr C z = GETr C1 z") prefer 2 apply (erule UnionGet5, assumption)
apply fastsimp
done

lemma reg_C2_h_h1:
"\<lbrakk>(C1, C2, C) \<in> Union; unmodified F (DOM C1) C1 h E h1; distinctFrom (DOM C) C h E F;
        regionsDistinct (DOM C) C h E; (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, R, S) \<in> reg;x:DOM C2\<rbrakk> \<Longrightarrow>
      (RVal (E\<lfloor>x\<rfloor>), h1, GETr C2 x, R, S) \<in> reg"
apply (subgoal_tac "GETr C x = GETr C2 x", clarsimp)
apply (rule reg_Preserved, assumption)
apply clarsimp
apply (erule Union_sameOH_h_h1, assumption+)
apply (erule UnionGet6, assumption)
done

lemma reg_C2_h1_h:
"\<lbrakk>(C1, C2, C) \<in> Union; unmodified F (DOM C1) C1 h E h1; distinctFrom (DOM C) C h E F;
   regionsDistinct (DOM C) C h E; regionsExist C h E; x:DOM C2; (RVal (E\<lfloor>x\<rfloor>), h1, GETr C2 x, R, S) \<in> reg; 
  E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor> \<rbrakk>
 \<Longrightarrow> (RVal (EE\<lfloor>x\<rfloor>), h, GETr C x, R, S) \<in> reg"
apply (subgoal_tac "GETr C x = GETr C2 x", clarsimp)
apply (subgoal_tac "\<exists> RR SS . (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, RR, SS) \<in> reg", clarsimp)
apply (subgoal_tac "RR = R \<and> SS = S", clarsimp)
apply (subgoal_tac "(RVal (renv E x), h1, GETr C2 x, RR, SS) \<in> reg")
apply clarsimp
apply (rotate_tac -1, erule reg_Unique, assumption)
apply (erule reg_C2_h_h1, assumption, assumption, assumption, clarsimp, assumption)
apply (simp add: regionsExist_def)
apply (erule_tac x=x in allE, erule impE, erule Union_DOM2, assumption)
apply clarsimp
apply (erule UnionGet6, assumption)
done

lemma regionsDistinct_Letv:
"\<lbrakk>(C1, C2, C) \<in> Union; unmodified F (DOM C1) C1 h E h1; distinctFrom (DOM C) C h E F;
  regionsDistinct (DOM C) C h E; regionsExist C h E; renv E = renv EE\<rbrakk> \<Longrightarrow> regionsDistinct (DOM C2) C2 h1 EE"
apply (subgoal_tac "regionsExist C2 h1 E") 
prefer 2 apply(erule regionsExist_Letv, assumption+,simp)
apply (simp add: regionsDistinct_def, clarsimp)
apply (subgoal_tac "regionsDistinct (DOM C) C h E") prefer 2 apply (simp add: regionsDistinct_def)
apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, safe)
apply (erule Union_DOM2, assumption)
apply (erule Union_DOM2, assumption)
apply (rule_tac x=Sx in exI)
apply (erule reg_C2_h1_h, assumption+,clarsimp+)
apply (rule_tac x=Sxx in exI)
apply (erule reg_C2_h1_h, assumption+,clarsimp+)
done

lemma regionsDistinct_Leti:
"\<lbrakk>(D, ({y}, emptyfinmap), C) \<in> Union; (G, D, GD) \<in> Union; unmodified F (DOM G) G h E h1;
  distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E;
  renv E = renv EE\<rbrakk> \<Longrightarrow> regionsDistinct (DOM C) C h1 EE"
apply (subgoal_tac "regionsDistinct (DOM D) D h1 EE")
prefer 2 apply (erule regionsDistinct_Letv, assumption+)
apply (simp add: regionsDistinct_def, clarsimp)
apply (rotate_tac 4, erule thin_rl)
apply (subgoal_tac "DOM C = DOM D", clarsimp)
apply (subgoal_tac "GETr C x = GETr D x",clarsimp) 
apply (subgoal_tac "GETr C xx = GETr D xx",clarsimp) 
apply fast
apply (erule Union.elims, clarsimp)
apply (erule Union.elims, clarsimp)
apply (erule Union.elims, clarsimp, simp add: DOM_def)
done

lemma regionsDistinct_Letr:
"\<lbrakk>(D, ({}, emptyfinmap(y\<mapsto>\<^sub>fk)), C) \<in> Union; (G, D, GD) \<in> Union; unmodified F (DOM G) G h E h1;
  distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E;
   Result_bounded R F G h E; (RVal r, h1, Some (ListET k), R, S) \<in> reg\<rbrakk> \<Longrightarrow> regionsDistinct (DOM C) C h1 E\<lfloor>y:=r\<rfloor>"
apply (subgoal_tac "regionsDistinct (DOM D) D h1 E")
prefer 2 apply (erule regionsDistinct_Letv, assumption+,simp)
apply (simp add: regionsDistinct_def, clarsimp)
apply (subgoal_tac "regionsDistinct (DOM GD) GD h E") prefer 2 apply (simp add: regionsDistinct_def)
apply (case_tac "x=y", clarsimp)
(*x=y*)
apply (rotate_tac 8, erule thin_rl)
apply (subgoal_tac "GETr C y = Some(ListET k)",clarsimp) prefer 2 apply (erule Union.elims, simp add: DOM_def GETr_def,clarsimp)
apply (subgoal_tac "Rx = R \<and> Sx = S",clarsimp) prefer 2 apply (erule reg_Unique,assumption)
apply rule apply (rule, clarsimp)
           apply (subgoal_tac "xx:DOM D") prefer 2 apply (erule Union.elims,simp add: DOM_def,clarsimp)
           apply (simp add: Result_bounded_def) apply (erule_tac x=x in allE, clarsimp)
           apply (erule disjE) apply (rotate_tac 9, erule thin_rl) apply (simp add: distinctFrom_def) 
                               apply (subgoal_tac "distinctFrom (DOM GD) GD h E F") prefer 2 apply (simp add: distinctFrom_def) 
                               apply (erule_tac x=xx in allE, erule impE) 
                               apply (rotate_tac -3, erule Union.elims, simp add: DOM_def)
                               apply (erule_tac x=Rxx in allE, erule impE) 
                               apply (rule_tac x=Sxx in exI, rule reg_C2_h1_h,assumption+)
                               apply (subgoal_tac "GETr D xx = GETr C xx", clarsimp) apply (erule Union.elims, simp add: DOM_def GETr_def)
                               apply simp
                               apply fast
           apply clarsimp
           apply (erule_tac x=xx in allE, erule_tac x=xa in allE, erule_tac x=Rxx in allE, erule_tac x=Rx in allE, erule impE)
           apply rule apply (rule Union_DOM2) prefer 2 apply assumption apply assumption
           apply rule apply (erule Union_DOM1,assumption)
           apply rule apply (erule Union_Distinct) prefer 2 apply assumption apply assumption 
           apply (rule, rule_tac x=Sxx in exI) apply (erule reg_C2_h1_h,assumption+) apply (erule Union.elims,clarsimp)
           apply simp
           apply (subgoal_tac "GETr GD xa = GETr G xa",clarsimp,fast) apply (erule UnionGet5,assumption)  
           apply fast
apply simp
(* x \<noteq> y*)
apply clarsimp
apply (case_tac "xx = y",clarsimp)
(* xx = y*)
apply (rotate_tac 8, erule thin_rl)
apply (subgoal_tac "GETr C y = Some(ListET k)",clarsimp) prefer 2 apply (erule Union.elims, simp add: DOM_def GETr_def,clarsimp)
apply (subgoal_tac "Rxx = R \<and> Sxx = S",clarsimp) prefer 2 apply (erule reg_Unique,assumption)
apply rule apply (rule, clarsimp)
           apply (subgoal_tac "x:DOM D") prefer 2 apply (erule Union.elims,simp add: DOM_def,clarsimp)
           apply (simp add: Result_bounded_def) apply (rotate_tac -6) apply (erule_tac x=xa in allE, clarsimp)
           apply (erule disjE) apply (rotate_tac 14, erule thin_rl) apply (simp add: distinctFrom_def) 
                               apply (subgoal_tac "distinctFrom (DOM GD) GD h E F") prefer 2 apply (simp add: distinctFrom_def) 
                               apply (erule_tac x=x in allE, erule impE) 
                               apply (rotate_tac -3, erule Union.elims, simp add: DOM_def)
                               apply (erule_tac x=Rx in allE, erule impE) 
                               apply (rule_tac x=Sx in exI, rule reg_C2_h1_h,assumption+)
                               apply (subgoal_tac "GETr D x = GETr C x", clarsimp) apply (erule Union.elims, simp add: DOM_def GETr_def)
                               apply simp
                               apply fast
           apply clarsimp
           apply (erule_tac x=x in allE, erule_tac x=xb in allE, erule_tac x=Rx in allE, erule_tac x=Rxa in allE, erule impE)
           apply rule apply (erule Union_DOM2) apply assumption 
           apply rule apply (erule Union_DOM1,assumption)
           apply rule apply (erule Union_Distinct) apply assumption apply assumption 
           apply (rule, rule_tac x=Sx in exI) apply (erule reg_C2_h1_h,assumption+) apply (erule Union.elims,clarsimp)
           apply simp
           apply (subgoal_tac "GETr GD xb = GETr G xb",clarsimp,fast) apply (erule UnionGet5,assumption)  
           apply fast
apply simp
(* xx \<noteq> y*)
apply (rotate_tac 4, erule thin_rl)
apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, safe)
apply (erule Union.elims,simp add: DOM_def, clarsimp)
apply (erule Union.elims,simp add: DOM_def, clarsimp)
apply (subgoal_tac "GETr D x = GETr C x",clarsimp,fast)
apply (erule Union.elims, simp add: DOM_def GETr_def, clarsimp)
apply (subgoal_tac "GETr D xx = GETr C xx",clarsimp,fast)
apply (erule Union.elims, simp add: DOM_def GETr_def, clarsimp)
done

lemma distinctFrom_Letv:
"\<lbrakk>(C1, C2, C) \<in> Union; unmodified F (DOM C1) C1 h E h1; distinctFrom (DOM C) C h E F;
  regionsDistinct (DOM C) C h E; regionsExist C h E; 
  FL_bounded FF F (DOM C1) C1 h E; renv E = renv EE\<rbrakk> \<Longrightarrow> distinctFrom (DOM C2) C2 h1 EE FF"
apply (simp add: distinctFrom_def, clarsimp)
apply (subgoal_tac "distinctFrom (DOM C) C h E F") prefer 2 apply (simp add: distinctFrom_def)
apply (subgoal_tac "Rx \<inter> (F \<union> {l. \<exists>z. z \<in> DOM C1 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C1 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}) = {}")
apply (simp add: FL_bounded_def, auto)
apply (erule_tac x=x in allE, erule impE) apply (erule Union_DOM2, assumption)
apply (erule_tac x=Rx in allE, erule impE, rule_tac x=Sx in exI)
apply (erule reg_C2_h1_h, assumption+,simp,simp) apply fast
apply (subgoal_tac "(RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg") prefer 2 apply (erule reg_C2_h1_h, assumption+,simp,simp)
apply (subgoal_tac "x:DOM C")
apply (subgoal_tac "z:DOM C")
apply (subgoal_tac "x \<noteq> z") prefer 2 apply (erule Union_Distinct) prefer 2 apply(assumption, assumption)
apply (subgoal_tac "GETr C z = GETr C1 z")
apply (simp add: regionsDistinct_def)
apply (rotate_tac 2, erule thin_rl)
apply (erule_tac x=x in allE,erule_tac x=z in allE,erule_tac x=Rx in allE,erule_tac x=Rz in allE, auto)
apply (erule UnionGet5, assumption)
apply (erule Union_DOM1, assumption)
apply (erule Union_DOM2, assumption)
done

lemma distinctFrom_Leti:
"\<lbrakk>(D, ({y}, emptyfinmap), C) \<in> Union; (G, D, GD) \<in> Union; unmodified F (DOM G) G h E h1;
  distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E;
  FL_bounded FF F (DOM G) G h E; renv E = renv EE\<rbrakk> \<Longrightarrow> distinctFrom (DOM C) C h1 EE FF"
apply (subgoal_tac "distinctFrom (DOM D) D h1 EE FF")
prefer 2 apply (erule distinctFrom_Letv, assumption+)
apply (simp add: distinctFrom_def, clarsimp)
apply (rotate_tac 3, erule thin_rl)
apply (subgoal_tac "DOM C = DOM D", clarsimp)
apply (subgoal_tac "GETr C x = GETr D x",clarsimp) 
apply fast
apply (erule Union.elims, clarsimp)
apply (erule Union.elims, clarsimp, simp add: DOM_def)
done

lemma distinctFrom_Letr:
"\<lbrakk>(D, ({}, emptyfinmap(y\<mapsto>\<^sub>fk)), C) \<in> Union; (G, D, GD) \<in> Union; unmodified F (DOM G) G h E h1;
  distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E;
  FL_bounded FF F (DOM G) G h E;(RVal r, h1, Some (ListET k), R, S) \<in> reg;R \<inter> FF = {}
 \<rbrakk> \<Longrightarrow> distinctFrom (DOM C) C h1 E\<lfloor>y:=r\<rfloor> FF"
apply (subgoal_tac "distinctFrom (DOM D) D h1 E FF")
prefer 2 apply (erule distinctFrom_Letv, assumption+,simp)
apply (simp add: distinctFrom_def, clarsimp)
apply (case_tac "x=y",clarsimp)
(*x=y*)
apply (subgoal_tac "Rx = R \<and> Sx = S", clarsimp)
apply (erule reg_Unique)
apply (subgoal_tac "GETr C y = Some(ListET k)",clarsimp)
apply (erule Union.elims, clarsimp, simp add: DOM_def GETr_def)
(*x \<noteq> y*)
apply clarsimp
apply (rotate_tac -4, erule_tac x=x in allE, erule impE)
  apply (erule Union.elims, simp add: DOM_def, clarsimp)
  apply (subgoal_tac "GETr D x = GETr C x",clarsimp) 
  apply fast
  apply (erule Union.elims, clarsimp, simp add: DOM_def)
done

lemma unmodified_Letv:
"\<lbrakk>(C1, C2, C) \<in> Union; unmodified F (DOM C1) C1 h E h1; FL_bounded FF F (DOM C1) C1 h E;
  unmodified FF (DOM C2) C2 h1 EE hh;regionsExist C h E; regionsDistinct (DOM C) C h E; 
  distinctFrom (DOM C) C h E F; \<forall> x. (x:DOM C \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>)
 \<rbrakk> \<Longrightarrow> unmodified F (DOM C) C h E hh"
apply (simp add: unmodified_def, clarsimp)
apply (subgoal_tac "unmodified F (DOM C1) C1 h EE h1")
prefer 2 
  apply (simp add: unmodified_def,clarsimp)
  apply (erule_tac x=la in allE, erule impE, safe)
  apply (rotate_tac -4, erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, safe)
  apply (rotate_tac -4, erule_tac x=z in allE, erule impE)
  apply (erule Union_DOM1, assumption)
  apply (clarsimp,fast)
apply (erule_tac x=l in allE, erule impE) prefer 2
apply (erule_tac x=l in allE, erule impE) prefer 2
apply (erule SameOHTransitive, assumption, simp)
apply rule apply (simp add: FL_bounded_def)
  apply (subgoal_tac "l \<notin> {l. \<exists>z. z \<in> DOM C1 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C1 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
  apply (rotate_tac 5, erule thin_rl)
  apply (rotate_tac 1, erule thin_rl)
  apply fast
  apply clarsimp
  apply (rotate_tac 6)
  apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE)
  apply (rule, erule Union_DOM1, assumption) 
  apply (subgoal_tac "GETr C z = GETr C1 z", clarsimp, fast)
  apply (erule UnionGet5, assumption)
  apply simp
apply clarsimp apply (subgoal_tac "z:DOM C") prefer 2 apply (erule Union_DOM2,assumption) 
               apply (subgoal_tac "(RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg")
               apply (rotate_tac 6)
               apply (erule_tac x=z in allE, erule_tac x=Rz in allE, clarsimp)
               apply (erule reg_C2_h1_h, assumption+)
                apply (simp add: distinctFrom_def)
                apply (simp add: regionsDistinct_def,clarsimp)  
                  apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE, 
                         erule_tac x=Rx in allE, erule_tac x=Rxx in allE,erule impE,clarsimp) apply fast 
                  apply simp
                apply (simp add: regionsExist_def)
                apply assumption
                apply assumption
                apply (erule_tac x=z in allE, clarsimp)
apply safe
apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, safe)
apply (erule Union_DOM1, assumption)
apply (subgoal_tac "GETr C z = GETr C1 z", clarsimp, fast)
apply (erule UnionGet5, assumption)
done

lemma unmodified_Leti:
"\<lbrakk>(D, ({y}, emptyfinmap), C) \<in> Union; (G, D, GD) \<in> Union; unmodified F (DOM G) G h E h1;
  unmodified FF (DOM C) C h1 EE hh; distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E;
  FL_bounded FF F (DOM G) G h E; \<forall> x. (x:DOM GD \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>)\<rbrakk> \<Longrightarrow> unmodified F (DOM GD) GD h E hh"
apply (subgoal_tac "unmodified FF (DOM D) D h1 EE hh")
apply (erule unmodified_Letv, assumption+)
apply (simp add: unmodified_def, clarsimp)
apply (rotate_tac 2, erule thin_rl)
apply (erule_tac x=l in allE, erule impE, safe)
apply (subgoal_tac "DOM C = DOM D", clarsimp)
apply (subgoal_tac "GETr C z = GETr D z",clarsimp) 
apply fast
apply (erule Union.elims, clarsimp)
apply (erule Union.elims, clarsimp, simp add: DOM_def)
done

lemma unmodified_Letr:
"\<lbrakk>(D, ({}, emptyfinmap(y\<mapsto>\<^sub>fk)), C) \<in> Union; (G, D, GD) \<in> Union; unmodified F (DOM G) G h E h1;
  unmodified FF (DOM C) C h1 E\<lfloor>y:=r\<rfloor> hh; distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E;
  FL_bounded FF F (DOM G) G h E;(RVal r, h1, Some (ListET k), R, S) \<in> reg;R \<inter> FF = {}; Result_bounded R F G h E
 \<rbrakk> \<Longrightarrow> unmodified F (DOM G \<union> DOM D) GD h E hh"
apply (simp add: unmodified_def, clarsimp)
apply (subgoal_tac "unmodified F (DOM G) G h E h1") prefer 2 apply (simp add: unmodified_def)
apply (subgoal_tac "sameOH {l} h h1")
prefer 2
  apply (erule_tac x=l in allE, erule impE, safe)
  apply (rotate_tac 2, erule thin_rl)
  apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, safe)
  apply (subgoal_tac "GETr GD z = GETr G z", clarsimp, fast)
  apply (erule UnionGet5, assumption)
apply (subgoal_tac "sameOH {l} h1 hh") apply (erule SameOHTransitive,assumption,simp)
apply (rotate_tac 2, erule thin_rl)
apply (erule_tac x=l in allE, erule impE, safe)
  apply (simp add: FL_bounded_def)
  apply (subgoal_tac "l \<notin> {l. \<exists>z. z \<in> DOM G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
  apply (rotate_tac -4, erule thin_rl, fast)
  apply clarsimp
  apply (subgoal_tac "GETr G z = GETr GD z", clarsimp, fast)
  apply (rotate_tac -5, erule Union.elims,clarsimp)
apply (case_tac "z=y", clarsimp)
(*z=y*)
apply (subgoal_tac "Rz = R \<and> Sz = S",clarsimp)
prefer 2 apply (erule reg_Unique, erule Union.elims, simp add: DOM_def GETr_def,clarsimp)
apply (simp add: Result_bounded_def)
apply (erule_tac x=l in allE, clarsimp)
apply (subgoal_tac "GETr G x = GETr GD x",clarsimp, fast)
apply (rotate_tac -7, erule Union.elims, simp add: DOM_def GETr_def)
(*z \<noteq> y*)
apply clarsimp
apply (subgoal_tac "z:DOM D") 
apply (subgoal_tac "GETr C z = GETr D z",clarsimp)
apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, safe)
apply (rule_tac x=Sz in exI, erule reg_C2_h1_h, assumption+, simp)
apply (erule Union.elims, simp add: DOM_def GETr_def)
apply (erule Union.elims, simp add: DOM_def, clarsimp)
done

lemma FL_bounded_Letv:
"\<lbrakk>(C1, C2, C) \<in> Union; unmodified F (DOM C1) C1 h E h1; 
  distinctFrom (DOM C) C h E F; regionsDistinct (DOM C) C h E; regionsExist C h E;
  FL_bounded FF F (DOM C1) C1 h E; FL_bounded FFa FF (DOM C2) C2 h1 EE; 
  \<forall> x. (x:DOM C \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>)
 \<rbrakk> \<Longrightarrow> FL_bounded FFa F (DOM C) C h E"
apply (simp add: FL_bounded_def, clarsimp)
apply (subgoal_tac "x : FF \<or> x:{l. \<exists>z. z \<in> DOM C2 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv EE z), h1, GETr C2 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply (erule disjE)
(*x:FF*)
apply (subgoal_tac "x:{l. \<exists>z. z \<in> DOM C1 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C1 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply clarsimp apply (rule_tac x=z in exI, safe)
apply (erule Union_DOM1, assumption)
apply (subgoal_tac "GETr C z = GETr C1 z", clarsimp, fast)
apply (erule UnionGet5, assumption)
(*x:{l. \<exists>z. z \<in> DOM C2 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h1, GETr C2 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}*)
apply (subgoal_tac "z:DOM C")
apply (rule_tac x=z in exI, safe)
apply (rule_tac x=Rz in exI, safe)
apply (rule_tac x=Sz in exI)
apply (erule reg_C2_h1_h, assumption+) apply (erule_tac x=z in allE, erule impE, safe) 
apply clarsimp
apply (erule Union_DOM2,assumption) 
done

lemma FL_bounded_Leti:
"\<lbrakk>(D, ({y}, emptyfinmap), C) \<in> Union; (G, D, GD) \<in> Union; unmodified F (DOM G) G h E h1;
  distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E;
  FL_bounded FF F (DOM G) G h E; FL_bounded FFa FF (DOM C) C h1 EE; \<forall> x. (x:DOM GD \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>)
 \<rbrakk> \<Longrightarrow> FL_bounded FFa F (DOM GD) GD h E"
apply (subgoal_tac "FL_bounded FFa FF (DOM D) D h1 EE")
apply (rule FL_bounded_Letv,assumption+) 
apply (simp add: FL_bounded_def, clarsimp)
apply (rotate_tac 6, erule thin_rl)
apply (subgoal_tac "\<exists>z. z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv EE z), h1, GETr C z, Rz, Sz) \<in> reg) \<and> x \<in> Rz)",clarsimp)
apply (subgoal_tac "DOM C = DOM D", clarsimp)
apply (subgoal_tac "GETr C z = GETr D z",clarsimp) 
apply fast
apply (erule Union.elims, clarsimp)
apply (erule Union.elims, clarsimp, simp add: DOM_def)
apply fast
done

lemma FL_bounded_Letr:
"\<lbrakk>(D, ({}, emptyfinmap(y\<mapsto>\<^sub>fk)), C) \<in> Union;(G, D, GD) \<in> Union; unmodified F (DOM G) G h E h1;
  distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E;
  (RVal r, h1, Some (ListET k), R, S) \<in> reg; R \<inter> FF = {}; Result_bounded R F G h E;
  FL_bounded FF F (DOM G) G h E; FL_bounded FFa FF (DOM C) C h1 E\<lfloor>y:=r\<rfloor>
 \<rbrakk> \<Longrightarrow> FL_bounded FFa F (DOM GD) GD h E"
apply (simp add: FL_bounded_def, clarsimp)
apply (subgoal_tac "x:FF \<union> {l. \<exists>z. z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E\<lfloor>y:=r\<rfloor> z), h1, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", clarsimp)
prefer 2 apply fast
apply (erule disjE)
(*x:FF*)
apply (subgoal_tac "x:{l. \<exists>z. z \<in> DOM G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", clarsimp)
prefer 2 apply fast
apply (rule_tac x=z in exI, safe)
apply (rotate_tac 1, erule Union.elims, simp add: DOM_def)
apply (subgoal_tac "GETr GD z = GETr G z",clarsimp, fast)
apply (rotate_tac 1, erule Union.elims, simp add: DOM_def GETr_def)
(*x:{l. \<exists>z. z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E\<lfloor>y:=r\<rfloor> z), h1, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}*)
apply (case_tac "z=y",clarsimp)
(*z=y*)
apply (subgoal_tac "Rz = R \<and> Sz = S",clarsimp)
prefer 2 apply (erule reg_Unique) apply (erule Union.elims, simp add: DOM_def GETr_def, clarsimp)
apply (simp add: Result_bounded_def) apply (erule_tac x=x in allE, clarsimp)
apply (rotate_tac 1)
apply (rule_tac x=xa in exI,safe) apply (erule Union.elims, simp add: DOM_def)
apply (subgoal_tac "GETr GD xa = GETr G xa",clarsimp,fast)
apply (erule Union.elims, simp add: DOM_def GETr_def)
(*z \<noteq> y*)
apply clarsimp
apply (subgoal_tac "z:DOM D") prefer 2 apply (erule Union.elims, simp add: DOM_def,clarsimp)
apply (subgoal_tac "GETr D z = GETr C z") prefer 2 apply (erule Union.elims, simp add: DOM_def GETr_def)
apply (subgoal_tac "z:DOM GD") 
apply (rule_tac x=z in exI,clarsimp, rule_tac x=Rz in exI, clarsimp, rule_tac x=Sz in exI)
apply (erule reg_C2_h1_h, assumption+, clarsimp+)
apply (rotate_tac 1, erule Union.elims, simp add: DOM_def)
done

lemma Result_bounded_Letv:
"\<lbrakk>(C1, C2, C) \<in> Union; unmodified F (DOM C1) C1 h E h1; 
  distinctFrom (DOM C) C h E F; regionsDistinct (DOM C) C h E; regionsExist C h E;
  FL_bounded FF F (DOM C1) C1 h E; Result_bounded R F C1 h E; Result_bounded Ra FF C2 h1 E;
  \<forall> x. (x:DOM C \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>)
 \<rbrakk> \<Longrightarrow> Result_bounded Ra F C h E"
apply (simp add: Result_bounded_def)
apply (rule, rule)
apply (rotate_tac -3, erule_tac x=l in allE, erule impE, simp)
apply (erule disjE)
(*l:FF*)
apply (simp add: FL_bounded_def)
apply (subgoal_tac "l : F \<or> l:{l. \<exists>z. z \<in> DOM C1 \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C1 z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
apply (erule disjE, simp)
apply (subgoal_tac "\<exists>x. x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (rule_tac x=z in exI) apply (rule, erule Union.elims, simp add: DOM_def)
apply (rule_tac x=Rz in exI, clarsimp) 
apply (rule_tac x=Sz in exI, subgoal_tac "GETr C z = GETr C1 z",clarsimp) 
apply (erule Union.elims, simp add: DOM_def GETr_def)
apply (erule thin_rl, rotate_tac -2, erule thin_rl) apply fast
(*l \<notin> FF*)
apply (subgoal_tac "\<exists>x. x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",simp)
apply clarsimp
apply (rule_tac x=x in exI) apply (rule, erule Union.elims, simp add: DOM_def)
apply (rule_tac x=Rx in exI, clarsimp, rule_tac x=Sx in exI)
apply (erule reg_C2_h1_h, assumption+, simp)
done

lemma Result_bounded_Leti:
"\<lbrakk>(D, ({y}, emptyfinmap), C) \<in> Union; (G, D, GD) \<in> Union;unmodified F (DOM G) G h E h1;
  distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E;
  FL_bounded FF F (DOM G) G h E;
  Result_bounded R F G h E; Ra \<inter> FFa = {}; Result_bounded Ra FF C h1 EE;
  \<forall> x. (x:DOM C \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>)
 \<rbrakk> \<Longrightarrow> Result_bounded Ra F GD h E"
apply (subgoal_tac "Result_bounded Ra FF D h1 E")
apply (erule Result_bounded_Letv, assumption+, clarsimp, simp)
apply (simp add: Result_bounded_def)
apply (rule, rule)
apply (rotate_tac -3, erule_tac x=l in allE, erule impE, simp)
apply (erule disjE)
(*l:FF*)
apply (simp add: FL_bounded_def)
(*l \<notin> FF*)
apply (subgoal_tac "\<exists>x. x \<in> DOM D \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h1, GETr D x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (rule_tac x=x in exI) apply (rule, erule Union.elims, simp add: DOM_def,clarsimp)
apply (rule_tac x=Rx in exI, clarsimp, rule_tac x=Sx in exI)
apply (subgoal_tac "GETr D x = GETr C x",clarsimp)
apply (erule Union.elims, simp add: DOM_def GETr_def, clarsimp)
done

lemma Result_bounded_Letr:
"\<lbrakk>(D, ({}, emptyfinmap(y\<mapsto>\<^sub>fk)), C) \<in> Union; (G, D, GD) \<in> Union;unmodified F (DOM G) G h E h1;
  distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E;
  FL_bounded FF F (DOM G) G h E;
  Result_bounded R F G h E;  Ra \<inter> FFa = {};R \<inter> FF = {}; Result_bounded Ra FF C h1 E\<lfloor>y:=r\<rfloor>;
  (v, hh, Some B, Ra, Sa) \<in> reg;(RVal r, h1, Some (ListET k), R, S) \<in> reg
 \<rbrakk> \<Longrightarrow> Result_bounded Ra F GD h E"
apply (simp add: Result_bounded_def)
apply (rule, rule)
apply (rotate_tac -4, erule_tac x=l in allE, erule impE, simp)
apply (erule disjE)
(*l:FF*)
  apply (simp add: FL_bounded_def)
  apply (subgoal_tac "l:F \<or> l:{l. \<exists>z. z \<in> DOM G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
  prefer 2 apply (rotate_tac -4, erule thin_rl) apply fast
  apply (erule disjE)
  (*l:F*)
  apply simp
  (*l:{l. \<exists>z. z \<in> DOM G \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr G z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}*)
  apply (subgoal_tac "\<exists>x. x \<in> DOM GD \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr GD x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",simp)
  apply clarsimp
  apply (rule_tac x=z in exI, rule) apply (erule Union_DOM1,assumption)
  apply (subgoal_tac "GETr GD z = GETr G z",clarsimp,fast) 
  apply (erule UnionGet5,assumption)
(*l \<notin> FF*)
  apply ((erule exE)+, (erule conjE)+)+
  apply (case_tac "x=y")
  (*x=y*)
    apply (erule exE, simp)
    apply (subgoal_tac "Rx = R \<and> Sx = S", simp)
    prefer 2 apply (subgoal_tac "GETr C y = Some (ListET k)",clarsimp) 
             apply (erule reg_Unique,assumption)
             apply (erule Union.elims, simp add: DOM_def GETr_def,clarsimp)
    apply (erule_tac x=l in allE, erule impE, clarsimp)
    apply (erule disjE)
    (*l:F*)
      apply simp
    (*l \<notin> F*)
      apply (subgoal_tac "\<exists>x. x \<in> DOM GD \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr GD x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
      apply clarsimp
      apply (rule_tac x=xa in exI, rule) apply (erule Union_DOM1,assumption)
      apply (subgoal_tac "GETr GD xa = GETr G xa",clarsimp,fast) 
      apply (erule UnionGet5,assumption)
  (*x \<noteq>y*)
    apply (subgoal_tac "\<exists>x. x \<in> DOM GD \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr GD x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
    apply clarsimp
    apply (rule_tac x=x in exI) apply (rule, rule Union_DOM2) prefer 2 apply assumption
                                apply (erule Union.elims, simp add: DOM_def,clarsimp)
    apply (rule_tac x=Rx in exI, clarsimp, rule_tac x=Sx in exI)
    apply (erule reg_C2_h1_h, assumption+)  apply (erule Union.elims, simp add: DOM_def,clarsimp)
    apply (erule Union.elims, simp add: DOM_def GETr_def,clarsimp)
    apply simp
done

lemma SizePreserved[rule_format]:
"(E, h, C, CS) \<in> ContextSize \<Longrightarrow> 
   ( (\<forall> x R n . x : DOM C \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>),h, GETr C x, R, n) : reg \<longrightarrow> (\<forall> l . l : R \<longrightarrow> sameOH {l} h h1)) \<longrightarrow>
     (E, h1, C, CS) \<in> ContextSize)"
apply (erule ContextSize.induct)
apply clarsimp 
apply (erule ContextSizeNIL, simp)
apply clarsimp
apply (rule ContextSizeCONS) defer 1 defer 1
apply (assumption)
apply simp
apply simp
apply (rule reg_Preserved, assumption)
apply (rotate_tac 2, erule thin_rl, erule_tac x=x in allE, erule impE) apply (simp add: Equal_def EqualR_def DOM_def) apply fast
apply safe
apply (erule_tac x=xa in allE, erule impE) apply (simp add: Equal_def EqualR_def DOM_def)
apply (erule_tac x=Ra in allE, erule impE)
apply (subgoal_tac "GETr (aa, ba) xa = GETr (a, b) xa", clarsimp, fast)
apply (subgoal_tac "GETr (a, b) xa = GETr (aa, ba(x\<mapsto>\<^sub>fk)) xa") prefer 2 apply (simp add: Equal_def, clarsimp, erule EqualR_GETr)
apply (subgoal_tac "GETr (aa, ba(x\<mapsto>\<^sub>fk)) xa = GETr (aa, ba) xa", clarsimp)
apply (rule GETr_Update1) apply fast
apply fast
done

lemma Size_restricted_Letv:
"\<lbrakk>(C1, C2, C) \<in> Union; unmodified F (DOM C1) C1 h E h1; distinctFrom (DOM C) C h E F;
  regionsDistinct (DOM C) C h E; regionsExist C h E; Size_restricted n N n1 S M C1 h E; 
  Size_restricted n1 M n2 Sa Ma C2 h1 EE; \<forall> x. (x:DOM C2 \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>)
 \<rbrakk>
 \<Longrightarrow> Size_restricted n N n2 Sa Ma C h E"
apply (simp add: Size_restricted_def, clarsimp)
apply (subgoal_tac " \<exists> CS1 CS2. (E, h, C1, CS1) \<in> ContextSize \<and> (E, h, C2, CS2) \<in> ContextSize \<and> CS1 + CS2 = CS", clarsimp)
prefer 2 apply (erule Union_ContextSize, assumption)
apply (subgoal_tac "(EE, h1, C2, CS2) \<in> ContextSize")
apply (erule_tac x="CS2 + q" in allE, rotate_tac -1, erule_tac x=CS1 in allE, clarsimp)
apply (rule ContextSizePreservedEqual)
apply (erule SizePreserved)
apply (simp add: unmodified_def)
apply (rotate_tac 5, erule thin_rl, erule thin_rl, erule_tac x=l in allE, erule impE, safe)
apply (simp add: distinctFrom_def) apply (subgoal_tac "GETr C x = GETr C2 x") prefer 2 apply (erule UnionGet6, assumption)
                                   apply (subgoal_tac "x:DOM C") prefer 2 apply (erule Union_DOM2, assumption) 
                                   apply (erule_tac x=x in allE, clarsimp, fast)
apply (simp add: regionsDistinct_def)
  apply (erule_tac x=x in allE,erule_tac x=z in allE,erule_tac x=R in allE,erule_tac x=Rz in allE, erule impE)
  apply (rule, erule Union_DOM2, assumption)
  apply (rule, erule Union_DOM1, assumption)
  apply (rule, erule Union_Distinct, assumption, assumption)
  apply (subgoal_tac "GETr C x = GETr C2 x", clarsimp)
  apply (subgoal_tac "GETr C z = GETr C1 z", clarsimp)
  apply fast
  apply (erule UnionGet5, assumption)
  apply (erule UnionGet6, assumption)
  apply fast
apply fast
apply (rule Equal_reflexive)
done

lemma Size_restricted_Leti:
"\<lbrakk>(D, ({y}, emptyfinmap), C) \<in> Union; (G, D, GD) \<in> Union; unmodified F (DOM G) G h E h1;
  distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E;
  Size_restricted n N n1 S M G h E; Size_restricted n1 M n2 Sa Ma C h1 EE; \<forall> x. (x:DOM D \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>)
 \<rbrakk> \<Longrightarrow> Size_restricted n N n2 Sa Ma GD h E"
apply (subgoal_tac "Size_restricted n1 M n2 Sa Ma D h1 EE")
apply (erule Size_restricted_Letv, assumption+)
apply (simp add: Size_restricted_def, clarsimp)
apply (rotate_tac 6, erule thin_rl)
apply (subgoal_tac "(EE, h1, C, CS) \<in> ContextSize",clarsimp)
apply (erule ContextSize_IcontextIenv_irrelevant)
apply (erule Union.elims, clarsimp) apply (simp add: EqualR_def DOM_def)
apply simp
done

lemma Size_restricted_Letr:
"\<lbrakk>(D, ({}, emptyfinmap(y\<mapsto>\<^sub>fk)), C) \<in> Union; (G, D, GD) \<in> Union; unmodified F (DOM G) G h E h1;
  distinctFrom (DOM GD) GD h E F; regionsDistinct (DOM GD) GD h E; regionsExist GD h E;
  (RVal r, h1, Some (ListET k), R, S) \<in> reg;
  Size_restricted n N n1 S M G h E; Size_restricted n1 M n2 Sa Ma C h1 E\<lfloor>y:=r\<rfloor>
 \<rbrakk> \<Longrightarrow> Size_restricted n N n2 Sa Ma GD h E"

apply (simp add: Size_restricted_def, clarsimp)
apply (subgoal_tac " \<exists> CS1 CS2. (E, h, G, CS1) \<in> ContextSize \<and> (E, h, D, CS2) \<in> ContextSize \<and> CS1 + CS2 = CS", clarsimp)
prefer 2 apply (erule Union_ContextSize, assumption)
apply (subgoal_tac "(E\<lfloor>y:=r\<rfloor>, h1, C, CS2 + S) \<in> ContextSize")
apply (erule_tac x="CS2 + q" in allE, rotate_tac -1, erule_tac x=CS1 in allE, clarsimp)
apply (rule ContextSizeCONS)
apply (subgoal_tac "(RVal (renv E\<lfloor>y:=r\<rfloor> y), h1, GETr C y,R,S):reg",assumption)
  apply simp apply (subgoal_tac "GETr C y = Some(ListET k)", clarsimp) 
             apply (erule Union.elims, simp add: DOM_def GETr_def, clarsimp)
apply (subgoal_tac "(E\<lfloor>y:=r\<rfloor>, h1, D, CS2) \<in> ContextSize",assumption)
apply (rule ContextSizePreservedEqual)
apply (erule SizePreserved)
apply (simp add: unmodified_def)
apply (rotate_tac 7, erule thin_rl, erule thin_rl, erule_tac x=l in allE, erule impE, safe)
apply (simp add: distinctFrom_def) apply (subgoal_tac "GETr GD x = GETr D x") prefer 2 apply (erule UnionGet6,assumption)
                                   apply (subgoal_tac "x:DOM GD") prefer 2 apply (erule Union_DOM2, assumption) 
                                   apply (erule_tac x=x in allE, clarsimp, fast)
apply (simp add: regionsDistinct_def)
  apply (erule_tac x=x in allE,erule_tac x=z in allE,erule_tac x=Ra in allE,erule_tac x=Rz in allE, erule impE)
  apply (rule, erule Union_DOM2, assumption)
  apply (rule, erule Union_DOM1, assumption)
  apply (rule, erule Union_Distinct, assumption, assumption)
  apply (subgoal_tac "GETr GD x = GETr D x", clarsimp)
  apply (subgoal_tac "GETr GD z = GETr G z", clarsimp)
  apply fast
  apply (erule UnionGet5, assumption)
  apply (erule UnionGet6, assumption)
  apply fast
apply (subgoal_tac "y \<noteq> x", simp) apply (erule Union_Distinct) prefer 2 apply assumption apply (simp add: DOM_def)
apply (rule Equal_reflexive)
apply (erule Union.elims, simp add: DOM_def, clarsimp)
apply (subgoal_tac "Equal C (fst D, snd D(y\<mapsto>\<^sub>fk))",assumption)
  apply(erule Union.elims, clarsimp, simp add: Equal_def EqualR_def DOM_def,clarsimp)
  apply (rule, clarsimp) apply (simp add: GETr_def) 
  apply clarsimp apply (subgoal_tac "GETr (a, b(y\<mapsto>\<^sub>fk)) x = GETr (a, b) x", clarsimp)
    apply (rule GETr_Update1) apply fast
apply simp
done

lemma Union_regionsExist_CCt:
"\<lbrakk>(Cx, ({}, emptyfinmap(x\<mapsto>\<^sub>fk)), C) \<in> Union; 
  (Cx, ({}, emptyfinmap(t\<mapsto>\<^sub>fk)), Ct) \<in> Union; 
  regionsExist C h E; E\<lfloor>x\<rfloor> = Ref a
 \<rbrakk> \<Longrightarrow>  regionsExist Ct h E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>"
apply (erule Union.elims, erule Union.elims, simp add: regionsExist_def, safe)
apply (erule_tac x=xa in allE, clarsimp)
apply (subgoal_tac "xa \<noteq> t", simp, fast) apply (simp add: DOM_def, fast)
apply (subgoal_tac "xa=t", clarsimp) prefer 2 apply (simp add: DOM_def)
apply (erule_tac x=x in allE, clarsimp)
apply (rotate_tac -1, erule impE)
apply (simp add: DOM_def)
apply clarsimp
apply (erule reg.elims, simp_all, clarsimp)
apply (erule mLIST.elims, simp_all, clarsimp)
apply (subgoal_tac "GETr (ac,be) t = Some (ListET k)", clarsimp)
apply (rule, rule, erule regList)
apply simp
apply (rotate_tac -8) apply (erule_tac x=t in allE, erule impE)
apply (simp add: DOM_def)
apply (simp add: GETr_def)
done

lemma reg_F1: "\<lbrakk>(RVal (Ref a),h, Some(ListET k),R,n):reg\<rbrakk> \<Longrightarrow> (RVal (h\<lfloor>a\<diamondsuit>F1\<rfloor>),h,Some(ListET k), R-{a},n-k):reg"
apply (erule reg.elims, simp_all, clarsimp)
apply (erule mLIST.elims, simp_all, clarsimp)
apply (erule regList, simp)
done

lemma Union_regionsDistinct_CCt:
"\<lbrakk>(Cx, ({}, emptyfinmap(x\<mapsto>\<^sub>fk)), C) \<in> Union;
  (Cx, ({}, emptyfinmap(t\<mapsto>\<^sub>fk)), Ct) \<in> Union;
  X \<subseteq> insert t (DOM Cx); E\<lfloor>x\<rfloor> = Ref a; regionsExist C h E;
  regionsDistinct (insert x (DOM Cx)) C h E
 \<rbrakk> \<Longrightarrow> regionsDistinct X Ct h E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>"
apply (subgoal_tac "x \<notin> DOM Cx ") prefer 2 apply (erule Union.elims,clarsimp, simp add: DOM_def)
apply (subgoal_tac "t \<notin> DOM Cx ") prefer 2 apply (rotate_tac 1, erule Union.elims,clarsimp, simp add: DOM_def)
apply (erule Union.elims, erule Union.elims, simp add: regionsDistinct_def, clarsimp)
apply (case_tac "xa=t", clarsimp)
apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE, simp, rotate_tac -1)
apply (subgoal_tac "\<exists> R S . (RVal (E\<lfloor>x\<rfloor>),h, GETr(ac,bb) x,R,S):reg", clarsimp)
prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=x in allE) apply (simp add: DOM_def)
apply (subgoal_tac "(RVal (h\<lfloor>a\<diamondsuit>F1\<rfloor>),h,Some(ListET k), R-{a},S-k):reg") 
prefer 2 apply (rule reg_F1) apply(subgoal_tac "GETr (ac, bb) x = Some (ListET k)", clarsimp) 
                             apply (rotate_tac 9, erule_tac x=x in allE, erule impE, simp add: DOM_def) apply (simp add: GETr_def)
apply (subgoal_tac "Rx=R-{a} \<and> Sx=S-k", clarsimp)
apply (erule_tac x=R in allE, rotate_tac -1, erule_tac x=Rxx in allE, rotate_tac -1, erule impE)
apply (subgoal_tac "xx:DOM (ac,bc)", clarsimp, fast)
apply (subgoal_tac "xx : insert t (DOM (ac,bc))", fast) apply (erule SubsetTriv,assumption)
apply (rotate_tac -2) apply fast
apply (erule reg_Unique)
apply (subgoal_tac "GETr (ac, be) t = Some (ListET k)",clarsimp)
apply (rotate_tac -7, erule_tac x=t in allE, erule impE, simp add: DOM_def) apply (simp add: GETr_def)
(*case xa \<noteq> t*)
apply (case_tac "xx=t", clarsimp)
apply (erule_tac x=xa in allE, rotate_tac -1, erule_tac x=x in allE, simp, rotate_tac -1)
apply (subgoal_tac "\<exists> R S . (RVal (E\<lfloor>x\<rfloor>),h, GETr(ac,bb) x,R,S):reg", clarsimp)
prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=x in allE) apply (simp add: DOM_def)
apply (subgoal_tac "(RVal (h\<lfloor>a\<diamondsuit>F1\<rfloor>),h,Some(ListET k), R-{a},S-k):reg") 
prefer 2 apply (rule reg_F1) apply(subgoal_tac "GETr (ac, bb) x = Some (ListET k)", clarsimp) 
                             apply (rotate_tac 9, erule_tac x=x in allE, erule impE, simp add: DOM_def) apply (simp add: GETr_def)
apply (subgoal_tac "Rxx=R-{a} \<and> Sxx=S-k", clarsimp)
apply (erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=R in allE, rotate_tac -1, erule impE)
apply (subgoal_tac "xa:DOM (ac,bc)", clarsimp, fast)
apply (subgoal_tac "xa : insert t (DOM (ac,bc))", fast) apply (erule SubsetTriv,assumption)
apply (rotate_tac -2) apply fast
apply (erule reg_Unique)
apply (subgoal_tac "GETr (ac, be) t = Some (ListET k)",clarsimp)
apply (rotate_tac -7, erule_tac x=t in allE, erule impE, simp add: DOM_def) apply (simp add: GETr_def)
(*case xa \<noteq> t \<and> xx \<noteq> t*)
apply clarsimp
apply (erule_tac x=xa in allE, rotate_tac -1, erule_tac x=xx in allE, rotate_tac -1, 
       erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Rxx in allE, rotate_tac -1, erule impE,clarsimp)
apply (subgoal_tac "xa:DOM (ac,bc)", clarsimp)
apply (subgoal_tac "xx:DOM (ac,bc)", clarsimp, fast)
apply (subgoal_tac "xx : insert t (DOM (ac,bc))", fast) apply (erule SubsetTriv,assumption)
apply (subgoal_tac "xa : insert t (DOM (ac,bc))", fast) apply (erule SubsetTriv,assumption)
apply simp
done

lemma Union_distinctFrom_CCt:
"\<lbrakk>(Cx, ({}, emptyfinmap(x\<mapsto>\<^sub>fk)), C) \<in> Union;
  (Cx, ({}, emptyfinmap(t\<mapsto>\<^sub>fk)), Ct) \<in> Union; E\<lfloor>x\<rfloor> = Ref a; regionsExist C h E;
  distinctFrom (insert x (DOM Cx)) C h E F\<rbrakk>
       \<Longrightarrow> distinctFrom (insert t (DOM Cx)) Ct h E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> F"
apply (erule Union.elims, erule Union.elims, simp add: distinctFrom_def,safe)
(*xa=t*)
apply (erule_tac x=x in allE, clarsimp)
apply (subgoal_tac "\<exists> R S . (RVal (Ref a), h, GETr (ac, bb) x, R, S) \<in> reg", clarsimp)
prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, clarsimp) apply (simp add: DOM_def)
apply (erule_tac x=R in allE, erule impE, fast)
apply (subgoal_tac "(RVal (h\<lfloor>a\<diamondsuit>F1\<rfloor>),h,Some(ListET k), R-{a},S-k):reg")
prefer 2 apply (rule_tac reg_F1) apply (rotate_tac 5, erule_tac x=x in allE, simp add: DOM_def GETr_def)
apply (subgoal_tac "Rx = R-{a} \<and> Sx = S-k", clarsimp, rotate_tac -8, fast)
apply (erule reg_Unique)
apply (rotate_tac -6, erule_tac x=t in allE, simp add: DOM_def GETr_def)
(* xa : DOM (ac,bc)*)
apply (subgoal_tac "xa \<noteq> t", simp)
apply (erule_tac x=xa in allE, clarsimp,fast)
apply (simp add: DOM_def,fast)
done

lemma Union_distinctFrom_CtC:
"\<lbrakk>(Cx, ({}, emptyfinmap(x\<mapsto>\<^sub>fk)), C) \<in> Union;
  (Cx, ({}, emptyfinmap(t\<mapsto>\<^sub>fk)), Ct) \<in> Union;
   Y \<subseteq> insert t (DOM Cx);
   distinctFrom Y Ct h E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> R\<rbrakk> \<Longrightarrow> distinctFrom (Y - {t}) C h E R"
apply (erule Union.elims, erule Union.elims, simp add: distinctFrom_def,safe)
apply (erule_tac x=xa in allE, clarsimp)
apply (erule_tac x=xa in allE, erule impE) apply (subgoal_tac "xa:insert t (DOM (ac, bc))",fast) apply (erule SubsetTriv, assumption)
apply (clarsimp, fast)
done

lemma Union_unmodified_CtC:
"\<lbrakk>(Cx, ({}, emptyfinmap(x\<mapsto>\<^sub>fk)), C) \<in> Union;
  (Cx, ({}, emptyfinmap(t\<mapsto>\<^sub>fk)), Ct) \<in> Union;
   Z \<subseteq> insert t (DOM Cx); 
  E\<lfloor>x\<rfloor> = Ref a;  regionsExist C h E;
  unmodified F Z Ct h E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> hh\<rbrakk> \<Longrightarrow> unmodified F (insert x (Z - {t})) C h E hh"
apply (erule Union.elims, erule Union.elims, simp add: unmodified_def,safe)
apply (erule_tac x=l in allE, erule impE, safe)
apply (case_tac "z=t", clarsimp)
(*z=t*)
apply (subgoal_tac "\<exists> R S . (RVal (Ref a), h, GETr (ac, bb) x, R, S) \<in> reg", clarsimp)
prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, clarsimp) apply (simp add: DOM_def)
apply (rotate_tac -5, erule_tac x=x in allE,erule_tac x=R in allE, erule impE, clarsimp) apply (rule_tac x=S in exI, assumption)
apply (subgoal_tac "(RVal (h\<lfloor>a\<diamondsuit>F1\<rfloor>),h,Some(ListET k), R-{a},S-k):reg")
prefer 2 apply (rule_tac reg_F1) apply (rotate_tac 10, erule_tac x=x in allE, simp add: DOM_def GETr_def)
apply (subgoal_tac "Rz = R-{a} \<and> Sz = S-k", clarsimp)
apply (erule reg_Unique)
apply (rotate_tac 9, erule_tac x=t in allE, simp add: DOM_def GETr_def)
(*z \<noteq>t*)
apply clarsimp 
apply (rotate_tac -5, erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, safe)
apply (erule_tac x=z in allE, erule impE)
apply (subgoal_tac "z:DOM (ac, be)", simp add: DOM_def) apply (erule reg_DOM)
apply (clarsimp, fast)
done

lemma Union_FL_bounded_CtC:
"\<lbrakk>(Cx, ({}, emptyfinmap(x\<mapsto>\<^sub>fk)), C) \<in> Union;
  (Cx, ({}, emptyfinmap(t\<mapsto>\<^sub>fk)), Ct) \<in> Union;
   Z \<subseteq> insert t (DOM Cx); 
  E\<lfloor>x\<rfloor> = Ref a;  regionsExist C h E;
  FL_bounded FF F Z Ct h E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>\<rbrakk> \<Longrightarrow> FL_bounded FF F (insert x (Z - {t})) C h E"
apply (erule Union.elims, erule Union.elims, simp add: FL_bounded_def,safe)
apply (subgoal_tac "xa : {l. \<exists>z. z \<in> Z \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> z), h, GETr (ae, be) z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", clarsimp)
prefer 2 apply (rotate_tac 8, erule thin_rl, erule thin_rl, rotate_tac 4, erule thin_rl, erule thin_rl)
         apply (subgoal_tac "xa : F \<union> {l. \<exists>z. z \<in> Z \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> z), h, GETr (ae, be) z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}",fast) apply (erule SubsetTriv, assumption)
apply (case_tac "z=t", clarsimp)
(*z=t*)
apply (subgoal_tac "\<exists> R S . (RVal (Ref a), h, GETr (ac, bb) x, R, S) \<in> reg", clarsimp)
prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, clarsimp) apply (simp add: DOM_def)
apply (rule_tac x=x in exI,clarsimp)
apply (rule_tac x=R in exI)
apply (rule, fast)
apply (subgoal_tac "(RVal (h\<lfloor>a\<diamondsuit>F1\<rfloor>),h,Some(ListET k), R-{a},S-k):reg")
prefer 2 apply (rule_tac reg_F1) apply (rotate_tac 10, erule_tac x=x in allE, simp add: DOM_def GETr_def)
apply (subgoal_tac "Rz = R-{a} \<and> Sz = S-k", clarsimp)
apply (erule reg_Unique)
apply (rotate_tac 9, erule_tac x=t in allE, simp add: DOM_def GETr_def)
(*z \<noteq>t*)
apply clarsimp 
apply (rule_tac x=z in exI, clarsimp)
apply (erule_tac x=z in allE, erule impE)
apply (subgoal_tac "z:DOM (ac, be)", simp add: DOM_def) apply (erule reg_DOM)
apply (clarsimp, fast)
done

lemma Equal_Emptyfinmap:
"\<lbrakk>Equal (A, emptyfinmap(x\<mapsto>\<^sub>fk)) (B, ba(xa\<mapsto>\<^sub>fka)); xa \<notin> DOM (B,ba)\<rbrakk> \<Longrightarrow> Equal (A,emptyfinmap) (B,ba) \<and> x=xa \<and> k=ka"
by (simp add: Equal_def EqualR_def DOM_def GETr_def,auto)

lemma ContextSize_Emptyfinmap: "\<lbrakk>(E, h, C, S) \<in> ContextSize; Equal (A, emptyfinmap) C\<rbrakk> \<Longrightarrow> S = 0"
by (erule ContextSize.elims, clarsimp, clarsimp, simp add: Equal_def EqualR_def DOM_def)

lemma Union_Size_restricted_CtC:
"\<lbrakk>(Cx, ({}, emptyfinmap(x\<mapsto>\<^sub>fk)), C) \<in> Union;
  (Cx, ({}, emptyfinmap(t\<mapsto>\<^sub>fk)), Ct) \<in> Union; E\<lfloor>x\<rfloor> = Ref a;
  Size_restricted (n + k) N m S M Ct h E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>
 \<rbrakk> \<Longrightarrow> Size_restricted n N m S M C h E"
apply (simp add: Size_restricted_def,safe)
apply (subgoal_tac "\<exists> CS1 CS2. (E, h, Cx, CS1) \<in> ContextSize \<and> (E, h, ({}, emptyfinmap(x\<mapsto>\<^sub>fk)), CS2) \<in> ContextSize \<and> CS1 + CS2 = CS",clarsimp)
prefer 2 apply (erule Union_ContextSize, assumption) 
apply (rotate_tac -1)
apply (erule ContextSize.elims, clarsimp)
  apply (simp add: Equal_def EqualR_def DOM_def)
  apply clarsimp 
  apply (erule reg.elims,clarsimp) prefer 2 apply clarsimp
  apply (subgoal_tac "ma = 0 \<and> xa=x \<and> k=ka",clarsimp)
  apply (erule mLIST.elims,clarsimp, clarsimp) 
  apply (subgoal_tac "(E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>, h, ({}, emptyfinmap(t\<mapsto>\<^sub>fk)), k * na) \<in> ContextSize")
apply (subgoal_tac "(E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>, h, Cx, CS1) \<in> ContextSize")
apply (erule_tac x=q in allE) apply (rotate_tac -1, erule_tac x="CS1 + k * na" in allE)
apply (erule impE) apply (erule ContextSize_split, assumption, assumption)
apply (simp add: GETr_def)
apply (erule ContextSizePreservedEqual) apply (subgoal_tac "xa \<noteq> t", simp) 
apply (rotate_tac 1, erule Union.elims, clarsimp,simp add: DOM_def) apply (rule Equal_reflexive)
    (*the proof of (E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>, h, ({}, emptyfinmap(t\<mapsto>\<^sub>fk)), k * na) \<in> ContextSize*)
    apply (rule ContextSizeCONS) 
    apply (subgoal_tac "(RVal (renv E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> t), h, GETr ({}, emptyfinmap(t\<mapsto>\<^sub>fk)) t,X, ka * na) \<in> reg", assumption, simp add: GETr_def)
    apply (erule regList, simp)
    apply (subgoal_tac "(E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>, h, ({},emptyfinmap), 0) \<in> ContextSize", assumption)
    apply (rule ContextSizeNIL) apply (simp add: Equal_def EqualR_def) apply (rule, simp, simp, simp)
    apply (simp add: DOM_def)
    apply simp apply (subgoal_tac "Equal ({}, emptyfinmap(t\<mapsto>\<^sub>fk)) ({}, emptyfinmap(t\<mapsto>\<^sub>fk))",assumption) apply(simp add: Equal_reflexive)
    apply (simp add: GETr_def)
apply (subgoal_tac "Equal ({},emptyfinmap) (aa,ba) \<and> x=xa \<and> k=ka")
prefer 2 apply (erule Equal_Emptyfinmap, assumption)
apply clarsimp apply (rotate_tac 7) apply (erule ContextSize_Emptyfinmap,assumption)
done

lemma Union_Result_bounded_CtC:
"\<lbrakk>(Cx, ({}, emptyfinmap(x\<mapsto>\<^sub>fk)), C) \<in> Union;
  (Cx, ({}, emptyfinmap(t\<mapsto>\<^sub>fk)), Ct) \<in> Union; 
  E\<lfloor>x\<rfloor> = Ref a; regionsExist C h E;
  Result_bounded R F Ct h E\<lfloor>t:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>
 \<rbrakk> \<Longrightarrow> Result_bounded R F C h E"
apply (simp add: Result_bounded_def)
apply (rule, rule, erule_tac x=l in allE,erule impE, simp, erule disjE)
(* l:F*)
apply simp
(*l \<notin>F *)
apply (subgoal_tac "\<exists>x. x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (case_tac "xa = t", simp)
(*xa=t*)
apply (rule_tac x=x in exI)
apply (subgoal_tac "x:DOM C", simp add: regionsExist_def)
apply (erule_tac x=x in allE, clarsimp)
apply (rule_tac x=Rxa in exI, rule, rule_tac x=Sxa in exI, simp)
apply (erule reg.elims, erule reg.elims, clarsimp) apply (rotate_tac -4, erule mLIST.elims,clarsimp,clarsimp)
  apply (subgoal_tac "n=nb \<and> Ra = X",clarsimp) apply (erule mLIST_Unique,assumption)
  apply clarsimp
  apply clarsimp
  apply (rule Union_DOM2) prefer 2 apply assumption apply (simp add: DOM_def)
(* xa \<noteq> t*)
apply (rule_tac x=xa in exI)
apply (subgoal_tac "xa:DOM Cx", simp)
apply (subgoal_tac "xa:DOM C", simp)
apply (subgoal_tac "GETr C xa = GETr Ct xa", clarsimp,fast)
apply (erule Union.elims, erule Union.elims, clarsimp)
apply (rule Union_DOM1) prefer 2 apply (assumption, assumption)
apply (rotate_tac 1, erule Union.elims, clarsimp, simp add:DOM_def)
done

end
