(*<*)
theory CountLeafs = mTreeList:
(*>*)

subsection{*Counting the leafs of a tree*}

text {* Camelot code:
\begin{verbatim}
type itree = Leaf of int | Node of itree * itree
type ilist = Nil | Cons of int * ilist

let countLeafs t = match t with Leaf(i) => 1
                              | Node(l,r) => (countLeafs l) + (countLeafs r)

\end{verbatim}
Grail code:
\begin{verbatim}
   method public static int countLeafs (TreeList$dia_0 t) =
   let fun f:countLeafs(TreeList$dia_0 t) =
         let val v1 = getfield t <int TreeList$dia_0.$>
         in if v1 = 0 then f:0(t) else f:1(t)
         end

       fun f:1(TreeList$dia_0 t) =
         let val v4 = getfield t <TreeList$dia_0 TreeList$dia_0.f1>
             val v3 = getfield t <TreeList$dia_0 TreeList$dia_0.f2>
             val v2 = invokestatic <int TreeList.countLeafs (TreeList$dia_0)> (v4)
             val v1 = invokestatic <int TreeList.countLeafs (TreeList$dia_0)> (v3)
         in add v2 v1 end

       fun f:0(TreeList$dia_0 t) =
         let val v1 = getfield t <int TreeList$dia_0.f0>
         in 1
         end
   in f:countLeafs(t)
   end
\end{verbatim}
*}

syntax b_  :: iname
       t_  :: rname 
       v1_ :: iname 
       v2_ :: iname 
       v3_ :: rname
       v4_ :: rname
       fcountLeafs :: funame
       fzero :: funame
       fone  :: funame
       countLeafs :: mname

translations
 "b_" == "(In ''b'') "
 "v1_" == "(In ''v1'') "
 "v2_" == "(In ''v2'') "
 "v3_" == "(RN ''v3'') "
 "v4_" == "(RN ''v4'') "
 "t_" == "(RN ''t'') "
 "fcountLeafs" == "(FN ''fcountLeafs'') "
 "fzero" == "(FN ''f_zero'')"
 "fone" == "(FN ''f_one'')"
 "countLeafs" == "(MN ''countLeafs'')"

axioms Meth_CL: 
"methtable DIAM countLeafs = ([RNpar t_], LET  v1_ = GetFi t_ DOLLAR; 
                                          b_ = Primop (\<lambda> z y. if z = 0 then 1 else 0) v1_ v1_
                                    IN IF b_ THEN CALL fzero ELSE CALL fone END)"
axioms FunFzero: "funtable fzero = LET v1_ = GetFi t_ F0 IN expr.Int 1 END"
axioms FunFone: "funtable fone = LET rf v4_ = GetFr t_ F1;
                                     rf v3_ = GetFr t_ F2;
                                        v2_ = DIAM\<bullet>countLeafs([RNarg v4_]);
                                        v1_ = DIAM\<bullet>countLeafs([RNarg v3_])
                                 IN Primop (\<lambda> x y . x + y) v2_ v1_ 
                                 END"

constdefs  countLeafsSpec::bool
" countLeafsSpec == (MS DIAM countLeafs = 
     (\<lambda> args E h hh v p. (\<forall> y Ups ll X. args =[RNarg y] \<and> (E\<lfloor>y\<rfloor> = Ref ll \<and> (Ups,ll,X,h): mTree) \<longrightarrow> 
                                   (v = IVal (2 ^ Ups) \<and> same (Dom h) h hh))))"

lemma countLeafsVDMcontext:
"countLeafsSpec \<Longrightarrow> goodContext {(DIAM\<bullet>countLeafs([RNarg v3_]), MS DIAM countLeafs [RNarg v3_]), 
                                 (DIAM\<bullet>countLeafs([RNarg v4_]), MS DIAM countLeafs [RNarg v4_])}"
apply (simp add: goodContext_def) apply clarsimp 
apply (simp add: Meth_CL,safe)
apply (rule vdmC_conseq)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: FunFzero)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: FunFone)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp)
apply (rule vdmC_basics)+
defer 1
apply (rule vdmC_conseq)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: FunFzero)
apply (rule vdmC_basics)+
apply (rule Call1)
apply (simp add: FunFone)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp)
apply (rule vdmC_basics)+
apply (rule vdm_ax, simp)
apply (rule vdmC_basics)+

txt {*end of simple VCG*}

apply (simp add: IMPLIES_def countLeafsSpec_def newframe_env_def evalARGS_def, clarsimp) apply(erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, clarsimp)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule primElims, simp add: valExpr_predicates)
apply clarsimp
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letiComb_def, clarsimp)
apply (erule primElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply clarsimp

txt {* end of extended vcg, now discharge the 2 side conditions*}
txt {*Case CONS*}
apply (erule mTree.elims, simp_all, clarsimp)
apply (erule_tac x=n in allE) apply (erule impE) apply (rule, assumption)
apply (erule_tac x=n in allE) apply (erule impE) apply (rule)
apply (rule mTreeSame) prefer 2 apply (subgoal_tac "same X2 ha h1", assumption) apply clarsimp apply (erule SameSubset) 
  apply (erule mTreeDom) apply assumption
apply simp
apply clarsimp apply (rule SameTransitive) apply assumption apply assumption apply (erule SameImpliesDomsubset)
txt{*case NIL*}
apply (erule mTree.elims, simp_all)

txt {*NOW THE SAME PROOF AGAIN!!!*}
apply (simp add: IMPLIES_def countLeafsSpec_def newframe_env_def evalARGS_def, clarsimp) apply(erule thin_rl)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, clarsimp)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule primElims, simp add: valExpr_predicates)
apply clarsimp
prefer 2
apply clarsimp
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (simp add: letiComb_def, clarsimp)
apply (erule primElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply clarsimp

txt {* end of extended vcg, now discharge the 2 side conditions*}
txt {*Case CONS*}
apply (erule mTree.elims, simp_all, clarsimp)
apply (erule_tac x=n in allE) apply (erule impE) apply (rule, assumption)
apply (erule_tac x=n in allE) apply (erule impE) apply (rule)
apply (rule mTreeSame) prefer 2 apply (subgoal_tac "same X2 ha h1", assumption) apply clarsimp apply (erule SameSubset) 
  apply (erule mTreeDom) apply assumption
apply simp
apply clarsimp apply (rule SameTransitive) apply assumption apply assumption apply (erule SameImpliesDomsubset)
txt{*case NIL*}
apply (erule mTree.elims, simp_all)
done

lemma countLeafsVDMcontext1:"countLeafsSpec \<Longrightarrow> goodContext {(DIAM\<bullet>countLeafs([RNarg v3_]), MS DIAM countLeafs [RNarg v3_])}"
apply (insert countLeafsVDMcontext, simp)
apply (subgoal_tac "{(DIAM\<bullet>countLeafs([RNarg v3_]), MS DIAM countLeafs [RNarg v3_])} = 
                    ({(DIAM\<bullet>countLeafs([RNarg v3_]), MS DIAM countLeafs [RNarg v3_]), (DIAM\<bullet>countLeafs([RNarg v4_]), MS DIAM countLeafs [RNarg v4_])} -
                                 {(DIAM\<bullet>countLeafs([RNarg v4_]), MS DIAM countLeafs [RNarg v4_])})", simp)
apply (erule GoodContextCut) apply simp
apply fastsimp
done

lemma countLeafsCorrect:"countLeafsSpec \<Longrightarrow> \<rhd> (DIAM\<bullet>countLeafs([RNarg a])) : (MS DIAM countLeafs [RNarg a])"
apply (subgoal_tac "({(DIAM\<bullet>countLeafs([RNarg v3_]), MS DIAM countLeafs [RNarg v3_])} - {(DIAM\<bullet>countLeafs([RNarg v3_]), MS DIAM countLeafs [RNarg v3_])}) \<rhd> (DIAM\<bullet>countLeafs([RNarg a])) : (MS DIAM countLeafs [RNarg a])", simp)
apply (rule Adapt)
apply (erule countLeafsVDMcontext1)
apply simp
done

constdefs countLeafsSpecContext::"ARGTYPE \<Rightarrow> vdmassn"
"countLeafsSpecContext == 
     (\<lambda> args E h hh v p. (\<forall> y Ups ll X L l Y. (args = [RNarg y] \<and> E\<lfloor>y\<rfloor> = Ref ll \<and> (Ups,ll,X,h): mTree \<and> (L,l,Y,h): mList \<and> X \<inter> Y = {}) \<longrightarrow> 
                          (v = IVal (2 ^ Ups) \<and> same (Dom h) h hh \<and> (L,l,Y,hh): mList)))"

lemma countLeafsCorrectContext:"countLeafsSpec \<Longrightarrow> \<rhd> (DIAM\<bullet>countLeafs([RNarg a])) : countLeafsSpecContext [RNarg a]"
apply (rule vdmC_conseq)
apply (erule countLeafsCorrect)
apply (simp add: countLeafsSpec_def countLeafsSpecContext_def IMPLIES_def, safe)
apply fast+
apply (erule_tac x=Ups in allE, clarsimp)
apply (erule impE, rule, assumption, clarsimp)
apply (rule mListSame, assumption)
apply (erule SameSubset) apply (erule mListDom)
done
(*<*)
end
(*>*)
