theory AppendDAssU = DAss_rulesU:

(*DAssAdaptU currently not needed (will  contain the proof of the ADAPT lemma below*)

subsection{*Append function*}

text {* Camelot code:
\begin{verbatim}
type ilist = !Nil | Cons of int * ilist
let append l1 l2 = match l1 with Nil => l2
                               | Cons(h,t) => Cons(h,append t l2)
\end{verbatim}

Grail code:
\begin{verbatim}
method public static TreeListNIL$dia_0 append (TreeListNIL$dia_0 l1, TreeListNIL$dia_0 l2) =
  let fun f:append(TreeListNIL$dia_0 l1, TreeListNIL$dia_0 l2) =
         if l1 = null[TreeListNIL$dia_0]
         then f:0(l2)
         else f:1(l1, l2)

      fun f:1(TreeListNIL$dia_0 l1, TreeListNIL$dia_0 l2) =
      let val v3 = getfield l1 <int TreeListNIL$dia_0.f0>
          val v2 = getfield l1 <TreeListNIL$dia_0 TreeListNIL$dia_0.f1>
          val l1 = invokestatic <TreeListNIL$dia_0 TreeListNIL.append (TreeListNIL$dia_0, TreeListNIL$dia_0)> (v2, l2)
      in invokestatic <TreeListNIL$dia_0 TreeListNIL$dia_0.make (int, int, TreeListNIL$dia_0)> (1, v3, l1)
      end

      fun f:0(TreeListNIL$dia_0 l2) = l2
   in
      f:append(l1, l2)
   end
\end{verbatim}
*}

syntax b_    :: iname
       v3_   :: iname
       v2_   :: rname
       l1_   :: rname 
       l2_  :: rname 

       fAppend :: funame
       fzeroAppend :: funame
       foneAppend  :: funame
       Append :: mname

translations
 "b_" == "(In ''b'') "
 "v3_" == "(In ''v3'') "
 "v2_" == "(RN ''v2'') "
 "l1_" == "(RN ''l1'') "
 "l2_" == "(RN ''l2'') "
 "fAppend" == "(FN ''fAppend'') "
 "fzeroAppend" == "(FN ''f_zeroAppend'')"
 "foneAppend" == "(FN ''f_oneAppend'')"
 "Append" == "(MN ''Append'')"

axioms Meth_Append: 
"methtable DIAM Append = ([RNpar l1_,RNpar l2_], CALL fAppend)"
lemma "methtable DIAM Append = ([RNpar l1_,RNpar l2_], CALL fAppend)" by (simp add: Meth_Append)

axioms Fun_fAppend:
"funtable fAppend = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l1_ l1_
                    IN IF b_ THEN CALL fzeroAppend ELSE CALL foneAppend END"
lemma "funtable fAppend = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l1_ l1_
                    IN IF b_ THEN CALL fzeroAppend ELSE CALL foneAppend END"
by (simp add: Fun_fAppend)
  
axioms Fun_foneAppend:
"funtable foneAppend =
       LET v3_ = GetFi l1_ F0;
        rf v2_ = GetFr l1_ F1;
        rf l1_ = DIAM\<bullet>Append ([RNarg v2_, RNarg l2_])
       IN  DIAM\<bullet>Make_IID ([VALarg (IVal 1),INarg v3_, RNarg l1_]) END"
lemma "funtable foneAppend =
       LET v3_ = GetFi l1_ F0;
        rf v2_ = GetFr l1_ F1;
        rf l1_ = DIAM\<bullet>Append ([RNarg v2_, RNarg l2_])
       IN  DIAM\<bullet>Make_IID ([VALarg (IVal 1),INarg v3_, RNarg l1_]) END"
by (simp add: Fun_foneAppend)

axioms Fun_fzeroAppend:
"funtable fzeroAppend = RVar l2_"
lemma  "funtable fzeroAppend = RVar l2_"
by (simp add: Fun_fzeroAppend)

text {*Here is what Steffen's analysis claims:
 \begin{verbatim}
  append        : <0>, ilist[Nil(<0>)|Cons(int,#,<1>)] -> ilist[Nil(<0>)|Cons(int,#,<0>)] 
                    -> ilist[Nil(<0>)|Cons(int,#,<0>)], <0>
 \end<verbatim} *}

text {*This corresponds to the following specification, formalised from the viewpoint of the
       method body: the context (in second parameter of @{text DAss}) is the context in which
       the method body may be typed*}
constdefs Append_Spec::vdmassn
"Append_Spec == DAss {l1_,l2_} 0 (emptyfinmap(l1_ \<mapsto>\<^sub>f(ListET 1))(l2_ \<mapsto>\<^sub>f(ListET 0))) (ListET 0) 0"

text {*In order to prove the body correct we define a context which contains a single entry.*}
constdefs AppendContext:: vdmcontext
"AppendContext \<equiv> {(DIAM\<bullet>Append([RNarg l1_,RNarg l2_]), Append_Spec)}"

lemma Append_DAss:
"\<lbrakk>G = AppendContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable DIAM Append) : Append_Spec"
apply (simp add: Meth_Append)
apply (simp add: Meth_Append Append_Spec_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call)
apply (simp add: Fun_fAppend)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*first branch*)
apply (rule DA_Call)
apply (simp only: Fun_fzeroAppend)
apply (rule DA_RVar)
apply (simp add: GETr_def)
apply simp
(*second branch*)
apply (rule DA_Call)
apply (simp only:  Fun_foneAppend)
apply (rule DA_Let_HD)
apply (rule DA_Let_TL) apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp apply simp
apply (rule DA_Letr)
(*invocation of append*)
apply (rule ADAPT)
  (*lookup from context*)
  apply (simp add: AppendContext_def Append_Spec_def) apply (rule,simp,simp)
  apply simp apply simp
  (*calculation of renaming*)
  apply (rule getRenamingRVar)
  apply (rule getRenamingRVar)
  apply (rule getRenamingNIL)
  (*verify that context at applications site arises from context in
    specification via the renaming*)
  apply (rule RenContextCONS,fastsimp) 
    apply (rule GETr_Update2, simp add: GETr_def,simp)
    apply simp
    apply (simp add: GETr_def) 
  apply (rule RenContextCONS,fastsimp) apply (simp add: GETr_def)
    apply simp apply (rule GETr_Update2, simp add: GETr_def, fastsimp)
  apply (rule RenContextNIL) 
  (*the last side condition of ADAPT*)
  apply simp 
(*invocation of append now finished*)
(*invocation of make*)
apply (rule DA_Make_IID)
apply (simp add: DOM_def GETr_def)
apply (simp add: DOM_def GETr_def)
apply (simp add: DOM_def GETr_def)
apply (simp add: DOM_def GETr_def)
apply (simp add: DOM_def GETr_def)
apply fastsimp
apply (simp add: DOM_def GETr_def)
apply (simp add: DOM_def GETr_def)
apply fastsimp
apply fastsimp
done

text {*We require the specification table at method @{text Append} to contain entries
       which relate to the assertion @{text Append_Spec}.*}
constdefs AppTable::bool
"AppTable == 
 (MS DIAM Append = (\<lambda> args E h hh v p . Append_Spec (newframe_env Nullref (fst (methtable DIAM Append)) args E) h hh v p))"

text {*The parameter passing at the invocation site mathces the requirements of lemma 
       @{text DAss_Envs_same_on_U}, hence we have the following*}
lemma Append_Spec_Framecorrect:
"AppTable ==> Append_Spec = MS DIAM Append [RNarg l1_, RNarg l2_]"
apply (simp add: AppTable_def Meth_Append newframe_env_def evalARGS_def)
apply (rule, rule, rule, rule, rule, simp add: Append_Spec_def)
apply (rule DAss_Envs_same_on_U)
apply (simp_all add: DOM_def)
apply auto 
done

text {*For a specification table satisfying \verb|AppendContext| is a good context.*}
lemma AppendContext_good: "AppTable \<Longrightarrow> goodContext AppendContext"
apply (simp add: goodContext_def AppendContext_def, rule)
apply (erule  Append_Spec_Framecorrect)
apply clarsimp
apply (rule vdm_conseq)
apply (rule Append_DAss)
apply (simp add: AppendContext_def)
apply clarsimp
apply (simp add: AppTable_def Append_Spec_def)
apply (rule DAss_PConst)
apply (simp add: Append_Spec_def)
done

text {*Thus, we can prove that an arbitrary invocation of @{text App} honours
       its entry in the specification table, in the empty VDM context.*}
theorem "\<lbrakk>AppTable\<rbrakk> \<Longrightarrow> \<rhd> DIAM\<bullet>Append([RNarg x, RNarg y]): MS DIAM Append [RNarg x, RNarg y]"
apply (rule GCInvs)
apply (erule AppendContext_good)
apply (simp_all add: AppendContext_def)
apply (rule, simp)
apply (insert Append_Spec_Framecorrect, fastsimp)
done 

end
