header {*Parameter adaptation for static methods*}
(*<*)
theory AdaptVirt = VDMderivedPC:
(*>*)

consts MS :: "cname \<Rightarrow> mname \<Rightarrow> ARGTYPE \<Rightarrow> vdmassn" 

text {*The fact that the specification of the body mentions both "C" and "c"
      might make it difficult to apply*}

constdefs goodContext::"vdmcontext \<Rightarrow> bool" 
"goodContext G == 
  (\<forall> A c m y . (A\<diamondsuit>m(y), MS c m y) : G \<longrightarrow> 
             (\<forall> x C d. G \<rhd> (snd(methtable C m)) : (\<lambda> E h hh v p . (\<forall> E'. classOf E' h A C \<and> 
                                                                               E = newframe_env (E'\<lfloor>A\<rfloor>) (fst (methtable C m)) x E'  \<longrightarrow> 
                                                                MS d m x (E') h hh v (\<langle>5 0 1 1\<rangle> \<oplus> p)))))"

text {*The following adaptation lemma allows to change actual parameters to z,
        leaving context G unchanged.*}
lemma goodAdapt: "\<lbrakk> (A\<diamondsuit>m(y), MS c m y) : G; goodContext G\<rbrakk> \<Longrightarrow> G \<rhd> (A\<diamondsuit>m(z)) : MS c m z"
apply (rule vdm_invoke, clarsimp)
apply (rule CtxtWeakSingleton, simp add: goodContext_def) apply fast
done


text {* The following adaptation rule is more useful than the above since 
        the context decreases -- in the end we will want to prove specifications 
        in the empty context!*}
lemma Adapt[rule_format]: 
"\<lbrakk>goodContext G; (A\<diamondsuit>m(y), MS c m y) : G\<rbrakk> \<Longrightarrow> (G - {(A\<diamondsuit>m(y), MS c m y)}) \<rhd> (A\<diamondsuit>m(z)) : MS c m z"
(*<*)
apply (subgoal_tac "goodContext (G \<union> {(A\<diamondsuit>m(z), MS c m z)})")
apply (rule vdm_invoke)
apply (case_tac "y=z")
(*case y=z*)
apply (subgoal_tac "G = ({(A\<diamondsuit>m(z), MS c m z)} \<union> (G - {(A\<diamondsuit>m(y), MS c m y)}))", simp)
  prefer 2 apply fast
  apply (simp add: goodContext_def, fast)
(*case y \<noteq> z*)
apply (rule, rule cut)
apply (subgoal_tac "({(A\<diamondsuit>m(z), MS c m z)} \<union> (G - {(A\<diamondsuit>m(y), MS c m y)})) \<rhd>  (A\<diamondsuit>m(y)) : MS c m y", assumption)
apply (rule vdm_invoke)
apply (subgoal_tac "({(A\<diamondsuit>m(y), MS c m y)} \<union> ({(A\<diamondsuit>m(z), MS c m z)} \<union> (G - {(A\<diamondsuit>m(y), MS c m y)}))) =
                    {(A\<diamondsuit>m(z), MS c m z)} \<union> G", simp) prefer 2 apply fast 
apply (erule thin_rl, simp add: goodContext_def)
apply (subgoal_tac "insert (A\<diamondsuit>m(y), MS c m y) ({(A\<diamondsuit>m(z), MS c m z)} \<union> (G - {(A\<diamondsuit>m(y), MS c m y)}))=
                    {(A\<diamondsuit>m(z), MS c m z)} \<union> G", simp) prefer 2 apply fast 
apply (erule thin_rl, simp add: goodContext_def)
(*last goal*)
apply (simp add: goodContext_def,safe)
apply (erule_tac x=A in allE)
apply (erule_tac x=c in allE)
apply (erule_tac x=m in allE)
apply (erule impE) apply (rule, assumption)
apply (erule_tac x=x in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=d in allE)
(*apply (subgoal_tac "insert (A\<diamondsuit>m(z), MS c m z) G
            \<rhd>  snd (methtable C m) : (\<lambda>E h hh v p.
                              \<forall>E'. classOf E' h A C \<and> E = newframe_env (renv E' A) (fst (methtable C m)) x E' \<longrightarrow>
                                   MS c m x E' h hh v
                                    (mkRescomp (5 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))", simp)
*)
apply (erule CtxtWeakSingleton)

apply (erule_tac x=Aa in allE)
apply (erule_tac x=ca in allE)
apply (erule_tac x=ma in allE)
apply (erule impE) apply (rule, assumption)
apply (erule_tac x=x in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=d in allE)
(*apply (subgoal_tac "(G \<union> {(A\<diamondsuit>m(z), MS c m z)}) \<rhd> (snd(methtable ca ma)) :
                      (\<lambda>E h hh v p.
                           \<forall>E'. E = newframe_env Nullref (fst(methtable ca ma)) x E' \<longrightarrow>
                                MS ca ma x E' h hh v (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))", simp)
*)
apply (erule CtxtWeakSingleton)
done
(*>*)
text {*The proof involves the cut rule, the weakening lemma and the 
       VDM rule for static method invocation.*}

text {*We can also show that subcontexts of good context are good (cf. consitent contexts!).*}
lemma GoodContextCut: "\<lbrakk>goodContext G; (A\<diamondsuit>m(y), MS c m y) : G\<rbrakk> \<Longrightarrow> goodContext (G - {(A\<diamondsuit>m(y), MS c m y)})"
(*<*)
apply (simp add: goodContext_def)
apply clarsimp
apply (rule cut)
(*1*)
apply (subgoal_tac "(G - {(A\<diamondsuit>m(y), MS c m y)}) \<rhd>  (A\<diamondsuit>m(y)): (MS c m y)", assumption)
apply (rule vdm_invoke)
apply (subgoal_tac "({(A\<diamondsuit>m(y), MS c m y)} \<union> (G - {(A\<diamondsuit>m(y), MS c m y)})) = G", simp)
apply fast apply fast
(*2*)
apply (subgoal_tac "insert (A\<diamondsuit>m(y), MS c m y) (G - {(A\<diamondsuit>m(y), MS c m y)}) = G", simp)
apply (erule_tac x=Aa in allE, erule_tac x=ca in allE, erule_tac x=ma in allE) apply (rotate_tac -1) apply (erule impE)
  apply (rule, assumption)
  apply (erule_tac x=x in allE, erule_tac x=C in allE, erule_tac x=d in allE, assumption)
  apply fast
done
(*>*)
text {*Again, the cut rule plays a crucial role in the proof.*}

text {*Finally, two derived lemmas.*}
lemma GoodContextCut1: 
"\<lbrakk>goodContext G; (A\<diamondsuit>m(y), MS c m y) : G; D = G - {(A\<diamondsuit>m(y), MS c m y)}\<rbrakk> \<Longrightarrow> goodContext D"
(*<*)by (insert GoodContextCut, fast)(*>*)

lemma EmptyProof: "\<lbrakk>goodContext {(A\<diamondsuit>m(y), MS c m y)}\<rbrakk> \<Longrightarrow>  \<rhd> (A\<diamondsuit>m(z)) : MS c m z"
(*<*)by (subgoal_tac "({(A\<diamondsuit>m(y), MS c m y)} - {(A\<diamondsuit>m(y), MS c m y)}) \<rhd> (A\<diamondsuit>m(z)) : MS c m z", 
     simp, erule Adapt, simp)(*>*)

constdefs InvContext:: "vdmcontext \<Rightarrow> bool"
"InvContext G \<equiv> (\<forall> e P . (e,P) : G \<longrightarrow> (\<exists> A c m y . e = A\<diamondsuit>m(y) \<and> P = MS c m y))"

lemma "\<lbrakk>InvContext G; goodContext G\<rbrakk> \<Longrightarrow> consistent G"
apply (simp add: goodContext_def InvContext_def consistent_def)
apply (rule, rule, rule)
apply (erule_tac x=e in allE, erule_tac x=P in allE, erule impE, assumption)
apply (erule exE)+
apply (erule_tac x=A in allE, erule_tac x=c in allE, erule_tac x=m in allE, erule impE, fast)
apply (rule disjI2)
apply (rule disjI1)
apply (erule conjE)
apply (rule, rule, rule, rule, assumption)
apply rule 
prefer 2
apply fast
txt {*The only goal left at this point is P = Mspectable c m, and we have an assumption P = MS c m y*}
oops

lemma SetDiff: "\<lbrakk>a : G; aa : G - {a}\<rbrakk> \<Longrightarrow> a : G - {aa}" by fast

lemma GC_aux:"\<forall> G c m y. (G,n):cardR \<longrightarrow> InvContext G \<longrightarrow>
                       goodContext G \<longrightarrow> (A\<diamondsuit>m(y), MS c m y) : G \<longrightarrow> goodContext {(A\<diamondsuit>m(y), MS c m y)}"
apply (induct n, safe)
apply (erule cardR.elims, simp, simp)
apply (case_tac "\<exists> AA cc mm yy . (AA\<diamondsuit>mm(yy),MS cc mm yy) : G - {(A\<diamondsuit>m(y), MS c m y)}", (erule exE)+)
  apply (erule_tac x="G - {(AA\<diamondsuit>mm(yy), MS cc mm yy)}" in allE)
  apply (erule_tac x=c in allE, erule_tac x=m in allE, erule_tac x=y in allE)
  apply (erule impE)
    apply (erule cardR_determ_aux1, simp, simp)
  apply (erule impE)
    apply (simp add: InvContext_def)
  apply (erule impE)
    apply (erule GoodContextCut1) prefer 2 apply simp apply fast
  apply (erule impE)
    apply (erule SetDiff,assumption) 
    apply assumption
apply (erule thin_rl)
apply (subgoal_tac "G = {(A\<diamondsuit>m(y), MS c m y)}", simp) 
apply (case_tac "\<exists> e P . (e,P): G - {(A\<diamondsuit>m(y), MS c m y)}")
  apply (erule exE)+
  apply (simp only: InvContext_def)
  apply (erule_tac x=e in allE, erule_tac x=P in allE)
  apply (erule impE, fast) 
  apply fast
apply fast
done

lemma GC: "\<lbrakk>goodContext G; InvContext G; finite G; (A\<diamondsuit>m(y), MS c m y) : G\<rbrakk> \<Longrightarrow> \<rhd> (A\<diamondsuit>m(z)) : MS c m z"
apply (rule EmptyProof)
apply (subgoal_tac "\<exists> n. (G,n):cardR", safe)
apply (insert GC_aux, fast)
apply (erule finite_imp_cardR)
done
(*<*) 
end
(*>*)
