header {*Parameter adaptation for static methods*}
(*<*)
theory Adapt = VDMderivedPC:
(*>*)

text {*Our new specification table takes an additional parameter, the actual argument(s) whose
  values will be passed to the formal parameters. Thus, the specifications for methods are "uniform" over
  the actual parmeters (in many cases these variables will be the only free variable
  of the vdmassn*}
consts MS :: "cname \<Rightarrow> mname \<Rightarrow> ARGTYPE \<Rightarrow> vdmassn" 


text {*Contexts usually contain pairs associating invokestatic instructions with
       the corresponding entries from MS - so we restrict our attention to such entries from
      now on.
      The notion of good context is very similar to the definition of "consitency" in VDMderived -
      we additionally quantify universally over the actual parameters.*}

constdefs goodContext::"vdmcontext \<Rightarrow> bool" 
"goodContext G == 
  (\<forall> c m y . (c\<bullet>m(y), MS c m y) : G \<longrightarrow> 
             (\<forall> x . G \<rhd> (snd(methtable c m)) : (\<lambda> E h hh v p . (\<forall> E'. E = newframe_env Nullref (fst (methtable c m)) x E'  \<longrightarrow> 
                                                                MS c m x (E') h hh v (\<langle>3 0 1 1\<rangle> \<oplus> p)))))"

text {*The following (preliminary) adaptation lemma allows to change actual parameters to z,
        leaving context G unchanged.*}
lemma goodAdapt: "\<lbrakk> (c\<bullet>m(y), MS c m y) : G; goodContext G\<rbrakk> \<Longrightarrow> G \<rhd> (c\<bullet>m(z)) : MS c m z"
by (rule vdm_invokestatic, simp, rule CtxtWeakSingleton, simp add: goodContext_def, fast)

text {* The following alternative definition may seem more appealing (the quantification 
        on the perameters occurs next to the quantification of $E'$) ..*}
constdefs goodContext1::"vdmcontext \<Rightarrow> bool" 
"goodContext1 G == 
  (\<forall> c m y . (c\<bullet>m(y), MS c m y) : G \<longrightarrow> 
             G \<rhd> (snd(methtable c m)): (\<lambda> E h hh v p . (\<forall> E' x . E = newframe_env Nullref (fst(methtable c m)) x E'  \<longrightarrow> 
                                                                MS c m x (E') h hh v (\<langle>3 0 1 1\<rangle> \<oplus> p))))"

text {*.. but the goodAdapt lemma for this variations fails -- the VDM rule for
          invokestatic does not have a quantification at this position.*}
lemma goodAdapt1: "\<lbrakk>(c\<bullet>m(y), MS c m y) : G; goodContext1 G\<rbrakk> \<Longrightarrow> G \<rhd> (c\<bullet>m(z)) : MS c m z"
apply (rule vdm_invokestatic, simp)
apply (rule CtxtWeakSingleton)
apply (simp add: goodContext1_def)
apply (erule_tac x=c in allE)
apply (erule_tac x=m in allE)
apply (erule impE) apply (rule, assumption)
oops

text {* The following adaptation rule is more useful than the above since 
        the context decreases -- in the end we will want to prove specifications 
        in the empty context!*}
lemma Adapt: 
"\<lbrakk>goodContext G; (c\<bullet>m(y), MS c m y) : G\<rbrakk> \<Longrightarrow> (G - {(c\<bullet>m(y), MS c m y)}) \<rhd> (c\<bullet>m(z)) : MS c m z"
(*<*)
apply (subgoal_tac "goodContext (G \<union> {(c\<bullet>m(z), MS c m z)})")
apply (rule vdm_invokestatic)
apply (case_tac "y=z")
(*case y=z*)
apply (subgoal_tac "G = ({(c\<bullet>m(z), MS c m z)} \<union> (G - {(c\<bullet>m(y), MS c m y)}))", simp)
  prefer 2 apply fast
  apply (simp add: goodContext_def, fast)
(*case y \<noteq> z*)
apply (rule cut)
apply (subgoal_tac "({(c\<bullet>m(z), MS c m z)} \<union> (G - {(c\<bullet>m(y), MS c m y)})) \<rhd>  (c\<bullet>m(y)) : MS c m y", assumption)
apply (rule vdm_invokestatic)
apply (subgoal_tac "({(c\<bullet>m(y), MS c m y)} \<union> ({(c\<bullet>m(z), MS c m z)} \<union> (G - {(c\<bullet>m(y), MS c m y)}))) =
                    {(c\<bullet>m(z), MS c m z)} \<union> G", simp) prefer 2 apply fast 
apply (erule thin_rl, simp add: goodContext_def)
apply (subgoal_tac "insert (c\<bullet>m(y), MS c m y) ({(c\<bullet>m(z), MS c m z)} \<union> (G - {(c\<bullet>m(y), MS c m y)}))=
                    {(c\<bullet>m(z), MS c m z)} \<union> G", simp) prefer 2 apply fast 
apply (erule thin_rl, simp add: goodContext_def)
(*last goal*)
apply (simp add: goodContext_def,safe)
apply (erule_tac x=c in allE)
apply (erule_tac x=m in allE)
apply (erule impE) apply (rule, assumption)
apply (erule_tac x=x in allE)
apply (subgoal_tac "(G \<union> {(c\<bullet>m(z), MS c m z)}) \<rhd> (snd(methtable c m)) :
                     (\<lambda>E h hh v p.
                          \<forall>E'. E = newframe_env Nullref (fst(methtable c m)) x E' \<longrightarrow>
                               MS c m x E' h hh v (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))", simp)
apply (erule CtxtWeak)

apply (erule_tac x=ca in allE)
apply (erule_tac x=ma in allE)
apply (erule impE) apply (rule, assumption)
apply (erule_tac x=x in allE)
apply (subgoal_tac "(G \<union> {(c\<bullet>m(z), MS c m z)}) \<rhd> (snd(methtable ca ma)) :
                      (\<lambda>E h hh v p.
                           \<forall>E'. E = newframe_env Nullref (fst(methtable ca ma)) x E' \<longrightarrow>
                                MS ca ma x E' h hh v (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))", simp)
apply (erule CtxtWeak)
done
(*>*)
text {*The proof involves the cut rule, the weakening lemma and the 
       VDM rule for static method invocation.*}

text {*We can also show that subcontexts of good context are good (cf. consitent contexts!).*}
lemma GoodContextCut: "\<lbrakk>goodContext G; (c\<bullet>m(y), MS c m y) : G\<rbrakk> \<Longrightarrow> goodContext (G - {(c\<bullet>m(y), MS c m y)})"
(*<*)
apply (simp add: goodContext_def)
apply clarsimp
apply (rule cut)
(*1*)
apply (subgoal_tac "(G - {(c\<bullet>m(y), MS c m y)}) \<rhd>  (c\<bullet>m(y)): (MS c m y)", assumption)
apply (rule vdm_invokestatic)
apply (subgoal_tac "({(c\<bullet>m(y), MS c m y)} \<union> (G - {(c\<bullet>m(y), MS c m y)})) = G", simp)
apply fast apply fast
(*2*)
apply (subgoal_tac "insert (c\<bullet>m(y), MS c m y) (G - {(c\<bullet>m(y), MS c m y)}) = G", simp)
apply (erule_tac x=ca in allE, erule_tac x=ma in allE) apply (rotate_tac -1) apply (erule impE)
  apply (rule, assumption)
  apply (erule_tac x=x in allE, assumption)
  apply fast
done
(*>*)
text {*Again, the cut rule plays a crucial role in the proof.*}

text {*Finally, two derived lemmas.*}
lemma GoodContextCut1: 
"\<lbrakk>goodContext G; (c\<bullet>m(y), MS c m y) : G; D = G - {(c\<bullet>m(y), MS c m y)}\<rbrakk> \<Longrightarrow> goodContext D"
(*<*)by (insert GoodContextCut, fast)(*>*)

lemma EmptyProof: "\<lbrakk>goodContext {(c\<bullet>m(y), MS c m y)}\<rbrakk> \<Longrightarrow>  \<rhd> (c\<bullet>m(z)) : MS c m z"
(*<*)by (subgoal_tac "({(c\<bullet>m(y), MS c m y)} - {(c\<bullet>m(y), MS c m y)}) \<rhd> (c\<bullet>m(z)) : MS c m z", 
     simp, erule Adapt, simp)(*>*)

constdefs InvContext:: "vdmcontext \<Rightarrow> bool"
"InvContext G \<equiv> (\<forall> e P . (e,P) : G \<longrightarrow> (\<exists> c m y . e = c\<bullet>m(y) \<and> P = MS c m y))"

lemma "\<lbrakk>InvContext G; goodContext G\<rbrakk> \<Longrightarrow> consistent G"
apply (simp add: goodContext_def InvContext_def consistent_def)
apply (rule, rule, rule)
apply (erule_tac x=e in allE, erule_tac x=P in allE, erule impE, assumption)
apply (erule exE)+
apply (erule_tac x=c in allE, erule_tac x=m in allE, erule impE, fast)
apply (rule disjI2)+
apply (erule conjE)
apply (rule, rule, rule, rule, assumption)
apply rule 
prefer 2
apply fast
txt {*The only goal left at this point is P = Mspectable c m, and we have an assumption P = MS c m y*}
oops

lemma GC_aux:"\<forall> G c m y. (G,n):cardR \<longrightarrow> InvContext G \<longrightarrow>
                       goodContext G \<longrightarrow> (c\<bullet>m(y), MS c m y) : G \<longrightarrow> goodContext {(c\<bullet>m(y), MS c m y)}"
apply (induct n, safe)
apply (erule cardR.elims, simp, simp)
apply (case_tac "\<exists> cc mm yy . (cc\<bullet>mm(yy),MS cc mm yy) : G - {(c\<bullet>m(y), MS c m y)}", (erule exE)+)
  apply (erule_tac x="G - {(cc\<bullet>mm(yy), MS cc mm yy)}" in allE)
  apply (erule_tac x=c in allE, erule_tac x=m in allE, erule_tac x=y in allE)
  apply (erule impE)
    apply (erule cardR_determ_aux1, simp, simp)
  apply (erule impE)
    apply (simp add: InvContext_def)
  apply (erule impE)
    apply (erule GoodContextCut1) prefer 2 apply simp apply fast
  apply (erule impE)
    apply fast
    apply assumption
apply (erule thin_rl)
apply (subgoal_tac "G = {(c\<bullet>m(y), MS c m y)}", simp)
apply (case_tac "\<exists> e P . (e,P): G - {(c\<bullet>m(y), MS c m y)}")
  apply (erule exE)+
  apply (simp only: InvContext_def)
  apply (erule_tac x=e in allE, erule_tac x=P in allE)
  apply (erule impE, fast)
  apply fast
apply fast
done

lemma GC: "\<lbrakk>goodContext G; InvContext G; finite G; (c\<bullet>m(y), MS c m y) : G\<rbrakk> \<Longrightarrow> \<rhd> (c\<bullet>m(z)) : MS c m z"
apply (rule EmptyProof)
apply (subgoal_tac "\<exists> n. (G,n):cardR", safe)
apply (insert GC_aux, fast)
apply (erule finite_imp_cardR)
done
(*<*) 
end
(*>*)
