/* Some horrible Java */
/* ... which counts the frequencies of JVM instructions in classes */
/* You can either do this for individual classes by feeding the
   program their names on the command line,  or put a big list of 
   class names in a file and use the -f option */

import org.apache.bcel.classfile.*;
import org.apache.bcel.*;
import org.apache.bcel.generic.*;
import org.apache.bcel.classfile.Utility.*;
import java.util.*;
import java.io.*;
import java.text.NumberFormat;

public class BytecodeCounter {

    static int nclasses = 0;
    static int nmethods = 0;
    static int nnative = 0;
    static int nabstract = 0;
    static int ncompliant = 0;
    static int ncompliantclasses = 0;

    static String getOpName (int j) {
	return (Constants.OPCODE_NAMES[j]);
    };


    static final String[] Grail_instrs = { 
	"bipush", "sipush", "ldc", 
	"aconst_null", "dup", "pop",
	"new", "putfield", "getfield", 
	"putstatic", "getstatic", 
	"checkcast", "instanceof", 
	"iinc", "iadd", "isub", "imul", "ineg",
	"ifnull", "ifnonnull", "if_acmpeq", "if_acmpne", 
	"ifeq", "ifne", "iflt", "ifgt", "ifle", "ifge",
	"if_icmpeq", "if_icmpne", "if_icmplt", 
	"if_icmpgt", "if_icmple", "if_icmpge",
	"goto", 
	"invokeinterface", "invokespecial", 
	"invokestatic", "invokevirtual", 
	"ireturn", "areturn", "return",
	"aload_0", "aload_1", "aload_2", "aload_3", "aload",
	"astore_0", "astore_1", "astore_2", "astore_3", "astore",
	"iload_0", "iload_1", "iload_2", "iload_3", "iload",
	"istore_0", "istore_1", "istore_2", "istore_3", "istore",
	"iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4",
	"iconst_5", "iconst_m1", 
	"lookupswitch",  "tableswitch" };

    static final List Grail2 = Arrays.asList(Grail_instrs);

    static int[] Grail_opcodes = new int[Grail_instrs.length];

    static {
	String thisOp;
	int q=0;

	for (int j=0; j < Grail_instrs.length; j++ ) {
	    thisOp = Grail_instrs[j];
	    for (int k = 0; k<202; k++)
		if (thisOp.equals(getOpName(k))) 
		    Grail_opcodes[q++]=k;
	}
	//	for (int j=0; j<Grail_opcodes.length; j++ ) 
	//      System.out.println (getOpName(Grail_opcodes[j]));
	Arrays.sort(Grail_opcodes);
    }

    static boolean is_grail(int c) { return Arrays.binarySearch(Grail_opcodes, c) >= 0; };
    
    static String percentage (int i, int n) {
	NumberFormat format = java.text.NumberFormat.getInstance();
	format.setMaximumFractionDigits(1);
	format.setMinimumFractionDigits(1);

	return Utility.fillup(""+format.format(100.0*i/n), 5, false, ' ') + "%";
    }
    
    static boolean member (Object x, Object[] A) { // A must be sorted
	return (java.util.Arrays.binarySearch (A, x) >= 0);
    }

    static class pair
    implements Comparable {
	private int x, y;
	
	pair (int x, int y) { this.x=x; this.y=y; }

	public int compareTo(Object p) { return (((pair)p).y)-y; }

	public String toString() {
	    String compliance;
	    String opname = Constants.OPCODE_NAMES[x];

	    if (Grail2.indexOf(opname) < 0) 
		compliance = "* "; 
	    else compliance = "  ";
	    return (Utility.fillup(compliance+opname, 17, true, ' ') + ": " + 
		    Utility.fillup(y+"", 7, false, ' ') ); }
    }

    static class frequency {
	static final int N = 256;

	public int[] freq;
	private Vector inorder;
	private boolean ordered = false;
	private int total = 0;
	private boolean compliance = true;
	
	frequency () { 
	    freq = new int[N]; 
	    ordered = false;
	    inorder = new Vector (); 
	    total = 0;
	}

	int getfreq(String[] ops) { 
	    int sum = 0;
	    for (int j=0; j<ops.length; j++) {
		//		System.out.println ( "looking for " + ops[j] );
		sum += freq[Utility.searchOpcode(ops[j])];
	    }
	    return sum;
	}

	boolean compliant () { return compliance; };

	void incr (int j) { freq[j]++; };

	void order () {
	    if (ordered) return;
	    ordered = true;
	    for (int k=0; k<256; k++) {
		total += freq[k];
		inorder.add(new pair(k, freq[k]));
	    }
	    Collections.sort(inorder);
	}


	void print () {
	    int n;
	    pair p;
	    final String[] aload_instrs =
		{"aload_0", "aload_1", "aload_2", "aload_3", "aload"};
	    final String[] astore_instrs =
		{"astore_0", "astore_1", "astore_2", "astore_3", "astore"};
	    final String[] iload_instrs =
		{"iload_0", "iload_1", "iload_2", "iload_3", "iload"};
	    final String[] istore_instrs =
		{"istore_0", "istore_1", "istore_2", "istore_3", "istore"};
	    
	    final String[] array_instrs =
		{ "newarray", "anewarray", "multianewarray", "arraylength",
		  "aaload", "baload", "caload", "daload", 
		  "faload", "iaload", "laload", "saload", 
		  "aastore", "bastore", "castore", "dastore", 
		  "fastore", "iastore", "lastore", "sastore" };

	    this.order ();
	    System.out.println (total+ " instructions in total\n");

	    for (int k=0; k<256; k++) {
		p = (pair)(inorder.get(k));
		if (p.y != 0) 
		    System.out.println (p.toString() + 
					" " + percentage(p.y,total));
	    }
	    System.out.print ("\n\n");

	    n = getfreq(aload_instrs);
	    System.out.println ("aload*  " + 
				n + " " + percentage(n,total));

	    n = getfreq(astore_instrs);
	    System.out.println ("astore* " + 
				n + " " + percentage(n,total));

	    n = getfreq(iload_instrs);
	    System.out.println ("iload*  " + 
				n + " " + percentage(n,total));

	    n = getfreq(istore_instrs);
	    System.out.println ("istore* " + 	
				n + " " + percentage(n,total));

	    n = getfreq(Grail_instrs);
	    System.out.println ("Grail " + 
				n + " " + percentage(n,total));

	    System.out.println();
	    n = getfreq(array_instrs);
	    System.out.println ("array instructions " + 
				n + " " + percentage(n,total));

	}
    }
	    


    static void process (String classname, frequency cumulative) {
	boolean compliant;
	boolean compliantclass = true;

	//	System.out.println ("Trying " + classname );
	JavaClass C = Repository.lookupClass(classname);
	if (C == null) System.out.println ("Can't find class " + classname);

	nclasses++;
	Method[] M = C.getMethods();
	nmethods += M.length;

	for (int j=0; j<M.length; j++) {
	    //	    frequency freq = new frequency();

	    compliant = true;

	    if (M[j].isNative()) { 
		nnative++; 
		compliantclass = false; 
		break; 
	    }
	    if (M[j].isAbstract()) { 
		nabstract++; 
		break; 
	    }


	    // System.out.println (M[j]);

	    Code code = M[j].getCode();
	    if (code == null) {
		System.out.println ( "No code: " + M[j]);
		break;
	    }

	    InstructionList inst = new InstructionList (code.getCode());

	    for (InstructionHandle h = inst.getStart(); h != null; h = h.getNext() ) {
		int c;
		//		System.out.println (h);
		Instruction i = h.getInstruction();
		//		freq.incr(i.getOpcode());
		c = i.getOpcode();
		if (!is_grail(c)) { 
		    //		    System.out.println ("Found " + getOpName(c));
		    compliant = false;
		}
		cumulative.incr(c);
	    }
	    //	    freq.print();
	    if (compliant) ncompliant++;
	    else compliantclass = false;
	}
	if (compliantclass) ncompliantclasses++;
    }

    

    public static void main (String[] arg) 
	throws IOException {
	int counter = 0;

	frequency cumulative = new frequency();
	//	for (int j=0;j<255;j++) System.out.println ("|"+Constants.OPCODE_NAMES[j]+"|");
	//	System.exit(0);

	if (arg.length == 0)
	    System.err.println ("Stat: no classes specified");
	else if ( arg[0].equals ("-f") ) {
	    BufferedReader in = new BufferedReader ( new FileReader (arg[1]));
	    String s;
	    while ( (s=in.readLine()) != null) process (s, cumulative);
	} else {
	    for (int j=0; j<arg.length; j++) process (arg[j], cumulative);
	}

	System.out.println ( "\nCumulative statistics" );
	System.out.println ( "=====================" );
	cumulative.print ();

	System.out.println();
	System.out.println( nclasses + " classes analysed: " + 
			    ncompliantclasses + " are Grail compliant");
	System.out.println( nmethods + " methods: " 
			   + nnative + " native, " + nabstract + " abstract");
	System.out.println( ncompliant + " methods are Grail compliant");

	System.out.print("\nUnused instructions: \n");
	
	for (int j=0;j<202;j++) if (cumulative.freq[j] == 0) {
	    System.out.print (Constants.OPCODE_NAMES[j]+" ");
	    if (++counter % 8 == 0) {
		System.out.println ();
		counter = 0;
	    }
	}
    }
}
