%{
   open Support
   open Types
   open Syntax
   open Lazy
     
   let actual = ref "No further parse error information available"

   let unique_aux_var_counter = ref 0
   
   let unique_aux_var: unit -> string =
     fun () ->
       let _ = unique_aux_var_counter := !unique_aux_var_counter + 1 in
       ("%auto_id%"^(string_of_int !unique_aux_var_counter)^"%")

   let new_actual s lres =
     let prev   = !actual  in
     let _      = actual := s in
     let result = 
       try  (force lres) 
       with _ -> raise (Failure s)
     in
     let _      = 
       actual := s (* prev  *) (* Does not work as intended! *)
     in result

   let parse_error s = 
     raise (Failure (!actual))
     (* print_string ("\n\n Details: "^(!actual)^".\n\n") *)

   let anonymous_id s = (* Checks whether identifier is anonymous. USCORE had been removed and included into identifier token, since in most places it does not matter at the time of parsing. *)
     function
       | "_" -> true
       |  _  -> false

   let add_typ_to_fun = (* Auto-fill-in a missing type option for a subsequent FunExp from the let/rec type info *)
     fun let_exp typ_opt ->
       match (let_exp#e, typ_opt) with
       | (FunExp(absv,None,bodyexpr),Some(let_typ)) ->
	   begin 
	     try 
	       let absv_typ = List.hd (uncurry let_typ) in
	       new expression let_exp#i (FunExp(absv, (Some(absv_typ)), bodyexpr))
	     with _ -> let_exp (* The missing type might produce a proper error later on if really needed *)
	   end
       |  _       -> let_exp   (* Nothing to do if not a fun-def or if type is explicitly given *)
%}

/* 

   Authors:  Steffen Jost  <jost@informatik.uni-muenchen.de>
	     using a template file from
	     David Aspinall	<da@dcs.ed.ac.uk> and
	     Martin Hofmann	<mhofmann@informatik.uni-muenchen.de> 
   Name:     $Name:  $
   File:     $RCSfile: parser.mly,v $
   Id:       $Id: parser.mly,v 1.1 2004/12/07 17:30:41 sjost Exp $ 

   This module contains the rules to generate a parser for the
   abstract syntax vir ocamlyacc.



   NOTE:
       Since the grammar of LF_<> restricts some subexpressions to values,
       we run into some problems here as both expression and values
       may be contained within parenthesis. Therefore this grammar-file
       becomes unusually complicated! 
       (Or maybe I'm just too stupid, as I havent done something like this before, 
        but it works and I dont want to waste much more time on this)


   TODOs: 

       - Resolve the two remaining reduce/reduce conflicts. As far as I can see, they are not harmful.
    
       - We just ignored SupportErroInfo, 
         i.e. always $1.v instead of $1
         Use it to give better Parse-Errors!!! 

       - Maybe document all differences to current Camelot

*/

/* Ordered by appearance as in lexer.mll */
%token <Support.info> EOF
%token <int Support.withinfo> DIASIZE
%token <string Support.withinfo> 	IDENTIFIER
%token <string Support.withinfo> 	CONSTRUCTOR
/* KEYWORDS ARE DEFINED BELOW */
%token <string Support.withinfo> 	TYPEVAR
%token <Support.info> 		UNITVAL
%token <int    Support.withinfo> 	INTVAL
%token <float  Support.withinfo> 	FLOATVAL
%token <char   Support.withinfo> 	CHARVAL
%token <string Support.withinfo> 	STRINGVAL
/* Den Unterschied zwischen QUOTEVAL und STRINGVAL in Camelot habe ich nicht verstanden.
   Deshalb ignoriere ich QUOTEVAL. 
   Das STRINGVAL als ein beliebiges unidentifiziertes KEYWORD definiert ist,
   finde ich auch ziemlich komisch, das mache ich anders, also so wie QUOTEVAL,
   so das ich letztendlich also STRINGVAL und nicht QUOTEVAL ignoriere! 
*/
%token <Support.info> EQUALS
%token <Support.info> LESS
%token <Support.info> GREATER
%token <Support.info> DIAMOND
%token <Support.info> LTEQ
%token <Support.info> GTEQ
%token <Support.info> ARROW
%token <Support.info> LPAREN
%token <Support.info> RPAREN
%token <Support.info> EMPTYPAREN
%token <Support.info> LBRACE
%token <Support.info> RBRACE
%token <Support.info> LBRAK
%token <Support.info> RBRAK
%token <Support.info> LBANA
%token <Support.info> RBANA
%token <Support.info> DOT
%token <Support.info> COMMA
%token <Support.info> COLON 
%token <Support.info> SEMICOLON
/* AND is also a keyword */
%token <Support.info> BAR
%token <Support.info> AT
%token <Support.info> BANG
%token <Support.info> DOLLAR
%token <Support.info> SHARP
%token <Support.info> POUND
%token <Support.info> PARAGRAPH
/* %token <Support.info> USCORE   This token was removed. */
%token <Support.info> CARET
%token <Support.info> PLUS 
%token <Support.info> MINUS
%token <Support.info> TIMES
%token <Support.info> DIVIDE
%token <Support.info> FPLUS 
%token <Support.info> FMINUS
%token <Support.info> FTIMES
%token <Support.info> FDIVIDE
%token UMINUS
/* KEYWORDS */
%token <Support.info> UNIT
%token <Support.info> BOOL
%token <Support.info> INTEGER
%token <Support.info> FLOAT
%token <Support.info> ARRAY
%token <Support.info> CHAR
%token <Support.info> STRING

%token <Support.info> TYPE
%token <Support.info> VAL
%token <Support.info> ANNVAL
%token <Support.info> OF

%token <Support.info> TRUEVAL
%token <Support.info> FALSEVAL

%token <Support.info> BOOL
%token <Support.info> NOT
%token <Support.info> FST
%token <Support.info> SND
%token <Support.info> LAND
%token <Support.info> LOR
%token <Support.info> ANDALSO
%token <Support.info> ORELSE
%token <Support.info> MOD

%token <Support.info> BEGIN
%token <Support.info> END
%token <Support.info> IF
%token <Support.info> THEN
%token <Support.info> ELSE
%token <Support.info> MATCH
%token <Support.info> MATCHPR
%token <Support.info> WITH
%token <Support.info> MATCHEND
%token <Support.info> LET
%token <Support.info> AND
%token <Support.info> REC
%token <Support.info> IN
%token <Support.info> WHERE
%token <Support.info> FUN

/* Das sind eigentlich keine Keywords, sondern Built-in functions die ich
   erst bei der Prfung der Identifier abfange... 
 %token <Support.info> INT_OF_FLOAT
 %token <Support.info> FLOAT_OF_INT
 %token <Support.info> CHAR_OF_INT
 %token <Support.info> INT_OF_CHAR
 %token <Support.info> FLOAT_OF_STRING
 %token <Support.info> STRING_OF_FLOAT
 %token <Support.info> INT_OF_STRING
 %token <Support.info> STRING_OF_INT
 %token <Support.info> PRINT_OF_INT
 %token <Support.info> PRINT_OF_FLOAT
 %token <Support.info> PRINT_OF_CHAR
 %token <Support.info> PRINT_OF_STRING
 %token <Support.info> ARRAY_HEAD
*/


/* Operatorsymbole in aufsteigender Prioritt */
%nonassoc LET AND REC IN
%nonassoc MATCH MATCHPR WITH 
%nonassoc IF THEN ELSE
%nonassoc COLON
%nonassoc ARRAY
%left WHERE
%right SEMICOLON COMMA
%right ARROW
%left ANDALSO ORELSE
%left LAND LOR  
%right NOT
%nonassoc EQUALS LESS GREATER LTEQ GTEQ
%left CARET /* String append */
%left PLUS MINUS FPLUS FMINUS
%left TIMES DIVIDE FTIMES FDIVIDE 
%nonassoc MOD
%nonassoc UMINUS UFMINUS


/* Starting symbols (must have type) */
%start pprogram
%type <Syntax.program> pprogram


%%

tname: /* Names of user-types may be upper or lower case */ 
	    IDENTIFIER   { $1 }
	|   CONSTRUCTOR  { $1 }
;

pprogram: ptdeclist pvaldec pexpression EOF 
    { 
      begin (* we allow parsing of programs like (fun x-> expr) here, i.e. get type from valdec and built generic "let main_expr_name = <..> in main_expr_name" *)
	match $3#e with
	| FunExp(id, ty_opt, fbody) ->
	    let main_var = Argument.main_expr_name in
	    let in_expr  = new expression Support.unknown (ValueExp(Support.fakeinfo (VarVal(main_var)))) in
	    let (some_ty, let_expr)  = 
	      match ty_opt with
	      | None     -> (* Use type specified in valdec *)
		  let absv_ty = List.hd (uncurry $2) in
                  (Some($2),(new expression $3#i (FunExp(id, Some(absv_ty), fbody))))
	      | Some(ty) -> (ty_opt, $3)
	    in
	    let main_expr = new expression Support.unknown (LetExp(main_var,some_ty,let_expr,in_expr)) in (* Cannot be a RecExp since main_var is a new variable *)
	    Program($4,$1,$2,main_expr) 
	|  _  ->  
	    Program($4,$1,$2,$3) 
      end
    } 
;

ptdeclist: ptdeclist_ { new_actual "Expecting a type or val declaration here." (lazy $1) }
ptdeclist_:
					{ [] }
	| ptdec ptdeclist		{ $1 :: $2 }
;

ptdec:
	  TYPE ptypevarlist tname EQUALS pconstructordeclist psemicolonopt
		{ TypDec($1,$2,$3.v,$5) }
;

ptypevarlist:
	  			{ [] }
	| TYPEVAR ptypevarlist	{ $1.v :: $2 }
;

pconstructordeclist:	
	  pconstructordec				{ $1 :: [] }
	| pconstructordec BAR pconstructordeclist	{ $1 :: $3 }
;

pconstructordec:		
       CONSTRUCTOR pconstrsize                   { (let size =
	                                              match $2 with
						      | None    -> (Support.warningAt $1.i ("Unspecified size for constructor '"^$1.v^"', using default size 0.")); 0
	                                              | Some(i) -> i  
						    in TypCon($1.i,$1.v,size,[])) }
    |  BANG CONSTRUCTOR 	                 { TypCon($2.i,$2.v,0,[]) }
    |  CONSTRUCTOR pconstrsize OF ptypedeclist	 { (let size =
	                                              match $2 with
						      | None    -> 
							  (
							   let s = List.fold_left (fun a x -> a + (Memory.Size.typ x)) 0 $4 in
							   (Support.warningAt $1.i ("Unspecified size for constructor '"^$1.v^"', using default size "^(string_of_int s)^".")); s
                                                          )
						      | Some(i) -> i
                                                    in TypCon($1.i,$1.v,size,$4)) }
;


pconstrsize:
	                        { None }
	| DIASIZE               { Some($1.v) }
;


ptypedeclist:		/* Teil einer Typeklaration */
	  ptype		     		{ $1 :: [] } 
	| ptype TIMES ptypedeclist	{ $1 :: $3 }
;

/* Not needed in higher-type system
pvaldeclist:
				{ [] }
	| pvaldec pvaldeclist	{ $1 :: $2 }
;
*/

/*
pnameopt: 
                      { None }
	| tname COLON { Some($1)}
;
*/

pvaldec: pvaldec_ { new_actual "Expecting the VAL definition of the main expression here." (lazy $1) }
pvaldec_:  
	  VAL ptype psemicolonopt 	 { $2 }
/*	 Old variant, where we had multiple functions instead of one expression:  
          VAL tname COLON  ptype psemicolonopt 	
            { ValDec($1,$2.v,$4) }
	| ANNVAL tname COLON pdianumopt COMMA prtype COMMA pdianumopt psemicolonopt
	    { AnnValDec($1,$2.v,$4,$6,$8) }
*/
;

psemicolonopt: /* There might be a semicolon, but it is not necessary */
	            { }
	| SEMICOLON { }
;

ptypeopt:   /* There might be a typdeclaration here, starting with a colon, but it is not compulsory */
          COLON ptype { Some $2 }
        |             { None    }
;

ptype: ptype_ { new_actual "Expecting a type here." (lazy $1) }
ptype_:
	  psubtype			{ $1 }
	| psubtype ARROW ptype	 	{ {i=$2; v=ArrowTyp($1,$3)} }   /* Erlaubt leider auch Higher-Order Types, die wir nicht behandeln knnen */
/*	| psubtypelist tname 	        { {i=$2.i; v=ConTyp($1,$2.v)} }    Generische Konstruktor typen 
;


psubtypelist:
	  			{ [] }
	| psubtype psubtypelist	{ $1::$2 } */
;


psubtype: psubtype_ { new_actual "Expecting a base type here. Other types must be enclosed in parenthesis." (lazy $1) }
psubtype_:
	  UNIT				{ {i=$1; v=UnitTyp} }
	| DIAMOND			{ {i=$1; v=DiamondTyp} }
	| BOOL				{ {i=$1; v=BoolTyp} }
	| INTEGER			{ {i=$1; v=IntTyp} }
	| FLOAT				{ {i=$1; v=FloatTyp} }
	| CHAR				{ {i=$1; v=CharTyp} }
	| STRING			{ {i=$1; v=StringTyp} }
	| TYPEVAR			{ {i=$1.i; v=TvarTyp($1.v)} }
	| tname 	                { {i=$1.i; v=ConTyp([],$1.v)} } /* Nicht-Generische Konstruktor typen */
	| LPAREN ptype RPAREN		{ $2 }
	| LBANA ptype BAR ptype RBANA	{ {i=$3; v=LinPairTyp($2,$4)} }
;

/*
 The commented part was concerned with parsing rich_types in
 order to restrict the constraint inference. 
 If this is again desired, one cannot use the rich_typ
 directly anymore and one must define a subset pseudo_rich_typ
 for parsing.

 Does not allow nestes comments, hence *->@

pdianum:   /@ Deprecated. Move into pdianumopt! @/
	  LESS FLOATVAL GREATER { $2.v }
	| LESS   INTVAL GREATER { float_of_int($2.v) }
;

pdianumopt:
          pdianum             { Some $1 }
	| TIMES               { None    }
	| LESS TIMES GREATER  { None    } /@ For convenience @/
;


prtype: /@ Types.rich_type - does not contain any 'info'-elements 
           The idea is, that the user already states the wanted rich_type.
	   However, not all necessary informations are already computed,
	   hence the rich_type is not really valid and must be completed
           by Constraint.complete_annval_rt. This is a hack, yes. :-(
	@/
	  psubrbasetype			{ $1 }
	| prtype ARROW prtype	 	{ RArrowTyp($1,$3) }   /@ Does not exclude Higher-Order Types, which we cant treat so far! @/
	| psubrtypelist tname LBRAK pconrtlist RBRAK	       
                                        { RConTyp($1,$2.v,$4) } 
;

prrectype: /@ A limited prtype, where constructor types are not allowed to have parameters in front. 
              Saves some parenthesis in the source code. @/
   tname LBRAK pconrtlist RBRAK       { RConTyp([],$1.v,$3) } 
;


pconrtlist: /@ Syntax.rt_contab @/
	  pconrtarg pconrtlistend
	    {
 	     let (cnstr,rcinf) = $1 in
	     ConTab.add cnstr rcinf $2 
	   }
;
pconrtlistend: /@ Syntax.rt_contab @/
	                 { ConTab.empty }
	| BAR pconrtlist { $2 }
;

pconrtarg: /@ (constructor @ Syntax.rich_coninfo) @/
          CONSTRUCTOR LPAREN pconrtarglist RPAREN
            { let (args, d) = $3 in 
	      ($1.v,
	       {
		rcvar = 
		(
		 match d with 
		 | None   -> "None"
		 | Some c -> string_of_float c
		); (@ Must be converted back into a proper constant -> lp_solve does not accept linear arithmetic expressions as factors @)
		rorder = 0;                (@ UNKNOWN!   0 denotes unknown order @)
		rarg_types = args;         (@ May contain incomplete subdata @)
		rsize = Unspecified        (@ UNKNOWN! @)  
	      }
	      )
	    }
;

pconrtarglist: /@ (rich_type list @ float ) @/
          pdianumopt                         { ([], $1) }
	| psubrtypeself COMMA pconrtarglist  { let (args, d) = $3 in (($1::args), d) }
;

psubrtypelist:
	                            { [] }
	|  psubrbasetype psubrtypelist  { $1::$2 }
;

/@
psubrtype:
	  psubrbasetype                 { $1 }
	| prrectype                     { $1 }
;
@/

psubrbasetype: psubrbasetype_ { new_actual "Expecting a base type here. Rich types must be enclosed in parenthesis." (lazy $1) }
psubrbasetype_:
	  UNIT				{ RUnitTyp }
	| DIAMOND			{ RDiamantTyp }
	| BOOL				{ RBoolTyp }
	| INTEGER			{ RIntTyp }
	| FLOAT				{ RFloatTyp }
	| CHAR				{ RCharTyp }
	| STRING			{ RStringTyp }
/@	| TYPEVAR			{ {i=$1.i; v=TvarTyp($1.v)} } @/
	| LPAREN prtype RPAREN		{ $2 }
;


psubrtypeself: 
          SHARP                         { rSelfTypUnknown }
	| prrectype                     { $1 }
	| psubrbasetype                 { $1 }
;
*/

/* END of the ANNVAL-RICHTYPE-HACK */

pbaropt: /* Hier darf ein BAR kommen, muss aber nicht */
		{ }
	| BAR	{ }
;

/*
precopt: * hier darf ein REC kommen, muss aber nicht -> liefert bool *
  { false }
	| REC   { true }
;
*/

at_loc: /* We need to distinguish this in the sandboxed execution only */
  AT IDENTIFIER         
  { 
    let s = $2.v in 
    if   (s = "_") 
    then New
    else Reuse(s)
  } 
;
/* Deprecated below, since now USCORES are not produced by the Lexer anymore:
  AT USCORE             { New }
| AT IDENTIFIER         { Reuse($2.v) } 
*/

pmatchrulelist:
	  pmatchrule				{ [$1] }
	| pmatchrule BAR pmatchrulelist		{ $1::$3 }
;

pmatchrule: pmatchrule_ { new_actual "Expecting a constructor for a pattern match rule here." (lazy $1) }
pmatchrule_:
      CONSTRUCTOR pvarargs        ARROW psubexpression   { Matchrule($3,$1.v,$2, None    ,$4) } 
   |  CONSTRUCTOR pvarargs at_loc ARROW psubexpression   { Matchrule($4,$1.v,$2,(Some $3),$5) } 
;

pexpression: pexpression_ { new_actual "Expecting an expression here." (lazy $1) };
pexpression_: 
     psubexpression                        { $1 } 
   | MATCH IDENTIFIER WITH pbaropt pmatchrulelist { new expression $1 (MatchExp ($2.v, $5)) }
/* | LPAREN pexpression RPAREN             { $2 } Produces 2 reduce/reduce conflicts, which seem harmless though. */
;

psubexpression: psubexpression_ { new_actual "Expecting a subexpression here." (lazy $1) }
psubexpression_:
     pvalue                         { new expression $1.i (ValueExp($1)) }
   | BEGIN pexpression END          { $2 }
   | IDENTIFIER IDENTIFIER          { new expression $1.i (AppExp($1.v,$2.v)) }      /* Function application */
   | FUN IDENTIFIER ARROW psubexpression 
                                    { new expression $1   (FunExp($2.v,None,$4)) }   /* Function abstraction */
   | FUN LPAREN IDENTIFIER COLON ptype RPAREN ARROW psubexpression 
                                    { new expression $1   (FunExp($3.v,Some($5),$8)) }  /* Function abstraction, with type annotation */
   | FUN pmatchrule                 { let auxv    = unique_aux_var () in 
                                      let matchex = new expression $1 (MatchExp(auxv,[$2]))  in
					new expression $1 (FunExp(auxv,None,matchex))      }  /* Function abstraction, including singleton pattern match for convenience */
   | LET REC iddeflist IN psubexpression
       { new expression $1 (AndExp($3,$5)) } /* A couple of mutual-recursive definition - no resource polymorphism among them then */
   | LET IDENTIFIER ptypeopt EQUALS pexpression IN psubexpression 
 	                            { 
				      let let_exp = add_typ_to_fun $5 $3 in (* Auto-fill-in a missing type option for the subsequent FunExp *)
				      let expr =
					match ($2.v) with
					| "_" -> SeqExp(let_exp,$7)
					|  _  -> LetExp($2.v,$3,let_exp,$7) 
				      in new expression $1 expr
			            }  
/*   | psubexpression SEMICOLON psubexpression	
                                    { new expression $2 (SeqExp($1,$3)) } */
   | IF pvalue_ext THEN pexpression ELSE psubexpression
			            { new expression $1 (IfExp($2,$4,$6)) }
   | LBANA psubexpression BAR psubexpression RBANA 
	                            { new expression $3 (LinIExp($2,$4))} /* Lineares Paar */
   | FST        IDENTIFIER          { new expression $1 (LinEExp(true ,$2.v)) } 
   | FST LPAREN IDENTIFIER RPAREN   { new expression $1 (LinEExp(true ,$3.v)) } 
   | SND        IDENTIFIER          { new expression $1 (LinEExp(false,$2.v)) } 
   | SND LPAREN IDENTIFIER RPAREN   { new expression $1 (LinEExp(false,$3.v)) } 
   | MATCH IDENTIFIER WITH pbaropt pmatchrulelist MATCHEND	
	                            { new expression $1   (MatchExp($2.v,$5))  }
   | CONSTRUCTOR pvalueargs  	    { new expression $1.i (ConstrExp($1.v,$2,New)) }    /* Constructor application */
   | CONSTRUCTOR pvalueargs at_loc  { new expression $1.i (ConstrExp($1.v,$2,$3)) }     /* Constructor application */
;

iddeflist: iddeflist_ { new_actual "Expecting an identifier definining subexpression here." (lazy $1) }
iddeflist_:
      IDENTIFIER ptypeopt EQUALS pexpression	           { let let_ex = add_typ_to_fun $4 $2 in    [($1.v,$2,let_ex)] }
    | IDENTIFIER ptypeopt EQUALS pexpression AND iddeflist { let let_ex = add_typ_to_fun $4 $2 in ($1.v,$2,let_ex)::$6  }	
;

pvalue: pvalue_ { new_actual "Expecting an atomic value. Arithmetic expressions must be enclosed in parenthesis here." (lazy $1) }
pvalue_: 
	  patomicvalue                            { new_actual "Expecting an atomic value." (lazy $1) } 
        | LPAREN pvalue_ext RPAREN                { $2 } 
;

pvalue_ext:
	  patomicvalue                          { $1 }
	| LPAREN pvalue_ext RPAREN              { $2 }
	| MINUS	 %prec UMINUS  pvalue_ext { {i=$1; v=UnaryOpVal({i=$1; v=UMinusOp },$2) } }
	| FMINUS %prec UFMINUS pvalue_ext { {i=$1; v=UnaryOpVal({i=$1; v=UFminusOp},$2) } }
	| NOT  		       pvalue_ext { {i=$1; v=UnaryOpVal({i=$1; v=NotOp},$2) } }
/*	| FST LPAREN pvalue_ext RPAREN    { {i=$1; v=UnaryOpVal({i=$1; v=FstOp},$3) } } FST/SND are too special in order to be implemented as ordinary operators.
	| SND LPAREN pvalue_ext RPAREN    { {i=$1; v=UnaryOpVal({i=$1; v=SndOp},$3) } }  */
	| pvalue_ext TIMES   pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=TimesOp  },$1,$3)} } 
	| pvalue_ext DIVIDE  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=DivOp    },$1,$3)} } 
	| pvalue_ext PLUS    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=PlusOp   },$1,$3)} } 
	| pvalue_ext MINUS   pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=MinusOp  },$1,$3)} } 
	| pvalue_ext FTIMES  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=FtimesOp },$1,$3)} } 
	| pvalue_ext FDIVIDE pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=FdivOp   },$1,$3)} } 
	| pvalue_ext FPLUS   pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=FplusOp  },$1,$3)} } 
	| pvalue_ext FMINUS  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=FminusOp },$1,$3)} } 
	| pvalue_ext LESS    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=LessOp   },$1,$3)} } 
	| pvalue_ext LTEQ    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=LteqOp   },$1,$3)} } 
	| pvalue_ext GREATER pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=GreaterOp},$1,$3)} } 
	| pvalue_ext GTEQ    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=GteqOp   },$1,$3)} } 
	| pvalue_ext EQUALS  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=EqualOp  },$1,$3)} } 
	| pvalue_ext CARET   pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=AppendOp },$1,$3)} } 
	| pvalue_ext LAND    pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=AndOp    },$1,$3)} } 
	| pvalue_ext LOR     pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=OrOp     },$1,$3)} } 
	| pvalue_ext ANDALSO pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=AndalsoOp},$1,$3)} } 
	| pvalue_ext ORELSE  pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=OrelseOp },$1,$3)} } 
	| pvalue_ext MOD     pvalue_ext       { {i=$2; v=BinaryOpVal({i=$2; v=ModOp },$1,$3)} } 
;
/* USING THE BULIT_IN PRECEDENCES FAILED. See parser.mly of LFD_infer for more comments and examples on this topic! */

patomicvalue:
	  IDENTIFIER			{ {i=$1.i; v=VarVal($1.v)} } /* Could also be a 0-arity function call, but should not be! */
	| INTVAL			{ {i=$1.i; v=IntVal($1.v)} }
	| FLOATVAL			{ {i=$1.i; v=FloatVal($1.v)} }
	| CHARVAL			{ {i=$1.i; v=CharVal($1.v)} }
	| STRINGVAL			{ {i=$1.i; v=StringVal($1.v)} }
	| TRUEVAL			{ {i=$1; v=BoolVal(true)} }
	| FALSEVAL			{ {i=$1; v=BoolVal(false)} } 
	| UNITVAL			{ {i=$1; v=UnitVal} }        
;


/*
 For compatibility with CAMELOT, we must distinguish to kinds of argument lists:
 	list - lists like " a b c d ", " a ", " " 
   	args - lists like "(a,b,c,d)", "(a)", "()" or " "
 note that an arg-list consiting of a single unit argmuent must be written as "(())" 
*/

/*
pvaluelist:
	                        { [] }
   |   pvalue pvaluelist	{ $1::$2 }
;

pvaluelistnotempty:
       pvalue pvaluelist	{ $1::$2 }                    
;
*/

pvalueargs:
	                                       	 	{ [] }
	| EMPTYPAREN                           	 	{ [] }
	| UNITVAL                              	 	{ [] } /* Special Case: if there is a single argument of type unit, it must be enclosed in parenthesis in an argument-list */	
	| LPAREN RPAREN                       	 	{ [] }
	| LPAREN pvalue_ext pvalueargsaux RPAREN	{ $2 :: $3 }
;

pvalueargsaux:
	      					{ [] } 	
	| COMMA pvalue_ext pvalueargsaux  	{ $2 :: $3 }
;

/*
pvarlist:
	  				{ [] }
	| IDENTIFIER pvarlist		{ $1.v :: $2 }
;
*/

pvarargs: 
	                                        { [] }
	| EMPTYPAREN                            { [] }
	| UNITVAL                               { [] } /* Special Case: if there is a single argument of type unit, it must be enclosed in parenthesis in an argument-list */	
	| LPAREN RPAREN                         { [] }
	| LPAREN IDENTIFIER pvarargsaux RPAREN 	{ $2.v :: $3 }
;

pvarargsaux:
	      				{ [] } 	
	| COMMA IDENTIFIER pvarargsaux  { $2.v :: $3 }
;
