(*

   Author:   Steffen Jost <jost@informatik.uni-muenchen.de>
   Name:     $Name:  $
   File:     $RCSfile: main.ml,v $
   Id:       $Id: main.ml,v 1.1 2004/12/07 17:30:41 sjost Exp $ 

	

   What this File is all about:
   ----------------------------
   This file shall simply glue everything together. 
   It evolved from a file from M.Hofmann and D.Aspinall,
   but only few original lines have survived until now.

*)

open Common
open Support
open Argument

let main () = 
  let _ = (* Gain some space within the terminal *)
    begin
      print_string (version_info^"\n");
      print_string ("written by "^author_info^"\n");
      queue_warnings ()
    end
  in
  let ((inchan,inname),(outchan,outname),opts) = my_parse_arg () in (* Parse command line.. *)
  let _ = (* Before-Parsing *)
    print_newline();
    print_raligned_string '.' (opts.screen_width - 18) (" Parsing program '"^inname^"'..")
  in
  let Syntax.Program(info, tds, vd, exp) as pr =  (* pr: syntax.program *)
    let lexbuf =  Lexing.from_channel inchan  in 
    let _ = Lexer.setFilename inname in 
    let parseerr s = errAt (Lexer.info lexbuf) ("\n Parse error: unexpected token '" ^ (Lexing.lexeme lexbuf) ^ "'.\n " ^s^" \n ") in
    try 
      Parser.pprogram Lexer.token lexbuf 
    with 
      Parsing.Parse_error -> parseerr " "
    | Failure s -> parseerr s
  in
  let _ = (* After-Parsing *)
    begin
      (Types.update_the_contab tds); (* generate global table of user-defined constructors *)
      print_string ("..finished.\n");
      print_warnings ();
      if inchan <> stdin 
      then 
	let _ = 
	  if !the_options.debug 
	  then print_string (" Closing infile '"^inname^"'.\n") 
	in close_in inchan
    end
  in
  let _ = (* Inferring and solving ARTHUR type constraints *)
    if opts.inference 
    then Inference.iprogram pr (outchan,outname) 
  in
  let _ = (* Print some separator *)
    if opts.inference && opts.execute
    then print_string " \n\n "
  in
  let _ = (* Sandboxed execution, independent of inference *)
    if opts.execute
    then  Exec.eprogram pr 
  in ()

    
(* All above are mere Definitions. Below is the term to be evaluated... *)


let () =   (* OCaml is strict *)
  let runtime_main = new timer in
  let res =
    try  main();             0   (* Default exit-code 0 *) 
    with x -> print_err x;   1   (* Our own errorhandling instead of Prinexc.print *)
  in
  begin
    (print_warnings ());
    (print_string ("\nTotal processing time: "^(pretty_string_of_float(runtime_main#time))^" seconds.\n"));
    (exit res)
  end
