theory test = VDMderived:

(*Policies for invokestatics may be specified later*)
consts InvS_policy:: "expr \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> 'a \<Rightarrow> 'a"

defs 
  Int_effect_def: "Int_effect == (\<lambda> e E h . True)"
  IVar_effect_def: "IVar_effect == (\<lambda> e E h . True)"
  Primop_effect_def: "Primop_effect == (\<lambda> e E h . True)"
  Null_effect_def: "Null_effect == (\<lambda> e E h . True)"
  RVar_effect_def: "RVar_effect == (\<lambda> e E h . True)"
  RPrimop_effect_def: "RPrimop_effect == (\<lambda> e E h . True)"
  New_effect_def: "New_effect == (\<lambda> e E h . True)"
  GetFi_effect_def: "GetFi_effect == (\<lambda> e E h . True)"
  GetFr_effect_def: "GetFr_effect == (\<lambda> e E h . True)"
  PutFi_effect_def: "PutFi_effect == (\<lambda> e E h . True)"
  PutFr_effect_def: "PutFr_effect == (\<lambda> e E h . True)"
  GetStat_effect_def: "GetStat_effect == (\<lambda> e E h . True)"
  PutStat_effect_def: "PutStat_effect == (\<lambda> e E h . True)"
  InvV_effect_def: "InvV_effect == (\<lambda> e E h p . p)"

  InvS_effect_def: "InvS_effect == InvS_policy"
     
  Leti_effect_def: "Leti_effect == (\<lambda> e E h p1 p2 . p1 \<and> p2)"
  Letr_effect_def: "Letr_effect == (\<lambda> e E h p1 p2 . p1 \<and> p2)"
  Letv_effect_def: "Letv_effect == (\<lambda> e E h p1 p2 . p1 \<and> p2)"
  If_effect_def: "If_effect == (\<lambda> e E h p. p)"
  Call_effect_def: "Call_effect == (\<lambda> e E h p . p)"

consts SysC::cname
       SysM::mname
       SysP1::iname
       SysP2::rname

axioms MTSys: "methtable SysC SysM = ([INpar SysP1, RNpar SysP2], Null)"

(*This axiom suffices for proving a derived VDM rule similar to the axiom in Martin's note:*)
lemma vdmSys:" \<rhd> (SysC\<bullet>SysM([INarg x,RNarg a])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                                           p = InvS_policy (SysC\<bullet>SysM([INarg x,RNarg a])) E h True)"
apply (rule vdm_invokestatic)
apply clarsimp
apply (simp add: MTSys)
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (simp add: InvS_effect_def)
apply (simp add: Null_effect_def)
done

(*Now we define policies.*)

consts TL :: rfldname
       HD :: ifldname
consts mLIST::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
(*non-cyclic lists of length n (i.e. n cons-nodes)*)
inductive mLIST intros
mLIST_NIL: "(0,Nullref,{},h) : mLIST"
mLIST_CONS:"\<lbrakk>h@@a = Some C; h\<lfloor>a\<diamondsuit>TL\<rfloor> = r; h<a\<bullet>HD> = i; a \<notin> X; (n,r,X,h):mLIST; m=Suc n;XX=X \<union> {a}\<rbrakk>
          \<Longrightarrow> (m, Ref a, XX, h): mLIST"


(*Second policy: a policy that that requires the second argument to the system method 
 to be a pointer to a list whose length is less than a given number*)
constdefs llength::"ref \<Rightarrow> heap \<Rightarrow> nat \<Rightarrow> bool"
"llength r h M == (\<exists> R . (M,r,R,h):mLIST)"
constdefs InvS_Policy2::"nat \<Rightarrow> (nat \<Rightarrow> nat \<Rightarrow> bool) \<Rightarrow> expr \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool \<Rightarrow> bool"
"InvS_Policy2 M compare e E h p ==
   (\<forall> y . (e = SysC\<bullet>SysM(y) \<longrightarrow> 
              (case y of
                 [] \<Rightarrow> False
               | (arg1 # args1) \<Rightarrow> (case args1 of
                                      [] \<Rightarrow> False
                                    | (arg2 # args2) \<Rightarrow> (case arg2 of
                                                           INarg x \<Rightarrow> False
                                                         | RNarg x \<Rightarrow> (\<exists> m . llength (E\<lfloor>x\<rfloor>) h m \<and> compare m M)
                                                         | VALarg v \<Rightarrow> (case v of IVal i \<Rightarrow> False
                                                                                | RVal r \<Rightarrow> (\<exists> m . llength r h m \<and> compare m M)))))))"

constdefs Policy2::"nat \<Rightarrow> bool"
"Policy2 M == (\<forall> e E h p. InvS_policy e E h p = InvS_Policy2 M (\<lambda> m M . m < M) e E h p)"

(*Specialising vdmSys for this policy gives a more readable form*)
lemma vdmSysExplicit2:
"Policy2 M \<Longrightarrow> \<rhd> (SysC\<bullet>SysM([INarg x, RNarg a])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and>
                                  p = (\<exists> m R. (m,E\<lfloor>a\<rfloor>,R,h):mLIST \<and> m < M))"
apply (rule vdm_conseq, rule vdmSys, clarsimp)
apply( simp add: InvS_effect_def Policy2_def InvS_Policy2_def llength_def)
done

(*A first test of the policy*)
lemma "Policy2 42 \<Longrightarrow>
       \<rhd> (LET x = expr.Int 22; rf y = NULL IN SysC\<bullet>SysM([INarg x,RNarg y]) END): (\<lambda> E h hh v p. p = True)"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdm_letr, rule vdm_null)
apply (erule vdmSysExplicit2, clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
apply (simp add: Letr_effect_def Null_effect_def) 
apply (simp add: Policy2_def InvS_Policy2_def)
apply (rule,rule, rule, rule mLIST_NIL, simp)
done
(*Second test*)
lemma mLIST_Preserved[rule_format]:
"(n, r, R, h) \<in> mLIST \<Longrightarrow> (\<forall> h1. (\<forall> l. l \<in> R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (n, r, R, h1) \<in> mLIST)"
(*<*)
apply (erule mLIST.induct)
apply clarsimp
apply (rule mLIST_NIL)
apply clarsimp
apply (rule mLIST_CONS)
apply (subgoal_tac "fmap_lookup (oheap h1) a = Some C", assumption)
  apply (erule_tac x=a in allE, clarsimp) apply (simp add: sameOH_def) 
apply (erule_tac x=a in allE, clarsimp) apply (simp add: sameOH_def)
  apply (erule_tac x=a in allE, clarsimp, simp add: sameOH_def)
apply assumption
apply (subgoal_tac "h\<lfloor>a\<diamondsuit>TL\<rfloor>=h1\<lfloor>a\<diamondsuit>TL\<rfloor>", clarsimp)
apply (erule_tac x=h1 in allE)
  apply (erule impE) apply clarsimp
  apply assumption
  apply (erule_tac x=a in allE, clarsimp, simp add: sameOH_def)
apply fastsimp+
done
(*>*)
lemma mLIST_region_in_heap:"(n, r, R, h) \<in> mLIST \<Longrightarrow> R \<subseteq> Dom h"
(*<*)
apply (erule mLIST.induct,fast)
apply (subgoal_tac "a:Dom h",fast) 
apply (simp add: fmap_lookup_def fmap_dom_def,fastsimp)
done
(*>*)
lemma "\<lbrakk>Policy2 (Suc M); y \<noteq> z\<rbrakk> \<Longrightarrow>
       \<rhd> (LET rf y = New C [] []; _ = PutFr y TL z IN SysC\<bullet>SysM([INarg x,RNarg y]) END):
              (\<lambda> E h hh v p. p = (\<exists> m R. (m,E\<lfloor>z\<rfloor>,R,h):mLIST \<and> m < M))"
apply (rule vdm_conseq)
apply (rule vdm_letr, rule vdm_new)
apply (rule vdm_letv, rule vdm_putfr)
apply (erule vdmSysExplicit2, clarsimp)
apply (simp add: Letr_effect_def New_effect_def newObj_def) 
apply (simp add: Letv_effect_def PutFr_effect_def) 
apply safe
apply (erule mLIST.elims)
  apply simp
  apply clarsimp
  apply (rule_tac x=n in exI, simp)
  apply (rule_tac x=X in exI) apply(erule mLIST_Preserved) apply (simp add: sameOH_def)
  apply safe apply (simp add: FMAPlookup1) 
apply (rule_tac x="Suc m" in exI, simp)
apply (rule_tac x="insert (freshloc (Dom h)) R" in exI)
apply (rule mLIST_CONS) apply simp apply simp apply simp 
  apply (subgoal_tac "freshloc (Dom h) \<notin> R", assumption) 
  apply (subgoal_tac "freshloc (Dom h) \<notin> Dom h") prefer 2 apply (rule freshloc, rule finite_dom_fmap)
  apply (drule mLIST_region_in_heap, fast)
  apply (frule mLIST_region_in_heap)
  apply (subgoal_tac "freshloc (Dom h) \<notin> R") 
  prefer 2 apply (subgoal_tac "freshloc (Dom h) \<notin> Dom h", fast) apply (rule freshloc, rule finite_dom_fmap)
  apply (erule mLIST_Preserved)  apply (simp add: sameOH_def)
  apply safe apply (simp add: FMAPlookup1) 
done

lemma "E \<turnstile> h,e \<Down> hh,v,(p::'a) \<Longrightarrow> (\<exists> q . E \<turnstile> h,e \<Down> hh,v,(q::'b))"
apply (simp add: sem_def, clarsimp)
apply (erule semn.induct)
apply (rule, rule, rule semNull)
apply (rule, rule, rule semInt)
apply (rule, rule, rule semIVar)
apply (rule, rule, rule semRVar)
apply (rule, rule, rule semPrimop)
apply (rule, rule, rule semRPrimop)
apply (rule, rule, erule semGetfi, assumption)
apply (rule, rule, erule semGetfr, assumption)
apply (rule, rule, erule semPutfi, assumption)
apply (rule, rule, erule semPutfr, assumption)
apply (rule, rule, rule semGetstat)
apply (rule, rule, rule semPutstat)
apply (rule, rule, erule semNew)
apply clarsimp apply (rule, rule, rule semIf_True)  apply simp apply simp
apply clarsimp apply (rule, rule, rule semIf_False)  apply simp apply simp
apply clarsimp apply (rule, rule, erule semLeti) apply simp 
apply clarsimp apply (rule, rule, erule semLetr) apply simp 
apply clarsimp apply (rule, rule, erule semLetv) apply simp 
apply clarsimp apply (rule, rule, erule semCall) 
apply clarsimp apply (rule, rule, erule semInvoke)  apply simp apply simp apply simp
apply clarsimp apply (rule, rule, rule semInvokeStatic)  apply simp apply simp 
done

constdefs InvS_Policy1::"nat \<Rightarrow> (int \<Rightarrow> nat \<Rightarrow> bool) \<Rightarrow> expr \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool \<Rightarrow> bool"
"InvS_Policy1 M compare e E h p ==
   (\<forall> y . (e = SysC\<bullet>SysM(y) \<longrightarrow> (case y of [] \<Rightarrow> False
                                   | (arg # args) \<Rightarrow> (case arg of INarg x \<Rightarrow> (compare (E<x>) M)
                                                                     | RNarg x \<Rightarrow> False
                                                                     | VALarg v \<Rightarrow> case v of IVal i \<Rightarrow> compare i M
                                                                                           | RVal r \<Rightarrow> False))))"

constdefs Policy1::"nat \<Rightarrow> bool"
"Policy1 M == (\<forall> e E h p. InvS_policy e E h p = InvS_Policy1 M (\<lambda> m M . 0 <= m \<and> m < (int M)) e E h p)"

(*Specialising vdmSys for this policy gives a more readable form*)
lemma vdmSysExplicit1:"Policy1 M \<Longrightarrow> 
        \<rhd> (SysC\<bullet>SysM([INarg x, RNarg a])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and> p = (0 <= E<x> \<and> E<x> < (int M)))"
by (rule vdm_conseq,rule vdmSys, simp add: InvS_effect_def Policy1_def InvS_Policy1_def)

(*A first test of the policy*)

lemma "Policy1 42 \<Longrightarrow> \<rhd> (Leti x (expr.Int 21) (SysC\<bullet>SysM([INarg x, RNarg a]))): (\<lambda> E h hh v p. p = True)"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (erule vdmSysExplicit1, clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
done
(*Second test*)
lemma "Policy1 42 \<Longrightarrow> \<rhd> (Leti x (expr.Int 55) (SysC\<bullet>SysM([INarg x, RNarg a]))): (\<lambda> E h hh v p. p = False)"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (erule vdmSysExplicit1, clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
done
(*More general:*)
lemma "Policy1 M \<Longrightarrow> \<rhd> (Leti x (expr.Int i) (SysC\<bullet>SysM([INarg x, RNarg a]))): (\<lambda> E h hh v p. p = (0 <= i \<and> i < (int M)))"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (erule vdmSysExplicit1, clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
done

(*policy-independent proof rule for immediate integer arguments*)
lemma vdmSys2:"Policy1 M \<Longrightarrow> \<rhd> (SysC\<bullet>SysM([VALarg (IVal i), RNarg a])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                                           p = InvS_policy (SysC\<bullet>SysM([VALarg (IVal i), RNarg a])) E h True)"
apply (rule vdm_invokestatic)
apply clarsimp
apply (simp add: MTSys)
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (simp add: InvS_effect_def)
apply (simp add: Null_effect_def)
done

(*policy-independent proof rule for reference arguments*)
lemma vdmSys3:"Policy1 M \<Longrightarrow> \<rhd> (SysC\<bullet>SysM([RNarg y, RNarg a])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                                           p = InvS_policy (SysC\<bullet>SysM([RNarg y, RNarg a])) E h True)"
apply (rule vdm_invokestatic)
apply clarsimp
apply (simp add: MTSys)
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (simp add: InvS_effect_def)
apply (simp add: Null_effect_def)
done

(*we can prove that a reference argument violates policy1. This amounts to some very basic type-checking
  But that interpretation is abit weird becuase of the partial correctness interpretation of assertions.*)
lemma "Policy1 M \<Longrightarrow> \<rhd> (Leti x (expr.Int 21) (SysC\<bullet>SysM([RNarg y, RNarg a]))): (\<lambda> E h hh v p. p = False)"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (erule vdmSys3, clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
apply (simp add: Policy1_def InvS_Policy1_def) 
done

(*Third policy - the conjunction of the first two, where the list length is a limit on the parameter: *)
constdefs Policy3::"(int \<Rightarrow> nat \<Rightarrow> bool) \<Rightarrow> (nat \<Rightarrow> nat \<Rightarrow> bool) \<Rightarrow> bool"
"Policy3 comp1 comp2 == 
  (\<forall> e E h p. InvS_policy e E h p = 
               (\<exists> M . InvS_Policy1 M comp1 e E h p \<and> InvS_Policy2 M comp2 e E h p))"
(*Specialising vdmSys for this policy gives a more readable form*)
lemma vdmSysExplicit3:"Policy3 comp1 comp2 \<Longrightarrow> 
        \<rhd> (SysC\<bullet>SysM([INarg x, RNarg a])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                               p = (\<exists> M . comp1 (E<x>) M \<and> (\<exists> m R. (m,E\<lfloor>a\<rfloor>,R,h):mLIST \<and> comp2 m M)))"
apply (rule vdm_conseq, rule vdmSys, clarsimp)
apply (simp add: Policy3_def InvS_Policy1_def  InvS_Policy2_def llength_def)
done

(*A first test of the policy*)


(*more interesting, we could easily formulate a policy where the first (Integer) argument 
  bounds the lgnth of the second (list) argument!*)

(*particularly interserting is "comp1 = equals" and "comp2 = leq"*)
lemma vdmSysExplicit4:"Policy3 (\<lambda> x y . 0 <= x \<and> (nat x) = y) (\<lambda> x y . x <= y) \<Longrightarrow> 
        \<rhd> (SysC\<bullet>SysM([INarg x, RNarg a])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                               p = (\<exists> m R. (m,E\<lfloor>a\<rfloor>,R,h):mLIST \<and> 0 <= E<x> \<and> (m <= (nat E<x>))))"
apply (rule vdm_conseq, rule vdmSys, clarsimp)
apply (simp add: Policy3_def InvS_Policy1_def  InvS_Policy2_def llength_def)
apply fastsimp
done

(*A first test of the policy*)
lemma "Policy3 (\<lambda> x y . 0 <= x \<and> (nat x) = y) (\<lambda> x y . x <= y) \<Longrightarrow>
       \<rhd> (LET x = expr.Int 22; rf y = NULL IN SysC\<bullet>SysM([INarg x,RNarg y]) END): (\<lambda> E h hh v p. p = True)"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdm_letr, rule vdm_null)
apply (erule vdmSysExplicit4, clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
apply (simp add: Letr_effect_def Null_effect_def)
apply (rule,rule, rule, rule mLIST_NIL, simp)
done
(*Second test*)
lemma "Policy3 (\<lambda> x y . 0 <= x \<and> (nat x) = y) (\<lambda> x y . x <= y) \<Longrightarrow>
       \<rhd> (LET x = expr.Int i; rf y = NULL IN SysC\<bullet>SysM([INarg x,RNarg y]) END): (\<lambda> E h hh v p. p = (0 <= i))"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdm_letr, rule vdm_null)
apply (erule vdmSysExplicit4, clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
apply (simp add: Letr_effect_def Null_effect_def)
apply rule apply clarsimp
apply (rule,rule, rule, rule mLIST_NIL, simp)
done
lemma "\<lbrakk>Policy3 (\<lambda> x y . 0 <= x \<and> (nat x) = y) (\<lambda> x y . x <= y); y \<noteq> z\<rbrakk> \<Longrightarrow>
       \<rhd> (LET x = expr.Int i; rf y = New C [] []; _ = PutFr y TL z IN SysC\<bullet>SysM([INarg x,RNarg y]) END):
           (\<lambda> E h hh v p. p = (\<exists> m R. (m,E\<lfloor>z\<rfloor>,R,h):mLIST \<and> 0 <= i \<and> m < nat i))"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdm_letr, rule vdm_new)
apply (rule vdm_letv, rule vdm_putfr)
apply (erule vdmSysExplicit4, clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
apply (simp add: Letr_effect_def New_effect_def newObj_def) 
apply (simp add: Letv_effect_def PutFr_effect_def) 
apply safe
apply (erule mLIST.elims)
  apply simp
  apply clarsimp
  apply (rule_tac x=n in exI, simp)
  apply (rule_tac x=X in exI) apply(erule mLIST_Preserved) apply (simp add: sameOH_def)
  apply safe apply (simp add: FMAPlookup1) 
apply (rule_tac x="Suc m" in exI, simp)
apply (rule_tac x="insert (freshloc (Dom h)) R" in exI)
apply (rule mLIST_CONS) apply simp apply simp apply simp 
  apply (subgoal_tac "freshloc (Dom h) \<notin> R", assumption) 
  apply (subgoal_tac "freshloc (Dom h) \<notin> Dom h") prefer 2 apply (rule freshloc, rule finite_dom_fmap)
  apply (drule mLIST_region_in_heap, fast)
  apply (frule mLIST_region_in_heap)
  apply (subgoal_tac "freshloc (Dom h) \<notin> R") 
  prefer 2 apply (subgoal_tac "freshloc (Dom h) \<notin> Dom h", fast) apply (rule freshloc, rule finite_dom_fmap)
  apply (erule mLIST_Preserved)  apply (simp add: sameOH_def)
  apply safe apply (simp add: FMAPlookup1) 
done
done

(*policy-independent proof rule for immediate integer arguments*)
lemma vdmSys2:"Policy1 M \<Longrightarrow> \<rhd> (SysC\<bullet>SysM([VALarg (IVal i), RNarg a])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                                           p = InvS_policy (SysC\<bullet>SysM([VALarg (IVal i), RNarg a])) E h True)"
apply (rule vdm_invokestatic)
apply clarsimp
apply (simp add: MTSys)
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (simp add: InvS_effect_def)
apply (simp add: Null_effect_def)
done

(*policy-independent proof rule for reference arguments*)
lemma vdmSys3:"Policy1 M \<Longrightarrow> \<rhd> (SysC\<bullet>SysM([RNarg y, RNarg a])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                                           p = InvS_policy (SysC\<bullet>SysM([RNarg y, RNarg a])) E h True)"
apply (rule vdm_invokestatic)
apply clarsimp
apply (simp add: MTSys)
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (simp add: InvS_effect_def)
apply (simp add: Null_effect_def)
done

(*we can prove that a reference argument violates policy1. This amounts to some very basic type-checking
  But that interpretation is abit weird becuase of the partial correctness interpretation of assertions.*)
lemma "Policy1 M \<Longrightarrow> \<rhd> (Leti x (expr.Int 21) (SysC\<bullet>SysM([RNarg y, RNarg a]))): (\<lambda> E h hh v p. p = False)"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (erule vdmSys3, clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
apply (simp add: Policy1_def InvS_Policy1_def) 
done


done
(*More general:*)
lemma "{} \<rhd> (Leti x (expr.Int i) (SysC\<bullet>SysM([INarg x]))): (\<lambda> E h hh v p. p = (i < 42))"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdmSysExplicit, clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
done

(*policy-independent proof rule for immediate integer arguments*)
lemma vdmSys2:" \<rhd> (SysC\<bullet>SysM([VALarg (IVal i)])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                                           p = InvS_policy (SysC\<bullet>SysM([VALarg (IVal i)])) E h True)"
apply (rule vdm_invokestatic)
apply clarsimp
apply (simp add: MTSys)
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (simp add: InvS_effect_def)
apply (simp add: Null_effect_def)
done

(*policy-independent proof rule for reference arguments*)
lemma vdmSys3:" \<rhd> (SysC\<bullet>SysM([RNarg y])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                                           p = InvS_policy (SysC\<bullet>SysM([RNarg y])) E h True)"
apply (rule vdm_invokestatic)
apply clarsimp
apply (simp add: MTSys)
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (simp add: InvS_effect_def)
apply (simp add: Null_effect_def)
done

(*we can prove that a reference argument violates policy1*)
lemma " \<rhd> (Leti x (expr.Int 21) (SysC\<bullet>SysM([RNarg y]))): (\<lambda> E h hh v p. p = False)"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdmSys3)
apply( clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
apply (simp add: Policy1)
done


