theory test = VDMSoundRecPC:


constdefs Morph::"('a \<Rightarrow> 'b) \<Rightarrow> ('a EFF) \<Rightarrow> ('b EFF) \<Rightarrow> bool"
"Morph f P Q == ((\<forall> x . f(Int_effect P x) = Int_effect Q x) \<and> 
                 (\<forall> x p. f(Call_effect P x p) = Call_effect Q x (f p))) \<and> 
                 (\<forall> x p1 p2. f(Leti_effect P x p1 p2) = Leti_effect Q x (f p1) (f p2))"

lemma "\<lbrakk>Morph f P Q; Morph g Q R\<rbrakk> \<Longrightarrow> Morph (g o f) P R"
by (simp add: Morph_def)

constdefs Id::"'a EFF \<Rightarrow> ('a \<Rightarrow> 'a)"
"Id A == (\<lambda> x . x)"
lemma "Morph (Id A) A A"
by (simp add: Id_def Morph_def)

constdefs mkC::"('b,'c) Effect \<Rightarrow> 'c \<Rightarrow> ('a \<Rightarrow> 'b) \<Rightarrow> ('a \<Rightarrow> 'b)"
"mkC Q == (\<lambda> eEh f a. Call_effect Q eEh (f a))"

constdefs EEffect ::"('b,'a) Effect \<Rightarrow> ('c,'b) Effect \<Rightarrow> ('c, 'a) Effect"
"EEffect P Q == \<lparr>Int_effect = \<lambda> eEh. Int_effect Q (Int_effect P eEh),
                 IVar_effect = \<lambda> eEh. IVar_effect Q (IVar_effect P eEh),
                 Primop_effect = \<lambda> eEh. Primop_effect Q (Primop_effect P eEh),
                 Null_effect = \<lambda> eEh. Null_effect Q (Null_effect P eEh),
                 RVar_effect = \<lambda> eEh. RVar_effect Q (RVar_effect P eEh),
                 RPrimop_effect = \<lambda> eEh. RPrimop_effect Q (RPrimop_effect P eEh),
                 New_effect = \<lambda> eEh. New_effect Q (New_effect P eEh),
                 GetFi_effect = \<lambda> eEh. GetFi_effect Q (GetFi_effect P eEh),
                 GetFr_effect = \<lambda> eEh. GetFr_effect Q (GetFr_effect P eEh),
                 PutFi_effect = \<lambda> eEh. PutFi_effect Q (PutFi_effect P eEh),
                 PutFr_effect = \<lambda> eEh. PutFr_effect Q (PutFr_effect P eEh),
                 GetStat_effect = \<lambda> eEh. GetStat_effect Q (GetStat_effect P eEh),
                 PutStat_effect = \<lambda> eEh. PutStat_effect Q (PutStat_effect P eEh),
                 InvV_effect = \<lambda> eEh c. InvV_effect Q (InvV_effect P eEh c) c,
                 InvS_effect = \<lambda> eEh c. InvS_effect Q (InvS_effect P eEh c) c,
                 Leti_effect = \<lambda> eEh c1 c2. Leti_effect Q (Leti_effect P eEh c1 c2) c1 c2,
                 Letr_effect = \<lambda> eEh c1 c2. Letr_effect Q (Letr_effect P eEh c1 c2) c1 c2,
                 Letv_effect = \<lambda> eEh c1 c2. Letv_effect Q (Letv_effect P eEh c1 c2) c1 c2,
                 If_effect = \<lambda> eEh c. If_effect Q (If_effect P eEh c) c,
                 Call_effect = \<lambda> eEh c. Call_effect Q (Call_effect P eEh c) c\<rparr>"

constdefs ExpEffect ::"('a,'c) Effect \<Rightarrow> ('b,'c) Effect \<Rightarrow> ('a \<Rightarrow> 'b, 'c) Effect"
"ExpEffect P Q == \<lparr>Int_effect = \<lambda> eEh a. Int_effect Q eEh,
                   IVar_effect = \<lambda> eEh a. IVar_effect Q eEh,
                   Primop_effect = \<lambda> eEh a. Primop_effect Q eEh,
                   Null_effect = \<lambda> eEh a. Null_effect Q eEh,
                   RVar_effect = \<lambda> eEh a. RVar_effect Q eEh,
                   RPrimop_effect = \<lambda> eEh a. RPrimop_effect Q eEh,
                   New_effect = \<lambda> eEh a. New_effect Q eEh,
                   GetFi_effect = \<lambda> eEh a. GetFi_effect Q eEh,
                   GetFr_effect = \<lambda> eEh a. GetFr_effect Q eEh,
                   PutFi_effect = \<lambda> eEh a. PutFi_effect Q eEh,
                   PutFr_effect = \<lambda> eEh a. PutFr_effect Q eEh,
                   GetStat_effect = \<lambda> eEh a. GetStat_effect Q eEh,
                   PutStat_effect = \<lambda> eEh a. PutStat_effect Q eEh,
                   InvV_effect = \<lambda> eEh f a. InvS_effect Q eEh (f a),
                   InvS_effect = \<lambda> eEh f a. InvS_effect Q eEh (f a),
                   Leti_effect = \<lambda> eEh f g a. Leti_effect Q eEh (f a) (g a),
                   Letr_effect = \<lambda> eEh f g a. Letr_effect Q eEh (f a) (g a),
                   Letv_effect = \<lambda> eEh f g a. Letv_effect Q eEh (f a) (g a),
                   If_effect = \<lambda> eEh f a. If_effect Q eEh (f a),
                   Call_effect = \<lambda> eEh f a. Call_effect Q eEh (f a)\<rparr>"

constdefs sharp::"(('a \<times> 'b) \<Rightarrow> 'c) \<Rightarrow> ('a \<Rightarrow> ('b \<Rightarrow> 'c))"
"sharp f == (\<lambda> a. (\<lambda> b. f(a,b)))"

lemma "Morph f (prodEffect A B) C \<Longrightarrow> Morph (sharp f) A (ExpEffect B C)"
apply (simp add: Morph_def prodEffect_def ExpEffect_def sharp_def, safe)
oops (* does not hold*)
        
done
(*Policies for invokestatics may be specified later*)
consts InvS_policy:: "(expr \<times> env \<times> heap) \<Rightarrow> 'a \<Rightarrow> 'a"

constdefs ParameterValues ::"bool EFF"
"ParameterValues == \<lparr>
  Int_effect = (\<lambda> eEh . True),
  IVar_effect = (\<lambda> eEh . True),
  Primop_effect = (\<lambda> eEh . True),
  Null_effect = (\<lambda> eEh . True),
  RVar_effect = (\<lambda> eEh . True),
  RPrimop_effect = (\<lambda> eEh . True),
  New_effect = (\<lambda> eEh . True),
  GetFi_effect = (\<lambda> eEh . True),
  GetFr_effect = (\<lambda> eEh . True),
  PutFi_effect = (\<lambda> eEh . True),
  PutFr_effect = (\<lambda> eEh . True),
  GetStat_effect = (\<lambda> eEh . True),
  PutStat_effect = (\<lambda> eEh . True),
  InvV_effect = (\<lambda> eEh p . p),

  InvS_effect = InvS_policy,
     
  Leti_effect = (\<lambda> eEh p1 p2 . p1 \<and> p2),
  Letr_effect = (\<lambda> eEh p1 p2 . p1 \<and> p2),
  Letv_effect = (\<lambda> eEh p1 p2 . p1 \<and> p2),
  If_effect = (\<lambda> eEh p. p),
  Call_effect = (\<lambda> eEh p . p)\<rparr>"

consts SysC::cname
       SysM::mname
       SysP1::iname
       SysP2::rname

axioms MTSys: "methtable SysC SysM = ([INpar SysP1, RNpar SysP2], Null)"

(*This axiom suffices for proving a derived VDM rule similar to the axiom in Martin's note:*)
lemma vdmSys:"G \<rhd> (SysC\<bullet>SysM([INarg x,RNarg a])) : (\<lambda> P E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                                          (P = ParameterValues \<longrightarrow> 
                                                           p = InvS_policy (SysC\<bullet>SysM([INarg x,RNarg a]),E,h) True))"
apply (rule vdm_invokestatic)
apply clarsimp
apply (simp add: MTSys)
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (simp add:ParameterValues_def)
done

subsection{*Paramater Policies*}
subsubsection{*Bounding the value of an integer-valued method argument *}
consts InvS_Policy1::"nat \<Rightarrow> (int \<Rightarrow> nat \<Rightarrow> bool) \<Rightarrow> (expr \<times> env \<times> heap) \<Rightarrow> bool \<Rightarrow> bool"
primrec
"InvS_Policy1 M compare (e, Eh) p =
 (case Eh of (E,h) \<Rightarrow>
   (\<forall> y . (e = SysC\<bullet>SysM(y) \<longrightarrow> (case y of [] \<Rightarrow> False
                                   | (arg # args) \<Rightarrow> (case arg of INarg x \<Rightarrow> (compare (E<x>) M)
                                                                     | RNarg x \<Rightarrow> False
                                                                     | VALarg v \<Rightarrow> case v of IVal i \<Rightarrow> compare i M
                                                                                           | RVal r \<Rightarrow> False)))))"

constdefs Policy1::"nat \<Rightarrow> bool"
"Policy1 M == (\<forall> e E h p.  InvS_policy (e, E, h) p = 
                             InvS_Policy1 M (\<lambda> m M . 0 <= m \<and> m < (int M)) (e, E, h) p)"

(*Specialising vdmSys for this policy gives a more readable form*)
lemma vdmSysExplicit1:"Policy1 M \<Longrightarrow> 
      G \<rhd> (SysC\<bullet>SysM([INarg x, RNarg a])) : (\<lambda> P E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                                (P = ParameterValues \<longrightarrow> p = (0 <= E<x> \<and> E<x> < (int M))))"
by (rule vdm_conseq,rule vdmSys, simp add: InvS_effect_def Policy1_def ParameterValues_def)

(*A first test of the policy*)
lemma "Policy1 42 \<Longrightarrow> \<rhd> (Leti x (expr.Int 21) (SysC\<bullet>SysM([INarg x, RNarg a]))): (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = ParameterValues \<longrightarrow> p))"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (erule vdmSysExplicit1, clarsimp)
apply (simp add: ParameterValues_def)
done
(*Second test*)
lemma "Policy1 42 \<Longrightarrow> \<rhd> (Leti x (expr.Int 21) (SysC\<bullet>SysM([INarg x, RNarg a]))): (\<lambda> P E h hh v p.  P = ParameterValues \<longrightarrow> p)"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (erule vdmSysExplicit1, clarsimp)
apply (simp add: ParameterValues_def)
done
(*Third test*)
lemma "Policy1 42 \<Longrightarrow> \<rhd> (Leti x (expr.Int 55) (SysC\<bullet>SysM([INarg x, RNarg a]))): (\<lambda> P E h hh v p. P = ParameterValues \<longrightarrow> \<not> p)"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (erule vdmSysExplicit1, clarsimp)
apply (simp add: ParameterValues_def) 
done
(*More general:*)
lemma "Policy1 M \<Longrightarrow> \<rhd> (Leti x (expr.Int i) (SysC\<bullet>SysM([INarg x, RNarg a]))): (\<lambda> P E h hh v p. P = ParameterValues \<longrightarrow> (p = (0 <= i \<and> i < (int M))))"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (erule vdmSysExplicit1, clarsimp)
apply (simp add: ParameterValues_def) 
done

(*policy-independent proof rule for immediate integer arguments*)
lemma vdmSys2:"G \<rhd> (SysC\<bullet>SysM([VALarg (IVal i), RNarg a])) : 
             (\<lambda> P E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                             (P = ParameterValues \<longrightarrow> p = InvS_policy (SysC\<bullet>SysM([VALarg (IVal i), RNarg a]), E, h) True))"
apply (rule vdm_invokestatic)
apply (simp add: MTSys)
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (simp add: ParameterValues_def)
done

(*policy-independent proof rule for reference arguments*)
lemma vdmSys3:
"Policy1 M \<Longrightarrow> 
 G \<rhd> (SysC\<bullet>SysM([RNarg y, RNarg a])) : (\<lambda> P E h hh v p . h=hh \<and> v= RVal Nullref \<and> (P = ParameterValues \<longrightarrow> \<not> p))"
apply (rule vdm_invokestatic)
apply clarsimp
apply (simp add: MTSys)
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (simp add: Policy1_def)
apply (simp add: ParameterValues_def)
done
(*Thus, we can prove that a reference argument violates policy1. This amounts to some very basic type-checking
  But that interpretation is a bit weird becuase of the partial correctness interpretation of assertions.*)

subsubsection{*Statically bounding the size of a data structure pointed to by a pointer-valued method argument *}
consts TL :: rfldname
       HD :: ifldname
consts mLIST::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
(*non-cyclic lists of length n (i.e. n cons-nodes)*)
inductive mLIST intros
mLIST_NIL: "(0,Nullref,{},h) : mLIST"
mLIST_CONS:"\<lbrakk>h@@a = Some C; h\<lfloor>a\<diamondsuit>TL\<rfloor> = r; h<a\<bullet>HD> = i; a \<notin> X; (n,r,X,h):mLIST; m=Suc n;XX=X \<union> {a}\<rbrakk>
          \<Longrightarrow> (m, Ref a, XX, h): mLIST"

lemma mLIST_Preserved[rule_format]:
"(n, r, R, h) \<in> mLIST \<Longrightarrow> (\<forall> h1. (\<forall> l. l \<in> R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (n, r, R, h1) \<in> mLIST)"
(*<*)
apply (erule mLIST.induct)
apply clarsimp
apply (rule mLIST_NIL)
apply clarsimp
apply (rule mLIST_CONS)
apply (subgoal_tac "fmap_lookup (oheap h1) a = Some C", assumption)
  apply (erule_tac x=a in allE, clarsimp) apply (simp add: sameOH_def) 
apply (erule_tac x=a in allE, clarsimp) apply (simp add: sameOH_def)
  apply (erule_tac x=a in allE, clarsimp, simp add: sameOH_def)
apply assumption
apply (subgoal_tac "h\<lfloor>a\<diamondsuit>TL\<rfloor>=h1\<lfloor>a\<diamondsuit>TL\<rfloor>", clarsimp)
apply (erule_tac x=h1 in allE)
  apply (erule impE) apply clarsimp
  apply assumption
  apply (erule_tac x=a in allE, clarsimp, simp add: sameOH_def)
apply fastsimp+
done
(*>*)
lemma mLIST_region_in_heap:"(n, r, R, h) \<in> mLIST \<Longrightarrow> R \<subseteq> Dom h"
(*<*)
apply (erule mLIST.induct,fast)
apply (subgoal_tac "a:Dom h",fast) 
apply (simp add: fmap_lookup_def fmap_dom_def,fastsimp)
done
(*>*)

(*Second policy: a policy that that requires the second argument to the system method 
 to be a pointer to a list whose length is less than a given number*)
constdefs llength::"ref \<Rightarrow> heap \<Rightarrow> nat \<Rightarrow> bool"
"llength r h M == (\<exists> R . (M,r,R,h):mLIST)"

consts InvS_Policy2::"nat \<Rightarrow> (nat \<Rightarrow> nat \<Rightarrow> bool) \<Rightarrow> (expr \<times> env \<times> heap) \<Rightarrow> bool \<Rightarrow> bool"
primrec
"InvS_Policy2 M compare (e, Eh) p =
   (case Eh of (E,h) \<Rightarrow>
        (\<forall> y . (e = SysC\<bullet>SysM(y) \<longrightarrow> 
               (0 < length y \<and> (case y!1 of INarg x \<Rightarrow> False
                                         | RNarg x \<Rightarrow> (\<exists> m . llength (E\<lfloor>x\<rfloor>) h m \<and> compare m M)
                                         | VALarg v \<Rightarrow> (case v of IVal i \<Rightarrow> False
                                                                | RVal r \<Rightarrow> (\<exists> m . llength r h m \<and> compare m M)))))))"

constdefs Policy2::"nat \<Rightarrow> bool"
"Policy2 M == (\<forall> e E h p. InvS_policy (e, E, h) p = InvS_Policy2 M (\<lambda> m M . m < M) (e, E, h) p)"

(*Specialising vdmSys for this policy gives a more readable form*)
lemma vdmSysExplicit2:
"Policy2 M \<Longrightarrow> G \<rhd> (SysC\<bullet>SysM([INarg x, RNarg a])) : 
                    (\<lambda> P E h hh v p . h=hh \<and> v= RVal Nullref \<and>
                                      (P = ParameterValues \<longrightarrow> p = (\<exists> m R. (m,E\<lfloor>a\<rfloor>,R,h):mLIST \<and> m < M)))"
by (rule vdm_conseq, rule vdmSys, clarsimp,
    simp add: InvS_effect_def Policy2_def ParameterValues_def llength_def)

(*A first test of the policy*)
lemma "Policy2 42 \<Longrightarrow>
       \<rhd> (LET x = expr.Int 22; rf y = NULL IN SysC\<bullet>SysM([INarg x,RNarg y]) END):
            (\<lambda> P E h hh v p. (P = ParameterValues \<longrightarrow> p))"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdm_letr, rule vdm_null)
apply (erule vdmSysExplicit2, clarsimp)
apply (simp add: Policy2_def ParameterValues_def)
apply (rule,rule, rule, rule mLIST_NIL, simp)
done

(*Second test*)
lemma "\<lbrakk>Policy2 (Suc M); y \<noteq> z\<rbrakk> \<Longrightarrow>
       \<rhd> (LET rf y = New C [] []; _ = PutFr y TL z IN SysC\<bullet>SysM([INarg x,RNarg y]) END):
              (\<lambda> P E h hh v p. (P = ParameterValues \<longrightarrow> p = (\<exists> m R. (m,E\<lfloor>z\<rfloor>,R,h):mLIST \<and> m < M)))"
apply (rule vdm_conseq)
apply (rule vdm_letr, rule vdm_new)
apply (rule vdm_letv, rule vdm_putfr)
apply (erule vdmSysExplicit2, clarsimp)
apply (simp add: ParameterValues_def newObj_def) 
apply safe
apply (erule mLIST.elims)
  apply simp
  apply clarsimp
  apply (rule_tac x=n in exI, simp)
  apply (rule_tac x=X in exI) apply(erule mLIST_Preserved) apply (simp add: sameOH_def)
  apply safe apply (simp add: FMAPlookup1) 
apply (rule_tac x="Suc m" in exI, simp)
apply (rule_tac x="insert (freshloc (Dom h)) R" in exI)
apply (rule mLIST_CONS) apply simp apply simp apply simp 
  apply (subgoal_tac "freshloc (Dom h) \<notin> R", assumption) 
  apply (subgoal_tac "freshloc (Dom h) \<notin> Dom h") prefer 2 apply (rule freshloc, rule finite_dom_fmap)
  apply (drule mLIST_region_in_heap, fast)
  apply (frule mLIST_region_in_heap)
  apply (subgoal_tac "freshloc (Dom h) \<notin> R") 
  prefer 2 apply (subgoal_tac "freshloc (Dom h) \<notin> Dom h", fast) apply (rule freshloc, rule finite_dom_fmap)
  apply (erule mLIST_Preserved)  apply (simp add: sameOH_def)
  apply safe apply (simp add: FMAPlookup1) 
done

subsubsection{*Dynamically bounding the size of a data structure pointed to by a pointer-valued method argument 
               by an integer-valued argument*}

(*Third policy - the conjunction of the first two, where the list length is a limit on the parameter: *)
constdefs Policy3::"(int \<Rightarrow> nat \<Rightarrow> bool) \<Rightarrow> (nat \<Rightarrow> nat \<Rightarrow> bool) \<Rightarrow> bool"
"Policy3 comp1 comp2 == 
  (\<forall> e E h p. InvS_policy (e, E, h) p = 
               (\<exists> M . InvS_Policy1 M comp1 (e, E, h) p \<and> InvS_Policy2 M comp2 (e, E, h) p))"

(*Specialising vdmSys for this policy gives a more readable form*)
lemma vdmSysExplicit3:
"Policy3 comp1 comp2 \<Longrightarrow> 
 G \<rhd> (SysC\<bullet>SysM([INarg x, RNarg a])) : 
         (\<lambda> P E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                         (P = ParameterValues \<longrightarrow> (p = (\<exists> M . comp1 (E<x>) M \<and> 
                                                              (\<exists> m R. (m,E\<lfloor>a\<rfloor>,R,h):mLIST \<and> comp2 m M)))))"
by (rule vdm_conseq, rule vdmSys, clarsimp,
    simp add: Policy3_def ParameterValues_def llength_def)

(*More interestingly, we can easily formulate a policy where the first (Integer) argument 
  bounds the legnth of the second (list) argument! In particular, we instantiate "comp1 = equals" and "comp2 = leq"
  and change the quantification*)
lemma vdmSysExplicit4:"Policy3 (\<lambda> x y . 0 <= x \<and> (nat x) = y) (\<lambda> x y . x <= y) \<Longrightarrow> 
      G \<rhd> (SysC\<bullet>SysM([INarg x, RNarg a])) : (\<lambda> P E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                               (P = ParameterValues \<longrightarrow> p = (\<exists> m R. (m,E\<lfloor>a\<rfloor>,R,h):mLIST \<and> 0 <= E<x> \<and> (m <= (nat E<x>)))))"
apply (rule vdm_conseq, rule vdmSys, clarsimp)
apply (simp add: Policy3_def ParameterValues_def llength_def)
apply fastsimp
done

(*A first test of the policy*)
lemma "Policy3 (\<lambda> x y . 0 <= x \<and> (nat x) = y) (\<lambda> x y . x <= y) \<Longrightarrow>
       \<rhd> (LET x = expr.Int 22; rf y = NULL IN SysC\<bullet>SysM([INarg x,RNarg y]) END): (\<lambda> P E h hh v p. P = ParameterValues \<longrightarrow> p)"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdm_letr, rule vdm_null)
apply (erule vdmSysExplicit4, clarsimp)
apply (simp add: ParameterValues_def) 
apply (rule,rule, rule, rule mLIST_NIL, simp)
done

(*Second test*)
lemma "Policy3 (\<lambda> x y . 0 <= x \<and> (nat x) = y) (\<lambda> x y . x <= y) \<Longrightarrow>
       \<rhd> (LET x = expr.Int i; rf y = NULL IN SysC\<bullet>SysM([INarg x,RNarg y]) END): (\<lambda> P E h hh v p. P = ParameterValues \<longrightarrow> p = (0 <= i))"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdm_letr, rule vdm_null)
apply (erule vdmSysExplicit4, clarsimp)
apply (simp add: ParameterValues_def) 
apply rule apply clarsimp
apply (rule,rule, rule, rule mLIST_NIL, simp)
done
lemma "\<lbrakk>Policy3 (\<lambda> x y . 0 <= x \<and> (nat x) = y) (\<lambda> x y . x <= y); y \<noteq> z\<rbrakk> \<Longrightarrow>
       \<rhd> (LET x = expr.Int i; rf y = New C [] []; _ = PutFr y TL z IN SysC\<bullet>SysM([INarg x,RNarg y]) END):
           (\<lambda> P E h hh v p. P = ParameterValues \<longrightarrow> p = (\<exists> m R. (m,E\<lfloor>z\<rfloor>,R,h):mLIST \<and> 0 <= i \<and> m < nat i))"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdm_letr, rule vdm_new)
apply (rule vdm_letv, rule vdm_putfr)
apply (erule vdmSysExplicit4, clarsimp)
apply (simp add: ParameterValues_def newObj_def) 
apply safe
apply (erule mLIST.elims)
  apply simp
  apply clarsimp
  apply (rule_tac x=n in exI, simp)
  apply (rule_tac x=X in exI) apply(erule mLIST_Preserved) apply (simp add: sameOH_def)
  apply safe apply (simp add: FMAPlookup1) 
apply (rule_tac x="Suc m" in exI, simp)
apply (rule_tac x="insert (freshloc (Dom h)) R" in exI)
apply (rule mLIST_CONS) apply simp apply simp apply simp 
  apply (subgoal_tac "freshloc (Dom h) \<notin> R", assumption) 
  apply (subgoal_tac "freshloc (Dom h) \<notin> Dom h") prefer 2 apply (rule freshloc, rule finite_dom_fmap)
  apply (drule mLIST_region_in_heap, fast)
  apply (frule mLIST_region_in_heap)
  apply (subgoal_tac "freshloc (Dom h) \<notin> R") 
  prefer 2 apply (subgoal_tac "freshloc (Dom h) \<notin> Dom h", fast) apply (rule freshloc, rule finite_dom_fmap)
  apply (erule mLIST_Preserved)  apply (simp add: sameOH_def)
  apply safe apply (simp add: FMAPlookup1) 
done

consts f::funame
       n::iname
       b::iname
       y::rname
       l::rname
       C::cname
axioms f_def: "funtable f = ([INpar n, RNpar l],
                         LET n = Primop (\<lambda> x y . x+1) n n;
                             rf y = New C [] [];
                                _ = PutFi y HD n;
                                _ = PutFr y TL l;
                             rf l = RVar y;
                                _ = SysC\<bullet>SysM([INarg n,RNarg l]);
                                b = Primop (\<lambda> x y . if x < 42 then 1 else 0) n n
                         IN IF b THEN CALL f ELSE RVar l END)"

lemma L: "\<lbrakk>(m, renv E l, R, h) \<in> mLIST; 0 <= E<n>; m \<le> nat (E<n>)\<rbrakk>
       \<Longrightarrow> \<exists>m. (\<exists>R. (m, Ref (freshloc (Dom h)), R,
                    \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fC),
                       iheap = (iheap h)(HD := (iheap h HD)(freshloc (Dom h) := ienv E n + 1)),
                       rheap = (rheap h)(TL := (rheap h TL)(freshloc (Dom h) := renv E l)), sheap = sheap h\<rparr>)
                   \<in> mLIST) \<and>
              m \<le> nat (ienv E n + 1)"
    apply (rule_tac x="Suc m" in exI, rule) apply rule apply (rule mLIST_CONS) apply simp
      prefer 3 apply (subgoal_tac "freshloc (Dom h) \<notin> R", assumption) 
                 apply (subgoal_tac "freshloc (Dom h) \<notin> Dom h") prefer 2 apply (rule freshloc, rule finite_dom_fmap)
                      apply (drule mLIST_region_in_heap, fast)
      prefer 3 apply (rule mLIST_Preserved, assumption) apply (simp add: sameOH_def)
                    apply rule apply clarsimp
                    apply (subgoal_tac "freshloc (Dom h) \<notin> R", fast) 
                    apply (subgoal_tac "freshloc (Dom h) \<notin> Dom h") prefer 2 apply (rule freshloc, rule finite_dom_fmap)
                      apply (drule mLIST_region_in_heap, fast) 
                    apply clarsimp apply (simp add: FMAPlookup1) 
                    apply simp apply simp apply simp apply simp apply arith
done

lemma "\<lbrakk>Policy3 (\<lambda> x y . 0 <= x \<and> (nat x) = y) (\<lambda> x y . x <= y); y \<noteq> l; n \<noteq> b\<rbrakk> \<Longrightarrow>
       \<rhd> (CALL f):
           (\<lambda> P E h hh v p. (\<exists> m R. (m,E\<lfloor>l\<rfloor>,R,h):mLIST \<and> 0 <= E<n> \<and> m <= nat(E<n>) \<and> E<n> <= 42 \<and> P = ParameterValues) \<longrightarrow> p = True)"
apply (rule vdm_call, simp add:f_def)
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_new)  prefer 2 apply (simp add: newObj_def) apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, erule vdmSysExplicit4)  prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
apply (rule vdm_if)
apply (rule vdm_ax) apply simp
apply (rule vdm_rvar)
apply clarsimp
apply (simp add: ParameterValues_def)
apply rule
apply clarsimp 
  apply rule apply (erule L) apply assumption+ apply (erule mp) apply (erule L) apply assumption+ 
apply clarsimp apply (erule L) apply simp apply assumption
done

"\<rhd> (CALL f):
   (\<lambda> P E h hh v p. (v = False \<longrightarrow> multiply p = E<x>)"
done
