theory mil = VDMderived:

text {* datatype for effect: alloc, read, write, loop, parametrized possibly by a region:
here, rather pointlessly by object level grail types  *}
datatype 'a meff = AllEff 'a | RdEff 'a | WrtEff 'a | LoopEff

datatype GrailType = INTty | LOCty

(*Policies for invokestatics may be specified later
consts InvS_policy:: "(expr \<times> env \<times> heap) \<Rightarrow> 'a \<Rightarrow> 'a"
*)

consts rho :: 'a
constdefs MilEff ::"(GrailType  meff set) EFF"
"MilEff == \<lparr>
  Int_effect = (\<lambda> eEh . {}),
  IVar_effect = (\<lambda> eEh . {}),
  Primop_effect = (\<lambda> eEh . {}),
  Null_effect = (\<lambda> eEh . {}),
  RVar_effect = (\<lambda> eEh . {}),
  RPrimop_effect = (\<lambda> eEh . {}),
  New_effect = (\<lambda> eEh . {AllEff LOCty}),
  GetFi_effect = (\<lambda> eEh . {RdEff LOCty}),
  GetFr_effect = (\<lambda> eEh . {RdEff LOCty}),
  PutFi_effect = (\<lambda> eEh . {WrtEff INTty}),
  PutFr_effect = (\<lambda> eEh . {WrtEff LOCty}),
  GetStat_effect = (\<lambda> eEh . {RdEff LOCty}),
  PutStat_effect = (\<lambda> eEh . {WrtEff LOCty}),
  InvV_effect = (\<lambda> eEh p . insert LoopEff p),

  InvS_effect = (\<lambda> eEh p . insert LoopEff p),
     
  Leti_effect = (\<lambda> eEh p1 p2 . p1 \<union>  p2),
  Letr_effect = (\<lambda> eEh p1 p2 . p1 \<union> p2),
  Letv_effect = (\<lambda> eEh p1 p2 . p1 \<union> p2),
  If_effect = (\<lambda> eEh p . p),
  Call_effect = (\<lambda> eEh p . insert LoopEff p) \<rparr>"



types MEFF = "( GrailType meff set)"


text  {* observational implication *}

types 'a vdmtriple = " expr \<times> expr \<times>  'a vdmassn"


types obcxt = "(MEFF vdmtriple) set"


consts obimp :: "(MEFF vdmcontext \<times> MEFF vdmtriple) set"

syntax obimp_deriv :: "MEFF vdmcontext \<Rightarrow>  expr \<Rightarrow> expr \<Rightarrow> MEFF vdmassn \<Rightarrow> bool"
		  ("_ \<rhd>  _ \<leadsto>_: _ " [900,100,100,100] 50)


translations "G \<rhd> e \<leadsto> f : A" == "(G,e,f,A) \<in> obimp"


inductive obimp intros

ob_drop_v: "\<lbrakk>G \<rhd> e1 : A1; G \<rhd> e2 : A2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Letv e1 e2) \<leadsto> e2 :
                (\<lambda> P E h hh v p  . \<exists> p1 p2 h1 w tty . (A1 P E h h1 w p1) \<and> p1 \<subseteq> {RdEff tty} \<and> 
                                                (A2  P E h1 hh v p2) \<and>
                                                 p = (Letv_effect P) (Letv e1 e2, E, h) p1 p2)"


ob_conseq: "\<lbrakk>G \<rhd> e  \<leadsto> f : A; (\<forall> P E h hh v p . (A  P E h hh v p ) \<longrightarrow> (Q  P E h hh v p ))\<rbrakk>
            \<Longrightarrow> G \<rhd> e  \<leadsto> f : Q"


lemma " G \<rhd> (Letv (expr.Int i) NULL) \<leadsto> NULL :  (\<lambda> P E h hh v p .P = MilEff \<longrightarrow>  p = {})" 
apply (rule obimp.intros)+
apply(rule vdm_basics)+
apply (unfold MilEff_def)
by force


lemma " ! rn fl. G \<rhd> (Letv (GetFi rn fl) NULL) \<leadsto> NULL :  (\<lambda> P E h hh v p .P = MilEff \<longrightarrow>  p = {RdEff LOCty})"
apply clarify 
apply (rule obimp.intros)+
apply(rule vdm_basics)+
apply clarify
apply (unfold MilEff_def)
apply simp
done




lemma " {} \<rhd> (Letv (expr.Int 1) (Letv (expr.Int 2) NULL)) \<leadsto> NULL :  (\<lambda> P E h hh v p .P = MilEff \<longrightarrow>  p = {})" 
oops
(*
apply (rule obimp.intros)
apply (rule ob_drop_v)
apply(rule vdm_basics)+
apply (unfold MilEff_def)
by force


lemma " ! rn fl rr. G \<rhd> (Letv (PutFr rn fl rr) NULL) \<leadsto> NULL :  (\<lambda> P E h hh v p .P = MilEff \<longrightarrow>  True)"
apply clarify 
apply (rule obimp.intros)+
apply(rule vdm_basics)+
apply clarify
*)



(*
consts ob_imp :: "(MEFF vdmcontext \<times> MEFF vdmtriple) set"


syntax ob_imp_deriv :: "MEFF vdmcontext \<Rightarrow>  expr \<Rightarrow> expr \<Rightarrow> MEFF vdmassn \<Rightarrow> bool"
		  ("_ \<rhd>  _ \<hookrightarrow>_: _ " [900,100,100,100] 50)


translations "G \<rhd> e \<hookrightarrow> f : A" == "(G,e,f,A) \<in> ob_imp"


inductive ob_imp intros

ob_drop_v: "\<lbrakk>G \<rhd> e1 : A1; G \<rhd> e2 : A2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Letv e1 e2) \<hookrightarrow> e2 :
                (\<lambda> P E h hh v p  . \<exists> p1 p2 h1 w  . (A1 P E h h1 w p1) \<and> 
                                                   (A2 P E h1 hh v p2) \<and>
                                                    p = (Letv_effect P) (Letv e1 e2, E, h) p1 p2)"

ob_conseq: "\<lbrakk>G \<rhd> e  \<hookrightarrow> f : A; (\<forall> P E h hh v p . (A  P E h hh v p ) \<longrightarrow> (Q  P E h hh v p ))\<rbrakk>
            \<Longrightarrow> G \<rhd> e  \<hookrightarrow> f : Q"

*)
consts ob_imp :: "(expr * expr) set"
(*
syntax obi_mp_deriv :: "expr \<Rightarrow> expr \<Rightarrow> bool"
		  (" _ \<leadsto>_" [400] 50)


translations "e \<leadsto> f " == "(e,f) \<in> ob_imp"
*)

inductive ob_imp intros

ob_drop_v: "\<lbrakk>G \<rhd> e1 : (\<lambda> P E h hh v p  . P = MilEff \<longrightarrow> ((A1 P E h hh v p) \<and> p \<subseteq> {RdEff INTty}))\<rbrakk> \<Longrightarrow>
           (Letv e1 e2, e2):ob_imp" 
ob_trans: "\<lbrakk>(e1,e2):ob_imp;(e2,e3):ob_imp\<rbrakk> \<Longrightarrow> (e1,e3):ob_imp"

lemma "(Letv (expr.Int 1) (Letv (expr.Int 2) Null), Null):ob_imp"
apply (rule ob_imp.intros)+
apply(rule vdm_conseq)
apply(rule vdm_int)
apply clarify
prefer 2
apply (rule ob_imp.intros)+
apply(rule vdm_conseq)
apply(rule vdm_int)
apply clarify
apply (unfold MilEff_def)
apply simp_all
done


lemma " (Letv (expr.Int i) NULL) \<leadsto> NULL" 
apply (rule ob_imp.intros)+
apply(rule vdm_conseq)
apply(rule vdm_int)
apply clarify
apply (unfold MilEff_def)
by force



lemma " ! rn fl rr. (Letv (PutFr rn fl rr) NULL) \<leadsto> NULL "
apply clarify 
apply (rule ob_imp.intros)+
apply(rule vdm_conseq)
apply(rule vdm_basics)+
apply clarify
apply (unfold MilEff_def)
apply simp
oops



lemma " (Letv (expr.Int 1) (Letv (expr.Int 2) NULL)) \<leadsto> NULL" 
sorry
lemma "e=(LET _ = (expr.Int 2) IN Null END) \<Longrightarrow> (Letv (expr.Int 1) e, Null):ob_imp" 
apply (rule ob_imp.intros)
apply(rule vdm_conseq)
apply(rule vdm_int)
apply clarify
apply (unfold MilEff_def)

end

constdefs obimp :: "expr \<Rightarrow> expr => bool"

constdefs  obimp1 "expr \<Rightarrow> expr => (MEFF vdmassn) \<Rightarrow> bool"

"obimp e1 e2 == (\<forall> Q1 Q2 G.  ((G \<rhd> e1 : Q1) &  (G \<rhd> e2 : Q2)) \<longrightarrow> 
                                (\<forall> P E h  hh  v  (p :: MEFF) . (Q1  P E h  hh  v  p)  \<longrightarrow>  (Q2  P E h  hh  v  p)))"


end


constdefs obimpP :: "expr \<Rightarrow> expr => (MEFF vdmassn) \<Rightarrow> bool"

"obimpP e1 e2 P == (\<forall> Q1 Q2 G.  ((G \<rhd> e1 : Q1) &  (G \<rhd> e2 : Q2)) \<longrightarrow> 
                                (\<forall> P E h  hh  v  (p :: MEFF) . (Q1  P E h  hh  v  p)  \<longrightarrow>  (Q2  P E h  hh  v  p)))"



end




