header {*Axiomatic semantics*}
(*<*)
theory VDMpc = Lemmas:
(*>*)

subsection {* The derivation system*}

types 'a vdmassn = "['a EFF, env, heap, heap, val, 'a] \<Rightarrow> bool"

types 'a vdmtuple = " expr \<times> 'a vdmassn"

types 'a vdmcontext = "('a vdmtuple) set"

consts vdm_proof :: "('a vdmcontext \<times> 'a vdmtuple) set"

syntax vdm_deriv :: "'a vdmcontext \<Rightarrow>  expr \<Rightarrow> 'a vdmassn \<Rightarrow> bool"
		  ("_ \<rhd>  _ : _ " [900,100,100] 50)

translations "G \<rhd> e : A" == "(G,e,A) \<in> vdm_proof"

syntax vdm_emptyctx :: " expr \<Rightarrow> 'a vdmassn \<Rightarrow> bool" ("\<rhd> _ : _ " 40)
translations "\<rhd> e : A " == "{} \<rhd> e : A"

text {*Dynamic class lookup for objects*}

constdefs classOf :: "env \<Rightarrow> heap \<Rightarrow> rname \<Rightarrow> cname \<Rightarrow> bool"
 "classOf E h x C == (\<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> h @@ a = Some C)"

text {*The derivation system.*}
inductive vdm_proof intros
vdm_null: "G \<rhd> NULL : (\<lambda>  P E h  hh  v  p . hh = h \<and> v = RVal Nullref \<and> p = (Null_effect P) (NULL, E, h))"

vdm_int: "G \<rhd> expr.Int i : (\<lambda>  P E h hh v p . hh = h \<and> v = IVal i \<and> p = (Int_effect P) (expr.Int i, E, h))"

vdm_ivar: "G \<rhd> IVar x : (\<lambda> P E h hh v p . hh = h \<and> v = IVal (E<x>) \<and> p =  (IVar_effect P) (IVar x, E, h))"

vdm_rvar: "G \<rhd> RVar x : (\<lambda> P E h hh v p . hh = h \<and> v = RVal (E\<lfloor>x\<rfloor>) \<and> p = (RVar_effect P) (RVar x, E, h))"

vdm_prim: "G \<rhd> Primop f x y : 
               (\<lambda> P E h hh v p  . hh = h \<and> v = IVal (f (E<x>) (E<y>)) \<and> p = (Primop_effect P) (Primop f x y, E, h))"

vdm_rprim: "G \<rhd> RPrimop f x y : 
                (\<lambda> P E h hh v p  . hh = h \<and> v = IVal (f (E\<lfloor>x\<rfloor>) (E\<lfloor>y\<rfloor>)) \<and> p = (RPrimop_effect P) (RPrimop f x y, E, h))"

vdm_getfi: "G \<rhd> GetFi x f : 
                (\<lambda> P E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> a:Dom h \<and> hh = h \<and>  
                                       v = IVal (h<a\<bullet>f>) \<and> p = (GetFi_effect P) (GetFi x f, E, h))"

vdm_getfr: "G \<rhd> GetFr x f :
                (\<lambda> P E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> a:Dom h \<and> hh = h \<and>
                                       v = RVal (h\<lfloor>a\<diamondsuit>f\<rfloor>) \<and> p =  (GetFr_effect P) (GetFr x f, E, h))"

vdm_putfi: "G \<rhd> PutFi x f y : 
                (\<lambda> P E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> a:Dom h \<and> hh = h<a\<bullet>f:=E<y>> \<and>
                                       v = arbitrary \<and>  p =  (PutFi_effect P) (PutFi x f y, E, h))"

vdm_putfr: "G \<rhd> PutFr x f y : 
                (\<lambda> P E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> a:Dom h \<and> hh = h\<lfloor>a\<diamondsuit>f:=E\<lfloor>y\<rfloor>\<rfloor> \<and>
                                       v = arbitrary \<and> p = (PutFr_effect P) (PutFr x f y, E, h))"

vdm_getstat: "G \<rhd> GetStat c f : (\<lambda> P E h hh v p . h = hh \<and> v = RVal (h\<lbrace>c\<struct>f\<rbrace>) \<and> p = (GetStat_effect P) (GetStat c f, E, h))"

vdm_putstat: "G \<rhd> PutStat c f y :
                  (\<lambda> P E h hh v p . hh = h\<lbrace>c\<struct>f:=E\<lfloor>y\<rfloor>\<rbrace> \<and> v=arbitrary \<and> p = (PutStat_effect P) (PutStat c f y, E, h))"

vdm_new: "G \<rhd> New c ifldvals rfldvals :
              (\<lambda> P E h hh v p  . \<exists> l . l = freshloc (fmap_dom (heap.oheap h)) \<and> 
                                    hh = newObj h l E c ifldvals rfldvals \<and>
                                    v = RVal (Ref l) \<and> p = (New_effect P) (New c ifldvals rfldvals, E, h))"

vdm_if: "\<lbrakk>G \<rhd> e1 : A1; G \<rhd> e2 : A2\<rbrakk> \<Longrightarrow> 
         G \<rhd> (IF x THEN e1 ELSE e2) :
          (\<lambda> P E h hh v p . \<exists> pp. p = (If_effect P) (IF x THEN e1 ELSE e2, E, h) pp \<and> 
                               (E<x> = grailbool True \<longrightarrow> (A1  P E h hh v pp  )) \<and> 
                               (E<x> = grailbool False \<longrightarrow> (A2  P E h hh v pp  )) \<and>
                               (E<x> = grailbool True \<or> E<x> = grailbool False))"

vdm_leti: "\<lbrakk>G \<rhd> e1 : A1; G \<rhd> e2 : A2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Leti x e1 e2) :
                (\<lambda> P E h hh v p  . \<exists> p1 p2 h1 i . (A1  P E h h1 (IVal i) p1) \<and>
                                                (A2 P (E<x:=i>) h1 hh v p2) \<and>
                                                 p =  (Leti_effect P) (Leti x e1 e2, E, h) p1 p2)"

vdm_letr: "\<lbrakk>G \<rhd> e1 : A1; G \<rhd> e2 : A2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Letr x e1 e2) :
                (\<lambda> P E h hh v p  . \<exists> p1 p2 h1 r . (A1 P E h h1 (RVal r) p1) \<and>
                                                (A2 P (E\<lfloor>x:=r\<rfloor>) h1 hh v p2) \<and>
                                                 p = (Letr_effect P) (Letr x e1 e2, E, h) p1 p2)"

vdm_letv: "\<lbrakk>G \<rhd> e1 : A1; G \<rhd> e2 : A2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Letv e1 e2) :
                (\<lambda> P E h hh v p  . \<exists> p1 p2 h1 w . (A1 P E h h1 w p1) \<and>
                                                (A2  P E h1 hh v p2) \<and>
                                                 p = (Letv_effect P) (Letv e1 e2, E, h) p1 p2)"

vdm_call: "\<lbrakk> ({(Call f, A)} \<union> G) \<rhd> snd(funtable f) : (\<lambda> P E h hh v p  . (A  P E h hh v ((Call_effect P) (Call f, E, h) p)))\<rbrakk>
          \<Longrightarrow>  G \<rhd> (Call f) : A"

vdm_invokestatic:
  "\<lbrakk>({(C\<bullet>mn(args),A)} \<union> G) \<rhd> (snd (methtable C mn)) :  
    (\<lambda> P E h hh v p  . \<forall> E'. E = newframe_env Nullref (fst (methtable C mn)) args E'  \<longrightarrow>
                           (A P E' h hh v ((InvS_effect P) (C\<bullet>mn(args), E', h) p)))\<rbrakk> \<Longrightarrow>
   G \<rhd> (C\<bullet>mn(args)) : A"

vdm_invoke:
  "\<lbrakk> \<forall> C .
     ({(x\<diamondsuit>mn(args),A)} \<union> G) \<rhd> (snd (methtable C mn)) :
     (\<lambda> P E h hh v p  . \<forall> E' . classOf E' h x C \<and> 
                              E = newframe_env (E'\<lfloor>x\<rfloor>) (fst (methtable C mn)) args E' \<longrightarrow> 
                             (A P E' h hh v ((InvV_effect P) (x\<diamondsuit>mn(args), E', h) p)))\<rbrakk> \<Longrightarrow>
   G \<rhd> (x\<diamondsuit>mn(args)) : A"


vdm_ax: "\<lbrakk> (e,A) : G \<rbrakk> \<Longrightarrow> G \<rhd> e : A"

vdm_conseq: "\<lbrakk>G \<rhd> e : A; (\<forall> P E h hh v p . (A  P E h hh v p ) \<longrightarrow> (Q  P E h hh v p ))\<rbrakk>
            \<Longrightarrow> G \<rhd> e : Q"

subsection {*Semantic validity*}
constdefs  vdm_validn :: "nat \<Rightarrow> expr \<Rightarrow> 'a vdmassn \<Rightarrow> bool"  ("\<Turnstile>\<^sub>_ _ : _" 50)
"\<Turnstile>\<^sub>n e : A \<equiv> (\<forall> m . m \<le> n \<longrightarrow> (\<forall> P E h hh v p . ((P|E \<turnstile> h,e \<Down>m (hh,v,p)) \<longrightarrow> A P E h hh v p)))"
(*
constdefs  vdm_validn :: "nat \<Rightarrow>  expr \<Rightarrow> vdmassn \<Rightarrow> bool"  ("\<Turnstile>\<^sub>_ _ : _" 50)
"\<Turnstile>\<^sub>n e : P \<equiv> (\<forall> E h hh v p . ((E \<turnstile> h,e \<Down> hh,v,p) \<and> (reccount p = n) \<longrightarrow> (E,h,hh,v,p) \<in> P))"
*)
constdefs  vdm_valid :: " expr \<Rightarrow> 'a vdmassn \<Rightarrow> bool"  ("\<Turnstile> _ : _" 50)
"\<Turnstile> e : A \<equiv> (\<forall> P E h hh v p . ((P|E \<turnstile> h,e \<Down> hh,v,p) \<longrightarrow> A P E h hh v p))"

constdefs vdm_context_validn::"nat \<Rightarrow> 'a vdmcontext \<Rightarrow> bool"  ("|\<Turnstile>\<^sub>_ _" 60)
"|\<Turnstile>\<^sub>n G \<equiv> (\<forall> (e,A) \<in> G . \<Turnstile>\<^sub>n e : A)"

constdefs vdm_context_valid::"'a vdmcontext \<Rightarrow> bool"  ("|\<Turnstile> _" 60)
"|\<Turnstile> G \<equiv> (\<forall> (e,A) \<in> G . \<Turnstile> e : A)"

lemma valid_validn: "\<Turnstile> e : A \<Longrightarrow>  \<Turnstile>\<^sub>n e : A"
(*<*)by (simp add: vdm_valid_def vdm_validn_def sem_def, fastsimp)(*>*)

lemma validn_valid: "(\<forall> n . \<Turnstile>\<^sub>n e : A) \<Longrightarrow> \<Turnstile> e : A"
(*<*)by (simp add: vdm_valid_def vdm_validn_def sem_def, fastsimp)(*>*)

lemma ctxt_valid_validn: "( |\<Turnstile> G) \<Longrightarrow> (\<forall> n.( |\<Turnstile>\<^sub>n G))"
(*<*)
apply (simp add: vdm_context_validn_def vdm_context_valid_def)
apply clarsimp
apply (auto elim: valid_validn)
done
(*>*)

lemma emptyctxn [simp]: "|\<Turnstile>\<^sub>n {}"
(*<*)by (simp add: vdm_context_validn_def)(*>*)

lemma ctx_projn[rule_format]: "(e,A) \<in> G \<and> |\<Turnstile>\<^sub>n G \<Longrightarrow> (\<Turnstile>\<^sub>n e : A)"
(*<*)by (simp add: vdm_context_validn_def, fastsimp)(*>*)

lemma ctxt_drop: "( |\<Turnstile> {(e,A)} \<union> G) \<Longrightarrow> |\<Turnstile> G"
(*<*)by (simp add: vdm_context_valid_def)(*>*)

lemma ctxt_ext[simp]: "( |\<Turnstile> {(e,A)} \<union> G) = ((\<Turnstile> e : A ) \<and> ( |\<Turnstile> G))"
(*<*)by (simp add: vdm_context_valid_def)(*>*)

lemma emptyctx [simp]: "|\<Turnstile> {}"
(*<*)by (simp add: vdm_context_valid_def)(*>*)

lemma ctx_subn[rule_format]:  "H \<subseteq> G \<and> |\<Turnstile>\<^sub>n G \<Longrightarrow> |\<Turnstile>\<^sub>n H"
(*<*)by (simp add: vdm_context_validn_def vdm_validn_def, fast)(*>*)

lemma ctxt_cons: "\<lbrakk> |\<Turnstile> G; \<Turnstile> e : A\<rbrakk> \<Longrightarrow> |\<Turnstile> G \<union> {(e,A)}"
(*<*)by (simp add: vdm_context_valid_def)(*>*)

lemma contxt_validn_valid[rule_format]: "(\<forall> n. |\<Turnstile>\<^sub>n G) \<Longrightarrow> |\<Turnstile> G"
(*<*)by (simp add: vdm_context_validn_def vdm_context_valid_def 
              vdm_valid_def vdm_validn_def sem_def,
    fastsimp)(*>*)

lemma contxt_valid_validn: "|\<Turnstile> G \<Longrightarrow> (\<forall> n. |\<Turnstile>\<^sub>n G)"
(*<*)by (simp add: vdm_context_validn_def vdm_context_valid_def 
              vdm_valid_def vdm_validn_def sem_def,
    fastsimp)(*>*)

lemma lowerm: "\<lbrakk>  m < n; \<Turnstile>\<^sub>n e:A \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>m e : A"
(*<*)
apply (simp add: vdm_validn_def)
apply clarsimp
apply (subgoal_tac "ma < n")
prefer 2 apply simp
apply (erule_tac thin_rl)
apply (erule_tac x="ma" in allE)
apply simp
done
(*>*)
 
lemma lowerm_suc: "\<lbrakk>  \<Turnstile>\<^sub>(Suc n) e:A \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>n e : A"
(*<*)
apply (simp add: vdm_validn_def)
apply clarsimp
apply (erule_tac x="m" in allE)
apply simp
done
(*>*)

lemma ctxt_lower: "\<lbrakk> |\<Turnstile>\<^sub>n G; m<n \<rbrakk> \<Longrightarrow> |\<Turnstile>\<^sub>m G"
(*<*)
apply (simp add: vdm_context_validn_def)
apply clarsimp
apply (rule lowerm)
apply fastsimp+
done
(*>*)

(* lemmas ctxt_lower_suc = ctxt_lower [of "Suc n" G n]; *)

lemma ctxt_lower_suc: "\<lbrakk> |\<Turnstile>\<^sub>(Suc n) G \<rbrakk> \<Longrightarrow> |\<Turnstile>\<^sub>n G"
(*<*)
apply (simp add: vdm_context_validn_def)
apply clarsimp
apply (rule lowerm)
apply fastsimp+
done
(*>*)

lemma ctxt_consn: "\<lbrakk> |\<Turnstile>\<^sub>n G; \<Turnstile>\<^sub>n e:A \<rbrakk> \<Longrightarrow> ( |\<Turnstile>\<^sub>n {(e,A)} \<union> G)"
(*<*)by (simp add: vdm_context_validn_def)(*>*)

lemma ctxt_insertn: "\<lbrakk> |\<Turnstile>\<^sub>n G; \<Turnstile>\<^sub>n e:A \<rbrakk> \<Longrightarrow> ( |\<Turnstile>\<^sub>n (insert (e,A) G))"
(*<*)by (simp add: vdm_context_validn_def)(*>*)


constdefs 
vdm_valid_in_ctxt :: "('a vdmtuple) set \<Rightarrow>  expr \<Rightarrow> 'a vdmassn \<Rightarrow> bool" ("_ \<Turnstile> _ : _" 75)
  "G \<Turnstile> e : A \<equiv>  ( |\<Turnstile> G ) \<longrightarrow> (\<Turnstile> e:A)"

vdm_valid_in_ctxt_n :: "('a vdmtuple) set \<Rightarrow> nat \<Rightarrow>  expr \<Rightarrow>  'a vdmassn \<Rightarrow> bool" ("_ \<Turnstile>\<^sub> _ _ : _" 75)
  "G \<Turnstile>\<^sub>n e : A \<equiv>  ( |\<Turnstile>\<^sub>n G ) \<longrightarrow> ( \<Turnstile>\<^sub>n e:A)"
(*  "G \<Turnstile>\<^sub>n e : A \<equiv>  \<forall> m . m \<le> n \<longrightarrow> ( |\<Turnstile>\<^sub>m G ) \<longrightarrow> ( \<Turnstile>\<^sub>m e:A)"*)

(*<*)
lemmas vdm_basics = vdm_null vdm_int vdm_ivar vdm_rvar vdm_prim vdm_rprim 
                    vdm_getfi vdm_getfr vdm_putfi vdm_putfr vdm_getstat vdm_putstat
                    vdm_new vdm_if vdm_leti vdm_letr vdm_letv 

lemmas vdm_calls = vdm_call vdm_invokestatic vdm_invoke 

lemmas vdm_pathetic = vdm_null vdm_int vdm_ivar vdm_rvar vdm_prim vdm_rprim
                      vdm_getfi vdm_getfr vdm_putfi vdm_putfr vdm_getstat vdm_putstat
                      vdm_new 
(*>*)
(*<*)
end
(*>*)
