header {*Soundness of axiomatic semantics*}
(*<*)
theory VDMSoundRecPC = VDMpc :
(*>*)
text {* First an auxiliary lemma about function calls. *}

lemma calllemma00: 
 "\<forall> e A G. 
    ((e, A) \<in> G \<longrightarrow>
      ( \<forall>n. ( ( |\<Turnstile>\<^sub>n G) \<longrightarrow>
            (\<forall>m. (m \<le> n \<longrightarrow>
                  (\<forall> P E h hh v p. (P|E \<turnstile> h , e \<Down>m (hh , v , p) \<longrightarrow> A P E h hh v p)))))))"
(*<*)
apply (rule allI)+
apply (rule impI)
apply (rule allI)
apply (rule impI)
apply (subgoal_tac "\<Turnstile>\<^sub>n e : A")
apply (simp add: vdm_context_validn_def vdm_validn_def) 
apply (simp add: vdm_context_validn_def, fastsimp)
done
(*>*)
(*
lemma calllemma0: 
"\<And> e A G. 
   ((e, A) \<in> G \<Longrightarrow>
       ( \<forall>n. ( ( |\<Turnstile>\<^sub>n G) \<longrightarrow>
               (\<forall>m. ( m \<le> n \<longrightarrow>
                     ( \<forall> E h hh v p. (E \<turnstile> h , e \<Down>m (hh , v , p) \<longrightarrow> A E h hh v p)))))))"
apply (rule allI)
apply (rule impI)
apply (subgoal_tac "\<Turnstile>\<^sub>n e : A")
 apply (simp add: vdm_context_validn_def vdm_validn_def) 
 apply (simp add: vdm_context_validn_def, fastsimp)
done
*)

text {*The ''Spec lemma''.*}

lemma vdmspec_lemma:
"\<lbrakk> G \<rhd> e : A ; 
  (\<forall>n. (( |\<Turnstile>\<^sub>n G) \<longrightarrow> (\<forall>m. (m \<le> n \<longrightarrow> (\<forall> P E h hh v p. (P|E \<turnstile> h , e \<Down>m (hh , v , p) \<longrightarrow> A P E h hh v p))))));
  |\<Turnstile>\<^sub>n G; m \<le> n;
  P|E \<turnstile> h , e \<Down>m (hh , v , p)\<rbrakk> \<Longrightarrow> A P E h hh v p"
(*<*)by simp(*>*)

(*<*)
lemma SucMaxLemma1: "Suc (max na ma) \<le> n \<Longrightarrow> na \<le> n"
by(subgoal_tac "na < Suc (max na ma)", (simp add: max_def)+)

lemma SucMaxLemma2: "Suc (max na ma) \<le> n \<Longrightarrow> ma \<le> n"
by(subgoal_tac "ma < Suc (max na ma)", (simp add: max_def)+)
(*>*)

text {*The essence of the soundness proof is the following lemma.*}
lemma vdm_soundAux: "(G \<rhd> e:A) \<Longrightarrow> (\<forall> n . (G \<Turnstile>\<^sub>n e:A))"
(*<*)
apply (erule vdm_proof.induct)
apply (simp_all add: vdm_valid_in_ctxt_n_def vdm_validn_def)
(*prefer 22 apply fastsimp*)
apply (clarsimp, erule eval_cases, simp)
apply (clarsimp, erule eval_cases, simp)
apply (clarsimp, erule eval_cases, simp)
apply (clarsimp, erule eval_cases, simp)
apply (clarsimp, erule eval_cases, simp)
apply (clarsimp, erule eval_cases, simp)
apply (clarsimp, erule eval_cases, simp)
apply (clarsimp, erule eval_cases, simp)
apply (clarsimp, erule eval_cases, simp)
apply (clarsimp, erule eval_cases, simp)
apply (clarsimp, erule eval_cases, simp)
apply (clarsimp, erule eval_cases, simp)
apply (clarsimp, erule eval_cases, simp)
(*If*)
apply (clarsimp, erule eval_cases, simp)
(*True*)
apply (clarsimp, rule_tac x=pa in exI, simp)
apply (subgoal_tac "ma \<le> n")
apply (rotate_tac 5, erule thin_rl)
apply (erule vdmspec_lemma, simp+)
(*False*)
apply (clarsimp, rule_tac x=pa in exI, simp)
apply (subgoal_tac "ma \<le> n")
apply (rotate_tac 5, erule thin_rl)
apply (erule vdmspec_lemma, simp+)
(*Leti*)
apply (clarsimp, erule eval_cases, simp)
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, rule_tac x=i in exI, simp, rule)
apply (subgoal_tac "na \<le> n")
apply(rotate_tac 5, erule thin_rl)
apply (erule vdmspec_lemma, simp+, erule SucMaxLemma1)
apply (subgoal_tac "ma \<le> n")
apply(rotate_tac 5, erule thin_rl)
apply (erule vdmspec_lemma, simp+, erule SucMaxLemma2)
(*Letr*)
apply (clarsimp, erule eval_cases, simp)
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, rule_tac x=r in exI, simp, rule)
apply (subgoal_tac "na \<le> n")
apply(rotate_tac 5, erule thin_rl)
apply (erule vdmspec_lemma, simp+, erule SucMaxLemma1)
apply (subgoal_tac "ma \<le> n")
apply(rotate_tac 5, erule thin_rl)
apply (erule vdmspec_lemma, simp+, erule SucMaxLemma2)
(*Letv*)
apply (clarsimp, erule eval_cases, clarsimp)
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, simp)
apply (rule_tac x=w in exI)
apply (erule_tac x="n" in allE)
apply(erule thin_rl, erule thin_rl, erule thin_rl, fastsimp)
(*Call*)
apply (rule allI)
apply (induct_tac n)
 defer 1 (* should follow directly from the set of 0-step evaluations (semn) being empty *)
 (* -- *)
 apply (erule thin_rl)
 apply (tactic {* rename_tac "k" 1 *})
 apply (rule impI)
 apply (rule allI)
 apply (case_tac "m=Suc k")
  (* interesting case *)
  apply (erule_tac x="k" in allE, rotate_tac -1)
  apply (frule mp) apply (rule ctxt_insertn) apply (rule ctxt_lower_suc) apply (assumption) 
    apply (rotate_tac -3)
    apply (frule mp) apply (rule ctxt_lower_suc) apply (assumption) apply (erule thin_rl)
    apply (rotate_tac -1)
    apply (simp add: vdm_validn_def)
    apply (erule thin_rl)
  apply (rotate_tac -1)
  apply (erule_tac x="k" in allE)
  apply (erule thin_rl)
  apply clarsimp
  apply (erule eval_cases)
  apply clarsimp
  apply (tactic {* all_tac *})
  (* boring case *)
  apply (rotate_tac -3)
  apply (frule mp) apply (rule ctxt_lower_suc) apply (assumption) apply (erule thin_rl)
  apply (rotate_tac -1)
  apply (erule_tac x="m" in allE)
  apply (case_tac "m=Suc k")
   apply (rule impI)
   apply simp
   (* -- *)
   apply (rule impI)
   apply clarsimp
  defer 1 (* get invoke lemma out of the way; not finished with call yet *)
  defer 1 (* get invoke lemma out of the way; not finished with call yet *)
(*  defer 1  get invoke lemma out of the way; not finished with call yet *)
(*  defer 1  get invoke lemma out of the way; not finished with call yet *)
  (* 2 CALL subgoals that remain *)
  (* 1. calllemma could be used here; for now the proof is inlined  *)
  apply (insert calllemma00)
  apply (erule_tac x="e" in allE)
  apply (erule_tac x="A" in allE)
  apply (erule_tac x="G" in allE)
  apply (frule mp) apply (assumption) 
  apply (assumption) 
  (* 2. base case of induction; should be trivial *)
  apply (erule thin_rl)
  apply (rule impI)
  apply (rule allI)
  apply (rule impI)
  apply (rule allI)+
  apply (rule impI)
  apply (simp add: vdm_validn_def vdm_context_validn_def)
  apply clarsimp
  apply (insert no_zero_height_derivs)
  apply fastsimp
(* InvokeStatic *)
(* clean-up *)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule allI)
apply (induct_tac n)
 (* base case *)
  apply clarify
  apply (simp add: vdm_validn_def vdm_context_validn_def)
  apply clarsimp
  apply (insert no_zero_height_derivs)
  apply fastsimp
 (* -- *)
 apply (rotate_tac -1)
 apply (erule thin_rl)
 apply (tactic {* rename_tac "k" 1 *})
 apply (rule impI)
 apply (rule allI)
 apply (case_tac "m=Suc k")
  (* interesting case *)
  apply clarsimp
  apply (rotate_tac 1)
  apply (erule_tac x="k" in allE, rotate_tac -1)
  apply (frule mp) apply (rule ctxt_insertn) apply (rule ctxt_lower_suc) apply (assumption) 
    apply (rotate_tac -4)
    apply (frule mp) apply (rule ctxt_lower_suc) apply (assumption) apply (erule thin_rl)
    apply (rotate_tac -1)
    apply (simp add: vdm_validn_def)
    apply (erule thin_rl)
  apply (rotate_tac -1)
  apply (erule_tac x="k" in allE)
  apply (erule thin_rl)
  apply clarsimp
  apply (erule eval_cases)
  apply clarsimp  
  apply (tactic {* all_tac *})
  (* Doch Dal (boring case)  *)
  apply (rotate_tac -3)
  apply (frule mp) apply (rule ctxt_lower_suc) apply (assumption) apply (erule thin_rl)
  apply (rotate_tac -1)
  apply (erule_tac x="m" in allE)
  apply (case_tac "m=Suc k")
   apply (rule impI)
   apply simp
   (* -- *)
   apply (rotate_tac -2)
   apply (rule impI)
   apply clarsimp
apply (tactic {* all_tac *}) (* Doch rIn *)
(* Invoke *)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule allI)
apply (induct_tac n)
 (* base case *)
  apply clarify
  apply (simp add: vdm_validn_def vdm_context_validn_def)
  apply clarsimp
  apply (insert no_zero_height_derivs)
  apply fastsimp
 (* -- *)
 apply (rotate_tac -1)
 apply (erule thin_rl)
 apply (rotate_tac -2)
 apply (erule thin_rl)
 apply (tactic {* rename_tac "k" 1 *})
 apply (rule impI)
 apply (rule allI)
 apply (case_tac "m=Suc k")
  (* interesting case *)
  apply clarsimp
  apply (erule eval_cases)
  apply (rotate_tac 1)
  apply (erule_tac x="C" in allE, rotate_tac -1)
  apply (tactic {* all_tac *})
  apply (erule conjE) apply (rotate_tac -1)
  apply (erule_tac x="k" in allE, rotate_tac -1)
  apply (frule mp) apply (rule ctxt_insertn) apply (rule ctxt_lower_suc) apply (assumption) 
    apply (rotate_tac -2)
    apply (frule mp) apply (rule ctxt_lower_suc) apply (assumption) apply (erule thin_rl) apply (rotate_tac -1)
    apply (simp add: vdm_validn_def)
    apply (erule thin_rl)
   apply (rotate_tac -1)
   apply (erule_tac x="k" in allE)
   apply clarsimp
   apply (tactic {* all_tac *})
   apply (erule_tac x=P in allE)
   apply (erule_tac x="newframe_env (Ref a) (fst (methtable C mn)) args E" in allE, rotate_tac -1)
   apply (erule_tac x="h" in allE, rotate_tac -1)
   apply (erule_tac x="hh" in allE, rotate_tac -1)
   apply (erule_tac x="v" in allE, rotate_tac -1)
   apply (erule_tac x="pa" in allE, rotate_tac -1)
   apply (frule mp) apply assumption
  apply (tactic {* all_tac *})
   (* case m != Suc k *)
  apply (erule_tac x=E in allE)
(*  apply (tactic {* all_tac *})*) 
  apply clarsimp 
  apply (erule_tac x=E in allE)
  apply (drule mp) apply (rule ctxt_lower_suc) apply assumption 
  apply (frule mp) apply (simp add: classOf_def) 
   apply clarsimp
   apply (frule mp) apply (rule ctxt_lower_suc)  apply assumption apply (erule thin_rl) apply (rotate_tac -1)
   apply clarsimp
   apply (erule_tac x="m" in allE, rotate_tac -1)
   apply (frule mp) apply clarsimp  apply (erule thin_rl) apply (rotate_tac -1)
   apply (erule_tac x=P in allE, rotate_tac -1)
   apply (erule_tac x="E" in allE, rotate_tac -1)
   apply (erule_tac x="h" in allE, rotate_tac -1)
   apply (erule_tac x="hh" in allE, rotate_tac -1)
   apply (erule_tac x="v" in allE, rotate_tac -1)
   apply (erule_tac x="p" in allE, rotate_tac -1)
   apply (frule mp) apply (assumption)  
 apply assumption
done
(*>*)

text {*Soundness in arbitrary contexts.*}
theorem vdm_sound_ctxt: "(G \<rhd> e:A) \<Longrightarrow> (G \<Turnstile> e:A)"
(*<*)
apply (subgoal_tac "\<forall> n . (G \<Turnstile>\<^sub>n e:A)")
prefer 2 apply (rule vdm_soundAux, simp)
apply (erule thin_rl)
apply (simp add: vdm_valid_in_ctxt_n_def vdm_valid_in_ctxt_def)
apply clarsimp
apply (subgoal_tac "\<forall>n. ( |\<Turnstile>\<^sub>n G) ")
apply (simp add: validn_valid)
apply (rule contxt_valid_validn, simp)
done
(*>*)

text {*Finally, soundness in empty contexts.*}
theorem vdm_sound: "\<rhd> e : A  \<Longrightarrow> \<Turnstile> e : A"
(*<*)
apply (insert vdm_sound_ctxt [of "{}"])
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def vdm_valid_def sem_def)
apply fast
done
(*>*)
(*<*)
end
(*>*)
